"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-components"],{

/***/ "./js/components/Spinner.js":
/*!**********************************!*\
  !*** ./js/components/Spinner.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Spinner component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * A single module. Keeps track of its own active state and settings.
 */

function Spinner({
  isSaving,
  style = {}
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "spinner",
    style: {
      display: isSaving ? 'inline-block' : 'none',
      float: 'none',
      marginTop: '0',
      visibility: 'visible',
      ...style
    }
  });
}
Spinner.propTypes = {
  isSaving: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Spinner);

/***/ }),

/***/ "./js/googlesitekit-components.js":
/*!****************************************!*\
  !*** ./js/googlesitekit-components.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: () => (/* binding */ Button),
/* harmony export */   Checkbox: () => (/* binding */ Checkbox),
/* harmony export */   Chip: () => (/* binding */ Chip),
/* harmony export */   CircularProgress: () => (/* binding */ CircularProgress),
/* harmony export */   Dialog: () => (/* binding */ Dialog),
/* harmony export */   DialogContent: () => (/* binding */ DialogContent),
/* harmony export */   DialogFooter: () => (/* binding */ DialogFooter),
/* harmony export */   DialogTitle: () => (/* binding */ DialogTitle),
/* harmony export */   HelperText: () => (/* binding */ HelperText),
/* harmony export */   Menu: () => (/* binding */ Menu),
/* harmony export */   Option: () => (/* binding */ Option),
/* harmony export */   ProgressBar: () => (/* binding */ ProgressBar),
/* harmony export */   Radio: () => (/* binding */ Radio),
/* harmony export */   Select: () => (/* binding */ Select),
/* harmony export */   SpinnerButton: () => (/* binding */ SpinnerButton),
/* harmony export */   Switch: () => (/* binding */ Switch),
/* harmony export */   Tab: () => (/* binding */ Tab),
/* harmony export */   TabBar: () => (/* binding */ TabBar),
/* harmony export */   TextField: () => (/* binding */ TextField),
/* harmony export */   Tooltip: () => (/* binding */ Tooltip)
/* harmony export */ });
/* harmony import */ var _googlesitekit_components_gm2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./googlesitekit/components-gm2 */ "./js/googlesitekit/components-gm2/index.js");
/**
 * Public components entrypoint.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

if (typeof __webpack_require__.g.googlesitekit === 'undefined') {
  __webpack_require__.g.googlesitekit = {};
}
__webpack_require__.g.googlesitekit.components = _googlesitekit_components_gm2__WEBPACK_IMPORTED_MODULE_0__["default"];
const {
  Button,
  Checkbox,
  Chip,
  CircularProgress,
  Dialog,
  DialogTitle,
  DialogContent,
  DialogFooter,
  Menu,
  Option,
  ProgressBar,
  Radio,
  Select,
  SpinnerButton,
  Switch,
  Tab,
  TabBar,
  TextField,
  HelperText,
  Tooltip
} = _googlesitekit_components_gm2__WEBPACK_IMPORTED_MODULE_0__["default"];

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/MaybeTooltip.js":
/*!****************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/MaybeTooltip.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MaybeTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_components_gm2_Tooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/components-gm2/Tooltip */ "./js/googlesitekit/components-gm2/Tooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * MaybeTooltip component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function MaybeTooltip({
  children,
  disabled = false,
  tooltip = false,
  tooltipTitle = null,
  hasIconOnly = false,
  tooltipEnterDelayInMS = 100
}) {
  if (!disabled && (tooltip && tooltipTitle || hasIconOnly && tooltipTitle)) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_googlesitekit_components_gm2_Tooltip__WEBPACK_IMPORTED_MODULE_0__["default"], {
      title: tooltipTitle,
      enterDelay: tooltipEnterDelayInMS,
      children: children
    });
  }
  return children;
}
MaybeTooltip.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltipTitle: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_2___default().element)]),
  hasIconOnly: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  tooltipEnterDelayInMS: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/SemanticButton.js":
/*!******************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/SemanticButton.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SemanticButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const SemanticButton = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  children,
  href,
  text,
  className,
  danger,
  disabled,
  target,
  'aria-label': ariaLabel,
  inverse,
  tertiary,
  callout,
  calloutStyle,
  ...extraProps
}, ref) => {
  // Use a button if disabled, even if a href is provided to ensure expected behavior.
  const ButtonTag = href && !disabled ? 'a' : 'button';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ButtonTag, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-button', className, {
      'mdc-button--raised': !text && !tertiary && !callout,
      'mdc-button--danger': danger,
      'mdc-button--inverse': inverse,
      'mdc-button--tertiary': tertiary,
      'mdc-button--callout': callout,
      'mdc-button--callout-primary': callout || calloutStyle === 'primary',
      'mdc-button--callout-warning': calloutStyle === 'warning',
      'mdc-button--callout-error': calloutStyle === 'error'
    }),
    href: disabled ? undefined : href,
    ref: ref,
    disabled: !!disabled,
    "aria-label": ariaLabel,
    target: target || '_self',
    role: 'a' === ButtonTag ? 'button' : undefined,
    ...extraProps,
    children: children
  });
});
SemanticButton.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  text: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  target: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  callout: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  calloutStyle: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(['primary', 'warning', 'error'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SemanticButton);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Button/index.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Button/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @react-hook/merged-ref */ "../node_modules/@react-hook/merged-ref/dist/module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _SemanticButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SemanticButton */ "./js/googlesitekit/components-gm2/Button/SemanticButton.js");
/* harmony import */ var _MaybeTooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MaybeTooltip */ "./js/googlesitekit/components-gm2/Button/MaybeTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Button component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const Button = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(({
  children,
  href = null,
  text = false,
  className = '',
  danger = false,
  disabled = false,
  target,
  icon = null,
  trailingIcon = null,
  'aria-label': ariaLabel,
  title = null,
  customizedTooltip = null,
  tooltip = false,
  inverse = false,
  hideTooltipTitle = false,
  tooltipEnterDelayInMS = 100,
  tertiary = false,
  callout = false,
  calloutStyle = null,
  ...extraProps
}, ref) => {
  const buttonRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(el => {
    if (el !== null) {
      _js_material_components__WEBPACK_IMPORTED_MODULE_1__.MDCRipple.attachTo(el);
    }
  }, []);
  const mergedRefs = (0,_react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_6__["default"])(ref, buttonRef);
  function getAriaLabel() {
    let label = ariaLabel;
    if (target !== '_blank') {
      return label;
    }
    const newTabText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    if (typeof children === 'string') {
      label = label || children;
    }
    if (label) {
      return `${label} ${newTabText}`;
    }
    return newTabText;
  }
  const tooltipTitle = !hideTooltipTitle ? title || customizedTooltip || ariaLabel : null;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_MaybeTooltip__WEBPACK_IMPORTED_MODULE_3__["default"], {
    disabled: disabled,
    tooltip: tooltip,
    tooltipTitle: tooltipTitle,
    hasIconOnly: !!icon && children === undefined,
    tooltipEnterDelayInMS: tooltipEnterDelayInMS,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_SemanticButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
      href: href,
      disabled: disabled,
      className: className,
      danger: danger,
      text: text,
      tertiary: tertiary,
      inverse: inverse,
      callout: callout,
      calloutStyle: calloutStyle,
      ref: mergedRefs,
      "aria-label": getAriaLabel(),
      target: target || '_self',
      ...extraProps,
      children: [icon, children && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
        className: "mdc-button__label",
        children: children
      }), trailingIcon]
    })
  });
});
Button.propTypes = {
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  text: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  icon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  customizedTooltip: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().element),
  tooltip: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hideTooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  callout: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  calloutStyle: prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOf(['primary', 'warning', 'error'])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Button);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Checkbox.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Checkbox.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Checkbox)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Spinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Spinner */ "./js/components/Spinner.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Checkbox component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function Checkbox(props) {
  const {
    onChange,
    id,
    name,
    value,
    checked,
    disabled,
    children,
    tabIndex,
    onKeyDown,
    loading,
    alignLeft,
    description,
    badge
  } = props;
  const label = !!badge ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "mdc-checkbox__label-wrapper",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("label", {
      htmlFor: id,
      children: children
    }), badge]
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("label", {
    htmlFor: id,
    children: children
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "mdc-form-field",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-checkbox', {
        'mdc-checkbox--disabled': disabled,
        'mdc-checkbox--align-left': alignLeft
      }),
      children: loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Spinner__WEBPACK_IMPORTED_MODULE_1__["default"], {
        style: {
          margin: '0'
        },
        isSaving: true
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("input", {
          className: "mdc-checkbox__native-control",
          type: "checkbox",
          id: id,
          name: name,
          value: value,
          checked: checked,
          disabled: disabled,
          onChange: onChange,
          tabIndex: tabIndex,
          onKeyDown: onKeyDown
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: "mdc-checkbox__background",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("svg", {
            className: "mdc-checkbox__checkmark",
            viewBox: "0 0 12 9",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("path", {
              className: "mdc-checkbox__checkmark-path",
              d: "M2.08301 5.28834L3.55703 7.29507C4.24647 8.23368 5.5034 8.23368 6.19285 7.29507L10.083 1.99902",
              fill: "none",
              stroke: "none"
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            className: "mdc-checkbox__mixedmark"
          })]
        })]
      })
    }), !description && label, description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "mdc-checkbox__content",
      children: [label, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "mdc-checkbox__description",
        children: description
      })]
    })]
  });
}
Checkbox.propTypes = {
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func).isRequired,
  onKeyDown: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  name: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  value: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node).isRequired,
  tabIndex: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)]),
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  badge: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node)
};
Checkbox.defaultProps = {
  checked: false,
  disabled: false,
  tabIndex: undefined,
  onKeyDown: null,
  loading: false,
  alignLeft: false,
  description: ''
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Chip.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Chip.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Chip)
/* harmony export */ });
/* harmony import */ var _material_react_chips__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-chips */ "../node_modules/@material/react-chips/dist/index.js");
/* harmony import */ var _material_react_chips__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_chips__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Chip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




function Chip({
  id,
  label,
  onClick,
  selected,
  className,
  CheckMark = _material_react_chips__WEBPACK_IMPORTED_MODULE_0__.ChipCheckmark,
  disabled,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_material_react_chips__WEBPACK_IMPORTED_MODULE_0__.Chip, {
    chipCheckmark: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(CheckMark, {}),
    "data-chip-id": id,
    id: id,
    label: label,
    onClick: event => {
      if (disabled) {
        return;
      }
      onClick?.(event);
    },
    selected: selected,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-chip', className, {
      'googlesitekit-chip--disabled': disabled
    }),
    ...props
  });
}
Chip.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  selected: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  CheckMark: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/CircularProgress.js":
/*!*************************************************************!*\
  !*** ./js/googlesitekit/components-gm2/CircularProgress.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CircularProgress)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/CircularProgress/CircularProgress.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CircularProgress component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function CircularProgress(props) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_1__["default"], {
    ...props
  });
}

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Menu.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Menu.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @react-hook/merged-ref */ "../node_modules/@react-hook/merged-ref/dist/module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Menu component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const Menu = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.forwardRef)(({
  children,
  className,
  menuOpen,
  menuItems,
  onSelected,
  nonInteractive,
  id
}, ref) => {
  const [menu, setMenu] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(null);
  const menuRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)(null);
  const mergedRefs = (0,_react_hook_merged_ref__WEBPACK_IMPORTED_MODULE_4__["default"])(ref, menuRef);
  const handleMenuSelected = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(event => {
    const {
      detail: {
        index
      }
    } = event;
    onSelected(index, event);
  }, [onSelected]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (!menuRef?.current) {
      // Return noop cleanup function to satisfy consistent-return rule.
      return () => {};
    }
    const menuComponent = new _js_material_components__WEBPACK_IMPORTED_MODULE_1__.MDCMenu(menuRef.current);
    menuComponent.listen('MDCMenu:selected', handleMenuSelected);
    menuComponent.quickOpen = true;
    setMenu(menuComponent);
    return () => {
      menuComponent.unlisten('MDCMenu:selected', handleMenuSelected);
      menuComponent.destroy();
    };
  }, [menuRef, handleMenuSelected, nonInteractive]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (menu) {
      menu.open = menuOpen;
      menu.setDefaultFocusState(1);
    }
  }, [menu, menuOpen]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-menu', 'mdc-menu-surface', className),
    ref: mergedRefs,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("ul", {
      "aria-hidden": !menuOpen,
      "aria-orientation": "vertical",
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-list', {
        'mdc-list--non-interactive': nonInteractive
      }),
      id: id,
      role: "menu",
      tabIndex: "-1",
      children: [!children && menuItems.map((item, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
        className: "mdc-list-item",
        role: "menuitem",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
          className: "mdc-list-item__text",
          children: item
        })
      }, index)), children]
    })
  });
});
Menu.displayName = 'Menu';
Menu.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  menuOpen: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool).isRequired,
  menuItems: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().array),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  onSelected: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  nonInteractive: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)
};
Menu.defaultProps = {
  onSelected: () => {},
  nonInteractive: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Menu);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/ProgressBar.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/ProgressBar.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ProgressBar)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ProgressBar component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




function ProgressBar({
  className,
  small,
  compress,
  indeterminate,
  height,
  verticalSpacing,
  mobileVerticalSpacing,
  tabletVerticalSpacing,
  desktopVerticalSpacing,
  progress
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  let progressBarVerticalSpacing = verticalSpacing;
  if (_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL === breakpoint && mobileVerticalSpacing !== undefined) {
    progressBarVerticalSpacing = mobileVerticalSpacing;
  } else if (_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET === breakpoint && tabletVerticalSpacing !== undefined) {
    progressBarVerticalSpacing = tabletVerticalSpacing;
  } else if ((_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE === breakpoint || _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP === breakpoint) && desktopVerticalSpacing !== undefined) {
    progressBarVerticalSpacing = desktopVerticalSpacing;
  }
  let margin;
  if (progressBarVerticalSpacing !== undefined) {
    margin = progressBarVerticalSpacing === 0 ? 0 : Math.round(progressBarVerticalSpacing / 2);
  }
  const transform = progress ? `scaleX(${progress})` : undefined;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    role: "progressbar",
    style: {
      marginTop: margin,
      marginBottom: margin,
      ...(height && {
        height: `${height}px`
      })
    },
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-linear-progress', className, {
      'mdc-linear-progress--indeterminate': indeterminate,
      'mdc-linear-progress--small': small,
      'mdc-linear-progress--compress': compress
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "mdc-linear-progress__buffering-dots"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "mdc-linear-progress__buffer"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "mdc-linear-progress__bar mdc-linear-progress__primary-bar",
      style: {
        transform
      },
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        className: "mdc-linear-progress__bar-inner"
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "mdc-linear-progress__bar mdc-linear-progress__secondary-bar",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        className: "mdc-linear-progress__bar-inner"
      })
    })]
  });
}
ProgressBar.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  compress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  indeterminate: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  progress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  verticalSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  mobileVerticalSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  tabletVerticalSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  desktopVerticalSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)
};
ProgressBar.defaultProps = {
  className: '',
  small: false,
  compress: false,
  indeterminate: true,
  progress: 0,
  height: 4
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Radio.js":
/*!**************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Radio.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Radio)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Radio component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function Radio(props) {
  const {
    id,
    name,
    value,
    checked = false,
    disabled = false,
    children,
    tabIndex,
    onKeyDown = null,
    onClick = null,
    onChange = null,
    alignLeft = false,
    description
  } = props;
  const formFieldRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(el => {
    if (el !== null) {
      const formField = new _js_material_components__WEBPACK_IMPORTED_MODULE_1__.MDCFormField(el);
      const radioEl = el.querySelector('.mdc-radio');
      if (radioEl) {
        formField.input = new _js_material_components__WEBPACK_IMPORTED_MODULE_1__.MDCRadio(radioEl);
      }
    }
  }, []);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "mdc-form-field",
    ref: formFieldRef,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-radio', {
        'mdc-radio--disabled': disabled,
        'mdc-radio--align-left': alignLeft
      }),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("input", {
        className: "mdc-radio__native-control",
        onClick: onClick,
        onKeyDown: onKeyDown,
        type: "radio",
        id: id,
        name: name,
        value: value,
        checked: checked,
        disabled: disabled,
        tabIndex: tabIndex,
        onChange: onChange,
        readOnly: true
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "mdc-radio__background",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "mdc-radio__outer-circle"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "mdc-radio__inner-circle"
        })]
      })]
    }), !description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("label", {
      htmlFor: id,
      children: children
    }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "mdc-radio__content",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("label", {
        htmlFor: id,
        children: children
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "mdc-radio__description",
        children: description
      })]
    })]
  });
}
Radio.propTypes = {
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  onKeyDown: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  name: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  value: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  tabIndex: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node)
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Select.js":
/*!***************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Select.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Select)
/* harmony export */ });
/* harmony import */ var _material_react_select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-select */ "../node_modules/@material/react-select/dist/index.js");
/* harmony import */ var _material_react_select__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_select__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Select component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


function Select({
  id,
  helperText,
  ...props
}) {
  // For accessibility, provide a generated id fallback if an id
  // is not supplied. Adding an id is mandatory because otherwise the label
  // is not able to associate with the select.
  const idFallback = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_2__["default"])(Select, 'googlesitekit-select');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)((_material_react_select__WEBPACK_IMPORTED_MODULE_0___default()), {
    id: id || idFallback,
    helperText: !!helperText ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_material_react_select__WEBPACK_IMPORTED_MODULE_0__.SelectHelperText, {
      children: helperText
    }) : undefined,
    ...props
  });
}

/***/ }),

/***/ "./js/googlesitekit/components-gm2/SpinnerButton.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/components-gm2/SpinnerButton.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SPINNER_POSITION: () => (/* binding */ SPINNER_POSITION),
/* harmony export */   "default": () => (/* binding */ SpinnerButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Button */ "./js/googlesitekit/components-gm2/Button/index.js");
/* harmony import */ var _CircularProgress__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircularProgress */ "./js/googlesitekit/components-gm2/CircularProgress.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



const SPINNER_POSITION = {
  BEFORE: 'before',
  AFTER: 'after'
};
function SpinnerButton(props) {
  const {
    className,
    onClick = () => {},
    isSaving = false,
    spinnerPosition = SPINNER_POSITION.AFTER,
    ...restProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Button__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'googlesitekit-button-icon--spinner', {
      'googlesitekit-button-icon--spinner__running': isSaving,
      'googlesitekit-button-icon--spinner__before': spinnerPosition === SPINNER_POSITION.BEFORE,
      'googlesitekit-button-icon--spinner__after': spinnerPosition === SPINNER_POSITION.AFTER
    }),
    icon: isSaving && spinnerPosition === SPINNER_POSITION.BEFORE ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_CircularProgress__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: 14
    }) : undefined,
    trailingIcon: isSaving && spinnerPosition === SPINNER_POSITION.AFTER ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_CircularProgress__WEBPACK_IMPORTED_MODULE_2__["default"], {
      size: 14
    }) : undefined,
    onClick: onClick,
    ...restProps
  });
}
SpinnerButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  isSaving: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  spinnerPosition: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(Object.values(SPINNER_POSITION))
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Switch.js":
/*!***************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Switch.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/keycodes */ "../node_modules/@wordpress/keycodes/build-module/index.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Switch component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function Switch({
  onClick,
  label,
  checked,
  disabled,
  hideLabel
}) {
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__["default"])(Switch);
  const switchRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(el => {
    if (el !== null) {
      _js_material_components__WEBPACK_IMPORTED_MODULE_1__.MDCSwitch.attachTo(el);
    }
  }, []);
  const onKeyDown = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(event => {
    if (typeof onClick === 'function' && _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_5__.ENTER === event.keyCode) {
      onClick(event);
    }
  }, [onClick]);
  const id = `googlesitekit-switch-${instanceID}`;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      "aria-checked": checked ? 'true' : 'false',
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-switch', {
        'mdc-switch--checked': checked,
        'mdc-switch--disabled': disabled
      }),
      onClick: onClick,
      onKeyDown: onKeyDown,
      role: "switch",
      ref: switchRef,
      tabIndex: 0,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "mdc-switch__track",
        children: "\xA0"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: "mdc-switch__thumb-underlay",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
          className: "mdc-switch__thumb",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("input", {
            type: "checkbox",
            id: id,
            className: "mdc-switch__native-control",
            role: "switch",
            checked: checked,
            disabled: disabled,
            readOnly: true
          })
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("label", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
        'screen-reader-only': hideLabel
      }),
      htmlFor: id,
      children: label
    })]
  });
}
Switch.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node).isRequired,
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  hideLabel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};
Switch.defaultProps = {
  checked: false,
  disabled: false,
  hideLabel: true
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Switch);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/TextField.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/components-gm2/TextField.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HelperText: () => (/* reexport safe */ _material_react_text_field__WEBPACK_IMPORTED_MODULE_0__.HelperText),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _material_react_text_field__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-text-field */ "../node_modules/@material/react-text-field/dist/index.js");
/* harmony import */ var _material_react_text_field__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_text_field__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TextField component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


function TextField({
  className,
  name,
  label,
  noLabel,
  outlined,
  textarea,
  leadingIcon,
  trailingIcon,
  helperText,
  id,
  inputType,
  value,
  size,
  maxLength,
  tabIndex,
  disabled,
  onChange,
  onKeyDown
}) {
  // For accessibility, provide a generated id fallback if an id
  // is not supplied. Adding an id is mandatory because otherwise the label
  // is not able to associate with the input.
  const idFallback = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_2__["default"])(TextField, 'googlesitekit-textfield');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)((_material_react_text_field__WEBPACK_IMPORTED_MODULE_0___default()), {
    className: className,
    name: name,
    label: label,
    noLabel: noLabel,
    outlined: outlined,
    textarea: textarea,
    leadingIcon: leadingIcon,
    trailingIcon: trailingIcon,
    helperText: helperText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_material_react_text_field__WEBPACK_IMPORTED_MODULE_0__.HelperText, {
      persistent: true,
      children: helperText
    }),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_material_react_text_field__WEBPACK_IMPORTED_MODULE_0__.Input, {
      id: id || idFallback,
      inputType: inputType,
      value: value,
      size: size,
      maxLength: maxLength,
      tabIndex: tabIndex,
      disabled: disabled,
      onChange: onChange,
      onKeyDown: onKeyDown
    })
  });
}
TextField.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  noLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  outlined: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  textarea: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().element),
  trailingIcon: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().element)]),
  helperText: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)]),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  inputType: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  value: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)]),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  maxLength: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  tabIndex: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)]),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  onKeyDown: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};

/**
 * The HelperText component is exported as a named export here because
 * it is being used as a standalone component in the
 * SurveyQuestionMultiSelect component.
 */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextField);

/***/ }),

/***/ "./js/googlesitekit/components-gm2/Tooltip.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/components-gm2/Tooltip.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Tooltip/Tooltip.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


function Tooltip({
  children,
  popperClassName,
  tooltipClassName,
  onOpen,
  onClose,
  ...props
}) {
  const isOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useRef)(false);
  const handleOpen = onOpen ? () => {
    // This fixes a bug where the `onOpen` callback is called when the tooltip is already open.
    if (isOpen.current) {
      return;
    }
    isOpen.current = true;
    onOpen?.();
  } : undefined;
  const handleClose = onOpen ? () => {
    isOpen.current = false;
    onClose?.();
  } : onClose;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_3__["default"], {
    classes: {
      popper: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tooltip-popper', popperClassName),
      tooltip: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tooltip', tooltipClassName)
    },
    onOpen: handleOpen,
    onClose: handleClose,
    ...props,
    arrow: true,
    children: children
  });
}
Tooltip.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().node),
  popperClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};

/***/ }),

/***/ "./js/googlesitekit/components-gm2/index.js":
/*!**************************************************!*\
  !*** ./js/googlesitekit/components-gm2/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-dialog */ "../node_modules/@material/react-dialog/dist/index.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_dialog__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_react_select__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material/react-select */ "../node_modules/@material/react-select/dist/index.js");
/* harmony import */ var _material_react_select__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_material_react_select__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _material_react_tab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/react-tab */ "../node_modules/@material/react-tab/dist/index.js");
/* harmony import */ var _material_react_tab__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_material_react_tab__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _material_react_tab_bar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/react-tab-bar */ "../node_modules/@material/react-tab-bar/dist/index.js");
/* harmony import */ var _material_react_tab_bar__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_material_react_tab_bar__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _Button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Button */ "./js/googlesitekit/components-gm2/Button/index.js");
/* harmony import */ var _Checkbox__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Checkbox */ "./js/googlesitekit/components-gm2/Checkbox.js");
/* harmony import */ var _Chip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Chip */ "./js/googlesitekit/components-gm2/Chip.js");
/* harmony import */ var _CircularProgress__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CircularProgress */ "./js/googlesitekit/components-gm2/CircularProgress.js");
/* harmony import */ var _Menu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Menu */ "./js/googlesitekit/components-gm2/Menu.js");
/* harmony import */ var _ProgressBar__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ProgressBar */ "./js/googlesitekit/components-gm2/ProgressBar.js");
/* harmony import */ var _Radio__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Radio */ "./js/googlesitekit/components-gm2/Radio.js");
/* harmony import */ var _Select__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Select */ "./js/googlesitekit/components-gm2/Select.js");
/* harmony import */ var _SpinnerButton__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./SpinnerButton */ "./js/googlesitekit/components-gm2/SpinnerButton.js");
/* harmony import */ var _Switch__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Switch */ "./js/googlesitekit/components-gm2/Switch.js");
/* harmony import */ var _TextField__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./TextField */ "./js/googlesitekit/components-gm2/TextField.js");
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Tooltip */ "./js/googlesitekit/components-gm2/Tooltip.js");
/**
 * Google Site Kit components.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */





/**
 * Internal dependencies
 */












const Components = {
  Button: _Button__WEBPACK_IMPORTED_MODULE_4__["default"],
  Checkbox: _Checkbox__WEBPACK_IMPORTED_MODULE_5__["default"],
  Chip: _Chip__WEBPACK_IMPORTED_MODULE_6__["default"],
  CircularProgress: _CircularProgress__WEBPACK_IMPORTED_MODULE_7__["default"],
  Dialog: (_material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default()),
  DialogTitle: _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogTitle,
  DialogContent: _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogContent,
  DialogFooter: _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogFooter,
  HelperText: _TextField__WEBPACK_IMPORTED_MODULE_14__.HelperText,
  Menu: _Menu__WEBPACK_IMPORTED_MODULE_8__["default"],
  Option: _material_react_select__WEBPACK_IMPORTED_MODULE_1__.Option,
  ProgressBar: _ProgressBar__WEBPACK_IMPORTED_MODULE_9__["default"],
  Radio: _Radio__WEBPACK_IMPORTED_MODULE_10__["default"],
  Select: _Select__WEBPACK_IMPORTED_MODULE_11__["default"],
  SpinnerButton: _SpinnerButton__WEBPACK_IMPORTED_MODULE_12__["default"],
  SPINNER_POSITION: _SpinnerButton__WEBPACK_IMPORTED_MODULE_12__.SPINNER_POSITION,
  Switch: _Switch__WEBPACK_IMPORTED_MODULE_13__["default"],
  Tab: (_material_react_tab__WEBPACK_IMPORTED_MODULE_2___default()),
  TabBar: (_material_react_tab_bar__WEBPACK_IMPORTED_MODULE_3___default()),
  TextField: _TextField__WEBPACK_IMPORTED_MODULE_14__["default"],
  Tooltip: _Tooltip__WEBPACK_IMPORTED_MODULE_15__["default"]
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Components);

/***/ }),

/***/ "./js/hooks/useBreakpoint.ts":
/*!***********************************!*\
  !*** ./js/hooks/useBreakpoint.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAKPOINT_DESKTOP: () => (/* binding */ BREAKPOINT_DESKTOP),
/* harmony export */   BREAKPOINT_SMALL: () => (/* binding */ BREAKPOINT_SMALL),
/* harmony export */   BREAKPOINT_TABLET: () => (/* binding */ BREAKPOINT_TABLET),
/* harmony export */   BREAKPOINT_XLARGE: () => (/* binding */ BREAKPOINT_XLARGE),
/* harmony export */   useBreakpoint: () => (/* binding */ useBreakpoint)
/* harmony export */ });
/* harmony import */ var _useWindowSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useWindowSize */ "./js/hooks/useWindowSize.ts");
/**
 * `useBreakpoint` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



/**
 * Breakpoint for an extra large screen (over `1280px` wide).
 */
const BREAKPOINT_XLARGE = 'xlarge';
/**
 * Breakpoint for a desktop screen (over `960px` wide).
 */
const BREAKPOINT_DESKTOP = 'desktop';
/**
 * Breakpoint for a tablet screen (over `600px` wide).
 */
const BREAKPOINT_TABLET = 'tablet';
/**
 * Breakpoint for a mobile phone screen (any screen `600px` wide or less).
 */
const BREAKPOINT_SMALL = 'small';

/**
 * Retrieves the current breakpoint.
 *
 * @since 1.29.0
 *
 * @return {string} The current breakpoint according to the window size.
 */
function useBreakpoint() {
  const windowWidth = (0,_useWindowSize__WEBPACK_IMPORTED_MODULE_0__.useWindowWidth)();
  if (windowWidth > 1280) {
    return BREAKPOINT_XLARGE;
  }
  if (windowWidth > 960) {
    return BREAKPOINT_DESKTOP;
  }
  if (windowWidth > 600) {
    return BREAKPOINT_TABLET;
  }
  return BREAKPOINT_SMALL;
}

/***/ }),

/***/ "./js/hooks/useWindowSize.ts":
/*!***********************************!*\
  !*** ./js/hooks/useWindowSize.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useWindowHeight: () => (/* binding */ useWindowHeight),
/* harmony export */   useWindowSize: () => (/* binding */ useWindowSize),
/* harmony export */   useWindowWidth: () => (/* binding */ useWindowWidth)
/* harmony export */ });
/* harmony import */ var _react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @react-hook/throttle */ "../node_modules/@react-hook/throttle/dist/module/index.js");
/* harmony import */ var _react_hook_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-hook/event */ "../node_modules/@react-hook/event/dist/module/index.js");
/**
 * `useWindowSize` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Copied from https://github.com/jaredLunde/react-hook/blob/b8ac9515e26937e838a36a27001dc46c7f46a390/packages/window-size/throttled/src/index.tsx
// Modified to use global.innerWidth and global.innerHeight instead of document.documentElement.clientWidth and document.documentElement.clientHeight.

/**
 * External dependencies
 */


function getSize() {
  return [__webpack_require__.g.innerWidth, __webpack_require__.g.innerHeight];
}
function useWindowSize({
  fps = 60,
  leading = false,
  initialWidth = 0,
  initialHeight = 0
} = {}) {
  const [size, setThrottledSize] = (0,_react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__.useThrottle)(/* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);
  function setSize() {
    return setThrottledSize(getSize);
  }
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'resize', setSize);
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'orientationchange', setSize);
  return size;
}
function useWindowHeight(options = {}) {
  return useWindowSize(options)[1];
}
function useWindowWidth(options = {}) {
  return useWindowSize(options)[0];
}

/***/ }),

/***/ "./js/material-components/index.js":
/*!*****************************************!*\
  !*** ./js/material-components/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Cell),
/* harmony export */   Dialog: () => (/* reexport default from dynamic */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default.a),
/* harmony export */   DialogContent: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogContent),
/* harmony export */   DialogFooter: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogFooter),
/* harmony export */   Grid: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Grid),
/* harmony export */   MDCCheckbox: () => (/* reexport safe */ _material_checkbox__WEBPACK_IMPORTED_MODULE_7__.MDCCheckbox),
/* harmony export */   MDCDialog: () => (/* reexport safe */ _material_dialog__WEBPACK_IMPORTED_MODULE_6__.MDCDialog),
/* harmony export */   MDCFormField: () => (/* reexport safe */ _material_form_field__WEBPACK_IMPORTED_MODULE_3__.MDCFormField),
/* harmony export */   MDCMenu: () => (/* reexport safe */ _material_menu__WEBPACK_IMPORTED_MODULE_8__.MDCMenu),
/* harmony export */   MDCRadio: () => (/* reexport safe */ _material_radio__WEBPACK_IMPORTED_MODULE_4__.MDCRadio),
/* harmony export */   MDCRipple: () => (/* reexport safe */ _material_ripple__WEBPACK_IMPORTED_MODULE_2__.MDCRipple),
/* harmony export */   MDCSwitch: () => (/* reexport safe */ _material_switch__WEBPACK_IMPORTED_MODULE_5__.MDCSwitch),
/* harmony export */   Row: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Row)
/* harmony export */ });
/* harmony import */ var _material_ripple__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/ripple */ "../node_modules/@material/ripple/component.js");
/* harmony import */ var _material_form_field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/form-field */ "../node_modules/@material/form-field/component.js");
/* harmony import */ var _material_radio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material/radio */ "../node_modules/@material/radio/component.js");
/* harmony import */ var _material_switch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/switch */ "../node_modules/@material/switch/component.js");
/* harmony import */ var _material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/dialog */ "../node_modules/@material/dialog/component.js");
/* harmony import */ var _material_checkbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material/checkbox */ "../node_modules/@material/checkbox/component.js");
/* harmony import */ var _material_menu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material/menu */ "../node_modules/@material/menu/component.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-dialog */ "../node_modules/@material/react-dialog/dist/index.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_dialog__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./layout */ "./js/material-components/layout/index.js");
/**
 * Material components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */











/***/ }),

/***/ "./js/material-components/layout/Cell.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Cell.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cell)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Cell component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Cell(props) {
  const {
    className,
    alignTop,
    alignMiddle,
    alignBottom,
    alignRight,
    alignLeft,
    smAlignRight,
    mdAlignRight,
    lgAlignRight,
    smSize,
    smStart,
    smOrder,
    mdSize,
    mdStart,
    mdOrder,
    lgSize,
    lgStart,
    lgOrder,
    size,
    children,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'mdc-layout-grid__cell', {
      'mdc-layout-grid__cell--align-top': alignTop,
      'mdc-layout-grid__cell--align-middle': alignMiddle,
      'mdc-layout-grid__cell--align-bottom': alignBottom,
      'mdc-layout-grid__cell--align-right': alignRight,
      'mdc-layout-grid__cell--align-left': alignLeft,
      'mdc-layout-grid__cell--align-right-phone': smAlignRight,
      'mdc-layout-grid__cell--align-right-tablet': mdAlignRight,
      'mdc-layout-grid__cell--align-right-desktop': lgAlignRight,
      [`mdc-layout-grid__cell--span-${size}`]: 12 >= size && size > 0,
      [`mdc-layout-grid__cell--span-${lgSize}-desktop`]: 12 >= lgSize && lgSize > 0,
      [`mdc-layout-grid__cell--start-${lgStart}-desktop`]: 12 >= lgStart && lgStart > 0,
      [`mdc-layout-grid__cell--order-${lgOrder}-desktop`]: 12 >= lgOrder && lgOrder > 0,
      [`mdc-layout-grid__cell--span-${mdSize}-tablet`]: 8 >= mdSize && mdSize > 0,
      [`mdc-layout-grid__cell--start-${mdStart}-tablet`]: 8 >= mdStart && mdStart > 0,
      [`mdc-layout-grid__cell--order-${mdOrder}-tablet`]: 8 >= mdOrder && mdOrder > 0,
      [`mdc-layout-grid__cell--span-${smSize}-phone`]: 4 >= smSize && smSize > 0,
      [`mdc-layout-grid__cell--start-${smStart}-phone`]: 4 >= smStart && smStart > 0,
      [`mdc-layout-grid__cell--order-${smOrder}-phone`]: 4 >= smOrder && smOrder > 0
    }),
    children: children
  });
}
Cell.propTypes = {
  smSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  alignTop: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignMiddle: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignBottom: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  smAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  mdAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  lgAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
Cell.defaultProps = {
  className: '',
  size: 0,
  smSize: 0,
  smStart: 0,
  smOrder: 0,
  mdSize: 0,
  mdStart: 0,
  mdOrder: 0,
  lgSize: 0,
  lgStart: 0,
  lgOrder: 0
};

/***/ }),

/***/ "./js/material-components/layout/Grid.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Grid.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Grid component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Grid = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  alignLeft,
  fill,
  className,
  children,
  collapsed,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid', className, {
      'mdc-layout-grid--align-left': alignLeft,
      'mdc-layout-grid--collapsed': collapsed,
      'mdc-layout-grid--fill': fill
    }),
    ...otherProps,
    ref: ref,
    children: children
  });
});
Grid.displayName = 'Grid';
Grid.propTypes = {
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  fill: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Grid.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Grid);

/***/ }),

/***/ "./js/material-components/layout/Row.js":
/*!**********************************************!*\
  !*** ./js/material-components/layout/Row.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Row component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Row = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid__inner', className),
    ...otherProps,
    children: children
  });
});
Row.displayName = 'Row';
Row.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Row.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Row);

/***/ }),

/***/ "./js/material-components/layout/index.js":
/*!************************************************!*\
  !*** ./js/material-components/layout/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _Cell__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Grid: () => (/* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Row: () => (/* reexport safe */ _Row__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _Cell__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cell */ "./js/material-components/layout/Cell.js");
/* harmony import */ var _Row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Row */ "./js/material-components/layout/Row.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Grid */ "./js/material-components/layout/Grid.js");
/**
 * Material UI > Layout components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.i18n;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-components.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-components.js.map