"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-datastore-ui"],{

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-datastore-ui.js":
/*!******************************************!*\
  !*** ./js/googlesitekit-datastore-ui.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _googlesitekit_datastore_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/datastore/ui */ "./js/googlesitekit/datastore/ui/index.js");
/**
 * Entrypoint for the `core/ui` data store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This import has side effects; it registers the core/ui datastore
// on the default data store (`googlesitekit.data`).

/**
 * Internal dependencies
 */


(0,_googlesitekit_datastore_ui__WEBPACK_IMPORTED_MODULE_1__.registerStore)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.167.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/data/create-error-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-error-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   createErrorStore: () => (/* binding */ createErrorStore),
/* harmony export */   generateErrorKey: () => (/* binding */ generateErrorKey)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


const RECEIVE_ERROR = 'RECEIVE_ERROR';
const CLEAR_ERROR = 'CLEAR_ERROR';
const CLEAR_ERRORS = 'CLEAR_ERRORS';

/**
 * Internal dependencies
 */


function generateErrorKey(baseName, args) {
  if (args && Array.isArray(args)) {
    const stringifiedArgs = args.map(item => {
      return 'object' === typeof item ? (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringifyObject)(item) : item;
    });
    return `${baseName}::${md5__WEBPACK_IMPORTED_MODULE_1___default()(JSON.stringify(stringifiedArgs))}`;
  }
  return baseName;
}
const actions = {
  receiveError(error, baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(error, 'error is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: RECEIVE_ERROR,
      payload: {
        error,
        baseName,
        args
      }
    };
  },
  clearError(baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: CLEAR_ERROR,
      payload: {
        baseName,
        args
      }
    };
  },
  clearErrors(baseName) {
    return {
      type: CLEAR_ERRORS,
      payload: {
        baseName
      }
    };
  }
};
function createErrorStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName must be defined.');
  const initialState = {
    errors: {},
    errorArgs: {}
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case RECEIVE_ERROR:
        {
          const {
            baseName,
            args,
            error
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          state.errors[key] = error;
          state.errorArgs[key] = args;
          break;
        }
      case CLEAR_ERROR:
        {
          const {
            baseName,
            args
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          delete state.errors[key];
          delete state.errorArgs[key];
          break;
        }
      case CLEAR_ERRORS:
        {
          const {
            baseName
          } = payload;
          if (baseName) {
            state.errors = state.errors || {};
            state.errorArgs = state.errorArgs || {};
            for (const key in state.errors) {
              if (key === baseName || key.startsWith(`${baseName}::`)) {
                delete state.errors[key];
                delete state.errorArgs[key];
              }
            }
          } else {
            state.errors = {};
            state.errorArgs = {};
          }
          break;
        }
    }
  });
  const controls = {};
  const resolvers = {};
  const selectors = {
    /**
     * Retrieves the error object from state.
     *
     * Error object has the format:
     *
     * ```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state        Data store's state.
     * @param {string}      selectorName Selector name.
     * @param {Array.<any>} [args]       Arguments passed to selector (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForSelector(state, selectorName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(selectorName, 'selectorName is required.');
      return selectors.getError(state, selectorName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      actionName Action name.
     * @param {Array.<any>} [args]     Arguments passed to action (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForAction(state, actionName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(actionName, 'actionName is required.');
      return selectors.getError(state, actionName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     * @private
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      [baseName] Selector or action name.
     * @param {Array.<any>} [args]     Arguments array.
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getError(state, baseName, args) {
      const {
        errors
      } = state;
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
      return errors[generateErrorKey(baseName, args)];
    },
    /**
     * Gets a list of all unique errors.
     *
     * @since 1.19.0
     *
     * @param {Object} state Data store's state.
     * @return {Object[]} Unique set of errors.
     */
    getErrors(state) {
      const errorsSet = new Set(Object.values(state.errors));
      return Array.from(errorsSet);
    },
    /**
     * Gets the meta-data for a given error object, or null if the error is not found.
     *
     * Returns meta-data in the format:
     *
     * ```
     *	{
     *		baseName: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.84.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Meta-data for the given error object, or null if the error is not found.
     */
    getMetaDataForError(state, error) {
      const key = Object.keys(state.errors).find(errorKey => state.errors[errorKey] === error);
      if (key) {
        const baseName = key.substring(0, key.indexOf('::'));
        return {
          baseName,
          args: state.errorArgs[key]
        };
      }
      return null;
    },
    /**
     * Gets the selector data for a given error object, or null if no selector data is available.
     *
     * Returns selector data in the format:
     *
     * ```
     *	{
     *		storeName: <string>,
     *		name: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.87.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Selector data for the given error object, or null if no selector data is available.
     */
    getSelectorDataForError: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.createRegistrySelector)(select => function (state, error) {
      const metaData = select(storeName).getMetaDataForError(error);
      if (metaData) {
        const {
          baseName: name,
          args
        } = metaData;
        const isSelector = !!select(storeName)[name];
        if (isSelector) {
          return {
            storeName,
            name,
            args
          };
        }
      }
      return null;
    }),
    /**
     * Determines whether the datastore has errors or not.
     *
     * @since 1.15.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} TRUE if the datastore has errors, otherwise FALSE.
     */
    hasErrors(state) {
      return selectors.getErrors(state).length > 0;
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-snapshot-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-snapshot-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSnapshotStore: () => (/* binding */ createSnapshotStore),
/* harmony export */   getStoresWithSnapshots: () => (/* binding */ getStoresWithSnapshots),
/* harmony export */   restoreAllSnapshots: () => (/* binding */ restoreAllSnapshots),
/* harmony export */   snapshotAllStores: () => (/* binding */ snapshotAllStores)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Provides a datastore for snapshotting and restoring state.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




// Actions
const CREATE_SNAPSHOT = 'CREATE_SNAPSHOT';
const DELETE_SNAPSHOT = 'DELETE_SNAPSHOT';
const RESTORE_SNAPSHOT = 'RESTORE_SNAPSHOT';
const SET_STATE_FROM_SNAPSHOT = 'SET_STATE_FROM_SNAPSHOT';

/**
 * Creates a store object that includes actions and controls for restoring/creating state snapshots.
 *
 * @since 1.9.0
 * @since 1.163.0 Added the ability to pick specific parts of the state to save in the snapshot.
 * @private
 *
 * @param {string}          storeName                The name of the store to snapshot in the cache.
 * @param {Object}          [options]                Optional configuration object.
 * @param {string|string[]} [options.keysToSnapshot] Property path(s) to pick from state when creating snapshots.
 * @return {Object} The snapshot store object.
 */
function createSnapshotStore(storeName, {
  keysToSnapshot
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required to create a snapshot store.');
  const initialState = {};
  const actions = {
    /**
     * Deletes a snapshot of state for a storeName, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache deletion response.
     */
    *deleteSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: DELETE_SNAPSHOT
      };
      return cacheResult;
    },
    /**
     * Restores a snapshot of state for a storeName, if available, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @param {Object}  [options]                   Options object.
     * @param {boolean} [options.clearAfterRestore] Whether or not to delete snapshot after restore. Default: true.
     * @return {boolean} Cache restoration response.
     */
    *restoreSnapshot(options = {}) {
      const {
        clearAfterRestore = true
      } = options;
      const {
        cacheHit,
        value
      } = yield {
        payload: {},
        type: RESTORE_SNAPSHOT
      };
      if (cacheHit) {
        yield {
          payload: {
            snapshot: value
          },
          type: SET_STATE_FROM_SNAPSHOT
        };
        if (clearAfterRestore) {
          yield {
            payload: {},
            type: DELETE_SNAPSHOT
          };
        }
      }
      return cacheHit;
    },
    /**
     * Creates a snapshot of the current state of this store, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache write response.
     */
    *createSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: CREATE_SNAPSHOT
      };
      return cacheResult;
    }
  };
  const controls = {
    [DELETE_SNAPSHOT]: () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.deleteItem)(`datastore::cache::${storeName}`);
    },
    [CREATE_SNAPSHOT]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistryControl)(registry => () => {
      const state = registry.stores[storeName].store.getState();
      const stateToSnapshot = keysToSnapshot?.length > 0 ? (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(state, keysToSnapshot) : state;
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.setItem)(`datastore::cache::${storeName}`, stateToSnapshot);
    }),
    [RESTORE_SNAPSHOT]: () => {
      // Only get snapshots made within the last hour.
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.getItem)(`datastore::cache::${storeName}`, _js_util__WEBPACK_IMPORTED_MODULE_4__.HOUR_IN_SECONDS);
    }
  };
  function reducer(state = initialState, {
    type,
    payload
  }) {
    // eslint-disable-line no-shadow
    switch (type) {
      case SET_STATE_FROM_SNAPSHOT:
        {
          const {
            snapshot
          } = payload;
          // Exclude any top-level errors from the restored state.
          // eslint-disable-next-line no-unused-vars
          const {
            error,
            ...newState
          } = snapshot;

          // If only a part of the state has been added to the snapshot, then
          // we should update the initial state with partial data restored
          // from the snapshot.
          if (keysToSnapshot?.length > 0) {
            return {
              ...state,
              ...newState
            };
          }
          return newState;
        }
      default:
        {
          return state;
        }
    }
  }
  return {
    initialState,
    actions,
    controls,
    reducer
  };
}

/**
 * Inspects a registry to find all stores that support our snapshot features.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} registry Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Object} The snapshot store object.
 */
function getStoresWithSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Object.values(registry.stores).filter(store => {
    return Object.keys(store.getActions()).includes('restoreSnapshot');
  });
}

/**
 * Creates snapshots of all supporting stores.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been taken.
 */
function snapshotAllStores(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().createSnapshot();
  }));
}

/**
 * Restores state for all snapshots that support it.
 *
 * Only restores snapshots for stores that have `restoreSnapshot` action, and
 * clears the snapshot afterward, so more stores will not be restored unless
 * a snapshot was saved on the last pageview.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been restored.
 */
function restoreAllSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().restoreSnapshot();
  }));
}

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVE_CONTEXT_ID: () => (/* binding */ ACTIVE_CONTEXT_ID),
/* harmony export */   CORE_UI: () => (/* binding */ CORE_UI)
/* harmony export */ });
/**
 * `core/ui` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_UI = 'core/ui';
const ACTIVE_CONTEXT_ID = 'activeContextID';

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/index.js":
/*!************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   registerStore: () => (/* binding */ registerStore),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ui */ "./js/googlesitekit/datastore/ui/ui.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/ui/constants.js");
/**
 * `core/ui` data store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonStore, _ui__WEBPACK_IMPORTED_MODULE_3__["default"], (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_2__.createSnapshotStore)(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI), (0,_js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_1__.createErrorStore)(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI));
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
function registerStore(registry) {
  registry.registerStore(_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI, store);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/ui.js":
/*!*********************************************!*\
  !*** ./js/googlesitekit/datastore/ui/ui.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/ui/constants.js");
/**
 * `core/ui` data store: ui data
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


const SET_VALUES = 'SET_VALUES';
const SET_VALUE = 'SET_VALUE';
const initialState = {
  useInViewResetCount: 0,
  isOnline: true
};
const actions = {
  /**
   * Resets all `useInView` hooks that have the `sticky` param set to `true`.
   *
   * @since 1.46.0
   * @private
   *
   * @return {Object} Redux-style action.
   */
  *resetInViewHook() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    const useInViewResetCount = registry.select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI).getValue('useInViewResetCount');
    return yield actions.setValue('useInViewResetCount', useInViewResetCount + 1);
  },
  /**
   * Sets `isOnline` state.
   *
   * @since 1.118.0
   * @private
   *
   * @param {boolean} value `isOnline` status.
   * @return {Object} Redux-style action.
   */
  setIsOnline(value) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isBoolean)(value), 'value must be boolean.');
    return actions.setValue('isOnline', value);
  },
  /**
   * Stores site ui information.
   *
   * @since 1.27.0
   * @private
   *
   * @param {Object} values Ui data supplied as a map of keys to set and their respective values.
   * @return {Object} Redux-style action.
   */
  setValues(values) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(values), 'values must be an object.');
    return {
      payload: {
        values
      },
      type: SET_VALUES
    };
  },
  /**
   * Sets a particular value for a key.
   *
   * @since 1.27.0
   * @private
   *
   * @param {string} key   Ui key to set the value for.
   * @param {*}      value The value for the key.
   * @return {Object} Redux-style action.
   */
  setValue(key, value) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(key, 'key is required.');
    return {
      payload: {
        key,
        value
      },
      type: SET_VALUE
    };
  }
};
const controls = {};
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case SET_VALUES:
      Object.assign(state, payload.values);
      break;
    case SET_VALUE:
      state[payload.key] = payload.value;
      break;
    default:
      break;
  }
});
const resolvers = {};
const selectors = {
  /**
   * Gets the existing data by key.
   *
   * @since 1.27.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @param {string} key   Get data stored in this key.
   * @return {*} Value stored in state by key. Returns `undefined` if key isn't found.
   */
  getValue(state, key) {
    return state[key];
  },
  /**
   * Gets the existing useInView hook reset count.
   *
   * @since 1.46.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {number} Number of times `useInView` hooks have been reset.
   */
  getInViewResetCount(state) {
    return state.useInViewResetCount;
  },
  /**
   * Gets the `isOnline` status.
   *
   * @since 1.118.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {boolean} `isOnline` value.
   */
  getIsOnline(state) {
    return state.isOnline;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
});

/***/ }),

/***/ "./js/util/chart.js":
/*!**************************!*\
  !*** ./js/util/chart.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* binding */ calculateDifferenceBetweenChartValues),
/* harmony export */   getChartDifferenceArrow: () => (/* binding */ getChartDifferenceArrow),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Utility functions for charts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Gets the up/down SVG arrow for Google Chart tooltips.
 *
 * @since 1.30.0
 *
 * @param {number}  difference            The difference which can be positive or negative.
 * @param {string}  [options]             Options to be passed to the ChangeArrow component.
 * @param {boolean} [options.invertColor] Whether we need to reverse the +/- colors of the arrow.
 * @return {string} SVG for the +/- difference.
 */

function getChartDifferenceArrow(difference, options = {}) {
  if (Number.isNaN(Number(difference))) {
    return '';
  }
  const {
    invertColor = false
  } = options;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["default"])(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__["default"], {
    direction: difference > 0 ? 'up' : 'down',
    invertColor: invertColor
  }));
}

/**
 * Checks if there is a single row of data or one row is contributing 100% of the total for a given dimension.
 *
 * @since 1.31.0
 *
 * @param {Array.<Object>} report An array of report data objects.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  if (report?.[0]?.data?.rows?.length === 1 || report?.[0]?.data?.rows?.[0]?.metrics?.[0]?.values?.[0] === report?.[0]?.data?.totals?.[0]?.values?.[0]) {
    return true;
  }
  return false;
}

/**
 * Calculates difference between two chart values.
 *
 * @since 1.48.0
 *
 * @param {number} currentValue  Current chart value.
 * @param {number} previousValue Previous chart value.
 * @return {number} The difference.
 */
function calculateDifferenceBetweenChartValues(currentValue, previousValue) {
  if (currentValue > 0 && previousValue > 0) {
    return currentValue / previousValue - 1;
  }
  if (currentValue > 0) {
    return 1;
  }
  if (previousValue > 0) {
    return -1;
  }
  return 0;
}

/***/ }),

/***/ "./js/util/convert-time.js":
/*!*********************************!*\
  !*** ./js/util/convert-time.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* binding */ convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* binding */ convertSecondsToArray)
/* harmony export */ });
/**
 * Time related utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts seconds into an array with the following values [HH, MM, SS, MS] as described below.
 * HH: hours.
 * MM: minutes.
 * SS: seconds.
 * MS: milliseconds.
 *
 * For example, passing 196.385 returns [ 0, 3, 16, 385 ].
 *
 * @since 1.27.0
 *
 * @param {number} seconds The number of seconds.
 * @return {Array} Array containing the hours, minutes, seconds and milliseconds.
 */
function convertSecondsToArray(seconds) {
  seconds = parseFloat(seconds);
  if (isNaN(seconds) || 0 === seconds) {
    return [0, 0, 0, 0];
  }
  return [Math.floor(seconds / 60 / 60), Math.floor(seconds / 60 % 60), Math.floor(seconds % 60), Math.floor(seconds * 1000) - Math.floor(seconds) * 1000];
}

/**
 * Converts Date time string into UNIX timestamp in milliseconds.
 *
 * For example, passing "2014-10-02T15:01:23Z" returns 1412262083000.
 *
 * @since 1.116.0
 *
 * @param {string} dateStringValue The date time string.
 * @return {number} UNIX timestamp in milliseconds.
 */
function convertDateStringToUNIXTimestamp(dateStringValue) {
  const unixTimestamp = dateStringValue && !Number.isInteger(dateStringValue) ?
  // Valid use of `new Date()` with an argument, because this should only
  // be passed full time strings, not `YYYY-MM-DD` style dates.
  //
  // See: https://github.com/google/site-kit-wp/pull/9459#discussion_r1790660073
  // eslint-disable-next-line sitekit/no-direct-date
  new Date(dateStringValue).getTime() : dateStringValue;
  if (isNaN(unixTimestamp) || !unixTimestamp) {
    return 0;
  }
  return unixTimestamp;
}

/***/ }),

/***/ "./js/util/dates.js":
/*!**************************!*\
  !*** ./js/util/dates.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* binding */ DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* binding */ HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* binding */ INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* binding */ INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* binding */ INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* binding */ MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* binding */ MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* binding */ WEEK_IN_SECONDS),
/* harmony export */   dateSub: () => (/* binding */ dateSub),
/* harmony export */   getAvailableDateRanges: () => (/* binding */ getAvailableDateRanges),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* binding */ getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* binding */ getDateString),
/* harmony export */   getPreviousDate: () => (/* binding */ getPreviousDate),
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidDateString: () => (/* binding */ isValidDateString),
/* harmony export */   stringToDate: () => (/* binding */ stringToDate)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

const INVALID_DATE_INSTANCE_ERROR = 'Date param must construct to a valid date instance or be a valid date instance itself.';
const INVALID_DATE_STRING_ERROR = 'Invalid dateString parameter, it must be a string.';
const INVALID_DATE_RANGE_ERROR = 'Invalid date range, it must be a string with the format "last-x-days".';
const MINUTE_IN_SECONDS = 60;
const HOUR_IN_SECONDS = 60 * MINUTE_IN_SECONDS;
const DAY_IN_SECONDS = 24 * HOUR_IN_SECONDS;
const WEEK_IN_SECONDS = 7 * DAY_IN_SECONDS;
const MONTH_IN_SECONDS = 30 * DAY_IN_SECONDS;

/**
 * Gets the hash of available date ranges.
 *
 * @since 1.12.0
 *
 * @return {Object} The object hash where every key is a date range slug, and the value is an object with the date range slug and its translation.
 */
function getAvailableDateRanges() {
  function label(days) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: number of days */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._n)('Last %s day', 'Last %s days', days, 'google-site-kit'), days);
  }
  return {
    'last-7-days': {
      slug: 'last-7-days',
      label: label(7),
      days: 7
    },
    'last-14-days': {
      slug: 'last-14-days',
      label: label(14),
      days: 14
    },
    'last-28-days': {
      slug: 'last-28-days',
      label: label(28),
      days: 28
    },
    'last-90-days': {
      slug: 'last-90-days',
      label: label(90),
      days: 90
    }
  };
}

/**
 * Gets the current dateRange day count.
 *
 * @since 1.19.0
 * @since 1.26.0 `dateRange` is now a required argument.
 *
 * @param {string} dateRange The date range slug.
 * @return {number} The number of days in the range.
 */
function getCurrentDateRangeDayCount(dateRange) {
  const daysMatch = dateRange.match(/last-(\d+)-days/);
  if (daysMatch && daysMatch[1]) {
    return parseInt(daysMatch[1], 10);
  }
  throw new Error('Unrecognized date range slug.');
}

/**
 * Asserts whether a given date string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateString Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given date string is valid.
 */
function isValidDateString(dateString = '') {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isString)(dateString)) {
    return false;
  }
  const dateArray = dateString.split('-');
  if (dateArray.length !== 3) {
    return false;
  }

  // Valid use of `new Date()`, constructing a new date from the string.
  // eslint-disable-next-line sitekit/no-direct-date
  const date = new Date(dateString);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date);
}

/**
 * Parses the given Date instance and returns a date string (YYYY-MM-DD).
 *
 * @since 1.18.0
 * @since 1.85.0 Updated the function signature to only accept a Date argument.
 *
 * @param {Date} date Date to parse into a string.
 * @return {string}                 The parsed date string (YYYY-MM-DD).
 */
function getDateString(date) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date), INVALID_DATE_INSTANCE_ERROR);
  const month = `${date.getMonth() + 1}`;
  const day = `${date.getDate()}`;
  const year = date.getFullYear();
  return [year, month.length < 2 ? `0${month}` : month, day.length < 2 ? `0${day}` : day].join('-');
}

/**
 * Converts a valid date string to a Date instance.
 *
 * @since 1.38.0
 *
 * @param {string} dateString The date string to parse.
 * @return {Date} Date instance.
 */
function stringToDate(dateString) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(dateString), INVALID_DATE_STRING_ERROR);

  /**
   * Split date into explicit parts rather than pass directly into date constructor
   * to avoid timezone issues caused by parsing as UTC. Ensures date is accurate for
   * the user's local time, otherwise has a chance to return a different day than was
   * passed in depending on timezone.
   */
  const [year, month, day] = dateString.split('-');
  return new Date(year, month - 1, day);
}

/**
 * Parses the given date and returns the previous date (daysBefore).
 *
 * @since 1.18.0
 *
 * @param {string} relativeDate Date string (YYYY-MM-DD) to subtract days from.
 * @param {number} daysBefore   Number of days to subtract from relativeDate.
 * @return {string}             The date string (YYYY-MM-DD) for the previous date.
 */
function getPreviousDate(relativeDate, daysBefore) {
  return getDateString(dateSub(relativeDate, daysBefore * DAY_IN_SECONDS));
}

/**
 * Asserts whether a given dateRange string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateRange Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given dateRange string is valid.
 */
function isValidDateRange(dateRange) {
  const parts = dateRange.split('-');
  return parts.length === 3 && parts[0] === 'last' && !Number.isNaN(parts[1]) && !Number.isNaN(parseFloat(parts[1])) && parts[2] === 'days';
}

/**
 * Subtracts duration from the prodived date and returns it.
 *
 * @since 1.132.0
 *
 * @param {Date|string} relativeDate Date string (YYYY-MM-DD) or date object to subtract duration from.
 * @param {number}      duration     The duration in seconds to subtract from relativeDate.
 * @return {Date} Resulting date.
 */
function dateSub(relativeDate, duration) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(relativeDate) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(relativeDate) && !isNaN(relativeDate), INVALID_DATE_STRING_ERROR);
  const timestamp = isValidDateString(relativeDate) ? Date.parse(relativeDate) : relativeDate.getTime();

  // Valid use of `new Date()` using calculations.
  // eslint-disable-next-line sitekit/no-direct-date
  return new Date(timestamp - duration * 1000);
}

/***/ }),

/***/ "./js/util/i18n.js":
/*!*************************!*\
  !*** ./js/util/i18n.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDurationFormat: () => (/* binding */ createDurationFormat),
/* harmony export */   expandNumFmtOptions: () => (/* binding */ expandNumFmtOptions),
/* harmony export */   getLocale: () => (/* binding */ getLocale),
/* harmony export */   listFormat: () => (/* binding */ listFormat),
/* harmony export */   numFmt: () => (/* binding */ numFmt),
/* harmony export */   numberFormat: () => (/* binding */ numberFormat),
/* harmony export */   prepareForReadableLargeNumber: () => (/* binding */ prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* binding */ readableLargeNumber)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Internationalization Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed.
 *
 * For example, passing 65 returns '1m 5s'.
 *
 * @since 1.0.0
 * @since 1.28.0 Refactored and renamed to improve localization.
 * @private
 *
 * @param {number}                     durationInSeconds The number of seconds.
 * @param {(Intl.NumberFormatOptions)} [options]         Optional formatting options.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationFormat(durationInSeconds, options = {}) {
  const {
    formatUnit,
    formatDecimal
  } = createDurationFormat(durationInSeconds, options);
  try {
    // Some browsers, e.g. Safari, throw a RangeError when options.style is
    // not one of decimal, percent, or currency.
    return formatUnit();
  } catch {
    // Fallback to XXh YYm ZZs using localized decimals with hardcoded units.
    return formatDecimal();
  }
}

/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed
 * in ISO format - HH:mm:ss.
 *
 * If the duration is less than an hour, the HH part of the string
 * is truncated.
 * For example, passing 65 returns '01:05'.
 * Passing 5400 returns '01:30:00'.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationISOFormat(durationInSeconds) {
  let {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  seconds = ('0' + seconds).slice(-2);
  minutes = ('0' + minutes).slice(-2);
  hours = ('0' + hours).slice(-2);
  return hours === '00' ? `${minutes}:${seconds}` : `${hours}:${minutes}:${seconds}`;
}

/**
 * Parses the duration in seconds into hours, minutes and seconds.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {Object} Number of hours, minutes and seconds equivalent
 * to the given duration in seconds.
 */
function parseDuration(durationInSeconds) {
  durationInSeconds = parseInt(durationInSeconds, 10);
  if (Number.isNaN(durationInSeconds)) {
    durationInSeconds = 0;
  }
  const hours = Math.floor(durationInSeconds / 60 / 60);
  const minutes = Math.floor(durationInSeconds / 60 % 60);
  const seconds = Math.floor(durationInSeconds % 60);
  return {
    hours,
    minutes,
    seconds
  };
}

/**
 * Creates duration formatting utilities.
 *
 * Not intended to be used directly.
 * Use `numFmt( number, { style: 'duration' } )` instead.
 *
 * @since 1.29.0
 * @private
 *
 * @param {number} durationInSeconds Duration to format.
 * @param {Object} [options]         Formatting options.
 * @return {Object} Formatting functions.
 */
function createDurationFormat(durationInSeconds, options = {}) {
  const {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  return {
    hours,
    minutes,
    seconds,
    formatUnit() {
      const {
        unitDisplay = 'short',
        ...restOptions
      } = options;
      const commonOptions = {
        unitDisplay,
        ...restOptions,
        style: 'unit'
      };
      if (durationInSeconds === 0) {
        return numberFormat(seconds, {
          ...commonOptions,
          unit: 'second'
        });
      }
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? numberFormat(seconds, {
        ...commonOptions,
        unit: 'second'
      }) : '', minutes ? numberFormat(minutes, {
        ...commonOptions,
        unit: 'minute'
      }) : '', hours ? numberFormat(hours, {
        ...commonOptions,
        unit: 'hour'
      }) : '').trim();
    },
    /**
     * Formats the duration using integers and translatable strings.
     * This is only used as a fallback when the above `formatUnit` fails.
     *
     * @since 1.29.0
     *
     * @return {string} Formatted duration.
     */
    formatDecimal() {
      const formattedSeconds = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of seconds with "s" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%ds', 'google-site-kit'), seconds);
      if (durationInSeconds === 0) {
        return formattedSeconds;
      }
      const formattedMinutes = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of minutes with "m" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dm', 'google-site-kit'), minutes);
      const formattedHours = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of hours with "h" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dh', 'google-site-kit'), hours);
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? formattedSeconds : '', minutes ? formattedMinutes : '', hours ? formattedHours : '').trim();
    }
  };
}

/**
 * Prepares a number to be used in readableLargeNumber.
 *
 * @since 1.7.0
 *
 * @param {number} number The large number to prepare.
 * @return {number} The prepared number.
 */
function prepareForReadableLargeNumber(number) {
  if (1000000 <= number) {
    return Math.round(number / 100000) / 10;
  }
  if (10000 <= number) {
    return Math.round(number / 1000);
  }
  if (1000 <= number) {
    return Math.round(number / 100) / 10;
  }
  return number;
}

/**
 * Formats a large number for shortened display.
 *
 * @since 1.0.0
 *
 * @param {number} number The large number to format.
 * @return {string} The formatted number.
 */
function readableLargeNumber(number) {
  const withSingleDecimal = {
    minimumFractionDigits: 1,
    maximumFractionDigits: 1
  };

  // Numbers over 1,000,000 round normally and display a single decimal unless the decimal is 0.
  if (1000000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in millions.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sM', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }

  // Numbers between 10,000 and 1,000,000 round normally and have no decimals
  if (10000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number)));
  }

  // Numbers between 1,000 and 10,000 round normally and display a single decimal unless the decimal is 0.
  if (1000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }
  return numberFormat(number, {
    signDisplay: 'never',
    maximumFractionDigits: 1
  });
}

/**
 * Parses formatting options and returns an object with options for selected formatting.
 *
 * @since 1.103.0
 *
 * @param {(Intl.NumberFormatOptions|string)} options Formatting options or unit shorthand. Possible shorthand values are '%', 's', or a currency code.
 * @return {Object} Formatting options.
 */
function expandNumFmtOptions(options) {
  let formatOptions = {};

  // Expand shorthand values for units.
  if ('%' === options) {
    formatOptions = {
      style: 'percent',
      maximumFractionDigits: 2
    };
  } else if ('s' === options) {
    formatOptions = {
      style: 'duration',
      unitDisplay: 'narrow'
    };
  } else if (!!options && typeof options === 'string') {
    formatOptions = {
      style: 'currency',
      currency: options
    };
  } else if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(options)) {
    formatOptions = {
      ...options
    };
  }
  return formatOptions;
}

/**
 * Formats a number with unit using the JS Internationalization Number Format API.
 *
 * In addition to the supported 'style' values of the lower-level `numberFormat` function, this function
 * supports two additional 'style' values 'metric' and 'duration' (expects a number in seconds).
 *
 * Another differentiation in behavior is that by default the function will use 'metric' formatting instead
 * of 'decimal' formatting.
 *
 * @since 1.24.0
 *
 * @param {number|string}                     number    The number to format.
 * @param {(Intl.NumberFormatOptions|string)} [options] Formatting options or unit shorthand.
 *                                                      Possible shorthand values are '%', 's',
 *                                                      or a currency code.
 * @return {string} The formatted number.
 */
function numFmt(number, options = {}) {
  // Cast parsable values to numeric types.
  number = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number) ? number : Number(number);
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number)) {
    // eslint-disable-next-line no-console
    console.warn('Invalid number', number, typeof number);
    number = 0;
  }
  const formatOptions = expandNumFmtOptions(options);
  const {
    style = 'metric'
  } = formatOptions; // Note: `metric` is our custom, default style.

  if ('metric' === style) {
    return readableLargeNumber(number);
  }
  if ('duration' === style) {
    return durationFormat(number, formatOptions);
  }
  if ('durationISO' === style) {
    return durationISOFormat(number);
  }
  return numberFormat(number, formatOptions);
}

// Warn once for a given message.
const warnOnce = memize__WEBPACK_IMPORTED_MODULE_1___default()(console.warn); // eslint-disable-line no-console

/**
 * Formats a number using the JS Internationalization Number Format API.
 *
 * @since 1.8.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/NumberFormat|`options` parameter} For all available formatting options.
 *
 * @param {number}                   number           The number to format.
 * @param {Intl.NumberFormatOptions} [options]        Formatting options.
 * @param {string}                   [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @return {string} The formatted number.
 */
function numberFormat(number, options = {}) {
  const {
    locale = getLocale(),
    ...formatOptions
  } = options;
  try {
    /**
     * Per https://github.com/google/site-kit-wp/issues/3255 there have been issues with some versions of Safari
     * on some operating systems throwing issues with some parameters in the formatOptions.
     *
     * If an error is thrown, we remove some troublesome params from the formatOptions object and fallback to no formatting.
     *
     * This allows us to degrade somewhat gracefully without breaking the dashboard for users of unaffected browsers.
     */
    return new Intl.NumberFormat(locale, formatOptions).format(number);
  } catch (error) {
    warnOnce(`Site Kit numberFormat error: Intl.NumberFormat( ${JSON.stringify(locale)}, ${JSON.stringify(formatOptions)} ).format( ${typeof number} )`, error.message);
  }

  // Remove these key/values from formatOptions.
  const unstableFormatOptionValues = {
    currencyDisplay: 'narrow',
    currencySign: 'accounting',
    style: 'unit'
  };

  // Remove these keys from formatOptions irrespective of value.
  const unstableFormatOptions = ['signDisplay', 'compactDisplay'];
  const reducedFormatOptions = {};
  for (const [key, value] of Object.entries(formatOptions)) {
    if (unstableFormatOptionValues[key] && value === unstableFormatOptionValues[key]) {
      continue;
    }
    if (unstableFormatOptions.includes(key)) {
      continue;
    }
    reducedFormatOptions[key] = value;
  }
  try {
    return new Intl.NumberFormat(locale, reducedFormatOptions).format(number);
  } catch {
    return new Intl.NumberFormat(locale).format(number);
  }
}

/**
 * Flattens an array of strings into a string using the JS Internationalization List Format API.
 *
 * @since 1.23.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat|`options` parameter} For all available options.
 *
 * @param {Array}  list             The list to flatten.
 * @param {Object} [options]        Formatting options.
 * @param {string} [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @param {string} [options.style]  Length of the formatted message. Defaults to long.
 * @param {string} [options.type]   Type of list. Defaults to 'conjunction' (A, B, and C).
 *                                  Also available 'disjunction' (A, B, or C)
 *                                  Also available 'unit' (5 pounds, 12 ounces)
 * @return {string} The flattened list.
 */
function listFormat(list, options = {}) {
  const {
    locale = getLocale(),
    style = 'long',
    type = 'conjunction'
  } = options;

  // Not all browsers support Intl.Listformat per
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat#Browser_compatibility
  // We've seen that the built versions don't polyfill for the unsupported browsers (iOS/safari) so we provide a fallback.
  if (Intl.ListFormat) {
    const formatter = new Intl.ListFormat(locale, {
      style,
      type
    });
    return formatter.format(list);
  }

  /* translators: used between list items, there is a space after the comma. */
  const listSeparator = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(', ', 'google-site-kit');
  return list.join(listSeparator);
}

/**
 * Gets the current locale for use with browser APIs.
 *
 * @since 1.8.0
 *
 * @param {Object} _global The global window object.
 * @return {string} Current Site Kit locale if set, otherwise the current language set by the browser.
 *                  E.g. `en-US` or `de-DE`
 */
function getLocale(_global = __webpack_require__.g) {
  const siteKitLocale = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(_global, ['_googlesitekitLegacyData', 'locale']);
  if (siteKitLocale) {
    const matches = siteKitLocale.match(/^(\w{2})?(_)?(\w{2})/);
    if (matches && matches[0]) {
      return matches[0].replace(/_/g, '-');
    }
  }
  return _global.navigator.language;
}

/***/ }),

/***/ "./js/util/index.js":
/*!**************************!*\
  !*** ./js/util/index.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.WEEK_IN_SECONDS),
/* harmony export */   calculateChange: () => (/* binding */ calculateChange),
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.calculateDifferenceBetweenChartValues),
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertSecondsToArray),
/* harmony export */   createDurationFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.createDurationFormat),
/* harmony export */   dateSub: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.dateSub),
/* harmony export */   decodeHTMLEntity: () => (/* binding */ decodeHTMLEntity),
/* harmony export */   expandNumFmtOptions: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.expandNumFmtOptions),
/* harmony export */   getAvailableDateRanges: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getAvailableDateRanges),
/* harmony export */   getChartDifferenceArrow: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.getChartDifferenceArrow),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getDateString),
/* harmony export */   getFullURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getFullURL),
/* harmony export */   getLocale: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.getLocale),
/* harmony export */   getPreviousDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getPreviousDate),
/* harmony export */   getStorage: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.getStorage),
/* harmony export */   getURLPath: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getURLPath),
/* harmony export */   isHashOnly: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.isHashOnly),
/* harmony export */   isNumeric: () => (/* reexport safe */ _isnumeric__WEBPACK_IMPORTED_MODULE_12__.isNumeric),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.isSingleSlice),
/* harmony export */   isValidDateRange: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateRange),
/* harmony export */   isValidDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateString),
/* harmony export */   isValidNumericID: () => (/* reexport safe */ _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__.isValidNumericID),
/* harmony export */   listFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.listFormat),
/* harmony export */   markdownToHTML: () => (/* reexport safe */ _markdown__WEBPACK_IMPORTED_MODULE_6__.markdownToHTML),
/* harmony export */   normalizeURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.normalizeURL),
/* harmony export */   numFmt: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numFmt),
/* harmony export */   numberFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numberFormat),
/* harmony export */   partitionReport: () => (/* reexport safe */ _partition_report__WEBPACK_IMPORTED_MODULE_14__.partitionReport),
/* harmony export */   prepareForReadableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.readableLargeNumber),
/* harmony export */   safelySort: () => (/* reexport safe */ _safely_sort__WEBPACK_IMPORTED_MODULE_13__.safelySort),
/* harmony export */   sanitizeHTML: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML),
/* harmony export */   shortenURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.shortenURL),
/* harmony export */   storageAvailable: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.storageAvailable),
/* harmony export */   stringToDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.stringToDate),
/* harmony export */   stringifyObject: () => (/* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_3__.stringifyObject),
/* harmony export */   trackEvent: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEvent),
/* harmony export */   trackEventOnce: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEventOnce),
/* harmony export */   untrailingslashit: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.untrailingslashit),
/* harmony export */   validateJSON: () => (/* binding */ validateJSON)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sanitize */ "./js/util/sanitize.js");
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringify */ "./js/util/stringify.js");
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./storage */ "./js/util/storage.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./i18n */ "./js/util/i18n.js");
/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./markdown */ "./js/util/markdown.js");
/* harmony import */ var _convert_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./convert-time */ "./js/util/convert-time.js");
/* harmony import */ var _dates__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dates */ "./js/util/dates.js");
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart */ "./js/util/chart.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./urls */ "./js/util/urls.js");
/* harmony import */ var _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./is-valid-numeric-id */ "./js/util/is-valid-numeric-id.js");
/* harmony import */ var _isnumeric__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isnumeric */ "./js/util/isnumeric.js");
/* harmony import */ var _safely_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./safely-sort */ "./js/util/safely-sort.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./partition-report */ "./js/util/partition-report.js");
/**
 * Utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */
















/**
 * Calculates the change between two values.
 *
 * @since 1.24.0
 *
 * @param {number} previous The previous value.
 * @param {number} current  The current value.
 * @return {(number|null)} The percent change. Null if the input or output is invalid.
 */
function calculateChange(previous, current) {
  function isZero(value) {
    return value === '0' || value === 0;
  }

  // Prevent null result when both values are legitimately zero.
  if (isZero(previous) && isZero(current)) {
    return 0;
  }

  // Prevent divide by zero errors.
  if (isZero(previous) || Number.isNaN(previous)) {
    return null;
  }

  // Avoid NaN at all costs.
  const change = (current - previous) / previous;
  if (Number.isNaN(change) || !Number.isFinite(change)) {
    return null;
  }
  return change;
}

/**
 * Verifies whether JSON is valid.
 *
 * @since 1.0.0
 *
 * @param {string} stringToValidate The string to validate.
 * @return {boolean} Indicates JSON is valid.
 */
function validateJSON(stringToValidate) {
  try {
    return JSON.parse(stringToValidate) && !!stringToValidate;
  } catch (e) {
    return false;
  }
}

/**
 * Converts HTML text into an HTML entity.
 *
 * _.unescape doesn't seem to decode some entities for admin bar titles.
 * adding combination in this helper as a workaround.
 *
 * @since 1.0.0
 *
 * @param {string} str The string to decode.
 * @return {string} Decoded HTML entity.
 */
function decodeHTMLEntity(str) {
  if (!str) {
    return '';
  }
  const decoded = str.replace(/&#(\d+);/g, (match, dec) => {
    return String.fromCharCode(dec);
  }).replace(/(\\)/g, '');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(decoded);
}

/***/ }),

/***/ "./js/util/is-valid-numeric-id.js":
/*!****************************************!*\
  !*** ./js/util/is-valid-numeric-id.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidNumericID: () => (/* binding */ isValidNumericID)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks the given value to see if it is a positive integer.
 *
 * @since 1.11.0 Function introduced.
 * @since 1.90.0 Moved outside Tag Manager to a generic utility function.
 *
 * @param {*} input Value to check.
 * @return {boolean} Validity.
 */
function isValidNumericID(input) {
  const id = parseFloat(input) || 0;
  if (!Number.isInteger(id)) {
    return false;
  }
  return id > 0;
}

/***/ }),

/***/ "./js/util/isnumeric.js":
/*!******************************!*\
  !*** ./js/util/isnumeric.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNumeric: () => (/* binding */ isNumeric)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if a given value is numeric.
 *
 * @since 1.80.0
 *
 * @param {*} value The value to check.
 * @return {boolean} TRUE if a value is numeric FALSE otherwise.
 */
function isNumeric(value) {
  if (typeof value === 'number') {
    return true;
  }
  const string = (value || '').toString();
  if (!string) {
    return false;
  }
  return !isNaN(string);
}

/***/ }),

/***/ "./js/util/markdown.js":
/*!*****************************!*\
  !*** ./js/util/markdown.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   markdownToHTML: () => (/* binding */ markdownToHTML)
/* harmony export */ });
/**
 * Markdown utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Replaces markdown links with its HTML equivalents.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownLinks(text) {
  return text.replace(new RegExp('\\[([^\\]]+)\\]\\((https?://[^/]+\\.\\w+/?.*?)\\)', 'gi'), '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>');
}

/**
 * Adds paragraphs to the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownParagraphs(text) {
  return `<p>${text.replace(/\n{2,}/g, '</p><p>')}</p>`;
}

/**
 * Replaces line breaks in the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownBreaks(text) {
  return text.replace(/\n/gi, '<br>');
}

/**
 * Converts markdown to HTML.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} HTML version of the markdown text.
 */
function markdownToHTML(text) {
  const rules = [markdownLinks, markdownParagraphs, markdownBreaks];
  let html = text;
  for (const rule of rules) {
    html = rule(html);
  }
  return html;
}

/***/ }),

/***/ "./js/util/partition-report.js":
/*!*************************************!*\
  !*** ./js/util/partition-report.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionReport: () => (/* binding */ partitionReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report partitioning utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.33.0
 * @since 1.34.0 Updated to support incomplete `report` arrays.
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionReport(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');

  // Use a negative date range length for reverse slicing.
  const _dateRangeLength = -1 * dateRangeLength;
  return {
    // The current range should always be sliced from the end.
    currentRange: report.slice(_dateRangeLength),
    // The compare range continues from where the current left off (slicing towards the start),
    // and may be shorter (where older data is not available yet) which is fine.
    compareRange: report.slice(_dateRangeLength * 2, _dateRangeLength)
  };
}

/***/ }),

/***/ "./js/util/purify.js":
/*!***************************!*\
  !*** ./js/util/purify.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   purify: () => (/* binding */ purify)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "../node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

const purify = dompurify__WEBPACK_IMPORTED_MODULE_0___default()(__webpack_require__.g);

/***/ }),

/***/ "./js/util/safely-sort.js":
/*!********************************!*\
  !*** ./js/util/safely-sort.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safelySort: () => (/* binding */ safelySort)
/* harmony export */ });
/**
 * `safelySort` utility function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Sorts an array without causing the mutation if the given parameter is an array.
 * If the parameter is not an array, it returns the parameter as is.
 *
 * @since 1.110.0
 * @since 1.128.0 Moved to the common utility directory from the key metrics directory.
 *
 * @param {Array|*} arr Param to be sorted.
 * @return {Array|*} 	Safely sorted array without mutation.
 */
function safelySort(arr) {
  return Array.isArray(arr) ? [...arr].sort() : arr;
}

/***/ }),

/***/ "./js/util/sanitize.js":
/*!*****************************!*\
  !*** ./js/util/sanitize.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sanitizeHTML: () => (/* binding */ sanitizeHTML),
/* harmony export */   untrailingslashit: () => (/* binding */ untrailingslashit)
/* harmony export */ });
/* harmony import */ var _purify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./purify */ "./js/util/purify.js");
/**
 * Internal dependencies
 */

function sanitizeHTML(unsafeHTML, domPurifyConfig = {}) {
  return {
    __html: _purify__WEBPACK_IMPORTED_MODULE_0__.purify.sanitize(unsafeHTML, domPurifyConfig)
  };
}

/**
 * Takes a string or an URL object, removes the trailing slash if any and returns it.
 *
 * @since 1.20.0
 * @private
 *
 * @param {Object|string} url A string with or without trailing slash or an URL object.
 * @return {string|undefined} The URL string after removing the trailing slash.
 */
function untrailingslashit(url) {
  const originalURL = typeof url === 'object' ? url.toString() : url;
  return originalURL?.replace?.(/\/+$/, '');
}

/***/ }),

/***/ "./js/util/storage.js":
/*!****************************!*\
  !*** ./js/util/storage.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   storageAvailable: () => (/* binding */ storageAvailable)
/* harmony export */ });
/**
 * Storage abstraction.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.0.0
 *
 * @param {string} type Browser storage to test. ex localStorage or sessionStorage.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
function storageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

// Custom no-op implementation of window.Storage.
class NullStorage {
  get length() {
    return 0;
  }
  key() {
    return null;
  }
  getItem() {
    return null;
  }
  setItem() {
    // Empty method body.
  }
  removeItem() {
    // Empty method body.
  }
  clear() {
    // Empty method body.
  }
}
let storageObj;

/**
 * Gets the storage object to use.
 *
 * @since 1.0.0
 *
 * @return {Storage} Either window.sessionStorage, window.localStorage', or a
 *                   no-op implementation if neither is available.
 */
function getStorage() {
  // Only run the logic to determine the storage object once.
  if (!storageObj) {
    if (storageAvailable('sessionStorage')) {
      storageObj = __webpack_require__.g.sessionStorage;
    } else if (storageAvailable('localStorage')) {
      storageObj = __webpack_require__.g.localStorage;
    } else {
      storageObj = new NullStorage();
    }
  }
  return storageObj;
}

/***/ }),

/***/ "./js/util/stringify.js":
/*!******************************!*\
  !*** ./js/util/stringify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyObject: () => (/* binding */ stringifyObject)
/* harmony export */ });
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Stringify function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Transforms an object into a hash string.
 *
 * This function can be used to e.g. generate cache keys, based on the given
 * object. Object properties are sorted, so even if they are provided in
 * different order, the hash will match. The function furthermore supports
 * nested objects.
 *
 * @since 1.7.0
 *
 * @param {Object} obj The object to stringify.
 * @return {string} Hash for the object.
 */
function stringifyObject(obj) {
  return md5__WEBPACK_IMPORTED_MODULE_0___default()(JSON.stringify(sortObjectProperties(obj)));
}
function sortObjectProperties(obj) {
  const orderedData = {};
  Object.keys(obj).sort().forEach(key => {
    let val = obj[key];
    if (val && 'object' === typeof val && !Array.isArray(val)) {
      val = sortObjectProperties(val);
    }
    orderedData[key] = val;
  });
  return orderedData;
}

/***/ }),

/***/ "./js/util/tracking/constants.js":
/*!***************************************!*\
  !*** ./js/util/tracking/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_LAYER: () => (/* binding */ DATA_LAYER),
/* harmony export */   SCRIPT_IDENTIFIER: () => (/* binding */ SCRIPT_IDENTIFIER)
/* harmony export */ });
/**
 * Constants related to event tracking.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Data layer global used for internal/private Site Kit data.
 *
 * @since 1.8.0
 * @private
 */
const DATA_LAYER = '_googlesitekitDataLayer';

/**
 * The `gtag` `<script>` identifier.
 *
 * @since 1.8.0
 * @private
 */
const SCRIPT_IDENTIFIER = 'data-googlesitekit-gtag';

/***/ }),

/***/ "./js/util/tracking/createDataLayerPush.js":
/*!*************************************************!*\
  !*** ./js/util/tracking/createDataLayerPush.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createDataLayerPush)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked will initialize the dataLayer and push data onto it.
 *
 * @since 1.3.0
 *
 * @param {Object} target Object to enhance with dataLayer data.
 * @return {Function} Function that pushes data onto the dataLayer.
 */
function createDataLayerPush(target) {
  /**
   * Pushes data onto the data layer.
   *
   * Must push an instance of Arguments to the target.
   * Using an ES6 spread operator (i.e. `...args`) will cause tracking events to
   * _silently_ fail.
   *
   * @since 1.0.0
   * @see {@link https://github.com/google/site-kit-wp/issues/1181}
   */
  return function dataLayerPush() {
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] = target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] || [];
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER].push(arguments);
  };
}

/***/ }),

/***/ "./js/util/tracking/createInitializeSnippet.js":
/*!*****************************************************!*\
  !*** ./js/util/tracking/createInitializeSnippet.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createInitializeSnippet)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/* harmony import */ var _js_features_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/features/index */ "./js/features/index.js");
/**
 * Internal dependencies
 */




/**
 * Returns a function which, when invoked injects the gtag script if necessary.
 *
 * @since 1.44.0
 *
 * @param {Object} config          Tracking configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @return {Function} Function that injects gtag script if it isn't yet present.
 */
function createInitializeSnippet(config, dataLayerTarget) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);
  let hasInsertedTag;
  const {
    activeModules,
    referenceSiteURL,
    userIDHash,
    userRoles = [],
    isAuthenticated,
    pluginVersion
  } = config;

  /**
   * Injects the necessary script tag if not present.
   *
   * @since 1.118.0
   *
   * @return {boolean|Object} Tag src as scriptTagSrc property.
   */
  return function initializeSnippet() {
    const {
      document
    } = __webpack_require__.g;
    if (undefined === hasInsertedTag) {
      hasInsertedTag = !!document.querySelector(`script[${_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER}]`);
    }
    if (hasInsertedTag) {
      return false;
    }
    hasInsertedTag = true;

    // Sometimes the user roles returned by Site Kit/WordPress is not an
    // array, as expected, so we guard against it here.
    //
    // See: https://github.com/google/site-kit-wp/issues/8266
    const userRolesAsString = userRoles?.length ? userRoles.join(',') : '';

    // We should use the real time, and not the reference date, when
    // measuring when we initialized tracking.
    dataLayerPush('js', new Date()); // eslint-disable-line sitekit/no-direct-date
    dataLayerPush('config', config.trackingID, {
      groups: 'site_kit',
      send_page_view: config.isSiteKitScreen,
      domain: referenceSiteURL,
      plugin_version: pluginVersion || '',
      enabled_features: Array.from(_js_features_index__WEBPACK_IMPORTED_MODULE_2__.enabledFeatures).join(','),
      active_modules: activeModules.join(','),
      authenticated: isAuthenticated ? '1' : '0',
      user_properties: {
        user_roles: userRolesAsString,
        user_identifier: userIDHash
      }
    });

    // If not present, inject it and initialize dataLayer.
    const scriptTag = document.createElement('script');
    scriptTag.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER, '');
    scriptTag.async = true;
    scriptTag.src = `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`;
    document.head.appendChild(scriptTag);
    return {
      scriptTagSrc: `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`
    };
  };
}

/***/ }),

/***/ "./js/util/tracking/createTrackEvent.js":
/*!**********************************************!*\
  !*** ./js/util/tracking/createTrackEvent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTrackEvent)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked tracks a single event.
 *
 * @since 1.3.0
 *
 * @param {Object}   config            Tracking configuration.
 * @param {Object}   dataLayerTarget   Data layer parent object.
 * @param {Function} initializeSnippet Function to initialize tracking.
 * @param {Object}   _global           The global window object.
 * @return {Function} Function that tracks an event.
 */
function createTrackEvent(config, dataLayerTarget, initializeSnippet, _global) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);

  /**
   * Send an Analytics tracking event.
   *
   * @since 1.3.0
   *
   * @param {string} category The category of the event.
   * @param {string} action   The action name of the event.
   * @param {string} [label]  Optional. The label of the event.
   * @param {number} [value]  Optional. A non-negative integer that will appear as the event value.
   * @return {Promise} Promise that always resolves.
   */
  // eslint-disable-next-line require-await
  return async function trackEvent(category, action, label, value) {
    const {
      trackingEnabled
    } = config;
    if (!trackingEnabled) {
      // Resolve immediately if tracking is disabled.
      return null;
    }
    initializeSnippet();
    const eventData = {
      send_to: 'site_kit',
      event_category: category,
      event_label: label,
      value
    };
    return new Promise(resolve => {
      // This timeout ensures a tracking event does not block the user
      // event if it is not sent (in time).
      // If the event beacon fails, it shouldn't reject the promise since event
      // tracking should not result in user-facing errors. It will just
      // trigger a console warning.
      function failCallback() {
        _global.console.warn(`Tracking event "${action}" (category "${category}") took too long to fire.`);
        resolve();
      }
      const failTimeout = setTimeout(failCallback, 1000);
      // eslint-disable-next-line camelcase
      function event_callback() {
        clearTimeout(failTimeout);
        resolve();
      }
      dataLayerPush('event', action, {
        ...eventData,
        event_callback
      });

      // If the client-side opt-out is present, the event_callback will never be called
      // so we call it here to prevent the warning and added delay.
      if (_global._gaUserPrefs?.ioo?.()) {
        event_callback();
      }
    });
  };
}

/***/ }),

/***/ "./js/util/tracking/createTracking.js":
/*!********************************************!*\
  !*** ./js/util/tracking/createTracking.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTracking)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createInitializeSnippet */ "./js/util/tracking/createInitializeSnippet.js");
/* harmony import */ var _createTrackEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createTrackEvent */ "./js/util/tracking/createTrackEvent.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const DEFAULT_CONFIG = {
  activeModules: [],
  isAuthenticated: false,
  referenceSiteURL: '',
  trackingEnabled: false,
  trackingID: '',
  userIDHash: '',
  userRoles: []
};

/**
 * Initializes tracking.
 *
 * @since 1.3.0
 *
 * @param {Object} newConfig       New configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @param {Object} _global         The global window object.
 * @return {Object} Tracking config.
 */
function createTracking(newConfig, dataLayerTarget = __webpack_require__.g, _global = __webpack_require__.g) {
  const config = {
    ...DEFAULT_CONFIG,
    ...newConfig
  };
  // Remove any trailing slash from the reference URL.
  if (config.referenceSiteURL) {
    config.referenceSiteURL = config.referenceSiteURL.toString().replace(/\/+$/, '');
  }
  const initializeSnippet = (0,_createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__["default"])(config, dataLayerTarget);
  const trackEvent = (0,_createTrackEvent__WEBPACK_IMPORTED_MODULE_2__["default"])(config, dataLayerTarget, initializeSnippet, _global);
  const onceTrackedEventsMap = {};
  function trackEventOnce(...params) {
    const key = JSON.stringify(params);
    if (!onceTrackedEventsMap[key]) {
      onceTrackedEventsMap[key] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.once)(trackEvent);
    }
    onceTrackedEventsMap[key](...params);
  }
  return {
    enableTracking: function enableTracking() {
      config.trackingEnabled = true;
    },
    disableTracking: function disableTracking() {
      config.trackingEnabled = false;
    },
    initializeSnippet,
    isTrackingEnabled: function isTrackingEnabled() {
      return !!config.trackingEnabled;
    },
    trackEvent,
    trackEventOnce
  };
}

/***/ }),

/***/ "./js/util/tracking/index.js":
/*!***********************************!*\
  !*** ./js/util/tracking/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTracking: () => (/* binding */ disableTracking),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   isTrackingEnabled: () => (/* binding */ isTrackingEnabled),
/* harmony export */   toggleTracking: () => (/* binding */ toggleTracking),
/* harmony export */   trackEvent: () => (/* binding */ trackEvent),
/* harmony export */   trackEventOnce: () => (/* binding */ trackEventOnce)
/* harmony export */ });
/* harmony import */ var _createTracking__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createTracking */ "./js/util/tracking/createTracking.js");
/**
 * Event tracking utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * Internal dependencies
 */

const {
  activeModules = [],
  isSiteKitScreen,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isAuthenticated,
  userRoles
} = __webpack_require__.g._googlesitekitTrackingData || {};

// Access the plugin version directly without destructuring as Webpack's DefinePlugin
// performs text replacement at build time and doesn't support destructuring patterns.
// See: https://github.com/google/site-kit-wp/issues/11802#issuecomment-3562955579
const pluginVersion = "1.167.0";
const initialConfig = {
  activeModules,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isSiteKitScreen,
  userRoles,
  isAuthenticated,
  pluginVersion
};
const {
  enableTracking,
  disableTracking,
  isTrackingEnabled,
  initializeSnippet,
  trackEvent,
  trackEventOnce
} = (0,_createTracking__WEBPACK_IMPORTED_MODULE_0__["default"])(initialConfig);

/**
 * Changes the active state of tracking.
 *
 * @since 1.3.0
 *
 * @param {boolean} activeStatus The new state to set.
 */
function toggleTracking(activeStatus) {
  if (!!activeStatus) {
    enableTracking();
  } else {
    disableTracking();
  }
}

// Bootstrap on import if tracking is allowed.
if (isSiteKitScreen && trackingEnabled) {
  initializeSnippet();
}


/***/ }),

/***/ "./js/util/urls.js":
/*!*************************!*\
  !*** ./js/util/urls.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFullURL: () => (/* binding */ getFullURL),
/* harmony export */   getURLPath: () => (/* binding */ getURLPath),
/* harmony export */   isHashOnly: () => (/* binding */ isHashOnly),
/* harmony export */   normalizeURL: () => (/* binding */ normalizeURL),
/* harmony export */   shortenURL: () => (/* binding */ shortenURL)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/**
 * URL pathname getter utility function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the path from a URL, omitting its protocol, hostname, query params, and hash.
 *
 * @since 1.24.0
 *
 * @param {string} url The URL to get the path from.
 * @return {string} The URL path.
 */
function getURLPath(url) {
  try {
    return new URL(url).pathname;
  } catch {}
  return null;
}

/**
 * Returns the absolute URL from a path including the siteURL.
 *
 * @since 1.32.0
 *
 * @param {string} siteURL The siteURL fo the WordPress install.
 * @param {string} path    The path.
 * @return {string} The URL path.
 */
function getFullURL(siteURL, path) {
  try {
    return new URL(path, siteURL).href;
  } catch {}
  return (typeof siteURL === 'string' ? siteURL : '') + (typeof path === 'string' ? path : '');
}

/**
 * Normalizes URL by removing protocol, www subdomain and trailing slash.
 *
 * @since 1.33.0
 *
 * @param {string} incomingURL The original URL.
 * @return {string} Normalized URL.
 */
function normalizeURL(incomingURL) {
  if (typeof incomingURL !== 'string') {
    return incomingURL;
  }
  return incomingURL
  // Remove protocol and optional "www." prefix from the URL.
  .replace(/^https?:\/\/(www\.)?/i, '')
  // Remove trailing slash.
  .replace(/\/$/, '');
}

/**
 * Checks if a string is not a full URL and simply a hash / anchor link.
 *
 * @since 1.49.0
 *
 * @param {string} url The URL or Hash string to test.
 * @return {boolean} Returns true if the string is only a hash and not a full URL.
 */
function isHashOnly(url) {
  return /^#\w[A-Za-z0-9-_]*$/.test(url);
}

/**
 * Shortens a URL to fit a given length.
 *
 * @since 1.49.0
 *
 * @param {string} url      The original URL to shorten.
 * @param {number} maxChars The maximum length of the URL.
 * @return {string} The shortened URL.
 */
function shortenURL(url, maxChars) {
  if (!(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.isURL)(url)) {
    return url;
  }
  if (url.length <= maxChars) {
    return url;
  }
  const urlObject = new URL(url);
  const shortenedURL = url.replace(urlObject.origin, '');
  if (shortenedURL.length < maxChars) {
    return shortenedURL;
  }
  const extraChars = shortenedURL.length - Math.floor(maxChars) + 1; // 1 is the length of "…".
  return '…' + shortenedURL.substr(extraChars);
}

/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.i18n;

/***/ }),

/***/ "googlesitekit-data":
/*!*****************************************!*\
  !*** external ["googlesitekit","data"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.data;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-datastore-ui.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-datastore-ui.js.map