"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-modules-ads"],{

/***/ "./js/api-fetch-shim.js":
/*!******************************!*\
  !*** ./js/api-fetch-shim.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch__non-shim */ "../node_modules/@wordpress/api-fetch/build/index.js");
/* harmony import */ var _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/api/middleware/preloading.js */ "./js/googlesitekit/api/middleware/preloading.js");
/* harmony import */ var _js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/api/middleware/deduplication */ "./js/googlesitekit/api/middleware/deduplication.ts");
/* harmony reexport (unknown) */ var __WEBPACK_REEXPORT_OBJECT__ = {};
/* harmony reexport (unknown) */ for(const __WEBPACK_IMPORT_KEY__ in _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== "default") __WEBPACK_REEXPORT_OBJECT__[__WEBPACK_IMPORT_KEY__] = () => _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__[__WEBPACK_IMPORT_KEY__]
/* harmony reexport (unknown) */ __webpack_require__.d(__webpack_exports__, __WEBPACK_REEXPORT_OBJECT__);
/**
 * API Fetch Shim.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const {
  nonce,
  nonceEndpoint,
  preloadedData,
  rootURL
} = __webpack_require__.g._googlesitekitAPIFetchData || {};
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceEndpoint) = nonceEndpoint;
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceMiddleware) = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().createNonceMiddleware(nonce);
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().rootURLMiddleware) = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().createRootURLMiddleware(rootURL);
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().dedupeMiddleware) = (0,_js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_2__["default"])({
  onDuplicate: _js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_2__.logDuplicate
});
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().preloadingMiddleware) = (0,_googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_1__["default"])(preloadedData);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().mediaUploadMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().rootURLMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().dedupeMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().preloadingMiddleware));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default()));

/***/ }),

/***/ "./js/components/AdminScreenTooltip/AdminScreenTooltip.js":
/*!****************************************************************!*\
  !*** ./js/components/AdminScreenTooltip/AdminScreenTooltip.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminScreenTooltip: () => (/* binding */ AdminScreenTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/JoyrideTooltip */ "./js/components/JoyrideTooltip.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdminMenuTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function AdminScreenTooltip() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.useBreakpoint)();
  const {
    isTooltipVisible = false,
    target,
    placement,
    className,
    tooltipSlug,
    title,
    content,
    dismissLabel
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue('admin-screen-tooltip') || {
    isTooltipVisible: false
  });
  function handleViewTooltip() {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_view');
  }
  const handleDismissTooltip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    // Track dismiss event.
    if (tooltipSlug) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_dismiss');
    }
    setValue('admin-screen-tooltip', undefined);
  }, [setValue, tooltipSlug, viewContext]);
  if (!isTooltipVisible) {
    return null;
  }
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_5__.BREAKPOINT_TABLET;
  const desktopTarget = target !== null && target !== void 0 ? target : '#adminmenu [href*="page=googlesitekit-settings"]';
  const desktopPlacement = placement !== null && placement !== void 0 ? placement : 'right';
  function desktopClassName() {
    if (className) {
      return className;
    }
    return !target ? 'googlesitekit-tour-tooltip__fixed-settings-tooltip' : undefined;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
    target: isMobileTablet ? 'body' : desktopTarget,
    placement: isMobileTablet ? 'center' : desktopPlacement,
    className: isMobileTablet ? 'googlesitekit-tour-tooltip__modal_step' : desktopClassName(),
    disableOverlay: !isMobileTablet,
    slug: "admin-screen-tooltip",
    title: title,
    content: content,
    dismissLabel: dismissLabel,
    onView: handleViewTooltip,
    onDismiss: handleDismissTooltip
  });
}

/***/ }),

/***/ "./js/components/AdminScreenTooltip/index.js":
/*!***************************************************!*\
  !*** ./js/components/AdminScreenTooltip/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminScreenTooltip: () => (/* reexport safe */ _AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_1__.AdminScreenTooltip),
/* harmony export */   useShowTooltip: () => (/* reexport safe */ _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__.useShowTooltip)
/* harmony export */ });
/* harmony import */ var _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useShowTooltip */ "./js/components/AdminScreenTooltip/useShowTooltip.js");
/* harmony import */ var _AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AdminScreenTooltip */ "./js/components/AdminScreenTooltip/AdminScreenTooltip.js");



/***/ }),

/***/ "./js/components/AdminScreenTooltip/useShowTooltip.js":
/*!************************************************************!*\
  !*** ./js/components/AdminScreenTooltip/useShowTooltip.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useShowTooltip: () => (/* binding */ useShowTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");



function useShowTooltip(tooltipSettings) {
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI);
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
    setValue('admin-screen-tooltip', {
      isTooltipVisible: true,
      ...tooltipSettings
    });
  }, [setValue, tooltipSettings]);
}

/***/ }),

/***/ "./js/components/Badge.js":
/*!********************************!*\
  !*** ./js/components/Badge.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Badge component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Badge = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  label,
  className,
  hasLeftSpacing = false,
  ...rest
}, ref) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
  ref: ref,
  ...rest,
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge', className, {
    'googlesitekit-badge--has-left-spacing': hasLeftSpacing
  }),
  children: label
}));
Badge.displayName = 'Badge';
Badge.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);

/***/ }),

/***/ "./js/components/Banner/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton({
  label,
  ariaLabel,
  disabled,
  inProgress,
  onClick,
  href,
  external = false,
  hideExternalIndicator = false
}) {
  if (!label || !onClick && !href) {
    return null;
  }
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-banner__cta",
    "aria-label": ariaLabel,
    disabled: disabled || inProgress,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : undefined,
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ariaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  dismissOnClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Banner/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Description({
  className,
  description,
  learnMoreLink,
  additionalDescription,
  children
}) {
  function renderDescription() {
    if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.isValidElement)(description)) {
      return description;
    }
    if ('string' === typeof description) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.sanitizeHTML)(description, {
          ALLOWED_TAGS: ['strong', 'em', 'br', 'a'],
          ALLOWED_ATTR: ['href']
        })
      });
    }
    return description;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__description', className),
    children: [renderDescription(), ' ', learnMoreLink?.href && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...learnMoreLink
    }), additionalDescription && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-banner__additional-description",
      children: additionalDescription
    }), children]
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"].propTypes),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};

/***/ }),

/***/ "./js/components/Banner/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled,
  tertiary = true
}) {
  if (!onClick) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: className,
    onClick: onClick,
    disabled: disabled,
    tertiary: tertiary,
    children: label
  });
}
DismissButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Footer.js":
/*!****************************************!*\
  !*** ./js/components/Banner/Footer.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Footer({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__footer', className),
    children: children
  });
}
Footer.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/HelpText.js":
/*!******************************************!*\
  !*** ./js/components/Banner/HelpText.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HelpText)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function HelpText({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__help-text', className),
    children: children
  });
}
HelpText.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/LearnMoreLink.tsx":
/*!************************************************!*\
  !*** ./js/components/Banner/LearnMoreLink.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* provided dependency */ var React = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/index.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

/**
 * Renders a "Learn More" link component, usually used to append "Learn more" with a
 * specified URL to content like a paragraph.
 *
 * @since 1.153.0
 *
 * @param props            The props for the component.
 * @param props.className  The class name for the link.
 * @param [props.external] Whether the link is external. Optional, defaults to true.
 * @param props.href       The URL for the link.
 * @param props.label      The label for the link.
 * @param [props.onClick]  The function to call when the link is clicked. Optional, defaults to an empty function.
 * @return The rendered component.
 */
const LearnMoreLink = ({
  className,
  external = true,
  href,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
  onClick = () => {}
}) => {
  // Return null if no href is provided.
  //
  // This arguably shouldn't be optional, but until all usage of this
  // component are via typed code, we need this safeguard.
  if (!href) {
    return null;
  }
  return (
    /*#__PURE__*/
    // @ts-expect-error `Link` component is not currently typed, so this
    // results in an error because we're supplying a `children` prop.
    React.createElement(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      href: href,
      className: className,
      onClick: onClick,
      external: external
    }, label)
  );
};
LearnMoreLink.propTypes = {
  href: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LearnMoreLink);

/***/ }),

/***/ "./js/components/Banner/Title.js":
/*!***************************************!*\
  !*** ./js/components/Banner/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/TitleIcon.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/TitleIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TitleIcon)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function TitleIcon({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title-icon', className),
    children: children
  });
}
TitleIcon.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/index.js":
/*!***************************************!*\
  !*** ./js/components/Banner/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _TitleIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TitleIcon */ "./js/components/Banner/TitleIcon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Title */ "./js/components/Banner/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Description */ "./js/components/Banner/Description.js");
/* harmony import */ var _HelpText__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./HelpText */ "./js/components/Banner/HelpText.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Footer */ "./js/components/Banner/Footer.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











const Banner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.forwardRef)(({
  className,
  titleIcon,
  title,
  description,
  additionalDescription,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  // NOTE: SVGs must be imported with the ?url suffix for use as a backgroundImage in this component.
  footer
}, ref) => {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const isMobileOrTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET;
  let SVGData = null;
  if (isMobileOrTablet && svg?.mobile) {
    SVGData = svg.mobile;
  } else if (!isMobileOrTablet && svg?.desktop) {
    SVGData = svg.desktop;
  }
  const svgMode = svg?.verticalPosition ? svg.verticalPosition : 'center';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-banner__content",
      children: [titleIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_TitleIcon__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: titleIcon
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_4__["default"], {
        description: description,
        learnMoreLink: learnMoreLink,
        additionalDescription: additionalDescription
      }), helpText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpText__WEBPACK_IMPORTED_MODULE_5__["default"], {
        children: helpText
      }), errorText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"], {
        type: "error",
        description: errorText
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-notice__action",
        children: [ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_7__["default"], {
          ...ctaButton
        }), dismissButton?.onClick && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_8__["default"], {
          ...dismissButton
        })]
      })]
    }), SVGData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__svg-wrapper', {
        [`googlesitekit-banner__svg-wrapper--${svgMode}`]: svgMode
      }),
      style: {
        backgroundImage: `url(${SVGData})`
      }
    }), footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_9__["default"], {
      children: footer
    })]
  });
});
Banner.propTypes = {
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_8__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_CTAButton__WEBPACK_IMPORTED_MODULE_7__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Banner);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/DisplaySetting.js":
/*!*****************************************!*\
  !*** ./js/components/DisplaySetting.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BLANK_SPACE: () => (/* binding */ BLANK_SPACE),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);
/**
 * DisplaySetting component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const BLANK_SPACE = '\u00A0';
function DisplaySetting({
  value
}) {
  return value || BLANK_SPACE;
}
DisplaySetting.propTypes = {
  value: prop_types__WEBPACK_IMPORTED_MODULE_0___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_0___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_0___default().number)])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DisplaySetting);

/***/ }),

/***/ "./js/components/ErrorNotice.js":
/*!**************************************!*\
  !*** ./js/components/ErrorNotice.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorNotice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ErrorNotice({
  className,
  error,
  hasButton = false,
  storeName,
  message = error.message,
  noPrefix = false,
  skipRetryMessage,
  hideIcon = false
}) {
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const selectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!storeName) {
      return null;
    }
    return select(storeName).getSelectorDataForError(error);
  });
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
  }, [dispatch, selectorData]);

  // Do not display if there is no error and no direct message text is passed as a direct prop.
  // Also do not display if the error is for missing scopes as these are handled by a popup modal.
  if (!message || (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isPermissionScopeError)(error)) {
    return null;
  }
  const shouldDisplayRetry = hasButton && (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isErrorRetryable)(error, selectorData);

  /**
   * Error message to display to the user. Sometimes we append a retry message
   * or a reconnect URL, so we create a new variable for the message to display.
   */
  let errorMessageWithModifications = message;

  // Append "Try again" messaging if no retry button is present.
  if (!hasButton && !skipRetryMessage) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message from Google API. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s (Please try again.)', 'google-site-kit'), errorMessageWithModifications);
  }
  if (!noPrefix) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: $%s: Error message */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), errorMessageWithModifications);
  }
  const reconnectURL = error?.data?.reconnectURL;
  if (reconnectURL && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.isURL)(reconnectURL)) {
    /**
     * This error message uses HTML tags without using
     * `createInterpolateElement` because the error messages
     * that come from the server/API can also contain HTML (eg. links)
     * we want to render.
     *
     * Instead of creating a React node using `createInterpolateElement`,
     * we use `dangerouslySetInnerHTML` to allow the HTML we create and from
     * the server/API to be rendered as-intended.
     */
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Original error message 2: Reconnect URL */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s To fix this, <a href="%2$s">redo the plugin setup</a>.', 'google-site-kit'), errorMessageWithModifications, reconnectURL);
  }
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a'],
    ALLOWED_ATTR: ['href']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    type: _Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.ERROR,
    description:
    /*#__PURE__*/
    // The error messages that come from the server/API can contain
    // HTML (eg. links), so we use `dangerouslySetInnerHTML` and sanitize
    // the HTML to render these links.
    //
    // We tried to use `createInterpolateElement` but it does not work
    // with HTML tags that come from the server/API.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.sanitizeHTML)(errorMessageWithModifications, sanitizeArgs)
    }),
    ctaButton: shouldDisplayRetry ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit'),
      onClick: handleRetry
    } : undefined,
    hideIcon: hideIcon
  });
}
ErrorNotice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  error: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }),
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/FeaturesProvider/FeaturesContext.js":
/*!***********************************************************!*\
  !*** ./js/components/FeaturesProvider/FeaturesContext.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Feature Flags context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const FeaturesContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createContext)(_js_features__WEBPACK_IMPORTED_MODULE_0__.enabledFeatures);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturesContext);

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/InViewProvider/InViewContext.js":
/*!*******************************************************!*\
  !*** ./js/components/InViewProvider/InViewContext.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * InView context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const InViewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)(false);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewContext);

/***/ }),

/***/ "./js/components/JoyrideTooltip.js":
/*!*****************************************!*\
  !*** ./js/components/JoyrideTooltip.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ JoyrideTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useInterval.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var _TourTooltips__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TourTooltips */ "./js/components/TourTooltips.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * JoyRideTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function JoyrideTooltip(props) {
  const {
    title,
    content,
    dismissLabel,
    disableOverlay = true,
    target,
    cta = false,
    className,
    styles = {},
    slug = '',
    placement = 'auto',
    onDismiss = () => {},
    onView = () => {},
    onTourStart = () => {},
    onTourEnd = () => {}
  } = props;
  function checkIfTargetExists() {
    return !!__webpack_require__.g.document.querySelector(target);
  }
  const [targetExists, setTargetExists] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(checkIfTargetExists);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.useBreakpoint)();
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_TABLET;
  const [shouldRun, setShouldRun] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(true);
  const previousIsMobileTabletRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useRef)(isMobileTablet);
  (0,react_use__WEBPACK_IMPORTED_MODULE_6__["default"])(() => {
    if (checkIfTargetExists()) {
      setTargetExists(true);
    }
  },
  // An delay of null will stop the interval.
  targetExists ? null : 250);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    // eslint-disable-next-line sitekit/function-declaration-consistency
    let disconnect = () => {};
    if (typeof __webpack_require__.g.ResizeObserver === 'function') {
      const targetElement = __webpack_require__.g.document.querySelector(target);
      if (targetElement) {
        const resizeObserver = new ResizeObserver(() => {
          // Dispatch a window resize event to trigger the tooltip to reposition.
          __webpack_require__.g.dispatchEvent(new Event('resize'));
        });
        resizeObserver.observe(targetElement);
        disconnect = () => resizeObserver.disconnect();
      }
    }
    return disconnect;
  }, [target, targetExists]);

  // Reset the component between mobile and desktop layouts they use different
  // targets which requires the tooltip to be re-rendered to display correctly.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    let timeoutID;
    if (previousIsMobileTabletRef.current !== isMobileTablet) {
      setShouldRun(false);
      timeoutID = setTimeout(() => {
        setShouldRun(true);
      }, 50);
      previousIsMobileTabletRef.current = isMobileTablet;
    }
    return () => {
      if (timeoutID) {
        clearTimeout(timeoutID);
      }
    };
  }, [isMobileTablet]);

  // Joyride expects the step's target to be in the DOM immediately
  // so we need to wait for it in some cases, e.g. loading data.
  if (!targetExists) {
    return null;
  }
  const steps = [{
    title,
    target,
    content,
    disableBeacon: true,
    isFixed: true,
    placement,
    cta,
    className
  }];

  // Provides button content as well as aria-label & title attribute values.
  const joyrideLocale = {
    close: dismissLabel,
    last: dismissLabel
  };
  function callback({
    type
  }) {
    switch (type) {
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_START:
        onTourStart();
        __webpack_require__.g.document.body.classList.add('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_END:
        onTourEnd();
        __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.STEP_AFTER:
        // This is not strictly necessary as the tooltip will hide without it,
        // but this allows the consumer of the component to clean up
        // post-dismiss.
        onDismiss();
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOOLTIP:
        onView();
        break;
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Portal__WEBPACK_IMPORTED_MODULE_1__["default"], {
    slug: slug,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_7__["default"], {
      callback: callback,
      disableOverlay: disableOverlay,
      spotlightPadding: 0,
      floaterProps: _TourTooltips__WEBPACK_IMPORTED_MODULE_2__.floaterProps,
      locale: joyrideLocale,
      steps: steps,
      styles: {
        ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles,
        ...styles,
        options: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles.options,
          ...styles?.options
        },
        spotlight: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_2__.joyrideStyles.spotlight,
          ...styles?.spotlight
        }
      },
      tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_0__["default"],
      run: shouldRun,
      disableScrolling: true
    })
  });
}
JoyrideTooltip.propTypes = {
  title: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.node,
  content: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  disableOverlay: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.bool,
  dismissLabel: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  target: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string.isRequired,
  onDismiss: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  onShow: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  className: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  styles: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.object,
  slug: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  placement: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  onView: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func
};

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/LoadingWrapper.js":
/*!*****************************************!*\
  !*** ./js/components/LoadingWrapper.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LoadingWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _PreviewBlock__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * LoadingWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function LoadingWrapper({
  loading,
  children,
  ...previewBlockProps
}) {
  if (loading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"], {
      ...previewBlockProps
    });
  }
  return children;
}
LoadingWrapper.propTypes = {
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node),
  ..._PreviewBlock__WEBPACK_IMPORTED_MODULE_0__["default"].propTypes
};

/***/ }),

/***/ "./js/components/ModalDialog.js":
/*!**************************************!*\
  !*** ./js/components/ModalDialog.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/warning.svg */ "./svg/icons/warning.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function ModalDialog({
  className = '',
  dialogActive = false,
  handleCancel = null,
  onOpen = null,
  onClose = null,
  title = null,
  provides,
  handleConfirm,
  subtitle,
  confirmButton = null,
  notes = [],
  danger = false,
  inProgress = false,
  small = false,
  medium = false,
  buttonLink = null
}) {
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__["default"])(ModalDialog);
  const describedByID = `googlesitekit-dialog-description-${instanceID}`;
  const hasProvides = !!(provides && provides.length);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Dialog, {
    open: dialogActive,
    onOpen: onOpen,
    onClose: onClose,
    "aria-describedby": hasProvides ? describedByID : undefined,
    tabIndex: "-1",
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, {
      'googlesitekit-dialog-sm': small,
      'googlesitekit-dialog-md': medium
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, {
      children: [danger && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        width: 28,
        height: 28
      }), title]
    }),
    // Ensure we don't render anything at all if subtitle is falsy, as Dialog expects all its children to be elements and a falsy value will result in an error.
    subtitle ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "mdc-dialog__lead",
      children: subtitle
    }) : [], /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogContent, {
      children: [hasProvides && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("section", {
        id: describedByID,
        className: "mdc-dialog__provides",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("ul", {
          className: "mdc-list mdc-list--underlined mdc-list--non-interactive",
          children: provides.map(attribute => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("li", {
            className: "mdc-list-item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "mdc-list-item__text",
              children: attribute
            })
          }, attribute))
        })
      }), notes.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("section", {
        className: "mdc-dialog__notes",
        children: notes.map((Note, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("p", {
          className: "mdc-dialog__note",
          children: [typeof Note === 'string' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s is replaced with some sub-note text. */
          (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('<strong>Note:</strong> %s', 'google-site-kit'), Note), {
            strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
          }), typeof Note === 'function' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Note, {})]
        }, `note-${index}`))
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogFooter, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        className: "mdc-dialog__cancel-button",
        onClick: handleCancel,
        disabled: inProgress,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
      }), buttonLink ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        href: buttonLink,
        onClick: handleConfirm,
        target: "_blank",
        danger: danger,
        children: confirmButton
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
        onClick: handleConfirm,
        danger: danger,
        disabled: inProgress,
        isSaving: inProgress,
        children: confirmButton || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Disconnect', 'google-site-kit')
      })]
    })]
  });
}
ModalDialog.displayName = 'Dialog';
ModalDialog.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  handleDialog: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  handleConfirm: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  provides: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)),
  confirmButton: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  notes: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType)])),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  medium: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  buttonLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModalDialog);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external = false,
  hideExternalIndicator = false
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__cta', {
      'googlesitekit-notice__cta--spinner__running': inProgress
    }),
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : undefined,
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  INFO_ALT: 'info-alt',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
    children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-notice__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        type: type
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__content",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__action",
      children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
        label: dismissButton.label,
        onClick: dismissButton.onClick,
        disabled: dismissButton.disabled
      }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        label: ctaButton.label,
        onClick: ctaButton.onClick,
        inProgress: ctaButton.inProgress,
        disabled: ctaButton.disabled,
        href: ctaButton.href,
        external: ctaButton.external,
        hideExternalIndicator: ctaButton.hideExternalIndicator
      })]
    })]
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_6__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/Portal.js":
/*!*********************************!*\
  !*** ./js/components/Portal.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEffectOnce.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/**
 * Portal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

function Portal({
  children,
  slug
}) {
  // Using state as we need `el` to not change when the component re-renders
  const [el] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(document.createElement('div'));
  (0,react_use__WEBPACK_IMPORTED_MODULE_1__["default"])(() => {
    if (slug) {
      el.classList.add(`googlesitekit-portal-${slug}`);
    }
    const root = document.querySelector('.googlesitekit-plugin') || document.body;
    root.appendChild(el);
    return () => root.removeChild(el);
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createPortal)(children, el);
}
Portal.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Portal.defaultProps = {
  slug: '',
  children: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Portal);

/***/ }),

/***/ "./js/components/PreviewBlock.js":
/*!***************************************!*\
  !*** ./js/components/PreviewBlock.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewBlock component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function PreviewBlock({
  className,
  width,
  height,
  shape,
  padding,
  smallWidth,
  smallHeight,
  tabletWidth,
  tabletHeight,
  desktopWidth,
  desktopHeight
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const blockDimensions = {
    width: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    },
    height: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block', className, {
      'googlesitekit-preview-block--padding': padding
    }),
    style: {
      width: blockDimensions.width[breakpoint] || width,
      height: blockDimensions.height[breakpoint] || height
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block__wrapper', {
        'googlesitekit-preview-block__wrapper--circle': shape === 'circular'
      })
    })
  });
}
PreviewBlock.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  shape: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  padding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  smallWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  smallHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
PreviewBlock.defaultProps = {
  className: undefined,
  width: '100px',
  height: '100px',
  shape: 'square',
  padding: false,
  smallWidth: undefined,
  smallHeight: undefined,
  tabletWidth: undefined,
  tabletHeight: undefined,
  desktopWidth: undefined,
  desktopHeight: undefined
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewBlock);

/***/ }),

/***/ "./js/components/RefocusableModalDialog.js":
/*!*************************************************!*\
  !*** ./js/components/RefocusableModalDialog.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ModalDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ModalDialog */ "./js/components/ModalDialog.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



// Use a singleton variable to store the clicked element before any dialog opens.
// We need to do this at the module level since the component may not be mounted
// when the user initiates an action that will open the dialog.

let previouslyClickedElement = null;

// Set up a global event listener to capture the clicked element before any dialog opens.
// This needs to happen at the module level to ensure it's set up before any user interaction.
function setupFocusTracker() {
  if (typeof __webpack_require__.g === 'undefined' || !__webpack_require__.g.document || __webpack_require__.g._googlesitekitModalFocusTrackerInitialized) {
    return;
  }
  function captureActiveElementOnClick(event) {
    // Store the clicked (or keyboard-activated) element when user clicks.
    // This will be the element that was clicked right before the dialog opens.
    const nearestParentButtonOrAnchor = event.target.closest('button, a, input');
    if (nearestParentButtonOrAnchor && !nearestParentButtonOrAnchor.classList.contains('mdc-dialog__cancel-button')) {
      previouslyClickedElement = nearestParentButtonOrAnchor;
    }
  }
  __webpack_require__.g.document.addEventListener('mousedown', captureActiveElementOnClick);
  __webpack_require__.g.document.addEventListener('keydown', event => {
    if (event.key === 'Enter' || event.key === ' ') {
      captureActiveElementOnClick(event);
    }
  });
  __webpack_require__.g._googlesitekitModalFocusTrackerInitialized = true;
}
setupFocusTracker();
function RefocusableModalDialog({
  dialogActive = false,
  refocusQuerySelector = null,
  ...modalDialogProps
}) {
  const handleElementRefocus = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(() => {
    setTimeout(() => {
      const elementToFocus = refocusQuerySelector ? document.querySelector(refocusQuerySelector) : previouslyClickedElement;
      if (elementToFocus && document.body.contains(elementToFocus)) {
        elementToFocus.focus();
      }
      if (!refocusQuerySelector) {
        previouslyClickedElement = null;
      }
    });
  }, [refocusQuerySelector]);
  const previousDialogActive = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(dialogActive);
  // Handle re-focus of the button which triggered the modal.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (previousDialogActive === true && dialogActive === false) {
      handleElementRefocus();
    }
    return () => {
      // In majority of cases the modal is conditionally rendered, so dialogActive
      // will not be passed, as component will be unmounted/removed from the DOM.
      handleElementRefocus();
    };
  }, [previousDialogActive, dialogActive, handleElementRefocus]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_ModalDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    dialogActive: dialogActive,
    ...modalDialogProps
  });
}
RefocusableModalDialog.propTypes = {
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  refocusQuerySelector: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ...googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Dialog.propTypes
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RefocusableModalDialog);

/***/ }),

/***/ "./js/components/Root/ViewContextContext.js":
/*!**************************************************!*\
  !*** ./js/components/Root/ViewContextContext.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * View Context context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const ViewContextContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)('');
const {
  Consumer,
  Provider
} = ViewContextContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewContextContext);

/***/ }),

/***/ "./js/components/StoreErrorNotices.js":
/*!********************************************!*\
  !*** ./js/components/StoreErrorNotices.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ StoreErrorNotices)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ErrorNotice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/insufficient-permissions-error-description */ "./js/util/insufficient-permissions-error-description.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * StoreErrorNotices component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






function StoreErrorNotices({
  hasButton = false,
  moduleSlug,
  storeName
}) {
  const errors = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(storeName).getErrors());
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(moduleSlug));
  const existingErrorMessages = [];
  return errors.filter(error => {
    if (!error?.message || existingErrorMessages.includes(error.message)) {
      return false;
    }
    existingErrorMessages.push(error.message);
    return true;
  }).map((error, key) => {
    let {
      message
    } = error;
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_3__.isInsufficientPermissionsError)(error)) {
      message = (0,_js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_4__.getInsufficientPermissionsErrorDescription)(message, module);
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_ErrorNotice__WEBPACK_IMPORTED_MODULE_1__["default"], {
      error: error,
      hasButton: hasButton,
      storeName: storeName,
      message: message
    }, key);
  });
}
StoreErrorNotices.propTypes = {
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};

/***/ }),

/***/ "./js/components/SupportLink.js":
/*!**************************************!*\
  !*** ./js/components/SupportLink.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SupportLink)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function SupportLink(props) {
  const {
    path,
    query,
    hash,
    ...otherProps
  } = props;
  const supportURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getGoogleSupportURL({
    path,
    query,
    hash
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
    ...otherProps,
    href: supportURL
  });
}
SupportLink.propTypes = {
  path: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  query: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object),
  hash: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/TourTooltip.js":
/*!**************************************!*\
  !*** ./js/components/TourTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TourTooltip)
/* harmony export */ });
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-card */ "../node_modules/@material/react-card/dist/index.js");
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_card__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/create-incremental-array-by-size */ "./js/util/create-incremental-array-by-size.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltip component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function TourTooltip({
  backProps,
  closeProps,
  index,
  primaryProps,
  size,
  step,
  tooltipProps
}) {
  const indicatorArray = size > 1 ? (0,_js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__.createIncrementalArrayBySize)(size) : [];
  function getIndicatorClassName(indicatorIndex) {
    return classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tooltip-indicator', {
      active: indicatorIndex === index
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tour-tooltip', step.className),
    ...tooltipProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)((_material_react_card__WEBPACK_IMPORTED_MODULE_0___default()), {
      className: "googlesitekit-tooltip-card",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-tooltip-body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Typography__WEBPACK_IMPORTED_MODULE_6__["default"], {
          as: "h2",
          className: "googlesitekit-tooltip-title",
          size: "medium",
          type: "title",
          children: step.title
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "googlesitekit-tooltip-content",
          children: step.content
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_material_react_card__WEBPACK_IMPORTED_MODULE_0__.CardActions, {
        className: "googlesitekit-tooltip-actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("ul", {
          className: "googlesitekit-tooltip-indicators",
          children: indicatorArray.map(indicatorIndex => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("li", {
            className: getIndicatorClassName(indicatorIndex)
          }, `indicator-${indicatorIndex}`))
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "googlesitekit-tooltip-buttons",
          children: [index !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...backProps,
            children: backProps.title
          }), step.cta, primaryProps.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...primaryProps,
            children: primaryProps.title
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        className: "googlesitekit-tooltip-close",
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
          width: "14",
          height: "14"
        }),
        onClick: closeProps.onClick,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Close', 'google-site-kit'),
        text: true,
        hideTooltipTitle: true
      })]
    })
  });
}

/**
 * All props are provided directly from `react-joyride`, intended for custom components.
 *
 * @since 1.28.0
 * @see {@link https://docs.react-joyride.com/custom-components#props-1}.
 */
TourTooltip.propTypes = {
  backProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  closeProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  index: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  isLastStep: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool).isRequired,
  primaryProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  size: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  step: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    content: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    cta: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)]),
    className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }).isRequired,
  tooltipProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired
};

/***/ }),

/***/ "./js/components/TourTooltips.js":
/*!***************************************!*\
  !*** ./js/components/TourTooltips.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GA_ACTIONS: () => (/* binding */ GA_ACTIONS),
/* harmony export */   "default": () => (/* binding */ TourTooltips),
/* harmony export */   floaterProps: () => (/* binding */ floaterProps),
/* harmony export */   joyrideStyles: () => (/* binding */ joyrideStyles)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltips component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







/** For available options, see: {@link https://github.com/gilbarbara/react-joyride/blob/3e08384415a831b20ce21c8423b6c271ad419fbf/src/styles.js}. */

const joyrideStyles = {
  options: {
    arrowColor: '#3c7251',
    // $c-content-primary
    backgroundColor: '#3c7251',
    // $c-content-primary
    overlayColor: 'rgba(0, 0, 0, 0.6)',
    textColor: '#fff',
    // $c-content-on-primary
    zIndex: 20000
  },
  spotlight: {
    border: '2px solid #3c7251',
    // $c-content-primary
    backgroundColor: '#fff'
  }
};

// Provides button content as well as aria-label & title attribute values.
const joyrideLocale = {
  back: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back', 'google-site-kit'),
  close: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Close', 'google-site-kit'),
  last: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  next: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Next', 'google-site-kit')
};

/** For available options, see: {@link https://github.com/gilbarbara/react-floater#props}. */
const floaterProps = {
  disableAnimation: true,
  styles: {
    arrow: {
      length: 8,
      margin: 56,
      spread: 16
    },
    floater: {
      filter: 'drop-shadow(rgba(60, 64, 67, 0.3) 0px 1px 2px) drop-shadow(rgba(60, 64, 67, 0.15) 0px 2px 6px)'
    }
  }
};

// GA Event Tracking actions (do not change!)
const GA_ACTIONS = {
  VIEW: 'feature_tooltip_view',
  NEXT: 'feature_tooltip_advance',
  PREV: 'feature_tooltip_return',
  DISMISS: 'feature_tooltip_dismiss',
  COMPLETE: 'feature_tooltip_complete'
};
function TourTooltips({
  steps,
  tourID,
  gaEventCategory,
  callback
}) {
  const stepKey = `${tourID}-step`;
  const runKey = `${tourID}-run`;
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const {
    dismissTour
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const stepIndex = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(stepKey) || 0);
  const run = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(runKey) && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isTourDismissed(tourID) === false;
  });
  function changeStep(index, action) {
    return setValue(stepKey, index + (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV ? -1 : 1));
  }
  function startTour() {
    __webpack_require__.g.document.body.classList.add('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    setValue(runKey, true);
  }
  function endTour() {
    __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    // Dismiss tour to avoid unwanted repeat viewing.
    dismissTour(tourID);
  }
  function trackAllTourEvents({
    index,
    action,
    lifecycle,
    size,
    status,
    type
  }) {
    // The index is 0-based, but step numbers are 1-based.
    const stepNumber = index + 1;
    const eventCategory = typeof gaEventCategory === 'function' ? gaEventCategory(viewContext) : gaEventCategory;
    if (type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOOLTIP && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.TOOLTIP) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.VIEW, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.DISMISS, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT && status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOUR_END &&
    // Here we need to additionally check the size === stepNumber because
    // it is the only way to differentiate the status/event combination
    // from an identical combination that happens immediately after completion
    // on index `0` to avoid duplicate measurement.
    size === stepNumber) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.COMPLETE, stepNumber);
    }
    if (lifecycle !== react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE || status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED) {
      return;
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.PREV, stepNumber);
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(eventCategory, GA_ACTIONS.NEXT, stepNumber);
    }
  }

  /**
   * Handles `react-joyride` state changes using callback function.
   *
   * @typedef {Object} JoyrideCallbackData
   * @property {string} action The action that updated the state.
   * @property {status} status The tour's status.
   * @property {number} index  Step index.
   * @property {string} type   Specific type (tour, step, beacon).
   *
   * @since 1.28.0
   * @since 1.38.0 Calls new callback prop.
   * @see {@link https://docs.react-joyride.com/callback} Example data provided by `react-joyride`.
   * @see {@link https://docs.react-joyride.com/constants} State & lifecycle constants used by `react-joyride`.
   *
   * @param {JoyrideCallbackData} data Data object provided via `react-joyride` callback prop.
   */
  function handleJoyrideCallback(data) {
    trackAllTourEvents(data);
    const {
      action,
      index,
      status,
      step,
      type
    } = data;
    const hasCloseAction = action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE;
    const shouldChangeStep = !hasCloseAction && [react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER, react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TARGET_NOT_FOUND].includes(type);
    const isFinishedOrSkipped = [react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED, react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.SKIPPED].includes(status);
    const shouldCloseFromButtonClick = hasCloseAction && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER;
    const shouldEndTour = isFinishedOrSkipped || shouldCloseFromButtonClick;

    // Center the target in the viewport when transitioning to the step.
    if (react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_BEFORE === type) {
      let el = step.target;
      if ('string' === typeof step.target) {
        el = __webpack_require__.g.document.querySelector(step.target);
      }
      el?.scrollIntoView?.({
        block: 'center'
      });
    }
    if (shouldChangeStep) {
      changeStep(index, action);
    } else if (shouldEndTour) {
      endTour();
    }
    if (callback) {
      callback(data, registry);
    }
  }

  // Start tour on initial render
  (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(startTour);
  const parsedSteps = steps.map(step => ({
    disableBeacon: true,
    isFixed: true,
    placement: 'auto',
    ...step
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_8__["default"], {
    callback: handleJoyrideCallback,
    floaterProps: floaterProps,
    locale: joyrideLocale,
    run: run,
    stepIndex: stepIndex,
    steps: parsedSteps,
    styles: joyrideStyles,
    tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_5__["default"],
    continuous: true,
    disableOverlayClose: true,
    disableScrolling: true,
    showProgress: true
  });
}

/** For available properties & docs for `steps`, see: {@link https://docs.react-joyride.com/step#options}. */
TourTooltips.propTypes = {
  steps: prop_types__WEBPACK_IMPORTED_MODULE_10___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_10___default().object)).isRequired,
  tourID: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  gaEventCategory: prop_types__WEBPACK_IMPORTED_MODULE_10___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_10___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)]).isRequired,
  callback: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};

/***/ }),

/***/ "./js/components/Typography/P.js":
/*!***************************************!*\
  !*** ./js/components/Typography/P.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ P)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! . */ "./js/components/Typography/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function P({
  type = _constants__WEBPACK_IMPORTED_MODULE_2__.TYPE_BODY,
  size,
  children,
  ...props
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(___WEBPACK_IMPORTED_MODULE_1__["default"], {
    as: "p",
    type: type,
    size: size || (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL ? _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_SMALL : _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_MEDIUM),
    ...props,
    children: children
  });
}
P.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_SIZES)
};

/***/ }),

/***/ "./js/components/Typography/constants.js":
/*!***********************************************!*\
  !*** ./js/components/Typography/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SIZE_LARGE: () => (/* binding */ SIZE_LARGE),
/* harmony export */   SIZE_MEDIUM: () => (/* binding */ SIZE_MEDIUM),
/* harmony export */   SIZE_SMALL: () => (/* binding */ SIZE_SMALL),
/* harmony export */   TYPE_BODY: () => (/* binding */ TYPE_BODY),
/* harmony export */   TYPE_DISPLAY: () => (/* binding */ TYPE_DISPLAY),
/* harmony export */   TYPE_HEADLINE: () => (/* binding */ TYPE_HEADLINE),
/* harmony export */   TYPE_LABEL: () => (/* binding */ TYPE_LABEL),
/* harmony export */   TYPE_TITLE: () => (/* binding */ TYPE_TITLE),
/* harmony export */   VALID_SIZES: () => (/* binding */ VALID_SIZES),
/* harmony export */   VALID_TYPES: () => (/* binding */ VALID_TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPE_DISPLAY = 'display';
const TYPE_HEADLINE = 'headline';
const TYPE_TITLE = 'title';
const TYPE_BODY = 'body';
const TYPE_LABEL = 'label';
const VALID_TYPES = [TYPE_BODY, TYPE_DISPLAY, TYPE_HEADLINE, TYPE_LABEL, TYPE_TITLE];
const SIZE_SMALL = 'small';
const SIZE_MEDIUM = 'medium';
const SIZE_LARGE = 'large';
const VALID_SIZES = [SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE];

/***/ }),

/***/ "./js/components/Typography/index.js":
/*!*******************************************!*\
  !*** ./js/components/Typography/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Typography)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function Typography({
  className,
  type,
  size,
  as: Component = 'span',
  children,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Component, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-typography', className, {
      [`googlesitekit-typography--${type}`]: type && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES.includes(type),
      [`googlesitekit-typography--${size}`]: size && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES.includes(size)
    }),
    ...props,
    children: children
  });
}
Typography.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES),
  as: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)])
};

/***/ }),

/***/ "./js/components/VisuallyHidden.js":
/*!*****************************************!*\
  !*** ./js/components/VisuallyHidden.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Visually Hidden component, mainly used for screen-reader text.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function VisuallyHidden({
  className,
  children,
  ...otherProps
}) {
  if (!children) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('screen-reader-text', className),
    children: children
  });
}
VisuallyHidden.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
VisuallyHidden.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VisuallyHidden);

/***/ }),

/***/ "./js/components/conversion-tracking/ConfirmDisableConversionTrackingDialog.js":
/*!*************************************************************************************!*\
  !*** ./js/components/conversion-tracking/ConfirmDisableConversionTrackingDialog.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConfirmDisableConversionTrackingDialog)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/RefocusableModalDialog */ "./js/components/RefocusableModalDialog.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function ConfirmDisableConversionTrackingDialog({
  onConfirm,
  onCancel
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const subtitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('By disabling plugin conversion tracking, you will no longer have access to:', 'google-site-kit');
  const provides = [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Performance of your Ad campaigns', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Tracking additional conversion-related events via Analytics', 'google-site-kit')];
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.trackEvent)(`${viewContext}`, 'ect_view_modal');
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    className: "googlesitekit-settings-module__confirm-disconnect-modal",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disable plugin conversion tracking', 'google-site-kit'),
    subtitle: subtitle,
    handleConfirm: onConfirm,
    handleCancel: onCancel,
    onClose: onCancel,
    provides: provides,
    confirmButton: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disable', 'google-site-kit'),
    dialogActive: true,
    danger: true
  });
}
ConfirmDisableConversionTrackingDialog.propTypes = {
  onConfirm: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired,
  onCancel: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired
};

/***/ }),

/***/ "./js/components/conversion-tracking/ConversionTrackingToggle.js":
/*!***********************************************************************!*\
  !*** ./js/components/conversion-tracking/ConversionTrackingToggle.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConversionTrackingToggle)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/LoadingWrapper */ "./js/components/LoadingWrapper.js");
/* harmony import */ var _ConfirmDisableConversionTrackingDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ConfirmDisableConversionTrackingDialog */ "./js/components/conversion-tracking/ConfirmDisableConversionTrackingDialog.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function ConversionTrackingToggle({
  children,
  loading
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const [saveError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
  const [showConfirmDialog, setShowConfirmDialog] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const isConversionTrackingEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isConversionTrackingEnabled());
  const isSaving = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isFetchingSaveConversionTrackingSettings());
  const {
    setConversionTrackingEnabled
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_4__["default"], {
      loading: loading,
      width: "180px",
      height: "21.3px",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "googlesitekit-module-settings-group__switch",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Switch, {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Plugin conversion tracking', 'google-site-kit'),
          checked: isConversionTrackingEnabled,
          disabled: isSaving || loading,
          onClick: () => {
            // If Conversion Tracking is currently enabled, show a confirmation
            // dialog warning users about the impact of disabling it.
            if (isConversionTrackingEnabled) {
              (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}`, 'ect_disable');
              setShowConfirmDialog(true);
            } else {
              (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}`, 'ect_enable');

              // Conversion Tracking is not currently enabled, so this toggle
              // enables it.
              setConversionTrackingEnabled(true);
            }
          },
          hideLabel: false
        })
      })
    }), !!saveError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_8__["default"], {
      message: saveError.message
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_LoadingWrapper__WEBPACK_IMPORTED_MODULE_4__["default"], {
      className: "googlesitekit-settings-conversion-tracking-switch-description--loading",
      loading: loading,
      width: "750px",
      height: "42px",
      smallWidth: "386px",
      smallHeight: "84px",
      tabletWidth: "540px",
      tabletHeight: "84px",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("p", {
        className: "googlesitekit-module-settings-group__helper-text",
        children: children
      })
    }), showConfirmDialog && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_ConfirmDisableConversionTrackingDialog__WEBPACK_IMPORTED_MODULE_5__["default"], {
      onConfirm: () => {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}`, 'ect_confirm_disable');
        setConversionTrackingEnabled(false);
        setShowConfirmDialog(false);
      },
      onCancel: () => {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}`, 'ect_cancel_disable');
        setShowConfirmDialog(false);
      }
    })]
  });
}
ConversionTrackingToggle.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().node).isRequired,
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool)
};

/***/ }),

/***/ "./js/components/conversion-tracking/SetupPluginConversionTrackingNotice.js":
/*!**********************************************************************************!*\
  !*** ./js/components/conversion-tracking/SetupPluginConversionTrackingNotice.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupPluginConversionTrackingNotice)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function SetupPluginConversionTrackingNotice({
  className,
  message
}) {
  const isCTEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).isConversionTrackingEnabled());
  if (isCTEnabled || isCTEnabled === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'googlesitekit-color--surfaces-on-background-variant googlesitekit-plugin-conversion-tracking-notice'),
    children: message
  });
}

/***/ }),

/***/ "./js/components/google-tag-gateway/GoogleTagGatewayToggle.js":
/*!********************************************************************!*\
  !*** ./js/components/google-tag-gateway/GoogleTagGatewayToggle.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GoogleTagGatewayToggle)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_withIntersectionObserver__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util/withIntersectionObserver */ "./js/util/withIntersectionObserver.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Google Tag Gateway Toggle component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










const SubtleNotificationWithIntersectionObserver = (0,_js_util_withIntersectionObserver__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"]);
function GoogleTagGatewayToggle({
  className
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const isGoogleTagGatewayEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isGoogleTagGatewayEnabled());
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isFetchingGetGTGServerRequirementStatus());
  const hasMetServerRequirements = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const {
      isGTGHealthy,
      isScriptAccessEnabled
    } = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
    return isGTGHealthy() !== false && isScriptAccessEnabled() !== false;
  });
  const {
    fetchGetGTGServerRequirementStatus,
    setGoogleTagGatewayEnabled
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
  const learnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('google-tag-gateway-introduction');
  });
  const serverRequirementsLearnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('google-tag-gateway-server-requirements');
  });

  // Fetch the server requirement status on mount.
  (0,react_use__WEBPACK_IMPORTED_MODULE_12__["default"])(fetchGetGTGServerRequirementStatus);
  const handleClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    const action = isGoogleTagGatewayEnabled ? 'deactivate_google_tag_gateway' : 'activate_google_tag_gateway';
    (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_gtg-settings-toggle`, action).finally(() => {
      setGoogleTagGatewayEnabled(!isGoogleTagGatewayEnabled);
    });
  }, [isGoogleTagGatewayEnabled, setGoogleTagGatewayEnabled, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-google-tag-gateway-toggle', className),
    children: [isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {
      className: "googlesitekit-google-tag-gateway-toggle__progress",
      small: true
    }), !isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-module-settings-group__switch",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Switch, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Google tag gateway for advertisers', 'google-site-kit'),
        checked: !!isGoogleTagGatewayEnabled && hasMetServerRequirements,
        disabled: !hasMetServerRequirements,
        onClick: handleClick,
        hideLabel: false
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "googlesitekit-google-tag-gateway-toggle__switch-badge",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_5__["default"], {
          className: "googlesitekit-badge--beta",
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Beta', 'google-site-kit'),
          hasLeftSpacing: true
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
      className: "googlesitekit-module-settings-group__helper-text",
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Your tag data will be sent through your own domain to improve data quality and help you recover measurement signals. <a>Learn more</a>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
          href: learnMoreURL,
          onClick: () => {
            (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_gtg-settings-toggle`, 'click_learn_more_link');
          },
          "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more about Google tag gateway for advertisers', 'google-site-kit'),
          external: true
        })
      })
    }), !isLoading && !hasMetServerRequirements && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(SubtleNotificationWithIntersectionObserver, {
      type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"].TYPES.WARNING,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Your server’s current settings prevent Google tag gateway for advertisers from working. To enable it, please contact your hosting provider and request access to external resources and plugin files. <a>Learn more</a>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
          href: serverRequirementsLearnMoreURL,
          onClick: () => {
            (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_gtg-settings-toggle-disabled`, 'click_learn_more_link');
          },
          "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more about Google tag gateway for advertisers server requirements', 'google-site-kit'),
          external: true
        })
      }),
      variant: "warning",
      onInView: () => {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_gtg-settings-toggle-disabled`, 'view_notice');
      }
    })]
  });
}

/***/ }),

/***/ "./js/components/notifications/AdBlockerWarning.js":
/*!*********************************************************!*\
  !*** ./js/components/notifications/AdBlockerWarning.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdBlockerWarning)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _AdBlockerWarningMessage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AdBlockerWarningMessage */ "./js/components/notifications/AdBlockerWarningMessage.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdSense AdBlockerWarning component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





function AdBlockerWarning({
  moduleSlug,
  className
}) {
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const adBlockerWarningMessage = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(storeName)?.getAdBlockerWarningMessage());
  const getHelpLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getDocumentationLinkURL(`${moduleSlug}-ad-blocker-detected`));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_AdBlockerWarningMessage__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    getHelpLink: getHelpLink,
    warningMessage: adBlockerWarningMessage
  });
}
AdBlockerWarning.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/components/notifications/AdBlockerWarningMessage.js":
/*!****************************************************************!*\
  !*** ./js/components/notifications/AdBlockerWarningMessage.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdBlockerWarningMessage)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _svg_icons_external_rounded_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/external-rounded.svg */ "./svg/icons/external-rounded.svg");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdBlockerWarningMessage component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function AdBlockerWarningMessage({
  getHelpLink = '',
  warningMessage = null
}) {
  if (!warningMessage) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: "googlesitekit-notice--small",
    type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.WARNING,
    description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: The warning message. 2: "Get help" text. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s. <Link><Strong>%2$s</Strong></Link>', 'google-site-kit'), warningMessage, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')), {
      Link: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
        href: getHelpLink,
        trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_external_rounded_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
          width: 15,
          height: 15
        }),
        external: true,
        hideExternalIndicator: true
      }),
      Strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
    }),
    hideIcon: true
  });
}
AdBlockerWarningMessage.propTypes = {
  getHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  warningMessage: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};

/***/ }),

/***/ "./js/components/notifications/CTA.js":
/*!********************************************!*\
  !*** ./js/components/notifications/CTA.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CTA component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function CTA({
  title,
  headerText,
  headerContent,
  description,
  ctaLink,
  ctaLabel,
  ctaLinkExternal,
  ctaType,
  error,
  onClick,
  'aria-label': ariaLabel,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta', {
      'googlesitekit-cta--error': error
    }),
    children: [(headerText || headerContent) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__header",
      children: [headerText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h2",
        size: "small",
        type: "label",
        className: "googlesitekit-cta__header_text",
        children: headerText
      }), headerContent]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__body",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h3",
        size: "small",
        type: "title",
        className: "googlesitekit-cta__title",
        children: title
      }), description && typeof description === 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "googlesitekit-cta__description",
        children: description
      }), description && typeof description !== 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "googlesitekit-cta__description",
        children: description
      }), ctaLabel && ctaType === 'button' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        "aria-label": ariaLabel,
        href: ctaLink,
        onClick: onClick,
        children: ctaLabel
      }), ctaLabel && ctaType === 'link' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: ctaLink,
        onClick: onClick,
        "aria-label": ariaLabel,
        external: ctaLinkExternal,
        hideExternalIndicator: ctaLinkExternal,
        arrow: true,
        children: ctaLabel
      }), children]
    })]
  });
}
CTA.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  headerText: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  ctaLink: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaLinkExternal: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaType: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  headerContent: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};
CTA.defaultProps = {
  title: '',
  headerText: '',
  headerContent: '',
  description: '',
  ctaLink: '',
  ctaLabel: '',
  ctaType: 'link',
  error: false,
  onClick: () => {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CTA);

/***/ }),

/***/ "./js/components/settings/SettingsGroup.js":
/*!*************************************************!*\
  !*** ./js/components/settings/SettingsGroup.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsGroup)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsInactiveModules component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function SettingsGroup({
  title,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-module-settings-group",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_0__["default"], {
      as: "h4",
      size: "medium",
      type: "title",
      children: title
    }), children]
  });
}
SettingsGroup.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired
};

/***/ }),

/***/ "./js/components/settings/SettingsStatuses.js":
/*!****************************************************!*\
  !*** ./js/components/settings/SettingsStatuses.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsStatuses)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsStatuses component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function SettingsStatuses({
  statuses
}) {
  if (!statuses || statuses.length === 0) {
    return null;
  }
  function renderStatus(status) {
    if (status === undefined) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "googlesitekit-settings-module__meta-item-data",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, {})
      });
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
      className: "googlesitekit-settings-module__meta-item-data",
      children: status ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enabled', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disabled', 'google-site-kit')
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "googlesitekit-settings-module__meta-items",
    children: statuses.map(({
      label,
      status
    }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-settings-module__meta-item",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_2__["default"], {
        as: "h5",
        size: "medium",
        type: "label",
        className: "googlesitekit-settings-module__meta-item-type",
        children: label
      }), renderStatus(status)]
    }, label))
  });
}
SettingsStatuses.propTypes = {
  statuses: prop_types__WEBPACK_IMPORTED_MODULE_4___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_4___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
    status: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf([undefined, true, false])
  }))
};

/***/ }),

/***/ "./js/components/surveys/SurveyViewTrigger.js":
/*!****************************************************!*\
  !*** ./js/components/surveys/SurveyViewTrigger.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SurveyViewTrigger)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/**
 * SurveyViewTrigger component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function SurveyViewTrigger({
  triggerID,
  ttl = 0
}) {
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    triggerSurvey(triggerID, {
      ttl
    });
  }, [triggerID, ttl, triggerSurvey]);
  return null;
}
SurveyViewTrigger.propTypes = {
  triggerID: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  ttl: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number)
};

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-modules-ads.js":
/*!*****************************************!*\
  !*** ./js/googlesitekit-modules-ads.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-modules */ "googlesitekit-modules");
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-widgets */ "googlesitekit-widgets");
/* harmony import */ var googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-notifications */ "googlesitekit-notifications");
/* harmony import */ var googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _modules_ads__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modules/ads */ "./js/modules/ads/index.js");
/**
 * Ads module entrypoint.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





(0,_modules_ads__WEBPACK_IMPORTED_MODULE_4__.registerStore)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
(0,_modules_ads__WEBPACK_IMPORTED_MODULE_4__.registerModule)((googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1___default()));
(0,_modules_ads__WEBPACK_IMPORTED_MODULE_4__.registerWidgets)((googlesitekit_widgets__WEBPACK_IMPORTED_MODULE_2___default()));
(0,_modules_ads__WEBPACK_IMPORTED_MODULE_4__.registerNotifications)((googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_3___default()));

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.168.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/api/middleware/deduplication.ts":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/api/middleware/deduplication.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   logDuplicate: () => (/* binding */ logDuplicate)
/* harmony export */ });
/* harmony import */ var equivalent_key_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! equivalent-key-map */ "../node_modules/equivalent-key-map/equivalent-key-map.js");
/* harmony import */ var equivalent_key_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(equivalent_key_map__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */

/**
 * Logs a console warning for the given request options.
 *
 * @since n.e.x.t
 *
 * @param  options API fetch options of the duplicate request.
 * @return {void}
 */
function logDuplicate(options) {
  __webpack_require__.g.console.warn('Google Site Kit API: duplicate request', options);
}
/**
 * Creates a new request deduplication middleware instance.
 *
 * @since n.e.x.t
 *
 * @param middlewareOptions Options for configuring the behavior of the middleware.
 * @return Middleware handler function.
 */
function createDedupeMiddleware(middlewareOptions = {}) {
  const {
    onDuplicate
  } = middlewareOptions;
  const concurrentRequests = new (equivalent_key_map__WEBPACK_IMPORTED_MODULE_0___default())();
  return function (options, next) {
    // If we already have a request for these options
    // call the handler, if any, and return the shared response.
    const existingRequest = concurrentRequests.get(options);
    // EquivalentKeyMap doesn't implement `has` as expected, so we need to check the value.
    // When deleting, the value is set to `undefined` so `has(key)` remains true.
    if (existingRequest instanceof Promise) {
      onDuplicate?.(options);
      return existingRequest;
    }
    const promise = next(options);
    concurrentRequests.set(options, promise);

    // Ensure the request entry is removed once the request
    // is completed regardless of any error.
    promise.catch(() => {
      // avoid an uncaught error here
    }).finally(() => {
      concurrentRequests.delete(options);
    });
    return promise;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createDedupeMiddleware);

/***/ }),

/***/ "./js/googlesitekit/api/middleware/preloading.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/api/middleware/preloading.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/normalize-path.js");
/**
 * Custom preloading middleware.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies.
 */


/**
 * Creates a preloading middleware.
 *
 * Based on preloadMiddleware from from @wordpress/api-fetch, this middle is a single-use per-endpoint and provides cached
 * data for the first request only and any subsequent requests reach the server.
 *
 * @since 1.13.0
 *
 * @param {Object} preloadedData Preloaded data paths.
 * @return {Function} Function.
 */
function createPreloadingMiddleware(preloadedData) {
  const cache = Object.keys(preloadedData).reduce((result, path) => {
    result[(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(path)] = preloadedData[path];
    return result;
  }, {});
  let cacheHasExpired = false;
  return (options, next) => {
    if (cacheHasExpired) {
      return next(options);
    }
    setTimeout(() => {
      cacheHasExpired = true;
    }, 3000);
    const {
      parse = true
    } = options;
    const uri = options.path;
    if (typeof options.path === 'string') {
      const method = options.method?.toUpperCase() || 'GET';
      const path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(uri);
      if (parse && 'GET' === method && cache[path]) {
        const result = Promise.resolve(cache[path].body);
        delete cache[path];
        return result;
      } else if ('OPTIONS' === method && cache[method] && cache[method][path]) {
        const result = Promise.resolve(cache[method][path]);
        delete cache[method][path];
        return result;
      }
    }
    return next(options);
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPreloadingMiddleware);

/***/ }),

/***/ "./js/googlesitekit/constants.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ANCHOR_ID_CONTENT: () => (/* binding */ ANCHOR_ID_CONTENT),
/* harmony export */   ANCHOR_ID_KEY_METRICS: () => (/* binding */ ANCHOR_ID_KEY_METRICS),
/* harmony export */   ANCHOR_ID_MONETIZATION: () => (/* binding */ ANCHOR_ID_MONETIZATION),
/* harmony export */   ANCHOR_ID_SPEED: () => (/* binding */ ANCHOR_ID_SPEED),
/* harmony export */   ANCHOR_ID_TRAFFIC: () => (/* binding */ ANCHOR_ID_TRAFFIC),
/* harmony export */   SITE_KIT_VIEW_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_CONTEXTS),
/* harmony export */   SITE_KIT_VIEW_ONLY_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_ONLY_CONTEXTS),
/* harmony export */   VIEW_CONTEXT_ACTIVATION: () => (/* binding */ VIEW_CONTEXT_ACTIVATION),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_AD_BLOCKING_RECOVERY: () => (/* binding */ VIEW_CONTEXT_AD_BLOCKING_RECOVERY),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_KEY_METRICS_SETUP: () => (/* binding */ VIEW_CONTEXT_KEY_METRICS_SETUP),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_METRIC_SELECTION: () => (/* binding */ VIEW_CONTEXT_METRIC_SELECTION),
/* harmony export */   VIEW_CONTEXT_MODULE: () => (/* binding */ VIEW_CONTEXT_MODULE),
/* harmony export */   VIEW_CONTEXT_MODULE_SETUP: () => (/* binding */ VIEW_CONTEXT_MODULE_SETUP),
/* harmony export */   VIEW_CONTEXT_POSTS_LIST: () => (/* binding */ VIEW_CONTEXT_POSTS_LIST),
/* harmony export */   VIEW_CONTEXT_SETTINGS: () => (/* binding */ VIEW_CONTEXT_SETTINGS),
/* harmony export */   VIEW_CONTEXT_SPLASH: () => (/* binding */ VIEW_CONTEXT_SPLASH),
/* harmony export */   VIEW_CONTEXT_USER_INPUT: () => (/* binding */ VIEW_CONTEXT_USER_INPUT),
/* harmony export */   VIEW_CONTEXT_WP_BLOCK_EDITOR: () => (/* binding */ VIEW_CONTEXT_WP_BLOCK_EDITOR),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY)
/* harmony export */ });
/**
 * Core constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const VIEW_CONTEXT_MAIN_DASHBOARD = 'mainDashboard';
const VIEW_CONTEXT_ENTITY_DASHBOARD = 'entityDashboard';
const VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY = 'mainDashboardViewOnly';
const VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY = 'entityDashboardViewOnly';
const VIEW_CONTEXT_POSTS_LIST = 'postsList';
const VIEW_CONTEXT_USER_INPUT = 'userInput';
const VIEW_CONTEXT_ACTIVATION = 'activation';
const VIEW_CONTEXT_SPLASH = 'splash';
const VIEW_CONTEXT_ADMIN_BAR = 'adminBar';
const VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY = 'adminBarViewOnly';
const VIEW_CONTEXT_SETTINGS = 'settings';
const VIEW_CONTEXT_AD_BLOCKING_RECOVERY = 'adBlockingRecovery';
const VIEW_CONTEXT_MODULE = 'module';
const VIEW_CONTEXT_WP_DASHBOARD = 'wpDashboard';
const VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY = 'wpDashboardViewOnly';
const VIEW_CONTEXT_MODULE_SETUP = 'moduleSetup';
const VIEW_CONTEXT_METRIC_SELECTION = 'metricSelection';
const VIEW_CONTEXT_WP_BLOCK_EDITOR = 'wpBlockEditor';
const VIEW_CONTEXT_KEY_METRICS_SETUP = 'keyMetricsSetup';

// Anchor ID Constants
const ANCHOR_ID_KEY_METRICS = 'key-metrics';
const ANCHOR_ID_TRAFFIC = 'traffic';
const ANCHOR_ID_CONTENT = 'content';
const ANCHOR_ID_SPEED = 'speed';
const ANCHOR_ID_MONETIZATION = 'monetization';

// Site Kit only view contexts
const SITE_KIT_VIEW_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD, VIEW_CONTEXT_ENTITY_DASHBOARD, VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_USER_INPUT, VIEW_CONTEXT_SPLASH, VIEW_CONTEXT_SETTINGS, VIEW_CONTEXT_MODULE_SETUP, VIEW_CONTEXT_METRIC_SELECTION];

// Site Kit view-only contexts
const SITE_KIT_VIEW_ONLY_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY, VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/data/create-error-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-error-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   createErrorStore: () => (/* binding */ createErrorStore),
/* harmony export */   generateErrorKey: () => (/* binding */ generateErrorKey)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


const RECEIVE_ERROR = 'RECEIVE_ERROR';
const CLEAR_ERROR = 'CLEAR_ERROR';
const CLEAR_ERRORS = 'CLEAR_ERRORS';

/**
 * Internal dependencies
 */


function generateErrorKey(baseName, args) {
  if (args && Array.isArray(args)) {
    const stringifiedArgs = args.map(item => {
      return 'object' === typeof item ? (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringifyObject)(item) : item;
    });
    return `${baseName}::${md5__WEBPACK_IMPORTED_MODULE_1___default()(JSON.stringify(stringifiedArgs))}`;
  }
  return baseName;
}
const actions = {
  receiveError(error, baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(error, 'error is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: RECEIVE_ERROR,
      payload: {
        error,
        baseName,
        args
      }
    };
  },
  clearError(baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: CLEAR_ERROR,
      payload: {
        baseName,
        args
      }
    };
  },
  clearErrors(baseName) {
    return {
      type: CLEAR_ERRORS,
      payload: {
        baseName
      }
    };
  }
};
function createErrorStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName must be defined.');
  const initialState = {
    errors: {},
    errorArgs: {}
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case RECEIVE_ERROR:
        {
          const {
            baseName,
            args,
            error
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          state.errors[key] = error;
          state.errorArgs[key] = args;
          break;
        }
      case CLEAR_ERROR:
        {
          const {
            baseName,
            args
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          delete state.errors[key];
          delete state.errorArgs[key];
          break;
        }
      case CLEAR_ERRORS:
        {
          const {
            baseName
          } = payload;
          if (baseName) {
            state.errors = state.errors || {};
            state.errorArgs = state.errorArgs || {};
            for (const key in state.errors) {
              if (key === baseName || key.startsWith(`${baseName}::`)) {
                delete state.errors[key];
                delete state.errorArgs[key];
              }
            }
          } else {
            state.errors = {};
            state.errorArgs = {};
          }
          break;
        }
    }
  });
  const controls = {};
  const resolvers = {};
  const selectors = {
    /**
     * Retrieves the error object from state.
     *
     * Error object has the format:
     *
     * ```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state        Data store's state.
     * @param {string}      selectorName Selector name.
     * @param {Array.<any>} [args]       Arguments passed to selector (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForSelector(state, selectorName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(selectorName, 'selectorName is required.');
      return selectors.getError(state, selectorName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      actionName Action name.
     * @param {Array.<any>} [args]     Arguments passed to action (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForAction(state, actionName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(actionName, 'actionName is required.');
      return selectors.getError(state, actionName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     * @private
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      [baseName] Selector or action name.
     * @param {Array.<any>} [args]     Arguments array.
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getError(state, baseName, args) {
      const {
        errors
      } = state;
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
      return errors[generateErrorKey(baseName, args)];
    },
    /**
     * Gets a list of all unique errors.
     *
     * @since 1.19.0
     *
     * @param {Object} state Data store's state.
     * @return {Object[]} Unique set of errors.
     */
    getErrors(state) {
      const errorsSet = new Set(Object.values(state.errors));
      return Array.from(errorsSet);
    },
    /**
     * Gets the meta-data for a given error object, or null if the error is not found.
     *
     * Returns meta-data in the format:
     *
     * ```
     *	{
     *		baseName: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.84.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Meta-data for the given error object, or null if the error is not found.
     */
    getMetaDataForError(state, error) {
      const key = Object.keys(state.errors).find(errorKey => state.errors[errorKey] === error);
      if (key) {
        const baseName = key.substring(0, key.indexOf('::'));
        return {
          baseName,
          args: state.errorArgs[key]
        };
      }
      return null;
    },
    /**
     * Gets the selector data for a given error object, or null if no selector data is available.
     *
     * Returns selector data in the format:
     *
     * ```
     *	{
     *		storeName: <string>,
     *		name: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.87.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Selector data for the given error object, or null if no selector data is available.
     */
    getSelectorDataForError: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.createRegistrySelector)(select => function (state, error) {
      const metaData = select(storeName).getMetaDataForError(error);
      if (metaData) {
        const {
          baseName: name,
          args
        } = metaData;
        const isSelector = !!select(storeName)[name];
        if (isSelector) {
          return {
            storeName,
            name,
            args
          };
        }
      }
      return null;
    }),
    /**
     * Determines whether the datastore has errors or not.
     *
     * @since 1.15.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} TRUE if the datastore has errors, otherwise FALSE.
     */
    hasErrors(state) {
      return selectors.getErrors(state).length > 0;
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-fetch-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-fetch-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFetchStore: () => (/* binding */ createFetchStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _create_error_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _transform_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function defaultReducerCallback(state) {
  return state;
}
function defaultArgsToParams() {
  return {};
}
function defaultValidateParams() {}

// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _create_error_store__WEBPACK_IMPORTED_MODULE_2__.actions;

/**
 * Creates a store object implementing the necessary infrastructure for a
 * single fetch action.
 *
 * This function returns a partial store object with the following:
 * - action creators to fetch and to receive the data
 * - control to issue the API request
 * - reducer to set API request flag and receive the response
 * - selector to check whether the API request is in progress via a flag
 *
 * The names of the pieces are based on the baseName provided.
 * For example, if baseName is 'saveSettings':
 * - The fetch action creator is called 'fetchSaveSettings'.
 * - The receive action creator is called 'receiveSaveSettings'.
 * - The fetching selector is called 'isFetchingSaveSettings'.
 *
 * All parts of the returned store objects should be considered internal. A
 * public action or selector should be implemented to actually call the
 * fetch action included in the returned store object.
 *
 * For example, if the fetch store is intended for an API-based
 * action 'storeMySetting':
 * - The basename passed should be 'storeMySetting'.
 * - The action 'storeMySetting' should call 'fetchStoreMySetting'.
 *
 * Or, if the fetch store is intended for an API-based selector
 * 'getSomeData':
 * - The baseName passed should be 'getSomeData'.
 * - The resolver for 'getSomeData' should call 'fetchGetSomeData'.
 *
 * @since 1.10.0
 * @private
 *
 * @param {Object}   args                   Arguments for creating the fetch store.
 * @param {string}   args.baseName          The base name to use for all the created infrastructure.
 * @param {Function} args.controlCallback   Callback function to issue the API request. Will be used inside the
 *                                          control. The function receives a params object based on argsToParams,
 *                                          i.e. the respective values passed to the action.
 * @param {Function} [args.reducerCallback] Optional. Callback function to modify state based on the API response.
 *                                          Will be used inside the reducer. The function receives the store's state
 *                                          object as first parameter, the API response as second parameter, and the
 *                                          params object for the request (see above) as third parameter. If not
 *                                          provided, the default will return the unmodified state.
 * @param {Function} [args.argsToParams]    Optional. Function that reduces the given list of arguments
 *                                          into a object of key/value parameters, with the argument names used as keys.
 *                                          If not provided, the default function will return an empty object,
 *                                          essentially indicating that no arguments are supported/required.
 * @param {Function} [args.validateParams]  Optional. Function that validates the given parameters object created by `argsToParams`.
 *                                          Any invalid parameters should cause a respective error to be thrown.
 * @return {Object} Partial store object with properties 'actions', 'controls', 'reducer', 'resolvers', and 'selectors'.
 */
function createFetchStore({
  baseName,
  controlCallback,
  reducerCallback = defaultReducerCallback,
  argsToParams = defaultArgsToParams,
  validateParams = defaultValidateParams
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof controlCallback, 'controlCallback is required and must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof reducerCallback, 'reducerCallback must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof argsToParams, 'argsToParams must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof validateParams, 'validateParams must be a function.');

  // If validating the result of argsToParams without any arguments does not result in an error, we
  // know params is okay to be empty.
  let requiresParams;
  try {
    validateParams(argsToParams());
    requiresParams = false;
  } catch (error) {
    requiresParams = true;
  }
  const pascalCaseBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToPascalCase)(baseName);
  const constantBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToConstantCase)(baseName);
  const FETCH = `FETCH_${constantBaseName}`;
  const START_FETCH = `START_${FETCH}`;
  const FINISH_FETCH = `FINISH_${FETCH}`;
  const CATCH_FETCH = `CATCH_${FETCH}`;
  const RECEIVE = `RECEIVE_${constantBaseName}`;
  const fetchCreator = `fetch${pascalCaseBaseName}`;
  const receiveCreator = `receive${pascalCaseBaseName}`;
  const isFetching = `isFetching${pascalCaseBaseName}`;
  const initialState = {
    [isFetching]: {}
  };
  function* fetchGenerator(params, args) {
    let response;
    let error;
    yield {
      payload: {
        params
      },
      type: START_FETCH
    };
    yield clearError(baseName, args);
    try {
      response = yield {
        payload: {
          params
        },
        type: FETCH
      };
      yield actions[receiveCreator](response, params);
      yield {
        payload: {
          params
        },
        type: FINISH_FETCH
      };
    } catch (e) {
      error = e;
      yield receiveError(error, baseName, args);
      yield {
        payload: {
          params
        },
        type: CATCH_FETCH
      };
    }
    return {
      response,
      error
    };
  }
  const actions = {
    [fetchCreator](...args) {
      const params = argsToParams(...args);
      // In order for params validation to throw an error as expected,
      // this function cannot be a generator.
      validateParams(params);

      // The normal fetch action generator is invoked as the return here
      // to preserve asynchronous behavior without registering another action creator.
      return fetchGenerator(params, args);
    },
    [receiveCreator](response, params) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(response !== undefined, 'response is required.');
      if (requiresParams) {
        invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(params), 'params is required.');
        validateParams(params);
      } else {
        params = {};
      }
      return {
        payload: {
          response,
          params
        },
        type: RECEIVE
      };
    }
  };
  const controls = {
    [FETCH]: ({
      payload
    }) => {
      return controlCallback(payload.params);
    }
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case START_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = true;
          return state;
        }
      case RECEIVE:
        {
          const {
            response,
            params
          } = payload;
          return reducerCallback(state, response, params);
        }
      case FINISH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      case CATCH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      default:
        return state;
    }
  });
  const selectors = {
    [isFetching]: (state, ...args) => {
      if (state[isFetching] === undefined) {
        return false;
      }
      let params;
      try {
        params = argsToParams(...args);
        validateParams(params);
      } catch (err) {
        // If parameters are invalid, fail silently here. It likely is
        // because some dependency selector is still resolving.
        return false;
      }
      return !!state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)];
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers: {},
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-settings-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-settings-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INVARIANT_DOING_SUBMIT_CHANGES: () => (/* binding */ INVARIANT_DOING_SUBMIT_CHANGES),
/* harmony export */   INVARIANT_SETTINGS_NOT_CHANGED: () => (/* binding */ INVARIANT_SETTINGS_NOT_CHANGED),
/* harmony export */   createSettingsStore: () => (/* binding */ createSettingsStore),
/* harmony export */   makeDefaultCanSubmitChanges: () => (/* binding */ makeDefaultCanSubmitChanges),
/* harmony export */   makeDefaultHaveSettingsChanged: () => (/* binding */ makeDefaultHaveSettingsChanged),
/* harmony export */   makeDefaultRollbackChanges: () => (/* binding */ makeDefaultRollbackChanges),
/* harmony export */   makeDefaultSubmitChanges: () => (/* binding */ makeDefaultSubmitChanges)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _transform_case__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var _create_fetch_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/**
 * Provides API functions to create a datastore for settings.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */







// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__.actions;

// Invariant error messages.
const INVARIANT_DOING_SUBMIT_CHANGES = 'cannot submit changes while submitting changes';
const INVARIANT_SETTINGS_NOT_CHANGED = 'cannot submit changes if settings have not changed';

// Actions
const SET_SETTINGS = 'SET_SETTINGS';
const ROLLBACK_SETTINGS = 'ROLLBACK_SETTINGS';
const ROLLBACK_SETTING = 'ROLLBACK_SETTING';

/**
 * Creates a store object that includes actions and selectors for managing settings.
 *
 * The first three parameters hook up the store to the respective REST API endpoint,
 * while the fourth defines the names of the sub-settings to support.
 *
 * @since 1.6.0
 * @since 1.129.0 Added haveSettingsChanged optional paramter.
 * @private
 *
 * @param {string}        type                                  The data to access. One of 'core' or 'modules'.
 * @param {string}        identifier                            The data identifier, eg. a module slug like `search-console`.
 * @param {string}        datapoint                             The endpoint to request data from, e.g. 'settings'.
 * @param {Object}        options                               Optional. Options to consider for the store.
 * @param {Array}         [options.ownedSettingsSlugs]          Optional. List of "owned settings" for this module, if they exist.
 * @param {number}        [options.storeName]                   Store name to use. Default is '{type}/{identifier}'.
 * @param {Array}         [options.settingSlugs]                List of the slugs that are part of the settings object handled by the respective API endpoint.
 * @param {Object}        [options.initialSettings]             Optional. An initial set of settings as key-value pairs.
 * @param {Function|null} [options.validateHaveSettingsChanged] Optional. Custom callback to determine if settings have changed.
 * @return {Object} The settings store object, with additional `STORE_NAME` and
 *                  `initialState` properties.
 */
function createSettingsStore(type, identifier, datapoint, {
  ownedSettingsSlugs = undefined,
  storeName = undefined,
  settingSlugs = [],
  initialSettings = undefined,
  validateHaveSettingsChanged = makeDefaultHaveSettingsChanged()
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(type, 'type is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(identifier, 'identifier is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(datapoint, 'datapoint is required.');
  const STORE_NAME = storeName || `${type}/${identifier}`;
  const initialState = {
    ownedSettingsSlugs,
    settings: initialSettings,
    savedSettings: undefined
  };
  const fetchGetSettingsStore = (0,_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
    baseName: 'getSettings',
    controlCallback: () => {
      return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)(type, identifier, datapoint, {}, {
        useCache: false
      });
    },
    reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, values) => {
      state.savedSettings = {
        ...values
      };
      state.settings = {
        ...values,
        // In case settings were already changed, they should take precedence.
        ...(state.settings || {})
      };
    })
  });
  const fetchSaveSettingsStore = (0,_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
    baseName: 'saveSettings',
    controlCallback: params => {
      const {
        values
      } = params;
      return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)(type, identifier, datapoint, values);
    },
    reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, values) => {
      state.savedSettings = {
        ...values
      };
      // Ensure client settings are refreshed from server.
      state.settings = {
        ...values
      };
    }),
    argsToParams: values => {
      return {
        values
      };
    },
    validateParams: ({
      values
    } = {}) => {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(values), 'values is required.');
    }
  });

  // This will be populated further down with reducer functions for individual settings.
  const settingReducers = {};
  const actions = {
    /**
     * Sets settings for the given values.
     *
     * @since 1.6.0
     *
     * @param {Object} values Settings with their values to set.
     * @return {Object} Redux-style action.
     */
    setSettings(values) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(values), 'values is required.');
      return {
        payload: {
          values
        },
        type: SET_SETTINGS
      };
    },
    /**
     * Returns the current settings back to the current saved values.
     *
     * @since 1.7.1
     * @private
     *
     * @return {Object} Redux-style action.
     */
    rollbackSettings() {
      return {
        payload: {},
        type: ROLLBACK_SETTINGS
      };
    },
    /**
     * Returns a specific setting back to the current saved value.
     *
     * @since 1.147.0
     *
     * @param {string} setting The setting to rollback.
     * @return {Object} Redux-style action.
     */
    rollbackSetting(setting) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(setting, 'setting is required.');
      return {
        payload: {
          setting
        },
        type: ROLLBACK_SETTING
      };
    },
    /**
     * Saves all current settings to the server.
     *
     * @since 1.6.0
     *
     * @return {Object} Response and error, if any.
     */
    *saveSettings() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
      yield clearError('saveSettings', []);
      const values = registry.select(STORE_NAME).getSettings();
      const {
        response,
        error
      } = yield fetchSaveSettingsStore.actions.fetchSaveSettings(values);
      if (error) {
        // Store error manually since saveSettings signature differs from fetchSaveSettings.
        yield receiveError(error, 'saveSettings', []);
      }
      return {
        response,
        error
      };
    }
  };
  const controls = {};

  // eslint-disable-next-line no-shadow
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case SET_SETTINGS:
        {
          const {
            values
          } = payload;
          state.settings = {
            ...(state.settings || {}),
            ...values
          };
          break;
        }
      case ROLLBACK_SETTINGS:
        {
          state.settings = state.savedSettings;
          break;
        }
      case ROLLBACK_SETTING:
        {
          const {
            setting
          } = payload;
          if (state.savedSettings[setting]) {
            state.settings = {
              ...(state.settings || {}),
              [setting]: state.savedSettings[setting]
            };
          }
          break;
        }
      default:
        {
          // Check if this action is for a reducer for an individual setting.
          if ('undefined' !== typeof settingReducers[type]) {
            settingReducers[type](state, {
              type,
              payload
            });
          }
          break;
        }
    }
  });
  const resolvers = {
    *getSettings() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
      const existingSettings = registry.select(STORE_NAME).getSettings();
      // If settings are already present, don't fetch them.
      if (!existingSettings) {
        yield fetchGetSettingsStore.actions.fetchGetSettings();
      }
    }
  };
  const {
    safeSelector: haveSettingsChanged,
    dangerousSelector: __dangerousHaveSettingsChanged
  } = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.createValidationSelector)(validateHaveSettingsChanged);
  const selectors = {
    /**
     * Indicates whether the current settings have changed from what is saved.
     *
     * @since 1.6.0
     * @since 1.77.0 Added ability to filter settings using `keys` argument.
     * @since 1.129.0 Changed the approach to use validateHaveSettingsChanged callback.
     * @since 1.131.0 Updated implementation to use safeSelector and dangerousSelector returned from createValidationSelector.
     *
     * @param {Object}     state Data store's state.
     * @param {Array|null} keys  Settings keys to check; if not provided, all settings are checked.
     * @return {boolean} True if the settings have changed, false otherwise.
     */
    haveSettingsChanged,
    __dangerousHaveSettingsChanged,
    /**
     * Gets the current settings.
     *
     * Returns `undefined` if notifications are not available/loaded.
     *
     * @since 1.6.0
     *
     * @param {Object} state Data store's state.
     * @return {(Object|undefined)} Settings with their values, or undefined.
     */
    getSettings(state) {
      return state.settings;
    },
    /**
     * Indicates whether the provided setting has changed from what is saved.
     *
     * @since 1.72.0
     *
     * @param {Object} state   Data store's state.
     * @param {string} setting The setting we want to check for saved changes.
     * @return {boolean} True if the settings have changed, false otherwise.
     */
    hasSettingChanged(state, setting) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(setting, 'setting is required.');
      const {
        settings,
        savedSettings
      } = state;
      if (!settings || !savedSettings) {
        return false;
      }
      return !(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(settings[setting], savedSettings[setting]);
    },
    /**
     * Indicates whether saving the settings is currently in progress.
     *
     * @since 1.6.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} True if the settings are being saved, false otherwise.
     */
    isDoingSaveSettings(state) {
      // Since isFetchingSaveSettings (via createFetchStore)
      // holds information based on specific values but we only need
      // generic information here, we need to check whether ANY such
      // request is in progress.
      return Object.values(state.isFetchingSaveSettings).some(Boolean);
    },
    /**
     * Gets the owned settings slugs for this module.
     *
     * @since 1.77.0
     *
     * @param {Object} state Data store's state.
     * @return {Array|null} The array of owned settings slugs for this module if they exist. Returns `null` if no owned settings slugs exist.
     */
    getOwnedSettingsSlugs: state => {
      return state.ownedSettingsSlugs;
    },
    /**
     * Returns `true` if a module's "own settings" have changed; `false` if not.
     *
     * @since 1.77.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} `true` if the module's "own settings" have changed; `false` if not.
     */
    haveOwnedSettingsChanged: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
      const ownedSettingsSlugsToCheck = select(STORE_NAME).getOwnedSettingsSlugs();
      return select(STORE_NAME).haveSettingsChanged(ownedSettingsSlugsToCheck);
    })
  };

  // Define individual actions, selectors and related for sub-settings.
  settingSlugs.forEach(slug => {
    const pascalCaseSlug = (0,_transform_case__WEBPACK_IMPORTED_MODULE_5__.camelCaseToPascalCase)(slug);
    const constantSlug = (0,_transform_case__WEBPACK_IMPORTED_MODULE_5__.camelCaseToConstantCase)(slug);

    /**
     * Sets the setting indicated by the action name to the given value.
     *
     * @since 1.6.0
     *
     * @param {*} value Value for the setting.
     * @return {Object} Redux-style action.
     */
    actions[`set${pascalCaseSlug}`] = value => {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof value !== 'undefined', `value is required for calls to set${pascalCaseSlug}().`);
      return {
        payload: {
          value
        },
        type: `SET_${constantSlug}`
      };
    };
    settingReducers[`SET_${constantSlug}`] = (state, {
      payload
    }) => {
      const {
        value
      } = payload;
      state.settings = {
        ...(state.settings || {}),
        [slug]: value
      };
    };

    /**
     * Gets the current value for the setting indicated by the selector name.
     *
     * @since 1.6.0
     *
     * @return {*} Setting value, or undefined.
     */
    selectors[`get${pascalCaseSlug}`] = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
      const settings = select(STORE_NAME).getSettings() || {};
      return settings[slug];
    });
  });
  const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonStore, fetchGetSettingsStore, fetchSaveSettingsStore, {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  });
  return {
    ...store,
    STORE_NAME
  };
}

/**
 * Creates a default submitChanges control function.
 *
 * @since 1.21.0
 *
 * @param {string} slug      Module slug.
 * @param {string} storeName Datastore slug.
 * @return {Function} Control function to submit changes.
 */
function makeDefaultSubmitChanges(slug, storeName) {
  return async ({
    select,
    dispatch
  }) => {
    if (select(storeName).haveSettingsChanged()) {
      const {
        error
      } = await dispatch(storeName).saveSettings();
      if (error) {
        return {
          error
        };
      }
    }
    await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.invalidateCache)('modules', slug);
    return {};
  };
}

/**
 * Creates a default rollbackChanges control function.
 *
 * @since 1.45.0
 *
 * @param {string} storeName Datastore slug.
 * @return {Function} Control function to rollback settings changes.
 */
function makeDefaultRollbackChanges(storeName) {
  return ({
    select,
    dispatch
  }) => {
    if (select(storeName).haveSettingsChanged()) {
      return dispatch(storeName).rollbackSettings();
    }
    return {};
  };
}

/**
 * Creates a default canSubmitChanges function.
 *
 * @since 1.21.0
 *
 * @param {string} storeName Datastore slug.
 * @return {Function} A function to check if settings can be submitted.
 */
function makeDefaultCanSubmitChanges(storeName) {
  return select => {
    const strictSelect = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.createStrictSelect)(select);
    const {
      haveSettingsChanged,
      isDoingSubmitChanges
    } = strictSelect(storeName);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(!isDoingSubmitChanges(), INVARIANT_DOING_SUBMIT_CHANGES);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(haveSettingsChanged(), INVARIANT_SETTINGS_NOT_CHANGED);
  };
}

/**
 * Creates Default haveSettingsChanged.
 *
 * @since 1.129.0
 *
 * @return {boolean} True if the settings have changed, false otherwise.
 */
function makeDefaultHaveSettingsChanged() {
  return (select, state, keys) => {
    const {
      settings,
      savedSettings
    } = state;
    if (keys) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)((0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(settings, keys), (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(savedSettings, keys)), INVARIANT_SETTINGS_NOT_CHANGED);
    }
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(settings, savedSettings), INVARIANT_SETTINGS_NOT_CHANGED);
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/transform-case.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/transform-case.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCaseToConstantCase: () => (/* binding */ camelCaseToConstantCase),
/* harmony export */   camelCaseToPascalCase: () => (/* binding */ camelCaseToPascalCase),
/* harmony export */   hyphenCaseToPascalCase: () => (/* binding */ hyphenCaseToPascalCase)
/* harmony export */ });
/**
 * Data store utilities for transforming names to a certain case.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Transforms a camelCase name into its PascalCase name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} PascalCase name.
 */
function camelCaseToPascalCase(name) {
  return name.charAt(0).toUpperCase() + name.slice(1);
}

/**
 * Transforms a camelCase name into its CONSTANT_CASE name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} CONSTANT_CASE name.
 */
function camelCaseToConstantCase(name) {
  return name.replace(/([a-z0-9]{1})([A-Z]{1})/g, '$1_$2').toUpperCase();
}

/**
 * Transforms a hyphen-case name into its PascalCase name.
 *
 * @since 1.30.0
 * @private
 *
 * @param {string} name "hyphen-case" name to transform.
 * @return {string} PascalCase name.
 */
function hyphenCaseToPascalCase(name) {
  return name.split('-').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join('');
}

/***/ }),

/***/ "./js/googlesitekit/data/utils.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   collect: () => (/* binding */ collect),
/* harmony export */   collectActions: () => (/* binding */ collectActions),
/* harmony export */   collectControls: () => (/* binding */ collectControls),
/* harmony export */   collectName: () => (/* binding */ collectName),
/* harmony export */   collectReducers: () => (/* binding */ collectReducers),
/* harmony export */   collectResolvers: () => (/* binding */ collectResolvers),
/* harmony export */   collectSelectors: () => (/* binding */ collectSelectors),
/* harmony export */   collectState: () => (/* binding */ collectState),
/* harmony export */   combineStores: () => (/* binding */ combineStores),
/* harmony export */   commonActions: () => (/* binding */ commonActions),
/* harmony export */   commonControls: () => (/* binding */ commonControls),
/* harmony export */   commonStore: () => (/* binding */ commonStore),
/* harmony export */   createStrictSelect: () => (/* binding */ createStrictSelect),
/* harmony export */   createValidatedAction: () => (/* binding */ createValidatedAction),
/* harmony export */   createValidationSelector: () => (/* binding */ createValidationSelector)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/**
 * Data store utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */

const GET_REGISTRY = 'GET_REGISTRY';
const AWAIT = 'AWAIT';

/**
 * Collects and combines multiple objects of similar shape.
 *
 * Used to combine objects like actions, selectors, etc. for a data
 * store while ensuring no keys/action names/selector names are duplicated.
 *
 * Effectively this is an object spread, but throws an error if keys are
 * duplicated.
 *
 * @since 1.5.0
 * @private
 *
 * @param {...Object} items A list of arguments, each one should be an object to combine into one.
 * @return {Object} The combined object.
 */
function collect(...items) {
  const collectedObject = items.reduce((acc, item) => {
    return {
      ...acc,
      ...item
    };
  }, {});
  const functionNames = items.reduce((acc, itemSet) => {
    return [...acc, ...Object.keys(itemSet)];
  }, []);
  const duplicates = findDuplicates(functionNames);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === 0, `collect() cannot accept collections with duplicate keys. Your call to collect() contains the following duplicated functions: ${duplicates.join(', ')}. Check your data stores for duplicates.`);
  return collectedObject;
}

/**
 * Collects all actions.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own actions.
 * @return {Object} The combined object.
 */
const collectActions = collect;

/**
 * Collects all controls.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own controls.
 * @return {Object} The combined object.
 */
const collectControls = collect;

/**
 * Collects all reducers and (optionally) provides initial state.
 *
 * If the first argument passed is not a function, it will be used as the
 * combined reducer's `initialState`.
 *
 * @since 1.5.0
 *
 * @param {...(Object|Function)} args A list of reducers, each containing their own controls. If the first argument is not a function, it will be used as the combined reducer's `initialState`.
 * @return {Function} A Redux-style reducer.
 */
function collectReducers(...args) {
  const reducers = [...args];
  let initialState;
  if (typeof reducers[0] !== 'function') {
    initialState = reducers.shift();
  }
  return (state = initialState, action = {}) => {
    return reducers.reduce((newState, reducer) => {
      return reducer(newState, action);
    }, state);
  };
}

/**
 * Collects all resolvers.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own resolvers.
 * @return {Object} The combined object.
 */
const collectResolvers = collect;

/**
 * Collects all selectors.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own selectors.
 * @return {Object} The combined object.
 */
const collectSelectors = collect;

/**
 * Collects all state values.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own state values.
 * @return {Object} The combined object.
 */
const collectState = collect;

/**
 * Collects all store names.
 *
 * This function's main purpose is to ensure generated store names for a single store match.
 *
 * @since 1.6.0
 *
 * @param {...string} args A list of store names, all of which must be equal.
 * @return {string} The single store name.
 */
function collectName(...args) {
  const names = [...args];
  const duplicates = findDuplicates(names);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === names.length - 1, 'collectName() must not receive different names.');
  return names.shift();
}

/**
 * Passes through state unmodified; eg. an empty reducer.
 *
 * @since 1.8.0
 * @private
 *
 * @param {Object} state A store's state.
 * @return {Object} The same state data as passed in `state`.
 */
function passthroughReducer(state) {
  return state;
}

/**
 * Combines multiple stores.
 *
 * @since 1.8.0
 *
 * @param {...Object} stores A list of objects, each a store containing one or more of the following keys: initialState, actions, controls, reducer, resolvers, selectors.
 * @return {Object} The combined store.
 */
function combineStores(...stores) {
  const combinedInitialState = collectState(...stores.map(store => store.initialState || {}));
  return {
    initialState: combinedInitialState,
    controls: collectControls(...stores.map(store => store.controls || {})),
    actions: collectActions(...stores.map(store => store.actions || {})),
    reducer: collectReducers(combinedInitialState, ...stores.map(store => store.reducer || passthroughReducer)),
    resolvers: collectResolvers(...stores.map(store => store.resolvers || {})),
    selectors: collectSelectors(...stores.map(store => store.selectors || {}))
  };
}

/**
 * An object of common actions most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common actions most stores will want.
 */
const commonActions = {
  /**
   * Dispatches an action and calls a control to get the current data registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  getRegistry() {
    return {
      payload: {},
      type: GET_REGISTRY
    };
  },
  /**
   * Dispatches an action and calls a control to return the promise resolution.
   *
   * Useful for controls and resolvers that wish to call an asynchronous function or other promise.
   *
   * @since 1.22.0
   *
   * @param {Promise} value A promise to resolve.
   * @return {Object} Object with resolved promise.
   */
  *await(value) {
    return {
      payload: {
        value
      },
      type: AWAIT
    };
  }
};

/**
 * An object of common controls most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common controls most stores will want.
 */
const commonControls = {
  /**
   * Returns the current registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  [GET_REGISTRY]: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistryControl)(registry => () => registry),
  /**
   * Returns a resolved promise.
   *
   * @since 1.22.0
   *
   * @param {Object} payload         Object containing a promise.
   * @param {Object} payload.payload Object containing a promise.
   * @return {*} Resolved promise.
   */
  [AWAIT]: ({
    payload
  }) => payload.value
};

/**
 * Finds all duplicate items in an array and return them.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} array Any array.
 * @return {Array} All values in the input array that were duplicated.
 */
function findDuplicates(array) {
  const duplicates = [];
  const counts = {};
  for (let i = 0; i < array.length; i++) {
    const item = array[i];
    counts[item] = counts[item] >= 1 ? counts[item] + 1 : 1;
    if (counts[item] > 1) {
      duplicates.push(item);
    }
  }
  return duplicates;
}

/**
 * A store containing the common actions, controls and reducer that all stores will use.
 *
 * @since 1.8.0
 *
 * @return {Object} Object with common actions, controls and reducer.
 */
const commonStore = {
  actions: commonActions,
  controls: commonControls,
  reducer: passthroughReducer
};

/**
 * Creates a strict version of registry.select for ensuring that a selector is resolved at the time of calling.
 *
 * Not intended to be used directly. This is useful in the context of validation functions
 * to save checking for undefined on every result.
 *
 * Given the registry.select function instance, a new function is returned
 * with the same API as `select()` but will throw an error if the result
 * of the selector function is `undefined`.
 *
 * Ideally this would use something like `hasFinishedResolution` instead,
 * but there is no way to traverse the selectors used internally to identify
 * dependent selectors that have resolvers as many selectors are composed of
 * higher-level selectors internally which is where a resolver is normally implemented.
 *
 * @since 1.18.0
 * @private
 *
 * @param {Function} select The registry.select function.
 * @return {Function} The strict version of registry.select.
 */
function createStrictSelect(select) {
  return storeName => {
    return getStrictSelectors(select(storeName));
  };
}

// Based on {@link https://github.com/WordPress/gutenberg/blob/b1c8026087dfb026eff0a023a5f7febe28c876de/packages/data/src/registry.js#L91}
const getStrictSelectors = memize__WEBPACK_IMPORTED_MODULE_1___default()(selectors => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.mapValues)(selectors, (selector, selectorName) => (...args) => {
  const returnValue = selector(...args);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(returnValue !== undefined, `${selectorName}(...) is not resolved`);
  return returnValue;
}));

/**
 * Creates two registry selectors that call the incoming function to validate the current state.
 *
 * @since 1.19.0
 *
 * @param {Function} validate         Validation function callback.
 * @param {Object}   [options]        Options to modify the behavior of the generated selectors.
 * @param {boolean}  [options.negate] Whether to negate the boolean result or not. Default: false.
 * @return {Object} Safe and dangerous selectors.
 */
function createValidationSelector(validate, {
  negate = false
} = {}) {
  const safeSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    const pass = negate ? false : true;
    const fail = negate ? true : false;
    try {
      validate(select, state, ...args);
      return pass;
    } catch {
      return fail;
    }
  });
  const dangerousSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    validate(select, state, ...args);
  });
  return {
    safeSelector,
    dangerousSelector
  };
}

/**
 * Creates a validated action creator.
 *
 * @since 1.32.0
 *
 * @param {Function} validate      A function for validating action arguments.
 * @param {Function} actionCreator A function for returning or yielding redux-style actions.
 * @return {Function} An enhanced action creator.
 */
function createValidatedAction(validate, actionCreator) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof validate === 'function', 'a validator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof actionCreator === 'function', 'an action creator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(validate[Symbol.toStringTag] !== 'Generator' && validate[Symbol.toStringTag] !== 'GeneratorFunction', 'an action’s validator function must not be a generator.');
  return (...args) => {
    validate(...args);
    return actionCreator(...args);
  };
}

/***/ }),

/***/ "./js/googlesitekit/datastore/location/constants.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/datastore/location/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_LOCATION: () => (/* binding */ CORE_LOCATION)
/* harmony export */ });
/**
 * `core/location` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_LOCATION = 'core/location';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/info.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/datastore/site/info.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var query_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! query-string */ "../node_modules/query-string/index.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_negate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/negate */ "./js/util/negate.js");
/**
 * `core/site` data store: site info.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function getSiteInfoProperty(propName) {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const siteInfo = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteInfo() || {};
    return siteInfo[propName];
  });
}

// Actions
const RECEIVE_SITE_INFO = 'RECEIVE_SITE_INFO';
const RECEIVE_PERMALINK_PARAM = 'RECEIVE_PERMALINK_PARAM';
const SET_SITE_KIT_AUTO_UPDATES_ENABLED = 'SET_SITE_KIT_AUTO_UPDATES_ENABLED';
const SET_KEY_METRICS_SETUP_COMPLETED_BY = 'SET_KEY_METRICS_SETUP_COMPLETED_BY';
const SET_SETUP_ERROR_CODE = 'SET_SETUP_ERROR_CODE';
const initialState = {
  siteInfo: undefined,
  permaLink: false
};
const actions = {
  /**
   * Stores site info in the datastore.
   *
   * Because this is frequently-accessed data, this is usually sourced
   * from a global variable (`_googlesitekitSiteData`), set by PHP
   * in the `before_print` callback for `googlesitekit-datastore-site`.
   *
   * @since 1.7.0
   * @private
   *
   * @param {Object} siteInfo Site info, usually supplied via a global variable from PHP.
   * @return {Object} Redux-style action.
   */
  receiveSiteInfo(siteInfo) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(siteInfo, 'siteInfo is required.');
    return {
      payload: {
        siteInfo
      },
      type: RECEIVE_SITE_INFO
    };
  },
  receivePermaLinkParam(permaLink) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(permaLink, 'permaLink is required.');
    return {
      payload: {
        permaLink
      },
      type: RECEIVE_PERMALINK_PARAM
    };
  },
  /**
   * Sets `siteKitAutoUpdatesEnabled` value; if set to `true` this will
   * enable auto-updates for Site Kit. Set to `false` to disable this
   * behaviour.
   *
   * @since 1.93.0
   *
   * @param {boolean} siteKitAutoUpdatesEnabled Whether Site Kit auto-updates are enabled.
   * @return {Object} Redux-style action.
   */
  setSiteKitAutoUpdatesEnabled(siteKitAutoUpdatesEnabled) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof siteKitAutoUpdatesEnabled === 'boolean', 'siteKitAutoUpdatesEnabled must be a boolean.');
    return {
      payload: {
        siteKitAutoUpdatesEnabled
      },
      type: SET_SITE_KIT_AUTO_UPDATES_ENABLED
    };
  },
  /**
   * Sets the `setKeyMetricsSetupCompletedBy` value.
   *
   * @since 1.113.0
   *
   * @param {number} keyMetricsSetupCompletedBy Positive integer if key metrics setup is completed, otherwise 0.
   * @return {Object} Redux-style action.
   */
  setKeyMetricsSetupCompletedBy(keyMetricsSetupCompletedBy) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof keyMetricsSetupCompletedBy === 'number', 'keyMetricsSetupCompletedBy must be a number.');
    return {
      payload: {
        keyMetricsSetupCompletedBy
      },
      type: SET_KEY_METRICS_SETUP_COMPLETED_BY
    };
  },
  /**
   * Sets `setupErrorCode` value.
   *
   * @since 1.131.0
   *
   * @param {string|null} setupErrorCode Error code from setup, or `null` if no error.
   * @return {Object} Redux-style action.
   */
  setSetupErrorCode(setupErrorCode) {
    // setupErrorCode can be a string or null.
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof setupErrorCode === 'string' || setupErrorCode === null, 'setupErrorCode must be a string or null.');
    return {
      payload: {
        setupErrorCode
      },
      type: SET_SETUP_ERROR_CODE
    };
  }
};
const controls = {};
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, {
  payload,
  type
}) => {
  switch (type) {
    case RECEIVE_SITE_INFO:
      const {
        adminURL,
        ampMode,
        currentEntityID,
        currentEntityTitle,
        currentEntityType,
        currentEntityURL,
        homeURL,
        proxyPermissionsURL,
        proxySetupURL,
        referenceSiteURL,
        setupErrorCode,
        setupErrorMessage,
        setupErrorRedoURL,
        siteName,
        siteLocale,
        timezone,
        startOfWeek,
        usingProxy,
        webStoriesActive,
        proxySupportLinkURL,
        widgetsAdminURL,
        postTypes,
        wpVersion,
        updateCoreURL,
        changePluginAutoUpdatesCapacity,
        siteKitAutoUpdatesEnabled,
        pluginBasename,
        productPostType,
        keyMetricsSetupCompletedBy,
        keyMetricsSetupNew,
        consentModeRegions,
        anyoneCanRegister,
        isMultisite
      } = payload.siteInfo;
      state.siteInfo = {
        adminURL,
        ampMode,
        currentEntityID: parseInt(currentEntityID, 10),
        currentEntityTitle,
        currentEntityType,
        currentEntityURL,
        homeURL,
        proxyPermissionsURL,
        proxySetupURL,
        referenceSiteURL,
        setupErrorCode,
        setupErrorMessage,
        setupErrorRedoURL,
        siteName,
        siteLocale,
        timezone,
        startOfWeek,
        usingProxy,
        webStoriesActive,
        proxySupportLinkURL,
        widgetsAdminURL,
        postTypes,
        wpVersion,
        updateCoreURL,
        changePluginAutoUpdatesCapacity,
        siteKitAutoUpdatesEnabled,
        pluginBasename,
        productPostType,
        keyMetricsSetupCompletedBy,
        keyMetricsSetupNew,
        consentModeRegions,
        anyoneCanRegister,
        isMultisite
      };
      break;
    case RECEIVE_PERMALINK_PARAM:
      {
        state.permaLink = payload.permaLink;
        break;
      }
    case SET_SITE_KIT_AUTO_UPDATES_ENABLED:
      {
        if (!state.siteInfo) {
          state.siteInfo = {};
        }
        state.siteInfo.siteKitAutoUpdatesEnabled = payload.siteKitAutoUpdatesEnabled;
        break;
      }
    case SET_KEY_METRICS_SETUP_COMPLETED_BY:
      {
        if (!state.siteInfo) {
          state.siteInfo = {};
        }
        state.siteInfo.keyMetricsSetupCompletedBy = payload.keyMetricsSetupCompletedBy;
        break;
      }
    case SET_SETUP_ERROR_CODE:
      {
        if (!state.siteInfo) {
          state.siteInfo = {};
        }
        state.siteInfo.setupErrorCode = payload.setupErrorCode;
        break;
      }
    default:
      break;
  }
});
const resolvers = {
  *getSiteInfo() {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    if (registry.select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteInfo()) {
      return;
    }
    if (!__webpack_require__.g._googlesitekitBaseData || !__webpack_require__.g._googlesitekitEntityData) {
      __webpack_require__.g.console.error('Could not load core/site info.');
      return;
    }
    const {
      adminURL,
      ampMode,
      homeURL,
      proxyPermissionsURL,
      proxySetupURL,
      referenceSiteURL,
      setupErrorCode,
      setupErrorMessage,
      setupErrorRedoURL,
      siteName,
      siteLocale,
      timezone,
      startOfWeek,
      usingProxy,
      webStoriesActive,
      proxySupportLinkURL,
      widgetsAdminURL,
      postTypes,
      wpVersion,
      updateCoreURL,
      changePluginAutoUpdatesCapacity,
      siteKitAutoUpdatesEnabled,
      pluginBasename,
      productPostType,
      keyMetricsSetupCompletedBy,
      keyMetricsSetupNew,
      consentModeRegions,
      anyoneCanRegister,
      isMultisite
    } = __webpack_require__.g._googlesitekitBaseData;
    const {
      currentEntityID,
      currentEntityTitle,
      currentEntityType,
      currentEntityURL
    } = __webpack_require__.g._googlesitekitEntityData;
    yield actions.receiveSiteInfo({
      adminURL,
      ampMode,
      currentEntityID,
      currentEntityTitle,
      currentEntityType,
      currentEntityURL,
      homeURL,
      proxyPermissionsURL,
      proxySetupURL,
      referenceSiteURL,
      setupErrorCode,
      setupErrorMessage,
      setupErrorRedoURL,
      siteName,
      siteLocale,
      timezone,
      startOfWeek,
      postTypes,
      usingProxy: !!usingProxy,
      webStoriesActive,
      proxySupportLinkURL,
      widgetsAdminURL,
      wpVersion,
      updateCoreURL,
      changePluginAutoUpdatesCapacity,
      siteKitAutoUpdatesEnabled,
      pluginBasename,
      productPostType,
      keyMetricsSetupCompletedBy,
      keyMetricsSetupNew,
      consentModeRegions,
      anyoneCanRegister,
      isMultisite
    });
  }
};
const selectors = {
  /**
   * Gets all site info from this data store.
   *
   * Not intended to be used publicly; this is largely here so other selectors can
   * request data using the selector/resolver pattern.
   *
   * @since 1.7.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Site connection info.
   */
  getSiteInfo(state) {
    return state.siteInfo;
  },
  /**
   * Gets a site's admin URL.
   *
   * @since 1.7.0
   *
   * @param {Object}             state Data store's state.
   * @param {(string|undefined)} page  Optional page query argument ( Simple format: 'test-page' or Full format: 'custom.php?page=test-page' ) to add to admin URL. If not provided, the base admin URL is returned.
   * @param {(Object|undefined)} args  Optional additional query arguments to add to admin URL.
   * @return {(string|undefined)} This site's admin URL.
   */
  getAdminURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, page, args = {}) => {
    const {
      adminURL
    } = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteInfo() || {};

    // Return adminURL if undefined, or if no page supplied.
    if (adminURL === undefined || page === undefined) {
      return adminURL;
    }
    const baseURL = adminURL[adminURL.length - 1] === '/' ? adminURL : `${adminURL}/`;
    let pageArg = page;
    let phpFile = 'admin.php';

    // If page argument is full format (i.e. 'admin.php?page=google-site-kit'), extract php file and pageArg, returning early with adminURL if no 'page' param found.
    if (page.indexOf('.php?') !== -1) {
      const splitPage = page.split('?');
      pageArg = query_string__WEBPACK_IMPORTED_MODULE_1__.parse(splitPage.pop()).page;
      if (!pageArg) {
        return adminURL;
      }
      phpFile = splitPage.shift();
    }

    // Since page should be first query arg, create queryArgs without 'page' to prevent a 'page' in args from overriding it.
    const {
      page: extraPage,
      ...queryArgs
    } = args; // eslint-disable-line no-unused-vars

    return (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_6__.addQueryArgs)(`${baseURL}${phpFile}`, {
      page: pageArg,
      ...queryArgs
    });
  }),
  /**
   * Gets a site's AMP mode.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} AMP Mode.
   */
  getAMPMode: getSiteInfoProperty('ampMode'),
  /**
   * Gets the current entity's ID.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(number|null|undefined)} Current entity's ID, null if there is
   *                                   none, undefined if not loaded yet.
   */
  getCurrentEntityID: getSiteInfoProperty('currentEntityID'),
  /**
   * Gets the current entity's title.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} Current entity's title, null if there
   *                                   is none, undefined if not loaded yet.
   */
  getCurrentEntityTitle: getSiteInfoProperty('currentEntityTitle'),
  /**
   * Gets the current entity's title.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} Current entity's type, null if there
   *                                   is none, undefined if not loaded yet.
   */
  getCurrentEntityType: getSiteInfoProperty('currentEntityType'),
  /**
   * Gets the current entity's reference URL.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} Current entity's URL, null if there is
   *                                   none, undefined if not loaded yet.
   */
  getCurrentEntityURL: getSiteInfoProperty('currentEntityURL'),
  /**
   * Gets a site's homepage URL.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} This site's home URL.
   */
  getHomeURL: getSiteInfoProperty('homeURL'),
  /**
   * Gets a site's reference site URL.
   *
   * @since 1.7.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} The reference site URL.
   */
  getReferenceSiteURL: getSiteInfoProperty('referenceSiteURL'),
  /**
   * Gets proxy setup URL.
   *
   * @since 1.14.0
   *
   * @return {string} Proxy setup URL if available, otherwise an empty string.
   */
  getProxySetupURL: getSiteInfoProperty('proxySetupURL'),
  /**
   * Gets proxy permissions URL.
   *
   * @since 1.14.0
   *
   * @return {string} Proxy permissions URL if available, otherwise an empty string.
   */
  getProxyPermissionsURL: getSiteInfoProperty('proxyPermissionsURL'),
  /**
   * Gets the current reference URL to use.
   *
   * This selector should be used to get the contextual URL for requesting
   * URL-specific data from Google APIs.
   *
   * If a current entity exists, this will return the same value as the
   * `getCurrentEntityURL` selector. Otherwise it will fall back to returning
   * the same value as the `getReferenceSiteURL` selector.
   *
   * @since 1.10.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} The current reference URL, or undefined if
   *                              not loaded yet.
   */
  getCurrentReferenceURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    // Use current entity URL if present or still loading.
    const currentEntityURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getCurrentEntityURL();
    if (currentEntityURL !== null) {
      return currentEntityURL;
    }

    // Otherwise fall back to reference site URL.
    return select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getReferenceSiteURL();
  }),
  /**
   * Returns true if this site supports AMP.
   *
   * @since 1.7.0
   * @since 1.11.0 Renamed from isAmp to isAMP.
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} `true` if AMP support is enabled, `false` if not. Returns `undefined` if not loaded.
   */
  isAMP: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const ampMode = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAMPMode();
    if (ampMode === undefined) {
      return undefined;
    }
    return !!ampMode;
  }),
  /**
   * Checks if the site is in the primary AMP mode.
   *
   * @since 1.12.0
   *
   * @return {(boolean|undefined)} `true` or `false` if the site is in the primary AMP mode. Returns `undefined` if not loaded.
   */
  isPrimaryAMP: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const ampMode = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAMPMode();
    if (ampMode === undefined) {
      return undefined;
    }
    return ampMode === _constants__WEBPACK_IMPORTED_MODULE_3__.AMP_MODE_PRIMARY;
  }),
  /**
   * Checks if the site is in a secondary AMP mode.
   *
   * @since 1.12.0
   *
   * @return {(boolean|undefined)} `true` or `false` if the site is in a secondary AMP mode. Returns `undefined` if not loaded.
   */
  isSecondaryAMP: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const ampMode = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAMPMode();
    if (ampMode === undefined) {
      return undefined;
    }
    return ampMode === _constants__WEBPACK_IMPORTED_MODULE_3__.AMP_MODE_SECONDARY;
  }),
  /**
   * Retrieves an admin settings URL, pointing to either network or single-site settings
   * depending on whether the site is multisite.
   *
   * @since 1.146.0
   *
   * @return {string|undefined} The admin settings URL, or undefined if required data is unavailable.
   */
  getAdminSettingsURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const adminURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getAdminURL();
    const isMultisite = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isMultisite();
    if (adminURL === undefined || isMultisite === undefined) {
      return undefined;
    }
    return new URL(isMultisite === true ? 'network/settings.php' : 'options-general.php', adminURL).href;
  }),
  /**
   * Gets a site's timezone.
   *
   * @since 1.9.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} The timezone.
   */
  getTimezone: getSiteInfoProperty('timezone'),
  /**
   * Gets the WordPress "start of week" option for the site.
   *
   * 0 = Sunday, 1 = Monday, ... 6 = Saturday.
   *
   * @since 1.164.0
   *
   * @param {Object} state Data store's state.
   * @return {(number|undefined)} The start of week index, or undefined while loading.
   */
  getStartOfWeek: getSiteInfoProperty('startOfWeek'),
  /**
   * Returns true if this site is using the proxy service.
   *
   * @since 1.9.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if the proxy service is in use, `false` if not. Returns `undefined` if not loaded.
   */
  isUsingProxy: getSiteInfoProperty('usingProxy'),
  /**
   * Gets a site's name.
   *
   * @since 1.9.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} The site name.
   */
  getSiteName: getSiteInfoProperty('siteName'),
  /**
   * Gets a site's locale.
   *
   * @since 1.147.0
   *
   * @return {(string|undefined)} The site locale.
   */
  getSiteLocale: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteInfo()?.siteLocale?.replace('_', '-')),
  /**
   * Gets a setup error code, if one exists.
   *
   * @since 1.80.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|undefined)} An error code from setup, if one exists. Will be `null` if no error exists; `undefined` when loading.
   */
  getSetupErrorCode: getSiteInfoProperty('setupErrorCode'),
  /**
   * Gets a setup error message, if one exists.
   *
   * @since 1.77.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} An error message from setup, if one exists. Will be `null` if no error exists; `undefined` when loading.
   */
  getSetupErrorMessage: getSiteInfoProperty('setupErrorMessage'),
  /**
   * Gets a setup redo URL, if one exists after encountering a setup error.
   *
   * This URL will be used to redo the setup process if a user encountered
   * an error.
   *
   * @since 1.77.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} The setup URL, if one exists. Will be `null` if no error exists and thus the setup redo URL doesn't exist; `undefined` when loading.
   */
  getSetupErrorRedoURL: getSiteInfoProperty('setupErrorRedoURL'),
  /**
   * Gets the proxy support URL.
   *
   * @since 1.80.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null)} The proxy support URL.
   */
  getProxySupportLinkURL: getSiteInfoProperty('proxySupportLinkURL'),
  /**
   * Gets the admin widgets editor URL.
   *
   * @since 1.81.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null)} The proxy support URL.
   */
  getWidgetsAdminURL: getSiteInfoProperty('widgetsAdminURL'),
  /**
   * Gets the public post types.
   *
   * @since 1.81.0
   *
   * @param {Object} state Data store's state.
   * @return {Array.<Object>} The public post types.
   */
  getPostTypes: getSiteInfoProperty('postTypes'),
  /**
   * Gets the 'permaLink' query parameter.
   *
   * @since 1.18.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|boolean)} Value of the 'permaLink' query parameter or `false` if not set.
   */
  getPermaLinkParam: state => {
    if (state.permaLink) {
      return state.permaLink;
    }
    const queryArg = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.getQueryArg)(__webpack_require__.g.location.href, 'permaLink');
    return queryArg ? queryArg : false;
  },
  /**
   * Returns true if this site has the Web Stories plugin enabled.
   *
   * @since 1.27.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if the Web Stories plugin is enabled, `false` if not. Returns `undefined` if not loaded.
   */
  isWebStoriesActive: getSiteInfoProperty('webStoriesActive'),
  /**
   * Determines whether the provided URL matches reference site URL or not.
   *
   * @since 1.32.0
   *
   * @param {string} url The URL to compare with the reference site URL.
   * @return {boolean} TRUE if the URL matches reference site URL, otherwise FALSE.
   */
  isSiteURLMatch: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, url) => {
    const referenceURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getReferenceSiteURL();
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.normalizeURL)(referenceURL) === (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.normalizeURL)(url);
  }),
  /**
   * Gets an array with site URL permutations.
   *
   * @since 1.34.0
   *
   * @return {Array.<string>} An array with permutations.
   */
  getSiteURLPermutations: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const referenceURL = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getReferenceSiteURL();
    const permutations = [];
    const url = new URL(referenceURL);
    url.hostname = url.hostname.replace(/^www\./i, '');
    url.protocol = 'http';
    permutations.push((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.untrailingslashit)(url));
    url.protocol = 'https';
    permutations.push((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.untrailingslashit)(url));
    url.hostname = 'www.' + url.hostname;
    permutations.push((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.untrailingslashit)(url));
    url.protocol = 'http';
    permutations.push((0,_js_util__WEBPACK_IMPORTED_MODULE_4__.untrailingslashit)(url));
    return permutations;
  }),
  /**
   * Gets the WordPress version object.
   *
   * @since 1.85.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} WordPress version object.
   */
  getWPVersion: getSiteInfoProperty('wpVersion'),
  /**
   * Gets the WordPress update core URL.
   *
   * @since 1.85.0
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} WordPress update core URL.
   */
  getUpdateCoreURL: getSiteInfoProperty('updateCoreURL'),
  /**
   * Determines if Site Kit auto update settings can be changed.
   *
   * Auto update settings can not be changed if plugin updates are disabled site-wide
   * or if Site Kit auto updates are enforced by a PHP filter.
   *
   * @since 1.93.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if plugin auto updates are enabled, otherwise `false`.
   */
  hasChangePluginAutoUpdatesCapacity: getSiteInfoProperty('changePluginAutoUpdatesCapacity'),
  /**
   * Determines if the auto updates are enabled for the Site Kit plugin.
   *
   * @since 1.93.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if Site Kit auto updates are enabled, otherwise `false`.
   */
  getSiteKitAutoUpdatesEnabled: getSiteInfoProperty('siteKitAutoUpdatesEnabled'),
  /**
   * Get the plugin basename.
   *
   * @since 1.93.0
   *
   * @param {Object} state Data store's state.
   * @return {string} The basename of plugin, e.g. `'google-site-kit/google-site-kit.php'`.
   */
  getPluginBasename: getSiteInfoProperty('pluginBasename'),
  /**
   * Get the user ID of the user who setup Key Metrics widget if present.
   *
   * @since 1.113.0
   *
   * @return {number} `ID` of the user who did initial setup of the Key Metrics widget, if setup was done, otherwise `0`.
   */
  getKeyMetricsSetupCompletedBy: getSiteInfoProperty('keyMetricsSetupCompletedBy'),
  /**
   * Gets the state of whether or not Key Metrics was recently set up.
   *
   * @since 1.115.0
   *
   * @return {boolean} `true` if recently set up, otherwise `false`.
   */
  getKeyMetricsSetupNew: getSiteInfoProperty('keyMetricsSetupNew'),
  /**
   * Determines whether the current WordPress site has the minimum required version.
   * Currently, the minimum required version is 5.2.
   *
   * @since 1.85.0
   *
   * @param {string} minimumWPVersion The minimum required WordPress version.
   * @return {(boolean|undefined)} `true` if the WordPress site's version is greater than or equal to the minimum required version, `false` if not. Returns `undefined` if not loaded.
   */
  hasMinimumWordPressVersion: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, minimumWPVersion) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(minimumWPVersion, 'minimumWPVersion is required.');
    const {
      major,
      minor
    } = select(_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getWPVersion() || {};
    if (major === undefined || minor === undefined) {
      return undefined;
    }
    const [minimumMajor, minimumMinor = 0] = minimumWPVersion.split('.').map(v => parseInt(v, 10));
    return minimumMajor < major || minimumMajor === major && minimumMinor <= minor;
  }),
  /**
   * Gets product post type.
   *
   * @since 1.116.0
   *
   * @return {string|null} The product post type or null if not present.
   */
  getProductPostType: getSiteInfoProperty('productPostType'),
  /**
   * Checks if the Key Metrics widget has been setup either if at least one user
   * has answered the User Input questionnaire or picked their own metrics.
   *
   * @since 1.108.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean|undefined)} `true` if the Key Metrics widget has been setup, otherwise `false`.
   */
  isKeyMetricsSetupCompleted: state => {
    // Here we double-negate the value of the setup completed by state
    // in order to cast it to a boolean, but only if it's not undefined.
    return (0,_js_util_negate__WEBPACK_IMPORTED_MODULE_5__.negateDefined)((0,_js_util_negate__WEBPACK_IMPORTED_MODULE_5__.negateDefined)(selectors.getKeyMetricsSetupCompletedBy(state)));
  },
  /**
   * Get the static list of consent mode regions.
   *
   * @since 1.128.0
   *
   * @return {Array<string>} Array of consent mode regions.
   */
  getConsentModeRegions: getSiteInfoProperty('consentModeRegions'),
  /**
   * Checks if user registrations are open on this WordPress site.
   *
   * @since 1.141.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} `true` if registrations are open; `false` if not. Returns `undefined` if not yet loaded.
   */
  getAnyoneCanRegister: getSiteInfoProperty('anyoneCanRegister'),
  /**
   * Checks if WordPress site is running in the multisite mode.
   *
   * @since 1.142.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} `true` if it is multisite; `false` if not. Returns `undefined` if not yet loaded.
   */
  isMultisite: getSiteInfoProperty('isMultisite')
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVE_CONTEXT_ID: () => (/* binding */ ACTIVE_CONTEXT_ID),
/* harmony export */   CORE_UI: () => (/* binding */ CORE_UI)
/* harmony export */ });
/**
 * `core/ui` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_UI = 'core/ui';
const ACTIVE_CONTEXT_ID = 'activeContextID';

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   EMAIL_REPORT_FREQUENCIES: () => (/* binding */ EMAIL_REPORT_FREQUENCIES),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Email Report Frequency options.
const EMAIL_REPORT_FREQUENCIES = ['weekly', 'monthly', 'quarterly'];

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/notifications/components/common/LearnMoreLink.js":
/*!***************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/common/LearnMoreLink.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LearnMoreLink)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function LearnMoreLink({
  id,
  label,
  url,
  ariaLabel,
  gaTrackingEventArgs,
  external = true,
  ...otherProps
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__["default"])(id);
  function handleLearnMore(event) {
    event.persist();
    trackEvents.clickLearnMore(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_0__["default"], {
    onClick: handleLearnMore,
    href: url,
    "aria-label": ariaLabel,
    external: external,
    ...otherProps,
    children: label
  });
}
LearnMoreLink.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  url: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ariaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
  }),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/NoticeNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NoticeNotification)
/* harmony export */ });
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







function NoticeNotification({
  notificationID,
  children,
  dismissButton,
  ctaButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_1__["default"])(notificationID);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...(dismissButton?.dismissOptions || {})
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
        size: 12,
        alignMiddle: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_0__["default"], {
          dismissButton: {
            ...dismissButton,
            onClick: handleDismissWithTrackEvent
          },
          ctaButton: {
            ...ctaButton,
            onClick: handleCTAClickWithTrackEvent
          },
          ...props,
          children: children
        })
      })
    })
  });
}
NoticeNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/SetupCTA.js":
/*!**********************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/SetupCTA.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupCTA)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var _js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Banner/CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Banner/DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupCTA layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function SetupCTA({
  notificationID,
  title,
  description,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  footer,
  gaTrackingEventArgs,
  waitingProgress,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(notificationID, gaTrackingEventArgs?.category);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton?.dismissOptions
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  async function handleLearnMoreClickWithTrackEvent(event) {
    trackEvents.clickLearnMore(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await learnMoreLink?.onClick?.(event);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [!!waitingProgress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__.ProgressBar, {
      className: "googlesitekit-banner__progress-bar",
      ...waitingProgress
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-widget-context', {
        'googlesitekit-widget-context--with-progress-bar': !!waitingProgress
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Banner__WEBPACK_IMPORTED_MODULE_4__["default"], {
              className: "googlesitekit-banner--setup-cta",
              title: title,
              description: description,
              errorText: errorText,
              helpText: helpText,
              learnMoreLink: learnMoreLink && {
                ...learnMoreLink,
                onClick: handleLearnMoreClickWithTrackEvent
              },
              dismissButton: dismissButton && {
                ...dismissButton,
                onClick: handleDismissWithTrackEvent
              },
              ctaButton: ctaButton && {
                ...ctaButton,
                onClick: handleCTAClickWithTrackEvent
              },
              svg: svg,
              footer: footer,
              ...props
            })
          })
        })
      })
    })]
  });
}
SetupCTA.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_7__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number)
  }),
  waitingProgress: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(googlesitekit_components__WEBPACK_IMPORTED_MODULE_9__.ProgressBar.propTypes)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/constants.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/notifications/constants.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID: () => (/* binding */ GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID),
/* harmony export */   GTG_SETUP_CTA_BANNER_NOTIFICATION: () => (/* binding */ GTG_SETUP_CTA_BANNER_NOTIFICATION),
/* harmony export */   NOTIFICATION_AREAS: () => (/* binding */ NOTIFICATION_AREAS),
/* harmony export */   NOTIFICATION_GROUPS: () => (/* binding */ NOTIFICATION_GROUPS),
/* harmony export */   PRIORITY: () => (/* binding */ PRIORITY)
/* harmony export */ });
/**
 * Notifications API constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID = 'warning-notification-gtg';
const GTG_SETUP_CTA_BANNER_NOTIFICATION = 'gtg-setup-cta';
const PRIORITY = {
  ERROR_HIGH: 30,
  ERROR_LOW: 60,
  WARNING: 100,
  INFO: 150,
  SETUP_CTA_HIGH: 150,
  SETUP_CTA_LOW: 200
};
const NOTIFICATION_AREAS = {
  HEADER: 'notification-area-header',
  DASHBOARD_TOP: 'notification-area-dashboard-top',
  OVERLAYS: 'notification-area-overlays'
};
const NOTIFICATION_GROUPS = {
  DEFAULT: 'default',
  SETUP_CTAS: 'setup-ctas'
};

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/constants.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/constants.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_NOTIFICATIONS: () => (/* binding */ CORE_NOTIFICATIONS),
/* harmony export */   NOTIFICATION_VIEW_CONTEXTS: () => (/* binding */ NOTIFICATION_VIEW_CONTEXTS)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const CORE_NOTIFICATIONS = 'core/notifications';
const NOTIFICATION_VIEW_CONTEXTS = [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_SPLASH, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js":
/*!***********************************************************************!*\
  !*** ./js/googlesitekit/notifications/hooks/useNotificationEvents.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNotificationEvents)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * `useNotificationEvents` hook.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useNotificationEvents(id, category, {
  viewAction = 'view_notification',
  confirmAction = 'confirm_notification',
  dismissAction = 'dismiss_notification',
  clickLearnMoreAction = 'click_learn_more_link'
} = {}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__["default"])();
  const eventCategory = category !== null && category !== void 0 ? category : `${viewContext}_${id}`;
  const view = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, viewAction, ...args);
  }, [eventCategory, viewAction]);
  const confirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, confirmAction, ...args);
  }, [eventCategory, confirmAction]);
  const dismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, dismissAction, ...args);
  }, [eventCategory, dismissAction]);
  const clickLearnMore = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, clickLearnMoreAction, ...args);
  }, [eventCategory, clickLearnMoreAction]);
  return {
    view,
    confirm,
    dismiss,
    clickLearnMore
  };
}

/***/ }),

/***/ "./js/hooks/useActivateModuleCallback.js":
/*!***********************************************!*\
  !*** ./js/hooks/useActivateModuleCallback.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useActivateModuleCallback)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./useViewContext */ "./js/hooks/useViewContext.js");
/**
 * `useActivateModuleCallback` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









/**
 * Returns a callback to activate a module. If the call to activate the module is successful, navigate to the reauthentication URL.
 * Returns null if the module doesn't exist or the user can't manage options.
 *
 * @since 1.70.0
 *
 * @param {string} moduleSlug Module slug.
 * @return {Function|null} Callback to activate module, null if the module doesn't exist or the user can't manage options.
 */
function useActivateModuleCallback(moduleSlug) {
  const viewContext = (0,_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).getModule(moduleSlug));
  const canManageOptions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.PERMISSION_MANAGE_OPTIONS));
  const {
    activateModule
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_LOCATION);
  const {
    setInternalServerError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE);
  const activateModuleCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(async () => {
    const {
      error,
      response
    } = await activateModule(moduleSlug);
    if (!error) {
      await (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_widget-activation-cta`, 'activate_module', moduleSlug);
      await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_5__.setItem)('module_setup', moduleSlug, {
        ttl: 300
      });
      navigateTo(response.moduleReauthURL);
    } else {
      setInternalServerError({
        id: `${moduleSlug}-setup-error`,
        description: error.message
      });
    }
  }, [activateModule, moduleSlug, navigateTo, setInternalServerError, viewContext]);
  if (!module?.name || !canManageOptions) {
    return null;
  }
  return activateModuleCallback;
}

/***/ }),

/***/ "./js/hooks/useBreakpoint.ts":
/*!***********************************!*\
  !*** ./js/hooks/useBreakpoint.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAKPOINT_DESKTOP: () => (/* binding */ BREAKPOINT_DESKTOP),
/* harmony export */   BREAKPOINT_SMALL: () => (/* binding */ BREAKPOINT_SMALL),
/* harmony export */   BREAKPOINT_TABLET: () => (/* binding */ BREAKPOINT_TABLET),
/* harmony export */   BREAKPOINT_XLARGE: () => (/* binding */ BREAKPOINT_XLARGE),
/* harmony export */   useBreakpoint: () => (/* binding */ useBreakpoint)
/* harmony export */ });
/* harmony import */ var _useWindowSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useWindowSize */ "./js/hooks/useWindowSize.ts");
/**
 * `useBreakpoint` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



/**
 * Breakpoint for an extra large screen (over `1280px` wide).
 */
const BREAKPOINT_XLARGE = 'xlarge';
/**
 * Breakpoint for a desktop screen (over `960px` wide).
 */
const BREAKPOINT_DESKTOP = 'desktop';
/**
 * Breakpoint for a tablet screen (over `600px` wide).
 */
const BREAKPOINT_TABLET = 'tablet';
/**
 * Breakpoint for a mobile phone screen (any screen `600px` wide or less).
 */
const BREAKPOINT_SMALL = 'small';

/**
 * Retrieves the current breakpoint.
 *
 * @since 1.29.0
 *
 * @return {string} The current breakpoint according to the window size.
 */
function useBreakpoint() {
  const windowWidth = (0,_useWindowSize__WEBPACK_IMPORTED_MODULE_0__.useWindowWidth)();
  if (windowWidth > 1280) {
    return BREAKPOINT_XLARGE;
  }
  if (windowWidth > 960) {
    return BREAKPOINT_DESKTOP;
  }
  if (windowWidth > 600) {
    return BREAKPOINT_TABLET;
  }
  return BREAKPOINT_SMALL;
}

/***/ }),

/***/ "./js/hooks/useDebounce.js":
/*!*********************************!*\
  !*** ./js/hooks/useDebounce.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDebounce: () => (/* binding */ useDebounce)
/* harmony export */ });
/* harmony import */ var use_memo_one__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! use-memo-one */ "../node_modules/use-memo-one/dist/use-memo-one.esm.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * `useDebounce` hook, from @wordpress/compose.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// @TODO When we upgrade React to 16.4, we can also upgrade @wordpress/compose, and then this file can be removed.

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Debounces a function with Lodash's `debounce`.
 *
 * A new debounced function will be returned and any scheduled calls
 * cancelled if any of the arguments change, including the function to debounce,
 * so please wrap functions created on render in components in `useCallback`.
 *
 * @since 1.26.0
 *
 * @param {...any} args Arguments passed to Lodash's `debounce`.
 * @return {Function} Debounced function.
 */
function useDebounce(...args) {
  const debounced = (0,use_memo_one__WEBPACK_IMPORTED_MODULE_1__.useMemoOne)(() => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.debounce)(...args), args);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => () => debounced.cancel(), [debounced]);
  return debounced;
}

/***/ }),

/***/ "./js/hooks/useFeature.js":
/*!********************************!*\
  !*** ./js/hooks/useFeature.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFeature: () => (/* binding */ useFeature)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_FeaturesProvider_FeaturesContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/FeaturesProvider/FeaturesContext */ "./js/components/FeaturesProvider/FeaturesContext.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Feature Flags hook.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Returns the enabled state of a feature flag.
 *
 * @since 1.25.0
 *
 * @param {string} feature The feature flag name to check enabled state for.
 * @return {boolean} `true` if the feature is enabled, `false` otherwise.
 */
function useFeature(feature) {
  const enabledFeatures = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useContext)(_js_components_FeaturesProvider_FeaturesContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return (0,_js_features__WEBPACK_IMPORTED_MODULE_1__.isFeatureEnabled)(feature, enabledFeatures);
}

/***/ }),

/***/ "./js/hooks/useInView.js":
/*!*******************************!*\
  !*** ./js/hooks/useInView.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useInView: () => (/* binding */ useInView)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useUpdateEffect.js");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_InViewProvider_InViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/InViewProvider/InViewContext */ "./js/components/InViewProvider/InViewContext.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/**
 * In viewport hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */
// Imported directly from `@wordpress/data` to avoid circular
// dependency/imports.



/**
 * Internal dependencies
 */



/**
 * Returns whether the nearest parent component tracking viewport detection is in-view.
 *
 * @since 1.46.0
 *
 * @param {Object}  options        Optional. Options to pass to the request.
 * @param {boolean} options.sticky Set to `true` to always return `true` after the nearest viewport-detecting component has been in-view once. Defaults to `false`.
 * @return {boolean} `true` if the nearest parent component is in-view (or if `sticky` is `true`, if the component has ever been in-view); `false` if not..
 */
function useInView({
  sticky = false
} = {}) {
  const inView = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useContext)(_js_components_InViewProvider_InViewContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  const [hasBeenInViewOnce, setHasBeenInViewOnce] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const resetCount = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__["default"])(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI).getInViewResetCount());
  const forceInView = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__["default"])(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI).getValue('forceInView'));
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (inView.value && !hasBeenInViewOnce) {
      setHasBeenInViewOnce(true);
    }
  }, [hasBeenInViewOnce, inView, setHasBeenInViewOnce]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (forceInView) {
      setHasBeenInViewOnce(true);
    }
  }, [forceInView]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
    setHasBeenInViewOnce(false);
  }, [resetCount]);
  if (sticky && hasBeenInViewOnce) {
    return true;
  }
  return !!inView.value;
}

/***/ }),

/***/ "./js/hooks/useQueryArg.js":
/*!*********************************!*\
  !*** ./js/hooks/useQueryArg.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/**
 * `useQueryArg` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Uses a location query param as a variable in a component.
 *
 * @since 1.24.0
 *
 * @param {string} key            The query param key to be used.
 * @param {string} [initialValue] Optional. The initial value for the query param to be used.
 * @param {Object} [_global]      The global window object.
 * @return {Array} The getter and setter for the query param state.
 */
function useQueryArg(key, initialValue, _global = __webpack_require__.g) {
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.getQueryArg)(_global.location.href, key) || initialValue);
  function onSetValue(newValue) {
    setValue(newValue);
    const newURL = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.addQueryArgs)(_global.location.href, {
      [key]: newValue
    });
    _global.history.replaceState(null, '', newURL);
  }
  return [value, onSetValue];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useQueryArg);

/***/ }),

/***/ "./js/hooks/useViewContext.js":
/*!************************************!*\
  !*** ./js/hooks/useViewContext.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/**
 * `useViewContext` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Returns the current Site Kit viewing context, eg. "dashboard",
 * "entity dashboard", "view-only dashboard", etc.
 *
 * @since 1.74.0
 *
 * @return {string} The current "viewing context" value for the plugin.
 */
function useViewContext() {
  const viewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useContext)(_js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return viewContext;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useViewContext);

/***/ }),

/***/ "./js/hooks/useWindowSize.ts":
/*!***********************************!*\
  !*** ./js/hooks/useWindowSize.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useWindowHeight: () => (/* binding */ useWindowHeight),
/* harmony export */   useWindowSize: () => (/* binding */ useWindowSize),
/* harmony export */   useWindowWidth: () => (/* binding */ useWindowWidth)
/* harmony export */ });
/* harmony import */ var _react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @react-hook/throttle */ "../node_modules/@react-hook/throttle/dist/module/index.js");
/* harmony import */ var _react_hook_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-hook/event */ "../node_modules/@react-hook/event/dist/module/index.js");
/**
 * `useWindowSize` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Copied from https://github.com/jaredLunde/react-hook/blob/b8ac9515e26937e838a36a27001dc46c7f46a390/packages/window-size/throttled/src/index.tsx
// Modified to use global.innerWidth and global.innerHeight instead of document.documentElement.clientWidth and document.documentElement.clientHeight.

/**
 * External dependencies
 */


function getSize() {
  return [__webpack_require__.g.innerWidth, __webpack_require__.g.innerHeight];
}
function useWindowSize({
  fps = 60,
  leading = false,
  initialWidth = 0,
  initialHeight = 0
} = {}) {
  const [size, setThrottledSize] = (0,_react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__.useThrottle)(/* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);
  function setSize() {
    return setThrottledSize(getSize);
  }
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'resize', setSize);
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'orientationchange', setSize);
  return size;
}
function useWindowHeight(options = {}) {
  return useWindowSize(options)[1];
}
function useWindowWidth(options = {}) {
  return useWindowSize(options)[0];
}

/***/ }),

/***/ "./js/material-components/index.js":
/*!*****************************************!*\
  !*** ./js/material-components/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Cell),
/* harmony export */   Dialog: () => (/* reexport default from dynamic */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default.a),
/* harmony export */   DialogContent: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogContent),
/* harmony export */   DialogFooter: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogFooter),
/* harmony export */   Grid: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Grid),
/* harmony export */   MDCCheckbox: () => (/* reexport safe */ _material_checkbox__WEBPACK_IMPORTED_MODULE_7__.MDCCheckbox),
/* harmony export */   MDCDialog: () => (/* reexport safe */ _material_dialog__WEBPACK_IMPORTED_MODULE_6__.MDCDialog),
/* harmony export */   MDCFormField: () => (/* reexport safe */ _material_form_field__WEBPACK_IMPORTED_MODULE_3__.MDCFormField),
/* harmony export */   MDCMenu: () => (/* reexport safe */ _material_menu__WEBPACK_IMPORTED_MODULE_8__.MDCMenu),
/* harmony export */   MDCRadio: () => (/* reexport safe */ _material_radio__WEBPACK_IMPORTED_MODULE_4__.MDCRadio),
/* harmony export */   MDCRipple: () => (/* reexport safe */ _material_ripple__WEBPACK_IMPORTED_MODULE_2__.MDCRipple),
/* harmony export */   MDCSwitch: () => (/* reexport safe */ _material_switch__WEBPACK_IMPORTED_MODULE_5__.MDCSwitch),
/* harmony export */   Row: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Row)
/* harmony export */ });
/* harmony import */ var _material_ripple__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/ripple */ "../node_modules/@material/ripple/component.js");
/* harmony import */ var _material_form_field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/form-field */ "../node_modules/@material/form-field/component.js");
/* harmony import */ var _material_radio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material/radio */ "../node_modules/@material/radio/component.js");
/* harmony import */ var _material_switch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/switch */ "../node_modules/@material/switch/component.js");
/* harmony import */ var _material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/dialog */ "../node_modules/@material/dialog/component.js");
/* harmony import */ var _material_checkbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material/checkbox */ "../node_modules/@material/checkbox/component.js");
/* harmony import */ var _material_menu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material/menu */ "../node_modules/@material/menu/component.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-dialog */ "../node_modules/@material/react-dialog/dist/index.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_dialog__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./layout */ "./js/material-components/layout/index.js");
/**
 * Material components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */











/***/ }),

/***/ "./js/material-components/layout/Cell.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Cell.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cell)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Cell component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Cell(props) {
  const {
    className,
    alignTop,
    alignMiddle,
    alignBottom,
    alignRight,
    alignLeft,
    smAlignRight,
    mdAlignRight,
    lgAlignRight,
    smSize,
    smStart,
    smOrder,
    mdSize,
    mdStart,
    mdOrder,
    lgSize,
    lgStart,
    lgOrder,
    size,
    children,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'mdc-layout-grid__cell', {
      'mdc-layout-grid__cell--align-top': alignTop,
      'mdc-layout-grid__cell--align-middle': alignMiddle,
      'mdc-layout-grid__cell--align-bottom': alignBottom,
      'mdc-layout-grid__cell--align-right': alignRight,
      'mdc-layout-grid__cell--align-left': alignLeft,
      'mdc-layout-grid__cell--align-right-phone': smAlignRight,
      'mdc-layout-grid__cell--align-right-tablet': mdAlignRight,
      'mdc-layout-grid__cell--align-right-desktop': lgAlignRight,
      [`mdc-layout-grid__cell--span-${size}`]: 12 >= size && size > 0,
      [`mdc-layout-grid__cell--span-${lgSize}-desktop`]: 12 >= lgSize && lgSize > 0,
      [`mdc-layout-grid__cell--start-${lgStart}-desktop`]: 12 >= lgStart && lgStart > 0,
      [`mdc-layout-grid__cell--order-${lgOrder}-desktop`]: 12 >= lgOrder && lgOrder > 0,
      [`mdc-layout-grid__cell--span-${mdSize}-tablet`]: 8 >= mdSize && mdSize > 0,
      [`mdc-layout-grid__cell--start-${mdStart}-tablet`]: 8 >= mdStart && mdStart > 0,
      [`mdc-layout-grid__cell--order-${mdOrder}-tablet`]: 8 >= mdOrder && mdOrder > 0,
      [`mdc-layout-grid__cell--span-${smSize}-phone`]: 4 >= smSize && smSize > 0,
      [`mdc-layout-grid__cell--start-${smStart}-phone`]: 4 >= smStart && smStart > 0,
      [`mdc-layout-grid__cell--order-${smOrder}-phone`]: 4 >= smOrder && smOrder > 0
    }),
    children: children
  });
}
Cell.propTypes = {
  smSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  alignTop: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignMiddle: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignBottom: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  smAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  mdAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  lgAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
Cell.defaultProps = {
  className: '',
  size: 0,
  smSize: 0,
  smStart: 0,
  smOrder: 0,
  mdSize: 0,
  mdStart: 0,
  mdOrder: 0,
  lgSize: 0,
  lgStart: 0,
  lgOrder: 0
};

/***/ }),

/***/ "./js/material-components/layout/Grid.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Grid.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Grid component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Grid = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  alignLeft,
  fill,
  className,
  children,
  collapsed,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid', className, {
      'mdc-layout-grid--align-left': alignLeft,
      'mdc-layout-grid--collapsed': collapsed,
      'mdc-layout-grid--fill': fill
    }),
    ...otherProps,
    ref: ref,
    children: children
  });
});
Grid.displayName = 'Grid';
Grid.propTypes = {
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  fill: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Grid.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Grid);

/***/ }),

/***/ "./js/material-components/layout/Row.js":
/*!**********************************************!*\
  !*** ./js/material-components/layout/Row.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Row component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Row = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid__inner', className),
    ...otherProps,
    children: children
  });
});
Row.displayName = 'Row';
Row.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Row.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Row);

/***/ }),

/***/ "./js/material-components/layout/index.js":
/*!************************************************!*\
  !*** ./js/material-components/layout/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _Cell__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Grid: () => (/* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Row: () => (/* reexport safe */ _Row__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _Cell__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cell */ "./js/material-components/layout/Cell.js");
/* harmony import */ var _Row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Row */ "./js/material-components/layout/Row.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Grid */ "./js/material-components/layout/Grid.js");
/**
 * Material UI > Layout components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "./js/modules/ads/components/common/ConversionIDTextField.js":
/*!*******************************************************************!*\
  !*** ./js/modules/ads/components/common/ConversionIDTextField.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConversionIDTextField)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var _js_modules_ads_utils_validation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/ads/utils/validation */ "./js/modules/ads/utils/validation.js");
/* harmony import */ var _svg_icons_warning_v2_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/svg/icons/warning-v2.svg */ "./svg/icons/warning-v2.svg");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads Module Conversion Tracking ID component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */








function ConversionIDTextField({
  helperText,
  hideHeading = false
}) {
  const conversionID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ADS).getConversionID());

  // Don't show a validation error before user interacts with the field
  // in setup. When editing show validation error immediately if the value
  // is invalid.
  const [isValid, setIsValid] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useState)(!conversionID || (0,_js_modules_ads_utils_validation__WEBPACK_IMPORTED_MODULE_7__.isValidConversionID)(conversionID));
  const debounceSetIsValid = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_2__.useDebounce)(setIsValid, 500);
  const {
    setConversionID
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ADS);
  const onChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(({
    currentTarget
  }) => {
    let newValue = currentTarget.value.trim().toUpperCase();
    // Automatically add the AW- prefix if not provided, unless the field is empty.
    if (newValue !== '' && !/^AW-/.test(newValue)) {
      newValue = `AW-${newValue}`;
    }
    if (newValue !== conversionID) {
      setConversionID(newValue);
    }
    debounceSetIsValid((0,_js_modules_ads_utils_validation__WEBPACK_IMPORTED_MODULE_7__.isValidConversionID)(newValue));
  }, [debounceSetIsValid, conversionID, setConversionID]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    className: "googlesitekit-settings-module__fields-group",
    children: [!hideHeading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_9__["default"], {
      as: "h4",
      size: "small",
      type: "title",
      className: "googlesitekit-settings-module__fields-group-title",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Conversion ID', 'google-site-kit')
    }), helperText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("p", {
      className: "googlesitekit-settings-module__fields-group-helper-text",
      children: helperText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_4__.TextField, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Conversion ID', 'google-site-kit'),
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-text-field-conversion-tracking-id', {
        'mdc-text-field--error': !isValid
      }),
      helperText: !isValid && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Tracking for your Ads campaigns won’t work until you insert a valid ID', 'google-site-kit')
      // The "AW-" prefix is constant throughout all Conversion Tracking IDs,
      // so we don't localize it.
      ,
      leadingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {
        className: "googlesitekit-text-field-conversion-tracking-id-prefix",
        children: "AW-"
      }),
      trailingIcon: !isValid && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("span", {
        className: "googlesitekit-text-field-icon--error",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_6__["default"], {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Error', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_svg_icons_warning_v2_svg__WEBPACK_IMPORTED_MODULE_8__["default"], {
          width: 14,
          height: 12
        })]
      }),
      value: conversionID?.replace(/^(AW)?-?/, ''),
      onChange: onChange,
      maxLength: 20,
      outlined: true
    })]
  });
}

/***/ }),

/***/ "./js/modules/ads/components/common/PAXEmbeddedApp.js":
/*!************************************************************!*\
  !*** ./js/modules/ads/components/common/PAXEmbeddedApp.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PAXEmbeddedApp)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useInterval.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_components_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_ads_pax__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/ads/pax */ "./js/modules/ads/pax/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads Partner Ads Experience (PAX) Embedded App component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */







function PAXEmbeddedApp({
  displayMode = 'default',
  onLaunch,
  onCampaignCreated,
  onFinishAndCloseSignUpFlow
}) {
  const [launchGoogleAdsAvailable, setLaunchGoogleAdsAvailable] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(typeof __webpack_require__.g?.google?.ads?.integration?.integrator?.launchGoogleAds === 'function');
  const [hasLaunchedPAXApp, setHasLaunchedPAXApp] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const [isLoading, setIsLoading] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(true);
  const [launchError, setLaunchError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(undefined);
  const paxDateRange = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (displayMode !== 'reporting') {
      return {};
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getDateRangeDates({
      offsetDays: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATE_RANGE_OFFSET
    });
  });
  const isAdBlockerActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isAdBlockerActive());
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_9__["default"])(PAXEmbeddedApp, 'PAXEmbeddedApp');
  const elementID = `googlesitekit-pax-embedded-app-${instanceID}`;
  const paxAppRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useRef)();
  const setDateRangeForReportingMode = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(() => {
    if (displayMode === 'reporting' && paxAppRef?.current && paxDateRange.startDate && paxDateRange.endDate) {
      paxAppRef.current.getServices().adsDateRangeService.update({
        startDate: (0,_js_modules_ads_pax__WEBPACK_IMPORTED_MODULE_6__.formatPaxDate)(paxDateRange.startDate),
        endDate: (0,_js_modules_ads_pax__WEBPACK_IMPORTED_MODULE_6__.formatPaxDate)(paxDateRange.endDate)
      });
    }
  }, [displayMode, paxDateRange.endDate, paxDateRange.startDate]);
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const launchPAXApp = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(async () => {
    // State is only checked here because app ref is only set on successful launch.
    if (hasLaunchedPAXApp) {
      return;
    }
    // Prevent multiple launches.
    setHasLaunchedPAXApp(true);
    const config = (0,_js_modules_ads_pax__WEBPACK_IMPORTED_MODULE_6__.createPaxConfig)({
      contentContainer: `#${elementID}`,
      reportingStyle: displayMode === 'reporting' ? 'REPORTING_STYLE_MINI' : 'REPORTING_STYLE_FULL'
    });
    const services = (0,_js_modules_ads_pax__WEBPACK_IMPORTED_MODULE_6__.createPaxServices)(registry, {
      onCampaignCreated,
      onFinishAndCloseSignUpFlow
    });
    try {
      paxAppRef.current = await __webpack_require__.g.google.ads.integration.integrator.launchGoogleAds(config, services);
      setDateRangeForReportingMode();
      onLaunch?.(paxAppRef.current);
    } catch (error) {
      setLaunchError(error);
      __webpack_require__.g.console.error('Google Ads Partner Experience Error:', error);
    }
    setIsLoading(false);
  }, [displayMode, elementID, hasLaunchedPAXApp, onCampaignCreated, onFinishAndCloseSignUpFlow, onLaunch, registry, setDateRangeForReportingMode]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_10__["default"])(() => {
    if (launchGoogleAdsAvailable || hasLaunchedPAXApp) {
      return;
    }
    if (typeof __webpack_require__.g?.google?.ads?.integration?.integrator?.launchGoogleAds === 'function') {
      setLaunchGoogleAdsAvailable(true);
    }
  },
  // Supplying `null` as the interval will stop the interval, so we
  // use `null` once the app has been launched to prevent further
  // checking of whether the app is _ready_ to launch.
  hasLaunchedPAXApp ? null : 50);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (launchGoogleAdsAvailable && !hasLaunchedPAXApp) {
      launchPAXApp();
    }
  }, [hasLaunchedPAXApp, isLoading, launchGoogleAdsAvailable, launchPAXApp]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    setDateRangeForReportingMode();
  }, [setDateRangeForReportingMode,
  // `setDateRangeForReportingMode` will change whenever the date range
  // updates, causing this effect to run again, so the two date range
  // dependencies are technically redundant, but are explicitly listed
  // here to make the intent of the code clearer. (They're harmless
  // to include and do not cause extra renders/requests.)
  paxDateRange.startDate, paxDateRange.endDate]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "googlesitekit-pax-embedded-app",
    children: [!!launchError && !isAdBlockerActive && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google Ads error', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Could not load Google Ads content.', 'google-site-kit'),
      error: true
    }), isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: "100%",
      height: "240px"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      id: elementID
    })]
  });
}
PAXEmbeddedApp.propTypes = {
  displayMode: prop_types__WEBPACK_IMPORTED_MODULE_11___default().oneOf(['default', 'reporting', 'setup']),
  onLaunch: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onCampaignCreated: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onFinishAndCloseSignUpFlow: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func)
};

/***/ }),

/***/ "./js/modules/ads/components/common/WooCommerceRedirectModal.js":
/*!**********************************************************************!*\
  !*** ./js/modules/ads/components/common/WooCommerceRedirectModal.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WooCommerceRedirectModal)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _svg_graphics_woo_logo_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/graphics/woo-logo.svg */ "./svg/graphics/woo-logo.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/hooks/useActivateModuleCallback */ "./js/hooks/useActivateModuleCallback.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WooCommerce Redirect Modal component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */















function WooCommerceRedirectModal({
  dialogActive,
  onClose,
  onDismiss = null,
  onContinue = null,
  onBeforeSetupCallback = null
}) {
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useState)('');
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_13__["default"])();
  const adminURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).getAdminURL());
  const isWooCommerceActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS).isWooCommerceActivated());
  const isGoogleForWooCommerceActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS).isGoogleForWooCommerceActivated());
  const trackEventLabel = isGoogleForWooCommerceActive ? 'gfw' : 'wc';
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    if (dialogActive) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_14__.trackEvent)(`${viewContext}_pax_wc-redirect`, 'view_modal', trackEventLabel);
    }
  }, [dialogActive, viewContext, trackEventLabel]);
  const isGoogleForWooCommerceAdsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const hasGoogleForWooCommerceAdsAccount = select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS).hasGoogleForWooCommerceAdsAccount();
    if (isWooCommerceActive && isGoogleForWooCommerceActive && hasGoogleForWooCommerceAdsAccount) {
      return true;
    }
    return false;
  });
  const isModalDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS).isWooCommerceRedirectModalDismissed());
  const isAccountLinkedViaGoogleForWoocommerceNoticeDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_USER).isItemDismissed('account-linked-via-google-for-woocommerce'));
  const googleForWooCommerceRedirectURI = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useMemo)(() => {
    if (!adminURL || !isWooCommerceActive) {
      return undefined;
    }
    if (isGoogleForWooCommerceActive === false) {
      return (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_18__.addQueryArgs)(`${adminURL}/plugin-install.php`, {
        s: _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.PLUGINS.GOOGLE_FOR_WOOCOMMERCE,
        tab: 'search',
        type: 'term'
      });
    }
    const googleDashboardPath = encodeURIComponent('/google/dashboard');
    return `${adminURL}/admin.php?page=wc-admin&path=${googleDashboardPath}`;
  }, [adminURL, isWooCommerceActive, isGoogleForWooCommerceActive]);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_LOCATION);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS);
  const handleGoogleForWooCommerceRedirect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(async () => {
    if (!isAccountLinkedViaGoogleForWoocommerceNoticeDismissed) {
      dismissNotification('account-linked-via-google-for-woocommerce');
    }
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_14__.trackEvent)(`${viewContext}_pax_wc-redirect`, 'choose_gfw', trackEventLabel);
    if (isGoogleForWooCommerceAdsConnected) {
      setIsSaving('primary');
      navigateTo(googleForWooCommerceRedirectURI);
    }
    onDismiss?.();
    onClose?.();
  }, [isAccountLinkedViaGoogleForWoocommerceNoticeDismissed, dismissNotification, setIsSaving, onDismiss, onClose, navigateTo, googleForWooCommerceRedirectURI, viewContext, trackEventLabel, isGoogleForWooCommerceAdsConnected]);
  const onSetupCallback = (0,_js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_12__["default"])(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS);
  const onContinueWithSiteKit = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_14__.trackEvent)(`${viewContext}_pax_wc-redirect`, 'choose_sk', trackEventLabel);
    if (!onContinue) {
      setIsSaving('tertiary');
      onDismiss?.();
    }
    if (onContinue) {
      // Override default module activation with custom callback.
      onClose();
      onContinue();
      return;
    }
    onBeforeSetupCallback?.();
    onSetupCallback();
  }, [setIsSaving, onDismiss, onClose, onBeforeSetupCallback, onSetupCallback, onContinue, viewContext, trackEventLabel]);
  if (isModalDismissed && !isSaving) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Dialog, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-dialog-woocommerce-redirect', {
      'googlesitekit-dialog-woocommerce-redirect--ads-connected': isGoogleForWooCommerceAdsConnected
    }),
    open: dialogActive,
    "aria-describedby": undefined,
    tabIndex: "-1",
    onClose: onClose,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("div", {
      className: "googlesitekit-dialog-woocommerce-redirect__svg-wrapper",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_graphics_woo_logo_svg__WEBPACK_IMPORTED_MODULE_10__["default"], {
        width: 110,
        height: 46
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.DialogTitle, {
      children: isGoogleForWooCommerceAdsConnected ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Are you sure you want to create another Ads account for this site?', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Using the WooCommerce plugin?', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.DialogContent, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_15__["default"], {
        children: isGoogleForWooCommerceAdsConnected ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.Fragment, {
          children: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Site Kit has detected an already existing Ads account connected to this site via the Google for WooCommerce extension.', 'google-site-kit'), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("br", {}), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Continue Ads setup with Site Kit only if you do want to create another account.', 'google-site-kit')]
        }) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The Google for WooCommerce plugin can utilize your provided business information for advertising on Google and may be more suitable for your business.', 'google-site-kit')
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.DialogFooter, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        className: "mdc-dialog__cancel-button",
        onClick: onContinueWithSiteKit,
        icon: isSaving === 'tertiary' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.CircularProgress, {
          size: 14
        }) : undefined,
        disabled: !!isSaving,
        tertiary: true,
        children: isGoogleForWooCommerceAdsConnected ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Create another account', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Continue with Site Kit', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        trailingIcon: isGoogleForWooCommerceAdsConnected ? undefined : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_11__["default"], {
          width: 13,
          height: 13
        }),
        icon: isSaving === 'primary' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.CircularProgress, {
          size: 14
        }) : undefined,
        onClick: () => {
          if (isGoogleForWooCommerceAdsConnected || isWooCommerceActive) {
            handleGoogleForWooCommerceRedirect();
          } else {
            onClose();
          }
        },
        href: isGoogleForWooCommerceAdsConnected ? null : googleForWooCommerceRedirectURI,
        target: isGoogleForWooCommerceAdsConnected ? '_self' : '_blank',
        disabled: !!isSaving,
        tertiary: !isGoogleForWooCommerceAdsConnected,
        children: isGoogleForWooCommerceAdsConnected ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('View current Ads account', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Use Google for WooCommerce', 'google-site-kit')
      })]
    })]
  });
}
WooCommerceRedirectModal.propTypes = {
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().bool).isRequired,
  onDismiss: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().func),
  onContinue: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().func),
  onBeforeSetupCallback: (prop_types__WEBPACK_IMPORTED_MODULE_19___default().func)
};

/***/ }),

/***/ "./js/modules/ads/components/common/index.js":
/*!***************************************************!*\
  !*** ./js/modules/ads/components/common/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConversionIDTextField: () => (/* reexport safe */ _ConversionIDTextField__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   PAXEmbeddedApp: () => (/* reexport safe */ _PAXEmbeddedApp__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   WooCommerceRedirectModal: () => (/* reexport safe */ _WooCommerceRedirectModal__WEBPACK_IMPORTED_MODULE_2__["default"])
/* harmony export */ });
/* harmony import */ var _ConversionIDTextField__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ConversionIDTextField */ "./js/modules/ads/components/common/ConversionIDTextField.js");
/* harmony import */ var _PAXEmbeddedApp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PAXEmbeddedApp */ "./js/modules/ads/components/common/PAXEmbeddedApp.js");
/* harmony import */ var _WooCommerceRedirectModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./WooCommerceRedirectModal */ "./js/modules/ads/components/common/WooCommerceRedirectModal.js");
/**
 * Ads Common components.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "./js/modules/ads/components/notifications/AccountLinkedViaGoogleForWooCommerceSubtleNotification.js":
/*!***********************************************************************************************************!*\
  !*** ./js/modules/ads/components/notifications/AccountLinkedViaGoogleForWooCommerceSubtleNotification.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccountLinkedViaGoogleForWooCommerceSubtleNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useActivateModuleCallback */ "./js/hooks/useActivateModuleCallback.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AccountLinkedViaGoogleForWooCommerceSubtleNotification component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function AccountLinkedViaGoogleForWooCommerceSubtleNotification({
  id,
  Notification
}) {
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const onSetupCallback = (0,_js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_7__["default"])(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  const {
    setCacheItem
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE);
  const dismissWooCommerceRedirectModal = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async () => {
    await setCacheItem(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.ADS_WOOCOMMERCE_REDIRECT_MODAL_CACHE_KEY, true, {
      ttl: 5 * _js_util__WEBPACK_IMPORTED_MODULE_6__.MINUTE_IN_SECONDS
    });
  }, [setCacheItem]);
  const onCTAClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async () => {
    setIsSaving(true);
    await dismissNotification(id, {
      skipHidingFromQueue: true
    });
    await dismissWooCommerceRedirectModal();
    await onSetupCallback();
  }, [setIsSaving, dismissWooCommerceRedirectModal, dismissNotification, id, onSetupCallback]);
  const onDismissClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async () => {
    setIsSaving(true);
    await dismissNotification(id);
    await dismissWooCommerceRedirectModal();
  }, [setIsSaving, dismissNotification, dismissWooCommerceRedirectModal, id]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_8__["default"], {
      notificationID: id,
      type: "new",
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('We’ve detected an existing Ads account via the Google for WooCommerce plugin. You can still create a new Ads account using Site Kit.', 'google-site-kit'),
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Create new account', 'google-site-kit'),
        onClick: onCTAClick,
        disabled: isSaving
      },
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Keep existing account', 'google-site-kit'),
        onClick: onDismissClick,
        disabled: isSaving
      }
    })
  });
}
AccountLinkedViaGoogleForWooCommerceSubtleNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType).isRequired
};

/***/ }),

/***/ "./js/modules/ads/components/notifications/AdsModuleSetupCTABanner.js":
/*!****************************************************************************!*\
  !*** ./js/modules/ads/components/notifications/AdsModuleSetupCTABanner.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdsModuleSetupCTABanner)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useActivateModuleCallback */ "./js/hooks/useActivateModuleCallback.js");
/* harmony import */ var _js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/ads/components/common */ "./js/modules/ads/components/common/index.js");
/* harmony import */ var _js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/notifications/AdBlockerWarning */ "./js/components/notifications/AdBlockerWarning.js");
/* harmony import */ var _js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/AdminScreenTooltip */ "./js/components/AdminScreenTooltip/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_SetupCTA__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/SetupCTA */ "./js/googlesitekit/notifications/components/layout/SetupCTA.js");
/* harmony import */ var _svg_graphics_banner_ads_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/svg/graphics/banner-ads-setup-cta.svg?url */ "./svg/graphics/banner-ads-setup-cta.svg?url");
/* harmony import */ var _svg_graphics_banner_ads_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/svg/graphics/banner-ads-setup-cta-mobile.svg?url */ "./svg/graphics/banner-ads-setup-cta-mobile.svg?url");
/* harmony import */ var _js_googlesitekit_notifications_components_common_LearnMoreLink__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/common/LearnMoreLink */ "./js/googlesitekit/notifications/components/common/LearnMoreLink.js");
/* harmony import */ var _js_components_surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/components/surveys/SurveyViewTrigger */ "./js/components/surveys/SurveyViewTrigger.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdsModuleSetupCTABanner component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */

















function AdsModuleSetupCTABanner({
  id,
  Notification
}) {
  const [openDialog, setOpenDialog] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(false);
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(false);
  const learnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_SITE).getDocumentationLinkURL('set-up-ads'));
  const isAdBlockerActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isAdBlockerActive());
  const isDismissalFinal = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS).isNotificationDismissalFinal(id));
  const shouldShowWooCommerceRedirectModal = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const {
      isWooCommerceActivated,
      isGoogleForWooCommerceActivated,
      hasGoogleForWooCommerceAdsAccount
    } = select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ADS);
    return isWooCommerceActivated() && isGoogleForWooCommerceActivated() && !hasGoogleForWooCommerceAdsAccount() || isWooCommerceActivated() && !isGoogleForWooCommerceActivated();
  });
  const isWooCommerceRedirectModalDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ADS).isWooCommerceRedirectModalDismissed());
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  const {
    setCacheItem
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_SITE);
  const dismissWooCommerceRedirectModal = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(() => {
    setCacheItem(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.ADS_WOOCOMMERCE_REDIRECT_MODAL_CACHE_KEY, true, {
      ttl: 5 * _js_util__WEBPACK_IMPORTED_MODULE_4__.MINUTE_IN_SECONDS
    });
  }, [setCacheItem]);
  const activateModule = (0,_js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_7__["default"])(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_ADS);
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const onSetupCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(() => {
    triggerSurvey('accept_ads_setup_cta');
    if (!shouldShowWooCommerceRedirectModal || isWooCommerceRedirectModalDismissed) {
      setIsSaving(true);
      activateModule();
      return;
    }
    setOpenDialog(true);
  }, [triggerSurvey, shouldShowWooCommerceRedirectModal, activateModule, isWooCommerceRedirectModalDismissed]);
  const onModalClose = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useCallback)(() => {
    setOpenDialog(false);
  }, [setOpenDialog]);
  const tooltipSettings = {
    tooltipSlug: 'ads-setup-notification',
    content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always enable Ads in Settings later', 'google-site-kit'),
    dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
  };
  const showTooltip = (0,_js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_10__.useShowTooltip)(tooltipSettings);
  const [dismissLabel, setDismissLabel] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'));
  (0,react_use__WEBPACK_IMPORTED_MODULE_19__["default"])(() => {
    if (true === isDismissalFinal) {
      setDismissLabel((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Don’t show again', 'google-site-kit'));
    }
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(Notification, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_googlesitekit_notifications_components_layout_SetupCTA__WEBPACK_IMPORTED_MODULE_12__["default"], {
      notificationID: id,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get better quality leads and enhance conversions with Ads', 'google-site-kit'),
      description: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.Fragment, {
        children: [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_20__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Help drive sales, leads, or site traffic by getting your business in front of people who are actively searching Google for products or services you offer. <a />', 'google-site-kit'), {
          a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_googlesitekit_notifications_components_common_LearnMoreLink__WEBPACK_IMPORTED_MODULE_15__["default"], {
            id: id,
            label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
            url: learnMoreURL
          })
        }), isAdBlockerActive && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_9__["default"], {
          moduleSlug: "ads"
        })]
      }),
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set up Ads', 'google-site-kit'),
        onClick: onSetupCallback,
        disabled: isAdBlockerActive || isSaving || openDialog,
        inProgress: isSaving,
        dismissOnClick: true,
        dismissOptions: {
          expiresInSeconds: 2 * _js_util__WEBPACK_IMPORTED_MODULE_4__.WEEK_IN_SECONDS,
          skipHidingFromQueue: true
        }
      },
      dismissButton: {
        label: dismissLabel,
        onClick: showTooltip,
        disabled: isSaving,
        dismissOptions: {
          expiresInSeconds: isDismissalFinal ? 0 : 2 * _js_util__WEBPACK_IMPORTED_MODULE_4__.WEEK_IN_SECONDS
        }
      },
      svg: {
        desktop: _svg_graphics_banner_ads_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_13__["default"],
        mobile: _svg_graphics_banner_ads_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_14__["default"],
        verticalPosition: 'center'
      }
    }), openDialog && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_8__.WooCommerceRedirectModal, {
      onDismiss: () => dismissNotification(id),
      onClose: onModalClose,
      onBeforeSetupCallback: dismissWooCommerceRedirectModal,
      dialogActive: true
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_17__.jsx)(_js_components_surveys_SurveyViewTrigger__WEBPACK_IMPORTED_MODULE_16__["default"], {
      triggerID: "view_ads_setup_cta",
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_4__.DAY_IN_SECONDS
    })]
  });
}
AdsModuleSetupCTABanner.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_21___default().elementType).isRequired
};

/***/ }),

/***/ "./js/modules/ads/components/notifications/EnhancedConversionsNotification.js":
/*!************************************************************************************!*\
  !*** ./js/modules/ads/components/notifications/EnhancedConversionsNotification.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ENHANCED_CONVERSIONS_NOTIFICATION_ADS: () => (/* binding */ ENHANCED_CONVERSIONS_NOTIFICATION_ADS),
/* harmony export */   "default": () => (/* binding */ EnhancedConversionsNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_common_LearnMoreLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/common/LearnMoreLink */ "./js/googlesitekit/notifications/components/common/LearnMoreLink.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads EnhancedConversionsNotification component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const ENHANCED_CONVERSIONS_NOTIFICATION_ADS = 'ecee-notification-ads';
function EnhancedConversionsNotification({
  id,
  Notification
}) {
  const documentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getDocumentationLinkURL('enhanced-conversions-ads'));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO_ALT,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Boost your data and Ads results with enhanced conversions', 'google-site-kit'),
      description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit now supports enhanced conversions. This feature helps your ads count sales and leads more accurately, even across different devices, so your budget is spent smarter. To turn this on, simply agree to the terms of service in your Ads account and enable enhanced conversions. <a />', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_googlesitekit_notifications_components_common_LearnMoreLink__WEBPACK_IMPORTED_MODULE_4__["default"], {
          id: id,
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
          url: documentationURL
        })
      }),
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No thanks', 'google-site-kit')
      },
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Go to Ads', 'google-site-kit'),
        href: 'https://ads.google.com/aw/conversions/customersettings',
        dismissOnClick: true,
        external: true,
        hideExternalIndicator: true
      }
    })
  });
}
EnhancedConversionsNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().elementType).isRequired
};

/***/ }),

/***/ "./js/modules/ads/components/notifications/PAXSetupSuccessSubtleNotification.js":
/*!**************************************************************************************!*\
  !*** ./js/modules/ads/components/notifications/PAXSetupSuccessSubtleNotification.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PAXSetupSuccessSubtleNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useQueryArg */ "./js/hooks/useQueryArg.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PAXSetupSuccessSubtleNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */








function PAXSetupSuccessSubtleNotification({
  id,
  Notification
}) {
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  const [, setNotification] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_7__["default"])('notification');
  const dismissNotice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    setNotification(undefined);
  }, [setNotification]);
  const accountSelectorWrappedAccountOverviewURL = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_10__["default"])(select => {
    const accountOverviewURL = select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).getAccountOverviewURL();
    if (!!accountOverviewURL) {
      return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getAccountChooserURL(accountOverviewURL);
    }
    return null;
  });
  const onPrimaryCTAClickCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    dismissNotice();
    dismissNotification(id);
  }, [dismissNotice, dismissNotification, id]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_6__.TYPES.SUCCESS,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Ads campaign was successfully set up!', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Track your conversions, measure your campaign results and make the most of your ad spend', 'google-site-kit'),
      dismissButton: {
        onClick: dismissNotice
      },
      ctaButton: {
        onClick: onPrimaryCTAClickCallback,
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Show me', 'google-site-kit'),
        href: accountSelectorWrappedAccountOverviewURL,
        external: true
      }
    })
  });
}
PAXSetupSuccessSubtleNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType).isRequired
};

/***/ }),

/***/ "./js/modules/ads/components/notifications/SetupSuccessSubtleNotification.js":
/*!***********************************************************************************!*\
  !*** ./js/modules/ads/components/notifications/SetupSuccessSubtleNotification.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupSuccessSubtleNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var _js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useQueryArg */ "./js/hooks/useQueryArg.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupSuccessSubtleNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function SetupSuccessSubtleNotification({
  id,
  Notification
}) {
  const [, setNotification] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_2__["default"])('notification');
  const [, setSlug] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_2__["default"])('slug');
  function onDismiss() {
    setNotification(undefined);
    setSlug(undefined);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_1__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Success! Your Conversion ID was added to your site', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can now track conversions for your Ads campaigns', 'google-site-kit'),
      dismissButton: {
        onClick: onDismiss
      }
    })
  });
}
SetupSuccessSubtleNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().elementType).isRequired
};

/***/ }),

/***/ "./js/modules/ads/components/notifications/index.js":
/*!**********************************************************!*\
  !*** ./js/modules/ads/components/notifications/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountLinkedViaGoogleForWooCommerceSubtleNotification: () => (/* reexport safe */ _AccountLinkedViaGoogleForWooCommerceSubtleNotification__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   AdsModuleSetupCTABanner: () => (/* reexport safe */ _AdsModuleSetupCTABanner__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   EnhancedConversionsNotification: () => (/* reexport safe */ _EnhancedConversionsNotification__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   PAXSetupSuccessSubtleNotification: () => (/* reexport safe */ _PAXSetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   SetupSuccessSubtleNotification: () => (/* reexport safe */ _SetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _PAXSetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PAXSetupSuccessSubtleNotification */ "./js/modules/ads/components/notifications/PAXSetupSuccessSubtleNotification.js");
/* harmony import */ var _SetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SetupSuccessSubtleNotification */ "./js/modules/ads/components/notifications/SetupSuccessSubtleNotification.js");
/* harmony import */ var _AccountLinkedViaGoogleForWooCommerceSubtleNotification__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AccountLinkedViaGoogleForWooCommerceSubtleNotification */ "./js/modules/ads/components/notifications/AccountLinkedViaGoogleForWooCommerceSubtleNotification.js");
/* harmony import */ var _AdsModuleSetupCTABanner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AdsModuleSetupCTABanner */ "./js/modules/ads/components/notifications/AdsModuleSetupCTABanner.js");
/* harmony import */ var _EnhancedConversionsNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./EnhancedConversionsNotification */ "./js/modules/ads/components/notifications/EnhancedConversionsNotification.js");
/**
 * Ads Notification components.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */







/***/ }),

/***/ "./js/modules/ads/components/settings/EnhancedConversionsSettingsNotice.js":
/*!*********************************************************************************!*\
  !*** ./js/modules/ads/components/settings/EnhancedConversionsSettingsNotice.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EnhancedConversionsSettingsNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_hooks_useInView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useInView */ "./js/hooks/useInView.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_ads_components_notifications_EnhancedConversionsNotification__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/ads/components/notifications/EnhancedConversionsNotification */ "./js/modules/ads/components/notifications/EnhancedConversionsNotification.js");
/* harmony import */ var _js_googlesitekit_notifications_components_common_LearnMoreLink__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/common/LearnMoreLink */ "./js/googlesitekit/notifications/components/common/LearnMoreLink.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads EnhancedConversionsSettingsNotice component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function EnhancedConversionsSettingsNotice({
  type = _js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"].TYPES.INFO
}) {
  const id = _js_modules_ads_components_notifications_EnhancedConversionsNotification__WEBPACK_IMPORTED_MODULE_6__.ENHANCED_CONVERSIONS_NOTIFICATION_ADS;
  const inView = (0,_js_hooks_useInView__WEBPACK_IMPORTED_MODULE_2__.useInView)();
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(id);
  const [isViewedOnce, setIsViewedOnce] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
  const documentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('enhanced-conversions-ads'));
  const isDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).isItemDismissed(id));
  const {
    dismissItem
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER);
  const handleCTAClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async () => {
    // Dismiss the notice when the CTA is clicked.
    await dismissItem(id);
    trackEvents.confirm();
  }, [dismissItem, id, trackEvents]);
  const handleDismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async () => {
    await dismissItem(id);
    trackEvents.dismiss();
  }, [dismissItem, id, trackEvents]);

  // Track view event when notice comes into view.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (!isViewedOnce && inView) {
      trackEvents.view();
      setIsViewedOnce(true);
    }
  }, [inView, trackEvents, isViewedOnce]);
  if (isDismissed) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"], {
    type: type,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Boost your data and Ads results with enhanced conversions', 'google-site-kit'),
    description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit now supports enhanced conversions. This feature helps your ads count sales and leads more accurately, even across different devices, so your budget is spent smarter. To turn this on, simply agree to the terms of service in your Ads account and enable enhanced conversions. <a />', 'google-site-kit'), {
      a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_googlesitekit_notifications_components_common_LearnMoreLink__WEBPACK_IMPORTED_MODULE_7__["default"], {
        id: id,
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
        url: documentationURL
      })
    }),
    dismissButton: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No thanks', 'google-site-kit'),
      onClick: handleDismiss
    },
    ctaButton: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Go to Ads', 'google-site-kit'),
      href: 'https://ads.google.com/aw/conversions/customersettings',
      onClick: handleCTAClick,
      external: true,
      hideExternalIndicator: true
    }
  });
}
EnhancedConversionsSettingsNotice.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOf(Object.values(_js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"].TYPES))
};

/***/ }),

/***/ "./js/modules/ads/components/settings/SettingsDisconnectNote.js":
/*!**********************************************************************!*\
  !*** ./js/modules/ads/components/settings/SettingsDisconnectNote.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsDisconnectNote)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads Disconnection Note component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function SettingsDisconnectNote() {
  const detailsLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getDetailsLinkURL(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ADS));
  const paxConversionID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ADS).getPaxConversionID());
  const extCustomerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ADS).getExtCustomerID());
  const isPaxSetup = paxConversionID || extCustomerID;
  if (!detailsLinkURL || !isPaxSetup) {
    return null;
  }
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('<strong>Note:</strong> Disconnecting Ads from Site Kit won’t remove your campaign from Ads. <br />Visit <DetailsLink /> to manage your campaign settings', 'google-site-kit'), {
    strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("strong", {}),
    br: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("br", {}),
    DetailsLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
      href: detailsLinkURL,
      external: true,
      hideExternalIndicator: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('Ads', 'Service name', 'google-site-kit')
    })
  });
}

/***/ }),

/***/ "./js/modules/ads/components/settings/SettingsEdit.js":
/*!************************************************************!*\
  !*** ./js/modules/ads/components/settings/SettingsEdit.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsEdit)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _SettingsForm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SettingsForm */ "./js/modules/ads/components/settings/SettingsForm.js");
/* harmony import */ var _js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/notifications/AdBlockerWarning */ "./js/components/notifications/AdBlockerWarning.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads Settings Edit component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







function SettingsEdit() {
  const isDoingSubmitChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ADS).isDoingSubmitChanges());
  const isAdBlockerActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isAdBlockerActive());
  let viewComponent;
  if (isAdBlockerActive) {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_5__["default"], {
      moduleSlug: "ads"
    });
  } else if (isDoingSubmitChanges) {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, {});
  } else {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_SettingsForm__WEBPACK_IMPORTED_MODULE_4__["default"], {});
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
    className: "googlesitekit-setup-module googlesitekit-setup-module--ads",
    children: viewComponent
  });
}

/***/ }),

/***/ "./js/modules/ads/components/settings/SettingsForm.js":
/*!************************************************************!*\
  !*** ./js/modules/ads/components/settings/SettingsForm.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsForm)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_components_conversion_tracking_ConversionTrackingToggle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/conversion-tracking/ConversionTrackingToggle */ "./js/components/conversion-tracking/ConversionTrackingToggle.js");
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/ads/components/common */ "./js/modules/ads/components/common/index.js");
/* harmony import */ var _js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useFeature */ "./js/hooks/useFeature.js");
/* harmony import */ var _js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/DisplaySetting */ "./js/components/DisplaySetting.js");
/* harmony import */ var _EnhancedConversionsSettingsNotice__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./EnhancedConversionsSettingsNotice */ "./js/modules/ads/components/settings/EnhancedConversionsSettingsNotice.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_settings_SettingsGroup__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/settings/SettingsGroup */ "./js/components/settings/SettingsGroup.js");
/* harmony import */ var _js_components_google_tag_gateway_GoogleTagGatewayToggle__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/google-tag-gateway/GoogleTagGatewayToggle */ "./js/components/google-tag-gateway/GoogleTagGatewayToggle.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsForm component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */















function SettingsForm() {
  const paxEnabled = (0,_js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_7__.useFeature)('adsPax');
  const gtgEnabled = (0,_js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_7__.useFeature)('googleTagGateway');
  const gtagUserDataEnabled = (0,_js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_7__.useFeature)('gtagUserData');
  const conversionID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ADS).getConversionID());
  const paxConversionID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ADS).getPaxConversionID());
  const extCustomerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ADS).getExtCustomerID());
  const conversionTrackingDocumentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_SITE).getDocumentationLinkURL('plugin-conversion-tracking'));
  const conversionIDValue = paxEnabled && paxConversionID ? paxConversionID : conversionID;
  const isPaxView = paxEnabled && (paxConversionID || extCustomerID);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
    className: "googlesitekit-ads-settings-fields",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_5__["default"], {
      moduleSlug: "ads",
      storeName: _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ADS
    }), !isPaxView && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
      className: "googlesitekit-setup-module__inputs",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_6__.ConversionIDTextField, {
        helperText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The Conversion ID will help track the performance of ad campaigns for the corresponding account', 'google-site-kit')
      })
    }), isPaxView && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
        className: "googlesitekit-settings-module__meta-item",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_14__["default"], {
          as: "h5",
          size: "small",
          type: "label",
          className: "googlesitekit-settings-module__meta-item-type",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Conversion ID', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("p", {
          className: "googlesitekit-settings-module__meta-item-data",
          children: [conversionIDValue === '' && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('None', 'google-site-kit'), conversionIDValue || typeof conversionIDValue === 'undefined' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_8__["default"], {
            value: conversionIDValue
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
        className: "googlesitekit-settings-module__meta-item",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_14__["default"], {
          as: "h5",
          size: "medium",
          type: "label",
          className: "googlesitekit-settings-module__meta-item-type",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Customer ID', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("p", {
          className: "googlesitekit-settings-module__meta-item-data",
          children: [extCustomerID === '' && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('None', 'google-site-kit'), extCustomerID || typeof extCustomerID === 'undefined' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_8__["default"], {
            value: extCustomerID
          })]
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_js_components_settings_SettingsGroup__WEBPACK_IMPORTED_MODULE_12__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Improve your measurement', 'google-site-kit'),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_conversion_tracking_ConversionTrackingToggle__WEBPACK_IMPORTED_MODULE_4__["default"], {
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_16__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To track the performance of your campaigns, Site Kit will enable plugin conversion tracking. <a>Learn more</a>', 'google-site-kit'), {
          a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_11__["default"], {
            href: conversionTrackingDocumentationURL,
            "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more about conversion tracking', 'google-site-kit'),
            external: true
          })
        })
      }), gtgEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_components_google_tag_gateway_GoogleTagGatewayToggle__WEBPACK_IMPORTED_MODULE_13__["default"], {}), gtagUserDataEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_EnhancedConversionsSettingsNotice__WEBPACK_IMPORTED_MODULE_9__["default"], {
        type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO_ALT
      })]
    })]
  });
}

/***/ }),

/***/ "./js/modules/ads/components/settings/SettingsView.js":
/*!************************************************************!*\
  !*** ./js/modules/ads/components/settings/SettingsView.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsView)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/DisplaySetting */ "./js/components/DisplaySetting.js");
/* harmony import */ var _EnhancedConversionsSettingsNotice__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./EnhancedConversionsSettingsNotice */ "./js/modules/ads/components/settings/EnhancedConversionsSettingsNotice.js");
/* harmony import */ var _js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/notifications/AdBlockerWarning */ "./js/components/notifications/AdBlockerWarning.js");
/* harmony import */ var _hooks_useFeature__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./../../../../hooks/useFeature */ "./js/hooks/useFeature.js");
/* harmony import */ var _js_components_settings_SettingsStatuses__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/settings/SettingsStatuses */ "./js/components/settings/SettingsStatuses.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads Settings View component
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */











function SettingsView() {
  const paxEnabled = (0,_hooks_useFeature__WEBPACK_IMPORTED_MODULE_9__.useFeature)('adsPax');
  const gtgEnabled = (0,_hooks_useFeature__WEBPACK_IMPORTED_MODULE_9__.useFeature)('googleTagGateway');
  const gtagUserDataEnabled = (0,_hooks_useFeature__WEBPACK_IMPORTED_MODULE_9__.useFeature)('gtagUserData');
  const conversionID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).getConversionID());
  const paxConversionID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).getPaxConversionID());
  const extCustomerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).getExtCustomerID());
  const isAdBlockerActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).isAdBlockerActive());
  const conversionIDValue = paxEnabled && paxConversionID ? paxConversionID : conversionID;
  const isPaxView = paxEnabled && (paxConversionID || extCustomerID);
  const isConversionTrackingEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isConversionTrackingEnabled());
  const isGTGEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    if (!gtgEnabled) {
      return false;
    }
    const {
      isGoogleTagGatewayEnabled,
      isGTGHealthy,
      isScriptAccessEnabled
    } = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
    return isGoogleTagGatewayEnabled() && isGTGHealthy() && isScriptAccessEnabled();
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
    className: "googlesitekit-setup-module",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
        'googlesitekit-settings-module__meta-item': isAdBlockerActive
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_8__["default"], {
        moduleSlug: "ads"
      })
    }), !isAdBlockerActive && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
        className: "googlesitekit-settings-module__meta-item",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_11__["default"], {
          as: "h5",
          size: "medium",
          type: "label",
          className: "googlesitekit-settings-module__meta-item-type",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Conversion ID', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("p", {
          className: "googlesitekit-settings-module__meta-item-data",
          children: [conversionIDValue === '' && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('None', 'google-site-kit'), conversionIDValue || typeof conversionIDValue === 'undefined' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_6__["default"], {
            value: conversionIDValue
          })]
        })]
      }), isPaxView && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
        className: "googlesitekit-settings-module__meta-item",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_11__["default"], {
          as: "h5",
          size: "medium",
          type: "body",
          className: "googlesitekit-settings-module__meta-item-type",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Customer ID', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("p", {
          className: "googlesitekit-settings-module__meta-item-data",
          children: [extCustomerID === '' && (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('None', 'google-site-kit'), extCustomerID || typeof extCustomerID === 'undefined' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_6__["default"], {
            value: extCustomerID
          })]
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_settings_SettingsStatuses__WEBPACK_IMPORTED_MODULE_10__["default"], {
      statuses: [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Plugin conversion tracking', 'google-site-kit'),
        status: isConversionTrackingEnabled
      }, ...(gtgEnabled ? [{
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Google tag gateway for advertisers', 'google-site-kit'),
        status: isGTGEnabled
      }] : [])]
    }), gtagUserDataEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_EnhancedConversionsSettingsNotice__WEBPACK_IMPORTED_MODULE_7__["default"], {})]
  });
}

/***/ }),

/***/ "./js/modules/ads/components/settings/index.js":
/*!*****************************************************!*\
  !*** ./js/modules/ads/components/settings/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EnhancedConversionsSettingsNotice: () => (/* reexport safe */ _EnhancedConversionsSettingsNotice__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   SettingsDisconnectNote: () => (/* reexport safe */ _SettingsDisconnectNote__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   SettingsEdit: () => (/* reexport safe */ _SettingsEdit__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SettingsForm: () => (/* reexport safe */ _SettingsForm__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   SettingsView: () => (/* reexport safe */ _SettingsView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _SettingsView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SettingsView */ "./js/modules/ads/components/settings/SettingsView.js");
/* harmony import */ var _SettingsForm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SettingsForm */ "./js/modules/ads/components/settings/SettingsForm.js");
/* harmony import */ var _SettingsEdit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SettingsEdit */ "./js/modules/ads/components/settings/SettingsEdit.js");
/* harmony import */ var _EnhancedConversionsSettingsNotice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./EnhancedConversionsSettingsNotice */ "./js/modules/ads/components/settings/EnhancedConversionsSettingsNotice.js");
/* harmony import */ var _SettingsDisconnectNote__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SettingsDisconnectNote */ "./js/modules/ads/components/settings/SettingsDisconnectNote.js");
/**
 * Ads Settings components.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */







/***/ }),

/***/ "./js/modules/ads/components/setup/SetupForm.js":
/*!******************************************************!*\
  !*** ./js/modules/ads/components/setup/SetupForm.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupForm)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/components/common */ "./js/modules/ads/components/common/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_conversion_tracking_SetupPluginConversionTrackingNotice__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/conversion-tracking/SetupPluginConversionTrackingNotice */ "./js/components/conversion-tracking/SetupPluginConversionTrackingNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads Setup form.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function SetupForm({
  finishSetup,
  createAccountCTA,
  isNavigatingToOAuthURL
}) {
  const canSubmitChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).canSubmitChanges());
  const isSaving = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).isDoingSubmitChanges() && !isNavigatingToOAuthURL);
  const {
    submitChanges
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS);
  const {
    setConversionTrackingEnabled,
    saveConversionTrackingSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE);
  const submitForm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async event => {
    event.preventDefault();
    const {
      error
    } = await submitChanges();
    if (!error) {
      setConversionTrackingEnabled(true);
      await saveConversionTrackingSettings();
      finishSetup();
    }
  }, [finishSetup, saveConversionTrackingSettings, setConversionTrackingEnabled, submitChanges]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("form", {
    className: "googlesitekit-ads-setup__form",
    onSubmit: submitForm,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_4__["default"], {
      moduleSlug: "ads",
      storeName: _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-setup-module__inputs",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_5__.ConversionIDTextField, {})
    }), createAccountCTA && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-setup-module__create-account",
      children: createAccountCTA
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_conversion_tracking_SetupPluginConversionTrackingNotice__WEBPACK_IMPORTED_MODULE_7__["default"], {
      className: "googlesitekit-margin-top-1",
      message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To track the performance of your campaigns, Site Kit will enable plugin conversion tracking. You can always disable it in settings.', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-setup-module__action",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
        disabled: !canSubmitChanges || isSaving,
        isSaving: isSaving,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Complete setup', 'google-site-kit')
      })
    })]
  });
}
SetupForm.propTypes = {
  finishSetup: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  createAccountCTA: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  isNavigatingToOAuthURL: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool)
};
SetupForm.defaultProps = {
  finishSetup: () => {},
  createAccountCTA: null,
  isNavigatingToOAuthURL: false
};

/***/ }),

/***/ "./js/modules/ads/components/setup/SetupFormPAX.js":
/*!*********************************************************!*\
  !*** ./js/modules/ads/components/setup/SetupFormPAX.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupFormPAX)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/components/common */ "./js/modules/ads/components/common/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads PAX Setup form.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function SetupFormPAX({
  finishSetup,
  isNavigatingToOAuthURL
}) {
  const canSubmitChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).canSubmitChanges());
  const isSaving = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).isDoingSubmitChanges() && !isNavigatingToOAuthURL);
  const {
    submitChanges
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS);
  const {
    setConversionTrackingEnabled,
    saveConversionTrackingSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE);
  const currentConversionID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).getConversionID());
  const googleListingsAndAdsConnectedAdsID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS).getGoogleForWooCommerceConversionID());
  const isDuplicateAdsIDDetected = !!currentConversionID && currentConversionID === googleListingsAndAdsConnectedAdsID;
  const submitForm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async event => {
    event.preventDefault();
    const {
      error
    } = await submitChanges();
    if (!error) {
      setConversionTrackingEnabled(true);
      await saveConversionTrackingSettings();
      finishSetup();
    }
  }, [finishSetup, saveConversionTrackingSettings, setConversionTrackingEnabled, submitChanges]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "googlesitekit-ads-setup__form googlesitekit-ads-setup__form--pax",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_4__["default"], {
      moduleSlug: "ads",
      storeName: _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ADS
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-setup-module__inputs",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_5__.ConversionIDTextField, {
        hideHeading: true
      })
    }), isDuplicateAdsIDDetected && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_7__["default"], {
      className: "googlesitekit-notice--small googlesitekit-ads-setup__ads-id-conflict-warning",
      type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_7__["default"].TYPES.WARNING,
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This Conversion ID is already in use via the Google for WooCommerce plugin. We don’t recommend adding it in Site Kit, as it may result in inaccurate measurement of your Ads campaign conversions.', 'google-site-kit'),
      hideIcon: true
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: "googlesitekit-setup-module__action",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
        disabled: !canSubmitChanges || isSaving || isDuplicateAdsIDDetected,
        isSaving: isSaving,
        onClick: submitForm,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Complete manual setup', 'google-site-kit')
      })
    })]
  });
}
SetupFormPAX.propTypes = {
  finishSetup: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  isNavigatingToOAuthURL: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool)
};

/***/ }),

/***/ "./js/modules/ads/components/setup/SetupMain.js":
/*!******************************************************!*\
  !*** ./js/modules/ads/components/setup/SetupMain.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupMain)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_graphics_ads_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/graphics/ads.svg */ "./svg/graphics/ads.svg");
/* harmony import */ var _SetupForm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SetupForm */ "./js/modules/ads/components/setup/SetupForm.js");
/* harmony import */ var _js_components_SupportLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/SupportLink */ "./js/components/SupportLink.js");
/* harmony import */ var _js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/notifications/AdBlockerWarning */ "./js/components/notifications/AdBlockerWarning.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads Main setup component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function SetupMain({
  finishSetup
}) {
  const isAdBlockerActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_USER).isAdBlockerActive());
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    className: "googlesitekit-setup-module googlesitekit-setup-module--ads",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "googlesitekit-setup-module__step",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "googlesitekit-setup-module__logo",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_svg_graphics_ads_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
          width: "40",
          height: "40"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_7__["default"], {
        as: "h3",
        className: "googlesitekit-setup-module__title",
        size: "small",
        type: "headline",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('Ads', 'Service name', 'google-site-kit')
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "googlesitekit-setup-module__step",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_5__["default"], {
        moduleSlug: "ads"
      }), !isAdBlockerActive && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_8__["default"], {
          children: [(0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Add your conversion ID below. Site Kit will place it on your site so you can track the performance of your Google Ads campaigns. <a>Learn more</a>', 'google-site-kit'), {
            a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_SupportLink__WEBPACK_IMPORTED_MODULE_4__["default"], {
              path: "/google-ads/thread/108976144/where-i-can-find-google-conversion-id-begins-with-aw",
              external: true
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("br", {}), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always change this later in Site Kit Settings.', 'google-site-kit')]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_SetupForm__WEBPACK_IMPORTED_MODULE_3__["default"], {
          finishSetup: finishSetup
        })]
      })]
    })]
  });
}
SetupMain.propTypes = {
  finishSetup: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().func)
};
SetupMain.defaultProps = {
  finishSetup: () => {}
};

/***/ }),

/***/ "./js/modules/ads/components/setup/SetupMainPAX.js":
/*!*********************************************************!*\
  !*** ./js/modules/ads/components/setup/SetupMainPAX.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupMainPAX)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var use_memo_one__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! use-memo-one */ "../node_modules/use-memo-one/dist/use-memo-one.esm.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _svg_graphics_ads_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/graphics/ads.svg */ "./svg/graphics/ads.svg");
/* harmony import */ var _SetupFormPAX__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SetupFormPAX */ "./js/modules/ads/components/setup/SetupFormPAX.js");
/* harmony import */ var _js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/notifications/AdBlockerWarning */ "./js/components/notifications/AdBlockerWarning.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useQueryArg */ "./js/hooks/useQueryArg.js");
/* harmony import */ var _js_modules_ads_components_common_PAXEmbeddedApp__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/modules/ads/components/common/PAXEmbeddedApp */ "./js/modules/ads/components/common/PAXEmbeddedApp.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/modules/ads/pax/constants */ "./js/modules/ads/pax/constants.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/modules/ads/components/common */ "./js/modules/ads/components/common/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Ads Main PAX setup component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



















function SetupMainPAX({
  finishSetup
}) {
  const [openDialog, setOpenDialog] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_21__.useState)(false);
  const [showPaxAppQueryParam, setShowPaxAppQueryParam] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_10__["default"])(_js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_PARAM_SETUP_STEP);
  const showPaxAppStep = !!showPaxAppQueryParam && parseInt(showPaxAppQueryParam, 10);
  const paxAppRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_21__.useRef)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_17__["default"])();
  const isAdBlockerActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).isAdBlockerActive());
  const hasAdwordsScope = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).hasScope(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.ADWORDS_SCOPE));
  const oAuthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const redirectURL = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_22__.addQueryArgs)(__webpack_require__.g.location.href, {
      [_js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_PARAM_SETUP_STEP]: _js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_SETUP_STEP.LAUNCH
    });
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).getConnectURL({
      additionalScopes: [_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.ADWORDS_SCOPE, _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.SUPPORT_CONTENT_SCOPE],
      redirectURL
    });
  });
  const isNavigatingToOAuthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    if (!oAuthURL) {
      return false;
    }
    return select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_LOCATION).isNavigatingTo(oAuthURL);
  });
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_LOCATION);
  const {
    setPaxConversionID,
    setCustomerID,
    setExtCustomerID,
    setFormattedExtCustomerID,
    setUserID,
    setAccountOverviewURL,
    submitChanges
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ADS);
  (0,react_use__WEBPACK_IMPORTED_MODULE_23__["default"])(() => {
    if (_js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_SETUP_STEP.FINISHED === showPaxAppStep) {
      // If the PAX query param indicates the setup is finished on page load,
      // set the step back to the PAX launch, as values are only temporarily
      // saved in state after PAX campaign setup signal is received.
      setShowPaxAppQueryParam(_js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_SETUP_STEP.LAUNCH);
    }
  });
  const {
    setConversionTrackingEnabled,
    saveConversionTrackingSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_SITE);

  // Callback to be executed when a campaign is created in PAX.
  //
  // We use `useCallbackOne` to ensure the function is only created once
  // and not recreated when React potentially uncaches the callback causing
  // it to be recreated and trigger the PAX app to re-render.
  const onCampaignCreated = (0,use_memo_one__WEBPACK_IMPORTED_MODULE_24__.useCallbackOne)(async () => {
    if (!paxAppRef?.current) {
      return;
    }

    /* eslint-disable sitekit/acronym-case */
    // Disabling rule because function and property names
    // are expected in current format by PAX API.
    const {
      accountService,
      conversionTrackingIdService
    } = paxAppRef.current.getServices();
    const customerData = await accountService.getAccountId({});
    const googleAdsURLData = await accountService.getGoogleAdsUrl({});
    const conversionTrackingData = await conversionTrackingIdService.getConversionTrackingId({});
    if (!customerData.externalCustomerId && !conversionTrackingData.conversionTrackingId) {
      return;
    }
    (0,_js_util__WEBPACK_IMPORTED_MODULE_18__.trackEvent)(`${viewContext}_pax`, 'pax_campaign_created');
    triggerSurvey('pax_campaign_created');
    setUserID(customerData.userId);
    setCustomerID(customerData.customerId);
    setExtCustomerID(customerData.externalCustomerId);
    setFormattedExtCustomerID(customerData.formattedExternalCustomerId);
    setPaxConversionID(conversionTrackingData.conversionTrackingId);
    setAccountOverviewURL(googleAdsURLData.accountOverviewUrl);
    /* eslint-enable sitekit/acronym-case */

    // Here we save settings right away but leave final navigation to `onSetupComplete`.
    const {
      error
    } = await submitChanges();
    if (!error) {
      setConversionTrackingEnabled(true);
      await saveConversionTrackingSettings();
    }
  }, [setExtCustomerID, setPaxConversionID, viewContext]);
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useRegistry)();
  const onCompleteSetup = (0,use_memo_one__WEBPACK_IMPORTED_MODULE_24__.useCallbackOne)(async () => {
    // Encapsulate dependencies to avoid function changing after launch.
    const {
      select,
      resolveSelect
    } = registry;
    await resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_SITE).getSiteInfo();
    const redirectURL = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_SITE).getAdminURL('googlesitekit-dashboard', {
      notification: _js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_SETUP_SUCCESS_NOTIFICATION
    });
    await Promise.all([(0,_js_util__WEBPACK_IMPORTED_MODULE_18__.trackEvent)(`${viewContext}_pax`, 'pax_setup_completed'), triggerSurvey('pax_setup_completed')]);
    finishSetup(redirectURL);
  }, [registry, finishSetup, viewContext]);
  const isWooCommerceRedirectModalDismissed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ADS).isWooCommerceRedirectModalDismissed());
  const isWooCommerceActivated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ADS).isWooCommerceActivated());
  const isGoogleForWooCommerceAdsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const hasGoogleForWooCommerceAdsAccount = select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ADS).hasGoogleForWooCommerceAdsAccount();
    const isGoogleForWooCommerceActive = select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ADS).isGoogleForWooCommerceActivated();
    return isWooCommerceActivated && isGoogleForWooCommerceActive && hasGoogleForWooCommerceAdsAccount;
  });
  const createAccount = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_21__.useCallback)(() => {
    if (!hasAdwordsScope) {
      navigateTo(oAuthURL);
      return;
    }
    setShowPaxAppQueryParam(_js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_SETUP_STEP.LAUNCH);
  }, [navigateTo, setShowPaxAppQueryParam, hasAdwordsScope, oAuthURL]);
  const onLaunch = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_21__.useCallback)(app => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_18__.trackEvent)(`${viewContext}_pax`, 'pax_launch');
    triggerSurvey('pax_launch');
    paxAppRef.current = app;
  }, [viewContext, triggerSurvey]);
  const onSetupCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_21__.useCallback)(async () => {
    if (isWooCommerceActivated && !isWooCommerceRedirectModalDismissed) {
      setOpenDialog(true);
      return;
    }

    // awaiting because `createAccount` may trigger a navigation.
    await Promise.all([(0,_js_util__WEBPACK_IMPORTED_MODULE_18__.trackEvent)(viewContext, 'start_setup_pax'), triggerSurvey('start_setup_pax')]);
    createAccount();
  }, [triggerSurvey, isWooCommerceActivated, isWooCommerceRedirectModalDismissed, setOpenDialog, createAccount, viewContext]);
  const setupNewAdsAccountSupportURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_SITE).getDocumentationLinkURL('ads-set-up-a-new-ads-account'));
  const setupExistingAdsAccountSupportURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_SITE).getDocumentationLinkURL('ads-connect-an-existing-ads-account'));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-setup-module', 'googlesitekit-setup-module--ads', {
      'has-pax-flow': !isAdBlockerActive && _js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_SETUP_STEP.LAUNCH === showPaxAppStep && hasAdwordsScope
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
      className: "googlesitekit-setup-module__step",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("div", {
        className: "googlesitekit-setup-module__logo",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_svg_graphics_ads_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
          width: "40",
          height: "40"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_19__["default"], {
        as: "h3",
        size: "small",
        type: "headline",
        className: "googlesitekit-setup-module__title",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('Ads', 'Service name', 'google-site-kit')
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)("div", {
      className: "googlesitekit-setup-module__step",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_components_notifications_AdBlockerWarning__WEBPACK_IMPORTED_MODULE_6__["default"], {
        moduleSlug: "ads"
      }), !isAdBlockerActive && _js_modules_ads_pax_constants__WEBPACK_IMPORTED_MODULE_13__.PAX_SETUP_STEP.LAUNCH === showPaxAppStep && hasAdwordsScope && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_14__.Row, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_14__.Cell, {
          mdSize: 12,
          lgSize: 12,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_modules_ads_components_common_PAXEmbeddedApp__WEBPACK_IMPORTED_MODULE_11__["default"], {
            displayMode: "setup",
            onLaunch: onLaunch,
            onCampaignCreated: onCampaignCreated,
            onFinishAndCloseSignUpFlow: onCompleteSetup
          })
        })
      }), !isAdBlockerActive && (!showPaxAppStep || !hasAdwordsScope) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_14__.Row, {
        className: "googlesitekit-setup-module--ads--setup-container",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_14__.Cell, {
          smSize: 8,
          mdSize: 8,
          lgSize: 5,
          className: "align-top",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_19__["default"], {
            as: "h3",
            type: "headline",
            size: "small",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Set up a new Ads account', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
            className: "instructions",
            children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_25__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Create your first Ads campaign, add billing information, and choose your conversion goals. To create a new Ads account, you’ll need to grant Site Kit additional permissions during the account creation process. <a>Learn more</a>', 'google-site-kit'), {
              a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_16__["default"], {
                href: setupNewAdsAccountSupportURL,
                external: true
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.SpinnerButton, {
            onClick: onSetupCallback,
            disabled: isNavigatingToOAuthURL,
            isSaving: isNavigatingToOAuthURL,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Start setup', 'google-site-kit')
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_14__.Cell, {
          className: "divider",
          smSize: 8,
          mdSize: 8,
          lgSize: 2,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("span", {
            className: "divider-line"
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("span", {
            className: "divider-label",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('OR', 'google-site-kit')
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsxs)(_js_material_components__WEBPACK_IMPORTED_MODULE_14__.Cell, {
          smSize: 8,
          mdSize: 8,
          lgSize: 5,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_19__["default"], {
            as: "h3",
            type: "headline",
            size: "small",
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Connect an existing Ads account', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("p", {
            className: "instructions",
            children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_25__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('To track conversions for your Ads campaign, you need to add your Conversion ID to Site Kit. You can always change the Conversion ID later in Site Kit Settings. <a>Learn more</a>', 'google-site-kit'), {
              a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_16__["default"], {
                href: setupExistingAdsAccountSupportURL,
                external: true
              }),
              br: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)("br", {})
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_SetupFormPAX__WEBPACK_IMPORTED_MODULE_5__["default"], {
            finishSetup: finishSetup,
            isNavigatingToOAuthURL: isNavigatingToOAuthURL
          })]
        })]
      })]
    }), openDialog && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_20__.jsx)(_js_modules_ads_components_common__WEBPACK_IMPORTED_MODULE_15__.WooCommerceRedirectModal, {
      onClose: isGoogleForWooCommerceAdsConnected ? null : () => setOpenDialog(false),
      onContinue: createAccount,
      dialogActive: true
    })]
  });
}
SetupMainPAX.defaultProps = {
  finishSetup: () => {}
};

/***/ }),

/***/ "./js/modules/ads/components/setup/index.js":
/*!**************************************************!*\
  !*** ./js/modules/ads/components/setup/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SetupForm: () => (/* reexport safe */ _SetupForm__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   SetupFormPAX: () => (/* reexport safe */ _SetupFormPAX__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   SetupMain: () => (/* reexport safe */ _SetupMain__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SetupMainPAX: () => (/* reexport safe */ _SetupMainPAX__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _SetupForm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SetupForm */ "./js/modules/ads/components/setup/SetupForm.js");
/* harmony import */ var _SetupFormPAX__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SetupFormPAX */ "./js/modules/ads/components/setup/SetupFormPAX.js");
/* harmony import */ var _SetupMain__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SetupMain */ "./js/modules/ads/components/setup/SetupMain.js");
/* harmony import */ var _SetupMainPAX__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SetupMainPAX */ "./js/modules/ads/components/setup/SetupMainPAX.js");
/**
 * Ads Setup components.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */






/***/ }),

/***/ "./js/modules/ads/constants.js":
/*!*************************************!*\
  !*** ./js/modules/ads/constants.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_ADS: () => (/* binding */ MODULE_SLUG_ADS)
/* harmony export */ });
/**
 * Ads module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_ADS = 'ads';

/***/ }),

/***/ "./js/modules/ads/datastore/adblocker.js":
/*!***********************************************!*\
  !*** ./js/modules/ads/datastore/adblocker.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/**
 * `modules/ads` data store: adblocker.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const selectors = {
  /**
   * Returns appropriate ad blocker warning message based on modules connection status.
   *
   * @since 1.125.0
   *
   * @param {Object} state Data store's state.
   * @return {(string|null|undefined)} The error message string if an ad blocker is active,
   *                                   `null` if an ad blocker isn't detected,
   *                                   `undefined` if ad blocker detection has not completed yet.
   */
  getAdBlockerWarningMessage: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const isAdBlockerActive = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isAdBlockerActive();
    if (undefined === isAdBlockerActive) {
      return undefined;
    }
    if (!isAdBlockerActive) {
      return null;
    }
    const isModuleConnected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).isModuleConnected(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ADS);
    if (isModuleConnected) {
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To get the latest Ads data you will need to disable your Ad blocker', 'google-site-kit');
    }
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To set up Ads you will need to disable your Ad blocker', 'google-site-kit');
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  selectors
});

/***/ }),

/***/ "./js/modules/ads/datastore/base.js":
/*!******************************************!*\
  !*** ./js/modules/ads/datastore/base.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-modules */ "googlesitekit-modules");
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./settings */ "./js/modules/ads/datastore/settings.js");
/**
 * `modules/ads` base data store.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




const baseModuleStore = googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0___default().createModuleStore(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_ADS, {
  ownedSettingsSlugs: ['conversionID', 'paxConversionID', 'extCustomerID', 'customerID', 'userID'],
  storeName: _constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_ADS,
  settingSlugs: ['conversionID', 'ownerID', 'paxConversionID', 'customerID', 'extCustomerID', 'formattedExtCustomerID', 'userID', 'accountOverviewURL'],
  requiresSetup: true,
  submitChanges: _settings__WEBPACK_IMPORTED_MODULE_3__.submitChanges,
  rollbackChanges: _settings__WEBPACK_IMPORTED_MODULE_3__.rollbackChanges,
  validateCanSubmitChanges: _settings__WEBPACK_IMPORTED_MODULE_3__.validateCanSubmitChanges,
  validateHaveSettingsChanged: _settings__WEBPACK_IMPORTED_MODULE_3__.validateHaveSettingsChanged
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseModuleStore);

/***/ }),

/***/ "./js/modules/ads/datastore/constants.js":
/*!***********************************************!*\
  !*** ./js/modules/ads/datastore/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ADS_MODULE_SETUP_BANNER_PROMPT_DISMISSED_KEY: () => (/* binding */ ADS_MODULE_SETUP_BANNER_PROMPT_DISMISSED_KEY),
/* harmony export */   ADS_WOOCOMMERCE_REDIRECT_MODAL_CACHE_KEY: () => (/* binding */ ADS_WOOCOMMERCE_REDIRECT_MODAL_CACHE_KEY),
/* harmony export */   ADWORDS_SCOPE: () => (/* binding */ ADWORDS_SCOPE),
/* harmony export */   AVAILABLE_PLUGINS: () => (/* binding */ AVAILABLE_PLUGINS),
/* harmony export */   DATE_RANGE_OFFSET: () => (/* binding */ DATE_RANGE_OFFSET),
/* harmony export */   MODULES_ADS: () => (/* binding */ MODULES_ADS),
/* harmony export */   PLUGINS: () => (/* binding */ PLUGINS),
/* harmony export */   SUPPORT_CONTENT_SCOPE: () => (/* binding */ SUPPORT_CONTENT_SCOPE)
/* harmony export */ });
/**
 * `modules/ads` data store constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_ADS = 'modules/ads';
const ADWORDS_SCOPE = 'https://www.googleapis.com/auth/adwords';
const SUPPORT_CONTENT_SCOPE = 'https://www.googleapis.com/auth/supportcontent';

// Date range offset days for Ads report requests.
const DATE_RANGE_OFFSET = 1;
const ADS_MODULE_SETUP_BANNER_PROMPT_DISMISSED_KEY = 'ads_module_setup_banner_prompt_dismissed_key';
const ADS_WOOCOMMERCE_REDIRECT_MODAL_CACHE_KEY = 'wc-redirect-modal';
const PLUGINS = {
  WOOCOMMERCE: 'woocommerce',
  GOOGLE_FOR_WOOCOMMERCE: 'google-listings-and-ads'
};
const AVAILABLE_PLUGINS = [PLUGINS.WOOCOMMERCE, PLUGINS.GOOGLE_FOR_WOOCOMMERCE];

/***/ }),

/***/ "./js/modules/ads/datastore/index.js":
/*!*******************************************!*\
  !*** ./js/modules/ads/datastore/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   registerStore: () => (/* binding */ registerStore),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./base */ "./js/modules/ads/datastore/base.js");
/* harmony import */ var _adblocker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./adblocker */ "./js/modules/ads/datastore/adblocker.js");
/* harmony import */ var _module_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./module-data */ "./js/modules/ads/datastore/module-data.js");
/* harmony import */ var _woocommerce__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./woocommerce */ "./js/modules/ads/datastore/woocommerce.js");
/* harmony import */ var _service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./service */ "./js/modules/ads/datastore/service.js");
/**
 * `modules/ads` data store.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */







const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores)(_base__WEBPACK_IMPORTED_MODULE_2__["default"], _adblocker__WEBPACK_IMPORTED_MODULE_3__["default"], _module_data__WEBPACK_IMPORTED_MODULE_4__["default"], _woocommerce__WEBPACK_IMPORTED_MODULE_5__["default"], _service__WEBPACK_IMPORTED_MODULE_6__["default"]);
const initialState = store.initialState;
const actions = store.actions;
const controls = store.controls;
const reducer = store.reducer;
const resolvers = store.resolvers;
const selectors = store.selectors;
function registerStore(registry) {
  registry.registerStore(_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_ADS, store);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/ads/datastore/module-data.js":
/*!*************************************************!*\
  !*** ./js/modules/ads/datastore/module-data.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_info__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/info */ "./js/googlesitekit/datastore/site/info.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/**
 * `modules/ads` data store: module data.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies.
 */


/**
 * Internal dependencies
 */





function getModuleDataProperty(propName) {
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const moduleData = select(_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ADS).getModuleData() || [];
    return moduleData[propName];
  });
}
function getPluginStatusProperty(propName, plugin) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(propName, 'propName is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(plugin, 'plugin is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(_constants__WEBPACK_IMPORTED_MODULE_2__.AVAILABLE_PLUGINS.includes(plugin), 'Invalid plugin.');
  return (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
    const {
      getPluginsData
    } = select(_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ADS);
    const pluginData = getPluginsData() || [];
    const pluginStatus = pluginData[plugin] || [];
    return pluginStatus[propName];
  });
}

// Actions
const RECEIVE_MODULE_DATA = 'RECEIVE_MODULE_DATA';
const initialState = {
  moduleData: {
    supportedConversionEvents: undefined,
    plugins: undefined
  }
};
const actions = {
  /**
   * Stores module data in the datastore.
   *
   * @since 1.127.0
   * @private
   *
   * @param {Object} moduleData Module data object.
   * @return {Object} Redux-style action.
   */
  receiveModuleData(moduleData) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(moduleData, 'moduleData is required.');
    return {
      payload: moduleData,
      type: RECEIVE_MODULE_DATA
    };
  }
};
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, {
  payload,
  type
}) => {
  switch (type) {
    case RECEIVE_MODULE_DATA:
      {
        const {
          supportedConversionEvents,
          plugins
        } = payload;
        const moduleData = {
          supportedConversionEvents,
          plugins
        };
        state.moduleData = moduleData;
        break;
      }
    default:
      break;
  }
});
const resolvers = {
  /**
   * Resolves module data.
   *
   * @since 1.127.0
   * @since 1.162.0 Updated to use centralized module data access.
   */
  *getModuleData() {
    const {
      resolveSelect
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();
    const moduleData = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.await(resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getModuleInlineData(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ADS));
    if (!moduleData) {
      return;
    }
    yield actions.receiveModuleData(moduleData);
  }
};
const selectors = {
  /**
   * Gets all module data from this data store.
   *
   * Not intended to be used publicly; this is largely here so other selectors can
   * request data using the selector/resolver pattern.
   *
   * @since 1.127.0
   * @private
   *
   * @param {Object} state Data store's state.
   * @return {(Object|undefined)} Module data.
   */
  getModuleData(state) {
    return state.moduleData;
  },
  /**
   * Gets supported conversion events.
   *
   * @since 1.127.0
   *
   * @param {Object} state Data store's state.
   * @return {(Array|undefined)} List of supported conversion events.
   */
  getSupportedConversionEvents: getModuleDataProperty('supportedConversionEvents'),
  /**
   * Gets plugins data.
   *
   * @since 1.148.0
   *
   * @param {Object} state Data store's state.
   * @return {Array|undefined} Plugins data array.
   */
  getPluginsData: getModuleDataProperty('plugins'),
  /**
   * Determines whether the WooCommerce plugin is installed or not.
   *
   * @since 1.148.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} True if the plugin is installed, false if it is not, and undefined if data is being resolved.
   */
  isWooCommerceInstalled: getPluginStatusProperty('installed', _constants__WEBPACK_IMPORTED_MODULE_2__.PLUGINS.WOOCOMMERCE),
  /**
   * Determines whether the WooCommerce plugin is activated or not.
   *
   * @since 1.148.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} True if the plugin is activated, false if it is not, and undefined if data is being resolved.
   */
  isWooCommerceActivated: getPluginStatusProperty('active', _constants__WEBPACK_IMPORTED_MODULE_2__.PLUGINS.WOOCOMMERCE),
  /**
   * Determines whether the Google for WooCommerce plugin is installed or not.
   *
   * @since 1.148.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} True if the plugin is installed, false if it is not, and undefined if data is being resolved.
   */
  isGoogleForWooCommerceInstalled: getPluginStatusProperty('installed', _constants__WEBPACK_IMPORTED_MODULE_2__.PLUGINS.GOOGLE_FOR_WOOCOMMERCE),
  /**
   * Determines whether the Google for WooCommerce plugin is activated or not.
   *
   * @since 1.148.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} True if the plugin is activated, false if it is not, and undefined if data is being resolved.
   */
  isGoogleForWooCommerceActivated: getPluginStatusProperty('active', _constants__WEBPACK_IMPORTED_MODULE_2__.PLUGINS.GOOGLE_FOR_WOOCOMMERCE),
  /**
   * Determines whether the Google for WooCommerce plugin has the linked Ads account.
   *
   * @since 1.148.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean|undefined} True if the plugin has linked Ads account, false if it doesn't have it, and undefined if data is being resolved.
   */
  hasGoogleForWooCommerceAdsAccount: getPluginStatusProperty('adsConnected', _constants__WEBPACK_IMPORTED_MODULE_2__.PLUGINS.GOOGLE_FOR_WOOCOMMERCE),
  /**
   * Gets Google for WooCommerce Ads connected conversion ID.
   *
   * @since 1.148.0
   *
   * @param {Object} state Data store's state.
   * @return {string|undefined} Ads conversion ID value if present, empty string if not present, and undefined if data is being resolved.
   */
  getGoogleForWooCommerceConversionID: getPluginStatusProperty('conversionID', _constants__WEBPACK_IMPORTED_MODULE_2__.PLUGINS.GOOGLE_FOR_WOOCOMMERCE)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  initialState,
  actions,
  controls: _js_googlesitekit_datastore_site_info__WEBPACK_IMPORTED_MODULE_3__.controls,
  reducer,
  resolvers,
  selectors
});

/***/ }),

/***/ "./js/modules/ads/datastore/service.js":
/*!*********************************************!*\
  !*** ./js/modules/ads/datastore/service.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/**
 * `modules/ads` data store: service.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





const selectors = {
  /**
   * Overrides the details link URL for the module.
   *
   * @since 1.150.0
   *
   * @return {string} Details link URL.
   */
  getDetailsLinkURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createRegistrySelector)(select => () => {
    const accountOverviewURL = select(_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_ADS).getAccountOverviewURL();
    if (accountOverviewURL) {
      return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getAccountChooserURL(accountOverviewURL);
    }
    const module = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModule(_js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_3__.MODULE_SLUG_ADS);
    if (module === undefined) {
      return undefined;
    }
    if (module === null || !module.homepage) {
      return null;
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getAccountChooserURL(module.homepage);
  })
};
const store = {
  selectors
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/ads/datastore/settings.js":
/*!**********************************************!*\
  !*** ./js/modules/ads/datastore/settings.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INVARIANT_INVALID_CONVERSION_ID: () => (/* binding */ INVARIANT_INVALID_CONVERSION_ID),
/* harmony export */   rollbackChanges: () => (/* binding */ rollbackChanges),
/* harmony export */   submitChanges: () => (/* binding */ submitChanges),
/* harmony export */   validateCanSubmitChanges: () => (/* binding */ validateCanSubmitChanges),
/* harmony export */   validateHaveSettingsChanged: () => (/* binding */ validateHaveSettingsChanged)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-settings-store */ "./js/googlesitekit/data/create-settings-store.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/ads/constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_modules_ads_utils_validation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/ads/utils/validation */ "./js/modules/ads/utils/validation.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/**
 * `modules/ads` data store: settings.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */










// Invariant error messages.
const INVARIANT_INVALID_CONVERSION_ID = 'a valid conversionID is required to submit changes';
async function submitChanges({
  select,
  dispatch
}) {
  const haveSettingsChanged = select(_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ADS).haveSettingsChanged();

  // This action shouldn't be called if settings haven't changed,
  // but this prevents errors in tests.
  if (haveSettingsChanged) {
    const {
      error
    } = await dispatch(_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ADS).saveSettings();
    if (error) {
      return {
        error
      };
    }
  }
  const haveConversionTrackingSettingsChanged = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).haveConversionTrackingSettingsChanged();
  if (haveConversionTrackingSettingsChanged) {
    const {
      error
    } = await dispatch(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).saveConversionTrackingSettings();
    if (error) {
      return {
        error
      };
    }
  }
  const haveGoogleTagGatewaySettingsChanged = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).haveGoogleTagGatewaySettingsChanged();
  if (haveGoogleTagGatewaySettingsChanged) {
    const {
      error
    } = await dispatch(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).saveGoogleTagGatewaySettings();
    if (error) {
      return {
        error
      };
    }
    if (select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).isGoogleTagGatewayEnabled() && !select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_NOTIFICATIONS).isNotificationDismissed(_js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.GTG_SETUP_CTA_BANNER_NOTIFICATION)) {
      const {
        error: dismissError
      } = (await dispatch(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_NOTIFICATIONS).dismissNotification(_js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.GTG_SETUP_CTA_BANNER_NOTIFICATION)) || {};
      if (dismissError) {
        return {
          error: dismissError
        };
      }
    }
  }
  await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.invalidateCache)('modules', _js_modules_ads_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ADS);
  await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.invalidateCache)('core', 'site', 'ads-measurement-status');
  return {};
}
function validateCanSubmitChanges(select) {
  const strictSelect = (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_3__.createStrictSelect)(select);
  const {
    isDoingSubmitChanges,
    haveSettingsChanged,
    getConversionID,
    getPaxConversionID
  } = strictSelect(_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ADS);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(!isDoingSubmitChanges(), _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_4__.INVARIANT_DOING_SUBMIT_CHANGES);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(haveSettingsChanged(), _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_4__.INVARIANT_SETTINGS_NOT_CHANGED);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_ads_utils_validation__WEBPACK_IMPORTED_MODULE_9__.isValidConversionID)(getConversionID()) || (0,_js_modules_ads_utils_validation__WEBPACK_IMPORTED_MODULE_9__.isValidConversionID)(getPaxConversionID()), INVARIANT_INVALID_CONVERSION_ID);
}
function rollbackChanges({
  select,
  dispatch
}) {
  if (select(_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ADS).haveSettingsChanged()) {
    dispatch(_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_ADS).rollbackSettings();
    dispatch(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).resetConversionTrackingSettings();
    dispatch(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).resetGoogleTagGatewaySettings();
  }
}
function validateHaveSettingsChanged(select, state, keys) {
  const {
    settings,
    savedSettings
  } = state;
  const haveConversionTrackingSettingsChanged = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).haveConversionTrackingSettingsChanged();
  const haveGoogleTagGatewaySettingsChanged = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).haveGoogleTagGatewaySettingsChanged();
  if (keys) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)((0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(settings, keys), (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(savedSettings, keys)) || !haveConversionTrackingSettingsChanged || haveGoogleTagGatewaySettingsChanged, _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_4__.INVARIANT_SETTINGS_NOT_CHANGED);
  }
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(settings, savedSettings) || haveConversionTrackingSettingsChanged || haveGoogleTagGatewaySettingsChanged, _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_4__.INVARIANT_SETTINGS_NOT_CHANGED);
}

/***/ }),

/***/ "./js/modules/ads/datastore/woocommerce.js":
/*!*************************************************!*\
  !*** ./js/modules/ads/datastore/woocommerce.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/**
 * `modules/ads` data store: woocommerce
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies.
 */


/**
 * Internal dependencies
 */




// Actions.
const RECEIVE_WOOCOMMERCE_MODAL_CACHE_KEY = 'RECEIVE_WOOCOMMERCE_MODAL_CACHE_KEY';
const initialState = {
  woocommerceModalDismissed: false
};
const actions = {
  /**
   * Stores woocommerce modal dismissal in the datastore.
   *
   * @since 1.150.0
   * @private
   *
   * @param {Object} cacheHit Boolean property extracted fro mthe cache item.
   * @return {Object} Redux-style action.
   */
  receiveIsWooCommerceRedirectModalDismissed(cacheHit) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(cacheHit !== undefined, 'A cacheHit is required.');
    return {
      type: RECEIVE_WOOCOMMERCE_MODAL_CACHE_KEY,
      payload: {
        cacheHit
      }
    };
  }
};
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case RECEIVE_WOOCOMMERCE_MODAL_CACHE_KEY:
      state.woocommerceModalDismissed = payload.cacheHit;
      break;
    default:
      break;
  }
});
const selectors = {
  /**
   * Gets the WooCommerce modal dismissal status.
   *
   * @since 1.150.0
   *
   * @param {Object} state Data store's state.
   * @return {(boolean)} WooCommerce modal dismissed status.
   */
  isWooCommerceRedirectModalDismissed(state) {
    return state.woocommerceModalDismissed;
  }
};
const resolvers = {
  *isWooCommerceRedirectModalDismissed() {
    const {
      cacheHit
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.await((0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.getItem)(_constants__WEBPACK_IMPORTED_MODULE_2__.ADS_WOOCOMMERCE_REDIRECT_MODAL_CACHE_KEY));
    yield actions.receiveIsWooCommerceRedirectModalDismissed(cacheHit || false);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  initialState,
  actions,
  reducer,
  resolvers,
  selectors
});

/***/ }),

/***/ "./js/modules/ads/index.js":
/*!*********************************!*\
  !*** ./js/modules/ads/index.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ADS_NOTIFICATIONS: () => (/* binding */ ADS_NOTIFICATIONS),
/* harmony export */   registerModule: () => (/* binding */ registerModule),
/* harmony export */   registerNotifications: () => (/* binding */ registerNotifications),
/* harmony export */   registerStore: () => (/* reexport safe */ _datastore__WEBPACK_IMPORTED_MODULE_15__.registerStore),
/* harmony export */   registerWidgets: () => (/* binding */ registerWidgets)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var _svg_graphics_ads_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/graphics/ads.svg */ "./svg/graphics/ads.svg");
/* harmony import */ var _components_settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/settings */ "./js/modules/ads/components/settings/index.js");
/* harmony import */ var _components_setup__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/setup */ "./js/modules/ads/components/setup/index.js");
/* harmony import */ var _datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/modules/ads/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/* harmony import */ var _components_notifications__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/notifications */ "./js/modules/ads/components/notifications/index.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _pax_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./pax/constants */ "./js/modules/ads/pax/constants.js");
/* harmony import */ var _components_notifications_EnhancedConversionsNotification__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./components/notifications/EnhancedConversionsNotification */ "./js/modules/ads/components/notifications/EnhancedConversionsNotification.js");
/* harmony import */ var _components_settings_SettingsDisconnectNote__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./components/settings/SettingsDisconnectNote */ "./js/modules/ads/components/settings/SettingsDisconnectNote.js");
/* harmony import */ var _datastore__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./datastore */ "./js/modules/ads/datastore/index.js");
/**
 * Ads module initialization.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */















function registerModule(modules) {
  modules.registerModule(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS, {
    storeName: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS,
    SettingsEditComponent: _components_settings__WEBPACK_IMPORTED_MODULE_2__.SettingsEdit,
    SettingsViewComponent: _components_settings__WEBPACK_IMPORTED_MODULE_2__.SettingsView,
    SetupComponent: (0,_js_features__WEBPACK_IMPORTED_MODULE_8__.isFeatureEnabled)('adsPax') ? _components_setup__WEBPACK_IMPORTED_MODULE_3__.SetupMainPAX : _components_setup__WEBPACK_IMPORTED_MODULE_3__.SetupMain,
    Icon: _svg_graphics_ads_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
    features: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Tagging necessary for your ads campaigns to work will be disabled', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Conversion tracking for your ads campaigns will be disabled', 'google-site-kit')],
    SettingsDisconnectNoteComponent: (0,_js_features__WEBPACK_IMPORTED_MODULE_8__.isFeatureEnabled)('adsPax') ? _components_settings_SettingsDisconnectNote__WEBPACK_IMPORTED_MODULE_14__["default"] : undefined,
    overrideSetupSuccessNotification: true,
    checkRequirements: async registry => {
      const adBlockerActive = await registry.resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).isAdBlockerActive();
      if (!adBlockerActive) {
        return;
      }
      const message = registry.select(_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS).getAdBlockerWarningMessage();
      throw {
        code: _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.ERROR_CODE_ADBLOCKER_ACTIVE,
        message,
        data: null
      };
    }
  });
}
function registerWidgets() {}
const ADS_NOTIFICATIONS = {
  'setup-success-notification-ads': {
    Component: _components_notifications__WEBPACK_IMPORTED_MODULE_9__.SetupSuccessSubtleNotification,
    areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_11__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_11__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY],
    checkRequirements: () => {
      const notification = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_16__.getQueryArg)(location.href, 'notification');
      const slug = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_16__.getQueryArg)(location.href, 'slug');
      if ('authentication_success' === notification && slug === _constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS) {
        return true;
      }
      return false;
    }
  },
  'setup-success-notification-pax': {
    Component: _components_notifications__WEBPACK_IMPORTED_MODULE_9__.PAXSetupSuccessSubtleNotification,
    areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_11__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_11__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY],
    checkRequirements: () => {
      const notification = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_16__.getQueryArg)(location.href, 'notification');
      if (_pax_constants__WEBPACK_IMPORTED_MODULE_12__.PAX_SETUP_SUCCESS_NOTIFICATION === notification) {
        return true;
      }
      return false;
    }
  },
  'account-linked-via-google-for-woocommerce': {
    Component: _components_notifications__WEBPACK_IMPORTED_MODULE_9__.AccountLinkedViaGoogleForWooCommerceSubtleNotification,
    areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_11__.VIEW_CONTEXT_MAIN_DASHBOARD],
    checkRequirements: async ({
      select,
      resolveSelect
    }) => {
      // isWooCommerceActivated, isGoogleForWooCommerceActivated and isGoogleForWooCommerceLinked are all relying
      // on the data being resolved in getModuleData() selector.
      const [, isModuleConnected] = await Promise.all([resolveSelect(_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS).getModuleData(), resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).isModuleConnected(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS)]);
      const {
        isWooCommerceActivated,
        isGoogleForWooCommerceActivated,
        hasGoogleForWooCommerceAdsAccount
      } = select(_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS);
      return !isModuleConnected && isWooCommerceActivated() && isGoogleForWooCommerceActivated() && hasGoogleForWooCommerceAdsAccount();
    },
    featureFlag: 'adsPax',
    isDismissible: true
  },
  'ads-setup-cta': {
    Component: _components_notifications__WEBPACK_IMPORTED_MODULE_9__.AdsModuleSetupCTABanner,
    // This notification should be displayed before audience segmentation one,
    // which has priority of PRIORITY.SETUP_CTA_LOW
    priority: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.PRIORITY.SETUP_CTA_HIGH,
    areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    groupID: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.NOTIFICATION_GROUPS.SETUP_CTAS,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_11__.VIEW_CONTEXT_MAIN_DASHBOARD],
    checkRequirements: async ({
      select,
      resolveSelect
    }) => {
      await Promise.all([
      // isGoogleForWooCommerceLinked is relying
      // on the data being resolved in getModuleData() selector.
      resolveSelect(_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS).getModuleData(), resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).isModuleConnected(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS), resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).canActivateModule(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS)]);
      const {
        isModuleConnected
      } = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES);
      const {
        hasGoogleForWooCommerceAdsAccount
      } = select(_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ADS);
      const isAdsConnected = isModuleConnected(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS);
      return isAdsConnected === false && hasGoogleForWooCommerceAdsAccount() === false;
    },
    isDismissible: true,
    dismissRetries: 1,
    featureFlag: 'adsPax'
  },
  [_components_notifications_EnhancedConversionsNotification__WEBPACK_IMPORTED_MODULE_13__.ENHANCED_CONVERSIONS_NOTIFICATION_ADS]: {
    Component: _components_notifications_EnhancedConversionsNotification__WEBPACK_IMPORTED_MODULE_13__["default"],
    priority: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.PRIORITY.SETUP_CTA_HIGH,
    areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    groupID: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_10__.NOTIFICATION_GROUPS.SETUP_CTAS,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_11__.VIEW_CONTEXT_MAIN_DASHBOARD],
    checkRequirements: async ({
      resolveSelect
    }) => {
      const adsConnected = await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).isModuleConnected(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ADS);
      if (!adsConnected) {
        return false;
      }
      return true;
    },
    isDismissible: true,
    featureFlag: 'gtagUserData'
  }
};
function registerNotifications(notifications) {
  for (const notificationID in ADS_NOTIFICATIONS) {
    notifications.registerNotification(notificationID, ADS_NOTIFICATIONS[notificationID]);
  }
}

/***/ }),

/***/ "./js/modules/ads/pax/config.js":
/*!**************************************!*\
  !*** ./js/modules/ads/pax/config.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPaxConfig: () => (/* binding */ createPaxConfig)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/ads/pax/constants.js");
/* eslint-disable valid-jsdoc */ // Disabled to allow type imports below.
/* eslint-disable jsdoc/valid-types */
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Creates PAX configuration.
 *
 * @since 1.129.0
 *
 * @param {Object}                                                                                options                  Optional.
 * @param {string}                                                                                options.contentContainer Optional. The container selector to launch the Ads app.
 * @param {import('google-pax-sdk/sdk/config/config.d.ts').google.ads.integration.ReportingStyle} options.reportingStyle   Optional. The campaign reporting style.
 * @return {import('google-pax-sdk/sdk/config/config.d.ts').google.ads.integration.Config} Configuration.
 */
function createPaxConfig(options = {}) {
  const {
    contentContainer,
    reportingStyle,
    _global = __webpack_require__.g
  } = options;
  const baseConfig = _global?.[_constants__WEBPACK_IMPORTED_MODULE_2__.PAX_GLOBAL_CONFIG];
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(baseConfig), 'base PAX config must be a plain object');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.merge)(baseConfig, contentContainer ? {
    clientConfig: {
      partnerName: 'site-kit',
      contentContainer
    }
  } : {}, reportingStyle ? {
    contentConfig: {
      partnerAdsExperienceConfig: {
        reportingStyle
      }
    }
  } : {});
}

/***/ }),

/***/ "./js/modules/ads/pax/constants.js":
/*!*****************************************!*\
  !*** ./js/modules/ads/pax/constants.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PAX_GLOBAL_CONFIG: () => (/* binding */ PAX_GLOBAL_CONFIG),
/* harmony export */   PAX_PARAM_SETUP_STEP: () => (/* binding */ PAX_PARAM_SETUP_STEP),
/* harmony export */   PAX_SETUP_STEP: () => (/* binding */ PAX_SETUP_STEP),
/* harmony export */   PAX_SETUP_SUCCESS_NOTIFICATION: () => (/* binding */ PAX_SETUP_SUCCESS_NOTIFICATION)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const PAX_PARAM_SETUP_STEP = 'pax';
const PAX_GLOBAL_CONFIG = '_googlesitekitPAXConfig';
const PAX_SETUP_STEP = {
  LAUNCH: 1,
  FINISHED: 2
};
const PAX_SETUP_SUCCESS_NOTIFICATION = 'pax_setup_success_notification';

/***/ }),

/***/ "./js/modules/ads/pax/index.js":
/*!*************************************!*\
  !*** ./js/modules/ads/pax/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPaxConfig: () => (/* reexport safe */ _config__WEBPACK_IMPORTED_MODULE_0__.createPaxConfig),
/* harmony export */   createPaxServices: () => (/* reexport safe */ _services__WEBPACK_IMPORTED_MODULE_1__.createPaxServices),
/* harmony export */   formatPaxDate: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_2__.formatPaxDate)
/* harmony export */ });
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./config */ "./js/modules/ads/pax/config.js");
/* harmony import */ var _services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./services */ "./js/modules/ads/pax/services.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./js/modules/ads/pax/utils.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "./js/modules/ads/pax/services.js":
/*!****************************************!*\
  !*** ./js/modules/ads/pax/services.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPaxServices: () => (/* binding */ createPaxServices)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "./js/api-fetch-shim.js");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/ads/datastore/constants */ "./js/modules/ads/datastore/constants.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils */ "./js/modules/ads/pax/utils.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/**
 * Services functions.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





async function restFetchWpPages() {
  try {
    const wpPages = await (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__["default"])({
      path: '/wp/v2/pages?per_page=100'
    });
    return wpPages.map(page => {
      return {
        title: page.title.rendered,
        path: new URL(page.link).pathname
      };
    });
  } catch {
    return [];
  }
}
function createMemoizedGetToken() {
  const maxAgeSeconds = 4 * 60; // 4 min in seconds
  const clearAfterSeconds = 30;
  const memoizedGetToken = memize__WEBPACK_IMPORTED_MODULE_1___default()(() => (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_3__.set)('core', 'user', 'get-token'));
  const debouncedClear = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.debounce)(memoizedGetToken.clear, clearAfterSeconds * 1000, {
    leading: false,
    trailing: true,
    maxWait: maxAgeSeconds * 1000
  });
  function getToken() {
    debouncedClear();
    return memoizedGetToken();
  }
  getToken.clear = () => {
    debouncedClear.cancel();
    memoizedGetToken.clear();
  };
  return getToken;
}

/**
 * Returns PAX services.
 *
 * @since 1.126.0
 * @since 1.128.0 Added options parameter.
 *
 * @param {Object}   registry                           Registry object to dispatch to.
 * @param {Object}   options                            Optional. Additional options.
 * @param {Function} options.onCampaignCreated          Callback function that will be called when campaign is created.
 * @param {Function} options.onFinishAndCloseSignUpFlow Callback function that will be called by the `userActionService.finishAndCloseSignUpFlow` if provided.
 * @return {Object} An object containing various service interfaces.
 */
function createPaxServices(registry, options = {}) {
  const {
    onCampaignCreated = null,
    onFinishAndCloseSignUpFlow = null
  } = options;
  const {
    select,
    resolveSelect
  } = registry;
  const getToken = createMemoizedGetToken();
  async function getSupportedConversionEvents() {
    await resolveSelect(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ADS).getModuleData();
    return select(_js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ADS).getSupportedConversionEvents() || [];
  }
  const services = {
    authenticationService: {
      // Ignore the ESLint rule that requires `await` in the function body.
      //
      // We mark this function as `async` to make it clear that it returns a
      // promise and in case, in the future, anything here wants to be async.
      //
      // Marking this function as `async` makes it clear that this will be
      // allowed.
      //
      // eslint-disable-next-line require-await
      get: async () => {
        const refreshedToken = await getToken();
        return {
          accessToken: refreshedToken.token
        };
      },
      // eslint-disable-next-line require-await
      fix: async () => {
        getToken.clear();
        return {
          retryReady: true
        };
      }
    },
    businessService: {
      getBusinessInfo: async () => {
        await resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getSiteInfo();

        /* eslint-disable sitekit/acronym-case */
        // Disabling rule because businessName and businessUrl are expected by PAX API.
        const businessName = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getSiteName();
        const businessUrl = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getHomeURL();
        return {
          businessName,
          businessUrl
        };
        /* eslint-enable sitekit/acronym-case */
      },
      // eslint-disable-next-line require-await
      fixBusinessInfo: async () => {
        return {
          retryReady: true
        };
      }
    },
    campaignService: {
      notifyNewCampaignCreated: async () => {
        if (onCampaignCreated) {
          await onCampaignCreated();
        }
        return {};
      }
    },
    conversionTrackingService: {
      getSupportedConversionLabels: async () => {
        const conversionEvents = await getSupportedConversionEvents();
        return {
          conversionLabels: conversionEvents
        };
      },
      getPageViewConversionSetting: async () => {
        const websitePages = await restFetchWpPages();
        return {
          websitePages
        };
      },
      getSupportedConversionTrackingTypes: async () => {
        const conversionEvents = await getSupportedConversionEvents();
        const conversionTrackingTypesArray = ['TYPE_PAGE_VIEW'];
        if (conversionEvents.length > 0) {
          conversionTrackingTypesArray.push('TYPE_CONVERSION_EVENT');
        }
        return {
          conversionTrackingTypes: conversionTrackingTypesArray
        };
      }
    },
    termsAndConditionsService: {
      // Ignore the ESLint rule that requires `await` in the function body.
      //
      // We mark this function as `async` to make it clear that it returns a
      // promise and in case, in the future, anything here wants to be async.
      //
      // Marking this function as `async` makes it clear that this will be
      // allowed.
      //
      // eslint-disable-next-line require-await
      notify: async () => {
        return {};
      }
    },
    partnerDateRangeService: {
      // Ignore the ESLint rule that requires `await` in the function body.
      //
      // We mark this function as `async` to make it clear that it returns a
      // promise and in case, in the future, anything here wants to be async.
      //
      // Marking this function as `async` makes it clear that this will be
      // allowed.
      //
      // eslint-disable-next-line require-await
      get: async () => {
        const {
          startDate,
          endDate
        } = registry.select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).getDateRangeDates({
          offsetDays: _js_modules_ads_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.DATE_RANGE_OFFSET
        });
        return {
          startDate: (0,_utils__WEBPACK_IMPORTED_MODULE_6__.formatPaxDate)(startDate),
          endDate: (0,_utils__WEBPACK_IMPORTED_MODULE_6__.formatPaxDate)(endDate)
        };
      }
    },
    userActionService: {
      finishAndCloseSignUpFlow: async () => {
        if (onFinishAndCloseSignUpFlow) {
          await onFinishAndCloseSignUpFlow();
        }
        return {};
      }
    }
  };
  return services;
}

/***/ }),

/***/ "./js/modules/ads/pax/utils.js":
/*!*************************************!*\
  !*** ./js/modules/ads/pax/utils.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formatPaxDate: () => (/* binding */ formatPaxDate)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * PAX utility functions.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Returns formatted date object.
 *
 * @since 1.127.0
 *
 * @param {string} dateString Date in 'YYYY-MM-DD' format.
 * @return {Date} Date instance.
 */
function formatPaxDate(dateString) {
  const dateObject = (0,_js_util__WEBPACK_IMPORTED_MODULE_0__.stringToDate)(dateString);
  return {
    year: dateObject.getFullYear(),
    // PAX uses a 1-indexed month value (to match the month string value).
    //
    // Our `stringToDate()` function returns 0-indexed month values,
    // so we need to adjust the values for PAX.
    month: dateObject.getMonth() + 1,
    day: dateObject.getDate()
  };
}

/***/ }),

/***/ "./js/modules/ads/utils/validation.js":
/*!********************************************!*\
  !*** ./js/modules/ads/utils/validation.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidConversionID: () => (/* binding */ isValidConversionID),
/* harmony export */   isValidExtCustomerID: () => (/* binding */ isValidExtCustomerID),
/* harmony export */   isValidPaxConversionID: () => (/* binding */ isValidPaxConversionID)
/* harmony export */ });
/**
 * Validation utilities.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if the given conversion ID is valid.
 *
 * @since 1.32.0
 * @since 1.121.0 Migrated from analytics to analytics-4.
 * @since 1.124.0 Migrated from analytics-4 to ads.
 *
 * @param {*} value Ads Conversion Tracking ID to test.
 * @return {boolean} Whether or not the given ID is valid.
 */
function isValidConversionID(value) {
  return typeof value === 'string' && value !== '' && /^AW-[0-9]+$/.test(value);
}

/**
 * Checks if the given paxConversionID ID is valid.
 *
 * @since 1.126.0
 *
 * @param {*} value Ads Conversion Tracking ID to test.
 * @return {boolean} Whether or not the given ID is valid.
 */
function isValidPaxConversionID(value) {
  return typeof value === 'string' && value !== '' && /^AW-[0-9]+$/.test(value);
}

/**
 * Checks if the given extCustomerID ID is valid.
 *
 * @since 1.126.0
 *
 * @param {*} value PAX external customer ID to test.
 * @return {boolean} Whether or not the given ID is valid.
 */
function isValidExtCustomerID(value) {
  return typeof value === 'string';
}

/***/ }),

/***/ "./js/modules/analytics-4/constants.js":
/*!*********************************************!*\
  !*** ./js/modules/analytics-4/constants.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY: () => (/* binding */ ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY),
/* harmony export */   ACTIVATION_STEP_IN_PROGRESS: () => (/* binding */ ACTIVATION_STEP_IN_PROGRESS),
/* harmony export */   ACTIVATION_STEP_REMINDER: () => (/* binding */ ACTIVATION_STEP_REMINDER),
/* harmony export */   ACTIVATION_STEP_SETUP: () => (/* binding */ ACTIVATION_STEP_SETUP),
/* harmony export */   ACTIVATION_STEP_SUCCESS: () => (/* binding */ ACTIVATION_STEP_SUCCESS),
/* harmony export */   ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY: () => (/* binding */ ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY),
/* harmony export */   GA4_ACTIVATION_BANNER_STATE_KEY: () => (/* binding */ GA4_ACTIVATION_BANNER_STATE_KEY),
/* harmony export */   GA4_AUTO_SWITCH_DATE: () => (/* binding */ GA4_AUTO_SWITCH_DATE),
/* harmony export */   KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY: () => (/* binding */ KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY),
/* harmony export */   LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY: () => (/* binding */ LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY),
/* harmony export */   MODULE_SLUG_ANALYTICS_4: () => (/* binding */ MODULE_SLUG_ANALYTICS_4),
/* harmony export */   REPORT_ARGS_DATA_FILTERS_KEY: () => (/* binding */ REPORT_ARGS_DATA_FILTERS_KEY),
/* harmony export */   REPORT_ARGS_NAV_KEY: () => (/* binding */ REPORT_ARGS_NAV_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_DIMENSION_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_DIMENSION_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_METRIC_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_METRIC_KEY)
/* harmony export */ });
/**
 * GA4 module constants.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const ACTIVATION_STEP_REMINDER = 0;
const ACTIVATION_STEP_SETUP = 1;
const ACTIVATION_STEP_SUCCESS = 2;
const ACTIVATION_STEP_IN_PROGRESS = 3;
const ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY = 'activation-acknowledgement-tooltip-state';
const GA4_ACTIVATION_BANNER_STATE_KEY = 'ga4-activation-banner-state';
const ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY = 'enhanced-measurement-activation-banner-tooltip-state';
const LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY = 'enhanced-measurement-activation-banner-dismissed-item';
const REPORT_ARGS_SELECTED_METRIC_KEY = '_r.explorerCard..selmet';
const REPORT_ARGS_SELECTED_DIMENSION_KEY = '_r.explorerCard..seldim';
const REPORT_ARGS_DATA_FILTERS_KEY = '_r..dataFilters';
const REPORT_ARGS_NAV_KEY = '_r..nav';
const KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY = 'key-metrics-connect-ga4-cta-widget';

/**
 * Date that Site Kit will automatically switch to using GA4: September 25, 2023.
 *
 * With Site Kit's maximum date range being three months, once this period has passed since the UA cutoff date,
 * it will no longer be able to show any historical data for UA and will automatically switch to GA4.
 * For operational reasons, we automatically make the switch a few days before the three month cutoff point.
 *
 * @since 1.107.0
 * @see UA_CUTOFF_DATE.
 */
const GA4_AUTO_SWITCH_DATE = '2023-09-25';
const MODULE_SLUG_ANALYTICS_4 = 'analytics-4';

/***/ }),

/***/ "./js/modules/analytics-4/datastore/constants.js":
/*!*******************************************************!*\
  !*** ./js/modules/analytics-4/datastore/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCOUNT_CREATE: () => (/* binding */ ACCOUNT_CREATE),
/* harmony export */   AUDIENCE_FILTER_CLAUSE_TYPE_ENUM: () => (/* binding */ AUDIENCE_FILTER_CLAUSE_TYPE_ENUM),
/* harmony export */   AUDIENCE_FILTER_SCOPE_ENUM: () => (/* binding */ AUDIENCE_FILTER_SCOPE_ENUM),
/* harmony export */   AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX: () => (/* binding */ AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX),
/* harmony export */   AUDIENCE_SEGMENTATION_SETUP_FORM: () => (/* binding */ AUDIENCE_SEGMENTATION_SETUP_FORM),
/* harmony export */   AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE: () => (/* binding */ AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE),
/* harmony export */   AUDIENCE_TYPE_SORT_ORDER: () => (/* binding */ AUDIENCE_TYPE_SORT_ORDER),
/* harmony export */   CONVERSION_REPORTING_LEAD_EVENTS: () => (/* binding */ CONVERSION_REPORTING_LEAD_EVENTS),
/* harmony export */   CUSTOM_DIMENSION_DEFINITIONS: () => (/* binding */ CUSTOM_DIMENSION_DEFINITIONS),
/* harmony export */   DATE_RANGE_OFFSET: () => (/* binding */ DATE_RANGE_OFFSET),
/* harmony export */   EDIT_SCOPE: () => (/* binding */ EDIT_SCOPE),
/* harmony export */   ENHANCED_MEASUREMENT_ENABLED: () => (/* binding */ ENHANCED_MEASUREMENT_ENABLED),
/* harmony export */   ENHANCED_MEASUREMENT_FORM: () => (/* binding */ ENHANCED_MEASUREMENT_FORM),
/* harmony export */   ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER: () => (/* binding */ ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER),
/* harmony export */   ENUM_CONVERSION_EVENTS: () => (/* binding */ ENUM_CONVERSION_EVENTS),
/* harmony export */   FORM_ACCOUNT_CREATE: () => (/* binding */ FORM_ACCOUNT_CREATE),
/* harmony export */   FORM_CUSTOM_DIMENSIONS_CREATE: () => (/* binding */ FORM_CUSTOM_DIMENSIONS_CREATE),
/* harmony export */   FORM_SETUP: () => (/* binding */ FORM_SETUP),
/* harmony export */   GTM_SCOPE: () => (/* binding */ GTM_SCOPE),
/* harmony export */   MAX_WEBDATASTREAMS_PER_BATCH: () => (/* binding */ MAX_WEBDATASTREAMS_PER_BATCH),
/* harmony export */   MODULES_ANALYTICS_4: () => (/* binding */ MODULES_ANALYTICS_4),
/* harmony export */   PROPERTY_CREATE: () => (/* binding */ PROPERTY_CREATE),
/* harmony export */   PROVISIONING_SCOPE: () => (/* binding */ PROVISIONING_SCOPE),
/* harmony export */   RESOURCE_TYPES: () => (/* binding */ RESOURCE_TYPES),
/* harmony export */   RESOURCE_TYPE_AUDIENCE: () => (/* binding */ RESOURCE_TYPE_AUDIENCE),
/* harmony export */   RESOURCE_TYPE_CUSTOM_DIMENSION: () => (/* binding */ RESOURCE_TYPE_CUSTOM_DIMENSION),
/* harmony export */   RESOURCE_TYPE_PROPERTY: () => (/* binding */ RESOURCE_TYPE_PROPERTY),
/* harmony export */   SITE_KIT_AUDIENCE_DEFINITIONS: () => (/* binding */ SITE_KIT_AUDIENCE_DEFINITIONS),
/* harmony export */   UI_ACTIVE_ROW_INDEX: () => (/* binding */ UI_ACTIVE_ROW_INDEX),
/* harmony export */   UI_ALL_TRAFFIC_LOADED: () => (/* binding */ UI_ALL_TRAFFIC_LOADED),
/* harmony export */   UI_DIMENSION_COLOR: () => (/* binding */ UI_DIMENSION_COLOR),
/* harmony export */   UI_DIMENSION_NAME: () => (/* binding */ UI_DIMENSION_NAME),
/* harmony export */   UI_DIMENSION_VALUE: () => (/* binding */ UI_DIMENSION_VALUE),
/* harmony export */   WEBDATASTREAM_CREATE: () => (/* binding */ WEBDATASTREAM_CREATE)
/* harmony export */ });
/**
 * `modules/analytics-4` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_ANALYTICS_4 = 'modules/analytics-4';

// A special Account ID value used for the "Set up a new account" option.
const ACCOUNT_CREATE = 'account_create';

// A special Property ID value used for the "Set up a new property" option.
const PROPERTY_CREATE = 'property_create';
const WEBDATASTREAM_CREATE = 'webdatastream_create';
const FORM_SETUP = 'analyticsSetup';
const MAX_WEBDATASTREAMS_PER_BATCH = 10;

// Date range offset days for Analytics 4 report requests.
const DATE_RANGE_OFFSET = 1;
const GTM_SCOPE = 'https://www.googleapis.com/auth/tagmanager.readonly';
const ENHANCED_MEASUREMENT_FORM = 'enhanced-measurement-form';
const ENHANCED_MEASUREMENT_ENABLED = 'enhanced-measurement-enabled';
const ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER = 'enhanced-measurement-should-dismiss-activation-banner';

// Form ID for the account creation form.
const FORM_ACCOUNT_CREATE = 'analyticsAccountCreate';
const FORM_CUSTOM_DIMENSIONS_CREATE = 'analyticsCustomDimensionsCreate';

// OAuth scope required for provisioning a Google Analytics account.
const PROVISIONING_SCOPE = 'https://www.googleapis.com/auth/analytics.provision';
const EDIT_SCOPE = 'https://www.googleapis.com/auth/analytics.edit';

// Dashboard widget constants.
const UI_DIMENSION_NAME = 'dashboardAllTrafficWidgetDimensionName';
const UI_DIMENSION_COLOR = 'dashboardAllTrafficWidgetDimensionColor';
const UI_DIMENSION_VALUE = 'dashboardAllTrafficWidgetDimensionValue';
const UI_ACTIVE_ROW_INDEX = 'dashboardAllTrafficWidgetActiveRowIndex';
const UI_ALL_TRAFFIC_LOADED = 'dashboardAllTrafficWidgetLoaded';

// Note: names and descriptions are not translated as these are not surfaced in Site Kit
// and are also subject to hard limits on the length which would be unpredictable if translated.
// See https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1beta/properties.customDimensions#CustomDimension
const CUSTOM_DIMENSION_DEFINITIONS = {
  googlesitekit_post_date: {
    parameterName: 'googlesitekit_post_date',
    displayName: 'WordPress Post Date',
    description: 'Created by Site Kit: Date when a post was published',
    scope: 'EVENT'
  },
  googlesitekit_post_author: {
    parameterName: 'googlesitekit_post_author',
    displayName: 'WordPress Post Author',
    description: 'Created by Site Kit: WordPress name of the post author',
    scope: 'EVENT'
  },
  googlesitekit_post_categories: {
    parameterName: 'googlesitekit_post_categories',
    displayName: 'WordPress Post Categories',
    description: 'Created by Site Kit: Names of categories assigned to a post',
    scope: 'EVENT'
  },
  googlesitekit_post_type: {
    parameterName: 'googlesitekit_post_type',
    displayName: 'WordPress Post Type',
    description: 'Created by Site Kit: Content type of a post',
    scope: 'EVENT'
  }
};
const ENUM_CONVERSION_EVENTS = {
  ADD_TO_CART: 'add_to_cart',
  PURCHASE: 'purchase',
  SUBMIT_LEAD_FORM: 'submit_lead_form',
  GENERATE_LEAD: 'generate_lead',
  CONTACT: 'contact'
};
const CONVERSION_REPORTING_LEAD_EVENTS = [ENUM_CONVERSION_EVENTS.CONTACT, ENUM_CONVERSION_EVENTS.GENERATE_LEAD, ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM];

// Audience enums.
const AUDIENCE_FILTER_CLAUSE_TYPE_ENUM = {
  AUDIENCE_CLAUSE_TYPE_UNSPECIFIED: 'AUDIENCE_CLAUSE_TYPE_UNSPECIFIED',
  INCLUDE: 'INCLUDE',
  EXCLUDE: 'EXCLUDE'
};
const AUDIENCE_FILTER_SCOPE_ENUM = {
  AUDIENCE_FILTER_SCOPE_UNSPECIFIED: 'AUDIENCE_FILTER_SCOPE_UNSPECIFIED',
  AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT: 'AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT',
  AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION: 'AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION',
  AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS'
};
const SITE_KIT_AUDIENCE_DEFINITIONS = {
  'new-visitors': {
    description: 'People who visited the site for the first time',
    displayName: 'New visitors',
    membershipDurationDays: -1,
    // The longest duration, 540 days.
    filterClauses: [{
      clauseType: 'INCLUDE',
      simpleFilter: {
        scope: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS',
        filterExpression: {
          andGroup: {
            filterExpressions: [{
              orGroup: {
                filterExpressions: [{
                  dimensionOrMetricFilter: {
                    fieldName: 'newVsReturning',
                    stringFilter: {
                      matchType: 'EXACT',
                      value: 'new'
                    }
                  }
                }]
              }
            }, {
              orGroup: {
                filterExpressions: [{
                  notExpression: {
                    dimensionOrMetricFilter: {
                      fieldName: 'groupId',
                      stringFilter: {
                        matchType: 'EXACT',
                        value: 'created_by_googlesitekit:new_visitors'
                      }
                    }
                  }
                }]
              }
            }]
          }
        }
      }
    }]
  },
  'returning-visitors': {
    description: 'People who have visited your site at least once before',
    displayName: 'Returning visitors',
    membershipDurationDays: -1,
    // The longest duration, 540 days.
    filterClauses: [{
      clauseType: 'INCLUDE',
      simpleFilter: {
        scope: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS',
        filterExpression: {
          andGroup: {
            filterExpressions: [{
              orGroup: {
                filterExpressions: [{
                  dimensionOrMetricFilter: {
                    fieldName: 'newVsReturning',
                    stringFilter: {
                      matchType: 'EXACT',
                      value: 'returning'
                    }
                  }
                }]
              }
            }, {
              orGroup: {
                filterExpressions: [{
                  notExpression: {
                    dimensionOrMetricFilter: {
                      fieldName: 'groupId',
                      stringFilter: {
                        matchType: 'EXACT',
                        value: 'created_by_googlesitekit:returning_visitors'
                      }
                    }
                  }
                }]
              }
            }]
          }
        }
      }
    }]
  }
};
const AUDIENCE_SEGMENTATION_SETUP_FORM = 'audiencePermissionsSetup';
const AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE = 'audienceTileCustomDimensionCreate';
const AUDIENCE_TYPE_SORT_ORDER = {
  USER_AUDIENCE: 0,
  SITE_KIT_AUDIENCE: 1,
  DEFAULT_AUDIENCE: 2
};
const AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX = 'audience-selection-panel-expirable-new-badge-';
const RESOURCE_TYPE_AUDIENCE = 'audience';
const RESOURCE_TYPE_CUSTOM_DIMENSION = 'customDimension';
const RESOURCE_TYPE_PROPERTY = 'property';
const RESOURCE_TYPES = [RESOURCE_TYPE_AUDIENCE, RESOURCE_TYPE_CUSTOM_DIMENSION, RESOURCE_TYPE_PROPERTY];

/***/ }),

/***/ "./js/modules/search-console/constants.js":
/*!************************************************!*\
  !*** ./js/modules/search-console/constants.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_SEARCH_CONSOLE: () => (/* binding */ MODULE_SLUG_SEARCH_CONSOLE)
/* harmony export */ });
/**
 * Search Console module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_SEARCH_CONSOLE = 'search-console';

/***/ }),

/***/ "./js/util/chart.js":
/*!**************************!*\
  !*** ./js/util/chart.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* binding */ calculateDifferenceBetweenChartValues),
/* harmony export */   getChartDifferenceArrow: () => (/* binding */ getChartDifferenceArrow),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Utility functions for charts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Gets the up/down SVG arrow for Google Chart tooltips.
 *
 * @since 1.30.0
 *
 * @param {number}  difference            The difference which can be positive or negative.
 * @param {string}  [options]             Options to be passed to the ChangeArrow component.
 * @param {boolean} [options.invertColor] Whether we need to reverse the +/- colors of the arrow.
 * @return {string} SVG for the +/- difference.
 */

function getChartDifferenceArrow(difference, options = {}) {
  if (Number.isNaN(Number(difference))) {
    return '';
  }
  const {
    invertColor = false
  } = options;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["default"])(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__["default"], {
    direction: difference > 0 ? 'up' : 'down',
    invertColor: invertColor
  }));
}

/**
 * Checks if there is a single row of data or one row is contributing 100% of the total for a given dimension.
 *
 * @since 1.31.0
 *
 * @param {Array.<Object>} report An array of report data objects.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  if (report?.[0]?.data?.rows?.length === 1 || report?.[0]?.data?.rows?.[0]?.metrics?.[0]?.values?.[0] === report?.[0]?.data?.totals?.[0]?.values?.[0]) {
    return true;
  }
  return false;
}

/**
 * Calculates difference between two chart values.
 *
 * @since 1.48.0
 *
 * @param {number} currentValue  Current chart value.
 * @param {number} previousValue Previous chart value.
 * @return {number} The difference.
 */
function calculateDifferenceBetweenChartValues(currentValue, previousValue) {
  if (currentValue > 0 && previousValue > 0) {
    return currentValue / previousValue - 1;
  }
  if (currentValue > 0) {
    return 1;
  }
  if (previousValue > 0) {
    return -1;
  }
  return 0;
}

/***/ }),

/***/ "./js/util/convert-time.js":
/*!*********************************!*\
  !*** ./js/util/convert-time.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* binding */ convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* binding */ convertSecondsToArray)
/* harmony export */ });
/**
 * Time related utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts seconds into an array with the following values [HH, MM, SS, MS] as described below.
 * HH: hours.
 * MM: minutes.
 * SS: seconds.
 * MS: milliseconds.
 *
 * For example, passing 196.385 returns [ 0, 3, 16, 385 ].
 *
 * @since 1.27.0
 *
 * @param {number} seconds The number of seconds.
 * @return {Array} Array containing the hours, minutes, seconds and milliseconds.
 */
function convertSecondsToArray(seconds) {
  seconds = parseFloat(seconds);
  if (isNaN(seconds) || 0 === seconds) {
    return [0, 0, 0, 0];
  }
  return [Math.floor(seconds / 60 / 60), Math.floor(seconds / 60 % 60), Math.floor(seconds % 60), Math.floor(seconds * 1000) - Math.floor(seconds) * 1000];
}

/**
 * Converts Date time string into UNIX timestamp in milliseconds.
 *
 * For example, passing "2014-10-02T15:01:23Z" returns 1412262083000.
 *
 * @since 1.116.0
 *
 * @param {string} dateStringValue The date time string.
 * @return {number} UNIX timestamp in milliseconds.
 */
function convertDateStringToUNIXTimestamp(dateStringValue) {
  const unixTimestamp = dateStringValue && !Number.isInteger(dateStringValue) ?
  // Valid use of `new Date()` with an argument, because this should only
  // be passed full time strings, not `YYYY-MM-DD` style dates.
  //
  // See: https://github.com/google/site-kit-wp/pull/9459#discussion_r1790660073
  // eslint-disable-next-line sitekit/no-direct-date
  new Date(dateStringValue).getTime() : dateStringValue;
  if (isNaN(unixTimestamp) || !unixTimestamp) {
    return 0;
  }
  return unixTimestamp;
}

/***/ }),

/***/ "./js/util/create-incremental-array-by-size.js":
/*!*****************************************************!*\
  !*** ./js/util/create-incremental-array-by-size.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createIncrementalArrayBySize: () => (/* binding */ createIncrementalArrayBySize)
/* harmony export */ });
/**
 * Create Incremental Array by Size utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Creates an array of length equal to size with incremental values starting at 0.
 *
 * @since 1.28.0
 *
 * @param {number} size Array length.
 * @return {number[]} Array of incremental numbers.
 * @example createIncrementalArrayBySize(3); // [0, 1, 2]
 */
function createIncrementalArrayBySize(size) {
  return new Array(size !== null && size !== void 0 ? size : 0).fill().map((_, i) => i);
}

/***/ }),

/***/ "./js/util/dates.js":
/*!**************************!*\
  !*** ./js/util/dates.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* binding */ DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* binding */ HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* binding */ INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* binding */ INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* binding */ INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* binding */ MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* binding */ MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* binding */ WEEK_IN_SECONDS),
/* harmony export */   dateSub: () => (/* binding */ dateSub),
/* harmony export */   getAvailableDateRanges: () => (/* binding */ getAvailableDateRanges),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* binding */ getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* binding */ getDateString),
/* harmony export */   getPreviousDate: () => (/* binding */ getPreviousDate),
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidDateString: () => (/* binding */ isValidDateString),
/* harmony export */   stringToDate: () => (/* binding */ stringToDate)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

const INVALID_DATE_INSTANCE_ERROR = 'Date param must construct to a valid date instance or be a valid date instance itself.';
const INVALID_DATE_STRING_ERROR = 'Invalid dateString parameter, it must be a string.';
const INVALID_DATE_RANGE_ERROR = 'Invalid date range, it must be a string with the format "last-x-days".';
const MINUTE_IN_SECONDS = 60;
const HOUR_IN_SECONDS = 60 * MINUTE_IN_SECONDS;
const DAY_IN_SECONDS = 24 * HOUR_IN_SECONDS;
const WEEK_IN_SECONDS = 7 * DAY_IN_SECONDS;
const MONTH_IN_SECONDS = 30 * DAY_IN_SECONDS;

/**
 * Gets the hash of available date ranges.
 *
 * @since 1.12.0
 *
 * @return {Object} The object hash where every key is a date range slug, and the value is an object with the date range slug and its translation.
 */
function getAvailableDateRanges() {
  function label(days) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: number of days */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._n)('Last %s day', 'Last %s days', days, 'google-site-kit'), days);
  }
  return {
    'last-7-days': {
      slug: 'last-7-days',
      label: label(7),
      days: 7
    },
    'last-14-days': {
      slug: 'last-14-days',
      label: label(14),
      days: 14
    },
    'last-28-days': {
      slug: 'last-28-days',
      label: label(28),
      days: 28
    },
    'last-90-days': {
      slug: 'last-90-days',
      label: label(90),
      days: 90
    }
  };
}

/**
 * Gets the current dateRange day count.
 *
 * @since 1.19.0
 * @since 1.26.0 `dateRange` is now a required argument.
 *
 * @param {string} dateRange The date range slug.
 * @return {number} The number of days in the range.
 */
function getCurrentDateRangeDayCount(dateRange) {
  const daysMatch = dateRange.match(/last-(\d+)-days/);
  if (daysMatch && daysMatch[1]) {
    return parseInt(daysMatch[1], 10);
  }
  throw new Error('Unrecognized date range slug.');
}

/**
 * Asserts whether a given date string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateString Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given date string is valid.
 */
function isValidDateString(dateString = '') {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isString)(dateString)) {
    return false;
  }
  const dateArray = dateString.split('-');
  if (dateArray.length !== 3) {
    return false;
  }

  // Valid use of `new Date()`, constructing a new date from the string.
  // eslint-disable-next-line sitekit/no-direct-date
  const date = new Date(dateString);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date);
}

/**
 * Parses the given Date instance and returns a date string (YYYY-MM-DD).
 *
 * @since 1.18.0
 * @since 1.85.0 Updated the function signature to only accept a Date argument.
 *
 * @param {Date} date Date to parse into a string.
 * @return {string}                 The parsed date string (YYYY-MM-DD).
 */
function getDateString(date) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date), INVALID_DATE_INSTANCE_ERROR);
  const month = `${date.getMonth() + 1}`;
  const day = `${date.getDate()}`;
  const year = date.getFullYear();
  return [year, month.length < 2 ? `0${month}` : month, day.length < 2 ? `0${day}` : day].join('-');
}

/**
 * Converts a valid date string to a Date instance.
 *
 * @since 1.38.0
 *
 * @param {string} dateString The date string to parse.
 * @return {Date} Date instance.
 */
function stringToDate(dateString) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(dateString), INVALID_DATE_STRING_ERROR);

  /**
   * Split date into explicit parts rather than pass directly into date constructor
   * to avoid timezone issues caused by parsing as UTC. Ensures date is accurate for
   * the user's local time, otherwise has a chance to return a different day than was
   * passed in depending on timezone.
   */
  const [year, month, day] = dateString.split('-');
  return new Date(year, month - 1, day);
}

/**
 * Parses the given date and returns the previous date (daysBefore).
 *
 * @since 1.18.0
 *
 * @param {string} relativeDate Date string (YYYY-MM-DD) to subtract days from.
 * @param {number} daysBefore   Number of days to subtract from relativeDate.
 * @return {string}             The date string (YYYY-MM-DD) for the previous date.
 */
function getPreviousDate(relativeDate, daysBefore) {
  return getDateString(dateSub(relativeDate, daysBefore * DAY_IN_SECONDS));
}

/**
 * Asserts whether a given dateRange string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateRange Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given dateRange string is valid.
 */
function isValidDateRange(dateRange) {
  const parts = dateRange.split('-');
  return parts.length === 3 && parts[0] === 'last' && !Number.isNaN(parts[1]) && !Number.isNaN(parseFloat(parts[1])) && parts[2] === 'days';
}

/**
 * Subtracts duration from the prodived date and returns it.
 *
 * @since 1.132.0
 *
 * @param {Date|string} relativeDate Date string (YYYY-MM-DD) or date object to subtract duration from.
 * @param {number}      duration     The duration in seconds to subtract from relativeDate.
 * @return {Date} Resulting date.
 */
function dateSub(relativeDate, duration) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(relativeDate) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(relativeDate) && !isNaN(relativeDate), INVALID_DATE_STRING_ERROR);
  const timestamp = isValidDateString(relativeDate) ? Date.parse(relativeDate) : relativeDate.getTime();

  // Valid use of `new Date()` using calculations.
  // eslint-disable-next-line sitekit/no-direct-date
  return new Date(timestamp - duration * 1000);
}

/***/ }),

/***/ "./js/util/errors.js":
/*!***************************!*\
  !*** ./js/util/errors.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_CODE_MISSING_REQUIRED_SCOPE: () => (/* binding */ ERROR_CODE_MISSING_REQUIRED_SCOPE),
/* harmony export */   ERROR_INTERNAL_SERVER_ERROR: () => (/* binding */ ERROR_INTERNAL_SERVER_ERROR),
/* harmony export */   ERROR_INVALID_JSON: () => (/* binding */ ERROR_INVALID_JSON),
/* harmony export */   ERROR_REASON_BAD_REQUEST: () => (/* binding */ ERROR_REASON_BAD_REQUEST),
/* harmony export */   ERROR_REASON_FORBIDDEN: () => (/* binding */ ERROR_REASON_FORBIDDEN),
/* harmony export */   ERROR_REASON_INSUFFICIENT_PERMISSIONS: () => (/* binding */ ERROR_REASON_INSUFFICIENT_PERMISSIONS),
/* harmony export */   getReportErrorMessage: () => (/* binding */ getReportErrorMessage),
/* harmony export */   isAuthError: () => (/* binding */ isAuthError),
/* harmony export */   isErrorRetryable: () => (/* binding */ isErrorRetryable),
/* harmony export */   isInsufficientPermissionsError: () => (/* binding */ isInsufficientPermissionsError),
/* harmony export */   isPermissionScopeError: () => (/* binding */ isPermissionScopeError),
/* harmony export */   isWPError: () => (/* binding */ isWPError)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Error Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


// Error codes and reasons.
const ERROR_CODE_MISSING_REQUIRED_SCOPE = 'missing_required_scopes'; // When scopes are missing.
const ERROR_REASON_INSUFFICIENT_PERMISSIONS = 'insufficientPermissions';
const ERROR_REASON_FORBIDDEN = 'forbidden';
const ERROR_INTERNAL_SERVER_ERROR = 'internal_server_error';
const ERROR_INVALID_JSON = 'invalid_json';
const ERROR_REASON_BAD_REQUEST = 'bad_request';

/**
 * Checks if the provided object is an instance of WP_Error class.
 *
 * @since 1.13.0
 *
 * @param {Object} obj The object to check.
 * @return {boolean} TRUE if the object has "code", "data" and "message" properties, otherwise FALSE.
 */
function isWPError(obj) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(obj) && obj.hasOwnProperty('code') && (typeof obj.code === 'string' || typeof obj.code === 'number') && obj.hasOwnProperty('message') && typeof obj.message === 'string' && obj.hasOwnProperty('data'); // We don't check "obj.data" type because it can be anything.
}

/**
 * Checks if the given error is a permission scope error.
 *
 * @since 1.9.0
 * @private
 *
 * @param {Object} error Input to test as a possible permission scope error.
 * @return {boolean} TRUE if permission scope error, otherwise FALSE.
 */
function isPermissionScopeError(error) {
  return error?.code === ERROR_CODE_MISSING_REQUIRED_SCOPE;
}

/**
 * Checks if the given error has insufficient permissions reason.
 *
 * @since 1.16.0
 * @since 1.70.0 Add support for "forbidden" reason.
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's insufficient permissions error, otherwise FALSE.
 */
function isInsufficientPermissionsError(error) {
  return [ERROR_REASON_INSUFFICIENT_PERMISSIONS, ERROR_REASON_FORBIDDEN].includes(error?.data?.reason);
}

/**
 * Checks if the given error is an auth error.
 *
 * @since 1.78.0
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's an auth error, otherwise FALSE.
 */
function isAuthError(error) {
  return !!error?.data?.reconnectURL;
}

/**
 * Checks if the given error can be retried.
 *
 * @since 1.86.0
 *
 * @param {Object} error          The error object to check.
 * @param {Object} [selectorData] The error's associated selector data object.
 * @return {boolean} TRUE if the error is retryable, otherwise FALSE.
 */
function isErrorRetryable(error, selectorData) {
  return !!selectorData?.storeName && !isInsufficientPermissionsError(error) && !isPermissionScopeError(error) && !isAuthError(error);
}

/**
 * Sets the error message for specific error codes.
 *
 * @since 1.92.0
 *
 * @param {Object} error The error object to check.
 * @return {Object} The updated error object.
 */
function getReportErrorMessage(error) {
  if (error?.code === ERROR_INTERNAL_SERVER_ERROR) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('There was a critical error on this website while fetching data', 'google-site-kit');
  } else if (error?.code === ERROR_INVALID_JSON) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The server provided an invalid response', 'google-site-kit');
  }
  return error?.message;
}

/***/ }),

/***/ "./js/util/i18n.js":
/*!*************************!*\
  !*** ./js/util/i18n.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDurationFormat: () => (/* binding */ createDurationFormat),
/* harmony export */   expandNumFmtOptions: () => (/* binding */ expandNumFmtOptions),
/* harmony export */   getLocale: () => (/* binding */ getLocale),
/* harmony export */   listFormat: () => (/* binding */ listFormat),
/* harmony export */   numFmt: () => (/* binding */ numFmt),
/* harmony export */   numberFormat: () => (/* binding */ numberFormat),
/* harmony export */   prepareForReadableLargeNumber: () => (/* binding */ prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* binding */ readableLargeNumber)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Internationalization Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed.
 *
 * For example, passing 65 returns '1m 5s'.
 *
 * @since 1.0.0
 * @since 1.28.0 Refactored and renamed to improve localization.
 * @private
 *
 * @param {number}                     durationInSeconds The number of seconds.
 * @param {(Intl.NumberFormatOptions)} [options]         Optional formatting options.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationFormat(durationInSeconds, options = {}) {
  const {
    formatUnit,
    formatDecimal
  } = createDurationFormat(durationInSeconds, options);
  try {
    // Some browsers, e.g. Safari, throw a RangeError when options.style is
    // not one of decimal, percent, or currency.
    return formatUnit();
  } catch {
    // Fallback to XXh YYm ZZs using localized decimals with hardcoded units.
    return formatDecimal();
  }
}

/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed
 * in ISO format - HH:mm:ss.
 *
 * If the duration is less than an hour, the HH part of the string
 * is truncated.
 * For example, passing 65 returns '01:05'.
 * Passing 5400 returns '01:30:00'.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationISOFormat(durationInSeconds) {
  let {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  seconds = ('0' + seconds).slice(-2);
  minutes = ('0' + minutes).slice(-2);
  hours = ('0' + hours).slice(-2);
  return hours === '00' ? `${minutes}:${seconds}` : `${hours}:${minutes}:${seconds}`;
}

/**
 * Parses the duration in seconds into hours, minutes and seconds.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {Object} Number of hours, minutes and seconds equivalent
 * to the given duration in seconds.
 */
function parseDuration(durationInSeconds) {
  durationInSeconds = parseInt(durationInSeconds, 10);
  if (Number.isNaN(durationInSeconds)) {
    durationInSeconds = 0;
  }
  const hours = Math.floor(durationInSeconds / 60 / 60);
  const minutes = Math.floor(durationInSeconds / 60 % 60);
  const seconds = Math.floor(durationInSeconds % 60);
  return {
    hours,
    minutes,
    seconds
  };
}

/**
 * Creates duration formatting utilities.
 *
 * Not intended to be used directly.
 * Use `numFmt( number, { style: 'duration' } )` instead.
 *
 * @since 1.29.0
 * @private
 *
 * @param {number} durationInSeconds Duration to format.
 * @param {Object} [options]         Formatting options.
 * @return {Object} Formatting functions.
 */
function createDurationFormat(durationInSeconds, options = {}) {
  const {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  return {
    hours,
    minutes,
    seconds,
    formatUnit() {
      const {
        unitDisplay = 'short',
        ...restOptions
      } = options;
      const commonOptions = {
        unitDisplay,
        ...restOptions,
        style: 'unit'
      };
      if (durationInSeconds === 0) {
        return numberFormat(seconds, {
          ...commonOptions,
          unit: 'second'
        });
      }
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? numberFormat(seconds, {
        ...commonOptions,
        unit: 'second'
      }) : '', minutes ? numberFormat(minutes, {
        ...commonOptions,
        unit: 'minute'
      }) : '', hours ? numberFormat(hours, {
        ...commonOptions,
        unit: 'hour'
      }) : '').trim();
    },
    /**
     * Formats the duration using integers and translatable strings.
     * This is only used as a fallback when the above `formatUnit` fails.
     *
     * @since 1.29.0
     *
     * @return {string} Formatted duration.
     */
    formatDecimal() {
      const formattedSeconds = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of seconds with "s" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%ds', 'google-site-kit'), seconds);
      if (durationInSeconds === 0) {
        return formattedSeconds;
      }
      const formattedMinutes = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of minutes with "m" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dm', 'google-site-kit'), minutes);
      const formattedHours = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of hours with "h" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dh', 'google-site-kit'), hours);
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? formattedSeconds : '', minutes ? formattedMinutes : '', hours ? formattedHours : '').trim();
    }
  };
}

/**
 * Prepares a number to be used in readableLargeNumber.
 *
 * @since 1.7.0
 *
 * @param {number} number The large number to prepare.
 * @return {number} The prepared number.
 */
function prepareForReadableLargeNumber(number) {
  if (1000000 <= number) {
    return Math.round(number / 100000) / 10;
  }
  if (10000 <= number) {
    return Math.round(number / 1000);
  }
  if (1000 <= number) {
    return Math.round(number / 100) / 10;
  }
  return number;
}

/**
 * Formats a large number for shortened display.
 *
 * @since 1.0.0
 *
 * @param {number} number The large number to format.
 * @return {string} The formatted number.
 */
function readableLargeNumber(number) {
  const withSingleDecimal = {
    minimumFractionDigits: 1,
    maximumFractionDigits: 1
  };

  // Numbers over 1,000,000 round normally and display a single decimal unless the decimal is 0.
  if (1000000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in millions.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sM', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }

  // Numbers between 10,000 and 1,000,000 round normally and have no decimals
  if (10000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number)));
  }

  // Numbers between 1,000 and 10,000 round normally and display a single decimal unless the decimal is 0.
  if (1000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }
  return numberFormat(number, {
    signDisplay: 'never',
    maximumFractionDigits: 1
  });
}

/**
 * Parses formatting options and returns an object with options for selected formatting.
 *
 * @since 1.103.0
 *
 * @param {(Intl.NumberFormatOptions|string)} options Formatting options or unit shorthand. Possible shorthand values are '%', 's', or a currency code.
 * @return {Object} Formatting options.
 */
function expandNumFmtOptions(options) {
  let formatOptions = {};

  // Expand shorthand values for units.
  if ('%' === options) {
    formatOptions = {
      style: 'percent',
      maximumFractionDigits: 2
    };
  } else if ('s' === options) {
    formatOptions = {
      style: 'duration',
      unitDisplay: 'narrow'
    };
  } else if (!!options && typeof options === 'string') {
    formatOptions = {
      style: 'currency',
      currency: options
    };
  } else if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(options)) {
    formatOptions = {
      ...options
    };
  }
  return formatOptions;
}

/**
 * Formats a number with unit using the JS Internationalization Number Format API.
 *
 * In addition to the supported 'style' values of the lower-level `numberFormat` function, this function
 * supports two additional 'style' values 'metric' and 'duration' (expects a number in seconds).
 *
 * Another differentiation in behavior is that by default the function will use 'metric' formatting instead
 * of 'decimal' formatting.
 *
 * @since 1.24.0
 *
 * @param {number|string}                     number    The number to format.
 * @param {(Intl.NumberFormatOptions|string)} [options] Formatting options or unit shorthand.
 *                                                      Possible shorthand values are '%', 's',
 *                                                      or a currency code.
 * @return {string} The formatted number.
 */
function numFmt(number, options = {}) {
  // Cast parsable values to numeric types.
  number = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number) ? number : Number(number);
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number)) {
    // eslint-disable-next-line no-console
    console.warn('Invalid number', number, typeof number);
    number = 0;
  }
  const formatOptions = expandNumFmtOptions(options);
  const {
    style = 'metric'
  } = formatOptions; // Note: `metric` is our custom, default style.

  if ('metric' === style) {
    return readableLargeNumber(number);
  }
  if ('duration' === style) {
    return durationFormat(number, formatOptions);
  }
  if ('durationISO' === style) {
    return durationISOFormat(number);
  }
  return numberFormat(number, formatOptions);
}

// Warn once for a given message.
const warnOnce = memize__WEBPACK_IMPORTED_MODULE_1___default()(console.warn); // eslint-disable-line no-console

/**
 * Formats a number using the JS Internationalization Number Format API.
 *
 * @since 1.8.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/NumberFormat|`options` parameter} For all available formatting options.
 *
 * @param {number}                   number           The number to format.
 * @param {Intl.NumberFormatOptions} [options]        Formatting options.
 * @param {string}                   [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @return {string} The formatted number.
 */
function numberFormat(number, options = {}) {
  const {
    locale = getLocale(),
    ...formatOptions
  } = options;
  try {
    /**
     * Per https://github.com/google/site-kit-wp/issues/3255 there have been issues with some versions of Safari
     * on some operating systems throwing issues with some parameters in the formatOptions.
     *
     * If an error is thrown, we remove some troublesome params from the formatOptions object and fallback to no formatting.
     *
     * This allows us to degrade somewhat gracefully without breaking the dashboard for users of unaffected browsers.
     */
    return new Intl.NumberFormat(locale, formatOptions).format(number);
  } catch (error) {
    warnOnce(`Site Kit numberFormat error: Intl.NumberFormat( ${JSON.stringify(locale)}, ${JSON.stringify(formatOptions)} ).format( ${typeof number} )`, error.message);
  }

  // Remove these key/values from formatOptions.
  const unstableFormatOptionValues = {
    currencyDisplay: 'narrow',
    currencySign: 'accounting',
    style: 'unit'
  };

  // Remove these keys from formatOptions irrespective of value.
  const unstableFormatOptions = ['signDisplay', 'compactDisplay'];
  const reducedFormatOptions = {};
  for (const [key, value] of Object.entries(formatOptions)) {
    if (unstableFormatOptionValues[key] && value === unstableFormatOptionValues[key]) {
      continue;
    }
    if (unstableFormatOptions.includes(key)) {
      continue;
    }
    reducedFormatOptions[key] = value;
  }
  try {
    return new Intl.NumberFormat(locale, reducedFormatOptions).format(number);
  } catch {
    return new Intl.NumberFormat(locale).format(number);
  }
}

/**
 * Flattens an array of strings into a string using the JS Internationalization List Format API.
 *
 * @since 1.23.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat|`options` parameter} For all available options.
 *
 * @param {Array}  list             The list to flatten.
 * @param {Object} [options]        Formatting options.
 * @param {string} [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @param {string} [options.style]  Length of the formatted message. Defaults to long.
 * @param {string} [options.type]   Type of list. Defaults to 'conjunction' (A, B, and C).
 *                                  Also available 'disjunction' (A, B, or C)
 *                                  Also available 'unit' (5 pounds, 12 ounces)
 * @return {string} The flattened list.
 */
function listFormat(list, options = {}) {
  const {
    locale = getLocale(),
    style = 'long',
    type = 'conjunction'
  } = options;

  // Not all browsers support Intl.Listformat per
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat#Browser_compatibility
  // We've seen that the built versions don't polyfill for the unsupported browsers (iOS/safari) so we provide a fallback.
  if (Intl.ListFormat) {
    const formatter = new Intl.ListFormat(locale, {
      style,
      type
    });
    return formatter.format(list);
  }

  /* translators: used between list items, there is a space after the comma. */
  const listSeparator = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(', ', 'google-site-kit');
  return list.join(listSeparator);
}

/**
 * Gets the current locale for use with browser APIs.
 *
 * @since 1.8.0
 *
 * @param {Object} _global The global window object.
 * @return {string} Current Site Kit locale if set, otherwise the current language set by the browser.
 *                  E.g. `en-US` or `de-DE`
 */
function getLocale(_global = __webpack_require__.g) {
  const siteKitLocale = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(_global, ['_googlesitekitLegacyData', 'locale']);
  if (siteKitLocale) {
    const matches = siteKitLocale.match(/^(\w{2})?(_)?(\w{2})/);
    if (matches && matches[0]) {
      return matches[0].replace(/_/g, '-');
    }
  }
  return _global.navigator.language;
}

/***/ }),

/***/ "./js/util/index.js":
/*!**************************!*\
  !*** ./js/util/index.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.WEEK_IN_SECONDS),
/* harmony export */   calculateChange: () => (/* binding */ calculateChange),
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.calculateDifferenceBetweenChartValues),
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertSecondsToArray),
/* harmony export */   createDurationFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.createDurationFormat),
/* harmony export */   dateSub: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.dateSub),
/* harmony export */   decodeHTMLEntity: () => (/* binding */ decodeHTMLEntity),
/* harmony export */   expandNumFmtOptions: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.expandNumFmtOptions),
/* harmony export */   getAvailableDateRanges: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getAvailableDateRanges),
/* harmony export */   getChartDifferenceArrow: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.getChartDifferenceArrow),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getDateString),
/* harmony export */   getFullURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getFullURL),
/* harmony export */   getLocale: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.getLocale),
/* harmony export */   getPreviousDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getPreviousDate),
/* harmony export */   getStorage: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.getStorage),
/* harmony export */   getURLPath: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getURLPath),
/* harmony export */   isHashOnly: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.isHashOnly),
/* harmony export */   isNumeric: () => (/* reexport safe */ _isnumeric__WEBPACK_IMPORTED_MODULE_12__.isNumeric),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.isSingleSlice),
/* harmony export */   isValidDateRange: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateRange),
/* harmony export */   isValidDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateString),
/* harmony export */   isValidNumericID: () => (/* reexport safe */ _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__.isValidNumericID),
/* harmony export */   listFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.listFormat),
/* harmony export */   markdownToHTML: () => (/* reexport safe */ _markdown__WEBPACK_IMPORTED_MODULE_6__.markdownToHTML),
/* harmony export */   normalizeURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.normalizeURL),
/* harmony export */   numFmt: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numFmt),
/* harmony export */   numberFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numberFormat),
/* harmony export */   partitionReport: () => (/* reexport safe */ _partition_report__WEBPACK_IMPORTED_MODULE_14__.partitionReport),
/* harmony export */   prepareForReadableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.readableLargeNumber),
/* harmony export */   safelySort: () => (/* reexport safe */ _safely_sort__WEBPACK_IMPORTED_MODULE_13__.safelySort),
/* harmony export */   sanitizeHTML: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML),
/* harmony export */   shortenURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.shortenURL),
/* harmony export */   storageAvailable: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.storageAvailable),
/* harmony export */   stringToDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.stringToDate),
/* harmony export */   stringifyObject: () => (/* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_3__.stringifyObject),
/* harmony export */   trackEvent: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEvent),
/* harmony export */   trackEventOnce: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEventOnce),
/* harmony export */   untrailingslashit: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.untrailingslashit),
/* harmony export */   validateJSON: () => (/* binding */ validateJSON)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sanitize */ "./js/util/sanitize.js");
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringify */ "./js/util/stringify.js");
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./storage */ "./js/util/storage.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./i18n */ "./js/util/i18n.js");
/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./markdown */ "./js/util/markdown.js");
/* harmony import */ var _convert_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./convert-time */ "./js/util/convert-time.js");
/* harmony import */ var _dates__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dates */ "./js/util/dates.js");
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart */ "./js/util/chart.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./urls */ "./js/util/urls.js");
/* harmony import */ var _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./is-valid-numeric-id */ "./js/util/is-valid-numeric-id.js");
/* harmony import */ var _isnumeric__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isnumeric */ "./js/util/isnumeric.js");
/* harmony import */ var _safely_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./safely-sort */ "./js/util/safely-sort.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./partition-report */ "./js/util/partition-report.js");
/**
 * Utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */
















/**
 * Calculates the change between two values.
 *
 * @since 1.24.0
 *
 * @param {number} previous The previous value.
 * @param {number} current  The current value.
 * @return {(number|null)} The percent change. Null if the input or output is invalid.
 */
function calculateChange(previous, current) {
  function isZero(value) {
    return value === '0' || value === 0;
  }

  // Prevent null result when both values are legitimately zero.
  if (isZero(previous) && isZero(current)) {
    return 0;
  }

  // Prevent divide by zero errors.
  if (isZero(previous) || Number.isNaN(previous)) {
    return null;
  }

  // Avoid NaN at all costs.
  const change = (current - previous) / previous;
  if (Number.isNaN(change) || !Number.isFinite(change)) {
    return null;
  }
  return change;
}

/**
 * Verifies whether JSON is valid.
 *
 * @since 1.0.0
 *
 * @param {string} stringToValidate The string to validate.
 * @return {boolean} Indicates JSON is valid.
 */
function validateJSON(stringToValidate) {
  try {
    return JSON.parse(stringToValidate) && !!stringToValidate;
  } catch (e) {
    return false;
  }
}

/**
 * Converts HTML text into an HTML entity.
 *
 * _.unescape doesn't seem to decode some entities for admin bar titles.
 * adding combination in this helper as a workaround.
 *
 * @since 1.0.0
 *
 * @param {string} str The string to decode.
 * @return {string} Decoded HTML entity.
 */
function decodeHTMLEntity(str) {
  if (!str) {
    return '';
  }
  const decoded = str.replace(/&#(\d+);/g, (match, dec) => {
    return String.fromCharCode(dec);
  }).replace(/(\\)/g, '');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(decoded);
}

/***/ }),

/***/ "./js/util/insufficient-permissions-error-description.js":
/*!***************************************************************!*\
  !*** ./js/util/insufficient-permissions-error-description.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getInsufficientPermissionsErrorDescription: () => (/* binding */ getInsufficientPermissionsErrorDescription)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/**
 * `getInsufficientPermissionsErrorDescription` function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */




/**
 * Gets a description for an insufficient permissions error.
 *
 * @since 1.16.0
 *
 * @param {string} error              Original error message.
 * @param {Object} module             Module data.
 * @param {string} module.name        The name of the module.
 * @param {string} module.slug        The slug of the module.
 * @param {Object} module.owner       The owner of the module.
 * @param {string} module.owner.login The The login of the current owner.
 * @return {string}                   Error description.
 */
function getInsufficientPermissionsErrorDescription(error = '', module = {}) {
  const {
    slug = '',
    name = '',
    owner = {}
  } = module || {};

  // If no module data provided, it is impossible to provide a more clear message.
  if (!slug || !name) {
    return error;
  }
  let message = '';
  let userInfo = '';
  if (_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_ANALYTICS_4 === slug) {
    if (error.match(/account/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics account, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    } else if (error.match(/property/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics property, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    } else if (error.match(/view/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics view, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    }
  } else if (_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_1__.MODULE_SLUG_SEARCH_CONSOLE === slug) {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Search Console property, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
  }
  if (!message) {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions to access %s data, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit'), name);
  }
  if (owner && owner.login) {
    userInfo = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: owner name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This service was originally connected by the administrator "%s" — you can contact them for more information.', 'google-site-kit'), owner.login);
  }
  if (!userInfo) {
    userInfo = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This service was originally connected by an administrator — you can contact them for more information.', 'google-site-kit');
  }
  return `${message} ${userInfo}`;
}

/***/ }),

/***/ "./js/util/is-valid-numeric-id.js":
/*!****************************************!*\
  !*** ./js/util/is-valid-numeric-id.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidNumericID: () => (/* binding */ isValidNumericID)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks the given value to see if it is a positive integer.
 *
 * @since 1.11.0 Function introduced.
 * @since 1.90.0 Moved outside Tag Manager to a generic utility function.
 *
 * @param {*} input Value to check.
 * @return {boolean} Validity.
 */
function isValidNumericID(input) {
  const id = parseFloat(input) || 0;
  if (!Number.isInteger(id)) {
    return false;
  }
  return id > 0;
}

/***/ }),

/***/ "./js/util/isnumeric.js":
/*!******************************!*\
  !*** ./js/util/isnumeric.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNumeric: () => (/* binding */ isNumeric)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if a given value is numeric.
 *
 * @since 1.80.0
 *
 * @param {*} value The value to check.
 * @return {boolean} TRUE if a value is numeric FALSE otherwise.
 */
function isNumeric(value) {
  if (typeof value === 'number') {
    return true;
  }
  const string = (value || '').toString();
  if (!string) {
    return false;
  }
  return !isNaN(string);
}

/***/ }),

/***/ "./js/util/markdown.js":
/*!*****************************!*\
  !*** ./js/util/markdown.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   markdownToHTML: () => (/* binding */ markdownToHTML)
/* harmony export */ });
/**
 * Markdown utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Replaces markdown links with its HTML equivalents.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownLinks(text) {
  return text.replace(new RegExp('\\[([^\\]]+)\\]\\((https?://[^/]+\\.\\w+/?.*?)\\)', 'gi'), '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>');
}

/**
 * Adds paragraphs to the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownParagraphs(text) {
  return `<p>${text.replace(/\n{2,}/g, '</p><p>')}</p>`;
}

/**
 * Replaces line breaks in the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownBreaks(text) {
  return text.replace(/\n/gi, '<br>');
}

/**
 * Converts markdown to HTML.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} HTML version of the markdown text.
 */
function markdownToHTML(text) {
  const rules = [markdownLinks, markdownParagraphs, markdownBreaks];
  let html = text;
  for (const rule of rules) {
    html = rule(html);
  }
  return html;
}

/***/ }),

/***/ "./js/util/negate.js":
/*!***************************!*\
  !*** ./js/util/negate.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   negateDefined: () => (/* binding */ negateDefined)
/* harmony export */ });
/**
 * Negation utils.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Negates a defined value.
 *
 * @since 1.99.0
 *
 * @param {*} value The value to negate.
 * @return {(boolean|undefined)} The negated value, if defined.
 */
function negateDefined(value) {
  if (value === undefined) {
    return undefined;
  }
  return !value;
}

/***/ }),

/***/ "./js/util/partition-report.js":
/*!*************************************!*\
  !*** ./js/util/partition-report.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionReport: () => (/* binding */ partitionReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report partitioning utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.33.0
 * @since 1.34.0 Updated to support incomplete `report` arrays.
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionReport(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');

  // Use a negative date range length for reverse slicing.
  const _dateRangeLength = -1 * dateRangeLength;
  return {
    // The current range should always be sliced from the end.
    currentRange: report.slice(_dateRangeLength),
    // The compare range continues from where the current left off (slicing towards the start),
    // and may be shorter (where older data is not available yet) which is fine.
    compareRange: report.slice(_dateRangeLength * 2, _dateRangeLength)
  };
}

/***/ }),

/***/ "./js/util/purify.js":
/*!***************************!*\
  !*** ./js/util/purify.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   purify: () => (/* binding */ purify)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "../node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

const purify = dompurify__WEBPACK_IMPORTED_MODULE_0___default()(__webpack_require__.g);

/***/ }),

/***/ "./js/util/safely-sort.js":
/*!********************************!*\
  !*** ./js/util/safely-sort.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safelySort: () => (/* binding */ safelySort)
/* harmony export */ });
/**
 * `safelySort` utility function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Sorts an array without causing the mutation if the given parameter is an array.
 * If the parameter is not an array, it returns the parameter as is.
 *
 * @since 1.110.0
 * @since 1.128.0 Moved to the common utility directory from the key metrics directory.
 *
 * @param {Array|*} arr Param to be sorted.
 * @return {Array|*} 	Safely sorted array without mutation.
 */
function safelySort(arr) {
  return Array.isArray(arr) ? [...arr].sort() : arr;
}

/***/ }),

/***/ "./js/util/sanitize.js":
/*!*****************************!*\
  !*** ./js/util/sanitize.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sanitizeHTML: () => (/* binding */ sanitizeHTML),
/* harmony export */   untrailingslashit: () => (/* binding */ untrailingslashit)
/* harmony export */ });
/* harmony import */ var _purify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./purify */ "./js/util/purify.js");
/**
 * Internal dependencies
 */

function sanitizeHTML(unsafeHTML, domPurifyConfig = {}) {
  return {
    __html: _purify__WEBPACK_IMPORTED_MODULE_0__.purify.sanitize(unsafeHTML, domPurifyConfig)
  };
}

/**
 * Takes a string or an URL object, removes the trailing slash if any and returns it.
 *
 * @since 1.20.0
 * @private
 *
 * @param {Object|string} url A string with or without trailing slash or an URL object.
 * @return {string|undefined} The URL string after removing the trailing slash.
 */
function untrailingslashit(url) {
  const originalURL = typeof url === 'object' ? url.toString() : url;
  return originalURL?.replace?.(/\/+$/, '');
}

/***/ }),

/***/ "./js/util/storage.js":
/*!****************************!*\
  !*** ./js/util/storage.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   storageAvailable: () => (/* binding */ storageAvailable)
/* harmony export */ });
/**
 * Storage abstraction.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.0.0
 *
 * @param {string} type Browser storage to test. ex localStorage or sessionStorage.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
function storageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

// Custom no-op implementation of window.Storage.
class NullStorage {
  get length() {
    return 0;
  }
  key() {
    return null;
  }
  getItem() {
    return null;
  }
  setItem() {
    // Empty method body.
  }
  removeItem() {
    // Empty method body.
  }
  clear() {
    // Empty method body.
  }
}
let storageObj;

/**
 * Gets the storage object to use.
 *
 * @since 1.0.0
 *
 * @return {Storage} Either window.sessionStorage, window.localStorage', or a
 *                   no-op implementation if neither is available.
 */
function getStorage() {
  // Only run the logic to determine the storage object once.
  if (!storageObj) {
    if (storageAvailable('sessionStorage')) {
      storageObj = __webpack_require__.g.sessionStorage;
    } else if (storageAvailable('localStorage')) {
      storageObj = __webpack_require__.g.localStorage;
    } else {
      storageObj = new NullStorage();
    }
  }
  return storageObj;
}

/***/ }),

/***/ "./js/util/stringify.js":
/*!******************************!*\
  !*** ./js/util/stringify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyObject: () => (/* binding */ stringifyObject)
/* harmony export */ });
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Stringify function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Transforms an object into a hash string.
 *
 * This function can be used to e.g. generate cache keys, based on the given
 * object. Object properties are sorted, so even if they are provided in
 * different order, the hash will match. The function furthermore supports
 * nested objects.
 *
 * @since 1.7.0
 *
 * @param {Object} obj The object to stringify.
 * @return {string} Hash for the object.
 */
function stringifyObject(obj) {
  return md5__WEBPACK_IMPORTED_MODULE_0___default()(JSON.stringify(sortObjectProperties(obj)));
}
function sortObjectProperties(obj) {
  const orderedData = {};
  Object.keys(obj).sort().forEach(key => {
    let val = obj[key];
    if (val && 'object' === typeof val && !Array.isArray(val)) {
      val = sortObjectProperties(val);
    }
    orderedData[key] = val;
  });
  return orderedData;
}

/***/ }),

/***/ "./js/util/tracking/constants.js":
/*!***************************************!*\
  !*** ./js/util/tracking/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_LAYER: () => (/* binding */ DATA_LAYER),
/* harmony export */   SCRIPT_IDENTIFIER: () => (/* binding */ SCRIPT_IDENTIFIER)
/* harmony export */ });
/**
 * Constants related to event tracking.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Data layer global used for internal/private Site Kit data.
 *
 * @since 1.8.0
 * @private
 */
const DATA_LAYER = '_googlesitekitDataLayer';

/**
 * The `gtag` `<script>` identifier.
 *
 * @since 1.8.0
 * @private
 */
const SCRIPT_IDENTIFIER = 'data-googlesitekit-gtag';

/***/ }),

/***/ "./js/util/tracking/createDataLayerPush.js":
/*!*************************************************!*\
  !*** ./js/util/tracking/createDataLayerPush.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createDataLayerPush)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked will initialize the dataLayer and push data onto it.
 *
 * @since 1.3.0
 *
 * @param {Object} target Object to enhance with dataLayer data.
 * @return {Function} Function that pushes data onto the dataLayer.
 */
function createDataLayerPush(target) {
  /**
   * Pushes data onto the data layer.
   *
   * Must push an instance of Arguments to the target.
   * Using an ES6 spread operator (i.e. `...args`) will cause tracking events to
   * _silently_ fail.
   *
   * @since 1.0.0
   * @see {@link https://github.com/google/site-kit-wp/issues/1181}
   */
  return function dataLayerPush() {
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] = target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] || [];
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER].push(arguments);
  };
}

/***/ }),

/***/ "./js/util/tracking/createInitializeSnippet.js":
/*!*****************************************************!*\
  !*** ./js/util/tracking/createInitializeSnippet.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createInitializeSnippet)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/* harmony import */ var _js_features_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/features/index */ "./js/features/index.js");
/**
 * Internal dependencies
 */




/**
 * Returns a function which, when invoked injects the gtag script if necessary.
 *
 * @since 1.44.0
 *
 * @param {Object} config          Tracking configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @return {Function} Function that injects gtag script if it isn't yet present.
 */
function createInitializeSnippet(config, dataLayerTarget) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);
  let hasInsertedTag;
  const {
    activeModules,
    referenceSiteURL,
    userIDHash,
    userRoles = [],
    isAuthenticated,
    pluginVersion
  } = config;

  /**
   * Injects the necessary script tag if not present.
   *
   * @since 1.118.0
   *
   * @return {boolean|Object} Tag src as scriptTagSrc property.
   */
  return function initializeSnippet() {
    const {
      document
    } = __webpack_require__.g;
    if (undefined === hasInsertedTag) {
      hasInsertedTag = !!document.querySelector(`script[${_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER}]`);
    }
    if (hasInsertedTag) {
      return false;
    }
    hasInsertedTag = true;

    // Sometimes the user roles returned by Site Kit/WordPress is not an
    // array, as expected, so we guard against it here.
    //
    // See: https://github.com/google/site-kit-wp/issues/8266
    const userRolesAsString = userRoles?.length ? userRoles.join(',') : '';

    // We should use the real time, and not the reference date, when
    // measuring when we initialized tracking.
    dataLayerPush('js', new Date()); // eslint-disable-line sitekit/no-direct-date
    dataLayerPush('config', config.trackingID, {
      groups: 'site_kit',
      send_page_view: config.isSiteKitScreen,
      domain: referenceSiteURL,
      plugin_version: pluginVersion || '',
      enabled_features: Array.from(_js_features_index__WEBPACK_IMPORTED_MODULE_2__.enabledFeatures).join(','),
      active_modules: activeModules.join(','),
      authenticated: isAuthenticated ? '1' : '0',
      user_properties: {
        user_roles: userRolesAsString,
        user_identifier: userIDHash
      }
    });

    // If not present, inject it and initialize dataLayer.
    const scriptTag = document.createElement('script');
    scriptTag.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER, '');
    scriptTag.async = true;
    scriptTag.src = `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`;
    document.head.appendChild(scriptTag);
    return {
      scriptTagSrc: `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`
    };
  };
}

/***/ }),

/***/ "./js/util/tracking/createTrackEvent.js":
/*!**********************************************!*\
  !*** ./js/util/tracking/createTrackEvent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTrackEvent)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked tracks a single event.
 *
 * @since 1.3.0
 *
 * @param {Object}   config            Tracking configuration.
 * @param {Object}   dataLayerTarget   Data layer parent object.
 * @param {Function} initializeSnippet Function to initialize tracking.
 * @param {Object}   _global           The global window object.
 * @return {Function} Function that tracks an event.
 */
function createTrackEvent(config, dataLayerTarget, initializeSnippet, _global) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);

  /**
   * Send an Analytics tracking event.
   *
   * @since 1.3.0
   *
   * @param {string} category The category of the event.
   * @param {string} action   The action name of the event.
   * @param {string} [label]  Optional. The label of the event.
   * @param {number} [value]  Optional. A non-negative integer that will appear as the event value.
   * @return {Promise} Promise that always resolves.
   */
  // eslint-disable-next-line require-await
  return async function trackEvent(category, action, label, value) {
    const {
      trackingEnabled
    } = config;
    if (!trackingEnabled) {
      // Resolve immediately if tracking is disabled.
      return null;
    }
    initializeSnippet();
    const eventData = {
      send_to: 'site_kit',
      event_category: category,
      event_label: label,
      value
    };
    return new Promise(resolve => {
      // This timeout ensures a tracking event does not block the user
      // event if it is not sent (in time).
      // If the event beacon fails, it shouldn't reject the promise since event
      // tracking should not result in user-facing errors. It will just
      // trigger a console warning.
      function failCallback() {
        _global.console.warn(`Tracking event "${action}" (category "${category}") took too long to fire.`);
        resolve();
      }
      const failTimeout = setTimeout(failCallback, 1000);
      // eslint-disable-next-line camelcase
      function event_callback() {
        clearTimeout(failTimeout);
        resolve();
      }
      dataLayerPush('event', action, {
        ...eventData,
        event_callback
      });

      // If the client-side opt-out is present, the event_callback will never be called
      // so we call it here to prevent the warning and added delay.
      if (_global._gaUserPrefs?.ioo?.()) {
        event_callback();
      }
    });
  };
}

/***/ }),

/***/ "./js/util/tracking/createTracking.js":
/*!********************************************!*\
  !*** ./js/util/tracking/createTracking.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTracking)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createInitializeSnippet */ "./js/util/tracking/createInitializeSnippet.js");
/* harmony import */ var _createTrackEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createTrackEvent */ "./js/util/tracking/createTrackEvent.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const DEFAULT_CONFIG = {
  activeModules: [],
  isAuthenticated: false,
  referenceSiteURL: '',
  trackingEnabled: false,
  trackingID: '',
  userIDHash: '',
  userRoles: []
};

/**
 * Initializes tracking.
 *
 * @since 1.3.0
 *
 * @param {Object} newConfig       New configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @param {Object} _global         The global window object.
 * @return {Object} Tracking config.
 */
function createTracking(newConfig, dataLayerTarget = __webpack_require__.g, _global = __webpack_require__.g) {
  const config = {
    ...DEFAULT_CONFIG,
    ...newConfig
  };
  // Remove any trailing slash from the reference URL.
  if (config.referenceSiteURL) {
    config.referenceSiteURL = config.referenceSiteURL.toString().replace(/\/+$/, '');
  }
  const initializeSnippet = (0,_createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__["default"])(config, dataLayerTarget);
  const trackEvent = (0,_createTrackEvent__WEBPACK_IMPORTED_MODULE_2__["default"])(config, dataLayerTarget, initializeSnippet, _global);
  const onceTrackedEventsMap = {};
  function trackEventOnce(...params) {
    const key = JSON.stringify(params);
    if (!onceTrackedEventsMap[key]) {
      onceTrackedEventsMap[key] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.once)(trackEvent);
    }
    onceTrackedEventsMap[key](...params);
  }
  return {
    enableTracking: function enableTracking() {
      config.trackingEnabled = true;
    },
    disableTracking: function disableTracking() {
      config.trackingEnabled = false;
    },
    initializeSnippet,
    isTrackingEnabled: function isTrackingEnabled() {
      return !!config.trackingEnabled;
    },
    trackEvent,
    trackEventOnce
  };
}

/***/ }),

/***/ "./js/util/tracking/index.js":
/*!***********************************!*\
  !*** ./js/util/tracking/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTracking: () => (/* binding */ disableTracking),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   isTrackingEnabled: () => (/* binding */ isTrackingEnabled),
/* harmony export */   toggleTracking: () => (/* binding */ toggleTracking),
/* harmony export */   trackEvent: () => (/* binding */ trackEvent),
/* harmony export */   trackEventOnce: () => (/* binding */ trackEventOnce)
/* harmony export */ });
/* harmony import */ var _createTracking__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createTracking */ "./js/util/tracking/createTracking.js");
/**
 * Event tracking utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * Internal dependencies
 */

const {
  activeModules = [],
  isSiteKitScreen,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isAuthenticated,
  userRoles
} = __webpack_require__.g._googlesitekitTrackingData || {};

// Access the plugin version directly without destructuring as Webpack's DefinePlugin
// performs text replacement at build time and doesn't support destructuring patterns.
// See: https://github.com/google/site-kit-wp/issues/11802#issuecomment-3562955579
const pluginVersion = "1.168.0";
const initialConfig = {
  activeModules,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isSiteKitScreen,
  userRoles,
  isAuthenticated,
  pluginVersion
};
const {
  enableTracking,
  disableTracking,
  isTrackingEnabled,
  initializeSnippet,
  trackEvent,
  trackEventOnce
} = (0,_createTracking__WEBPACK_IMPORTED_MODULE_0__["default"])(initialConfig);

/**
 * Changes the active state of tracking.
 *
 * @since 1.3.0
 *
 * @param {boolean} activeStatus The new state to set.
 */
function toggleTracking(activeStatus) {
  if (!!activeStatus) {
    enableTracking();
  } else {
    disableTracking();
  }
}

// Bootstrap on import if tracking is allowed.
if (isSiteKitScreen && trackingEnabled) {
  initializeSnippet();
}


/***/ }),

/***/ "./js/util/urls.js":
/*!*************************!*\
  !*** ./js/util/urls.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFullURL: () => (/* binding */ getFullURL),
/* harmony export */   getURLPath: () => (/* binding */ getURLPath),
/* harmony export */   isHashOnly: () => (/* binding */ isHashOnly),
/* harmony export */   normalizeURL: () => (/* binding */ normalizeURL),
/* harmony export */   shortenURL: () => (/* binding */ shortenURL)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/**
 * URL pathname getter utility function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the path from a URL, omitting its protocol, hostname, query params, and hash.
 *
 * @since 1.24.0
 *
 * @param {string} url The URL to get the path from.
 * @return {string} The URL path.
 */
function getURLPath(url) {
  try {
    return new URL(url).pathname;
  } catch {}
  return null;
}

/**
 * Returns the absolute URL from a path including the siteURL.
 *
 * @since 1.32.0
 *
 * @param {string} siteURL The siteURL fo the WordPress install.
 * @param {string} path    The path.
 * @return {string} The URL path.
 */
function getFullURL(siteURL, path) {
  try {
    return new URL(path, siteURL).href;
  } catch {}
  return (typeof siteURL === 'string' ? siteURL : '') + (typeof path === 'string' ? path : '');
}

/**
 * Normalizes URL by removing protocol, www subdomain and trailing slash.
 *
 * @since 1.33.0
 *
 * @param {string} incomingURL The original URL.
 * @return {string} Normalized URL.
 */
function normalizeURL(incomingURL) {
  if (typeof incomingURL !== 'string') {
    return incomingURL;
  }
  return incomingURL
  // Remove protocol and optional "www." prefix from the URL.
  .replace(/^https?:\/\/(www\.)?/i, '')
  // Remove trailing slash.
  .replace(/\/$/, '');
}

/**
 * Checks if a string is not a full URL and simply a hash / anchor link.
 *
 * @since 1.49.0
 *
 * @param {string} url The URL or Hash string to test.
 * @return {boolean} Returns true if the string is only a hash and not a full URL.
 */
function isHashOnly(url) {
  return /^#\w[A-Za-z0-9-_]*$/.test(url);
}

/**
 * Shortens a URL to fit a given length.
 *
 * @since 1.49.0
 *
 * @param {string} url      The original URL to shorten.
 * @param {number} maxChars The maximum length of the URL.
 * @return {string} The shortened URL.
 */
function shortenURL(url, maxChars) {
  if (!(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.isURL)(url)) {
    return url;
  }
  if (url.length <= maxChars) {
    return url;
  }
  const urlObject = new URL(url);
  const shortenedURL = url.replace(urlObject.origin, '');
  if (shortenedURL.length < maxChars) {
    return shortenedURL;
  }
  const extraChars = shortenedURL.length - Math.floor(maxChars) + 1; // 1 is the length of "…".
  return '…' + shortenedURL.substr(extraChars);
}

/***/ }),

/***/ "./js/util/withIntersectionObserver.js":
/*!*********************************************!*\
  !*** ./js/util/withIntersectionObserver.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ withIntersectionObserver)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * `withIntersectionObserver` HOC.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Higher-Order Component to render a wrapped component and trigger a callback when it becomes in view.
 *
 * This was initially added to provide a workaround for a limitation with the `useIntersection` hook from `react-use`.
 * We should replace `useIntersection()` with a version that doesn't have this limitation.
 * See https://github.com/streamich/react-use/issues/2359.
 *
 * This HOC can however remain as an abstraction around `useIntersection()` to avoid repeating the same logic.
 *
 * @since 1.125.0
 *
 * @param {WPComponent} WrappedComponent Component to wrap.
 * @return {Function} Enhancing function.
 */

function withIntersectionObserver(WrappedComponent) {
  function WithIntersectionObserverComponent({
    onInView,
    ...props
  }) {
    const inViewRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useRef)();
    const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_2__["default"])(inViewRef, {
      root: null,
      threshold: 0.45
    });
    const [hasBeenInView, setHasBeenInView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const inView = !!intersectionEntry?.isIntersecting && !!intersectionEntry?.intersectionRatio;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (!intersectionEntry) {
        return;
      }
      if (inView && !hasBeenInView) {
        onInView();
        setHasBeenInView(true);
      }
    }, [hasBeenInView, inView, intersectionEntry, onInView]);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(WrappedComponent, {
      ref: inViewRef,
      ...props
    });
  }
  WithIntersectionObserverComponent.displayName = 'WithIntersectionObserverComponent';
  if (WrappedComponent.displayName || WrappedComponent.name) {
    WithIntersectionObserverComponent.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
  }
  WithIntersectionObserverComponent.propTypes = {
    onInView: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
    ...WrappedComponent.propTypes
  };
  return WithIntersectionObserverComponent;
}

/***/ }),

/***/ "./svg/graphics/ads.svg":
/*!******************************!*\
  !*** ./svg/graphics/ads.svg ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g, _defs;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgAds = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 40 40"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  clipPath: "url(#ads_svg__a)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#3C8BD9",
  d: "M13.612 5.602c.386-1.015.918-1.95 1.707-2.706C18.478-.181 23.697.592 25.84 4.458c1.61 2.932 3.318 5.8 4.978 8.7 2.77 4.816 5.573 9.632 8.312 14.465 2.303 4.044-.193 9.15-4.768 9.843-2.803.419-5.43-.87-6.88-3.383-2.432-4.237-4.88-8.473-7.313-12.694a1.5 1.5 0 0 0-.177-.258c-.258-.21-.37-.515-.531-.79-1.08-1.9-2.191-3.785-3.27-5.67-.693-1.224-1.418-2.432-2.11-3.656a6.67 6.67 0 0 1-.887-3.544c.048-.645.129-1.29.419-1.87"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#FABC04",
  d: "M13.612 5.602c-.145.58-.274 1.16-.306 1.772-.048 1.353.29 2.61.966 3.786 1.772 3.044 3.544 6.105 5.3 9.166.161.274.29.547.451.805a805 805 0 0 1-2.915 5.01c-1.354 2.336-2.707 4.688-4.076 7.024-.064 0-.08-.032-.097-.08-.016-.13.033-.242.065-.371.66-2.417.113-4.56-1.547-6.396-1.015-1.111-2.303-1.74-3.785-1.949-1.933-.274-3.641.226-5.171 1.434-.274.21-.451.515-.774.677-.064 0-.096-.033-.112-.081.773-1.337 1.53-2.674 2.303-4.011 3.19-5.542 6.38-11.083 9.585-16.609.032-.064.08-.113.113-.177"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#34A852",
  d: "M1.675 26.447c.306-.274.596-.564.918-.821 3.915-3.093 9.795-.854 10.648 4.043.21 1.176.097 2.304-.257 3.431a2 2 0 0 1-.065.274c-.145.258-.274.532-.435.79-1.434 2.368-3.544 3.544-6.315 3.366C2.996 37.305.5 34.92.064 31.763c-.21-1.53.097-2.964.886-4.285.161-.29.354-.548.532-.838.08-.064.048-.193.193-.193"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#FABC04",
  d: "M1.675 26.447c-.064.065-.064.177-.177.194-.016-.113.048-.178.113-.258z"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#E1C025",
  d: "M12.92 33.374c-.065-.113 0-.193.064-.274l.064.065z"
}))), _defs || (_defs = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("defs", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("clipPath", {
  id: "ads_svg__a"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#fff",
  d: "M0 0h40v40H0z"
})))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgAds);

/***/ }),

/***/ "./svg/graphics/banner-ads-setup-cta-mobile.svg?url":
/*!**********************************************************!*\
  !*** ./svg/graphics/banner-ads-setup-cta-mobile.svg?url ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-ads-setup-cta.svg?url":
/*!***************************************************!*\
  !*** ./svg/graphics/banner-ads-setup-cta.svg?url ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/woo-logo.svg":
/*!***********************************!*\
  !*** ./svg/graphics/woo-logo.svg ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWooLogo = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 109 46"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#873EFF",
  fillRule: "evenodd",
  d: "M45.718 8.472c-2.54 0-4.194.827-5.67 3.603l-6.734 12.7V13.491c0-3.367-1.595-5.02-4.549-5.02-2.953 0-4.193 1.004-5.67 3.839l-6.38 12.463V13.611c0-3.604-1.476-5.14-5.079-5.14H4.312C1.536 8.472 0 9.772 0 12.135s1.477 3.78 4.194 3.78h3.012V30.15c0 4.017 2.717 6.38 6.616 6.38s5.67-1.536 7.62-5.14l4.252-7.973v6.733c0 3.958 2.599 6.38 6.556 6.38 3.958 0 5.435-1.36 7.679-5.14l9.805-16.538c2.127-3.603.65-6.38-4.076-6.38zM64.147 8.472c-8.033 0-14.117 5.965-14.117 14.058s6.143 13.998 14.117 13.998 14.058-5.965 14.117-13.998c0-8.093-6.143-14.058-14.117-14.058m0 19.433c-3.012 0-5.08-2.245-5.08-5.376 0-3.13 2.068-5.434 5.08-5.434s5.08 2.304 5.08 5.435-2.008 5.375-5.08 5.375M94.329 8.472c-7.974 0-14.117 5.965-14.117 14.058s6.143 13.998 14.117 13.998 14.117-5.965 14.117-13.998c0-8.034-6.143-14.058-14.117-14.058m0 19.433c-3.072 0-5.02-2.245-5.02-5.376 0-3.13 2.007-5.434 5.02-5.434s5.08 2.304 5.08 5.435-2.009 5.375-5.08 5.375",
  clipRule: "evenodd"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWooLogo);

/***/ }),

/***/ "./svg/icons/arrow-inverse.svg":
/*!*************************************!*\
  !*** ./svg/icons/arrow-inverse.svg ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrowInverse = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "#FFF"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrowInverse);

/***/ }),

/***/ "./svg/icons/arrow.svg":
/*!*****************************!*\
  !*** ./svg/icons/arrow.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrow = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "currentColor"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#FFF",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrow);

/***/ }),

/***/ "./svg/icons/back.svg":
/*!****************************!*\
  !*** ./svg/icons/back.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgBack = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "m12 20-8-8 8-8 1.425 1.4-5.6 5.6H20v2H7.825l5.6 5.6z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgBack);

/***/ }),

/***/ "./svg/icons/check-fill.svg":
/*!**********************************!*\
  !*** ./svg/icons/check-fill.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgCheckFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  fillRule: "evenodd",
  d: "M12 1C5.925 1 1 5.925 1 12s4.925 11 11 11 11-4.925 11-11S18.075 1 12 1m4.806 8.592.592-.806-1.612-1.184-.592.806-3.89 5.296c-.166.226-.36.296-.512.296s-.346-.07-.512-.296l-1.474-2.007-.592-.806-1.612 1.184.592.806 1.474 2.007C9.191 15.6 9.971 16 10.792 16s1.6-.4 2.124-1.112z",
  clipRule: "evenodd"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgCheckFill);

/***/ }),

/***/ "./svg/icons/close.svg":
/*!*****************************!*\
  !*** ./svg/icons/close.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgClose = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 14 14"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M14 1.41 12.59 0 7 5.59 1.41 0 0 1.41 5.59 7 0 12.59 1.41 14 7 8.41 12.59 14 14 12.59 8.41 7z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgClose);

/***/ }),

/***/ "./svg/icons/external-rounded.svg":
/*!****************************************!*\
  !*** ./svg/icons/external-rounded.svg ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgExternalRounded = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 13 14"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "currentColor",
  strokeWidth: 1.5,
  d: "M4.5 1.5H3a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h7a2 2 0 0 0 2-2V9M7 1.5h5v5M5 8.5 11.5 2"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgExternalRounded);

/***/ }),

/***/ "./svg/icons/external.svg":
/*!********************************!*\
  !*** ./svg/icons/external.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgExternal = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "M5 21a2 2 0 0 1-1.425-.575A2 2 0 0 1 3 19V5q0-.825.575-1.4Q4.175 3 5 3h7v2H5v14h14v-7h2v7q0 .825-.6 1.425Q19.825 21 19 21zm4.7-5.3-1.4-1.4L17.6 5H14V3h7v7h-2V6.4z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgExternal);

/***/ }),

/***/ "./svg/icons/star-fill.svg":
/*!*********************************!*\
  !*** ./svg/icons/star-fill.svg ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgStarFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "m5.825 22 2.325-7.6L2 10h7.6L12 2l2.4 8H22l-6.15 4.4 2.325 7.6L12 17.3z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgStarFill);

/***/ }),

/***/ "./svg/icons/warning-notice.svg":
/*!**************************************!*\
  !*** ./svg/icons/warning-notice.svg ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningNotice = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1m0 14a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3m-1-2h2V6h-2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningNotice);

/***/ }),

/***/ "./svg/icons/warning-v2.svg":
/*!**********************************!*\
  !*** ./svg/icons/warning-v2.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningV2 = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 22 19"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M0 19h22L11 0zm12-3h-2v-2h2zm0-4h-2V8h2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningV2);

/***/ }),

/***/ "./svg/icons/warning.svg":
/*!*******************************!*\
  !*** ./svg/icons/warning.svg ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path, _path2;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarning = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  "aria-labelledby": "warning-title warning-desc",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "none",
  d: "M0 0h24v24H0z"
})), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2m1 15h-2v-2h2zm0-4h-2V7h2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarning);

/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.i18n;

/***/ }),

/***/ "googlesitekit-api":
/*!****************************************!*\
  !*** external ["googlesitekit","api"] ***!
  \****************************************/
/***/ ((module) => {

module.exports = googlesitekit.api;

/***/ }),

/***/ "googlesitekit-components":
/*!***********************************************!*\
  !*** external ["googlesitekit","components"] ***!
  \***********************************************/
/***/ ((module) => {

module.exports = googlesitekit.components;

/***/ }),

/***/ "googlesitekit-data":
/*!*****************************************!*\
  !*** external ["googlesitekit","data"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.data;

/***/ }),

/***/ "googlesitekit-modules":
/*!********************************************!*\
  !*** external ["googlesitekit","modules"] ***!
  \********************************************/
/***/ ((module) => {

module.exports = googlesitekit.modules;

/***/ }),

/***/ "googlesitekit-notifications":
/*!**************************************************!*\
  !*** external ["googlesitekit","notifications"] ***!
  \**************************************************/
/***/ ((module) => {

module.exports = googlesitekit.notifications;

/***/ }),

/***/ "googlesitekit-widgets":
/*!********************************************!*\
  !*** external ["googlesitekit","widgets"] ***!
  \********************************************/
/***/ ((module) => {

module.exports = googlesitekit.widgets;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-modules-ads.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-modules-ads.js.map