<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\TagManager;

class RevertTagResponse extends \Google\Site_Kit_Dependencies\Google\Model
{
    protected $tagType = \Google\Site_Kit_Dependencies\Google\Service\TagManager\Tag::class;
    protected $tagDataType = '';
    /**
     * Tag as it appears in the latest container version since the last workspace
     * synchronization operation. If no tag is present, that means the tag was
     * deleted in the latest container version.
     *
     * @param Tag $tag
     */
    public function setTag(\Google\Site_Kit_Dependencies\Google\Service\TagManager\Tag $tag)
    {
        $this->tag = $tag;
    }
    /**
     * @return Tag
     */
    public function getTag()
    {
        return $this->tag;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\TagManager\RevertTagResponse::class, 'Google\\Site_Kit_Dependencies\\Google_Service_TagManager_RevertTagResponse');
