<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\SiteVerification;

class SiteVerificationWebResourceGettokenResponse extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * The verification method to use in conjunction with this token. For FILE,
     * the token should be placed in the top-level directory of the site, stored
     * inside a file of the same name. For META, the token should be placed in the
     * HEAD tag of the default page that is loaded for the site. For DNS, the
     * token should be placed in a TXT record of the domain.
     *
     * @var string
     */
    public $method;
    /**
     * The verification token. The token must be placed appropriately in order for
     * verification to succeed.
     *
     * @var string
     */
    public $token;
    /**
     * The verification method to use in conjunction with this token. For FILE,
     * the token should be placed in the top-level directory of the site, stored
     * inside a file of the same name. For META, the token should be placed in the
     * HEAD tag of the default page that is loaded for the site. For DNS, the
     * token should be placed in a TXT record of the domain.
     *
     * @param string $method
     */
    public function setMethod($method)
    {
        $this->method = $method;
    }
    /**
     * @return string
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * The verification token. The token must be placed appropriately in order for
     * verification to succeed.
     *
     * @param string $token
     */
    public function setToken($token)
    {
        $this->token = $token;
    }
    /**
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\SiteVerification\SiteVerificationWebResourceGettokenResponse::class, 'Google\\Site_Kit_Dependencies\\Google_Service_SiteVerification_SiteVerificationWebResourceGettokenResponse');
