<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle;

class Order extends \Google\Site_Kit_Dependencies\Google\Collection
{
    protected $collection_key = 'stateDetails';
    /**
     * @var string
     */
    public $createTime;
    /**
     * @var string
     */
    public $name;
    /**
     * @var string
     */
    public $offerId;
    /**
     * @var string
     */
    public $orderId;
    protected $paymentAddressType = \Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\PaymentAddress::class;
    protected $paymentAddressDataType = '';
    /**
     * @var string
     */
    public $planTitle;
    /**
     * @var string[]
     */
    public $productIds;
    protected $recurrenceDetailsType = \Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\RecurrenceDetails::class;
    protected $recurrenceDetailsDataType = '';
    protected $stateDetailsType = \Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\StateDetails::class;
    protected $stateDetailsDataType = 'array';
    /**
     * @var string
     */
    public $updateTime;
    /**
     * @param string
     */
    public function setCreateTime($createTime)
    {
        $this->createTime = $createTime;
    }
    /**
     * @return string
     */
    public function getCreateTime()
    {
        return $this->createTime;
    }
    /**
     * @param string
     */
    public function setName($name)
    {
        $this->name = $name;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * @param string
     */
    public function setOfferId($offerId)
    {
        $this->offerId = $offerId;
    }
    /**
     * @return string
     */
    public function getOfferId()
    {
        return $this->offerId;
    }
    /**
     * @param string
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
    }
    /**
     * @return string
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * @param PaymentAddress
     */
    public function setPaymentAddress(\Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\PaymentAddress $paymentAddress)
    {
        $this->paymentAddress = $paymentAddress;
    }
    /**
     * @return PaymentAddress
     */
    public function getPaymentAddress()
    {
        return $this->paymentAddress;
    }
    /**
     * @param string
     */
    public function setPlanTitle($planTitle)
    {
        $this->planTitle = $planTitle;
    }
    /**
     * @return string
     */
    public function getPlanTitle()
    {
        return $this->planTitle;
    }
    /**
     * @param string[]
     */
    public function setProductIds($productIds)
    {
        $this->productIds = $productIds;
    }
    /**
     * @return string[]
     */
    public function getProductIds()
    {
        return $this->productIds;
    }
    /**
     * @param RecurrenceDetails
     */
    public function setRecurrenceDetails(\Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\RecurrenceDetails $recurrenceDetails)
    {
        $this->recurrenceDetails = $recurrenceDetails;
    }
    /**
     * @return RecurrenceDetails
     */
    public function getRecurrenceDetails()
    {
        return $this->recurrenceDetails;
    }
    /**
     * @param StateDetails[]
     */
    public function setStateDetails($stateDetails)
    {
        $this->stateDetails = $stateDetails;
    }
    /**
     * @return StateDetails[]
     */
    public function getStateDetails()
    {
        return $this->stateDetails;
    }
    /**
     * @param string
     */
    public function setUpdateTime($updateTime)
    {
        $this->updateTime = $updateTime;
    }
    /**
     * @return string
     */
    public function getUpdateTime()
    {
        return $this->updateTime;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\Order::class, 'Google\\Site_Kit_Dependencies\\Google_Service_SubscribewithGoogle_Order');
