"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-modules-tagmanager"],{

/***/ "./js/api-fetch-shim.js":
/*!******************************!*\
  !*** ./js/api-fetch-shim.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch__non-shim */ "../node_modules/@wordpress/api-fetch/build/index.js");
/* harmony import */ var _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/api/middleware/preloading.js */ "./js/googlesitekit/api/middleware/preloading.js");
/* harmony import */ var _js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/api/middleware/deduplication */ "./js/googlesitekit/api/middleware/deduplication.ts");
/* harmony reexport (unknown) */ var __WEBPACK_REEXPORT_OBJECT__ = {};
/* harmony reexport (unknown) */ for(const __WEBPACK_IMPORT_KEY__ in _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== "default") __WEBPACK_REEXPORT_OBJECT__[__WEBPACK_IMPORT_KEY__] = () => _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__[__WEBPACK_IMPORT_KEY__]
/* harmony reexport (unknown) */ __webpack_require__.d(__webpack_exports__, __WEBPACK_REEXPORT_OBJECT__);
/**
 * API Fetch Shim.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const {
  nonce,
  nonceEndpoint,
  preloadedData,
  rootURL
} = __webpack_require__.g._googlesitekitAPIFetchData || {};
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceEndpoint) = nonceEndpoint;
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceMiddleware) = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().createNonceMiddleware(nonce);
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().rootURLMiddleware) = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().createRootURLMiddleware(rootURL);
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().dedupeMiddleware) = (0,_js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_2__["default"])({
  onDuplicate: _js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_2__.logDuplicate
});
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().preloadingMiddleware) = (0,_googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_1__["default"])(preloadedData);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().mediaUploadMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().rootURLMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().dedupeMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().preloadingMiddleware));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default()));

/***/ }),

/***/ "./js/components/AccessibleWarningIcon.js":
/*!************************************************!*\
  !*** ./js/components/AccessibleWarningIcon.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccessibleWarningIcon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _VisuallyHidden__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var _svg_icons_warning_v2_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/warning-v2.svg */ "./svg/icons/warning-v2.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AccessibleWarningIcon component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function AccessibleWarningIcon({
  height = 12,
  screenReaderText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error', 'google-site-kit'),
  width = 14
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_VisuallyHidden__WEBPACK_IMPORTED_MODULE_1__["default"], {
      children: screenReaderText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_warning_v2_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: width,
      height: height
    })]
  });
}
AccessibleWarningIcon.propTypes = {
  height: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number),
  screenReaderText: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number)
};

/***/ }),

/***/ "./js/components/Badge.js":
/*!********************************!*\
  !*** ./js/components/Badge.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Badge component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Badge = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  label,
  className,
  hasLeftSpacing = false,
  ...rest
}, ref) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
  ref: ref,
  ...rest,
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge', className, {
    'googlesitekit-badge--has-left-spacing': hasLeftSpacing
  }),
  children: label
}));
Badge.displayName = 'Badge';
Badge.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/DisplaySetting.js":
/*!*****************************************!*\
  !*** ./js/components/DisplaySetting.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BLANK_SPACE: () => (/* binding */ BLANK_SPACE),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);
/**
 * DisplaySetting component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const BLANK_SPACE = '\u00A0';
function DisplaySetting({
  value
}) {
  return value || BLANK_SPACE;
}
DisplaySetting.propTypes = {
  value: prop_types__WEBPACK_IMPORTED_MODULE_0___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_0___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_0___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_0___default().number)])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DisplaySetting);

/***/ }),

/***/ "./js/components/ErrorNotice.js":
/*!**************************************!*\
  !*** ./js/components/ErrorNotice.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorNotice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ErrorNotice({
  className,
  error,
  hasButton = false,
  storeName,
  message = error.message,
  noPrefix = false,
  skipRetryMessage,
  hideIcon = false
}) {
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const selectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!storeName) {
      return null;
    }
    return select(storeName).getSelectorDataForError(error);
  });
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
  }, [dispatch, selectorData]);

  // Do not display if there is no error and no direct message text is passed as a direct prop.
  // Also do not display if the error is for missing scopes as these are handled by a popup modal.
  if (!message || (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isPermissionScopeError)(error)) {
    return null;
  }
  const shouldDisplayRetry = hasButton && (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isErrorRetryable)(error, selectorData);

  /**
   * Error message to display to the user. Sometimes we append a retry message
   * or a reconnect URL, so we create a new variable for the message to display.
   */
  let errorMessageWithModifications = message;

  // Append "Try again" messaging if no retry button is present.
  if (!hasButton && !skipRetryMessage) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message from Google API. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s (Please try again.)', 'google-site-kit'), errorMessageWithModifications);
  }
  if (!noPrefix) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: $%s: Error message */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), errorMessageWithModifications);
  }
  const reconnectURL = error?.data?.reconnectURL;
  if (reconnectURL && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.isURL)(reconnectURL)) {
    /**
     * This error message uses HTML tags without using
     * `createInterpolateElement` because the error messages
     * that come from the server/API can also contain HTML (eg. links)
     * we want to render.
     *
     * Instead of creating a React node using `createInterpolateElement`,
     * we use `dangerouslySetInnerHTML` to allow the HTML we create and from
     * the server/API to be rendered as-intended.
     */
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Original error message 2: Reconnect URL */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s To fix this, <a href="%2$s">redo the plugin setup</a>.', 'google-site-kit'), errorMessageWithModifications, reconnectURL);
  }
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a'],
    ALLOWED_ATTR: ['href']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: className,
    type: _Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.ERROR,
    description:
    /*#__PURE__*/
    // The error messages that come from the server/API can contain
    // HTML (eg. links), so we use `dangerouslySetInnerHTML` and sanitize
    // the HTML to render these links.
    //
    // We tried to use `createInterpolateElement` but it does not work
    // with HTML tags that come from the server/API.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.sanitizeHTML)(errorMessageWithModifications, sanitizeArgs)
    }),
    ctaButton: shouldDisplayRetry ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit'),
      onClick: handleRetry
    } : undefined,
    hideIcon: hideIcon
  });
}
ErrorNotice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  error: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }),
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/FeaturesProvider/FeaturesContext.js":
/*!***********************************************************!*\
  !*** ./js/components/FeaturesProvider/FeaturesContext.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Feature Flags context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const FeaturesContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createContext)(_js_features__WEBPACK_IMPORTED_MODULE_0__.enabledFeatures);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturesContext);

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external = false,
  hideExternalIndicator = false
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__cta', {
      'googlesitekit-notice__cta--spinner__running': inProgress
    }),
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : undefined,
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_1__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  INFO_ALT: 'info-alt',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
    className: "googlesitekit-notice-container",
    ref: ref,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
      children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
        className: "googlesitekit-notice__icon",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
          type: type
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-notice__content",
        children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_2__["default"], {
          children: title
        }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
          children: description
        })]
      }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-notice__action",
        children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
          label: dismissButton.label,
          onClick: dismissButton.onClick,
          disabled: dismissButton.disabled
        }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
          label: ctaButton.label,
          onClick: ctaButton.onClick,
          inProgress: ctaButton.inProgress,
          disabled: ctaButton.disabled,
          href: ctaButton.href,
          external: ctaButton.external,
          hideExternalIndicator: ctaButton.hideExternalIndicator
        })]
      })]
    })
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_6__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_6__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/Root/ViewContextContext.js":
/*!**************************************************!*\
  !*** ./js/components/Root/ViewContextContext.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * View Context context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const ViewContextContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)('');
const {
  Consumer,
  Provider
} = ViewContextContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewContextContext);

/***/ }),

/***/ "./js/components/StoreErrorNotices.js":
/*!********************************************!*\
  !*** ./js/components/StoreErrorNotices.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ StoreErrorNotices)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ErrorNotice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/insufficient-permissions-error-description */ "./js/util/insufficient-permissions-error-description.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * StoreErrorNotices component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






function StoreErrorNotices({
  hasButton = false,
  moduleSlug,
  storeName
}) {
  const errors = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(storeName).getErrors());
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(moduleSlug));
  const existingErrorMessages = [];
  return errors.filter(error => {
    if (!error?.message || existingErrorMessages.includes(error.message)) {
      return false;
    }
    existingErrorMessages.push(error.message);
    return true;
  }).map((error, key) => {
    let {
      message
    } = error;
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_3__.isInsufficientPermissionsError)(error)) {
      message = (0,_js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_4__.getInsufficientPermissionsErrorDescription)(message, module);
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_ErrorNotice__WEBPACK_IMPORTED_MODULE_1__["default"], {
      error: error,
      hasButton: hasButton,
      storeName: storeName,
      message: message
    }, key);
  });
}
StoreErrorNotices.propTypes = {
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};

/***/ }),

/***/ "./js/components/Typography/P.js":
/*!***************************************!*\
  !*** ./js/components/Typography/P.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ P)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! . */ "./js/components/Typography/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function P({
  type = _constants__WEBPACK_IMPORTED_MODULE_2__.TYPE_BODY,
  size,
  children,
  ...props
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(___WEBPACK_IMPORTED_MODULE_1__["default"], {
    as: "p",
    type: type,
    size: size || (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL ? _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_SMALL : _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_MEDIUM),
    ...props,
    children: children
  });
}
P.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_SIZES)
};

/***/ }),

/***/ "./js/components/Typography/constants.js":
/*!***********************************************!*\
  !*** ./js/components/Typography/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SIZE_LARGE: () => (/* binding */ SIZE_LARGE),
/* harmony export */   SIZE_MEDIUM: () => (/* binding */ SIZE_MEDIUM),
/* harmony export */   SIZE_SMALL: () => (/* binding */ SIZE_SMALL),
/* harmony export */   TYPE_BODY: () => (/* binding */ TYPE_BODY),
/* harmony export */   TYPE_DISPLAY: () => (/* binding */ TYPE_DISPLAY),
/* harmony export */   TYPE_HEADLINE: () => (/* binding */ TYPE_HEADLINE),
/* harmony export */   TYPE_LABEL: () => (/* binding */ TYPE_LABEL),
/* harmony export */   TYPE_TITLE: () => (/* binding */ TYPE_TITLE),
/* harmony export */   VALID_SIZES: () => (/* binding */ VALID_SIZES),
/* harmony export */   VALID_TYPES: () => (/* binding */ VALID_TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPE_DISPLAY = 'display';
const TYPE_HEADLINE = 'headline';
const TYPE_TITLE = 'title';
const TYPE_BODY = 'body';
const TYPE_LABEL = 'label';
const VALID_TYPES = [TYPE_BODY, TYPE_DISPLAY, TYPE_HEADLINE, TYPE_LABEL, TYPE_TITLE];
const SIZE_SMALL = 'small';
const SIZE_MEDIUM = 'medium';
const SIZE_LARGE = 'large';
const VALID_SIZES = [SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE];

/***/ }),

/***/ "./js/components/Typography/index.js":
/*!*******************************************!*\
  !*** ./js/components/Typography/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Typography)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function Typography({
  className,
  type,
  size,
  as: Component = 'span',
  children,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Component, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-typography', className, {
      [`googlesitekit-typography--${type}`]: type && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES.includes(type),
      [`googlesitekit-typography--${size}`]: size && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES.includes(size)
    }),
    ...props,
    children: children
  });
}
Typography.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES),
  as: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)])
};

/***/ }),

/***/ "./js/components/VisuallyHidden.js":
/*!*****************************************!*\
  !*** ./js/components/VisuallyHidden.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Visually Hidden component, mainly used for screen-reader text.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function VisuallyHidden({
  className,
  children,
  ...otherProps
}) {
  if (!children) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('screen-reader-text', className),
    children: children
  });
}
VisuallyHidden.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
VisuallyHidden.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VisuallyHidden);

/***/ }),

/***/ "./js/components/google-tag-gateway/GoogleTagGatewayToggle.js":
/*!********************************************************************!*\
  !*** ./js/components/google-tag-gateway/GoogleTagGatewayToggle.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GoogleTagGatewayToggle)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_withIntersectionObserver__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util/withIntersectionObserver */ "./js/util/withIntersectionObserver.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Google Tag Gateway Toggle component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










const SubtleNotificationWithIntersectionObserver = (0,_js_util_withIntersectionObserver__WEBPACK_IMPORTED_MODULE_9__["default"])(_js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"]);
function GoogleTagGatewayToggle({
  className
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const isGoogleTagGatewayEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isGoogleTagGatewayEnabled());
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isFetchingGetGTGServerRequirementStatus());
  const hasMetServerRequirements = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const {
      isGTGHealthy,
      isScriptAccessEnabled
    } = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
    return isGTGHealthy() !== false && isScriptAccessEnabled() !== false;
  });
  const {
    fetchGetGTGServerRequirementStatus,
    setGoogleTagGatewayEnabled
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
  const learnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('google-tag-gateway-introduction');
  });
  const serverRequirementsLearnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('google-tag-gateway-server-requirements');
  });

  // Fetch the server requirement status on mount.
  (0,react_use__WEBPACK_IMPORTED_MODULE_12__["default"])(fetchGetGTGServerRequirementStatus);
  const handleClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    const action = isGoogleTagGatewayEnabled ? 'deactivate_google_tag_gateway' : 'activate_google_tag_gateway';
    (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_gtg-settings-toggle`, action).finally(() => {
      setGoogleTagGatewayEnabled(!isGoogleTagGatewayEnabled);
    });
  }, [isGoogleTagGatewayEnabled, setGoogleTagGatewayEnabled, viewContext]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-google-tag-gateway-toggle', className),
    children: [isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {
      className: "googlesitekit-google-tag-gateway-toggle__progress",
      small: true
    }), !isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-module-settings-group__switch",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Switch, {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Google tag gateway for advertisers', 'google-site-kit'),
        checked: !!isGoogleTagGatewayEnabled && hasMetServerRequirements,
        disabled: !hasMetServerRequirements,
        onClick: handleClick,
        hideLabel: false
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "googlesitekit-google-tag-gateway-toggle__switch-badge",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_5__["default"], {
          className: "googlesitekit-badge--beta",
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Beta', 'google-site-kit'),
          hasLeftSpacing: true
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
      className: "googlesitekit-module-settings-group__helper-text",
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Your tag data will be sent through your own domain to improve data quality and help you recover measurement signals. <a>Learn more</a>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
          href: learnMoreURL,
          onClick: () => {
            (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_gtg-settings-toggle`, 'click_learn_more_link');
          },
          "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more about Google tag gateway for advertisers', 'google-site-kit'),
          external: true
        })
      })
    }), !isLoading && !hasMetServerRequirements && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(SubtleNotificationWithIntersectionObserver, {
      type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_10__["default"].TYPES.WARNING,
      title: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Your server’s current settings prevent Google tag gateway for advertisers from working. To enable it, please contact your hosting provider and request access to external resources and plugin files. <a>Learn more</a>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
          href: serverRequirementsLearnMoreURL,
          onClick: () => {
            (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_gtg-settings-toggle-disabled`, 'click_learn_more_link');
          },
          "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more about Google tag gateway for advertisers server requirements', 'google-site-kit'),
          external: true
        })
      }),
      variant: "warning",
      onInView: () => {
        (0,_js_util__WEBPACK_IMPORTED_MODULE_8__.trackEvent)(`${viewContext}_gtg-settings-toggle-disabled`, 'view_notice');
      }
    })]
  });
}

/***/ }),

/***/ "./js/components/settings/SettingsGroup.js":
/*!*************************************************!*\
  !*** ./js/components/settings/SettingsGroup.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsGroup)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsInactiveModules component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function SettingsGroup({
  title,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-module-settings-group",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_0__["default"], {
      as: "h4",
      size: "medium",
      type: "title",
      children: title
    }), children]
  });
}
SettingsGroup.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired
};

/***/ }),

/***/ "./js/components/settings/SettingsStatuses.js":
/*!****************************************************!*\
  !*** ./js/components/settings/SettingsStatuses.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsStatuses)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SettingsStatuses component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function SettingsStatuses({
  statuses
}) {
  if (!statuses || statuses.length === 0) {
    return null;
  }
  function renderStatus(status) {
    if (status === undefined) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "googlesitekit-settings-module__meta-item-data",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, {})
      });
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
      className: "googlesitekit-settings-module__meta-item-data",
      children: status ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enabled', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Disabled', 'google-site-kit')
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
    className: "googlesitekit-settings-module__meta-items",
    children: statuses.map(({
      label,
      status
    }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "googlesitekit-settings-module__meta-item",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_2__["default"], {
        as: "h5",
        size: "medium",
        type: "label",
        className: "googlesitekit-settings-module__meta-item-type",
        children: label
      }), renderStatus(status)]
    }, label))
  });
}
SettingsStatuses.propTypes = {
  statuses: prop_types__WEBPACK_IMPORTED_MODULE_4___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_4___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
    status: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf([undefined, true, false])
  }))
};

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-modules-tagmanager.js":
/*!************************************************!*\
  !*** ./js/googlesitekit-modules-tagmanager.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-modules */ "googlesitekit-modules");
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _modules_tagmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modules/tagmanager */ "./js/modules/tagmanager/index.js");
/**
 * Tag Manager module entrypoint.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



(0,_modules_tagmanager__WEBPACK_IMPORTED_MODULE_2__.registerStore)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
(0,_modules_tagmanager__WEBPACK_IMPORTED_MODULE_2__.registerModule)((googlesitekit_modules__WEBPACK_IMPORTED_MODULE_1___default()));

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.170.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/api/middleware/deduplication.ts":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/api/middleware/deduplication.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   logDuplicate: () => (/* binding */ logDuplicate)
/* harmony export */ });
/* harmony import */ var equivalent_key_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! equivalent-key-map */ "../node_modules/equivalent-key-map/equivalent-key-map.js");
/* harmony import */ var equivalent_key_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(equivalent_key_map__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */

/**
 * Logs a console warning for the given request options.
 *
 * @since 1.170.0
 *
 * @param  options API fetch options of the duplicate request.
 * @return {void}
 */
function logDuplicate(options) {
  __webpack_require__.g.console.warn('Google Site Kit API: duplicate request', options);
}
/**
 * Creates a new request deduplication middleware instance.
 *
 * @since 1.170.0
 *
 * @param middlewareOptions Options for configuring the behavior of the middleware.
 * @return Middleware handler function.
 */
function createDedupeMiddleware(middlewareOptions = {}) {
  const {
    onDuplicate
  } = middlewareOptions;
  const concurrentRequests = new (equivalent_key_map__WEBPACK_IMPORTED_MODULE_0___default())();
  return function (options, next) {
    // If we already have a request for these options
    // call the handler, if any, and return the shared response.
    const existingRequest = concurrentRequests.get(options);
    // EquivalentKeyMap doesn't implement `has` as expected, so we need to check the value.
    // When deleting, the value is set to `undefined` so `has(key)` remains true.
    if (existingRequest instanceof Promise) {
      onDuplicate?.(options);
      return existingRequest;
    }
    const promise = next(options);
    concurrentRequests.set(options, promise);

    // Ensure the request entry is removed once the request
    // is completed regardless of any error.
    promise.catch(() => {
      // avoid an uncaught error here
    }).finally(() => {
      concurrentRequests.delete(options);
    });
    return promise;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createDedupeMiddleware);

/***/ }),

/***/ "./js/googlesitekit/api/middleware/preloading.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/api/middleware/preloading.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/normalize-path.js");
/**
 * Custom preloading middleware.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies.
 */


/**
 * Creates a preloading middleware.
 *
 * Based on preloadMiddleware from from @wordpress/api-fetch, this middle is a single-use per-endpoint and provides cached
 * data for the first request only and any subsequent requests reach the server.
 *
 * @since 1.13.0
 *
 * @param {Object} preloadedData Preloaded data paths.
 * @return {Function} Function.
 */
function createPreloadingMiddleware(preloadedData) {
  const cache = Object.keys(preloadedData).reduce((result, path) => {
    result[(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(path)] = preloadedData[path];
    return result;
  }, {});
  let cacheHasExpired = false;
  return (options, next) => {
    if (cacheHasExpired) {
      return next(options);
    }
    setTimeout(() => {
      cacheHasExpired = true;
    }, 3000);
    const {
      parse = true
    } = options;
    const uri = options.path;
    if (typeof options.path === 'string') {
      const method = options.method?.toUpperCase() || 'GET';
      const path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(uri);
      if (parse && 'GET' === method && cache[path]) {
        const result = Promise.resolve(cache[path].body);
        delete cache[path];
        return result;
      } else if ('OPTIONS' === method && cache[method] && cache[method][path]) {
        const result = Promise.resolve(cache[method][path]);
        delete cache[method][path];
        return result;
      }
    }
    return next(options);
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPreloadingMiddleware);

/***/ }),

/***/ "./js/googlesitekit/constants.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ANCHOR_ID_CONTENT: () => (/* binding */ ANCHOR_ID_CONTENT),
/* harmony export */   ANCHOR_ID_KEY_METRICS: () => (/* binding */ ANCHOR_ID_KEY_METRICS),
/* harmony export */   ANCHOR_ID_MONETIZATION: () => (/* binding */ ANCHOR_ID_MONETIZATION),
/* harmony export */   ANCHOR_ID_SPEED: () => (/* binding */ ANCHOR_ID_SPEED),
/* harmony export */   ANCHOR_ID_TRAFFIC: () => (/* binding */ ANCHOR_ID_TRAFFIC),
/* harmony export */   SITE_KIT_VIEW_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_CONTEXTS),
/* harmony export */   SITE_KIT_VIEW_ONLY_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_ONLY_CONTEXTS),
/* harmony export */   VIEW_CONTEXT_ACTIVATION: () => (/* binding */ VIEW_CONTEXT_ACTIVATION),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_AD_BLOCKING_RECOVERY: () => (/* binding */ VIEW_CONTEXT_AD_BLOCKING_RECOVERY),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_KEY_METRICS_SETUP: () => (/* binding */ VIEW_CONTEXT_KEY_METRICS_SETUP),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_METRIC_SELECTION: () => (/* binding */ VIEW_CONTEXT_METRIC_SELECTION),
/* harmony export */   VIEW_CONTEXT_MODULE: () => (/* binding */ VIEW_CONTEXT_MODULE),
/* harmony export */   VIEW_CONTEXT_MODULE_SETUP: () => (/* binding */ VIEW_CONTEXT_MODULE_SETUP),
/* harmony export */   VIEW_CONTEXT_POSTS_LIST: () => (/* binding */ VIEW_CONTEXT_POSTS_LIST),
/* harmony export */   VIEW_CONTEXT_SETTINGS: () => (/* binding */ VIEW_CONTEXT_SETTINGS),
/* harmony export */   VIEW_CONTEXT_SPLASH: () => (/* binding */ VIEW_CONTEXT_SPLASH),
/* harmony export */   VIEW_CONTEXT_USER_INPUT: () => (/* binding */ VIEW_CONTEXT_USER_INPUT),
/* harmony export */   VIEW_CONTEXT_WP_BLOCK_EDITOR: () => (/* binding */ VIEW_CONTEXT_WP_BLOCK_EDITOR),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY)
/* harmony export */ });
/**
 * Core constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const VIEW_CONTEXT_MAIN_DASHBOARD = 'mainDashboard';
const VIEW_CONTEXT_ENTITY_DASHBOARD = 'entityDashboard';
const VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY = 'mainDashboardViewOnly';
const VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY = 'entityDashboardViewOnly';
const VIEW_CONTEXT_POSTS_LIST = 'postsList';
const VIEW_CONTEXT_USER_INPUT = 'userInput';
const VIEW_CONTEXT_ACTIVATION = 'activation';
const VIEW_CONTEXT_SPLASH = 'splash';
const VIEW_CONTEXT_ADMIN_BAR = 'adminBar';
const VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY = 'adminBarViewOnly';
const VIEW_CONTEXT_SETTINGS = 'settings';
const VIEW_CONTEXT_AD_BLOCKING_RECOVERY = 'adBlockingRecovery';
const VIEW_CONTEXT_MODULE = 'module';
const VIEW_CONTEXT_WP_DASHBOARD = 'wpDashboard';
const VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY = 'wpDashboardViewOnly';
const VIEW_CONTEXT_MODULE_SETUP = 'moduleSetup';
const VIEW_CONTEXT_METRIC_SELECTION = 'metricSelection';
const VIEW_CONTEXT_WP_BLOCK_EDITOR = 'wpBlockEditor';
const VIEW_CONTEXT_KEY_METRICS_SETUP = 'keyMetricsSetup';

// Anchor ID Constants
const ANCHOR_ID_KEY_METRICS = 'key-metrics';
const ANCHOR_ID_TRAFFIC = 'traffic';
const ANCHOR_ID_CONTENT = 'content';
const ANCHOR_ID_SPEED = 'speed';
const ANCHOR_ID_MONETIZATION = 'monetization';

// Site Kit only view contexts
const SITE_KIT_VIEW_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD, VIEW_CONTEXT_ENTITY_DASHBOARD, VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_USER_INPUT, VIEW_CONTEXT_SPLASH, VIEW_CONTEXT_SETTINGS, VIEW_CONTEXT_MODULE_SETUP, VIEW_CONTEXT_METRIC_SELECTION];

// Site Kit view-only contexts
const SITE_KIT_VIEW_ONLY_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY, VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/data/create-error-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-error-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   createErrorStore: () => (/* binding */ createErrorStore),
/* harmony export */   generateErrorKey: () => (/* binding */ generateErrorKey)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */


const RECEIVE_ERROR = 'RECEIVE_ERROR';
const CLEAR_ERROR = 'CLEAR_ERROR';
const CLEAR_ERRORS = 'CLEAR_ERRORS';

/**
 * Internal dependencies
 */


function generateErrorKey(baseName, args) {
  if (args && Array.isArray(args)) {
    const stringifiedArgs = args.map(item => {
      return 'object' === typeof item ? (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringifyObject)(item) : item;
    });
    return `${baseName}::${md5__WEBPACK_IMPORTED_MODULE_1___default()(JSON.stringify(stringifiedArgs))}`;
  }
  return baseName;
}
const actions = {
  receiveError(error, baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(error, 'error is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: RECEIVE_ERROR,
      payload: {
        error,
        baseName,
        args
      }
    };
  },
  clearError(baseName, args = []) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(args && Array.isArray(args), 'args must be an array.');
    return {
      type: CLEAR_ERROR,
      payload: {
        baseName,
        args
      }
    };
  },
  clearErrors(baseName) {
    return {
      type: CLEAR_ERRORS,
      payload: {
        baseName
      }
    };
  }
};
function createErrorStore(storeName) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName must be defined.');
  const initialState = {
    errors: {},
    errorArgs: {}
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case RECEIVE_ERROR:
        {
          const {
            baseName,
            args,
            error
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          state.errors[key] = error;
          state.errorArgs[key] = args;
          break;
        }
      case CLEAR_ERROR:
        {
          const {
            baseName,
            args
          } = payload;
          const key = generateErrorKey(baseName, args);
          state.errors = state.errors || {};
          state.errorArgs = state.errorArgs || {};
          delete state.errors[key];
          delete state.errorArgs[key];
          break;
        }
      case CLEAR_ERRORS:
        {
          const {
            baseName
          } = payload;
          if (baseName) {
            state.errors = state.errors || {};
            state.errorArgs = state.errorArgs || {};
            for (const key in state.errors) {
              if (key === baseName || key.startsWith(`${baseName}::`)) {
                delete state.errors[key];
                delete state.errorArgs[key];
              }
            }
          } else {
            state.errors = {};
            state.errorArgs = {};
          }
          break;
        }
    }
  });
  const controls = {};
  const resolvers = {};
  const selectors = {
    /**
     * Retrieves the error object from state.
     *
     * Error object has the format:
     *
     * ```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state        Data store's state.
     * @param {string}      selectorName Selector name.
     * @param {Array.<any>} [args]       Arguments passed to selector (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForSelector(state, selectorName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(selectorName, 'selectorName is required.');
      return selectors.getError(state, selectorName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      actionName Action name.
     * @param {Array.<any>} [args]     Arguments passed to action (default `[]`).
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getErrorForAction(state, actionName, args = []) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(actionName, 'actionName is required.');
      return selectors.getError(state, actionName, args);
    },
    /**
     * Retrieves the error object from state.
     *
     *```
     * {
     *   code: <String>,
     *   message: <String>,
     *   data: <Object>
     * }
     * ```
     *
     * @since 1.15.0
     * @private
     *
     * @param {Object}      state      Data store's state.
     * @param {string}      [baseName] Selector or action name.
     * @param {Array.<any>} [args]     Arguments array.
     * @return {(Object|undefined)} Error object if exists, otherwise undefined.
     */
    getError(state, baseName, args) {
      const {
        errors
      } = state;
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
      return errors[generateErrorKey(baseName, args)];
    },
    /**
     * Gets a list of all unique errors.
     *
     * @since 1.19.0
     *
     * @param {Object} state Data store's state.
     * @return {Object[]} Unique set of errors.
     */
    getErrors(state) {
      const errorsSet = new Set(Object.values(state.errors));
      return Array.from(errorsSet);
    },
    /**
     * Gets the meta-data for a given error object, or null if the error is not found.
     *
     * Returns meta-data in the format:
     *
     * ```
     *	{
     *		baseName: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.84.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Meta-data for the given error object, or null if the error is not found.
     */
    getMetaDataForError(state, error) {
      const key = Object.keys(state.errors).find(errorKey => state.errors[errorKey] === error);
      if (key) {
        const baseName = key.substring(0, key.indexOf('::'));
        return {
          baseName,
          args: state.errorArgs[key]
        };
      }
      return null;
    },
    /**
     * Gets the selector data for a given error object, or null if no selector data is available.
     *
     * Returns selector data in the format:
     *
     * ```
     *	{
     *		storeName: <string>,
     *		name: <string>,
     *		args: <Array>
     *	}
     * ```
     *
     * @since 1.87.0
     *
     * @param {Object} state Data store's state.
     * @param {Object} error Error object.
     * @return {Object|null} Selector data for the given error object, or null if no selector data is available.
     */
    getSelectorDataForError: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.createRegistrySelector)(select => function (state, error) {
      const metaData = select(storeName).getMetaDataForError(error);
      if (metaData) {
        const {
          baseName: name,
          args
        } = metaData;
        const isSelector = !!select(storeName)[name];
        if (isSelector) {
          return {
            storeName,
            name,
            args
          };
        }
      }
      return null;
    }),
    /**
     * Determines whether the datastore has errors or not.
     *
     * @since 1.15.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} TRUE if the datastore has errors, otherwise FALSE.
     */
    hasErrors(state) {
      return selectors.getErrors(state).length > 0;
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-existing-tag-store.js":
/*!************************************************************!*\
  !*** ./js/googlesitekit/data/create-existing-tag-store.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createExistingTagStore: () => (/* binding */ createExistingTagStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_util_tag__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/tag */ "./js/util/tag.js");
/**
 * Provides a datastore for getting existing tags
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




// Actions
const FETCH_GET_EXISTING_TAG = 'FETCH_GET_EXISTING_TAG';
const RECEIVE_GET_EXISTING_TAG = 'RECEIVE_GET_EXISTING_TAG';

/**
 * Creates a store object that includes actions and selectors for getting existing tags.
 *
 * @since 1.13.0
 * @private
 *
 * @param {Object}   args             Arguments for the store generation.
 * @param {string}   args.storeName   Store name to use.
 * @param {Array}    args.tagMatchers The tag matchers used to extract tags from HTML.
 * @param {Function} args.isValidTag  Function to test whether a tag is valid or not.
 * @return {Object} The existing tag store object, with additional `STORE_NAME` and
 * initialState` properties.
 */
function createExistingTagStore({
  storeName: STORE_NAME,
  isValidTag,
  tagMatchers
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('string' === typeof STORE_NAME && STORE_NAME, 'storeName is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof isValidTag, 'isValidTag must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(tagMatchers), 'tagMatchers must be an Array.');
  const initialState = {
    existingTag: undefined
  };
  const actions = {
    fetchGetExistingTag() {
      return {
        payload: {},
        type: FETCH_GET_EXISTING_TAG
      };
    },
    receiveGetExistingTag(existingTag) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(existingTag === null || 'string' === typeof existingTag, 'existingTag must be a tag string or null.');
      return {
        payload: {
          existingTag: isValidTag(existingTag) ? existingTag : null
        },
        type: RECEIVE_GET_EXISTING_TAG
      };
    }
  };
  const controls = {
    [FETCH_GET_EXISTING_TAG]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => async () => {
      const homeURL = registry.select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getHomeURL();
      const ampMode = registry.select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getAMPMode();
      const existingTagURLs = await (0,_js_util_tag__WEBPACK_IMPORTED_MODULE_3__.getExistingTagURLs)({
        homeURL,
        ampMode
      });
      const {
        getHTMLForURL
      } = registry.resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE);
      for (const url of existingTagURLs) {
        const html = await getHTMLForURL(url);
        const tagFound = (0,_js_util_tag__WEBPACK_IMPORTED_MODULE_3__.extractExistingTag)(html, tagMatchers);
        if (tagFound) {
          return tagFound;
        }
      }
      return null;
    })
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case RECEIVE_GET_EXISTING_TAG:
        {
          const {
            existingTag
          } = payload;
          state.existingTag = existingTag;
          break;
        }
    }
  });
  const resolvers = {
    *getExistingTag() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();
      if (registry.select(STORE_NAME).getExistingTag() === undefined) {
        const existingTag = yield actions.fetchGetExistingTag();
        registry.dispatch(STORE_NAME).receiveGetExistingTag(existingTag);
      }
    }
  };
  const selectors = {
    /**
     * Gets the existing tag, if any.
     *
     * @since 1.13.0
     *
     * @param {Object} state Data store's state.
     * @return {(string|null|undefined)} The existing tag `string` if present, `null` if not present, or `undefined` if not loaded yet.
     */
    getExistingTag(state) {
      return state.existingTag;
    },
    /**
     * Checks whether or not an existing tag is present.
     *
     * @since 1.13.0
     *
     * @return {(boolean|undefined)} Boolean if tag is present, `undefined` if tag presence has not been resolved yet.
     */
    hasExistingTag: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => () => {
      const existingTag = select(STORE_NAME).getExistingTag();
      if (existingTag === undefined) {
        return undefined;
      }
      return !!existingTag;
    })
  };
  const store = {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  };
  return {
    ...store,
    STORE_NAME
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-fetch-store.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data/create-fetch-store.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createFetchStore: () => (/* binding */ createFetchStore)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _create_error_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/* harmony import */ var _transform_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__);
/**
 * API function to create fetch store.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function defaultReducerCallback(state) {
  return state;
}
function defaultArgsToParams() {
  return {};
}
function defaultValidateParams() {}

// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _create_error_store__WEBPACK_IMPORTED_MODULE_2__.actions;

/**
 * Creates a store object implementing the necessary infrastructure for a
 * single fetch action.
 *
 * This function returns a partial store object with the following:
 * - action creators to fetch and to receive the data
 * - control to issue the API request
 * - reducer to set API request flag and receive the response
 * - selector to check whether the API request is in progress via a flag
 *
 * The names of the pieces are based on the baseName provided.
 * For example, if baseName is 'saveSettings':
 * - The fetch action creator is called 'fetchSaveSettings'.
 * - The receive action creator is called 'receiveSaveSettings'.
 * - The fetching selector is called 'isFetchingSaveSettings'.
 *
 * All parts of the returned store objects should be considered internal. A
 * public action or selector should be implemented to actually call the
 * fetch action included in the returned store object.
 *
 * For example, if the fetch store is intended for an API-based
 * action 'storeMySetting':
 * - The basename passed should be 'storeMySetting'.
 * - The action 'storeMySetting' should call 'fetchStoreMySetting'.
 *
 * Or, if the fetch store is intended for an API-based selector
 * 'getSomeData':
 * - The baseName passed should be 'getSomeData'.
 * - The resolver for 'getSomeData' should call 'fetchGetSomeData'.
 *
 * @since 1.10.0
 * @private
 *
 * @param {Object}   args                   Arguments for creating the fetch store.
 * @param {string}   args.baseName          The base name to use for all the created infrastructure.
 * @param {Function} args.controlCallback   Callback function to issue the API request. Will be used inside the
 *                                          control. The function receives a params object based on argsToParams,
 *                                          i.e. the respective values passed to the action.
 * @param {Function} [args.reducerCallback] Optional. Callback function to modify state based on the API response.
 *                                          Will be used inside the reducer. The function receives the store's state
 *                                          object as first parameter, the API response as second parameter, and the
 *                                          params object for the request (see above) as third parameter. If not
 *                                          provided, the default will return the unmodified state.
 * @param {Function} [args.argsToParams]    Optional. Function that reduces the given list of arguments
 *                                          into a object of key/value parameters, with the argument names used as keys.
 *                                          If not provided, the default function will return an empty object,
 *                                          essentially indicating that no arguments are supported/required.
 * @param {Function} [args.validateParams]  Optional. Function that validates the given parameters object created by `argsToParams`.
 *                                          Any invalid parameters should cause a respective error to be thrown.
 * @return {Object} Partial store object with properties 'actions', 'controls', 'reducer', 'resolvers', and 'selectors'.
 */
function createFetchStore({
  baseName,
  controlCallback,
  reducerCallback = defaultReducerCallback,
  argsToParams = defaultArgsToParams,
  validateParams = defaultValidateParams
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(baseName, 'baseName is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof controlCallback, 'controlCallback is required and must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof reducerCallback, 'reducerCallback must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof argsToParams, 'argsToParams must be a function.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()('function' === typeof validateParams, 'validateParams must be a function.');

  // If validating the result of argsToParams without any arguments does not result in an error, we
  // know params is okay to be empty.
  let requiresParams;
  try {
    validateParams(argsToParams());
    requiresParams = false;
  } catch (error) {
    requiresParams = true;
  }
  const pascalCaseBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToPascalCase)(baseName);
  const constantBaseName = (0,_transform_case__WEBPACK_IMPORTED_MODULE_3__.camelCaseToConstantCase)(baseName);
  const FETCH = `FETCH_${constantBaseName}`;
  const START_FETCH = `START_${FETCH}`;
  const FINISH_FETCH = `FINISH_${FETCH}`;
  const CATCH_FETCH = `CATCH_${FETCH}`;
  const RECEIVE = `RECEIVE_${constantBaseName}`;
  const fetchCreator = `fetch${pascalCaseBaseName}`;
  const receiveCreator = `receive${pascalCaseBaseName}`;
  const isFetching = `isFetching${pascalCaseBaseName}`;
  const initialState = {
    [isFetching]: {}
  };
  function* fetchGenerator(params, args) {
    let response;
    let error;
    yield {
      payload: {
        params
      },
      type: START_FETCH
    };
    yield clearError(baseName, args);
    try {
      response = yield {
        payload: {
          params
        },
        type: FETCH
      };
      yield actions[receiveCreator](response, params);
      yield {
        payload: {
          params
        },
        type: FINISH_FETCH
      };
    } catch (e) {
      error = e;
      yield receiveError(error, baseName, args);
      yield {
        payload: {
          params
        },
        type: CATCH_FETCH
      };
    }
    return {
      response,
      error
    };
  }
  const actions = {
    [fetchCreator](...args) {
      const params = argsToParams(...args);
      // In order for params validation to throw an error as expected,
      // this function cannot be a generator.
      validateParams(params);

      // The normal fetch action generator is invoked as the return here
      // to preserve asynchronous behavior without registering another action creator.
      return fetchGenerator(params, args);
    },
    [receiveCreator](response, params) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(response !== undefined, 'response is required.');
      if (requiresParams) {
        invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(params), 'params is required.');
        validateParams(params);
      } else {
        params = {};
      }
      return {
        payload: {
          response,
          params
        },
        type: RECEIVE
      };
    }
  };
  const controls = {
    [FETCH]: ({
      payload
    }) => {
      return controlCallback(payload.params);
    }
  };
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_5__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case START_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = true;
          return state;
        }
      case RECEIVE:
        {
          const {
            response,
            params
          } = payload;
          return reducerCallback(state, response, params);
        }
      case FINISH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      case CATCH_FETCH:
        {
          const {
            params
          } = payload;
          state[isFetching] = state[isFetching] || {};
          state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)] = false;
          return state;
        }
      default:
        return state;
    }
  });
  const selectors = {
    [isFetching]: (state, ...args) => {
      if (state[isFetching] === undefined) {
        return false;
      }
      let params;
      try {
        params = argsToParams(...args);
        validateParams(params);
      } catch (err) {
        // If parameters are invalid, fail silently here. It likely is
        // because some dependency selector is still resolving.
        return false;
      }
      return !!state[isFetching][(0,_js_util__WEBPACK_IMPORTED_MODULE_4__.stringifyObject)(params)];
    }
  };
  return {
    initialState,
    actions,
    controls,
    reducer,
    resolvers: {},
    selectors
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-settings-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-settings-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INVARIANT_DOING_SUBMIT_CHANGES: () => (/* binding */ INVARIANT_DOING_SUBMIT_CHANGES),
/* harmony export */   INVARIANT_SETTINGS_NOT_CHANGED: () => (/* binding */ INVARIANT_SETTINGS_NOT_CHANGED),
/* harmony export */   createSettingsStore: () => (/* binding */ createSettingsStore),
/* harmony export */   makeDefaultCanSubmitChanges: () => (/* binding */ makeDefaultCanSubmitChanges),
/* harmony export */   makeDefaultHaveSettingsChanged: () => (/* binding */ makeDefaultHaveSettingsChanged),
/* harmony export */   makeDefaultRollbackChanges: () => (/* binding */ makeDefaultRollbackChanges),
/* harmony export */   makeDefaultSubmitChanges: () => (/* binding */ makeDefaultSubmitChanges)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _transform_case__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./transform-case */ "./js/googlesitekit/data/transform-case.js");
/* harmony import */ var _create_fetch_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/data/create-error-store */ "./js/googlesitekit/data/create-error-store.js");
/**
 * Provides API functions to create a datastore for settings.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */







// Get access to error store action creators.
// If the parent store doesn't include the error store,
// yielded error actions will be a no-op.
const {
  clearError,
  receiveError
} = _js_googlesitekit_data_create_error_store__WEBPACK_IMPORTED_MODULE_7__.actions;

// Invariant error messages.
const INVARIANT_DOING_SUBMIT_CHANGES = 'cannot submit changes while submitting changes';
const INVARIANT_SETTINGS_NOT_CHANGED = 'cannot submit changes if settings have not changed';

// Actions
const SET_SETTINGS = 'SET_SETTINGS';
const ROLLBACK_SETTINGS = 'ROLLBACK_SETTINGS';
const ROLLBACK_SETTING = 'ROLLBACK_SETTING';

/**
 * Creates a store object that includes actions and selectors for managing settings.
 *
 * The first three parameters hook up the store to the respective REST API endpoint,
 * while the fourth defines the names of the sub-settings to support.
 *
 * @since 1.6.0
 * @since 1.129.0 Added haveSettingsChanged optional paramter.
 * @private
 *
 * @param {string}        type                                  The data to access. One of 'core' or 'modules'.
 * @param {string}        identifier                            The data identifier, eg. a module slug like `search-console`.
 * @param {string}        datapoint                             The endpoint to request data from, e.g. 'settings'.
 * @param {Object}        options                               Optional. Options to consider for the store.
 * @param {Array}         [options.ownedSettingsSlugs]          Optional. List of "owned settings" for this module, if they exist.
 * @param {number}        [options.storeName]                   Store name to use. Default is '{type}/{identifier}'.
 * @param {Array}         [options.settingSlugs]                List of the slugs that are part of the settings object handled by the respective API endpoint.
 * @param {Object}        [options.initialSettings]             Optional. An initial set of settings as key-value pairs.
 * @param {Function|null} [options.validateHaveSettingsChanged] Optional. Custom callback to determine if settings have changed.
 * @return {Object} The settings store object, with additional `STORE_NAME` and
 *                  `initialState` properties.
 */
function createSettingsStore(type, identifier, datapoint, {
  ownedSettingsSlugs = undefined,
  storeName = undefined,
  settingSlugs = [],
  initialSettings = undefined,
  validateHaveSettingsChanged = makeDefaultHaveSettingsChanged()
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(type, 'type is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(identifier, 'identifier is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(datapoint, 'datapoint is required.');
  const STORE_NAME = storeName || `${type}/${identifier}`;
  const initialState = {
    ownedSettingsSlugs,
    settings: initialSettings,
    savedSettings: undefined
  };
  const fetchGetSettingsStore = (0,_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
    baseName: 'getSettings',
    controlCallback: () => {
      return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.get)(type, identifier, datapoint, {}, {
        useCache: false
      });
    },
    reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, values) => {
      state.savedSettings = {
        ...values
      };
      state.settings = {
        ...values,
        // In case settings were already changed, they should take precedence.
        ...(state.settings || {})
      };
    })
  });
  const fetchSaveSettingsStore = (0,_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
    baseName: 'saveSettings',
    controlCallback: params => {
      const {
        values
      } = params;
      return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.set)(type, identifier, datapoint, values);
    },
    reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, values) => {
      state.savedSettings = {
        ...values
      };
      // Ensure client settings are refreshed from server.
      state.settings = {
        ...values
      };
    }),
    argsToParams: values => {
      return {
        values
      };
    },
    validateParams: ({
      values
    } = {}) => {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(values), 'values is required.');
    }
  });

  // This will be populated further down with reducer functions for individual settings.
  const settingReducers = {};
  const actions = {
    /**
     * Sets settings for the given values.
     *
     * @since 1.6.0
     *
     * @param {Object} values Settings with their values to set.
     * @return {Object} Redux-style action.
     */
    setSettings(values) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(values), 'values is required.');
      return {
        payload: {
          values
        },
        type: SET_SETTINGS
      };
    },
    /**
     * Returns the current settings back to the current saved values.
     *
     * @since 1.7.1
     * @private
     *
     * @return {Object} Redux-style action.
     */
    rollbackSettings() {
      return {
        payload: {},
        type: ROLLBACK_SETTINGS
      };
    },
    /**
     * Returns a specific setting back to the current saved value.
     *
     * @since 1.147.0
     *
     * @param {string} setting The setting to rollback.
     * @return {Object} Redux-style action.
     */
    rollbackSetting(setting) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(setting, 'setting is required.');
      return {
        payload: {
          setting
        },
        type: ROLLBACK_SETTING
      };
    },
    /**
     * Saves all current settings to the server.
     *
     * @since 1.6.0
     *
     * @return {Object} Response and error, if any.
     */
    *saveSettings() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
      yield clearError('saveSettings', []);
      const values = registry.select(STORE_NAME).getSettings();
      const {
        response,
        error
      } = yield fetchSaveSettingsStore.actions.fetchSaveSettings(values);
      if (error) {
        // Store error manually since saveSettings signature differs from fetchSaveSettings.
        yield receiveError(error, 'saveSettings', []);
      }
      return {
        response,
        error
      };
    }
  };
  const controls = {};

  // eslint-disable-next-line no-shadow
  const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createReducer)((state, {
    type,
    payload
  }) => {
    switch (type) {
      case SET_SETTINGS:
        {
          const {
            values
          } = payload;
          state.settings = {
            ...(state.settings || {}),
            ...values
          };
          break;
        }
      case ROLLBACK_SETTINGS:
        {
          state.settings = state.savedSettings;
          break;
        }
      case ROLLBACK_SETTING:
        {
          const {
            setting
          } = payload;
          if (state.savedSettings[setting]) {
            state.settings = {
              ...(state.settings || {}),
              [setting]: state.savedSettings[setting]
            };
          }
          break;
        }
      default:
        {
          // Check if this action is for a reducer for an individual setting.
          if ('undefined' !== typeof settingReducers[type]) {
            settingReducers[type](state, {
              type,
              payload
            });
          }
          break;
        }
    }
  });
  const resolvers = {
    *getSettings() {
      const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonActions.getRegistry();
      const existingSettings = registry.select(STORE_NAME).getSettings();
      // If settings are already present, don't fetch them.
      if (!existingSettings) {
        yield fetchGetSettingsStore.actions.fetchGetSettings();
      }
    }
  };
  const {
    safeSelector: haveSettingsChanged,
    dangerousSelector: __dangerousHaveSettingsChanged
  } = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.createValidationSelector)(validateHaveSettingsChanged);
  const selectors = {
    /**
     * Indicates whether the current settings have changed from what is saved.
     *
     * @since 1.6.0
     * @since 1.77.0 Added ability to filter settings using `keys` argument.
     * @since 1.129.0 Changed the approach to use validateHaveSettingsChanged callback.
     * @since 1.131.0 Updated implementation to use safeSelector and dangerousSelector returned from createValidationSelector.
     *
     * @param {Object}     state Data store's state.
     * @param {Array|null} keys  Settings keys to check; if not provided, all settings are checked.
     * @return {boolean} True if the settings have changed, false otherwise.
     */
    haveSettingsChanged,
    __dangerousHaveSettingsChanged,
    /**
     * Gets the current settings.
     *
     * Returns `undefined` if notifications are not available/loaded.
     *
     * @since 1.6.0
     *
     * @param {Object} state Data store's state.
     * @return {(Object|undefined)} Settings with their values, or undefined.
     */
    getSettings(state) {
      return state.settings;
    },
    /**
     * Indicates whether the provided setting has changed from what is saved.
     *
     * @since 1.72.0
     *
     * @param {Object} state   Data store's state.
     * @param {string} setting The setting we want to check for saved changes.
     * @return {boolean} True if the settings have changed, false otherwise.
     */
    hasSettingChanged(state, setting) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(setting, 'setting is required.');
      const {
        settings,
        savedSettings
      } = state;
      if (!settings || !savedSettings) {
        return false;
      }
      return !(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(settings[setting], savedSettings[setting]);
    },
    /**
     * Indicates whether saving the settings is currently in progress.
     *
     * @since 1.6.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} True if the settings are being saved, false otherwise.
     */
    isDoingSaveSettings(state) {
      // Since isFetchingSaveSettings (via createFetchStore)
      // holds information based on specific values but we only need
      // generic information here, we need to check whether ANY such
      // request is in progress.
      return Object.values(state.isFetchingSaveSettings).some(Boolean);
    },
    /**
     * Gets the owned settings slugs for this module.
     *
     * @since 1.77.0
     *
     * @param {Object} state Data store's state.
     * @return {Array|null} The array of owned settings slugs for this module if they exist. Returns `null` if no owned settings slugs exist.
     */
    getOwnedSettingsSlugs: state => {
      return state.ownedSettingsSlugs;
    },
    /**
     * Returns `true` if a module's "own settings" have changed; `false` if not.
     *
     * @since 1.77.0
     *
     * @param {Object} state Data store's state.
     * @return {boolean} `true` if the module's "own settings" have changed; `false` if not.
     */
    haveOwnedSettingsChanged: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
      const ownedSettingsSlugsToCheck = select(STORE_NAME).getOwnedSettingsSlugs();
      return select(STORE_NAME).haveSettingsChanged(ownedSettingsSlugsToCheck);
    })
  };

  // Define individual actions, selectors and related for sub-settings.
  settingSlugs.forEach(slug => {
    const pascalCaseSlug = (0,_transform_case__WEBPACK_IMPORTED_MODULE_5__.camelCaseToPascalCase)(slug);
    const constantSlug = (0,_transform_case__WEBPACK_IMPORTED_MODULE_5__.camelCaseToConstantCase)(slug);

    /**
     * Sets the setting indicated by the action name to the given value.
     *
     * @since 1.6.0
     *
     * @param {*} value Value for the setting.
     * @return {Object} Redux-style action.
     */
    actions[`set${pascalCaseSlug}`] = value => {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof value !== 'undefined', `value is required for calls to set${pascalCaseSlug}().`);
      return {
        payload: {
          value
        },
        type: `SET_${constantSlug}`
      };
    };
    settingReducers[`SET_${constantSlug}`] = (state, {
      payload
    }) => {
      const {
        value
      } = payload;
      state.settings = {
        ...(state.settings || {}),
        [slug]: value
      };
    };

    /**
     * Gets the current value for the setting indicated by the selector name.
     *
     * @since 1.6.0
     *
     * @return {*} Setting value, or undefined.
     */
    selectors[`get${pascalCaseSlug}`] = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => {
      const settings = select(STORE_NAME).getSettings() || {};
      return settings[slug];
    });
  });
  const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.commonStore, fetchGetSettingsStore, fetchSaveSettingsStore, {
    initialState,
    actions,
    controls,
    reducer,
    resolvers,
    selectors
  });
  return {
    ...store,
    STORE_NAME
  };
}

/**
 * Creates a default submitChanges control function.
 *
 * @since 1.21.0
 *
 * @param {string} slug      Module slug.
 * @param {string} storeName Datastore slug.
 * @return {Function} Control function to submit changes.
 */
function makeDefaultSubmitChanges(slug, storeName) {
  return async ({
    select,
    dispatch
  }) => {
    if (select(storeName).haveSettingsChanged()) {
      const {
        error
      } = await dispatch(storeName).saveSettings();
      if (error) {
        return {
          error
        };
      }
    }
    await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.invalidateCache)('modules', slug);
    return {};
  };
}

/**
 * Creates a default rollbackChanges control function.
 *
 * @since 1.45.0
 *
 * @param {string} storeName Datastore slug.
 * @return {Function} Control function to rollback settings changes.
 */
function makeDefaultRollbackChanges(storeName) {
  return ({
    select,
    dispatch
  }) => {
    if (select(storeName).haveSettingsChanged()) {
      return dispatch(storeName).rollbackSettings();
    }
    return {};
  };
}

/**
 * Creates a default canSubmitChanges function.
 *
 * @since 1.21.0
 *
 * @param {string} storeName Datastore slug.
 * @return {Function} A function to check if settings can be submitted.
 */
function makeDefaultCanSubmitChanges(storeName) {
  return select => {
    const strictSelect = (0,_utils__WEBPACK_IMPORTED_MODULE_4__.createStrictSelect)(select);
    const {
      haveSettingsChanged,
      isDoingSubmitChanges
    } = strictSelect(storeName);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(!isDoingSubmitChanges(), INVARIANT_DOING_SUBMIT_CHANGES);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(haveSettingsChanged(), INVARIANT_SETTINGS_NOT_CHANGED);
  };
}

/**
 * Creates Default haveSettingsChanged.
 *
 * @since 1.129.0
 *
 * @return {boolean} True if the settings have changed, false otherwise.
 */
function makeDefaultHaveSettingsChanged() {
  return (select, state, keys) => {
    const {
      settings,
      savedSettings
    } = state;
    if (keys) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()(!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)((0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(settings, keys), (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(savedSettings, keys)), INVARIANT_SETTINGS_NOT_CHANGED);
    }
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(settings, savedSettings), INVARIANT_SETTINGS_NOT_CHANGED);
  };
}

/***/ }),

/***/ "./js/googlesitekit/data/create-snapshot-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-snapshot-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSnapshotStore: () => (/* binding */ createSnapshotStore),
/* harmony export */   getStoresWithSnapshots: () => (/* binding */ getStoresWithSnapshots),
/* harmony export */   restoreAllSnapshots: () => (/* binding */ restoreAllSnapshots),
/* harmony export */   snapshotAllStores: () => (/* binding */ snapshotAllStores)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Provides a datastore for snapshotting and restoring state.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




// Actions
const CREATE_SNAPSHOT = 'CREATE_SNAPSHOT';
const DELETE_SNAPSHOT = 'DELETE_SNAPSHOT';
const RESTORE_SNAPSHOT = 'RESTORE_SNAPSHOT';
const SET_STATE_FROM_SNAPSHOT = 'SET_STATE_FROM_SNAPSHOT';

/**
 * Creates a store object that includes actions and controls for restoring/creating state snapshots.
 *
 * @since 1.9.0
 * @since 1.163.0 Added the ability to pick specific parts of the state to save in the snapshot.
 * @private
 *
 * @param {string}          storeName                The name of the store to snapshot in the cache.
 * @param {Object}          [options]                Optional configuration object.
 * @param {string|string[]} [options.keysToSnapshot] Property path(s) to pick from state when creating snapshots.
 * @return {Object} The snapshot store object.
 */
function createSnapshotStore(storeName, {
  keysToSnapshot
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required to create a snapshot store.');
  const initialState = {};
  const actions = {
    /**
     * Deletes a snapshot of state for a storeName, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache deletion response.
     */
    *deleteSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: DELETE_SNAPSHOT
      };
      return cacheResult;
    },
    /**
     * Restores a snapshot of state for a storeName, if available, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @param {Object}  [options]                   Options object.
     * @param {boolean} [options.clearAfterRestore] Whether or not to delete snapshot after restore. Default: true.
     * @return {boolean} Cache restoration response.
     */
    *restoreSnapshot(options = {}) {
      const {
        clearAfterRestore = true
      } = options;
      const {
        cacheHit,
        value
      } = yield {
        payload: {},
        type: RESTORE_SNAPSHOT
      };
      if (cacheHit) {
        yield {
          payload: {
            snapshot: value
          },
          type: SET_STATE_FROM_SNAPSHOT
        };
        if (clearAfterRestore) {
          yield {
            payload: {},
            type: DELETE_SNAPSHOT
          };
        }
      }
      return cacheHit;
    },
    /**
     * Creates a snapshot of the current state of this store, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache write response.
     */
    *createSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: CREATE_SNAPSHOT
      };
      return cacheResult;
    }
  };
  const controls = {
    [DELETE_SNAPSHOT]: () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.deleteItem)(`datastore::cache::${storeName}`);
    },
    [CREATE_SNAPSHOT]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistryControl)(registry => () => {
      const state = registry.stores[storeName].store.getState();
      const stateToSnapshot = keysToSnapshot?.length > 0 ? (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(state, keysToSnapshot) : state;
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.setItem)(`datastore::cache::${storeName}`, stateToSnapshot);
    }),
    [RESTORE_SNAPSHOT]: () => {
      // Only get snapshots made within the last hour.
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.getItem)(`datastore::cache::${storeName}`, _js_util__WEBPACK_IMPORTED_MODULE_4__.HOUR_IN_SECONDS);
    }
  };
  function reducer(state = initialState, {
    type,
    payload
  }) {
    // eslint-disable-line no-shadow
    switch (type) {
      case SET_STATE_FROM_SNAPSHOT:
        {
          const {
            snapshot
          } = payload;
          // Exclude any top-level errors from the restored state.
          // eslint-disable-next-line no-unused-vars
          const {
            error,
            ...newState
          } = snapshot;

          // If only a part of the state has been added to the snapshot, then
          // we should update the initial state with partial data restored
          // from the snapshot.
          if (keysToSnapshot?.length > 0) {
            return {
              ...state,
              ...newState
            };
          }
          return newState;
        }
      default:
        {
          return state;
        }
    }
  }
  return {
    initialState,
    actions,
    controls,
    reducer
  };
}

/**
 * Inspects a registry to find all stores that support our snapshot features.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} registry Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Object} The snapshot store object.
 */
function getStoresWithSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Object.values(registry.stores).filter(store => {
    return Object.keys(store.getActions()).includes('restoreSnapshot');
  });
}

/**
 * Creates snapshots of all supporting stores.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been taken.
 */
function snapshotAllStores(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().createSnapshot();
  }));
}

/**
 * Restores state for all snapshots that support it.
 *
 * Only restores snapshots for stores that have `restoreSnapshot` action, and
 * clears the snapshot afterward, so more stores will not be restored unless
 * a snapshot was saved on the last pageview.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been restored.
 */
function restoreAllSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().restoreSnapshot();
  }));
}

/***/ }),

/***/ "./js/googlesitekit/data/transform-case.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/data/transform-case.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   camelCaseToConstantCase: () => (/* binding */ camelCaseToConstantCase),
/* harmony export */   camelCaseToPascalCase: () => (/* binding */ camelCaseToPascalCase),
/* harmony export */   hyphenCaseToPascalCase: () => (/* binding */ hyphenCaseToPascalCase)
/* harmony export */ });
/**
 * Data store utilities for transforming names to a certain case.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Transforms a camelCase name into its PascalCase name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} PascalCase name.
 */
function camelCaseToPascalCase(name) {
  return name.charAt(0).toUpperCase() + name.slice(1);
}

/**
 * Transforms a camelCase name into its CONSTANT_CASE name.
 *
 * @since 1.10.0
 * @private
 *
 * @param {string} name "camelCase" name to transform.
 * @return {string} CONSTANT_CASE name.
 */
function camelCaseToConstantCase(name) {
  return name.replace(/([a-z0-9]{1})([A-Z]{1})/g, '$1_$2').toUpperCase();
}

/**
 * Transforms a hyphen-case name into its PascalCase name.
 *
 * @since 1.30.0
 * @private
 *
 * @param {string} name "hyphen-case" name to transform.
 * @return {string} PascalCase name.
 */
function hyphenCaseToPascalCase(name) {
  return name.split('-').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join('');
}

/***/ }),

/***/ "./js/googlesitekit/data/utils.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   collect: () => (/* binding */ collect),
/* harmony export */   collectActions: () => (/* binding */ collectActions),
/* harmony export */   collectControls: () => (/* binding */ collectControls),
/* harmony export */   collectName: () => (/* binding */ collectName),
/* harmony export */   collectReducers: () => (/* binding */ collectReducers),
/* harmony export */   collectResolvers: () => (/* binding */ collectResolvers),
/* harmony export */   collectSelectors: () => (/* binding */ collectSelectors),
/* harmony export */   collectState: () => (/* binding */ collectState),
/* harmony export */   combineStores: () => (/* binding */ combineStores),
/* harmony export */   commonActions: () => (/* binding */ commonActions),
/* harmony export */   commonControls: () => (/* binding */ commonControls),
/* harmony export */   commonStore: () => (/* binding */ commonStore),
/* harmony export */   createStrictSelect: () => (/* binding */ createStrictSelect),
/* harmony export */   createValidatedAction: () => (/* binding */ createValidatedAction),
/* harmony export */   createValidationSelector: () => (/* binding */ createValidationSelector)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/**
 * Data store utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */

const GET_REGISTRY = 'GET_REGISTRY';
const AWAIT = 'AWAIT';

/**
 * Collects and combines multiple objects of similar shape.
 *
 * Used to combine objects like actions, selectors, etc. for a data
 * store while ensuring no keys/action names/selector names are duplicated.
 *
 * Effectively this is an object spread, but throws an error if keys are
 * duplicated.
 *
 * @since 1.5.0
 * @private
 *
 * @param {...Object} items A list of arguments, each one should be an object to combine into one.
 * @return {Object} The combined object.
 */
function collect(...items) {
  const collectedObject = items.reduce((acc, item) => {
    return {
      ...acc,
      ...item
    };
  }, {});
  const functionNames = items.reduce((acc, itemSet) => {
    return [...acc, ...Object.keys(itemSet)];
  }, []);
  const duplicates = findDuplicates(functionNames);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === 0, `collect() cannot accept collections with duplicate keys. Your call to collect() contains the following duplicated functions: ${duplicates.join(', ')}. Check your data stores for duplicates.`);
  return collectedObject;
}

/**
 * Collects all actions.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own actions.
 * @return {Object} The combined object.
 */
const collectActions = collect;

/**
 * Collects all controls.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own controls.
 * @return {Object} The combined object.
 */
const collectControls = collect;

/**
 * Collects all reducers and (optionally) provides initial state.
 *
 * If the first argument passed is not a function, it will be used as the
 * combined reducer's `initialState`.
 *
 * @since 1.5.0
 *
 * @param {...(Object|Function)} args A list of reducers, each containing their own controls. If the first argument is not a function, it will be used as the combined reducer's `initialState`.
 * @return {Function} A Redux-style reducer.
 */
function collectReducers(...args) {
  const reducers = [...args];
  let initialState;
  if (typeof reducers[0] !== 'function') {
    initialState = reducers.shift();
  }
  return (state = initialState, action = {}) => {
    return reducers.reduce((newState, reducer) => {
      return reducer(newState, action);
    }, state);
  };
}

/**
 * Collects all resolvers.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own resolvers.
 * @return {Object} The combined object.
 */
const collectResolvers = collect;

/**
 * Collects all selectors.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own selectors.
 * @return {Object} The combined object.
 */
const collectSelectors = collect;

/**
 * Collects all state values.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own state values.
 * @return {Object} The combined object.
 */
const collectState = collect;

/**
 * Collects all store names.
 *
 * This function's main purpose is to ensure generated store names for a single store match.
 *
 * @since 1.6.0
 *
 * @param {...string} args A list of store names, all of which must be equal.
 * @return {string} The single store name.
 */
function collectName(...args) {
  const names = [...args];
  const duplicates = findDuplicates(names);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === names.length - 1, 'collectName() must not receive different names.');
  return names.shift();
}

/**
 * Passes through state unmodified; eg. an empty reducer.
 *
 * @since 1.8.0
 * @private
 *
 * @param {Object} state A store's state.
 * @return {Object} The same state data as passed in `state`.
 */
function passthroughReducer(state) {
  return state;
}

/**
 * Combines multiple stores.
 *
 * @since 1.8.0
 *
 * @param {...Object} stores A list of objects, each a store containing one or more of the following keys: initialState, actions, controls, reducer, resolvers, selectors.
 * @return {Object} The combined store.
 */
function combineStores(...stores) {
  const combinedInitialState = collectState(...stores.map(store => store.initialState || {}));
  return {
    initialState: combinedInitialState,
    controls: collectControls(...stores.map(store => store.controls || {})),
    actions: collectActions(...stores.map(store => store.actions || {})),
    reducer: collectReducers(combinedInitialState, ...stores.map(store => store.reducer || passthroughReducer)),
    resolvers: collectResolvers(...stores.map(store => store.resolvers || {})),
    selectors: collectSelectors(...stores.map(store => store.selectors || {}))
  };
}

/**
 * An object of common actions most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common actions most stores will want.
 */
const commonActions = {
  /**
   * Dispatches an action and calls a control to get the current data registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  getRegistry() {
    return {
      payload: {},
      type: GET_REGISTRY
    };
  },
  /**
   * Dispatches an action and calls a control to return the promise resolution.
   *
   * Useful for controls and resolvers that wish to call an asynchronous function or other promise.
   *
   * @since 1.22.0
   *
   * @param {Promise} value A promise to resolve.
   * @return {Object} Object with resolved promise.
   */
  *await(value) {
    return {
      payload: {
        value
      },
      type: AWAIT
    };
  }
};

/**
 * An object of common controls most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common controls most stores will want.
 */
const commonControls = {
  /**
   * Returns the current registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  [GET_REGISTRY]: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistryControl)(registry => () => registry),
  /**
   * Returns a resolved promise.
   *
   * @since 1.22.0
   *
   * @param {Object} payload         Object containing a promise.
   * @param {Object} payload.payload Object containing a promise.
   * @return {*} Resolved promise.
   */
  [AWAIT]: ({
    payload
  }) => payload.value
};

/**
 * Finds all duplicate items in an array and return them.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} array Any array.
 * @return {Array} All values in the input array that were duplicated.
 */
function findDuplicates(array) {
  const duplicates = [];
  const counts = {};
  for (let i = 0; i < array.length; i++) {
    const item = array[i];
    counts[item] = counts[item] >= 1 ? counts[item] + 1 : 1;
    if (counts[item] > 1) {
      duplicates.push(item);
    }
  }
  return duplicates;
}

/**
 * A store containing the common actions, controls and reducer that all stores will use.
 *
 * @since 1.8.0
 *
 * @return {Object} Object with common actions, controls and reducer.
 */
const commonStore = {
  actions: commonActions,
  controls: commonControls,
  reducer: passthroughReducer
};

/**
 * Creates a strict version of registry.select for ensuring that a selector is resolved at the time of calling.
 *
 * Not intended to be used directly. This is useful in the context of validation functions
 * to save checking for undefined on every result.
 *
 * Given the registry.select function instance, a new function is returned
 * with the same API as `select()` but will throw an error if the result
 * of the selector function is `undefined`.
 *
 * Ideally this would use something like `hasFinishedResolution` instead,
 * but there is no way to traverse the selectors used internally to identify
 * dependent selectors that have resolvers as many selectors are composed of
 * higher-level selectors internally which is where a resolver is normally implemented.
 *
 * @since 1.18.0
 * @private
 *
 * @param {Function} select The registry.select function.
 * @return {Function} The strict version of registry.select.
 */
function createStrictSelect(select) {
  return storeName => {
    return getStrictSelectors(select(storeName));
  };
}

// Based on {@link https://github.com/WordPress/gutenberg/blob/b1c8026087dfb026eff0a023a5f7febe28c876de/packages/data/src/registry.js#L91}
const getStrictSelectors = memize__WEBPACK_IMPORTED_MODULE_1___default()(selectors => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.mapValues)(selectors, (selector, selectorName) => (...args) => {
  const returnValue = selector(...args);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(returnValue !== undefined, `${selectorName}(...) is not resolved`);
  return returnValue;
}));

/**
 * Creates two registry selectors that call the incoming function to validate the current state.
 *
 * @since 1.19.0
 *
 * @param {Function} validate         Validation function callback.
 * @param {Object}   [options]        Options to modify the behavior of the generated selectors.
 * @param {boolean}  [options.negate] Whether to negate the boolean result or not. Default: false.
 * @return {Object} Safe and dangerous selectors.
 */
function createValidationSelector(validate, {
  negate = false
} = {}) {
  const safeSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    const pass = negate ? false : true;
    const fail = negate ? true : false;
    try {
      validate(select, state, ...args);
      return pass;
    } catch {
      return fail;
    }
  });
  const dangerousSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    validate(select, state, ...args);
  });
  return {
    safeSelector,
    dangerousSelector
  };
}

/**
 * Creates a validated action creator.
 *
 * @since 1.32.0
 *
 * @param {Function} validate      A function for validating action arguments.
 * @param {Function} actionCreator A function for returning or yielding redux-style actions.
 * @return {Function} An enhanced action creator.
 */
function createValidatedAction(validate, actionCreator) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof validate === 'function', 'a validator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof actionCreator === 'function', 'an action creator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(validate[Symbol.toStringTag] !== 'Generator' && validate[Symbol.toStringTag] !== 'GeneratorFunction', 'an action’s validator function must not be a generator.');
  return (...args) => {
    validate(...args);
    return actionCreator(...args);
  };
}

/***/ }),

/***/ "./js/googlesitekit/datastore/forms/constants.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/datastore/forms/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_FORMS: () => (/* binding */ CORE_FORMS)
/* harmony export */ });
/**
 * `core/forms` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_FORMS = 'core/forms';

/***/ }),

/***/ "./js/googlesitekit/datastore/location/constants.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/datastore/location/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_LOCATION: () => (/* binding */ CORE_LOCATION)
/* harmony export */ });
/**
 * `core/location` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_LOCATION = 'core/location';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   EMAIL_REPORT_FREQUENCIES: () => (/* binding */ EMAIL_REPORT_FREQUENCIES),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Email Report Frequency options.
const EMAIL_REPORT_FREQUENCIES = ['weekly', 'monthly', 'quarterly'];

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/notifications/constants.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/notifications/constants.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID: () => (/* binding */ GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID),
/* harmony export */   GTG_SETUP_CTA_BANNER_NOTIFICATION: () => (/* binding */ GTG_SETUP_CTA_BANNER_NOTIFICATION),
/* harmony export */   NOTIFICATION_AREAS: () => (/* binding */ NOTIFICATION_AREAS),
/* harmony export */   NOTIFICATION_GROUPS: () => (/* binding */ NOTIFICATION_GROUPS),
/* harmony export */   PRIORITY: () => (/* binding */ PRIORITY)
/* harmony export */ });
/**
 * Notifications API constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID = 'warning-notification-gtg';
const GTG_SETUP_CTA_BANNER_NOTIFICATION = 'gtg-setup-cta';
const PRIORITY = {
  ERROR_HIGH: 30,
  ERROR_LOW: 60,
  WARNING: 100,
  INFO: 150,
  SETUP_CTA_HIGH: 150,
  SETUP_CTA_LOW: 200
};
const NOTIFICATION_AREAS = {
  HEADER: 'notification-area-header',
  DASHBOARD_TOP: 'notification-area-dashboard-top',
  OVERLAYS: 'notification-area-overlays'
};
const NOTIFICATION_GROUPS = {
  DEFAULT: 'default',
  SETUP_CTAS: 'setup-ctas'
};

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/constants.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/constants.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_NOTIFICATIONS: () => (/* binding */ CORE_NOTIFICATIONS),
/* harmony export */   NOTIFICATION_VIEW_CONTEXTS: () => (/* binding */ NOTIFICATION_VIEW_CONTEXTS)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


const CORE_NOTIFICATIONS = 'core/notifications';
const NOTIFICATION_VIEW_CONTEXTS = [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_SPLASH, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/hooks/useBreakpoint.ts":
/*!***********************************!*\
  !*** ./js/hooks/useBreakpoint.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAKPOINT_DESKTOP: () => (/* binding */ BREAKPOINT_DESKTOP),
/* harmony export */   BREAKPOINT_SMALL: () => (/* binding */ BREAKPOINT_SMALL),
/* harmony export */   BREAKPOINT_TABLET: () => (/* binding */ BREAKPOINT_TABLET),
/* harmony export */   BREAKPOINT_XLARGE: () => (/* binding */ BREAKPOINT_XLARGE),
/* harmony export */   useBreakpoint: () => (/* binding */ useBreakpoint)
/* harmony export */ });
/* harmony import */ var _useWindowSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useWindowSize */ "./js/hooks/useWindowSize.ts");
/**
 * `useBreakpoint` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



/**
 * Breakpoint for an extra large screen (over `1280px` wide).
 */
const BREAKPOINT_XLARGE = 'xlarge';
/**
 * Breakpoint for a desktop screen (over `960px` wide).
 */
const BREAKPOINT_DESKTOP = 'desktop';
/**
 * Breakpoint for a tablet screen (over `600px` wide).
 */
const BREAKPOINT_TABLET = 'tablet';
/**
 * Breakpoint for a mobile phone screen (any screen `600px` wide or less).
 */
const BREAKPOINT_SMALL = 'small';

/**
 * Retrieves the current breakpoint.
 *
 * @since 1.29.0
 *
 * @return {string} The current breakpoint according to the window size.
 */
function useBreakpoint() {
  const windowWidth = (0,_useWindowSize__WEBPACK_IMPORTED_MODULE_0__.useWindowWidth)();
  if (windowWidth > 1280) {
    return BREAKPOINT_XLARGE;
  }
  if (windowWidth > 960) {
    return BREAKPOINT_DESKTOP;
  }
  if (windowWidth > 600) {
    return BREAKPOINT_TABLET;
  }
  return BREAKPOINT_SMALL;
}

/***/ }),

/***/ "./js/hooks/useFeature.js":
/*!********************************!*\
  !*** ./js/hooks/useFeature.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFeature: () => (/* binding */ useFeature)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_FeaturesProvider_FeaturesContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/FeaturesProvider/FeaturesContext */ "./js/components/FeaturesProvider/FeaturesContext.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Feature Flags hook.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Returns the enabled state of a feature flag.
 *
 * @since 1.25.0
 *
 * @param {string} feature The feature flag name to check enabled state for.
 * @return {boolean} `true` if the feature is enabled, `false` otherwise.
 */
function useFeature(feature) {
  const enabledFeatures = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useContext)(_js_components_FeaturesProvider_FeaturesContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return (0,_js_features__WEBPACK_IMPORTED_MODULE_1__.isFeatureEnabled)(feature, enabledFeatures);
}

/***/ }),

/***/ "./js/hooks/useFormValue.js":
/*!**********************************!*\
  !*** ./js/hooks/useFormValue.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFormValue)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/**
 * Form value hook.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the value of a form field.
 *
 * @since 1.160.0
 *
 * @param {string} formName The name of the form.
 * @param {string} key      The key of the form field.
 * @return {string|number|boolean|Array|Object|undefined} The value of the form field, or the default value if provided.
 */
function useFormValue(formName, key) {
  return (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["default"])(select => {
    const {
      getValue
    } = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_FORMS);
    return getValue(formName, key);
  }, [formName, key]);
}

/***/ }),

/***/ "./js/hooks/useViewContext.js":
/*!************************************!*\
  !*** ./js/hooks/useViewContext.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/**
 * `useViewContext` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Returns the current Site Kit viewing context, eg. "dashboard",
 * "entity dashboard", "view-only dashboard", etc.
 *
 * @since 1.74.0
 *
 * @return {string} The current "viewing context" value for the plugin.
 */
function useViewContext() {
  const viewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useContext)(_js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return viewContext;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useViewContext);

/***/ }),

/***/ "./js/hooks/useWindowSize.ts":
/*!***********************************!*\
  !*** ./js/hooks/useWindowSize.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useWindowHeight: () => (/* binding */ useWindowHeight),
/* harmony export */   useWindowSize: () => (/* binding */ useWindowSize),
/* harmony export */   useWindowWidth: () => (/* binding */ useWindowWidth)
/* harmony export */ });
/* harmony import */ var _react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @react-hook/throttle */ "../node_modules/@react-hook/throttle/dist/module/index.js");
/* harmony import */ var _react_hook_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-hook/event */ "../node_modules/@react-hook/event/dist/module/index.js");
/**
 * `useWindowSize` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Copied from https://github.com/jaredLunde/react-hook/blob/b8ac9515e26937e838a36a27001dc46c7f46a390/packages/window-size/throttled/src/index.tsx
// Modified to use global.innerWidth and global.innerHeight instead of document.documentElement.clientWidth and document.documentElement.clientHeight.

/**
 * External dependencies
 */


function getSize() {
  return [__webpack_require__.g.innerWidth, __webpack_require__.g.innerHeight];
}
function useWindowSize({
  fps = 60,
  leading = false,
  initialWidth = 0,
  initialHeight = 0
} = {}) {
  const [size, setThrottledSize] = (0,_react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__.useThrottle)(/* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);
  function setSize() {
    return setThrottledSize(getSize);
  }
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'resize', setSize);
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'orientationchange', setSize);
  return size;
}
function useWindowHeight(options = {}) {
  return useWindowSize(options)[1];
}
function useWindowWidth(options = {}) {
  return useWindowSize(options)[0];
}

/***/ }),

/***/ "./js/modules/analytics-4/constants.js":
/*!*********************************************!*\
  !*** ./js/modules/analytics-4/constants.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY: () => (/* binding */ ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY),
/* harmony export */   ACTIVATION_STEP_IN_PROGRESS: () => (/* binding */ ACTIVATION_STEP_IN_PROGRESS),
/* harmony export */   ACTIVATION_STEP_REMINDER: () => (/* binding */ ACTIVATION_STEP_REMINDER),
/* harmony export */   ACTIVATION_STEP_SETUP: () => (/* binding */ ACTIVATION_STEP_SETUP),
/* harmony export */   ACTIVATION_STEP_SUCCESS: () => (/* binding */ ACTIVATION_STEP_SUCCESS),
/* harmony export */   ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY: () => (/* binding */ ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY),
/* harmony export */   GA4_ACTIVATION_BANNER_STATE_KEY: () => (/* binding */ GA4_ACTIVATION_BANNER_STATE_KEY),
/* harmony export */   GA4_AUTO_SWITCH_DATE: () => (/* binding */ GA4_AUTO_SWITCH_DATE),
/* harmony export */   KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY: () => (/* binding */ KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY),
/* harmony export */   LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY: () => (/* binding */ LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY),
/* harmony export */   MODULE_SLUG_ANALYTICS_4: () => (/* binding */ MODULE_SLUG_ANALYTICS_4),
/* harmony export */   REPORT_ARGS_DATA_FILTERS_KEY: () => (/* binding */ REPORT_ARGS_DATA_FILTERS_KEY),
/* harmony export */   REPORT_ARGS_NAV_KEY: () => (/* binding */ REPORT_ARGS_NAV_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_DIMENSION_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_DIMENSION_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_METRIC_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_METRIC_KEY)
/* harmony export */ });
/**
 * GA4 module constants.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const ACTIVATION_STEP_REMINDER = 0;
const ACTIVATION_STEP_SETUP = 1;
const ACTIVATION_STEP_SUCCESS = 2;
const ACTIVATION_STEP_IN_PROGRESS = 3;
const ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY = 'activation-acknowledgement-tooltip-state';
const GA4_ACTIVATION_BANNER_STATE_KEY = 'ga4-activation-banner-state';
const ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY = 'enhanced-measurement-activation-banner-tooltip-state';
const LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY = 'enhanced-measurement-activation-banner-dismissed-item';
const REPORT_ARGS_SELECTED_METRIC_KEY = '_r.explorerCard..selmet';
const REPORT_ARGS_SELECTED_DIMENSION_KEY = '_r.explorerCard..seldim';
const REPORT_ARGS_DATA_FILTERS_KEY = '_r..dataFilters';
const REPORT_ARGS_NAV_KEY = '_r..nav';
const KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY = 'key-metrics-connect-ga4-cta-widget';

/**
 * Date that Site Kit will automatically switch to using GA4: September 25, 2023.
 *
 * With Site Kit's maximum date range being three months, once this period has passed since the UA cutoff date,
 * it will no longer be able to show any historical data for UA and will automatically switch to GA4.
 * For operational reasons, we automatically make the switch a few days before the three month cutoff point.
 *
 * @since 1.107.0
 * @see UA_CUTOFF_DATE.
 */
const GA4_AUTO_SWITCH_DATE = '2023-09-25';
const MODULE_SLUG_ANALYTICS_4 = 'analytics-4';

/***/ }),

/***/ "./js/modules/analytics-4/datastore/constants.js":
/*!*******************************************************!*\
  !*** ./js/modules/analytics-4/datastore/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCOUNT_CREATE: () => (/* binding */ ACCOUNT_CREATE),
/* harmony export */   AUDIENCE_FILTER_CLAUSE_TYPE_ENUM: () => (/* binding */ AUDIENCE_FILTER_CLAUSE_TYPE_ENUM),
/* harmony export */   AUDIENCE_FILTER_SCOPE_ENUM: () => (/* binding */ AUDIENCE_FILTER_SCOPE_ENUM),
/* harmony export */   AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX: () => (/* binding */ AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX),
/* harmony export */   AUDIENCE_SEGMENTATION_SETUP_FORM: () => (/* binding */ AUDIENCE_SEGMENTATION_SETUP_FORM),
/* harmony export */   AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE: () => (/* binding */ AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE),
/* harmony export */   AUDIENCE_TYPE_SORT_ORDER: () => (/* binding */ AUDIENCE_TYPE_SORT_ORDER),
/* harmony export */   CONVERSION_REPORTING_LEAD_EVENTS: () => (/* binding */ CONVERSION_REPORTING_LEAD_EVENTS),
/* harmony export */   CUSTOM_DIMENSION_DEFINITIONS: () => (/* binding */ CUSTOM_DIMENSION_DEFINITIONS),
/* harmony export */   DATE_RANGE_OFFSET: () => (/* binding */ DATE_RANGE_OFFSET),
/* harmony export */   EDIT_SCOPE: () => (/* binding */ EDIT_SCOPE),
/* harmony export */   ENHANCED_MEASUREMENT_ENABLED: () => (/* binding */ ENHANCED_MEASUREMENT_ENABLED),
/* harmony export */   ENHANCED_MEASUREMENT_FORM: () => (/* binding */ ENHANCED_MEASUREMENT_FORM),
/* harmony export */   ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER: () => (/* binding */ ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER),
/* harmony export */   ENUM_CONVERSION_EVENTS: () => (/* binding */ ENUM_CONVERSION_EVENTS),
/* harmony export */   FORM_ACCOUNT_CREATE: () => (/* binding */ FORM_ACCOUNT_CREATE),
/* harmony export */   FORM_CUSTOM_DIMENSIONS_CREATE: () => (/* binding */ FORM_CUSTOM_DIMENSIONS_CREATE),
/* harmony export */   FORM_SETUP: () => (/* binding */ FORM_SETUP),
/* harmony export */   GTM_SCOPE: () => (/* binding */ GTM_SCOPE),
/* harmony export */   MAX_WEBDATASTREAMS_PER_BATCH: () => (/* binding */ MAX_WEBDATASTREAMS_PER_BATCH),
/* harmony export */   MODULES_ANALYTICS_4: () => (/* binding */ MODULES_ANALYTICS_4),
/* harmony export */   PROPERTY_CREATE: () => (/* binding */ PROPERTY_CREATE),
/* harmony export */   PROVISIONING_SCOPE: () => (/* binding */ PROVISIONING_SCOPE),
/* harmony export */   RESOURCE_TYPES: () => (/* binding */ RESOURCE_TYPES),
/* harmony export */   RESOURCE_TYPE_AUDIENCE: () => (/* binding */ RESOURCE_TYPE_AUDIENCE),
/* harmony export */   RESOURCE_TYPE_CUSTOM_DIMENSION: () => (/* binding */ RESOURCE_TYPE_CUSTOM_DIMENSION),
/* harmony export */   RESOURCE_TYPE_PROPERTY: () => (/* binding */ RESOURCE_TYPE_PROPERTY),
/* harmony export */   SITE_KIT_AUDIENCE_DEFINITIONS: () => (/* binding */ SITE_KIT_AUDIENCE_DEFINITIONS),
/* harmony export */   UI_ACTIVE_ROW_INDEX: () => (/* binding */ UI_ACTIVE_ROW_INDEX),
/* harmony export */   UI_ALL_TRAFFIC_LOADED: () => (/* binding */ UI_ALL_TRAFFIC_LOADED),
/* harmony export */   UI_DIMENSION_COLOR: () => (/* binding */ UI_DIMENSION_COLOR),
/* harmony export */   UI_DIMENSION_NAME: () => (/* binding */ UI_DIMENSION_NAME),
/* harmony export */   UI_DIMENSION_VALUE: () => (/* binding */ UI_DIMENSION_VALUE),
/* harmony export */   WEBDATASTREAM_CREATE: () => (/* binding */ WEBDATASTREAM_CREATE)
/* harmony export */ });
/**
 * `modules/analytics-4` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_ANALYTICS_4 = 'modules/analytics-4';

// A special Account ID value used for the "Set up a new account" option.
const ACCOUNT_CREATE = 'account_create';

// A special Property ID value used for the "Set up a new property" option.
const PROPERTY_CREATE = 'property_create';
const WEBDATASTREAM_CREATE = 'webdatastream_create';
const FORM_SETUP = 'analyticsSetup';
const MAX_WEBDATASTREAMS_PER_BATCH = 10;

// Date range offset days for Analytics 4 report requests.
const DATE_RANGE_OFFSET = 0;
const GTM_SCOPE = 'https://www.googleapis.com/auth/tagmanager.readonly';
const ENHANCED_MEASUREMENT_FORM = 'enhanced-measurement-form';
const ENHANCED_MEASUREMENT_ENABLED = 'enhanced-measurement-enabled';
const ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER = 'enhanced-measurement-should-dismiss-activation-banner';

// Form ID for the account creation form.
const FORM_ACCOUNT_CREATE = 'analyticsAccountCreate';
const FORM_CUSTOM_DIMENSIONS_CREATE = 'analyticsCustomDimensionsCreate';

// OAuth scope required for provisioning a Google Analytics account.
const PROVISIONING_SCOPE = 'https://www.googleapis.com/auth/analytics.provision';
const EDIT_SCOPE = 'https://www.googleapis.com/auth/analytics.edit';

// Dashboard widget constants.
const UI_DIMENSION_NAME = 'dashboardAllTrafficWidgetDimensionName';
const UI_DIMENSION_COLOR = 'dashboardAllTrafficWidgetDimensionColor';
const UI_DIMENSION_VALUE = 'dashboardAllTrafficWidgetDimensionValue';
const UI_ACTIVE_ROW_INDEX = 'dashboardAllTrafficWidgetActiveRowIndex';
const UI_ALL_TRAFFIC_LOADED = 'dashboardAllTrafficWidgetLoaded';

// Note: names and descriptions are not translated as these are not surfaced in Site Kit
// and are also subject to hard limits on the length which would be unpredictable if translated.
// See https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1beta/properties.customDimensions#CustomDimension
const CUSTOM_DIMENSION_DEFINITIONS = {
  googlesitekit_post_date: {
    parameterName: 'googlesitekit_post_date',
    displayName: 'WordPress Post Date',
    description: 'Created by Site Kit: Date when a post was published',
    scope: 'EVENT'
  },
  googlesitekit_post_author: {
    parameterName: 'googlesitekit_post_author',
    displayName: 'WordPress Post Author',
    description: 'Created by Site Kit: WordPress name of the post author',
    scope: 'EVENT'
  },
  googlesitekit_post_categories: {
    parameterName: 'googlesitekit_post_categories',
    displayName: 'WordPress Post Categories',
    description: 'Created by Site Kit: Names of categories assigned to a post',
    scope: 'EVENT'
  },
  googlesitekit_post_type: {
    parameterName: 'googlesitekit_post_type',
    displayName: 'WordPress Post Type',
    description: 'Created by Site Kit: Content type of a post',
    scope: 'EVENT'
  }
};
const ENUM_CONVERSION_EVENTS = {
  ADD_TO_CART: 'add_to_cart',
  PURCHASE: 'purchase',
  SUBMIT_LEAD_FORM: 'submit_lead_form',
  GENERATE_LEAD: 'generate_lead',
  CONTACT: 'contact'
};
const CONVERSION_REPORTING_LEAD_EVENTS = [ENUM_CONVERSION_EVENTS.CONTACT, ENUM_CONVERSION_EVENTS.GENERATE_LEAD, ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM];

// Audience enums.
const AUDIENCE_FILTER_CLAUSE_TYPE_ENUM = {
  AUDIENCE_CLAUSE_TYPE_UNSPECIFIED: 'AUDIENCE_CLAUSE_TYPE_UNSPECIFIED',
  INCLUDE: 'INCLUDE',
  EXCLUDE: 'EXCLUDE'
};
const AUDIENCE_FILTER_SCOPE_ENUM = {
  AUDIENCE_FILTER_SCOPE_UNSPECIFIED: 'AUDIENCE_FILTER_SCOPE_UNSPECIFIED',
  AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT: 'AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT',
  AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION: 'AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION',
  AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS'
};
const SITE_KIT_AUDIENCE_DEFINITIONS = {
  'new-visitors': {
    description: 'People who visited the site for the first time',
    displayName: 'New visitors',
    membershipDurationDays: -1,
    // The longest duration, 540 days.
    filterClauses: [{
      clauseType: 'INCLUDE',
      simpleFilter: {
        scope: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS',
        filterExpression: {
          andGroup: {
            filterExpressions: [{
              orGroup: {
                filterExpressions: [{
                  dimensionOrMetricFilter: {
                    fieldName: 'newVsReturning',
                    stringFilter: {
                      matchType: 'EXACT',
                      value: 'new'
                    }
                  }
                }]
              }
            }, {
              orGroup: {
                filterExpressions: [{
                  notExpression: {
                    dimensionOrMetricFilter: {
                      fieldName: 'groupId',
                      stringFilter: {
                        matchType: 'EXACT',
                        value: 'created_by_googlesitekit:new_visitors'
                      }
                    }
                  }
                }]
              }
            }]
          }
        }
      }
    }]
  },
  'returning-visitors': {
    description: 'People who have visited your site at least once before',
    displayName: 'Returning visitors',
    membershipDurationDays: -1,
    // The longest duration, 540 days.
    filterClauses: [{
      clauseType: 'INCLUDE',
      simpleFilter: {
        scope: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS',
        filterExpression: {
          andGroup: {
            filterExpressions: [{
              orGroup: {
                filterExpressions: [{
                  dimensionOrMetricFilter: {
                    fieldName: 'newVsReturning',
                    stringFilter: {
                      matchType: 'EXACT',
                      value: 'returning'
                    }
                  }
                }]
              }
            }, {
              orGroup: {
                filterExpressions: [{
                  notExpression: {
                    dimensionOrMetricFilter: {
                      fieldName: 'groupId',
                      stringFilter: {
                        matchType: 'EXACT',
                        value: 'created_by_googlesitekit:returning_visitors'
                      }
                    }
                  }
                }]
              }
            }]
          }
        }
      }
    }]
  }
};
const AUDIENCE_SEGMENTATION_SETUP_FORM = 'audiencePermissionsSetup';
const AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE = 'audienceTileCustomDimensionCreate';
const AUDIENCE_TYPE_SORT_ORDER = {
  USER_AUDIENCE: 0,
  SITE_KIT_AUDIENCE: 1,
  DEFAULT_AUDIENCE: 2
};
const AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX = 'audience-selection-panel-expirable-new-badge-';
const RESOURCE_TYPE_AUDIENCE = 'audience';
const RESOURCE_TYPE_CUSTOM_DIMENSION = 'customDimension';
const RESOURCE_TYPE_PROPERTY = 'property';
const RESOURCE_TYPES = [RESOURCE_TYPE_AUDIENCE, RESOURCE_TYPE_CUSTOM_DIMENSION, RESOURCE_TYPE_PROPERTY];

/***/ }),

/***/ "./js/modules/analytics-4/utils/report-normalization.js":
/*!**************************************************************!*\
  !*** ./js/modules/analytics-4/utils/report-normalization.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizeReportOptions: () => (/* binding */ normalizeReportOptions)
/* harmony export */ });
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Analytics 4 report normalization utilities.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Normalizes report options.
 *
 * @since 1.94.0
 *
 * @param {Object} options Report options object.
 * @return {Object} Normalized options object.
 */
const normalizeReportOptions = memize__WEBPACK_IMPORTED_MODULE_0___default()(({
  metrics,
  dimensions,
  ...options
} = {}) => {
  return {
    metrics: normalizeMetrics(metrics),
    dimensions: normalizeDimensions(dimensions),
    ...options
  };
});
function normalizeMetrics(metrics) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.castArray)(metrics).map(metric => typeof metric === 'string' ? {
    name: metric
  } : metric).filter(metric => (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(metric));
}
function normalizeDimensions(dimensions) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.castArray)(dimensions).map(dimension => typeof dimension === 'string' ? {
    name: dimension
  } : dimension).filter(dimension => (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(dimension));
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/report-validation.js":
/*!***********************************************************!*\
  !*** ./js/modules/analytics-4/utils/report-validation.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidDimensionFilters: () => (/* binding */ isValidDimensionFilters),
/* harmony export */   isValidDimensions: () => (/* binding */ isValidDimensions),
/* harmony export */   isValidMetricFilters: () => (/* binding */ isValidMetricFilters),
/* harmony export */   isValidMetrics: () => (/* binding */ isValidMetrics),
/* harmony export */   isValidOrders: () => (/* binding */ isValidOrders)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util/report-validation */ "./js/util/report-validation.js");
/**
 * Analytics 4 reporting API validation utilities.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint complexity: [ "error", 17 ] */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Verifies that provided metrics match allowed values. Metrics can be a string,
 * an array of string, an array of objects or mix of strings and objects.
 * Objects must have a "name" property that matches the regex `/^[a-zA-Z0-9_]+$/`
 * to be valid. Objects can optionally include an "expression" property.
 *
 * When a single string is provided, it must be a metric name or a comma-separated
 * list of metric names.
 *
 * A metric name must match the regular expression `/^[a-zA-Z0-9_]+$/`.
 *
 * @since 1.94.0
 * @since 1.98.0 Added a regular expression to validate metric names, in keeping with the GA4 API.
 *
 * @param {string|string[]|Object|Object[]} metrics The metrics to check.
 * @return {boolean} TRUE if metrics are valid, otherwise FALSE.
 */
function isValidMetrics(metrics) {
  function isValidName(metricName) {
    return typeof metricName === 'string' && /^[a-zA-Z0-9_]+$/.test(metricName);
  }
  if (typeof metrics === 'string') {
    const metricNames = metrics.split(',');
    return metricNames.every(isValidName);
  }
  return (0,_js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__.isValidStringsOrObjects)(metrics, metric => {
    const validName = metric.hasOwnProperty('name') && isValidName(metric.name);

    // 'expression' is optional, so if it wasn't provided, we can
    // return early.
    if (!metric.hasOwnProperty('expression')) {
      return validName;
    }

    // 'expression', if provided, must be a string.
    const validExpression = typeof metric.expression === 'string';
    return validName && validExpression;
  }, isValidName);
}

/**
 * Verifies provided dimensions to make sure it matches allowed values. It can be a string,
 * array of strings, an object with "name" field, array of such objects or an array of strings
 * and objects.
 *
 * @since 1.94.0
 *
 * @param {string|string[]|Object|Object[]} dimensions The dimensions to check.
 * @return {boolean} TRUE if dimensions are valid, otherwise FALSE.
 */
function isValidDimensions(dimensions) {
  return (0,_js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__.isValidStringsOrObjects)(dimensions, dimension => {
    return dimension.hasOwnProperty('name') && typeof dimension.name === 'string';
  });
}

/**
 * Verifies provided dimensionFilters to make sure they match allowed values found in dimensions.
 *
 * @since 1.94.0
 *
 * @param {Object} filters The dimension filters to check.
 * @return {boolean} TRUE if dimension filters are valid, otherwise FALSE.
 */
function isValidDimensionFilters(filters) {
  // Ensure every dimensionFilter key corresponds to a valid dimension.
  const validType = ['string'];
  return Object.keys(filters).every(dimension => {
    if (validType.includes(typeof filters[dimension])) {
      return true;
    }
    if (Array.isArray(filters[dimension])) {
      return filters[dimension].every(param => validType.includes(typeof param));
    }
    if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(filters[dimension])) {
      const props = Object.keys(filters[dimension]);
      if (!props.includes('filterType')) {
        return false;
      }
      if (filters[dimension].filterType !== 'emptyFilter' && !props.includes('value')) {
        return false;
      }
      return true;
    }
    return false;
  });
}

/**
 * Verifies provided metricFilters to make sure they match allowed values found in metrics and supported filters.
 *
 * @since 1.111.0
 *
 * @param {Object} filters The metric filters to check.
 * @return {boolean} TRUE if dimension filters are valid, otherwise FALSE.
 */
function isValidMetricFilters(filters) {
  const validType = ['string'];
  const allowedFilterTypes = ['numericFilter', 'betweenFilter'];
  return Object.values(filters).every(filter => {
    if (validType.includes(typeof filter)) {
      return true;
    }
    if (Array.isArray(filter)) {
      return filter.every(param => validType.includes(typeof param));
    }
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(filter)) {
      return false;
    }
    const {
      filterType,
      value,
      fromValue,
      toValue
    } = filter;

    // Validate filterType if present
    if (filterType && !allowedFilterTypes.includes(filterType)) {
      return false;
    }
    const props = Object.keys(filter);

    // Numeric Filter (default if filterType is missing)
    if (!filterType || filterType === 'numericFilter') {
      return props.includes('operation') && props.includes('value') && (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(value) || 'int64Value' in value);
    }

    // Between Filter
    if (filterType === 'betweenFilter') {
      return props.includes('fromValue') && props.includes('toValue') && [fromValue, toValue].every(val => !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(val) || 'int64Value' in val);
    }
    return false;
  });
}

/**
 * Verifies that order definitions are valid for a report. It should be an array
 * of objects where each object has either a "metric" or a "dimension" property,
 * and an optional "desc" property. The "metric" and "dimension" properties should
 * be objects with "metricName" and "dimensionName" properties respectively.
 *
 * @since 1.95.0
 *
 * @param {Object[]} orders The order definitions to check.
 * @return {boolean} TRUE if order definitions are valid, otherwise FALSE.
 */
function isValidOrders(orders) {
  if (!Array.isArray(orders)) {
    return false;
  }
  return orders.every(order => {
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(order)) {
      return false;
    }
    if (order.hasOwnProperty('desc') && typeof order.desc !== 'boolean') {
      return false;
    }
    if (order.metric) {
      return !order.dimension && typeof order.metric?.metricName === 'string';
    }
    if (order.dimension) {
      return typeof order.dimension?.dimensionName === 'string';
    }
    return false;
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/validation.js":
/*!****************************************************!*\
  !*** ./js/modules/analytics-4/utils/validation.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidAccountID: () => (/* reexport safe */ _js_util__WEBPACK_IMPORTED_MODULE_3__.isValidNumericID),
/* harmony export */   isValidAccountSelection: () => (/* binding */ isValidAccountSelection),
/* harmony export */   isValidGoogleTagAccountID: () => (/* binding */ isValidGoogleTagAccountID),
/* harmony export */   isValidGoogleTagContainerID: () => (/* binding */ isValidGoogleTagContainerID),
/* harmony export */   isValidGoogleTagID: () => (/* binding */ isValidGoogleTagID),
/* harmony export */   isValidMeasurementID: () => (/* binding */ isValidMeasurementID),
/* harmony export */   isValidPropertyID: () => (/* binding */ isValidPropertyID),
/* harmony export */   isValidPropertySelection: () => (/* binding */ isValidPropertySelection),
/* harmony export */   isValidWebDataStreamID: () => (/* binding */ isValidWebDataStreamID),
/* harmony export */   isValidWebDataStreamName: () => (/* binding */ isValidWebDataStreamName),
/* harmony export */   isValidWebDataStreamSelection: () => (/* binding */ isValidWebDataStreamSelection),
/* harmony export */   validateAudience: () => (/* binding */ validateAudience),
/* harmony export */   validateReport: () => (/* binding */ validateReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_report_validation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/report-validation */ "./js/util/report-validation.js");
/* harmony import */ var _report_normalization__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./report-normalization */ "./js/modules/analytics-4/utils/report-normalization.js");
/* harmony import */ var _report_validation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./report-validation */ "./js/modules/analytics-4/utils/report-validation.js");
/**
 * Validation utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */






/**
 * Checks if the given value is a valid selection for an Account.
 *
 * @since 1.119.0
 *
 * @param {?string} value Selected value.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidAccountSelection(value) {
  if (value === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.ACCOUNT_CREATE) {
    return true;
  }
  return (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.isValidNumericID)(value);
}

/**
 * Checks if the given account ID appears to be a valid Analytics account.
 *
 * @since 1.8.0
 * @since 1.121.0 Migrated from analytics to analytics-4.
 *
 * @param {(string|number)} accountID Account ID to test.
 * @return {boolean} Whether or not the given account ID is valid.
 */


/**
 * Checks whether the given property ID appears to be valid.
 *
 * @since 1.31.0
 *
 * @param {*} propertyID Property ID to check.
 * @return {boolean} Whether or not the given property ID is valid.
 */
function isValidPropertyID(propertyID) {
  return typeof propertyID === 'string' && /^\d+$/.test(propertyID);
}

/**
 * Checks if the given value is a valid selection for a Property.
 *
 * @since 1.31.0
 *
 * @param {?string} value Selected value.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidPropertySelection(value) {
  if (value === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTY_CREATE) {
    return true;
  }
  return isValidPropertyID(value);
}

/**
 * Checks whether the given web data stream ID appears to be valid.
 *
 * @since 1.33.0
 *
 * @param {*} webDataStreamID Web data stream ID to check.
 * @return {boolean} TRUE if the web data stream ID is valid, otherwise FALSE.
 */
function isValidWebDataStreamID(webDataStreamID) {
  return typeof webDataStreamID === 'string' && /^\d+$/.test(webDataStreamID);
}

/**
 * Checks whether the given web data stream is a valid selection.
 *
 * @since 1.35.0
 *
 * @param {?string} webDataStreamID Web data stream to check.
 * @return {boolean} TRUE if the web data stream selection is valid, otherwise FALSE.
 */
function isValidWebDataStreamSelection(webDataStreamID) {
  if (webDataStreamID === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.WEBDATASTREAM_CREATE) {
    return true;
  }
  return isValidWebDataStreamID(webDataStreamID);
}

/**
 * Checks if the given web data stream name appears to be valid.
 *
 * @since 1.124.0
 *
 * @param {string} value Web data stream name to test.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidWebDataStreamName(value) {
  return typeof value === 'string' && value.trim().length > 0;
}

/**
 * Checks whether the given measurementID appears to be valid.
 *
 * @since 1.35.0
 *
 * @param {*} measurementID Web data stream measurementID to check.
 * @return {boolean} TRUE if the measurementID is valid, otherwise FALSE.
 */
function isValidMeasurementID(measurementID) {
  return typeof measurementID === 'string' && /^G-[a-zA-Z0-9]+$/.test(measurementID);
}

/**
 * Checks whether the given googleTagId appears to be valid.
 *
 * @since 1.90.0
 *
 * @param {*} googleTagID Google Tag ID to check.
 * @return {boolean} TRUE if the googleTagID is valid, otherwise FALSE.
 */
function isValidGoogleTagID(googleTagID) {
  return typeof googleTagID === 'string' && /^(G|GT|AW)-[a-zA-Z0-9]+$/.test(googleTagID);
}

/**
 * Checks whether the given googleTagAccountID appears to be valid.
 *
 * @since 1.90.0
 *
 * @param {*} googleTagAccountID Google Tag ID to check.
 * @return {boolean} TRUE if the googleTagAccountID is valid, otherwise FALSE.
 */
function isValidGoogleTagAccountID(googleTagAccountID) {
  return (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.isValidNumericID)(googleTagAccountID);
}

/**
 * Checks whether the given googleTagContainerID appears to be valid.
 *
 * @since 1.90.0
 *
 * @param {*} googleTagContainerID Google Tag ID to check.
 * @return {boolean} TRUE if the googleTagContainerID is valid, otherwise FALSE.
 */
function isValidGoogleTagContainerID(googleTagContainerID) {
  return (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.isValidNumericID)(googleTagContainerID);
}

/**
 * Checks whether a given report options object is valid.
 *
 * @since 1.130.0
 *
 * @param {Object} options The options for the report.
 */
function validateReport(options) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(options), 'options for Analytics 4 report must be an object.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_util_report_validation__WEBPACK_IMPORTED_MODULE_4__.isValidDateRange)(options), 'Either date range or start/end dates must be provided for Analytics 4 report.');
  const {
    metrics,
    dimensions,
    dimensionFilters,
    metricFilters,
    orderby
  } = (0,_report_normalization__WEBPACK_IMPORTED_MODULE_5__.normalizeReportOptions)(options);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(metrics.length, 'Requests must specify at least one metric for an Analytics 4 report.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidMetrics)(metrics), 'metrics for an Analytics 4 report must be either a string, an array of strings, an object, an array of objects, or a mix of strings and objects. Objects must have a "name" property. Metric names must match the expression ^[a-zA-Z0-9_]+$.');
  if (dimensions) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidDimensions)(dimensions), 'dimensions for an Analytics 4 report must be either a string, an array of strings, an object, an array of objects, or a mix of strings and objects. Objects must have a "name" property.');
  }
  if (dimensionFilters) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidDimensionFilters)(dimensionFilters), 'dimensionFilters for an Analytics 4 report must be a map of dimension names as keys and dimension values as values.');
  }
  if (metricFilters) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidMetricFilters)(metricFilters), 'metricFilters for an Analytics 4 report must be a map of metric names as keys and filter value(s) as numeric fields, depending on the filterType.');
  }
  if (orderby) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidOrders)(orderby), 'orderby for an Analytics 4 report must be an array of OrderBy objects where each object should have either a "metric" or "dimension" property, and an optional "desc" property.');
  }
}

/**
 * Checks whether the passed audience object is valid.
 *
 * @since 1.120.0
 *
 * @param {Object} audience Audience object to check.
 */
function validateAudience(audience) {
  const audienceFields = ['displayName', 'description', 'membershipDurationDays', 'eventTrigger', 'exclusionDurationMode', 'filterClauses'];
  const audienceRequiredFields = ['displayName', 'description', 'membershipDurationDays', 'filterClauses'];
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(audience), 'Audience must be an object.');
  Object.keys(audience).forEach(key => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(audienceFields.includes(key), `Audience object must contain only valid keys. Invalid key: "${key}"`);
  });
  audienceRequiredFields.forEach(key => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(audience[key], `Audience object must contain required keys. Missing key: "${key}"`);
  });
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isArray)(audience.filterClauses), 'filterClauses must be an array with AudienceFilterClause objects.');
}

/***/ }),

/***/ "./js/modules/search-console/constants.js":
/*!************************************************!*\
  !*** ./js/modules/search-console/constants.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_SEARCH_CONSOLE: () => (/* binding */ MODULE_SLUG_SEARCH_CONSOLE)
/* harmony export */ });
/**
 * Search Console module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_SEARCH_CONSOLE = 'search-console';

/***/ }),

/***/ "./js/modules/tagmanager/components/common/AMPContainerNameTextField.js":
/*!******************************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/AMPContainerNameTextField.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AMPContainerNameTextField)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _ContainerNameTextField__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContainerNameTextField */ "./js/modules/tagmanager/components/common/ContainerNameTextField.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AMPContainerNameTextField component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function AMPContainerNameTextField() {
  const ampContainerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_TAGMANAGER).getAMPContainerID());
  const siteName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteName());
  const referenceSiteURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getReferenceSiteURL());
  const initialAMPContainerName = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__["default"])(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.FORM_SETUP, 'ampContainerName');
  let ampContainerName = siteName;
  if (!ampContainerName && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_8__.isURL)(referenceSiteURL)) {
    ampContainerName = new URL(referenceSiteURL).hostname;
  }
  ampContainerName += ' AMP';
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS);
  (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
    if (!initialAMPContainerName) {
      setValues(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.FORM_SETUP, {
        ampContainerName
      });
    }
  });
  if (ampContainerID !== _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CONTAINER_CREATE) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_ContainerNameTextField__WEBPACK_IMPORTED_MODULE_5__["default"], {
    name: "ampContainerName",
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('AMP Container Name', 'google-site-kit')
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/common/AMPContainerSelect.js":
/*!***********************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/AMPContainerSelect.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AMPContainerSelect)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _ContainerSelect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContainerSelect */ "./js/modules/tagmanager/components/common/ContainerSelect.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager AMP Container Select component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function AMPContainerSelect({
  hasModuleAccess
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccountID());
  const ampContainerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAMPContainerID());
  const ampContainers = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    if (hasModuleAccess === false) {
      return null;
    }
    return select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAMPContainers(accountID);
  });
  const isAMP = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isAMP());
  const {
    setAMPContainerID,
    setInternalAMPContainerID
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER);
  const onSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)((index, item) => {
    const {
      value: newContainerID,
      // eslint-disable-next-line sitekit/acronym-case
      internalId: newInternalContainerID
    } = item.dataset;
    if (ampContainerID !== newContainerID) {
      const eventAction = newContainerID === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONTAINER_CREATE ? 'change_amp_container_new' : 'change_amp_container';
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_tagmanager`, eventAction);
      setAMPContainerID(newContainerID);
      setInternalAMPContainerID(newInternalContainerID || '');
    }
  }, [ampContainerID, setAMPContainerID, setInternalAMPContainerID, viewContext]);
  if (!isAMP) {
    return null;
  }
  const label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('AMP Container', 'google-site-kit');
  if (hasModuleAccess === false) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
      className: "googlesitekit-tagmanager__select-container--amp",
      label: label,
      value: ampContainerID,
      enhanced: true,
      outlined: true,
      disabled: true,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Option, {
        value: ampContainerID,
        children: ampContainerID
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_ContainerSelect__WEBPACK_IMPORTED_MODULE_5__["default"], {
    className: "googlesitekit-tagmanager__select-container--amp",
    label: label,
    value: ampContainerID,
    containers: ampContainers,
    onEnhancedChange: onSelect
  });
}
AMPContainerSelect.propTypes = {
  hasModuleAccess: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool)
};

/***/ }),

/***/ "./js/modules/tagmanager/components/common/AccountCreate.js":
/*!******************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/AccountCreate.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccountCreate)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Account Create component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function AccountCreate() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  const hasResolvedAccounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).hasFinishedResolution('getAccounts'));
  const hasResolvedGetUser = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).hasFinishedResolution('getUser'));
  const createAccountURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getServiceURL({
    path: 'admin/accounts/create'
  }));
  const {
    resetAccounts
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER);
  const refetchAccountsHandler = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    resetAccounts();
  }, [resetAccounts]);
  const createAccountHandler = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_tagmanager`, 'create_account');

    // Need to use window.open for this to allow for stubbing in E2E.
    __webpack_require__.g.window.open(createAccountURL, '_blank');
  }, [createAccountURL, viewContext]);
  if (!hasResolvedAccounts || !hasResolvedGetUser) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {});
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_5__["default"], {
      moduleSlug: "tagmanager",
      storeName: _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To create a new account, click the button below which will open the Google Tag Manager account creation screen in a new window.', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Once completed, click the link below to re-fetch your accounts to continue.', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "googlesitekit-setup-module__action",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        onClick: createAccountHandler,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Create an account', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "googlesitekit-setup-module__sub-action",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
          onClick: refetchAccountsHandler,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Re-fetch My Account', 'google-site-kit')
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/common/AccountSelect.js":
/*!******************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/AccountSelect.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccountSelect)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Account Select component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function AccountSelect({
  hasModuleAccess
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_5__["default"])();
  const accounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccounts());
  const hasResolvedAccounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).hasFinishedResolution('getAccounts'));
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccountID());
  const {
    selectAccount
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER);
  const onChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)((index, item) => {
    const newAccountID = item.dataset.value;
    if (accountID !== newAccountID) {
      const eventAction = newAccountID === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ACCOUNT_CREATE ? 'change_account_new' : 'change_account';
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_tagmanager`, eventAction);
      selectAccount(newAccountID);
    }
  }, [accountID, selectAccount, viewContext]);
  if (!hasResolvedAccounts) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, {
      small: true
    });
  }
  if (hasModuleAccess === false) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
      className: "googlesitekit-tagmanager__select-account",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Account', 'google-site-kit'),
      value: accountID,
      enhanced: true,
      outlined: true,
      disabled: true,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Option, {
        value: accountID,
        children: accountID
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
    className: "googlesitekit-tagmanager__select-account",
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Account', 'google-site-kit'),
    value: accountID,
    onEnhancedChange: onChange,
    enhanced: true,
    outlined: true,
    children: (accounts || []).concat({
      accountId: _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ACCOUNT_CREATE,
      // eslint-disable-line sitekit/acronym-case
      name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set up a new account', 'google-site-kit')
    }).map(({
      accountId,
      name
    } // eslint-disable-line sitekit/acronym-case
    ) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Option, {
      // eslint-disable-line sitekit/acronym-case
      value: accountId // eslint-disable-line sitekit/acronym-case
      ,
      children: name
    }, accountId))
  });
}
AccountSelect.propTypes = {
  hasModuleAccess: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/modules/tagmanager/components/common/ContainerNameTextField.js":
/*!***************************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/ContainerNameTextField.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContainerNameTextField)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_components_AccessibleWarningIcon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/AccessibleWarningIcon */ "./js/components/AccessibleWarningIcon.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/tagmanager/util */ "./js/modules/tagmanager/util/index.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ContainerNameTextField component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function ContainerNameTextField({
  label,
  name
}) {
  const containers = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const accountID = select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccountID();
    return select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainers(accountID);
  });
  const containerName = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__["default"])(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, name);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS);
  const onChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(({
    currentTarget
  }) => {
    setValues(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, {
      [name]: currentTarget.value
    });
  }, [name, setValues]);
  const isUniqueName = (0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_7__.isUniqueContainerName)(containerName, containers);
  const helperText = containerName && !isUniqueName ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('A container with this name already exists', 'google-site-kit') : false;
  const trailingIcon = containerName && !isUniqueName ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("span", {
    className: "googlesitekit-text-field-icon--error",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_AccessibleWarningIcon__WEBPACK_IMPORTED_MODULE_5__["default"], {})
  }) : false;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tagmanager-containername', `googlesitekit-tagmanager-${name}`),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_6__.TextField, {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
        'mdc-text-field--error': !containerName || !isUniqueName
      }),
      label: label,
      helperText: helperText,
      trailingIcon: trailingIcon,
      id: name,
      name: name,
      value: containerName,
      onChange: onChange,
      outlined: true
    })
  });
}
ContainerNameTextField.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired,
  name: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired
};

/***/ }),

/***/ "./js/modules/tagmanager/components/common/ContainerNames.js":
/*!*******************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/ContainerNames.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContainerNames)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _AMPContainerNameTextField__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AMPContainerNameTextField */ "./js/modules/tagmanager/components/common/AMPContainerNameTextField.js");
/* harmony import */ var _WebContainerNameTextField__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./WebContainerNameTextField */ "./js/modules/tagmanager/components/common/WebContainerNameTextField.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager container names component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */





function ContainerNames() {
  const containerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainerID());
  const ampContainerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAMPContainerID());
  if (containerID !== _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONTAINER_CREATE && ampContainerID !== _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONTAINER_CREATE) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "googlesitekit-setup-module__inputs googlesitekit-setup-module__inputs--collapsed",
    children: [containerID === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONTAINER_CREATE && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_WebContainerNameTextField__WEBPACK_IMPORTED_MODULE_2__["default"], {}), ampContainerID === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONTAINER_CREATE && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_AMPContainerNameTextField__WEBPACK_IMPORTED_MODULE_1__["default"], {})]
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/common/ContainerSelect.js":
/*!********************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/ContainerSelect.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContainerSelect)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/tagmanager/util */ "./js/modules/tagmanager/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Container Select component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function ContainerSelect({
  containers,
  className,
  value,
  ...props
}) {
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).getAccountID());
  const hasResolvedAccounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).hasFinishedResolution('getAccounts'));
  const hasResolvedContainers = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).hasFinishedResolution('getContainers', [accountID]));
  if (!hasResolvedAccounts || !hasResolvedContainers) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {
      small: true
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Select, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-tagmanager__select-container', className),
    disabled: !(0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID),
    value: value,
    enhanced: true,
    outlined: true,
    ...props,
    children: (containers || []).concat({
      // eslint-disable-next-line sitekit/acronym-case
      publicId: _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CONTAINER_CREATE,
      name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Set up a new container', 'google-site-kit')
    }).map(({
      publicId,
      name,
      containerId
    } // eslint-disable-line sitekit/acronym-case
    ) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Option, {
      // eslint-disable-line sitekit/acronym-case
      value: publicId // eslint-disable-line sitekit/acronym-case
      ,
      "data-internal-id": containerId // eslint-disable-line sitekit/acronym-case
      ,
      children: publicId === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CONTAINER_CREATE // eslint-disable-line sitekit/acronym-case
      ? name : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: container name, 2: container ID */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('%1$s (%2$s)', 'Tag Manager container name and ID', 'google-site-kit'), name, publicId // eslint-disable-line sitekit/acronym-case
      )
    }, publicId))
  });
}
ContainerSelect.propTypes = {
  containers: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_7___default().object))
};

/***/ }),

/***/ "./js/modules/tagmanager/components/common/FormInstructions.js":
/*!*********************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/FormInstructions.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FormInstructions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Form Instructions component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function FormInstructions({
  isSetup
}) {
  const isSecondaryAMP = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).isSecondaryAMP());
  const analyticsModuleAvailable = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).isModuleAvailable(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ANALYTICS_4));
  const analyticsModuleActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).isModuleActive(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_ANALYTICS_4));
  const currentGTMGoogleTagID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).getCurrentGTMGoogleTagID());

  // If the Analytics module is not active, and the selected container has a valid Google Tag ID,
  // then recommend continuing with Analytics setup.
  if (analyticsModuleAvailable && !analyticsModuleActive && currentGTMGoogleTagID) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Looks like you may be using Google Analytics within your Google Tag Manager configuration. Activate the Google Analytics module in Site Kit to see relevant insights in your dashboard.', 'google-site-kit')
    });
  }
  if (isSecondaryAMP) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: isSetup ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Looks like your site is using paired AMP. Please select your Tag Manager account and relevant containers below. You can change these later in your settings.', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Looks like your site is using paired AMP. Please select your Tag Manager account and relevant containers below.', 'google-site-kit')
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_6__["default"], {
    children: isSetup ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Please select your Tag Manager account and container below. You can change these later in your settings.', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Please select your Tag Manager account and container below', 'google-site-kit')
  });
}
FormInstructions.propTypes = {
  isSetup: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/modules/tagmanager/components/common/TagCheckProgress.js":
/*!*********************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/TagCheckProgress.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TagCheckProgress)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Check Progress Loader component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function TagCheckProgress({
  className
}) {
  const isResolvingLiveContainerVersion = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const accountID = select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).getAccountID();
    const internalContainerID = select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).getInternalContainerID();
    const internalAMPContainerID = select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).getInternalAMPContainerID();
    return select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).isResolving('getLiveContainerVersion', [accountID, internalContainerID]) || select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).isResolving('getLiveContainerVersion', [accountID, internalAMPContainerID]);
  });
  if (!isResolvingLiveContainerVersion) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("small", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Checking tags…', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.ProgressBar, {
      small: true,
      compress: true
    })]
  });
}
TagCheckProgress.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};
TagCheckProgress.defaultProps = {
  className: ''
};

/***/ }),

/***/ "./js/modules/tagmanager/components/common/UseSnippetSwitch.js":
/*!*********************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/UseSnippetSwitch.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UseSnippetSwitch)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Use Snippet Switch component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function UseSnippetSwitch({
  description
}) {
  const useSnippet = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getUseSnippet());
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_5__["default"])();
  const {
    setUseSnippet
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER);
  const onChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    const newUseSnippet = !useSnippet;
    setUseSnippet(newUseSnippet);
    (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)(`${viewContext}_tagmanager`, newUseSnippet ? 'enable_tag' : 'disable_tag');
  }, [setUseSnippet, useSnippet, viewContext]);
  if (useSnippet === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "googlesitekit-tagmanager-usesnippet",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Switch, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Let Site Kit place code on your site', 'google-site-kit'),
      checked: useSnippet,
      onClick: onChange,
      hideLabel: false
    }), description]
  });
}
UseSnippetSwitch.propTypes = {
  description: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node)
};

/***/ }),

/***/ "./js/modules/tagmanager/components/common/WebContainerNameTextField.js":
/*!******************************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/WebContainerNameTextField.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WebContainerNameTextField)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _ContainerNameTextField__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContainerNameTextField */ "./js/modules/tagmanager/components/common/ContainerNameTextField.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WebContainerNameTextField component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function WebContainerNameTextField() {
  const containerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_TAGMANAGER).getContainerID());
  const siteName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSiteName());
  const isAMP = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).isAMP());
  const referenceSiteURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getReferenceSiteURL());
  const initialContainerName = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__["default"])(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.FORM_SETUP, 'containerName');
  let containerName = siteName;
  if (!containerName && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_8__.isURL)(referenceSiteURL)) {
    containerName = new URL(referenceSiteURL).hostname;
  }
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS);
  (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
    if (!initialContainerName) {
      setValues(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.FORM_SETUP, {
        containerName
      });
    }
  });
  if (containerID !== _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CONTAINER_CREATE) {
    return null;
  }
  const label = isAMP ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Web Container Name', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Container Name', 'google-site-kit');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_ContainerNameTextField__WEBPACK_IMPORTED_MODULE_5__["default"], {
    name: "containerName",
    label: label
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/common/WebContainerSelect.js":
/*!***********************************************************************!*\
  !*** ./js/modules/tagmanager/components/common/WebContainerSelect.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WebContainerSelect)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _ContainerSelect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContainerSelect */ "./js/modules/tagmanager/components/common/ContainerSelect.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Web Container Select component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function WebContainerSelect({
  hasModuleAccess
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccountID());
  const containerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainerID());
  const containers = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    if (hasModuleAccess === false) {
      return null;
    }
    return select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getWebContainers(accountID);
  });
  const isAMP = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).isAMP());
  const {
    setContainerID,
    setInternalContainerID
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER);
  const onSelect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)((index, item) => {
    const {
      value: newContainerID,
      // eslint-disable-next-line sitekit/acronym-case
      internalId: newInternalContainerID
    } = item.dataset;
    if (containerID !== newContainerID) {
      const eventAction = newContainerID === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CONTAINER_CREATE ? 'change_container_new' : 'change_container';
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_tagmanager`, eventAction);
      setContainerID(newContainerID);
      setInternalContainerID(newInternalContainerID || '');
    }
  }, [containerID, setContainerID, setInternalContainerID, viewContext]);
  const label = isAMP ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Web Container', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Container', 'google-site-kit');
  if (hasModuleAccess === false) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
      className: "googlesitekit-tagmanager__select-container--web",
      label: label,
      value: containerID,
      enhanced: true,
      outlined: true,
      disabled: true,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Option, {
        value: containerID,
        children: containerID
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_ContainerSelect__WEBPACK_IMPORTED_MODULE_5__["default"], {
    className: "googlesitekit-tagmanager__select-container--web",
    label: label,
    value: containerID,
    containers: containers,
    onEnhancedChange: onSelect
  });
}
WebContainerSelect.propTypes = {
  hasModuleAccess: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool)
};

/***/ }),

/***/ "./js/modules/tagmanager/components/common/index.js":
/*!**********************************************************!*\
  !*** ./js/modules/tagmanager/components/common/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMPContainerNameTextField: () => (/* reexport safe */ _AMPContainerNameTextField__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   AMPContainerSelect: () => (/* reexport safe */ _AMPContainerSelect__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   AccountCreate: () => (/* reexport safe */ _AccountCreate__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   AccountSelect: () => (/* reexport safe */ _AccountSelect__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   ContainerNameTextField: () => (/* reexport safe */ _ContainerNameTextField__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   ContainerNames: () => (/* reexport safe */ _ContainerNames__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   ContainerSelect: () => (/* reexport safe */ _ContainerSelect__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   FormInstructions: () => (/* reexport safe */ _FormInstructions__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   TagCheckProgress: () => (/* reexport safe */ _TagCheckProgress__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   UseSnippetSwitch: () => (/* reexport safe */ _UseSnippetSwitch__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   WebContainerNameTextField: () => (/* reexport safe */ _WebContainerNameTextField__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   WebContainerSelect: () => (/* reexport safe */ _WebContainerSelect__WEBPACK_IMPORTED_MODULE_11__["default"])
/* harmony export */ });
/* harmony import */ var _AccountCreate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AccountCreate */ "./js/modules/tagmanager/components/common/AccountCreate.js");
/* harmony import */ var _AccountSelect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AccountSelect */ "./js/modules/tagmanager/components/common/AccountSelect.js");
/* harmony import */ var _AMPContainerNameTextField__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AMPContainerNameTextField */ "./js/modules/tagmanager/components/common/AMPContainerNameTextField.js");
/* harmony import */ var _AMPContainerSelect__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AMPContainerSelect */ "./js/modules/tagmanager/components/common/AMPContainerSelect.js");
/* harmony import */ var _ContainerNames__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ContainerNames */ "./js/modules/tagmanager/components/common/ContainerNames.js");
/* harmony import */ var _ContainerNameTextField__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContainerNameTextField */ "./js/modules/tagmanager/components/common/ContainerNameTextField.js");
/* harmony import */ var _ContainerSelect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ContainerSelect */ "./js/modules/tagmanager/components/common/ContainerSelect.js");
/* harmony import */ var _FormInstructions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./FormInstructions */ "./js/modules/tagmanager/components/common/FormInstructions.js");
/* harmony import */ var _TagCheckProgress__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./TagCheckProgress */ "./js/modules/tagmanager/components/common/TagCheckProgress.js");
/* harmony import */ var _UseSnippetSwitch__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./UseSnippetSwitch */ "./js/modules/tagmanager/components/common/UseSnippetSwitch.js");
/* harmony import */ var _WebContainerNameTextField__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./WebContainerNameTextField */ "./js/modules/tagmanager/components/common/WebContainerNameTextField.js");
/* harmony import */ var _WebContainerSelect__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./WebContainerSelect */ "./js/modules/tagmanager/components/common/WebContainerSelect.js");
/**
 * Tag Manager common components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */














/***/ }),

/***/ "./js/modules/tagmanager/components/settings/SettingsEdit.js":
/*!*******************************************************************!*\
  !*** ./js/modules/tagmanager/components/settings/SettingsEdit.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsEdit)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/* harmony import */ var _js_modules_tagmanager_hooks_useExistingTagEffect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/tagmanager/hooks/useExistingTagEffect */ "./js/modules/tagmanager/hooks/useExistingTagEffect.js");
/* harmony import */ var _js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/tagmanager/components/common */ "./js/modules/tagmanager/components/common/index.js");
/* harmony import */ var _SettingsForm__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SettingsForm */ "./js/modules/tagmanager/components/settings/SettingsForm.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Settings Edit component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */









function SettingsEdit() {
  const accounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccounts()) || [];
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccountID());
  const hasExistingTag = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).hasExistingTag());
  const isDoingSubmitChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).isDoingSubmitChanges());
  const hasResolvedAccounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).hasFinishedResolution('getAccounts'));
  const hasTagManagerAccess = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).hasModuleOwnershipOrAccess(_js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_TAGMANAGER));
  const isCreateAccount = _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.ACCOUNT_CREATE === accountID;

  // Set useSnippet to `false` if there is an existing tag and it is the same as the selected container ID.
  (0,_js_modules_tagmanager_hooks_useExistingTagEffect__WEBPACK_IMPORTED_MODULE_5__["default"])();
  let viewComponent;
  // Here we also check for `hasResolvedAccounts` to prevent showing a different case below
  // when the component initially loads and has yet to start fetching accounts.
  if (isDoingSubmitChanges || !hasResolvedAccounts || hasTagManagerAccess === undefined || hasExistingTag === undefined) {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, {});
  } else if (isCreateAccount || !accounts?.length) {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_6__.AccountCreate, {});
  } else {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_SettingsForm__WEBPACK_IMPORTED_MODULE_7__["default"], {
      hasModuleAccess: hasTagManagerAccess
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
    className: "googlesitekit-setup-module googlesitekit-setup-module--tagmanager",
    children: viewComponent
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/settings/SettingsForm.js":
/*!*******************************************************************!*\
  !*** ./js/modules/tagmanager/components/settings/SettingsForm.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsForm)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/tagmanager/components/common */ "./js/modules/tagmanager/components/common/index.js");
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _SettingsUseSnippetSwitch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./SettingsUseSnippetSwitch */ "./js/modules/tagmanager/components/settings/SettingsUseSnippetSwitch.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_components_settings_SettingsGroup__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/settings/SettingsGroup */ "./js/components/settings/SettingsGroup.js");
/* harmony import */ var _js_components_google_tag_gateway_GoogleTagGatewayToggle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/google-tag-gateway/GoogleTagGatewayToggle */ "./js/components/google-tag-gateway/GoogleTagGatewayToggle.js");
/* harmony import */ var _js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useFeature */ "./js/hooks/useFeature.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Settings Form component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */












function SettingsForm({
  hasModuleAccess
}) {
  const gtgEnabled = (0,_js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_11__.useFeature)('googleTagGateway');
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModule(_js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_TAGMANAGER));
  const formattedOwnerName = module?.owner?.login ? `<strong>${module.owner.login}</strong>` : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Another admin', 'google-site-kit');
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
    className: "googlesitekit-tagmanager-settings-fields",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_3__["default"], {
      moduleSlug: "tagmanager",
      storeName: _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_2__.FormInstructions, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "googlesitekit-setup-module__inputs",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_2__.AccountSelect, {
        hasModuleAccess: hasModuleAccess
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_2__.WebContainerSelect, {
        hasModuleAccess: hasModuleAccess
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_2__.AMPContainerSelect, {
        hasModuleAccess: hasModuleAccess
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_2__.TagCheckProgress, {})]
    }), hasModuleAccess === false && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"], {
      className: "googlesitekit-notice--bottom-margin",
      type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_8__["default"].TYPES.INFO,
      description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: module owner's name, 2: module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s configured %2$s and you don’t have access to this %2$s account. Contact them to share access or change the %2$s account.', 'google-site-kit'), formattedOwnerName, module?.name), {
        strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("strong", {})
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_2__.ContainerNames, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("div", {
      className: "googlesitekit-setup-module__inputs googlesitekit-setup-module__inputs--multiline",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_SettingsUseSnippetSwitch__WEBPACK_IMPORTED_MODULE_7__["default"], {})
    }), gtgEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_settings_SettingsGroup__WEBPACK_IMPORTED_MODULE_9__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Improve your measurement', 'google-site-kit'),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_components_google_tag_gateway_GoogleTagGatewayToggle__WEBPACK_IMPORTED_MODULE_10__["default"], {})
    })]
  });
}
SettingsForm.propTypes = {
  hasModuleAccess: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().bool)
};
SettingsForm.defaultProps = {
  hasModuleAccess: true
};

/***/ }),

/***/ "./js/modules/tagmanager/components/settings/SettingsUseSnippetSwitch.js":
/*!*******************************************************************************!*\
  !*** ./js/modules/tagmanager/components/settings/SettingsUseSnippetSwitch.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsUseSnippetSwitch)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_modules_tagmanager_components_common_UseSnippetSwitch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/components/common/UseSnippetSwitch */ "./js/modules/tagmanager/components/common/UseSnippetSwitch.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Settings Use Snippet Switch component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function SettingsUseSnippetSwitch() {
  const useSnippet = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).getUseSnippet());
  const primaryContainerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).getPrimaryContainerID());
  const existingTag = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER).getExistingTag());
  let description;
  if (existingTag) {
    description = primaryContainerID === existingTag ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: existing tag ID */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('A tag %s for the selected container already exists on the site', 'google-site-kit'), existingTag)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Consider removing the existing tag to avoid loading both tags on your site', 'google-site-kit')
      })]
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: existing tag ID */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An existing tag %s was found on the page', 'google-site-kit'), existingTag)
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('If you prefer to collect data using that existing tag, please select the corresponding account and property above', 'google-site-kit')
      })]
    });
  } else {
    description = useSnippet ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit will add the code automatically', 'google-site-kit')
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit will not add the code to your site', 'google-site-kit')
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_modules_tagmanager_components_common_UseSnippetSwitch__WEBPACK_IMPORTED_MODULE_3__["default"], {
    description: description
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/settings/SettingsView.js":
/*!*******************************************************************!*\
  !*** ./js/modules/tagmanager/components/settings/SettingsView.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SettingsView)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/DisplaySetting */ "./js/components/DisplaySetting.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_util_escape_uri__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/escape-uri */ "./js/util/escape-uri.ts");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_components_settings_SettingsStatuses__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/settings/SettingsStatuses */ "./js/components/settings/SettingsStatuses.js");
/* harmony import */ var _js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/hooks/useFeature */ "./js/hooks/useFeature.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Settings View component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */













function SettingsView() {
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).getAccountID());
  const containerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).getContainerID());
  const ampContainerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).getAMPContainerID());
  const useSnippet = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).getUseSnippet());
  const hasExistingTag = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).hasExistingTag());
  const isAMP = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).isAMP());
  const isSecondaryAMP = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).isSecondaryAMP());
  const internalContainerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).getInternalContainerID());
  const internalAMPContainerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).getInternalAMPContainerID());
  const editWebContainerURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).getServiceURL({
    path: (0,_js_util_escape_uri__WEBPACK_IMPORTED_MODULE_8__.escapeURI)`/container/accounts/${accountID}/containers/${internalContainerID}`
  }));
  const editAMPContainerURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER).getServiceURL({
    path: (0,_js_util_escape_uri__WEBPACK_IMPORTED_MODULE_8__.escapeURI)`/container/accounts/${accountID}/containers/${internalAMPContainerID}`
  }));
  const googleTagGatewayEnabled = (0,_js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_12__.useFeature)('googleTagGateway');
  const googleTagGatewayStatuses = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!googleTagGatewayEnabled) {
      return [];
    }
    const {
      isGoogleTagGatewayEnabled,
      isGTGHealthy,
      isScriptAccessEnabled
    } = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE);
    const status = isGoogleTagGatewayEnabled() && isGTGHealthy() && isScriptAccessEnabled();
    return [{
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google tag gateway for advertisers', 'google-site-kit'),
      status
    }];
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_4__["default"], {
      moduleSlug: "tagmanager",
      storeName: _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.MODULES_TAGMANAGER
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
      className: "googlesitekit-settings-module__meta-items",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "googlesitekit-settings-module__meta-item",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_9__["default"], {
          as: "h5",
          size: "medium",
          type: "label",
          className: "googlesitekit-settings-module__meta-item-type",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Account', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
          className: "googlesitekit-settings-module__meta-item-data",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_2__["default"], {
            value: accountID
          })
        })]
      }), (!isAMP || isSecondaryAMP) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "googlesitekit-settings-module__meta-item",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_9__["default"], {
            as: "h5",
            size: "medium",
            type: "label",
            className: "googlesitekit-settings-module__meta-item-type",
            children: [isSecondaryAMP && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Web Container ID', 'google-site-kit')
            }), !isSecondaryAMP && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Container ID', 'google-site-kit')
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
            className: "googlesitekit-settings-module__meta-item-data",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_2__["default"], {
              value: containerID
            })
          })]
        }), editWebContainerURL && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
          className: "googlesitekit-settings-module__meta-item googlesitekit-settings-module__meta-item--data-only",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
            className: "googlesitekit-settings-module__meta-item-data googlesitekit-settings-module__meta-item-data--tiny",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
              href: editWebContainerURL,
              external: true,
              children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_15__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Appropriate container term. */
              (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Edit <VisuallyHidden>%s </VisuallyHidden>in Tag Manager', 'google-site-kit'), isSecondaryAMP ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('web container', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('container', 'google-site-kit')), {
                VisuallyHidden: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_5__["default"], {})
              })
            })
          })
        })]
      }), isAMP && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "googlesitekit-settings-module__meta-item",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_9__["default"], {
            as: "h5",
            size: "medium",
            type: "label",
            className: "googlesitekit-settings-module__meta-item-type",
            children: [isSecondaryAMP && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('AMP Container ID', 'google-site-kit')
            }), !isSecondaryAMP && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
              children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Container ID', 'google-site-kit')
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
            className: "googlesitekit-settings-module__meta-item-data",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_DisplaySetting__WEBPACK_IMPORTED_MODULE_2__["default"], {
              value: ampContainerID
            })
          })]
        }), editAMPContainerURL && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
          className: "googlesitekit-settings-module__meta-item googlesitekit-settings-module__meta-item--data-only",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("p", {
            className: "googlesitekit-settings-module__meta-item-data googlesitekit-settings-module__meta-item-data--tiny",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
              href: editAMPContainerURL,
              external: true,
              children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_15__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Appropriate container term. */
              (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Edit <VisuallyHidden>%s </VisuallyHidden>in Tag Manager', 'google-site-kit'), isSecondaryAMP ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('AMP container', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('container', 'google-site-kit')), {
                VisuallyHidden: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_VisuallyHidden__WEBPACK_IMPORTED_MODULE_5__["default"], {})
              })
            })
          })
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("div", {
      className: "googlesitekit-settings-module__meta-items",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
        className: "googlesitekit-settings-module__meta-item",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_9__["default"], {
          as: "h5",
          size: "medium",
          type: "label",
          className: "googlesitekit-settings-module__meta-item-type",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Tag Manager Code Snippet', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("p", {
          className: "googlesitekit-settings-module__meta-item-data",
          children: [useSnippet && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Snippet is inserted', 'google-site-kit')
          }), !useSnippet && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Snippet is not inserted', 'google-site-kit')
          })]
        }), hasExistingTag && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__["default"], {
          className: "googlesitekit-margin-bottom-0",
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Placing two tags at the same time is not recommended.', 'google-site-kit')
        })]
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_settings_SettingsStatuses__WEBPACK_IMPORTED_MODULE_11__["default"], {
      statuses: googleTagGatewayStatuses
    })]
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/settings/index.js":
/*!************************************************************!*\
  !*** ./js/modules/tagmanager/components/settings/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SettingsEdit: () => (/* reexport safe */ _SettingsEdit__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   SettingsForm: () => (/* reexport safe */ _SettingsForm__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   SettingsUseSnippetSwitch: () => (/* reexport safe */ _SettingsUseSnippetSwitch__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SettingsView: () => (/* reexport safe */ _SettingsView__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _SettingsEdit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SettingsEdit */ "./js/modules/tagmanager/components/settings/SettingsEdit.js");
/* harmony import */ var _SettingsForm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SettingsForm */ "./js/modules/tagmanager/components/settings/SettingsForm.js");
/* harmony import */ var _SettingsUseSnippetSwitch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SettingsUseSnippetSwitch */ "./js/modules/tagmanager/components/settings/SettingsUseSnippetSwitch.js");
/* harmony import */ var _SettingsView__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SettingsView */ "./js/modules/tagmanager/components/settings/SettingsView.js");
/**
 * Tag Manager settings components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */






/***/ }),

/***/ "./js/modules/tagmanager/components/setup/SetupErrorNotice.js":
/*!********************************************************************!*\
  !*** ./js/modules/tagmanager/components/setup/SetupErrorNotice.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupErrorNotice)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Setup Error Notice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */








function SetupErrorNotice() {
  const analyticsModuleAvailable = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).isModuleAvailable(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ANALYTICS_4));
  const analyticsErrors = [
  // Check if activating Analytics failed.
  (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getErrorForAction('activateModule', [_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_ANALYTICS_4])),
  // Check if saving Analytics settings failed.
  (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!analyticsModuleAvailable) {
      return false;
    }
    const settings = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getSettings();
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_ANALYTICS_4).getErrorForAction('saveSettings', [settings]);
  })].filter(Boolean);
  if (analyticsErrors.length) {
    return analyticsErrors.map(error => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_6__["default"], {
      error: error
    }, error?.message));
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_5__["default"], {
    moduleSlug: "tagmanager",
    storeName: _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_TAGMANAGER
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/setup/SetupForm.js":
/*!*************************************************************!*\
  !*** ./js/modules/tagmanager/components/setup/SetupForm.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupForm)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/modules/tagmanager/components/common */ "./js/modules/tagmanager/components/common/index.js");
/* harmony import */ var _SetupErrorNotice__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./SetupErrorNotice */ "./js/modules/tagmanager/components/setup/SetupErrorNotice.js");
/* harmony import */ var _SetupUseSnippetSwitch__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./SetupUseSnippetSwitch */ "./js/modules/tagmanager/components/setup/SetupUseSnippetSwitch.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Setup Form component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */















function SetupForm({
  finishSetup
}) {
  const canSubmitChanges = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).canSubmitChanges());
  const currentGTMGoogleTagID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getCurrentGTMGoogleTagID());
  const analyticsModuleAvailable = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).isModuleAvailable(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_13__.MODULE_SLUG_ANALYTICS_4));
  const analyticsModuleActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).isModuleActive(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_13__.MODULE_SLUG_ANALYTICS_4));
  const hasEditScope = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).hasScope(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.EDIT_SCOPE));
  // Only select the initial autosubmit + submitMode once from form state which will already be set if a snapshot was restored.
  const initialAutoSubmit = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_14__["default"])(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, 'autoSubmit');
  const initialSubmitMode = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_14__["default"])(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, 'submitMode');
  const hasExistingTag = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).hasExistingTag());
  const submitInProgress = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_14__["default"])(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, 'submitInProgress');
  const isSaving = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).isDoingSubmitChanges() || select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_LOCATION).isNavigating() || submitInProgress);

  // This flag is be used to determine whether to show the loading spinner
  // within the "Continue to Analytics setup" button when setting up GTM with Analytics.
  // It prevents the spinner from showing when the user opts to set up GTM without Analytics.
  const [isSavingWithAnalytics, setIsSavingWithAnalytics] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.useState)(false);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS);
  const {
    activateModule
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES);
  const {
    submitChanges
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER);
  const submitForm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.useCallback)(async ({
    submitMode
  } = {}) => {
    async function throwOnError(func) {
      const {
        error
      } = (await func()) || {};
      if (error) {
        throw error;
      }
    }
    // We'll use form state to persist the chosen submit choice
    // in order to preserve support for auto-submit.
    setValues(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, {
      submitMode,
      submitInProgress: true
    });
    try {
      await throwOnError(() => submitChanges());
      // If submitChanges was successful, disable autoSubmit (in case it was restored).
      setValues(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, {
        autoSubmit: false
      });

      // If submitting with Analytics setup, and Analytics is not active,
      // activate it, and navigate to its reauth/setup URL to proceed with its setup.
      if (submitMode === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.SETUP_MODE_WITH_ANALYTICS && !analyticsModuleActive) {
        const {
          response,
          error
        } = await activateModule(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_13__.MODULE_SLUG_ANALYTICS_4);
        if (error) {
          throw error;
        }
        await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_9__.setItem)('module_setup', _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_13__.MODULE_SLUG_ANALYTICS_4, {
          ttl: 300
        });

        // Reauth/setup URL needs to come from async activateModule action to be fresh.
        finishSetup(response.moduleReauthURL);
      } else {
        // If we got here, call finishSetup to navigate to the success screen.
        finishSetup();
      }
    } catch (err) {
      if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_8__.isPermissionScopeError)(err)) {
        setValues(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, {
          autoSubmit: true
        });
      }
    }
    // Mark the submit as no longer in progress in all cases.
    setValues(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.FORM_SETUP, {
      submitInProgress: false
    });
  }, [finishSetup, analyticsModuleActive, activateModule, submitChanges, setValues]);

  // If the user lands back on this component with autoSubmit and the edit scope,
  // resubmit the form.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.useEffect)(() => {
    if (initialAutoSubmit && hasEditScope) {
      submitForm({
        submitMode: initialSubmitMode
      });
    }
  }, [hasEditScope, initialAutoSubmit, submitForm, initialSubmitMode]);
  const isSetupWithAnalytics = !!(currentGTMGoogleTagID && analyticsModuleAvailable && !analyticsModuleActive);

  // Form submit behavior now varies based on which button is clicked.
  // Only the main buttons will trigger the form submit so here we only handle the default action.
  const onSubmit = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.useCallback)(event => {
    event.preventDefault();
    const submitMode = isSetupWithAnalytics ? _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.SETUP_MODE_WITH_ANALYTICS : '';
    submitForm({
      submitMode
    });
  }, [submitForm, isSetupWithAnalytics]);
  // Click handler for secondary option when setting up with option to include Analytics.
  const onSetupWithoutAnalytics = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.useCallback)(() => submitForm(), [submitForm]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("form", {
    className: "googlesitekit-tagmanager-setup__form",
    onSubmit: onSubmit,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_SetupErrorNotice__WEBPACK_IMPORTED_MODULE_11__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_10__.FormInstructions, {
      isSetup: true
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
      className: "googlesitekit-setup-module__inputs",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_10__.AccountSelect, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_10__.WebContainerSelect, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_10__.AMPContainerSelect, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_10__.TagCheckProgress, {})]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_10__.ContainerNames, {}), hasExistingTag && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_SetupUseSnippetSwitch__WEBPACK_IMPORTED_MODULE_12__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)("div", {
      className: "googlesitekit-setup-module__action",
      children: [isSetupWithAnalytics && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
          disabled: !canSubmitChanges,
          isSaving: isSavingWithAnalytics && isSaving
          // Show the spinner only when saving GA4 and GTM together.
          ,
          onClick: () => setIsSavingWithAnalytics(true),
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Continue to Analytics setup', 'google-site-kit')
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
          className: "googlesitekit-setup-module__sub-action",
          type: "button",
          onClick: onSetupWithoutAnalytics,
          disabled: !canSubmitChanges,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Complete setup without Analytics', 'google-site-kit')
        })]
      }), !isSetupWithAnalytics && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
        disabled: !canSubmitChanges || isSaving,
        isSaving: isSaving,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Complete setup', 'google-site-kit')
      })]
    })]
  });
}
SetupForm.propTypes = {
  finishSetup: (prop_types__WEBPACK_IMPORTED_MODULE_17___default().func)
};

/***/ }),

/***/ "./js/modules/tagmanager/components/setup/SetupMain.js":
/*!*************************************************************!*\
  !*** ./js/modules/tagmanager/components/setup/SetupMain.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupMain)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_graphics_tagmanager_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/graphics/tagmanager.svg */ "./svg/graphics/tagmanager.svg");
/* harmony import */ var _SetupForm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SetupForm */ "./js/modules/tagmanager/components/setup/SetupForm.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_hooks_useExistingTagEffect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/tagmanager/hooks/useExistingTagEffect */ "./js/modules/tagmanager/hooks/useExistingTagEffect.js");
/* harmony import */ var _js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/tagmanager/components/common */ "./js/modules/tagmanager/components/common/index.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Main setup component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









function SetupMain({
  finishSetup
}) {
  const accounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).getAccounts());
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).getAccountID());
  const hasExistingTag = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).hasExistingTag());
  const hasResolvedAccounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).hasFinishedResolution('getAccounts'));
  const isCreateAccount = _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.ACCOUNT_CREATE === accountID;

  // Set useSnippet to `false` if there is an existing tag and it is the same as the selected container ID.
  (0,_js_modules_tagmanager_hooks_useExistingTagEffect__WEBPACK_IMPORTED_MODULE_6__["default"])();
  let viewComponent;
  // Here we also check for `hasResolvedAccounts` to prevent showing a different case below
  // when the component initially loads and has yet to start fetching accounts.
  if (!hasResolvedAccounts || hasExistingTag === undefined) {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {});
  } else if (isCreateAccount || !accounts?.length) {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_modules_tagmanager_components_common__WEBPACK_IMPORTED_MODULE_7__.AccountCreate, {});
  } else {
    viewComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_SetupForm__WEBPACK_IMPORTED_MODULE_4__["default"], {
      finishSetup: finishSetup
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    className: "googlesitekit-setup-module googlesitekit-setup-module--tagmanager",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "googlesitekit-setup-module__step",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "googlesitekit-setup-module__logo",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_svg_graphics_tagmanager_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
          width: "40",
          height: "40"
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_8__["default"], {
        as: "h3",
        className: "googlesitekit-setup-module__title",
        size: "small",
        type: "headline",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)('Tag Manager', 'Service name', 'google-site-kit')
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
      className: "googlesitekit-setup-module__step",
      children: viewComponent
    })]
  });
}
SetupMain.propTypes = {
  finishSetup: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};
SetupMain.defaultProps = {
  finishSetup: () => {}
};

/***/ }),

/***/ "./js/modules/tagmanager/components/setup/SetupUseSnippetSwitch.js":
/*!*************************************************************************!*\
  !*** ./js/modules/tagmanager/components/setup/SetupUseSnippetSwitch.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupUseSnippetSwitch)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_components_common_UseSnippetSwitch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/components/common/UseSnippetSwitch */ "./js/modules/tagmanager/components/common/UseSnippetSwitch.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Tag Manager Setup Use Snippet Switch component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function SetupUseSnippetSwitch() {
  const primaryContainerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getPrimaryContainerID());
  const existingTag = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getExistingTag());
  const description = primaryContainerID === existingTag ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: existing tag ID */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('A tag %s for the selected container already exists on the site', 'google-site-kit'), existingTag)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Make sure you remove it if you want to place the same tag via Site Kit, otherwise they will be duplicated', 'google-site-kit')
    })]
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: existing tag ID */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An existing tag %s was found on the page', 'google-site-kit'), existingTag)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('If you prefer to collect data using that existing tag, please select the corresponding account and property above', 'google-site-kit')
    })]
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_modules_tagmanager_components_common_UseSnippetSwitch__WEBPACK_IMPORTED_MODULE_4__["default"], {
    description: description
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/components/setup/index.js":
/*!*********************************************************!*\
  !*** ./js/modules/tagmanager/components/setup/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SetupErrorNotice: () => (/* reexport safe */ _SetupErrorNotice__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   SetupForm: () => (/* reexport safe */ _SetupForm__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   SetupMain: () => (/* reexport safe */ _SetupMain__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   SetupUseSnippetSwitch: () => (/* reexport safe */ _SetupUseSnippetSwitch__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _SetupErrorNotice__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SetupErrorNotice */ "./js/modules/tagmanager/components/setup/SetupErrorNotice.js");
/* harmony import */ var _SetupForm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SetupForm */ "./js/modules/tagmanager/components/setup/SetupForm.js");
/* harmony import */ var _SetupMain__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SetupMain */ "./js/modules/tagmanager/components/setup/SetupMain.js");
/* harmony import */ var _SetupUseSnippetSwitch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SetupUseSnippetSwitch */ "./js/modules/tagmanager/components/setup/SetupUseSnippetSwitch.js");
/**
 * Tag Manager Setup components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */






/***/ }),

/***/ "./js/modules/tagmanager/constants.js":
/*!********************************************!*\
  !*** ./js/modules/tagmanager/constants.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_TAGMANAGER: () => (/* binding */ MODULE_SLUG_TAGMANAGER)
/* harmony export */ });
/**
 * Tag Manager module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_TAGMANAGER = 'tagmanager';

/***/ }),

/***/ "./js/modules/tagmanager/datastore/accounts.js":
/*!*****************************************************!*\
  !*** ./js/modules/tagmanager/datastore/accounts.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   baseActions: () => (/* binding */ baseActions),
/* harmony export */   baseInitialState: () => (/* binding */ baseInitialState),
/* harmony export */   baseReducer: () => (/* binding */ baseReducer),
/* harmony export */   baseResolvers: () => (/* binding */ baseResolvers),
/* harmony export */   baseSelectors: () => (/* binding */ baseSelectors),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/* harmony import */ var _js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/tagmanager/util/validation */ "./js/modules/tagmanager/util/validation.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/**
 * `modules/tagmanager` data store: accounts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */










// Actions
const RESET_ACCOUNTS = 'RESET_ACCOUNTS';
const fetchGetAccountsStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_8__.createFetchStore)({
  baseName: 'getAccounts',
  controlCallback: () => (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.get)('modules', _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_TAGMANAGER, 'accounts', null, {
    useCache: false
  }),
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, accounts) => {
    state.accounts = accounts;
  })
});
const baseInitialState = {
  accounts: undefined
};
const baseActions = {
  /**
   * Clears received accounts, and unsets related selections.
   *
   * The `getAccounts` selector will be invalidated to allow accounts to be re-fetched from the server.
   *
   * @since 1.12.0
   * @private
   */
  *resetAccounts() {
    const {
      dispatch
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    yield {
      payload: {},
      type: RESET_ACCOUNTS
    };
    dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).invalidateResolutionForStoreSelector('getAccounts');
  },
  /**
   * Selects the given account and makes related selections.
   *
   * @since 1.12.0
   * @private
   *
   * @param {string} accountID Tag Manager account ID to select.
   */
  selectAccount: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_3__.createValidatedAction)(accountID => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_7__.isValidAccountSelection)(accountID), 'A valid accountID selection is required to select.');
  }, function* (accountID) {
    const {
      dispatch,
      select,
      resolveSelect
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();

    // Do nothing if the accountID to select is the same as the current.
    if (accountID === select(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).getAccountID()) {
      return;
    }
    dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setSettings({
      accountID,
      containerID: '',
      internalContainerID: '',
      ampContainerID: '',
      internalAMPContainerID: ''
    });
    if (_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.ACCOUNT_CREATE === accountID || select(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).hasExistingTag()) {
      return;
    }

    // Trigger cascading selections.
    const {
      isAMP,
      isSecondaryAMP
    } = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
    if (!isAMP() || isSecondaryAMP()) {
      const webContainers = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.await(resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).getWebContainers(accountID));
      if (!webContainers.length) {
        dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setContainerID(_constants__WEBPACK_IMPORTED_MODULE_5__.CONTAINER_CREATE);
        dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setInternalContainerID('');
      } else if (webContainers.length === 1) {
        dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setContainerID(
        // eslint-disable-next-line sitekit/acronym-case
        webContainers[0].publicId);
        dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setInternalContainerID(
        // eslint-disable-next-line sitekit/acronym-case
        webContainers[0].containerId);
      }
    }
    if (isAMP()) {
      const ampContainers = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.await(resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).getAMPContainers(accountID));
      if (!ampContainers.length) {
        dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setAMPContainerID(_constants__WEBPACK_IMPORTED_MODULE_5__.CONTAINER_CREATE);
        dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setInternalAMPContainerID('');
      } else if (ampContainers.length === 1) {
        dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setAMPContainerID(
        // eslint-disable-next-line sitekit/acronym-case
        ampContainers[0].publicId);
        dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).setInternalAMPContainerID(
        // eslint-disable-next-line sitekit/acronym-case
        ampContainers[0].containerId);
      }
    }
  })
};
const baseReducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, {
  type
}) => {
  switch (type) {
    case RESET_ACCOUNTS:
      {
        state.accounts = undefined;
        state.settings.accountID = undefined;
        state.settings.ampContainerID = undefined;
        state.settings.containerID = undefined;
        state.settings.internalAMPContainerID = undefined;
        state.settings.internalContainerID = undefined;
        break;
      }
    default:
      break;
  }
});
const baseResolvers = {
  *getAccounts() {
    const {
      select,
      dispatch
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    let accounts = select(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).getAccounts();

    // Only fetch accounts if they have not been received yet.
    if (!accounts) {
      ({
        response: accounts
      } = yield fetchGetAccountsStore.actions.fetchGetAccounts());
    }
    if (accounts?.length === 1 && !select(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).getAccountID()) {
      dispatch(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).selectAccount(
      // eslint-disable-next-line sitekit/acronym-case
      accounts[0].accountId);
    }
  }
};
const baseSelectors = {
  /**
   * Gets all Google Tag Manager accounts this user can access.
   *
   * @since 1.11.0
   *
   * @param {Object} state Data store's state.
   * @return {?Array.<Object>} An array of account objects; `undefined` if not loaded.
   */
  getAccounts(state) {
    const {
      accounts
    } = state;
    return accounts;
  },
  /**
   * Checks whether accounts are currently being fetched.
   *
   * @since 1.11.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean} Whether accounts are currently being fetched or not.
   */
  isDoingGetAccounts: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_TAGMANAGER).isFetchingGetAccounts();
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.combineStores)(fetchGetAccountsStore, {
  initialState: baseInitialState,
  actions: baseActions,
  reducer: baseReducer,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const {
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
} = store;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/tagmanager/datastore/base.js":
/*!*************************************************!*\
  !*** ./js/modules/tagmanager/datastore/base.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-modules */ "googlesitekit-modules");
/* harmony import */ var googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./settings */ "./js/modules/tagmanager/datastore/settings.js");
/**
 * `modules/tagmanager` base data store
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




let baseModuleStore = googlesitekit_modules__WEBPACK_IMPORTED_MODULE_0___default().createModuleStore(_js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_TAGMANAGER, {
  ownedSettingsSlugs: ['accountID', 'ampContainerID', 'containerID', 'internalAMPContainerID', 'internalContainerID'],
  storeName: _constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_TAGMANAGER,
  settingSlugs: ['accountID', 'ampContainerID', 'containerID', 'internalContainerID', 'internalAMPContainerID', 'useSnippet', 'ownerID'],
  submitChanges: _settings__WEBPACK_IMPORTED_MODULE_3__.submitChanges,
  rollbackChanges: _settings__WEBPACK_IMPORTED_MODULE_3__.rollbackChanges,
  validateCanSubmitChanges: _settings__WEBPACK_IMPORTED_MODULE_3__.validateCanSubmitChanges,
  validateHaveSettingsChanged: _settings__WEBPACK_IMPORTED_MODULE_3__.validateHaveSettingsChanged
});

// Rename generated pieces to adhere to our convention.
baseModuleStore = (({
  actions,
  selectors,
  ...store
}) => {
  // eslint-disable-next-line sitekit/acronym-case
  const {
    setAmpContainerID,
    ...restActions
  } = actions;
  // eslint-disable-next-line sitekit/acronym-case
  const {
    getAmpContainerID,
    ...restSelectors
  } = selectors;
  return {
    ...store,
    actions: {
      ...restActions,
      // eslint-disable-next-line sitekit/acronym-case
      setAMPContainerID: setAmpContainerID
    },
    selectors: {
      ...restSelectors,
      // eslint-disable-next-line sitekit/acronym-case
      getAMPContainerID: getAmpContainerID
    }
  };
})(baseModuleStore);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseModuleStore);

/***/ }),

/***/ "./js/modules/tagmanager/datastore/constants.js":
/*!******************************************************!*\
  !*** ./js/modules/tagmanager/datastore/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCOUNT_CREATE: () => (/* binding */ ACCOUNT_CREATE),
/* harmony export */   CONTAINER_CREATE: () => (/* binding */ CONTAINER_CREATE),
/* harmony export */   CONTEXT_AMP: () => (/* binding */ CONTEXT_AMP),
/* harmony export */   CONTEXT_WEB: () => (/* binding */ CONTEXT_WEB),
/* harmony export */   EDIT_SCOPE: () => (/* binding */ EDIT_SCOPE),
/* harmony export */   FORM_SETUP: () => (/* binding */ FORM_SETUP),
/* harmony export */   MODULES_TAGMANAGER: () => (/* binding */ MODULES_TAGMANAGER),
/* harmony export */   READ_SCOPE: () => (/* binding */ READ_SCOPE),
/* harmony export */   SETUP_MODE_WITH_ANALYTICS: () => (/* binding */ SETUP_MODE_WITH_ANALYTICS)
/* harmony export */ });
/**
 * `modules/tagmanager` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_TAGMANAGER = 'modules/tagmanager';

// A special Account ID value used for the "Set up a new account" option.
const ACCOUNT_CREATE = 'account_create';
// A special Container ID value used for the "Set up a new container" option.
const CONTAINER_CREATE = 'container_create';
// Usage context for web containers.
const CONTEXT_WEB = 'web';
// Usage context for AMP containers.
const CONTEXT_AMP = 'amp';
// Form ID for the module setup form.
const FORM_SETUP = 'tagmanagerSetup';
// OAuth scope needed for viewing containers.
const READ_SCOPE = 'https://www.googleapis.com/auth/tagmanager.readonly';
// OAuth scope needed for creating containers.
const EDIT_SCOPE = 'https://www.googleapis.com/auth/tagmanager.edit.containers';
// A special setupMode value for when completing setup with Analytics.
const SETUP_MODE_WITH_ANALYTICS = 'SETUP_WITH_ANALYTICS';

/***/ }),

/***/ "./js/modules/tagmanager/datastore/containers.js":
/*!*******************************************************!*\
  !*** ./js/modules/tagmanager/datastore/containers.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/* harmony import */ var _js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/tagmanager/util/validation */ "./js/modules/tagmanager/util/validation.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/**
 * `modules/tagmanager` data store: containers.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */








const fetchGetContainersStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
  baseName: 'getContainers',
  argsToParams: accountID => {
    return {
      accountID
    };
  },
  validateParams: ({
    accountID
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID), 'A valid accountID is required to fetch containers.');
  },
  controlCallback: ({
    accountID
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.get)('modules', _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_TAGMANAGER, 'containers', {
      accountID
    }, {
      useCache: false
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, containers, {
    accountID
  }) => {
    state.containers[accountID] = containers;
  })
});
const fetchCreateContainerStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
  baseName: 'createContainer',
  argsToParams(accountID, usageContext, {
    containerName
  }) {
    return {
      accountID,
      usageContext,
      containerName
    };
  },
  validateParams: ({
    accountID,
    usageContext,
    containerName
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID), 'A valid accountID is required to create a container.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidUsageContext)(usageContext), 'A valid usageContext is required to create a container.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidContainerName)(containerName), 'A valid containerName is required to create a container.');
  },
  controlCallback: ({
    accountID,
    usageContext,
    containerName: name
  }) => {
    return (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.set)('modules', _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_TAGMANAGER, 'create-container', {
      accountID,
      usageContext,
      name
    });
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, container, {
    accountID
  }) => {
    if (!state.containers[accountID]) {
      state.containers[accountID] = [];
    }
    state.containers[accountID].push(container);
  })
});
const baseInitialState = {
  containers: {}
};
const baseActions = {
  /**
   * Creates a new Tag Manager container in the given account.
   *
   * @since 1.11.0
   *
   * @param {string} accountID          Google Tag Manager account ID.
   * @param {string} usageContext       Container usage context. (Either 'web', or 'amp').
   * @param {Object} args               Container arguments.
   * @param {string} args.containerName The name for a new container.
   * @return {Object} Object with `response` and `error`.
   */
  createContainer: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_7__.createValidatedAction)((accountID, usageContext, {
    containerName
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID), 'A valid accountID is required to create a container.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidUsageContext)(usageContext), 'A valid usageContext is required to create a container.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidContainerName)(containerName), 'A valid containerName is required to create a container.');
  }, function* (accountID, usageContext, {
    containerName
  }) {
    const {
      response,
      error
    } = yield fetchCreateContainerStore.actions.fetchCreateContainer(accountID, usageContext, {
      containerName
    });
    return {
      response,
      error
    };
  }),
  /**
   * Sets selected container settings for the given container ID of the current account.
   *
   * Supports selecting a container that has not been received yet.
   *
   * @since 1.12.0
   * @private
   *
   * @param {string} containerID Tag Manager container `publicId` of container to select.
   */
  selectContainerByID: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_7__.createValidatedAction)(containerID => {
    // This action relies on looking up the container in state to know what
    // settings to set the container IDs for. For this reason we cannot use this
    // for selecting the option to "set up a new container"
    // another instance here
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidContainerID)(containerID), 'A valid container ID is required to select a container by ID.');
  }, function* (containerID) {
    const {
      select,
      dispatch,
      resolveSelect
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    const accountID = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccountID();
    if (!(0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID)) {
      return;
    }

    // Containers may not be loaded yet for this account,
    // and no selections are done in the getContainers resolver, so we wait here.
    // This will not guarantee that containers exist, as an account may also have no containers
    // it will simply wait for `getContainers` to be resolved for this account ID.
    yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.await(resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainers(accountID));
    const container = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainerByID(accountID, containerID);
    if (!container) {
      // Do nothing if the container was not found.
      return;
    }
    if (container.usageContext.includes(_constants__WEBPACK_IMPORTED_MODULE_3__.CONTEXT_WEB)) {
      dispatch(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).setContainerID(containerID);
      dispatch(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).setInternalContainerID(
      // eslint-disable-next-line sitekit/acronym-case
      container.containerId);
    } else if (container.usageContext.includes(_constants__WEBPACK_IMPORTED_MODULE_3__.CONTEXT_AMP)) {
      dispatch(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).setAMPContainerID(containerID);
      dispatch(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).setInternalAMPContainerID(
      // eslint-disable-next-line sitekit/acronym-case
      container.containerId);
    }
  })
};
const baseControls = {};
function* resolveGetContainers(accountID) {
  const {
    resolveSelect
  } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
  yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.await(resolveSelect(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainers(accountID));
}
const baseResolvers = {
  *getContainers(accountID) {
    if (!(0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID)) {
      return;
    }
    const {
      select
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    if (!select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainers(accountID)) {
      yield fetchGetContainersStore.actions.fetchGetContainers(accountID);
    }
  },
  getWebContainers: resolveGetContainers,
  getAMPContainers: resolveGetContainers
};
const baseSelectors = {
  /**
   * Gets a container by its ID.
   *
   * @since 1.11.0
   *
   * @param {Object} state       Data store's state.
   * @param {string} accountID   Account ID to find container in.
   * @param {string} containerID Container (publicId) of container to get.
   * @return {(Object|null|undefined)} Container object if found, `null` if not found, or `undefined` if not loaded yet.
   */
  getContainerByID: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, accountID, containerID) => {
    // Select all containers of the account to find the container, regardless of usageContext.
    const containers = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainers(accountID);
    if (containers === undefined) {
      return undefined;
    }
    return containers.find(
    // eslint-disable-next-line sitekit/acronym-case
    ({
      publicId
    }) => containerID === publicId) || null;
  }),
  /**
   * Gets all web containers for the given account.
   *
   * @since 1.12.0
   *
   * @param {Object} state     Data store's state.
   * @param {string} accountID Account ID to get containers for.
   * @return {(Array|undefined)} Array of containers, or `undefined` if not loaded yet.
   */
  getWebContainers: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, accountID) => {
    const containers = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainers(accountID);
    if (!Array.isArray(containers)) {
      return undefined;
    }
    return containers.filter(({
      usageContext
    }) => usageContext.includes(_constants__WEBPACK_IMPORTED_MODULE_3__.CONTEXT_WEB));
  }),
  /**
   * Gets all AMP containers for the given account.
   *
   * @since 1.12.0
   *
   * @param {Object} state     Data store's state.
   * @param {string} accountID Account ID to get containers for.
   * @return {(Array|undefined)} Array of containers, or `undefined` if not loaded yet.
   */
  getAMPContainers: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, accountID) => {
    const containers = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainers(accountID);
    if (!Array.isArray(containers)) {
      return undefined;
    }
    return containers.filter(({
      usageContext
    }) => usageContext.includes(_constants__WEBPACK_IMPORTED_MODULE_3__.CONTEXT_AMP));
  }),
  /**
   * Gets all containers for the given account.
   *
   * @since 1.12.0
   *
   * @param {Object} state     Data store's state.
   * @param {string} accountID Account ID to get containers for.
   * @return {(Array|undefined)} Array of containers, or `undefined` if not loaded yet.
   */
  getContainers(state, accountID) {
    return state.containers[accountID];
  },
  /**
   * Checks if containers are currently being fetched for the given account or not.
   *
   * @since 1.12.0
   *
   * @param {Object} state     Data store's state.
   * @param {string} accountID Account ID to get containers for.
   * @return {boolean} True if containers are being fetched for the given account, otherwise false.
   */
  isDoingGetContainers: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, accountID) => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).isFetchingGetContainers(accountID);
  }),
  /**
   * Checks if any request for creating a container is in progress.
   *
   * @since 1.11.0
   *
   * @param {Object} state Data store's state.
   * @return {boolean} True if a request for create-container is in progress, otherwise false.
   */
  isDoingCreateContainer(state) {
    return Object.values(state.isFetchingCreateContainer).some(Boolean);
  },
  /**
   * Gets primary container ID based on the AMP mode.
   *
   * @since 1.75.0
   *
   * @return {(string|undefined)} Primary container ID or `undefined` if not loaded yet.
   */
  getPrimaryContainerID: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => () => {
    const isPrimaryAMP = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_SITE).isPrimaryAMP();
    if (undefined === isPrimaryAMP) {
      return undefined;
    }
    if (isPrimaryAMP) {
      return select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAMPContainerID();
    }
    return select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getContainerID();
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.combineStores)(fetchGetContainersStore, fetchCreateContainerStore, {
  initialState: baseInitialState,
  actions: baseActions,
  controls: baseControls,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const {
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
} = store;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/tagmanager/datastore/index.js":
/*!**************************************************!*\
  !*** ./js/modules/tagmanager/datastore/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   registerStore: () => (/* binding */ registerStore),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./base */ "./js/modules/tagmanager/datastore/base.js");
/* harmony import */ var _accounts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./accounts */ "./js/modules/tagmanager/datastore/accounts.js");
/* harmony import */ var _containers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./containers */ "./js/modules/tagmanager/datastore/containers.js");
/* harmony import */ var _tags__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./tags */ "./js/modules/tagmanager/datastore/tags.js");
/* harmony import */ var _versions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./versions */ "./js/modules/tagmanager/datastore/versions.js");
/* harmony import */ var _service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./service */ "./js/modules/tagmanager/datastore/service.js");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./settings */ "./js/modules/tagmanager/datastore/settings.js");
/**
 * `modules/tagmanager` data store
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */










const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores)(_base__WEBPACK_IMPORTED_MODULE_3__["default"], _accounts__WEBPACK_IMPORTED_MODULE_4__["default"], _containers__WEBPACK_IMPORTED_MODULE_5__["default"], _tags__WEBPACK_IMPORTED_MODULE_6__["default"], _versions__WEBPACK_IMPORTED_MODULE_7__["default"], (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_1__.createSnapshotStore)(_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_TAGMANAGER), _settings__WEBPACK_IMPORTED_MODULE_9__["default"], _service__WEBPACK_IMPORTED_MODULE_8__["default"]);
const {
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
} = store;
function registerStore(registry) {
  registry.registerStore(_constants__WEBPACK_IMPORTED_MODULE_2__.MODULES_TAGMANAGER, store);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/tagmanager/datastore/service.js":
/*!****************************************************!*\
  !*** ./js/modules/tagmanager/datastore/service.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/**
 * `modules/tagmanager` data store: service.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const selectors = {
  /**
   * Gets a URL to the service.
   *
   * @since 1.14.0
   *
   * @param {Object} state        Data store's state.
   * @param {Object} [args]       Object containing optional path and query args.
   * @param {string} [args.path]  A path to append to the base url.
   * @param {Object} [args.query] Object of query params to be added to the URL.
   * @return {(string|undefined)} The URL to the service, or `undefined` if not loaded.
   */
  getServiceURL: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.createRegistrySelector)(select => (state, {
    path,
    query
  } = {}) => {
    let serviceURL = 'https://tagmanager.google.com/';
    if (query) {
      serviceURL = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.addQueryArgs)(serviceURL, {
        ...query,
        utm_source: 'sitekit'
      });
    }
    if (path) {
      const sanitizedPath = `/${path.replace(/^\//, '')}`;
      serviceURL = `${serviceURL}#${sanitizedPath}`;
    }
    const accountChooserBaseURI = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getAccountChooserURL(serviceURL);
    if (accountChooserBaseURI === undefined) {
      return undefined;
    }
    return accountChooserBaseURI;
  })
};
const store = {
  selectors
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/tagmanager/datastore/settings.js":
/*!*****************************************************!*\
  !*** ./js/modules/tagmanager/datastore/settings.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INVARIANT_GTM_GA_PROPERTY_ID_MISMATCH: () => (/* binding */ INVARIANT_GTM_GA_PROPERTY_ID_MISMATCH),
/* harmony export */   INVARIANT_INVALID_ACCOUNT_ID: () => (/* binding */ INVARIANT_INVALID_ACCOUNT_ID),
/* harmony export */   INVARIANT_INVALID_AMP_CONTAINER_SELECTION: () => (/* binding */ INVARIANT_INVALID_AMP_CONTAINER_SELECTION),
/* harmony export */   INVARIANT_INVALID_AMP_INTERNAL_CONTAINER_ID: () => (/* binding */ INVARIANT_INVALID_AMP_INTERNAL_CONTAINER_ID),
/* harmony export */   INVARIANT_INVALID_CONTAINER_NAME: () => (/* binding */ INVARIANT_INVALID_CONTAINER_NAME),
/* harmony export */   INVARIANT_INVALID_CONTAINER_SELECTION: () => (/* binding */ INVARIANT_INVALID_CONTAINER_SELECTION),
/* harmony export */   INVARIANT_INVALID_INTERNAL_CONTAINER_ID: () => (/* binding */ INVARIANT_INVALID_INTERNAL_CONTAINER_ID),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   rollbackChanges: () => (/* binding */ rollbackChanges),
/* harmony export */   submitChanges: () => (/* binding */ submitChanges),
/* harmony export */   validateCanSubmitChanges: () => (/* binding */ validateCanSubmitChanges),
/* harmony export */   validateHaveSettingsChanged: () => (/* binding */ validateHaveSettingsChanged)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/tagmanager/util */ "./js/modules/tagmanager/util/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/* harmony import */ var _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/data/create-settings-store */ "./js/googlesitekit/data/create-settings-store.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/**
 * `modules/tagmanager` data store: settings.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */















// Invariant error messages.
const INVARIANT_INVALID_ACCOUNT_ID = 'a valid accountID is required to submit changes';
const INVARIANT_INVALID_AMP_CONTAINER_SELECTION = 'a valid ampContainerID selection is required to submit changes';
const INVARIANT_INVALID_AMP_INTERNAL_CONTAINER_ID = 'a valid internalAMPContainerID is required to submit changes';
const INVARIANT_INVALID_CONTAINER_SELECTION = 'a valid containerID selection is required to submit changes';
const INVARIANT_INVALID_INTERNAL_CONTAINER_ID = 'a valid internalContainerID is required to submit changes';
const INVARIANT_INVALID_CONTAINER_NAME = 'a valid container name is required to submit changes';
const INVARIANT_GTM_GA_PROPERTY_ID_MISMATCH = 'single GTM Analytics property ID must match Analytics property ID';
const store = {
  selectors: {
    areSettingsEditDependenciesLoaded: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => () => select(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).hasFinishedResolution('getAccounts'))
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);
async function submitChanges({
  select,
  dispatch
}) {
  const accountID = select(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).getAccountID();
  const containerID = select(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).getContainerID();
  if (containerID === _constants__WEBPACK_IMPORTED_MODULE_6__.CONTAINER_CREATE) {
    const containerName = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS).getValue(_constants__WEBPACK_IMPORTED_MODULE_6__.FORM_SETUP, 'containerName');
    const {
      response: container,
      error
    } = await dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).createContainer(accountID, _constants__WEBPACK_IMPORTED_MODULE_6__.CONTEXT_WEB, {
      containerName
    });
    if (error) {
      return {
        error
      };
    }
    await dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).setContainerID(
    // eslint-disable-next-line sitekit/acronym-case
    container.publicId);
    await dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).setInternalContainerID(
    // eslint-disable-next-line sitekit/acronym-case
    container.containerId);
  }
  const ampContainerID = select(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).getAMPContainerID();
  if (ampContainerID === _constants__WEBPACK_IMPORTED_MODULE_6__.CONTAINER_CREATE) {
    const containerName = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS).getValue(_constants__WEBPACK_IMPORTED_MODULE_6__.FORM_SETUP, 'ampContainerName');
    const {
      response: container,
      error
    } = await dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).createContainer(accountID, _constants__WEBPACK_IMPORTED_MODULE_6__.CONTEXT_AMP, {
      containerName
    });
    if (error) {
      return {
        error
      };
    }
    await dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).setAMPContainerID(
    // eslint-disable-next-line sitekit/acronym-case
    container.publicId);
    await dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).setInternalAMPContainerID(
    // eslint-disable-next-line sitekit/acronym-case
    container.containerId);
  }

  // This action shouldn't be called if settings haven't changed,
  // but this prevents errors in tests.
  if (select(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).haveSettingsChanged()) {
    const {
      error
    } = await dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).saveSettings();
    if (error) {
      return {
        error
      };
    }

    // Fetch the latest settings in the Analytics store so that we can update
    // the filtered value of canUseSnippet.
    const analyticsModuleConnected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_13__.MODULE_SLUG_ANALYTICS_4);
    if (analyticsModuleConnected) {
      await dispatch(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_12__.MODULES_ANALYTICS_4).fetchGetSettings();
    }
  }
  if (select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_SITE).haveGoogleTagGatewaySettingsChanged()) {
    const {
      error
    } = await dispatch(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_SITE).saveGoogleTagGatewaySettings();
    if (error) {
      return {
        error
      };
    }
    if (select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_SITE).isGoogleTagGatewayEnabled() && !select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_14__.CORE_NOTIFICATIONS).isNotificationDismissed(_js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_15__.GTG_SETUP_CTA_BANNER_NOTIFICATION)) {
      const {
        error: dismissError
      } = (await dispatch(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_14__.CORE_NOTIFICATIONS).dismissNotification(_js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_15__.GTG_SETUP_CTA_BANNER_NOTIFICATION)) || {};
      if (dismissError) {
        return {
          error: dismissError
        };
      }
    }
  }
  await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.invalidateCache)('modules', _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_7__.MODULE_SLUG_TAGMANAGER);
  return {};
}
function validateCanSubmitChanges(select) {
  const strictSelect = (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_11__.createStrictSelect)(select);
  // Strict select will cause all selector functions to throw an error
  // if `undefined` is returned, otherwise it behaves the same as `select`.
  // This ensures that the selector returns `false` until all data dependencies are resolved.
  const {
    getAccountID,
    getContainerID,
    getContainers,
    getAMPContainerID,
    getInternalContainerID,
    getInternalAMPContainerID,
    haveSettingsChanged,
    isDoingSubmitChanges
  } = strictSelect(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER);
  const {
    isAMP,
    isSecondaryAMP
  } = strictSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_SITE);
  const accountID = getAccountID();

  // Note: these error messages are referenced in test assertions.
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(!isDoingSubmitChanges(), _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_8__.INVARIANT_DOING_SUBMIT_CHANGES);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(haveSettingsChanged(), _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_8__.INVARIANT_SETTINGS_NOT_CHANGED);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID), INVARIANT_INVALID_ACCOUNT_ID);
  const containerID = getContainerID();
  if (containerID === _constants__WEBPACK_IMPORTED_MODULE_6__.CONTAINER_CREATE) {
    const containerName = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS).getValue(_constants__WEBPACK_IMPORTED_MODULE_6__.FORM_SETUP, 'containerName');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidContainerName)(containerName), INVARIANT_INVALID_CONTAINER_NAME);
    const containers = getContainers(accountID);
    const normalizedContainerName = (0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.getNormalizedContainerName)(containerName);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isUniqueContainerName)(containerName, containers), `a container with "${normalizedContainerName}" name already exists`);
  }
  if (isAMP()) {
    const ampContainerID = getAMPContainerID();

    // If AMP is active, the AMP container ID must be valid, regardless of mode.
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidContainerSelection)(ampContainerID), INVARIANT_INVALID_AMP_CONTAINER_SELECTION);
    // If AMP is active, and a valid AMP container ID is selected, the internal ID must also be valid.
    if ((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidContainerID)(ampContainerID)) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidInternalContainerID)(getInternalAMPContainerID()), INVARIANT_INVALID_AMP_INTERNAL_CONTAINER_ID);
    }
    if (ampContainerID === _constants__WEBPACK_IMPORTED_MODULE_6__.CONTAINER_CREATE) {
      const ampContainerName = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_FORMS).getValue(_constants__WEBPACK_IMPORTED_MODULE_6__.FORM_SETUP, 'ampContainerName');
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidContainerName)(ampContainerName), INVARIANT_INVALID_CONTAINER_NAME);
      const containers = getContainers(accountID);
      const normalizedContainerName = (0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.getNormalizedContainerName)(ampContainerName);
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isUniqueContainerName)(ampContainerName, containers), `an AMP container with "${normalizedContainerName}" name already exists`);
    }
  }
  if (!isAMP() || isSecondaryAMP()) {
    // If AMP is not active, or in a secondary mode, validate the web container IDs.
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidContainerSelection)(getContainerID()), INVARIANT_INVALID_CONTAINER_SELECTION);
    // If a valid container ID is selected, the internal ID must also be valid.
    if ((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidContainerID)(getContainerID())) {
      invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util__WEBPACK_IMPORTED_MODULE_5__.isValidInternalContainerID)(getInternalContainerID()), INVARIANT_INVALID_INTERNAL_CONTAINER_ID);
    }
  }
}
function rollbackChanges({
  select,
  dispatch
}) {
  if (select(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).haveSettingsChanged()) {
    dispatch(_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_TAGMANAGER).rollbackSettings();
    dispatch(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_SITE).resetGoogleTagGatewaySettings();
  }
}
function validateHaveSettingsChanged(select, state, keys) {
  const {
    settings,
    savedSettings
  } = state;
  const haveGoogleTagGatewaySettingsChanged = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_10__.CORE_SITE).haveGoogleTagGatewaySettingsChanged();
  if (keys) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)((0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(settings, keys), (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(savedSettings, keys)) || haveGoogleTagGatewaySettingsChanged, _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_8__.INVARIANT_SETTINGS_NOT_CHANGED);
  }
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isEqual)(settings, savedSettings) || haveGoogleTagGatewaySettingsChanged, _js_googlesitekit_data_create_settings_store__WEBPACK_IMPORTED_MODULE_8__.INVARIANT_SETTINGS_NOT_CHANGED);
}

/***/ }),

/***/ "./js/modules/tagmanager/datastore/tags.js":
/*!*************************************************!*\
  !*** ./js/modules/tagmanager/datastore/tags.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/tagmanager/util/validation */ "./js/modules/tagmanager/util/validation.js");
/* harmony import */ var _js_googlesitekit_data_create_existing_tag_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/data/create-existing-tag-store */ "./js/googlesitekit/data/create-existing-tag-store.js");
/* harmony import */ var _js_modules_tagmanager_util_tag_matchers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/tagmanager/util/tag-matchers */ "./js/modules/tagmanager/util/tag-matchers.js");
/**
 * `modules/tagmanager` data store: existing tag.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




const store = (0,_js_googlesitekit_data_create_existing_tag_store__WEBPACK_IMPORTED_MODULE_2__.createExistingTagStore)({
  storeName: _constants__WEBPACK_IMPORTED_MODULE_0__.MODULES_TAGMANAGER,
  tagMatchers: _js_modules_tagmanager_util_tag_matchers__WEBPACK_IMPORTED_MODULE_3__["default"],
  isValidTag: _js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_1__.isValidContainerID
});
const {
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
} = store;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/tagmanager/datastore/versions.js":
/*!*****************************************************!*\
  !*** ./js/modules/tagmanager/datastore/versions.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/tagmanager/constants */ "./js/modules/tagmanager/constants.js");
/* harmony import */ var _js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/tagmanager/util/validation */ "./js/modules/tagmanager/util/validation.js");
/* harmony import */ var _js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/data/create-fetch-store */ "./js/googlesitekit/data/create-fetch-store.js");
/* harmony import */ var _js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/utils/validation */ "./js/modules/analytics-4/utils/validation.js");
/**
 * `modules/tagmanager` data store: versions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */







const fetchGetLiveContainerVersionStore = (0,_js_googlesitekit_data_create_fetch_store__WEBPACK_IMPORTED_MODULE_6__.createFetchStore)({
  baseName: 'getLiveContainerVersion',
  argsToParams: (accountID, internalContainerID) => {
    return {
      accountID,
      internalContainerID
    };
  },
  validateParams: ({
    accountID,
    internalContainerID
  } = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID), 'A valid accountID is required to fetch or receive a live container version.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidInternalContainerID)(internalContainerID), 'A valid internalContainerID is required to fetch or receive a live container version.');
  },
  controlCallback: async ({
    accountID,
    internalContainerID
  }) => {
    try {
      return await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_1__.get)('modules', _js_modules_tagmanager_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_TAGMANAGER, 'live-container-version', {
        accountID,
        internalContainerID
      }, {
        useCache: false
      });
    } catch (err) {
      // If the container has no published version, it will error with a 404
      // and the message will be "Published container version not found".
      // If the user has no permission to access the container, the error is also a 404
      // with a different message. In this case or any other case, we want to display
      // the error message along with the option to retry, so we allow it to be thrown
      // but filter out the former case.
      if (404 === err.code && err.message.includes('container version not found')) {
        return null;
      }
      throw err;
    }
  },
  reducerCallback: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createReducer)((state, liveContainerVersion, {
    accountID,
    internalContainerID
  }) => {
    state.liveContainerVersions[`${accountID}::${internalContainerID}`] = liveContainerVersion;
  })
});
const baseInitialState = {
  liveContainerVersions: {}
};
const baseResolvers = {
  *getLiveContainerVersion(accountID, internalContainerID) {
    if (!(0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID) || !(0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidInternalContainerID)(internalContainerID)) {
      return;
    }
    const {
      select
    } = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.commonActions.getRegistry();
    if (undefined === select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getLiveContainerVersion(accountID, internalContainerID)) {
      yield fetchGetLiveContainerVersionStore.actions.fetchGetLiveContainerVersion(accountID, internalContainerID);
    }
  }
};
const baseSelectors = {
  /**
   * Gets the first Google Tag object within the current live container for the given account and internal container ID.
   *
   * @since 1.121.0
   *
   * @param {Object} state               Data store's state.
   * @param {string} accountID           Account ID the container belongs to.
   * @param {string} internalContainerID Internal container ID to get the Analytics tag for.
   * @return {(Object|null|undefined)} Live container Google tag object, `null` if none exists, or `undefined` if not loaded yet.
   */
  getLiveContainerGoogleTag: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => function (state, accountID, internalContainerID) {
    const liveContainerVersion = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getLiveContainerVersion(accountID, internalContainerID);
    if (liveContainerVersion === undefined) {
      return undefined;
    }
    if (liveContainerVersion?.tag) {
      return liveContainerVersion.tag.find(({
        type
      }) => type === 'googtag') || null;
    }
    return null;
  }),
  /**
   * Gets the first Google Tag ID within the live container for the given account and container ID.
   *
   * @since 1.121.0
   *
   * @param {Object} state               Data store's state.
   * @param {string} accountID           Account ID the container belongs to.
   * @param {string} internalContainerID Internal container ID to get the Analytics tag for.
   * @return {(string|null|undefined)} Google Tag ID if present and valid, `null` if none exists or not valid, or `undefined` if not loaded yet.
   */
  getLiveContainerGoogleTagID: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => function (state, accountID, internalContainerID) {
    const googleTag = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getLiveContainerGoogleTag(accountID, internalContainerID);
    if (googleTag === undefined) {
      return undefined;
    }
    if (googleTag?.parameter) {
      // Check if the tag ID is provided directly on the tag first.
      let tagID = googleTag.parameter.find(({
        key
      }) => key === 'tagId')?.value;

      // If the tag ID is a variable, parse out the name and look up its value.
      if (tagID?.startsWith('{{')) {
        tagID = tagID.replace(/(\{\{|\}\})/g, '');
        const constantVariable = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getLiveContainerVariable(accountID, internalContainerID, tagID);
        tagID = constantVariable?.parameter.find(({
          key
        }) => key === 'value')?.value;
      }

      // Finally, check that whatever was found is a valid Google Tag ID.
      if ((0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_7__.isValidGoogleTagID)(tagID)) {
        return tagID;
      }
    }
    return null;
  }),
  /**
   * Gets a Google Tag ID, if any, for the currently selected GTM account and container.
   *
   * @since 1.121.0
   *
   * @return {(string|null|undefined)} Google Tag ID string, or `null` if none, or `undefined` if not fully loaded.
   */
  getCurrentGTMGoogleTagID: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => function () {
    const accountID = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getAccountID();
    if (!(0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidAccountID)(accountID)) {
      return null;
    }
    const internalContainerID = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getInternalContainerID();
    if (!(0,_js_modules_tagmanager_util_validation__WEBPACK_IMPORTED_MODULE_5__.isValidInternalContainerID)(internalContainerID)) {
      return null;
    }
    return select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getLiveContainerGoogleTagID(accountID, internalContainerID);
  }),
  /**
   * Gets the live container variable object by the given name for the given account and container ID.
   *
   * @since 1.18.0
   *
   * @param {Object} state               Data store's state.
   * @param {string} accountID           Account ID the container belongs to.
   * @param {string} internalContainerID Internal container ID to get version for.
   * @param {string} variableName        Variable name to retrive.
   * @return {(Object|null|undefined)} Live container version object, `null` if none exists, or `undefined` if not loaded yet.
   */
  getLiveContainerVariable: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => function (state, accountID, internalContainerID, variableName) {
    const liveContainerVersion = select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).getLiveContainerVersion(accountID, internalContainerID);
    if (liveContainerVersion === undefined) {
      return undefined;
    }
    if (liveContainerVersion?.variable) {
      return liveContainerVersion.variable.find(({
        name
      }) => name === variableName) || null;
    }
    return null;
  }),
  /**
   * Gets the live container version for the given account and container IDs.
   *
   * @since 1.11.0
   *
   * @param {Object} state               Data store's state.
   * @param {string} accountID           Account ID the container belongs to.
   * @param {string} internalContainerID Internal container ID to get version for.
   * @return {(Object|null|undefined)} Live container version object, `null` if none exists, or `undefined` if not loaded yet.
   */
  getLiveContainerVersion(state, accountID, internalContainerID) {
    return state.liveContainerVersions[`${accountID}::${internalContainerID}`];
  },
  /**
   * Checks whether or not the live container version is being fetched for the given account and container IDs.
   *
   * @since 1.11.0
   *
   * @param {Object} state               Data store's state.
   * @param {string} accountID           Account ID the container belongs to.
   * @param {string} internalContainerID Internal container ID to get version for.
   * @return {(boolean|undefined)} True if the live container version is being fetched, otherwise false.
   */
  isDoingGetLiveContainerVersion: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistrySelector)(select => (state, accountID, internalContainerID) => {
    return select(_constants__WEBPACK_IMPORTED_MODULE_3__.MODULES_TAGMANAGER).isFetchingGetLiveContainerVersion(accountID, internalContainerID);
  })
};
const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.combineStores)(fetchGetLiveContainerVersionStore, {
  initialState: baseInitialState,
  resolvers: baseResolvers,
  selectors: baseSelectors
});
const {
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
} = store;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/modules/tagmanager/hooks/useExistingTagEffect.js":
/*!*************************************************************!*\
  !*** ./js/modules/tagmanager/hooks/useExistingTagEffect.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useExistingTagEffect)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/**
 * Tag Manager useExistingTag custom hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useExistingTagEffect() {
  const existingTag = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_TAGMANAGER).getExistingTag());
  const containerID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_TAGMANAGER).getPrimaryContainerID());
  const skipEffect = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useRef)(true);
  const {
    setUseSnippet
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.MODULES_TAGMANAGER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (existingTag && containerID !== undefined) {
      if (containerID === '' || skipEffect.current) {
        skipEffect.current = false;
        return;
      }
      if (existingTag === containerID) {
        setUseSnippet(false);
      } else {
        setUseSnippet(true);
      }
    }
  }, [containerID, existingTag, setUseSnippet]);
}

/***/ }),

/***/ "./js/modules/tagmanager/index.js":
/*!****************************************!*\
  !*** ./js/modules/tagmanager/index.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   registerModule: () => (/* binding */ registerModule),
/* harmony export */   registerStore: () => (/* reexport safe */ _datastore__WEBPACK_IMPORTED_MODULE_6__.registerStore)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_setup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/setup */ "./js/modules/tagmanager/components/setup/index.js");
/* harmony import */ var _components_settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/settings */ "./js/modules/tagmanager/components/settings/index.js");
/* harmony import */ var _svg_graphics_tagmanager_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/graphics/tagmanager.svg */ "./svg/graphics/tagmanager.svg");
/* harmony import */ var _datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./js/modules/tagmanager/constants.js");
/* harmony import */ var _datastore__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./datastore */ "./js/modules/tagmanager/datastore/index.js");
/**
 * Tag Manager module initialization.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function registerModule(modules) {
  modules.registerModule(_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_TAGMANAGER, {
    storeName: _datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_TAGMANAGER,
    SettingsEditComponent: _components_settings__WEBPACK_IMPORTED_MODULE_2__.SettingsEdit,
    SettingsViewComponent: _components_settings__WEBPACK_IMPORTED_MODULE_2__.SettingsView,
    SetupComponent: _components_setup__WEBPACK_IMPORTED_MODULE_1__.SetupMain,
    Icon: _svg_graphics_tagmanager_svg__WEBPACK_IMPORTED_MODULE_3__["default"],
    features: [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You will not be able to create tags without updating code', 'google-site-kit')]
  });
}

/***/ }),

/***/ "./js/modules/tagmanager/util/container.js":
/*!*************************************************!*\
  !*** ./js/modules/tagmanager/util/container.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNormalizedContainerName: () => (/* binding */ getNormalizedContainerName)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Container utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Gets normalized container name.
 *
 * @since 1.20.0
 *
 * @param {string} containerName Container name to normalize.
 * @return {string} Normalized container name.
 */
function getNormalizedContainerName(containerName) {
  let sanitizedContainerName = containerName;

  // Decode html entities.
  sanitizedContainerName = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(sanitizedContainerName);
  // Remove any leading or trailing whitespace.
  sanitizedContainerName = sanitizedContainerName.trim();
  // Must not start with an underscore.
  sanitizedContainerName = sanitizedContainerName.replace(/^_+/, '');
  // Convert accents to basic characters to prevent them from being stripped.
  sanitizedContainerName = sanitizedContainerName.normalize('NFD').replace(/[\u0300-\u036f]/g, '');
  // Strip all non-simple characters.
  sanitizedContainerName = sanitizedContainerName.replace(/[^a-zA-Z0-9_., -]/g, '');
  // Collapse multiple whitespaces.
  sanitizedContainerName = sanitizedContainerName.replace(/\s+/g, ' ');
  return sanitizedContainerName;
}

/***/ }),

/***/ "./js/modules/tagmanager/util/get-containers.js":
/*!******************************************************!*\
  !*** ./js/modules/tagmanager/util/get-containers.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getContainers)
/* harmony export */ });
/**
 * Gets an object of utility functions for filtering the given list of containers.
 *
 * @since 1.4.0
 *
 * @param {Array} containers Containers to filter.
 * @return {Object} Object with keys mapping to utility functions to operate on given containers.
 */
function getContainers(containers) {
  return {
    /**
     * Gets containers that include the given usage context.
     *
     * @since 1.4.0
     *
     * @param {string} context The context to filter by.
     * @return {Array} Containers with the given usage context.
     */
    byContext: context => containers.filter(c => c.usageContext.includes(context))
  };
}

/***/ }),

/***/ "./js/modules/tagmanager/util/index.js":
/*!*********************************************!*\
  !*** ./js/modules/tagmanager/util/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getContainers: () => (/* reexport safe */ _get_containers__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   getNormalizedContainerName: () => (/* reexport safe */ _container__WEBPACK_IMPORTED_MODULE_0__.getNormalizedContainerName),
/* harmony export */   isUniqueContainerName: () => (/* reexport safe */ _validation__WEBPACK_IMPORTED_MODULE_1__.isUniqueContainerName),
/* harmony export */   isValidAccountID: () => (/* reexport safe */ _validation__WEBPACK_IMPORTED_MODULE_1__.isValidAccountID),
/* harmony export */   isValidAccountSelection: () => (/* reexport safe */ _validation__WEBPACK_IMPORTED_MODULE_1__.isValidAccountSelection),
/* harmony export */   isValidContainerID: () => (/* reexport safe */ _validation__WEBPACK_IMPORTED_MODULE_1__.isValidContainerID),
/* harmony export */   isValidContainerName: () => (/* reexport safe */ _validation__WEBPACK_IMPORTED_MODULE_1__.isValidContainerName),
/* harmony export */   isValidContainerSelection: () => (/* reexport safe */ _validation__WEBPACK_IMPORTED_MODULE_1__.isValidContainerSelection),
/* harmony export */   isValidInternalContainerID: () => (/* reexport safe */ _validation__WEBPACK_IMPORTED_MODULE_1__.isValidInternalContainerID),
/* harmony export */   isValidUsageContext: () => (/* reexport safe */ _validation__WEBPACK_IMPORTED_MODULE_1__.isValidUsageContext),
/* harmony export */   tagMatchers: () => (/* reexport safe */ _tag_matchers__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./container */ "./js/modules/tagmanager/util/container.js");
/* harmony import */ var _validation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./validation */ "./js/modules/tagmanager/util/validation.js");
/* harmony import */ var _get_containers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./get-containers */ "./js/modules/tagmanager/util/get-containers.js");
/* harmony import */ var _tag_matchers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./tag-matchers */ "./js/modules/tagmanager/util/tag-matchers.js");
/**
 * Utilities for the Tag Manager module.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */






/***/ }),

/***/ "./js/modules/tagmanager/util/tag-matchers.js":
/*!****************************************************!*\
  !*** ./js/modules/tagmanager/util/tag-matchers.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Tag matching patterns.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ([
// Detect injection script. (Google provided code, duracelltomi-google-tag-manager, metronet-tag-manager (uses user-provided))
/<script[^>]*>[^>]+?www.googletagmanager.com\/gtm[^>]+?['|"](GTM-[0-9A-Z]+)['|"]/,
// Detect gtm.js script calls.
/<script[^>]*src=['|"]https:\/\/www.googletagmanager.com\/gtm\.js\?id=(GTM-[0-9A-Z]+)['|"]/,
// Detect iframe version for no-js.
/<script[^>]*src=['|"]https:\/\/www.googletagmanager.com\/ns.html\?id=(GTM-[0-9A-Z]+)['|"]/,
// Detect amp tag.
/<amp-analytics [^>]*config=['|"]https:\/\/www.googletagmanager.com\/amp.json\?id=(GTM-[0-9A-Z]+)['|"]/]);

/***/ }),

/***/ "./js/modules/tagmanager/util/validation.js":
/*!**************************************************!*\
  !*** ./js/modules/tagmanager/util/validation.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isUniqueContainerName: () => (/* binding */ isUniqueContainerName),
/* harmony export */   isValidAccountID: () => (/* binding */ isValidAccountID),
/* harmony export */   isValidAccountSelection: () => (/* binding */ isValidAccountSelection),
/* harmony export */   isValidContainerID: () => (/* binding */ isValidContainerID),
/* harmony export */   isValidContainerName: () => (/* binding */ isValidContainerName),
/* harmony export */   isValidContainerSelection: () => (/* binding */ isValidContainerSelection),
/* harmony export */   isValidInternalContainerID: () => (/* binding */ isValidInternalContainerID),
/* harmony export */   isValidUsageContext: () => (/* binding */ isValidUsageContext)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./container */ "./js/modules/tagmanager/util/container.js");
/**
 * Validation utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




/**
 * Checks if the given account ID appears to be a valid Tag Manager account.
 *
 * @since 1.11.0
 *
 * @param {(string|number)} accountID Account ID to test.
 * @return {boolean} Whether or not the given account ID is valid.
 */
function isValidAccountID(accountID) {
  return (0,_js_util__WEBPACK_IMPORTED_MODULE_0__.isValidNumericID)(accountID);
}

/**
 * Checks if the given value is a valid selection for an Account.
 *
 * @since 1.11.0
 *
 * @param {string} value Selected value.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidAccountSelection(value) {
  if (value === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ACCOUNT_CREATE) {
    return true;
  }
  return isValidAccountID(value);
}

/**
 * Checks if the given container ID appears to be a valid GTM container.
 *
 * @since 1.11.0
 *
 * @param {string} containerID Container ID to check.
 * @return {boolean} Whether or not the given container ID is valid.
 */
function isValidContainerID(containerID) {
  return typeof containerID === 'string' && /^GTM-[A-Z0-9]+$/.test(containerID);
}

/**
 * Checks if the given container name appears to be valid.
 *
 * @since 1.20.0
 *
 * @param {string} containerName Container name to test.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidContainerName(containerName) {
  return typeof containerName === 'string' && (0,_container__WEBPACK_IMPORTED_MODULE_2__.getNormalizedContainerName)(containerName).length > 0;
}

/**
 * Checks if the given container name is unique across account containers.
 *
 * @since 1.20.0
 *
 * @param {string}         containerName Container name to test.
 * @param {Array.<Object>} containers    Available containers.
 * @return {boolean} True if unique, otherwise false.
 */
function isUniqueContainerName(containerName, containers) {
  const normalizedContainerName = (0,_container__WEBPACK_IMPORTED_MODULE_2__.getNormalizedContainerName)(containerName);
  return !Array.isArray(containers) || !containers.some(({
    name
  }) => (0,_container__WEBPACK_IMPORTED_MODULE_2__.getNormalizedContainerName)(name) === normalizedContainerName);
}

/**
 * Checks if the given value is a valid selection for a container.
 *
 * @since 1.11.0
 *
 * @param {string} value Selected value.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidContainerSelection(value) {
  if (value === _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CONTAINER_CREATE) {
    return true;
  }
  return isValidContainerID(value);
}

/**
 * Checks if the given internal container ID appears to be valid.
 *
 * @since 1.11.0
 *
 * @param {(string|number)} internalContainerID Internal container ID to test.
 * @return {boolean} Whether or not the given ID is valid.
 */
function isValidInternalContainerID(internalContainerID) {
  return (0,_js_util__WEBPACK_IMPORTED_MODULE_0__.isValidNumericID)(internalContainerID);
}

/**
 * Checks if the given context is a valid container usage context.
 *
 * @since 1.11.0
 *
 * @param {string} context A usage context to check.
 * @return {boolean} Whether or not the given context is valid.
 */
function isValidUsageContext(context) {
  return [_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CONTEXT_WEB, _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CONTEXT_AMP].includes(context);
}

/***/ }),

/***/ "./js/util/chart.js":
/*!**************************!*\
  !*** ./js/util/chart.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* binding */ calculateDifferenceBetweenChartValues),
/* harmony export */   getChartDifferenceArrow: () => (/* binding */ getChartDifferenceArrow),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Utility functions for charts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Gets the up/down SVG arrow for Google Chart tooltips.
 *
 * @since 1.30.0
 *
 * @param {number}  difference            The difference which can be positive or negative.
 * @param {string}  [options]             Options to be passed to the ChangeArrow component.
 * @param {boolean} [options.invertColor] Whether we need to reverse the +/- colors of the arrow.
 * @return {string} SVG for the +/- difference.
 */

function getChartDifferenceArrow(difference, options = {}) {
  if (Number.isNaN(Number(difference))) {
    return '';
  }
  const {
    invertColor = false
  } = options;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["default"])(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__["default"], {
    direction: difference > 0 ? 'up' : 'down',
    invertColor: invertColor
  }));
}

/**
 * Checks if there is a single row of data or one row is contributing 100% of the total for a given dimension.
 *
 * @since 1.31.0
 *
 * @param {Array.<Object>} report An array of report data objects.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  if (report?.[0]?.data?.rows?.length === 1 || report?.[0]?.data?.rows?.[0]?.metrics?.[0]?.values?.[0] === report?.[0]?.data?.totals?.[0]?.values?.[0]) {
    return true;
  }
  return false;
}

/**
 * Calculates difference between two chart values.
 *
 * @since 1.48.0
 *
 * @param {number} currentValue  Current chart value.
 * @param {number} previousValue Previous chart value.
 * @return {number} The difference.
 */
function calculateDifferenceBetweenChartValues(currentValue, previousValue) {
  if (currentValue > 0 && previousValue > 0) {
    return currentValue / previousValue - 1;
  }
  if (currentValue > 0) {
    return 1;
  }
  if (previousValue > 0) {
    return -1;
  }
  return 0;
}

/***/ }),

/***/ "./js/util/convert-time.js":
/*!*********************************!*\
  !*** ./js/util/convert-time.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* binding */ convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* binding */ convertSecondsToArray)
/* harmony export */ });
/**
 * Time related utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts seconds into an array with the following values [HH, MM, SS, MS] as described below.
 * HH: hours.
 * MM: minutes.
 * SS: seconds.
 * MS: milliseconds.
 *
 * For example, passing 196.385 returns [ 0, 3, 16, 385 ].
 *
 * @since 1.27.0
 *
 * @param {number} seconds The number of seconds.
 * @return {Array} Array containing the hours, minutes, seconds and milliseconds.
 */
function convertSecondsToArray(seconds) {
  seconds = parseFloat(seconds);
  if (isNaN(seconds) || 0 === seconds) {
    return [0, 0, 0, 0];
  }
  return [Math.floor(seconds / 60 / 60), Math.floor(seconds / 60 % 60), Math.floor(seconds % 60), Math.floor(seconds * 1000) - Math.floor(seconds) * 1000];
}

/**
 * Converts Date time string into UNIX timestamp in milliseconds.
 *
 * For example, passing "2014-10-02T15:01:23Z" returns 1412262083000.
 *
 * @since 1.116.0
 *
 * @param {string} dateStringValue The date time string.
 * @return {number} UNIX timestamp in milliseconds.
 */
function convertDateStringToUNIXTimestamp(dateStringValue) {
  const unixTimestamp = dateStringValue && !Number.isInteger(dateStringValue) ?
  // Valid use of `new Date()` with an argument, because this should only
  // be passed full time strings, not `YYYY-MM-DD` style dates.
  //
  // See: https://github.com/google/site-kit-wp/pull/9459#discussion_r1790660073
  // eslint-disable-next-line sitekit/no-direct-date
  new Date(dateStringValue).getTime() : dateStringValue;
  if (isNaN(unixTimestamp) || !unixTimestamp) {
    return 0;
  }
  return unixTimestamp;
}

/***/ }),

/***/ "./js/util/dates.js":
/*!**************************!*\
  !*** ./js/util/dates.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* binding */ DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* binding */ HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* binding */ INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* binding */ INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* binding */ INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* binding */ MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* binding */ MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* binding */ WEEK_IN_SECONDS),
/* harmony export */   dateSub: () => (/* binding */ dateSub),
/* harmony export */   getAvailableDateRanges: () => (/* binding */ getAvailableDateRanges),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* binding */ getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* binding */ getDateString),
/* harmony export */   getPreviousDate: () => (/* binding */ getPreviousDate),
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidDateString: () => (/* binding */ isValidDateString),
/* harmony export */   stringToDate: () => (/* binding */ stringToDate)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

const INVALID_DATE_INSTANCE_ERROR = 'Date param must construct to a valid date instance or be a valid date instance itself.';
const INVALID_DATE_STRING_ERROR = 'Invalid dateString parameter, it must be a string.';
const INVALID_DATE_RANGE_ERROR = 'Invalid date range, it must be a string with the format "last-x-days".';
const MINUTE_IN_SECONDS = 60;
const HOUR_IN_SECONDS = 60 * MINUTE_IN_SECONDS;
const DAY_IN_SECONDS = 24 * HOUR_IN_SECONDS;
const WEEK_IN_SECONDS = 7 * DAY_IN_SECONDS;
const MONTH_IN_SECONDS = 30 * DAY_IN_SECONDS;

/**
 * Gets the hash of available date ranges.
 *
 * @since 1.12.0
 *
 * @return {Object} The object hash where every key is a date range slug, and the value is an object with the date range slug and its translation.
 */
function getAvailableDateRanges() {
  function label(days) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: number of days */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._n)('Last %s day', 'Last %s days', days, 'google-site-kit'), days);
  }
  return {
    'last-7-days': {
      slug: 'last-7-days',
      label: label(7),
      days: 7
    },
    'last-14-days': {
      slug: 'last-14-days',
      label: label(14),
      days: 14
    },
    'last-28-days': {
      slug: 'last-28-days',
      label: label(28),
      days: 28
    },
    'last-90-days': {
      slug: 'last-90-days',
      label: label(90),
      days: 90
    }
  };
}

/**
 * Gets the current dateRange day count.
 *
 * @since 1.19.0
 * @since 1.26.0 `dateRange` is now a required argument.
 *
 * @param {string} dateRange The date range slug.
 * @return {number} The number of days in the range.
 */
function getCurrentDateRangeDayCount(dateRange) {
  const daysMatch = dateRange.match(/last-(\d+)-days/);
  if (daysMatch && daysMatch[1]) {
    return parseInt(daysMatch[1], 10);
  }
  throw new Error('Unrecognized date range slug.');
}

/**
 * Asserts whether a given date string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateString Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given date string is valid.
 */
function isValidDateString(dateString = '') {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isString)(dateString)) {
    return false;
  }
  const dateArray = dateString.split('-');
  if (dateArray.length !== 3) {
    return false;
  }

  // Valid use of `new Date()`, constructing a new date from the string.
  // eslint-disable-next-line sitekit/no-direct-date
  const date = new Date(dateString);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date);
}

/**
 * Parses the given Date instance and returns a date string (YYYY-MM-DD).
 *
 * @since 1.18.0
 * @since 1.85.0 Updated the function signature to only accept a Date argument.
 *
 * @param {Date} date Date to parse into a string.
 * @return {string}                 The parsed date string (YYYY-MM-DD).
 */
function getDateString(date) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date), INVALID_DATE_INSTANCE_ERROR);
  const month = `${date.getMonth() + 1}`;
  const day = `${date.getDate()}`;
  const year = date.getFullYear();
  return [year, month.length < 2 ? `0${month}` : month, day.length < 2 ? `0${day}` : day].join('-');
}

/**
 * Converts a valid date string to a Date instance.
 *
 * @since 1.38.0
 *
 * @param {string} dateString The date string to parse.
 * @return {Date} Date instance.
 */
function stringToDate(dateString) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(dateString), INVALID_DATE_STRING_ERROR);

  /**
   * Split date into explicit parts rather than pass directly into date constructor
   * to avoid timezone issues caused by parsing as UTC. Ensures date is accurate for
   * the user's local time, otherwise has a chance to return a different day than was
   * passed in depending on timezone.
   */
  const [year, month, day] = dateString.split('-');
  return new Date(year, month - 1, day);
}

/**
 * Parses the given date and returns the previous date (daysBefore).
 *
 * @since 1.18.0
 *
 * @param {string} relativeDate Date string (YYYY-MM-DD) to subtract days from.
 * @param {number} daysBefore   Number of days to subtract from relativeDate.
 * @return {string}             The date string (YYYY-MM-DD) for the previous date.
 */
function getPreviousDate(relativeDate, daysBefore) {
  return getDateString(dateSub(relativeDate, daysBefore * DAY_IN_SECONDS));
}

/**
 * Asserts whether a given dateRange string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateRange Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given dateRange string is valid.
 */
function isValidDateRange(dateRange) {
  const parts = dateRange.split('-');
  return parts.length === 3 && parts[0] === 'last' && !Number.isNaN(parts[1]) && !Number.isNaN(parseFloat(parts[1])) && parts[2] === 'days';
}

/**
 * Subtracts duration from the prodived date and returns it.
 *
 * @since 1.132.0
 *
 * @param {Date|string} relativeDate Date string (YYYY-MM-DD) or date object to subtract duration from.
 * @param {number}      duration     The duration in seconds to subtract from relativeDate.
 * @return {Date} Resulting date.
 */
function dateSub(relativeDate, duration) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(relativeDate) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(relativeDate) && !isNaN(relativeDate), INVALID_DATE_STRING_ERROR);
  const timestamp = isValidDateString(relativeDate) ? Date.parse(relativeDate) : relativeDate.getTime();

  // Valid use of `new Date()` using calculations.
  // eslint-disable-next-line sitekit/no-direct-date
  return new Date(timestamp - duration * 1000);
}

/***/ }),

/***/ "./js/util/errors.js":
/*!***************************!*\
  !*** ./js/util/errors.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_CODE_MISSING_REQUIRED_SCOPE: () => (/* binding */ ERROR_CODE_MISSING_REQUIRED_SCOPE),
/* harmony export */   ERROR_INTERNAL_SERVER_ERROR: () => (/* binding */ ERROR_INTERNAL_SERVER_ERROR),
/* harmony export */   ERROR_INVALID_JSON: () => (/* binding */ ERROR_INVALID_JSON),
/* harmony export */   ERROR_REASON_BAD_REQUEST: () => (/* binding */ ERROR_REASON_BAD_REQUEST),
/* harmony export */   ERROR_REASON_FORBIDDEN: () => (/* binding */ ERROR_REASON_FORBIDDEN),
/* harmony export */   ERROR_REASON_INSUFFICIENT_PERMISSIONS: () => (/* binding */ ERROR_REASON_INSUFFICIENT_PERMISSIONS),
/* harmony export */   getReportErrorMessage: () => (/* binding */ getReportErrorMessage),
/* harmony export */   isAuthError: () => (/* binding */ isAuthError),
/* harmony export */   isErrorRetryable: () => (/* binding */ isErrorRetryable),
/* harmony export */   isInsufficientPermissionsError: () => (/* binding */ isInsufficientPermissionsError),
/* harmony export */   isPermissionScopeError: () => (/* binding */ isPermissionScopeError),
/* harmony export */   isWPError: () => (/* binding */ isWPError)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Error Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


// Error codes and reasons.
const ERROR_CODE_MISSING_REQUIRED_SCOPE = 'missing_required_scopes'; // When scopes are missing.
const ERROR_REASON_INSUFFICIENT_PERMISSIONS = 'insufficientPermissions';
const ERROR_REASON_FORBIDDEN = 'forbidden';
const ERROR_INTERNAL_SERVER_ERROR = 'internal_server_error';
const ERROR_INVALID_JSON = 'invalid_json';
const ERROR_REASON_BAD_REQUEST = 'bad_request';

/**
 * Checks if the provided object is an instance of WP_Error class.
 *
 * @since 1.13.0
 *
 * @param {Object} obj The object to check.
 * @return {boolean} TRUE if the object has "code", "data" and "message" properties, otherwise FALSE.
 */
function isWPError(obj) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(obj) && obj.hasOwnProperty('code') && (typeof obj.code === 'string' || typeof obj.code === 'number') && obj.hasOwnProperty('message') && typeof obj.message === 'string' && obj.hasOwnProperty('data'); // We don't check "obj.data" type because it can be anything.
}

/**
 * Checks if the given error is a permission scope error.
 *
 * @since 1.9.0
 * @private
 *
 * @param {Object} error Input to test as a possible permission scope error.
 * @return {boolean} TRUE if permission scope error, otherwise FALSE.
 */
function isPermissionScopeError(error) {
  return error?.code === ERROR_CODE_MISSING_REQUIRED_SCOPE;
}

/**
 * Checks if the given error has insufficient permissions reason.
 *
 * @since 1.16.0
 * @since 1.70.0 Add support for "forbidden" reason.
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's insufficient permissions error, otherwise FALSE.
 */
function isInsufficientPermissionsError(error) {
  return [ERROR_REASON_INSUFFICIENT_PERMISSIONS, ERROR_REASON_FORBIDDEN].includes(error?.data?.reason);
}

/**
 * Checks if the given error is an auth error.
 *
 * @since 1.78.0
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's an auth error, otherwise FALSE.
 */
function isAuthError(error) {
  return !!error?.data?.reconnectURL;
}

/**
 * Checks if the given error can be retried.
 *
 * @since 1.86.0
 *
 * @param {Object} error          The error object to check.
 * @param {Object} [selectorData] The error's associated selector data object.
 * @return {boolean} TRUE if the error is retryable, otherwise FALSE.
 */
function isErrorRetryable(error, selectorData) {
  return !!selectorData?.storeName && !isInsufficientPermissionsError(error) && !isPermissionScopeError(error) && !isAuthError(error);
}

/**
 * Sets the error message for specific error codes.
 *
 * @since 1.92.0
 *
 * @param {Object} error The error object to check.
 * @return {Object} The updated error object.
 */
function getReportErrorMessage(error) {
  if (error?.code === ERROR_INTERNAL_SERVER_ERROR) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('There was a critical error on this website while fetching data', 'google-site-kit');
  } else if (error?.code === ERROR_INVALID_JSON) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The server provided an invalid response', 'google-site-kit');
  }
  return error?.message;
}

/***/ }),

/***/ "./js/util/escape-uri.ts":
/*!*******************************!*\
  !*** ./js/util/escape-uri.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   escapeURI: () => (/* binding */ escapeURI)
/* harmony export */ });
/**
 * Escape URI components utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Escapes URI components in a template string as a tag function.
 *
 * @example
 * ```
 * // Escape a redirect url:
 * const redirectTo = 'http://localhost/admin/';
 * const loginUrl = escapeURI`http://localhost/login?redirect=${ redirectTo }`;
 * ```
 * @since 1.11.0
 *
 * @param strings The array of static strings in the template.
 * @param values  The array of expressions used in the template.
 * @return The escaped URI.
 */
function escapeURI(
/**
 * The array of static strings in the template.
 */
strings,
/**
 * The array of expressions used in the template.
 */
...values) {
  return strings.reduce((acc, string, idx) => {
    return acc + string + encodeURIComponent(values[idx] || '');
  }, '');
}

/***/ }),

/***/ "./js/util/i18n.js":
/*!*************************!*\
  !*** ./js/util/i18n.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDurationFormat: () => (/* binding */ createDurationFormat),
/* harmony export */   expandNumFmtOptions: () => (/* binding */ expandNumFmtOptions),
/* harmony export */   getLocale: () => (/* binding */ getLocale),
/* harmony export */   listFormat: () => (/* binding */ listFormat),
/* harmony export */   numFmt: () => (/* binding */ numFmt),
/* harmony export */   numberFormat: () => (/* binding */ numberFormat),
/* harmony export */   prepareForReadableLargeNumber: () => (/* binding */ prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* binding */ readableLargeNumber)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Internationalization Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed.
 *
 * For example, passing 65 returns '1m 5s'.
 *
 * @since 1.0.0
 * @since 1.28.0 Refactored and renamed to improve localization.
 * @private
 *
 * @param {number}                     durationInSeconds The number of seconds.
 * @param {(Intl.NumberFormatOptions)} [options]         Optional formatting options.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationFormat(durationInSeconds, options = {}) {
  const {
    formatUnit,
    formatDecimal
  } = createDurationFormat(durationInSeconds, options);
  try {
    // Some browsers, e.g. Safari, throw a RangeError when options.style is
    // not one of decimal, percent, or currency.
    return formatUnit();
  } catch {
    // Fallback to XXh YYm ZZs using localized decimals with hardcoded units.
    return formatDecimal();
  }
}

/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed
 * in ISO format - HH:mm:ss.
 *
 * If the duration is less than an hour, the HH part of the string
 * is truncated.
 * For example, passing 65 returns '01:05'.
 * Passing 5400 returns '01:30:00'.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationISOFormat(durationInSeconds) {
  let {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  seconds = ('0' + seconds).slice(-2);
  minutes = ('0' + minutes).slice(-2);
  hours = ('0' + hours).slice(-2);
  return hours === '00' ? `${minutes}:${seconds}` : `${hours}:${minutes}:${seconds}`;
}

/**
 * Parses the duration in seconds into hours, minutes and seconds.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {Object} Number of hours, minutes and seconds equivalent
 * to the given duration in seconds.
 */
function parseDuration(durationInSeconds) {
  durationInSeconds = parseInt(durationInSeconds, 10);
  if (Number.isNaN(durationInSeconds)) {
    durationInSeconds = 0;
  }
  const hours = Math.floor(durationInSeconds / 60 / 60);
  const minutes = Math.floor(durationInSeconds / 60 % 60);
  const seconds = Math.floor(durationInSeconds % 60);
  return {
    hours,
    minutes,
    seconds
  };
}

/**
 * Creates duration formatting utilities.
 *
 * Not intended to be used directly.
 * Use `numFmt( number, { style: 'duration' } )` instead.
 *
 * @since 1.29.0
 * @private
 *
 * @param {number} durationInSeconds Duration to format.
 * @param {Object} [options]         Formatting options.
 * @return {Object} Formatting functions.
 */
function createDurationFormat(durationInSeconds, options = {}) {
  const {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  return {
    hours,
    minutes,
    seconds,
    formatUnit() {
      const {
        unitDisplay = 'short',
        ...restOptions
      } = options;
      const commonOptions = {
        unitDisplay,
        ...restOptions,
        style: 'unit'
      };
      if (durationInSeconds === 0) {
        return numberFormat(seconds, {
          ...commonOptions,
          unit: 'second'
        });
      }
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? numberFormat(seconds, {
        ...commonOptions,
        unit: 'second'
      }) : '', minutes ? numberFormat(minutes, {
        ...commonOptions,
        unit: 'minute'
      }) : '', hours ? numberFormat(hours, {
        ...commonOptions,
        unit: 'hour'
      }) : '').trim();
    },
    /**
     * Formats the duration using integers and translatable strings.
     * This is only used as a fallback when the above `formatUnit` fails.
     *
     * @since 1.29.0
     *
     * @return {string} Formatted duration.
     */
    formatDecimal() {
      const formattedSeconds = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of seconds with "s" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%ds', 'google-site-kit'), seconds);
      if (durationInSeconds === 0) {
        return formattedSeconds;
      }
      const formattedMinutes = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of minutes with "m" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dm', 'google-site-kit'), minutes);
      const formattedHours = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of hours with "h" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dh', 'google-site-kit'), hours);
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? formattedSeconds : '', minutes ? formattedMinutes : '', hours ? formattedHours : '').trim();
    }
  };
}

/**
 * Prepares a number to be used in readableLargeNumber.
 *
 * @since 1.7.0
 *
 * @param {number} number The large number to prepare.
 * @return {number} The prepared number.
 */
function prepareForReadableLargeNumber(number) {
  if (1000000 <= number) {
    return Math.round(number / 100000) / 10;
  }
  if (10000 <= number) {
    return Math.round(number / 1000);
  }
  if (1000 <= number) {
    return Math.round(number / 100) / 10;
  }
  return number;
}

/**
 * Formats a large number for shortened display.
 *
 * @since 1.0.0
 *
 * @param {number} number The large number to format.
 * @return {string} The formatted number.
 */
function readableLargeNumber(number) {
  const withSingleDecimal = {
    minimumFractionDigits: 1,
    maximumFractionDigits: 1
  };

  // Numbers over 1,000,000 round normally and display a single decimal unless the decimal is 0.
  if (1000000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in millions.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sM', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }

  // Numbers between 10,000 and 1,000,000 round normally and have no decimals
  if (10000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number)));
  }

  // Numbers between 1,000 and 10,000 round normally and display a single decimal unless the decimal is 0.
  if (1000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }
  return numberFormat(number, {
    signDisplay: 'never',
    maximumFractionDigits: 1
  });
}

/**
 * Parses formatting options and returns an object with options for selected formatting.
 *
 * @since 1.103.0
 *
 * @param {(Intl.NumberFormatOptions|string)} options Formatting options or unit shorthand. Possible shorthand values are '%', 's', or a currency code.
 * @return {Object} Formatting options.
 */
function expandNumFmtOptions(options) {
  let formatOptions = {};

  // Expand shorthand values for units.
  if ('%' === options) {
    formatOptions = {
      style: 'percent',
      maximumFractionDigits: 2
    };
  } else if ('s' === options) {
    formatOptions = {
      style: 'duration',
      unitDisplay: 'narrow'
    };
  } else if (!!options && typeof options === 'string') {
    formatOptions = {
      style: 'currency',
      currency: options
    };
  } else if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(options)) {
    formatOptions = {
      ...options
    };
  }
  return formatOptions;
}

/**
 * Formats a number with unit using the JS Internationalization Number Format API.
 *
 * In addition to the supported 'style' values of the lower-level `numberFormat` function, this function
 * supports two additional 'style' values 'metric' and 'duration' (expects a number in seconds).
 *
 * Another differentiation in behavior is that by default the function will use 'metric' formatting instead
 * of 'decimal' formatting.
 *
 * @since 1.24.0
 *
 * @param {number|string}                     number    The number to format.
 * @param {(Intl.NumberFormatOptions|string)} [options] Formatting options or unit shorthand.
 *                                                      Possible shorthand values are '%', 's',
 *                                                      or a currency code.
 * @return {string} The formatted number.
 */
function numFmt(number, options = {}) {
  // Cast parsable values to numeric types.
  number = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number) ? number : Number(number);
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number)) {
    // eslint-disable-next-line no-console
    console.warn('Invalid number', number, typeof number);
    number = 0;
  }
  const formatOptions = expandNumFmtOptions(options);
  const {
    style = 'metric'
  } = formatOptions; // Note: `metric` is our custom, default style.

  if ('metric' === style) {
    return readableLargeNumber(number);
  }
  if ('duration' === style) {
    return durationFormat(number, formatOptions);
  }
  if ('durationISO' === style) {
    return durationISOFormat(number);
  }
  return numberFormat(number, formatOptions);
}

// Warn once for a given message.
const warnOnce = memize__WEBPACK_IMPORTED_MODULE_1___default()(console.warn); // eslint-disable-line no-console

/**
 * Formats a number using the JS Internationalization Number Format API.
 *
 * @since 1.8.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/NumberFormat|`options` parameter} For all available formatting options.
 *
 * @param {number}                   number           The number to format.
 * @param {Intl.NumberFormatOptions} [options]        Formatting options.
 * @param {string}                   [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @return {string} The formatted number.
 */
function numberFormat(number, options = {}) {
  const {
    locale = getLocale(),
    ...formatOptions
  } = options;
  try {
    /**
     * Per https://github.com/google/site-kit-wp/issues/3255 there have been issues with some versions of Safari
     * on some operating systems throwing issues with some parameters in the formatOptions.
     *
     * If an error is thrown, we remove some troublesome params from the formatOptions object and fallback to no formatting.
     *
     * This allows us to degrade somewhat gracefully without breaking the dashboard for users of unaffected browsers.
     */
    return new Intl.NumberFormat(locale, formatOptions).format(number);
  } catch (error) {
    warnOnce(`Site Kit numberFormat error: Intl.NumberFormat( ${JSON.stringify(locale)}, ${JSON.stringify(formatOptions)} ).format( ${typeof number} )`, error.message);
  }

  // Remove these key/values from formatOptions.
  const unstableFormatOptionValues = {
    currencyDisplay: 'narrow',
    currencySign: 'accounting',
    style: 'unit'
  };

  // Remove these keys from formatOptions irrespective of value.
  const unstableFormatOptions = ['signDisplay', 'compactDisplay'];
  const reducedFormatOptions = {};
  for (const [key, value] of Object.entries(formatOptions)) {
    if (unstableFormatOptionValues[key] && value === unstableFormatOptionValues[key]) {
      continue;
    }
    if (unstableFormatOptions.includes(key)) {
      continue;
    }
    reducedFormatOptions[key] = value;
  }
  try {
    return new Intl.NumberFormat(locale, reducedFormatOptions).format(number);
  } catch {
    return new Intl.NumberFormat(locale).format(number);
  }
}

/**
 * Flattens an array of strings into a string using the JS Internationalization List Format API.
 *
 * @since 1.23.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat|`options` parameter} For all available options.
 *
 * @param {Array}  list             The list to flatten.
 * @param {Object} [options]        Formatting options.
 * @param {string} [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @param {string} [options.style]  Length of the formatted message. Defaults to long.
 * @param {string} [options.type]   Type of list. Defaults to 'conjunction' (A, B, and C).
 *                                  Also available 'disjunction' (A, B, or C)
 *                                  Also available 'unit' (5 pounds, 12 ounces)
 * @return {string} The flattened list.
 */
function listFormat(list, options = {}) {
  const {
    locale = getLocale(),
    style = 'long',
    type = 'conjunction'
  } = options;

  // Not all browsers support Intl.Listformat per
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat#Browser_compatibility
  // We've seen that the built versions don't polyfill for the unsupported browsers (iOS/safari) so we provide a fallback.
  if (Intl.ListFormat) {
    const formatter = new Intl.ListFormat(locale, {
      style,
      type
    });
    return formatter.format(list);
  }

  /* translators: used between list items, there is a space after the comma. */
  const listSeparator = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(', ', 'google-site-kit');
  return list.join(listSeparator);
}

/**
 * Gets the current locale for use with browser APIs.
 *
 * @since 1.8.0
 *
 * @param {Object} _global The global window object.
 * @return {string} Current Site Kit locale if set, otherwise the current language set by the browser.
 *                  E.g. `en-US` or `de-DE`
 */
function getLocale(_global = __webpack_require__.g) {
  const siteKitLocale = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(_global, ['_googlesitekitLegacyData', 'locale']);
  if (siteKitLocale) {
    const matches = siteKitLocale.match(/^(\w{2})?(_)?(\w{2})/);
    if (matches && matches[0]) {
      return matches[0].replace(/_/g, '-');
    }
  }
  return _global.navigator.language;
}

/***/ }),

/***/ "./js/util/index.js":
/*!**************************!*\
  !*** ./js/util/index.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.WEEK_IN_SECONDS),
/* harmony export */   calculateChange: () => (/* binding */ calculateChange),
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.calculateDifferenceBetweenChartValues),
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertSecondsToArray),
/* harmony export */   createDurationFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.createDurationFormat),
/* harmony export */   dateSub: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.dateSub),
/* harmony export */   decodeHTMLEntity: () => (/* binding */ decodeHTMLEntity),
/* harmony export */   expandNumFmtOptions: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.expandNumFmtOptions),
/* harmony export */   getAvailableDateRanges: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getAvailableDateRanges),
/* harmony export */   getChartDifferenceArrow: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.getChartDifferenceArrow),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getDateString),
/* harmony export */   getFullURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getFullURL),
/* harmony export */   getLocale: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.getLocale),
/* harmony export */   getPreviousDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getPreviousDate),
/* harmony export */   getStorage: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.getStorage),
/* harmony export */   getURLPath: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getURLPath),
/* harmony export */   isHashOnly: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.isHashOnly),
/* harmony export */   isNumeric: () => (/* reexport safe */ _isnumeric__WEBPACK_IMPORTED_MODULE_12__.isNumeric),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.isSingleSlice),
/* harmony export */   isValidDateRange: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateRange),
/* harmony export */   isValidDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateString),
/* harmony export */   isValidNumericID: () => (/* reexport safe */ _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__.isValidNumericID),
/* harmony export */   listFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.listFormat),
/* harmony export */   markdownToHTML: () => (/* reexport safe */ _markdown__WEBPACK_IMPORTED_MODULE_6__.markdownToHTML),
/* harmony export */   normalizeURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.normalizeURL),
/* harmony export */   numFmt: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numFmt),
/* harmony export */   numberFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numberFormat),
/* harmony export */   partitionReport: () => (/* reexport safe */ _partition_report__WEBPACK_IMPORTED_MODULE_14__.partitionReport),
/* harmony export */   prepareForReadableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.readableLargeNumber),
/* harmony export */   safelySort: () => (/* reexport safe */ _safely_sort__WEBPACK_IMPORTED_MODULE_13__.safelySort),
/* harmony export */   sanitizeHTML: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML),
/* harmony export */   shortenURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.shortenURL),
/* harmony export */   storageAvailable: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.storageAvailable),
/* harmony export */   stringToDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.stringToDate),
/* harmony export */   stringifyObject: () => (/* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_3__.stringifyObject),
/* harmony export */   trackEvent: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEvent),
/* harmony export */   trackEventOnce: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEventOnce),
/* harmony export */   untrailingslashit: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.untrailingslashit),
/* harmony export */   validateJSON: () => (/* binding */ validateJSON)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sanitize */ "./js/util/sanitize.js");
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringify */ "./js/util/stringify.js");
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./storage */ "./js/util/storage.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./i18n */ "./js/util/i18n.js");
/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./markdown */ "./js/util/markdown.js");
/* harmony import */ var _convert_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./convert-time */ "./js/util/convert-time.js");
/* harmony import */ var _dates__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dates */ "./js/util/dates.js");
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart */ "./js/util/chart.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./urls */ "./js/util/urls.js");
/* harmony import */ var _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./is-valid-numeric-id */ "./js/util/is-valid-numeric-id.js");
/* harmony import */ var _isnumeric__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isnumeric */ "./js/util/isnumeric.js");
/* harmony import */ var _safely_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./safely-sort */ "./js/util/safely-sort.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./partition-report */ "./js/util/partition-report.js");
/**
 * Utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */
















/**
 * Calculates the change between two values.
 *
 * @since 1.24.0
 *
 * @param {number} previous The previous value.
 * @param {number} current  The current value.
 * @return {(number|null)} The percent change. Null if the input or output is invalid.
 */
function calculateChange(previous, current) {
  function isZero(value) {
    return value === '0' || value === 0;
  }

  // Prevent null result when both values are legitimately zero.
  if (isZero(previous) && isZero(current)) {
    return 0;
  }

  // Prevent divide by zero errors.
  if (isZero(previous) || Number.isNaN(previous)) {
    return null;
  }

  // Avoid NaN at all costs.
  const change = (current - previous) / previous;
  if (Number.isNaN(change) || !Number.isFinite(change)) {
    return null;
  }
  return change;
}

/**
 * Verifies whether JSON is valid.
 *
 * @since 1.0.0
 *
 * @param {string} stringToValidate The string to validate.
 * @return {boolean} Indicates JSON is valid.
 */
function validateJSON(stringToValidate) {
  try {
    return JSON.parse(stringToValidate) && !!stringToValidate;
  } catch (e) {
    return false;
  }
}

/**
 * Converts HTML text into an HTML entity.
 *
 * _.unescape doesn't seem to decode some entities for admin bar titles.
 * adding combination in this helper as a workaround.
 *
 * @since 1.0.0
 *
 * @param {string} str The string to decode.
 * @return {string} Decoded HTML entity.
 */
function decodeHTMLEntity(str) {
  if (!str) {
    return '';
  }
  const decoded = str.replace(/&#(\d+);/g, (match, dec) => {
    return String.fromCharCode(dec);
  }).replace(/(\\)/g, '');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(decoded);
}

/***/ }),

/***/ "./js/util/insufficient-permissions-error-description.js":
/*!***************************************************************!*\
  !*** ./js/util/insufficient-permissions-error-description.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getInsufficientPermissionsErrorDescription: () => (/* binding */ getInsufficientPermissionsErrorDescription)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/**
 * `getInsufficientPermissionsErrorDescription` function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */




/**
 * Gets a description for an insufficient permissions error.
 *
 * @since 1.16.0
 *
 * @param {string} error              Original error message.
 * @param {Object} module             Module data.
 * @param {string} module.name        The name of the module.
 * @param {string} module.slug        The slug of the module.
 * @param {Object} module.owner       The owner of the module.
 * @param {string} module.owner.login The The login of the current owner.
 * @return {string}                   Error description.
 */
function getInsufficientPermissionsErrorDescription(error = '', module = {}) {
  const {
    slug = '',
    name = '',
    owner = {}
  } = module || {};

  // If no module data provided, it is impossible to provide a more clear message.
  if (!slug || !name) {
    return error;
  }
  let message = '';
  let userInfo = '';
  if (_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_ANALYTICS_4 === slug) {
    if (error.match(/account/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics account, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    } else if (error.match(/property/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics property, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    } else if (error.match(/view/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics view, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    }
  } else if (_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_1__.MODULE_SLUG_SEARCH_CONSOLE === slug) {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Search Console property, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
  }
  if (!message) {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions to access %s data, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit'), name);
  }
  if (owner && owner.login) {
    userInfo = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: owner name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This service was originally connected by the administrator "%s" — you can contact them for more information.', 'google-site-kit'), owner.login);
  }
  if (!userInfo) {
    userInfo = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This service was originally connected by an administrator — you can contact them for more information.', 'google-site-kit');
  }
  return `${message} ${userInfo}`;
}

/***/ }),

/***/ "./js/util/is-valid-numeric-id.js":
/*!****************************************!*\
  !*** ./js/util/is-valid-numeric-id.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidNumericID: () => (/* binding */ isValidNumericID)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks the given value to see if it is a positive integer.
 *
 * @since 1.11.0 Function introduced.
 * @since 1.90.0 Moved outside Tag Manager to a generic utility function.
 *
 * @param {*} input Value to check.
 * @return {boolean} Validity.
 */
function isValidNumericID(input) {
  const id = parseFloat(input) || 0;
  if (!Number.isInteger(id)) {
    return false;
  }
  return id > 0;
}

/***/ }),

/***/ "./js/util/isnumeric.js":
/*!******************************!*\
  !*** ./js/util/isnumeric.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNumeric: () => (/* binding */ isNumeric)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if a given value is numeric.
 *
 * @since 1.80.0
 *
 * @param {*} value The value to check.
 * @return {boolean} TRUE if a value is numeric FALSE otherwise.
 */
function isNumeric(value) {
  if (typeof value === 'number') {
    return true;
  }
  const string = (value || '').toString();
  if (!string) {
    return false;
  }
  return !isNaN(string);
}

/***/ }),

/***/ "./js/util/markdown.js":
/*!*****************************!*\
  !*** ./js/util/markdown.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   markdownToHTML: () => (/* binding */ markdownToHTML)
/* harmony export */ });
/**
 * Markdown utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Replaces markdown links with its HTML equivalents.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownLinks(text) {
  return text.replace(new RegExp('\\[([^\\]]+)\\]\\((https?://[^/]+\\.\\w+/?.*?)\\)', 'gi'), '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>');
}

/**
 * Adds paragraphs to the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownParagraphs(text) {
  return `<p>${text.replace(/\n{2,}/g, '</p><p>')}</p>`;
}

/**
 * Replaces line breaks in the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownBreaks(text) {
  return text.replace(/\n/gi, '<br>');
}

/**
 * Converts markdown to HTML.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} HTML version of the markdown text.
 */
function markdownToHTML(text) {
  const rules = [markdownLinks, markdownParagraphs, markdownBreaks];
  let html = text;
  for (const rule of rules) {
    html = rule(html);
  }
  return html;
}

/***/ }),

/***/ "./js/util/partition-report.js":
/*!*************************************!*\
  !*** ./js/util/partition-report.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionReport: () => (/* binding */ partitionReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report partitioning utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.33.0
 * @since 1.34.0 Updated to support incomplete `report` arrays.
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionReport(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');

  // Use a negative date range length for reverse slicing.
  const _dateRangeLength = -1 * dateRangeLength;
  return {
    // The current range should always be sliced from the end.
    currentRange: report.slice(_dateRangeLength),
    // The compare range continues from where the current left off (slicing towards the start),
    // and may be shorter (where older data is not available yet) which is fine.
    compareRange: report.slice(_dateRangeLength * 2, _dateRangeLength)
  };
}

/***/ }),

/***/ "./js/util/purify.js":
/*!***************************!*\
  !*** ./js/util/purify.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   purify: () => (/* binding */ purify)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "../node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

const purify = dompurify__WEBPACK_IMPORTED_MODULE_0___default()(__webpack_require__.g);

/***/ }),

/***/ "./js/util/report-validation.js":
/*!**************************************!*\
  !*** ./js/util/report-validation.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidOrders: () => (/* binding */ isValidOrders),
/* harmony export */   isValidStringsOrObjects: () => (/* binding */ isValidStringsOrObjects),
/* harmony export */   isValidStringularItems: () => (/* binding */ isValidStringularItems)
/* harmony export */ });
/**
 * Reporting API validation utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Validates data that can be either string or object of the certain type, or array of them.
 *
 * @since 1.13.0
 * @since 1.98.0 Added verifyStringFunction parameter.
 *
 * @param {string|string[]|Object|Object[]} data                   The data to check.
 * @param {Function}                        verifyObjectFunction   The callback to verify an object.
 * @param {Function}                        [verifyStringFunction] The callback to verify a string (optional).
 * @return {boolean} TRUE if data is valid, otherwise FALSE.
 */
function isValidStringsOrObjects(data, verifyObjectFunction, verifyStringFunction = () => true) {
  if (typeof data === 'string') {
    return verifyStringFunction(data);
  }
  if (typeof data === 'object' && verifyObjectFunction(data)) {
    return true;
  }
  if (Array.isArray(data)) {
    return data.every(item => {
      if (typeof item === 'string') {
        return verifyStringFunction(item);
      }
      if (typeof item === 'object') {
        return verifyObjectFunction(item);
      }
      return false;
    });
  }

  // Arguably this should fail/throw, because none of our allowed types were encountered.
  return false;
}

/**
 * Verifies that either date range or start and end dates are valid.
 *
 * @since 1.13.0
 *
 * @param {Object} dates           The object containing dates to check.
 * @param {string} dates.startDate The start date to check.
 * @param {string} dates.endDate   The end date to check.
 * @return {boolean} TRUE if either date range or start/end dates are valid, otherwise FALSE.
 */
function isValidDateRange({
  startDate,
  endDate
}) {
  const validStartDate = startDate && startDate.match(/^\d{4}-\d{2}-\d{2}$/);
  const validEndDate = endDate && endDate.match(/^\d{4}-\d{2}-\d{2}$/);
  return validStartDate && validEndDate;
}

/**
 * Verifies that order definitions are valid. It can be either an object or an array
 * of objects where each object has "fieldName" and valid "sortOrder" properties.
 *
 * @since 1.13.0
 *
 * @param {Object|Object[]} orders The order definitions to check.
 * @return {boolean} TRUE if order definitions are valid, otherwise FALSE.
 */
function isValidOrders(orders) {
  function isValidOrder(order) {
    const isValidFieldName = order.hasOwnProperty('fieldName') && !!order.fieldName;
    const isValidSortOrder = order.hasOwnProperty('sortOrder') && /(ASCENDING|DESCENDING)/i.test(order.sortOrder.toString());
    return isValidFieldName && isValidSortOrder;
  }
  if (Array.isArray(orders)) {
    return orders.every(item => typeof item === 'object' && isValidOrder(item));
  }
  if (typeof orders === 'object') {
    return isValidOrder(orders);
  }

  // Arguably this should fail/throw, because none of our allowed types were encountered.
  return false;
}

/**
 * Verifies that provided parameter is either a string or an array of strings.
 *
 * @since 1.15.0
 *
 * @param {(string|Array.<string>)} items Items to validate.
 * @return {boolean} TRUE if items are either a string or an array of strings, otherwise FALSE.
 */
function isValidStringularItems(items) {
  if (typeof items === 'string') {
    return true;
  }
  if (Array.isArray(items)) {
    return items.every(item => typeof item === 'string');
  }
  return false;
}

/***/ }),

/***/ "./js/util/safely-sort.js":
/*!********************************!*\
  !*** ./js/util/safely-sort.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safelySort: () => (/* binding */ safelySort)
/* harmony export */ });
/**
 * `safelySort` utility function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Sorts an array without causing the mutation if the given parameter is an array.
 * If the parameter is not an array, it returns the parameter as is.
 *
 * @since 1.110.0
 * @since 1.128.0 Moved to the common utility directory from the key metrics directory.
 *
 * @param {Array|*} arr Param to be sorted.
 * @return {Array|*} 	Safely sorted array without mutation.
 */
function safelySort(arr) {
  return Array.isArray(arr) ? [...arr].sort() : arr;
}

/***/ }),

/***/ "./js/util/sanitize.js":
/*!*****************************!*\
  !*** ./js/util/sanitize.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sanitizeHTML: () => (/* binding */ sanitizeHTML),
/* harmony export */   untrailingslashit: () => (/* binding */ untrailingslashit)
/* harmony export */ });
/* harmony import */ var _purify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./purify */ "./js/util/purify.js");
/**
 * Internal dependencies
 */

function sanitizeHTML(unsafeHTML, domPurifyConfig = {}) {
  return {
    __html: _purify__WEBPACK_IMPORTED_MODULE_0__.purify.sanitize(unsafeHTML, domPurifyConfig)
  };
}

/**
 * Takes a string or an URL object, removes the trailing slash if any and returns it.
 *
 * @since 1.20.0
 * @private
 *
 * @param {Object|string} url A string with or without trailing slash or an URL object.
 * @return {string|undefined} The URL string after removing the trailing slash.
 */
function untrailingslashit(url) {
  const originalURL = typeof url === 'object' ? url.toString() : url;
  return originalURL?.replace?.(/\/+$/, '');
}

/***/ }),

/***/ "./js/util/storage.js":
/*!****************************!*\
  !*** ./js/util/storage.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   storageAvailable: () => (/* binding */ storageAvailable)
/* harmony export */ });
/**
 * Storage abstraction.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.0.0
 *
 * @param {string} type Browser storage to test. ex localStorage or sessionStorage.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
function storageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

// Custom no-op implementation of window.Storage.
class NullStorage {
  get length() {
    return 0;
  }
  key() {
    return null;
  }
  getItem() {
    return null;
  }
  setItem() {
    // Empty method body.
  }
  removeItem() {
    // Empty method body.
  }
  clear() {
    // Empty method body.
  }
}
let storageObj;

/**
 * Gets the storage object to use.
 *
 * @since 1.0.0
 *
 * @return {Storage} Either window.sessionStorage, window.localStorage', or a
 *                   no-op implementation if neither is available.
 */
function getStorage() {
  // Only run the logic to determine the storage object once.
  if (!storageObj) {
    if (storageAvailable('sessionStorage')) {
      storageObj = __webpack_require__.g.sessionStorage;
    } else if (storageAvailable('localStorage')) {
      storageObj = __webpack_require__.g.localStorage;
    } else {
      storageObj = new NullStorage();
    }
  }
  return storageObj;
}

/***/ }),

/***/ "./js/util/stringify.js":
/*!******************************!*\
  !*** ./js/util/stringify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyObject: () => (/* binding */ stringifyObject)
/* harmony export */ });
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Stringify function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Transforms an object into a hash string.
 *
 * This function can be used to e.g. generate cache keys, based on the given
 * object. Object properties are sorted, so even if they are provided in
 * different order, the hash will match. The function furthermore supports
 * nested objects.
 *
 * @since 1.7.0
 *
 * @param {Object} obj The object to stringify.
 * @return {string} Hash for the object.
 */
function stringifyObject(obj) {
  return md5__WEBPACK_IMPORTED_MODULE_0___default()(JSON.stringify(sortObjectProperties(obj)));
}
function sortObjectProperties(obj) {
  const orderedData = {};
  Object.keys(obj).sort().forEach(key => {
    let val = obj[key];
    if (val && 'object' === typeof val && !Array.isArray(val)) {
      val = sortObjectProperties(val);
    }
    orderedData[key] = val;
  });
  return orderedData;
}

/***/ }),

/***/ "./js/util/tag.js":
/*!************************!*\
  !*** ./js/util/tag.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extractExistingTag: () => (/* binding */ extractExistingTag),
/* harmony export */   getExistingTagURLs: () => (/* binding */ getExistingTagURLs)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/api-fetch */ "./js/api-fetch-shim.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/**
 * Utility functions for Tags
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Extracts a tag from the given HTML string matched by given matchers.
 *
 * @since 1.13.0
 *
 * @param {string} html        The string of html from which to extract the tag.
 * @param {Array}  tagMatchers An array of the matchers to use.
 * @return {(string|boolean)} The tag id if found, otherwise false.
 */
function extractExistingTag(html, tagMatchers) {
  const matchingPattern = tagMatchers.find(pattern => pattern.test(html));
  if (matchingPattern) {
    return matchingPattern.exec(html)[1];
  }
  return false;
}

/**
 * Gets the existing tag URLs.
 *
 * @since 1.13.0
 *
 * @param {Object} args           Arguments to use to get URLs.
 * @param {string} args.homeURL   The site's home URL.
 * @param {string} [args.ampMode] Optional. The site's AMP mode.
 * @return {Array} An array of the existing tag URLs.
 */
const getExistingTagURLs = (0,lodash__WEBPACK_IMPORTED_MODULE_1__.memoize)(async ({
  homeURL,
  ampMode
}) => {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_4__.isURL)(homeURL), 'homeURL must be valid URL');

  // Initialize urls with home URL
  const urls = [homeURL];

  // Add first post in AMP mode if AMP mode is secondary.
  if (_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.AMP_MODE_SECONDARY === ampMode) {
    try {
      const ampPostURL = await (0,_wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_2__["default"])({
        path: '/wp/v2/posts?per_page=1'
      }).then(posts => posts.slice(0, 1).map(post => (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_5__.addQueryArgs)(post.link, {
        amp: 1
      })).pop());
      if (ampPostURL) {
        urls.push(ampPostURL);
      }
    } catch {
      return urls;
    }
  }
  return urls;
});

/***/ }),

/***/ "./js/util/tracking/constants.js":
/*!***************************************!*\
  !*** ./js/util/tracking/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_LAYER: () => (/* binding */ DATA_LAYER),
/* harmony export */   SCRIPT_IDENTIFIER: () => (/* binding */ SCRIPT_IDENTIFIER)
/* harmony export */ });
/**
 * Constants related to event tracking.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Data layer global used for internal/private Site Kit data.
 *
 * @since 1.8.0
 * @private
 */
const DATA_LAYER = '_googlesitekitDataLayer';

/**
 * The `gtag` `<script>` identifier.
 *
 * @since 1.8.0
 * @private
 */
const SCRIPT_IDENTIFIER = 'data-googlesitekit-gtag';

/***/ }),

/***/ "./js/util/tracking/createDataLayerPush.js":
/*!*************************************************!*\
  !*** ./js/util/tracking/createDataLayerPush.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createDataLayerPush)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked will initialize the dataLayer and push data onto it.
 *
 * @since 1.3.0
 *
 * @param {Object} target Object to enhance with dataLayer data.
 * @return {Function} Function that pushes data onto the dataLayer.
 */
function createDataLayerPush(target) {
  /**
   * Pushes data onto the data layer.
   *
   * Must push an instance of Arguments to the target.
   * Using an ES6 spread operator (i.e. `...args`) will cause tracking events to
   * _silently_ fail.
   *
   * @since 1.0.0
   * @see {@link https://github.com/google/site-kit-wp/issues/1181}
   */
  return function dataLayerPush() {
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] = target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] || [];
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER].push(arguments);
  };
}

/***/ }),

/***/ "./js/util/tracking/createInitializeSnippet.js":
/*!*****************************************************!*\
  !*** ./js/util/tracking/createInitializeSnippet.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createInitializeSnippet)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/* harmony import */ var _js_features_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/features/index */ "./js/features/index.js");
/**
 * Internal dependencies
 */




/**
 * Returns a function which, when invoked injects the gtag script if necessary.
 *
 * @since 1.44.0
 *
 * @param {Object} config          Tracking configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @return {Function} Function that injects gtag script if it isn't yet present.
 */
function createInitializeSnippet(config, dataLayerTarget) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);
  let hasInsertedTag;
  const {
    activeModules,
    referenceSiteURL,
    userIDHash,
    userRoles = [],
    isAuthenticated,
    pluginVersion
  } = config;

  /**
   * Injects the necessary script tag if not present.
   *
   * @since 1.118.0
   *
   * @return {boolean|Object} Tag src as scriptTagSrc property.
   */
  return function initializeSnippet() {
    const {
      document
    } = __webpack_require__.g;
    if (undefined === hasInsertedTag) {
      hasInsertedTag = !!document.querySelector(`script[${_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER}]`);
    }
    if (hasInsertedTag) {
      return false;
    }
    hasInsertedTag = true;

    // Sometimes the user roles returned by Site Kit/WordPress is not an
    // array, as expected, so we guard against it here.
    //
    // See: https://github.com/google/site-kit-wp/issues/8266
    const userRolesAsString = userRoles?.length ? userRoles.join(',') : '';

    // We should use the real time, and not the reference date, when
    // measuring when we initialized tracking.
    dataLayerPush('js', new Date()); // eslint-disable-line sitekit/no-direct-date
    dataLayerPush('config', config.trackingID, {
      groups: 'site_kit',
      send_page_view: config.isSiteKitScreen,
      domain: referenceSiteURL,
      plugin_version: pluginVersion || '',
      enabled_features: Array.from(_js_features_index__WEBPACK_IMPORTED_MODULE_2__.enabledFeatures).join(','),
      active_modules: activeModules.join(','),
      authenticated: isAuthenticated ? '1' : '0',
      user_properties: {
        user_roles: userRolesAsString,
        user_identifier: userIDHash
      }
    });

    // If not present, inject it and initialize dataLayer.
    const scriptTag = document.createElement('script');
    scriptTag.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER, '');
    scriptTag.async = true;
    scriptTag.src = `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`;
    document.head.appendChild(scriptTag);
    return {
      scriptTagSrc: `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`
    };
  };
}

/***/ }),

/***/ "./js/util/tracking/createTrackEvent.js":
/*!**********************************************!*\
  !*** ./js/util/tracking/createTrackEvent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTrackEvent)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked tracks a single event.
 *
 * @since 1.3.0
 *
 * @param {Object}   config            Tracking configuration.
 * @param {Object}   dataLayerTarget   Data layer parent object.
 * @param {Function} initializeSnippet Function to initialize tracking.
 * @param {Object}   _global           The global window object.
 * @return {Function} Function that tracks an event.
 */
function createTrackEvent(config, dataLayerTarget, initializeSnippet, _global) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);

  /**
   * Send an Analytics tracking event.
   *
   * @since 1.3.0
   *
   * @param {string} category The category of the event.
   * @param {string} action   The action name of the event.
   * @param {string} [label]  Optional. The label of the event.
   * @param {number} [value]  Optional. A non-negative integer that will appear as the event value.
   * @return {Promise} Promise that always resolves.
   */
  // eslint-disable-next-line require-await
  return async function trackEvent(category, action, label, value) {
    const {
      trackingEnabled
    } = config;
    if (!trackingEnabled) {
      // Resolve immediately if tracking is disabled.
      return null;
    }
    initializeSnippet();
    const eventData = {
      send_to: 'site_kit',
      event_category: category,
      event_label: label,
      value
    };
    return new Promise(resolve => {
      // This timeout ensures a tracking event does not block the user
      // event if it is not sent (in time).
      // If the event beacon fails, it shouldn't reject the promise since event
      // tracking should not result in user-facing errors. It will just
      // trigger a console warning.
      function failCallback() {
        _global.console.warn(`Tracking event "${action}" (category "${category}") took too long to fire.`);
        resolve();
      }
      const failTimeout = setTimeout(failCallback, 1000);
      // eslint-disable-next-line camelcase
      function event_callback() {
        clearTimeout(failTimeout);
        resolve();
      }
      dataLayerPush('event', action, {
        ...eventData,
        event_callback
      });

      // If the client-side opt-out is present, the event_callback will never be called
      // so we call it here to prevent the warning and added delay.
      if (_global._gaUserPrefs?.ioo?.()) {
        event_callback();
      }
    });
  };
}

/***/ }),

/***/ "./js/util/tracking/createTracking.js":
/*!********************************************!*\
  !*** ./js/util/tracking/createTracking.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTracking)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createInitializeSnippet */ "./js/util/tracking/createInitializeSnippet.js");
/* harmony import */ var _createTrackEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createTrackEvent */ "./js/util/tracking/createTrackEvent.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const DEFAULT_CONFIG = {
  activeModules: [],
  isAuthenticated: false,
  referenceSiteURL: '',
  trackingEnabled: false,
  trackingID: '',
  userIDHash: '',
  userRoles: []
};

/**
 * Initializes tracking.
 *
 * @since 1.3.0
 *
 * @param {Object} newConfig       New configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @param {Object} _global         The global window object.
 * @return {Object} Tracking config.
 */
function createTracking(newConfig, dataLayerTarget = __webpack_require__.g, _global = __webpack_require__.g) {
  const config = {
    ...DEFAULT_CONFIG,
    ...newConfig
  };
  // Remove any trailing slash from the reference URL.
  if (config.referenceSiteURL) {
    config.referenceSiteURL = config.referenceSiteURL.toString().replace(/\/+$/, '');
  }
  const initializeSnippet = (0,_createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__["default"])(config, dataLayerTarget);
  const trackEvent = (0,_createTrackEvent__WEBPACK_IMPORTED_MODULE_2__["default"])(config, dataLayerTarget, initializeSnippet, _global);
  const onceTrackedEventsMap = {};
  function trackEventOnce(...params) {
    const key = JSON.stringify(params);
    if (!onceTrackedEventsMap[key]) {
      onceTrackedEventsMap[key] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.once)(trackEvent);
    }
    onceTrackedEventsMap[key](...params);
  }
  return {
    enableTracking: function enableTracking() {
      config.trackingEnabled = true;
    },
    disableTracking: function disableTracking() {
      config.trackingEnabled = false;
    },
    initializeSnippet,
    isTrackingEnabled: function isTrackingEnabled() {
      return !!config.trackingEnabled;
    },
    trackEvent,
    trackEventOnce
  };
}

/***/ }),

/***/ "./js/util/tracking/index.js":
/*!***********************************!*\
  !*** ./js/util/tracking/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTracking: () => (/* binding */ disableTracking),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   isTrackingEnabled: () => (/* binding */ isTrackingEnabled),
/* harmony export */   toggleTracking: () => (/* binding */ toggleTracking),
/* harmony export */   trackEvent: () => (/* binding */ trackEvent),
/* harmony export */   trackEventOnce: () => (/* binding */ trackEventOnce)
/* harmony export */ });
/* harmony import */ var _createTracking__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createTracking */ "./js/util/tracking/createTracking.js");
/**
 * Event tracking utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * Internal dependencies
 */

const {
  activeModules = [],
  isSiteKitScreen,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isAuthenticated,
  userRoles
} = __webpack_require__.g._googlesitekitTrackingData || {};

// Access the plugin version directly without destructuring as Webpack's DefinePlugin
// performs text replacement at build time and doesn't support destructuring patterns.
// See: https://github.com/google/site-kit-wp/issues/11802#issuecomment-3562955579
const pluginVersion = "1.170.0";
const initialConfig = {
  activeModules,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isSiteKitScreen,
  userRoles,
  isAuthenticated,
  pluginVersion
};
const {
  enableTracking,
  disableTracking,
  isTrackingEnabled,
  initializeSnippet,
  trackEvent,
  trackEventOnce
} = (0,_createTracking__WEBPACK_IMPORTED_MODULE_0__["default"])(initialConfig);

/**
 * Changes the active state of tracking.
 *
 * @since 1.3.0
 *
 * @param {boolean} activeStatus The new state to set.
 */
function toggleTracking(activeStatus) {
  if (!!activeStatus) {
    enableTracking();
  } else {
    disableTracking();
  }
}

// Bootstrap on import if tracking is allowed.
if (isSiteKitScreen && trackingEnabled) {
  initializeSnippet();
}


/***/ }),

/***/ "./js/util/urls.js":
/*!*************************!*\
  !*** ./js/util/urls.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFullURL: () => (/* binding */ getFullURL),
/* harmony export */   getURLPath: () => (/* binding */ getURLPath),
/* harmony export */   isHashOnly: () => (/* binding */ isHashOnly),
/* harmony export */   normalizeURL: () => (/* binding */ normalizeURL),
/* harmony export */   shortenURL: () => (/* binding */ shortenURL)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/**
 * URL pathname getter utility function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the path from a URL, omitting its protocol, hostname, query params, and hash.
 *
 * @since 1.24.0
 *
 * @param {string} url The URL to get the path from.
 * @return {string} The URL path.
 */
function getURLPath(url) {
  try {
    return new URL(url).pathname;
  } catch {}
  return null;
}

/**
 * Returns the absolute URL from a path including the siteURL.
 *
 * @since 1.32.0
 *
 * @param {string} siteURL The siteURL fo the WordPress install.
 * @param {string} path    The path.
 * @return {string} The URL path.
 */
function getFullURL(siteURL, path) {
  try {
    return new URL(path, siteURL).href;
  } catch {}
  return (typeof siteURL === 'string' ? siteURL : '') + (typeof path === 'string' ? path : '');
}

/**
 * Normalizes URL by removing protocol, www subdomain and trailing slash.
 *
 * @since 1.33.0
 *
 * @param {string} incomingURL The original URL.
 * @return {string} Normalized URL.
 */
function normalizeURL(incomingURL) {
  if (typeof incomingURL !== 'string') {
    return incomingURL;
  }
  return incomingURL
  // Remove protocol and optional "www." prefix from the URL.
  .replace(/^https?:\/\/(www\.)?/i, '')
  // Remove trailing slash.
  .replace(/\/$/, '');
}

/**
 * Checks if a string is not a full URL and simply a hash / anchor link.
 *
 * @since 1.49.0
 *
 * @param {string} url The URL or Hash string to test.
 * @return {boolean} Returns true if the string is only a hash and not a full URL.
 */
function isHashOnly(url) {
  return /^#\w[A-Za-z0-9-_]*$/.test(url);
}

/**
 * Shortens a URL to fit a given length.
 *
 * @since 1.49.0
 *
 * @param {string} url      The original URL to shorten.
 * @param {number} maxChars The maximum length of the URL.
 * @return {string} The shortened URL.
 */
function shortenURL(url, maxChars) {
  if (!(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.isURL)(url)) {
    return url;
  }
  if (url.length <= maxChars) {
    return url;
  }
  const urlObject = new URL(url);
  const shortenedURL = url.replace(urlObject.origin, '');
  if (shortenedURL.length < maxChars) {
    return shortenedURL;
  }
  const extraChars = shortenedURL.length - Math.floor(maxChars) + 1; // 1 is the length of "…".
  return '…' + shortenedURL.substr(extraChars);
}

/***/ }),

/***/ "./js/util/withIntersectionObserver.js":
/*!*********************************************!*\
  !*** ./js/util/withIntersectionObserver.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ withIntersectionObserver)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * `withIntersectionObserver` HOC.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Higher-Order Component to render a wrapped component and trigger a callback when it becomes in view.
 *
 * This was initially added to provide a workaround for a limitation with the `useIntersection` hook from `react-use`.
 * We should replace `useIntersection()` with a version that doesn't have this limitation.
 * See https://github.com/streamich/react-use/issues/2359.
 *
 * This HOC can however remain as an abstraction around `useIntersection()` to avoid repeating the same logic.
 *
 * @since 1.125.0
 *
 * @param {WPComponent} WrappedComponent Component to wrap.
 * @return {Function} Enhancing function.
 */

function withIntersectionObserver(WrappedComponent) {
  function WithIntersectionObserverComponent({
    onInView,
    ...props
  }) {
    const inViewRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useRef)();
    const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_2__["default"])(inViewRef, {
      root: null,
      threshold: 0.45
    });
    const [hasBeenInView, setHasBeenInView] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const inView = !!intersectionEntry?.isIntersecting && !!intersectionEntry?.intersectionRatio;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
      if (!intersectionEntry) {
        return;
      }
      if (inView && !hasBeenInView) {
        onInView();
        setHasBeenInView(true);
      }
    }, [hasBeenInView, inView, intersectionEntry, onInView]);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(WrappedComponent, {
      ref: inViewRef,
      ...props
    });
  }
  WithIntersectionObserverComponent.displayName = 'WithIntersectionObserverComponent';
  if (WrappedComponent.displayName || WrappedComponent.name) {
    WithIntersectionObserverComponent.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
  }
  WithIntersectionObserverComponent.propTypes = {
    onInView: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
    ...WrappedComponent.propTypes
  };
  return WithIntersectionObserverComponent;
}

/***/ }),

/***/ "./svg/graphics/tagmanager.svg":
/*!*************************************!*\
  !*** ./svg/graphics/tagmanager.svg ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgTagmanager = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 40 40"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  transform: "translate(.422 .422)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#8ab4f8",
  d: "m16.091 30.725 14.461-14.543 6.817 6.856L22.908 37.58z"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#4285f4",
  d: "M22.91 8.496 16.09 1.64 1.63 16.182a4.867 4.867 0 0 0 0 6.854L16.09 37.58l6.817-6.855L11.856 19.61z"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ellipse", {
  cx: 19.5,
  cy: 34.153,
  fill: "#1967d2",
  rx: 4.82,
  ry: 4.847
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#8ab4f8",
  d: "M37.37 16.182 22.91 1.639a4.8 4.8 0 0 0-6.817 0 4.867 4.867 0 0 0 0 6.855l14.46 14.542a4.8 4.8 0 0 0 6.817 0 4.867 4.867 0 0 0 0-6.854"
}))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgTagmanager);

/***/ }),

/***/ "./svg/icons/arrow-inverse.svg":
/*!*************************************!*\
  !*** ./svg/icons/arrow-inverse.svg ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrowInverse = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "#FFF"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrowInverse);

/***/ }),

/***/ "./svg/icons/arrow.svg":
/*!*****************************!*\
  !*** ./svg/icons/arrow.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrow = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "currentColor"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#FFF",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrow);

/***/ }),

/***/ "./svg/icons/back.svg":
/*!****************************!*\
  !*** ./svg/icons/back.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgBack = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "m12 20-8-8 8-8 1.425 1.4-5.6 5.6H20v2H7.825l5.6 5.6z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgBack);

/***/ }),

/***/ "./svg/icons/check-fill.svg":
/*!**********************************!*\
  !*** ./svg/icons/check-fill.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgCheckFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  fillRule: "evenodd",
  d: "M12 1C5.925 1 1 5.925 1 12s4.925 11 11 11 11-4.925 11-11S18.075 1 12 1m4.806 8.592.592-.806-1.612-1.184-.592.806-3.89 5.296c-.166.226-.36.296-.512.296s-.346-.07-.512-.296l-1.474-2.007-.592-.806-1.612 1.184.592.806 1.474 2.007C9.191 15.6 9.971 16 10.792 16s1.6-.4 2.124-1.112z",
  clipRule: "evenodd"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgCheckFill);

/***/ }),

/***/ "./svg/icons/external.svg":
/*!********************************!*\
  !*** ./svg/icons/external.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgExternal = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "M5 21a2 2 0 0 1-1.425-.575A2 2 0 0 1 3 19V5q0-.825.575-1.4Q4.175 3 5 3h7v2H5v14h14v-7h2v7q0 .825-.6 1.425Q19.825 21 19 21zm4.7-5.3-1.4-1.4L17.6 5H14V3h7v7h-2V6.4z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgExternal);

/***/ }),

/***/ "./svg/icons/star-fill.svg":
/*!*********************************!*\
  !*** ./svg/icons/star-fill.svg ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgStarFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "m5.825 22 2.325-7.6L2 10h7.6L12 2l2.4 8H22l-6.15 4.4 2.325 7.6L12 17.3z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgStarFill);

/***/ }),

/***/ "./svg/icons/warning-notice.svg":
/*!**************************************!*\
  !*** ./svg/icons/warning-notice.svg ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningNotice = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1m0 14a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3m-1-2h2V6h-2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningNotice);

/***/ }),

/***/ "./svg/icons/warning-v2.svg":
/*!**********************************!*\
  !*** ./svg/icons/warning-v2.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningV2 = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 22 19"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M0 19h22L11 0zm12-3h-2v-2h2zm0-4h-2V8h2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningV2);

/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.i18n;

/***/ }),

/***/ "googlesitekit-api":
/*!****************************************!*\
  !*** external ["googlesitekit","api"] ***!
  \****************************************/
/***/ ((module) => {

module.exports = googlesitekit.api;

/***/ }),

/***/ "googlesitekit-components":
/*!***********************************************!*\
  !*** external ["googlesitekit","components"] ***!
  \***********************************************/
/***/ ((module) => {

module.exports = googlesitekit.components;

/***/ }),

/***/ "googlesitekit-data":
/*!*****************************************!*\
  !*** external ["googlesitekit","data"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.data;

/***/ }),

/***/ "googlesitekit-modules":
/*!********************************************!*\
  !*** external ["googlesitekit","modules"] ***!
  \********************************************/
/***/ ((module) => {

module.exports = googlesitekit.modules;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-modules-tagmanager.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-modules-tagmanager.js.map