/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./assets/js/api-fetch-shim.js":
/*!*************************************!*\
  !*** ./assets/js/api-fetch-shim.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch__non-shim */ "./node_modules/@wordpress/api-fetch/build/index.js");
/* harmony import */ var _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/api/middleware/deduplication */ "./assets/js/googlesitekit/api/middleware/deduplication.ts");
/* harmony import */ var _googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./googlesitekit/api/middleware/preloading.js */ "./assets/js/googlesitekit/api/middleware/preloading.js");
/* harmony reexport (unknown) */ var __WEBPACK_REEXPORT_OBJECT__ = {};
/* harmony reexport (unknown) */ for(const __WEBPACK_IMPORT_KEY__ in _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== "default") __WEBPACK_REEXPORT_OBJECT__[__WEBPACK_IMPORT_KEY__] = () => _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0__[__WEBPACK_IMPORT_KEY__]
/* harmony reexport (unknown) */ __webpack_require__.d(__webpack_exports__, __WEBPACK_REEXPORT_OBJECT__);
/**
 * API Fetch Shim.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const {
  nonce,
  nonceEndpoint,
  preloadedData,
  rootURL
} = __webpack_require__.g._googlesitekitAPIFetchData || {};
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceEndpoint) = nonceEndpoint;
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceMiddleware) = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().createNonceMiddleware(nonce);
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().rootURLMiddleware) = _wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().createRootURLMiddleware(rootURL);
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().dedupeMiddleware) = (0,_js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_1__["default"])({
  onDuplicate: _js_googlesitekit_api_middleware_deduplication__WEBPACK_IMPORTED_MODULE_1__.logDuplicate
});
(_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().preloadingMiddleware) = (0,_googlesitekit_api_middleware_preloading_js__WEBPACK_IMPORTED_MODULE_2__["default"])(preloadedData);
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().nonceMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().mediaUploadMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().rootURLMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().dedupeMiddleware));
_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().use((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default().preloadingMiddleware));

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((_wordpress_api_fetch_non_shim__WEBPACK_IMPORTED_MODULE_0___default()));

/***/ }),

/***/ "./assets/js/googlesitekit/api/middleware/deduplication.ts":
/*!*****************************************************************!*\
  !*** ./assets/js/googlesitekit/api/middleware/deduplication.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   logDuplicate: () => (/* binding */ logDuplicate)
/* harmony export */ });
/* harmony import */ var equivalent_key_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! equivalent-key-map */ "./node_modules/equivalent-key-map/equivalent-key-map.js");
/* harmony import */ var equivalent_key_map__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(equivalent_key_map__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */

/**
 * Logs a console warning for the given request options.
 *
 * @since n.e.x.t
 *
 * @param  options API fetch options of the duplicate request.
 * @return {void}
 */
function logDuplicate(options) {
  __webpack_require__.g.console.warn('Google Site Kit API: duplicate request', options);
}
/**
 * Creates a new request deduplication middleware instance.
 *
 * @since n.e.x.t
 *
 * @param middlewareOptions Options for configuring the behavior of the middleware.
 * @return Middleware handler function.
 */
function createDedupeMiddleware(middlewareOptions = {}) {
  const {
    onDuplicate
  } = middlewareOptions;
  const concurrentRequests = new (equivalent_key_map__WEBPACK_IMPORTED_MODULE_0___default())();
  return function (options, next) {
    // If we already have a request for these options
    // call the handler, if any, and return the shared response.
    const existingRequest = concurrentRequests.get(options);
    // EquivalentKeyMap doesn't implement `has` as expected, so we need to check the value.
    // When deleting, the value is set to `undefined` so `has(key)` remains true.
    if (existingRequest instanceof Promise) {
      onDuplicate?.(options);
      return existingRequest;
    }
    const promise = next(options);
    concurrentRequests.set(options, promise);

    // Ensure the request entry is removed once the request
    // is completed regardless of any error.
    promise.catch(() => {
      // avoid an uncaught error here
    }).finally(() => {
      concurrentRequests.delete(options);
    });
    return promise;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createDedupeMiddleware);

/***/ }),

/***/ "./assets/js/googlesitekit/api/middleware/preloading.js":
/*!**************************************************************!*\
  !*** ./assets/js/googlesitekit/api/middleware/preloading.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/url/build-module/normalize-path.js");
/**
 * Custom preloading middleware.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Creates a preloading middleware.
 *
 * Based on preloadMiddleware from from @wordpress/api-fetch, this middle is a single-use per-endpoint and provides cached
 * data for the first request only and any subsequent requests reach the server.
 *
 * @since 1.13.0
 *
 * @param {Object} preloadedData Preloaded data paths.
 * @return {Function} Function.
 */
function createPreloadingMiddleware(preloadedData) {
  const cache = Object.keys(preloadedData).reduce((result, path) => {
    result[(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(path)] = preloadedData[path];
    return result;
  }, {});
  let cacheHasExpired = false;
  return (options, next) => {
    if (cacheHasExpired) {
      return next(options);
    }
    setTimeout(() => {
      cacheHasExpired = true;
    }, 3000);
    const {
      parse = true
    } = options;
    const uri = options.path;
    if (typeof options.path === 'string') {
      const method = options.method?.toUpperCase() || 'GET';
      const path = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(uri);
      if (parse && 'GET' === method && cache[path]) {
        const result = Promise.resolve(cache[path].body);
        delete cache[path];
        return result;
      } else if ('OPTIONS' === method && cache[method] && cache[method][path]) {
        const result = Promise.resolve(cache[method][path]);
        delete cache[method][path];
        return result;
      }
    }
    return next(options);
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPreloadingMiddleware);

/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/index.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/index.ts
var index_exports = {};
__export(index_exports, {
  default: () => index_default
});
module.exports = __toCommonJS(index_exports);
var import_i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var import_nonce = __toESM(__webpack_require__(/*! ./middlewares/nonce */ "./node_modules/@wordpress/api-fetch/build/middlewares/nonce.js"));
var import_root_url = __toESM(__webpack_require__(/*! ./middlewares/root-url */ "./node_modules/@wordpress/api-fetch/build/middlewares/root-url.js"));
var import_preloading = __toESM(__webpack_require__(/*! ./middlewares/preloading */ "./node_modules/@wordpress/api-fetch/build/middlewares/preloading.js"));
var import_fetch_all_middleware = __toESM(__webpack_require__(/*! ./middlewares/fetch-all-middleware */ "./node_modules/@wordpress/api-fetch/build/middlewares/fetch-all-middleware.js"));
var import_namespace_endpoint = __toESM(__webpack_require__(/*! ./middlewares/namespace-endpoint */ "./node_modules/@wordpress/api-fetch/build/middlewares/namespace-endpoint.js"));
var import_http_v1 = __toESM(__webpack_require__(/*! ./middlewares/http-v1 */ "./node_modules/@wordpress/api-fetch/build/middlewares/http-v1.js"));
var import_user_locale = __toESM(__webpack_require__(/*! ./middlewares/user-locale */ "./node_modules/@wordpress/api-fetch/build/middlewares/user-locale.js"));
var import_media_upload = __toESM(__webpack_require__(/*! ./middlewares/media-upload */ "./node_modules/@wordpress/api-fetch/build/middlewares/media-upload.js"));
var import_theme_preview = __toESM(__webpack_require__(/*! ./middlewares/theme-preview */ "./node_modules/@wordpress/api-fetch/build/middlewares/theme-preview.js"));
var import_response = __webpack_require__(/*! ./utils/response */ "./node_modules/@wordpress/api-fetch/build/utils/response.js");
__reExport(index_exports, __webpack_require__(/*! ./types */ "./node_modules/@wordpress/api-fetch/build/types.js"), module.exports);
var DEFAULT_HEADERS = {
  // The backend uses the Accept header as a condition for considering an
  // incoming request as a REST request.
  //
  // See: https://core.trac.wordpress.org/ticket/44534
  Accept: "application/json, */*;q=0.1"
};
var DEFAULT_OPTIONS = {
  credentials: "include"
};
var middlewares = [
  import_user_locale.default,
  import_namespace_endpoint.default,
  import_http_v1.default,
  import_fetch_all_middleware.default
];
function registerMiddleware(middleware) {
  middlewares.unshift(middleware);
}
var defaultFetchHandler = (nextOptions) => {
  const { url, path, data, parse = true, ...remainingOptions } = nextOptions;
  let { body, headers } = nextOptions;
  headers = { ...DEFAULT_HEADERS, ...headers };
  if (data) {
    body = JSON.stringify(data);
    headers["Content-Type"] = "application/json";
  }
  const responsePromise = globalThis.fetch(
    // Fall back to explicitly passing `window.location` which is the behavior if `undefined` is passed.
    url || path || window.location.href,
    {
      ...DEFAULT_OPTIONS,
      ...remainingOptions,
      body,
      headers
    }
  );
  return responsePromise.then(
    (response) => {
      if (!response.ok) {
        return (0, import_response.parseAndThrowError)(response, parse);
      }
      return (0, import_response.parseResponseAndNormalizeError)(response, parse);
    },
    (err) => {
      if (err && err.name === "AbortError") {
        throw err;
      }
      if (!globalThis.navigator.onLine) {
        throw {
          code: "offline_error",
          message: (0, import_i18n.__)(
            "Unable to connect. Please check your Internet connection."
          )
        };
      }
      throw {
        code: "fetch_error",
        message: (0, import_i18n.__)(
          "Could not get a valid response from the server."
        )
      };
    }
  );
};
var fetchHandler = defaultFetchHandler;
function setFetchHandler(newFetchHandler) {
  fetchHandler = newFetchHandler;
}
var apiFetch = (options) => {
  const enhancedHandler = middlewares.reduceRight(
    (next, middleware) => {
      return (workingOptions) => middleware(workingOptions, next);
    },
    fetchHandler
  );
  return enhancedHandler(options).catch((error) => {
    if (error.code !== "rest_cookie_invalid_nonce") {
      return Promise.reject(error);
    }
    return globalThis.fetch(apiFetch.nonceEndpoint).then((response) => {
      if (!response.ok) {
        return Promise.reject(error);
      }
      return response.text();
    }).then((text) => {
      apiFetch.nonceMiddleware.nonce = text;
      return apiFetch(options);
    });
  });
};
apiFetch.use = registerMiddleware;
apiFetch.setFetchHandler = setFetchHandler;
apiFetch.createNonceMiddleware = import_nonce.default;
apiFetch.createPreloadingMiddleware = import_preloading.default;
apiFetch.createRootURLMiddleware = import_root_url.default;
apiFetch.fetchAllMiddleware = import_fetch_all_middleware.default;
apiFetch.mediaUploadMiddleware = import_media_upload.default;
apiFetch.createThemePreviewMiddleware = import_theme_preview.default;
var index_default = apiFetch;
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/fetch-all-middleware.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/fetch-all-middleware.js ***!
  \*************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/fetch-all-middleware.ts
var fetch_all_middleware_exports = {};
__export(fetch_all_middleware_exports, {
  default: () => fetch_all_middleware_default
});
module.exports = __toCommonJS(fetch_all_middleware_exports);
var import_url = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/index.js");
var import__ = __toESM(__webpack_require__(/*! .. */ "./node_modules/@wordpress/api-fetch/build/index.js"));
var modifyQuery = ({ path, url, ...options }, queryArgs) => ({
  ...options,
  url: url && (0, import_url.addQueryArgs)(url, queryArgs),
  path: path && (0, import_url.addQueryArgs)(path, queryArgs)
});
var parseResponse = (response) => response.json ? response.json() : Promise.reject(response);
var parseLinkHeader = (linkHeader) => {
  if (!linkHeader) {
    return {};
  }
  const match = linkHeader.match(/<([^>]+)>; rel="next"/);
  return match ? {
    next: match[1]
  } : {};
};
var getNextPageUrl = (response) => {
  const { next } = parseLinkHeader(response.headers.get("link"));
  return next;
};
var requestContainsUnboundedQuery = (options) => {
  const pathIsUnbounded = !!options.path && options.path.indexOf("per_page=-1") !== -1;
  const urlIsUnbounded = !!options.url && options.url.indexOf("per_page=-1") !== -1;
  return pathIsUnbounded || urlIsUnbounded;
};
var fetchAllMiddleware = async (options, next) => {
  if (options.parse === false) {
    return next(options);
  }
  if (!requestContainsUnboundedQuery(options)) {
    return next(options);
  }
  const response = await (0, import__.default)({
    ...modifyQuery(options, {
      per_page: 100
    }),
    // Ensure headers are returned for page 1.
    parse: false
  });
  const results = await parseResponse(response);
  if (!Array.isArray(results)) {
    return results;
  }
  let nextPage = getNextPageUrl(response);
  if (!nextPage) {
    return results;
  }
  let mergedResults = [].concat(results);
  while (nextPage) {
    const nextResponse = await (0, import__.default)({
      ...options,
      // Ensure the URL for the next page is used instead of any provided path.
      path: void 0,
      url: nextPage,
      // Ensure we still get headers so we can identify the next page.
      parse: false
    });
    const nextResults = await parseResponse(nextResponse);
    mergedResults = mergedResults.concat(nextResults);
    nextPage = getNextPageUrl(nextResponse);
  }
  return mergedResults;
};
var fetch_all_middleware_default = fetchAllMiddleware;
//# sourceMappingURL=fetch-all-middleware.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/http-v1.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/http-v1.js ***!
  \************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/http-v1.ts
var http_v1_exports = {};
__export(http_v1_exports, {
  default: () => http_v1_default
});
module.exports = __toCommonJS(http_v1_exports);
var OVERRIDE_METHODS = /* @__PURE__ */ new Set(["PATCH", "PUT", "DELETE"]);
var DEFAULT_METHOD = "GET";
var httpV1Middleware = (options, next) => {
  const { method = DEFAULT_METHOD } = options;
  if (OVERRIDE_METHODS.has(method.toUpperCase())) {
    options = {
      ...options,
      headers: {
        ...options.headers,
        "X-HTTP-Method-Override": method,
        "Content-Type": "application/json"
      },
      method: "POST"
    };
  }
  return next(options);
};
var http_v1_default = httpV1Middleware;
//# sourceMappingURL=http-v1.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/media-upload.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/media-upload.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/media-upload.ts
var media_upload_exports = {};
__export(media_upload_exports, {
  default: () => media_upload_default
});
module.exports = __toCommonJS(media_upload_exports);
var import_i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var import_response = __webpack_require__(/*! ../utils/response */ "./node_modules/@wordpress/api-fetch/build/utils/response.js");
function isMediaUploadRequest(options) {
  const isCreateMethod = !!options.method && options.method === "POST";
  const isMediaEndpoint = !!options.path && options.path.indexOf("/wp/v2/media") !== -1 || !!options.url && options.url.indexOf("/wp/v2/media") !== -1;
  return isMediaEndpoint && isCreateMethod;
}
var mediaUploadMiddleware = (options, next) => {
  if (!isMediaUploadRequest(options)) {
    return next(options);
  }
  let retries = 0;
  const maxRetries = 5;
  const postProcess = (attachmentId) => {
    retries++;
    return next({
      path: `/wp/v2/media/${attachmentId}/post-process`,
      method: "POST",
      data: { action: "create-image-subsizes" },
      parse: false
    }).catch(() => {
      if (retries < maxRetries) {
        return postProcess(attachmentId);
      }
      next({
        path: `/wp/v2/media/${attachmentId}?force=true`,
        method: "DELETE"
      });
      return Promise.reject();
    });
  };
  return next({ ...options, parse: false }).catch((response) => {
    if (!(response instanceof globalThis.Response)) {
      return Promise.reject(response);
    }
    const attachmentId = response.headers.get(
      "x-wp-upload-attachment-id"
    );
    if (response.status >= 500 && response.status < 600 && attachmentId) {
      return postProcess(attachmentId).catch(() => {
        if (options.parse !== false) {
          return Promise.reject({
            code: "post_process",
            message: (0, import_i18n.__)(
              "Media upload failed. If this is a photo or a large image, please scale it down and try again."
            )
          });
        }
        return Promise.reject(response);
      });
    }
    return (0, import_response.parseAndThrowError)(response, options.parse);
  }).then(
    (response) => (0, import_response.parseResponseAndNormalizeError)(response, options.parse)
  );
};
var media_upload_default = mediaUploadMiddleware;
//# sourceMappingURL=media-upload.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/namespace-endpoint.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/namespace-endpoint.js ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/namespace-endpoint.ts
var namespace_endpoint_exports = {};
__export(namespace_endpoint_exports, {
  default: () => namespace_endpoint_default
});
module.exports = __toCommonJS(namespace_endpoint_exports);
var namespaceAndEndpointMiddleware = (options, next) => {
  let path = options.path;
  let namespaceTrimmed, endpointTrimmed;
  if (typeof options.namespace === "string" && typeof options.endpoint === "string") {
    namespaceTrimmed = options.namespace.replace(/^\/|\/$/g, "");
    endpointTrimmed = options.endpoint.replace(/^\//, "");
    if (endpointTrimmed) {
      path = namespaceTrimmed + "/" + endpointTrimmed;
    } else {
      path = namespaceTrimmed;
    }
  }
  delete options.namespace;
  delete options.endpoint;
  return next({
    ...options,
    path
  });
};
var namespace_endpoint_default = namespaceAndEndpointMiddleware;
//# sourceMappingURL=namespace-endpoint.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/nonce.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/nonce.js ***!
  \**********************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/nonce.ts
var nonce_exports = {};
__export(nonce_exports, {
  default: () => nonce_default
});
module.exports = __toCommonJS(nonce_exports);
function createNonceMiddleware(nonce) {
  const middleware = (options, next) => {
    const { headers = {} } = options;
    for (const headerName in headers) {
      if (headerName.toLowerCase() === "x-wp-nonce" && headers[headerName] === middleware.nonce) {
        return next(options);
      }
    }
    return next({
      ...options,
      headers: {
        ...headers,
        "X-WP-Nonce": middleware.nonce
      }
    });
  };
  middleware.nonce = nonce;
  return middleware;
}
var nonce_default = createNonceMiddleware;
//# sourceMappingURL=nonce.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/preloading.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/preloading.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/preloading.ts
var preloading_exports = {};
__export(preloading_exports, {
  default: () => preloading_default
});
module.exports = __toCommonJS(preloading_exports);
var import_url = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/index.js");
function createPreloadingMiddleware(preloadedData) {
  const cache = Object.fromEntries(
    Object.entries(preloadedData).map(([path, data]) => [
      (0, import_url.normalizePath)(path),
      data
    ])
  );
  return (options, next) => {
    const { parse = true } = options;
    let rawPath = options.path;
    if (!rawPath && options.url) {
      const { rest_route: pathFromQuery, ...queryArgs } = (0, import_url.getQueryArgs)(
        options.url
      );
      if (typeof pathFromQuery === "string") {
        rawPath = (0, import_url.addQueryArgs)(pathFromQuery, queryArgs);
      }
    }
    if (typeof rawPath !== "string") {
      return next(options);
    }
    const method = options.method || "GET";
    const path = (0, import_url.normalizePath)(rawPath);
    if ("GET" === method && cache[path]) {
      const cacheData = cache[path];
      delete cache[path];
      return prepareResponse(cacheData, !!parse);
    } else if ("OPTIONS" === method && cache[method] && cache[method][path]) {
      const cacheData = cache[method][path];
      delete cache[method][path];
      return prepareResponse(cacheData, !!parse);
    }
    return next(options);
  };
}
function prepareResponse(responseData, parse) {
  if (parse) {
    return Promise.resolve(responseData.body);
  }
  try {
    return Promise.resolve(
      new window.Response(JSON.stringify(responseData.body), {
        status: 200,
        statusText: "OK",
        headers: responseData.headers
      })
    );
  } catch {
    Object.entries(
      responseData.headers
    ).forEach(([key, value]) => {
      if (key.toLowerCase() === "link") {
        responseData.headers[key] = value.replace(
          /<([^>]+)>/,
          (_, url) => `<${encodeURI(url)}>`
        );
      }
    });
    return Promise.resolve(
      parse ? responseData.body : new window.Response(JSON.stringify(responseData.body), {
        status: 200,
        statusText: "OK",
        headers: responseData.headers
      })
    );
  }
}
var preloading_default = createPreloadingMiddleware;
//# sourceMappingURL=preloading.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/root-url.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/root-url.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/root-url.ts
var root_url_exports = {};
__export(root_url_exports, {
  default: () => root_url_default
});
module.exports = __toCommonJS(root_url_exports);
var import_namespace_endpoint = __toESM(__webpack_require__(/*! ./namespace-endpoint */ "./node_modules/@wordpress/api-fetch/build/middlewares/namespace-endpoint.js"));
var createRootURLMiddleware = (rootURL) => (options, next) => {
  return (0, import_namespace_endpoint.default)(options, (optionsWithPath) => {
    let url = optionsWithPath.url;
    let path = optionsWithPath.path;
    let apiRoot;
    if (typeof path === "string") {
      apiRoot = rootURL;
      if (-1 !== rootURL.indexOf("?")) {
        path = path.replace("?", "&");
      }
      path = path.replace(/^\//, "");
      if ("string" === typeof apiRoot && -1 !== apiRoot.indexOf("?")) {
        path = path.replace("?", "&");
      }
      url = apiRoot + path;
    }
    return next({
      ...optionsWithPath,
      url
    });
  });
};
var root_url_default = createRootURLMiddleware;
//# sourceMappingURL=root-url.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/theme-preview.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/theme-preview.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/theme-preview.ts
var theme_preview_exports = {};
__export(theme_preview_exports, {
  default: () => theme_preview_default
});
module.exports = __toCommonJS(theme_preview_exports);
var import_url = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/index.js");
var createThemePreviewMiddleware = (themePath) => (options, next) => {
  if (typeof options.url === "string") {
    const wpThemePreview = (0, import_url.getQueryArg)(
      options.url,
      "wp_theme_preview"
    );
    if (wpThemePreview === void 0) {
      options.url = (0, import_url.addQueryArgs)(options.url, {
        wp_theme_preview: themePath
      });
    } else if (wpThemePreview === "") {
      options.url = (0, import_url.removeQueryArgs)(
        options.url,
        "wp_theme_preview"
      );
    }
  }
  if (typeof options.path === "string") {
    const wpThemePreview = (0, import_url.getQueryArg)(
      options.path,
      "wp_theme_preview"
    );
    if (wpThemePreview === void 0) {
      options.path = (0, import_url.addQueryArgs)(options.path, {
        wp_theme_preview: themePath
      });
    } else if (wpThemePreview === "") {
      options.path = (0, import_url.removeQueryArgs)(
        options.path,
        "wp_theme_preview"
      );
    }
  }
  return next(options);
};
var theme_preview_default = createThemePreviewMiddleware;
//# sourceMappingURL=theme-preview.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/middlewares/user-locale.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/middlewares/user-locale.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/middlewares/user-locale.ts
var user_locale_exports = {};
__export(user_locale_exports, {
  default: () => user_locale_default
});
module.exports = __toCommonJS(user_locale_exports);
var import_url = __webpack_require__(/*! @wordpress/url */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/index.js");
var userLocaleMiddleware = (options, next) => {
  if (typeof options.url === "string" && !(0, import_url.hasQueryArg)(options.url, "_locale")) {
    options.url = (0, import_url.addQueryArgs)(options.url, { _locale: "user" });
  }
  if (typeof options.path === "string" && !(0, import_url.hasQueryArg)(options.path, "_locale")) {
    options.path = (0, import_url.addQueryArgs)(options.path, { _locale: "user" });
  }
  return next(options);
};
var user_locale_default = userLocaleMiddleware;
//# sourceMappingURL=user-locale.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/types.js":
/*!**********************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/types.js ***!
  \**********************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/types.ts
var types_exports = {};
module.exports = __toCommonJS(types_exports);
//# sourceMappingURL=types.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/build/utils/response.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/build/utils/response.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/api-fetch/src/utils/response.ts
var response_exports = {};
__export(response_exports, {
  parseAndThrowError: () => parseAndThrowError,
  parseResponseAndNormalizeError: () => parseResponseAndNormalizeError
});
module.exports = __toCommonJS(response_exports);
var import_i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
async function parseJsonAndNormalizeError(response) {
  try {
    return await response.json();
  } catch {
    throw {
      code: "invalid_json",
      message: (0, import_i18n.__)("The response is not a valid JSON response.")
    };
  }
}
async function parseResponseAndNormalizeError(response, shouldParseResponse = true) {
  if (!shouldParseResponse) {
    return response;
  }
  if (response.status === 204) {
    return null;
  }
  return await parseJsonAndNormalizeError(response);
}
async function parseAndThrowError(response, shouldParseResponse = true) {
  if (!shouldParseResponse) {
    throw response;
  }
  throw await parseJsonAndNormalizeError(response);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=response.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/add-query-args.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/add-query-args.js ***!
  \***********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/add-query-args.ts
var add_query_args_exports = {};
__export(add_query_args_exports, {
  addQueryArgs: () => addQueryArgs
});
module.exports = __toCommonJS(add_query_args_exports);
var import_get_query_args = __webpack_require__(/*! ./get-query-args */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-args.js");
var import_build_query_string = __webpack_require__(/*! ./build-query-string */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/build-query-string.js");
var import_get_fragment = __webpack_require__(/*! ./get-fragment */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-fragment.js");
function addQueryArgs(url = "", args) {
  if (!args || !Object.keys(args).length) {
    return url;
  }
  const fragment = (0, import_get_fragment.getFragment)(url) || "";
  let baseUrl = url.replace(fragment, "");
  const queryStringIndex = url.indexOf("?");
  if (queryStringIndex !== -1) {
    args = Object.assign((0, import_get_query_args.getQueryArgs)(url), args);
    baseUrl = baseUrl.substr(0, queryStringIndex);
  }
  return baseUrl + "?" + (0, import_build_query_string.buildQueryString)(args) + fragment;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=add-query-args.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/build-query-string.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/build-query-string.js ***!
  \***************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/build-query-string.ts
var build_query_string_exports = {};
__export(build_query_string_exports, {
  buildQueryString: () => buildQueryString
});
module.exports = __toCommonJS(build_query_string_exports);
function buildQueryString(data) {
  let string = "";
  const stack = Object.entries(data);
  let pair;
  while (pair = stack.shift()) {
    let [key, value] = pair;
    const hasNestedData = Array.isArray(value) || value && value.constructor === Object;
    if (hasNestedData) {
      const valuePairs = Object.entries(value).reverse();
      for (const [member, memberValue] of valuePairs) {
        stack.unshift([`${key}[${member}]`, memberValue]);
      }
    } else if (value !== void 0) {
      if (value === null) {
        value = "";
      }
      string += "&" + [key, String(value)].map(encodeURIComponent).join("=");
    }
  }
  return string.substr(1);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=build-query-string.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/clean-for-slug.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/clean-for-slug.js ***!
  \***********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/clean-for-slug.ts
var clean_for_slug_exports = {};
__export(clean_for_slug_exports, {
  cleanForSlug: () => cleanForSlug
});
module.exports = __toCommonJS(clean_for_slug_exports);
var import_remove_accents = __toESM(__webpack_require__(/*! remove-accents */ "./node_modules/remove-accents/index.js"));
function cleanForSlug(string) {
  if (!string) {
    return "";
  }
  return (0, import_remove_accents.default)(string).replace(/(&nbsp;|&ndash;|&mdash;)/g, "-").replace(/[\s\./]+/g, "-").replace(/&\S+?;/g, "").replace(/[^\p{L}\p{N}_-]+/gu, "").toLowerCase().replace(/-+/g, "-").replace(/(^-+)|(-+$)/g, "");
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=clean-for-slug.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/filter-url-for-display.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/filter-url-for-display.js ***!
  \*******************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/filter-url-for-display.ts
var filter_url_for_display_exports = {};
__export(filter_url_for_display_exports, {
  filterURLForDisplay: () => filterURLForDisplay
});
module.exports = __toCommonJS(filter_url_for_display_exports);
function filterURLForDisplay(url, maxLength = null) {
  if (!url) {
    return "";
  }
  let filteredURL = url.replace(/^[a-z\-.\+]+[0-9]*:(\/\/)?/i, "").replace(/^www\./i, "");
  if (filteredURL.match(/^[^\/]+\/$/)) {
    filteredURL = filteredURL.replace("/", "");
  }
  const fileRegexp = /\/([^\/?]+)\.(?:[\w]+)(?=\?|$)/;
  if (!maxLength || filteredURL.length <= maxLength || !filteredURL.match(fileRegexp)) {
    return filteredURL;
  }
  filteredURL = filteredURL.split("?")[0];
  const urlPieces = filteredURL.split("/");
  const file = urlPieces[urlPieces.length - 1];
  if (file.length <= maxLength) {
    return "\u2026" + filteredURL.slice(-maxLength);
  }
  const index = file.lastIndexOf(".");
  const [fileName, extension] = [
    file.slice(0, index),
    file.slice(index + 1)
  ];
  const truncatedFile = fileName.slice(-3) + "." + extension;
  return file.slice(0, maxLength - truncatedFile.length - 1) + "\u2026" + truncatedFile;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=filter-url-for-display.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-authority.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-authority.js ***!
  \**********************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-authority.ts
var get_authority_exports = {};
__export(get_authority_exports, {
  getAuthority: () => getAuthority
});
module.exports = __toCommonJS(get_authority_exports);
function getAuthority(url) {
  const matches = /^[^\/\s:]+:(?:\/\/)?\/?([^\/\s#?]+)[\/#?]{0,1}\S*$/.exec(
    url
  );
  if (matches) {
    return matches[1];
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-authority.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-filename.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-filename.js ***!
  \*********************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-filename.ts
var get_filename_exports = {};
__export(get_filename_exports, {
  getFilename: () => getFilename
});
module.exports = __toCommonJS(get_filename_exports);
function getFilename(url) {
  let filename;
  if (!url) {
    return;
  }
  try {
    filename = new URL(url, "http://example.com").pathname.split("/").pop();
  } catch (error) {
  }
  if (filename) {
    return filename;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-filename.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-fragment.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-fragment.js ***!
  \*********************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-fragment.ts
var get_fragment_exports = {};
__export(get_fragment_exports, {
  getFragment: () => getFragment
});
module.exports = __toCommonJS(get_fragment_exports);
function getFragment(url) {
  const matches = /^\S+?(#[^\s\?]*)/.exec(url);
  if (matches) {
    return matches[1];
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-fragment.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-path-and-query-string.js":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-path-and-query-string.js ***!
  \**********************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-path-and-query-string.ts
var get_path_and_query_string_exports = {};
__export(get_path_and_query_string_exports, {
  getPathAndQueryString: () => getPathAndQueryString
});
module.exports = __toCommonJS(get_path_and_query_string_exports);
var import__ = __webpack_require__(/*! . */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/index.js");
function getPathAndQueryString(url) {
  const path = (0, import__.getPath)(url);
  const queryString = (0, import__.getQueryString)(url);
  let value = "/";
  if (path) {
    value += path;
  }
  if (queryString) {
    value += `?${queryString}`;
  }
  return value;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-path-and-query-string.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-path.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-path.js ***!
  \*****************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-path.ts
var get_path_exports = {};
__export(get_path_exports, {
  getPath: () => getPath
});
module.exports = __toCommonJS(get_path_exports);
function getPath(url) {
  const matches = /^[^\/\s:]+:(?:\/\/)?[^\/\s#?]+[\/]([^\s#?]+)[#?]{0,1}\S*$/.exec(url);
  if (matches) {
    return matches[1];
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-path.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-protocol.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-protocol.js ***!
  \*********************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-protocol.ts
var get_protocol_exports = {};
__export(get_protocol_exports, {
  getProtocol: () => getProtocol
});
module.exports = __toCommonJS(get_protocol_exports);
function getProtocol(url) {
  const matches = /^([^\s:]+:)/.exec(url);
  if (matches) {
    return matches[1];
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-protocol.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-arg.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-arg.js ***!
  \**********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-query-arg.ts
var get_query_arg_exports = {};
__export(get_query_arg_exports, {
  getQueryArg: () => getQueryArg
});
module.exports = __toCommonJS(get_query_arg_exports);
var import_get_query_args = __webpack_require__(/*! ./get-query-args */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-args.js");
function getQueryArg(url, arg) {
  return (0, import_get_query_args.getQueryArgs)(url)[arg];
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-query-arg.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-args.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-args.js ***!
  \***********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-query-args.ts
var get_query_args_exports = {};
__export(get_query_args_exports, {
  getQueryArgs: () => getQueryArgs
});
module.exports = __toCommonJS(get_query_args_exports);
var import_safe_decode_uri_component = __webpack_require__(/*! ./safe-decode-uri-component */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/safe-decode-uri-component.js");
var import_get_query_string = __webpack_require__(/*! ./get-query-string */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-string.js");
function setPath(object, path, value) {
  const length = path.length;
  const lastIndex = length - 1;
  for (let i = 0; i < length; i++) {
    let key = path[i];
    if (!key && Array.isArray(object)) {
      key = object.length.toString();
    }
    key = ["__proto__", "constructor", "prototype"].includes(key) ? key.toUpperCase() : key;
    const isNextKeyArrayIndex = !isNaN(Number(path[i + 1]));
    object[key] = i === lastIndex ? (
      // If at end of path, assign the intended value.
      value
    ) : (
      // Otherwise, advance to the next object in the path, creating
      // it if it does not yet exist.
      object[key] || (isNextKeyArrayIndex ? [] : {})
    );
    if (Array.isArray(object[key]) && !isNextKeyArrayIndex) {
      object[key] = { ...object[key] };
    }
    object = object[key];
  }
}
function getQueryArgs(url) {
  return ((0, import_get_query_string.getQueryString)(url) || "").replace(/\+/g, "%20").split("&").reduce((accumulator, keyValue) => {
    const [key, value = ""] = keyValue.split("=").filter(Boolean).map(import_safe_decode_uri_component.safeDecodeURIComponent);
    if (key) {
      const segments = key.replace(/\]/g, "").split("[");
      setPath(accumulator, segments, value);
    }
    return accumulator;
  }, /* @__PURE__ */ Object.create(null));
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-query-args.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-string.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-string.js ***!
  \*************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/get-query-string.ts
var get_query_string_exports = {};
__export(get_query_string_exports, {
  getQueryString: () => getQueryString
});
module.exports = __toCommonJS(get_query_string_exports);
function getQueryString(url) {
  let query;
  try {
    query = new URL(url, "http://example.com").search.substring(1);
  } catch (error) {
  }
  if (query) {
    return query;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=get-query-string.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/has-query-arg.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/has-query-arg.js ***!
  \**********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/has-query-arg.ts
var has_query_arg_exports = {};
__export(has_query_arg_exports, {
  hasQueryArg: () => hasQueryArg
});
module.exports = __toCommonJS(has_query_arg_exports);
var import_get_query_arg = __webpack_require__(/*! ./get-query-arg */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-arg.js");
function hasQueryArg(url, arg) {
  return (0, import_get_query_arg.getQueryArg)(url, arg) !== void 0;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=has-query-arg.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/index.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/index.js ***!
  \**************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/index.ts
var index_exports = {};
__export(index_exports, {
  addQueryArgs: () => import_add_query_args.addQueryArgs,
  buildQueryString: () => import_build_query_string.buildQueryString,
  cleanForSlug: () => import_clean_for_slug.cleanForSlug,
  filterURLForDisplay: () => import_filter_url_for_display.filterURLForDisplay,
  getAuthority: () => import_get_authority.getAuthority,
  getFilename: () => import_get_filename.getFilename,
  getFragment: () => import_get_fragment.getFragment,
  getPath: () => import_get_path.getPath,
  getPathAndQueryString: () => import_get_path_and_query_string.getPathAndQueryString,
  getProtocol: () => import_get_protocol.getProtocol,
  getQueryArg: () => import_get_query_arg.getQueryArg,
  getQueryArgs: () => import_get_query_args.getQueryArgs,
  getQueryString: () => import_get_query_string.getQueryString,
  hasQueryArg: () => import_has_query_arg.hasQueryArg,
  isEmail: () => import_is_email.isEmail,
  isPhoneNumber: () => import_is_phone_number.isPhoneNumber,
  isURL: () => import_is_url.isURL,
  isValidAuthority: () => import_is_valid_authority.isValidAuthority,
  isValidFragment: () => import_is_valid_fragment.isValidFragment,
  isValidPath: () => import_is_valid_path.isValidPath,
  isValidProtocol: () => import_is_valid_protocol.isValidProtocol,
  isValidQueryString: () => import_is_valid_query_string.isValidQueryString,
  normalizePath: () => import_normalize_path.normalizePath,
  prependHTTP: () => import_prepend_http.prependHTTP,
  prependHTTPS: () => import_prepend_https.prependHTTPS,
  removeQueryArgs: () => import_remove_query_args.removeQueryArgs,
  safeDecodeURI: () => import_safe_decode_uri.safeDecodeURI,
  safeDecodeURIComponent: () => import_safe_decode_uri_component.safeDecodeURIComponent
});
module.exports = __toCommonJS(index_exports);
var import_is_url = __webpack_require__(/*! ./is-url */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-url.js");
var import_is_email = __webpack_require__(/*! ./is-email */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-email.js");
var import_is_phone_number = __webpack_require__(/*! ./is-phone-number */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-phone-number.js");
var import_get_protocol = __webpack_require__(/*! ./get-protocol */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-protocol.js");
var import_is_valid_protocol = __webpack_require__(/*! ./is-valid-protocol */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-protocol.js");
var import_get_authority = __webpack_require__(/*! ./get-authority */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-authority.js");
var import_is_valid_authority = __webpack_require__(/*! ./is-valid-authority */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-authority.js");
var import_get_path = __webpack_require__(/*! ./get-path */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-path.js");
var import_is_valid_path = __webpack_require__(/*! ./is-valid-path */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-path.js");
var import_get_query_string = __webpack_require__(/*! ./get-query-string */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-string.js");
var import_build_query_string = __webpack_require__(/*! ./build-query-string */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/build-query-string.js");
var import_is_valid_query_string = __webpack_require__(/*! ./is-valid-query-string */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-query-string.js");
var import_get_path_and_query_string = __webpack_require__(/*! ./get-path-and-query-string */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-path-and-query-string.js");
var import_get_fragment = __webpack_require__(/*! ./get-fragment */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-fragment.js");
var import_is_valid_fragment = __webpack_require__(/*! ./is-valid-fragment */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-fragment.js");
var import_add_query_args = __webpack_require__(/*! ./add-query-args */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/add-query-args.js");
var import_get_query_arg = __webpack_require__(/*! ./get-query-arg */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-arg.js");
var import_get_query_args = __webpack_require__(/*! ./get-query-args */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-args.js");
var import_has_query_arg = __webpack_require__(/*! ./has-query-arg */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/has-query-arg.js");
var import_remove_query_args = __webpack_require__(/*! ./remove-query-args */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/remove-query-args.js");
var import_prepend_http = __webpack_require__(/*! ./prepend-http */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/prepend-http.js");
var import_safe_decode_uri = __webpack_require__(/*! ./safe-decode-uri */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/safe-decode-uri.js");
var import_safe_decode_uri_component = __webpack_require__(/*! ./safe-decode-uri-component */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/safe-decode-uri-component.js");
var import_filter_url_for_display = __webpack_require__(/*! ./filter-url-for-display */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/filter-url-for-display.js");
var import_clean_for_slug = __webpack_require__(/*! ./clean-for-slug */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/clean-for-slug.js");
var import_get_filename = __webpack_require__(/*! ./get-filename */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-filename.js");
var import_normalize_path = __webpack_require__(/*! ./normalize-path */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/normalize-path.js");
var import_prepend_https = __webpack_require__(/*! ./prepend-https */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/prepend-https.js");
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-email.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-email.js ***!
  \*****************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/is-email.ts
var is_email_exports = {};
__export(is_email_exports, {
  isEmail: () => isEmail
});
module.exports = __toCommonJS(is_email_exports);
var EMAIL_REGEXP = /^(mailto:)?[a-z0-9._%+-]+@[a-z0-9][a-z0-9.-]*\.[a-z]{2,63}$/i;
function isEmail(email) {
  return EMAIL_REGEXP.test(email);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=is-email.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-phone-number.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-phone-number.js ***!
  \************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/is-phone-number.ts
var is_phone_number_exports = {};
__export(is_phone_number_exports, {
  isPhoneNumber: () => isPhoneNumber
});
module.exports = __toCommonJS(is_phone_number_exports);
var PHONE_REGEXP = /^(tel:)?(\+)?\d{6,15}$/;
function isPhoneNumber(phoneNumber) {
  phoneNumber = phoneNumber.replace(/[-.() ]/g, "");
  return PHONE_REGEXP.test(phoneNumber);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=is-phone-number.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-url.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-url.js ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/is-url.ts
var is_url_exports = {};
__export(is_url_exports, {
  isURL: () => isURL
});
module.exports = __toCommonJS(is_url_exports);
function isURL(url) {
  try {
    new URL(url);
    return true;
  } catch {
    return false;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=is-url.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-authority.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-authority.js ***!
  \***************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/is-valid-authority.ts
var is_valid_authority_exports = {};
__export(is_valid_authority_exports, {
  isValidAuthority: () => isValidAuthority
});
module.exports = __toCommonJS(is_valid_authority_exports);
function isValidAuthority(authority) {
  if (!authority) {
    return false;
  }
  return /^[^\s#?]+$/.test(authority);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=is-valid-authority.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-fragment.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-fragment.js ***!
  \**************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/is-valid-fragment.ts
var is_valid_fragment_exports = {};
__export(is_valid_fragment_exports, {
  isValidFragment: () => isValidFragment
});
module.exports = __toCommonJS(is_valid_fragment_exports);
function isValidFragment(fragment) {
  if (!fragment) {
    return false;
  }
  return /^#[^\s#?\/]*$/.test(fragment);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=is-valid-fragment.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-path.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-path.js ***!
  \**********************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/is-valid-path.ts
var is_valid_path_exports = {};
__export(is_valid_path_exports, {
  isValidPath: () => isValidPath
});
module.exports = __toCommonJS(is_valid_path_exports);
function isValidPath(path) {
  if (!path) {
    return false;
  }
  return /^[^\s#?]+$/.test(path);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=is-valid-path.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-protocol.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-protocol.js ***!
  \**************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/is-valid-protocol.ts
var is_valid_protocol_exports = {};
__export(is_valid_protocol_exports, {
  isValidProtocol: () => isValidProtocol
});
module.exports = __toCommonJS(is_valid_protocol_exports);
function isValidProtocol(protocol) {
  if (!protocol) {
    return false;
  }
  return /^[a-z\-.\+]+[0-9]*:$/i.test(protocol);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=is-valid-protocol.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-query-string.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-valid-query-string.js ***!
  \******************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/is-valid-query-string.ts
var is_valid_query_string_exports = {};
__export(is_valid_query_string_exports, {
  isValidQueryString: () => isValidQueryString
});
module.exports = __toCommonJS(is_valid_query_string_exports);
function isValidQueryString(queryString) {
  if (!queryString) {
    return false;
  }
  return /^[^\s#?\/]+$/.test(queryString);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=is-valid-query-string.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/normalize-path.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/normalize-path.js ***!
  \***********************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/normalize-path.ts
var normalize_path_exports = {};
__export(normalize_path_exports, {
  normalizePath: () => normalizePath
});
module.exports = __toCommonJS(normalize_path_exports);
function normalizePath(path) {
  const split = path.split("?");
  const query = split[1];
  const base = split[0];
  if (!query) {
    return base;
  }
  return base + "?" + query.split("&").map((entry) => entry.split("=")).map((pair) => pair.map(decodeURIComponent)).sort((a, b) => a[0].localeCompare(b[0])).map((pair) => pair.map(encodeURIComponent)).map((pair) => pair.join("=")).join("&");
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=normalize-path.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/prepend-http.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/prepend-http.js ***!
  \*********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/prepend-http.ts
var prepend_http_exports = {};
__export(prepend_http_exports, {
  prependHTTP: () => prependHTTP
});
module.exports = __toCommonJS(prepend_http_exports);
var import_is_email = __webpack_require__(/*! ./is-email */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/is-email.js");
var USABLE_HREF_REGEXP = /^(?:[a-z]+:|#|\?|\.|\/)/i;
function prependHTTP(url) {
  if (!url) {
    return url;
  }
  url = url.trim();
  if (!USABLE_HREF_REGEXP.test(url) && !(0, import_is_email.isEmail)(url)) {
    return "http://" + url;
  }
  return url;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=prepend-http.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/prepend-https.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/prepend-https.js ***!
  \**********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/prepend-https.ts
var prepend_https_exports = {};
__export(prepend_https_exports, {
  prependHTTPS: () => prependHTTPS
});
module.exports = __toCommonJS(prepend_https_exports);
var import_prepend_http = __webpack_require__(/*! ./prepend-http */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/prepend-http.js");
function prependHTTPS(url) {
  if (!url) {
    return url;
  }
  if (url.startsWith("http://")) {
    return url;
  }
  url = (0, import_prepend_http.prependHTTP)(url);
  return url.replace(/^http:/, "https:");
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=prepend-https.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/remove-query-args.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/remove-query-args.js ***!
  \**************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/remove-query-args.ts
var remove_query_args_exports = {};
__export(remove_query_args_exports, {
  removeQueryArgs: () => removeQueryArgs
});
module.exports = __toCommonJS(remove_query_args_exports);
var import_get_query_args = __webpack_require__(/*! ./get-query-args */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/get-query-args.js");
var import_build_query_string = __webpack_require__(/*! ./build-query-string */ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/build-query-string.js");
function removeQueryArgs(url, ...args) {
  const fragment = url.replace(/^[^#]*/, "");
  url = url.replace(/#.*/, "");
  const queryStringIndex = url.indexOf("?");
  if (queryStringIndex === -1) {
    return url + fragment;
  }
  const query = (0, import_get_query_args.getQueryArgs)(url);
  const baseURL = url.substr(0, queryStringIndex);
  args.forEach((arg) => delete query[arg]);
  const queryString = (0, import_build_query_string.buildQueryString)(query);
  const updatedUrl = queryString ? baseURL + "?" + queryString : baseURL;
  return updatedUrl + fragment;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=remove-query-args.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/safe-decode-uri-component.js":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/safe-decode-uri-component.js ***!
  \**********************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/safe-decode-uri-component.ts
var safe_decode_uri_component_exports = {};
__export(safe_decode_uri_component_exports, {
  safeDecodeURIComponent: () => safeDecodeURIComponent
});
module.exports = __toCommonJS(safe_decode_uri_component_exports);
function safeDecodeURIComponent(uriComponent) {
  try {
    return decodeURIComponent(uriComponent);
  } catch (uriComponentError) {
    return uriComponent;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=safe-decode-uri-component.js.map


/***/ }),

/***/ "./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/safe-decode-uri.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@wordpress/api-fetch/node_modules/@wordpress/url/build/safe-decode-uri.js ***!
  \************************************************************************************************/
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/url/src/safe-decode-uri.ts
var safe_decode_uri_exports = {};
__export(safe_decode_uri_exports, {
  safeDecodeURI: () => safeDecodeURI
});
module.exports = __toCommonJS(safe_decode_uri_exports);
function safeDecodeURI(uri) {
  try {
    return decodeURI(uri);
  } catch (uriError) {
    return uri;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);
//# sourceMappingURL=safe-decode-uri.js.map


/***/ }),

/***/ "./node_modules/@wordpress/url/build-module/normalize-path.js":
/*!********************************************************************!*\
  !*** ./node_modules/@wordpress/url/build-module/normalize-path.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizePath: () => (/* binding */ normalizePath)
/* harmony export */ });
/**
 * Given a path, returns a normalized path where equal query parameter values
 * will be treated as identical, regardless of order they appear in the original
 * text.
 *
 * @param {string} path Original path.
 *
 * @return {string} Normalized path.
 */
function normalizePath(path) {
  const splitted = path.split('?');
  const query = splitted[1];
  const base = splitted[0];
  if (!query) {
    return base;
  }

  // 'b=1%2C2&c=2&a=5'
  return base + '?' + query
  // [ 'b=1%2C2', 'c=2', 'a=5' ]
  .split('&')
  // [ [ 'b, '1%2C2' ], [ 'c', '2' ], [ 'a', '5' ] ]
  .map(entry => entry.split('='))
  // [ [ 'b', '1,2' ], [ 'c', '2' ], [ 'a', '5' ] ]
  .map(pair => pair.map(decodeURIComponent))
  // [ [ 'a', '5' ], [ 'b, '1,2' ], [ 'c', '2' ] ]
  .sort((a, b) => a[0].localeCompare(b[0]))
  // [ [ 'a', '5' ], [ 'b, '1%2C2' ], [ 'c', '2' ] ]
  .map(pair => pair.map(encodeURIComponent))
  // [ 'a=5', 'b=1%2C2', 'c=2' ]
  .map(pair => pair.join('='))
  // 'a=5&b=1%2C2&c=2'
  .join('&');
}
//# sourceMappingURL=normalize-path.js.map

/***/ }),

/***/ "./node_modules/equivalent-key-map/equivalent-key-map.js":
/*!***************************************************************!*\
  !*** ./node_modules/equivalent-key-map/equivalent-key-map.js ***!
  \***************************************************************/
/***/ ((module) => {

"use strict";


function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

/**
 * Given an instance of EquivalentKeyMap, returns its internal value pair tuple
 * for a key, if one exists. The tuple members consist of the last reference
 * value for the key (used in efficient subsequent lookups) and the value
 * assigned for the key at the leaf node.
 *
 * @param {EquivalentKeyMap} instance EquivalentKeyMap instance.
 * @param {*} key                     The key for which to return value pair.
 *
 * @return {?Array} Value pair, if exists.
 */
function getValuePair(instance, key) {
  var _map = instance._map,
      _arrayTreeMap = instance._arrayTreeMap,
      _objectTreeMap = instance._objectTreeMap; // Map keeps a reference to the last object-like key used to set the
  // value, which can be used to shortcut immediately to the value.

  if (_map.has(key)) {
    return _map.get(key);
  } // Sort keys to ensure stable retrieval from tree.


  var properties = Object.keys(key).sort(); // Tree by type to avoid conflicts on numeric object keys, empty value.

  var map = Array.isArray(key) ? _arrayTreeMap : _objectTreeMap;

  for (var i = 0; i < properties.length; i++) {
    var property = properties[i];
    map = map.get(property);

    if (map === undefined) {
      return;
    }

    var propertyValue = key[property];
    map = map.get(propertyValue);

    if (map === undefined) {
      return;
    }
  }

  var valuePair = map.get('_ekm_value');

  if (!valuePair) {
    return;
  } // If reached, it implies that an object-like key was set with another
  // reference, so delete the reference and replace with the current.


  _map.delete(valuePair[0]);

  valuePair[0] = key;
  map.set('_ekm_value', valuePair);

  _map.set(key, valuePair);

  return valuePair;
}
/**
 * Variant of a Map object which enables lookup by equivalent (deeply equal)
 * object and array keys.
 */


var EquivalentKeyMap =
/*#__PURE__*/
function () {
  /**
   * Constructs a new instance of EquivalentKeyMap.
   *
   * @param {Iterable.<*>} iterable Initial pair of key, value for map.
   */
  function EquivalentKeyMap(iterable) {
    _classCallCheck(this, EquivalentKeyMap);

    this.clear();

    if (iterable instanceof EquivalentKeyMap) {
      // Map#forEach is only means of iterating with support for IE11.
      var iterablePairs = [];
      iterable.forEach(function (value, key) {
        iterablePairs.push([key, value]);
      });
      iterable = iterablePairs;
    }

    if (iterable != null) {
      for (var i = 0; i < iterable.length; i++) {
        this.set(iterable[i][0], iterable[i][1]);
      }
    }
  }
  /**
   * Accessor property returning the number of elements.
   *
   * @return {number} Number of elements.
   */


  _createClass(EquivalentKeyMap, [{
    key: "set",

    /**
     * Add or update an element with a specified key and value.
     *
     * @param {*} key   The key of the element to add.
     * @param {*} value The value of the element to add.
     *
     * @return {EquivalentKeyMap} Map instance.
     */
    value: function set(key, value) {
      // Shortcut non-object-like to set on internal Map.
      if (key === null || _typeof(key) !== 'object') {
        this._map.set(key, value);

        return this;
      } // Sort keys to ensure stable assignment into tree.


      var properties = Object.keys(key).sort();
      var valuePair = [key, value]; // Tree by type to avoid conflicts on numeric object keys, empty value.

      var map = Array.isArray(key) ? this._arrayTreeMap : this._objectTreeMap;

      for (var i = 0; i < properties.length; i++) {
        var property = properties[i];

        if (!map.has(property)) {
          map.set(property, new EquivalentKeyMap());
        }

        map = map.get(property);
        var propertyValue = key[property];

        if (!map.has(propertyValue)) {
          map.set(propertyValue, new EquivalentKeyMap());
        }

        map = map.get(propertyValue);
      } // If an _ekm_value exists, there was already an equivalent key. Before
      // overriding, ensure that the old key reference is removed from map to
      // avoid memory leak of accumulating equivalent keys. This is, in a
      // sense, a poor man's WeakMap, while still enabling iterability.


      var previousValuePair = map.get('_ekm_value');

      if (previousValuePair) {
        this._map.delete(previousValuePair[0]);
      }

      map.set('_ekm_value', valuePair);

      this._map.set(key, valuePair);

      return this;
    }
    /**
     * Returns a specified element.
     *
     * @param {*} key The key of the element to return.
     *
     * @return {?*} The element associated with the specified key or undefined
     *              if the key can't be found.
     */

  }, {
    key: "get",
    value: function get(key) {
      // Shortcut non-object-like to get from internal Map.
      if (key === null || _typeof(key) !== 'object') {
        return this._map.get(key);
      }

      var valuePair = getValuePair(this, key);

      if (valuePair) {
        return valuePair[1];
      }
    }
    /**
     * Returns a boolean indicating whether an element with the specified key
     * exists or not.
     *
     * @param {*} key The key of the element to test for presence.
     *
     * @return {boolean} Whether an element with the specified key exists.
     */

  }, {
    key: "has",
    value: function has(key) {
      if (key === null || _typeof(key) !== 'object') {
        return this._map.has(key);
      } // Test on the _presence_ of the pair, not its value, as even undefined
      // can be a valid member value for a key.


      return getValuePair(this, key) !== undefined;
    }
    /**
     * Removes the specified element.
     *
     * @param {*} key The key of the element to remove.
     *
     * @return {boolean} Returns true if an element existed and has been
     *                   removed, or false if the element does not exist.
     */

  }, {
    key: "delete",
    value: function _delete(key) {
      if (!this.has(key)) {
        return false;
      } // This naive implementation will leave orphaned child trees. A better
      // implementation should traverse and remove orphans.


      this.set(key, undefined);
      return true;
    }
    /**
     * Executes a provided function once per each key/value pair, in insertion
     * order.
     *
     * @param {Function} callback Function to execute for each element.
     * @param {*}        thisArg  Value to use as `this` when executing
     *                            `callback`.
     */

  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _this = this;

      var thisArg = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this;

      this._map.forEach(function (value, key) {
        // Unwrap value from object-like value pair.
        if (key !== null && _typeof(key) === 'object') {
          value = value[1];
        }

        callback.call(thisArg, value, key, _this);
      });
    }
    /**
     * Removes all elements.
     */

  }, {
    key: "clear",
    value: function clear() {
      this._map = new Map();
      this._arrayTreeMap = new Map();
      this._objectTreeMap = new Map();
    }
  }, {
    key: "size",
    get: function get() {
      return this._map.size;
    }
  }]);

  return EquivalentKeyMap;
}();

module.exports = EquivalentKeyMap;


/***/ }),

/***/ "./node_modules/remove-accents/index.js":
/*!**********************************************!*\
  !*** ./node_modules/remove-accents/index.js ***!
  \**********************************************/
/***/ ((module) => {

var characterMap = {
	"À": "A",
	"Á": "A",
	"Â": "A",
	"Ã": "A",
	"Ä": "A",
	"Å": "A",
	"Ấ": "A",
	"Ắ": "A",
	"Ẳ": "A",
	"Ẵ": "A",
	"Ặ": "A",
	"Æ": "AE",
	"Ầ": "A",
	"Ằ": "A",
	"Ȃ": "A",
	"Ả": "A",
	"Ạ": "A",
	"Ẩ": "A",
	"Ẫ": "A",
	"Ậ": "A",
	"Ç": "C",
	"Ḉ": "C",
	"È": "E",
	"É": "E",
	"Ê": "E",
	"Ë": "E",
	"Ế": "E",
	"Ḗ": "E",
	"Ề": "E",
	"Ḕ": "E",
	"Ḝ": "E",
	"Ȇ": "E",
	"Ẻ": "E",
	"Ẽ": "E",
	"Ẹ": "E",
	"Ể": "E",
	"Ễ": "E",
	"Ệ": "E",
	"Ì": "I",
	"Í": "I",
	"Î": "I",
	"Ï": "I",
	"Ḯ": "I",
	"Ȋ": "I",
	"Ỉ": "I",
	"Ị": "I",
	"Ð": "D",
	"Ñ": "N",
	"Ò": "O",
	"Ó": "O",
	"Ô": "O",
	"Õ": "O",
	"Ö": "O",
	"Ø": "O",
	"Ố": "O",
	"Ṍ": "O",
	"Ṓ": "O",
	"Ȏ": "O",
	"Ỏ": "O",
	"Ọ": "O",
	"Ổ": "O",
	"Ỗ": "O",
	"Ộ": "O",
	"Ờ": "O",
	"Ở": "O",
	"Ỡ": "O",
	"Ớ": "O",
	"Ợ": "O",
	"Ù": "U",
	"Ú": "U",
	"Û": "U",
	"Ü": "U",
	"Ủ": "U",
	"Ụ": "U",
	"Ử": "U",
	"Ữ": "U",
	"Ự": "U",
	"Ý": "Y",
	"à": "a",
	"á": "a",
	"â": "a",
	"ã": "a",
	"ä": "a",
	"å": "a",
	"ấ": "a",
	"ắ": "a",
	"ẳ": "a",
	"ẵ": "a",
	"ặ": "a",
	"æ": "ae",
	"ầ": "a",
	"ằ": "a",
	"ȃ": "a",
	"ả": "a",
	"ạ": "a",
	"ẩ": "a",
	"ẫ": "a",
	"ậ": "a",
	"ç": "c",
	"ḉ": "c",
	"è": "e",
	"é": "e",
	"ê": "e",
	"ë": "e",
	"ế": "e",
	"ḗ": "e",
	"ề": "e",
	"ḕ": "e",
	"ḝ": "e",
	"ȇ": "e",
	"ẻ": "e",
	"ẽ": "e",
	"ẹ": "e",
	"ể": "e",
	"ễ": "e",
	"ệ": "e",
	"ì": "i",
	"í": "i",
	"î": "i",
	"ï": "i",
	"ḯ": "i",
	"ȋ": "i",
	"ỉ": "i",
	"ị": "i",
	"ð": "d",
	"ñ": "n",
	"ò": "o",
	"ó": "o",
	"ô": "o",
	"õ": "o",
	"ö": "o",
	"ø": "o",
	"ố": "o",
	"ṍ": "o",
	"ṓ": "o",
	"ȏ": "o",
	"ỏ": "o",
	"ọ": "o",
	"ổ": "o",
	"ỗ": "o",
	"ộ": "o",
	"ờ": "o",
	"ở": "o",
	"ỡ": "o",
	"ớ": "o",
	"ợ": "o",
	"ù": "u",
	"ú": "u",
	"û": "u",
	"ü": "u",
	"ủ": "u",
	"ụ": "u",
	"ử": "u",
	"ữ": "u",
	"ự": "u",
	"ý": "y",
	"ÿ": "y",
	"Ā": "A",
	"ā": "a",
	"Ă": "A",
	"ă": "a",
	"Ą": "A",
	"ą": "a",
	"Ć": "C",
	"ć": "c",
	"Ĉ": "C",
	"ĉ": "c",
	"Ċ": "C",
	"ċ": "c",
	"Č": "C",
	"č": "c",
	"C̆": "C",
	"c̆": "c",
	"Ď": "D",
	"ď": "d",
	"Đ": "D",
	"đ": "d",
	"Ē": "E",
	"ē": "e",
	"Ĕ": "E",
	"ĕ": "e",
	"Ė": "E",
	"ė": "e",
	"Ę": "E",
	"ę": "e",
	"Ě": "E",
	"ě": "e",
	"Ĝ": "G",
	"Ǵ": "G",
	"ĝ": "g",
	"ǵ": "g",
	"Ğ": "G",
	"ğ": "g",
	"Ġ": "G",
	"ġ": "g",
	"Ģ": "G",
	"ģ": "g",
	"Ĥ": "H",
	"ĥ": "h",
	"Ħ": "H",
	"ħ": "h",
	"Ḫ": "H",
	"ḫ": "h",
	"Ĩ": "I",
	"ĩ": "i",
	"Ī": "I",
	"ī": "i",
	"Ĭ": "I",
	"ĭ": "i",
	"Į": "I",
	"į": "i",
	"İ": "I",
	"ı": "i",
	"Ĳ": "IJ",
	"ĳ": "ij",
	"Ĵ": "J",
	"ĵ": "j",
	"Ķ": "K",
	"ķ": "k",
	"Ḱ": "K",
	"ḱ": "k",
	"K̆": "K",
	"k̆": "k",
	"Ĺ": "L",
	"ĺ": "l",
	"Ļ": "L",
	"ļ": "l",
	"Ľ": "L",
	"ľ": "l",
	"Ŀ": "L",
	"ŀ": "l",
	"Ł": "l",
	"ł": "l",
	"Ḿ": "M",
	"ḿ": "m",
	"M̆": "M",
	"m̆": "m",
	"Ń": "N",
	"ń": "n",
	"Ņ": "N",
	"ņ": "n",
	"Ň": "N",
	"ň": "n",
	"ŉ": "n",
	"N̆": "N",
	"n̆": "n",
	"Ō": "O",
	"ō": "o",
	"Ŏ": "O",
	"ŏ": "o",
	"Ő": "O",
	"ő": "o",
	"Œ": "OE",
	"œ": "oe",
	"P̆": "P",
	"p̆": "p",
	"Ŕ": "R",
	"ŕ": "r",
	"Ŗ": "R",
	"ŗ": "r",
	"Ř": "R",
	"ř": "r",
	"R̆": "R",
	"r̆": "r",
	"Ȓ": "R",
	"ȓ": "r",
	"Ś": "S",
	"ś": "s",
	"Ŝ": "S",
	"ŝ": "s",
	"Ş": "S",
	"Ș": "S",
	"ș": "s",
	"ş": "s",
	"Š": "S",
	"š": "s",
	"Ţ": "T",
	"ţ": "t",
	"ț": "t",
	"Ț": "T",
	"Ť": "T",
	"ť": "t",
	"Ŧ": "T",
	"ŧ": "t",
	"T̆": "T",
	"t̆": "t",
	"Ũ": "U",
	"ũ": "u",
	"Ū": "U",
	"ū": "u",
	"Ŭ": "U",
	"ŭ": "u",
	"Ů": "U",
	"ů": "u",
	"Ű": "U",
	"ű": "u",
	"Ų": "U",
	"ų": "u",
	"Ȗ": "U",
	"ȗ": "u",
	"V̆": "V",
	"v̆": "v",
	"Ŵ": "W",
	"ŵ": "w",
	"Ẃ": "W",
	"ẃ": "w",
	"X̆": "X",
	"x̆": "x",
	"Ŷ": "Y",
	"ŷ": "y",
	"Ÿ": "Y",
	"Y̆": "Y",
	"y̆": "y",
	"Ź": "Z",
	"ź": "z",
	"Ż": "Z",
	"ż": "z",
	"Ž": "Z",
	"ž": "z",
	"ſ": "s",
	"ƒ": "f",
	"Ơ": "O",
	"ơ": "o",
	"Ư": "U",
	"ư": "u",
	"Ǎ": "A",
	"ǎ": "a",
	"Ǐ": "I",
	"ǐ": "i",
	"Ǒ": "O",
	"ǒ": "o",
	"Ǔ": "U",
	"ǔ": "u",
	"Ǖ": "U",
	"ǖ": "u",
	"Ǘ": "U",
	"ǘ": "u",
	"Ǚ": "U",
	"ǚ": "u",
	"Ǜ": "U",
	"ǜ": "u",
	"Ứ": "U",
	"ứ": "u",
	"Ṹ": "U",
	"ṹ": "u",
	"Ǻ": "A",
	"ǻ": "a",
	"Ǽ": "AE",
	"ǽ": "ae",
	"Ǿ": "O",
	"ǿ": "o",
	"Þ": "TH",
	"þ": "th",
	"Ṕ": "P",
	"ṕ": "p",
	"Ṥ": "S",
	"ṥ": "s",
	"X́": "X",
	"x́": "x",
	"Ѓ": "Г",
	"ѓ": "г",
	"Ќ": "К",
	"ќ": "к",
	"A̋": "A",
	"a̋": "a",
	"E̋": "E",
	"e̋": "e",
	"I̋": "I",
	"i̋": "i",
	"Ǹ": "N",
	"ǹ": "n",
	"Ồ": "O",
	"ồ": "o",
	"Ṑ": "O",
	"ṑ": "o",
	"Ừ": "U",
	"ừ": "u",
	"Ẁ": "W",
	"ẁ": "w",
	"Ỳ": "Y",
	"ỳ": "y",
	"Ȁ": "A",
	"ȁ": "a",
	"Ȅ": "E",
	"ȅ": "e",
	"Ȉ": "I",
	"ȉ": "i",
	"Ȍ": "O",
	"ȍ": "o",
	"Ȑ": "R",
	"ȑ": "r",
	"Ȕ": "U",
	"ȕ": "u",
	"B̌": "B",
	"b̌": "b",
	"Č̣": "C",
	"č̣": "c",
	"Ê̌": "E",
	"ê̌": "e",
	"F̌": "F",
	"f̌": "f",
	"Ǧ": "G",
	"ǧ": "g",
	"Ȟ": "H",
	"ȟ": "h",
	"J̌": "J",
	"ǰ": "j",
	"Ǩ": "K",
	"ǩ": "k",
	"M̌": "M",
	"m̌": "m",
	"P̌": "P",
	"p̌": "p",
	"Q̌": "Q",
	"q̌": "q",
	"Ř̩": "R",
	"ř̩": "r",
	"Ṧ": "S",
	"ṧ": "s",
	"V̌": "V",
	"v̌": "v",
	"W̌": "W",
	"w̌": "w",
	"X̌": "X",
	"x̌": "x",
	"Y̌": "Y",
	"y̌": "y",
	"A̧": "A",
	"a̧": "a",
	"B̧": "B",
	"b̧": "b",
	"Ḑ": "D",
	"ḑ": "d",
	"Ȩ": "E",
	"ȩ": "e",
	"Ɛ̧": "E",
	"ɛ̧": "e",
	"Ḩ": "H",
	"ḩ": "h",
	"I̧": "I",
	"i̧": "i",
	"Ɨ̧": "I",
	"ɨ̧": "i",
	"M̧": "M",
	"m̧": "m",
	"O̧": "O",
	"o̧": "o",
	"Q̧": "Q",
	"q̧": "q",
	"U̧": "U",
	"u̧": "u",
	"X̧": "X",
	"x̧": "x",
	"Z̧": "Z",
	"z̧": "z",
	"й":"и",
	"Й":"И",
	"ё":"е",
	"Ё":"Е",
};

var chars = Object.keys(characterMap).join('|');
var allAccents = new RegExp(chars, 'g');
var firstAccent = new RegExp(chars, '');

function matcher(match) {
	return characterMap[match];
}

var removeAccents = function(string) {
	return string.replace(allAccents, matcher);
};

var hasAccents = function(string) {
	return !!string.match(firstAccent);
};

module.exports = removeAccents;
module.exports.has = hasAccents;
module.exports.remove = removeAccents;


/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

"use strict";
module.exports = googlesitekit.i18n;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!*******************************************!*\
  !*** ./tests/e2e/assets/e2e-api-fetch.js ***!
  \*******************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/api-fetch */ "./assets/js/api-fetch-shim.js");
/**
 * E2E API Fetch.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

if (__webpack_require__.g._e2eApiFetch === undefined) {
  __webpack_require__.g._e2eApiFetch = _wordpress_api_fetch__WEBPACK_IMPORTED_MODULE_0__["default"];
}
})();

/******/ })()
;
//# sourceMappingURL=e2e-api-fetch.js.map