"use strict";
(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-notifications"],{

/***/ "./js/components/AdminScreenTooltip/AdminScreenTooltip.js":
/*!****************************************************************!*\
  !*** ./js/components/AdminScreenTooltip/AdminScreenTooltip.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminScreenTooltip: () => (/* binding */ AdminScreenTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/JoyrideTooltip */ "./js/components/JoyrideTooltip.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AdminMenuTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function AdminScreenTooltip() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.useBreakpoint)();
  const {
    isTooltipVisible = false,
    target,
    placement,
    className,
    tooltipSlug,
    title,
    content,
    dismissLabel
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue('admin-screen-tooltip') || {
    isTooltipVisible: false
  });
  function handleViewTooltip() {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_view');
  }
  const handleDismissTooltip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    // Track dismiss event.
    if (tooltipSlug) {
      (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_${tooltipSlug}`, 'tooltip_dismiss');
    }
    setValue('admin-screen-tooltip', undefined);
  }, [setValue, tooltipSlug, viewContext]);
  if (!isTooltipVisible) {
    return null;
  }
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_3__.BREAKPOINT_TABLET;
  const desktopTarget = target !== null && target !== void 0 ? target : '#adminmenu [href*="page=googlesitekit-settings"]';
  const desktopPlacement = placement !== null && placement !== void 0 ? placement : 'right';
  function desktopClassName() {
    if (className) {
      return className;
    }
    return !target ? 'googlesitekit-tour-tooltip__fixed-settings-tooltip' : undefined;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_JoyrideTooltip__WEBPACK_IMPORTED_MODULE_1__["default"], {
    target: isMobileTablet ? 'body' : desktopTarget,
    placement: isMobileTablet ? 'center' : desktopPlacement,
    className: isMobileTablet ? 'googlesitekit-tour-tooltip__modal_step' : desktopClassName(),
    disableOverlay: !isMobileTablet,
    slug: "admin-screen-tooltip",
    title: title,
    content: content,
    dismissLabel: dismissLabel,
    onView: handleViewTooltip,
    onDismiss: handleDismissTooltip
  });
}

/***/ }),

/***/ "./js/components/AdminScreenTooltip/index.js":
/*!***************************************************!*\
  !*** ./js/components/AdminScreenTooltip/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdminScreenTooltip: () => (/* reexport safe */ _AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_1__.AdminScreenTooltip),
/* harmony export */   useShowTooltip: () => (/* reexport safe */ _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__.useShowTooltip)
/* harmony export */ });
/* harmony import */ var _useShowTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useShowTooltip */ "./js/components/AdminScreenTooltip/useShowTooltip.js");
/* harmony import */ var _AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AdminScreenTooltip */ "./js/components/AdminScreenTooltip/AdminScreenTooltip.js");



/***/ }),

/***/ "./js/components/AdminScreenTooltip/useShowTooltip.js":
/*!************************************************************!*\
  !*** ./js/components/AdminScreenTooltip/useShowTooltip.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useShowTooltip: () => (/* binding */ useShowTooltip)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useShowTooltip(tooltipSettings) {
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_UI);
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)(() => {
    setValue('admin-screen-tooltip', {
      isTooltipVisible: true,
      ...tooltipSettings
    });
  }, [setValue, tooltipSettings]);
}

/***/ }),

/***/ "./js/components/Badge.js":
/*!********************************!*\
  !*** ./js/components/Badge.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Badge component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Badge = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  label,
  className,
  hasLeftSpacing = false,
  ...rest
}, ref) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
  ref: ref,
  ...rest,
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge', className, {
    'googlesitekit-badge--has-left-spacing': hasLeftSpacing
  }),
  children: label
}));
Badge.displayName = 'Badge';
Badge.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);

/***/ }),

/***/ "./js/components/Banner/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton({
  label,
  ariaLabel,
  disabled,
  inProgress,
  onClick,
  href,
  external = false,
  hideExternalIndicator = false
}) {
  if (!label || !onClick && !href) {
    return null;
  }
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-banner__cta",
    "aria-label": ariaLabel,
    disabled: disabled || inProgress,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : undefined,
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ariaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  dismissOnClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Banner/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Description({
  className,
  description,
  learnMoreLink,
  additionalDescription,
  children
}) {
  function renderDescription() {
    if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.isValidElement)(description)) {
      return description;
    }
    if ('string' === typeof description) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.sanitizeHTML)(description, {
          ALLOWED_TAGS: ['strong', 'em', 'br', 'a'],
          ALLOWED_ATTR: ['href']
        })
      });
    }
    return description;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__description', className),
    children: [renderDescription(), ' ', learnMoreLink?.href && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...learnMoreLink
    }), additionalDescription && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-banner__additional-description",
      children: additionalDescription
    }), children]
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"].propTypes),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};

/***/ }),

/***/ "./js/components/Banner/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled,
  tertiary = true
}) {
  if (!onClick) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: className,
    onClick: onClick,
    disabled: disabled,
    tertiary: tertiary,
    children: label
  });
}
DismissButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Footer.js":
/*!****************************************!*\
  !*** ./js/components/Banner/Footer.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Footer({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__footer', className),
    children: children
  });
}
Footer.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/HelpText.js":
/*!******************************************!*\
  !*** ./js/components/Banner/HelpText.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HelpText)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function HelpText({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__help-text', className),
    children: children
  });
}
HelpText.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/LearnMoreLink.tsx":
/*!************************************************!*\
  !*** ./js/components/Banner/LearnMoreLink.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* provided dependency */ var React = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/index.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

/**
 * Renders a "Learn More" link component, usually used to append "Learn more" with a
 * specified URL to content like a paragraph.
 *
 * @since 1.153.0
 *
 * @param props            The props for the component.
 * @param props.className  The class name for the link.
 * @param [props.external] Whether the link is external. Optional, defaults to true.
 * @param props.href       The URL for the link.
 * @param props.label      The label for the link.
 * @param [props.onClick]  The function to call when the link is clicked. Optional, defaults to an empty function.
 * @return The rendered component.
 */
const LearnMoreLink = ({
  className,
  external = true,
  href,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
  onClick = () => {}
}) => {
  // Return null if no href is provided.
  //
  // This arguably shouldn't be optional, but until all usage of this
  // component are via typed code, we need this safeguard.
  if (!href) {
    return null;
  }
  return (
    /*#__PURE__*/
    // @ts-expect-error `Link` component is not currently typed, so this
    // results in an error because we're supplying a `children` prop.
    React.createElement(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      href: href,
      className: className,
      onClick: onClick,
      external: external
    }, label)
  );
};
LearnMoreLink.propTypes = {
  href: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LearnMoreLink);

/***/ }),

/***/ "./js/components/Banner/Title.js":
/*!***************************************!*\
  !*** ./js/components/Banner/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/TitleIcon.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/TitleIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TitleIcon)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function TitleIcon({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title-icon', className),
    children: children
  });
}
TitleIcon.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/index.js":
/*!***************************************!*\
  !*** ./js/components/Banner/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Description */ "./js/components/Banner/Description.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Footer */ "./js/components/Banner/Footer.js");
/* harmony import */ var _HelpText__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./HelpText */ "./js/components/Banner/HelpText.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Title */ "./js/components/Banner/Title.js");
/* harmony import */ var _TitleIcon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./TitleIcon */ "./js/components/Banner/TitleIcon.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











const Banner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.forwardRef)(({
  className,
  titleIcon,
  title,
  description,
  additionalDescription,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  // NOTE: SVGs must be imported with the ?url suffix for use as a backgroundImage in this component.
  footer
}, ref) => {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.useBreakpoint)();
  const isMobileOrTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.BREAKPOINT_TABLET;
  let SVGData = null;
  if (isMobileOrTablet && svg?.mobile) {
    SVGData = svg.mobile;
  } else if (!isMobileOrTablet && svg?.desktop) {
    SVGData = svg.desktop;
  }
  const svgMode = svg?.verticalPosition ? svg.verticalPosition : 'center';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-banner__content",
      children: [titleIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_TitleIcon__WEBPACK_IMPORTED_MODULE_10__["default"], {
        children: titleIcon
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_9__["default"], {
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_4__["default"], {
        description: description,
        learnMoreLink: learnMoreLink,
        additionalDescription: additionalDescription
      }), helpText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpText__WEBPACK_IMPORTED_MODULE_7__["default"], {
        children: helpText
      }), errorText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_1__["default"], {
        type: "error",
        description: errorText
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-notice__action",
        children: [ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_3__["default"], {
          ...ctaButton
        }), dismissButton?.onClick && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
          ...dismissButton
        })]
      })]
    }), SVGData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__svg-wrapper', {
        [`googlesitekit-banner__svg-wrapper--${svgMode}`]: svgMode
      }),
      style: {
        backgroundImage: `url(${SVGData})`
      }
    }), footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: footer
    })]
  });
});
Banner.propTypes = {
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_8__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_CTAButton__WEBPACK_IMPORTED_MODULE_3__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Banner);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/ErrorNotice.js":
/*!**************************************!*\
  !*** ./js/components/ErrorNotice.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorNotice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ErrorNotice({
  className,
  error,
  hasButton = false,
  storeName,
  message = error.message,
  noPrefix = false,
  skipRetryMessage,
  hideIcon = false
}) {
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const selectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!storeName) {
      return null;
    }
    return select(storeName).getSelectorDataForError(error);
  });
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
  }, [dispatch, selectorData]);

  // Do not display if there is no error and no direct message text is passed as a direct prop.
  // Also do not display if the error is for missing scopes as these are handled by a popup modal.
  if (!message || (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_3__.isPermissionScopeError)(error)) {
    return null;
  }
  const shouldDisplayRetry = hasButton && (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_3__.isErrorRetryable)(error, selectorData);

  /**
   * Error message to display to the user. Sometimes we append a retry message
   * or a reconnect URL, so we create a new variable for the message to display.
   */
  let errorMessageWithModifications = message;

  // Append "Try again" messaging if no retry button is present.
  if (!hasButton && !skipRetryMessage) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message from Google API. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s (Please try again.)', 'google-site-kit'), errorMessageWithModifications);
  }
  if (!noPrefix) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: $%s: Error message */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), errorMessageWithModifications);
  }
  const reconnectURL = error?.data?.reconnectURL;
  if (reconnectURL && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.isURL)(reconnectURL)) {
    /**
     * This error message uses HTML tags without using
     * `createInterpolateElement` because the error messages
     * that come from the server/API can also contain HTML (eg. links)
     * we want to render.
     *
     * Instead of creating a React node using `createInterpolateElement`,
     * we use `dangerouslySetInnerHTML` to allow the HTML we create and from
     * the server/API to be rendered as-intended.
     */
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Original error message 2: Reconnect URL */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s To fix this, <a href="%2$s">redo the plugin setup</a>.', 'google-site-kit'), errorMessageWithModifications, reconnectURL);
  }
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a'],
    ALLOWED_ATTR: ['href']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_4__["default"], {
    className: className,
    type: _Notice__WEBPACK_IMPORTED_MODULE_4__["default"].TYPES.ERROR,
    description:
    /*#__PURE__*/
    // The error messages that come from the server/API can contain
    // HTML (eg. links), so we use `dangerouslySetInnerHTML` and sanitize
    // the HTML to render these links.
    //
    // We tried to use `createInterpolateElement` but it does not work
    // with HTML tags that come from the server/API.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML)(errorMessageWithModifications, sanitizeArgs)
    }),
    ctaButton: shouldDisplayRetry ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit'),
      onClick: handleRetry
    } : undefined,
    hideIcon: hideIcon
  });
}
ErrorNotice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  error: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }),
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/JoyrideTooltip.js":
/*!*****************************************!*\
  !*** ./js/components/JoyrideTooltip.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ JoyrideTooltip)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useInterval.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _Portal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Portal */ "./js/components/Portal.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var _TourTooltips__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TourTooltips */ "./js/components/TourTooltips.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * JoyRideTooltip component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function JoyrideTooltip(props) {
  const {
    title,
    content,
    dismissLabel,
    disableOverlay = true,
    target,
    cta = false,
    className,
    styles = {},
    slug = '',
    placement = 'auto',
    onDismiss = () => {},
    onView = () => {},
    onTourStart = () => {},
    onTourEnd = () => {}
  } = props;
  function checkIfTargetExists() {
    return !!__webpack_require__.g.document.querySelector(target);
  }
  const [targetExists, setTargetExists] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(checkIfTargetExists);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.useBreakpoint)();
  const isMobileTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_0__.BREAKPOINT_TABLET;
  const [shouldRun, setShouldRun] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useState)(true);
  const previousIsMobileTabletRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useRef)(isMobileTablet);
  (0,react_use__WEBPACK_IMPORTED_MODULE_6__["default"])(() => {
    if (checkIfTargetExists()) {
      setTargetExists(true);
    }
  },
  // An delay of null will stop the interval.
  targetExists ? null : 250);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    // eslint-disable-next-line sitekit/function-declaration-consistency
    let disconnect = () => {};
    if (typeof __webpack_require__.g.ResizeObserver === 'function') {
      const targetElement = __webpack_require__.g.document.querySelector(target);
      if (targetElement) {
        const resizeObserver = new ResizeObserver(() => {
          // Dispatch a window resize event to trigger the tooltip to reposition.
          __webpack_require__.g.dispatchEvent(new Event('resize'));
        });
        resizeObserver.observe(targetElement);
        disconnect = () => resizeObserver.disconnect();
      }
    }
    return disconnect;
  }, [target, targetExists]);

  // Reset the component between mobile and desktop layouts they use different
  // targets which requires the tooltip to be re-rendered to display correctly.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    let timeoutID;
    if (previousIsMobileTabletRef.current !== isMobileTablet) {
      setShouldRun(false);
      timeoutID = setTimeout(() => {
        setShouldRun(true);
      }, 50);
      previousIsMobileTabletRef.current = isMobileTablet;
    }
    return () => {
      if (timeoutID) {
        clearTimeout(timeoutID);
      }
    };
  }, [isMobileTablet]);

  // Joyride expects the step's target to be in the DOM immediately
  // so we need to wait for it in some cases, e.g. loading data.
  if (!targetExists) {
    return null;
  }
  const steps = [{
    title,
    target,
    content,
    disableBeacon: true,
    isFixed: true,
    placement,
    cta,
    className
  }];

  // Provides button content as well as aria-label & title attribute values.
  const joyrideLocale = {
    close: dismissLabel,
    last: dismissLabel
  };
  function callback({
    type
  }) {
    switch (type) {
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_START:
        onTourStart();
        __webpack_require__.g.document.body.classList.add('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOUR_END:
        onTourEnd();
        __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-tooltip');
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.STEP_AFTER:
        // This is not strictly necessary as the tooltip will hide without it,
        // but this allows the consumer of the component to clean up
        // post-dismiss.
        onDismiss();
        break;
      case react_joyride__WEBPACK_IMPORTED_MODULE_7__.EVENTS.TOOLTIP:
        onView();
        break;
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Portal__WEBPACK_IMPORTED_MODULE_1__["default"], {
    slug: slug,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_7__["default"], {
      callback: callback,
      disableOverlay: disableOverlay,
      spotlightPadding: 0,
      floaterProps: _TourTooltips__WEBPACK_IMPORTED_MODULE_3__.floaterProps,
      locale: joyrideLocale,
      steps: steps,
      styles: {
        ..._TourTooltips__WEBPACK_IMPORTED_MODULE_3__.joyrideStyles,
        ...styles,
        options: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_3__.joyrideStyles.options,
          ...styles?.options
        },
        spotlight: {
          ..._TourTooltips__WEBPACK_IMPORTED_MODULE_3__.joyrideStyles.spotlight,
          ...styles?.spotlight
        }
      },
      tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_2__["default"],
      run: shouldRun,
      disableScrolling: true
    })
  });
}
JoyrideTooltip.propTypes = {
  title: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.node,
  content: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  disableOverlay: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.bool,
  dismissLabel: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  target: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string.isRequired,
  onDismiss: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  onShow: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func,
  className: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  styles: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.object,
  slug: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  placement: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.string,
  onView: prop_types__WEBPACK_IMPORTED_MODULE_8__.PropTypes.func
};

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/NewBadge.js":
/*!***********************************!*\
  !*** ./js/components/NewBadge.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Badge__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Badge */ "./js/components/Badge.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * NewBadge component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function NewBadge({
  tooltipTitle,
  learnMoreLink,
  forceOpen,
  hasLeftSpacing,
  hasNoSpacing,
  onLearnMoreClick = () => {}
}) {
  const badgeComponent = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Badge__WEBPACK_IMPORTED_MODULE_3__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-new-badge', {
      'googlesitekit-new-badge--has-no-spacing': hasNoSpacing
    }),
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('New', 'google-site-kit'),
    hasLeftSpacing: hasLeftSpacing
  });
  if (!tooltipTitle) {
    return badgeComponent;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Tooltip, {
    tooltipClassName: "googlesitekit-new-badge__tooltip",
    title: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
      children: [tooltipTitle, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("br", {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
        href: learnMoreLink,
        onClick: onLearnMoreClick,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more', 'google-site-kit')
      })]
    }),
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    open: forceOpen,
    interactive: true,
    children: badgeComponent
  });
}
NewBadge.propTypes = {
  tooltipTitle: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  learnMoreLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  forceOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  onLearnMoreClick: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  hasNoSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NewBadge);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external = false,
  hideExternalIndicator = false
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__cta', {
      'googlesitekit-notice__cta--spinner__running': inProgress
    }),
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : undefined,
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  INFO_ALT: 'info-alt',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
    children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-notice__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_5__["default"], {
        type: type
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__content",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_6__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__action",
      children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        label: dismissButton.label,
        onClick: dismissButton.onClick,
        disabled: dismissButton.disabled
      }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
        label: ctaButton.label,
        onClick: ctaButton.onClick,
        inProgress: ctaButton.inProgress,
        disabled: ctaButton.disabled,
        href: ctaButton.href,
        external: ctaButton.external,
        hideExternalIndicator: ctaButton.hideExternalIndicator
      })]
    })]
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_1__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_2__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/OverlayCard/Body.js":
/*!*******************************************!*\
  !*** ./js/components/OverlayCard/Body.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Body)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_NewBadge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/NewBadge */ "./js/components/NewBadge.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CTAButton */ "./js/components/OverlayCard/CTAButton.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/OverlayCard/Description.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Title */ "./js/components/OverlayCard/Title.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Body component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function Body({
  title,
  description,
  ctaButton,
  dismissButton,
  GraphicDesktop,
  GraphicMobile,
  newBadge
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [breakpoint !== _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL && GraphicDesktop && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      className: "googlesitekit-overlay-card__graphic",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(GraphicDesktop, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-overlay-card__body",
      children: [newBadge && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "googlesitekit-overlay-card__badge",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_NewBadge__WEBPACK_IMPORTED_MODULE_0__["default"], {
          hasNoSpacing: true
        })
      }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_5__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (ctaButton || dismissButton) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-overlay-card__actions",
      children: [dismissButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        ...dismissButton
      }), ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
        ...ctaButton
      })]
    }), breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL && GraphicMobile && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(GraphicMobile, {})]
  });
}
Body.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_4__.buttonProps,
    href: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
    trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().element)
  }),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_4__.buttonProps
  }),
  GraphicDesktop: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().elementType),
  GraphicMobile: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().elementType),
  newBadge: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/OverlayCard/CTAButton.js":
/*!************************************************!*\
  !*** ./js/components/OverlayCard/CTAButton.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard CTAButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton(props) {
  const {
    label,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Button, {
    ...otherProps,
    children: label
  });
}
CTAButton.propTypes = {
  ..._DismissButton__WEBPACK_IMPORTED_MODULE_1__.buttonProps,
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  target: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().object)
};

/***/ }),

/***/ "./js/components/OverlayCard/Description.js":
/*!**************************************************!*\
  !*** ./js/components/OverlayCard/Description.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Description component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function Description({
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
    className: "googlesitekit-overlay-card__description",
    children: children
  });
}
Description.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired
};

/***/ }),

/***/ "./js/components/OverlayCard/DismissButton.js":
/*!****************************************************!*\
  !*** ./js/components/OverlayCard/DismissButton.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   buttonProps: () => (/* binding */ buttonProps),
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard DismissButton component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
const buttonProps = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
DismissButton.propTypes = buttonProps;

/***/ }),

/***/ "./js/components/OverlayCard/Title.js":
/*!********************************************!*\
  !*** ./js/components/OverlayCard/Title.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard Title component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */

/**
 * Internal dependencies
 */


function Title({
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_0__["default"], {
    as: "h3",
    size: "medium",
    type: "title",
    className: "googlesitekit-overlay-card__title",
    children: children
  });
}
Title.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node).isRequired
};

/***/ }),

/***/ "./js/components/OverlayCard/index.js":
/*!********************************************!*\
  !*** ./js/components/OverlayCard/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OverlayCard)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/Slide/Slide.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _Body__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Body */ "./js/components/OverlayCard/Body.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DismissButton */ "./js/components/OverlayCard/DismissButton.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayCard component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * Internal dependencies
 */




function OverlayCard(props) {
  const {
    visible,
    className,
    ...cardProps
  } = props;
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  if (!visible) {
    return null;
  }
  const body = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-overlay-card', className),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_Body__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...cardProps
    })
  });
  if (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL) {
    return body;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_5__["default"], {
    direction: "up",
    in: visible,
    children: body
  });
}
OverlayCard.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
    ..._DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps,
    href: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    target: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
  }),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_3__.buttonProps),
  GraphicDesktop: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  GraphicMobile: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().elementType),
  newBadge: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  visible: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool)
};
OverlayCard.defaultProps = {
  visible: false
};

/***/ }),

/***/ "./js/components/Portal.js":
/*!*********************************!*\
  !*** ./js/components/Portal.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEffectOnce.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/**
 * Portal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

function Portal({
  children,
  slug
}) {
  // Using state as we need `el` to not change when the component re-renders
  const [el] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(document.createElement('div'));
  (0,react_use__WEBPACK_IMPORTED_MODULE_1__["default"])(() => {
    if (slug) {
      el.classList.add(`googlesitekit-portal-${slug}`);
    }
    const root = document.querySelector('.googlesitekit-plugin') || document.body;
    root.appendChild(el);
    return () => root.removeChild(el);
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createPortal)(children, el);
}
Portal.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Portal.defaultProps = {
  slug: '',
  children: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Portal);

/***/ }),

/***/ "./js/components/PreviewBlock.js":
/*!***************************************!*\
  !*** ./js/components/PreviewBlock.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewBlock component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function PreviewBlock({
  className,
  width,
  height,
  shape,
  padding,
  smallWidth,
  smallHeight,
  tabletWidth,
  tabletHeight,
  desktopWidth,
  desktopHeight
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const blockDimensions = {
    width: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    },
    height: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block', className, {
      'googlesitekit-preview-block--padding': padding
    }),
    style: {
      width: blockDimensions.width[breakpoint] || width,
      height: blockDimensions.height[breakpoint] || height
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block__wrapper', {
        'googlesitekit-preview-block__wrapper--circle': shape === 'circular'
      })
    })
  });
}
PreviewBlock.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  shape: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  padding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  smallWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  smallHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
PreviewBlock.defaultProps = {
  className: undefined,
  width: '100px',
  height: '100px',
  shape: 'square',
  padding: false,
  smallWidth: undefined,
  smallHeight: undefined,
  tabletWidth: undefined,
  tabletHeight: undefined,
  desktopWidth: undefined,
  desktopHeight: undefined
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewBlock);

/***/ }),

/***/ "./js/components/Root/ViewContextContext.js":
/*!**************************************************!*\
  !*** ./js/components/Root/ViewContextContext.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * View Context context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const ViewContextContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)('');
const {
  Consumer,
  Provider
} = ViewContextContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewContextContext);

/***/ }),

/***/ "./js/components/TourTooltip.js":
/*!**************************************!*\
  !*** ./js/components/TourTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TourTooltip)
/* harmony export */ });
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-card */ "../node_modules/@material/react-card/dist/index.js");
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_card__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/create-incremental-array-by-size */ "./js/util/create-incremental-array-by-size.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltip component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function TourTooltip({
  backProps,
  closeProps,
  index,
  primaryProps,
  size,
  step,
  tooltipProps
}) {
  const indicatorArray = size > 1 ? (0,_js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__.createIncrementalArrayBySize)(size) : [];
  function getIndicatorClassName(indicatorIndex) {
    return classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tooltip-indicator', {
      active: indicatorIndex === index
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tour-tooltip', step.className),
    ...tooltipProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)((_material_react_card__WEBPACK_IMPORTED_MODULE_0___default()), {
      className: "googlesitekit-tooltip-card",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-tooltip-body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Typography__WEBPACK_IMPORTED_MODULE_6__["default"], {
          as: "h2",
          className: "googlesitekit-tooltip-title",
          size: "medium",
          type: "title",
          children: step.title
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "googlesitekit-tooltip-content",
          children: step.content
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_material_react_card__WEBPACK_IMPORTED_MODULE_0__.CardActions, {
        className: "googlesitekit-tooltip-actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("ul", {
          className: "googlesitekit-tooltip-indicators",
          children: indicatorArray.map(indicatorIndex => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("li", {
            className: getIndicatorClassName(indicatorIndex)
          }, `indicator-${indicatorIndex}`))
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "googlesitekit-tooltip-buttons",
          children: [index !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...backProps,
            children: backProps.title
          }), step.cta, primaryProps.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...primaryProps,
            children: primaryProps.title
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        className: "googlesitekit-tooltip-close",
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
          width: "14",
          height: "14"
        }),
        onClick: closeProps.onClick,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Close', 'google-site-kit'),
        text: true,
        hideTooltipTitle: true
      })]
    })
  });
}

/**
 * All props are provided directly from `react-joyride`, intended for custom components.
 *
 * @since 1.28.0
 * @see {@link https://docs.react-joyride.com/custom-components#props-1}.
 */
TourTooltip.propTypes = {
  backProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  closeProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  index: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  isLastStep: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool).isRequired,
  primaryProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  size: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  step: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    content: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    cta: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)]),
    className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }).isRequired,
  tooltipProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired
};

/***/ }),

/***/ "./js/components/TourTooltips.js":
/*!***************************************!*\
  !*** ./js/components/TourTooltips.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GA_ACTIONS: () => (/* binding */ GA_ACTIONS),
/* harmony export */   "default": () => (/* binding */ TourTooltips),
/* harmony export */   floaterProps: () => (/* binding */ floaterProps),
/* harmony export */   joyrideStyles: () => (/* binding */ joyrideStyles)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltips component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







/** For available options, see: {@link https://github.com/gilbarbara/react-joyride/blob/3e08384415a831b20ce21c8423b6c271ad419fbf/src/styles.js}. */

const joyrideStyles = {
  options: {
    arrowColor: '#3c7251',
    // $c-content-primary
    backgroundColor: '#3c7251',
    // $c-content-primary
    overlayColor: 'rgba(0, 0, 0, 0.6)',
    textColor: '#fff',
    // $c-content-on-primary
    zIndex: 20000
  },
  spotlight: {
    border: '2px solid #3c7251',
    // $c-content-primary
    backgroundColor: '#fff'
  }
};

// Provides button content as well as aria-label & title attribute values.
const joyrideLocale = {
  back: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back', 'google-site-kit'),
  close: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Close', 'google-site-kit'),
  last: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  next: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Next', 'google-site-kit')
};

/** For available options, see: {@link https://github.com/gilbarbara/react-floater#props}. */
const floaterProps = {
  disableAnimation: true,
  styles: {
    arrow: {
      length: 8,
      margin: 56,
      spread: 16
    },
    floater: {
      filter: 'drop-shadow(rgba(60, 64, 67, 0.3) 0px 1px 2px) drop-shadow(rgba(60, 64, 67, 0.15) 0px 2px 6px)'
    }
  }
};

// GA Event Tracking actions (do not change!)
const GA_ACTIONS = {
  VIEW: 'feature_tooltip_view',
  NEXT: 'feature_tooltip_advance',
  PREV: 'feature_tooltip_return',
  DISMISS: 'feature_tooltip_dismiss',
  COMPLETE: 'feature_tooltip_complete'
};
function TourTooltips({
  steps,
  tourID,
  gaEventCategory,
  isRepeatable,
  callback
}) {
  const stepKey = `${tourID}-step`;
  const runKey = `${tourID}-run`;
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const {
    dismissTour,
    receiveCurrentTour
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const stepIndex = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(stepKey) || 0);
  const run = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(runKey) && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isTourDismissed(tourID) === false;
  });
  function changeStep(index, action) {
    return setValue(stepKey, index + (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV ? -1 : 1));
  }
  function startTour() {
    __webpack_require__.g.document.body.classList.add('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    setValue(runKey, true);
  }
  function endTour() {
    __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    if (isRepeatable) {
      setValue(runKey, false);
      setValue(stepKey, null);
      receiveCurrentTour(null);
    } else {
      // Dismiss tour to avoid unwanted repeat viewing.
      dismissTour(tourID);
    }
  }
  function trackAllTourEvents({
    index,
    action,
    lifecycle,
    size,
    status,
    type
  }) {
    // The index is 0-based, but step numbers are 1-based.
    const stepNumber = index + 1;
    const eventCategory = typeof gaEventCategory === 'function' ? gaEventCategory(viewContext) : gaEventCategory;
    if (type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOOLTIP && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.TOOLTIP) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.VIEW, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.DISMISS, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT && status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOUR_END &&
    // Here we need to additionally check the size === stepNumber because
    // it is the only way to differentiate the status/event combination
    // from an identical combination that happens immediately after completion
    // on index `0` to avoid duplicate measurement.
    size === stepNumber) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.COMPLETE, stepNumber);
    }
    if (lifecycle !== react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE || status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED) {
      return;
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.PREV, stepNumber);
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.NEXT, stepNumber);
    }
  }

  /**
   * Handles `react-joyride` state changes using callback function.
   *
   * @typedef {Object} JoyrideCallbackData
   * @property {string} action The action that updated the state.
   * @property {status} status The tour's status.
   * @property {number} index  Step index.
   * @property {string} type   Specific type (tour, step, beacon).
   *
   * @since 1.28.0
   * @since 1.38.0 Calls new callback prop.
   * @see {@link https://docs.react-joyride.com/callback} Example data provided by `react-joyride`.
   * @see {@link https://docs.react-joyride.com/constants} State & lifecycle constants used by `react-joyride`.
   *
   * @param {JoyrideCallbackData} data Data object provided via `react-joyride` callback prop.
   */
  function handleJoyrideCallback(data) {
    trackAllTourEvents(data);
    const {
      action,
      index,
      status,
      step,
      type
    } = data;
    const hasCloseAction = action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE;
    const shouldChangeStep = !hasCloseAction && [react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER, react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TARGET_NOT_FOUND].includes(type);
    const isFinishedOrSkipped = [react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED, react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.SKIPPED].includes(status);
    const shouldCloseFromButtonClick = hasCloseAction && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER;
    const shouldEndTour = isFinishedOrSkipped || shouldCloseFromButtonClick;

    // Center the target in the viewport when transitioning to the step.
    if (react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_BEFORE === type) {
      let el = step.target;
      if ('string' === typeof step.target) {
        el = __webpack_require__.g.document.querySelector(step.target);
      }
      el?.scrollIntoView?.({
        block: 'center'
      });
    }
    if (shouldChangeStep) {
      changeStep(index, action);
    } else if (shouldEndTour) {
      endTour();
    }
    if (callback) {
      callback(data, registry);
    }
  }

  // Start tour on initial render
  (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(startTour);
  const parsedSteps = steps.map(step => ({
    disableBeacon: true,
    isFixed: true,
    placement: 'auto',
    ...step
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_8__["default"], {
    callback: handleJoyrideCallback,
    floaterProps: floaterProps,
    locale: joyrideLocale,
    run: run,
    stepIndex: stepIndex,
    steps: parsedSteps,
    styles: joyrideStyles,
    tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_6__["default"],
    continuous: true,
    disableOverlayClose: true,
    disableScrolling: true,
    showProgress: true
  });
}

/** For available properties & docs for `steps`, see: {@link https://docs.react-joyride.com/step#options}. */
TourTooltips.propTypes = {
  steps: prop_types__WEBPACK_IMPORTED_MODULE_10___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_10___default().object)).isRequired,
  tourID: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  gaEventCategory: prop_types__WEBPACK_IMPORTED_MODULE_10___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_10___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)]).isRequired,
  isRepeatable: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  callback: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};

/***/ }),

/***/ "./js/components/Typography/P.js":
/*!***************************************!*\
  !*** ./js/components/Typography/P.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ P)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! . */ "./js/components/Typography/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function P({
  type = _constants__WEBPACK_IMPORTED_MODULE_2__.TYPE_BODY,
  size,
  children,
  ...props
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(___WEBPACK_IMPORTED_MODULE_0__["default"], {
    as: "p",
    type: type,
    size: size || (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL ? _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_SMALL : _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_MEDIUM),
    ...props,
    children: children
  });
}
P.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_SIZES)
};

/***/ }),

/***/ "./js/components/Typography/constants.js":
/*!***********************************************!*\
  !*** ./js/components/Typography/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SIZE_LARGE: () => (/* binding */ SIZE_LARGE),
/* harmony export */   SIZE_MEDIUM: () => (/* binding */ SIZE_MEDIUM),
/* harmony export */   SIZE_SMALL: () => (/* binding */ SIZE_SMALL),
/* harmony export */   TYPE_BODY: () => (/* binding */ TYPE_BODY),
/* harmony export */   TYPE_DISPLAY: () => (/* binding */ TYPE_DISPLAY),
/* harmony export */   TYPE_HEADLINE: () => (/* binding */ TYPE_HEADLINE),
/* harmony export */   TYPE_LABEL: () => (/* binding */ TYPE_LABEL),
/* harmony export */   TYPE_TITLE: () => (/* binding */ TYPE_TITLE),
/* harmony export */   VALID_SIZES: () => (/* binding */ VALID_SIZES),
/* harmony export */   VALID_TYPES: () => (/* binding */ VALID_TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPE_DISPLAY = 'display';
const TYPE_HEADLINE = 'headline';
const TYPE_TITLE = 'title';
const TYPE_BODY = 'body';
const TYPE_LABEL = 'label';
const VALID_TYPES = [TYPE_BODY, TYPE_DISPLAY, TYPE_HEADLINE, TYPE_LABEL, TYPE_TITLE];
const SIZE_SMALL = 'small';
const SIZE_MEDIUM = 'medium';
const SIZE_LARGE = 'large';
const VALID_SIZES = [SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE];

/***/ }),

/***/ "./js/components/Typography/index.js":
/*!*******************************************!*\
  !*** ./js/components/Typography/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Typography)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function Typography({
  className,
  type,
  size,
  as: Component = 'span',
  children,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Component, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-typography', className, {
      [`googlesitekit-typography--${type}`]: type && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES.includes(type),
      [`googlesitekit-typography--${size}`]: size && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES.includes(size)
    }),
    ...props,
    children: children
  });
}
Typography.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES),
  as: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)])
};

/***/ }),

/***/ "./js/components/consent-mode/ConsentModeSetupCTABanner.js":
/*!*****************************************************************!*\
  !*** ./js/components/consent-mode/ConsentModeSetupCTABanner.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConsentModeSetupCTABanner)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/AdminScreenTooltip */ "./js/components/AdminScreenTooltip/index.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_SetupCTA__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/SetupCTA */ "./js/googlesitekit/notifications/components/layout/SetupCTA.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _svg_graphics_banner_consent_mode_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/graphics/banner-consent-mode-setup-cta-mobile.svg?url */ "./svg/graphics/banner-consent-mode-setup-cta-mobile.svg?url");
/* harmony import */ var _svg_graphics_banner_consent_mode_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/svg/graphics/banner-consent-mode-setup-cta.svg?url */ "./svg/graphics/banner-consent-mode-setup-cta.svg?url");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./constants */ "./js/components/consent-mode/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */













function ConsentModeSetupCTABanner({
  id,
  Notification
}) {
  const [saveError, setSaveError] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(null);
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_8__["default"])();
  const gaTrackingEventArgs = {
    category: `${viewContext}_CoMo-ads-setup-notification`
  };
  const adminSettingsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getSiteKitAdminSettingsURL());
  const consentModeDocumentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('consent-mode'));
  const tooltipSettings = {
    tooltipSlug: _constants__WEBPACK_IMPORTED_MODULE_12__.CONSENT_MODE_SETUP_CTA_WIDGET_SLUG,
    content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always enable consent mode in Settings later', 'google-site-kit'),
    dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
  };
  const showTooltip = (0,_js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_2__.useShowTooltip)(tooltipSettings);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_LOCATION);
  const isDismissalFinal = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_NOTIFICATIONS).isNotificationDismissalFinal(id));
  const {
    setConsentModeEnabled,
    saveConsentModeSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__.useEffect)(() => {
    triggerSurvey('view_como_setup_cta', {
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_9__.DAY_IN_SECONDS
    });
  }, [triggerSurvey]);
  async function handleCTAClick() {
    setSaveError(null);
    setConsentModeEnabled(true);
    setIsSaving(true);
    const promises = [saveConsentModeSettings(), triggerSurvey('enable_como', {
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_9__.DAY_IN_SECONDS
    })];
    const [{
      error
    }] = await Promise.all(promises);
    if (error) {
      setSaveError(error);
      setConsentModeEnabled(false);
      setIsSaving(false);
    } else {
      navigateTo(adminSettingsURL);
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(Notification, {
    gaTrackingEventArgs: gaTrackingEventArgs,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_googlesitekit_notifications_components_layout_SetupCTA__WEBPACK_IMPORTED_MODULE_6__["default"], {
      notificationID: id,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enable consent mode to preserve tracking for your Ads campaigns', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Consent mode interacts with your Consent Management Platform (CMP) or custom implementation for obtaining visitor consent, such as a cookie consent banner.', 'google-site-kit'),
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enable consent mode', 'google-site-kit'),
        onClick: handleCTAClick,
        inProgress: isSaving,
        dismissOnClick: true,
        dismissOptions: {
          skipHidingFromQueue: true
        }
      },
      dismissButton: {
        label: isDismissalFinal ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Don’t show again', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
        onClick: showTooltip,
        dismissOptions: {
          expiresInSeconds: isDismissalFinal ? 0 : 2 * _js_util__WEBPACK_IMPORTED_MODULE_9__.WEEK_IN_SECONDS
        }
      },
      svg: {
        desktop: _svg_graphics_banner_consent_mode_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_11__["default"],
        mobile: _svg_graphics_banner_consent_mode_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_10__["default"],
        verticalPosition: 'center'
      },
      learnMoreLink: {
        href: consentModeDocumentationURL
      },
      errorText: saveError?.message,
      gaTrackingEventArgs: gaTrackingEventArgs
    })
  });
}
ConsentModeSetupCTABanner.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string),
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().elementType)
};

/***/ }),

/***/ "./js/components/consent-mode/constants.js":
/*!*************************************************!*\
  !*** ./js/components/consent-mode/constants.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CONSENT_MODE_SETUP_CTA_WIDGET_SLUG: () => (/* binding */ CONSENT_MODE_SETUP_CTA_WIDGET_SLUG)
/* harmony export */ });
/**
 * Consent mode components - constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CONSENT_MODE_SETUP_CTA_WIDGET_SLUG = 'consent-mode-setup-cta-widget';

/***/ }),

/***/ "./js/components/dashboard-sharing/ModuleRecoveryAlert/AdditionalDescription.js":
/*!**************************************************************************************!*\
  !*** ./js/components/dashboard-sharing/ModuleRecoveryAlert/AdditionalDescription.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdditionalDescription)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _Errors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Errors */ "./js/components/dashboard-sharing/ModuleRecoveryAlert/Errors.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleRecoveryAlert AdditionalDescription component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */

/**
 * WordPress dependencies.
 */


/**
 * Internal dependencies
 */

/**
 * Internal dependencies.
 */





function AdditionalDescription({
  inProgress,
  selectedModuleSlugs,
  hasUserRecoverableModules,
  recoverableModules,
  userRecoverableModuleSlugs,
  hasMultipleRecoverableModules,
  setSelectedModuleSlugs
}) {
  const recoveryErrors = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getRecoveryErrors());
  if (!hasUserRecoverableModules && !hasMultipleRecoverableModules) {
    return null;
  }
  if (!hasUserRecoverableModules) {
    // User has no permission to recover any modules.
    // Show all recoverable modules in a read-only list.
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("ul", {
      className: "mdc-list mdc-list--non-interactive",
      children: Object.values(recoverableModules || {}).map(module => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("li", {
        className: "mdc-list-item",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
          className: "mdc-list-item__text",
          children: module.name
        })
      }, module.slug))
    });
  }
  return (
    /*#__PURE__*/
    // List recoverable modules with checkboxes.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
      children: [hasMultipleRecoverableModules && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
        children: [selectedModuleSlugs && userRecoverableModuleSlugs.map(slug => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Checkbox, {
            checked: selectedModuleSlugs.includes(slug),
            name: "module-recovery-alert-checkbox",
            id: `module-recovery-alert-checkbox-${slug}`,
            onChange: () => {
              if (selectedModuleSlugs.includes(slug)) {
                setSelectedModuleSlugs((0,lodash__WEBPACK_IMPORTED_MODULE_0__.without)(selectedModuleSlugs, slug));
              } else {
                setSelectedModuleSlugs([...selectedModuleSlugs, slug]);
              }
            },
            disabled: inProgress,
            value: slug,
            children: recoverableModules[slug].name
          })
        }, slug)), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__["default"], {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('By recovering the selected modules, you will restore access for other users by sharing access via your Google account. This does not make any changes to external services and can be managed at any time via the dashboard sharing settings.', 'google-site-kit')
        })]
      }), !hasMultipleRecoverableModules && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('By recovering the module, you will restore access for other users by sharing access via your Google account. This does not make any changes to external services and can be managed at any time via the dashboard sharing settings.', 'google-site-kit')
      }), Object.keys(recoveryErrors).length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Errors__WEBPACK_IMPORTED_MODULE_6__["default"], {
        recoveryErrors: recoveryErrors
      })]
    })
  );
}

/***/ }),

/***/ "./js/components/dashboard-sharing/ModuleRecoveryAlert/Description.js":
/*!****************************************************************************!*\
  !*** ./js/components/dashboard-sharing/ModuleRecoveryAlert/Description.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleRecoveryAlert Description component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function Description({
  recoverableModules,
  userRecoverableModuleSlugs,
  hasUserRecoverableModules,
  hasMultipleRecoverableModules
}) {
  const documentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('dashboard-sharing');
  });
  let descriptionContent;
  if (!hasMultipleRecoverableModules && hasUserRecoverableModules) {
    descriptionContent = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module name. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data was previously shared with other users on the site by another admin who no longer has access. To restore access, you may recover the module as the new owner.', 'google-site-kit'), recoverableModules[userRecoverableModuleSlugs[0]]?.name);
  } else if (hasMultipleRecoverableModules && hasUserRecoverableModules) {
    descriptionContent = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The data for the following modules was previously shared with other users on the site by another admin who no longer has access. To restore access, you may recover the module as the new owner.', 'google-site-kit');
  } else if (!hasMultipleRecoverableModules && !hasUserRecoverableModules && recoverableModules) {
    descriptionContent = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module name. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data was previously shared with other users on the site by another admin who no longer has access. To restore access, the module must be recovered by another admin who has access.', 'google-site-kit'), Object.values(recoverableModules)[0]?.name);
  } else if (hasMultipleRecoverableModules && !hasUserRecoverableModules) {
    descriptionContent = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The data for the following modules was previously shared with other users on the site by another admin who no longer has access. To restore access, the module must be recovered by another admin who has access.', 'google-site-kit');
  }
  if (descriptionContent) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_3__["default"], {
      children: [descriptionContent, ' ', /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
        href: documentationURL
      })]
    });
  }
  return null;
}

/***/ }),

/***/ "./js/components/dashboard-sharing/ModuleRecoveryAlert/Errors.js":
/*!***********************************************************************!*\
  !*** ./js/components/dashboard-sharing/ModuleRecoveryAlert/Errors.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Errors)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleRecoveryAlert Error component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function Errors({
  recoveryErrors
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "googlesitekit-module-recovery-errors",
    children: [Object.keys(recoveryErrors).length === 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_1__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), Object.values(recoveryErrors)[0].message)
    }), Object.keys(recoveryErrors).length > 1 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_1__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The following modules failed to be recovered:', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("ul", {
        children: Object.keys(recoveryErrors).map(module => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("li", {
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Module name, 2: Error message */
          (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s: %2$s', 'google-site-kit'), recoveryErrors[module].name, recoveryErrors[module].message)
        }, module))
      })]
    })]
  });
}
Errors.propTypes = {
  recoveryErrors: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object).isRequired
};

/***/ }),

/***/ "./js/components/dashboard-sharing/ModuleRecoveryAlert/index.js":
/*!**********************************************************************!*\
  !*** ./js/components/dashboard-sharing/ModuleRecoveryAlert/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleRecoveryAlert)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMountedState.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _AdditionalDescription__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./AdditionalDescription */ "./js/components/dashboard-sharing/ModuleRecoveryAlert/AdditionalDescription.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Description */ "./js/components/dashboard-sharing/ModuleRecoveryAlert/Description.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./utils */ "./js/components/dashboard-sharing/ModuleRecoveryAlert/utils.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleRecoveryAlert component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function ModuleRecoveryAlert({
  id,
  Notification
}) {
  const [selectedModuleSlugs, setSelectedModuleSlugs] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)(null);
  const [inProgress, setInProgress] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)(false);
  const isMounted = (0,react_use__WEBPACK_IMPORTED_MODULE_13__["default"])();
  const recoverableModules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getRecoverableModules());
  const userRecoverableModuleSlugs = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getUserRecoverableModuleSlugs());

  // The alert renders conditional copy and actions based on:
  // 1. If there is one or more than one module to recover.
  // 2. If the user has access to perform the recovery.
  const hasMultipleRecoverableModules = Object.keys(recoverableModules || {}).length > 1;
  const hasUserRecoverableModules = !!userRecoverableModuleSlugs?.length;
  const {
    recoverModules,
    clearRecoveredModules
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_NOTIFICATIONS);
  const handleRecoverModules = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(async () => {
    setInProgress(true);
    await clearRecoveredModules();
    const recoveryResponse = await recoverModules(selectedModuleSlugs);
    const successfullyRecoveredModules = Object.keys(recoveryResponse?.response?.success || {}).filter(slug => recoveryResponse.response.success[slug]);

    // Only dismiss the notification if all modules were recovered successfully.
    if (userRecoverableModuleSlugs.length === successfullyRecoveredModules.length) {
      dismissNotification(id, {
        skipHidingFromQueue: false
      });
    }

    // Only update state if the component is still mounted.
    if (isMounted()) {
      setSelectedModuleSlugs(null);
      setInProgress(false);
    }
  }, [id, isMounted, clearRecoveredModules, dismissNotification, recoverModules, selectedModuleSlugs, userRecoverableModuleSlugs]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useEffect)(() => {
    if (selectedModuleSlugs === null && Array.isArray(userRecoverableModuleSlugs)) {
      setSelectedModuleSlugs(userRecoverableModuleSlugs);
    }
  }, [selectedModuleSlugs, userRecoverableModuleSlugs]);

  // Disable the CTA if no modules are selected to be restored.
  const disableCTA = !selectedModuleSlugs?.length;
  const isLoading = recoverableModules === undefined || userRecoverableModuleSlugs === undefined;
  const hideCTAButton = !hasUserRecoverableModules;
  if (inProgress && !hasUserRecoverableModules) {
    return null;
  }
  const ariaLabel = (0,_utils__WEBPACK_IMPORTED_MODULE_10__.computeAriaLabel)({
    recoverableModules,
    userRecoverableModuleSlugs,
    selectedModuleSlugs,
    hasUserRecoverableModules,
    hasMultipleRecoverableModules
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__.TYPES.ERROR,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Dashboard data for some services has been interrupted', 'google-site-kit'),
      description: isLoading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_3__["default"], {
          width: "auto",
          height: "50px"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_3__["default"], {
          width: "auto",
          height: "60px"
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_3__["default"], {
          width: "220px",
          height: "35px"
        })]
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_9__["default"], {
        recoverableModules: recoverableModules,
        userRecoverableModuleSlugs: userRecoverableModuleSlugs,
        hasUserRecoverableModules: hasUserRecoverableModules,
        hasMultipleRecoverableModules: hasMultipleRecoverableModules
      }),
      additionalDescription: !isLoading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_AdditionalDescription__WEBPACK_IMPORTED_MODULE_8__["default"], {
        selectedModuleSlugs: selectedModuleSlugs,
        hasUserRecoverableModules: hasUserRecoverableModules,
        hasMultipleRecoverableModules: hasMultipleRecoverableModules,
        recoverableModules: recoverableModules,
        userRecoverableModuleSlugs: userRecoverableModuleSlugs,
        inProgress: inProgress,
        setSelectedModuleSlugs: setSelectedModuleSlugs
      }),
      ctaButton: hideCTAButton ? undefined : {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Recover', 'google-site-kit'),
        onClick: handleRecoverModules,
        disabled: disableCTA,
        ariaLabel,
        inProgress
      },
      dismissButton: isLoading ? undefined : {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Remind me later', 'google-site-kit'),
        tertiary: !hideCTAButton,
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
          'googlesitekit-banner__cta': hideCTAButton
        }),
        dismissOptions: hideCTAButton ? {
          dismissExpires: _js_util__WEBPACK_IMPORTED_MODULE_7__.DAY_IN_SECONDS
        } : undefined
      }
    })
  });
}

/***/ }),

/***/ "./js/components/dashboard-sharing/ModuleRecoveryAlert/utils.js":
/*!**********************************************************************!*\
  !*** ./js/components/dashboard-sharing/ModuleRecoveryAlert/utils.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   computeAriaLabel: () => (/* binding */ computeAriaLabel)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * ModuleRecoveryAlert utils.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Computes the aria-label for the Recover CTA button.
 *
 * @since 1.160.0
 *
 * @param {Object}        args                               Parameters object.
 * @param {Object}        args.recoverableModules            Map of module slugs to module objects.
 * @param {Array<string>} args.userRecoverableModuleSlugs    List of slugs the user can recover.
 * @param {Array<string>} args.selectedModuleSlugs           List of selected slugs for recovery.
 * @param {boolean}       args.hasUserRecoverableModules     Whether the user has recoverable modules.
 * @param {boolean}       args.hasMultipleRecoverableModules Whether there are multiple recoverable modules.
 * @return {string|undefined} Formatted aria-label string, or undefined if no label should be rendered.
 */
function computeAriaLabel({
  recoverableModules,
  userRecoverableModuleSlugs,
  selectedModuleSlugs,
  hasUserRecoverableModules,
  hasMultipleRecoverableModules
}) {
  if (!hasUserRecoverableModules) {
    return undefined;
  }

  // Early return for single module case.
  if (!hasMultipleRecoverableModules) {
    const moduleName = recoverableModules[userRecoverableModuleSlugs[0]]?.name;

    /* translators: %s: Module name. */
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Recover %s', 'google-site-kit'), moduleName);
  }

  // Handle multiple modules case (module 1 and module 2, or module 1, module 2... and module X).
  if (!selectedModuleSlugs?.length) {
    return undefined;
  }
  const selectedSet = new Set(selectedModuleSlugs);
  const moduleNames = [];
  for (const slug of userRecoverableModuleSlugs) {
    if (selectedSet.has(slug)) {
      const moduleName = recoverableModules[slug]?.name;
      if (moduleName) {
        moduleNames.push(moduleName);
      }
    }
  }
  if (moduleNames.length === 0) {
    return undefined;
  }
  if (moduleNames.length === 1) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Recover %s', 'google-site-kit'), moduleNames[0]);
  }
  if (moduleNames.length === 2) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: First module name. 2: Second module name. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Recover %1$s and %2$s', 'google-site-kit'), moduleNames[0], moduleNames[1]);
  }
  const last = moduleNames[moduleNames.length - 1];
  const rest = moduleNames.slice(0, -1);
  return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: List of module names. 2: Last module name. */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Recover %1$s and %2$s', 'google-site-kit'), rest.join(', '), last);
}

/***/ }),

/***/ "./js/components/email-reporting/SetUpEmailReportingOverlayNotification.js":
/*!*********************************************************************************!*\
  !*** ./js/components/email-reporting/SetUpEmailReportingOverlayNotification.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SET_UP_EMAIL_REPORTING_OVERLAY_NOTIFICATION: () => (/* binding */ SET_UP_EMAIL_REPORTING_OVERLAY_NOTIFICATION),
/* harmony export */   "default": () => (/* binding */ SetUpEmailReportingOverlayNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/AdminScreenTooltip */ "./js/components/AdminScreenTooltip/index.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_OverlayNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/OverlayNotification */ "./js/googlesitekit/notifications/components/layout/OverlayNotification.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _svg_graphics_email_reporting_overlay_desktop_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/svg/graphics/email-reporting-overlay-desktop.svg */ "./svg/graphics/email-reporting-overlay-desktop.svg");
/* harmony import */ var _svg_graphics_email_reporting_overlay_mobile_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/svg/graphics/email-reporting-overlay-mobile.svg */ "./svg/graphics/email-reporting-overlay-mobile.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./constants */ "./js/components/email-reporting/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetUpEmailReportingOverlayNotification component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */










const SET_UP_EMAIL_REPORTING_OVERLAY_NOTIFICATION = 'email_reports_setup_overlay_notification';
function SetUpEmailReportingOverlayNotification({
  id,
  Notification
}) {
  const isSelectionPanelOpen = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI).getValue(_constants__WEBPACK_IMPORTED_MODULE_9__.USER_SETTINGS_SELECTION_PANEL_OPENED_KEY));
  const previousIsSelectionPanelOpen = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_11__["default"])(isSelectionPanelOpen);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_UI);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_NOTIFICATIONS);
  const onSetupCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    setValue(_constants__WEBPACK_IMPORTED_MODULE_9__.USER_SETTINGS_SELECTION_PANEL_OPENED_KEY, true);
  }, [setValue]);
  const tooltipSettings = {
    target: '.googlesitekit-user-selector',
    placement: 'bottom-end',
    className: 'googlesitekit-tour-tooltip--user-menu',
    tooltipSlug: SET_UP_EMAIL_REPORTING_OVERLAY_NOTIFICATION,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always manage your email reports subscription from the user menu', 'google-site-kit'),
    dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
  };
  const showTooltip = (0,_js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_2__.useShowTooltip)(tooltipSettings);
  const handleDismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    showTooltip();
  }, [showTooltip]);
  const isUserSubscribed = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isEmailReportingSubscribed());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useEffect)(() => {
    if (previousIsSelectionPanelOpen && !isSelectionPanelOpen) {
      dismissNotification(id);
      if (!isUserSubscribed) {
        setTimeout(() => {
          showTooltip();
        }, 310); // Wait until after the panel close animation.
      }
    }
  }, [previousIsSelectionPanelOpen, isSelectionPanelOpen, dismissNotification, id, isUserSubscribed, showTooltip]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_googlesitekit_notifications_components_layout_OverlayNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get site insights in your inbox', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Receive the most important insights about your site’s performance, key trends, and tailored metrics directly in your inbox', 'google-site-kit'),
      GraphicDesktop: _svg_graphics_email_reporting_overlay_desktop_svg__WEBPACK_IMPORTED_MODULE_7__["default"],
      GraphicMobile: _svg_graphics_email_reporting_overlay_mobile_svg__WEBPACK_IMPORTED_MODULE_8__["default"],
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set up', 'google-site-kit'),
        onClick: onSetupCallback,
        dismissOnClick: true
      },
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
        onClick: handleDismiss
      },
      newBadge: true
    })
  });
}
SetUpEmailReportingOverlayNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType).isRequired
};

/***/ }),

/***/ "./js/components/email-reporting/constants.js":
/*!****************************************************!*\
  !*** ./js/components/email-reporting/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   USER_SETTINGS_SELECTION_PANEL_OPENED_KEY: () => (/* binding */ USER_SETTINGS_SELECTION_PANEL_OPENED_KEY)
/* harmony export */ });
/**
 * Email Reporting constants
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const USER_SETTINGS_SELECTION_PANEL_OPENED_KEY = 'emailReportingUserSettingsSelectionPanelOpened';

/***/ }),

/***/ "./js/components/notifications/ActivateAnalyticsNotification.tsx":
/*!***********************************************************************!*\
  !*** ./js/components/notifications/ActivateAnalyticsNotification.tsx ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/AdminScreenTooltip */ "./js/components/AdminScreenTooltip/index.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useActivateModuleCallback */ "./js/hooks/useActivateModuleCallback.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _svg_graphics_activate_analytics_graphic_svg_url__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/svg/graphics/activate-analytics-graphic.svg?url */ "./svg/graphics/activate-analytics-graphic.svg?url");
/* provided dependency */ var React = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/index.js");
/**
 * ActivateAnalyticsNotification component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










// @ts-expect-error - We need to add types for imported SVGs.


// eslint-disable-next-line @typescript-eslint/no-explicit-any -- `@wordpress/data` is not typed yet.

const ActivateAnalyticsNotification = ({
  id,
  Notification
}) => {
  const tooltipSettings = {
    tooltipSlug: id,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always set up Analytics from Settings later', 'google-site-kit'),
    dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
  };
  const showTooltip = (0,_js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_2__.useShowTooltip)(tooltipSettings);
  const isDismissalFinal = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_NOTIFICATIONS).isNotificationDismissalFinal(id));
  const isNavigatingToReauthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const adminReauthURL = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ANALYTICS_4).getAdminReauthURL();
    if (!adminReauthURL) {
      return false;
    }
    return select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_LOCATION).isNavigatingTo(adminReauthURL);
  });
  const isActivatingAnalytics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).isFetchingSetModuleActivation(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ANALYTICS_4, true));
  const activateAnalytics = (0,_js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_7__["default"])(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ANALYTICS_4);
  const isBusy = isActivatingAnalytics || isNavigatingToReauthURL;
  return /*#__PURE__*/React.createElement(Notification, null, /*#__PURE__*/React.createElement(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
    notificationID: id,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Understand how visitors interact with your content', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get a deeper understanding of your customers. Google Analytics gives you the free tools you need to analyze data for your business in one place.', 'google-site-kit'),
    ctaButton: {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set up Analytics', 'google-site-kit'),
      onClick: activateAnalytics,
      disabled: isBusy,
      inProgress: isBusy,
      dismissOnClick: true,
      dismissOptions: {
        expiresInSeconds: 0,
        skipHidingFromQueue: true
      }
    },
    dismissButton: {
      label: isDismissalFinal ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Don’t show again', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
      onClick: showTooltip,
      disabled: isBusy,
      dismissOptions: {
        expiresInSeconds: isDismissalFinal ? 0 : 2 * _js_util__WEBPACK_IMPORTED_MODULE_10__.WEEK_IN_SECONDS
      }
    },
    svg: {
      desktop: _svg_graphics_activate_analytics_graphic_svg_url__WEBPACK_IMPORTED_MODULE_11__["default"],
      verticalPosition: 'center'
    }
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ActivateAnalyticsNotification);

/***/ }),

/***/ "./js/components/notifications/AuthError.js":
/*!**************************************************!*\
  !*** ./js/components/notifications/AuthError.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AuthError)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AuthError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function AuthError({
  id,
  Notification
}) {
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).getAuthError());
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__["default"], {
      notificationID: id,
      type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit can’t access necessary data', 'google-site-kit'),
      description: error.message,
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Redo the plugin setup', 'google-site-kit'),
        href: error.data.reconnectURL
      }
    })
  });
}

/***/ }),

/***/ "./js/components/notifications/EnableAutoUpdateBannerNotification.js":
/*!***************************************************************************!*\
  !*** ./js/components/notifications/EnableAutoUpdateBannerNotification.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ENABLE_AUTO_UPDATES_BANNER_SLUG: () => (/* binding */ ENABLE_AUTO_UPDATES_BANNER_SLUG),
/* harmony export */   "default": () => (/* binding */ EnableAutoUpdateBannerNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * EnableAutoUpdateBannerNotification component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







const ENABLE_AUTO_UPDATES_BANNER_SLUG = 'auto-update-cta';
function EnableAutoUpdateBannerNotification({
  id,
  Notification
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const siteKitAutoUpdatesEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getSiteKitAutoUpdatesEnabled());
  const enableAutoUpdateError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getErrorForAction('enableAutoUpdate', []));
  const {
    enableAutoUpdate
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);
  const ctaActivate = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(async () => {
    await enableAutoUpdate();
  }, [enableAutoUpdate]);
  const [enabledViaCTA, setEnabledViaCTA] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);

  // If auto-updates were enabled via this CTA banner, then set the state to
  // true to render the success banner variation.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
    if (enabledViaCTA === false && siteKitAutoUpdatesEnabled === true) {
      setEnabledViaCTA(true);
    }
  }, [enabledViaCTA, setEnabledViaCTA, siteKitAutoUpdatesEnabled]);
  if (enableAutoUpdateError?.message) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_ErrorNotice__WEBPACK_IMPORTED_MODULE_2__["default"], {
      message: enableAutoUpdateError.message
    });
  }

  // Render the "Auto Updates enabled successfully" banner variation
  // if auto updates were enabled using this banner CTA.
  if (enabledViaCTA) {
    // Use separate GA tracking event category for success banner variation.
    const gaTrackingEventArgs = {
      category: `${viewContext}_${ENABLE_AUTO_UPDATES_BANNER_SLUG}-success`
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Notification, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
        notificationID: id,
        type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS,
        gaTrackingEventArgs: gaTrackingEventArgs,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Thanks for enabling auto-updates', 'google-site-kit'),
        description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Auto-updates have been enabled. Your version of Site Kit will automatically be updated when new versions are available.', 'google-site-kit'),
        dismissButton: {
          label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Dismiss', 'google-site-kit'),
          dismissOptions: {
            expiresInSeconds: 1
          }
        }
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Keep Site Kit up-to-date', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Turn on auto-updates so you always have the latest version of Site Kit. We constantly introduce new features to help you get the insights you need to be successful on the web.', 'google-site-kit'),
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enable auto-updates', 'google-site-kit'),
        onClick: ctaActivate
      },
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Dismiss', 'google-site-kit')
      }
    })
  });
}
EnableAutoUpdateBannerNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().elementType).isRequired
};

/***/ }),

/***/ "./js/components/notifications/GA4AdSenseLinkedNotification.js":
/*!*********************************************************************!*\
  !*** ./js/components/notifications/GA4AdSenseLinkedNotification.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GA4AdSenseLinkedNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GA4AdSenseLinkedNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function GA4AdSenseLinkedNotification({
  id,
  Notification
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_2__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.SUCCESS,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your AdSense and Analytics accounts are linked', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('We’ll let you know as soon as there’s enough data available', 'google-site-kit'),
      dismissButton: true
    })
  });
}
GA4AdSenseLinkedNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().elementType).isRequired
};

/***/ }),

/***/ "./js/components/notifications/GatheringDataNotification.js":
/*!******************************************************************!*\
  !*** ./js/components/notifications/GatheringDataNotification.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GatheringDataNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_hooks_useModuleGatheringZeroData__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useModuleGatheringZeroData */ "./js/hooks/useModuleGatheringZeroData.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _svg_graphics_banner_gathering_data_svg_url__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/svg/graphics/banner-gathering-data.svg?url */ "./svg/graphics/banner-gathering-data.svg?url");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GatheringDataNotification component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function GatheringDataNotification({
  id,
  Notification
}) {
  const [isNavigating, setIsNavigating] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  const connectMoreServicesURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnectMoreServicesURL());
  const {
    analyticsGatheringData,
    searchConsoleGatheringData
  } = (0,_js_hooks_useModuleGatheringZeroData__WEBPACK_IMPORTED_MODULE_4__["default"])();
  let gatheringDataTitle;
  // Analytics requires up to 72 hours to gather data.
  let gatheringDataWaitTimeInHours = 72;
  if (analyticsGatheringData && searchConsoleGatheringData) {
    gatheringDataTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Search Console and Analytics are gathering data', 'google-site-kit');
  } else if (analyticsGatheringData) {
    gatheringDataTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Analytics is gathering data', 'google-site-kit');
  } else if (searchConsoleGatheringData) {
    // If only Search Console is gathering data, show a lower wait
    // time, since it only requires 48 hours.
    gatheringDataWaitTimeInHours = 48;
    gatheringDataTitle = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Search Console is gathering data', 'google-site-kit');
  }
  if (!gatheringDataWaitTimeInHours) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__["default"], {
      notificationID: id,
      type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO,
      title: gatheringDataTitle,
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: the number of hours the site can be in a gathering data state */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._n)('It can take up to %s hour before stats show up for your site. While you’re waiting, connect more services to get more stats.', 'It can take up to %s hours before stats show up for your site. While you’re waiting, connect more services to get more stats.', gatheringDataWaitTimeInHours, 'google-site-kit'), gatheringDataWaitTimeInHours),
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Connect more services', 'google-site-kit'),
        href: connectMoreServicesURL,
        dismissOnClick: true,
        dismissOptions: {
          expiresInSeconds: _js_util__WEBPACK_IMPORTED_MODULE_5__.DAY_IN_SECONDS,
          skipHidingFromQueue: true
        },
        onClick: () => setIsNavigating(true),
        inProgress: isNavigating
      },
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
        dismissOptions: {
          expiresInSeconds: _js_util__WEBPACK_IMPORTED_MODULE_5__.DAY_IN_SECONDS
        },
        disabled: isNavigating
      },
      svg: {
        desktop: _svg_graphics_banner_gathering_data_svg_url__WEBPACK_IMPORTED_MODULE_6__["default"],
        mobile: undefined,
        verticalPosition: 'center'
      }
    })
  });
}
GatheringDataNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().elementType)
};

/***/ }),

/***/ "./js/components/notifications/GoogleTagGatewaySetupBanner.js":
/*!********************************************************************!*\
  !*** ./js/components/notifications/GoogleTagGatewaySetupBanner.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GoogleTagGatewaySetupBanner)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/AdminScreenTooltip */ "./js/components/AdminScreenTooltip/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_SetupCTA__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/SetupCTA */ "./js/googlesitekit/notifications/components/layout/SetupCTA.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _svg_graphics_banner_google_tag_gateway_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/svg/graphics/banner-google-tag-gateway-setup-cta-mobile.svg?url */ "./svg/graphics/banner-google-tag-gateway-setup-cta-mobile.svg?url");
/* harmony import */ var _svg_graphics_banner_google_tag_gateway_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/graphics/banner-google-tag-gateway-setup-cta.svg?url */ "./svg/graphics/banner-google-tag-gateway-setup-cta.svg?url");
/* harmony import */ var _GoogleTagGatewaySetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./GoogleTagGatewaySetupSuccessSubtleNotification */ "./js/components/notifications/GoogleTagGatewaySetupSuccessSubtleNotification.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GoogleTagGatewaySetupBanner component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */












function GoogleTagGatewaySetupBanner({
  id,
  Notification
}) {
  const [inProgress, setInProgress] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useState)(false);
  const {
    setGoogleTagGatewayEnabled,
    saveGoogleTagGatewaySettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE);
  const tooltipSettings = {
    tooltipSlug: id,
    content: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always enable Google tag gateway for advertisers in Settings later', 'google-site-kit'),
    dismissLabel: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
  };
  const showTooltip = (0,_js_components_AdminScreenTooltip__WEBPACK_IMPORTED_MODULE_2__.useShowTooltip)(tooltipSettings);
  const {
    dismissNotification,
    registerNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_NOTIFICATIONS);
  const learnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getDocumentationLinkURL('google-tag-gateway-introduction'));
  async function onCTAClick() {
    setInProgress(true);
    setGoogleTagGatewayEnabled(true);
    const {
      error
    } = await saveGoogleTagGatewaySettings();
    if (error) {
      setInProgress(false);
      return;
    }
    dismissNotification(id);
    registerNotification(_GoogleTagGatewaySetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_11__.GOOGLE_TAG_GATEWAY_SETUP_SUCCESS_NOTIFICATION, {
      Component: _GoogleTagGatewaySetupSuccessSubtleNotification__WEBPACK_IMPORTED_MODULE_11__["default"],
      areaSlug: _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_6__.NOTIFICATION_AREAS.DASHBOARD_TOP,
      isDismissible: false,
      featureFlag: 'googleTagGateway'
    });
    setInProgress(false);
  }
  const ctaError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const googleTagGatewaySettings = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getGoogleTagGatewaySettings();
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getErrorForAction('saveGoogleTagGatewaySettings', [googleTagGatewaySettings]);
  });
  const {
    triggerSurvey
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER);
  const handleView = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
    triggerSurvey('view_gtg_setup_cta', {
      ttl: _js_util__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS
    });
  }, [triggerSurvey]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(Notification, {
    onView: handleView,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)(_js_googlesitekit_notifications_components_layout_SetupCTA__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get more comprehensive stats by collecting metrics via your own site', 'google-site-kit'),
      description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enable Google tag gateway for advertisers (<em>beta</em>) to send measurement through your own domain - this helps improve the quality and completeness of Analytics or Ads metrics.', 'google-site-kit'), {
        em: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx)("em", {})
      }),
      learnMoreLink: {
        href: learnMoreURL
      },
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Enable Google tag gateway for advertisers', 'google-site-kit'),
        onClick: onCTAClick,
        inProgress
      },
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
        onClick: showTooltip
      },
      svg: {
        desktop: _svg_graphics_banner_google_tag_gateway_setup_cta_svg_url__WEBPACK_IMPORTED_MODULE_10__["default"],
        mobile: _svg_graphics_banner_google_tag_gateway_setup_cta_mobile_svg_url__WEBPACK_IMPORTED_MODULE_9__["default"],
        verticalPosition: 'bottom'
      },
      errorText: ctaError?.message
    })
  });
}
GoogleTagGatewaySetupBanner.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().string),
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().elementType)
};

/***/ }),

/***/ "./js/components/notifications/GoogleTagGatewaySetupSuccessSubtleNotification.js":
/*!***************************************************************************************!*\
  !*** ./js/components/notifications/GoogleTagGatewaySetupSuccessSubtleNotification.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GOOGLE_TAG_GATEWAY_SETUP_SUCCESS_NOTIFICATION: () => (/* binding */ GOOGLE_TAG_GATEWAY_SETUP_SUCCESS_NOTIFICATION),
/* harmony export */   "default": () => (/* binding */ GoogleTagGatewaySetupSuccessSubtleNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GoogleTagGatewaySetupSuccessSubtleNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const GOOGLE_TAG_GATEWAY_SETUP_SUCCESS_NOTIFICATION = 'setup-success-notification-gtg';
function GoogleTagGatewaySetupSuccessSubtleNotification({
  id,
  Notification
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_2__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.SUCCESS,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You successfully enabled Google tag gateway for advertisers!', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('You can always disable it in Analytics or Ads settings', 'google-site-kit'),
      dismissButton: true
    })
  });
}
GoogleTagGatewaySetupSuccessSubtleNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().elementType).isRequired
};

/***/ }),

/***/ "./js/components/notifications/GoogleTagGatewayWarningNotification.js":
/*!****************************************************************************!*\
  !*** ./js/components/notifications/GoogleTagGatewayWarningNotification.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GoogleTagGatewayWarningNotification)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GoogleTagGatewayWarningNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function GoogleTagGatewayWarningNotification({
  id,
  Notification
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const serverRequirementsLearnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('google-tag-gateway-server-requirements');
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      type: _js_components_Notice__WEBPACK_IMPORTED_MODULE_3__["default"].TYPES.WARNING,
      description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Google tag gateway for advertisers has been disabled due to server configuration issues. Measurement data is now being routed through the default Google server. Please contact your hosting provider to resolve the issue. <a>Learn more</a>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
          href: serverRequirementsLearnMoreURL,
          onClick: () => {
            (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_warning-notification-gtg`, 'click_learn_more_link');
          },
          "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more about Google tag gateway for advertisers server requirements', 'google-site-kit'),
          external: true
        })
      }),
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit')
      }
    })
  });
}

/***/ }),

/***/ "./js/components/notifications/ModuleSetupSuccessNotification.js":
/*!***********************************************************************!*\
  !*** ./js/components/notifications/ModuleSetupSuccessNotification.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModuleSetupSuccessNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/NoticeNotification */ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js");
/* harmony import */ var _js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useQueryArg */ "./js/hooks/useQueryArg.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModuleSetupSuccessNotification component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








function ModuleSetupSuccessNotification({
  id,
  Notification
}) {
  const [, setNotification] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_6__["default"])('notification');
  const [slug, setSlug] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_6__["default"])('slug');
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModule(slug));
  const connectMoreServicesURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getConnectMoreServicesURL());
  function onDismiss() {
    setNotification(undefined);
    setSlug(undefined);
  }

  // Since the notification ID here is generic (`setup-success-notification-module`),
  // it will be helpful to track individual module notifications uniquely as we do for
  // other Setup Success Notifications.
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const gaTrackingEventArgs = {
    category: `${viewContext}_setup-success-notification-${module?.slug}`
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Notification, {
    gaTrackingEventArgs: gaTrackingEventArgs,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_googlesitekit_notifications_components_layout_NoticeNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_2__.TYPES.SUCCESS,
      gaTrackingEventArgs: gaTrackingEventArgs,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Congrats on completing the setup for %s!', 'google-site-kit'), module?.name),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Connect more services to see more stats.', 'google-site-kit'),
      dismissButton: {
        onClick: onDismiss
      },
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Go to Settings', 'google-site-kit'),
        href: connectMoreServicesURL
      }
    })
  });
}
ModuleSetupSuccessNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().elementType).isRequired
};

/***/ }),

/***/ "./js/components/notifications/SetupErrorMessageNotification.js":
/*!**********************************************************************!*\
  !*** ./js/components/notifications/SetupErrorMessageNotification.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupErrorMessageNotification)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupErrorMessageNotification component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function SetupErrorMessageNotification({
  Notification
}) {
  const id = 'setup_error';
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const isAuthenticated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).isAuthenticated());

  // These will be `null` if no errors exist.
  const setupErrorCode = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSetupErrorCode());
  const setupErrorMessage = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSetupErrorMessage());
  const temporaryPersistedPermissionsError = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__["default"])(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, 'permissionsError');
  const setupErrorRedoURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (temporaryPersistedPermissionsError?.data) {
      return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getConnectURL({
        additionalScopes: temporaryPersistedPermissionsError?.data?.scopes,
        redirectURL: temporaryPersistedPermissionsError?.data?.redirectURL || __webpack_require__.g.location.href
      });
    } else if (setupErrorCode === 'access_denied' && !temporaryPersistedPermissionsError?.data && isAuthenticated) {
      return null;
    }
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getSetupErrorRedoURL();
  });
  const errorTroubleshootingLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getErrorTroubleshootingLinkURL({
    code: setupErrorCode
  }));
  let title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error connecting Site Kit', 'google-site-kit');
  let ctaLabel = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Redo the plugin setup', 'google-site-kit');
  if (setupErrorCode === 'access_denied') {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Permissions Error', 'google-site-kit');
    if (temporaryPersistedPermissionsError?.data) {
      ctaLabel = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Grant permission', 'google-site-kit');
    } else if (!temporaryPersistedPermissionsError?.data && isAuthenticated) {
      ctaLabel = null;
    }
  }
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const snapshotCoreFormsStore = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async () => {
    if (temporaryPersistedPermissionsError?.data) {
      // Snapshot `CORE_FORMS` store to ensure the form data with current error data
      // is retained across page navigations.
      await (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_2__.snapshotAllStores)(registry);
    }
  }, [temporaryPersistedPermissionsError, registry]);
  const gaTrackingProps = {
    gaTrackingEventArgs: {
      category: `${viewContext}_${id}`
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Notification, {
    ...gaTrackingProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      title: title,
      type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__.TYPES.ERROR,
      description: setupErrorMessage,
      ctaButton: setupErrorRedoURL && {
        label: ctaLabel,
        href: setupErrorRedoURL,
        onClick: snapshotCoreFormsStore
      },
      learnMoreLink: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit'),
        href: errorTroubleshootingLinkURL
      }
    })
  });
}

/***/ }),

/***/ "./js/components/notifications/SiteKitSetupSuccessNotification.js":
/*!************************************************************************!*\
  !*** ./js/components/notifications/SiteKitSetupSuccessNotification.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SiteKitSetupSuccessNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useQueryArg */ "./js/hooks/useQueryArg.js");
/* harmony import */ var _svg_graphics_banner_site_kit_setup_success_svg_url__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/graphics/banner-site-kit-setup-success.svg?url */ "./svg/graphics/banner-site-kit-setup-success.svg?url");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SiteKitSetupSuccessNotification component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function SiteKitSetupSuccessNotification({
  id,
  Notification
}) {
  const connectMoreServicesURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getConnectMoreServicesURL());
  const [, setNotification] = (0,_js_hooks_useQueryArg__WEBPACK_IMPORTED_MODULE_4__["default"])('notification');
  const onDismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    setNotification(undefined);
  }, [setNotification]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__["default"], {
      notificationID: id,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Congrats on completing the setup for Site Kit!', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Connect more services or edit connected services from the settings screen.', 'google-site-kit'),
      learnMoreLink: {
        href: connectMoreServicesURL,
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Go to Settings', 'google-site-kit'),
        external: false
      },
      dismissButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it!', 'google-site-kit'),
        onClick: onDismiss,
        tertiary: false
      },
      svg: {
        desktop: _svg_graphics_banner_site_kit_setup_success_svg_url__WEBPACK_IMPORTED_MODULE_5__["default"],
        verticalPosition: 'bottom'
      }
    })
  });
}
SiteKitSetupSuccessNotification.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string).isRequired,
  Notification: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().elementType)
};

/***/ }),

/***/ "./js/components/notifications/UnsatisfiedScopesAlert/index.js":
/*!*********************************************************************!*\
  !*** ./js/components/notifications/UnsatisfiedScopesAlert/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UnsatisfiedScopesAlert)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./utils */ "./js/components/notifications/UnsatisfiedScopesAlert/utils.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UnsatisfiedScopesAlert component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











function UnsatisfiedScopesAlert({
  id,
  Notification
}) {
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
  const doingCTARef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useRef)();
  const [inProgressModuleSetup, setInProgressModuleSetup] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
  const isNavigating = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_LOCATION).isNavigatingTo(new RegExp('//oauth2|action=googlesitekit_connect', 'i')));
  const temporaryPersistedPermissionsError = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_8__["default"])(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, 'permissionsError');
  const unsatisfiedScopes = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getUnsatisfiedScopes());
  const modules = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES).getModules());
  const connectURLData = temporaryPersistedPermissionsError?.data ? {
    additionalScopes: temporaryPersistedPermissionsError.data?.scopes,
    redirectURL: temporaryPersistedPermissionsError.data?.redirectURL || __webpack_require__.g.location.href
  } : {
    redirectURL: __webpack_require__.g.location.href
  };
  const connectURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getConnectURL(connectURLData));
  const {
    activateModule
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_MODULES);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_LOCATION);
  const {
    setInternalServerError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE);

  // Fetch the module setup in progress from cache.
  (0,react_use__WEBPACK_IMPORTED_MODULE_12__["default"])(async () => {
    const {
      cacheHit,
      value
    } = await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_2__.getItem)('module_setup');
    if (cacheHit) {
      setInProgressModuleSetup(value);
    }
  });
  const onCTAClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(async () => {
    doingCTARef.current = true;
    setIsSaving(true);
    if (!inProgressModuleSetup) {
      return;
    }
    const {
      error,
      response
    } = await activateModule(inProgressModuleSetup);
    if (!error) {
      navigateTo(response.moduleReauthURL);
    } else {
      setInternalServerError({
        id: 'activate-module-error',
        description: error.message
      });
    }
  }, [activateModule, inProgressModuleSetup, navigateTo, setInternalServerError]);

  // Some external scenarios where we navigate to the OAuth service or connect URL may coincide with a request which populates the
  // list of unsatisfied scopes. In these scenarios we want to avoid showing this banner as the user is already being directed to
  // address the missing scopes. However, we want to ensure we still do show this banner while navigating to the connect URL as a
  // result of its own CTA.
  if (isNavigating && !doingCTARef.current || !unsatisfiedScopes?.length || connectURL === undefined) {
    return null;
  }
  const {
    title,
    message,
    ctaLabel
  } = (0,_utils__WEBPACK_IMPORTED_MODULE_9__.getUnsatisfiedScopesMessage)(unsatisfiedScopes, modules, temporaryPersistedPermissionsError);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_7__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.ERROR,
      title: title,
      description: message,
      ctaButton: {
        label: ctaLabel,
        href: inProgressModuleSetup ? undefined : connectURL,
        onClick: onCTAClick,
        inProgress: isSaving
      }
    })
  });
}

/***/ }),

/***/ "./js/components/notifications/UnsatisfiedScopesAlert/utils.js":
/*!*********************************************************************!*\
  !*** ./js/components/notifications/UnsatisfiedScopesAlert/utils.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getUnsatisfiedScopesMessage: () => (/* binding */ getUnsatisfiedScopesMessage),
/* harmony export */   mapScopesToModuleNames: () => (/* binding */ mapScopesToModuleNames)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_reader_revenue_manager_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/reader-revenue-manager/constants */ "./js/modules/reader-revenue-manager/constants.js");
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * UnsatisfiedScopesAlert utils.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const MESSAGE_MULTIPLE = 'multiple';
const MESSAGE_SINGULAR = 'single';
const MESSAGE_GENERIC = 'generic';

/**
 * Maps unsatisfied scopes to module names.
 *
 * @since 1.39.0
 *
 * @param {Array}  scopes  Array of unsatisfied scopes.
 * @param {Object} modules Object of all modules.
 * @return {Array} Array of module names. If a scope does not map to a module, it is set to `false`.
 */
function mapScopesToModuleNames(scopes, modules) {
  if (modules === undefined) {
    return null;
  }

  // Map of scope IDs to Site Kit module slugs.
  const scopeIDToSlug = {
    siteverification: 'site-verification',
    webmasters: _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_4__.MODULE_SLUG_SEARCH_CONSOLE,
    analytics: _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_ANALYTICS_4,
    subscribewithgoogle: _js_modules_reader_revenue_manager_constants__WEBPACK_IMPORTED_MODULE_3__.MODULE_SLUG_READER_REVENUE_MANAGER
  };
  return scopes
  // Map into an array of matches.
  .map(scope => scope.match(new RegExp('^https://www\\.googleapis\\.com/auth/([a-z]+)')))
  // Map each match into a module slug, if any.
  .map(([, id]) => scopeIDToSlug[id] || id)
  // Map module slugs into module names. If there is no matched module, set to `false`.
  .map(slug => modules[slug]?.name || false);
}

/**
 * Gets the appropriate message for unsatisfied scopes.
 *
 * @since 1.153.0
 *
 * @param {Array}  unsatisfiedScopes                  Array of unsatisfied scopes.
 * @param {Object} modules                            Object of all modules.
 * @param {Object} temporaryPersistedPermissionsError Object of temporary persisted permissions error.
 * @return {Object} An object containing message and ctaLabel.
 */
function getUnsatisfiedScopesMessage(unsatisfiedScopes, modules, temporaryPersistedPermissionsError) {
  let messageID;
  let moduleNames;
  if (
  // Determine if all scopes are in Google API format, otherwise use generic message.
  unsatisfiedScopes.some(scope => !scope.match(new RegExp('^https://www\\.googleapis\\.com/auth/')))) {
    messageID = MESSAGE_GENERIC;
  } else {
    // All scopes are in Google API format, map them to module names.
    moduleNames = mapScopesToModuleNames(unsatisfiedScopes, modules);
    // If any scope did not resolve to a module name, use the generic message.
    if (!moduleNames || moduleNames.some(name => name === false)) {
      messageID = MESSAGE_GENERIC;
    } else {
      moduleNames = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.uniq)(moduleNames);
      messageID = 1 < moduleNames.length ? MESSAGE_MULTIPLE : MESSAGE_SINGULAR;
    }
  }
  const title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Site Kit can’t access necessary data', 'google-site-kit');
  const ctaLabel = temporaryPersistedPermissionsError?.data ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Grant permission', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Redo setup', 'google-site-kit');
  let message;
  switch (messageID) {
    case MESSAGE_MULTIPLE:
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: List of product names */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Site Kit can’t access all relevant data because you haven’t granted all permissions requested during setup. To use Site Kit, you’ll need to redo the setup for: %s – make sure to approve all permissions at the authentication stage.', 'google-site-kit'), (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.listFormat)(moduleNames));
      break;
    case MESSAGE_SINGULAR:
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: Product name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Site Kit can’t access the relevant data from %1$s because you haven’t granted all permissions requested during setup. To use Site Kit, you’ll need to redo the setup for %1$s – make sure to approve all permissions at the authentication stage.', 'google-site-kit'), moduleNames[0]);
      break;
    case MESSAGE_GENERIC:
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Site Kit can’t access all relevant data because you haven’t granted all permissions requested during setup. To use Site Kit, you’ll need to redo the setup – make sure to approve all permissions at the authentication stage.', 'google-site-kit');
      break;
  }
  return {
    title,
    message,
    ctaLabel
  };
}

/***/ }),

/***/ "./js/components/notifications/UnsatisfiedScopesAlertGTE.js":
/*!******************************************************************!*\
  !*** ./js/components/notifications/UnsatisfiedScopesAlertGTE.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UnsatisfiedScopesAlertGTE)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * UnsatisfiedScopesAlertGTE component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function UnsatisfiedScopesAlertGTE({
  id,
  Notification
}) {
  const [isSaving, setIsSaving] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useState)(false);
  const temporaryPersistedPermissionsError = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__["default"])(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, 'permissionsError');
  const connectURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).getConnectURL({
    additionalScopes: [_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.READ_SCOPE],
    redirectURL: temporaryPersistedPermissionsError?.data?.redirectURL || __webpack_require__.g.location.href
  }));
  const googleTagLearnMoreURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getGoogleSupportURL({
    path: '/tagmanager/answer/11994839'
  }));
  if (connectURL === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_5__["default"], {
      notificationID: id,
      type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_2__.TYPES.ERROR,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit needs additional permissions to detect updates to tags on your site', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To continue using Analytics with Site Kit, you need to grant permission to check for any changes in your Google tag’s target Analytics property. The Google tag feature was recently updated to allow users to change a tag’s connected Analytics property without editing site code. Because of this change, Site Kit now must regularly check if the tag on your site matches the Analytics property destination.', 'google-site-kit'),
      learnMoreLink: {
        href: googleTagLearnMoreURL
      },
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Grant permission', 'google-site-kit'),
        href: connectURL,
        inProgress: isSaving,
        onClick: () => setIsSaving(true)
      }
    })
  });
}

/***/ }),

/***/ "./js/components/notifications/ZeroDataNotification.js":
/*!*************************************************************!*\
  !*** ./js/components/notifications/ZeroDataNotification.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ZeroDataNotification)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ZeroDataNotification component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function ZeroDataNotification({
  id,
  Notification
}) {
  const notEnoughTrafficURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getDocumentationLinkURL('not-enough-traffic');
  });
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_NOTIFICATIONS);
  function ctaClick() {
    dismissNotification(id, {
      expiresInSeconds: _js_util__WEBPACK_IMPORTED_MODULE_5__.DAY_IN_SECONDS
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(Notification, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__["default"], {
      notificationID: id,
      type: _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING,
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Not enough traffic yet to display stats', 'google-site-kit'),
      description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit will start showing stats on the dashboard as soon as enough people have visited your site. Keep working on your site to attract more visitors.', 'google-site-kit'),
      learnMoreLink: {
        href: notEnoughTrafficURL
      },
      ctaButton: {
        label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('OK, got it', 'google-site-kit'),
        onClick: ctaClick
      }
    })
  });
}

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-notifications.js":
/*!*******************************************!*\
  !*** ./js/googlesitekit-notifications.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./googlesitekit/notifications */ "./js/googlesitekit/notifications/index.js");
/**
 * Public Notifications API entrypoint.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


(0,_googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_1__.registerStore)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
const Notifications = (0,_googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_1__.createNotifications)((googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default()));
(0,_googlesitekit_notifications__WEBPACK_IMPORTED_MODULE_1__.registerNotifications)(Notifications);
if (typeof __webpack_require__.g.googlesitekit === 'undefined') {
  __webpack_require__.g.googlesitekit = {};
}
__webpack_require__.g.googlesitekit.notifications = Notifications;

// This is only exported for Jest and is not used in production.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notifications);

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.168.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/constants.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ANCHOR_ID_CONTENT: () => (/* binding */ ANCHOR_ID_CONTENT),
/* harmony export */   ANCHOR_ID_KEY_METRICS: () => (/* binding */ ANCHOR_ID_KEY_METRICS),
/* harmony export */   ANCHOR_ID_MONETIZATION: () => (/* binding */ ANCHOR_ID_MONETIZATION),
/* harmony export */   ANCHOR_ID_SPEED: () => (/* binding */ ANCHOR_ID_SPEED),
/* harmony export */   ANCHOR_ID_TRAFFIC: () => (/* binding */ ANCHOR_ID_TRAFFIC),
/* harmony export */   SITE_KIT_VIEW_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_CONTEXTS),
/* harmony export */   SITE_KIT_VIEW_ONLY_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_ONLY_CONTEXTS),
/* harmony export */   VIEW_CONTEXT_ACTIVATION: () => (/* binding */ VIEW_CONTEXT_ACTIVATION),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_AD_BLOCKING_RECOVERY: () => (/* binding */ VIEW_CONTEXT_AD_BLOCKING_RECOVERY),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_KEY_METRICS_SETUP: () => (/* binding */ VIEW_CONTEXT_KEY_METRICS_SETUP),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_METRIC_SELECTION: () => (/* binding */ VIEW_CONTEXT_METRIC_SELECTION),
/* harmony export */   VIEW_CONTEXT_MODULE: () => (/* binding */ VIEW_CONTEXT_MODULE),
/* harmony export */   VIEW_CONTEXT_MODULE_SETUP: () => (/* binding */ VIEW_CONTEXT_MODULE_SETUP),
/* harmony export */   VIEW_CONTEXT_POSTS_LIST: () => (/* binding */ VIEW_CONTEXT_POSTS_LIST),
/* harmony export */   VIEW_CONTEXT_SETTINGS: () => (/* binding */ VIEW_CONTEXT_SETTINGS),
/* harmony export */   VIEW_CONTEXT_SPLASH: () => (/* binding */ VIEW_CONTEXT_SPLASH),
/* harmony export */   VIEW_CONTEXT_USER_INPUT: () => (/* binding */ VIEW_CONTEXT_USER_INPUT),
/* harmony export */   VIEW_CONTEXT_WP_BLOCK_EDITOR: () => (/* binding */ VIEW_CONTEXT_WP_BLOCK_EDITOR),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY)
/* harmony export */ });
/**
 * Core constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const VIEW_CONTEXT_MAIN_DASHBOARD = 'mainDashboard';
const VIEW_CONTEXT_ENTITY_DASHBOARD = 'entityDashboard';
const VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY = 'mainDashboardViewOnly';
const VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY = 'entityDashboardViewOnly';
const VIEW_CONTEXT_POSTS_LIST = 'postsList';
const VIEW_CONTEXT_USER_INPUT = 'userInput';
const VIEW_CONTEXT_ACTIVATION = 'activation';
const VIEW_CONTEXT_SPLASH = 'splash';
const VIEW_CONTEXT_ADMIN_BAR = 'adminBar';
const VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY = 'adminBarViewOnly';
const VIEW_CONTEXT_SETTINGS = 'settings';
const VIEW_CONTEXT_AD_BLOCKING_RECOVERY = 'adBlockingRecovery';
const VIEW_CONTEXT_MODULE = 'module';
const VIEW_CONTEXT_WP_DASHBOARD = 'wpDashboard';
const VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY = 'wpDashboardViewOnly';
const VIEW_CONTEXT_MODULE_SETUP = 'moduleSetup';
const VIEW_CONTEXT_METRIC_SELECTION = 'metricSelection';
const VIEW_CONTEXT_WP_BLOCK_EDITOR = 'wpBlockEditor';
const VIEW_CONTEXT_KEY_METRICS_SETUP = 'keyMetricsSetup';

// Anchor ID Constants
const ANCHOR_ID_KEY_METRICS = 'key-metrics';
const ANCHOR_ID_TRAFFIC = 'traffic';
const ANCHOR_ID_CONTENT = 'content';
const ANCHOR_ID_SPEED = 'speed';
const ANCHOR_ID_MONETIZATION = 'monetization';

// Site Kit only view contexts
const SITE_KIT_VIEW_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD, VIEW_CONTEXT_ENTITY_DASHBOARD, VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_USER_INPUT, VIEW_CONTEXT_SPLASH, VIEW_CONTEXT_SETTINGS, VIEW_CONTEXT_MODULE_SETUP, VIEW_CONTEXT_METRIC_SELECTION];

// Site Kit view-only contexts
const SITE_KIT_VIEW_ONLY_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY, VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/data-requirements/index.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/data-requirements/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   requireAudienceSegmentationWidgetHidden: () => (/* binding */ requireAudienceSegmentationWidgetHidden),
/* harmony export */   requireCanActivateModule: () => (/* binding */ requireCanActivateModule),
/* harmony export */   requireCanViewSharedModule: () => (/* binding */ requireCanViewSharedModule),
/* harmony export */   requireIsAuthenticated: () => (/* binding */ requireIsAuthenticated),
/* harmony export */   requireItemDismissed: () => (/* binding */ requireItemDismissed),
/* harmony export */   requireModuleAccess: () => (/* binding */ requireModuleAccess),
/* harmony export */   requireModuleActive: () => (/* binding */ requireModuleActive),
/* harmony export */   requireModuleConnected: () => (/* binding */ requireModuleConnected),
/* harmony export */   requireModuleGatheringData: () => (/* binding */ requireModuleGatheringData),
/* harmony export */   requireModuleOwnership: () => (/* binding */ requireModuleOwnership),
/* harmony export */   requireScope: () => (/* binding */ requireScope)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




/**
 * Returns a function that checks if the current user has the given scope.
 *
 * @since 1.166.0
 *
 * @param {string} scope Scope to check.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the current user has the given scope.
 */
function requireScope(scope) {
  return async ({
    select,
    resolveSelect
  }) => {
    await resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getAuthentication();
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).hasScope(scope);
  };
}

/**
 * Returns a function that checks if the current user is authenticated.
 *
 * @since 1.166.0
 *
 * @return {function(WPDataRegistry): Promise<boolean>} Whether or not the current user is authenticated.
 */
function requireIsAuthenticated() {
  return async ({
    select,
    resolveSelect
  }) => {
    await resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getAuthentication();
    return true === select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isAuthenticated();
  };
}

/**
 * Returns a function that checks if the current user can view the given shared module.
 *
 * @since 1.166.0
 *
 * @param {string} slug Module slug to test.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the current user can view the given shared module.
 */
function requireCanViewSharedModule(slug) {
  return async ({
    select,
    resolveSelect
  }) => {
    await resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getCapabilities();
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).canViewSharedModule(slug);
  };
}

/**
 * Returns a function that checks if the given module is active.
 *
 * @since n.e.x.t
 *
 * @param {string} slug Module slug to test.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the given module is active or not.
 */
function requireModuleActive(slug) {
  return async function ({
    resolveSelect
  }) {
    return true === (await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).isModuleActive(slug));
  };
}

/**
 * Returns a function that checks if the given module is connected.
 *
 * @since 1.166.0
 *
 * @param {string} slug Module slug to test.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the given module is connected or not.
 */
function requireModuleConnected(slug) {
  return async function ({
    resolveSelect
  }) {
    return true === (await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).isModuleConnected(slug));
  };
}

/**
 * Returns a function that checks if the current user is the owner of the given module.
 *
 * @since 1.166.0
 *
 * @param {string} slug Module slug to test.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the given module is owned by the current user or not.
 */
function requireModuleOwnership(slug) {
  return async ({
    resolveSelect
  }) => true === (await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).hasModuleOwnership(slug));
}

/**
 * Returns a function that checks if the current user has access to the given module.
 *
 * @since 1.166.0
 *
 * @param {string} slug Module slug to test.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the current user has access to the given module or not.
 */
function requireModuleAccess(slug) {
  return async ({
    resolveSelect
  }) => true === (await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).hasModuleAccess(slug));
}

/**
 * Returns a function that checks if the given item is dismissed.
 *
 * @since 1.166.0
 *
 * @param {string} item Dismissible item ID.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the given item is dismissed or not.
 */
function requireItemDismissed(item) {
  return async ({
    resolveSelect
  }) => true === (await resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isItemDismissed(item));
}

/**
 * Returns a function that checks if the audience segmentation widget is hidden.
 *
 * @since 1.166.0
 *
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the widget is hidden or not.
 */
function requireAudienceSegmentationWidgetHidden() {
  return async ({
    select,
    resolveSelect
  }) => {
    await resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getUserAudienceSettings();
    return true === select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isAudienceSegmentationWidgetHidden();
  };
}

/**
 * Returns a function that checks if the given module'sdatastore is gathering data.
 *
 * @since n.e.x.t
 *
 * @param {string} datastoreSlug Datastore slug to test.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the given datastore is gathering data or not.
 */
function requireModuleGatheringData(datastoreSlug) {
  return async ({
    resolveSelect
  }) => true === (await resolveSelect(datastoreSlug).isGatheringData());
}

/**
 * Returns a function that checks if the current user can activate the given module.
 *
 * @since n.e.x.t
 *
 * @param {string} slug Module slug to test.
 * @return {function(WPDataRegistry): Promise<boolean>} Whether the current user can activate the given module or not.
 */
function requireCanActivateModule(slug) {
  return async ({
    resolveSelect
  }) => true === (await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).canActivateModule(slug));
}

/***/ }),

/***/ "./js/googlesitekit/data/create-snapshot-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-snapshot-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSnapshotStore: () => (/* binding */ createSnapshotStore),
/* harmony export */   getStoresWithSnapshots: () => (/* binding */ getStoresWithSnapshots),
/* harmony export */   restoreAllSnapshots: () => (/* binding */ restoreAllSnapshots),
/* harmony export */   snapshotAllStores: () => (/* binding */ snapshotAllStores)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Provides a datastore for snapshotting and restoring state.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




// Actions
const CREATE_SNAPSHOT = 'CREATE_SNAPSHOT';
const DELETE_SNAPSHOT = 'DELETE_SNAPSHOT';
const RESTORE_SNAPSHOT = 'RESTORE_SNAPSHOT';
const SET_STATE_FROM_SNAPSHOT = 'SET_STATE_FROM_SNAPSHOT';

/**
 * Creates a store object that includes actions and controls for restoring/creating state snapshots.
 *
 * @since 1.9.0
 * @since 1.163.0 Added the ability to pick specific parts of the state to save in the snapshot.
 * @private
 *
 * @param {string}          storeName                The name of the store to snapshot in the cache.
 * @param {Object}          [options]                Optional configuration object.
 * @param {string|string[]} [options.keysToSnapshot] Property path(s) to pick from state when creating snapshots.
 * @return {Object} The snapshot store object.
 */
function createSnapshotStore(storeName, {
  keysToSnapshot
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required to create a snapshot store.');
  const initialState = {};
  const actions = {
    /**
     * Deletes a snapshot of state for a storeName, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache deletion response.
     */
    *deleteSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: DELETE_SNAPSHOT
      };
      return cacheResult;
    },
    /**
     * Restores a snapshot of state for a storeName, if available, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @param {Object}  [options]                   Options object.
     * @param {boolean} [options.clearAfterRestore] Whether or not to delete snapshot after restore. Default: true.
     * @return {boolean} Cache restoration response.
     */
    *restoreSnapshot(options = {}) {
      const {
        clearAfterRestore = true
      } = options;
      const {
        cacheHit,
        value
      } = yield {
        payload: {},
        type: RESTORE_SNAPSHOT
      };
      if (cacheHit) {
        yield {
          payload: {
            snapshot: value
          },
          type: SET_STATE_FROM_SNAPSHOT
        };
        if (clearAfterRestore) {
          yield {
            payload: {},
            type: DELETE_SNAPSHOT
          };
        }
      }
      return cacheHit;
    },
    /**
     * Creates a snapshot of the current state of this store, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache write response.
     */
    *createSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: CREATE_SNAPSHOT
      };
      return cacheResult;
    }
  };
  const controls = {
    [DELETE_SNAPSHOT]: () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.deleteItem)(`datastore::cache::${storeName}`);
    },
    [CREATE_SNAPSHOT]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistryControl)(registry => () => {
      const state = registry.stores[storeName].store.getState();
      const stateToSnapshot = keysToSnapshot?.length > 0 ? (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(state, keysToSnapshot) : state;
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.setItem)(`datastore::cache::${storeName}`, stateToSnapshot);
    }),
    [RESTORE_SNAPSHOT]: () => {
      // Only get snapshots made within the last hour.
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.getItem)(`datastore::cache::${storeName}`, _js_util__WEBPACK_IMPORTED_MODULE_4__.HOUR_IN_SECONDS);
    }
  };
  function reducer(state = initialState, {
    type,
    payload
  }) {
    // eslint-disable-line no-shadow
    switch (type) {
      case SET_STATE_FROM_SNAPSHOT:
        {
          const {
            snapshot
          } = payload;
          // Exclude any top-level errors from the restored state.
          // eslint-disable-next-line no-unused-vars
          const {
            error,
            ...newState
          } = snapshot;

          // If only a part of the state has been added to the snapshot, then
          // we should update the initial state with partial data restored
          // from the snapshot.
          if (keysToSnapshot?.length > 0) {
            return {
              ...state,
              ...newState
            };
          }
          return newState;
        }
      default:
        {
          return state;
        }
    }
  }
  return {
    initialState,
    actions,
    controls,
    reducer
  };
}

/**
 * Inspects a registry to find all stores that support our snapshot features.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} registry Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Object} The snapshot store object.
 */
function getStoresWithSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Object.values(registry.stores).filter(store => {
    return Object.keys(store.getActions()).includes('restoreSnapshot');
  });
}

/**
 * Creates snapshots of all supporting stores.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been taken.
 */
function snapshotAllStores(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().createSnapshot();
  }));
}

/**
 * Restores state for all snapshots that support it.
 *
 * Only restores snapshots for stores that have `restoreSnapshot` action, and
 * clears the snapshot afterward, so more stores will not be restored unless
 * a snapshot was saved on the last pageview.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been restored.
 */
function restoreAllSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().restoreSnapshot();
  }));
}

/***/ }),

/***/ "./js/googlesitekit/data/utils.js":
/*!****************************************!*\
  !*** ./js/googlesitekit/data/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   collect: () => (/* binding */ collect),
/* harmony export */   collectActions: () => (/* binding */ collectActions),
/* harmony export */   collectControls: () => (/* binding */ collectControls),
/* harmony export */   collectName: () => (/* binding */ collectName),
/* harmony export */   collectReducers: () => (/* binding */ collectReducers),
/* harmony export */   collectResolvers: () => (/* binding */ collectResolvers),
/* harmony export */   collectSelectors: () => (/* binding */ collectSelectors),
/* harmony export */   collectState: () => (/* binding */ collectState),
/* harmony export */   combineStores: () => (/* binding */ combineStores),
/* harmony export */   commonActions: () => (/* binding */ commonActions),
/* harmony export */   commonControls: () => (/* binding */ commonControls),
/* harmony export */   commonStore: () => (/* binding */ commonStore),
/* harmony export */   createStrictSelect: () => (/* binding */ createStrictSelect),
/* harmony export */   createValidatedAction: () => (/* binding */ createValidatedAction),
/* harmony export */   createValidationSelector: () => (/* binding */ createValidationSelector)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/factory.js");
/**
 * Data store utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */

const GET_REGISTRY = 'GET_REGISTRY';
const AWAIT = 'AWAIT';

/**
 * Collects and combines multiple objects of similar shape.
 *
 * Used to combine objects like actions, selectors, etc. for a data
 * store while ensuring no keys/action names/selector names are duplicated.
 *
 * Effectively this is an object spread, but throws an error if keys are
 * duplicated.
 *
 * @since 1.5.0
 * @private
 *
 * @param {...Object} items A list of arguments, each one should be an object to combine into one.
 * @return {Object} The combined object.
 */
function collect(...items) {
  const collectedObject = items.reduce((acc, item) => {
    return {
      ...acc,
      ...item
    };
  }, {});
  const functionNames = items.reduce((acc, itemSet) => {
    return [...acc, ...Object.keys(itemSet)];
  }, []);
  const duplicates = findDuplicates(functionNames);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === 0, `collect() cannot accept collections with duplicate keys. Your call to collect() contains the following duplicated functions: ${duplicates.join(', ')}. Check your data stores for duplicates.`);
  return collectedObject;
}

/**
 * Collects all actions.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own actions.
 * @return {Object} The combined object.
 */
const collectActions = collect;

/**
 * Collects all controls.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own controls.
 * @return {Object} The combined object.
 */
const collectControls = collect;

/**
 * Collects all reducers and (optionally) provides initial state.
 *
 * If the first argument passed is not a function, it will be used as the
 * combined reducer's `initialState`.
 *
 * @since 1.5.0
 *
 * @param {...(Object|Function)} args A list of reducers, each containing their own controls. If the first argument is not a function, it will be used as the combined reducer's `initialState`.
 * @return {Function} A Redux-style reducer.
 */
function collectReducers(...args) {
  const reducers = [...args];
  let initialState;
  if (typeof reducers[0] !== 'function') {
    initialState = reducers.shift();
  }
  return (state = initialState, action = {}) => {
    return reducers.reduce((newState, reducer) => {
      return reducer(newState, action);
    }, state);
  };
}

/**
 * Collects all resolvers.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own resolvers.
 * @return {Object} The combined object.
 */
const collectResolvers = collect;

/**
 * Collects all selectors.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own selectors.
 * @return {Object} The combined object.
 */
const collectSelectors = collect;

/**
 * Collects all state values.
 *
 * @since 1.5.0
 *
 * @param {...Object} args A list of objects, each containing their own state values.
 * @return {Object} The combined object.
 */
const collectState = collect;

/**
 * Collects all store names.
 *
 * This function's main purpose is to ensure generated store names for a single store match.
 *
 * @since 1.6.0
 *
 * @param {...string} args A list of store names, all of which must be equal.
 * @return {string} The single store name.
 */
function collectName(...args) {
  const names = [...args];
  const duplicates = findDuplicates(names);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(duplicates.length === names.length - 1, 'collectName() must not receive different names.');
  return names.shift();
}

/**
 * Passes through state unmodified; eg. an empty reducer.
 *
 * @since 1.8.0
 * @private
 *
 * @param {Object} state A store's state.
 * @return {Object} The same state data as passed in `state`.
 */
function passthroughReducer(state) {
  return state;
}

/**
 * Combines multiple stores.
 *
 * @since 1.8.0
 *
 * @param {...Object} stores A list of objects, each a store containing one or more of the following keys: initialState, actions, controls, reducer, resolvers, selectors.
 * @return {Object} The combined store.
 */
function combineStores(...stores) {
  const combinedInitialState = collectState(...stores.map(store => store.initialState || {}));
  return {
    initialState: combinedInitialState,
    controls: collectControls(...stores.map(store => store.controls || {})),
    actions: collectActions(...stores.map(store => store.actions || {})),
    reducer: collectReducers(combinedInitialState, ...stores.map(store => store.reducer || passthroughReducer)),
    resolvers: collectResolvers(...stores.map(store => store.resolvers || {})),
    selectors: collectSelectors(...stores.map(store => store.selectors || {}))
  };
}

/**
 * An object of common actions most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common actions most stores will want.
 */
const commonActions = {
  /**
   * Dispatches an action and calls a control to get the current data registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  getRegistry() {
    return {
      payload: {},
      type: GET_REGISTRY
    };
  },
  /**
   * Dispatches an action and calls a control to return the promise resolution.
   *
   * Useful for controls and resolvers that wish to call an asynchronous function or other promise.
   *
   * @since 1.22.0
   *
   * @param {Promise} value A promise to resolve.
   * @return {Object} Object with resolved promise.
   */
  *await(value) {
    return {
      payload: {
        value
      },
      type: AWAIT
    };
  }
};

/**
 * An object of common controls most stores will use.
 *
 * @since 1.7.0
 *
 * @return {Object} Key/value list of common controls most stores will want.
 */
const commonControls = {
  /**
   * Returns the current registry.
   *
   * Useful for controls and resolvers that wish to dispatch actions/use selectors
   * on the current data registry.
   *
   * @since 1.7.0
   *
   * @return {Object} FSA-compatible action.
   */
  [GET_REGISTRY]: (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistryControl)(registry => () => registry),
  /**
   * Returns a resolved promise.
   *
   * @since 1.22.0
   *
   * @param {Object} payload         Object containing a promise.
   * @param {Object} payload.payload Object containing a promise.
   * @return {*} Resolved promise.
   */
  [AWAIT]: ({
    payload
  }) => payload.value
};

/**
 * Finds all duplicate items in an array and return them.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} array Any array.
 * @return {Array} All values in the input array that were duplicated.
 */
function findDuplicates(array) {
  const duplicates = [];
  const counts = {};
  for (let i = 0; i < array.length; i++) {
    const item = array[i];
    counts[item] = counts[item] >= 1 ? counts[item] + 1 : 1;
    if (counts[item] > 1) {
      duplicates.push(item);
    }
  }
  return duplicates;
}

/**
 * A store containing the common actions, controls and reducer that all stores will use.
 *
 * @since 1.8.0
 *
 * @return {Object} Object with common actions, controls and reducer.
 */
const commonStore = {
  actions: commonActions,
  controls: commonControls,
  reducer: passthroughReducer
};

/**
 * Creates a strict version of registry.select for ensuring that a selector is resolved at the time of calling.
 *
 * Not intended to be used directly. This is useful in the context of validation functions
 * to save checking for undefined on every result.
 *
 * Given the registry.select function instance, a new function is returned
 * with the same API as `select()` but will throw an error if the result
 * of the selector function is `undefined`.
 *
 * Ideally this would use something like `hasFinishedResolution` instead,
 * but there is no way to traverse the selectors used internally to identify
 * dependent selectors that have resolvers as many selectors are composed of
 * higher-level selectors internally which is where a resolver is normally implemented.
 *
 * @since 1.18.0
 * @private
 *
 * @param {Function} select The registry.select function.
 * @return {Function} The strict version of registry.select.
 */
function createStrictSelect(select) {
  return storeName => {
    return getStrictSelectors(select(storeName));
  };
}

// Based on {@link https://github.com/WordPress/gutenberg/blob/b1c8026087dfb026eff0a023a5f7febe28c876de/packages/data/src/registry.js#L91}
const getStrictSelectors = memize__WEBPACK_IMPORTED_MODULE_2___default()(selectors => (0,lodash__WEBPACK_IMPORTED_MODULE_1__.mapValues)(selectors, (selector, selectorName) => (...args) => {
  const returnValue = selector(...args);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(returnValue !== undefined, `${selectorName}(...) is not resolved`);
  return returnValue;
}));

/**
 * Creates two registry selectors that call the incoming function to validate the current state.
 *
 * @since 1.19.0
 *
 * @param {Function} validate         Validation function callback.
 * @param {Object}   [options]        Options to modify the behavior of the generated selectors.
 * @param {boolean}  [options.negate] Whether to negate the boolean result or not. Default: false.
 * @return {Object} Safe and dangerous selectors.
 */
function createValidationSelector(validate, {
  negate = false
} = {}) {
  const safeSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    const pass = negate ? false : true;
    const fail = negate ? true : false;
    try {
      validate(select, state, ...args);
      return pass;
    } catch {
      return fail;
    }
  });
  const dangerousSelector = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.createRegistrySelector)(select => (state, ...args) => {
    validate(select, state, ...args);
  });
  return {
    safeSelector,
    dangerousSelector
  };
}

/**
 * Creates a validated action creator.
 *
 * @since 1.32.0
 *
 * @param {Function} validate      A function for validating action arguments.
 * @param {Function} actionCreator A function for returning or yielding redux-style actions.
 * @return {Function} An enhanced action creator.
 */
function createValidatedAction(validate, actionCreator) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof validate === 'function', 'a validator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(typeof actionCreator === 'function', 'an action creator function is required.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(validate[Symbol.toStringTag] !== 'Generator' && validate[Symbol.toStringTag] !== 'GeneratorFunction', 'an action’s validator function must not be a generator.');
  return (...args) => {
    validate(...args);
    return actionCreator(...args);
  };
}

/***/ }),

/***/ "./js/googlesitekit/datastore/forms/constants.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/datastore/forms/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_FORMS: () => (/* binding */ CORE_FORMS)
/* harmony export */ });
/**
 * `core/forms` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_FORMS = 'core/forms';

/***/ }),

/***/ "./js/googlesitekit/datastore/location/constants.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/datastore/location/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_LOCATION: () => (/* binding */ CORE_LOCATION)
/* harmony export */ });
/**
 * `core/location` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_LOCATION = 'core/location';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVE_CONTEXT_ID: () => (/* binding */ ACTIVE_CONTEXT_ID),
/* harmony export */   CORE_UI: () => (/* binding */ CORE_UI)
/* harmony export */ });
/**
 * `core/ui` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_UI = 'core/ui';
const ACTIVE_CONTEXT_ID = 'activeContextID';

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   EMAIL_REPORT_FREQUENCIES: () => (/* binding */ EMAIL_REPORT_FREQUENCIES),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Email Report Frequency options.
const EMAIL_REPORT_FREQUENCIES = ['weekly', 'monthly', 'quarterly'];

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/BannerNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/BannerNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES),
/* harmony export */   "default": () => (/* binding */ BannerNotification)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Banner/CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Banner/DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _svg_graphics_banner_error_svg_url__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/svg/graphics/banner-error.svg?url */ "./svg/graphics/banner-error.svg?url");
/* harmony import */ var _svg_graphics_banner_warning_svg_url__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/graphics/banner-warning.svg?url */ "./svg/graphics/banner-warning.svg?url");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * BannerNotification layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */











const TYPES = {
  INFO: 'info',
  ERROR: 'error',
  WARNING: 'warning'
};
function BannerNotification({
  notificationID,
  type = TYPES.INFO,
  learnMoreLink,
  dismissButton,
  ctaButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_7__["default"])(notificationID, gaTrackingEventArgs?.category);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton?.dismissOptions
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  async function handleLearnMoreClickWithTrackEvent(event) {
    trackEvents.clickLearnMore(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await learnMoreLink?.onClick?.(event);
  }
  let SVGData = props?.svg;
  if (!SVGData && type !== TYPES.INFO) {
    SVGData = {
      desktop: undefined,
      mobile: undefined,
      verticalPosition: 'center'
    };
    if (type === TYPES.WARNING) {
      SVGData.desktop = _svg_graphics_banner_warning_svg_url__WEBPACK_IMPORTED_MODULE_10__["default"];
    }
    if (type === TYPES.ERROR) {
      SVGData.desktop = _svg_graphics_banner_error_svg_url__WEBPACK_IMPORTED_MODULE_9__["default"];
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner-notification', `googlesitekit-banner-notification--${type}`),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
      className: "googlesitekit-page-content",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
          size: 12,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Banner__WEBPACK_IMPORTED_MODULE_2__["default"], {
            learnMoreLink: learnMoreLink && {
              ...learnMoreLink,
              onClick: handleLearnMoreClickWithTrackEvent
            },
            dismissButton: dismissButton && {
              ...dismissButton,
              onClick: handleDismissWithTrackEvent
            },
            ctaButton: ctaButton && {
              ...ctaButton,
              onClick: handleCTAClickWithTrackEvent
            },
            svg: SVGData,
            ...props
          })
        })
      })
    })
  });
}
BannerNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string).isRequired,
  type: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOf(Object.values(TYPES)),
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_3__["default"].propTypes),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number)
  })
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/NoticeNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/NoticeNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NoticeNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






function NoticeNotification({
  notificationID,
  children,
  dismissButton,
  ctaButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(notificationID);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...(dismissButton?.dismissOptions || {})
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Grid, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Row, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_4__.Cell, {
        size: 12,
        alignMiddle: true,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_1__["default"], {
          dismissButton: {
            ...dismissButton,
            onClick: handleDismissWithTrackEvent
          },
          ctaButton: {
            ...ctaButton,
            onClick: handleCTAClickWithTrackEvent
          },
          ...props,
          children: children
        })
      })
    })
  });
}
NoticeNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().node),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_6___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)]),
  ctaButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object),
  gaTrackingEventArgs: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/OverlayNotification.js":
/*!*********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/OverlayNotification.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OverlayNotification)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_OverlayCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/OverlayCard */ "./js/components/OverlayCard/index.js");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * OverlayNotification layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





function OverlayNotification({
  notificationID,
  ctaButton,
  dismissButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_3__["default"])(notificationID, gaTrackingEventArgs?.category, {
    confirmAction: gaTrackingEventArgs?.confirmAction,
    dismissAction: gaTrackingEventArgs?.dismissAction
  });
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton.dismissOptions
    });
  }
  const {
    dismissOnClick,
    dismissOptions,
    ...otherCTAProps
  } = ctaButton || {};
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (dismissOnClick) {
      dismissNotification(notificationID, {
        ...dismissOptions
      });
    }
  }
  const overlayCTAButton = ctaButton ? {
    ...otherCTAProps,
    onClick: handleCTAClickWithTrackEvent
  } : undefined;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_OverlayCard__WEBPACK_IMPORTED_MODULE_1__["default"], {
    ctaButton: overlayCTAButton,
    dismissButton: {
      ...dismissButton,
      onClick: handleDismissWithTrackEvent
    },
    ...props,
    visible: true
  });
}
OverlayNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaButton: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)])
};

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/SetupCTA.js":
/*!**********************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/SetupCTA.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupCTA)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Banner/CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Banner/DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupCTA layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function SetupCTA({
  notificationID,
  title,
  description,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  footer,
  gaTrackingEventArgs,
  waitingProgress,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_8__["default"])(notificationID, gaTrackingEventArgs?.category);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton?.dismissOptions
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  async function handleLearnMoreClickWithTrackEvent(event) {
    trackEvents.clickLearnMore(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await learnMoreLink?.onClick?.(event);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [!!waitingProgress && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, {
      className: "googlesitekit-banner__progress-bar",
      ...waitingProgress
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-widget-context', {
        'googlesitekit-widget-context--with-progress-bar': !!waitingProgress
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_9__.Grid, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_9__.Row, {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_9__.Cell, {
            size: 12,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Banner__WEBPACK_IMPORTED_MODULE_3__["default"], {
              className: "googlesitekit-banner--setup-cta",
              title: title,
              description: description,
              errorText: errorText,
              helpText: helpText,
              learnMoreLink: learnMoreLink && {
                ...learnMoreLink,
                onClick: handleLearnMoreClickWithTrackEvent
              },
              dismissButton: dismissButton && {
                ...dismissButton,
                onClick: handleDismissWithTrackEvent
              },
              ctaButton: ctaButton && {
                ...ctaButton,
                onClick: handleCTAClickWithTrackEvent
              },
              svg: svg,
              footer: footer,
              ...props
            })
          })
        })
      })
    })]
  });
}
SetupCTA.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_6__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number)
  }),
  waitingProgress: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar.propTypes)
};

/***/ }),

/***/ "./js/googlesitekit/notifications/constants.js":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/notifications/constants.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID: () => (/* binding */ GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID),
/* harmony export */   GTG_SETUP_CTA_BANNER_NOTIFICATION: () => (/* binding */ GTG_SETUP_CTA_BANNER_NOTIFICATION),
/* harmony export */   NOTIFICATION_AREAS: () => (/* binding */ NOTIFICATION_AREAS),
/* harmony export */   NOTIFICATION_GROUPS: () => (/* binding */ NOTIFICATION_GROUPS),
/* harmony export */   PRIORITY: () => (/* binding */ PRIORITY)
/* harmony export */ });
/**
 * Notifications API constants.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID = 'warning-notification-gtg';
const GTG_SETUP_CTA_BANNER_NOTIFICATION = 'gtg-setup-cta';
const PRIORITY = {
  ERROR_HIGH: 30,
  ERROR_LOW: 60,
  WARNING: 100,
  INFO: 150,
  SETUP_CTA_HIGH: 150,
  SETUP_CTA_LOW: 200
};
const NOTIFICATION_AREAS = {
  HEADER: 'notification-area-header',
  DASHBOARD_TOP: 'notification-area-dashboard-top',
  OVERLAYS: 'notification-area-overlays'
};
const NOTIFICATION_GROUPS = {
  DEFAULT: 'default',
  SETUP_CTAS: 'setup-ctas'
};

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/constants.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/constants.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_NOTIFICATIONS: () => (/* binding */ CORE_NOTIFICATIONS),
/* harmony export */   NOTIFICATION_VIEW_CONTEXTS: () => (/* binding */ NOTIFICATION_VIEW_CONTEXTS)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const CORE_NOTIFICATIONS = 'core/notifications';
const NOTIFICATION_VIEW_CONTEXTS = [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_SPLASH, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/index.js":
/*!***********************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   registerStore: () => (/* binding */ registerStore)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _notifications__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./notifications */ "./js/googlesitekit/notifications/datastore/notifications.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



const store = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.combineStores)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.commonStore, _notifications__WEBPACK_IMPORTED_MODULE_2__["default"]);
function registerStore(registry) {
  registry.registerStore(_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_NOTIFICATIONS, store);
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (store);

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/notifications.js":
/*!*******************************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/notifications.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   controls: () => (/* binding */ controls),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   initialState: () => (/* binding */ initialState),
/* harmony export */   reducer: () => (/* binding */ reducer),
/* harmony export */   resolvers: () => (/* binding */ resolvers),
/* harmony export */   selectors: () => (/* binding */ selectors)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/data/utils */ "./js/googlesitekit/data/utils.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/notifications/constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_util_shouldNotificationBeAddedToQueue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/notifications/util/shouldNotificationBeAddedToQueue */ "./js/googlesitekit/notifications/util/shouldNotificationBeAddedToQueue.js");
/* harmony import */ var _js_util_async__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/async */ "./js/util/async.js");
/* harmony import */ var _js_util_storage__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util/storage */ "./js/util/storage.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/**
 * `core/notifications` data store: notifications info.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */








const INSERT_NOTIFICATION_INTO_RESOLVED_QUEUE = 'INSERT_NOTIFICATION_INTO_RESOLVED_QUEUE';
const REGISTER_NOTIFICATION = 'REGISTER_NOTIFICATION';
const RECEIVE_QUEUED_NOTIFICATIONS = 'RECEIVE_QUEUED_NOTIFICATIONS';
const DISMISS_NOTIFICATION = 'DISMISS_NOTIFICATION';
const QUEUE_NOTIFICATION = 'QUEUE_NOTIFICATION';
const RESET_QUEUE = 'RESET_QUEUE';
const MARK_NOTIFICATION_SEEN = 'MARK_NOTIFICATION_SEEN';
const PIN_NOTIFICATION = 'PIN_NOTIFICATION';
const UNPIN_NOTIFICATION = 'UNPIN_NOTIFICATION';
// Controls.
const POPULATE_QUEUE = 'POPULATE_QUEUE';
const PERSIST_SEEN_NOTIFICATIONS = 'PERSIST_SEEN_NOTIFICATIONS';
const PERSIST_PINNED_NOTIFICATIONS = 'PERSIST_PINNED_NOTIFICATIONS';
const NOTIFICATION_SEEN_STORAGE_KEY = 'googlesitekit_notification_seen';
const NOTIFICATION_PINNED_STORAGE_KEY = 'googlesitekit_notification_pinned';
const storage = (0,_js_util_storage__WEBPACK_IMPORTED_MODULE_7__.getStorage)();
function isValidNotificationID(notificationID) {
  return 'string' === typeof notificationID;
}
const initialState = {
  notifications: {},
  queuedNotifications: {},
  seenNotifications: JSON.parse(storage.getItem(NOTIFICATION_SEEN_STORAGE_KEY) || '{}'),
  pinnedNotification: JSON.parse(storage.getItem(NOTIFICATION_PINNED_STORAGE_KEY) || '{}')
};
const actions = {
  /**
   * Adds a notification to the queue of notifications, used when the queue
   * is already resolved.
   *
   * This action is internal and should not be used directly outside of the
   * `registerNotification()` action.
   *
   * @since 1.155.0
   * @private
   *
   * @param {string} id Notification's slug/ID.
   * @return {Object} Redux-style action.
   */
  insertNotificationIntoResolvedQueue(id) {
    return {
      payload: {
        id
      },
      type: INSERT_NOTIFICATION_INTO_RESOLVED_QUEUE
    };
  },
  /**
   * Registers a notification with a given `id` slug and settings.
   *
   * @since 1.132.0
   * @since 1.146.0 Added `featureFlag` parameter.
   * @since 1.155.0 Changed to a generator function to allow for state interaction.
   *
   * @param {string}         id                           Notification's slug.
   * @param {Object}         settings                     Notification's settings.
   * @param {WPComponent}    [settings.Component]         React component used to display the contents of this notification.
   * @param {number}         [settings.priority]          Notification's priority for ordering (lower number is higher priority, like WordPress hooks). Ideally in increments of 10. Default 10.
   * @param {string}         [settings.areaSlug]          The slug of the area where the notification should be rendered, e.g. notification-area-banners-above-nav.
   * @param {string}         [settings.groupID]           Optional. The ID of the group of notifications that should be rendered in their own individual queue. Default 'default'.
   * @param {Array.<string>} [settings.viewContexts]      Optional. Array of Site Kit contexts, e.g. VIEW_CONTEXT_MAIN_DASHBOARD.
   * @param {Function}       [settings.checkRequirements] Optional. Callback function to determine if the notification should be queued.
   * @param {boolean}        [settings.isDismissible]     Optional. Flag to check if the notification should be queued and is not dismissed.
   * @param {number}         [settings.dismissRetries]    Optional. An integer number denoting how many times a notification should be shown again on dismissal. Default 0.
   * @param {string}         [settings.featureFlag]       Optional. Feature flag that must be enabled to register the notification.
   */
  registerNotification: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_2__.createValidatedAction)((id, {
    Component,
    areaSlug,
    viewContexts
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(Component, 'Component is required to register a notification.');
    const notificationAreas = Object.values(_js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_4__.NOTIFICATION_AREAS);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(notificationAreas.includes(areaSlug), `Notification area should be one of: ${notificationAreas.join(', ')}, but "${areaSlug}" was provided.`);
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(viewContexts === undefined || Array.isArray(viewContexts) && viewContexts.some(_constants__WEBPACK_IMPORTED_MODULE_8__.NOTIFICATION_VIEW_CONTEXTS.includes, _constants__WEBPACK_IMPORTED_MODULE_8__.NOTIFICATION_VIEW_CONTEXTS), `Notification view context should be one of: ${_constants__WEBPACK_IMPORTED_MODULE_8__.NOTIFICATION_VIEW_CONTEXTS.join(', ')}, but "${viewContexts}" was provided.`);
  }, function* (id, {
    Component,
    priority = 10,
    areaSlug,
    groupID = _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_4__.NOTIFICATION_GROUPS.DEFAULT,
    viewContexts,
    checkRequirements,
    isDismissible,
    dismissRetries = 0,
    featureFlag = ''
  }) {
    // First, we register the notification with the given id and settings.
    yield {
      payload: {
        id,
        settings: {
          Component,
          priority,
          areaSlug,
          groupID,
          viewContexts,
          checkRequirements,
          isDismissible,
          dismissRetries,
          featureFlag
        }
      },
      type: REGISTER_NOTIFICATION
    };
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();

    // If no view contexts were provided, we should instead do a comparison
    // with the "top"/"visible" notification in the queue for this
    // notification's `groupID` to see if the newly-registered notification
    // should be added to the "top"/"visible position" in the queue.
    //
    // This is the usual route for "ad-hoc" notifications that are registered
    // after initial page load, such as Setup Success notifications.
    if (!viewContexts?.length) {
      const {
        isNotificationDismissed
      } = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS);
      const notification = {
        id,
        Component,
        priority,
        areaSlug,
        groupID,
        viewContexts,
        checkRequirements,
        isDismissible,
        dismissRetries,
        featureFlag
      };
      yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.await(
      // Wait for all dismissed items to be available before checking
      // for dismissed status.
      Promise.all([registry.resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getDismissedItems(), registry.resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getDismissedPrompts()]));
      const isDismissed = isNotificationDismissed(notification.id);

      // Check if the notification should be added to the queue
      // before inserting it.
      if (!(0,_js_googlesitekit_notifications_util_shouldNotificationBeAddedToQueue__WEBPACK_IMPORTED_MODULE_5__.shouldNotificationBeAddedToQueue)(notification, {
        groupID,
        isDismissed
      })) {
        return;
      }

      // To do this, we'll add the notification to the queue immediately,
      // which will insert it in the right position based on its priority.
      yield actions.insertNotificationIntoResolvedQueue(id);
      return;
    }

    // If view contexts were provided, we need to repopulate the queues
    // because the data store doesn’t know the current `viewContext` and thus
    // can’t figure out if the ones specified are valid/active.
    //
    // This has the unfortunate side effect of causing rotation of the
    // notifications in the queue, so specifying `viewContexts` should
    // be avoided when registering "ad-hoc" notifications that aren't
    // registered on initialization.
    //
    // For each view context, check to see if the notifications have
    // finished resolution for the `getQueuedNotifications` selector.
    //
    // If they have, we need to invalidate the `getQueuedNotifications`
    // resolver for that `viewContext` + `groupID` combination, as it's
    // no longer valid.
    //
    // Note that this is an unlikely scenario, as notifications that are
    // registered after initial page load are usually ad-hoc notifications
    // that do not specify a `viewContext` (because they're intended to be
    // immediately visible).
    //
    // Still: this code is here to ensure that if a notification _is_
    // registered after initial page load, it will be visible in the queue
    // if appropriate.
    const {
      hasFinishedResolution
    } = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS);
    const {
      invalidateResolution
    } = registry.dispatch(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS);
    viewContexts.forEach(viewContext => {
      const hasResolvedGetQueuedNotifications = hasFinishedResolution('getQueuedNotifications', [viewContext, groupID]);

      // If the notifications have not been resolved yet, we don't need
      // to do any comparison with the queue, so we can return early.
      if (!hasResolvedGetQueuedNotifications) {
        return;
      }

      // If the notifications have been resolved, we will invalidate
      // the `getQueuedNotifications` resolver for this `viewContext` +
      // `groupID` combination.
      invalidateResolution('getQueuedNotifications', [viewContext, groupID]);
    });
  }),
  receiveQueuedNotifications(queuedNotifications, groupID = _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_4__.NOTIFICATION_GROUPS.DEFAULT) {
    return {
      payload: {
        queuedNotifications,
        groupID
      },
      type: RECEIVE_QUEUED_NOTIFICATIONS
    };
  },
  /**
   * Resets a notification queue.
   *
   * @since 1.142.0
   *
   * @param {string?} groupID Group ID of queue to reset. Default: default.
   * @return {Object} Redux-style action.
   */
  resetQueue(groupID = _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_4__.NOTIFICATION_GROUPS.DEFAULT) {
    return {
      type: RESET_QUEUE,
      payload: {
        groupID
      }
    };
  },
  /**
   * Populates a queue with qualifying notifications ordered by priority.
   *
   * @since 1.142.0
   *
   * @param {string}  viewContext View context to populate queue for.
   * @param {string?} groupID     Group ID of queue to populate. Default: default.
   * @yield {Object} Redux-style action.
   */
  *populateQueue(viewContext, groupID = _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_4__.NOTIFICATION_GROUPS.DEFAULT) {
    yield {
      type: POPULATE_QUEUE,
      payload: {
        viewContext,
        groupID
      }
    };
  },
  /**
   * Adds the given notification to its respective queue.
   *
   * @since 1.142.0
   *
   * @param {Object} notification Notification definition.
   * @return {Object} Redux-style action.
   */
  queueNotification(notification) {
    return {
      payload: {
        notification
      },
      type: QUEUE_NOTIFICATION
    };
  },
  /**
   * Marks a notification as seen on the current date.
   *
   * @since 1.153.0
   *
   * @param {string} notificationID Notification ID.
   * @return {Object} Redux-style action.
   */
  markNotificationSeen: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_2__.createValidatedAction)(notificationID => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidNotificationID(notificationID), 'a valid notification ID is required to mark a notification as seen.');
  }, function* (notificationID) {
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();

    // Only dispatch action for dismissible notifications.
    const notification = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getNotification(notificationID);
    if (notification?.isDismissible) {
      const dateSeen = registry.select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getReferenceDate();
      yield {
        payload: {
          dateSeen,
          notificationID
        },
        type: MARK_NOTIFICATION_SEEN
      };
      yield {
        type: PERSIST_SEEN_NOTIFICATIONS
      };
    }
  }),
  /**
   * Dismisses the given notification by its id.
   *
   * Currently, this action simply dispatches the call to the dismissed items API.
   * We can potentially add more notification-specific dismissal logic here in the future.
   *
   * @since 1.132.0
   *
   * @param {string} id                            Notification id to dismiss.
   * @param {Object} options                       Dismiss notification options.
   * @param {number} [options.expiresInSeconds]    Optional. An integer number of seconds for expiry. 0 denotes permanent dismissal. Default 0.
   * @param {number} [options.skipHidingFromQueue] Optional. A boolean value if notification should not be removed from the queue immediately.
   * @return {Object} Generator instance.
   */
  dismissNotification: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_2__.createValidatedAction)((id, options = {}) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(id, 'A notification id is required to dismiss a notification.');
    const {
      expiresInSeconds = 0
    } = options;
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(expiresInSeconds), 'expiresInSeconds must be an integer.');
  }, function* (id, options = {}) {
    const {
      expiresInSeconds = 0
    } = options;
    const registry = yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.getRegistry();
    if (!options.skipHidingFromQueue) {
      // Remove the notification from the queue of notifications in state.
      yield {
        type: DISMISS_NOTIFICATION,
        payload: {
          id
        }
      };
    }
    const notification = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getNotification(id);

    // Check if the notification is pinned; if so, unpin it.
    const pinnedNotificationID = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getPinnedNotificationID(notification?.groupID);
    if (pinnedNotificationID === id) {
      yield actions.unpinNotification(id, notification.groupID);
    }

    // Skip persisting notification dismissal in database if the notification is not dismissible.
    if (notification.isDismissible !== true) {
      return null;
    }

    // Use prompts if a notification should be shown again until it
    // is dismissed for a certain number of retries.
    if (notification.dismissRetries > 0) {
      const dismissCount = registry.select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getPromptDismissCount(id);
      const expirationInSeconds = dismissCount < notification.dismissRetries ? expiresInSeconds : 0;
      return yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.await(registry.dispatch(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).dismissPrompt(id, {
        expiresInSeconds: expirationInSeconds
      }));
    }
    return yield googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.commonActions.await(registry.dispatch(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).dismissItem(id, {
      expiresInSeconds
    }));
  }),
  /**
   * Pins a notification to the top of its respective queue.
   *
   * @since 1.164.0
   *
   * @param {string} id      Notification ID to pin.
   * @param {string} groupID Group ID the notification belongs to.
   * @return {Object} Redux-style action.
   */
  pinNotification: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_2__.createValidatedAction)((id, groupID) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(id, 'A notification id is required to pin a notification.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(groupID, 'A groupID is required to pin a notification to a specific group.');
  }, function* (id, groupID) {
    yield {
      type: PIN_NOTIFICATION,
      payload: {
        id,
        groupID
      }
    };
    yield {
      type: PERSIST_PINNED_NOTIFICATIONS
    };
  }),
  /**
   * Unpins a notification from the top of its respective queue.
   *
   * @since 1.164.0
   *
   * @param {string} id      Notification ID to unpin.
   * @param {string} groupID Group ID the notification belongs to.
   * @return {Object} Redux-style action.
   */
  unpinNotification: (0,_js_googlesitekit_data_utils__WEBPACK_IMPORTED_MODULE_2__.createValidatedAction)((id, groupID) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(id, 'A notification id is required to unpin a notification.');
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(groupID, 'A groupID is required to unpin notification from a specific group.');
  }, function* (id, groupID) {
    yield {
      type: UNPIN_NOTIFICATION,
      payload: {
        id,
        groupID
      }
    };
    yield {
      type: PERSIST_PINNED_NOTIFICATIONS
    };
  })
};
const controls = {
  [POPULATE_QUEUE]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => async ({
    payload
  }) => {
    const {
      viewContext,
      groupID
    } = payload;
    const notifications = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getNotifications();

    // Wait for all dismissed items to be available before filtering.
    await Promise.all([registry.resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getDismissedItems(), registry.resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getDismissedPrompts()]);

    // Get the seen notifications to rotate same priority notifications.
    const seenNotifications = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getSeenNotifications();

    // Get the `isNotificationDismissed` selector to check if a
    // notification is dismissed.
    const {
      isNotificationDismissed
    } = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS);
    let potentialNotifications = Object.values(notifications).filter(notification => {
      const isDismissed = isNotificationDismissed(notification.id);
      return (0,_js_googlesitekit_notifications_util_shouldNotificationBeAddedToQueue__WEBPACK_IMPORTED_MODULE_5__.shouldNotificationBeAddedToQueue)(notification, {
        groupID,
        viewContext,
        // Because all dismissed items are already
        // resolved, this won't return undefined.
        isDismissed
      });
    }).map(({
      checkRequirements,
      ...notification
    }) => {
      const viewCount = seenNotifications[notification.id]?.length || 0;
      return {
        ...notification,
        viewCount,
        checkRequirements,
        async check() {
          if (checkRequirements) {
            return await checkRequirements(registry, viewContext);
          }
          return true;
        }
      };
    }).sort((a, b) => a.viewCount - b.viewCount);
    const {
      queueNotification
    } = registry.dispatch(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS);

    // Get the pinned notification ID for this group, if any.
    const pinnedNotificationID = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getPinnedNotificationID(groupID);
    if (pinnedNotificationID) {
      // Check if a pinned notification exists within the potential notifications.
      const potentialPinnedNotification = potentialNotifications.find(notification => notification.id === pinnedNotificationID);

      // If the pinned notification exists within the potential notifications,
      // check its requirements and add it to the queue first if they pass.
      if (potentialPinnedNotification) {
        const meetsRequirements = await potentialPinnedNotification.check();
        if (meetsRequirements) {
          queueNotification(potentialPinnedNotification);

          // Remove the pinned notification from the potential notifications.
          potentialNotifications = potentialNotifications.filter(notification => notification.id !== potentialPinnedNotification.id);
        }
      }
    }
    let nextNotification;
    do {
      nextNotification = await (0,_js_util_async__WEBPACK_IMPORTED_MODULE_6__.racePrioritizedAsyncTasks)(potentialNotifications);
      if (nextNotification) {
        queueNotification(nextNotification);
        potentialNotifications = potentialNotifications.filter(n => n !== nextNotification);
      }
    } while (nextNotification);
  }),
  [PERSIST_SEEN_NOTIFICATIONS]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => () => {
    const seenNotifications = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getSeenNotifications();
    storage.setItem(NOTIFICATION_SEEN_STORAGE_KEY, JSON.stringify(seenNotifications));
  }),
  [PERSIST_PINNED_NOTIFICATIONS]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistryControl)(registry => () => {
    const pinnedNotifications = registry.select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getPinnedNotificationIDs();
    storage.setItem(NOTIFICATION_PINNED_STORAGE_KEY, JSON.stringify(pinnedNotifications));
  })
};

// eslint-disable-next-line complexity
const reducer = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createReducer)((state, {
  type,
  payload
}) => {
  switch (type) {
    case INSERT_NOTIFICATION_INTO_RESOLVED_QUEUE:
      {
        const {
          id
        } = payload;
        const {
          notifications,
          pinnedNotification,
          queuedNotifications
        } = state;

        /**
         * The notification we want to add to the already-resolved queue.
         */
        const notification = notifications?.[id];

        // Don't try to add a notification that is not registered.
        if (notification === undefined) {
          __webpack_require__.g.console.warn(`Could not add notification with ID "${id}" to queue. Notification "${id}" is not registered.`);
          break;
        }
        const {
          groupID,
          priority
        } = notification;

        // If the queue hasn't resolved yet, the queued notifications for this
        // group will be undefined. In this case we return early because this
        // notification will be added to the queue once it resolves.
        if (queuedNotifications[groupID] === undefined) {
          break;
        }

        // Check if the notification is already in the queue.
        if (queuedNotifications[groupID].some(notificationInQueue => notificationInQueue.id === id)) {
          // Check if it is pinned.
          if (pinnedNotification[groupID] === id) {
            const existingIndex = queuedNotifications[groupID].findIndex(notificationInQueue => notificationInQueue.id === id);

            // Remove it from its current position.
            const [existingNotification] = queuedNotifications[groupID].splice(existingIndex, 1);

            // Add it to the front of the queue.
            queuedNotifications[groupID].unshift(existingNotification);
          }

          // We don't need to add it again.
          break;
        }

        // Check if the notification is pinned.
        if (pinnedNotification[groupID] === id) {
          // If it is, we add it to the front of the queue.
          queuedNotifications[groupID].unshift(notification);
          break;
        }

        // Find the next notification in the queue that has a lower priority than
        // the one we're adding, and add this notification ahead of it.
        //
        // The `findIndex` call will return -1 if we can't find a notification
        // with "lower priority" (eg. has a higher number) than the one we're
        // adding. In that case, we'll add the notification to the end of the
        // queue.
        //
        // If we do find a notification with a lower priority (or the same
        // priority), `findIndex` will return its index, which we can use to
        // insert the new notification after that notification.
        const positionForNewNotification = queuedNotifications[groupID].findIndex(notificationInQueue => {
          return notificationInQueue.priority >= priority;
        });

        // Insert the new notification at the position we found, or at the end of
        // the queue if we didn't find any notification with a lower priority.
        queuedNotifications[groupID].splice(positionForNewNotification !== -1 ? positionForNewNotification : state.queuedNotifications[groupID].length, 0, notification);
        break;
      }
    case REGISTER_NOTIFICATION:
      {
        const {
          id,
          settings
        } = payload;
        if (state.notifications[id] !== undefined) {
          __webpack_require__.g.console.warn(`Could not register notification with ID "${id}". Notification "${id}" is already registered.`);
        } else {
          state.notifications[id] = {
            ...settings,
            id
          };
        }
        break;
      }
    case RECEIVE_QUEUED_NOTIFICATIONS:
      {
        state.queuedNotifications[payload.groupID] = payload.queuedNotifications;
        break;
      }
    case RESET_QUEUE:
      {
        state.queuedNotifications[payload.groupID] = [];
        break;
      }
    case QUEUE_NOTIFICATION:
      {
        const {
          groupID,
          id
        } = payload.notification;
        state.queuedNotifications[groupID] = state.queuedNotifications[groupID] || [];

        // If the notification is already in the queue, we don't need to
        // add it again.
        if (state.queuedNotifications[groupID].some(notification => notification.id === id)) {
          break;
        }
        state.queuedNotifications[groupID].push(payload.notification);
        break;
      }
    case MARK_NOTIFICATION_SEEN:
      {
        const {
          dateSeen,
          notificationID
        } = payload;
        const seenNotifications = {
          ...state.seenNotifications
        };

        // Initialize array if it doesn't exist.
        if (!seenNotifications[notificationID]) {
          seenNotifications[notificationID] = [];
        }

        // Only add the date if it's not already in the array.
        if (!seenNotifications[notificationID].includes(dateSeen)) {
          seenNotifications[notificationID].push(dateSeen);
        }
        state.seenNotifications = seenNotifications;
        break;
      }
    case DISMISS_NOTIFICATION:
      {
        const {
          id
        } = payload;
        const groupID = state.notifications?.[id]?.groupID;
        const dismissedNotificationIndex = state.queuedNotifications[groupID]?.findIndex(notification => notification.id === id);
        if (dismissedNotificationIndex >= 0) {
          state.queuedNotifications[groupID].splice(dismissedNotificationIndex, 1);
        }
        break;
      }
    case PIN_NOTIFICATION:
      {
        const {
          id,
          groupID
        } = payload;
        state.pinnedNotification[groupID] = id;
        break;
      }
    case UNPIN_NOTIFICATION:
      {
        const {
          id,
          groupID
        } = payload;
        if (state.pinnedNotification[groupID] === id) {
          delete state.pinnedNotification[groupID];
        }
        break;
      }
    default:
      break;
  }
});
const resolvers = {
  *getQueuedNotifications(viewContext, groupID = _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_4__.NOTIFICATION_GROUPS.DEFAULT) {
    yield actions.resetQueue(groupID);
    yield actions.populateQueue(viewContext, groupID);
  }
};
const selectors = {
  /**
   * Gets all view dates for each notification, keyed by notification ID.
   *
   * @since 1.153.0
   *
   * @param {Object} state Data store's state.
   * @return {Object} Object with notification IDs as keys and array of dates viewed as the value.
   */
  getSeenNotifications(state) {
    return state.seenNotifications;
  },
  /**
   * Gets the dates when a specific notification was seen.
   *
   * @since 1.153.0
   *
   * @param {Object} state          Data store's state.
   * @param {string} notificationID Notification ID.
   * @return {Array} Array of dates when the notification was seen.
   */
  getNotificationSeenDates(state, notificationID) {
    var _seenNotifications$no;
    const {
      seenNotifications
    } = state;
    return (_seenNotifications$no = seenNotifications[notificationID]) !== null && _seenNotifications$no !== void 0 ? _seenNotifications$no : [];
  },
  /**
   * Fetches all registered notifications from state, regardless of whether they are dismissed or not.
   *
   * @since 1.133.0
   *
   * @param {Object} state Data store's state.
   * @return {(Array|undefined)} Array of notification objects.
   */
  getNotifications: state => {
    return state.notifications;
  },
  /**
   * Fetches a registered notification by ID from state.
   *
   * @since 1.138.0
   *
   * @param {Object} state Data store's state.
   * @param {string} id    Notification ID.
   * @return {(Object|undefined)} The registered notification object or undefined if a notification with the given ID is not registered.
   */
  getNotification: (state, id) => {
    return state.notifications[id];
  },
  /**
   * Fetches the queue of registered notifications which are filtered and sorted.
   *
   * Notifications are filtered and sorted in the corresponding resolver.
   * They are filtered based on the given `viewContext`, their dismissal state
   * and their `checkRequirements` callback. They are sorted by their `priority`.
   *
   * @since 1.133.0
   *
   * @param {Object} state       Data store's state.
   * @param {string} viewContext The viewContext to fetch notifications for.
   * @param {string} groupID     The groupID of the notification queue to fetch notifications for.
   * @return {(Array|undefined)} Array of notification objects.
   */
  getQueuedNotifications: (state, viewContext, groupID = _js_googlesitekit_notifications_constants__WEBPACK_IMPORTED_MODULE_4__.NOTIFICATION_GROUPS.DEFAULT) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(viewContext, 'viewContext is required.');
    return state.queuedNotifications[groupID];
  },
  /**
   * Determines whether a notification is dismissed or not.
   *
   * If the notification should appear again for a certain number of times after dismissal,
   * then we store them as prompts. So we check for dismissed prompts instead of dismissed items.
   *
   * @since 1.132.0
   *
   * @param {Object} state Data store's state.
   * @param {string} id    Notification id.
   * @return {(boolean|undefined)} TRUE if dismissed, otherwise FALSE, `undefined` if not resolved yet.
   */
  isNotificationDismissed: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, id) => {
    const notification = select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getNotification(id);
    if (notification === undefined) {
      return undefined;
    }
    if (notification.dismissRetries > 0) {
      return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isPromptDismissed(id);
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isItemDismissed(id);
  }),
  /**
   * Determines whether a notification that can reappear again for a fixed number of times
   * on dismissal is at its final appearance.
   *
   * @since 1.145.0
   *
   * @param {Object} state Data store's state.
   * @param {string} id    Notification id.
   * @return {(boolean|undefined)} TRUE if notification is on its final retry, otherwise FALSE, `undefined` if not resolved yet.
   */
  isNotificationDismissalFinal: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.createRegistrySelector)(select => (state, id) => {
    const notification = select(_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_NOTIFICATIONS).getNotification(id);
    if (notification === undefined) {
      return undefined;
    }
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(notification.isDismissible, 'Notification should be dismissible to check if a notification is on its final dismissal.');

    // If a notification does not have retries, it always will be on its final render.
    if (notification.dismissRetries === 0) {
      return true;
    }
    const dismissCount = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).getPromptDismissCount(id);
    if (dismissCount >= notification.dismissRetries) {
      return true;
    }
    return false;
  }),
  /**
   * Gets all pinned notification IDs, keyed by group ID.
   *
   * @since 1.164.0
   *
   * @param {Object} state Data store's state.
   * @return {Object} Object with group IDs as keys and pinned notification ID as the value.
   */
  getPinnedNotificationIDs: state => {
    return state.pinnedNotification;
  },
  /**
   * Gets the ID of the pinned notification for a specific group, if any.
   *
   * @since 1.164.0
   *
   * @param {Object} state   Data store's state.
   * @param {string} groupID The group ID to get the pinned notification ID for.
   * @return {(string|undefined)} The ID of the pinned notification, or undefined if none is pinned.
   */
  getPinnedNotificationID: (state, groupID) => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(groupID, 'groupID is required.');
    return state.pinnedNotification[groupID];
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  initialState,
  actions,
  controls,
  reducer,
  resolvers,
  selectors
});

/***/ }),

/***/ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js":
/*!***********************************************************************!*\
  !*** ./js/googlesitekit/notifications/hooks/useNotificationEvents.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNotificationEvents)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * `useNotificationEvents` hook.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useNotificationEvents(id, category, {
  viewAction = 'view_notification',
  confirmAction = 'confirm_notification',
  dismissAction = 'dismiss_notification',
  clickLearnMoreAction = 'click_learn_more_link'
} = {}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__["default"])();
  const eventCategory = category !== null && category !== void 0 ? category : `${viewContext}_${id}`;
  const view = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, viewAction, ...args);
  }, [eventCategory, viewAction]);
  const confirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, confirmAction, ...args);
  }, [eventCategory, confirmAction]);
  const dismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, dismissAction, ...args);
  }, [eventCategory, dismissAction]);
  const clickLearnMore = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, clickLearnMoreAction, ...args);
  }, [eventCategory, clickLearnMoreAction]);
  return {
    view,
    confirm,
    dismiss,
    clickLearnMore
  };
}

/***/ }),

/***/ "./js/googlesitekit/notifications/index.js":
/*!*************************************************!*\
  !*** ./js/googlesitekit/notifications/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createNotifications: () => (/* binding */ createNotifications),
/* harmony export */   registerNotifications: () => (/* reexport safe */ _register_defaults__WEBPACK_IMPORTED_MODULE_2__.registerDefaults),
/* harmony export */   registerStore: () => (/* reexport safe */ _datastore__WEBPACK_IMPORTED_MODULE_1__.registerStore)
/* harmony export */ });
/* harmony import */ var _datastore_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _datastore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./datastore */ "./js/googlesitekit/notifications/datastore/index.js");
/* harmony import */ var _register_defaults__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./register-defaults */ "./js/googlesitekit/notifications/register-defaults.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



function createNotifications(registry) {
  const {
    dispatch
  } = registry;
  const Notifications = {
    registerNotification(id, settings) {
      dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_NOTIFICATIONS).registerNotification(id, settings);
    }
  };
  return Notifications;
}

/***/ }),

/***/ "./js/googlesitekit/notifications/register-defaults.js":
/*!*************************************************************!*\
  !*** ./js/googlesitekit/notifications/register-defaults.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_NOTIFICATIONS: () => (/* binding */ DEFAULT_NOTIFICATIONS),
/* harmony export */   registerDefaults: () => (/* binding */ registerDefaults)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var _js_components_consent_mode_ConsentModeSetupCTABanner__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/consent-mode/ConsentModeSetupCTABanner */ "./js/components/consent-mode/ConsentModeSetupCTABanner.js");
/* harmony import */ var _js_components_consent_mode_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/consent-mode/constants */ "./js/components/consent-mode/constants.js");
/* harmony import */ var _js_components_dashboard_sharing_ModuleRecoveryAlert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/dashboard-sharing/ModuleRecoveryAlert */ "./js/components/dashboard-sharing/ModuleRecoveryAlert/index.js");
/* harmony import */ var _js_components_email_reporting_SetUpEmailReportingOverlayNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/email-reporting/SetUpEmailReportingOverlayNotification */ "./js/components/email-reporting/SetUpEmailReportingOverlayNotification.js");
/* harmony import */ var _js_components_notifications_ActivateAnalyticsNotification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/notifications/ActivateAnalyticsNotification */ "./js/components/notifications/ActivateAnalyticsNotification.tsx");
/* harmony import */ var _js_components_notifications_AuthError__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/notifications/AuthError */ "./js/components/notifications/AuthError.js");
/* harmony import */ var _js_components_notifications_EnableAutoUpdateBannerNotification__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/notifications/EnableAutoUpdateBannerNotification */ "./js/components/notifications/EnableAutoUpdateBannerNotification.js");
/* harmony import */ var _js_components_notifications_GA4AdSenseLinkedNotification__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/notifications/GA4AdSenseLinkedNotification */ "./js/components/notifications/GA4AdSenseLinkedNotification.js");
/* harmony import */ var _js_components_notifications_GatheringDataNotification__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/notifications/GatheringDataNotification */ "./js/components/notifications/GatheringDataNotification.js");
/* harmony import */ var _js_components_notifications_GoogleTagGatewaySetupBanner__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/notifications/GoogleTagGatewaySetupBanner */ "./js/components/notifications/GoogleTagGatewaySetupBanner.js");
/* harmony import */ var _js_components_notifications_GoogleTagGatewayWarningNotification__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/notifications/GoogleTagGatewayWarningNotification */ "./js/components/notifications/GoogleTagGatewayWarningNotification.js");
/* harmony import */ var _js_components_notifications_ModuleSetupSuccessNotification__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/components/notifications/ModuleSetupSuccessNotification */ "./js/components/notifications/ModuleSetupSuccessNotification.js");
/* harmony import */ var _js_components_notifications_SetupErrorMessageNotification__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/components/notifications/SetupErrorMessageNotification */ "./js/components/notifications/SetupErrorMessageNotification.js");
/* harmony import */ var _js_components_notifications_SiteKitSetupSuccessNotification__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/components/notifications/SiteKitSetupSuccessNotification */ "./js/components/notifications/SiteKitSetupSuccessNotification.js");
/* harmony import */ var _js_components_notifications_UnsatisfiedScopesAlert__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/components/notifications/UnsatisfiedScopesAlert */ "./js/components/notifications/UnsatisfiedScopesAlert/index.js");
/* harmony import */ var _js_components_notifications_UnsatisfiedScopesAlertGTE__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/components/notifications/UnsatisfiedScopesAlertGTE */ "./js/components/notifications/UnsatisfiedScopesAlertGTE.js");
/* harmony import */ var _js_components_notifications_ZeroDataNotification__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/components/notifications/ZeroDataNotification */ "./js/components/notifications/ZeroDataNotification.js");
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _js_googlesitekit_data_requirements__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/js/googlesitekit/data-requirements */ "./js/googlesitekit/data-requirements/index.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_modules_adsense_constants__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @/js/modules/adsense/constants */ "./js/modules/adsense/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_utils__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @/js/modules/analytics-4/utils */ "./js/modules/analytics-4/utils/index.js");
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/* harmony import */ var _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @/js/modules/search-console/datastore/constants */ "./js/modules/search-console/datastore/constants.js");
/* harmony import */ var _js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @/js/modules/tagmanager/datastore/constants */ "./js/modules/tagmanager/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_async__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @/js/util/async */ "./js/util/async.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./constants */ "./js/googlesitekit/notifications/constants.js");
/* harmony import */ var _datastore_constants__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/**
 * Notifications API defaults
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


































const DEFAULT_NOTIFICATIONS = {
  'activate-analytics-cta': {
    Component: _js_components_notifications_ActivateAnalyticsNotification__WEBPACK_IMPORTED_MODULE_4__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.SETUP_CTA_HIGH,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD],
    isDismissible: true,
    dismissRetries: 2,
    checkRequirements: (0,_js_util_async__WEBPACK_IMPORTED_MODULE_31__.asyncRequireAll)((0,_js_util_async__WEBPACK_IMPORTED_MODULE_31__.asyncRequire)(false, (0,_js_googlesitekit_data_requirements__WEBPACK_IMPORTED_MODULE_18__.requireModuleActive)(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4)), (0,_js_util_async__WEBPACK_IMPORTED_MODULE_31__.asyncRequire)(false, (0,_js_googlesitekit_data_requirements__WEBPACK_IMPORTED_MODULE_18__.requireModuleGatheringData)(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_28__.MODULES_SEARCH_CONSOLE)), (0,_js_googlesitekit_data_requirements__WEBPACK_IMPORTED_MODULE_18__.requireCanActivateModule)(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4)),
    featureFlag: 'setupFlowRefresh'
  },
  'authentication-error': {
    Component: _js_components_notifications_UnsatisfiedScopesAlert__WEBPACK_IMPORTED_MODULE_14__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.ERROR_HIGH,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_SETTINGS],
    checkRequirements: async ({
      select,
      resolveSelect
    }) => {
      await Promise.all([
      // The isAuthenticated(), hasScope() and getUnsatisfiedScopes() selectors
      // rely on the resolution of getAuthentication().
      resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getAuthentication(),
      // The isModuleConnected() selector relies on the resolution
      // of the getModules() resolver.
      resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getModules()]);
      const isAuthenticated = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).isAuthenticated();
      const ga4ModuleConnected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4);
      const hasTagManagerReadScope = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).hasScope(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_29__.READ_SCOPE);
      const unsatisfiedScopes = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getUnsatisfiedScopes();
      const showUnsatisfiedScopesAlertGTE = ga4ModuleConnected && !hasTagManagerReadScope && unsatisfiedScopes?.length === 1;
      return unsatisfiedScopes?.length && isAuthenticated && !showUnsatisfiedScopesAlertGTE;
    },
    isDismissible: false
  },
  'authentication-error-gte': {
    Component: _js_components_notifications_UnsatisfiedScopesAlertGTE__WEBPACK_IMPORTED_MODULE_15__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.ERROR_HIGH,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_SETTINGS],
    checkRequirements: async ({
      select,
      resolveSelect
    }) => {
      await Promise.all([
      // The isAuthenticated() and hasScope() selectors
      // rely on the resolution of getAuthentication().
      resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getAuthentication(),
      // The isModuleConnected() selector relies on the resolution
      // of the getModules() resolver.
      resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getModules()]);
      const isAuthenticated = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).isAuthenticated();
      const ga4ModuleConnected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4);
      const hasTagManagerReadScope = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).hasScope(_js_modules_tagmanager_datastore_constants__WEBPACK_IMPORTED_MODULE_29__.READ_SCOPE);
      const showUnsatisfiedScopesAlertGTE = ga4ModuleConnected && !hasTagManagerReadScope;
      return isAuthenticated && showUnsatisfiedScopesAlertGTE;
    },
    isDismissible: false
  },
  setup_plugin_error: {
    Component: _js_components_notifications_SetupErrorMessageNotification__WEBPACK_IMPORTED_MODULE_12__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.ERROR_LOW,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_SETTINGS, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_SPLASH],
    checkRequirements: async ({
      select,
      resolveSelect
    }) => {
      await resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).getSiteInfo();
      const temporaryPersistedPermissionsError = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_19__.CORE_FORMS).getValue(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, 'permissionsError');
      if (temporaryPersistedPermissionsError?.data?.skipDefaultErrorNotifications) {
        return false;
      }
      const setupErrorMessage = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).getSetupErrorMessage();
      return !!setupErrorMessage;
    },
    isDismissible: false
  },
  'auth-error': {
    Component: _js_components_notifications_AuthError__WEBPACK_IMPORTED_MODULE_5__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.ERROR_HIGH,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_SETTINGS],
    checkRequirements: ({
      select
    }) => {
      const error = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getAuthError();
      return !!error;
    },
    isDismissible: false
  },
  'top-earning-pages-success-notification': {
    Component: _js_components_notifications_GA4AdSenseLinkedNotification__WEBPACK_IMPORTED_MODULE_7__["default"],
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD],
    checkRequirements: async ({
      select,
      resolveSelect,
      dispatch
    }) => {
      const adSenseModuleConnected = await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).isModuleConnected(_js_modules_adsense_constants__WEBPACK_IMPORTED_MODULE_23__.MODULE_SLUG_ADSENSE);
      const analyticsModuleConnected = await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4);
      if (!(adSenseModuleConnected && analyticsModuleConnected)) {
        return false;
      }
      await resolveSelect(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_25__.MODULES_ANALYTICS_4).getSettings();
      const isAdSenseLinked = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_25__.MODULES_ANALYTICS_4).getAdSenseLinked();
      if (!isAdSenseLinked) {
        return false;
      }
      const {
        startDate,
        endDate
      } = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getDateRangeDates({
        offsetDays: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_25__.DATE_RANGE_OFFSET
      });
      const reportOptions = {
        startDate,
        endDate,
        dimensions: ['pagePath'],
        metrics: [{
          name: 'totalAdRevenue'
        }],
        orderby: [{
          metric: {
            metricName: 'totalAdRevenue'
          },
          desc: true
        }],
        limit: 3,
        reportID: 'notifications_top-earning-pages-success-notification_reportOptions'
      };

      // Ensure resolution of the report has completed before showing this
      // notification, since it should only appear when the user has no data in
      // the report.
      const report = await resolveSelect(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_25__.MODULES_ANALYTICS_4).getReport(reportOptions);

      // This notification should only appear when the user has connected their
      // AdSense and Google Analytics accounts, but has not yet received any data
      // from linking the accounts. If they have any data from the "linked" report,
      // we show them a different notification and should not show this one. Check
      // to see if the user already has data and dismiss this notification without
      // showing it.
      if ((0,_js_modules_analytics_4_utils__WEBPACK_IMPORTED_MODULE_26__.isZeroReport)(report) === false) {
        await dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_33__.CORE_NOTIFICATIONS).dismissNotification('top-earning-pages-success-notification');
        return false;
      }
      return true;
    },
    isDismissible: true
  },
  'setup-success-notification-site-kit': {
    Component: _js_components_notifications_SiteKitSetupSuccessNotification__WEBPACK_IMPORTED_MODULE_13__["default"],
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD],
    checkRequirements: () => {
      const notification = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_34__.getQueryArg)(location.href, 'notification');
      const slug = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_34__.getQueryArg)(location.href, 'slug');
      if ('authentication_success' === notification && !slug) {
        return true;
      }
      return false;
    }
  },
  'setup-success-notification-module': {
    Component: _js_components_notifications_ModuleSetupSuccessNotification__WEBPACK_IMPORTED_MODULE_11__["default"],
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD],
    checkRequirements: async ({
      select,
      resolveSelect
    }) => {
      await Promise.all([
      // The getModule() selector relies on the resolution
      // of the getModules() resolver.
      resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getModules()]);
      const notification = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_34__.getQueryArg)(location.href, 'notification');
      const slug = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_34__.getQueryArg)(location.href, 'slug');
      const module = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getModule(slug);
      if ('authentication_success' === notification && false === module.overrideSetupSuccessNotification && module.active) {
        return true;
      }
      return false;
    }
  },
  [_js_components_notifications_EnableAutoUpdateBannerNotification__WEBPACK_IMPORTED_MODULE_6__.ENABLE_AUTO_UPDATES_BANNER_SLUG]: {
    Component: _js_components_notifications_EnableAutoUpdateBannerNotification__WEBPACK_IMPORTED_MODULE_6__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.SETUP_CTA_LOW,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    groupID: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_GROUPS.SETUP_CTAS,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY],
    checkRequirements: async ({
      select,
      resolveSelect,
      dispatch
    }) => {
      await Promise.all([
      // The hasCapability() selector relies on the resolution
      // of the getCapabilities() resolver.
      resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getCapabilities(),
      // The hasChangePluginAutoUpdatesCapacity() and
      // getSiteKitAutoUpdatesEnabled() selectors rely on the
      // resolution of the getSiteInfo() resolver.
      resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).getSiteInfo()]);
      const notification = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_34__.getQueryArg)(location.href, 'notification');
      const slug = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_34__.getQueryArg)(location.href, 'slug');
      const {
        dismissNotification
      } = dispatch(_datastore_constants__WEBPACK_IMPORTED_MODULE_33__.CORE_NOTIFICATIONS);

      /**
       * If the user just set up Site Kit (i.e. just returned from the
       * initial OAuth sign-in flow) and is seeing the dashboard
       * for the first time, we want to hide (dismiss) this notification for 10
       * minutes so they aren't immediately bothered by this CTA.
       */
      if (notification === 'authentication_success' && !slug) {
        await dismissNotification('auto-update-cta', {
          expiresInSeconds: _js_util__WEBPACK_IMPORTED_MODULE_30__.MINUTE_IN_SECONDS * 10
        });
        return false;
      }
      const hasUpdatePluginCapability = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.PERMISSION_UPDATE_PLUGINS);
      const hasChangePluginAutoUpdatesCapacity = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).hasChangePluginAutoUpdatesCapacity();
      const siteKitAutoUpdatesEnabled = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).getSiteKitAutoUpdatesEnabled();

      // Don't render anything if the user has no permission to update plugin,
      // auto-updates can not be enabled for Site Kit, or auto updates are already
      // enabled for Site Kit.
      if (hasUpdatePluginCapability && hasChangePluginAutoUpdatesCapacity && !siteKitAutoUpdatesEnabled) {
        return true;
      }
      return false;
    },
    isDismissible: true
  },
  'gathering-data-notification': {
    Component: _js_components_notifications_GatheringDataNotification__WEBPACK_IMPORTED_MODULE_8__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.INFO,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY],
    checkRequirements: async ({
      select,
      resolveSelect
    }, viewContext) => {
      const viewOnly = _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.SITE_KIT_VIEW_ONLY_CONTEXTS.includes(viewContext);
      await Promise.all([
      // The isModuleConnected() and canViewSharedModule() selectors rely
      // on the resolution of the getModules() resolver.
      resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getModules(), viewOnly ? resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getRecoverableModules() : Promise.resolve([])]);
      const isAnalyticsConnected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4);
      const canViewSharedAnalytics = !viewOnly ? true : select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).canViewSharedModule(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4);
      const canViewSharedSearchConsole = !viewOnly ? true : select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).canViewSharedModule(_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_27__.MODULE_SLUG_SEARCH_CONSOLE);
      const showRecoverableAnalytics = await (() => {
        if (!viewOnly) {
          return false;
        }
        const recoverableModules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getRecoverableModules();
        return Object.keys(recoverableModules).includes(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4);
      })();
      const showRecoverableSearchConsole = await (() => {
        if (!viewOnly) {
          return false;
        }
        const recoverableModules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getRecoverableModules();
        return Object.keys(recoverableModules).includes(_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_27__.MODULE_SLUG_SEARCH_CONSOLE);
      })();
      const analyticsGatheringData = isAnalyticsConnected && canViewSharedAnalytics && false === showRecoverableAnalytics ? await resolveSelect(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_25__.MODULES_ANALYTICS_4).isGatheringData() : false;
      const searchConsoleGatheringData = canViewSharedSearchConsole && false === showRecoverableSearchConsole && (await resolveSelect(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_28__.MODULES_SEARCH_CONSOLE).isGatheringData());
      return analyticsGatheringData || searchConsoleGatheringData;
    },
    isDismissible: true
  },
  'zero-data-notification': {
    Component: _js_components_notifications_ZeroDataNotification__WEBPACK_IMPORTED_MODULE_16__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.INFO,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY],
    checkRequirements: async ({
      select,
      resolveSelect
    }, viewContext) => {
      const viewOnly = _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.SITE_KIT_VIEW_ONLY_CONTEXTS.includes(viewContext);
      await Promise.all([
      // The isModuleConnected() and canViewSharedModule() selectors rely
      // on the resolution of the getModules() resolver.
      resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getModules(), viewOnly ? resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getRecoverableModules() : Promise.resolve([])]);
      async function getModuleState(moduleSlug, datastoreSlug) {
        // Check if the module connected and return early if not.
        const isConnected = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).isModuleConnected(moduleSlug);
        if (!isConnected) {
          return 'disconnected';
        }

        // If we are in the view only mode, we need to ensure the user can view the module
        // and it is not in the recovering state. Return early if either of these is wrong.
        if (viewOnly) {
          const canView = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).canViewSharedModule(moduleSlug);
          if (!canView) {
            return 'cant-view';
          }
          const modules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getRecoverableModules();
          if (!!modules[moduleSlug]) {
            return 'recovering';
          }
        }

        // Next, we need to check gathering data state and return early
        // if the module is in the gathering state.
        const isGatheringData = await resolveSelect(datastoreSlug).isGatheringData();
        if (isGatheringData) {
          return 'gathering';
        }

        // Finally, we need to preload the sample report and check if it has zero data.
        await resolveSelect(datastoreSlug).getReport(select(datastoreSlug).getSampleReportArgs());
        if (select(datastoreSlug).hasZeroData()) {
          return 'zero-data';
        }
        return 'connected';
      }

      // Get Analytics-4 and Search Console states.
      const analyticsState = await getModuleState(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_25__.MODULES_ANALYTICS_4);
      const searchConsoleState = await getModuleState(_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_27__.MODULE_SLUG_SEARCH_CONSOLE, _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_28__.MODULES_SEARCH_CONSOLE);

      // If either of the modules is gathering data, we don't show the notification.
      if (analyticsState === 'gathering' || searchConsoleState === 'gathering') {
        return false;
      }

      // If either of the modules is in the zero data state, we need to show the notification.
      return analyticsState === 'zero-data' || searchConsoleState === 'zero-data';
    },
    isDismissible: true
  },
  'module-recovery-alert': {
    Component: _js_components_dashboard_sharing_ModuleRecoveryAlert__WEBPACK_IMPORTED_MODULE_2__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.ERROR_LOW,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.HEADER,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD],
    isDismissible: false,
    checkRequirements: async ({
      resolveSelect
    }) => {
      const recoverableModules = await resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getRecoverableModules();
      const recoverableModulesList = Object.keys(recoverableModules || {});
      if (!recoverableModulesList.length) {
        return false;
      }
      return true;
    }
  },
  [_js_components_consent_mode_constants__WEBPACK_IMPORTED_MODULE_1__.CONSENT_MODE_SETUP_CTA_WIDGET_SLUG]: {
    Component: _js_components_consent_mode_ConsentModeSetupCTABanner__WEBPACK_IMPORTED_MODULE_0__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.SETUP_CTA_HIGH,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    groupID: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_GROUPS.SETUP_CTAS,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD],
    isDismissible: true,
    checkRequirements: async ({
      select,
      resolveSelect
    }) => {
      // The isConsentModeEnabled selector relies on the resolution
      // of the getConsentModeSettings() resolver.
      await resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).getConsentModeSettings();
      const isConsentModeEnabled = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).isConsentModeEnabled();
      if (isConsentModeEnabled !== false) {
        return false;
      }
      return resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).isAdsConnected();
    },
    dismissRetries: 2
  },
  [_constants__WEBPACK_IMPORTED_MODULE_32__.GTG_SETUP_CTA_BANNER_NOTIFICATION]: {
    Component: _js_components_notifications_GoogleTagGatewaySetupBanner__WEBPACK_IMPORTED_MODULE_9__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.SETUP_CTA_LOW,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    groupID: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_GROUPS.SETUP_CTAS,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD],
    checkRequirements: async ({
      select,
      resolveSelect,
      dispatch
    }) => {
      const isGTGModuleConnected = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).isAnyGoogleTagGatewayModuleConnected();
      if (!isGTGModuleConnected) {
        return false;
      }
      await resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).getGoogleTagGatewaySettings();
      const {
        isGoogleTagGatewayEnabled,
        isGTGHealthy,
        isScriptAccessEnabled
      } = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE);
      if (isGoogleTagGatewayEnabled()) {
        return false;
      }
      const isHealthy = isGTGHealthy();
      const isAccessEnabled = isScriptAccessEnabled();
      if ([isHealthy, isAccessEnabled].includes(null)) {
        dispatch(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).fetchGetGTGServerRequirementStatus();
        return false;
      }
      return isHealthy && isAccessEnabled;
    },
    isDismissible: true,
    featureFlag: 'googleTagGateway'
  },
  [_constants__WEBPACK_IMPORTED_MODULE_32__.GTG_HEALTH_CHECK_WARNING_NOTIFICATION_ID]: {
    Component: _js_components_notifications_GoogleTagGatewayWarningNotification__WEBPACK_IMPORTED_MODULE_10__["default"],
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.DASHBOARD_TOP,
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD],
    checkRequirements: async ({
      select,
      resolveSelect
    }) => {
      const isGTGModuleConnected = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).isAnyGoogleTagGatewayModuleConnected();
      if (!isGTGModuleConnected) {
        return false;
      }
      await resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).getGoogleTagGatewaySettings();
      const {
        isGoogleTagGatewayEnabled,
        isGTGHealthy,
        isScriptAccessEnabled
      } = select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE);
      return isGoogleTagGatewayEnabled() && (!isGTGHealthy() || !isScriptAccessEnabled());
    },
    isDismissible: true,
    featureFlag: 'googleTagGateway'
  },
  [_js_components_email_reporting_SetUpEmailReportingOverlayNotification__WEBPACK_IMPORTED_MODULE_3__.SET_UP_EMAIL_REPORTING_OVERLAY_NOTIFICATION]: {
    Component: _js_components_email_reporting_SetUpEmailReportingOverlayNotification__WEBPACK_IMPORTED_MODULE_3__["default"],
    priority: _constants__WEBPACK_IMPORTED_MODULE_32__.PRIORITY.SETUP_CTA_LOW,
    areaSlug: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_AREAS.OVERLAYS,
    groupID: _constants__WEBPACK_IMPORTED_MODULE_32__.NOTIFICATION_GROUPS.SETUP_CTAS,
    featureFlag: 'proactiveUserEngagement',
    viewContexts: [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY],
    isDismissible: true,
    checkRequirements: async ({
      select,
      resolveSelect
    }, viewContext) => {
      // Check if email reporting is enabled at site level.
      await resolveSelect(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).getEmailReportingSettings();
      if (select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_20__.CORE_SITE).isEmailReportingEnabled() === false) {
        return false;
      }

      // Check user subscription status.
      const settings = await resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getEmailReportingSettings();
      if (settings === undefined || settings?.subscribed) {
        return false;
      }
      const viewOnly = _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_17__.SITE_KIT_VIEW_ONLY_CONTEXTS.includes(viewContext);

      // For view-only users, check if user has access to at least one
      // of the required email report data modules.
      // Admins always have access to the overlay notification.
      if (viewOnly) {
        await Promise.all([resolveSelect(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_22__.CORE_MODULES).getModules(), resolveSelect(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getCapabilities()]);
        const viewableModules = select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).getViewableModules();
        if (!viewableModules?.includes(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_24__.MODULE_SLUG_ANALYTICS_4) && !viewableModules?.includes(_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_27__.MODULE_SLUG_SEARCH_CONSOLE)) {
          return false;
        }
      }
      return !select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_21__.CORE_USER).isEmailReportingSubscribed();
    }
  }
};

/**
 * Registers notifications not specific to any one particular module.
 *
 * @since 1.132.0
 *
 * @param {Object} notificationsAPI Notifications API.
 */
function registerDefaults(notificationsAPI) {
  for (const notificationID in DEFAULT_NOTIFICATIONS) {
    notificationsAPI.registerNotification(notificationID, DEFAULT_NOTIFICATIONS[notificationID]);
  }
}

/***/ }),

/***/ "./js/googlesitekit/notifications/util/shouldNotificationBeAddedToQueue.js":
/*!*********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/util/shouldNotificationBeAddedToQueue.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   shouldNotificationBeAddedToQueue: () => (/* binding */ shouldNotificationBeAddedToQueue)
/* harmony export */ });
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Checks if a notification should be added to the queue based on
 * its feature flags, groupID, viewContext, etc.
 *
 * @since 1.155.0
 *
 * @param {Object}  notification                Notification object.
 * @param {Object}  params                      Parameters.
 * @param {string}  params.groupID              Group ID to check against the notification's groupID.
 * @param {boolean} params.isDismissed          Whether the notification is already dismissed, if it's dismissible.
 * @param {string}  params.viewContext          View context to check against the notification's viewContexts (if present).
 * @param {Array}   params._enabledFeatureFlags Feature flags object to check against the notification's `featureFlag`. Used for testing purposes.
 * @return {boolean} Returns true if the notification should be added to the queue, false otherwise.
 */
function shouldNotificationBeAddedToQueue(notification, {
  groupID,
  viewContext,
  isDismissed,
  _enabledFeatureFlags
} = {}) {
  if (notification?.featureFlag && !(0,_js_features__WEBPACK_IMPORTED_MODULE_0__.isFeatureEnabled)(notification.featureFlag, _enabledFeatureFlags ? new Set(_enabledFeatureFlags) : undefined)) {
    return false;
  }
  if (notification.groupID !== groupID) {
    return false;
  }
  if (notification.viewContexts?.length && viewContext && !notification.viewContexts.includes(viewContext)) {
    return false;
  }
  if (notification.isDismissible && isDismissed) {
    return false;
  }
  return true;
}

/***/ }),

/***/ "./js/hooks/useActivateModuleCallback.js":
/*!***********************************************!*\
  !*** ./js/hooks/useActivateModuleCallback.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useActivateModuleCallback)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./useViewContext */ "./js/hooks/useViewContext.js");
/**
 * `useActivateModuleCallback` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









/**
 * Returns a callback to activate a module. If the call to activate the module is successful, navigate to the reauthentication URL.
 * Returns null if the module doesn't exist or the user can't manage options.
 *
 * @since 1.70.0
 *
 * @param {string} moduleSlug Module slug.
 * @return {Function|null} Callback to activate module, null if the module doesn't exist or the user can't manage options.
 */
function useActivateModuleCallback(moduleSlug) {
  const viewContext = (0,_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getModule(moduleSlug));
  const canManageOptions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.PERMISSION_MANAGE_OPTIONS));
  const {
    activateModule
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_LOCATION);
  const {
    setInternalServerError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE);
  const activateModuleCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(async () => {
    const {
      error,
      response
    } = await activateModule(moduleSlug);
    if (!error) {
      await (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_widget-activation-cta`, 'activate_module', moduleSlug);
      await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_1__.setItem)('module_setup', moduleSlug, {
        ttl: 300
      });
      navigateTo(response.moduleReauthURL);
    } else {
      setInternalServerError({
        id: `${moduleSlug}-setup-error`,
        description: error.message
      });
    }
  }, [activateModule, moduleSlug, navigateTo, setInternalServerError, viewContext]);
  if (!module?.name || !canManageOptions) {
    return null;
  }
  return activateModuleCallback;
}

/***/ }),

/***/ "./js/hooks/useBreakpoint.ts":
/*!***********************************!*\
  !*** ./js/hooks/useBreakpoint.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAKPOINT_DESKTOP: () => (/* binding */ BREAKPOINT_DESKTOP),
/* harmony export */   BREAKPOINT_SMALL: () => (/* binding */ BREAKPOINT_SMALL),
/* harmony export */   BREAKPOINT_TABLET: () => (/* binding */ BREAKPOINT_TABLET),
/* harmony export */   BREAKPOINT_XLARGE: () => (/* binding */ BREAKPOINT_XLARGE),
/* harmony export */   useBreakpoint: () => (/* binding */ useBreakpoint)
/* harmony export */ });
/* harmony import */ var _useWindowSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useWindowSize */ "./js/hooks/useWindowSize.ts");
/**
 * `useBreakpoint` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Breakpoint for an extra large screen (over `1280px` wide).
 */
const BREAKPOINT_XLARGE = 'xlarge';
/**
 * Breakpoint for a desktop screen (over `960px` wide).
 */
const BREAKPOINT_DESKTOP = 'desktop';
/**
 * Breakpoint for a tablet screen (over `600px` wide).
 */
const BREAKPOINT_TABLET = 'tablet';
/**
 * Breakpoint for a mobile phone screen (any screen `600px` wide or less).
 */
const BREAKPOINT_SMALL = 'small';

/**
 * Retrieves the current breakpoint.
 *
 * @since 1.29.0
 *
 * @return {string} The current breakpoint according to the window size.
 */
function useBreakpoint() {
  const windowWidth = (0,_useWindowSize__WEBPACK_IMPORTED_MODULE_0__.useWindowWidth)();
  if (windowWidth > 1280) {
    return BREAKPOINT_XLARGE;
  }
  if (windowWidth > 960) {
    return BREAKPOINT_DESKTOP;
  }
  if (windowWidth > 600) {
    return BREAKPOINT_TABLET;
  }
  return BREAKPOINT_SMALL;
}

/***/ }),

/***/ "./js/hooks/useFormValue.js":
/*!**********************************!*\
  !*** ./js/hooks/useFormValue.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFormValue)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/**
 * Form value hook.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the value of a form field.
 *
 * @since 1.160.0
 *
 * @param {string} formName The name of the form.
 * @param {string} key      The key of the form field.
 * @return {string|number|boolean|Array|Object|undefined} The value of the form field, or the default value if provided.
 */
function useFormValue(formName, key) {
  return (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["default"])(select => {
    const {
      getValue
    } = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_FORMS);
    return getValue(formName, key);
  }, [formName, key]);
}

/***/ }),

/***/ "./js/hooks/useModuleGatheringZeroData.js":
/*!************************************************!*\
  !*** ./js/hooks/useModuleGatheringZeroData.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useModuleGatheringZeroData)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/* harmony import */ var _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/search-console/datastore/constants */ "./js/modules/search-console/datastore/constants.js");
/* harmony import */ var _useViewOnly__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./useViewOnly */ "./js/hooks/useViewOnly.js");
/**
 * `useModuleGatheringZeroData` hook.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */









/**
 * Determines if either Search Console or Analytics is in gathering or zero data states.
 *
 * @since 1.134.0
 *
 * @return {Object} Individual boolean|undefined values for Gathering and Zero data states for both modules.
 */
function useModuleGatheringZeroData() {
  const viewOnly = (0,_useViewOnly__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const isAnalyticsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_3__.MODULE_SLUG_ANALYTICS_4));
  const canViewSharedAnalytics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!viewOnly) {
      return true;
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).canViewSharedModule(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_3__.MODULE_SLUG_ANALYTICS_4);
  });
  const canViewSharedSearchConsole = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!viewOnly) {
      return true;
    }
    return select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).canViewSharedModule(_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_SEARCH_CONSOLE);
  });
  const showRecoverableAnalytics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!viewOnly) {
      return false;
    }
    const recoverableModules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getRecoverableModules();
    if (recoverableModules === undefined) {
      return undefined;
    }
    return Object.keys(recoverableModules).includes(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_3__.MODULE_SLUG_ANALYTICS_4);
  });
  const showRecoverableSearchConsole = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => {
    if (!viewOnly) {
      return false;
    }
    const recoverableModules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getRecoverableModules();
    if (recoverableModules === undefined) {
      return undefined;
    }
    return Object.keys(recoverableModules).includes(_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_5__.MODULE_SLUG_SEARCH_CONSOLE);
  });
  const analyticsGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect)(select => isAnalyticsConnected && canViewSharedAnalytics && false === showRecoverableAnalytics ? select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4).isGatheringData() : false, [isAnalyticsConnected, canViewSharedAnalytics, showRecoverableAnalytics]);
  const searchConsoleGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect)(select => canViewSharedSearchConsole && false === showRecoverableSearchConsole && select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).isGatheringData(), [canViewSharedSearchConsole, showRecoverableSearchConsole]);
  const analyticsHasZeroData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect)(select => isAnalyticsConnected && canViewSharedAnalytics && false === showRecoverableAnalytics ? select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4).hasZeroData() : false, [isAnalyticsConnected, canViewSharedAnalytics, showRecoverableAnalytics]);
  const searchConsoleHasZeroData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useInViewSelect)(select => canViewSharedSearchConsole && false === showRecoverableSearchConsole && select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).hasZeroData(), [canViewSharedSearchConsole, showRecoverableSearchConsole]);
  return {
    analyticsGatheringData,
    searchConsoleGatheringData,
    analyticsHasZeroData,
    searchConsoleHasZeroData
  };
}

/***/ }),

/***/ "./js/hooks/useQueryArg.js":
/*!*********************************!*\
  !*** ./js/hooks/useQueryArg.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/add-query-args.js");
/**
 * `useQueryArg` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Uses a location query param as a variable in a component.
 *
 * @since 1.24.0
 *
 * @param {string} key            The query param key to be used.
 * @param {string} [initialValue] Optional. The initial value for the query param to be used.
 * @param {Object} [_global]      The global window object.
 * @return {Array} The getter and setter for the query param state.
 */
function useQueryArg(key, initialValue, _global = __webpack_require__.g) {
  const [value, setValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_1__.getQueryArg)(_global.location.href, key) || initialValue);
  function onSetValue(newValue) {
    setValue(newValue);
    const newURL = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_2__.addQueryArgs)(_global.location.href, {
      [key]: newValue
    });
    _global.history.replaceState(null, '', newURL);
  }
  return [value, onSetValue];
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useQueryArg);

/***/ }),

/***/ "./js/hooks/useViewContext.js":
/*!************************************!*\
  !*** ./js/hooks/useViewContext.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/**
 * `useViewContext` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


/**
 * Returns the current Site Kit viewing context, eg. "dashboard",
 * "entity dashboard", "view-only dashboard", etc.
 *
 * @since 1.74.0
 *
 * @return {string} The current "viewing context" value for the plugin.
 */
function useViewContext() {
  const viewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useContext)(_js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return viewContext;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useViewContext);

/***/ }),

/***/ "./js/hooks/useViewOnly.js":
/*!*********************************!*\
  !*** ./js/hooks/useViewOnly.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useViewOnly)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useViewContext */ "./js/hooks/useViewContext.js");
/**
 * `useViewOnly` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Determines if the current view context is a "view only" dashboard context.
 *
 * @since 1.72.0
 *
 * @return {boolean} True if current context is a view-only dashboard context, false otherwise.
 */
function useViewOnly() {
  const viewContext = (0,_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.SITE_KIT_VIEW_ONLY_CONTEXTS.includes(viewContext);
}

/***/ }),

/***/ "./js/hooks/useWindowSize.ts":
/*!***********************************!*\
  !*** ./js/hooks/useWindowSize.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useWindowHeight: () => (/* binding */ useWindowHeight),
/* harmony export */   useWindowSize: () => (/* binding */ useWindowSize),
/* harmony export */   useWindowWidth: () => (/* binding */ useWindowWidth)
/* harmony export */ });
/* harmony import */ var _react_hook_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-hook/event */ "../node_modules/@react-hook/event/dist/module/index.js");
/* harmony import */ var _react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @react-hook/throttle */ "../node_modules/@react-hook/throttle/dist/module/index.js");
/**
 * `useWindowSize` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Copied from https://github.com/jaredLunde/react-hook/blob/b8ac9515e26937e838a36a27001dc46c7f46a390/packages/window-size/throttled/src/index.tsx
// Modified to use global.innerWidth and global.innerHeight instead of document.documentElement.clientWidth and document.documentElement.clientHeight.

/**
 * External dependencies
 */


function getSize() {
  return [__webpack_require__.g.innerWidth, __webpack_require__.g.innerHeight];
}
function useWindowSize({
  fps = 60,
  leading = false,
  initialWidth = 0,
  initialHeight = 0
} = {}) {
  const [size, setThrottledSize] = (0,_react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__.useThrottle)(/* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);
  function setSize() {
    return setThrottledSize(getSize);
  }
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'resize', setSize);
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'orientationchange', setSize);
  return size;
}
function useWindowHeight(options = {}) {
  return useWindowSize(options)[1];
}
function useWindowWidth(options = {}) {
  return useWindowSize(options)[0];
}

/***/ }),

/***/ "./js/material-components/index.js":
/*!*****************************************!*\
  !*** ./js/material-components/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Cell),
/* harmony export */   Dialog: () => (/* reexport default from dynamic */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default.a),
/* harmony export */   DialogContent: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogContent),
/* harmony export */   DialogFooter: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogFooter),
/* harmony export */   Grid: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Grid),
/* harmony export */   MDCCheckbox: () => (/* reexport safe */ _material_checkbox__WEBPACK_IMPORTED_MODULE_7__.MDCCheckbox),
/* harmony export */   MDCDialog: () => (/* reexport safe */ _material_dialog__WEBPACK_IMPORTED_MODULE_6__.MDCDialog),
/* harmony export */   MDCFormField: () => (/* reexport safe */ _material_form_field__WEBPACK_IMPORTED_MODULE_3__.MDCFormField),
/* harmony export */   MDCMenu: () => (/* reexport safe */ _material_menu__WEBPACK_IMPORTED_MODULE_8__.MDCMenu),
/* harmony export */   MDCRadio: () => (/* reexport safe */ _material_radio__WEBPACK_IMPORTED_MODULE_4__.MDCRadio),
/* harmony export */   MDCRipple: () => (/* reexport safe */ _material_ripple__WEBPACK_IMPORTED_MODULE_2__.MDCRipple),
/* harmony export */   MDCSwitch: () => (/* reexport safe */ _material_switch__WEBPACK_IMPORTED_MODULE_5__.MDCSwitch),
/* harmony export */   Row: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Row)
/* harmony export */ });
/* harmony import */ var _material_checkbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material/checkbox */ "../node_modules/@material/checkbox/component.js");
/* harmony import */ var _material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/dialog */ "../node_modules/@material/dialog/component.js");
/* harmony import */ var _material_form_field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/form-field */ "../node_modules/@material/form-field/component.js");
/* harmony import */ var _material_menu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material/menu */ "../node_modules/@material/menu/component.js");
/* harmony import */ var _material_radio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material/radio */ "../node_modules/@material/radio/component.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-dialog */ "../node_modules/@material/react-dialog/dist/index.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_dialog__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ripple__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/ripple */ "../node_modules/@material/ripple/component.js");
/* harmony import */ var _material_switch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/switch */ "../node_modules/@material/switch/component.js");
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./layout */ "./js/material-components/layout/index.js");
/**
 * Material components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */











/***/ }),

/***/ "./js/material-components/layout/Cell.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Cell.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cell)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Cell component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Cell(props) {
  const {
    className,
    alignTop,
    alignMiddle,
    alignBottom,
    alignRight,
    alignLeft,
    smAlignRight,
    mdAlignRight,
    lgAlignRight,
    smSize,
    smStart,
    smOrder,
    mdSize,
    mdStart,
    mdOrder,
    lgSize,
    lgStart,
    lgOrder,
    size,
    children,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'mdc-layout-grid__cell', {
      'mdc-layout-grid__cell--align-top': alignTop,
      'mdc-layout-grid__cell--align-middle': alignMiddle,
      'mdc-layout-grid__cell--align-bottom': alignBottom,
      'mdc-layout-grid__cell--align-right': alignRight,
      'mdc-layout-grid__cell--align-left': alignLeft,
      'mdc-layout-grid__cell--align-right-phone': smAlignRight,
      'mdc-layout-grid__cell--align-right-tablet': mdAlignRight,
      'mdc-layout-grid__cell--align-right-desktop': lgAlignRight,
      [`mdc-layout-grid__cell--span-${size}`]: 12 >= size && size > 0,
      [`mdc-layout-grid__cell--span-${lgSize}-desktop`]: 12 >= lgSize && lgSize > 0,
      [`mdc-layout-grid__cell--start-${lgStart}-desktop`]: 12 >= lgStart && lgStart > 0,
      [`mdc-layout-grid__cell--order-${lgOrder}-desktop`]: 12 >= lgOrder && lgOrder > 0,
      [`mdc-layout-grid__cell--span-${mdSize}-tablet`]: 8 >= mdSize && mdSize > 0,
      [`mdc-layout-grid__cell--start-${mdStart}-tablet`]: 8 >= mdStart && mdStart > 0,
      [`mdc-layout-grid__cell--order-${mdOrder}-tablet`]: 8 >= mdOrder && mdOrder > 0,
      [`mdc-layout-grid__cell--span-${smSize}-phone`]: 4 >= smSize && smSize > 0,
      [`mdc-layout-grid__cell--start-${smStart}-phone`]: 4 >= smStart && smStart > 0,
      [`mdc-layout-grid__cell--order-${smOrder}-phone`]: 4 >= smOrder && smOrder > 0
    }),
    children: children
  });
}
Cell.propTypes = {
  smSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  alignTop: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignMiddle: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignBottom: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  smAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  mdAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  lgAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
Cell.defaultProps = {
  className: '',
  size: 0,
  smSize: 0,
  smStart: 0,
  smOrder: 0,
  mdSize: 0,
  mdStart: 0,
  mdOrder: 0,
  lgSize: 0,
  lgStart: 0,
  lgOrder: 0
};

/***/ }),

/***/ "./js/material-components/layout/Grid.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Grid.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Grid component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Grid = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  alignLeft,
  fill,
  className,
  children,
  collapsed,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid', className, {
      'mdc-layout-grid--align-left': alignLeft,
      'mdc-layout-grid--collapsed': collapsed,
      'mdc-layout-grid--fill': fill
    }),
    ...otherProps,
    ref: ref,
    children: children
  });
});
Grid.displayName = 'Grid';
Grid.propTypes = {
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  fill: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Grid.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Grid);

/***/ }),

/***/ "./js/material-components/layout/Row.js":
/*!**********************************************!*\
  !*** ./js/material-components/layout/Row.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Row component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Row = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid__inner', className),
    ...otherProps,
    children: children
  });
});
Row.displayName = 'Row';
Row.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Row.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Row);

/***/ }),

/***/ "./js/material-components/layout/index.js":
/*!************************************************!*\
  !*** ./js/material-components/layout/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _Cell__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Grid: () => (/* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Row: () => (/* reexport safe */ _Row__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _Cell__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cell */ "./js/material-components/layout/Cell.js");
/* harmony import */ var _Row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Row */ "./js/material-components/layout/Row.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Grid */ "./js/material-components/layout/Grid.js");
/**
 * Material UI > Layout components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "./js/modules/adsense/constants.js":
/*!*****************************************!*\
  !*** ./js/modules/adsense/constants.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ADSENSE_CTA_WIDGET_DISMISSED_ITEM_KEY: () => (/* binding */ ADSENSE_CTA_WIDGET_DISMISSED_ITEM_KEY),
/* harmony export */   ADSENSE_CTA_WIDGET_TOOLTIP_STATE_KEY: () => (/* binding */ ADSENSE_CTA_WIDGET_TOOLTIP_STATE_KEY),
/* harmony export */   ADSENSE_GA4_TOP_EARNING_PAGES_NOTICE_DISMISSED_ITEM_KEY: () => (/* binding */ ADSENSE_GA4_TOP_EARNING_PAGES_NOTICE_DISMISSED_ITEM_KEY),
/* harmony export */   MODULE_SLUG_ADSENSE: () => (/* binding */ MODULE_SLUG_ADSENSE)
/* harmony export */ });
/**
 * AdSense module constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const ADSENSE_CTA_WIDGET_DISMISSED_ITEM_KEY = 'adsense-connect-cta';
const ADSENSE_CTA_WIDGET_TOOLTIP_STATE_KEY = 'adsense-connect-cta-tooltip-state';
const ADSENSE_GA4_TOP_EARNING_PAGES_NOTICE_DISMISSED_ITEM_KEY = 'adsense-ga4-top-earnings-notice';
const MODULE_SLUG_ADSENSE = 'adsense';

/***/ }),

/***/ "./js/modules/analytics-4/constants.js":
/*!*********************************************!*\
  !*** ./js/modules/analytics-4/constants.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY: () => (/* binding */ ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY),
/* harmony export */   ACTIVATION_STEP_IN_PROGRESS: () => (/* binding */ ACTIVATION_STEP_IN_PROGRESS),
/* harmony export */   ACTIVATION_STEP_REMINDER: () => (/* binding */ ACTIVATION_STEP_REMINDER),
/* harmony export */   ACTIVATION_STEP_SETUP: () => (/* binding */ ACTIVATION_STEP_SETUP),
/* harmony export */   ACTIVATION_STEP_SUCCESS: () => (/* binding */ ACTIVATION_STEP_SUCCESS),
/* harmony export */   ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY: () => (/* binding */ ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY),
/* harmony export */   GA4_ACTIVATION_BANNER_STATE_KEY: () => (/* binding */ GA4_ACTIVATION_BANNER_STATE_KEY),
/* harmony export */   GA4_AUTO_SWITCH_DATE: () => (/* binding */ GA4_AUTO_SWITCH_DATE),
/* harmony export */   KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY: () => (/* binding */ KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY),
/* harmony export */   LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY: () => (/* binding */ LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY),
/* harmony export */   MODULE_SLUG_ANALYTICS_4: () => (/* binding */ MODULE_SLUG_ANALYTICS_4),
/* harmony export */   REPORT_ARGS_DATA_FILTERS_KEY: () => (/* binding */ REPORT_ARGS_DATA_FILTERS_KEY),
/* harmony export */   REPORT_ARGS_NAV_KEY: () => (/* binding */ REPORT_ARGS_NAV_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_DIMENSION_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_DIMENSION_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_METRIC_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_METRIC_KEY)
/* harmony export */ });
/**
 * GA4 module constants.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const ACTIVATION_STEP_REMINDER = 0;
const ACTIVATION_STEP_SETUP = 1;
const ACTIVATION_STEP_SUCCESS = 2;
const ACTIVATION_STEP_IN_PROGRESS = 3;
const ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY = 'activation-acknowledgement-tooltip-state';
const GA4_ACTIVATION_BANNER_STATE_KEY = 'ga4-activation-banner-state';
const ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY = 'enhanced-measurement-activation-banner-tooltip-state';
const LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY = 'enhanced-measurement-activation-banner-dismissed-item';
const REPORT_ARGS_SELECTED_METRIC_KEY = '_r.explorerCard..selmet';
const REPORT_ARGS_SELECTED_DIMENSION_KEY = '_r.explorerCard..seldim';
const REPORT_ARGS_DATA_FILTERS_KEY = '_r..dataFilters';
const REPORT_ARGS_NAV_KEY = '_r..nav';
const KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY = 'key-metrics-connect-ga4-cta-widget';

/**
 * Date that Site Kit will automatically switch to using GA4: September 25, 2023.
 *
 * With Site Kit's maximum date range being three months, once this period has passed since the UA cutoff date,
 * it will no longer be able to show any historical data for UA and will automatically switch to GA4.
 * For operational reasons, we automatically make the switch a few days before the three month cutoff point.
 *
 * @since 1.107.0
 * @see UA_CUTOFF_DATE.
 */
const GA4_AUTO_SWITCH_DATE = '2023-09-25';
const MODULE_SLUG_ANALYTICS_4 = 'analytics-4';

/***/ }),

/***/ "./js/modules/analytics-4/datastore/constants.js":
/*!*******************************************************!*\
  !*** ./js/modules/analytics-4/datastore/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCOUNT_CREATE: () => (/* binding */ ACCOUNT_CREATE),
/* harmony export */   AUDIENCE_FILTER_CLAUSE_TYPE_ENUM: () => (/* binding */ AUDIENCE_FILTER_CLAUSE_TYPE_ENUM),
/* harmony export */   AUDIENCE_FILTER_SCOPE_ENUM: () => (/* binding */ AUDIENCE_FILTER_SCOPE_ENUM),
/* harmony export */   AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX: () => (/* binding */ AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX),
/* harmony export */   AUDIENCE_SEGMENTATION_SETUP_FORM: () => (/* binding */ AUDIENCE_SEGMENTATION_SETUP_FORM),
/* harmony export */   AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE: () => (/* binding */ AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE),
/* harmony export */   AUDIENCE_TYPE_SORT_ORDER: () => (/* binding */ AUDIENCE_TYPE_SORT_ORDER),
/* harmony export */   CONVERSION_REPORTING_LEAD_EVENTS: () => (/* binding */ CONVERSION_REPORTING_LEAD_EVENTS),
/* harmony export */   CUSTOM_DIMENSION_DEFINITIONS: () => (/* binding */ CUSTOM_DIMENSION_DEFINITIONS),
/* harmony export */   DATE_RANGE_OFFSET: () => (/* binding */ DATE_RANGE_OFFSET),
/* harmony export */   EDIT_SCOPE: () => (/* binding */ EDIT_SCOPE),
/* harmony export */   ENHANCED_MEASUREMENT_ENABLED: () => (/* binding */ ENHANCED_MEASUREMENT_ENABLED),
/* harmony export */   ENHANCED_MEASUREMENT_FORM: () => (/* binding */ ENHANCED_MEASUREMENT_FORM),
/* harmony export */   ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER: () => (/* binding */ ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER),
/* harmony export */   ENUM_CONVERSION_EVENTS: () => (/* binding */ ENUM_CONVERSION_EVENTS),
/* harmony export */   FORM_ACCOUNT_CREATE: () => (/* binding */ FORM_ACCOUNT_CREATE),
/* harmony export */   FORM_CUSTOM_DIMENSIONS_CREATE: () => (/* binding */ FORM_CUSTOM_DIMENSIONS_CREATE),
/* harmony export */   FORM_SETUP: () => (/* binding */ FORM_SETUP),
/* harmony export */   GTM_SCOPE: () => (/* binding */ GTM_SCOPE),
/* harmony export */   MAX_WEBDATASTREAMS_PER_BATCH: () => (/* binding */ MAX_WEBDATASTREAMS_PER_BATCH),
/* harmony export */   MODULES_ANALYTICS_4: () => (/* binding */ MODULES_ANALYTICS_4),
/* harmony export */   PROPERTY_CREATE: () => (/* binding */ PROPERTY_CREATE),
/* harmony export */   PROVISIONING_SCOPE: () => (/* binding */ PROVISIONING_SCOPE),
/* harmony export */   RESOURCE_TYPES: () => (/* binding */ RESOURCE_TYPES),
/* harmony export */   RESOURCE_TYPE_AUDIENCE: () => (/* binding */ RESOURCE_TYPE_AUDIENCE),
/* harmony export */   RESOURCE_TYPE_CUSTOM_DIMENSION: () => (/* binding */ RESOURCE_TYPE_CUSTOM_DIMENSION),
/* harmony export */   RESOURCE_TYPE_PROPERTY: () => (/* binding */ RESOURCE_TYPE_PROPERTY),
/* harmony export */   SITE_KIT_AUDIENCE_DEFINITIONS: () => (/* binding */ SITE_KIT_AUDIENCE_DEFINITIONS),
/* harmony export */   UI_ACTIVE_ROW_INDEX: () => (/* binding */ UI_ACTIVE_ROW_INDEX),
/* harmony export */   UI_ALL_TRAFFIC_LOADED: () => (/* binding */ UI_ALL_TRAFFIC_LOADED),
/* harmony export */   UI_DIMENSION_COLOR: () => (/* binding */ UI_DIMENSION_COLOR),
/* harmony export */   UI_DIMENSION_NAME: () => (/* binding */ UI_DIMENSION_NAME),
/* harmony export */   UI_DIMENSION_VALUE: () => (/* binding */ UI_DIMENSION_VALUE),
/* harmony export */   WEBDATASTREAM_CREATE: () => (/* binding */ WEBDATASTREAM_CREATE)
/* harmony export */ });
/**
 * `modules/analytics-4` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_ANALYTICS_4 = 'modules/analytics-4';

// A special Account ID value used for the "Set up a new account" option.
const ACCOUNT_CREATE = 'account_create';

// A special Property ID value used for the "Set up a new property" option.
const PROPERTY_CREATE = 'property_create';
const WEBDATASTREAM_CREATE = 'webdatastream_create';
const FORM_SETUP = 'analyticsSetup';
const MAX_WEBDATASTREAMS_PER_BATCH = 10;

// Date range offset days for Analytics 4 report requests.
const DATE_RANGE_OFFSET = 0;
const GTM_SCOPE = 'https://www.googleapis.com/auth/tagmanager.readonly';
const ENHANCED_MEASUREMENT_FORM = 'enhanced-measurement-form';
const ENHANCED_MEASUREMENT_ENABLED = 'enhanced-measurement-enabled';
const ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER = 'enhanced-measurement-should-dismiss-activation-banner';

// Form ID for the account creation form.
const FORM_ACCOUNT_CREATE = 'analyticsAccountCreate';
const FORM_CUSTOM_DIMENSIONS_CREATE = 'analyticsCustomDimensionsCreate';

// OAuth scope required for provisioning a Google Analytics account.
const PROVISIONING_SCOPE = 'https://www.googleapis.com/auth/analytics.provision';
const EDIT_SCOPE = 'https://www.googleapis.com/auth/analytics.edit';

// Dashboard widget constants.
const UI_DIMENSION_NAME = 'dashboardAllTrafficWidgetDimensionName';
const UI_DIMENSION_COLOR = 'dashboardAllTrafficWidgetDimensionColor';
const UI_DIMENSION_VALUE = 'dashboardAllTrafficWidgetDimensionValue';
const UI_ACTIVE_ROW_INDEX = 'dashboardAllTrafficWidgetActiveRowIndex';
const UI_ALL_TRAFFIC_LOADED = 'dashboardAllTrafficWidgetLoaded';

// Note: names and descriptions are not translated as these are not surfaced in Site Kit
// and are also subject to hard limits on the length which would be unpredictable if translated.
// See https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1beta/properties.customDimensions#CustomDimension
const CUSTOM_DIMENSION_DEFINITIONS = {
  googlesitekit_post_date: {
    parameterName: 'googlesitekit_post_date',
    displayName: 'WordPress Post Date',
    description: 'Created by Site Kit: Date when a post was published',
    scope: 'EVENT'
  },
  googlesitekit_post_author: {
    parameterName: 'googlesitekit_post_author',
    displayName: 'WordPress Post Author',
    description: 'Created by Site Kit: WordPress name of the post author',
    scope: 'EVENT'
  },
  googlesitekit_post_categories: {
    parameterName: 'googlesitekit_post_categories',
    displayName: 'WordPress Post Categories',
    description: 'Created by Site Kit: Names of categories assigned to a post',
    scope: 'EVENT'
  },
  googlesitekit_post_type: {
    parameterName: 'googlesitekit_post_type',
    displayName: 'WordPress Post Type',
    description: 'Created by Site Kit: Content type of a post',
    scope: 'EVENT'
  }
};
const ENUM_CONVERSION_EVENTS = {
  ADD_TO_CART: 'add_to_cart',
  PURCHASE: 'purchase',
  SUBMIT_LEAD_FORM: 'submit_lead_form',
  GENERATE_LEAD: 'generate_lead',
  CONTACT: 'contact'
};
const CONVERSION_REPORTING_LEAD_EVENTS = [ENUM_CONVERSION_EVENTS.CONTACT, ENUM_CONVERSION_EVENTS.GENERATE_LEAD, ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM];

// Audience enums.
const AUDIENCE_FILTER_CLAUSE_TYPE_ENUM = {
  AUDIENCE_CLAUSE_TYPE_UNSPECIFIED: 'AUDIENCE_CLAUSE_TYPE_UNSPECIFIED',
  INCLUDE: 'INCLUDE',
  EXCLUDE: 'EXCLUDE'
};
const AUDIENCE_FILTER_SCOPE_ENUM = {
  AUDIENCE_FILTER_SCOPE_UNSPECIFIED: 'AUDIENCE_FILTER_SCOPE_UNSPECIFIED',
  AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT: 'AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT',
  AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION: 'AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION',
  AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS'
};
const SITE_KIT_AUDIENCE_DEFINITIONS = {
  'new-visitors': {
    description: 'People who visited the site for the first time',
    displayName: 'New visitors',
    membershipDurationDays: -1,
    // The longest duration, 540 days.
    filterClauses: [{
      clauseType: 'INCLUDE',
      simpleFilter: {
        scope: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS',
        filterExpression: {
          andGroup: {
            filterExpressions: [{
              orGroup: {
                filterExpressions: [{
                  dimensionOrMetricFilter: {
                    fieldName: 'newVsReturning',
                    stringFilter: {
                      matchType: 'EXACT',
                      value: 'new'
                    }
                  }
                }]
              }
            }, {
              orGroup: {
                filterExpressions: [{
                  notExpression: {
                    dimensionOrMetricFilter: {
                      fieldName: 'groupId',
                      stringFilter: {
                        matchType: 'EXACT',
                        value: 'created_by_googlesitekit:new_visitors'
                      }
                    }
                  }
                }]
              }
            }]
          }
        }
      }
    }]
  },
  'returning-visitors': {
    description: 'People who have visited your site at least once before',
    displayName: 'Returning visitors',
    membershipDurationDays: -1,
    // The longest duration, 540 days.
    filterClauses: [{
      clauseType: 'INCLUDE',
      simpleFilter: {
        scope: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS',
        filterExpression: {
          andGroup: {
            filterExpressions: [{
              orGroup: {
                filterExpressions: [{
                  dimensionOrMetricFilter: {
                    fieldName: 'newVsReturning',
                    stringFilter: {
                      matchType: 'EXACT',
                      value: 'returning'
                    }
                  }
                }]
              }
            }, {
              orGroup: {
                filterExpressions: [{
                  notExpression: {
                    dimensionOrMetricFilter: {
                      fieldName: 'groupId',
                      stringFilter: {
                        matchType: 'EXACT',
                        value: 'created_by_googlesitekit:returning_visitors'
                      }
                    }
                  }
                }]
              }
            }]
          }
        }
      }
    }]
  }
};
const AUDIENCE_SEGMENTATION_SETUP_FORM = 'audiencePermissionsSetup';
const AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE = 'audienceTileCustomDimensionCreate';
const AUDIENCE_TYPE_SORT_ORDER = {
  USER_AUDIENCE: 0,
  SITE_KIT_AUDIENCE: 1,
  DEFAULT_AUDIENCE: 2
};
const AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX = 'audience-selection-panel-expirable-new-badge-';
const RESOURCE_TYPE_AUDIENCE = 'audience';
const RESOURCE_TYPE_CUSTOM_DIMENSION = 'customDimension';
const RESOURCE_TYPE_PROPERTY = 'property';
const RESOURCE_TYPES = [RESOURCE_TYPE_AUDIENCE, RESOURCE_TYPE_CUSTOM_DIMENSION, RESOURCE_TYPE_PROPERTY];

/***/ }),

/***/ "./js/modules/analytics-4/utils/chart.js":
/*!***********************************************!*\
  !*** ./js/modules/analytics-4/utils/chart.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extractAnalyticsDataForPieChart: () => (/* binding */ extractAnalyticsDataForPieChart),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Analytics utility functions.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Extracts data required for a pie chart from the Analytics 4 report information.
 *
 * @since 1.96.0
 *
 * @param {Array}    report                    The report data.
 * @param {Object}   [options]                 Optional. Data extraction options.
 * @param {number}   [options.keyColumnIndex]  Optional. The number of a column to extract metrics data from.
 * @param {number}   [options.maxSlices]       Optional. Limit the number of slices to display.
 * @param {boolean}  [options.withOthers]      Optional. Whether to add "Others" record to the data map. Only relevant
 *                                             if `maxSlices` is passed. If passed, the final slice will be the
 *                                             "Others" slice, i.e. the number of actual row slices will be
 *                                             `maxSlices - 1`.
 * @param {Function} [options.tooltipCallback] Optional. A callback function for tooltip column values.
 * @return {Array} Extracted data.
 */
function extractAnalyticsDataForPieChart(report, options = {}) {
  const {
    keyColumnIndex = 0,
    maxSlices,
    withOthers = false,
    tooltipCallback
  } = options;
  const {
    rows = []
  } = report || {};
  const withTooltips = typeof tooltipCallback === 'function';
  const columns = ['Source', 'Percent'];
  if (withTooltips) {
    columns.push({
      type: 'string',
      role: 'tooltip',
      p: {
        html: true
      }
    });
  }
  const dataMap = [columns];
  const currentDateRangeRows = rows.filter(({
    dimensionValues
  }) => dimensionValues[1].value === 'date_range_0');
  const totalCurrent = currentDateRangeRows.reduce((sum, row) => sum + parseInt(row.metricValues[0].value, 10), 0);
  const previousDateRangeRows = rows.filter(({
    dimensionValues
  }) => dimensionValues[1].value === 'date_range_1');
  const totalPrevious = previousDateRangeRows.reduce((sum, row) => sum + parseInt(row.metricValues[0].value, 10), 0);
  let hasOthers = withOthers;
  let rowsNumber = currentDateRangeRows.length;
  let othersCurrent = totalCurrent;
  let othersPrevious = totalPrevious;
  if (maxSlices > 0) {
    hasOthers = withOthers && currentDateRangeRows.length > maxSlices;
    rowsNumber = Math.min(currentDateRangeRows.length, hasOthers ? maxSlices - 1 : maxSlices);
  } else {
    hasOthers = false;
    rowsNumber = currentDateRangeRows.length;
  }
  for (let i = 0; i < rowsNumber; i++) {
    const row = currentDateRangeRows[i];
    const usersCurrent = row.metricValues[keyColumnIndex].value;
    const previousRow = previousDateRangeRows.find(({
      dimensionValues
    }) => dimensionValues[0].value === row.dimensionValues[0].value);
    const usersPrevious = previousRow ? previousRow.metricValues[keyColumnIndex].value : 0;
    othersCurrent -= usersCurrent;
    othersPrevious -= usersPrevious;
    const percent = totalCurrent > 0 ? usersCurrent / totalCurrent : 0;
    const rowData = [row.dimensionValues[0].value, percent];
    if (withTooltips) {
      const previousDateRangeRow = rows.find(({
        dimensionValues
      }) => dimensionValues[1].value === 'date_range_1' && dimensionValues[0].value === row.dimensionValues[0].value);
      rowData.push(tooltipCallback(row, previousDateRangeRow, rowData));
    }
    dataMap.push(rowData);
  }
  if (hasOthers && othersCurrent > 0) {
    const rowData = [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Others', 'google-site-kit'), othersCurrent / totalCurrent];
    if (withTooltips) {
      rowData.push(tooltipCallback({
        metricValues: [{
          value: othersCurrent
        }]
      }, {
        metricValues: [{
          value: othersPrevious
        }]
      }, rowData));
    }
    dataMap.push(rowData);
  }
  return dataMap;
}

/**
 * Checks if there is a single row of data or one row of the provided GA4 report is contributing 100% of the total for a given dimension.
 *
 * Note that chart reports will be in the multi-date range format.
 *
 * @since 1.96.0
 *
 * @param {Object} report The report data object.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  const currentDateRangeRows = (report?.rows || []).filter(({
    dimensionValues
  }) => dimensionValues[1].value === 'date_range_0');
  if (currentDateRangeRows?.length === 1 || currentDateRangeRows?.[0]?.metricValues?.[0]?.value === report?.totals?.[0]?.metricValues?.[0]?.value) {
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/extract-dashboard-data.js":
/*!****************************************************************!*\
  !*** ./js/modules/analytics-4/utils/extract-dashboard-data.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extractAnalytics4DashboardData: () => (/* binding */ extractAnalytics4DashboardData)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/i18n */ "./js/util/i18n.js");
/* harmony import */ var _parseDimensionStringToDate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseDimensionStringToDate */ "./js/modules/analytics-4/utils/parseDimensionStringToDate.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./partition-report */ "./js/modules/analytics-4/utils/partition-report.js");
/**
 * Analytics-4 Dashboard data extraction functions.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Reduces and processes an array of analytics-4 row data.
 *
 * @since 1.96.0
 *
 * @param {Array}  rows          An array of rows to reduce.
 * @param {number} selectedStats The currently selected stat we need to return data for.
 * @return {Array} Array of selected stats from analytics row data.
 */
function reduceAnalytics4RowsData(rows, selectedStats) {
  const dataMap = [];
  rows.forEach(row => {
    if (!row.metricValues) {
      return;
    }
    const {
      value
    } = row.metricValues[selectedStats];
    const dateString = row.dimensionValues[0].value;
    const date = (0,_parseDimensionStringToDate__WEBPACK_IMPORTED_MODULE_5__["default"])(dateString);
    dataMap.push([date, value]);
  });
  return dataMap;
}

/**
 * Extracts the data required from an analytics 'site-analytics' request.
 *
 * @since 1.96.0
 * @since 1.98.0 Added chartDataFormats parameter.
 *
 * @param {Object} report             The data returned from the Analytics API call.
 * @param {Array}  selectedStats      The currently selected stat we need to return data for.
 * @param {number} days               The number of days to extract data for. Pads empty data days.
 * @param {string} referenceDate      The reference date.
 * @param {Array}  dataLabels         The labels to be displayed.
 * @param {Array}  tooltipDataFormats The formats to be used for the tooltip data.
 * @param {Array}  chartDataFormats   The formats to be used for the chart data.
 * @return {Array} The dataMap ready for charting.
 */
function extractAnalytics4DashboardData(report, selectedStats, days, referenceDate, dataLabels = [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Users', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Sessions', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Engagement Rate', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Session Duration', 'google-site-kit')], tooltipDataFormats = [x => parseFloat(x).toLocaleString(), x => parseFloat(x).toLocaleString(), x => (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(x / 100, {
  style: 'percent',
  signDisplay: 'never',
  maximumFractionDigits: 2
}), x => (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(x, 's')], chartDataFormats = [lodash__WEBPACK_IMPORTED_MODULE_1__.identity, lodash__WEBPACK_IMPORTED_MODULE_1__.identity, x => x * 100, lodash__WEBPACK_IMPORTED_MODULE_1__.identity]) {
  const rows = [...(report?.rows || [])]; // Copying it to escape side effects by manipulating with rows.
  const rowLength = rows.length;

  // Pad rows to 2 x number of days data points to accommodate new accounts.
  if (days * 2 > rowLength) {
    const date = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.stringToDate)(referenceDate);
    for (let i = 0; days > i; i++) {
      const month = (date.getMonth() + 1).toString();
      const day = date.getDate().toString();
      const dateString = date.getFullYear().toString() + (2 > month.length ? '0' : '') + month + (2 > day.length ? '0' : '') + day;
      if (i > rowLength) {
        const emptyDay = [{
          dimensionValues: [{
            value: dateString
          }, {
            value: 'date_range_0'
          }],
          metricValues: [{
            value: 0
          }, {
            value: 0
          }]
        }, {
          dimensionValues: [{
            value: dateString
          }, {
            value: 'date_range_1'
          }],
          metricValues: [{
            value: 0
          }, {
            value: 0
          }]
        }];
        rows.unshift(...emptyDay);
      }
      date.setDate(date.getDate() - 1);
    }
    rows.push({
      dimensionValues: [{
        value: '0'
      }, {
        value: 'date_range_0'
      }]
    }, {
      dimensionValues: [{
        value: '0'
      }, {
        value: 'date_range_1'
      }]
    });
  }
  const isSessionDuration = dataLabels[selectedStats] === (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Session Duration', 'google-site-kit');
  const dataType = isSessionDuration ? 'timeofday' : 'number';
  const dataMap = [[{
    type: 'date',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Day', 'google-site-kit')
  }, {
    type: 'string',
    role: 'tooltip',
    p: {
      html: true
    }
  }, {
    type: dataType,
    label: dataLabels[selectedStats]
  }, {
    type: dataType,
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Previous period', 'google-site-kit')
  }]];
  const {
    compareRange,
    currentRange
  } = (0,_partition_report__WEBPACK_IMPORTED_MODULE_6__.partitionAnalytics4Report)(rows, {
    dateRangeLength: days
  });
  const lastMonthData = reduceAnalytics4RowsData(currentRange, selectedStats);
  const previousMonthData = reduceAnalytics4RowsData(compareRange, selectedStats);
  const locale = (0,_js_util_i18n__WEBPACK_IMPORTED_MODULE_4__.getLocale)();
  const localeDateOptions = {
    weekday: 'short',
    month: 'short',
    day: 'numeric'
  };
  lastMonthData.forEach((row, i) => {
    if (!row[0] || !row[1] || !previousMonthData[i]) {
      return;
    }
    const chartDataFormat = chartDataFormats[selectedStats];
    const currentMonthDatum = chartDataFormat(row[1]);
    const previousMonthDatum = chartDataFormat(previousMonthData[i][1]);
    const prevMonth = parseFloat(previousMonthDatum);
    const difference = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.calculateDifferenceBetweenChartValues)(currentMonthDatum, prevMonth);
    const svgArrow = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.getChartDifferenceArrow)(difference);
    const dateRange = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: date for user stats, 2: previous date for user stats comparison */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%1$s vs %2$s', 'Date range for chart tooltip', 'google-site-kit'), row[0].toLocaleDateString(locale, localeDateOptions), previousMonthData[i][0].toLocaleDateString(locale, localeDateOptions));
    const statInfo = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: selected stat label, 2: numeric value of selected stat, 3: up or down arrow , 4: different change in percentage */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%1$s: <strong>%2$s</strong> <em>%3$s %4$s</em>', 'Stat information for chart tooltip', 'google-site-kit'), dataLabels[selectedStats], tooltipDataFormats[selectedStats](currentMonthDatum), svgArrow, (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(Math.abs(difference), '%'));
    dataMap.push([row[0], `<div class="${classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-visualization-tooltip', {
      'googlesitekit-visualization-tooltip--up': difference > 0,
      'googlesitekit-visualization-tooltip--down': difference < 0
    })}">
				<p>${dateRange}</p>
				<p>${statInfo}</p>
			</div>`, isSessionDuration ? (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.convertSecondsToArray)(currentMonthDatum) : currentMonthDatum, isSessionDuration ? (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.convertSecondsToArray)(previousMonthDatum) : previousMonthDatum]);
  });
  return dataMap;
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/formatting.js":
/*!****************************************************!*\
  !*** ./js/modules/analytics-4/utils/formatting.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeAmpersand: () => (/* binding */ decodeAmpersand),
/* harmony export */   splitCategories: () => (/* binding */ splitCategories)
/* harmony export */ });
/**
 * Formatting helpers.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts ampersand HTML entities into characters.
 *
 * @since 1.152.0
 *
 * @param {string} input Input string.
 * @return {string} String with ampersand converted to char, if present.
 */
function decodeAmpersand(input) {
  return input.replace(/&amp;/gi, '&');
}

/**
 * Splits a string of categories separated by ; and returns an array of categories.
 * Decodes ampersands before doing so.
 *
 * @since 1.152.0
 *
 * @param {string} input Input string containing categories separated by ;.
 * @return {Array.<string>} Array of categories.
 */
function splitCategories(input) {
  return decodeAmpersand(input).split('; ');
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/index.js":
/*!***********************************************!*\
  !*** ./js/modules/analytics-4/utils/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeAmpersand: () => (/* reexport safe */ _formatting__WEBPACK_IMPORTED_MODULE_5__.decodeAmpersand),
/* harmony export */   extractAnalytics4DashboardData: () => (/* reexport safe */ _extract_dashboard_data__WEBPACK_IMPORTED_MODULE_4__.extractAnalytics4DashboardData),
/* harmony export */   extractAnalyticsDataForPieChart: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_0__.extractAnalyticsDataForPieChart),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_0__.isSingleSlice),
/* harmony export */   isValidDimensionFilters: () => (/* reexport safe */ _report_validation__WEBPACK_IMPORTED_MODULE_3__.isValidDimensionFilters),
/* harmony export */   isValidDimensions: () => (/* reexport safe */ _report_validation__WEBPACK_IMPORTED_MODULE_3__.isValidDimensions),
/* harmony export */   isValidMetricFilters: () => (/* reexport safe */ _report_validation__WEBPACK_IMPORTED_MODULE_3__.isValidMetricFilters),
/* harmony export */   isValidMetrics: () => (/* reexport safe */ _report_validation__WEBPACK_IMPORTED_MODULE_3__.isValidMetrics),
/* harmony export */   isValidOrders: () => (/* reexport safe */ _report_validation__WEBPACK_IMPORTED_MODULE_3__.isValidOrders),
/* harmony export */   isZeroReport: () => (/* reexport safe */ _is_zero_report__WEBPACK_IMPORTED_MODULE_1__.isZeroReport),
/* harmony export */   normalizeReportOptions: () => (/* reexport safe */ _report_normalization__WEBPACK_IMPORTED_MODULE_2__.normalizeReportOptions),
/* harmony export */   splitCategories: () => (/* reexport safe */ _formatting__WEBPACK_IMPORTED_MODULE_5__.splitCategories)
/* harmony export */ });
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./chart */ "./js/modules/analytics-4/utils/chart.js");
/* harmony import */ var _is_zero_report__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./is-zero-report */ "./js/modules/analytics-4/utils/is-zero-report.js");
/* harmony import */ var _report_normalization__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./report-normalization */ "./js/modules/analytics-4/utils/report-normalization.js");
/* harmony import */ var _report_validation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./report-validation */ "./js/modules/analytics-4/utils/report-validation.js");
/* harmony import */ var _extract_dashboard_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./extract-dashboard-data */ "./js/modules/analytics-4/utils/extract-dashboard-data.js");
/* harmony import */ var _formatting__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./formatting */ "./js/modules/analytics-4/utils/formatting.js");
/**
 * Analytics 4 utility functions.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */








/***/ }),

/***/ "./js/modules/analytics-4/utils/is-zero-report.js":
/*!********************************************************!*\
  !*** ./js/modules/analytics-4/utils/is-zero-report.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isZeroReport: () => (/* binding */ isZeroReport)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report utilities.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Checks whether the report data has only zero values.
 *
 * @since 1.95.0
 *
 * @param {Object} report Report data object.
 * @return {(boolean|undefined)} Returns TRUE if the report data is empty or has only zero values, FALSE if there is at least one non-zero value, or undefined if the report data is not resolved yet.
 */
function isZeroReport(report) {
  if (report === undefined) {
    return undefined;
  }

  // If there is no rows array, no totals array, or totals is an array of empty objects, this is an empty report.
  if (!report?.rows || !report?.totals || report?.totals?.every(lodash__WEBPACK_IMPORTED_MODULE_0__.isEmpty)) {
    return true;
  }

  // false means there _is_ some report data
  return !report.totals.some(totals => {
    if (!totals.metricValues) {
      return false;
    }
    return totals.metricValues.some(({
      value
    }) => value > 0);
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/parseDimensionStringToDate.js":
/*!********************************************************************!*\
  !*** ./js/modules/analytics-4/utils/parseDimensionStringToDate.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * `parseDimensionStringToDate` utility.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts a dimnension string date into a Date object accounting for differences in timezones.
 *
 * @since 1.10.0
 * @since 1.123.0 Migrated from analytics to analytics-4.
 * @private
 *
 * @param {string} dateString String representing the date in the format of `YYYYMMDD`.
 * @return {(Date|boolean)} Object representing the date passed, or false if parsing fails or a non-string is passed.
 */
function parseDimensionStringToDate(dateString) {
  if ('string' === typeof dateString && dateString.match(/[0-9]{8}/)) {
    const year = dateString.slice(0, 4);
    const monthIndex = Number(dateString.slice(4, 6)) - 1;
    const day = dateString.slice(6, 8);
    return new Date(year, monthIndex.toString(), day);
  }
  return false;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parseDimensionStringToDate);

/***/ }),

/***/ "./js/modules/analytics-4/utils/partition-report.js":
/*!**********************************************************!*\
  !*** ./js/modules/analytics-4/utils/partition-report.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionAnalytics4Report: () => (/* binding */ partitionAnalytics4Report)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Analytics-4 partition report utility.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.96.0
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionAnalytics4Report(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');
  function getRowsForDateRange(dateRange) {
    // Filter the report to get only rows that match the given date range.
    return report.filter(({
      dimensionValues: [, dateValue]
    }) => dateValue.value === dateRange);
  }

  // Use a negative date range length for reverse slicing.
  const reverseDateRangeLength = -1 * dateRangeLength;

  // Get the rows for the current date range and the compare date range.
  // The current range should always be sliced from the end.
  const currentRange = getRowsForDateRange('date_range_0').slice(reverseDateRangeLength);
  // The compare range continues from where the current left off (slicing towards the start),
  // and may be shorter (where older data is not available yet) which is fine.
  const compareRange = getRowsForDateRange('date_range_1').slice(reverseDateRangeLength * 2, reverseDateRangeLength);
  return {
    currentRange,
    compareRange
  };
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/report-normalization.js":
/*!**************************************************************!*\
  !*** ./js/modules/analytics-4/utils/report-normalization.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizeReportOptions: () => (/* binding */ normalizeReportOptions)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Analytics 4 report normalization utilities.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Normalizes report options.
 *
 * @since 1.94.0
 *
 * @param {Object} options Report options object.
 * @return {Object} Normalized options object.
 */
const normalizeReportOptions = memize__WEBPACK_IMPORTED_MODULE_1___default()(({
  metrics,
  dimensions,
  ...options
} = {}) => {
  return {
    metrics: normalizeMetrics(metrics),
    dimensions: normalizeDimensions(dimensions),
    ...options
  };
});
function normalizeMetrics(metrics) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.castArray)(metrics).map(metric => typeof metric === 'string' ? {
    name: metric
  } : metric).filter(metric => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(metric));
}
function normalizeDimensions(dimensions) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.castArray)(dimensions).map(dimension => typeof dimension === 'string' ? {
    name: dimension
  } : dimension).filter(dimension => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(dimension));
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/report-validation.js":
/*!***********************************************************!*\
  !*** ./js/modules/analytics-4/utils/report-validation.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidDimensionFilters: () => (/* binding */ isValidDimensionFilters),
/* harmony export */   isValidDimensions: () => (/* binding */ isValidDimensions),
/* harmony export */   isValidMetricFilters: () => (/* binding */ isValidMetricFilters),
/* harmony export */   isValidMetrics: () => (/* binding */ isValidMetrics),
/* harmony export */   isValidOrders: () => (/* binding */ isValidOrders)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util/report-validation */ "./js/util/report-validation.js");
/**
 * Analytics 4 reporting API validation utilities.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint complexity: [ "error", 17 ] */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Verifies that provided metrics match allowed values. Metrics can be a string,
 * an array of string, an array of objects or mix of strings and objects.
 * Objects must have a "name" property that matches the regex `/^[a-zA-Z0-9_]+$/`
 * to be valid. Objects can optionally include an "expression" property.
 *
 * When a single string is provided, it must be a metric name or a comma-separated
 * list of metric names.
 *
 * A metric name must match the regular expression `/^[a-zA-Z0-9_]+$/`.
 *
 * @since 1.94.0
 * @since 1.98.0 Added a regular expression to validate metric names, in keeping with the GA4 API.
 *
 * @param {string|string[]|Object|Object[]} metrics The metrics to check.
 * @return {boolean} TRUE if metrics are valid, otherwise FALSE.
 */
function isValidMetrics(metrics) {
  function isValidName(metricName) {
    return typeof metricName === 'string' && /^[a-zA-Z0-9_]+$/.test(metricName);
  }
  if (typeof metrics === 'string') {
    const metricNames = metrics.split(',');
    return metricNames.every(isValidName);
  }
  return (0,_js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__.isValidStringsOrObjects)(metrics, metric => {
    const validName = metric.hasOwnProperty('name') && isValidName(metric.name);

    // 'expression' is optional, so if it wasn't provided, we can
    // return early.
    if (!metric.hasOwnProperty('expression')) {
      return validName;
    }

    // 'expression', if provided, must be a string.
    const validExpression = typeof metric.expression === 'string';
    return validName && validExpression;
  }, isValidName);
}

/**
 * Verifies provided dimensions to make sure it matches allowed values. It can be a string,
 * array of strings, an object with "name" field, array of such objects or an array of strings
 * and objects.
 *
 * @since 1.94.0
 *
 * @param {string|string[]|Object|Object[]} dimensions The dimensions to check.
 * @return {boolean} TRUE if dimensions are valid, otherwise FALSE.
 */
function isValidDimensions(dimensions) {
  return (0,_js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__.isValidStringsOrObjects)(dimensions, dimension => {
    return dimension.hasOwnProperty('name') && typeof dimension.name === 'string';
  });
}

/**
 * Verifies provided dimensionFilters to make sure they match allowed values found in dimensions.
 *
 * @since 1.94.0
 *
 * @param {Object} filters The dimension filters to check.
 * @return {boolean} TRUE if dimension filters are valid, otherwise FALSE.
 */
function isValidDimensionFilters(filters) {
  // Ensure every dimensionFilter key corresponds to a valid dimension.
  const validType = ['string'];
  return Object.keys(filters).every(dimension => {
    if (validType.includes(typeof filters[dimension])) {
      return true;
    }
    if (Array.isArray(filters[dimension])) {
      return filters[dimension].every(param => validType.includes(typeof param));
    }
    if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(filters[dimension])) {
      const props = Object.keys(filters[dimension]);
      if (!props.includes('filterType')) {
        return false;
      }
      if (filters[dimension].filterType !== 'emptyFilter' && !props.includes('value')) {
        return false;
      }
      return true;
    }
    return false;
  });
}

/**
 * Verifies provided metricFilters to make sure they match allowed values found in metrics and supported filters.
 *
 * @since 1.111.0
 *
 * @param {Object} filters The metric filters to check.
 * @return {boolean} TRUE if dimension filters are valid, otherwise FALSE.
 */
function isValidMetricFilters(filters) {
  const validType = ['string'];
  const allowedFilterTypes = ['numericFilter', 'betweenFilter'];
  return Object.values(filters).every(filter => {
    if (validType.includes(typeof filter)) {
      return true;
    }
    if (Array.isArray(filter)) {
      return filter.every(param => validType.includes(typeof param));
    }
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(filter)) {
      return false;
    }
    const {
      filterType,
      value,
      fromValue,
      toValue
    } = filter;

    // Validate filterType if present
    if (filterType && !allowedFilterTypes.includes(filterType)) {
      return false;
    }
    const props = Object.keys(filter);

    // Numeric Filter (default if filterType is missing)
    if (!filterType || filterType === 'numericFilter') {
      return props.includes('operation') && props.includes('value') && (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(value) || 'int64Value' in value);
    }

    // Between Filter
    if (filterType === 'betweenFilter') {
      return props.includes('fromValue') && props.includes('toValue') && [fromValue, toValue].every(val => !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(val) || 'int64Value' in val);
    }
    return false;
  });
}

/**
 * Verifies that order definitions are valid for a report. It should be an array
 * of objects where each object has either a "metric" or a "dimension" property,
 * and an optional "desc" property. The "metric" and "dimension" properties should
 * be objects with "metricName" and "dimensionName" properties respectively.
 *
 * @since 1.95.0
 *
 * @param {Object[]} orders The order definitions to check.
 * @return {boolean} TRUE if order definitions are valid, otherwise FALSE.
 */
function isValidOrders(orders) {
  if (!Array.isArray(orders)) {
    return false;
  }
  return orders.every(order => {
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(order)) {
      return false;
    }
    if (order.hasOwnProperty('desc') && typeof order.desc !== 'boolean') {
      return false;
    }
    if (order.metric) {
      return !order.dimension && typeof order.metric?.metricName === 'string';
    }
    if (order.dimension) {
      return typeof order.dimension?.dimensionName === 'string';
    }
    return false;
  });
}

/***/ }),

/***/ "./js/modules/reader-revenue-manager/constants.js":
/*!********************************************************!*\
  !*** ./js/modules/reader-revenue-manager/constants.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_READER_REVENUE_MANAGER: () => (/* binding */ MODULE_SLUG_READER_REVENUE_MANAGER),
/* harmony export */   RRM_PRODUCT_ID_CONTRIBUTIONS_NOTIFICATION_ID: () => (/* binding */ RRM_PRODUCT_ID_CONTRIBUTIONS_NOTIFICATION_ID),
/* harmony export */   RRM_PRODUCT_ID_INFO_NOTICE_SLUG: () => (/* binding */ RRM_PRODUCT_ID_INFO_NOTICE_SLUG),
/* harmony export */   RRM_PRODUCT_ID_OPEN_ACCESS_NOTICE_SLUG: () => (/* binding */ RRM_PRODUCT_ID_OPEN_ACCESS_NOTICE_SLUG),
/* harmony export */   RRM_PRODUCT_ID_SUBSCRIPTIONS_NOTIFICATION_ID: () => (/* binding */ RRM_PRODUCT_ID_SUBSCRIPTIONS_NOTIFICATION_ID),
/* harmony export */   RRM_SETUP_NOTIFICATION_ID: () => (/* binding */ RRM_SETUP_NOTIFICATION_ID),
/* harmony export */   RRM_SETUP_SUCCESS_NOTIFICATION_ID: () => (/* binding */ RRM_SETUP_SUCCESS_NOTIFICATION_ID),
/* harmony export */   SNIPPET_MODES: () => (/* binding */ SNIPPET_MODES)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Reader Revenue Manager constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const SNIPPET_MODES = {
  post_types: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Specific content types', 'google-site-kit'),
  per_post: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Specified pages', 'google-site-kit'),
  sitewide: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site wide', 'google-site-kit')
};
const RRM_PRODUCT_ID_OPEN_ACCESS_NOTICE_SLUG = 'rrm-product-id-open-access-notice';
const RRM_PRODUCT_ID_INFO_NOTICE_SLUG = 'rrm-product-id-info-notice';
const RRM_SETUP_NOTIFICATION_ID = 'rrm-setup-notification';
const RRM_SETUP_SUCCESS_NOTIFICATION_ID = 'setup-success-notification-rrm';
const RRM_PRODUCT_ID_CONTRIBUTIONS_NOTIFICATION_ID = 'rrm-product-id-contributions-notification';
const RRM_PRODUCT_ID_SUBSCRIPTIONS_NOTIFICATION_ID = 'rrm-product-id-subscriptions-notification';
const MODULE_SLUG_READER_REVENUE_MANAGER = 'reader-revenue-manager';

/***/ }),

/***/ "./js/modules/search-console/constants.js":
/*!************************************************!*\
  !*** ./js/modules/search-console/constants.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_SEARCH_CONSOLE: () => (/* binding */ MODULE_SLUG_SEARCH_CONSOLE)
/* harmony export */ });
/**
 * Search Console module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_SEARCH_CONSOLE = 'search-console';

/***/ }),

/***/ "./js/modules/search-console/datastore/constants.js":
/*!**********************************************************!*\
  !*** ./js/modules/search-console/datastore/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATE_RANGE_OFFSET: () => (/* binding */ DATE_RANGE_OFFSET),
/* harmony export */   MODULES_SEARCH_CONSOLE: () => (/* binding */ MODULES_SEARCH_CONSOLE)
/* harmony export */ });
/**
 * `modules/search-console` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_SEARCH_CONSOLE = 'modules/search-console';

// Date range offset days for Search Console report requests.
const DATE_RANGE_OFFSET = 0;

/***/ }),

/***/ "./js/modules/tagmanager/datastore/constants.js":
/*!******************************************************!*\
  !*** ./js/modules/tagmanager/datastore/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCOUNT_CREATE: () => (/* binding */ ACCOUNT_CREATE),
/* harmony export */   CONTAINER_CREATE: () => (/* binding */ CONTAINER_CREATE),
/* harmony export */   CONTEXT_AMP: () => (/* binding */ CONTEXT_AMP),
/* harmony export */   CONTEXT_WEB: () => (/* binding */ CONTEXT_WEB),
/* harmony export */   EDIT_SCOPE: () => (/* binding */ EDIT_SCOPE),
/* harmony export */   FORM_SETUP: () => (/* binding */ FORM_SETUP),
/* harmony export */   MODULES_TAGMANAGER: () => (/* binding */ MODULES_TAGMANAGER),
/* harmony export */   READ_SCOPE: () => (/* binding */ READ_SCOPE),
/* harmony export */   SETUP_MODE_WITH_ANALYTICS: () => (/* binding */ SETUP_MODE_WITH_ANALYTICS)
/* harmony export */ });
/**
 * `modules/tagmanager` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_TAGMANAGER = 'modules/tagmanager';

// A special Account ID value used for the "Set up a new account" option.
const ACCOUNT_CREATE = 'account_create';
// A special Container ID value used for the "Set up a new container" option.
const CONTAINER_CREATE = 'container_create';
// Usage context for web containers.
const CONTEXT_WEB = 'web';
// Usage context for AMP containers.
const CONTEXT_AMP = 'amp';
// Form ID for the module setup form.
const FORM_SETUP = 'tagmanagerSetup';
// OAuth scope needed for viewing containers.
const READ_SCOPE = 'https://www.googleapis.com/auth/tagmanager.readonly';
// OAuth scope needed for creating containers.
const EDIT_SCOPE = 'https://www.googleapis.com/auth/tagmanager.edit.containers';
// A special setupMode value for when completing setup with Analytics.
const SETUP_MODE_WITH_ANALYTICS = 'SETUP_WITH_ANALYTICS';

/***/ }),

/***/ "./js/util/async.js":
/*!**************************!*\
  !*** ./js/util/async.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   asyncRequire: () => (/* binding */ asyncRequire),
/* harmony export */   asyncRequireAll: () => (/* binding */ asyncRequireAll),
/* harmony export */   asyncRequireAny: () => (/* binding */ asyncRequireAny),
/* harmony export */   racePrioritizedAsyncTasks: () => (/* binding */ racePrioritizedAsyncTasks)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Defines async task.
 *
 * @since 1.142.0
 *
 * @typedef {Object} AsyncTask
 * @property {number}     priority          Priority of task – executed in ascending order.
 * @property {function(): Promise<boolean>} check Async function that resolves to a boolean. `true` if its checks pass, otherwise `false`.
 */

/**
 * Finds the highest priority task from a collection of tasks with async checks.
 *
 * @since 1.142.0
 *
 * @param {AsyncTask[]} tasks List of task objects.
 * @return {Promise<Object|null>} Promise that resolves to the highest priority task object which finishes its check first or `null` if no checks pass.
 */
async function racePrioritizedAsyncTasks(tasks) {
  // Group tasks by priority
  const priorityGroups = tasks.reduce((grouped, task) => {
    const priority = parseInt(task.priority, 10);
    grouped[priority] = grouped[priority] || [];
    grouped[priority].push(task.check().then(result => ({
      task,
      result: !!result
    })).catch(() => ({
      result: false
    })));
    return grouped;
  }, {});

  // Collect all given priorities in ascending order.
  const priorities = Object.keys(priorityGroups).sort((a, b) => a - b);

  // Process priority groups sequentially.
  for (const priority of priorities) {
    // Initialize a copy of the priority group to allow for mutation.
    let group = [...priorityGroups[priority]];
    do {
      const winner = await Promise.race(group);
      if (winner.result) {
        return winner.task;
      }

      // If we got here, then the fastest task's check did not pass.
      // Filter out all tasks with completed failed checks.
      for (const i in group) {
        const task = group[i];
        if ((await isPromiseResolved(task)) && false === (await task).result) {
          delete group[i];
        }
      }

      // Filter out empty elements for the next iteration.
      group = group.filter(e => e);
    } while (group.length);
    // Move on to the next priority group.
  }
  return null;
}

/**
 * Checks if the given promise is resolved.
 *
 * A resolved promise is either settled or rejected, but not pending.
 *
 * @since 1.144.0
 *
 * @param {Promise} promise Promise to test.
 * @return {boolean} True if resolved, otherwise false.
 */
async function isPromiseResolved(promise) {
  const CONTROL = 'SECRETVALUETHATNOPROMISESHOULDEVERRESOLVETO';
  // If the given value isn't a Promise, wrap it in one.
  if (!(promise instanceof Promise)) {
    promise = Promise.resolve(promise);
  }
  // Important: while Promise.race works with non-promises, it doesn't work
  // consistently in some environments with client-side instrumentation tooling.
  return CONTROL !== (await Promise.race([promise, Promise.resolve(CONTROL)]));
}

/**
 * Returns a function which can process N asynchronous requirements in sequence, stopping at the first to return false.
 *
 * @since 1.166.0
 *
 * @param {...Function} requirements Async requirement function checks.
 * @return {function(...Promise<boolean>[]): Promise<boolean>} Function which processes all requirements in sequence.
 */
function asyncRequireAll(...requirements) {
  return async function (...args) {
    for (const predicate of requirements) {
      if (false === (await predicate(...args))) {
        return false;
      }
    }
    return true;
  };
}

/**
 * Returns a function which can process N asynchronous requirements in sequence, stopping at the first to return true.
 *
 * If any predicates return true, it returns true, otherwise it returns false.
 *
 * @since 1.166.0
 *
 * @param {...Function} requirements Async requirement function checks.
 * @return {function(): Promise<boolean>} Function which processes all requirements in sequence.
 */
function asyncRequireAny(...requirements) {
  return async function (...args) {
    for (const predicate of requirements) {
      if (true === (await predicate(...args))) {
        return true;
      }
    }
    return false;
  };
}

/**
 * Returns a predicate function which proxies the given function and returns `true` only if the given function's return equals the given value.
 *
 * @since 1.166.0
 *
 * @param {*}        want Value to match against predicate return.
 * @param {Function} func Function to proxy and check return value of.
 * @return {function(): Promise<boolean>} Predicate function.
 */
function asyncRequire(want, func) {
  return async function (...args) {
    return want === (await func(...args));
  };
}

/***/ }),

/***/ "./js/util/chart.js":
/*!**************************!*\
  !*** ./js/util/chart.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* binding */ calculateDifferenceBetweenChartValues),
/* harmony export */   getChartDifferenceArrow: () => (/* binding */ getChartDifferenceArrow),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Utility functions for charts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Gets the up/down SVG arrow for Google Chart tooltips.
 *
 * @since 1.30.0
 *
 * @param {number}  difference            The difference which can be positive or negative.
 * @param {string}  [options]             Options to be passed to the ChangeArrow component.
 * @param {boolean} [options.invertColor] Whether we need to reverse the +/- colors of the arrow.
 * @return {string} SVG for the +/- difference.
 */

function getChartDifferenceArrow(difference, options = {}) {
  if (Number.isNaN(Number(difference))) {
    return '';
  }
  const {
    invertColor = false
  } = options;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["default"])(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__["default"], {
    direction: difference > 0 ? 'up' : 'down',
    invertColor: invertColor
  }));
}

/**
 * Checks if there is a single row of data or one row is contributing 100% of the total for a given dimension.
 *
 * @since 1.31.0
 *
 * @param {Array.<Object>} report An array of report data objects.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  if (report?.[0]?.data?.rows?.length === 1 || report?.[0]?.data?.rows?.[0]?.metrics?.[0]?.values?.[0] === report?.[0]?.data?.totals?.[0]?.values?.[0]) {
    return true;
  }
  return false;
}

/**
 * Calculates difference between two chart values.
 *
 * @since 1.48.0
 *
 * @param {number} currentValue  Current chart value.
 * @param {number} previousValue Previous chart value.
 * @return {number} The difference.
 */
function calculateDifferenceBetweenChartValues(currentValue, previousValue) {
  if (currentValue > 0 && previousValue > 0) {
    return currentValue / previousValue - 1;
  }
  if (currentValue > 0) {
    return 1;
  }
  if (previousValue > 0) {
    return -1;
  }
  return 0;
}

/***/ }),

/***/ "./js/util/convert-time.js":
/*!*********************************!*\
  !*** ./js/util/convert-time.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* binding */ convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* binding */ convertSecondsToArray)
/* harmony export */ });
/**
 * Time related utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts seconds into an array with the following values [HH, MM, SS, MS] as described below.
 * HH: hours.
 * MM: minutes.
 * SS: seconds.
 * MS: milliseconds.
 *
 * For example, passing 196.385 returns [ 0, 3, 16, 385 ].
 *
 * @since 1.27.0
 *
 * @param {number} seconds The number of seconds.
 * @return {Array} Array containing the hours, minutes, seconds and milliseconds.
 */
function convertSecondsToArray(seconds) {
  seconds = parseFloat(seconds);
  if (isNaN(seconds) || 0 === seconds) {
    return [0, 0, 0, 0];
  }
  return [Math.floor(seconds / 60 / 60), Math.floor(seconds / 60 % 60), Math.floor(seconds % 60), Math.floor(seconds * 1000) - Math.floor(seconds) * 1000];
}

/**
 * Converts Date time string into UNIX timestamp in milliseconds.
 *
 * For example, passing "2014-10-02T15:01:23Z" returns 1412262083000.
 *
 * @since 1.116.0
 *
 * @param {string} dateStringValue The date time string.
 * @return {number} UNIX timestamp in milliseconds.
 */
function convertDateStringToUNIXTimestamp(dateStringValue) {
  const unixTimestamp = dateStringValue && !Number.isInteger(dateStringValue) ?
  // Valid use of `new Date()` with an argument, because this should only
  // be passed full time strings, not `YYYY-MM-DD` style dates.
  //
  // See: https://github.com/google/site-kit-wp/pull/9459#discussion_r1790660073
  // eslint-disable-next-line sitekit/no-direct-date
  new Date(dateStringValue).getTime() : dateStringValue;
  if (isNaN(unixTimestamp) || !unixTimestamp) {
    return 0;
  }
  return unixTimestamp;
}

/***/ }),

/***/ "./js/util/create-incremental-array-by-size.js":
/*!*****************************************************!*\
  !*** ./js/util/create-incremental-array-by-size.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createIncrementalArrayBySize: () => (/* binding */ createIncrementalArrayBySize)
/* harmony export */ });
/**
 * Create Incremental Array by Size utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Creates an array of length equal to size with incremental values starting at 0.
 *
 * @since 1.28.0
 *
 * @param {number} size Array length.
 * @return {number[]} Array of incremental numbers.
 * @example createIncrementalArrayBySize(3); // [0, 1, 2]
 */
function createIncrementalArrayBySize(size) {
  return new Array(size !== null && size !== void 0 ? size : 0).fill().map((_, i) => i);
}

/***/ }),

/***/ "./js/util/dates.js":
/*!**************************!*\
  !*** ./js/util/dates.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* binding */ DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* binding */ HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* binding */ INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* binding */ INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* binding */ INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* binding */ MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* binding */ MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* binding */ WEEK_IN_SECONDS),
/* harmony export */   dateSub: () => (/* binding */ dateSub),
/* harmony export */   getAvailableDateRanges: () => (/* binding */ getAvailableDateRanges),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* binding */ getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* binding */ getDateString),
/* harmony export */   getPreviousDate: () => (/* binding */ getPreviousDate),
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidDateString: () => (/* binding */ isValidDateString),
/* harmony export */   stringToDate: () => (/* binding */ stringToDate)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

const INVALID_DATE_INSTANCE_ERROR = 'Date param must construct to a valid date instance or be a valid date instance itself.';
const INVALID_DATE_STRING_ERROR = 'Invalid dateString parameter, it must be a string.';
const INVALID_DATE_RANGE_ERROR = 'Invalid date range, it must be a string with the format "last-x-days".';
const MINUTE_IN_SECONDS = 60;
const HOUR_IN_SECONDS = 60 * MINUTE_IN_SECONDS;
const DAY_IN_SECONDS = 24 * HOUR_IN_SECONDS;
const WEEK_IN_SECONDS = 7 * DAY_IN_SECONDS;
const MONTH_IN_SECONDS = 30 * DAY_IN_SECONDS;

/**
 * Gets the hash of available date ranges.
 *
 * @since 1.12.0
 *
 * @return {Object} The object hash where every key is a date range slug, and the value is an object with the date range slug and its translation.
 */
function getAvailableDateRanges() {
  function label(days) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: number of days */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._n)('Last %s day', 'Last %s days', days, 'google-site-kit'), days);
  }
  return {
    'last-7-days': {
      slug: 'last-7-days',
      label: label(7),
      days: 7
    },
    'last-14-days': {
      slug: 'last-14-days',
      label: label(14),
      days: 14
    },
    'last-28-days': {
      slug: 'last-28-days',
      label: label(28),
      days: 28
    },
    'last-90-days': {
      slug: 'last-90-days',
      label: label(90),
      days: 90
    }
  };
}

/**
 * Gets the current dateRange day count.
 *
 * @since 1.19.0
 * @since 1.26.0 `dateRange` is now a required argument.
 *
 * @param {string} dateRange The date range slug.
 * @return {number} The number of days in the range.
 */
function getCurrentDateRangeDayCount(dateRange) {
  const daysMatch = dateRange.match(/last-(\d+)-days/);
  if (daysMatch && daysMatch[1]) {
    return parseInt(daysMatch[1], 10);
  }
  throw new Error('Unrecognized date range slug.');
}

/**
 * Asserts whether a given date string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateString Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given date string is valid.
 */
function isValidDateString(dateString = '') {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isString)(dateString)) {
    return false;
  }
  const dateArray = dateString.split('-');
  if (dateArray.length !== 3) {
    return false;
  }

  // Valid use of `new Date()`, constructing a new date from the string.
  // eslint-disable-next-line sitekit/no-direct-date
  const date = new Date(dateString);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date);
}

/**
 * Parses the given Date instance and returns a date string (YYYY-MM-DD).
 *
 * @since 1.18.0
 * @since 1.85.0 Updated the function signature to only accept a Date argument.
 *
 * @param {Date} date Date to parse into a string.
 * @return {string}                 The parsed date string (YYYY-MM-DD).
 */
function getDateString(date) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date), INVALID_DATE_INSTANCE_ERROR);
  const month = `${date.getMonth() + 1}`;
  const day = `${date.getDate()}`;
  const year = date.getFullYear();
  return [year, month.length < 2 ? `0${month}` : month, day.length < 2 ? `0${day}` : day].join('-');
}

/**
 * Converts a valid date string to a Date instance.
 *
 * @since 1.38.0
 *
 * @param {string} dateString The date string to parse.
 * @return {Date} Date instance.
 */
function stringToDate(dateString) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(dateString), INVALID_DATE_STRING_ERROR);

  /**
   * Split date into explicit parts rather than pass directly into date constructor
   * to avoid timezone issues caused by parsing as UTC. Ensures date is accurate for
   * the user's local time, otherwise has a chance to return a different day than was
   * passed in depending on timezone.
   */
  const [year, month, day] = dateString.split('-');
  return new Date(year, month - 1, day);
}

/**
 * Parses the given date and returns the previous date (daysBefore).
 *
 * @since 1.18.0
 *
 * @param {string} relativeDate Date string (YYYY-MM-DD) to subtract days from.
 * @param {number} daysBefore   Number of days to subtract from relativeDate.
 * @return {string}             The date string (YYYY-MM-DD) for the previous date.
 */
function getPreviousDate(relativeDate, daysBefore) {
  return getDateString(dateSub(relativeDate, daysBefore * DAY_IN_SECONDS));
}

/**
 * Asserts whether a given dateRange string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateRange Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given dateRange string is valid.
 */
function isValidDateRange(dateRange) {
  const parts = dateRange.split('-');
  return parts.length === 3 && parts[0] === 'last' && !Number.isNaN(parts[1]) && !Number.isNaN(parseFloat(parts[1])) && parts[2] === 'days';
}

/**
 * Subtracts duration from the prodived date and returns it.
 *
 * @since 1.132.0
 *
 * @param {Date|string} relativeDate Date string (YYYY-MM-DD) or date object to subtract duration from.
 * @param {number}      duration     The duration in seconds to subtract from relativeDate.
 * @return {Date} Resulting date.
 */
function dateSub(relativeDate, duration) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(relativeDate) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(relativeDate) && !isNaN(relativeDate), INVALID_DATE_STRING_ERROR);
  const timestamp = isValidDateString(relativeDate) ? Date.parse(relativeDate) : relativeDate.getTime();

  // Valid use of `new Date()` using calculations.
  // eslint-disable-next-line sitekit/no-direct-date
  return new Date(timestamp - duration * 1000);
}

/***/ }),

/***/ "./js/util/errors.js":
/*!***************************!*\
  !*** ./js/util/errors.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_CODE_MISSING_REQUIRED_SCOPE: () => (/* binding */ ERROR_CODE_MISSING_REQUIRED_SCOPE),
/* harmony export */   ERROR_INTERNAL_SERVER_ERROR: () => (/* binding */ ERROR_INTERNAL_SERVER_ERROR),
/* harmony export */   ERROR_INVALID_JSON: () => (/* binding */ ERROR_INVALID_JSON),
/* harmony export */   ERROR_REASON_BAD_REQUEST: () => (/* binding */ ERROR_REASON_BAD_REQUEST),
/* harmony export */   ERROR_REASON_FORBIDDEN: () => (/* binding */ ERROR_REASON_FORBIDDEN),
/* harmony export */   ERROR_REASON_INSUFFICIENT_PERMISSIONS: () => (/* binding */ ERROR_REASON_INSUFFICIENT_PERMISSIONS),
/* harmony export */   getReportErrorMessage: () => (/* binding */ getReportErrorMessage),
/* harmony export */   isAuthError: () => (/* binding */ isAuthError),
/* harmony export */   isErrorRetryable: () => (/* binding */ isErrorRetryable),
/* harmony export */   isInsufficientPermissionsError: () => (/* binding */ isInsufficientPermissionsError),
/* harmony export */   isPermissionScopeError: () => (/* binding */ isPermissionScopeError),
/* harmony export */   isWPError: () => (/* binding */ isWPError)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Error Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


// Error codes and reasons.
const ERROR_CODE_MISSING_REQUIRED_SCOPE = 'missing_required_scopes'; // When scopes are missing.
const ERROR_REASON_INSUFFICIENT_PERMISSIONS = 'insufficientPermissions';
const ERROR_REASON_FORBIDDEN = 'forbidden';
const ERROR_INTERNAL_SERVER_ERROR = 'internal_server_error';
const ERROR_INVALID_JSON = 'invalid_json';
const ERROR_REASON_BAD_REQUEST = 'bad_request';

/**
 * Checks if the provided object is an instance of WP_Error class.
 *
 * @since 1.13.0
 *
 * @param {Object} obj The object to check.
 * @return {boolean} TRUE if the object has "code", "data" and "message" properties, otherwise FALSE.
 */
function isWPError(obj) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(obj) && obj.hasOwnProperty('code') && (typeof obj.code === 'string' || typeof obj.code === 'number') && obj.hasOwnProperty('message') && typeof obj.message === 'string' && obj.hasOwnProperty('data'); // We don't check "obj.data" type because it can be anything.
}

/**
 * Checks if the given error is a permission scope error.
 *
 * @since 1.9.0
 * @private
 *
 * @param {Object} error Input to test as a possible permission scope error.
 * @return {boolean} TRUE if permission scope error, otherwise FALSE.
 */
function isPermissionScopeError(error) {
  return error?.code === ERROR_CODE_MISSING_REQUIRED_SCOPE;
}

/**
 * Checks if the given error has insufficient permissions reason.
 *
 * @since 1.16.0
 * @since 1.70.0 Add support for "forbidden" reason.
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's insufficient permissions error, otherwise FALSE.
 */
function isInsufficientPermissionsError(error) {
  return [ERROR_REASON_INSUFFICIENT_PERMISSIONS, ERROR_REASON_FORBIDDEN].includes(error?.data?.reason);
}

/**
 * Checks if the given error is an auth error.
 *
 * @since 1.78.0
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's an auth error, otherwise FALSE.
 */
function isAuthError(error) {
  return !!error?.data?.reconnectURL;
}

/**
 * Checks if the given error can be retried.
 *
 * @since 1.86.0
 *
 * @param {Object} error          The error object to check.
 * @param {Object} [selectorData] The error's associated selector data object.
 * @return {boolean} TRUE if the error is retryable, otherwise FALSE.
 */
function isErrorRetryable(error, selectorData) {
  return !!selectorData?.storeName && !isInsufficientPermissionsError(error) && !isPermissionScopeError(error) && !isAuthError(error);
}

/**
 * Sets the error message for specific error codes.
 *
 * @since 1.92.0
 *
 * @param {Object} error The error object to check.
 * @return {Object} The updated error object.
 */
function getReportErrorMessage(error) {
  if (error?.code === ERROR_INTERNAL_SERVER_ERROR) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('There was a critical error on this website while fetching data', 'google-site-kit');
  } else if (error?.code === ERROR_INVALID_JSON) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The server provided an invalid response', 'google-site-kit');
  }
  return error?.message;
}

/***/ }),

/***/ "./js/util/i18n.js":
/*!*************************!*\
  !*** ./js/util/i18n.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDurationFormat: () => (/* binding */ createDurationFormat),
/* harmony export */   expandNumFmtOptions: () => (/* binding */ expandNumFmtOptions),
/* harmony export */   getLocale: () => (/* binding */ getLocale),
/* harmony export */   listFormat: () => (/* binding */ listFormat),
/* harmony export */   numFmt: () => (/* binding */ numFmt),
/* harmony export */   numberFormat: () => (/* binding */ numberFormat),
/* harmony export */   prepareForReadableLargeNumber: () => (/* binding */ prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* binding */ readableLargeNumber)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Internationalization Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed.
 *
 * For example, passing 65 returns '1m 5s'.
 *
 * @since 1.0.0
 * @since 1.28.0 Refactored and renamed to improve localization.
 * @private
 *
 * @param {number}                     durationInSeconds The number of seconds.
 * @param {(Intl.NumberFormatOptions)} [options]         Optional formatting options.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationFormat(durationInSeconds, options = {}) {
  const {
    formatUnit,
    formatDecimal
  } = createDurationFormat(durationInSeconds, options);
  try {
    // Some browsers, e.g. Safari, throw a RangeError when options.style is
    // not one of decimal, percent, or currency.
    return formatUnit();
  } catch {
    // Fallback to XXh YYm ZZs using localized decimals with hardcoded units.
    return formatDecimal();
  }
}

/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed
 * in ISO format - HH:mm:ss.
 *
 * If the duration is less than an hour, the HH part of the string
 * is truncated.
 * For example, passing 65 returns '01:05'.
 * Passing 5400 returns '01:30:00'.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationISOFormat(durationInSeconds) {
  let {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  seconds = ('0' + seconds).slice(-2);
  minutes = ('0' + minutes).slice(-2);
  hours = ('0' + hours).slice(-2);
  return hours === '00' ? `${minutes}:${seconds}` : `${hours}:${minutes}:${seconds}`;
}

/**
 * Parses the duration in seconds into hours, minutes and seconds.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {Object} Number of hours, minutes and seconds equivalent
 * to the given duration in seconds.
 */
function parseDuration(durationInSeconds) {
  durationInSeconds = parseInt(durationInSeconds, 10);
  if (Number.isNaN(durationInSeconds)) {
    durationInSeconds = 0;
  }
  const hours = Math.floor(durationInSeconds / 60 / 60);
  const minutes = Math.floor(durationInSeconds / 60 % 60);
  const seconds = Math.floor(durationInSeconds % 60);
  return {
    hours,
    minutes,
    seconds
  };
}

/**
 * Creates duration formatting utilities.
 *
 * Not intended to be used directly.
 * Use `numFmt( number, { style: 'duration' } )` instead.
 *
 * @since 1.29.0
 * @private
 *
 * @param {number} durationInSeconds Duration to format.
 * @param {Object} [options]         Formatting options.
 * @return {Object} Formatting functions.
 */
function createDurationFormat(durationInSeconds, options = {}) {
  const {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  return {
    hours,
    minutes,
    seconds,
    formatUnit() {
      const {
        unitDisplay = 'short',
        ...restOptions
      } = options;
      const commonOptions = {
        unitDisplay,
        ...restOptions,
        style: 'unit'
      };
      if (durationInSeconds === 0) {
        return numberFormat(seconds, {
          ...commonOptions,
          unit: 'second'
        });
      }
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? numberFormat(seconds, {
        ...commonOptions,
        unit: 'second'
      }) : '', minutes ? numberFormat(minutes, {
        ...commonOptions,
        unit: 'minute'
      }) : '', hours ? numberFormat(hours, {
        ...commonOptions,
        unit: 'hour'
      }) : '').trim();
    },
    /**
     * Formats the duration using integers and translatable strings.
     * This is only used as a fallback when the above `formatUnit` fails.
     *
     * @since 1.29.0
     *
     * @return {string} Formatted duration.
     */
    formatDecimal() {
      const formattedSeconds = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of seconds with "s" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%ds', 'google-site-kit'), seconds);
      if (durationInSeconds === 0) {
        return formattedSeconds;
      }
      const formattedMinutes = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of minutes with "m" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dm', 'google-site-kit'), minutes);
      const formattedHours = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of hours with "h" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dh', 'google-site-kit'), hours);
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? formattedSeconds : '', minutes ? formattedMinutes : '', hours ? formattedHours : '').trim();
    }
  };
}

/**
 * Prepares a number to be used in readableLargeNumber.
 *
 * @since 1.7.0
 *
 * @param {number} number The large number to prepare.
 * @return {number} The prepared number.
 */
function prepareForReadableLargeNumber(number) {
  if (1000000 <= number) {
    return Math.round(number / 100000) / 10;
  }
  if (10000 <= number) {
    return Math.round(number / 1000);
  }
  if (1000 <= number) {
    return Math.round(number / 100) / 10;
  }
  return number;
}

/**
 * Formats a large number for shortened display.
 *
 * @since 1.0.0
 *
 * @param {number} number The large number to format.
 * @return {string} The formatted number.
 */
function readableLargeNumber(number) {
  const withSingleDecimal = {
    minimumFractionDigits: 1,
    maximumFractionDigits: 1
  };

  // Numbers over 1,000,000 round normally and display a single decimal unless the decimal is 0.
  if (1000000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in millions.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sM', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }

  // Numbers between 10,000 and 1,000,000 round normally and have no decimals
  if (10000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number)));
  }

  // Numbers between 1,000 and 10,000 round normally and display a single decimal unless the decimal is 0.
  if (1000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }
  return numberFormat(number, {
    signDisplay: 'never',
    maximumFractionDigits: 1
  });
}

/**
 * Parses formatting options and returns an object with options for selected formatting.
 *
 * @since 1.103.0
 *
 * @param {(Intl.NumberFormatOptions|string)} options Formatting options or unit shorthand. Possible shorthand values are '%', 's', or a currency code.
 * @return {Object} Formatting options.
 */
function expandNumFmtOptions(options) {
  let formatOptions = {};

  // Expand shorthand values for units.
  if ('%' === options) {
    formatOptions = {
      style: 'percent',
      maximumFractionDigits: 2
    };
  } else if ('s' === options) {
    formatOptions = {
      style: 'duration',
      unitDisplay: 'narrow'
    };
  } else if (!!options && typeof options === 'string') {
    formatOptions = {
      style: 'currency',
      currency: options
    };
  } else if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(options)) {
    formatOptions = {
      ...options
    };
  }
  return formatOptions;
}

/**
 * Formats a number with unit using the JS Internationalization Number Format API.
 *
 * In addition to the supported 'style' values of the lower-level `numberFormat` function, this function
 * supports two additional 'style' values 'metric' and 'duration' (expects a number in seconds).
 *
 * Another differentiation in behavior is that by default the function will use 'metric' formatting instead
 * of 'decimal' formatting.
 *
 * @since 1.24.0
 *
 * @param {number|string}                     number    The number to format.
 * @param {(Intl.NumberFormatOptions|string)} [options] Formatting options or unit shorthand.
 *                                                      Possible shorthand values are '%', 's',
 *                                                      or a currency code.
 * @return {string} The formatted number.
 */
function numFmt(number, options = {}) {
  // Cast parsable values to numeric types.
  number = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number) ? number : Number(number);
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number)) {
    // eslint-disable-next-line no-console
    console.warn('Invalid number', number, typeof number);
    number = 0;
  }
  const formatOptions = expandNumFmtOptions(options);
  const {
    style = 'metric'
  } = formatOptions; // Note: `metric` is our custom, default style.

  if ('metric' === style) {
    return readableLargeNumber(number);
  }
  if ('duration' === style) {
    return durationFormat(number, formatOptions);
  }
  if ('durationISO' === style) {
    return durationISOFormat(number);
  }
  return numberFormat(number, formatOptions);
}

// Warn once for a given message.
const warnOnce = memize__WEBPACK_IMPORTED_MODULE_1___default()(console.warn); // eslint-disable-line no-console

/**
 * Formats a number using the JS Internationalization Number Format API.
 *
 * @since 1.8.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/NumberFormat|`options` parameter} For all available formatting options.
 *
 * @param {number}                   number           The number to format.
 * @param {Intl.NumberFormatOptions} [options]        Formatting options.
 * @param {string}                   [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @return {string} The formatted number.
 */
function numberFormat(number, options = {}) {
  const {
    locale = getLocale(),
    ...formatOptions
  } = options;
  try {
    /**
     * Per https://github.com/google/site-kit-wp/issues/3255 there have been issues with some versions of Safari
     * on some operating systems throwing issues with some parameters in the formatOptions.
     *
     * If an error is thrown, we remove some troublesome params from the formatOptions object and fallback to no formatting.
     *
     * This allows us to degrade somewhat gracefully without breaking the dashboard for users of unaffected browsers.
     */
    return new Intl.NumberFormat(locale, formatOptions).format(number);
  } catch (error) {
    warnOnce(`Site Kit numberFormat error: Intl.NumberFormat( ${JSON.stringify(locale)}, ${JSON.stringify(formatOptions)} ).format( ${typeof number} )`, error.message);
  }

  // Remove these key/values from formatOptions.
  const unstableFormatOptionValues = {
    currencyDisplay: 'narrow',
    currencySign: 'accounting',
    style: 'unit'
  };

  // Remove these keys from formatOptions irrespective of value.
  const unstableFormatOptions = ['signDisplay', 'compactDisplay'];
  const reducedFormatOptions = {};
  for (const [key, value] of Object.entries(formatOptions)) {
    if (unstableFormatOptionValues[key] && value === unstableFormatOptionValues[key]) {
      continue;
    }
    if (unstableFormatOptions.includes(key)) {
      continue;
    }
    reducedFormatOptions[key] = value;
  }
  try {
    return new Intl.NumberFormat(locale, reducedFormatOptions).format(number);
  } catch {
    return new Intl.NumberFormat(locale).format(number);
  }
}

/**
 * Flattens an array of strings into a string using the JS Internationalization List Format API.
 *
 * @since 1.23.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat|`options` parameter} For all available options.
 *
 * @param {Array}  list             The list to flatten.
 * @param {Object} [options]        Formatting options.
 * @param {string} [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @param {string} [options.style]  Length of the formatted message. Defaults to long.
 * @param {string} [options.type]   Type of list. Defaults to 'conjunction' (A, B, and C).
 *                                  Also available 'disjunction' (A, B, or C)
 *                                  Also available 'unit' (5 pounds, 12 ounces)
 * @return {string} The flattened list.
 */
function listFormat(list, options = {}) {
  const {
    locale = getLocale(),
    style = 'long',
    type = 'conjunction'
  } = options;

  // Not all browsers support Intl.Listformat per
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat#Browser_compatibility
  // We've seen that the built versions don't polyfill for the unsupported browsers (iOS/safari) so we provide a fallback.
  if (Intl.ListFormat) {
    const formatter = new Intl.ListFormat(locale, {
      style,
      type
    });
    return formatter.format(list);
  }

  /* translators: used between list items, there is a space after the comma. */
  const listSeparator = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(', ', 'google-site-kit');
  return list.join(listSeparator);
}

/**
 * Gets the current locale for use with browser APIs.
 *
 * @since 1.8.0
 *
 * @param {Object} _global The global window object.
 * @return {string} Current Site Kit locale if set, otherwise the current language set by the browser.
 *                  E.g. `en-US` or `de-DE`
 */
function getLocale(_global = __webpack_require__.g) {
  const siteKitLocale = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(_global, ['_googlesitekitLegacyData', 'locale']);
  if (siteKitLocale) {
    const matches = siteKitLocale.match(/^(\w{2})?(_)?(\w{2})/);
    if (matches && matches[0]) {
      return matches[0].replace(/_/g, '-');
    }
  }
  return _global.navigator.language;
}

/***/ }),

/***/ "./js/util/index.js":
/*!**************************!*\
  !*** ./js/util/index.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.WEEK_IN_SECONDS),
/* harmony export */   calculateChange: () => (/* binding */ calculateChange),
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.calculateDifferenceBetweenChartValues),
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertSecondsToArray),
/* harmony export */   createDurationFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.createDurationFormat),
/* harmony export */   dateSub: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.dateSub),
/* harmony export */   decodeHTMLEntity: () => (/* binding */ decodeHTMLEntity),
/* harmony export */   expandNumFmtOptions: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.expandNumFmtOptions),
/* harmony export */   getAvailableDateRanges: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getAvailableDateRanges),
/* harmony export */   getChartDifferenceArrow: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.getChartDifferenceArrow),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getDateString),
/* harmony export */   getFullURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getFullURL),
/* harmony export */   getLocale: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.getLocale),
/* harmony export */   getPreviousDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getPreviousDate),
/* harmony export */   getStorage: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.getStorage),
/* harmony export */   getURLPath: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getURLPath),
/* harmony export */   isHashOnly: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.isHashOnly),
/* harmony export */   isNumeric: () => (/* reexport safe */ _isnumeric__WEBPACK_IMPORTED_MODULE_12__.isNumeric),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.isSingleSlice),
/* harmony export */   isValidDateRange: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateRange),
/* harmony export */   isValidDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateString),
/* harmony export */   isValidNumericID: () => (/* reexport safe */ _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__.isValidNumericID),
/* harmony export */   listFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.listFormat),
/* harmony export */   markdownToHTML: () => (/* reexport safe */ _markdown__WEBPACK_IMPORTED_MODULE_6__.markdownToHTML),
/* harmony export */   normalizeURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.normalizeURL),
/* harmony export */   numFmt: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numFmt),
/* harmony export */   numberFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numberFormat),
/* harmony export */   partitionReport: () => (/* reexport safe */ _partition_report__WEBPACK_IMPORTED_MODULE_14__.partitionReport),
/* harmony export */   prepareForReadableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.readableLargeNumber),
/* harmony export */   safelySort: () => (/* reexport safe */ _safely_sort__WEBPACK_IMPORTED_MODULE_13__.safelySort),
/* harmony export */   sanitizeHTML: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML),
/* harmony export */   shortenURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.shortenURL),
/* harmony export */   storageAvailable: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.storageAvailable),
/* harmony export */   stringToDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.stringToDate),
/* harmony export */   stringifyObject: () => (/* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_3__.stringifyObject),
/* harmony export */   trackEvent: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEvent),
/* harmony export */   trackEventOnce: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEventOnce),
/* harmony export */   untrailingslashit: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.untrailingslashit),
/* harmony export */   validateJSON: () => (/* binding */ validateJSON)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sanitize */ "./js/util/sanitize.js");
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringify */ "./js/util/stringify.js");
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./storage */ "./js/util/storage.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./i18n */ "./js/util/i18n.js");
/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./markdown */ "./js/util/markdown.js");
/* harmony import */ var _convert_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./convert-time */ "./js/util/convert-time.js");
/* harmony import */ var _dates__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dates */ "./js/util/dates.js");
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart */ "./js/util/chart.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./urls */ "./js/util/urls.js");
/* harmony import */ var _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./is-valid-numeric-id */ "./js/util/is-valid-numeric-id.js");
/* harmony import */ var _isnumeric__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isnumeric */ "./js/util/isnumeric.js");
/* harmony import */ var _safely_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./safely-sort */ "./js/util/safely-sort.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./partition-report */ "./js/util/partition-report.js");
/**
 * Utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */
















/**
 * Calculates the change between two values.
 *
 * @since 1.24.0
 *
 * @param {number} previous The previous value.
 * @param {number} current  The current value.
 * @return {(number|null)} The percent change. Null if the input or output is invalid.
 */
function calculateChange(previous, current) {
  function isZero(value) {
    return value === '0' || value === 0;
  }

  // Prevent null result when both values are legitimately zero.
  if (isZero(previous) && isZero(current)) {
    return 0;
  }

  // Prevent divide by zero errors.
  if (isZero(previous) || Number.isNaN(previous)) {
    return null;
  }

  // Avoid NaN at all costs.
  const change = (current - previous) / previous;
  if (Number.isNaN(change) || !Number.isFinite(change)) {
    return null;
  }
  return change;
}

/**
 * Verifies whether JSON is valid.
 *
 * @since 1.0.0
 *
 * @param {string} stringToValidate The string to validate.
 * @return {boolean} Indicates JSON is valid.
 */
function validateJSON(stringToValidate) {
  try {
    return JSON.parse(stringToValidate) && !!stringToValidate;
  } catch (e) {
    return false;
  }
}

/**
 * Converts HTML text into an HTML entity.
 *
 * _.unescape doesn't seem to decode some entities for admin bar titles.
 * adding combination in this helper as a workaround.
 *
 * @since 1.0.0
 *
 * @param {string} str The string to decode.
 * @return {string} Decoded HTML entity.
 */
function decodeHTMLEntity(str) {
  if (!str) {
    return '';
  }
  const decoded = str.replace(/&#(\d+);/g, (match, dec) => {
    return String.fromCharCode(dec);
  }).replace(/(\\)/g, '');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(decoded);
}

/***/ }),

/***/ "./js/util/is-valid-numeric-id.js":
/*!****************************************!*\
  !*** ./js/util/is-valid-numeric-id.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidNumericID: () => (/* binding */ isValidNumericID)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks the given value to see if it is a positive integer.
 *
 * @since 1.11.0 Function introduced.
 * @since 1.90.0 Moved outside Tag Manager to a generic utility function.
 *
 * @param {*} input Value to check.
 * @return {boolean} Validity.
 */
function isValidNumericID(input) {
  const id = parseFloat(input) || 0;
  if (!Number.isInteger(id)) {
    return false;
  }
  return id > 0;
}

/***/ }),

/***/ "./js/util/isnumeric.js":
/*!******************************!*\
  !*** ./js/util/isnumeric.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNumeric: () => (/* binding */ isNumeric)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if a given value is numeric.
 *
 * @since 1.80.0
 *
 * @param {*} value The value to check.
 * @return {boolean} TRUE if a value is numeric FALSE otherwise.
 */
function isNumeric(value) {
  if (typeof value === 'number') {
    return true;
  }
  const string = (value || '').toString();
  if (!string) {
    return false;
  }
  return !isNaN(string);
}

/***/ }),

/***/ "./js/util/markdown.js":
/*!*****************************!*\
  !*** ./js/util/markdown.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   markdownToHTML: () => (/* binding */ markdownToHTML)
/* harmony export */ });
/**
 * Markdown utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Replaces markdown links with its HTML equivalents.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownLinks(text) {
  return text.replace(new RegExp('\\[([^\\]]+)\\]\\((https?://[^/]+\\.\\w+/?.*?)\\)', 'gi'), '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>');
}

/**
 * Adds paragraphs to the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownParagraphs(text) {
  return `<p>${text.replace(/\n{2,}/g, '</p><p>')}</p>`;
}

/**
 * Replaces line breaks in the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownBreaks(text) {
  return text.replace(/\n/gi, '<br>');
}

/**
 * Converts markdown to HTML.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} HTML version of the markdown text.
 */
function markdownToHTML(text) {
  const rules = [markdownLinks, markdownParagraphs, markdownBreaks];
  let html = text;
  for (const rule of rules) {
    html = rule(html);
  }
  return html;
}

/***/ }),

/***/ "./js/util/partition-report.js":
/*!*************************************!*\
  !*** ./js/util/partition-report.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionReport: () => (/* binding */ partitionReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report partitioning utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.33.0
 * @since 1.34.0 Updated to support incomplete `report` arrays.
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionReport(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');

  // Use a negative date range length for reverse slicing.
  const _dateRangeLength = -1 * dateRangeLength;
  return {
    // The current range should always be sliced from the end.
    currentRange: report.slice(_dateRangeLength),
    // The compare range continues from where the current left off (slicing towards the start),
    // and may be shorter (where older data is not available yet) which is fine.
    compareRange: report.slice(_dateRangeLength * 2, _dateRangeLength)
  };
}

/***/ }),

/***/ "./js/util/purify.js":
/*!***************************!*\
  !*** ./js/util/purify.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   purify: () => (/* binding */ purify)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "../node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

const purify = dompurify__WEBPACK_IMPORTED_MODULE_0___default()(__webpack_require__.g);

/***/ }),

/***/ "./js/util/report-validation.js":
/*!**************************************!*\
  !*** ./js/util/report-validation.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidOrders: () => (/* binding */ isValidOrders),
/* harmony export */   isValidStringsOrObjects: () => (/* binding */ isValidStringsOrObjects),
/* harmony export */   isValidStringularItems: () => (/* binding */ isValidStringularItems)
/* harmony export */ });
/**
 * Reporting API validation utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Validates data that can be either string or object of the certain type, or array of them.
 *
 * @since 1.13.0
 * @since 1.98.0 Added verifyStringFunction parameter.
 *
 * @param {string|string[]|Object|Object[]} data                   The data to check.
 * @param {Function}                        verifyObjectFunction   The callback to verify an object.
 * @param {Function}                        [verifyStringFunction] The callback to verify a string (optional).
 * @return {boolean} TRUE if data is valid, otherwise FALSE.
 */
function isValidStringsOrObjects(data, verifyObjectFunction, verifyStringFunction = () => true) {
  if (typeof data === 'string') {
    return verifyStringFunction(data);
  }
  if (typeof data === 'object' && verifyObjectFunction(data)) {
    return true;
  }
  if (Array.isArray(data)) {
    return data.every(item => {
      if (typeof item === 'string') {
        return verifyStringFunction(item);
      }
      if (typeof item === 'object') {
        return verifyObjectFunction(item);
      }
      return false;
    });
  }

  // Arguably this should fail/throw, because none of our allowed types were encountered.
  return false;
}

/**
 * Verifies that either date range or start and end dates are valid.
 *
 * @since 1.13.0
 *
 * @param {Object} dates           The object containing dates to check.
 * @param {string} dates.startDate The start date to check.
 * @param {string} dates.endDate   The end date to check.
 * @return {boolean} TRUE if either date range or start/end dates are valid, otherwise FALSE.
 */
function isValidDateRange({
  startDate,
  endDate
}) {
  const validStartDate = startDate && startDate.match(/^\d{4}-\d{2}-\d{2}$/);
  const validEndDate = endDate && endDate.match(/^\d{4}-\d{2}-\d{2}$/);
  return validStartDate && validEndDate;
}

/**
 * Verifies that order definitions are valid. It can be either an object or an array
 * of objects where each object has "fieldName" and valid "sortOrder" properties.
 *
 * @since 1.13.0
 *
 * @param {Object|Object[]} orders The order definitions to check.
 * @return {boolean} TRUE if order definitions are valid, otherwise FALSE.
 */
function isValidOrders(orders) {
  function isValidOrder(order) {
    const isValidFieldName = order.hasOwnProperty('fieldName') && !!order.fieldName;
    const isValidSortOrder = order.hasOwnProperty('sortOrder') && /(ASCENDING|DESCENDING)/i.test(order.sortOrder.toString());
    return isValidFieldName && isValidSortOrder;
  }
  if (Array.isArray(orders)) {
    return orders.every(item => typeof item === 'object' && isValidOrder(item));
  }
  if (typeof orders === 'object') {
    return isValidOrder(orders);
  }

  // Arguably this should fail/throw, because none of our allowed types were encountered.
  return false;
}

/**
 * Verifies that provided parameter is either a string or an array of strings.
 *
 * @since 1.15.0
 *
 * @param {(string|Array.<string>)} items Items to validate.
 * @return {boolean} TRUE if items are either a string or an array of strings, otherwise FALSE.
 */
function isValidStringularItems(items) {
  if (typeof items === 'string') {
    return true;
  }
  if (Array.isArray(items)) {
    return items.every(item => typeof item === 'string');
  }
  return false;
}

/***/ }),

/***/ "./js/util/safely-sort.js":
/*!********************************!*\
  !*** ./js/util/safely-sort.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safelySort: () => (/* binding */ safelySort)
/* harmony export */ });
/**
 * `safelySort` utility function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Sorts an array without causing the mutation if the given parameter is an array.
 * If the parameter is not an array, it returns the parameter as is.
 *
 * @since 1.110.0
 * @since 1.128.0 Moved to the common utility directory from the key metrics directory.
 *
 * @param {Array|*} arr Param to be sorted.
 * @return {Array|*} 	Safely sorted array without mutation.
 */
function safelySort(arr) {
  return Array.isArray(arr) ? [...arr].sort() : arr;
}

/***/ }),

/***/ "./js/util/sanitize.js":
/*!*****************************!*\
  !*** ./js/util/sanitize.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sanitizeHTML: () => (/* binding */ sanitizeHTML),
/* harmony export */   untrailingslashit: () => (/* binding */ untrailingslashit)
/* harmony export */ });
/* harmony import */ var _purify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./purify */ "./js/util/purify.js");
/**
 * Internal dependencies
 */

function sanitizeHTML(unsafeHTML, domPurifyConfig = {}) {
  return {
    __html: _purify__WEBPACK_IMPORTED_MODULE_0__.purify.sanitize(unsafeHTML, domPurifyConfig)
  };
}

/**
 * Takes a string or an URL object, removes the trailing slash if any and returns it.
 *
 * @since 1.20.0
 * @private
 *
 * @param {Object|string} url A string with or without trailing slash or an URL object.
 * @return {string|undefined} The URL string after removing the trailing slash.
 */
function untrailingslashit(url) {
  const originalURL = typeof url === 'object' ? url.toString() : url;
  return originalURL?.replace?.(/\/+$/, '');
}

/***/ }),

/***/ "./js/util/storage.js":
/*!****************************!*\
  !*** ./js/util/storage.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   storageAvailable: () => (/* binding */ storageAvailable)
/* harmony export */ });
/**
 * Storage abstraction.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.0.0
 *
 * @param {string} type Browser storage to test. ex localStorage or sessionStorage.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
function storageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

// Custom no-op implementation of window.Storage.
class NullStorage {
  get length() {
    return 0;
  }
  key() {
    return null;
  }
  getItem() {
    return null;
  }
  setItem() {
    // Empty method body.
  }
  removeItem() {
    // Empty method body.
  }
  clear() {
    // Empty method body.
  }
}
let storageObj;

/**
 * Gets the storage object to use.
 *
 * @since 1.0.0
 *
 * @return {Storage} Either window.sessionStorage, window.localStorage', or a
 *                   no-op implementation if neither is available.
 */
function getStorage() {
  // Only run the logic to determine the storage object once.
  if (!storageObj) {
    if (storageAvailable('sessionStorage')) {
      storageObj = __webpack_require__.g.sessionStorage;
    } else if (storageAvailable('localStorage')) {
      storageObj = __webpack_require__.g.localStorage;
    } else {
      storageObj = new NullStorage();
    }
  }
  return storageObj;
}

/***/ }),

/***/ "./js/util/stringify.js":
/*!******************************!*\
  !*** ./js/util/stringify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyObject: () => (/* binding */ stringifyObject)
/* harmony export */ });
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Stringify function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Transforms an object into a hash string.
 *
 * This function can be used to e.g. generate cache keys, based on the given
 * object. Object properties are sorted, so even if they are provided in
 * different order, the hash will match. The function furthermore supports
 * nested objects.
 *
 * @since 1.7.0
 *
 * @param {Object} obj The object to stringify.
 * @return {string} Hash for the object.
 */
function stringifyObject(obj) {
  return md5__WEBPACK_IMPORTED_MODULE_0___default()(JSON.stringify(sortObjectProperties(obj)));
}
function sortObjectProperties(obj) {
  const orderedData = {};
  Object.keys(obj).sort().forEach(key => {
    let val = obj[key];
    if (val && 'object' === typeof val && !Array.isArray(val)) {
      val = sortObjectProperties(val);
    }
    orderedData[key] = val;
  });
  return orderedData;
}

/***/ }),

/***/ "./js/util/tracking/constants.js":
/*!***************************************!*\
  !*** ./js/util/tracking/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_LAYER: () => (/* binding */ DATA_LAYER),
/* harmony export */   SCRIPT_IDENTIFIER: () => (/* binding */ SCRIPT_IDENTIFIER)
/* harmony export */ });
/**
 * Constants related to event tracking.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Data layer global used for internal/private Site Kit data.
 *
 * @since 1.8.0
 * @private
 */
const DATA_LAYER = '_googlesitekitDataLayer';

/**
 * The `gtag` `<script>` identifier.
 *
 * @since 1.8.0
 * @private
 */
const SCRIPT_IDENTIFIER = 'data-googlesitekit-gtag';

/***/ }),

/***/ "./js/util/tracking/createDataLayerPush.js":
/*!*************************************************!*\
  !*** ./js/util/tracking/createDataLayerPush.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createDataLayerPush)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked will initialize the dataLayer and push data onto it.
 *
 * @since 1.3.0
 *
 * @param {Object} target Object to enhance with dataLayer data.
 * @return {Function} Function that pushes data onto the dataLayer.
 */
function createDataLayerPush(target) {
  /**
   * Pushes data onto the data layer.
   *
   * Must push an instance of Arguments to the target.
   * Using an ES6 spread operator (i.e. `...args`) will cause tracking events to
   * _silently_ fail.
   *
   * @since 1.0.0
   * @see {@link https://github.com/google/site-kit-wp/issues/1181}
   */
  return function dataLayerPush() {
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] = target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] || [];
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER].push(arguments);
  };
}

/***/ }),

/***/ "./js/util/tracking/createInitializeSnippet.js":
/*!*****************************************************!*\
  !*** ./js/util/tracking/createInitializeSnippet.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createInitializeSnippet)
/* harmony export */ });
/* harmony import */ var _js_features_index__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/features/index */ "./js/features/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */




/**
 * Returns a function which, when invoked injects the gtag script if necessary.
 *
 * @since 1.44.0
 *
 * @param {Object} config          Tracking configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @return {Function} Function that injects gtag script if it isn't yet present.
 */
function createInitializeSnippet(config, dataLayerTarget) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_2__["default"])(dataLayerTarget);
  let hasInsertedTag;
  const {
    activeModules,
    referenceSiteURL,
    userIDHash,
    userRoles = [],
    isAuthenticated,
    pluginVersion
  } = config;

  /**
   * Injects the necessary script tag if not present.
   *
   * @since 1.118.0
   *
   * @return {boolean|Object} Tag src as scriptTagSrc property.
   */
  return function initializeSnippet() {
    const {
      document
    } = __webpack_require__.g;
    if (undefined === hasInsertedTag) {
      hasInsertedTag = !!document.querySelector(`script[${_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER}]`);
    }
    if (hasInsertedTag) {
      return false;
    }
    hasInsertedTag = true;

    // Sometimes the user roles returned by Site Kit/WordPress is not an
    // array, as expected, so we guard against it here.
    //
    // See: https://github.com/google/site-kit-wp/issues/8266
    const userRolesAsString = userRoles?.length ? userRoles.join(',') : '';

    // We should use the real time, and not the reference date, when
    // measuring when we initialized tracking.
    dataLayerPush('js', new Date()); // eslint-disable-line sitekit/no-direct-date
    dataLayerPush('config', config.trackingID, {
      groups: 'site_kit',
      send_page_view: config.isSiteKitScreen,
      domain: referenceSiteURL,
      plugin_version: pluginVersion || '',
      enabled_features: Array.from(_js_features_index__WEBPACK_IMPORTED_MODULE_0__.enabledFeatures).join(','),
      active_modules: activeModules.join(','),
      authenticated: isAuthenticated ? '1' : '0',
      user_properties: {
        user_roles: userRolesAsString,
        user_identifier: userIDHash
      }
    });

    // If not present, inject it and initialize dataLayer.
    const scriptTag = document.createElement('script');
    scriptTag.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER, '');
    scriptTag.async = true;
    scriptTag.src = `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`;
    document.head.appendChild(scriptTag);
    return {
      scriptTagSrc: `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`
    };
  };
}

/***/ }),

/***/ "./js/util/tracking/createTrackEvent.js":
/*!**********************************************!*\
  !*** ./js/util/tracking/createTrackEvent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTrackEvent)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked tracks a single event.
 *
 * @since 1.3.0
 *
 * @param {Object}   config            Tracking configuration.
 * @param {Object}   dataLayerTarget   Data layer parent object.
 * @param {Function} initializeSnippet Function to initialize tracking.
 * @param {Object}   _global           The global window object.
 * @return {Function} Function that tracks an event.
 */
function createTrackEvent(config, dataLayerTarget, initializeSnippet, _global) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);

  /**
   * Send an Analytics tracking event.
   *
   * @since 1.3.0
   *
   * @param {string} category The category of the event.
   * @param {string} action   The action name of the event.
   * @param {string} [label]  Optional. The label of the event.
   * @param {number} [value]  Optional. A non-negative integer that will appear as the event value.
   * @return {Promise} Promise that always resolves.
   */
  // eslint-disable-next-line require-await
  return async function trackEvent(category, action, label, value) {
    const {
      trackingEnabled
    } = config;
    if (!trackingEnabled) {
      // Resolve immediately if tracking is disabled.
      return null;
    }
    initializeSnippet();
    const eventData = {
      send_to: 'site_kit',
      event_category: category,
      event_label: label,
      value
    };
    return new Promise(resolve => {
      // This timeout ensures a tracking event does not block the user
      // event if it is not sent (in time).
      // If the event beacon fails, it shouldn't reject the promise since event
      // tracking should not result in user-facing errors. It will just
      // trigger a console warning.
      function failCallback() {
        _global.console.warn(`Tracking event "${action}" (category "${category}") took too long to fire.`);
        resolve();
      }
      const failTimeout = setTimeout(failCallback, 1000);
      // eslint-disable-next-line camelcase
      function event_callback() {
        clearTimeout(failTimeout);
        resolve();
      }
      dataLayerPush('event', action, {
        ...eventData,
        event_callback
      });

      // If the client-side opt-out is present, the event_callback will never be called
      // so we call it here to prevent the warning and added delay.
      if (_global._gaUserPrefs?.ioo?.()) {
        event_callback();
      }
    });
  };
}

/***/ }),

/***/ "./js/util/tracking/createTracking.js":
/*!********************************************!*\
  !*** ./js/util/tracking/createTracking.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTracking)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createInitializeSnippet */ "./js/util/tracking/createInitializeSnippet.js");
/* harmony import */ var _createTrackEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createTrackEvent */ "./js/util/tracking/createTrackEvent.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const DEFAULT_CONFIG = {
  activeModules: [],
  isAuthenticated: false,
  referenceSiteURL: '',
  trackingEnabled: false,
  trackingID: '',
  userIDHash: '',
  userRoles: []
};

/**
 * Initializes tracking.
 *
 * @since 1.3.0
 *
 * @param {Object} newConfig       New configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @param {Object} _global         The global window object.
 * @return {Object} Tracking config.
 */
function createTracking(newConfig, dataLayerTarget = __webpack_require__.g, _global = __webpack_require__.g) {
  const config = {
    ...DEFAULT_CONFIG,
    ...newConfig
  };
  // Remove any trailing slash from the reference URL.
  if (config.referenceSiteURL) {
    config.referenceSiteURL = config.referenceSiteURL.toString().replace(/\/+$/, '');
  }
  const initializeSnippet = (0,_createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__["default"])(config, dataLayerTarget);
  const trackEvent = (0,_createTrackEvent__WEBPACK_IMPORTED_MODULE_2__["default"])(config, dataLayerTarget, initializeSnippet, _global);
  const onceTrackedEventsMap = {};
  function trackEventOnce(...params) {
    const key = JSON.stringify(params);
    if (!onceTrackedEventsMap[key]) {
      onceTrackedEventsMap[key] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.once)(trackEvent);
    }
    onceTrackedEventsMap[key](...params);
  }
  return {
    enableTracking: function enableTracking() {
      config.trackingEnabled = true;
    },
    disableTracking: function disableTracking() {
      config.trackingEnabled = false;
    },
    initializeSnippet,
    isTrackingEnabled: function isTrackingEnabled() {
      return !!config.trackingEnabled;
    },
    trackEvent,
    trackEventOnce
  };
}

/***/ }),

/***/ "./js/util/tracking/index.js":
/*!***********************************!*\
  !*** ./js/util/tracking/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTracking: () => (/* binding */ disableTracking),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   isTrackingEnabled: () => (/* binding */ isTrackingEnabled),
/* harmony export */   toggleTracking: () => (/* binding */ toggleTracking),
/* harmony export */   trackEvent: () => (/* binding */ trackEvent),
/* harmony export */   trackEventOnce: () => (/* binding */ trackEventOnce)
/* harmony export */ });
/* harmony import */ var _createTracking__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createTracking */ "./js/util/tracking/createTracking.js");
/**
 * Event tracking utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * Internal dependencies
 */

const {
  activeModules = [],
  isSiteKitScreen,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isAuthenticated,
  userRoles
} = __webpack_require__.g._googlesitekitTrackingData || {};

// Access the plugin version directly without destructuring as Webpack's DefinePlugin
// performs text replacement at build time and doesn't support destructuring patterns.
// See: https://github.com/google/site-kit-wp/issues/11802#issuecomment-3562955579
const pluginVersion = "1.168.0";
const initialConfig = {
  activeModules,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isSiteKitScreen,
  userRoles,
  isAuthenticated,
  pluginVersion
};
const {
  enableTracking,
  disableTracking,
  isTrackingEnabled,
  initializeSnippet,
  trackEvent,
  trackEventOnce
} = (0,_createTracking__WEBPACK_IMPORTED_MODULE_0__["default"])(initialConfig);

/**
 * Changes the active state of tracking.
 *
 * @since 1.3.0
 *
 * @param {boolean} activeStatus The new state to set.
 */
function toggleTracking(activeStatus) {
  if (!!activeStatus) {
    enableTracking();
  } else {
    disableTracking();
  }
}

// Bootstrap on import if tracking is allowed.
if (isSiteKitScreen && trackingEnabled) {
  initializeSnippet();
}


/***/ }),

/***/ "./js/util/urls.js":
/*!*************************!*\
  !*** ./js/util/urls.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFullURL: () => (/* binding */ getFullURL),
/* harmony export */   getURLPath: () => (/* binding */ getURLPath),
/* harmony export */   isHashOnly: () => (/* binding */ isHashOnly),
/* harmony export */   normalizeURL: () => (/* binding */ normalizeURL),
/* harmony export */   shortenURL: () => (/* binding */ shortenURL)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/**
 * URL pathname getter utility function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the path from a URL, omitting its protocol, hostname, query params, and hash.
 *
 * @since 1.24.0
 *
 * @param {string} url The URL to get the path from.
 * @return {string} The URL path.
 */
function getURLPath(url) {
  try {
    return new URL(url).pathname;
  } catch {}
  return null;
}

/**
 * Returns the absolute URL from a path including the siteURL.
 *
 * @since 1.32.0
 *
 * @param {string} siteURL The siteURL fo the WordPress install.
 * @param {string} path    The path.
 * @return {string} The URL path.
 */
function getFullURL(siteURL, path) {
  try {
    return new URL(path, siteURL).href;
  } catch {}
  return (typeof siteURL === 'string' ? siteURL : '') + (typeof path === 'string' ? path : '');
}

/**
 * Normalizes URL by removing protocol, www subdomain and trailing slash.
 *
 * @since 1.33.0
 *
 * @param {string} incomingURL The original URL.
 * @return {string} Normalized URL.
 */
function normalizeURL(incomingURL) {
  if (typeof incomingURL !== 'string') {
    return incomingURL;
  }
  return incomingURL
  // Remove protocol and optional "www." prefix from the URL.
  .replace(/^https?:\/\/(www\.)?/i, '')
  // Remove trailing slash.
  .replace(/\/$/, '');
}

/**
 * Checks if a string is not a full URL and simply a hash / anchor link.
 *
 * @since 1.49.0
 *
 * @param {string} url The URL or Hash string to test.
 * @return {boolean} Returns true if the string is only a hash and not a full URL.
 */
function isHashOnly(url) {
  return /^#\w[A-Za-z0-9-_]*$/.test(url);
}

/**
 * Shortens a URL to fit a given length.
 *
 * @since 1.49.0
 *
 * @param {string} url      The original URL to shorten.
 * @param {number} maxChars The maximum length of the URL.
 * @return {string} The shortened URL.
 */
function shortenURL(url, maxChars) {
  if (!(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.isURL)(url)) {
    return url;
  }
  if (url.length <= maxChars) {
    return url;
  }
  const urlObject = new URL(url);
  const shortenedURL = url.replace(urlObject.origin, '');
  if (shortenedURL.length < maxChars) {
    return shortenedURL;
  }
  const extraChars = shortenedURL.length - Math.floor(maxChars) + 1; // 1 is the length of "…".
  return '…' + shortenedURL.substr(extraChars);
}

/***/ }),

/***/ "./svg/graphics/activate-analytics-graphic.svg?url":
/*!*********************************************************!*\
  !*** ./svg/graphics/activate-analytics-graphic.svg?url ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-consent-mode-setup-cta-mobile.svg?url":
/*!*******************************************************************!*\
  !*** ./svg/graphics/banner-consent-mode-setup-cta-mobile.svg?url ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-consent-mode-setup-cta.svg?url":
/*!************************************************************!*\
  !*** ./svg/graphics/banner-consent-mode-setup-cta.svg?url ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-error.svg?url":
/*!*******************************************!*\
  !*** ./svg/graphics/banner-error.svg?url ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-gathering-data.svg?url":
/*!****************************************************!*\
  !*** ./svg/graphics/banner-gathering-data.svg?url ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-google-tag-gateway-setup-cta-mobile.svg?url":
/*!*************************************************************************!*\
  !*** ./svg/graphics/banner-google-tag-gateway-setup-cta-mobile.svg?url ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-google-tag-gateway-setup-cta.svg?url":
/*!******************************************************************!*\
  !*** ./svg/graphics/banner-google-tag-gateway-setup-cta.svg?url ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-site-kit-setup-success.svg?url":
/*!************************************************************!*\
  !*** ./svg/graphics/banner-site-kit-setup-success.svg?url ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-warning.svg?url":
/*!*********************************************!*\
  !*** ./svg/graphics/banner-warning.svg?url ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/email-reporting-overlay-desktop.svg":
/*!**********************************************************!*\
  !*** ./svg/graphics/email-reporting-overlay-desktop.svg ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g, _defs;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgEmailReportingOverlayDesktop = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 348 163"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  clipPath: "url(#email-reporting-overlay-desktop_svg__a)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#B8E6CA",
  d: "M0 16C0 7.163 7.163 0 16 0h316c8.837 0 16 7.163 16 16v147H0z"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-desktop_svg__b)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#EBEEF0",
  d: "M75.352 82.774a8.32 8.32 0 0 1 4.337-7.307l87.93-47.985a13.32 13.32 0 0 1 12.761 0l87.931 47.985a8.32 8.32 0 0 1 4.337 7.307v94.401a8.325 8.325 0 0 1-8.325 8.325H83.676a8.325 8.325 0 0 1-8.324-8.325z"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-desktop_svg__c)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 88,
  height: 57,
  x: 66.467,
  y: -1.393,
  fill: "#fff",
  rx: 9.075,
  transform: "rotate(-38.65 66.467 -1.393)"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 61,
  height: 6.763,
  x: 84.463,
  y: 0.297,
  fill: "#EBEEF0",
  rx: 3.3,
  transform: "rotate(-38.65 84.463 .297)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 41.249,
  height: 15.94,
  x: 93.201,
  y: 10.905,
  fill: "#B8E6CA",
  rx: 7.97,
  transform: "rotate(-38.65 93.201 10.905)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#fff",
  strokeLinecap: "round",
  strokeLinejoin: "round",
  strokeWidth: 1.237,
  d: "m105.805 14.774.966-7.501m0 0-3.388 2.634m3.388-2.634 2.636 3.2"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 16.5,
  height: 4.782,
  x: 110.861,
  y: 3.926,
  fill: "#fff",
  rx: 1.65,
  transform: "rotate(-38.65 110.861 3.926)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-desktop_svg__d)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 87,
  height: 57,
  x: 171.227,
  y: 1.983,
  fill: "#fff",
  rx: 9.075,
  transform: "rotate(5.072 171.227 1.983)"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 52,
  height: 7,
  x: 183.025,
  y: 16.081,
  fill: "#EBEEF0",
  rx: 3.3,
  transform: "rotate(5.072 183.025 16.081)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 41.249,
  height: 16.5,
  x: 181.969,
  y: 30.268,
  fill: "#FFDED3",
  rx: 8.25,
  transform: "rotate(5.072 181.969 30.268)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#fff",
  strokeLinecap: "round",
  strokeLinejoin: "round",
  strokeWidth: 1.237,
  d: "m188.852 36.676 4.937 5.9m0 0 .44-4.27m-.44 4.27-4.28-.32"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 16.5,
  height: 4.95,
  x: 199.535,
  y: 37.625,
  fill: "#fff",
  rx: 1.65,
  transform: "rotate(5.072 199.535 37.625)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-desktop_svg__e)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 87,
  height: 57,
  x: 168.918,
  y: 77.078,
  fill: "#fff",
  rx: 9.075,
  transform: "rotate(21.428 168.918 77.078)"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 20.625,
  height: 6.6,
  x: 176.383,
  y: 94.187,
  fill: "#EBEEF0",
  rx: 3.3,
  transform: "rotate(21.428 176.383 94.187)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 41.249,
  height: 16.5,
  x: 171.26,
  y: 107.243,
  fill: "#FFDED3",
  rx: 8.25,
  transform: "rotate(21.428 171.26 107.243)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#fff",
  strokeLinecap: "round",
  strokeLinejoin: "round",
  strokeWidth: 1.237,
  d: "m176.06 115.331 3.076 7.05m0 0 1.624-3.972m-1.624 3.972-4.016-1.511"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 16.5,
  height: 4.95,
  x: 186.045,
  y: 119.249,
  fill: "#fff",
  rx: 1.65,
  transform: "rotate(21.428 186.045 119.249)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-desktop_svg__f)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 88,
  height: 57,
  x: 101.674,
  y: 57.565,
  fill: "#fff",
  rx: 9.075,
  transform: "rotate(-9.325 101.674 57.565)"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 41,
  height: 7,
  x: 116.609,
  y: 68.287,
  fill: "#EBEEF0",
  rx: 3.3,
  transform: "rotate(-9.325 116.609 68.287)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 41.249,
  height: 16.5,
  x: 119.109,
  y: 82.291,
  fill: "#B8E6CA",
  rx: 8.25,
  transform: "rotate(-9.325 119.109 82.291)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#fff",
  strokeLinecap: "round",
  strokeLinejoin: "round",
  strokeWidth: 1.237,
  d: "m128.264 92.214 4.486-6.25m0 0-4.244.636m4.244-.635.755 4.224"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 16.5,
  height: 4.95,
  x: 137.955,
  y: 85.049,
  fill: "#fff",
  rx: 1.65,
  transform: "rotate(-9.325 137.955 85.049)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-desktop_svg__g)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#fff",
  d: "M75.352 82.647c0-1.968 2.17-3.163 3.833-2.11l90.363 57.192a8.33 8.33 0 0 0 8.904 0l90.363-57.192c1.663-1.053 3.833.142 3.833 2.11v94.528a8.325 8.325 0 0 1-8.325 8.325H83.676a8.325 8.325 0 0 1-8.324-8.325z"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#EBEEF0",
  strokeOpacity: 0.75,
  strokeWidth: 2.497,
  d: "m78.682 183.003 64.933-62.436M269.318 183.003l-64.933-62.436"
}))), _defs || (_defs = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("defs", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-desktop_svg__b",
  width: 229.297,
  height: 191.646,
  x: 59.352,
  y: 17.854,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 8
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 8
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0.193775 0 0 0 0 0.34389 0 0 0 0 0.252153 0 0 0 0.2 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_623_10575"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_623_10575",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-desktop_svg__c",
  width: 123.366,
  height: 118.517,
  x: 56.947,
  y: -62.574,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 3.3
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 6.6
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_623_10575"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_623_10575",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-desktop_svg__d",
  width: 116.565,
  height: 89.335,
  x: 153.753,
  y: -7.151,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 3.3
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 6.6
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_623_10575"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_623_10575",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-desktop_svg__e",
  width: 122.839,
  height: 105.872,
  x: 137.58,
  y: 69.864,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 3.3
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 6.6
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_623_10575"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_623_10575",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-desktop_svg__f",
  width: 119.774,
  height: 94.207,
  x: 89.824,
  y: 34.756,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 3.3
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 6.6
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_623_10575"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_623_10575",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-desktop_svg__g",
  width: 223.936,
  height: 131.994,
  x: 62.032,
  y: 63.496,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: -3.33
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 6.66
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_623_10575"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_623_10575",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("clipPath", {
  id: "email-reporting-overlay-desktop_svg__a"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#fff",
  d: "M0 16C0 7.163 7.163 0 16 0h316c8.837 0 16 7.163 16 16v147H0z"
})))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgEmailReportingOverlayDesktop);

/***/ }),

/***/ "./svg/graphics/email-reporting-overlay-mobile.svg":
/*!*********************************************************!*\
  !*** ./svg/graphics/email-reporting-overlay-mobile.svg ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g, _defs;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgEmailReportingOverlayMobile = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 343 104"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  clipPath: "url(#email-reporting-overlay-mobile_svg__a)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#B8E6CA",
  d: "M304.553 64.365c2.4 22.73-4.803 32.78-23.025 59.949-18.222 27.17 7.404 59.277-20.779 89.869-33.528 36.394-150.686 39.364-201.232 24.212C8.97 223.242-4.063 191.922-.431 163.24 4.5 124.314 27.02 123.577 40 104.5c19.276-28.325 1.687-66.286 39-89s80.086 6.697 120.326 4.388c23.216-1.332 46.017-5.627 66.626.968 20.832 6.667 36.719 25.428 38.601 43.509"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-mobile_svg__b)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#EBEEF0",
  d: "M97.55 54.93a6.28 6.28 0 0 1 3.274-5.515l66.361-36.214a10.05 10.05 0 0 1 9.631 0l66.361 36.214a6.28 6.28 0 0 1 3.273 5.515v71.244a6.283 6.283 0 0 1-6.283 6.283H103.833a6.283 6.283 0 0 1-6.282-6.283z"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-mobile_svg__c)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 65.659,
  height: 43.018,
  x: 169.907,
  y: 3.573,
  fill: "#fff",
  rx: 6.849,
  transform: "rotate(5.072 169.907 3.573)"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 39.244,
  height: 5.283,
  x: 178.812,
  y: 14.213,
  fill: "#EBEEF0",
  rx: 2.49,
  transform: "rotate(5.072 178.812 14.213)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 31.131,
  height: 12.452,
  x: 178.013,
  y: 24.92,
  fill: "#FFDED3",
  rx: 6.226,
  transform: "rotate(5.072 178.013 24.92)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#fff",
  strokeLinecap: "round",
  strokeLinejoin: "round",
  strokeWidth: 0.934,
  d: "m183.207 29.756 3.726 4.452m0 0 .332-3.222m-.332 3.222-3.229-.24"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 12.452,
  height: 3.736,
  x: 191.272,
  y: 30.472,
  fill: "#fff",
  rx: 1.245,
  transform: "rotate(5.072 191.272 30.472)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-mobile_svg__d)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 65.659,
  height: 43.018,
  x: 168.165,
  y: 50.631,
  fill: "#fff",
  rx: 6.849,
  transform: "rotate(21.428 168.165 50.631)"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 15.565,
  height: 4.981,
  x: 173.799,
  y: 63.543,
  fill: "#EBEEF0",
  rx: 2.49,
  transform: "rotate(21.428 173.799 63.543)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 31.131,
  height: 12.452,
  x: 169.932,
  y: 73.397,
  fill: "#FFDED3",
  rx: 6.226,
  transform: "rotate(21.428 169.932 73.397)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#fff",
  strokeLinecap: "round",
  strokeLinejoin: "round",
  strokeWidth: 0.934,
  d: "m173.554 79.5 2.322 5.321m0 0 1.225-2.998m-1.225 2.998-3.032-1.14"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 12.452,
  height: 3.736,
  x: 181.091,
  y: 82.458,
  fill: "#fff",
  rx: 1.245,
  transform: "rotate(21.428 181.091 82.458)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-mobile_svg__e)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 66.413,
  height: 43.018,
  x: 117.415,
  y: 35.905,
  fill: "#fff",
  rx: 6.849,
  transform: "rotate(-9.325 117.415 35.905)"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 30.943,
  height: 5.283,
  x: 128.687,
  y: 43.996,
  fill: "#EBEEF0",
  rx: 2.49,
  transform: "rotate(-9.325 128.687 43.996)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 31.131,
  height: 12.452,
  x: 130.575,
  y: 54.565,
  fill: "#B8E6CA",
  rx: 6.226,
  transform: "rotate(-9.325 130.575 54.565)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#fff",
  strokeLinecap: "round",
  strokeLinejoin: "round",
  strokeWidth: 0.934,
  d: "m137.483 62.054 3.386-4.716m0 0-3.203.48m3.203-.48.57 3.188"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 12.452,
  height: 3.736,
  x: 144.797,
  y: 56.647,
  fill: "#fff",
  rx: 1.245,
  transform: "rotate(-9.325 144.797 56.647)"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  filter: "url(#email-reporting-overlay-mobile_svg__f)"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#fff",
  d: "M97.55 54.834c0-1.485 1.639-2.387 2.894-1.593l68.196 43.163a6.28 6.28 0 0 0 6.72 0l68.197-43.163c1.255-.794 2.893.108 2.893 1.593v71.34a6.283 6.283 0 0 1-6.283 6.283H103.833a6.283 6.283 0 0 1-6.282-6.283z"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#EBEEF0",
  strokeOpacity: 0.75,
  strokeWidth: 1.885,
  d: "m100.063 130.572 49.005-47.12M243.937 130.572l-49.005-47.12"
}))), _defs || (_defs = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("defs", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-mobile_svg__b",
  width: 173.05,
  height: 144.635,
  x: 85.476,
  y: 5.935,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 6.038
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 6.038
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0.193775 0 0 0 0 0.34389 0 0 0 0 0.252153 0 0 0 0.2 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_1164_30170"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_1164_30170",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-mobile_svg__c",
  width: 87.972,
  height: 67.421,
  x: 156.721,
  y: -3.32,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 2.49
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 4.981
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_1164_30170"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_1164_30170",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-mobile_svg__d",
  width: 92.706,
  height: 79.901,
  x: 144.515,
  y: 45.187,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 2.49
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 4.981
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_1164_30170"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_1164_30170",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-mobile_svg__e",
  width: 90.393,
  height: 71.098,
  x: 108.472,
  y: 18.69,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: 2.49
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 4.981
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_1164_30170"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_1164_30170",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("filter", {
  id: "email-reporting-overlay-mobile_svg__f",
  width: 169.004,
  height: 99.615,
  x: 87.499,
  y: 40.381,
  colorInterpolationFilters: "sRGB",
  filterUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feFlood", {
  floodOpacity: 0,
  result: "BackgroundImageFix"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  in: "SourceAlpha",
  result: "hardAlpha",
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feOffset", {
  dy: -2.513
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feGaussianBlur", {
  stdDeviation: 5.026
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feComposite", {
  in2: "hardAlpha",
  operator: "out"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feColorMatrix", {
  values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.05 0"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in2: "BackgroundImageFix",
  result: "effect1_dropShadow_1164_30170"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("feBlend", {
  in: "SourceGraphic",
  in2: "effect1_dropShadow_1164_30170",
  result: "shape"
})), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("clipPath", {
  id: "email-reporting-overlay-mobile_svg__a"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#fff",
  d: "M0 0h343v104H0z"
})))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgEmailReportingOverlayMobile);

/***/ }),

/***/ "./svg/icons/arrow-inverse.svg":
/*!*************************************!*\
  !*** ./svg/icons/arrow-inverse.svg ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrowInverse = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "#FFF"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrowInverse);

/***/ }),

/***/ "./svg/icons/arrow.svg":
/*!*****************************!*\
  !*** ./svg/icons/arrow.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrow = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "currentColor"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#FFF",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrow);

/***/ }),

/***/ "./svg/icons/back.svg":
/*!****************************!*\
  !*** ./svg/icons/back.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgBack = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "m12 20-8-8 8-8 1.425 1.4-5.6 5.6H20v2H7.825l5.6 5.6z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgBack);

/***/ }),

/***/ "./svg/icons/check-fill.svg":
/*!**********************************!*\
  !*** ./svg/icons/check-fill.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgCheckFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  fillRule: "evenodd",
  d: "M12 1C5.925 1 1 5.925 1 12s4.925 11 11 11 11-4.925 11-11S18.075 1 12 1m4.806 8.592.592-.806-1.612-1.184-.592.806-3.89 5.296c-.166.226-.36.296-.512.296s-.346-.07-.512-.296l-1.474-2.007-.592-.806-1.612 1.184.592.806 1.474 2.007C9.191 15.6 9.971 16 10.792 16s1.6-.4 2.124-1.112z",
  clipRule: "evenodd"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgCheckFill);

/***/ }),

/***/ "./svg/icons/close.svg":
/*!*****************************!*\
  !*** ./svg/icons/close.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgClose = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 14 14"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M14 1.41 12.59 0 7 5.59 1.41 0 0 1.41 5.59 7 0 12.59 1.41 14 7 8.41 12.59 14 14 12.59 8.41 7z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgClose);

/***/ }),

/***/ "./svg/icons/external.svg":
/*!********************************!*\
  !*** ./svg/icons/external.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgExternal = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "M5 21a2 2 0 0 1-1.425-.575A2 2 0 0 1 3 19V5q0-.825.575-1.4Q4.175 3 5 3h7v2H5v14h14v-7h2v7q0 .825-.6 1.425Q19.825 21 19 21zm4.7-5.3-1.4-1.4L17.6 5H14V3h7v7h-2V6.4z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgExternal);

/***/ }),

/***/ "./svg/icons/star-fill.svg":
/*!*********************************!*\
  !*** ./svg/icons/star-fill.svg ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgStarFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "m5.825 22 2.325-7.6L2 10h7.6L12 2l2.4 8H22l-6.15 4.4 2.325 7.6L12 17.3z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgStarFill);

/***/ }),

/***/ "./svg/icons/warning-notice.svg":
/*!**************************************!*\
  !*** ./svg/icons/warning-notice.svg ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningNotice = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1m0 14a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3m-1-2h2V6h-2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningNotice);

/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.i18n;

/***/ }),

/***/ "googlesitekit-components":
/*!***********************************************!*\
  !*** external ["googlesitekit","components"] ***!
  \***********************************************/
/***/ ((module) => {

module.exports = googlesitekit.components;

/***/ }),

/***/ "googlesitekit-data":
/*!*****************************************!*\
  !*** external ["googlesitekit","data"] ***!
  \*****************************************/
/***/ ((module) => {

module.exports = googlesitekit.data;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-notifications.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-notifications.js.map