(globalThis["__googlesitekit_webpackJsonp"] = globalThis["__googlesitekit_webpackJsonp"] || []).push([["googlesitekit-wp-dashboard"],{

/***/ "./js/components/AccessibleWarningIcon.js":
/*!************************************************!*\
  !*** ./js/components/AccessibleWarningIcon.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccessibleWarningIcon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_warning_v2_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/warning-v2.svg */ "./svg/icons/warning-v2.svg");
/* harmony import */ var _VisuallyHidden__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./VisuallyHidden */ "./js/components/VisuallyHidden.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AccessibleWarningIcon component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function AccessibleWarningIcon({
  height = 12,
  screenReaderText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error', 'google-site-kit'),
  width = 14
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_VisuallyHidden__WEBPACK_IMPORTED_MODULE_2__["default"], {
      children: screenReaderText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_warning_v2_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: width,
      height: height
    })]
  });
}
AccessibleWarningIcon.propTypes = {
  height: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number),
  screenReaderText: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number)
};

/***/ }),

/***/ "./js/components/ActivateAnalyticsCTA.js":
/*!***********************************************!*\
  !*** ./js/components/ActivateAnalyticsCTA.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ActivateAnalyticsCTA)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useActivateModuleCallback */ "./js/hooks/useActivateModuleCallback.js");
/* harmony import */ var _js_hooks_useCompleteModuleActivationCallback__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useCompleteModuleActivationCallback */ "./js/hooks/useCompleteModuleActivationCallback.js");
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ActivateAnalyticsCTA component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function ActivateAnalyticsCTA({
  children
}) {
  const activateModuleCallback = (0,_js_hooks_useActivateModuleCallback__WEBPACK_IMPORTED_MODULE_5__["default"])(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ANALYTICS_4);
  const completeModuleActivationCallback = (0,_js_hooks_useCompleteModuleActivationCallback__WEBPACK_IMPORTED_MODULE_6__["default"])(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ANALYTICS_4);
  const analyticsModuleActive = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).isModuleActive(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ANALYTICS_4));
  const analyticsModuleAvailable = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const {
      isModuleAvailable
    } = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES);
    return isModuleAvailable(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ANALYTICS_4) && !!select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ANALYTICS_4);
  });
  const [inProgress, setInProgress] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
  const isNavigatingToReauthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    if (!analyticsModuleAvailable) {
      return false;
    }
    const adminReauthURL = select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_9__.MODULES_ANALYTICS_4).getAdminReauthURL();
    if (!adminReauthURL) {
      return false;
    }
    return select(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_LOCATION).isNavigatingTo(adminReauthURL);
  });
  const isActivating = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    if (!analyticsModuleAvailable) {
      return false;
    }
    return select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).isFetchingSetModuleActivation(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_8__.MODULE_SLUG_ANALYTICS_4, true);
  });

  /*
   * Using debounce here because the spinner has to render across two separate calls.
   * Rather than risk it flickering on and off in between the activation call completing and
   * the navigate call starting, we will just set a debounce to keep the spinner for 3 seconds.
   */
  const debouncedSetInProgress = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_7__.useDebounce)(setInProgress, 3000);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
    if (isActivating || isNavigatingToReauthURL) {
      setInProgress(true);
    } else {
      debouncedSetInProgress(false);
    }
  }, [isActivating, isNavigatingToReauthURL, debouncedSetInProgress]);
  const onClickCallback = analyticsModuleActive ? completeModuleActivationCallback : activateModuleCallback;
  if (!analyticsModuleAvailable || !onClickCallback) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    className: "googlesitekit-analytics-cta",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
      className: "googlesitekit-analytics-cta__preview-graphs",
      children: children
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
      className: "googlesitekit-analytics-cta__details",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("p", {
        className: "googlesitekit-analytics-cta--description",
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('See how many people visit your site from Search and track how you’re achieving your goals', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
        onClick: onClickCallback,
        isSaving: inProgress,
        disabled: inProgress,
        children: analyticsModuleActive ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Complete setup', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set up Google Analytics', 'google-site-kit')
      })]
    })]
  });
}
ActivateAnalyticsCTA.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node).isRequired
};

/***/ }),

/***/ "./js/components/Badge.js":
/*!********************************!*\
  !*** ./js/components/Badge.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Badge component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Badge = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  label,
  className,
  hasLeftSpacing = false,
  ...rest
}, ref) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
  ref: ref,
  ...rest,
  className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-badge', className, {
    'googlesitekit-badge--has-left-spacing': hasLeftSpacing
  }),
  children: label
}));
Badge.displayName = 'Badge';
Badge.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  hasLeftSpacing: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Badge);

/***/ }),

/***/ "./js/components/Banner/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function CTAButton({
  label,
  ariaLabel,
  disabled,
  inProgress,
  onClick,
  href,
  external = false,
  hideExternalIndicator = false
}) {
  if (!label || !onClick && !href) {
    return null;
  }
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_1__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.SpinnerButton, {
    className: "googlesitekit-banner__cta",
    "aria-label": ariaLabel,
    disabled: disabled || inProgress,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : undefined,
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  ariaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  dismissOnClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Banner/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Description({
  className,
  description,
  learnMoreLink,
  additionalDescription,
  children
}) {
  function renderDescription() {
    if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.isValidElement)(description)) {
      return description;
    }
    if ('string' === typeof description) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
        dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.sanitizeHTML)(description, {
          ALLOWED_TAGS: ['strong', 'em', 'br', 'a'],
          ALLOWED_ATTR: ['href']
        })
      });
    }
    return description;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__description', className),
    children: [renderDescription(), ' ', learnMoreLink?.href && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
      ...learnMoreLink
    }), additionalDescription && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
      className: "googlesitekit-banner__additional-description",
      children: additionalDescription
    }), children]
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_2__["default"].propTypes),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};

/***/ }),

/***/ "./js/components/Banner/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Banner/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  className,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Maybe later', 'google-site-kit'),
  onClick,
  disabled,
  tertiary = true
}) {
  if (!onClick) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    className: className,
    onClick: onClick,
    disabled: disabled,
    tertiary: tertiary,
    children: label
  });
}
DismissButton.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  tertiary: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  dismissOptions: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({
    expiresInSeconds: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
    skipHidingFromQueue: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
  })
};

/***/ }),

/***/ "./js/components/Banner/Footer.js":
/*!****************************************!*\
  !*** ./js/components/Banner/Footer.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Footer)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Footer({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__footer', className),
    children: children
  });
}
Footer.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/HelpText.js":
/*!******************************************!*\
  !*** ./js/components/Banner/HelpText.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HelpText)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function HelpText({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__help-text', className),
    children: children
  });
}
HelpText.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/LearnMoreLink.tsx":
/*!************************************************!*\
  !*** ./js/components/Banner/LearnMoreLink.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* provided dependency */ var React = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/index.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

/**
 * Renders a "Learn More" link component, usually used to append "Learn more" with a
 * specified URL to content like a paragraph.
 *
 * @since 1.153.0
 *
 * @param props            The props for the component.
 * @param props.className  The class name for the link.
 * @param [props.external] Whether the link is external. Optional, defaults to true.
 * @param props.href       The URL for the link.
 * @param props.label      The label for the link.
 * @param [props.onClick]  The function to call when the link is clicked. Optional, defaults to an empty function.
 * @return The rendered component.
 */
const LearnMoreLink = ({
  className,
  external = true,
  href,
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Learn more', 'google-site-kit'),
  onClick = () => {}
}) => {
  // Return null if no href is provided.
  //
  // This arguably shouldn't be optional, but until all usage of this
  // component are via typed code, we need this safeguard.
  if (!href) {
    return null;
  }
  return (
    /*#__PURE__*/
    // @ts-expect-error `Link` component is not currently typed, so this
    // results in an error because we're supplying a `children` prop.
    React.createElement(_js_components_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      href: href,
      className: className,
      onClick: onClick,
      external: external
    }, label)
  );
};
LearnMoreLink.propTypes = {
  href: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LearnMoreLink);

/***/ }),

/***/ "./js/components/Banner/Title.js":
/*!***************************************!*\
  !*** ./js/components/Banner/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/TitleIcon.js":
/*!*******************************************!*\
  !*** ./js/components/Banner/TitleIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TitleIcon)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function TitleIcon({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__title-icon', className),
    children: children
  });
}
TitleIcon.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Banner/index.js":
/*!***************************************!*\
  !*** ./js/components/Banner/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Notice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/Notice */ "./js/components/Notice/index.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Description */ "./js/components/Banner/Description.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Footer */ "./js/components/Banner/Footer.js");
/* harmony import */ var _HelpText__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./HelpText */ "./js/components/Banner/HelpText.js");
/* harmony import */ var _LearnMoreLink__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Title */ "./js/components/Banner/Title.js");
/* harmony import */ var _TitleIcon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./TitleIcon */ "./js/components/Banner/TitleIcon.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











const Banner = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.forwardRef)(({
  className,
  titleIcon,
  title,
  description,
  additionalDescription,
  errorText,
  helpText,
  learnMoreLink,
  dismissButton,
  ctaButton,
  svg,
  // NOTE: SVGs must be imported with the ?url suffix for use as a backgroundImage in this component.
  footer
}, ref) => {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.useBreakpoint)();
  const isMobileOrTablet = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.BREAKPOINT_SMALL || breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_2__.BREAKPOINT_TABLET;
  let SVGData = null;
  if (isMobileOrTablet && svg?.mobile) {
    SVGData = svg.mobile;
  } else if (!isMobileOrTablet && svg?.desktop) {
    SVGData = svg.desktop;
  }
  const svgMode = svg?.verticalPosition ? svg.verticalPosition : 'center';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner', className),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-banner__content",
      children: [titleIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_TitleIcon__WEBPACK_IMPORTED_MODULE_10__["default"], {
        children: titleIcon
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_9__["default"], {
        children: title
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_4__["default"], {
        description: description,
        learnMoreLink: learnMoreLink,
        additionalDescription: additionalDescription
      }), helpText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_HelpText__WEBPACK_IMPORTED_MODULE_7__["default"], {
        children: helpText
      }), errorText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Notice__WEBPACK_IMPORTED_MODULE_1__["default"], {
        type: "error",
        description: errorText
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "googlesitekit-notice__action",
        children: [ctaButton && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_3__["default"], {
          ...ctaButton
        }), dismissButton?.onClick && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"], {
          ...dismissButton
        })]
      })]
    }), SVGData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner__svg-wrapper', {
        [`googlesitekit-banner__svg-wrapper--${svgMode}`]: svgMode
      }),
      style: {
        backgroundImage: `url(${SVGData})`
      }
    }), footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_Footer__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: footer
    })]
  });
});
Banner.propTypes = {
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  additionalDescription: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_13___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)]),
  errorText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  helpText: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().string),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_LearnMoreLink__WEBPACK_IMPORTED_MODULE_8__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape(_CTAButton__WEBPACK_IMPORTED_MODULE_3__["default"].propTypes),
  svg: prop_types__WEBPACK_IMPORTED_MODULE_13___default().shape({
    desktop: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    mobile: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().elementType),
    verticalPosition: prop_types__WEBPACK_IMPORTED_MODULE_13___default().oneOf(['top', 'center', 'bottom'])
  }),
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Banner);

/***/ }),

/***/ "./js/components/ChangeArrow.js":
/*!**************************************!*\
  !*** ./js/components/ChangeArrow.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



function ChangeArrow({
  direction,
  invertColor,
  width,
  height
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("svg", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-change-arrow', `googlesitekit-change-arrow--${direction}`, {
      'googlesitekit-change-arrow--inverted-color': invertColor
    }),
    width: width,
    height: height,
    viewBox: "0 0 10 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("path", {
      d: "M5.625 10L5.625 2.375L9.125 5.875L10 5L5 -1.76555e-07L-2.7055e-07 5L0.875 5.875L4.375 2.375L4.375 10L5.625 10Z",
      fill: "currentColor"
    })
  });
}
ChangeArrow.propTypes = {
  direction: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  invertColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number)
};
ChangeArrow.defaultProps = {
  direction: 'up',
  invertColor: false,
  width: 9,
  height: 9
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeArrow);

/***/ }),

/***/ "./js/components/DataBlock/Change.js":
/*!*******************************************!*\
  !*** ./js/components/DataBlock/Change.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Change component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function Change({
  change,
  changeDataUnit,
  period,
  invertChangeColor
}) {
  let changeFormatted = change;

  // If changeDataUnit is given, try using it as currency first, otherwise add it as suffix.
  if (changeDataUnit) {
    if (changeDataUnit === '%') {
      // Format percentage change with only 1 digit instead of the usual 2.
      changeFormatted = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(change, {
        style: 'percent',
        signDisplay: 'never',
        maximumFractionDigits: 1
      });
    } else {
      changeFormatted = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(change, changeDataUnit);
    }
  }

  // If period is given (requires %s placeholder), add it.
  if (period) {
    changeFormatted = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(period, changeFormatted);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-data-block__change', {
      'googlesitekit-data-block__change--no-change': !change
    }),
    children: [!!change && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
      className: "googlesitekit-data-block__arrow",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_2__["default"], {
        direction: 0 < parseFloat(change) ? 'up' : 'down',
        invertColor: invertChangeColor
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
      className: "googlesitekit-data-block__value",
      children: changeFormatted
    })]
  });
}
Change.propTypes = {
  change: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number)]),
  changeDataUnit: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)]),
  period: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  invertChangeColor: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Change);

/***/ }),

/***/ "./js/components/DataBlock/Content.js":
/*!********************************************!*\
  !*** ./js/components/DataBlock/Content.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Content)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Badge */ "./js/components/Badge.js");
/* harmony import */ var _js_components_SourceLink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/SourceLink */ "./js/components/SourceLink.tsx");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _Change__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Change */ "./js/components/DataBlock/Change.js");
/* harmony import */ var _Sparkline__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Sparkline */ "./js/components/DataBlock/Sparkline.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Content component for DataBlock.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







function Content({
  title = '',
  datapoint = null,
  datapointUnit = '',
  change = null,
  changeDataUnit = '',
  period = '',
  source,
  sparkline,
  invertChangeColor = false,
  gatheringData = false,
  badge
}) {
  const datapointFormatted = datapoint === undefined ? datapoint : (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(datapoint, datapointUnit);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-data-block__title-datapoint-wrapper",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_2__["default"], {
        as: "h3",
        size: "small",
        type: "title",
        className: " googlesitekit-subheading-1 googlesitekit-data-block__title ",
        children: [badge === true ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Badge__WEBPACK_IMPORTED_MODULE_0__["default"], {
          "aria-hidden": "true",
          className: "googlesitekit-badge--hidden",
          label: "X" // This is a minimal placeholder value to provide the correct height without too much width.
        }) : badge, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
          className: "googlesitekit-data-block__title-inner",
          children: title
        })]
      }), !gatheringData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "googlesitekit-data-block__datapoint",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("span", {
          className: "googlesitekit-data-block__datapoint--resize",
          children: datapointFormatted
        })
      })]
    }), !gatheringData && sparkline && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Sparkline__WEBPACK_IMPORTED_MODULE_5__["default"], {
      sparkline: sparkline,
      invertChangeColor: invertChangeColor
    }), !gatheringData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-data-block__change-source-wrapper",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_Change__WEBPACK_IMPORTED_MODULE_4__["default"], {
        change: change,
        changeDataUnit: changeDataUnit,
        period: period,
        invertChangeColor: invertChangeColor
      }), source && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_SourceLink__WEBPACK_IMPORTED_MODULE_1__["default"], {
        className: "googlesitekit-data-block__source",
        name: source.name,
        href: source.link,
        external: source?.external
      })]
    })]
  });
}
Content.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  datapoint: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number)]),
  datapointUnit: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  change: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number)]),
  changeDataUnit: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)]),
  period: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  source: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object),
  sparkline: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().element),
  invertChangeColor: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  gatheringData: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  badge: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node)])
};

/***/ }),

/***/ "./js/components/DataBlock/Sparkline.js":
/*!**********************************************!*\
  !*** ./js/components/DataBlock/Sparkline.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Sparkline component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


function Sparkline({
  sparkline,
  invertChangeColor
}) {
  // The `sparkline` prop is passed as a component, but if `invertChangeColor`
  // is set, we should pass that to `<Sparkline>`. In that case, we clone
  // the element and add the prop.
  let sparklineComponent = sparkline;
  if (sparklineComponent && invertChangeColor) {
    sparklineComponent = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.cloneElement)(sparkline, {
      invertChangeColor
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
    className: "googlesitekit-data-block__sparkline",
    children: sparklineComponent
  });
}
Sparkline.propTypes = {
  sparkline: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().element),
  invertChangeColor: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Sparkline);

/***/ }),

/***/ "./js/components/DataBlock/index.js":
/*!******************************************!*\
  !*** ./js/components/DataBlock/index.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/GatheringDataNotice */ "./js/components/GatheringDataNotice.js");
/* harmony import */ var _Content__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Content */ "./js/components/DataBlock/Content.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DataBlock component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function DataBlock({
  stat = null,
  className = '',
  title = '',
  datapoint = null,
  datapointUnit = '',
  change = null,
  changeDataUnit = '',
  context = 'default',
  period = '',
  selected = false,
  source,
  sparkline,
  handleStatSelection = null,
  invertChangeColor = false,
  gatheringData = false,
  gatheringDataNoticeStyle = _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_1__.NOTICE_STYLE.DEFAULT,
  badge
}) {
  const handleClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
    if (!gatheringData && handleStatSelection) {
      handleStatSelection(stat);
    }
  }, [gatheringData, handleStatSelection, stat]);
  const handleKeyDown = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(e => {
    if ('Enter' === e.key || ' ' === e.key) {
      e.preventDefault();
      handleClick();
    }
  }, [handleClick]);
  const isButtonContext = 'button' === context;
  const role = isButtonContext ? 'button' : '';
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-data-block', className, `googlesitekit-data-block--${context}`, {
      'googlesitekit-data-block--selected': selected,
      'googlesitekit-data-block--is-gathering-data': gatheringData
    }),
    tabIndex: isButtonContext && !gatheringData ? '0' : '-1',
    role: handleStatSelection && role,
    onClick: handleClick,
    onKeyDown: handleKeyDown,
    "aria-disabled": gatheringData || undefined,
    "aria-label": handleStatSelection && title,
    "aria-pressed": handleStatSelection && selected,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Content__WEBPACK_IMPORTED_MODULE_2__["default"], {
      title: title,
      datapoint: datapoint,
      datapointUnit: datapointUnit,
      change: change,
      changeDataUnit: changeDataUnit,
      period: period,
      source: source,
      sparkline: sparkline,
      invertChangeColor: invertChangeColor,
      gatheringData: gatheringData,
      badge: badge
    }), gatheringData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_1__["default"], {
      style: gatheringDataNoticeStyle
    })]
  });
}
DataBlock.propTypes = {
  stat: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  datapoint: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number)]),
  datapointUnit: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  change: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().number)]),
  changeDataUnit: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool)]),
  context: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  period: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  selected: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  source: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().object),
  sparkline: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().element),
  handleStatSelection: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  invertChangeColor: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  gatheringData: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  gatheringDataNoticeStyle: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_1__.NOTICE_STYLE)),
  badge: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)])
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DataBlock);

/***/ }),

/***/ "./js/components/DataBlockGroup.js":
/*!*****************************************!*\
  !*** ./js/components/DataBlockGroup.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DataBlockGroup)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEvent.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * DataBlockGroup component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function DataBlockGroup({
  className,
  children
}) {
  const ref = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useRef)();
  function adjustFontSize() {
    const blocks = ref?.current?.querySelectorAll('.googlesitekit-data-block');
    if (!blocks?.length) {
      return;
    }

    // Find the smallest font size needed across all blocks to fit without overflow.
    let smallestScaleFactor = 1;

    // Reset font sizes first to get accurate measurement, specifically on resize.
    setFontSizes(blocks, '');
    blocks.forEach(block => {
      const dataPoint = block.querySelector('.googlesitekit-data-block__datapoint');
      if (!dataPoint) {
        return;
      }
      const parentWidth = dataPoint?.parentElement?.offsetWidth;
      if (dataPoint.scrollWidth > parentWidth) {
        // Calculate the exact scale factor needed to resize the content to the parent.
        const scaleFactor = parentWidth / dataPoint.scrollWidth;

        // Round the scale factor down to one decimal place. This creates a
        // small visual buffer to prevent the text from appearing cramped.
        // It also improves stability by preventing minor pixel fluctuations
        // during resize from causing distracting font size changes.
        const roundedScaleFactor = Math.floor(scaleFactor * 10) / 10;
        if (roundedScaleFactor < smallestScaleFactor) {
          smallestScaleFactor = roundedScaleFactor;
        }
      }
    });

    // Apply the smallest font size to all blocks if adjustment is needed.
    if (smallestScaleFactor < 1 && smallestScaleFactor > 0) {
      const fontSize = parseInt(__webpack_require__.g?.getComputedStyle(blocks[0].querySelector('.googlesitekit-data-block__datapoint'))?.fontSize, 10);
      const newSize = Math.floor(fontSize * smallestScaleFactor);
      const clampedNewSize = Math.max(newSize, 14); // Don't allow the font size to go below 14px.
      setFontSizes(blocks, `${clampedNewSize}px`);
    }
  }
  function setFontSizes(blocks, adjustedSize) {
    blocks.forEach(block => {
      const dataPoint = block?.querySelector('.googlesitekit-data-block__datapoint');
      if (!dataPoint) {
        return;
      }
      dataPoint.style.fontSize = adjustedSize;
    });
  }

  // Debounce the adjustFontSize function to prevent excessive calls on resize.
  const debouncedAdjustFontSize = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_0__.useDebounce)(adjustFontSize, 50);
  (0,react_use__WEBPACK_IMPORTED_MODULE_3__["default"])('resize', debouncedAdjustFontSize);
  (0,react_use__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
    debouncedAdjustFontSize();
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ref: ref,
    className: className,
    children: children
  });
}

/***/ }),

/***/ "./js/components/DetailsPermaLinks.js":
/*!********************************************!*\
  !*** ./js/components/DetailsPermaLinks.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DetailsPermaLinks)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Details Permalink Links component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function DetailsPermaLinks({
  title,
  path,
  serviceURL
}) {
  const siteURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getReferenceSiteURL());
  const permaLink = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.getFullURL)(siteURL, path);
  const detailsURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getAdminURL('googlesitekit-dashboard', {
      permaLink
    });
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
      className: "googlesitekit-font-weight-medium",
      href: serviceURL || detailsURL,
      external: !!serviceURL,
      hideExternalIndicator: true,
      children: title
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_4__["default"], {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-display-block', 'googlesitekit-overflow-wrap-break-word'),
      href: permaLink,
      target: "_blank" // No external styling.
      ,
      small: true,
      children: path
    })]
  });
}
DetailsPermaLinks.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  path: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  serviceURL: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
};

/***/ }),

/***/ "./js/components/ErrorHandler/index.js":
/*!*********************************************!*\
  !*** ./js/components/ErrorHandler/index.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/GenericErrorHandlerActions */ "./js/components/GenericErrorHandlerActions.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/* harmony import */ var _js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/notifications/components/layout/BannerNotification */ "./js/googlesitekit/notifications/components/layout/BannerNotification.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorHandler component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





class ErrorHandler extends _wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      info: null,
      copied: false
    };
  }
  componentDidCatch(error, info) {
    __webpack_require__.g.console.error('Caught an error:', error, info);
    this.setState({
      error,
      info
    });
    (0,_js_util__WEBPACK_IMPORTED_MODULE_4__.trackEvent)('react_error', `handle_${this.context || 'unknown'}_error`,
    // label has a max-length of 500 bytes.
    `${error?.message}\n${info?.componentStack}`.slice(0, 500));
  }
  render() {
    const {
      children
    } = this.props;
    const {
      error,
      info
    } = this.state;

    // If there is no caught error, render the children components normally.
    if (!error) {
      return children;
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_googlesitekit_notifications_components_layout_BannerNotification__WEBPACK_IMPORTED_MODULE_3__["default"], {
      notificationID: "googlesitekit-error",
      className: "googlesitekit-error-handler",
      type: "error",
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Site Kit encountered an error', 'google-site-kit'),
      description: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_1__["default"], {
          message: error.message,
          componentStack: info.componentStack
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("pre", {
          className: "googlesitekit-overflow-auto",
          children: [error.message, info.componentStack]
        })]
      })
    });
  }
}
ErrorHandler.contextType = _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_2__["default"];
ErrorHandler.propTypes = {
  /** @ignore */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorHandler);

/***/ }),

/***/ "./js/components/ErrorNotice.js":
/*!**************************************!*\
  !*** ./js/components/ErrorNotice.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorNotice)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Notice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Notice */ "./js/components/Notice/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ErrorNotice component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function ErrorNotice({
  className,
  error,
  hasButton = false,
  storeName,
  message = error.message,
  noPrefix = false,
  skipRetryMessage,
  hideIcon = false
}) {
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)();
  const selectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    if (!storeName) {
      return null;
    }
    return select(storeName).getSelectorDataForError(error);
  });
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
  }, [dispatch, selectorData]);

  // Do not display if there is no error and no direct message text is passed as a direct prop.
  // Also do not display if the error is for missing scopes as these are handled by a popup modal.
  if (!message || (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_3__.isPermissionScopeError)(error)) {
    return null;
  }
  const shouldDisplayRetry = hasButton && (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_3__.isErrorRetryable)(error, selectorData);

  /**
   * Error message to display to the user. Sometimes we append a retry message
   * or a reconnect URL, so we create a new variable for the message to display.
   */
  let errorMessageWithModifications = message;

  // Append "Try again" messaging if no retry button is present.
  if (!hasButton && !skipRetryMessage) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Error message from Google API. */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s (Please try again.)', 'google-site-kit'), errorMessageWithModifications);
  }
  if (!noPrefix) {
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: $%s: Error message */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Error: %s', 'google-site-kit'), errorMessageWithModifications);
  }
  const reconnectURL = error?.data?.reconnectURL;
  if (reconnectURL && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_7__.isURL)(reconnectURL)) {
    /**
     * This error message uses HTML tags without using
     * `createInterpolateElement` because the error messages
     * that come from the server/API can also contain HTML (eg. links)
     * we want to render.
     *
     * Instead of creating a React node using `createInterpolateElement`,
     * we use `dangerouslySetInnerHTML` to allow the HTML we create and from
     * the server/API to be rendered as-intended.
     */
    errorMessageWithModifications = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: 1: Original error message 2: Reconnect URL */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%1$s To fix this, <a href="%2$s">redo the plugin setup</a>.', 'google-site-kit'), errorMessageWithModifications, reconnectURL);
  }
  const sanitizeArgs = {
    ALLOWED_TAGS: ['a'],
    ALLOWED_ATTR: ['href']
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_Notice__WEBPACK_IMPORTED_MODULE_4__["default"], {
    className: className,
    type: _Notice__WEBPACK_IMPORTED_MODULE_4__["default"].TYPES.ERROR,
    description:
    /*#__PURE__*/
    // The error messages that come from the server/API can contain
    // HTML (eg. links), so we use `dangerouslySetInnerHTML` and sanitize
    // the HTML to render these links.
    //
    // We tried to use `createInterpolateElement` but it does not work
    // with HTML tags that come from the server/API.
    (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("span", {
      dangerouslySetInnerHTML: (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML)(errorMessageWithModifications, sanitizeArgs)
    }),
    ctaButton: shouldDisplayRetry ? {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit'),
      onClick: handleRetry
    } : undefined,
    hideIcon: hideIcon
  });
}
ErrorNotice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  error: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }),
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  noPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  skipRetryMessage: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/components/FeatureTours.js":
/*!***************************************!*\
  !*** ./js/components/FeatureTours.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FeatureTours)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _TourTooltips__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TourTooltips */ "./js/components/TourTooltips.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Feature Tours component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function FeatureTours() {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const {
    triggerTourForView
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER);
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(() => {
    triggerTourForView(viewContext);
  });
  const tour = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).getCurrentTour());
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    if (!tour) {
      // Return noop cleanup function to satisfy consistent-return rule.
      return () => {};
    }
    const dashboardElement = document.getElementById('js-googlesitekit-main-dashboard');
    if (!dashboardElement) {
      // Return noop cleanup function to satisfy consistent-return rule.
      return () => {};
    }
    const observer = new ResizeObserver(() => {
      __webpack_require__.g.dispatchEvent(new Event('resize'));
    });
    observer.observe(dashboardElement);
    return () => {
      observer.disconnect();
    };
  }, [tour]);
  if (!tour) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_TourTooltips__WEBPACK_IMPORTED_MODULE_3__["default"], {
    tourID: tour.slug,
    steps: tour.steps,
    gaEventCategory: tour.gaEventCategory,
    isRepeatable: tour.isRepeatable,
    callback: tour.callback
  });
}

/***/ }),

/***/ "./js/components/FeaturesProvider/FeaturesContext.js":
/*!***********************************************************!*\
  !*** ./js/components/FeaturesProvider/FeaturesContext.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Feature Flags context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const FeaturesContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.createContext)(_js_features__WEBPACK_IMPORTED_MODULE_0__.enabledFeatures);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturesContext);

/***/ }),

/***/ "./js/components/FeaturesProvider/index.js":
/*!*************************************************!*\
  !*** ./js/components/FeaturesProvider/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FeaturesContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FeaturesContext */ "./js/components/FeaturesProvider/FeaturesContext.js");
/**
 * Feature Flags Provider component.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const {
  Consumer,
  Provider
} = _FeaturesContext__WEBPACK_IMPORTED_MODULE_0__["default"];
const FeaturesProvider = Provider;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturesProvider);

/***/ }),

/***/ "./js/components/GatheringDataNotice.js":
/*!**********************************************!*\
  !*** ./js/components/GatheringDataNotice.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NOTICE_STYLE: () => (/* binding */ NOTICE_STYLE),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GatheringDataNotice component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const NOTICE_STYLE = {
  DEFAULT: 'default',
  OVERLAY: 'overlay',
  SMALL: 'small',
  SMALL_OVERLAY: 'small-overlay',
  LARGE: 'large'
};
function GatheringDataNotice({
  style
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-gathering-data-notice', {
      [`googlesitekit-gathering-data-notice--has-style-${style}`]: !!style
    }),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Gathering data…', 'google-site-kit')
    })
  });
}
GatheringDataNotice.propTypes = {
  style: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(Object.values(NOTICE_STYLE))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GatheringDataNotice);

/***/ }),

/***/ "./js/components/GenericErrorHandlerActions.js":
/*!*****************************************************!*\
  !*** ./js/components/GenericErrorHandlerActions.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GenericErrorHandlerActions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var _ReportErrorButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ReportErrorButton */ "./js/components/ReportErrorButton/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GenericErrorHandlerActions component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function GenericErrorHandlerActions({
  message,
  componentStack
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: "googlesitekit-generic-error-handler-actions",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_ReportErrorButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
      message: message,
      componentStack: componentStack
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_1__["default"], {
      href: "https://wordpress.org/support/plugin/google-site-kit/",
      external: true,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Report this problem', 'google-site-kit')
    })]
  });
}
GenericErrorHandlerActions.propTypes = {
  message: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  componentStack: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/GoogleChart/DateMarker.js":
/*!*************************************************!*\
  !*** ./js/components/GoogleChart/DateMarker.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DateMarker)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/info.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useDebounce */ "./js/hooks/useDebounce.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GoogleChart DateMarker component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function DateMarker({
  id,
  text
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const eventCategory = `${viewContext}_ga4-data-collection-line`;
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(eventCategory, 'chart_line_view');
  }, [eventCategory]);
  const trackTooltipOpen = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useCallback)(() => {
    (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.trackEvent)(eventCategory, 'chart_tooltip_view');
  }, [eventCategory]);
  const handleTooltipOpen = (0,_js_hooks_useDebounce__WEBPACK_IMPORTED_MODULE_1__.useDebounce)(trackTooltipOpen, 5000, {
    leading: true,
    trailing: false
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      id: `googlesitekit-chart__date-marker-line--${id}`,
      className: "googlesitekit-chart__date-marker-line"
    }), text && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
      id: `googlesitekit-chart__date-marker-tooltip--${id}`,
      className: "googlesitekit-chart__date-marker-tooltip",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Tooltip, {
        title: text,
        onOpen: handleTooltipOpen,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"], {
            fill: "currentColor",
            icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"],
            size: 18
          })
        })
      })
    })]
  });
}

/***/ }),

/***/ "./js/components/GoogleChart/index.js":
/*!********************************************!*\
  !*** ./js/components/GoogleChart/index.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GoogleChart)
/* harmony export */ });
/* harmony import */ var _js_util_initialize_google_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util/initialize-google-global */ "./js/util/initialize-google-global.js");
/* harmony import */ var _js_util_initialize_google_global__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_js_util_initialize_google_global__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var react_google_charts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-google-charts */ "../node_modules/react-google-charts/dist/index.esm.js");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/GatheringDataNotice */ "./js/components/GatheringDataNotice.js");
/* harmony import */ var _js_components_GoogleChartErrorHandler__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/GoogleChartErrorHandler */ "./js/components/GoogleChartErrorHandler/index.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/util/is-site-kit-screen */ "./js/util/is-site-kit-screen.js");
/* harmony import */ var _DateMarker__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./DateMarker */ "./js/components/GoogleChart/DateMarker.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./utils */ "./js/components/GoogleChart/utils.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GoogleChart component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* eslint-disable react-hooks/exhaustive-deps */

/* Ensures `google` global is undefined before loading `react-google-charts` library */


/**
 * External dependencies
 */
// eslint-disable-next-line sitekit/sort-import-groups -- prevent the `initialize-google-global` import from being moved to the "Internal dependencies" group.






/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */













function GoogleChart(props) {
  const {
    chartEvents,
    chartType,
    children,
    className,
    data,
    dateMarkers,
    getChartWrapper,
    height,
    loaded,
    loadingHeight,
    loadingWidth,
    onMouseOver,
    onMouseOut,
    onReady,
    onSelect,
    selectedStats,
    width,
    options,
    gatheringData,
    ...otherProps
  } = props;

  /**
   * Size of the icons (in pixels) used in the tooltip.
   */
  const iconSize = 18;
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_17__["default"])(GoogleChart);
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_10__.useBreakpoint)();
  const {
    startDate,
    endDate
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_USER).getDateRangeDates({
    offsetDays: 0
  }));
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const googleChartsCollisionError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_UI).getValue('googleChartsCollisionError'));
  const [isChartLoaded, setIsChartLoaded] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useState)(false);
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_8__.CORE_UI);
  const filteredData = (0,_utils__WEBPACK_IMPORTED_MODULE_15__.getFilteredChartData)(data, selectedStats);
  const loadingShape = chartType === 'PieChart' ? 'circular' : 'square';
  const loadingDimensions = (0,_utils__WEBPACK_IMPORTED_MODULE_15__.getLoadingDimensions)(loadingHeight, height, loadingWidth, width);
  const loader = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("div", {
    className: "googlesitekit-chart-loading",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_7__["default"], {
      className: "googlesitekit-chart-loading__wrapper",
      shape: loadingShape,
      ...loadingDimensions
    })
  });
  const chartWrapperRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useRef)();
  const googleRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useRef)();

  // Don't load Google Charts if another script on the page has already loaded
  // Google Charts.
  //
  // If another plugin loads Google Charts somewhere on the page, our charts
  // will likely encounter an error due to a version mismatch.
  //
  // This is because Google Charts is a singleton, and if another plugin loads
  // it first, our charts will use the same instance of Google Charts.
  //
  // See:
  // * https://github.com/google/site-kit-wp/issues/6350
  // * https://github.com/google/site-kit-wp/issues/6355
  (0,react_use__WEBPACK_IMPORTED_MODULE_19__["default"])(() => {
    if (googleChartsCollisionError !== undefined) {
      return;
    }

    // If we're on a Site Kit screen, we want "priority" over the
    // `google.charts` global so we don't render a bunch of charts errors,
    // see: https://github.com/google/site-kit-wp/issues/6439#issuecomment-1404491940
    //
    // The only way to do this is to remove the `google.charts` global
    // and allow the `react-google-charts` library to re-initialize it.
    if ((0,_js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_13__.isSiteKitScreen)(viewContext) && __webpack_require__.g?.google?.charts) {
      __webpack_require__.g.google.charts = undefined;
    }
    if (!(0,_js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_13__.isSiteKitScreen)(viewContext) && __webpack_require__.g?.google?.charts) {
      setValue('googleChartsCollisionError', true);
    } else {
      setValue('googleChartsCollisionError', false);
    }
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useEffect)(() => {
    // Remove all event listeners after the component has unmounted.
    return () => {
      // eslint-disable-next-line no-unused-expressions
      if (googleRef.current && chartWrapperRef.current) {
        const {
          events
        } = googleRef.current.visualization;
        events.removeAllListeners(chartWrapperRef.current.getChart());
        events.removeAllListeners(chartWrapperRef.current);
      }
    };
  }, []);

  // These event listeners are added manually to the current chart because
  // `react-google-charts` doesn't support `mouseOver` or `mouseOut` events
  // in its `chartEvents` prop.
  // See: https://github.com/google/site-kit-wp/pull/2805#discussion_r579172660
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_18__.useLayoutEffect)(() => {
    if (onMouseOver) {
      // eslint-disable-next-line no-unused-expressions
      googleRef.current?.visualization.events.addListener(chartWrapperRef.current.getChart(), 'onmouseover', event => {
        onMouseOver(event, {
          chartWrapper: chartWrapperRef.current,
          google: googleRef.current
        });
      });
    }
    if (onMouseOut) {
      // eslint-disable-next-line no-unused-expressions
      googleRef.current?.visualization.events.addListener(chartWrapperRef.current.getChart(), 'onmouseout', event => {
        onMouseOut(event, {
          chartWrapper: chartWrapperRef.current,
          google: googleRef.current
        });
      });
    }
  }, [onMouseOver, onMouseOut]);

  // Checks to see if the date is within the date range.
  function isDateWithinRange(date) {
    // If any of the dates are not set, return false.
    if (!date || !startDate || !endDate) {
      return false;
    }
    if (
    // Don't render this marker if the date is before the first date
    // in the current date range.
    date.getTime() < (0,_js_util__WEBPACK_IMPORTED_MODULE_12__.stringToDate)(startDate).getTime() ||
    // Don't render this marker if the date is after the last date
    // in the current date range.
    date.getTime() > (0,_js_util__WEBPACK_IMPORTED_MODULE_12__.stringToDate)(endDate).getTime()) {
      return false;
    }
    return true;
  }

  // Only use markers if the date is within the current date range.
  const dateMarkersInRange = dateMarkers.filter(dateMarker => {
    // Valid use of `new Date()` with an argument.
    // eslint-disable-next-line sitekit/no-direct-date
    return isDateWithinRange(new Date(dateMarker.date));
  });

  /**
   * Adds any "key date" vertical lines/tooltips to the charts.
   */
  function addKeyDateLinesToChart() {
    if (!chartWrapperRef.current) {
      return;
    }
    if (!dateMarkersInRange.length) {
      return;
    }
    const chart = chartWrapperRef.current.getChart();
    const chartLayoutInterface = chart?.getChartLayoutInterface();
    const chartArea = chartLayoutInterface?.getChartAreaBoundingBox();
    const dataTable = chartWrapperRef.current.getDataTable();
    if (!chartLayoutInterface || !chartArea || !dataTable) {
      return;
    }

    // Add the dotted line and tooltip for each date marker.
    dateMarkersInRange.forEach((dateMarker, index) => {
      // Valid use of `new Date()` with an argument.
      // eslint-disable-next-line sitekit/no-direct-date
      const dateFromMarker = new Date(dateMarker.date);
      const chartLine = document.getElementById(`googlesitekit-chart__date-marker-line--${instanceID}-${index}`);
      invariant__WEBPACK_IMPORTED_MODULE_2___default()(chartLine, `#googlesitekit-chart__date-marker-line--${instanceID}-${index} is missing from the DOM, but required to render date markers.`);

      // We need to make sure the dates we use on the chart and on
      // this line are exactly the same, so we get the position on the
      // chart that matches the date we create from the date string.
      //
      // This prevents the line and the chart data from being
      // slightly out-of-alignment, see:
      // https://github.com/google/site-kit-wp/pull/6822#pullrequestreview-1376066844.
      const dateCoordinateX = Math.floor(chartLayoutInterface.getXLocation((0,_js_util__WEBPACK_IMPORTED_MODULE_12__.stringToDate)((0,_js_util__WEBPACK_IMPORTED_MODULE_12__.getDateString)(dateFromMarker))));

      // Align the dotted line with the date for this marker.
      Object.assign(chartLine.style, {
        left: `${dateCoordinateX - 1}px`,
        top: `${Math.floor(chartArea.top)}px`,
        height: `${Math.floor(chartArea.height)}px`,
        opacity: 1
      });

      // Text is optional, so only modify the DOM elements for the tooltip
      // text if the property was provided.
      if (dateMarker.text) {
        const tooltip = document.getElementById(`googlesitekit-chart__date-marker-tooltip--${instanceID}-${index}`);
        invariant__WEBPACK_IMPORTED_MODULE_2___default()(tooltip, `#googlesitekit-chart__date-marker-tooltip--${instanceID}-${index} is missing from the DOM, but required to render date marker tooltips.`);

        // Align the tooltip component with the date line.
        Object.assign(tooltip.style, {
          left: `${dateCoordinateX - iconSize / 2}px`,
          top: `${Math.floor(chartArea.top) - iconSize}px`,
          opacity: 1
        });
      }
    });
    const legendElement = document.querySelector(`#googlesitekit-chart-${instanceID} svg:first-of-type > g:first-of-type > g > g > text`)?.parentElement.parentElement.parentElement;

    // A legend is present if there are more than three `g` elements; charts
    // without legends won't have that many `g` elements so we don't need to
    // modify anything.
    const hasLegend = !!legendElement && document.querySelectorAll(`#googlesitekit-chart-${instanceID} svg:first-of-type > g`).length >= 3;

    // If there is a legend, move it up to make room for the date marker icon.
    if (hasLegend) {
      // `10px` is the best size to use to accommodate the bounding box of the
      // chart without needing to modify the chart's height.
      //
      // It allows the legend and the icon to fit without moving anything else
      // and without things feeling cramped or being cut off.
      legendElement.style.transform = 'translateY(-10px)';
    }
  }
  if (googleChartsCollisionError) {
    return null;
  }
  if (!loaded) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-chart', 'googlesitekit-chart-loading__forced', className),
      children: loader
    });
  }
  const combinedChartEvents = (0,_utils__WEBPACK_IMPORTED_MODULE_15__.getCombinedChartEvents)([...(chartEvents || []),
  // Call the `addKeyDateLinesToChart` function after the chart
  // has been rendered.
  //
  // This is to ensure that the chart has finished rendering before
  // we try to add the lines. If we don't do this, the `chart`
  // variable (from `chartWrapper.getChart()`) will be `null`.
  {
    eventName: 'ready',
    callback: addKeyDateLinesToChart
  }], onReady, onSelect);
  const chartOptions = (0,_utils__WEBPACK_IMPORTED_MODULE_15__.getChartOptions)(options, {
    gatheringData,
    chartType,
    startDate,
    endDate,
    breakpoint
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_GoogleChartErrorHandler__WEBPACK_IMPORTED_MODULE_6__["default"], {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-chart', `googlesitekit-chart--${chartType}`, className),
      id: `googlesitekit-chart-${instanceID}`,
      tabIndex: -1,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(react_google_charts__WEBPACK_IMPORTED_MODULE_3__.Chart, {
        className: "googlesitekit-chart__inner",
        chartEvents: combinedChartEvents,
        chartLanguage: (0,_js_util__WEBPACK_IMPORTED_MODULE_12__.getLocale)(),
        chartType: chartType,
        chartVersion: "49",
        data: filteredData,
        loader: loader,
        height: height,
        getChartWrapper: (chartWrapper, google) => {
          // An issue with `react-google-charts` v4 causes the chart to
          // render the overlay before the chart in some cases when using
          // their own `onLoad` callback. This is a workaround to prevent
          // that issue but still provide notice that the chart is loaded.
          // See: https://github.com/google/site-kit-wp/issues/4945
          if (!isChartLoaded) {
            setIsChartLoaded(true);
          }

          // Remove all the event listeners on the old chart before we draw
          // a new one. Only run this if the old chart and the new chart
          // aren't the same reference though, otherwise we'll remove
          // existing `onReady` events and other event listeners, which will
          // cause bugs.
          if (chartWrapper !== chartWrapperRef.current) {
            // eslint-disable-next-line no-unused-expressions
            googleRef.current?.visualization.events.removeAllListeners(chartWrapperRef.current?.getChart());
            // eslint-disable-next-line no-unused-expressions
            googleRef.current?.visualization.events.removeAllListeners(chartWrapperRef.current);
          }
          chartWrapperRef.current = chartWrapper;
          googleRef.current = google;
          if (getChartWrapper) {
            getChartWrapper(chartWrapper, google);
          }
        },
        width: width,
        options: chartOptions,
        ...otherProps
      }), gatheringData && isChartLoaded && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_5__["default"], {
        style: _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_5__.NOTICE_STYLE.OVERLAY
      }), !!dateMarkersInRange.length && dateMarkersInRange.map((dateMarker, index) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx)(_DateMarker__WEBPACK_IMPORTED_MODULE_14__["default"], {
          id: `${instanceID}-${index}`,
          text: dateMarker.text
        }, `googlesitekit-chart__date-marker--${instanceID}-${index}`);
      }), children]
    })
  });
}
GoogleChart.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().node),
  chartEvents: prop_types__WEBPACK_IMPORTED_MODULE_20___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_20___default().shape({
    eventName: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string),
    callback: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func)
  })),
  // Note: technically we support all types of charts that `react-google-charts`
  // supports, which is _all_ chart types from Google Charts. But we only list
  // the charts currently used in our codebase here, and only ones that we have
  // explicit support/styles/handling for.
  // See: https://github.com/google/site-kit-wp/pull/2916#discussion_r626620601
  chartType: prop_types__WEBPACK_IMPORTED_MODULE_20___default().oneOf(['LineChart', 'PieChart']).isRequired,
  data: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().array),
  dateMarkers: prop_types__WEBPACK_IMPORTED_MODULE_20___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_20___default().shape({
    /**
     * The date to mark on the chart, in the format `'YYYY-MM-DD'`.
     */
    date: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string).isRequired,
    /**
     * Text to display in a tooltip when the date marker is hovered.
     */
    text: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string)
  })),
  getChartWrapper: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string),
  loaded: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().bool),
  loadingHeight: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string),
  loadingWidth: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string),
  onMouseOut: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func),
  onMouseOver: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func),
  onReady: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func),
  onSelect: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().func),
  selectedStats: prop_types__WEBPACK_IMPORTED_MODULE_20___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_20___default().number)),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().string),
  options: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().object),
  gatheringData: (prop_types__WEBPACK_IMPORTED_MODULE_20___default().bool)
};
GoogleChart.defaultProps = {
  ...react_google_charts__WEBPACK_IMPORTED_MODULE_3__.Chart.defaultProps,
  dateMarkers: [],
  gatheringData: false,
  loaded: true
};

/***/ }),

/***/ "./js/components/GoogleChart/utils.js":
/*!********************************************!*\
  !*** ./js/components/GoogleChart/utils.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getChartOptions: () => (/* binding */ getChartOptions),
/* harmony export */   getCombinedChartEvents: () => (/* binding */ getCombinedChartEvents),
/* harmony export */   getCurrencyPattern: () => (/* binding */ getCurrencyPattern),
/* harmony export */   getFilteredChartData: () => (/* binding */ getFilteredChartData),
/* harmony export */   getLoadingDimensions: () => (/* binding */ getLoadingDimensions)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Google Chart utilities.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Returns the Google chart data, filtered by selected stats if present.
 *
 * @since 1.93.0
 *
 * @param {Array|undefined} data          Chart data.
 * @param {Array|undefined} selectedStats The columns that should be displayed for the data set.
 * @return {Object} The chart data, filtered by selected stats if present.
 */
function getFilteredChartData(data, selectedStats) {
  if (!selectedStats?.length) {
    return data;
  }

  // Ensure we don't filter out columns that aren't data, but are things like
  // tooltips or other content.
  let nonDataColumns = [];
  if (data?.length) {
    nonDataColumns = data[0].reduce((acc, row, rowIndex) => {
      return row?.role ? [...acc, rowIndex] : acc;
    }, []);
  }
  return data.map(row => {
    return row.filter((_columnValue, columnIndex) => {
      return columnIndex === 0 || selectedStats.includes(columnIndex - 1) || nonDataColumns.includes(columnIndex - 1);
    });
  });
}

/**
 * Returns the optimal height and width for a preview element.
 *
 * @since 1.93.0
 *
 * @param {string|undefined} loadingHeight Preview height.
 * @param {string|undefined} height        Chart height.
 * @param {string|undefined} loadingWidth  Preview width.
 * @param {string|undefined} width         Chart width.
 * @return {Object} The optimal height and width to use in a preview element.
 */
function getLoadingDimensions(loadingHeight, height, loadingWidth, width) {
  const dimensions = {
    height: loadingHeight || height,
    width: loadingWidth || width
  };
  // If a loading height is set but a width is not (or a loading width is set
  // but not a height), change the "unset" value to 100% to avoid visual bugs.
  // See: https://github.com/google/site-kit-wp/pull/2916#discussion_r623866269
  if (dimensions.width && !dimensions.height) {
    dimensions.height = '100%';
  }
  if (dimensions.height && !dimensions.width) {
    dimensions.width = '100%';
  }
  return dimensions;
}

/**
 * Returns a combined chart events object.
 *
 * @since 1.93.0
 *
 * @param {Array.<Object>|undefined} chartEvents Event names and its callbacks.
 * @param {Function|undefined}       onReady     Chart event.
 * @param {Function|undefined}       onSelect    Chart event.
 * @return {Object} The object containig all events.
 */
function getCombinedChartEvents(chartEvents, onReady, onSelect) {
  const combinedChartEvents = [...(chartEvents || [])];
  if (onReady) {
    combinedChartEvents.push({
      eventName: 'ready',
      callback: onReady
    });
  }
  if (onSelect) {
    combinedChartEvents.push({
      eventName: 'select',
      callback: onSelect
    });
  }
  return combinedChartEvents;
}

/**
 * Returns a chart configuration object.
 *
 * @since 1.93.0
 * @since 1.119.0 Added `breakpoint` parameter.
 * @since 1.160.0 Refactored `gatheringData`, `chartType`, `startDate`, `endDate`, and `breakpoint` to be named parameters.
 *
 * @param {Object}  options                     Chart options to extend.
 * @param {Object}  configuration               Configuration for the extended chart options.
 * @param {boolean} configuration.gatheringData If chart is in gathering info state.
 * @param {string}  configuration.chartType     Chart types: PieChart, LineChart.
 * @param {string}  configuration.startDate     Start date for a user data range.
 * @param {string}  configuration.endDate       End date for a user data range.
 * @param {string}  configuration.breakpoint    Current breakpoint.
 * @return {Object} Chart options object.
 */
function getChartOptions(options, {
  gatheringData,
  chartType,
  startDate,
  endDate,
  breakpoint
}) {
  const chartOptions = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.cloneDeep)(options);
  if (gatheringData && chartType === 'LineChart') {
    if (!options?.vAxis?.viewWindow?.min) {
      (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(chartOptions, 'vAxis.viewWindow.min', 0);
    }
    if (!options?.vAxis?.viewWindow?.max) {
      (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(chartOptions, 'vAxis.viewWindow.max', 100);
    }
    if (!options?.hAxis?.viewWindow?.min) {
      (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(chartOptions, 'hAxis.viewWindow.min', (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringToDate)(startDate));
      delete chartOptions.hAxis.ticks;
    }
    if (!options?.hAxis?.viewWindow?.max) {
      (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(chartOptions, 'hAxis.viewWindow.max', (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.stringToDate)(endDate));
      delete chartOptions.hAxis.ticks;
    }
  }
  if (chartType === 'LineChart') {
    if (!options?.hAxis?.maxTextLines) {
      (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(chartOptions, 'hAxis.maxTextLines', 1);
    }
    if (!options?.hAxis?.minTextSpacing) {
      const minTextSpacing = breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL ? 50 : 100;
      (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(chartOptions, 'hAxis.minTextSpacing', minTextSpacing);
    }
    // eslint-disable-next-line sitekit/acronym-case
    if (options?.tooltip?.isHtml === undefined) {
      (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(chartOptions, 'tooltip.isHtml', true);
      (0,lodash__WEBPACK_IMPORTED_MODULE_0__.set)(chartOptions, 'tooltip.trigger', 'both');
    }
  }
  (0,lodash__WEBPACK_IMPORTED_MODULE_0__.merge)(chartOptions, {
    hAxis: {
      textStyle: {
        fontSize: 10,
        color: '#5f6561'
      }
    },
    vAxis: {
      textStyle: {
        color: '#5f6561',
        fontSize: 10
      }
    },
    legend: {
      textStyle: {
        color: '#131418',
        fontSize: 12
      }
    }
  });
  return chartOptions;
}

/**
 * Returns the Google Charts currency pattern for a given currency code and locale.
 *
 * @since 1.118.0
 *
 * @param {string} currencyCode ISO 4217 currency code.
 * @param {string} locale       Locale to use for formatting.
 * @return {string} The currency pattern.
 */
function getCurrencyPattern(currencyCode, locale = (0,_js_util__WEBPACK_IMPORTED_MODULE_2__.getLocale)()) {
  const formatter = Intl.NumberFormat(locale, {
    style: 'currency',
    currency: currencyCode
  });
  const parts = formatter.formatToParts(1000000);
  return parts.reduce((pattern, part) => {
    const {
      value
    } = part;
    switch (part.type) {
      case 'group':
        // The group and decimal separators will be replaced with the
        // locale-specific versions by the chart.
        // See: https://groups.google.com/g/google-visualization-api/c/hBF9daxe8qY/m/_aPk3EfQLgAJ
        return pattern + ',';
      case 'decimal':
        return pattern + '.';
      case 'currency':
        return pattern + value;
      case 'literal':
        const sanitizedValue = /^\s*$/.test(value) ? value : '';
        return pattern + sanitizedValue;
      case 'integer':
        const integerPattern = value.replace(/\d/g, '#');
        const isLastIntegerGroup = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.findLast)(parts, ({
          type
        }) => 'integer' === type) === part;
        return pattern + (isLastIntegerGroup ? integerPattern.replace(/#$/, '0') : integerPattern);
      case 'fraction':
        return pattern + value.replace(/\d/g, '0');
      default:
        return pattern;
    }
  }, '');
}

/***/ }),

/***/ "./js/components/GoogleChartErrorHandler/index.js":
/*!********************************************************!*\
  !*** ./js/components/GoogleChartErrorHandler/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clipboard-copy */ "../node_modules/clipboard-copy/index.js");
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(clipboard_copy__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/GenericErrorHandlerActions */ "./js/components/GenericErrorHandlerActions.js");
/* harmony import */ var _js_components_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GoogleChartErrorHandler component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






class GoogleChartErrorHandler extends _wordpress_element__WEBPACK_IMPORTED_MODULE_8__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      info: null
    };
    this.onErrorClick = this.onErrorClick.bind(this);
  }
  componentDidCatch(error, info) {
    __webpack_require__.g.console.error('Google Charts error:', error, info);
    this.setState({
      error,
      info
    });
    (0,_js_util__WEBPACK_IMPORTED_MODULE_6__.trackEvent)('google_chart_error', `handle_${this.context || 'unknown'}_error`,
    // label has a max-length of 500 bytes.
    `${error?.message}\n${info?.componentStack}`.slice(0, 500));
  }
  onErrorClick() {
    const {
      error,
      info
    } = this.state;

    // Copy message with wrapping backticks for code block formatting on wp.org.
    clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default()(`\`${error?.message}\n${info?.componentStack}\``);
  }
  render() {
    const {
      children
    } = this.props;
    const {
      error,
      info
    } = this.state;

    // If there is no caught error, render the children components normally.
    if (!error) {
      return children;
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-googlechart-error-handler",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
        description: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.Fragment, {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_5__["default"], {
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('An error prevented this Google chart from being displayed properly. Report the exact contents of the error on the support forum to find out what caused it.', 'google-site-kit')
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_js_components_GenericErrorHandlerActions__WEBPACK_IMPORTED_MODULE_2__["default"], {
            message: error.message,
            componentStack: info.componentStack
          })]
        }),
        onErrorClick: this.onErrorClick,
        onClick: this.onErrorClick,
        title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Error in Google Chart', 'google-site-kit'),
        error: true
      })
    });
  }
}
GoogleChartErrorHandler.contextType = _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_4__["default"];
GoogleChartErrorHandler.propTypes = {
  /** @ignore */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GoogleChartErrorHandler);

/***/ }),

/***/ "./js/components/IconWrapper.js":
/*!**************************************!*\
  !*** ./js/components/IconWrapper.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ IconWrapper)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * IconWrapper component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


function IconWrapper({
  children,
  marginLeft,
  marginRight
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: "googlesitekit-icon-wrapper",
    style: {
      marginLeft,
      marginRight
    },
    children: children
  });
}
IconWrapper.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node).isRequired,
  marginLeft: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  marginRight: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
};

/***/ }),

/***/ "./js/components/InViewProvider/InViewContext.js":
/*!*******************************************************!*\
  !*** ./js/components/InViewProvider/InViewContext.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * InView context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const InViewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)(false);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewContext);

/***/ }),

/***/ "./js/components/InViewProvider/index.js":
/*!***********************************************!*\
  !*** ./js/components/InViewProvider/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _InViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./InViewContext */ "./js/components/InViewProvider/InViewContext.js");
/**
 * In-view Provider component.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const {
  Consumer,
  Provider
} = _InViewContext__WEBPACK_IMPORTED_MODULE_0__["default"];
const InViewProvider = Provider;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InViewProvider);

/***/ }),

/***/ "./js/components/InfoTooltip.js":
/*!**************************************!*\
  !*** ./js/components/InfoTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InfoTooltip)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/info-green.svg */ "./svg/icons/info-green.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * InfoTooltip component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function InfoTooltip({
  onOpen,
  title,
  tooltipClassName
}) {
  if (!title) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Tooltip, {
    className: "googlesitekit-info-tooltip",
    tooltipClassName: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-info-tooltip__content', tooltipClassName),
    title: title,
    placement: "top",
    enterTouchDelay: 0,
    leaveTouchDelay: 5000,
    onOpen: onOpen,
    interactive: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_info_green_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
        width: "16",
        height: "16"
      })
    })
  });
}
InfoTooltip.propTypes = {
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  title: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_4___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_4___default().element)]),
  tooltipClassName: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/Link.js":
/*!*******************************!*\
  !*** ./js/components/Link.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-router-dom */ "../node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/arrow-inverse.svg */ "./svg/icons/arrow-inverse.svg");
/* harmony import */ var _svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/arrow.svg */ "./svg/icons/arrow.svg");
/* harmony import */ var _svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/icons/back.svg */ "./svg/icons/back.svg");
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var _IconWrapper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./IconWrapper */ "./js/components/IconWrapper.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Link component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const BUTTON = 'BUTTON';
const BUTTON_DISABLED = 'BUTTON_DISABLED';
const EXTERNAL_LINK = 'EXTERNAL_LINK';
const LINK = 'LINK';
const ROUTER_LINK = 'ROUTER_LINK';
const Link = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
  const {
    'aria-label': ariaLabelProp,
    secondary = false,
    arrow = false,
    back = false,
    caps = false,
    children,
    className = '',
    danger = false,
    disabled = false,
    external = false,
    hideExternalIndicator = false,
    href = '',
    inverse = false,
    noFlex = false,
    onClick,
    small = false,
    standalone = false,
    linkButton = false,
    to,
    leadingIcon,
    trailingIcon,
    ...otherProps
  } = props;
  function getType() {
    // Force button element if `onClick` prop is passed and there's no `href`
    // or `to` prop.
    if (!href && !to && onClick) {
      if (disabled) {
        return BUTTON_DISABLED;
      }
      return BUTTON;
    }

    // Only `RouterLink` uses the `to` prop.
    if (to) {
      return ROUTER_LINK;
    }

    // The external prop means this is an external link, which will also output
    // an `<a>` tag.
    if (external) {
      return EXTERNAL_LINK;
    }

    // A regular `<a>` tag without external indicators.
    return LINK;
  }
  const type = getType();
  function getLinkComponent() {
    if (type === BUTTON || type === BUTTON_DISABLED) {
      return 'button';
    }
    if (type === ROUTER_LINK) {
      return react_router_dom__WEBPACK_IMPORTED_MODULE_9__.Link;
    }
    return 'a';
  }
  function getAriaLabel() {
    // Otherwise, create an ARIA label if the link opens in a new window
    // or is disabled, to add extra context to the link.
    let labelSuffix;
    if (type === EXTERNAL_LINK) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(opens in a new tab)', 'screen reader text', 'google-site-kit');
    }
    if (type === BUTTON_DISABLED) {
      labelSuffix = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('(disabled)', 'screen reader text', 'google-site-kit');
    }
    if (!labelSuffix) {
      return ariaLabelProp;
    }

    // If an ARIA label was supplied, use that.
    if (ariaLabelProp) {
      return `${ariaLabelProp} ${labelSuffix}`;
    }

    // Otherwise, use the children prop if it's a string.
    if (typeof children === 'string') {
      return `${children} ${labelSuffix}`;
    }

    // If there isn't a string we can use to create the label, we shouldn't
    // make one; otherwise we'll only create an ARIA label that says
    // "(opens in a new tab)", which is not good.
    return undefined;
  }
  const LinkComponent = getLinkComponent();
  const ariaLabel = getAriaLabel();

  // Set the prefix/suffix icons, based on the type of link this is and
  // the props supplied.
  let leadingIconToUse = leadingIcon;
  let trailingIconToUse = trailingIcon;
  if (back) {
    leadingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_back_svg__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: 14,
      height: 14
    });
  }
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && !inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
      width: 14,
      height: 14
    });
  }
  if (arrow && inverse) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_arrow_inverse_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(LinkComponent, {
    "aria-label": ariaLabel,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta-link', className, {
      'googlesitekit-cta-link--secondary': secondary,
      'googlesitekit-cta-link--inverse': inverse,
      'googlesitekit-cta-link--small': small,
      'googlesitekit-cta-link--caps': caps,
      'googlesitekit-cta-link--danger': danger,
      'googlesitekit-cta-link--disabled': disabled,
      'googlesitekit-cta-link--standalone': standalone,
      'googlesitekit-cta-link--link-button': linkButton,
      'googlesitekit-cta-link--no-flex': !!noFlex
    }),
    disabled: disabled,
    href: (type === LINK || type === EXTERNAL_LINK) && !disabled ? href : undefined,
    onClick: onClick,
    rel: type === EXTERNAL_LINK ? 'noopener noreferrer' : undefined,
    ref: ref,
    target: type === EXTERNAL_LINK ? '_blank' : undefined,
    to: to,
    ...otherProps,
    children: [!!leadingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginRight: 5,
      children: leadingIconToUse
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("span", {
      className: "googlesitekit-cta-link__contents",
      children: children
    }), !!trailingIconToUse && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_IconWrapper__WEBPACK_IMPORTED_MODULE_6__["default"], {
      marginLeft: 5,
      children: trailingIconToUse
    })]
  });
});
Link.propTypes = {
  arrow: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  back: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  caps: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  leadingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node),
  linkButton: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  noFlex: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  standalone: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  to: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  trailingIcon: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ "./js/components/ModalDialog.js":
/*!**************************************!*\
  !*** ./js/components/ModalDialog.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/icons/warning.svg */ "./svg/icons/warning.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function ModalDialog({
  className = '',
  dialogActive = false,
  handleCancel = null,
  onOpen = null,
  onClose = null,
  title = null,
  provides,
  handleConfirm,
  subtitle,
  confirmButton = null,
  notes = [],
  danger = false,
  inProgress = false,
  small = false,
  medium = false,
  buttonLink = null
}) {
  const instanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__["default"])(ModalDialog);
  const describedByID = `googlesitekit-dialog-description-${instanceID}`;
  const hasProvides = !!(provides && provides.length);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Dialog, {
    open: dialogActive,
    onOpen: onOpen,
    onClose: onClose,
    "aria-describedby": hasProvides ? describedByID : undefined,
    tabIndex: "-1",
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, {
      'googlesitekit-dialog-sm': small,
      'googlesitekit-dialog-md': medium
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogTitle, {
      children: [danger && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_svg_icons_warning_svg__WEBPACK_IMPORTED_MODULE_3__["default"], {
        width: 28,
        height: 28
      }), title]
    }),
    // Ensure we don't render anything at all if subtitle is falsy, as Dialog expects all its children to be elements and a falsy value will result in an error.
    subtitle ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
      className: "mdc-dialog__lead",
      children: subtitle
    }) : [], /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogContent, {
      children: [hasProvides && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("section", {
        id: describedByID,
        className: "mdc-dialog__provides",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("ul", {
          className: "mdc-list mdc-list--underlined mdc-list--non-interactive",
          children: provides.map(attribute => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("li", {
            className: "mdc-list-item",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("span", {
              className: "mdc-list-item__text",
              children: attribute
            })
          }, attribute))
        })
      }), notes.length > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("section", {
        className: "mdc-dialog__notes",
        children: notes.map((Note, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("p", {
          className: "mdc-dialog__note",
          children: [typeof Note === 'string' && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s is replaced with some sub-note text. */
          (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('<strong>Note:</strong> %s', 'google-site-kit'), Note), {
            strong: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("strong", {})
          }), typeof Note === 'function' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(Note, {})]
        }, `note-${index}`))
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.DialogFooter, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        className: "mdc-dialog__cancel-button",
        onClick: handleCancel,
        disabled: inProgress,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Cancel', 'google-site-kit')
      }), buttonLink ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
        href: buttonLink,
        onClick: handleConfirm,
        target: "_blank",
        danger: danger,
        children: confirmButton
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.SpinnerButton, {
        onClick: handleConfirm,
        danger: danger,
        disabled: inProgress,
        isSaving: inProgress,
        children: confirmButton || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Disconnect', 'google-site-kit')
      })]
    })]
  });
}
ModalDialog.displayName = 'Dialog';
ModalDialog.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  handleDialog: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  handleConfirm: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func).isRequired,
  onOpen: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  provides: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)),
  confirmButton: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  notes: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType)])),
  danger: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  small: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  medium: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  buttonLink: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModalDialog);

/***/ }),

/***/ "./js/components/Notice/CTAButton.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/CTAButton.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CTAButton)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/external.svg */ "./svg/icons/external.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function CTAButton({
  label,
  disabled,
  inProgress,
  onClick,
  href,
  external = false,
  hideExternalIndicator = false
}) {
  let trailingIconToUse;
  if (external && !hideExternalIndicator) {
    trailingIconToUse = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_svg_icons_external_svg__WEBPACK_IMPORTED_MODULE_2__["default"], {
      width: 14,
      height: 14
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.SpinnerButton, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__cta', {
      'googlesitekit-notice__cta--spinner__running': inProgress
    }),
    disabled: disabled,
    isSaving: inProgress,
    onClick: onClick,
    href: href,
    target: external ? '_blank' : undefined,
    trailingIcon: trailingIconToUse,
    children: label
  });
}
CTAButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  inProgress: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  hideExternalIndicator: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Description.js":
/*!*********************************************!*\
  !*** ./js/components/Notice/Description.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Description)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Description({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__description', className),
    children: children
  });
}
Description.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/DismissButton.js":
/*!***********************************************!*\
  !*** ./js/components/Notice/DismissButton.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DismissButton)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function DismissButton({
  label = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  onClick,
  disabled
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    onClick: onClick,
    disabled: disabled,
    tertiary: true,
    children: label
  });
}
DismissButton.propTypes = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};

/***/ }),

/***/ "./js/components/Notice/Icon.js":
/*!**************************************!*\
  !*** ./js/components/Notice/Icon.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/check-fill.svg */ "./svg/icons/check-fill.svg");
/* harmony import */ var _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/svg/icons/star-fill.svg */ "./svg/icons/star-fill.svg");
/* harmony import */ var _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/svg/icons/warning-notice.svg */ "./svg/icons/warning-notice.svg");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





const typeIconMap = {
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.NEW]: _svg_icons_star_fill_svg__WEBPACK_IMPORTED_MODULE_1__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.SUCCESS]: _svg_icons_check_fill_svg__WEBPACK_IMPORTED_MODULE_0__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.WARNING]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
  [_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.ERROR]: _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__["default"]
};
function Icon({
  type
}) {
  const IconComponent = typeIconMap[type] || _svg_icons_warning_notice_svg__WEBPACK_IMPORTED_MODULE_2__["default"];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(IconComponent, {
    width: 24,
    height: 24
  });
}
Icon.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES))
};

/***/ }),

/***/ "./js/components/Notice/Title.js":
/*!***************************************!*\
  !*** ./js/components/Notice/Title.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Title)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Title({
  className,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice__title', className),
    children: children
  });
}
Title.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};

/***/ }),

/***/ "./js/components/Notice/constants.js":
/*!*******************************************!*\
  !*** ./js/components/Notice/constants.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPES = {
  NEW: 'new',
  SUCCESS: 'success',
  WARNING: 'warning',
  INFO: 'info',
  INFO_ALT: 'info-alt',
  ERROR: 'error'
};

/***/ }),

/***/ "./js/components/Notice/index.js":
/*!***************************************!*\
  !*** ./js/components/Notice/index.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _CTAButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CTAButton */ "./js/components/Notice/CTAButton.js");
/* harmony import */ var _Description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Description */ "./js/components/Notice/Description.js");
/* harmony import */ var _DismissButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./DismissButton */ "./js/components/Notice/DismissButton.js");
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Icon */ "./js/components/Notice/Icon.js");
/* harmony import */ var _Title__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Title */ "./js/components/Notice/Title.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







const Notice = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(({
  className,
  title,
  description,
  dismissButton,
  ctaButton,
  type = _constants__WEBPACK_IMPORTED_MODULE_1__.TYPES.INFO,
  children,
  hideIcon
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-notice', `googlesitekit-notice--${type}`, className),
    children: [!hideIcon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
      className: "googlesitekit-notice__icon",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Icon__WEBPACK_IMPORTED_MODULE_5__["default"], {
        type: type
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__content",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Title__WEBPACK_IMPORTED_MODULE_6__["default"], {
        children: title
      }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Description__WEBPACK_IMPORTED_MODULE_3__["default"], {
        children: description
      })]
    }), (dismissButton?.label || dismissButton?.onClick || ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) || children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
      className: "googlesitekit-notice__action",
      children: [children, (dismissButton?.label || dismissButton?.onClick) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_DismissButton__WEBPACK_IMPORTED_MODULE_4__["default"], {
        label: dismissButton.label,
        onClick: dismissButton.onClick,
        disabled: dismissButton.disabled
      }), ctaButton?.label && (ctaButton?.onClick || ctaButton?.href) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_CTAButton__WEBPACK_IMPORTED_MODULE_2__["default"], {
        label: ctaButton.label,
        onClick: ctaButton.onClick,
        inProgress: ctaButton.inProgress,
        disabled: ctaButton.disabled,
        href: ctaButton.href,
        external: ctaButton.external,
        hideExternalIndicator: ctaButton.hideExternalIndicator
      })]
    })]
  });
});
Notice.TYPES = _constants__WEBPACK_IMPORTED_MODULE_1__.TYPES;
Notice.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  title: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_9___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_9___default().object)]),
  description: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  type: prop_types__WEBPACK_IMPORTED_MODULE_9___default().oneOf(Object.values(_constants__WEBPACK_IMPORTED_MODULE_1__.TYPES)),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape(_DismissButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_9___default().shape({
    ..._CTAButton__WEBPACK_IMPORTED_MODULE_2__["default"].propTypes,
    label: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string) // CTAButton label should not be required for this parent component.
  }),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().node),
  hideIcon: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);

/***/ }),

/***/ "./js/components/Null.js":
/*!*******************************!*\
  !*** ./js/components/Null.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Null)
/* harmony export */ });
/**
 * Null component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function Null() {
  return null;
}

/***/ }),

/***/ "./js/components/PermissionsModal/AuthenticatedPermissionsModal.js":
/*!*************************************************************************!*\
  !*** ./js/components/PermissionsModal/AuthenticatedPermissionsModal.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Portal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Portal */ "./js/components/Portal.js");
/* harmony import */ var _js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/RefocusableModalDialog */ "./js/components/RefocusableModalDialog.js");
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AuthenticatedPermissionsModal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function AuthenticatedPermissionsModal() {
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const permissionsError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).getPermissionScopeError());
  const unsatisfiedScopes = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).getUnsatisfiedScopes());
  const connectURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER).getConnectURL({
    additionalScopes: permissionsError?.data?.scopes,
    redirectURL: permissionsError?.data?.redirectURL || __webpack_require__.g.location.href,
    errorRedirectURL: permissionsError?.data?.errorRedirectURL
  }));
  const {
    clearPermissionScopeError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.CORE_USER);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_LOCATION);
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_FORMS);
  const onCancel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    clearPermissionScopeError();
  }, [clearPermissionScopeError]);
  const onConfirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(async () => {
    // Temporary store permissions error, so data like `scopes` and `redirectURL`
    // can be used in `Permission error` notification.
    setValues(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_7__.FORM_TEMPORARY_PERSIST_PERMISSION_ERROR, {
      permissionsError
    });
    // If we have a datastores to snapshot before navigating away to the
    // authorization page, do that first.
    await (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_4__.snapshotAllStores)(registry);

    // Navigate to the authorization page.
    navigateTo(connectURL);
  }, [registry, connectURL, navigateTo, permissionsError, setValues]);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
    // If error has flag to skip the modal, redirect to the authorization
    // page immediately without prompting the user, essentially short-
    // circuiting to the confirm step.
    async function confirmIfSkipModal() {
      if (permissionsError?.data?.skipModal && permissionsError?.data?.scopes?.length) {
        await onConfirm();
      }
    }
    confirmIfSkipModal();
  }, [onConfirm, permissionsError]);
  if (!permissionsError) {
    return null;
  }

  // If there aren't any scopes for us to request, there's no reason to show
  // the modal. Log a console warning if this happens and return `null`.
  if (!permissionsError?.data?.scopes?.length) {
    __webpack_require__.g.console.warn('permissionsError lacks scopes array to use for redirect, so not showing the PermissionsModal. permissionsError was:', permissionsError);
    return null;
  }
  if (permissionsError?.data?.skipModal) {
    return null;
  }
  if (unsatisfiedScopes && permissionsError?.data?.scopes.every(scope => unsatisfiedScopes.includes(scope))) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_Portal__WEBPACK_IMPORTED_MODULE_2__["default"], {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_RefocusableModalDialog__WEBPACK_IMPORTED_MODULE_3__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Additional Permissions Required', 'google-site-kit'),
      subtitle: permissionsError.message,
      confirmButton: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Proceed', 'google-site-kit'),
      handleConfirm: onConfirm,
      handleCancel: onCancel,
      onClose: onCancel,
      dialogActive: true,
      medium: true
    })
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AuthenticatedPermissionsModal);

/***/ }),

/***/ "./js/components/PermissionsModal/index.js":
/*!*************************************************!*\
  !*** ./js/components/PermissionsModal/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _AuthenticatedPermissionsModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AuthenticatedPermissionsModal */ "./js/components/PermissionsModal/AuthenticatedPermissionsModal.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PermissionsModal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */




function PermissionsModal() {
  const isAuthenticated = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_USER).isAuthenticated());
  if (isAuthenticated) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_AuthenticatedPermissionsModal__WEBPACK_IMPORTED_MODULE_2__["default"], {});
  }
  return null;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PermissionsModal);

/***/ }),

/***/ "./js/components/Portal.js":
/*!*********************************!*\
  !*** ./js/components/Portal.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEffectOnce.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/**
 * Portal component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

function Portal({
  children,
  slug
}) {
  // Using state as we need `el` to not change when the component re-renders
  const [el] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(document.createElement('div'));
  (0,react_use__WEBPACK_IMPORTED_MODULE_1__["default"])(() => {
    if (slug) {
      el.classList.add(`googlesitekit-portal-${slug}`);
    }
    const root = document.querySelector('.googlesitekit-plugin') || document.body;
    root.appendChild(el);
    return () => root.removeChild(el);
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createPortal)(children, el);
}
Portal.propTypes = {
  slug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Portal.defaultProps = {
  slug: '',
  children: null
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Portal);

/***/ }),

/***/ "./js/components/PreviewBlock.js":
/*!***************************************!*\
  !*** ./js/components/PreviewBlock.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewBlock component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function PreviewBlock({
  className,
  width,
  height,
  shape,
  padding,
  smallWidth,
  smallHeight,
  tabletWidth,
  tabletHeight,
  desktopWidth,
  desktopHeight
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  const blockDimensions = {
    width: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopWidth,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    },
    height: {
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL]: smallHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_TABLET]: tabletHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_DESKTOP]: desktopHeight,
      [_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_XLARGE]: desktopWidth
    }
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block', className, {
      'googlesitekit-preview-block--padding': padding
    }),
    style: {
      width: blockDimensions.width[breakpoint] || width,
      height: blockDimensions.height[breakpoint] || height
    },
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-block__wrapper', {
        'googlesitekit-preview-block__wrapper--circle': shape === 'circular'
      })
    })
  });
}
PreviewBlock.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  width: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  height: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  shape: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  padding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  smallWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  smallHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  tabletHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopWidth: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  desktopHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
PreviewBlock.defaultProps = {
  className: undefined,
  width: '100px',
  height: '100px',
  shape: 'square',
  padding: false,
  smallWidth: undefined,
  smallHeight: undefined,
  tabletWidth: undefined,
  tabletHeight: undefined,
  desktopWidth: undefined,
  desktopHeight: undefined
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewBlock);

/***/ }),

/***/ "./js/components/PreviewGraph.js":
/*!***************************************!*\
  !*** ./js/components/PreviewGraph.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PreviewGraph)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _svg_icons_arrow_up_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/svg/icons/arrow-up.svg */ "./svg/icons/arrow-up.svg");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewGraph component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function PreviewGraph({
  title,
  GraphSVG,
  showIcons
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "googlesitekit-analytics-cta__preview-graph",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_Typography__WEBPACK_IMPORTED_MODULE_1__["default"], {
      as: "h3",
      size: "small",
      type: "body",
      className: "googlesitekit-analytics-cta__preview-graph--title",
      children: title
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(GraphSVG, {})
    }), showIcons && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
      className: "googlesitekit-analytics-cta__preview-graph--icons",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_svg_icons_arrow_up_svg__WEBPACK_IMPORTED_MODULE_0__["default"], {
        className: "googlesitekit-analytics-cta__preview-graph--up-arrow"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
        className: "googlesitekit-analytics-cta__preview-graph--bar"
      })]
    })]
  });
}
PreviewGraph.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  GraphSVG: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType).isRequired,
  showIcons: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
PreviewGraph.defaultProps = {
  showIcons: true
};

/***/ }),

/***/ "./js/components/PreviewTable.js":
/*!***************************************!*\
  !*** ./js/components/PreviewTable.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _PreviewBlock__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PreviewTable component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function PreviewTable({
  rows,
  rowHeight,
  padding
}) {
  const rowData = [];
  for (let x = 0; rows > x; x++) {
    rowData.push(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      className: "googlesitekit-preview-table__row",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_PreviewBlock__WEBPACK_IMPORTED_MODULE_1__["default"], {
        width: "100%",
        height: rowHeight + 'px'
      })
    }, 'table-row-' + x));
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-preview-table', {
      'googlesitekit-preview-table--padding': padding
    }),
    children: rowData
  });
}
PreviewTable.propTypes = {
  rows: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  rowHeight: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().number),
  padding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
PreviewTable.defaultProps = {
  rows: 11,
  rowHeight: 35,
  padding: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PreviewTable);

/***/ }),

/***/ "./js/components/RecoverableModules.js":
/*!*********************************************!*\
  !*** ./js/components/RecoverableModules.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RecoverableModules)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * RecoverableModules component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function RecoverableModules({
  moduleSlugs
}) {
  const moduleNames = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    const modules = select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModules();
    if (modules === undefined) {
      return undefined;
    }
    return moduleSlugs.map(moduleSlug => modules[moduleSlug].name);
  });
  if (moduleNames === undefined) {
    return null;
  }
  const description = moduleNames.length === 1 ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data was previously shared by an admin who no longer has access. Please contact another admin to restore it.', 'google-site-kit'), moduleNames[0]) : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: List of module names */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('The data for the following modules was previously shared by an admin who no longer has access: %s. Please contact another admin to restore it.', 'google-site-kit'), moduleNames.join((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._x)(', ', 'Recoverable modules', 'google-site-kit')));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Data Unavailable', 'google-site-kit'),
    description: description
  });
}
RecoverableModules.propTypes = {
  moduleSlugs: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_5___default().string)).isRequired
};

/***/ }),

/***/ "./js/components/RefocusableModalDialog.js":
/*!*************************************************!*\
  !*** ./js/components/RefocusableModalDialog.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-previous/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ModalDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ModalDialog */ "./js/components/ModalDialog.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ModalDialog component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



// Use a singleton variable to store the clicked element before any dialog opens.
// We need to do this at the module level since the component may not be mounted
// when the user initiates an action that will open the dialog.

let previouslyClickedElement = null;

// Set up a global event listener to capture the clicked element before any dialog opens.
// This needs to happen at the module level to ensure it's set up before any user interaction.
function setupFocusTracker() {
  if (typeof __webpack_require__.g === 'undefined' || !__webpack_require__.g.document || __webpack_require__.g._googlesitekitModalFocusTrackerInitialized) {
    return;
  }
  function captureActiveElementOnClick(event) {
    // Store the clicked (or keyboard-activated) element when user clicks.
    // This will be the element that was clicked right before the dialog opens.
    const nearestParentButtonOrAnchor = event.target.closest('button, a, input');
    if (nearestParentButtonOrAnchor && !nearestParentButtonOrAnchor.classList.contains('mdc-dialog__cancel-button')) {
      previouslyClickedElement = nearestParentButtonOrAnchor;
    }
  }
  __webpack_require__.g.document.addEventListener('mousedown', captureActiveElementOnClick);
  __webpack_require__.g.document.addEventListener('keydown', event => {
    if (event.key === 'Enter' || event.key === ' ') {
      captureActiveElementOnClick(event);
    }
  });
  __webpack_require__.g._googlesitekitModalFocusTrackerInitialized = true;
}
setupFocusTracker();
function RefocusableModalDialog({
  dialogActive = false,
  refocusQuerySelector = null,
  ...modalDialogProps
}) {
  const handleElementRefocus = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(() => {
    setTimeout(() => {
      const elementToFocus = refocusQuerySelector ? document.querySelector(refocusQuerySelector) : previouslyClickedElement;
      if (elementToFocus && document.body.contains(elementToFocus)) {
        elementToFocus.focus();
      }
      if (!refocusQuerySelector) {
        previouslyClickedElement = null;
      }
    });
  }, [refocusQuerySelector]);
  const previousDialogActive = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(dialogActive);
  // Handle re-focus of the button which triggered the modal.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    if (previousDialogActive === true && dialogActive === false) {
      handleElementRefocus();
    }
    return () => {
      // In majority of cases the modal is conditionally rendered, so dialogActive
      // will not be passed, as component will be unmounted/removed from the DOM.
      handleElementRefocus();
    };
  }, [previousDialogActive, dialogActive, handleElementRefocus]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_ModalDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    dialogActive: dialogActive,
    ...modalDialogProps
  });
}
RefocusableModalDialog.propTypes = {
  dialogActive: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  refocusQuerySelector: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ...googlesitekit_components__WEBPACK_IMPORTED_MODULE_0__.Dialog.propTypes
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RefocusableModalDialog);

/***/ }),

/***/ "./js/components/ReportError.js":
/*!**************************************!*\
  !*** ./js/components/ReportError.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportError)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/remove-query-args.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/insufficient-permissions-error-description */ "./js/util/insufficient-permissions-error-description.js");
/* harmony import */ var _js_util_purify__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util/purify */ "./js/util/purify.js");
/* harmony import */ var _ErrorNotice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var _ReportErrorActions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ReportErrorActions */ "./js/components/ReportErrorActions.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */










function ReportError({
  moduleSlug,
  error
}) {
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).getModule(moduleSlug));
  const errors = Array.isArray(error) ? error : [error];
  let title;
  function getMessage(err) {
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err)) {
      if (isViewOnly) {
        title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Access lost to %s', 'google-site-kit'), module?.name);
        return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
        (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The administrator sharing this module with you has lost access to the %s service, so you won’t be able to see stats from it on the Site Kit dashboard. You can contact them or another administrator to restore access.', 'google-site-kit'), module?.name);
      }
      title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Insufficient permissions in %s', 'google-site-kit'), module?.name);
      return (0,_js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_6__.getInsufficientPermissionsErrorDescription)(err.message, module);
    }
    return (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.getReportErrorMessage)(err);
  }
  const uniqueErrors = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.uniqWith)(errors.map(err => ({
    ...err,
    message: getMessage(err),
    // The `code` parameter contains a session ID which can vary
    // between requests, so we ignore it for comparison below.
    // To use the original `reconnectURL` elsewhere, use `err.data.reconnectURL`.
    reconnectURL: err.data?.reconnectURL ? (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_12__.removeQueryArgs)(err.data.reconnectURL, 'code') : undefined
  })), (errorA, errorB) => errorA.message === errorB.message && errorA.reconnectURL === errorB.reconnectURL);
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_5__.isInsufficientPermissionsError)(err));
  if (!hasInsufficientPermissionsError && uniqueErrors.length === 1) {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Data error in %s', 'google-site-kit'), module?.name);
  } else if (!hasInsufficientPermissionsError && uniqueErrors.length > 1) {
    title = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Data errors in %s', 'google-site-kit'), module?.name);
  }
  const description = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_13__.Fragment, {
    children: uniqueErrors.map(errorForNotice => {
      const reconnectURL = errorForNotice?.data?.reconnectURL;
      return reconnectURL ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ErrorNotice__WEBPACK_IMPORTED_MODULE_8__["default"], {
        error: errorForNotice,
        message: errorForNotice.message
      }, errorForNotice.message) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
        children: _js_util_purify__WEBPACK_IMPORTED_MODULE_7__.purify.sanitize(errorForNotice.message, {
          // Ensures no HTML tags are passed as they would be
          // escaped by React and appear as strings.
          ALLOWED_TAGS: []
        })
      }, errorForNotice.message);
    })
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_9__["default"], {
    title: title,
    description: description,
    error: true,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_ReportErrorActions__WEBPACK_IMPORTED_MODULE_10__["default"], {
      moduleSlug: moduleSlug,
      error: error
    })
  });
}
ReportError.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_14___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_14___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_14___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_14___default().object)]).isRequired
};

/***/ }),

/***/ "./js/components/ReportErrorActions.js":
/*!*********************************************!*\
  !*** ./js/components/ReportErrorActions.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportErrorActions)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportErrorActions component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */








function ReportErrorActions(props) {
  const {
    moduleSlug,
    error,
    GetHelpLink,
    hideGetHelpLink,
    buttonVariant,
    onRetry,
    onRequestAccess,
    getHelpClassName,
    RequestAccessButton,
    RetryButton
  } = props;
  const isViewOnly = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_5__["default"])();
  const storeName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const requestAccessURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => typeof select(storeName)?.getServiceEntityAccessURL === 'function' ? select(storeName).getServiceEntityAccessURL() : null);
  const errors = Array.isArray(error) ? error : [error];
  const errorsWithSelectorData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => errors.map(err => {
    const selectorData = select(storeName)?.getSelectorDataForError(err);
    return {
      ...err,
      selectorData
    };
  }));
  const retryableErrors = errorsWithSelectorData?.filter(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_6__.isErrorRetryable)(err, err.selectorData) && err.selectorData.name === 'getReport');
  const showRetry = !!retryableErrors.length;
  const errorTroubleshootingLinkURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const err = {
      ...(showRetry ? retryableErrors[0] : errors[0])
    };
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_6__.isInsufficientPermissionsError)(err)) {
      err.code = `${moduleSlug}_insufficient_permissions`;
    }
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE).getErrorTroubleshootingLinkURL(err);
  });
  const dispatch = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)();
  const hasInsufficientPermissionsError = errors.some(err => (0,_js_util_errors__WEBPACK_IMPORTED_MODULE_6__.isInsufficientPermissionsError)(err));
  const handleRetry = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
    retryableErrors.forEach(err => {
      const {
        selectorData
      } = err;
      dispatch(selectorData.storeName).invalidateResolution(selectorData.name, selectorData.args);
    });
    onRetry?.();
  }, [dispatch, retryableErrors, onRetry]);
  const showRequestAccessURL = requestAccessURL && hasInsufficientPermissionsError && !isViewOnly;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
    className: "googlesitekit-report-error-actions",
    children: [showRequestAccessURL && (typeof RequestAccessButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RequestAccessButton, {
      requestAccessURL: requestAccessURL
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
      onClick: onRequestAccess,
      href: requestAccessURL,
      target: "_blank",
      danger: buttonVariant === 'danger',
      tertiary: buttonVariant === 'tertiary',
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Request access', 'google-site-kit')
    })), showRetry && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.Fragment, {
      children: [typeof RetryButton === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(RetryButton, {
        handleRetry: handleRetry
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        onClick: handleRetry,
        danger: buttonVariant === 'danger',
        tertiary: buttonVariant === 'tertiary',
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry', 'google-site-kit')
      }), !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("span", {
        className: "googlesitekit-error-retry-text",
        children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Retry didn’t work? <HelpLink />', 'google-site-kit'), {
          HelpLink: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
            href: errorTroubleshootingLinkURL,
            external: true,
            hideExternalIndicator: true,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
          })
        })
      })]
    }), !showRetry && !hideGetHelpLink && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)("div", {
      className: getHelpClassName,
      children: typeof GetHelpLink === 'function' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(GetHelpLink, {
        linkURL: errorTroubleshootingLinkURL
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_7__["default"], {
        href: errorTroubleshootingLinkURL,
        external: true,
        hideExternalIndicator: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Get help', 'google-site-kit')
      })
    })]
  });
}
ReportErrorActions.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string).isRequired,
  error: prop_types__WEBPACK_IMPORTED_MODULE_11___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_11___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)), (prop_types__WEBPACK_IMPORTED_MODULE_11___default().object)]).isRequired,
  GetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  hideGetHelpLink: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().bool),
  buttonVariant: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  onRetry: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  onRequestAccess: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().func),
  getHelpClassName: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().string),
  RequestAccessButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType),
  RetryButton: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType)
};

/***/ }),

/***/ "./js/components/ReportErrorButton/index.js":
/*!**************************************************!*\
  !*** ./js/components/ReportErrorButton/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clipboard-copy */ "../node_modules/clipboard-copy/index.js");
/* harmony import */ var clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(clipboard_copy__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/icons */ "../node_modules/@wordpress/icons/build-module/library/stack.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportErrorButton component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function ReportErrorButton({
  message,
  componentStack
}) {
  const [copied, setCopied] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  function onErrorClick() {
    // Copy message with wrapping backticks for code block formatting on wp.org.
    clipboard_copy__WEBPACK_IMPORTED_MODULE_0___default()(`\`\`\`\n${message}\n${componentStack}\n\`\`\``);
    setCopied(true);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Button, {
    "aria-label": copied ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Error message copied to clipboard. Click to copy the error message again.', 'google-site-kit') : undefined,
    onClick: onErrorClick,
    trailingIcon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_5__["default"], {
      className: "mdc-button__icon",
      icon: copied ? _wordpress_icons__WEBPACK_IMPORTED_MODULE_6__["default"] : _wordpress_icons__WEBPACK_IMPORTED_MODULE_7__["default"]
    }),
    children: copied ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Copied to clipboard', 'google-site-kit') : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Copy error contents', 'google-site-kit')
  });
}
ReportErrorButton.propTypes = {
  message: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string),
  componentStack: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReportErrorButton);

/***/ }),

/***/ "./js/components/ReportTable.js":
/*!**************************************!*\
  !*** ./js/components/ReportTable.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportTable)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _GatheringDataNotice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./GatheringDataNotice */ "./js/components/GatheringDataNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Report Table component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */





/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function ReportTable(props) {
  const {
    rows,
    columns,
    className,
    limit,
    zeroState: ZeroState,
    gatheringData = false,
    tabbedLayout = false
  } = props;
  invariant__WEBPACK_IMPORTED_MODULE_1___default()(Array.isArray(rows), 'rows must be an array.');
  invariant__WEBPACK_IMPORTED_MODULE_1___default()(Array.isArray(columns), 'columns must be an array.');
  columns.forEach(({
    Component,
    field = null
  }) => {
    invariant__WEBPACK_IMPORTED_MODULE_1___default()(Component || field !== null, 'each column must define a Component and/or a field.');
  });
  invariant__WEBPACK_IMPORTED_MODULE_1___default()(Number.isInteger(limit) || limit === undefined, 'limit must be an integer, if provided.');
  const hasBadges = columns.some(({
    badge
  }) => !!badge);
  const [activeColumnIndex, setActiveColumnIndex] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__.useState)(0);

  // The first column is expected to be the row title or label, which will always be
  // shown so we exclude it from the tab list.
  const tabColumns = tabbedLayout && columns.slice(1);
  const contentColumns = tabbedLayout ? [columns[0], tabColumns[activeColumnIndex]] : columns;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: className,
    children: [tabbedLayout && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.TabBar, {
      className: "googlesitekit-tab-bar--start-aligned-high-contrast",
      activeIndex: activeColumnIndex,
      handleActiveIndexUpdate: setActiveColumnIndex,
      children: tabColumns.map(({
        title,
        badge
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Tab, {
        "aria-label": title,
        children: [title, badge]
      }, title))
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-table', 'googlesitekit-table--with-list', {
        'googlesitekit-table--gathering-data': gatheringData
      }),
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("table", {
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-table__wrapper', `googlesitekit-table__wrapper--${contentColumns.length}-col`, {
          'googlesitekit-table__wrapper--tabbed-layout': tabbedLayout
        }),
        children: [!tabbedLayout && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("thead", {
          className: "googlesitekit-table__head",
          children: [hasBadges && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("tr", {
            className: "googlesitekit-table__head-badges",
            children: columns.map(({
              badge,
              primary,
              className: columnClassName,
              columnHeaderClassName
            }, colIndex) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("th", {
              className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-table__head-item', 'googlesitekit-table__head-item--badge', {
                'googlesitekit-table__head-item--primary': primary
              }, columnClassName, columnHeaderClassName),
              children: badge
            }, `googlesitekit-table__head-row-badge-${colIndex}`))
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("tr", {
            className: "googlesitekit-table__head-row",
            children: columns.map(({
              title,
              description,
              primary,
              className: columnClassName,
              columnHeaderClassName
            }, colIndex) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("th", {
              className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-table__head-item', {
                'googlesitekit-table__head-item--primary': primary
              }, columnClassName, columnHeaderClassName),
              "data-tooltip": description,
              children: title
            }, `googlesitekit-table__head-row-${colIndex}`))
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("tbody", {
          className: "googlesitekit-table__body",
          children: [gatheringData && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("tr", {
            className: "googlesitekit-table__body-row googlesitekit-table__body-row--no-data",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
              className: "googlesitekit-table__body-item",
              colSpan: contentColumns.length,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_4__["default"], {})
            })
          }), !gatheringData && !rows?.length && ZeroState && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("tr", {
            className: "googlesitekit-table__body-row googlesitekit-table__body-row--no-data",
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
              className: "googlesitekit-table__body-item",
              colSpan: contentColumns.length,
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(ZeroState, {})
            })
          }), !gatheringData && rows.slice(0, limit).map((row, rowIndex) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("tr", {
            className: "googlesitekit-table__body-row",
            children: contentColumns.map(({
              Component,
              field,
              className: columnClassName
            }, colIndex) => {
              const fieldValue = field !== undefined ? (0,lodash__WEBPACK_IMPORTED_MODULE_2__.get)(row, field) : undefined;
              return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)("td", {
                className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-table__body-item', columnClassName),
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "googlesitekit-table__body-item-content",
                  children: [Component && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(Component, {
                    row: row,
                    fieldValue: fieldValue
                  }), !Component && fieldValue]
                })
              }, `googlesitekit-table__body-item-${colIndex}`);
            })
          }, `googlesitekit-table__body-row-${rowIndex}`))]
        })]
      })
    })]
  });
}
ReportTable.propTypes = {
  rows: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_7___default().array), (prop_types__WEBPACK_IMPORTED_MODULE_7___default().object)])).isRequired,
  columns: prop_types__WEBPACK_IMPORTED_MODULE_7___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_7___default().shape({
    title: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    description: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    primary: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
    className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    field: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
    Component: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().elementType),
    badge: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().node)
  })).isRequired,
  className: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().string),
  limit: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().number),
  zeroState: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().func),
  gatheringData: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool),
  tabbedLayout: (prop_types__WEBPACK_IMPORTED_MODULE_7___default().bool)
};

/***/ }),

/***/ "./js/components/ReportZero.js":
/*!*************************************!*\
  !*** ./js/components/ReportZero.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ReportZero)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _notifications_CTA__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/CTA */ "./js/components/notifications/CTA.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * ReportZero component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function ReportZero({
  moduleSlug
}) {
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_MODULES).getModule(moduleSlug));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_notifications_CTA__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s Gathering Data', 'google-site-kit'), module?.name),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: Module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('%s data is not yet available, please check back later', 'google-site-kit'), module?.name)
  });
}
ReportZero.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired
};

/***/ }),

/***/ "./js/components/RestoreSnapshots/index.js":
/*!*************************************************!*\
  !*** ./js/components/RestoreSnapshots/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/data/create-snapshot-store */ "./js/googlesitekit/data/create-snapshot-store.js");
/**
 * Snapshot restoration component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function RestoreSnapshots({
  children
}) {
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useRegistry)();
  const [restoredSnapshots, setRestoredSnapshots] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (!restoredSnapshots) {
      (async () => {
        await (0,_js_googlesitekit_data_create_snapshot_store__WEBPACK_IMPORTED_MODULE_1__.restoreAllSnapshots)(registry);
        setRestoredSnapshots(true);
      })();
    }
  }, [registry, restoredSnapshots]);
  if (!restoredSnapshots) {
    return null;
  }
  return children;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RestoreSnapshots);

/***/ }),

/***/ "./js/components/Root/ViewContextContext.js":
/*!**************************************************!*\
  !*** ./js/components/Root/ViewContextContext.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * View Context context for React components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const ViewContextContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)('');
const {
  Consumer,
  Provider
} = ViewContextContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ViewContextContext);

/***/ }),

/***/ "./js/components/Root/index.js":
/*!*************************************!*\
  !*** ./js/components/Root/index.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Root)
/* harmony export */ });
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/core/esm/styles/createMuiStrictModeTheme.js");
/* harmony import */ var _material_ui_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @material-ui/core */ "../node_modules/@material-ui/styles/esm/ThemeProvider/ThemeProvider.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_ErrorHandler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ErrorHandler */ "./js/components/ErrorHandler/index.js");
/* harmony import */ var _js_components_FeaturesProvider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/FeaturesProvider */ "./js/components/FeaturesProvider/index.js");
/* harmony import */ var _js_components_FeatureTours__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/FeatureTours */ "./js/components/FeatureTours.js");
/* harmony import */ var _js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/InViewProvider */ "./js/components/InViewProvider/index.js");
/* harmony import */ var _js_components_PermissionsModal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/PermissionsModal */ "./js/components/PermissionsModal/index.js");
/* harmony import */ var _js_components_RestoreSnapshots__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/RestoreSnapshots */ "./js/components/RestoreSnapshots/index.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/* harmony import */ var _js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/is-site-kit-screen */ "./js/util/is-site-kit-screen.js");
/* harmony import */ var _ViewContextContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Root component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











function Root({
  children,
  registry,
  viewContext = null
}) {
  const theme =  false ? 0 : _material_ui_core__WEBPACK_IMPORTED_MODULE_11__["default"]; // eslint-disable-line camelcase

  const [inViewState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useState)({
    key: 'Root',
    value: true
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.StrictMode, {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_4__["default"], {
      value: inViewState,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.RegistryProvider, {
        value: registry,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_FeaturesProvider__WEBPACK_IMPORTED_MODULE_2__["default"], {
          value: _js_features__WEBPACK_IMPORTED_MODULE_7__.enabledFeatures,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_ViewContextContext__WEBPACK_IMPORTED_MODULE_9__.Provider, {
            value: viewContext,
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_material_ui_core__WEBPACK_IMPORTED_MODULE_13__["default"], {
              theme: theme(),
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_js_components_ErrorHandler__WEBPACK_IMPORTED_MODULE_1__["default"], {
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_js_components_RestoreSnapshots__WEBPACK_IMPORTED_MODULE_6__["default"], {
                  children: [children, viewContext && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_FeatureTours__WEBPACK_IMPORTED_MODULE_3__["default"], {})]
                }), (0,_js_util_is_site_kit_screen__WEBPACK_IMPORTED_MODULE_8__.isSiteKitScreen)(viewContext) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_PermissionsModal__WEBPACK_IMPORTED_MODULE_5__["default"], {})]
              })
            })
          })
        })
      })
    })
  });
}
Root.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().node),
  registry: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().object),
  viewContext: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().string).isRequired
};
Root.defaultProps = {
  registry: (googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default())
};

/***/ }),

/***/ "./js/components/SourceLink.tsx":
/*!**************************************!*\
  !*** ./js/components/SourceLink.tsx ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_widgets_hooks_useWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/widgets/hooks/useWidget */ "./js/googlesitekit/widgets/hooks/useWidget.ts");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewOnly */ "./js/hooks/useViewOnly.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* provided dependency */ var React = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/index.js");
/**
 * SourceLink component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function SourceLink({
  name = '',
  href = '',
  className = '',
  external = false
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const viewOnlyDashboard = (0,_js_hooks_useViewOnly__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const widget = (0,_js_googlesitekit_widgets_hooks_useWidget__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const handleClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    if (!widget.slug || !viewContext) {
      return;
    }
    (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_widget`, 'click_source_link', widget.slug);
  }, [viewContext, widget]);
  if (viewOnlyDashboard) {
    return null;
  }
  return /*#__PURE__*/React.createElement("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-source-link', className)
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: %s: source link */
  (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Source: %s', 'google-site-kit'), `<a>${name}</a>`), {
    a: /*#__PURE__*/React.createElement(_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
      key: "link"
      // @ts-expect-error - The `Link` component is not currently typed.
      ,
      href: href,
      external: external,
      onClick: handleClick
    })
  }));
}
SourceLink.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  href: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().string),
  external: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SourceLink);

/***/ }),

/***/ "./js/components/StoreErrorNotices.js":
/*!********************************************!*\
  !*** ./js/components/StoreErrorNotices.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ StoreErrorNotices)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util/insufficient-permissions-error-description */ "./js/util/insufficient-permissions-error-description.js");
/* harmony import */ var _ErrorNotice__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ErrorNotice */ "./js/components/ErrorNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * StoreErrorNotices component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */






function StoreErrorNotices({
  hasButton = false,
  moduleSlug,
  storeName
}) {
  const errors = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(storeName).getErrors());
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_MODULES).getModule(moduleSlug));
  const existingErrorMessages = [];
  return errors.filter(error => {
    if (!error?.message || existingErrorMessages.includes(error.message)) {
      return false;
    }
    existingErrorMessages.push(error.message);
    return true;
  }).map((error, key) => {
    let {
      message
    } = error;
    if ((0,_js_util_errors__WEBPACK_IMPORTED_MODULE_2__.isInsufficientPermissionsError)(error)) {
      message = (0,_js_util_insufficient_permissions_error_description__WEBPACK_IMPORTED_MODULE_3__.getInsufficientPermissionsErrorDescription)(message, module);
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_ErrorNotice__WEBPACK_IMPORTED_MODULE_4__["default"], {
      error: error,
      hasButton: hasButton,
      storeName: storeName,
      message: message
    }, key);
  });
}
StoreErrorNotices.propTypes = {
  hasButton: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().bool),
  storeName: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
};

/***/ }),

/***/ "./js/components/SupportLink.js":
/*!**************************************!*\
  !*** ./js/components/SupportLink.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SupportLink)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Link */ "./js/components/Link.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function SupportLink(props) {
  const {
    path,
    query,
    hash,
    ...otherProps
  } = props;
  const supportURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_SITE).getGoogleSupportURL({
    path,
    query,
    hash
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
    ...otherProps,
    href: supportURL
  });
}
SupportLink.propTypes = {
  path: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  query: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().object),
  hash: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./js/components/TableOverflowContainer.js":
/*!*************************************************!*\
  !*** ./js/components/TableOverflowContainer.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useEvent.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TableOverflowContainer component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */





/**
 * WordPress dependencies
 */


function TableOverflowContainer({
  children
}) {
  const [isScrolling, setScrolling] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const scrollRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)();
  const debouncedScrollCheck = (0,lodash__WEBPACK_IMPORTED_MODULE_1__.debounce)(setIsScrolling, 100);
  (0,react_use__WEBPACK_IMPORTED_MODULE_4__["default"])('resize', debouncedScrollCheck);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    setIsScrolling();
  }, []);
  function setIsScrolling() {
    if (!scrollRef.current) {
      return;
    }
    const {
      scrollLeft,
      scrollWidth,
      offsetWidth
    } = scrollRef.current;
    const maxScroll = scrollWidth - offsetWidth;
    const scrolling = scrollLeft < maxScroll - 16 && 0 < maxScroll - 16; // 16 = $grid-gap-phone

    setScrolling(scrolling);
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    onScroll: (0,lodash__WEBPACK_IMPORTED_MODULE_1__.debounce)(setIsScrolling, 100),
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-table-overflow', {
      'googlesitekit-table-overflow--gradient': isScrolling
    }),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
      ref: scrollRef,
      className: "googlesitekit-table-overflow__container",
      children: children
    })
  });
}
TableOverflowContainer.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().element)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TableOverflowContainer);

/***/ }),

/***/ "./js/components/TourTooltip.js":
/*!**************************************!*\
  !*** ./js/components/TourTooltip.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TourTooltip)
/* harmony export */ });
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-card */ "../node_modules/@material/react-card/dist/index.js");
/* harmony import */ var _material_react_card__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_card__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/create-incremental-array-by-size */ "./js/util/create-incremental-array-by-size.js");
/* harmony import */ var _svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/svg/icons/close.svg */ "./svg/icons/close.svg");
/* harmony import */ var _Typography__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltip component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function TourTooltip({
  backProps,
  closeProps,
  index,
  primaryProps,
  size,
  step,
  tooltipProps
}) {
  const indicatorArray = size > 1 ? (0,_js_util_create_incremental_array_by_size__WEBPACK_IMPORTED_MODULE_4__.createIncrementalArrayBySize)(size) : [];
  function getIndicatorClassName(indicatorIndex) {
    return classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tooltip-indicator', {
      active: indicatorIndex === index
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('googlesitekit-tour-tooltip', step.className),
    ...tooltipProps,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)((_material_react_card__WEBPACK_IMPORTED_MODULE_0___default()), {
      className: "googlesitekit-tooltip-card",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "googlesitekit-tooltip-body",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_Typography__WEBPACK_IMPORTED_MODULE_6__["default"], {
          as: "h2",
          className: "googlesitekit-tooltip-title",
          size: "medium",
          type: "title",
          children: step.title
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("div", {
          className: "googlesitekit-tooltip-content",
          children: step.content
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_material_react_card__WEBPACK_IMPORTED_MODULE_0__.CardActions, {
        className: "googlesitekit-tooltip-actions",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("ul", {
          className: "googlesitekit-tooltip-indicators",
          children: indicatorArray.map(indicatorIndex => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)("li", {
            className: getIndicatorClassName(indicatorIndex)
          }, `indicator-${indicatorIndex}`))
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "googlesitekit-tooltip-buttons",
          children: [index !== 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...backProps,
            children: backProps.title
          }), step.cta, primaryProps.title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
            className: "googlesitekit-tooltip-button",
            text: true,
            ...primaryProps,
            children: primaryProps.title
          })]
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        className: "googlesitekit-tooltip-close",
        icon: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(_svg_icons_close_svg__WEBPACK_IMPORTED_MODULE_5__["default"], {
          width: "14",
          height: "14"
        }),
        onClick: closeProps.onClick,
        "aria-label": (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Close', 'google-site-kit'),
        text: true,
        hideTooltipTitle: true
      })]
    })
  });
}

/**
 * All props are provided directly from `react-joyride`, intended for custom components.
 *
 * @since 1.28.0
 * @see {@link https://docs.react-joyride.com/custom-components#props-1}.
 */
TourTooltip.propTypes = {
  backProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  closeProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  index: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  isLastStep: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool).isRequired,
  primaryProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired,
  size: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().number).isRequired,
  step: prop_types__WEBPACK_IMPORTED_MODULE_8___default().shape({
    content: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node),
    cta: prop_types__WEBPACK_IMPORTED_MODULE_8___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_8___default().element), (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)]),
    className: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().string)
  }).isRequired,
  tooltipProps: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().object).isRequired
};

/***/ }),

/***/ "./js/components/TourTooltips.js":
/*!***************************************!*\
  !*** ./js/components/TourTooltips.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GA_ACTIONS: () => (/* binding */ GA_ACTIONS),
/* harmony export */   "default": () => (/* binding */ TourTooltips),
/* harmony export */   floaterProps: () => (/* binding */ floaterProps),
/* harmony export */   joyrideStyles: () => (/* binding */ joyrideStyles)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-joyride */ "../node_modules/react-joyride/dist/index.mjs");
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _TourTooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./TourTooltip */ "./js/components/TourTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TourTooltips component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







/** For available options, see: {@link https://github.com/gilbarbara/react-joyride/blob/3e08384415a831b20ce21c8423b6c271ad419fbf/src/styles.js}. */

const joyrideStyles = {
  options: {
    arrowColor: '#3c7251',
    // $c-content-primary
    backgroundColor: '#3c7251',
    // $c-content-primary
    overlayColor: 'rgba(0, 0, 0, 0.6)',
    textColor: '#fff',
    // $c-content-on-primary
    zIndex: 20000
  },
  spotlight: {
    border: '2px solid #3c7251',
    // $c-content-primary
    backgroundColor: '#fff'
  }
};

// Provides button content as well as aria-label & title attribute values.
const joyrideLocale = {
  back: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Back', 'google-site-kit'),
  close: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Close', 'google-site-kit'),
  last: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got it', 'google-site-kit'),
  next: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Next', 'google-site-kit')
};

/** For available options, see: {@link https://github.com/gilbarbara/react-floater#props}. */
const floaterProps = {
  disableAnimation: true,
  styles: {
    arrow: {
      length: 8,
      margin: 56,
      spread: 16
    },
    floater: {
      filter: 'drop-shadow(rgba(60, 64, 67, 0.3) 0px 1px 2px) drop-shadow(rgba(60, 64, 67, 0.15) 0px 2px 6px)'
    }
  }
};

// GA Event Tracking actions (do not change!)
const GA_ACTIONS = {
  VIEW: 'feature_tooltip_view',
  NEXT: 'feature_tooltip_advance',
  PREV: 'feature_tooltip_return',
  DISMISS: 'feature_tooltip_dismiss',
  COMPLETE: 'feature_tooltip_complete'
};
function TourTooltips({
  steps,
  tourID,
  gaEventCategory,
  isRepeatable,
  callback
}) {
  const stepKey = `${tourID}-step`;
  const runKey = `${tourID}-run`;
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const {
    dismissTour,
    receiveCurrentTour
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER);
  const registry = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useRegistry)();
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const stepIndex = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(stepKey) || 0);
  const run = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(runKey) && select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).isTourDismissed(tourID) === false;
  });
  function changeStep(index, action) {
    return setValue(stepKey, index + (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV ? -1 : 1));
  }
  function startTour() {
    __webpack_require__.g.document.body.classList.add('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    setValue(runKey, true);
  }
  function endTour() {
    __webpack_require__.g.document.body.classList.remove('googlesitekit-showing-feature-tour', `googlesitekit-showing-feature-tour--${tourID}`);
    if (isRepeatable) {
      setValue(runKey, false);
      setValue(stepKey, null);
      receiveCurrentTour(null);
    } else {
      // Dismiss tour to avoid unwanted repeat viewing.
      dismissTour(tourID);
    }
  }
  function trackAllTourEvents({
    index,
    action,
    lifecycle,
    size,
    status,
    type
  }) {
    // The index is 0-based, but step numbers are 1-based.
    const stepNumber = index + 1;
    const eventCategory = typeof gaEventCategory === 'function' ? gaEventCategory(viewContext) : gaEventCategory;
    if (type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOOLTIP && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.TOOLTIP) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.VIEW, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE && lifecycle === react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.DISMISS, stepNumber);
    } else if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT && status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TOUR_END &&
    // Here we need to additionally check the size === stepNumber because
    // it is the only way to differentiate the status/event combination
    // from an identical combination that happens immediately after completion
    // on index `0` to avoid duplicate measurement.
    size === stepNumber) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.COMPLETE, stepNumber);
    }
    if (lifecycle !== react_joyride__WEBPACK_IMPORTED_MODULE_8__.LIFECYCLE.COMPLETE || status === react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED) {
      return;
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.PREV) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.PREV, stepNumber);
    }
    if (action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.NEXT) {
      (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(eventCategory, GA_ACTIONS.NEXT, stepNumber);
    }
  }

  /**
   * Handles `react-joyride` state changes using callback function.
   *
   * @typedef {Object} JoyrideCallbackData
   * @property {string} action The action that updated the state.
   * @property {status} status The tour's status.
   * @property {number} index  Step index.
   * @property {string} type   Specific type (tour, step, beacon).
   *
   * @since 1.28.0
   * @since 1.38.0 Calls new callback prop.
   * @see {@link https://docs.react-joyride.com/callback} Example data provided by `react-joyride`.
   * @see {@link https://docs.react-joyride.com/constants} State & lifecycle constants used by `react-joyride`.
   *
   * @param {JoyrideCallbackData} data Data object provided via `react-joyride` callback prop.
   */
  function handleJoyrideCallback(data) {
    trackAllTourEvents(data);
    const {
      action,
      index,
      status,
      step,
      type
    } = data;
    const hasCloseAction = action === react_joyride__WEBPACK_IMPORTED_MODULE_8__.ACTIONS.CLOSE;
    const shouldChangeStep = !hasCloseAction && [react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER, react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.TARGET_NOT_FOUND].includes(type);
    const isFinishedOrSkipped = [react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.FINISHED, react_joyride__WEBPACK_IMPORTED_MODULE_8__.STATUS.SKIPPED].includes(status);
    const shouldCloseFromButtonClick = hasCloseAction && type === react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_AFTER;
    const shouldEndTour = isFinishedOrSkipped || shouldCloseFromButtonClick;

    // Center the target in the viewport when transitioning to the step.
    if (react_joyride__WEBPACK_IMPORTED_MODULE_8__.EVENTS.STEP_BEFORE === type) {
      let el = step.target;
      if ('string' === typeof step.target) {
        el = __webpack_require__.g.document.querySelector(step.target);
      }
      el?.scrollIntoView?.({
        block: 'center'
      });
    }
    if (shouldChangeStep) {
      changeStep(index, action);
    } else if (shouldEndTour) {
      endTour();
    }
    if (callback) {
      callback(data, registry);
    }
  }

  // Start tour on initial render
  (0,react_use__WEBPACK_IMPORTED_MODULE_9__["default"])(startTour);
  const parsedSteps = steps.map(step => ({
    disableBeacon: true,
    isFixed: true,
    placement: 'auto',
    ...step
  }));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(react_joyride__WEBPACK_IMPORTED_MODULE_8__["default"], {
    callback: handleJoyrideCallback,
    floaterProps: floaterProps,
    locale: joyrideLocale,
    run: run,
    stepIndex: stepIndex,
    steps: parsedSteps,
    styles: joyrideStyles,
    tooltipComponent: _TourTooltip__WEBPACK_IMPORTED_MODULE_6__["default"],
    continuous: true,
    disableOverlayClose: true,
    disableScrolling: true,
    showProgress: true
  });
}

/** For available properties & docs for `steps`, see: {@link https://docs.react-joyride.com/step#options}. */
TourTooltips.propTypes = {
  steps: prop_types__WEBPACK_IMPORTED_MODULE_10___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_10___default().object)).isRequired,
  tourID: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string).isRequired,
  gaEventCategory: prop_types__WEBPACK_IMPORTED_MODULE_10___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_10___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)]).isRequired,
  isRepeatable: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  callback: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};

/***/ }),

/***/ "./js/components/Typography/P.js":
/*!***************************************!*\
  !*** ./js/components/Typography/P.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ P)
/* harmony export */ });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! . */ "./js/components/Typography/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/hooks/useBreakpoint */ "./js/hooks/useBreakpoint.ts");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */



function P({
  type = _constants__WEBPACK_IMPORTED_MODULE_2__.TYPE_BODY,
  size,
  children,
  ...props
}) {
  const breakpoint = (0,_js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(___WEBPACK_IMPORTED_MODULE_0__["default"], {
    as: "p",
    type: type,
    size: size || (breakpoint === _js_hooks_useBreakpoint__WEBPACK_IMPORTED_MODULE_1__.BREAKPOINT_SMALL ? _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_SMALL : _constants__WEBPACK_IMPORTED_MODULE_2__.SIZE_MEDIUM),
    ...props,
    children: children
  });
}
P.propTypes = {
  type: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_4___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_2__.VALID_SIZES)
};

/***/ }),

/***/ "./js/components/Typography/constants.js":
/*!***********************************************!*\
  !*** ./js/components/Typography/constants.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SIZE_LARGE: () => (/* binding */ SIZE_LARGE),
/* harmony export */   SIZE_MEDIUM: () => (/* binding */ SIZE_MEDIUM),
/* harmony export */   SIZE_SMALL: () => (/* binding */ SIZE_SMALL),
/* harmony export */   TYPE_BODY: () => (/* binding */ TYPE_BODY),
/* harmony export */   TYPE_DISPLAY: () => (/* binding */ TYPE_DISPLAY),
/* harmony export */   TYPE_HEADLINE: () => (/* binding */ TYPE_HEADLINE),
/* harmony export */   TYPE_LABEL: () => (/* binding */ TYPE_LABEL),
/* harmony export */   TYPE_TITLE: () => (/* binding */ TYPE_TITLE),
/* harmony export */   VALID_SIZES: () => (/* binding */ VALID_SIZES),
/* harmony export */   VALID_TYPES: () => (/* binding */ VALID_TYPES)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const TYPE_DISPLAY = 'display';
const TYPE_HEADLINE = 'headline';
const TYPE_TITLE = 'title';
const TYPE_BODY = 'body';
const TYPE_LABEL = 'label';
const VALID_TYPES = [TYPE_BODY, TYPE_DISPLAY, TYPE_HEADLINE, TYPE_LABEL, TYPE_TITLE];
const SIZE_SMALL = 'small';
const SIZE_MEDIUM = 'medium';
const SIZE_LARGE = 'large';
const VALID_SIZES = [SIZE_SMALL, SIZE_MEDIUM, SIZE_LARGE];

/***/ }),

/***/ "./js/components/Typography/index.js":
/*!*******************************************!*\
  !*** ./js/components/Typography/index.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Typography)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/components/Typography/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


function Typography({
  className,
  type,
  size,
  as: Component = 'span',
  children,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(Component, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-typography', className, {
      [`googlesitekit-typography--${type}`]: type && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES.includes(type),
      [`googlesitekit-typography--${size}`]: size && _constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES.includes(size)
    }),
    ...props,
    children: children
  });
}
Typography.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  type: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_TYPES),
  size: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOf(_constants__WEBPACK_IMPORTED_MODULE_1__.VALID_SIZES),
  as: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)])
};

/***/ }),

/***/ "./js/components/VisuallyHidden.js":
/*!*****************************************!*\
  !*** ./js/components/VisuallyHidden.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Visually Hidden component, mainly used for screen-reader text.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function VisuallyHidden({
  className,
  children,
  ...otherProps
}) {
  if (!children) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('screen-reader-text', className),
    children: children
  });
}
VisuallyHidden.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
VisuallyHidden.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VisuallyHidden);

/***/ }),

/***/ "./js/components/conversion-tracking/SetupPluginConversionTrackingNotice.js":
/*!**********************************************************************************!*\
  !*** ./js/components/conversion-tracking/SetupPluginConversionTrackingNotice.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SetupPluginConversionTrackingNotice)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



function SetupPluginConversionTrackingNotice({
  className,
  message
}) {
  const isCTEnabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).isConversionTrackingEnabled());
  if (isCTEnabled || isCTEnabled === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("p", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'googlesitekit-color--surfaces-on-background-variant googlesitekit-plugin-conversion-tracking-notice'),
    children: message
  });
}

/***/ }),

/***/ "./js/components/notifications/CTA.js":
/*!********************************************!*\
  !*** ./js/components/notifications/CTA.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CTA component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function CTA({
  title,
  headerText,
  headerContent,
  description,
  ctaLink,
  ctaLabel,
  ctaLinkExternal,
  ctaType,
  error,
  onClick,
  'aria-label': ariaLabel,
  children
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-cta', {
      'googlesitekit-cta--error': error
    }),
    children: [(headerText || headerContent) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__header",
      children: [headerText && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h2",
        size: "small",
        type: "label",
        className: "googlesitekit-cta__header_text",
        children: headerText
      }), headerContent]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "googlesitekit-cta__body",
      children: [title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
        as: "h3",
        size: "small",
        type: "title",
        className: "googlesitekit-cta__title",
        children: title
      }), description && typeof description === 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("p", {
        className: "googlesitekit-cta__description",
        children: description
      }), description && typeof description !== 'string' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)("div", {
        className: "googlesitekit-cta__description",
        children: description
      }), ctaLabel && ctaType === 'button' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        "aria-label": ariaLabel,
        href: ctaLink,
        onClick: onClick,
        children: ctaLabel
      }), ctaLabel && ctaType === 'link' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: ctaLink,
        onClick: onClick,
        "aria-label": ariaLabel,
        external: ctaLinkExternal,
        hideExternalIndicator: ctaLinkExternal,
        arrow: true,
        children: ctaLabel
      }), children]
    })]
  });
}
CTA.propTypes = {
  title: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string).isRequired,
  headerText: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_5___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_5___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)]),
  ctaLink: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaLinkExternal: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  ctaLabel: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  ctaType: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  'aria-label': (prop_types__WEBPACK_IMPORTED_MODULE_5___default().string),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().bool),
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node),
  headerContent: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().node)
};
CTA.defaultProps = {
  title: '',
  headerText: '',
  headerContent: '',
  description: '',
  ctaLink: '',
  ctaLabel: '',
  ctaType: 'link',
  error: false,
  onClick: () => {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CTA);

/***/ }),

/***/ "./js/components/setup/StepHint/index.js":
/*!***********************************************!*\
  !*** ./js/components/setup/StepHint/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ StepHint)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/InfoTooltip */ "./js/components/InfoTooltip.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * SetupUsingProxyWithSignIn StepHint component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function StepHint({
  leadingText,
  tooltipText
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: "googlesitekit-setup__step-hint",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("p", {
      children: leadingText
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_InfoTooltip__WEBPACK_IMPORTED_MODULE_0__["default"], {
      tooltipClassName: "googlesitekit-setup__step-hint-tooltip",
      title: tooltipText
    })]
  });
}
StepHint.propTypes = {
  leadingText: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_2___default().element)]).isRequired,
  tooltipText: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_2___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_2___default().element)]).isRequired
};

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardActivateAnalyticsCTA.js":
/*!***********************************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardActivateAnalyticsCTA.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WPDashboardActivateAnalyticsCTA)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_ActivateAnalyticsCTA__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ActivateAnalyticsCTA */ "./js/components/ActivateAnalyticsCTA.js");
/* harmony import */ var _js_components_PreviewGraph__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/PreviewGraph */ "./js/components/PreviewGraph.js");
/* harmony import */ var _svg_graphics_cta_graph_traffic_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/svg/graphics/cta-graph-traffic.svg */ "./svg/graphics/cta-graph-traffic.svg");
/* harmony import */ var _svg_graphics_cta_most_popular_content_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/svg/graphics/cta-most-popular-content.svg */ "./svg/graphics/cta-most-popular-content.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WP Dashboard ActivateAnalyticsCTA component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





function WPDashboardActivateAnalyticsCTA() {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_js_components_ActivateAnalyticsCTA__WEBPACK_IMPORTED_MODULE_1__["default"], {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_PreviewGraph__WEBPACK_IMPORTED_MODULE_2__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Traffic', 'google-site-kit'),
      GraphSVG: _svg_graphics_cta_graph_traffic_svg__WEBPACK_IMPORTED_MODULE_3__["default"],
      showIcons: false
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_PreviewGraph__WEBPACK_IMPORTED_MODULE_2__["default"], {
      title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Most popular content', 'google-site-kit'),
      GraphSVG: _svg_graphics_cta_most_popular_content_svg__WEBPACK_IMPORTED_MODULE_4__["default"],
      showIcons: false
    })]
  });
}

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardApp.js":
/*!******************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardApp.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useIntersection.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/InViewProvider */ "./js/components/InViewProvider/index.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _WPDashboardWidgets__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./WPDashboardWidgets */ "./js/components/wp-dashboard/WPDashboardWidgets.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboardApp component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function WPDashboardApp() {
  const trackingRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useRef)();
  const intersectionEntry = (0,react_use__WEBPACK_IMPORTED_MODULE_8__["default"])(trackingRef, {
    threshold: 0 // Trigger "in-view" as soon as one pixel is visible.
  });
  const dashboardURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getAdminURL('googlesitekit-dashboard'));
  const [inViewState, setInViewState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useState)({
    key: 'WPDashboardApp',
    value: !!intersectionEntry?.intersectionRatio
  });
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    setInViewState({
      key: 'WPDashboardApp',
      value: !!intersectionEntry?.intersectionRatio
    });
  }, [intersectionEntry]);
  if (dashboardURL === undefined) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
      ref: trackingRef
    });
  }
  if (!dashboardURL) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_InViewProvider__WEBPACK_IMPORTED_MODULE_2__["default"], {
    value: inViewState,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-wp-dashboard",
      ref: trackingRef,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
        className: "googlesitekit-wp-dashboard__cta",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_3__["default"], {
          className: "googlesitekit-wp-dashboard__cta-link",
          href: dashboardURL,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Visit your Site Kit dashboard', 'google-site-kit')
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_WPDashboardWidgets__WEBPACK_IMPORTED_MODULE_5__["default"], {})]
    })
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WPDashboardApp);

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardClicks.js":
/*!*********************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardClicks.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_DataBlock__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/DataBlock */ "./js/components/DataBlock/index.js");
/* harmony import */ var _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/GatheringDataNotice */ "./js/components/GatheringDataNotice.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/search-console/datastore/constants */ "./js/modules/search-console/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_partition_report__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/partition-report */ "./js/util/partition-report.js");
/* harmony import */ var _js_util_sum_object_list_value__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util/sum-object-list-value */ "./js/util/sum-object-list-value.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboardClicks component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function WPDashboardClicks({
  WPDashboardReportError
}) {
  const isGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).isGatheringData());
  const {
    compareStartDate,
    endDate
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRangeDates({
    compare: true,
    offsetDays: _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.DATE_RANGE_OFFSET
  }));
  const dateRangeLength = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRangeNumberOfDays());
  const reportArgs = {
    startDate: compareStartDate,
    endDate,
    dimensions: 'date',
    reportID: 'dashboard_wp-dashboard-clicks_component_reportArgs'
  };
  const data = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).getReport(reportArgs), [reportArgs]);
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).getErrorForSelector('getReport', [reportArgs]));
  const loading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => !select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).hasFinishedResolution('getReport', [reportArgs]));
  if (loading || isGatheringData === undefined) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: "48%",
      height: "92px"
    });
  }
  if (error) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(WPDashboardReportError, {
      moduleSlug: "search-console",
      error: error
    });
  }
  const {
    compareRange,
    currentRange
  } = (0,_js_util_partition_report__WEBPACK_IMPORTED_MODULE_8__.partitionReport)(data, {
    dateRangeLength
  });
  const totalClicks = (0,_js_util_sum_object_list_value__WEBPACK_IMPORTED_MODULE_9__["default"])(currentRange, 'clicks');
  const totalOlderClicks = (0,_js_util_sum_object_list_value__WEBPACK_IMPORTED_MODULE_9__["default"])(compareRange, 'clicks');
  const totalClicksChange = (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.calculateChange)(totalOlderClicks, totalClicks);
  const gatheringDataProps = {
    gatheringData: isGatheringData,
    gatheringDataNoticeStyle: _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_3__.NOTICE_STYLE.SMALL
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_DataBlock__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: "googlesitekit-wp-dashboard-stats__data-table overview-total-clicks",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Total Clicks', 'google-site-kit'),
    datapoint: totalClicks,
    change: totalClicksChange,
    changeDataUnit: "%",
    ...gatheringDataProps
  });
}
WPDashboardClicks.propTypes = {
  WPDashboardReportError: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WPDashboardClicks);

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardImpressions.js":
/*!**************************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardImpressions.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_DataBlock__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/DataBlock */ "./js/components/DataBlock/index.js");
/* harmony import */ var _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/GatheringDataNotice */ "./js/components/GatheringDataNotice.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/search-console/datastore/constants */ "./js/modules/search-console/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_partition_report__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util/partition-report */ "./js/util/partition-report.js");
/* harmony import */ var _js_util_sum_object_list_value__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util/sum-object-list-value */ "./js/util/sum-object-list-value.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboardImpressions component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function WPDashboardImpressions({
  WPDashboardReportError
}) {
  const isGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).isGatheringData());
  const {
    compareStartDate,
    endDate
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRangeDates({
    compare: true,
    offsetDays: _js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.DATE_RANGE_OFFSET
  }));
  const dateRangeLength = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRangeNumberOfDays());
  const reportArgs = {
    startDate: compareStartDate,
    endDate,
    dimensions: 'date',
    reportID: 'dashboard_wp-dashboard-impressions_component_reportArgs'
  };
  const data = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).getReport(reportArgs), [reportArgs]);
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).getErrorForSelector('getReport', [reportArgs]));
  const loading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => !select(_js_modules_search_console_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_SEARCH_CONSOLE).hasFinishedResolution('getReport', [reportArgs]));
  if (loading || isGatheringData === undefined) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: "48%",
      height: "92px"
    });
  }
  if (error) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(WPDashboardReportError, {
      moduleSlug: "search-console",
      error: error
    });
  }
  const {
    compareRange,
    currentRange
  } = (0,_js_util_partition_report__WEBPACK_IMPORTED_MODULE_8__.partitionReport)(data, {
    dateRangeLength
  });
  const totalImpressions = (0,_js_util_sum_object_list_value__WEBPACK_IMPORTED_MODULE_9__["default"])(currentRange, 'impressions');
  const totalOlderImpressions = (0,_js_util_sum_object_list_value__WEBPACK_IMPORTED_MODULE_9__["default"])(compareRange, 'impressions');
  const totalImpressionsChange = (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.calculateChange)(totalOlderImpressions, totalImpressions);
  const gatheringDataProps = {
    gatheringData: isGatheringData,
    gatheringDataNoticeStyle: _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_3__.NOTICE_STYLE.SMALL
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_DataBlock__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: "googlesitekit-wp-dashboard-stats__data-table overview-total-impressions",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Total Impressions', 'google-site-kit'),
    datapoint: totalImpressions,
    change: totalImpressionsChange,
    changeDataUnit: "%",
    ...gatheringDataProps
  });
}
WPDashboardImpressions.propTypes = {
  WPDashboardReportError: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WPDashboardImpressions);

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardPopularPagesGA4.js":
/*!******************************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardPopularPagesGA4.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WPDashboardPopularPagesGA4)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_DetailsPermaLinks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/DetailsPermaLinks */ "./js/components/DetailsPermaLinks.js");
/* harmony import */ var _js_components_PreviewTable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/PreviewTable */ "./js/components/PreviewTable.js");
/* harmony import */ var _js_components_ReportTable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/ReportTable */ "./js/components/ReportTable.js");
/* harmony import */ var _js_components_TableOverflowContainer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/TableOverflowContainer */ "./js/components/TableOverflowContainer.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_components_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/modules/analytics-4/components/common */ "./js/modules/analytics-4/components/common/index.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboardPopularPagesGA4 component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */











function WPDashboardPopularPagesGA4({
  WPDashboardReportError
}) {
  const dateRangeDates = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_9__.CORE_USER).getDateRangeDates({
    offsetDays: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_11__.DATE_RANGE_OFFSET
  }));
  const isGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_11__.MODULES_ANALYTICS_4).isGatheringData());
  const reportArgs = {
    ...dateRangeDates,
    dimensions: ['pagePath'],
    metrics: [{
      name: 'screenPageViews'
    }],
    orderby: [{
      metric: {
        metricName: 'screenPageViews'
      },
      desc: true
    }],
    limit: 5,
    reportID: 'dashboard_wp-dashboard-popular-pages-ga4_component_reportArgs'
  };
  const report = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_11__.MODULES_ANALYTICS_4).getReport(reportArgs), [reportArgs]);
  const titles = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_11__.MODULES_ANALYTICS_4).getPageTitles(report, reportArgs), [report, reportArgs]);
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_11__.MODULES_ANALYTICS_4).getErrorForSelector('getReport', [reportArgs]));
  const loading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const hasLoadedPageTitles = undefined !== error || undefined !== titles;
    if (!hasLoadedPageTitles) {
      return true;
    }
    return !select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_11__.MODULES_ANALYTICS_4).hasFinishedResolution('getReport', [reportArgs]);
  });
  if (loading || isGatheringData === undefined) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_PreviewTable__WEBPACK_IMPORTED_MODULE_5__["default"], {
      rows: 6
    });
  }
  if (error) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(WPDashboardReportError, {
      moduleSlug: "analytics-4",
      error: error
    });
  }

  // data.rows is not guaranteed to be set so we need a fallback.
  const rows = report?.rows?.length ? (0,lodash__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(report.rows) : [];
  // Combine the titles from the pageTitles with the rows from the metrics report.
  rows.forEach(row => {
    const url = row.dimensionValues[0].value;
    row.dimensionValues.unshift({
      value: titles[url]
    }); // We always have an entry for titles[url].
  });
  const tableColumns = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Title', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Page Title', 'google-site-kit'),
    primary: true,
    Component({
      row
    }) {
      const [{
        value: title
      }, {
        value: url
      }] = row.dimensionValues;
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_DetailsPermaLinks__WEBPACK_IMPORTED_MODULE_4__["default"], {
        title: title,
        path: url
      });
    }
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Pageviews', 'google-site-kit'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Pageviews', 'google-site-kit'),
    field: 'metricValues.0.value',
    Component({
      fieldValue
    }) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)("span", {
        children: (0,_js_util__WEBPACK_IMPORTED_MODULE_12__.numFmt)(fieldValue, {
          style: 'decimal'
        })
      });
    }
  }];
  return /*#__PURE__*/ /* TODO: decouple the styles from search-console class */(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-search-console-widget', {
      'googlesitekit-search-console-widget--empty-data': isGatheringData || !rows?.length
    }),
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_8__["default"], {
      as: "h3",
      type: "headline",
      size: "small",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Top content over the last 28 days', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_TableOverflowContainer__WEBPACK_IMPORTED_MODULE_7__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx)(_js_components_ReportTable__WEBPACK_IMPORTED_MODULE_6__["default"], {
        rows: rows,
        columns: tableColumns,
        limit: 5,
        gatheringData: isGatheringData,
        zeroState: _js_modules_analytics_4_components_common__WEBPACK_IMPORTED_MODULE_10__.ZeroDataMessage
      })
    })]
  });
}
WPDashboardPopularPagesGA4.propTypes = {
  WPDashboardReportError: (prop_types__WEBPACK_IMPORTED_MODULE_14___default().elementType).isRequired
};

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardSessionDurationGA4.js":
/*!*********************************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardSessionDurationGA4.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_DataBlock__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/DataBlock */ "./js/components/DataBlock/index.js");
/* harmony import */ var _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/GatheringDataNotice */ "./js/components/GatheringDataNotice.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WP Dashboard Session Duration GA4 component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








function WPDashboardSessionDurationGA4({
  WPDashboardReportError
}) {
  const isGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).isGatheringData());
  const dateRangeDates = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRangeDates({
    compare: true,
    offsetDays: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.DATE_RANGE_OFFSET
  }));
  const reportArgs = {
    ...dateRangeDates,
    dimensions: [{
      name: 'date'
    }],
    limit: 10,
    metrics: [{
      name: 'averageSessionDuration'
    }],
    reportID: 'dashboard_wp-dashboard-session-duration-ga4_component_reportArgs'
  };
  const analytics4Data = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getReport(reportArgs), [reportArgs]);
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getErrorForSelector('getReport', [reportArgs]));
  const loading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => !select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).hasFinishedResolution('getReport', [reportArgs]));
  if (loading || isGatheringData === undefined) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: "48%",
      height: "92px"
    });
  }
  if (error) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(WPDashboardReportError, {
      moduleSlug: "analytics-4",
      error: error
    });
  }
  const {
    totals
  } = analytics4Data;
  const lastMonth = totals?.[0]?.metricValues?.[0]?.value;
  const previousMonth = totals?.[1]?.metricValues?.[0]?.value;
  const averageSessionDuration = lastMonth;
  const averageSessionDurationChange = (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.calculateChange)(previousMonth, lastMonth);
  const gatheringDataProps = {
    gatheringData: isGatheringData,
    gatheringDataNoticeStyle: _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_3__.NOTICE_STYLE.SMALL
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_DataBlock__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: "googlesitekit-wp-dashboard-stats__data-table overview-average-session-duration",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Avg. Time on Page', 'google-site-kit'),
    datapoint: averageSessionDuration,
    datapointUnit: "s",
    change: averageSessionDurationChange,
    changeDataUnit: "%",
    ...gatheringDataProps
  });
}
WPDashboardSessionDurationGA4.propTypes = {
  WPDashboardReportError: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().elementType).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WPDashboardSessionDurationGA4);

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardUniqueVisitorsChartGA4.js":
/*!*************************************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardUniqueVisitorsChartGA4.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WPDashboardUniqueVisitorsChartGA4)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_GoogleChart__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/GoogleChart */ "./js/components/GoogleChart/index.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_utils_extract_dashboard_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/utils/extract-dashboard-data */ "./js/modules/analytics-4/utils/extract-dashboard-data.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _chart_options__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart-options */ "./js/components/wp-dashboard/chart-options.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */










function WPDashboardUniqueVisitorsChartGA4(props) {
  const {
    WPDashboardReportError
  } = props;
  const isGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).isGatheringData());
  const googleChartsCollisionError = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_UI).getValue('googleChartsCollisionError'));
  const refDate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getReferenceDate());
  const {
    startDate,
    endDate,
    compareStartDate,
    compareEndDate
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRangeDates({
    compare: true,
    offsetDays: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.DATE_RANGE_OFFSET
  }));
  const dateRangeLength = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRangeNumberOfDays());
  const reportArgs = {
    startDate,
    endDate,
    compareStartDate,
    compareEndDate,
    metrics: [{
      name: 'totalUsers'
    }],
    dimensions: ['date'],
    orderby: [{
      dimension: {
        dimensionName: 'date'
      }
    }],
    reportID: 'dashboard_wp-dashboard-unique-visitors-ga4_component_reportArgs'
  };
  const data = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getReport(reportArgs), [reportArgs]);
  const loading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => !select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).hasFinishedResolution('getReport', [reportArgs]));
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getErrorForSelector('getReport', [reportArgs]));

  // If we can't load Google Charts, don't display this component at all.
  if (googleChartsCollisionError) {
    return null;
  }
  if (error) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(WPDashboardReportError, {
      moduleSlug: "analytics-4",
      error: error
    });
  }
  const googleChartData = (0,_js_modules_analytics_4_utils_extract_dashboard_data__WEBPACK_IMPORTED_MODULE_7__.extractAnalytics4DashboardData)(data, 0, dateRangeLength, refDate, [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Unique Visitors', 'google-site-kit')], [x => parseFloat(x).toLocaleString()]);
  const [, ...ticks] = googleChartData.slice(1).map(([date]) => date);
  const options = {
    ..._chart_options__WEBPACK_IMPORTED_MODULE_9__.UNIQUE_VISITORS_CHART_OPTIONS,
    hAxis: {
      ..._chart_options__WEBPACK_IMPORTED_MODULE_9__.UNIQUE_VISITORS_CHART_OPTIONS.hAxis,
      ticks
    }
  };
  const currentValueIndex = 2;
  const previousValueIndex = 3;
  const isZeroChart = !googleChartData.slice(1).some(datum => datum[currentValueIndex] > 0 || datum[previousValueIndex] > 0);
  if (isZeroChart) {
    options.hAxis.ticks = [(0,_js_util__WEBPACK_IMPORTED_MODULE_8__.stringToDate)(refDate)];
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)("div", {
    className: "googlesitekit-unique-visitors-chart-widget",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
      as: "h3",
      type: "headline",
      size: "small",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: number of days */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__._n)('Unique visitors over the last %s day', 'Unique visitors over the last %s days', dateRangeLength, 'google-site-kit'), dateRangeLength)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_GoogleChart__WEBPACK_IMPORTED_MODULE_2__["default"], {
      chartType: "LineChart",
      data: googleChartData,
      loadingHeight: "270px",
      loadingWidth: "100%",
      loaded: !(loading || isGatheringData === undefined),
      options: options,
      gatheringData: isGatheringData
    })]
  });
}
WPDashboardUniqueVisitorsChartGA4.propTypes = {
  WPDashboardReportError: (prop_types__WEBPACK_IMPORTED_MODULE_11___default().elementType).isRequired
};

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardUniqueVisitorsGA4.js":
/*!********************************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardUniqueVisitorsGA4.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_DataBlock__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/DataBlock */ "./js/components/DataBlock/index.js");
/* harmony import */ var _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/GatheringDataNotice */ "./js/components/GatheringDataNotice.js");
/* harmony import */ var _js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/PreviewBlock */ "./js/components/PreviewBlock.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboardUniqueVisitorsGA4 component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








function WPDashboardUniqueVisitorsGA4({
  WPDashboardReportError
}) {
  const isGatheringData = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).isGatheringData());
  const dateRangeDates = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_USER).getDateRangeDates({
    compare: true,
    offsetDays: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.DATE_RANGE_OFFSET
  }));
  const reportArgs = {
    ...dateRangeDates,
    metrics: [{
      name: 'totalUsers'
    }],
    reportID: 'dashboard_wp-dashboard-unique-visitors-ga4_component_reportArgs'
  };
  const data = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useInViewSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getReport(reportArgs), [reportArgs]);
  const error = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getErrorForSelector('getReport', [reportArgs]));
  const loading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => !select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).hasFinishedResolution('getReport', [reportArgs]));
  if (loading || isGatheringData === undefined) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_PreviewBlock__WEBPACK_IMPORTED_MODULE_4__["default"], {
      width: "48%",
      height: "92px"
    });
  }
  if (error) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(WPDashboardReportError, {
      moduleSlug: "analytics-4",
      error: error
    });
  }
  const totalUsers = data?.totals?.[0]?.metricValues?.[0]?.value;
  const previousTotalUsers = data?.totals?.[1]?.metricValues?.[0]?.value;
  const gatheringDataProps = {
    gatheringData: isGatheringData,
    gatheringDataNoticeStyle: _js_components_GatheringDataNotice__WEBPACK_IMPORTED_MODULE_3__.NOTICE_STYLE.SMALL
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(_js_components_DataBlock__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: "googlesitekit-wp-dashboard-stats__data-table overview-total-users",
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Total Unique Visitors', 'google-site-kit'),
    datapoint: totalUsers,
    change: (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.calculateChange)(previousTotalUsers, totalUsers),
    changeDataUnit: "%",
    ...gatheringDataProps
  });
}
WPDashboardUniqueVisitorsGA4.propTypes = {
  WPDashboardReportError: (prop_types__WEBPACK_IMPORTED_MODULE_9___default().elementType).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WPDashboardUniqueVisitorsGA4);

/***/ }),

/***/ "./js/components/wp-dashboard/WPDashboardWidgets.js":
/*!**********************************************************!*\
  !*** ./js/components/wp-dashboard/WPDashboardWidgets.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WPDashboardWidgets)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_DataBlockGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/DataBlockGroup */ "./js/components/DataBlockGroup.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_widgets_util_get_widget_component_props__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/widgets/util/get-widget-component-props */ "./js/googlesitekit/widgets/util/get-widget-component-props.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/* harmony import */ var _WPDashboardActivateAnalyticsCTA__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./WPDashboardActivateAnalyticsCTA */ "./js/components/wp-dashboard/WPDashboardActivateAnalyticsCTA.js");
/* harmony import */ var _WPDashboardClicks__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./WPDashboardClicks */ "./js/components/wp-dashboard/WPDashboardClicks.js");
/* harmony import */ var _WPDashboardImpressions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./WPDashboardImpressions */ "./js/components/wp-dashboard/WPDashboardImpressions.js");
/* harmony import */ var _WPDashboardPopularPagesGA4__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./WPDashboardPopularPagesGA4 */ "./js/components/wp-dashboard/WPDashboardPopularPagesGA4.js");
/* harmony import */ var _WPDashboardSessionDurationGA4__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./WPDashboardSessionDurationGA4 */ "./js/components/wp-dashboard/WPDashboardSessionDurationGA4.js");
/* harmony import */ var _WPDashboardUniqueVisitorsChartGA4__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./WPDashboardUniqueVisitorsChartGA4 */ "./js/components/wp-dashboard/WPDashboardUniqueVisitorsChartGA4.js");
/* harmony import */ var _WPDashboardUniqueVisitorsGA4__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./WPDashboardUniqueVisitorsGA4 */ "./js/components/wp-dashboard/WPDashboardUniqueVisitorsGA4.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboardWidgets component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */















// Widget slugs.

const WIDGET_IMPRESSIONS = 'wpDashboardImpressions';
const WIDGET_CLICKS = 'wpDashboardClicks';
const WIDGET_VISITORS = 'wpDashboardUniqueVisitors';
const WIDGET_VISITORS_CHART = 'wpDashboardUniqueVisitorsChart';
const WIDGET_SESSION_DURATION = 'wpDashboardSessionDuration';
const WIDGET_POPULAR_PAGES = 'wpDashboardPopularPages';

// Search Console widgets.
const WPDashboardImpressionsWidget = (0,_js_googlesitekit_widgets_util_get_widget_component_props__WEBPACK_IMPORTED_MODULE_5__.withWPDashboardWidgetComponentProps)(WIDGET_IMPRESSIONS)(_WPDashboardImpressions__WEBPACK_IMPORTED_MODULE_10__["default"]);
const WPDashboardClicksWidget = (0,_js_googlesitekit_widgets_util_get_widget_component_props__WEBPACK_IMPORTED_MODULE_5__.withWPDashboardWidgetComponentProps)(WIDGET_CLICKS)(_WPDashboardClicks__WEBPACK_IMPORTED_MODULE_9__["default"]);

// Analytics 4 Widgets.
const WPDashboardUniqueVisitorsGA4Widget = (0,_js_googlesitekit_widgets_util_get_widget_component_props__WEBPACK_IMPORTED_MODULE_5__.withWPDashboardWidgetComponentProps)(WIDGET_VISITORS)(_WPDashboardUniqueVisitorsGA4__WEBPACK_IMPORTED_MODULE_14__["default"]);
const WPDashboardSessionDurationGA4Widget = (0,_js_googlesitekit_widgets_util_get_widget_component_props__WEBPACK_IMPORTED_MODULE_5__.withWPDashboardWidgetComponentProps)(WIDGET_SESSION_DURATION)(_WPDashboardSessionDurationGA4__WEBPACK_IMPORTED_MODULE_12__["default"]);
const WPDashboardPopularPagesGA4Widget = (0,_js_googlesitekit_widgets_util_get_widget_component_props__WEBPACK_IMPORTED_MODULE_5__.withWPDashboardWidgetComponentProps)(WIDGET_POPULAR_PAGES)(_WPDashboardPopularPagesGA4__WEBPACK_IMPORTED_MODULE_11__["default"]);
const WPDashboardUniqueVisitorsChartGA4Widget = (0,_js_googlesitekit_widgets_util_get_widget_component_props__WEBPACK_IMPORTED_MODULE_5__.withWPDashboardWidgetComponentProps)(WIDGET_VISITORS_CHART)(_WPDashboardUniqueVisitorsChartGA4__WEBPACK_IMPORTED_MODULE_13__["default"]);
function WPDashboardWidgets() {
  const analyticsModule = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_MODULES).getModule(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_ANALYTICS_4));
  const canViewSharedAnalytics = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).hasAccessToShareableModule(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_6__.MODULE_SLUG_ANALYTICS_4));
  const canViewSharedSearchConsole = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_USER).hasAccessToShareableModule(_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_7__.MODULE_SLUG_SEARCH_CONSOLE));
  if (analyticsModule === undefined) {
    return null;
  }
  const {
    active: analyticsModuleActive,
    connected: analyticsModuleConnected
  } = analyticsModule;
  const analyticsModuleActiveAndConnected = analyticsModuleActive && analyticsModuleConnected;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_js_components_DataBlockGroup__WEBPACK_IMPORTED_MODULE_2__["default"], {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-wp-dashboard-stats googlesitekit-wp-dashboard-stats--twoup', {
      'googlesitekit-wp-dashboard-stats--fourup': analyticsModuleActiveAndConnected
    }),
    children: [analyticsModuleActiveAndConnected && canViewSharedAnalytics && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(WPDashboardUniqueVisitorsGA4Widget, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(WPDashboardSessionDurationGA4Widget, {})]
    }), canViewSharedSearchConsole && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(WPDashboardImpressionsWidget, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(WPDashboardClicksWidget, {})]
    }), !analyticsModuleActiveAndConnected && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)("div", {
      className: "googlesitekit-wp-dashboard-stats__cta",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(_WPDashboardActivateAnalyticsCTA__WEBPACK_IMPORTED_MODULE_8__["default"], {})
    }), analyticsModuleActiveAndConnected && canViewSharedAnalytics && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(WPDashboardUniqueVisitorsChartGA4Widget, {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_15__.jsx)(WPDashboardPopularPagesGA4Widget, {})]
    })]
  });
}

/***/ }),

/***/ "./js/components/wp-dashboard/chart-options.js":
/*!*****************************************************!*\
  !*** ./js/components/wp-dashboard/chart-options.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UNIQUE_VISITORS_CHART_OPTIONS: () => (/* binding */ UNIQUE_VISITORS_CHART_OPTIONS)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

const UNIQUE_VISITORS_CHART_OPTIONS = {
  animation: {
    startup: true
  },
  chart: {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Unique visitors', 'google-site-kit')
  },
  curveType: 'function',
  height: 270,
  width: '100%',
  chartArea: {
    height: '80%',
    left: 20,
    right: 20
  },
  legend: {
    position: 'top',
    textStyle: {
      color: '#616161',
      fontSize: 12
    }
  },
  hAxis: {
    format: 'MMM d',
    gridlines: {
      color: '#fff'
    },
    textStyle: {
      color: '#616161',
      fontSize: 12
    }
  },
  vAxis: {
    textPosition: 'none',
    viewWindow: {
      min: 0
    },
    gridlines: {
      color: '#eee'
    }
  },
  series: {
    0: {
      color: '#6380b8',
      targetAxisIndex: 0
    },
    1: {
      color: '#6380b8',
      targetAxisIndex: 0,
      lineDashStyle: [3, 3],
      lineWidth: 1
    }
  },
  focusTarget: 'category',
  crosshair: {
    color: 'gray',
    opacity: 0.1,
    orientation: 'vertical',
    trigger: 'both'
  },
  tooltip: {
    isHtml: true,
    // eslint-disable-line sitekit/acronym-case
    trigger: 'both'
  }
};

/***/ }),

/***/ "./js/features/index.js":
/*!******************************!*\
  !*** ./js/features/index.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enabledFeatures: () => (/* binding */ enabledFeatures),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled)
/* harmony export */ });
/**
 * Feature flags.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const enabledFeatures = new Set(__webpack_require__.g?._googlesitekitBaseData?.enabledFeatures || []);

/**
 * Returns true if a feature is enabled; false otherwise.
 *
 * @since 1.25.0
 * @since 1.33.0 Changed _enabledFeatures argument to be a `Set` instead of `Array`.
 *
 * @param {string} feature            The name of the feature to check.
 * @param {Set}    [_enabledFeatures] Optional. The set of enabled features. Uses `enabledFeatures` set by the server in a global JS variable, by default.
 * @return {boolean} `true` if a feature is enabled; `false` otherwise.
 */
function isFeatureEnabled(feature, _enabledFeatures = enabledFeatures) {
  if (!(_enabledFeatures instanceof Set)) {
    return false;
  }
  return _enabledFeatures.has(feature);
}

/***/ }),

/***/ "./js/googlesitekit-wp-dashboard.js":
/*!******************************************!*\
  !*** ./js/googlesitekit-wp-dashboard.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/dom-ready */ "../node_modules/@wordpress/dom-ready/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react-dom/index.js");
/* harmony import */ var _components_Root__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/Root */ "./js/components/Root/index.js");
/* harmony import */ var _components_wp_dashboard_WPDashboardApp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/wp-dashboard/WPDashboardApp */ "./js/components/wp-dashboard/WPDashboardApp.js");
/* harmony import */ var _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboard component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* eslint camelcase:[0] */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




// Initialize the app once the DOM is ready.

(0,_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
  const renderTarget = document.getElementById('js-googlesitekit-wp-dashboard');
  if (renderTarget) {
    const {
      viewOnly
    } = renderTarget.dataset;
    const viewContext = viewOnly ? _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__.VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY : _googlesitekit_constants__WEBPACK_IMPORTED_MODULE_2__.VIEW_CONTEXT_WP_DASHBOARD;
    (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.render)(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_components_Root__WEBPACK_IMPORTED_MODULE_0__["default"], {
      viewContext: viewContext,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_components_wp_dashboard_WPDashboardApp__WEBPACK_IMPORTED_MODULE_1__["default"], {})
    }), renderTarget);
  }
});

/***/ }),

/***/ "./js/googlesitekit/api/cache.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/api/cache.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STORAGE_KEY_PREFIX: () => (/* binding */ STORAGE_KEY_PREFIX),
/* harmony export */   STORAGE_KEY_PREFIX_ROOT: () => (/* binding */ STORAGE_KEY_PREFIX_ROOT),
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   deleteItem: () => (/* binding */ deleteItem),
/* harmony export */   getItem: () => (/* binding */ getItem),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   isStorageAvailable: () => (/* binding */ isStorageAvailable),
/* harmony export */   resetDefaultStorageOrder: () => (/* binding */ resetDefaultStorageOrder),
/* harmony export */   setItem: () => (/* binding */ setItem),
/* harmony export */   setSelectedStorageBackend: () => (/* binding */ setSelectedStorageBackend),
/* harmony export */   setStorageOrder: () => (/* binding */ setStorageOrder)
/* harmony export */ });
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Caching functions and cache management for API requests.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Prefix used for all Site Kit keys.
 *
 * Anything not using this prefix should not be touched by this library.
 *
 * @since 1.96.0
 * @private
 */
const STORAGE_KEY_PREFIX_ROOT = 'googlesitekit_';

/**
 * Prefix used for all Site Kit keys for the current Site Kit version.
 *
 * Anything not using this key should not be touched by this library.
 *
 * @since 1.5.0
 * @since 1.92.0 Updated to include a user, session, and blog-specific hash.
 * @since 1.96.0 Updated to make use of the new STORAGE_KEY_PREFIX_ROOT constant.
 * @private
 */
const STORAGE_KEY_PREFIX = `${STORAGE_KEY_PREFIX_ROOT}${"1.168.0"}_${__webpack_require__.g._googlesitekitBaseData.storagePrefix}_`;
const defaultOrder = ['sessionStorage', 'localStorage'];
let storageBackend;
let storageOrder = [...defaultOrder];

/**
 * Overrides the storage backend.
 *
 * Largely used for tests. Should not be used directly.
 *
 * @since 1.5.0
 * @private
 *
 * @param {*} backend Backend to set for the cache.
 */
function setSelectedStorageBackend(backend) {
  storageBackend = backend;
}

/**
 * Overrides the priority of storage mechanisms.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 *
 * @param {Array} order Ordered array of storage backends to use.
 */
function setStorageOrder(order) {
  storageOrder = [...order];
  setSelectedStorageBackend(undefined);
}

/**
 * Resets the storage mechanism order.
 *
 * Largely used for tests. Implicitly resets the selected storage backend,
 * causing `_getStorage` to re-run its checks for the best available
 * storage backend.
 *
 * @since 1.5.0
 * @private
 */
function resetDefaultStorageOrder() {
  storageOrder = [...defaultOrder];
  setSelectedStorageBackend(undefined);
}

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.5.0
 * @private
 *
 * @param {string} type Browser storage to test. Should be one of `localStorage` or `sessionStorage`.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
// eslint-disable-next-line require-await
async function isStorageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

/**
 * Gets the storage object to use.
 *
 * @since 1.5.0
 * @private
 *
 * @return {Storage|null} A storage mechanism (`localStorage` or `sessionStorage`) if available; otherwise returns `null`.
 */
async function getStorage() {
  if (storageBackend !== undefined) {
    return storageBackend;
  }

  // Only run the logic to determine the storage object once.
  for (const backend of storageOrder) {
    if (storageBackend) {
      continue;
    }
    if (await isStorageAvailable(backend)) {
      storageBackend = __webpack_require__.g[backend];
    }
  }
  if (storageBackend === undefined) {
    storageBackend = null;
  }
  return storageBackend;
}

/**
 * Gets cached data.
 *
 * Get cached data from the persistent storage cache.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise returned, containing an object with the cached value (if found) and whether or not there was a cache hit.
 */
async function getItem(key) {
  const storage = await getStorage();
  if (storage) {
    const cachedData = storage.getItem(`${STORAGE_KEY_PREFIX}${key}`);
    if (cachedData) {
      const parsedData = JSON.parse(cachedData);
      const {
        timestamp,
        ttl,
        value,
        isError
      } = parsedData;

      // Ensure a timestamp is found, otherwise this isn't a valid cache hit.
      // (We don't check for a truthy `value`, because it could be legitimately
      // false-y if `0`, `null`, etc.)
      if (timestamp && (!ttl ||
      // Ensure the cached data isn't too old.
      // The cache dates shouldn't rely on reference
      // dates for cache expiration. This is a case
      // where we actually want to rely on
      // the _actual_ date/time the data was set.
      Math.round(Date.now() / 1000) - timestamp < ttl) // eslint-disable-line sitekit/no-direct-date
      ) {
        return {
          cacheHit: true,
          value,
          isError
        };
      }
    }
  }
  return {
    cacheHit: false,
    value: undefined
  };
}

/**
 * Sets cached data using a key.
 *
 * Save data to the relevant local storage mechanism, if available.
 * By default, data is saved with a one hour (60 minute) TTL.
 *
 * @since 1.5.0
 *
 * @param {string}  key              Name of cache key.
 * @param {*}       value            Value to store in the cache.
 * @param {Object}  args             Optional object containing ttl, timestamp and isError keys.
 * @param {number}  [args.ttl]       Optional. Validity of the cached item in seconds.
 * @param {number}  [args.timestamp] Optional. Timestamp when the cached item was created.
 * @param {boolean} [args.isError]   Optional. Whether the cached item is an error.
 * @return {Promise} A promise: resolves to `true` if the value was saved; `false` if not (usually because no storage method was available).
 */
async function setItem(key, value, {
  ttl = _js_util__WEBPACK_IMPORTED_MODULE_0__.HOUR_IN_SECONDS,
  // Cached times should rely on real times, not the reference date,
  // so the cache timeouts are consistent even when changing
  // the reference dates when developing/testing.
  timestamp = Math.round(Date.now() / 1000),
  // eslint-disable-line sitekit/no-direct-date
  isError = false
} = {}) {
  const storage = await getStorage();
  if (storage) {
    try {
      storage.setItem(`${STORAGE_KEY_PREFIX}${key}`, JSON.stringify({
        timestamp,
        ttl,
        value,
        isError
      }));
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Removes cached data by key.
 *
 * Remove one piece of cached data from the persistent storage cache, by key.
 *
 * @since 1.5.0
 *
 * @param {string} key Name of cache key.
 * @return {Promise} A promise: resolves to `true` if the value was deleted; `false` if not (usually because no storage method was available).
 */
async function deleteItem(key) {
  const storage = await getStorage();
  if (storage) {
    try {
      const fullKey = key.startsWith(STORAGE_KEY_PREFIX_ROOT) ? key : `${STORAGE_KEY_PREFIX}${key}`;
      storage.removeItem(fullKey);
      return true;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return false;
    }
  }
  return false;
}

/**
 * Gets all cache keys created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to an array of all keys.
 */
async function getKeys() {
  const storage = await getStorage();
  if (storage) {
    try {
      const keys = [];
      for (let i = 0; i < storage.length; i++) {
        const itemKey = storage.key(i);
        if (itemKey.indexOf(STORAGE_KEY_PREFIX_ROOT) === 0) {
          keys.push(itemKey);
        }
      }
      return keys;
    } catch (error) {
      __webpack_require__.g.console.warn('Encountered an unexpected storage error:', error);
      return [];
    }
  }
  return [];
}

/**
 * Removes the entire cache created by Site Kit.
 *
 * @since 1.5.0
 *
 * @return {Promise} A promise: resolves to `true` if the cache was cleared; `false` if there was an error.
 */
async function clearCache() {
  const storage = await getStorage();
  if (storage) {
    const keys = await getKeys();
    for (const key of keys) {
      await deleteItem(key);
    }
    return true;
  }
  return false;
}

/***/ }),

/***/ "./js/googlesitekit/constants.js":
/*!***************************************!*\
  !*** ./js/googlesitekit/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ANCHOR_ID_CONTENT: () => (/* binding */ ANCHOR_ID_CONTENT),
/* harmony export */   ANCHOR_ID_KEY_METRICS: () => (/* binding */ ANCHOR_ID_KEY_METRICS),
/* harmony export */   ANCHOR_ID_MONETIZATION: () => (/* binding */ ANCHOR_ID_MONETIZATION),
/* harmony export */   ANCHOR_ID_SPEED: () => (/* binding */ ANCHOR_ID_SPEED),
/* harmony export */   ANCHOR_ID_TRAFFIC: () => (/* binding */ ANCHOR_ID_TRAFFIC),
/* harmony export */   SITE_KIT_VIEW_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_CONTEXTS),
/* harmony export */   SITE_KIT_VIEW_ONLY_CONTEXTS: () => (/* binding */ SITE_KIT_VIEW_ONLY_CONTEXTS),
/* harmony export */   VIEW_CONTEXT_ACTIVATION: () => (/* binding */ VIEW_CONTEXT_ACTIVATION),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR),
/* harmony export */   VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_AD_BLOCKING_RECOVERY: () => (/* binding */ VIEW_CONTEXT_AD_BLOCKING_RECOVERY),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_KEY_METRICS_SETUP: () => (/* binding */ VIEW_CONTEXT_KEY_METRICS_SETUP),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY),
/* harmony export */   VIEW_CONTEXT_METRIC_SELECTION: () => (/* binding */ VIEW_CONTEXT_METRIC_SELECTION),
/* harmony export */   VIEW_CONTEXT_MODULE: () => (/* binding */ VIEW_CONTEXT_MODULE),
/* harmony export */   VIEW_CONTEXT_MODULE_SETUP: () => (/* binding */ VIEW_CONTEXT_MODULE_SETUP),
/* harmony export */   VIEW_CONTEXT_POSTS_LIST: () => (/* binding */ VIEW_CONTEXT_POSTS_LIST),
/* harmony export */   VIEW_CONTEXT_SETTINGS: () => (/* binding */ VIEW_CONTEXT_SETTINGS),
/* harmony export */   VIEW_CONTEXT_SPLASH: () => (/* binding */ VIEW_CONTEXT_SPLASH),
/* harmony export */   VIEW_CONTEXT_USER_INPUT: () => (/* binding */ VIEW_CONTEXT_USER_INPUT),
/* harmony export */   VIEW_CONTEXT_WP_BLOCK_EDITOR: () => (/* binding */ VIEW_CONTEXT_WP_BLOCK_EDITOR),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD),
/* harmony export */   VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY: () => (/* binding */ VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY)
/* harmony export */ });
/**
 * Core constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const VIEW_CONTEXT_MAIN_DASHBOARD = 'mainDashboard';
const VIEW_CONTEXT_ENTITY_DASHBOARD = 'entityDashboard';
const VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY = 'mainDashboardViewOnly';
const VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY = 'entityDashboardViewOnly';
const VIEW_CONTEXT_POSTS_LIST = 'postsList';
const VIEW_CONTEXT_USER_INPUT = 'userInput';
const VIEW_CONTEXT_ACTIVATION = 'activation';
const VIEW_CONTEXT_SPLASH = 'splash';
const VIEW_CONTEXT_ADMIN_BAR = 'adminBar';
const VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY = 'adminBarViewOnly';
const VIEW_CONTEXT_SETTINGS = 'settings';
const VIEW_CONTEXT_AD_BLOCKING_RECOVERY = 'adBlockingRecovery';
const VIEW_CONTEXT_MODULE = 'module';
const VIEW_CONTEXT_WP_DASHBOARD = 'wpDashboard';
const VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY = 'wpDashboardViewOnly';
const VIEW_CONTEXT_MODULE_SETUP = 'moduleSetup';
const VIEW_CONTEXT_METRIC_SELECTION = 'metricSelection';
const VIEW_CONTEXT_WP_BLOCK_EDITOR = 'wpBlockEditor';
const VIEW_CONTEXT_KEY_METRICS_SETUP = 'keyMetricsSetup';

// Anchor ID Constants
const ANCHOR_ID_KEY_METRICS = 'key-metrics';
const ANCHOR_ID_TRAFFIC = 'traffic';
const ANCHOR_ID_CONTENT = 'content';
const ANCHOR_ID_SPEED = 'speed';
const ANCHOR_ID_MONETIZATION = 'monetization';

// Site Kit only view contexts
const SITE_KIT_VIEW_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD, VIEW_CONTEXT_ENTITY_DASHBOARD, VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_USER_INPUT, VIEW_CONTEXT_SPLASH, VIEW_CONTEXT_SETTINGS, VIEW_CONTEXT_MODULE_SETUP, VIEW_CONTEXT_METRIC_SELECTION];

// Site Kit view-only contexts
const SITE_KIT_VIEW_ONLY_CONTEXTS = [VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY, VIEW_CONTEXT_ADMIN_BAR_VIEW_ONLY, VIEW_CONTEXT_WP_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/data/create-snapshot-store.js":
/*!********************************************************!*\
  !*** ./js/googlesitekit/data/create-snapshot-store.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSnapshotStore: () => (/* binding */ createSnapshotStore),
/* harmony export */   getStoresWithSnapshots: () => (/* binding */ getStoresWithSnapshots),
/* harmony export */   restoreAllSnapshots: () => (/* binding */ restoreAllSnapshots),
/* harmony export */   snapshotAllStores: () => (/* binding */ snapshotAllStores)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * Provides a datastore for snapshotting and restoring state.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




// Actions
const CREATE_SNAPSHOT = 'CREATE_SNAPSHOT';
const DELETE_SNAPSHOT = 'DELETE_SNAPSHOT';
const RESTORE_SNAPSHOT = 'RESTORE_SNAPSHOT';
const SET_STATE_FROM_SNAPSHOT = 'SET_STATE_FROM_SNAPSHOT';

/**
 * Creates a store object that includes actions and controls for restoring/creating state snapshots.
 *
 * @since 1.9.0
 * @since 1.163.0 Added the ability to pick specific parts of the state to save in the snapshot.
 * @private
 *
 * @param {string}          storeName                The name of the store to snapshot in the cache.
 * @param {Object}          [options]                Optional configuration object.
 * @param {string|string[]} [options.keysToSnapshot] Property path(s) to pick from state when creating snapshots.
 * @return {Object} The snapshot store object.
 */
function createSnapshotStore(storeName, {
  keysToSnapshot
} = {}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(storeName, 'storeName is required to create a snapshot store.');
  const initialState = {};
  const actions = {
    /**
     * Deletes a snapshot of state for a storeName, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache deletion response.
     */
    *deleteSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: DELETE_SNAPSHOT
      };
      return cacheResult;
    },
    /**
     * Restores a snapshot of state for a storeName, if available, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @param {Object}  [options]                   Options object.
     * @param {boolean} [options.clearAfterRestore] Whether or not to delete snapshot after restore. Default: true.
     * @return {boolean} Cache restoration response.
     */
    *restoreSnapshot(options = {}) {
      const {
        clearAfterRestore = true
      } = options;
      const {
        cacheHit,
        value
      } = yield {
        payload: {},
        type: RESTORE_SNAPSHOT
      };
      if (cacheHit) {
        yield {
          payload: {
            snapshot: value
          },
          type: SET_STATE_FROM_SNAPSHOT
        };
        if (clearAfterRestore) {
          yield {
            payload: {},
            type: DELETE_SNAPSHOT
          };
        }
      }
      return cacheHit;
    },
    /**
     * Creates a snapshot of the current state of this store, using our cache API.
     *
     * @since 1.9.0
     * @private
     *
     * @return {boolean} Cache write response.
     */
    *createSnapshot() {
      const cacheResult = yield {
        payload: {},
        type: CREATE_SNAPSHOT
      };
      return cacheResult;
    }
  };
  const controls = {
    [DELETE_SNAPSHOT]: () => {
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.deleteItem)(`datastore::cache::${storeName}`);
    },
    [CREATE_SNAPSHOT]: (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.createRegistryControl)(registry => () => {
      const state = registry.stores[storeName].store.getState();
      const stateToSnapshot = keysToSnapshot?.length > 0 ? (0,lodash__WEBPACK_IMPORTED_MODULE_1__.pick)(state, keysToSnapshot) : state;
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.setItem)(`datastore::cache::${storeName}`, stateToSnapshot);
    }),
    [RESTORE_SNAPSHOT]: () => {
      // Only get snapshots made within the last hour.
      return (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_3__.getItem)(`datastore::cache::${storeName}`, _js_util__WEBPACK_IMPORTED_MODULE_4__.HOUR_IN_SECONDS);
    }
  };
  function reducer(state = initialState, {
    type,
    payload
  }) {
    // eslint-disable-line no-shadow
    switch (type) {
      case SET_STATE_FROM_SNAPSHOT:
        {
          const {
            snapshot
          } = payload;
          // Exclude any top-level errors from the restored state.
          // eslint-disable-next-line no-unused-vars
          const {
            error,
            ...newState
          } = snapshot;

          // If only a part of the state has been added to the snapshot, then
          // we should update the initial state with partial data restored
          // from the snapshot.
          if (keysToSnapshot?.length > 0) {
            return {
              ...state,
              ...newState
            };
          }
          return newState;
        }
      default:
        {
          return state;
        }
    }
  }
  return {
    initialState,
    actions,
    controls,
    reducer
  };
}

/**
 * Inspects a registry to find all stores that support our snapshot features.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} registry Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Object} The snapshot store object.
 */
function getStoresWithSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Object.values(registry.stores).filter(store => {
    return Object.keys(store.getActions()).includes('restoreSnapshot');
  });
}

/**
 * Creates snapshots of all supporting stores.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been taken.
 */
function snapshotAllStores(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().createSnapshot();
  }));
}

/**
 * Restores state for all snapshots that support it.
 *
 * Only restores snapshots for stores that have `restoreSnapshot` action, and
 * clears the snapshot afterward, so more stores will not be restored unless
 * a snapshot was saved on the last pageview.
 *
 * @since 1.9.0
 * @private
 *
 * @param {wp.data.registry} [registry] Optional. Registry object to inspect for stores that support state restoration. Defaults to `googlesitekit.data`.
 * @return {Promise} Promise resolves once all snapshots have been restored.
 */
function restoreAllSnapshots(registry = (googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default())) {
  return Promise.all(getStoresWithSnapshots(registry).map(store => {
    return store.getActions().restoreSnapshot();
  }));
}

/***/ }),

/***/ "./js/googlesitekit/datastore/forms/constants.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/datastore/forms/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_FORMS: () => (/* binding */ CORE_FORMS)
/* harmony export */ });
/**
 * `core/forms` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_FORMS = 'core/forms';

/***/ }),

/***/ "./js/googlesitekit/datastore/location/constants.js":
/*!**********************************************************!*\
  !*** ./js/googlesitekit/datastore/location/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_LOCATION: () => (/* binding */ CORE_LOCATION)
/* harmony export */ });
/**
 * `core/location` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_LOCATION = 'core/location';

/***/ }),

/***/ "./js/googlesitekit/datastore/site/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/site/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AMP_MODE_PRIMARY: () => (/* binding */ AMP_MODE_PRIMARY),
/* harmony export */   AMP_MODE_SECONDARY: () => (/* binding */ AMP_MODE_SECONDARY),
/* harmony export */   CORE_SITE: () => (/* binding */ CORE_SITE)
/* harmony export */ });
/**
 * `core/site` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_SITE = 'core/site';
const AMP_MODE_PRIMARY = 'primary';
const AMP_MODE_SECONDARY = 'secondary';

/***/ }),

/***/ "./js/googlesitekit/datastore/ui/constants.js":
/*!****************************************************!*\
  !*** ./js/googlesitekit/datastore/ui/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVE_CONTEXT_ID: () => (/* binding */ ACTIVE_CONTEXT_ID),
/* harmony export */   CORE_UI: () => (/* binding */ CORE_UI)
/* harmony export */ });
/**
 * `core/ui` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_UI = 'core/ui';
const ACTIVE_CONTEXT_ID = 'activeContextID';

/***/ }),

/***/ "./js/googlesitekit/datastore/user/constants.js":
/*!******************************************************!*\
  !*** ./js/googlesitekit/datastore/user/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_USER: () => (/* binding */ CORE_USER),
/* harmony export */   DISCONNECTED_REASON_CONNECTED_URL_MISMATCH: () => (/* binding */ DISCONNECTED_REASON_CONNECTED_URL_MISMATCH),
/* harmony export */   EMAIL_REPORT_FREQUENCIES: () => (/* binding */ EMAIL_REPORT_FREQUENCIES),
/* harmony export */   ERROR_CODE_ADBLOCKER_ACTIVE: () => (/* binding */ ERROR_CODE_ADBLOCKER_ACTIVE),
/* harmony export */   FORM_TEMPORARY_PERSIST_PERMISSION_ERROR: () => (/* binding */ FORM_TEMPORARY_PERSIST_PERMISSION_ERROR),
/* harmony export */   GLOBAL_SURVEYS_TIMEOUT_SLUG: () => (/* binding */ GLOBAL_SURVEYS_TIMEOUT_SLUG),
/* harmony export */   KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT: () => (/* binding */ KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT),
/* harmony export */   KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_LEAST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_LEAST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_MOST_ENGAGING_PAGES: () => (/* binding */ KM_ANALYTICS_MOST_ENGAGING_PAGES),
/* harmony export */   KM_ANALYTICS_NEW_VISITORS: () => (/* binding */ KM_ANALYTICS_NEW_VISITORS),
/* harmony export */   KM_ANALYTICS_PAGES_PER_VISIT: () => (/* binding */ KM_ANALYTICS_PAGES_PER_VISIT),
/* harmony export */   KM_ANALYTICS_POPULAR_AUTHORS: () => (/* binding */ KM_ANALYTICS_POPULAR_AUTHORS),
/* harmony export */   KM_ANALYTICS_POPULAR_CONTENT: () => (/* binding */ KM_ANALYTICS_POPULAR_CONTENT),
/* harmony export */   KM_ANALYTICS_POPULAR_PRODUCTS: () => (/* binding */ KM_ANALYTICS_POPULAR_PRODUCTS),
/* harmony export */   KM_ANALYTICS_RETURNING_VISITORS: () => (/* binding */ KM_ANALYTICS_RETURNING_VISITORS),
/* harmony export */   KM_ANALYTICS_TOP_CATEGORIES: () => (/* binding */ KM_ANALYTICS_TOP_CATEGORIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_COUNTRIES: () => (/* binding */ KM_ANALYTICS_TOP_COUNTRIES),
/* harmony export */   KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES: () => (/* binding */ KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS),
/* harmony export */   KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES: () => (/* binding */ KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES),
/* harmony export */   KM_ANALYTICS_VISITS_PER_VISITOR: () => (/* binding */ KM_ANALYTICS_VISITS_PER_VISITOR),
/* harmony export */   KM_ANALYTICS_VISIT_LENGTH: () => (/* binding */ KM_ANALYTICS_VISIT_LENGTH),
/* harmony export */   KM_SEARCH_CONSOLE_POPULAR_KEYWORDS: () => (/* binding */ KM_SEARCH_CONSOLE_POPULAR_KEYWORDS),
/* harmony export */   PERMISSION_AUTHENTICATE: () => (/* binding */ PERMISSION_AUTHENTICATE),
/* harmony export */   PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT: () => (/* binding */ PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT),
/* harmony export */   PERMISSION_MANAGE_MODULE_SHARING_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_MODULE_SHARING_OPTIONS),
/* harmony export */   PERMISSION_MANAGE_OPTIONS: () => (/* binding */ PERMISSION_MANAGE_OPTIONS),
/* harmony export */   PERMISSION_READ_SHARED_MODULE_DATA: () => (/* binding */ PERMISSION_READ_SHARED_MODULE_DATA),
/* harmony export */   PERMISSION_SETUP: () => (/* binding */ PERMISSION_SETUP),
/* harmony export */   PERMISSION_UPDATE_PLUGINS: () => (/* binding */ PERMISSION_UPDATE_PLUGINS),
/* harmony export */   PERMISSION_VIEW_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_DASHBOARD),
/* harmony export */   PERMISSION_VIEW_MODULE_DETAILS: () => (/* binding */ PERMISSION_VIEW_MODULE_DETAILS),
/* harmony export */   PERMISSION_VIEW_POSTS_INSIGHTS: () => (/* binding */ PERMISSION_VIEW_POSTS_INSIGHTS),
/* harmony export */   PERMISSION_VIEW_SHARED_DASHBOARD: () => (/* binding */ PERMISSION_VIEW_SHARED_DASHBOARD),
/* harmony export */   allKeyMetricsTileWidgets: () => (/* binding */ allKeyMetricsTileWidgets),
/* harmony export */   keyMetricsGA4Widgets: () => (/* binding */ keyMetricsGA4Widgets)
/* harmony export */ });
/**
 * `core/user` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_USER = 'core/user';
const DISCONNECTED_REASON_CONNECTED_URL_MISMATCH = 'connected_url_mismatch';
const GLOBAL_SURVEYS_TIMEOUT_SLUG = '__global';
const FORM_TEMPORARY_PERSIST_PERMISSION_ERROR = 'temporary_persist_permission_error';
const ERROR_CODE_ADBLOCKER_ACTIVE = 'adblocker_active';

// Email Report Frequency options.
const EMAIL_REPORT_FREQUENCIES = ['weekly', 'monthly', 'quarterly'];

// Permissions list.
const PERMISSION_AUTHENTICATE = 'googlesitekit_authenticate';
const PERMISSION_SETUP = 'googlesitekit_setup';
const PERMISSION_VIEW_POSTS_INSIGHTS = 'googlesitekit_view_posts_insights';
const PERMISSION_VIEW_DASHBOARD = 'googlesitekit_view_dashboard';
const PERMISSION_VIEW_SHARED_DASHBOARD = 'googlesitekit_view_shared_dashboard';
const PERMISSION_VIEW_MODULE_DETAILS = 'googlesitekit_view_module_details';
const PERMISSION_MANAGE_OPTIONS = 'googlesitekit_manage_options';
const PERMISSION_READ_SHARED_MODULE_DATA = 'googlesitekit_read_shared_module_data';
const PERMISSION_MANAGE_MODULE_SHARING_OPTIONS = 'googlesitekit_manage_module_sharing_options';
const PERMISSION_DELEGATE_MODULE_SHARING_MANAGEMENT = 'googlesitekit_delegate_module_sharing_management';
const PERMISSION_UPDATE_PLUGINS = 'googlesitekit_update_plugins';

// Key Metrics Widgets
const KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT = 'kmAnalyticsAdSenseTopEarningContent';
const KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE = 'kmAnalyticsEngagedTrafficSource';
const KM_ANALYTICS_LEAST_ENGAGING_PAGES = 'kmAnalyticsLeastEngagingPages';
const KM_ANALYTICS_NEW_VISITORS = 'kmAnalyticsNewVisitors';
const KM_ANALYTICS_POPULAR_AUTHORS = 'kmAnalyticsPopularAuthors';
const KM_ANALYTICS_POPULAR_CONTENT = 'kmAnalyticsPopularContent';
const KM_ANALYTICS_POPULAR_PRODUCTS = 'kmAnalyticsPopularProducts';
const KM_ANALYTICS_RETURNING_VISITORS = 'kmAnalyticsReturningVisitors';
const KM_ANALYTICS_TOP_CITIES = 'kmAnalyticsTopCities';
const KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS = 'kmAnalyticsTopCitiesDrivingLeads';
const KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART = 'kmAnalyticsTopCitiesDrivingAddToCart';
const KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES = 'kmAnalyticsTopCitiesDrivingPurchases';
const KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES = 'kmAnalyticsTopDeviceDrivingPurchases';
const KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE = 'kmAnalyticsTopConvertingTrafficSource';
const KM_ANALYTICS_TOP_COUNTRIES = 'kmAnalyticsTopCountries';
const KM_ANALYTICS_TOP_PAGES_DRIVING_LEADS = 'kmAnalyticsTopPagesDrivingLeads';
const KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES = 'kmAnalyticsTopRecentTrendingPages';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE = 'kmAnalyticsTopTrafficSource';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART = 'kmAnalyticsTopTrafficSourceDrivingAddToCart';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_LEADS = 'kmAnalyticsTopTrafficSourceDrivingLeads';
const KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_PURCHASES = 'kmAnalyticsTopTrafficSourceDrivingPurchases';
const KM_ANALYTICS_PAGES_PER_VISIT = 'kmAnalyticsPagesPerVisit';
const KM_ANALYTICS_VISIT_LENGTH = 'kmAnalyticsVisitLength';
const KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES = 'kmAnalyticsTopReturningVisitorPages';
const KM_SEARCH_CONSOLE_POPULAR_KEYWORDS = 'kmSearchConsolePopularKeywords';
const KM_ANALYTICS_VISITS_PER_VISITOR = 'kmAnalyticsVisitsPerVisitor';
const KM_ANALYTICS_MOST_ENGAGING_PAGES = 'kmAnalyticsMostEngagingPages';
const KM_ANALYTICS_TOP_CATEGORIES = 'kmAnalyticsTopCategories';
const keyMetricsGA4Widgets = [KM_ANALYTICS_ADSENSE_TOP_EARNING_CONTENT, KM_ANALYTICS_ENGAGED_TRAFFIC_SOURCE, KM_ANALYTICS_LEAST_ENGAGING_PAGES, KM_ANALYTICS_NEW_VISITORS, KM_ANALYTICS_POPULAR_AUTHORS, KM_ANALYTICS_POPULAR_CONTENT, KM_ANALYTICS_POPULAR_PRODUCTS, KM_ANALYTICS_RETURNING_VISITORS, KM_ANALYTICS_TOP_CATEGORIES, KM_ANALYTICS_TOP_CITIES, KM_ANALYTICS_TOP_CITIES_DRIVING_LEADS, KM_ANALYTICS_TOP_CITIES_DRIVING_ADD_TO_CART, KM_ANALYTICS_TOP_CITIES_DRIVING_PURCHASES, KM_ANALYTICS_TOP_DEVICE_DRIVING_PURCHASES, KM_ANALYTICS_TOP_CONVERTING_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_COUNTRIES, KM_ANALYTICS_TOP_RECENT_TRENDING_PAGES, KM_ANALYTICS_TOP_TRAFFIC_SOURCE, KM_ANALYTICS_TOP_TRAFFIC_SOURCE_DRIVING_ADD_TO_CART, KM_ANALYTICS_PAGES_PER_VISIT, KM_ANALYTICS_VISIT_LENGTH, KM_ANALYTICS_TOP_RETURNING_VISITOR_PAGES, KM_ANALYTICS_VISITS_PER_VISITOR, KM_ANALYTICS_MOST_ENGAGING_PAGES, KM_ANALYTICS_TOP_CATEGORIES];
const allKeyMetricsTileWidgets = [...keyMetricsGA4Widgets, KM_SEARCH_CONSOLE_POPULAR_KEYWORDS];

/***/ }),

/***/ "./js/googlesitekit/modules/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/modules/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_MODULES: () => (/* binding */ CORE_MODULES),
/* harmony export */   ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES: () => (/* binding */ ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES)
/* harmony export */ });
/**
 * `core/modules` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const CORE_MODULES = 'core/modules';
const ERROR_CODE_INSUFFICIENT_MODULE_DEPENDENCIES = 'insufficient_module_dependencies';

/***/ }),

/***/ "./js/googlesitekit/notifications/components/layout/BannerNotification.js":
/*!********************************************************************************!*\
  !*** ./js/googlesitekit/notifications/components/layout/BannerNotification.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TYPES: () => (/* binding */ TYPES),
/* harmony export */   "default": () => (/* binding */ BannerNotification)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Banner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Banner */ "./js/components/Banner/index.js");
/* harmony import */ var _js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Banner/CTAButton */ "./js/components/Banner/CTAButton.js");
/* harmony import */ var _js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Banner/DismissButton */ "./js/components/Banner/DismissButton.js");
/* harmony import */ var _js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/Banner/LearnMoreLink */ "./js/components/Banner/LearnMoreLink.tsx");
/* harmony import */ var _js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/notifications/datastore/constants */ "./js/googlesitekit/notifications/datastore/constants.js");
/* harmony import */ var _js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/googlesitekit/notifications/hooks/useNotificationEvents */ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _svg_graphics_banner_error_svg_url__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/svg/graphics/banner-error.svg?url */ "./svg/graphics/banner-error.svg?url");
/* harmony import */ var _svg_graphics_banner_warning_svg_url__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/graphics/banner-warning.svg?url */ "./svg/graphics/banner-warning.svg?url");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * BannerNotification layout component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */











const TYPES = {
  INFO: 'info',
  ERROR: 'error',
  WARNING: 'warning'
};
function BannerNotification({
  notificationID,
  type = TYPES.INFO,
  learnMoreLink,
  dismissButton,
  ctaButton,
  gaTrackingEventArgs,
  ...props
}) {
  const trackEvents = (0,_js_googlesitekit_notifications_hooks_useNotificationEvents__WEBPACK_IMPORTED_MODULE_7__["default"])(notificationID, gaTrackingEventArgs?.category);
  const {
    dismissNotification
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_notifications_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_NOTIFICATIONS);
  async function handleDismissWithTrackEvent(event) {
    await dismissButton?.onClick?.(event);
    trackEvents.dismiss(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    dismissNotification(notificationID, {
      ...dismissButton?.dismissOptions
    });
  }
  async function handleCTAClickWithTrackEvent(event) {
    trackEvents.confirm(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await ctaButton?.onClick?.(event);
    if (ctaButton?.dismissOnClick) {
      dismissNotification(notificationID, {
        ...ctaButton?.dismissOptions
      });
    }
  }
  async function handleLearnMoreClickWithTrackEvent(event) {
    trackEvents.clickLearnMore(gaTrackingEventArgs?.label, gaTrackingEventArgs?.value);
    await learnMoreLink?.onClick?.(event);
  }
  let SVGData = props?.svg;
  if (!SVGData && type !== TYPES.INFO) {
    SVGData = {
      desktop: undefined,
      mobile: undefined,
      verticalPosition: 'center'
    };
    if (type === TYPES.WARNING) {
      SVGData.desktop = _svg_graphics_banner_warning_svg_url__WEBPACK_IMPORTED_MODULE_10__["default"];
    }
    if (type === TYPES.ERROR) {
      SVGData.desktop = _svg_graphics_banner_error_svg_url__WEBPACK_IMPORTED_MODULE_9__["default"];
    }
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-banner-notification', `googlesitekit-banner-notification--${type}`),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Grid, {
      className: "googlesitekit-page-content",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Row, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_8__.Cell, {
          size: 12,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_Banner__WEBPACK_IMPORTED_MODULE_2__["default"], {
            learnMoreLink: learnMoreLink && {
              ...learnMoreLink,
              onClick: handleLearnMoreClickWithTrackEvent
            },
            dismissButton: dismissButton && {
              ...dismissButton,
              onClick: handleDismissWithTrackEvent
            },
            ctaButton: ctaButton && {
              ...ctaButton,
              onClick: handleCTAClickWithTrackEvent
            },
            svg: SVGData,
            ...props
          })
        })
      })
    })
  });
}
BannerNotification.propTypes = {
  notificationID: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string).isRequired,
  type: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOf(Object.values(TYPES)),
  titleIcon: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
  description: prop_types__WEBPACK_IMPORTED_MODULE_12___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_12___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_12___default().node)]),
  learnMoreLink: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_LearnMoreLink__WEBPACK_IMPORTED_MODULE_5__["default"].propTypes),
  dismissButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_DismissButton__WEBPACK_IMPORTED_MODULE_4__["default"].propTypes),
  ctaButton: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape(_js_components_Banner_CTAButton__WEBPACK_IMPORTED_MODULE_3__["default"].propTypes),
  gaTrackingEventArgs: prop_types__WEBPACK_IMPORTED_MODULE_12___default().shape({
    category: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().string),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_12___default().number)
  })
};

/***/ }),

/***/ "./js/googlesitekit/notifications/datastore/constants.js":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/notifications/datastore/constants.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_NOTIFICATIONS: () => (/* binding */ CORE_NOTIFICATIONS),
/* harmony export */   NOTIFICATION_VIEW_CONTEXTS: () => (/* binding */ NOTIFICATION_VIEW_CONTEXTS)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */

const CORE_NOTIFICATIONS = 'core/notifications';
const NOTIFICATION_VIEW_CONTEXTS = [_js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_SPLASH, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_MAIN_DASHBOARD_VIEW_ONLY, _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.VIEW_CONTEXT_ENTITY_DASHBOARD_VIEW_ONLY];

/***/ }),

/***/ "./js/googlesitekit/notifications/hooks/useNotificationEvents.js":
/*!***********************************************************************!*\
  !*** ./js/googlesitekit/notifications/hooks/useNotificationEvents.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useNotificationEvents)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/**
 * `useNotificationEvents` hook.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useNotificationEvents(id, category, {
  viewAction = 'view_notification',
  confirmAction = 'confirm_notification',
  dismissAction = 'dismiss_notification',
  clickLearnMoreAction = 'click_learn_more_link'
} = {}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_0__["default"])();
  const eventCategory = category !== null && category !== void 0 ? category : `${viewContext}_${id}`;
  const view = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, viewAction, ...args);
  }, [eventCategory, viewAction]);
  const confirm = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, confirmAction, ...args);
  }, [eventCategory, confirmAction]);
  const dismiss = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, dismissAction, ...args);
  }, [eventCategory, dismissAction]);
  const clickLearnMore = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((...args) => {
    return (0,_js_util__WEBPACK_IMPORTED_MODULE_1__.trackEvent)(eventCategory, clickLearnMoreAction, ...args);
  }, [eventCategory, clickLearnMoreAction]);
  return {
    view,
    confirm,
    dismiss,
    clickLearnMore
  };
}

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WPDashboardReportError.js":
/*!***********************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WPDashboardReportError.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WPDashboardReportError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useLifecycles.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "../node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_components_ReportError__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/components/ReportError */ "./js/components/ReportError.js");
/* harmony import */ var _js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/ui/constants */ "./js/googlesitekit/datastore/ui/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WPDashboardReportError component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function WPDashboardReportError({
  moduleSlug,
  error
}) {
  const errorInstanceID = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(WPDashboardReportError, 'WPDashboardReportError');
  const {
    setValue
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI);
  const errorMessage = error.message;
  const selectInstanceID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_ui_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_UI).getValue(`WPDashboardReportError-${moduleSlug}-${errorMessage}`));
  (0,react_use__WEBPACK_IMPORTED_MODULE_5__["default"])(() => {
    setValue(`WPDashboardReportError-${moduleSlug}-${errorMessage}`, errorInstanceID);
  }, () => {
    setValue(`WPDashboardReportError-${moduleSlug}-${errorMessage}`, undefined);
  });
  if (selectInstanceID !== errorInstanceID) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_js_components_ReportError__WEBPACK_IMPORTED_MODULE_1__["default"], {
    moduleSlug: moduleSlug,
    error: error
  });
}
WPDashboardReportError.propTypes = {
  moduleSlug: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string).isRequired,
  error: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().object).isRequired
};

/***/ }),

/***/ "./js/googlesitekit/widgets/components/Widget.js":
/*!*******************************************************!*\
  !*** ./js/googlesitekit/widgets/components/Widget.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Widget component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Widget = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  children,
  className,
  widgetSlug,
  noPadding,
  Header,
  Footer
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-widget', `googlesitekit-widget--${widgetSlug}`, {
      'googlesitekit-widget--no-padding': noPadding
    }, {
      'googlesitekit-widget--with-header': Header
    }, className),
    ref: ref,
    children: [Header && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-widget__header",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Header, {})
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-widget__body",
      children: children
    }), Footer && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      className: "googlesitekit-widget__footer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Footer, {})
    })]
  });
});
Widget.defaultProps = {
  children: undefined,
  noPadding: false
};
Widget.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  noPadding: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  Header: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType),
  Footer: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().elementType)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Widget);

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetContext.tsx":
/*!***************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetContext.tsx ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Consumer: () => (/* binding */ Consumer),
/* harmony export */   Provider: () => (/* binding */ Provider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * Context for widgets.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

/**
 * Widget context value interface.
 *
 * @since n.e.x.t
 */

const WidgetContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)({});
const {
  Consumer,
  Provider
} = WidgetContext;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WidgetContext);

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetNull.js":
/*!***********************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetNull.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WidgetNull)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_Null__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Null */ "./js/components/Null.js");
/* harmony import */ var _js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/widgets/hooks/useWidgetStateEffect */ "./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetNull component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



// This doesn't need to change.

const metadata = {};

// The supported props must match `Null` (except `widgetSlug`).
function WidgetNull({
  widgetSlug
}) {
  (0,_js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_1__["default"])(widgetSlug, _js_components_Null__WEBPACK_IMPORTED_MODULE_0__["default"], metadata);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_Null__WEBPACK_IMPORTED_MODULE_0__["default"], {});
}
WidgetNull.propTypes = {
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string).isRequired,
  ..._js_components_Null__WEBPACK_IMPORTED_MODULE_0__["default"].propTypes
};

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetRecoverableModules.js":
/*!*************************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetRecoverableModules.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WidgetRecoverableModules)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/RecoverableModules */ "./js/components/RecoverableModules.js");
/* harmony import */ var _js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/widgets/hooks/useWidgetStateEffect */ "./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetRecoverableModules component.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



// The supported props must match `RecoverableModules` (except `widgetSlug`).

function WidgetRecoverableModules({
  widgetSlug,
  moduleSlugs,
  ...props
}) {
  const metadata = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => ({
    // Here we serialize to `moduleSlug` for compatibility with the logic in
    // `combineWidgets()`. In future we may wish to take a less "hacky" approach.
    // See https://github.com/google/site-kit-wp/issues/5376#issuecomment-1165771399.
    moduleSlug: [...moduleSlugs].sort().join(','),
    // We also store `moduleSlugs` in the metadata in order for it to be passed back
    // into RecoverableModules as a prop.
    // See https://github.com/google/site-kit-wp/blob/c272c20eddcca61aae24c9812b6b11dbc15ec673/assets/js/googlesitekit/widgets/components/WidgetAreaRenderer.js#L171.
    moduleSlugs
  }), [moduleSlugs]);
  (0,_js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_1__["default"])(widgetSlug, _js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_0__["default"], metadata);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_0__["default"], {
    moduleSlugs: moduleSlugs,
    ...props
  });
}
WidgetRecoverableModules.propTypes = {
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  ..._js_components_RecoverableModules__WEBPACK_IMPORTED_MODULE_0__["default"].propTypes
};

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetReportError.js":
/*!******************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetReportError.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WidgetReportError)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_ReportError__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ReportError */ "./js/components/ReportError.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetReportError component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


// eslint-disable-next-line no-unused-vars

function WidgetReportError({
  widgetSlug,
  ...props
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ReportError__WEBPACK_IMPORTED_MODULE_0__["default"], {
    ...props
  });
}
WidgetReportError.propTypes = {
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string).isRequired,
  ..._js_components_ReportError__WEBPACK_IMPORTED_MODULE_0__["default"].propTypes
};

/***/ }),

/***/ "./js/googlesitekit/widgets/components/WidgetReportZero.js":
/*!*****************************************************************!*\
  !*** ./js/googlesitekit/widgets/components/WidgetReportZero.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WidgetReportZero)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_ReportZero__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ReportZero */ "./js/components/ReportZero.js");
/* harmony import */ var _js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/widgets/hooks/useWidgetStateEffect */ "./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WidgetReportZero component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



// The supported props must match `ReportZero` (except `widgetSlug`).

function WidgetReportZero({
  widgetSlug,
  moduleSlug,
  ...props
}) {
  const metadata = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => ({
    moduleSlug
  }), [moduleSlug]);
  (0,_js_googlesitekit_widgets_hooks_useWidgetStateEffect__WEBPACK_IMPORTED_MODULE_1__["default"])(widgetSlug, _js_components_ReportZero__WEBPACK_IMPORTED_MODULE_0__["default"], metadata);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_js_components_ReportZero__WEBPACK_IMPORTED_MODULE_0__["default"], {
    moduleSlug: moduleSlug,
    ...props
  });
}
WidgetReportZero.propTypes = {
  widgetSlug: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  ..._js_components_ReportZero__WEBPACK_IMPORTED_MODULE_0__["default"].propTypes
};

/***/ }),

/***/ "./js/googlesitekit/widgets/datastore/constants.js":
/*!*********************************************************!*\
  !*** ./js/googlesitekit/widgets/datastore/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_WIDGETS: () => (/* binding */ CORE_WIDGETS),
/* harmony export */   WIDGET_AREA_STYLES: () => (/* binding */ WIDGET_AREA_STYLES),
/* harmony export */   WIDGET_WIDTHS: () => (/* binding */ WIDGET_WIDTHS)
/* harmony export */ });
/**
 * `core/widgets` data store: constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const WIDGET_AREA_STYLES = {
  BOXES: 'boxes',
  COMPOSITE: 'composite'
};
const WIDGET_WIDTHS = {
  QUARTER: 'quarter',
  HALF: 'half',
  FULL: 'full'
};
const CORE_WIDGETS = 'core/widgets';

/***/ }),

/***/ "./js/googlesitekit/widgets/hooks/useWidget.ts":
/*!*****************************************************!*\
  !*** ./js/googlesitekit/widgets/hooks/useWidget.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useWidget)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetContext */ "./js/googlesitekit/widgets/components/WidgetContext.tsx");
/**
 * `useWidget` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the current widget context.
 *
 * @since n.e.x.t
 *
 * @return {WidgetContextValue} The current widget context.
 */
function useWidget() {
  const widgetContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useContext)(_js_googlesitekit_widgets_components_WidgetContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return widgetContext;
}

/***/ }),

/***/ "./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js":
/*!****************************************************************!*\
  !*** ./js/googlesitekit/widgets/hooks/useWidgetStateEffect.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useWidgetStateEffect)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/widgets/datastore/constants */ "./js/googlesitekit/widgets/datastore/constants.js");
/**
 * `useWidgetStateEffect` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useWidgetStateEffect(widgetSlug, Component, metadata) {
  const {
    setWidgetState,
    unsetWidgetState
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_widgets_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_WIDGETS);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    setWidgetState(widgetSlug, Component, metadata);
    return () => {
      unsetWidgetState(widgetSlug, Component, metadata);
    };
  }, [widgetSlug, Component, metadata, setWidgetState, unsetWidgetState]);
}

/***/ }),

/***/ "./js/googlesitekit/widgets/util/get-widget-component-props.js":
/*!*********************************************************************!*\
  !*** ./js/googlesitekit/widgets/util/get-widget-component-props.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getWidgetComponentProps: () => (/* binding */ getWidgetComponentProps),
/* harmony export */   withWPDashboardWidgetComponentProps: () => (/* binding */ withWPDashboardWidgetComponentProps),
/* harmony export */   withWidgetComponentProps: () => (/* binding */ withWidgetComponentProps)
/* harmony export */ });
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_googlesitekit_widgets_components_Widget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/Widget */ "./js/googlesitekit/widgets/components/Widget.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetNull__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetNull */ "./js/googlesitekit/widgets/components/WidgetNull.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetRecoverableModules__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetRecoverableModules */ "./js/googlesitekit/widgets/components/WidgetRecoverableModules.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetReportError__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetReportError */ "./js/googlesitekit/widgets/components/WidgetReportError.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WidgetReportZero__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WidgetReportZero */ "./js/googlesitekit/widgets/components/WidgetReportZero.js");
/* harmony import */ var _js_googlesitekit_widgets_components_WPDashboardReportError__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/widgets/components/WPDashboardReportError */ "./js/googlesitekit/widgets/components/WPDashboardReportError.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Widgets component props utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */







/**
 * Gets the props to pass to a widget's component.
 *
 * @since 1.25.0
 * @since 1.107.0 Added `widgetSlug` to the returned props.
 *
 * @param {string} widgetSlug The widget's slug.
 * @return {Object} Props to pass to the widget component.
 */

const getWidgetComponentProps = memize__WEBPACK_IMPORTED_MODULE_0___default()(widgetSlug => {
  // Scope widget-specific components to the widget instance so that the
  // component does not need to (re-)specify the widget slug.
  return {
    widgetSlug,
    Widget: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_Widget__WEBPACK_IMPORTED_MODULE_1__["default"]),
    WidgetRecoverableModules: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WidgetRecoverableModules__WEBPACK_IMPORTED_MODULE_3__["default"]),
    WidgetReportZero: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WidgetReportZero__WEBPACK_IMPORTED_MODULE_5__["default"]),
    WidgetReportError: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WidgetReportError__WEBPACK_IMPORTED_MODULE_4__["default"]),
    WidgetNull: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WidgetNull__WEBPACK_IMPORTED_MODULE_2__["default"])
  };
});
function withWidgetSlug(widgetSlug) {
  return WrappedComponent => {
    const WithWidgetSlug = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)((props, ref) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(WrappedComponent, {
        ...props,
        ref: ref,
        widgetSlug: widgetSlug
      });
    });
    WithWidgetSlug.displayName = 'WithWidgetSlug';
    if (WrappedComponent.displayName || WrappedComponent.name) {
      WithWidgetSlug.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
    }
    return WithWidgetSlug;
  };
}

/**
 * Gets the props and passes them to the widget's component through a HOC.
 *
 * @since 1.26.0
 *
 * @param {string} widgetSlug The slug of the widget.
 * @return {Function} Enhancing function that adds the getWidgetComponentProps to the passed component.
 */
function withWidgetComponentProps(widgetSlug) {
  const widgetComponentProps = getWidgetComponentProps(widgetSlug);
  return WrappedComponent => {
    function DecoratedComponent(props) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(WrappedComponent, {
        ...props,
        ...widgetComponentProps
      });
    }
    DecoratedComponent.displayName = 'WithWidgetComponentProps';
    if (WrappedComponent.displayName || WrappedComponent.name) {
      DecoratedComponent.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
    }
    return DecoratedComponent;
  };
}

/**
 * Gets the props and passes them to the WP Dashboard widget's component through a HOC.
 *
 * @since 1.114.0
 *
 * @param {string} widgetSlug The slug of the widget.
 * @return {Function} Enhancing function that adds the WP Dashboard specific
 *                    props to the passed component.
 */
function withWPDashboardWidgetComponentProps(widgetSlug) {
  return WrappedComponent => {
    function DecoratedComponent(props) {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(WrappedComponent, {
        ...props,
        WPDashboardReportError: withWidgetSlug(widgetSlug)(_js_googlesitekit_widgets_components_WPDashboardReportError__WEBPACK_IMPORTED_MODULE_6__["default"])
      });
    }
    DecoratedComponent.displayName = 'WithWPDashboardWidgetComponentProps';
    if (WrappedComponent.displayName || WrappedComponent.name) {
      DecoratedComponent.displayName += `(${WrappedComponent.displayName || WrappedComponent.name})`;
    }
    return DecoratedComponent;
  };
}

/***/ }),

/***/ "./js/hooks/useActivateModuleCallback.js":
/*!***********************************************!*\
  !*** ./js/hooks/useActivateModuleCallback.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useActivateModuleCallback)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/api/cache */ "./js/googlesitekit/api/cache.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_util_tracking__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/util/tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./useViewContext */ "./js/hooks/useViewContext.js");
/**
 * `useActivateModuleCallback` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









/**
 * Returns a callback to activate a module. If the call to activate the module is successful, navigate to the reauthentication URL.
 * Returns null if the module doesn't exist or the user can't manage options.
 *
 * @since 1.70.0
 *
 * @param {string} moduleSlug Module slug.
 * @return {Function|null} Callback to activate module, null if the module doesn't exist or the user can't manage options.
 */
function useActivateModuleCallback(moduleSlug) {
  const viewContext = (0,_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const module = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES).getModule(moduleSlug));
  const canManageOptions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_4__.PERMISSION_MANAGE_OPTIONS));
  const {
    activateModule
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_MODULES);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_LOCATION);
  const {
    setInternalServerError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_SITE);
  const activateModuleCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)(async () => {
    const {
      error,
      response
    } = await activateModule(moduleSlug);
    if (!error) {
      await (0,_js_util_tracking__WEBPACK_IMPORTED_MODULE_6__.trackEvent)(`${viewContext}_widget-activation-cta`, 'activate_module', moduleSlug);
      await (0,_js_googlesitekit_api_cache__WEBPACK_IMPORTED_MODULE_1__.setItem)('module_setup', moduleSlug, {
        ttl: 300
      });
      navigateTo(response.moduleReauthURL);
    } else {
      setInternalServerError({
        id: `${moduleSlug}-setup-error`,
        description: error.message
      });
    }
  }, [activateModule, moduleSlug, navigateTo, setInternalServerError, viewContext]);
  if (!module?.name || !canManageOptions) {
    return null;
  }
  return activateModuleCallback;
}

/***/ }),

/***/ "./js/hooks/useBreakpoint.ts":
/*!***********************************!*\
  !*** ./js/hooks/useBreakpoint.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAKPOINT_DESKTOP: () => (/* binding */ BREAKPOINT_DESKTOP),
/* harmony export */   BREAKPOINT_SMALL: () => (/* binding */ BREAKPOINT_SMALL),
/* harmony export */   BREAKPOINT_TABLET: () => (/* binding */ BREAKPOINT_TABLET),
/* harmony export */   BREAKPOINT_XLARGE: () => (/* binding */ BREAKPOINT_XLARGE),
/* harmony export */   useBreakpoint: () => (/* binding */ useBreakpoint)
/* harmony export */ });
/* harmony import */ var _useWindowSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useWindowSize */ "./js/hooks/useWindowSize.ts");
/**
 * `useBreakpoint` hook.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Breakpoint for an extra large screen (over `1280px` wide).
 */
const BREAKPOINT_XLARGE = 'xlarge';
/**
 * Breakpoint for a desktop screen (over `960px` wide).
 */
const BREAKPOINT_DESKTOP = 'desktop';
/**
 * Breakpoint for a tablet screen (over `600px` wide).
 */
const BREAKPOINT_TABLET = 'tablet';
/**
 * Breakpoint for a mobile phone screen (any screen `600px` wide or less).
 */
const BREAKPOINT_SMALL = 'small';

/**
 * Retrieves the current breakpoint.
 *
 * @since 1.29.0
 *
 * @return {string} The current breakpoint according to the window size.
 */
function useBreakpoint() {
  const windowWidth = (0,_useWindowSize__WEBPACK_IMPORTED_MODULE_0__.useWindowWidth)();
  if (windowWidth > 1280) {
    return BREAKPOINT_XLARGE;
  }
  if (windowWidth > 960) {
    return BREAKPOINT_DESKTOP;
  }
  if (windowWidth > 600) {
    return BREAKPOINT_TABLET;
  }
  return BREAKPOINT_SMALL;
}

/***/ }),

/***/ "./js/hooks/useCompleteModuleActivationCallback.js":
/*!*********************************************************!*\
  !*** ./js/hooks/useCompleteModuleActivationCallback.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useCompleteModuleActivationCallback)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/**
 * `useCompleteModuleActivationCallback` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Returns a callback to navigate users to the module's authentication URL.
 *
 * Returns null if the module doesn't exist or the user can't manage options.
 *
 * @since 1.73.0
 *
 * @param {string} moduleSlug Module slug.
 * @return {Function|null} Callback that navigates to a module's reauth URL, null if the module doesn't exist or the user can't manage options.
 */
function useCompleteModuleActivationCallback(moduleSlug) {
  const canManageOptions = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_USER).hasCapability(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_2__.PERMISSION_MANAGE_OPTIONS));
  const moduleStoreName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).getModuleStoreName(moduleSlug));
  const adminReauthURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useSelect)(select => select(moduleStoreName)?.getAdminReauthURL());
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_0__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_1__.CORE_LOCATION);
  const completeModuleActivationCallback = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => navigateTo(adminReauthURL), [adminReauthURL, navigateTo]);
  if (!adminReauthURL || !canManageOptions) {
    return null;
  }
  return completeModuleActivationCallback;
}

/***/ }),

/***/ "./js/hooks/useDebounce.js":
/*!*********************************!*\
  !*** ./js/hooks/useDebounce.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDebounce: () => (/* binding */ useDebounce)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var use_memo_one__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! use-memo-one */ "../node_modules/use-memo-one/dist/use-memo-one.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/**
 * `useDebounce` hook, from @wordpress/compose.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// @TODO When we upgrade React to 16.4, we can also upgrade @wordpress/compose, and then this file can be removed.

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Debounces a function with Lodash's `debounce`.
 *
 * A new debounced function will be returned and any scheduled calls
 * cancelled if any of the arguments change, including the function to debounce,
 * so please wrap functions created on render in components in `useCallback`.
 *
 * @since 1.26.0
 *
 * @param {...any} args Arguments passed to Lodash's `debounce`.
 * @return {Function} Debounced function.
 */
function useDebounce(...args) {
  const debounced = (0,use_memo_one__WEBPACK_IMPORTED_MODULE_1__.useMemoOne)(() => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.debounce)(...args), args);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => () => debounced.cancel(), [debounced]);
  return debounced;
}

/***/ }),

/***/ "./js/hooks/useFeature.js":
/*!********************************!*\
  !*** ./js/hooks/useFeature.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFeature: () => (/* binding */ useFeature)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_FeaturesProvider_FeaturesContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/FeaturesProvider/FeaturesContext */ "./js/components/FeaturesProvider/FeaturesContext.js");
/* harmony import */ var _js_features__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/features */ "./js/features/index.js");
/**
 * Feature Flags hook.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Returns the enabled state of a feature flag.
 *
 * @since 1.25.0
 *
 * @param {string} feature The feature flag name to check enabled state for.
 * @return {boolean} `true` if the feature is enabled, `false` otherwise.
 */
function useFeature(feature) {
  const enabledFeatures = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useContext)(_js_components_FeaturesProvider_FeaturesContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return (0,_js_features__WEBPACK_IMPORTED_MODULE_1__.isFeatureEnabled)(feature, enabledFeatures);
}

/***/ }),

/***/ "./js/hooks/useFormValue.js":
/*!**********************************!*\
  !*** ./js/hooks/useFormValue.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFormValue)
/* harmony export */ });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/data */ "../node_modules/@wordpress/data/build-module/components/use-select/index.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/**
 * Form value hook.
 *
 * Site Kit by Google, Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the value of a form field.
 *
 * @since 1.160.0
 *
 * @param {string} formName The name of the form.
 * @param {string} key      The key of the form field.
 * @return {string|number|boolean|Array|Object|undefined} The value of the form field, or the default value if provided.
 */
function useFormValue(formName, key) {
  return (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["default"])(select => {
    const {
      getValue
    } = select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_0__.CORE_FORMS);
    return getValue(formName, key);
  }, [formName, key]);
}

/***/ }),

/***/ "./js/hooks/useViewContext.js":
/*!************************************!*\
  !*** ./js/hooks/useViewContext.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/Root/ViewContextContext */ "./js/components/Root/ViewContextContext.js");
/**
 * `useViewContext` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


/**
 * Returns the current Site Kit viewing context, eg. "dashboard",
 * "entity dashboard", "view-only dashboard", etc.
 *
 * @since 1.74.0
 *
 * @return {string} The current "viewing context" value for the plugin.
 */
function useViewContext() {
  const viewContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useContext)(_js_components_Root_ViewContextContext__WEBPACK_IMPORTED_MODULE_0__["default"]);
  return viewContext;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useViewContext);

/***/ }),

/***/ "./js/hooks/useViewOnly.js":
/*!*********************************!*\
  !*** ./js/hooks/useViewOnly.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useViewOnly)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/* harmony import */ var _useViewContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useViewContext */ "./js/hooks/useViewContext.js");
/**
 * `useViewOnly` hook.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */



/**
 * Determines if the current view context is a "view only" dashboard context.
 *
 * @since 1.72.0
 *
 * @return {boolean} True if current context is a view-only dashboard context, false otherwise.
 */
function useViewOnly() {
  const viewContext = (0,_useViewContext__WEBPACK_IMPORTED_MODULE_1__["default"])();
  return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.SITE_KIT_VIEW_ONLY_CONTEXTS.includes(viewContext);
}

/***/ }),

/***/ "./js/hooks/useWindowSize.ts":
/*!***********************************!*\
  !*** ./js/hooks/useWindowSize.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useWindowHeight: () => (/* binding */ useWindowHeight),
/* harmony export */   useWindowSize: () => (/* binding */ useWindowSize),
/* harmony export */   useWindowWidth: () => (/* binding */ useWindowWidth)
/* harmony export */ });
/* harmony import */ var _react_hook_event__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @react-hook/event */ "../node_modules/@react-hook/event/dist/module/index.js");
/* harmony import */ var _react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @react-hook/throttle */ "../node_modules/@react-hook/throttle/dist/module/index.js");
/**
 * `useWindowSize` hook.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Copied from https://github.com/jaredLunde/react-hook/blob/b8ac9515e26937e838a36a27001dc46c7f46a390/packages/window-size/throttled/src/index.tsx
// Modified to use global.innerWidth and global.innerHeight instead of document.documentElement.clientWidth and document.documentElement.clientHeight.

/**
 * External dependencies
 */


function getSize() {
  return [__webpack_require__.g.innerWidth, __webpack_require__.g.innerHeight];
}
function useWindowSize({
  fps = 60,
  leading = false,
  initialWidth = 0,
  initialHeight = 0
} = {}) {
  const [size, setThrottledSize] = (0,_react_hook_throttle__WEBPACK_IMPORTED_MODULE_0__.useThrottle)(/* istanbul ignore next */
  typeof document === 'undefined' ? [initialWidth, initialHeight] : getSize, fps, leading);
  function setSize() {
    return setThrottledSize(getSize);
  }
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'resize', setSize);
  (0,_react_hook_event__WEBPACK_IMPORTED_MODULE_1__["default"])(window, 'orientationchange', setSize);
  return size;
}
function useWindowHeight(options = {}) {
  return useWindowSize(options)[1];
}
function useWindowWidth(options = {}) {
  return useWindowSize(options)[0];
}

/***/ }),

/***/ "./js/material-components/index.js":
/*!*****************************************!*\
  !*** ./js/material-components/index.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Cell),
/* harmony export */   Dialog: () => (/* reexport default from dynamic */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default.a),
/* harmony export */   DialogContent: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogContent),
/* harmony export */   DialogFooter: () => (/* reexport safe */ _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__.DialogFooter),
/* harmony export */   Grid: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Grid),
/* harmony export */   MDCCheckbox: () => (/* reexport safe */ _material_checkbox__WEBPACK_IMPORTED_MODULE_7__.MDCCheckbox),
/* harmony export */   MDCDialog: () => (/* reexport safe */ _material_dialog__WEBPACK_IMPORTED_MODULE_6__.MDCDialog),
/* harmony export */   MDCFormField: () => (/* reexport safe */ _material_form_field__WEBPACK_IMPORTED_MODULE_3__.MDCFormField),
/* harmony export */   MDCMenu: () => (/* reexport safe */ _material_menu__WEBPACK_IMPORTED_MODULE_8__.MDCMenu),
/* harmony export */   MDCRadio: () => (/* reexport safe */ _material_radio__WEBPACK_IMPORTED_MODULE_4__.MDCRadio),
/* harmony export */   MDCRipple: () => (/* reexport safe */ _material_ripple__WEBPACK_IMPORTED_MODULE_2__.MDCRipple),
/* harmony export */   MDCSwitch: () => (/* reexport safe */ _material_switch__WEBPACK_IMPORTED_MODULE_5__.MDCSwitch),
/* harmony export */   Row: () => (/* reexport safe */ _layout__WEBPACK_IMPORTED_MODULE_1__.Row)
/* harmony export */ });
/* harmony import */ var _material_checkbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material/checkbox */ "../node_modules/@material/checkbox/component.js");
/* harmony import */ var _material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/dialog */ "../node_modules/@material/dialog/component.js");
/* harmony import */ var _material_form_field__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/form-field */ "../node_modules/@material/form-field/component.js");
/* harmony import */ var _material_menu__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material/menu */ "../node_modules/@material/menu/component.js");
/* harmony import */ var _material_radio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material/radio */ "../node_modules/@material/radio/component.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/react-dialog */ "../node_modules/@material/react-dialog/dist/index.js");
/* harmony import */ var _material_react_dialog__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_material_react_dialog__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _material_ripple__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/ripple */ "../node_modules/@material/ripple/component.js");
/* harmony import */ var _material_switch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/switch */ "../node_modules/@material/switch/component.js");
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./layout */ "./js/material-components/layout/index.js");
/**
 * Material components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */











/***/ }),

/***/ "./js/material-components/layout/Cell.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Cell.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Cell)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Cell component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



function Cell(props) {
  const {
    className,
    alignTop,
    alignMiddle,
    alignBottom,
    alignRight,
    alignLeft,
    smAlignRight,
    mdAlignRight,
    lgAlignRight,
    smSize,
    smStart,
    smOrder,
    mdSize,
    mdStart,
    mdOrder,
    lgSize,
    lgStart,
    lgOrder,
    size,
    children,
    ...otherProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ...otherProps,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(className, 'mdc-layout-grid__cell', {
      'mdc-layout-grid__cell--align-top': alignTop,
      'mdc-layout-grid__cell--align-middle': alignMiddle,
      'mdc-layout-grid__cell--align-bottom': alignBottom,
      'mdc-layout-grid__cell--align-right': alignRight,
      'mdc-layout-grid__cell--align-left': alignLeft,
      'mdc-layout-grid__cell--align-right-phone': smAlignRight,
      'mdc-layout-grid__cell--align-right-tablet': mdAlignRight,
      'mdc-layout-grid__cell--align-right-desktop': lgAlignRight,
      [`mdc-layout-grid__cell--span-${size}`]: 12 >= size && size > 0,
      [`mdc-layout-grid__cell--span-${lgSize}-desktop`]: 12 >= lgSize && lgSize > 0,
      [`mdc-layout-grid__cell--start-${lgStart}-desktop`]: 12 >= lgStart && lgStart > 0,
      [`mdc-layout-grid__cell--order-${lgOrder}-desktop`]: 12 >= lgOrder && lgOrder > 0,
      [`mdc-layout-grid__cell--span-${mdSize}-tablet`]: 8 >= mdSize && mdSize > 0,
      [`mdc-layout-grid__cell--start-${mdStart}-tablet`]: 8 >= mdStart && mdStart > 0,
      [`mdc-layout-grid__cell--order-${mdOrder}-tablet`]: 8 >= mdOrder && mdOrder > 0,
      [`mdc-layout-grid__cell--span-${smSize}-phone`]: 4 >= smSize && smSize > 0,
      [`mdc-layout-grid__cell--start-${smStart}-phone`]: 4 >= smStart && smStart > 0,
      [`mdc-layout-grid__cell--order-${smOrder}-phone`]: 4 >= smOrder && smOrder > 0
    }),
    children: children
  });
}
Cell.propTypes = {
  smSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  smOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  mdOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgSize: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgStart: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  lgOrder: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().number),
  alignTop: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignMiddle: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignBottom: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  smAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  mdAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  lgAlignRight: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node)
};
Cell.defaultProps = {
  className: '',
  size: 0,
  smSize: 0,
  smStart: 0,
  smOrder: 0,
  mdSize: 0,
  mdStart: 0,
  mdOrder: 0,
  lgSize: 0,
  lgStart: 0,
  lgOrder: 0
};

/***/ }),

/***/ "./js/material-components/layout/Grid.js":
/*!***********************************************!*\
  !*** ./js/material-components/layout/Grid.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Grid component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Grid = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  alignLeft,
  fill,
  className,
  children,
  collapsed,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid', className, {
      'mdc-layout-grid--align-left': alignLeft,
      'mdc-layout-grid--collapsed': collapsed,
      'mdc-layout-grid--fill': fill
    }),
    ...otherProps,
    ref: ref,
    children: children
  });
});
Grid.displayName = 'Grid';
Grid.propTypes = {
  alignLeft: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  fill: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Grid.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Grid);

/***/ }),

/***/ "./js/material-components/layout/Row.js":
/*!**********************************************!*\
  !*** ./js/material-components/layout/Row.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Material UI > Layout > Row component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


const Row = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(({
  className,
  children,
  ...otherProps
}, ref) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
    ref: ref,
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-layout-grid__inner', className),
    ...otherProps,
    children: children
  });
});
Row.displayName = 'Row';
Row.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
Row.defaultProps = {
  className: ''
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Row);

/***/ }),

/***/ "./js/material-components/layout/index.js":
/*!************************************************!*\
  !*** ./js/material-components/layout/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cell: () => (/* reexport safe */ _Cell__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Grid: () => (/* reexport safe */ _Grid__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Row: () => (/* reexport safe */ _Row__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _Cell__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cell */ "./js/material-components/layout/Cell.js");
/* harmony import */ var _Row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Row */ "./js/material-components/layout/Row.js");
/* harmony import */ var _Grid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Grid */ "./js/material-components/layout/Grid.js");
/**
 * Material UI > Layout components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountCreate/AccountField.js":
/*!********************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountCreate/AccountField.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccountField)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _CreateAccountField__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./CreateAccountField */ "./js/modules/analytics-4/components/common/AccountCreate/CreateAccountField.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AccountField component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function AccountField() {
  const value = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_3__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.FORM_ACCOUNT_CREATE, 'accountName');
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS);
  const setValue = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(accountName => {
    setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.FORM_ACCOUNT_CREATE, {
      accountName
    });
  }, [setValues]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_CreateAccountField__WEBPACK_IMPORTED_MODULE_5__["default"], {
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Account', 'google-site-kit'),
    hasError: !value,
    value: value,
    setValue: setValue,
    name: "account"
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountCreate/CountrySelect.js":
/*!*********************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountCreate/CountrySelect.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CountrySelect)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_utils_countries_timezones__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/utils/countries-timezones */ "./js/modules/analytics-4/utils/countries-timezones.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CountrySelect component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function CountrySelect() {
  const value = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_4__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.FORM_ACCOUNT_CREATE, 'countryCode');
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_FORMS);
  const onEnhancedChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)((i, item) => {
    const newCountryCode = item.dataset.value;
    if (newCountryCode !== value && _js_modules_analytics_4_utils_countries_timezones__WEBPACK_IMPORTED_MODULE_6__.countriesByCode[newCountryCode]) {
      setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.FORM_ACCOUNT_CREATE, {
        countryCode: newCountryCode,
        timezone:
        // eslint-disable-next-line sitekit/acronym-case
        _js_modules_analytics_4_utils_countries_timezones__WEBPACK_IMPORTED_MODULE_6__.countriesByCode[newCountryCode].defaultTimeZoneId
      });
    }
  }, [setValues, value]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
    className: "googlesitekit-analytics__select-country",
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Country', 'google-site-kit'),
    value: value,
    onEnhancedChange: onEnhancedChange,
    enhanced: true,
    outlined: true,
    children: _js_modules_analytics_4_utils_countries_timezones__WEBPACK_IMPORTED_MODULE_6__.allCountries.map(({
      countryCode,
      displayName
    }, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Option, {
      value: countryCode,
      children: displayName
    }, i))
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountCreate/CreateAccountField.js":
/*!**************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountCreate/CreateAccountField.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CreateAccountField)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * CreateAccountField component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


function CreateAccountField({
  hasError,
  value,
  setValue,
  name,
  label
}) {
  // Ensure field doesn't render until default value is available, fixing a potential render bug.
  if (value === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.TextField, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('mdc-text-field', {
      'mdc-text-field--error': hasError
    }),
    label: label,
    name: name,
    onChange: event => {
      setValue(event.target.value, name);
    },
    value: value,
    id: `googlesitekit_analytics_account_create_${name}`,
    outlined: true
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountCreate/PropertyField.js":
/*!*********************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountCreate/PropertyField.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PropertyField)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useFeature */ "./js/hooks/useFeature.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_modules_analytics_4_components_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/components/common */ "./js/modules/analytics-4/components/common/index.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _CreateAccountField__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./CreateAccountField */ "./js/modules/analytics-4/components/common/AccountCreate/CreateAccountField.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * PropertyField component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function PropertyField() {
  const setupFlowRefreshEnabled = (0,_js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_4__.useFeature)('setupFlowRefresh');
  const value = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_5__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.FORM_ACCOUNT_CREATE, 'propertyName');
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS);
  const isAnalyticsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_7__.MODULE_SLUG_ANALYTICS_4));
  const setValue = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(propertyName => {
    setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.FORM_ACCOUNT_CREATE, {
      propertyName
    });
  }, [setValues]);

  // Ensure the hint is not shown when editing Analytics settings.
  const showHint = setupFlowRefreshEnabled && !isAnalyticsConnected;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_CreateAccountField__WEBPACK_IMPORTED_MODULE_9__["default"], {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Property', 'google-site-kit'),
      value: value,
      hasError: !value,
      setValue: setValue,
      name: "property"
    }), showHint && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_modules_analytics_4_components_common__WEBPACK_IMPORTED_MODULE_6__.PropertyHint, {})]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountCreate/TimezoneSelect.js":
/*!**********************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountCreate/TimezoneSelect.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TimezoneSelect)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_utils_countries_timezones__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/utils/countries-timezones */ "./js/modules/analytics-4/utils/countries-timezones.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * TimezoneSelect component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function TimezoneSelect() {
  const countryCode = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_4__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.FORM_ACCOUNT_CREATE, 'countryCode');
  const value = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_4__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.FORM_ACCOUNT_CREATE, 'timezone');
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_FORMS);
  const onEnhancedChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.useCallback)((i, item) => {
    setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.FORM_ACCOUNT_CREATE, {
      timezone: item.dataset.value
    });
  }, [setValues]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
    className: "googlesitekit-analytics__select-timezone",
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Timezone', 'google-site-kit'),
    value: value,
    onEnhancedChange: onEnhancedChange,
    disabled: !countryCode,
    enhanced: true,
    outlined: true,
    children: (_js_modules_analytics_4_utils_countries_timezones__WEBPACK_IMPORTED_MODULE_6__.timeZonesByCountryCode[countryCode] || []).map(
    // eslint-disable-next-line sitekit/acronym-case
    ({
      timeZoneId,
      displayName
    }, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Option, {
      // eslint-disable-next-line sitekit/acronym-case
      value: timeZoneId,
      children: displayName
    }, i))
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountCreate/WebDataStreamField.js":
/*!**************************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountCreate/WebDataStreamField.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WebDataStreamField)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/googlesitekit/modules/datastore/constants */ "./js/googlesitekit/modules/datastore/constants.js");
/* harmony import */ var _js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useFeature */ "./js/hooks/useFeature.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_modules_analytics_4_components_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/components/common */ "./js/modules/analytics-4/components/common/index.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _CreateAccountField__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./CreateAccountField */ "./js/modules/analytics-4/components/common/AccountCreate/CreateAccountField.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * WebDataStreamField component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function WebDataStreamField() {
  const setupFlowRefreshEnabled = (0,_js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_4__.useFeature)('setupFlowRefresh');
  const value = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_5__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.FORM_ACCOUNT_CREATE, 'dataStreamName');
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_FORMS);
  const isAnalyticsConnected = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_modules_datastore_constants__WEBPACK_IMPORTED_MODULE_3__.CORE_MODULES).isModuleConnected(_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_7__.MODULE_SLUG_ANALYTICS_4));
  const setValue = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(dataStreamName => {
    setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.FORM_ACCOUNT_CREATE, {
      dataStreamName
    });
  }, [setValues]);

  // Ensure the hint is not shown when editing Analytics settings.
  const showHint = setupFlowRefreshEnabled && !isAnalyticsConnected;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_CreateAccountField__WEBPACK_IMPORTED_MODULE_9__["default"], {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Web data stream', 'google-site-kit'),
      value: value,
      hasError: !value,
      setValue: setValue,
      name: "dataStream"
    }), showHint && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_modules_analytics_4_components_common__WEBPACK_IMPORTED_MODULE_6__.WebDataStreamHint, {})]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountCreate/index.js":
/*!*************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountCreate/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccountCreate)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/get-query-arg.js");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-api */ "googlesitekit-api");
/* harmony import */ var googlesitekit_api__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _js_components_conversion_tracking_SetupPluginConversionTrackingNotice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/components/conversion-tracking/SetupPluginConversionTrackingNotice */ "./js/components/conversion-tracking/SetupPluginConversionTrackingNotice.js");
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Null__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/components/Null */ "./js/components/Null.js");
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @/js/googlesitekit/datastore/location/constants */ "./js/googlesitekit/datastore/location/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @/js/googlesitekit/datastore/user/constants */ "./js/googlesitekit/datastore/user/constants.js");
/* harmony import */ var _js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @/js/hooks/useFeature */ "./js/hooks/useFeature.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_material_components__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @/js/material-components */ "./js/material-components/index.js");
/* harmony import */ var _js_modules_analytics_4_components_common__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @/js/modules/analytics-4/components/common */ "./js/modules/analytics-4/components/common/index.js");
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_utils_account__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @/js/modules/analytics-4/utils/account */ "./js/modules/analytics-4/utils/account.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_errors__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @/js/util/errors */ "./js/util/errors.js");
/* harmony import */ var _AccountField__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./AccountField */ "./js/modules/analytics-4/components/common/AccountCreate/AccountField.js");
/* harmony import */ var _CountrySelect__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./CountrySelect */ "./js/modules/analytics-4/components/common/AccountCreate/CountrySelect.js");
/* harmony import */ var _PropertyField__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./PropertyField */ "./js/modules/analytics-4/components/common/AccountCreate/PropertyField.js");
/* harmony import */ var _TimezoneSelect__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./TimezoneSelect */ "./js/modules/analytics-4/components/common/AccountCreate/TimezoneSelect.js");
/* harmony import */ var _WebDataStreamField__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./WebDataStreamField */ "./js/modules/analytics-4/components/common/AccountCreate/WebDataStreamField.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * AccountCreate component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





























function AccountCreate({
  className
}) {
  const setupFlowRefreshEnabled = (0,_js_hooks_useFeature__WEBPACK_IMPORTED_MODULE_15__.useFeature)('setupFlowRefresh');
  const [isNavigating, setIsNavigating] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_31__.useState)(false);
  const accounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.MODULES_ANALYTICS_4).getAccountSummaries());
  const hasResolvedAccounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.MODULES_ANALYTICS_4).hasFinishedResolution('getAccountSummaries'));
  const accountTicketTermsOfServiceURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.MODULES_ANALYTICS_4).getAccountTicketTermsOfServiceURL());
  const canSubmitAccountCreate = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.MODULES_ANALYTICS_4).canSubmitAccountCreate());
  const isDoingCreateAccount = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.MODULES_ANALYTICS_4).isDoingCreateAccount());
  const hasEditScope = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_14__.CORE_USER).hasScope(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.EDIT_SCOPE));
  const hasGTMScope = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_14__.CORE_USER).hasScope(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.GTM_SCOPE));
  const hasAccountCreateForm = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_FORMS).hasForm(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.FORM_ACCOUNT_CREATE));
  const autoSubmit = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_16__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.FORM_ACCOUNT_CREATE, 'autoSubmit');
  const siteURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_13__.CORE_SITE).getReferenceSiteURL());
  const siteName = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_13__.CORE_SITE).getSiteName());
  const timezone = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_13__.CORE_SITE).getTimezone());
  const pluginConversionsDocumentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_13__.CORE_SITE).getDocumentationLinkURL('plugin-conversion-tracking');
  });
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_17__["default"])();
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_11__.CORE_FORMS);
  const {
    navigateTo
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_js_googlesitekit_datastore_location_constants__WEBPACK_IMPORTED_MODULE_12__.CORE_LOCATION);
  const {
    createAccount
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.MODULES_ANALYTICS_4);
  const {
    setPermissionScopeError
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_js_googlesitekit_datastore_user_constants__WEBPACK_IMPORTED_MODULE_14__.CORE_USER);
  const {
    setConversionTrackingEnabled,
    saveConversionTrackingSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_13__.CORE_SITE);
  const hasRequiredScope = hasEditScope;

  // Redirect if the accountTicketTermsOfServiceURL is set.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_31__.useEffect)(() => {
    if (accountTicketTermsOfServiceURL) {
      (async () => {
        await (0,googlesitekit_api__WEBPACK_IMPORTED_MODULE_2__.invalidateCache)('modules', _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_20__.MODULE_SLUG_ANALYTICS_4);
        navigateTo(accountTicketTermsOfServiceURL);
      })();
    }
  }, [accountTicketTermsOfServiceURL, navigateTo]);

  // Set form defaults on initial render.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_31__.useEffect)(() => {
    // Only set the form if not already present in store.
    // e.g. after a snapshot has been restored.
    if (!hasAccountCreateForm) {
      setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.FORM_ACCOUNT_CREATE, (0,_js_modules_analytics_4_utils_account__WEBPACK_IMPORTED_MODULE_22__.getAccountDefaults)({
        siteName,
        siteURL,
        timezone
      }));
    }
  }, [hasAccountCreateForm, siteName, siteURL, timezone, setValues]);
  const showProgress = (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_32__.getQueryArg)(location.href, 'showProgress');
  const isInitialSetupFlow = !!showProgress && setupFlowRefreshEnabled;
  const handleSubmit = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_31__.useCallback)(async () => {
    const scopes = [];
    if (!hasEditScope) {
      scopes.push(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.EDIT_SCOPE);
    }
    // The GTM scope should be granted for GTE support, but
    // it is possible for it not to be at this point.
    // This saves an extra OAuth flow and is necessary for the
    // Google tag sync at the end of the post-provisioning flow.
    if (!hasGTMScope) {
      scopes.push(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.GTM_SCOPE);
    }

    // If scope not granted, trigger scope error right away. These are
    // typically handled automatically based on API responses, but
    // this particular case has some special handling to improve UX.
    if (scopes.length > 0) {
      // When state is restored, auto-submit the request again.
      setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.FORM_ACCOUNT_CREATE, {
        autoSubmit: true
      });
      setPermissionScopeError({
        code: _js_util_errors__WEBPACK_IMPORTED_MODULE_24__.ERROR_CODE_MISSING_REQUIRED_SCOPE,
        message: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Additional permissions are required to create a new Analytics account.', 'google-site-kit'),
        data: {
          status: 403,
          scopes,
          skipModal: true
        }
      });
      return;
    }
    setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.FORM_ACCOUNT_CREATE, {
      autoSubmit: false
    });
    if (isInitialSetupFlow) {
      await (0,_js_util__WEBPACK_IMPORTED_MODULE_23__.trackEvent)(`${viewContext}_setup`, 'setup_flow_v3_create_analytics_account');
    } else {
      await (0,_js_util__WEBPACK_IMPORTED_MODULE_23__.trackEvent)(`${viewContext}_analytics`, 'create_account', 'proxy');
    }
    const {
      error
    } = await createAccount({
      showProgress: showProgress === 'true'
    });
    if (!error) {
      setConversionTrackingEnabled(true);
      await saveConversionTrackingSettings();
      setIsNavigating(true);
    }
  }, [hasEditScope, hasGTMScope, setValues, isInitialSetupFlow, createAccount, showProgress, setPermissionScopeError, viewContext, setConversionTrackingEnabled, saveConversionTrackingSettings]);

  // If the user ends up back on this component with the required scope granted,
  // and already submitted the form, trigger the submit again.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_31__.useEffect)(() => {
    if (hasRequiredScope && autoSubmit) {
      handleSubmit();
    }
  }, [hasRequiredScope, autoSubmit, handleSubmit]);

  // If the user clicks "Back", rollback settings to restore saved values, if any.
  const {
    rollbackSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.MODULES_ANALYTICS_4);
  const handleBack = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_31__.useCallback)(() => rollbackSettings(), [rollbackSettings]);
  if (isDoingCreateAccount || isNavigating || !hasResolvedAccounts || hasRequiredScope === undefined) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.ProgressBar, {});
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsxs)("div", {
    className: className,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_8__["default"], {
      moduleSlug: "analytics-4",
      storeName: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.MODULES_ANALYTICS_4
    }), !isInitialSetupFlow && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_9__["default"], {
      as: "h3",
      type: "title",
      size: "large",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Create your Analytics account', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__["default"], {
      size: isInitialSetupFlow ? 'large' : undefined,
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('We’ve pre-filled the required information for your new account. Confirm or edit any details:', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsxs)("div", {
      className: "googlesitekit-setup-module__inputs",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_18__.Cell, {
        size: 6,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_AccountField__WEBPACK_IMPORTED_MODULE_25__["default"], {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_18__.Cell, {
        size: 6,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_PropertyField__WEBPACK_IMPORTED_MODULE_27__["default"], {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_18__.Cell, {
        size: 6,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_WebDataStreamField__WEBPACK_IMPORTED_MODULE_29__["default"], {})
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsxs)("div", {
      className: "googlesitekit-setup-module__inputs",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_18__.Cell, {
        size: 6,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_CountrySelect__WEBPACK_IMPORTED_MODULE_26__["default"], {})
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_material_components__WEBPACK_IMPORTED_MODULE_18__.Cell, {
        size: 6,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_TimezoneSelect__WEBPACK_IMPORTED_MODULE_28__["default"], {})
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsxs)("div", {
      className: "googlesitekit-setup-module__inputs",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_modules_analytics_4_components_common__WEBPACK_IMPORTED_MODULE_19__.EnhancedMeasurementSwitch, {
        formName: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_21__.FORM_ACCOUNT_CREATE,
        className: "googlesitekit-margin-bottom-0"
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_components_conversion_tracking_SetupPluginConversionTrackingNotice__WEBPACK_IMPORTED_MODULE_5__["default"], {
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
          'googlesitekit-margin-top-0': !setupFlowRefreshEnabled
        }),
        message: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_33__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('To track how visitors interact with your site, Site Kit will enable plugin conversion tracking. You can always disable it in settings. <LearnMoreLink />', 'google-site-kit'), {
          LearnMoreLink: setupFlowRefreshEnabled ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_6__["default"], {
            href: pluginConversionsDocumentationURL,
            external: true,
            children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Learn more', 'google-site-kit')
          }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(_js_components_Null__WEBPACK_IMPORTED_MODULE_7__["default"], {})
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsxs)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_10__["default"], {
      className: "googlesitekit-analytics-setup__analytics-create-account-info",
      size: setupFlowRefreshEnabled ? 'small' : undefined,
      children: [hasRequiredScope && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)("span", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('You will be redirected to Google Analytics to accept the terms of service.', 'google-site-kit')
      }), !hasRequiredScope && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)("span", {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('You will need to give Site Kit permission to create an Analytics account on your behalf and also accept the Google Analytics terms of service.', 'google-site-kit')
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsxs)("div", {
      className: "googlesitekit-setup-module__action",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        disabled: !canSubmitAccountCreate,
        onClick: handleSubmit,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Create Account', 'google-site-kit')
      }), accounts && !!accounts.length && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_30__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_3__.Button, {
        className: "googlesitekit-setup-module__sub-action",
        onClick: handleBack,
        tertiary: true,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Back', 'google-site-kit')
      })]
    })]
  });
}
AccountCreate.propTypes = {
  className: (prop_types__WEBPACK_IMPORTED_MODULE_34___default().string)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountCreateLegacy.js":
/*!*************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountCreateLegacy.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccountCreateLegacy)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/StoreErrorNotices */ "./js/components/StoreErrorNotices.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _CreatePropertyInfoNotice__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./CreatePropertyInfoNotice */ "./js/modules/analytics-4/components/common/CreatePropertyInfoNotice.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Legacy Account Creation component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */









function AccountCreateLegacy() {
  const accounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getAccountSummaries());
  const hasResolvedAccounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).hasFinishedResolution('getAccountSummaries'));
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getAccountID());
  const isCreateAccount = _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.ACCOUNT_CREATE === accountID;
  const createAccountURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4).getServiceURL({
    path: '/provision/SignUp'
  }));
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_5__["default"])();
  const createAccountHandler = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async event => {
    event.preventDefault();
    await (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_analytics`, 'create_account', 'custom-oauth');
    __webpack_require__.g.open(createAccountURL, '_blank');
  }, [createAccountURL, viewContext]);
  const {
    resetAccountSummaries,
    resetAccountSettings
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4);
  const refetchAccountsHandler = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
    resetAccountSummaries();
    resetAccountSettings();
  }, [resetAccountSettings, resetAccountSummaries]);
  if (!hasResolvedAccounts) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, {});
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_CreatePropertyInfoNotice__WEBPACK_IMPORTED_MODULE_8__["default"], {}), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_StoreErrorNotices__WEBPACK_IMPORTED_MODULE_3__["default"], {
      moduleSlug: "analytics-4",
      storeName: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_6__.MODULES_ANALYTICS_4
    }), !isCreateAccount && accounts && accounts.length === 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__["default"], {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Looks like you don’t have an Analytics account yet. Once you create it, click on "Re-fetch my account" and Site Kit will locate it.', 'google-site-kit')
    }), isCreateAccount && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_wordpress_element__WEBPACK_IMPORTED_MODULE_10__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('To create a new account, click the button below which will open the Google Analytics account creation screen in a new window.', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__["default"], {
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Once completed, click the link below to re-fetch your accounts to continue.', 'google-site-kit')
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
      className: "googlesitekit-setup-module__action",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
        onClick: createAccountHandler,
        children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Create an account', 'google-site-kit')
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)("div", {
        className: "googlesitekit-setup-module__sub-action",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
          onClick: refetchAccountsHandler,
          tertiary: true,
          children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Re-fetch My Account', 'google-site-kit')
        })
      })]
    })]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/AccountSelect.js":
/*!*******************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/AccountSelect.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccountSelect)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Analytics-4 Account Select component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function AccountSelect({
  hasModuleAccess,
  onChange
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4).getAccountID());
  const accounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4).getAccountSummaries());
  const hasResolvedAccounts = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4).hasFinishedResolution('getAccountSummaries'));
  const {
    selectAccount
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4);
  const onAccountChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)((index, item) => {
    const newAccountID = item.dataset.value;
    if (accountID !== newAccountID) {
      selectAccount(newAccountID);
      const action = newAccountID === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.ACCOUNT_CREATE ? 'change_account_new' : 'change_account';
      (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_analytics`, action);
      if (onChange) {
        onChange();
      }
    }
  }, [accountID, selectAccount, viewContext, onChange]);
  if (!hasResolvedAccounts) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, {
      small: true
    });
  }
  if (hasModuleAccess === false) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
      className: "googlesitekit-analytics__select-account",
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Account', 'google-site-kit'),
      value: accountID,
      enhanced: true,
      outlined: true,
      disabled: true,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Option, {
        value: accountID,
        children: accountID
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Select, {
    className: "googlesitekit-analytics__select-account",
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Account', 'google-site-kit'),
    value: accountID,
    onEnhancedChange: onAccountChange,
    enhanced: true,
    outlined: true,
    children: (accounts || []).concat({
      _id: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.ACCOUNT_CREATE,
      displayName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Set up a new account', 'google-site-kit')
    }).map(({
      _id,
      displayName
    }, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Option, {
      value: _id,
      children: displayName
    }, index))
  });
}
AccountSelect.propTypes = {
  hasModuleAccess: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().bool)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/common/CreatePropertyInfoNotice.js":
/*!******************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/CreatePropertyInfoNotice.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CreatePropertyInfoNotice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Notice/constants */ "./js/components/Notice/constants.js");
/* harmony import */ var _js_components_Notice_index__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Notice/index */ "./js/components/Notice/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Analytics GA4 Notice component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function CreatePropertyInfoNotice() {
  const documentationURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => {
    return select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_SITE).getDocumentationLinkURL('ga4');
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Notice_index__WEBPACK_IMPORTED_MODULE_4__["default"], {
    type: _js_components_Notice_constants__WEBPACK_IMPORTED_MODULE_3__.TYPES.INFO,
    description: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Got a Google Analytics property and want to find out how to use it with Site Kit? <a>Learn more</a>', 'google-site-kit'), {
      a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: documentationURL,
        external: true
      })
    })
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/EnhancedMeasurementSwitch.js":
/*!*******************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/EnhancedMeasurementSwitch.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EnhancedMeasurementSwitch)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_SupportLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/SupportLink */ "./js/components/SupportLink.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _svg_icons_tick_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @/svg/icons/tick.svg */ "./svg/icons/tick.svg");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * EnhancedMeasurementSwitch component.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */










function EnhancedMeasurementSwitch({
  className,
  onClick,
  disabled = false,
  loading = false,
  formName = _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.ENHANCED_MEASUREMENT_FORM,
  isEnhancedMeasurementAlreadyEnabled = false,
  showTick = false
}) {
  const isEnhancedMeasurementEnabled = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_6__["default"])(formName, _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.ENHANCED_MEASUREMENT_ENABLED);
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_FORMS);
  const handleClick = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_12__.useCallback)(() => {
    setValues(formName, {
      [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.ENHANCED_MEASUREMENT_ENABLED]: !isEnhancedMeasurementEnabled
    });
    (0,_js_util__WEBPACK_IMPORTED_MODULE_9__.trackEvent)(`${viewContext}_analytics`,
    // If the current status of enhanced measurement is enabled,
    // then it means that we disabled it, otherwise enabled it.
    isEnhancedMeasurementEnabled ? 'deactivate_enhanced_measurement' : 'activate_enhanced_measurement');
    onClick?.();
  }, [formName, isEnhancedMeasurementEnabled, onClick, setValues, viewContext]);
  (0,react_use__WEBPACK_IMPORTED_MODULE_13__["default"])(() => {
    // Ensure the Enhanced Measurement activation banner won't be shown if we've updated the setting
    // via the switch.
    setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.ENHANCED_MEASUREMENT_FORM, {
      [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER]: true
    });
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-analytics-enable-enhanced-measurement', className, {
      'googlesitekit-analytics-enable-enhanced-measurement--loading': loading
    }),
    children: [loading && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {
      className: "googlesitekit-analytics-enable-enhanced-measurement__progress--settings-edit",
      small: true
    }), !loading && isEnhancedMeasurementAlreadyEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "googlesitekit-analytics-enable-enhanced-measurement__already-enabled-label",
      children: [showTick && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("div", {
        className: "googlesitekit-analytics-enable-enhanced-measurement__already-enabled-tick",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_svg_icons_tick_svg__WEBPACK_IMPORTED_MODULE_10__["default"], {})
      }), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enhanced measurement is enabled for this web data stream', 'google-site-kit')]
    }), !loading && !isEnhancedMeasurementAlreadyEnabled && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Switch, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Enable enhanced measurement', 'google-site-kit'),
      checked: isEnhancedMeasurementEnabled,
      disabled: disabled,
      onClick: handleClick,
      hideLabel: false
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)("p", {
      className: "googlesitekit-module-settings-group__helper-text",
      children: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_14__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('This allows you to measure interactions with your content (e.g. file downloads, form completions, video views). <a>Learn more</a>', 'google-site-kit'), {
        a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx)(_js_components_SupportLink__WEBPACK_IMPORTED_MODULE_4__["default"], {
          path: "/analytics/answer/9216061",
          external: true
        })
      })
    })]
  });
}
EnhancedMeasurementSwitch.propTypes = {
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().func),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().bool),
  loading: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().bool),
  isEnhancedMeasurementAlreadyEnabled: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().bool),
  showTick: (prop_types__WEBPACK_IMPORTED_MODULE_15___default().bool)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/common/PropertyHint.js":
/*!******************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/PropertyHint.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PropertyHint)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_setup_StepHint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/setup/StepHint */ "./js/components/setup/StepHint/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Analytics PropertyHint component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function PropertyHint() {
  const learnMoreLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('ga4-property'));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_setup_StepHint__WEBPACK_IMPORTED_MODULE_3__["default"], {
    leadingText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('What is an Analytics property?', 'google-site-kit'),
    tooltipText: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('An Analytics property is a container for data collected from a website. It represents a specific website, and within a property, you can view reports, manage data collection, attribution, privacy settings, and product links. <a>Learn more</a>', 'google-site-kit'), {
      a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: learnMoreLink,
        external: true,
        hideExternalIndicator: true
      })
    })
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/PropertySelect.js":
/*!********************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/PropertySelect.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PropertySelect)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/utils/validation */ "./js/modules/analytics-4/utils/validation.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GA4 Property Select component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function PropertySelect(props) {
  const {
    isDisabled,
    hasModuleAccess,
    className,
    onChange = () => {}
  } = props;
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).getAccountID());
  const properties = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => hasModuleAccess && !isDisabled ? select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).getPropertySummaries(accountID) || [] : null);
  const propertyID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).getPropertyID());
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    if (isDisabled) {
      return false;
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).isLoadingPropertySummaries() || select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).isLoadingWebDataStreams({
      hasModuleAccess
    });
  });
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const {
    selectProperty
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4);
  const onPropertyChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)((index, {
    dataset
  }) => {
    const newPropertyID = dataset.value;
    if (propertyID === newPropertyID) {
      return;
    }
    selectProperty(newPropertyID);
    (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_analytics`, newPropertyID === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.PROPERTY_CREATE ? 'change_property_new' : 'change_property', 'ga4');
    onChange();
  }, [onChange, propertyID, selectProperty, viewContext]);
  if (!(0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_6__.isValidAccountID)(accountID)) {
    return null;
  } else if (isLoading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {
      mobileVerticalSpacing: 76,
      desktopVerticalSpacing: 84,
      small: true
    });
  }
  const isValidSelection = propertyID === undefined || propertyID === '' ? true : (0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_6__.isValidPropertySelection)(propertyID);
  if (hasModuleAccess === false) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Select, {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-analytics-4__select-property', className),
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Property', 'google-site-kit'),
      value: propertyID,
      enhanced: true,
      outlined: true,
      disabled: true,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Option, {
        value: propertyID,
        children: propertyID
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Select, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-analytics-4__select-property', className, {
      'mdc-select--invalid': !isValidSelection,
      'googlesitekit-analytics-4__select-property--loaded': !isDisabled && !isLoading
    }),
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Property', 'google-site-kit'),
    value: propertyID,
    onEnhancedChange: onPropertyChange,
    disabled: isDisabled,
    enhanced: true,
    outlined: true,
    children: (properties || []).concat({
      _id: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.PROPERTY_CREATE,
      displayName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Set up a new property', 'google-site-kit')
    }).map(({
      _id,
      displayName
    }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Option, {
      value: _id,
      children: _id === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.PROPERTY_CREATE ? displayName : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: Property name. 2: Property ID. */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('%1$s (%2$s)', 'Analytics property name and ID', 'google-site-kit'), displayName, _id)
    }, _id))
  });
}
PropertySelect.propTypes = {
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  hasModuleAccess: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().func)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/common/TrackingExclusionSwitches.js":
/*!*******************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/TrackingExclusionSwitches.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TRACKING_CONTENT_CREATORS: () => (/* binding */ TRACKING_CONTENT_CREATORS),
/* harmony export */   TRACKING_LOGGED_IN_USERS: () => (/* binding */ TRACKING_LOGGED_IN_USERS),
/* harmony export */   "default": () => (/* binding */ TrackingExclusionSwitches),
/* harmony export */   trackingExclusionLabels: () => (/* binding */ trackingExclusionLabels)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_components_Typography__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/Typography */ "./js/components/Typography/index.js");
/* harmony import */ var _js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/Typography/P */ "./js/components/Typography/P.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Analytics 4 Tracking Exclusion switches component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






const TRACKING_LOGGED_IN_USERS = 'loggedinUsers';
const TRACKING_CONTENT_CREATORS = 'contentCreators';
const trackingExclusionLabels = {
  [TRACKING_LOGGED_IN_USERS]: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All logged-in users', 'google-site-kit'),
  [TRACKING_CONTENT_CREATORS]: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Users that can write posts', 'google-site-kit')
};
function TrackingExclusionSwitches() {
  const trackingDisabled = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).getTrackingDisabled());
  const {
    setTrackingDisabled
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4);
  let message;
  if (trackingDisabled && trackingDisabled.includes(TRACKING_LOGGED_IN_USERS)) {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All logged-in users will be excluded from Analytics tracking', 'google-site-kit');
  } else if (trackingDisabled && trackingDisabled.includes(TRACKING_CONTENT_CREATORS)) {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Users that can write posts will be excluded from Analytics tracking', 'google-site-kit');
  } else {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('All logged-in users will be included in Analytics tracking', 'google-site-kit');
  }
  const updateTrackingDisabled = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)((users, exclude) => {
    const trackingDisabledArray = exclude ? trackingDisabled.concat(users) : trackingDisabled.filter(item => item !== users);
    setTrackingDisabled(trackingDisabledArray);
  }, [trackingDisabled, setTrackingDisabled]);
  const onChangeTrackContentCreators = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(event => {
    const {
      checked: exclude
    } = event.target;
    updateTrackingDisabled(TRACKING_CONTENT_CREATORS, exclude);
  }, [updateTrackingDisabled]);
  const onChangeTrackLoggedInUsers = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(event => {
    const {
      checked: exclude
    } = event.target;
    updateTrackingDisabled(TRACKING_LOGGED_IN_USERS, exclude);
  }, [updateTrackingDisabled]);
  if (!Array.isArray(trackingDisabled)) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "googlesitekit-settings-module__fields-group",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Typography__WEBPACK_IMPORTED_MODULE_3__["default"], {
      as: "h4",
      size: "small",
      type: "title",
      className: "googlesitekit-settings-module__fields-group-title",
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Exclude Analytics', 'google-site-kit')
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
      className: "googlesitekit-settings-module__meta-item",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "googlesitekit-settings-module__inline-items",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "googlesitekit-settings-module__inline-item",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Switch, {
            label: trackingExclusionLabels[TRACKING_LOGGED_IN_USERS],
            checked: trackingDisabled.includes(TRACKING_LOGGED_IN_USERS),
            onClick: onChangeTrackLoggedInUsers,
            hideLabel: false
          })
        }), !trackingDisabled.includes(TRACKING_LOGGED_IN_USERS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)("div", {
          className: "googlesitekit-settings-module__inline-item",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Switch, {
            label: trackingExclusionLabels[TRACKING_CONTENT_CREATORS],
            checked: trackingDisabled.includes(TRACKING_CONTENT_CREATORS),
            onClick: onChangeTrackContentCreators,
            hideLabel: false
          })
        })]
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(_js_components_Typography_P__WEBPACK_IMPORTED_MODULE_4__["default"], {
        children: message
      })]
    })]
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/UseSnippetSwitch.js":
/*!**********************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/UseSnippetSwitch.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UseSnippetSwitch)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * GA4 Use Snippet Switch component.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function UseSnippetSwitch({
  description
}) {
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_3__["default"])();
  const useSnippet = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4).getUseSnippet());
  const {
    setUseSnippet
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_4__.MODULES_ANALYTICS_4);
  const onChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    const newUseSnippet = !useSnippet;
    setUseSnippet(newUseSnippet);
    (0,_js_util__WEBPACK_IMPORTED_MODULE_5__.trackEvent)(`${viewContext}_analytics`, newUseSnippet ? 'enable_tag' : 'disable_tag', 'ga4');
  }, [useSnippet, setUseSnippet, viewContext]);
  if (useSnippet === undefined) {
    return null;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
    className: "googlesitekit-analytics-usesnippet",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_1__.Switch, {
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Place Google Analytics code', 'google-site-kit'),
      checked: useSnippet,
      onClick: onChange,
      hideLabel: false
    }), description]
  });
}
UseSnippetSwitch.propTypes = {
  description: (prop_types__WEBPACK_IMPORTED_MODULE_8___default().node)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/common/WebDataStreamHint.js":
/*!***********************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/WebDataStreamHint.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WebDataStreamHint)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_components_Link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/components/Link */ "./js/components/Link.js");
/* harmony import */ var _js_components_setup_StepHint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/components/setup/StepHint */ "./js/components/setup/StepHint/index.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Analytics WebDataStreamHint component.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function WebDataStreamHint() {
  const learnMoreLink = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_4__.CORE_SITE).getDocumentationLinkURL('ga4-data-stream'));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_setup_StepHint__WEBPACK_IMPORTED_MODULE_3__["default"], {
    leadingText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('What is a web data stream?', 'google-site-kit'),
    tooltipText: (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"])((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('A data stream is a flow of data from your visitors to Analytics. When a data stream is created, Analytics generates a snippet of code that is added to your site to collect that data. <a>Learn more</a>', 'google-site-kit'), {
      a: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx)(_js_components_Link__WEBPACK_IMPORTED_MODULE_2__["default"], {
        href: learnMoreLink,
        external: true,
        hideExternalIndicator: true
      })
    })
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/WebDataStreamNameInput.js":
/*!****************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/WebDataStreamNameInput.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WebDataStreamNameInput)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_use__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-use */ "../node_modules/react-use/esm/useMount.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_components_AccessibleWarningIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/components/AccessibleWarningIcon */ "./js/components/AccessibleWarningIcon.js");
/* harmony import */ var _js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/googlesitekit/datastore/forms/constants */ "./js/googlesitekit/datastore/forms/constants.js");
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var _js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/hooks/useFormValue */ "./js/hooks/useFormValue.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @/js/modules/analytics-4/utils/validation */ "./js/modules/analytics-4/utils/validation.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Analytics WebDataStreamNameInput component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */









function WebDataStreamNameInput() {
  const propertyID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.MODULES_ANALYTICS_4).getPropertyID());
  const webDataStreamID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.MODULES_ANALYTICS_4).getWebDataStreamID());
  const webDataStreamName = (0,_js_hooks_useFormValue__WEBPACK_IMPORTED_MODULE_7__["default"])(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.FORM_SETUP, 'webDataStreamName');
  const webDataStreamAlreadyExists = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => (0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_9__.isValidPropertyID)(propertyID) ? select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.MODULES_ANALYTICS_4).doesWebDataStreamExist(propertyID, webDataStreamName) : false);
  const siteURL = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_6__.CORE_SITE).getReferenceSiteURL());
  const {
    setValues
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_googlesitekit_datastore_forms_constants__WEBPACK_IMPORTED_MODULE_5__.CORE_FORMS);
  const onChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_11__.useCallback)(({
    currentTarget
  }) => {
    setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.FORM_SETUP, {
      webDataStreamName: currentTarget.value
    });
  }, [setValues]);

  // Set the default web data stream name.
  (0,react_use__WEBPACK_IMPORTED_MODULE_12__["default"])(() => {
    if (!webDataStreamName && (0,_wordpress_url__WEBPACK_IMPORTED_MODULE_13__.isURL)(siteURL)) {
      const {
        hostname
      } = new URL(siteURL);
      setValues(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.FORM_SETUP, {
        webDataStreamName: hostname
      });
    }
  });

  // Return early if an existing web data stream is selected.
  if (webDataStreamID !== _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_8__.WEBDATASTREAM_CREATE) {
    return null;
  }
  const error = webDataStreamAlreadyExists || !webDataStreamName || !(0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_9__.isValidWebDataStreamName)(webDataStreamName);
  let helperText = false;
  if (webDataStreamAlreadyExists) {
    helperText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('A web data stream with this name already exists.', 'google-site-kit');
  } else if (!webDataStreamName) {
    helperText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('A web data stream name is required.', 'google-site-kit');
  } else if (!(0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_9__.isValidWebDataStreamName)(webDataStreamName)) {
    helperText = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('This is not a valid web data stream name.', 'google-site-kit');
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("div", {
    className: "googlesitekit-analytics-webdatastreamname",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.TextField, {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()({
        'mdc-text-field--error': error
      }),
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Web data stream name', 'google-site-kit'),
      helperText: helperText,
      trailingIcon: error && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)("span", {
        className: "googlesitekit-text-field-icon--error",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_10__.jsx)(_js_components_AccessibleWarningIcon__WEBPACK_IMPORTED_MODULE_4__["default"], {})
      }),
      value: webDataStreamName,
      onChange: onChange,
      outlined: true
    })
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/components/common/WebDataStreamSelect.js":
/*!*************************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/WebDataStreamSelect.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WebDataStreamSelect)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/react/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! googlesitekit-components */ "googlesitekit-components");
/* harmony import */ var googlesitekit_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/hooks/useViewContext */ "./js/hooks/useViewContext.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/js/modules/analytics-4/utils/validation */ "./js/modules/analytics-4/utils/validation.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */







function WebDataStreamSelect(props) {
  const {
    hasModuleAccess,
    isDisabled,
    className,
    onChange
  } = props;
  const accountID = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).getAccountID());
  const {
    propertyID,
    webDataStreamID,
    measurementID
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).getSettings() || {});
  const webDataStreams = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => (0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_6__.isValidPropertyID)(propertyID) && hasModuleAccess ? select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).getWebDataStreams(propertyID) : []);
  const isLoading = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    if (isDisabled) {
      return false;
    }
    return select(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4).isLoadingWebDataStreams({
      hasModuleAccess
    });
  });
  const viewContext = (0,_js_hooks_useViewContext__WEBPACK_IMPORTED_MODULE_4__["default"])();
  const {
    setWebDataStreamID,
    updateSettingsForMeasurementID
  } = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)(_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.MODULES_ANALYTICS_4);
  const onWebDataStreamChange = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_9__.useCallback)((index, {
    dataset
  }) => {
    const newID = dataset.value;
    if (webDataStreamID === newID) {
      return;
    }
    setWebDataStreamID(newID);
    updateSettingsForMeasurementID(webDataStreams.find(({
      _id
    }) => _id === newID)?.webStreamData?.measurementId || '' // eslint-disable-line sitekit/acronym-case
    );
    (0,_js_util__WEBPACK_IMPORTED_MODULE_7__.trackEvent)(`${viewContext}_analytics`, newID === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.WEBDATASTREAM_CREATE ? 'change_webdatastream_new' : 'change_webdatastream', 'ga4');
    if (onChange) {
      onChange();
    }
  }, [webDataStreams, webDataStreamID, setWebDataStreamID, updateSettingsForMeasurementID, viewContext, onChange]);
  if (!(0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_6__.isValidAccountID)(accountID)) {
    return null;
  } else if (isLoading) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.ProgressBar, {
      mobileVerticalSpacing: 76,
      desktopVerticalSpacing: 84,
      small: true
    });
  }
  const isValidSelection = webDataStreamID === undefined || webDataStreamID === '' ? true : (0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_6__.isValidWebDataStreamSelection)(webDataStreamID);
  if (hasModuleAccess === false) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Select, {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-analytics-4__select-webdatastream', className),
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Web data stream', 'google-site-kit'),
      value: measurementID,
      enhanced: true,
      outlined: true,
      disabled: true,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Option, {
        value: measurementID,
        children: measurementID
      })
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Select, {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-analytics-4__select-webdatastream', className, {
      'mdc-select--invalid': !isValidSelection
    }),
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Web data stream', 'google-site-kit'),
    value: webDataStreamID,
    onEnhancedChange: onWebDataStreamChange,
    disabled: isDisabled || !(0,_js_modules_analytics_4_utils_validation__WEBPACK_IMPORTED_MODULE_6__.isValidPropertySelection)(propertyID),
    enhanced: true,
    outlined: true,
    children: (webDataStreams || []).concat({
      _id: _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.WEBDATASTREAM_CREATE,
      displayName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Set up a new web data stream', 'google-site-kit')
    }).map(({
      _id,
      displayName,
      webStreamData = {}
    }, index) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx)(googlesitekit_components__WEBPACK_IMPORTED_MODULE_2__.Option, {
      value: _id,
      children: _id === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_5__.WEBDATASTREAM_CREATE || !webStreamData?.measurementId // eslint-disable-line sitekit/acronym-case
      ? displayName : (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)(/* translators: 1: Data stream name. 2: Measurement ID. */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__._x)('%1$s (%2$s)', 'Analytics data stream name and measurement ID', 'google-site-kit'), displayName, webStreamData.measurementId // eslint-disable-line sitekit/acronym-case
      )
    }, index))
  });
}
WebDataStreamSelect.propTypes = {
  hasModuleAccess: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_10___default().string)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/common/ZeroDataMessage.js":
/*!*********************************************************************!*\
  !*** ./js/modules/analytics-4/components/common/ZeroDataMessage.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ZeroDataMessage)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! googlesitekit-data */ "googlesitekit-data");
/* harmony import */ var googlesitekit_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/googlesitekit/datastore/site/constants */ "./js/googlesitekit/datastore/site/constants.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Analytics ZeroDataMessage component.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function ZeroDataMessage({
  skipPrefix
}) {
  const url = (0,googlesitekit_data__WEBPACK_IMPORTED_MODULE_1__.useSelect)(select => select(_js_googlesitekit_datastore_site_constants__WEBPACK_IMPORTED_MODULE_2__.CORE_SITE).getCurrentEntityURL());
  if (skipPrefix) {
    return url ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your page hasn’t received any visitors yet', 'google-site-kit')
    }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
      children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your site hasn’t received any visitors yet', 'google-site-kit')
    });
  }
  return url ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No data to display: your page hasn’t received any visitors yet', 'google-site-kit')
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("span", {
    children: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('No data to display: your site hasn’t received any visitors yet', 'google-site-kit')
  });
}
ZeroDataMessage.propTypes = {
  skipPrefix: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool)
};

/***/ }),

/***/ "./js/modules/analytics-4/components/common/index.js":
/*!***********************************************************!*\
  !*** ./js/modules/analytics-4/components/common/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountCreate: () => (/* reexport safe */ _AccountCreate__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   AccountCreateLegacy: () => (/* reexport safe */ _AccountCreateLegacy__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   AccountSelect: () => (/* reexport safe */ _AccountSelect__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   CreatePropertyInfoNotice: () => (/* reexport safe */ _CreatePropertyInfoNotice__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   EnhancedMeasurementSwitch: () => (/* reexport safe */ _EnhancedMeasurementSwitch__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   PropertyHint: () => (/* reexport safe */ _PropertyHint__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   PropertySelect: () => (/* reexport safe */ _PropertySelect__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   TrackingExclusionSwitches: () => (/* reexport safe */ _TrackingExclusionSwitches__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   UseSnippetSwitch: () => (/* reexport safe */ _UseSnippetSwitch__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   WebDataStreamHint: () => (/* reexport safe */ _WebDataStreamHint__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   WebDataStreamNameInput: () => (/* reexport safe */ _WebDataStreamNameInput__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   WebDataStreamSelect: () => (/* reexport safe */ _WebDataStreamSelect__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   ZeroDataMessage: () => (/* reexport safe */ _ZeroDataMessage__WEBPACK_IMPORTED_MODULE_12__["default"])
/* harmony export */ });
/* harmony import */ var _AccountCreate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AccountCreate */ "./js/modules/analytics-4/components/common/AccountCreate/index.js");
/* harmony import */ var _AccountCreateLegacy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AccountCreateLegacy */ "./js/modules/analytics-4/components/common/AccountCreateLegacy.js");
/* harmony import */ var _AccountSelect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AccountSelect */ "./js/modules/analytics-4/components/common/AccountSelect.js");
/* harmony import */ var _CreatePropertyInfoNotice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CreatePropertyInfoNotice */ "./js/modules/analytics-4/components/common/CreatePropertyInfoNotice.js");
/* harmony import */ var _EnhancedMeasurementSwitch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./EnhancedMeasurementSwitch */ "./js/modules/analytics-4/components/common/EnhancedMeasurementSwitch.js");
/* harmony import */ var _PropertyHint__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./PropertyHint */ "./js/modules/analytics-4/components/common/PropertyHint.js");
/* harmony import */ var _PropertySelect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./PropertySelect */ "./js/modules/analytics-4/components/common/PropertySelect.js");
/* harmony import */ var _TrackingExclusionSwitches__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./TrackingExclusionSwitches */ "./js/modules/analytics-4/components/common/TrackingExclusionSwitches.js");
/* harmony import */ var _WebDataStreamHint__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./WebDataStreamHint */ "./js/modules/analytics-4/components/common/WebDataStreamHint.js");
/* harmony import */ var _WebDataStreamNameInput__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./WebDataStreamNameInput */ "./js/modules/analytics-4/components/common/WebDataStreamNameInput.js");
/* harmony import */ var _WebDataStreamSelect__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./WebDataStreamSelect */ "./js/modules/analytics-4/components/common/WebDataStreamSelect.js");
/* harmony import */ var _UseSnippetSwitch__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./UseSnippetSwitch */ "./js/modules/analytics-4/components/common/UseSnippetSwitch.js");
/* harmony import */ var _ZeroDataMessage__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./ZeroDataMessage */ "./js/modules/analytics-4/components/common/ZeroDataMessage.js");
/**
 * GA4 common components.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */















/***/ }),

/***/ "./js/modules/analytics-4/constants.js":
/*!*********************************************!*\
  !*** ./js/modules/analytics-4/constants.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY: () => (/* binding */ ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY),
/* harmony export */   ACTIVATION_STEP_IN_PROGRESS: () => (/* binding */ ACTIVATION_STEP_IN_PROGRESS),
/* harmony export */   ACTIVATION_STEP_REMINDER: () => (/* binding */ ACTIVATION_STEP_REMINDER),
/* harmony export */   ACTIVATION_STEP_SETUP: () => (/* binding */ ACTIVATION_STEP_SETUP),
/* harmony export */   ACTIVATION_STEP_SUCCESS: () => (/* binding */ ACTIVATION_STEP_SUCCESS),
/* harmony export */   ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY: () => (/* binding */ ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY),
/* harmony export */   GA4_ACTIVATION_BANNER_STATE_KEY: () => (/* binding */ GA4_ACTIVATION_BANNER_STATE_KEY),
/* harmony export */   GA4_AUTO_SWITCH_DATE: () => (/* binding */ GA4_AUTO_SWITCH_DATE),
/* harmony export */   KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY: () => (/* binding */ KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY),
/* harmony export */   LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY: () => (/* binding */ LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY),
/* harmony export */   MODULE_SLUG_ANALYTICS_4: () => (/* binding */ MODULE_SLUG_ANALYTICS_4),
/* harmony export */   REPORT_ARGS_DATA_FILTERS_KEY: () => (/* binding */ REPORT_ARGS_DATA_FILTERS_KEY),
/* harmony export */   REPORT_ARGS_NAV_KEY: () => (/* binding */ REPORT_ARGS_NAV_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_DIMENSION_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_DIMENSION_KEY),
/* harmony export */   REPORT_ARGS_SELECTED_METRIC_KEY: () => (/* binding */ REPORT_ARGS_SELECTED_METRIC_KEY)
/* harmony export */ });
/**
 * GA4 module constants.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const ACTIVATION_STEP_REMINDER = 0;
const ACTIVATION_STEP_SETUP = 1;
const ACTIVATION_STEP_SUCCESS = 2;
const ACTIVATION_STEP_IN_PROGRESS = 3;
const ACTIVATION_ACKNOWLEDGEMENT_TOOLTIP_STATE_KEY = 'activation-acknowledgement-tooltip-state';
const GA4_ACTIVATION_BANNER_STATE_KEY = 'ga4-activation-banner-state';
const ENHANCED_MEASUREMENT_ACTIVATION_BANNER_TOOLTIP_STATE_KEY = 'enhanced-measurement-activation-banner-tooltip-state';
const LEGACY_ENHANCED_MEASUREMENT_ACTIVATION_BANNER_DISMISSED_ITEM_KEY = 'enhanced-measurement-activation-banner-dismissed-item';
const REPORT_ARGS_SELECTED_METRIC_KEY = '_r.explorerCard..selmet';
const REPORT_ARGS_SELECTED_DIMENSION_KEY = '_r.explorerCard..seldim';
const REPORT_ARGS_DATA_FILTERS_KEY = '_r..dataFilters';
const REPORT_ARGS_NAV_KEY = '_r..nav';
const KM_CONNECT_GA4_CTA_WIDGET_DISMISSED_ITEM_KEY = 'key-metrics-connect-ga4-cta-widget';

/**
 * Date that Site Kit will automatically switch to using GA4: September 25, 2023.
 *
 * With Site Kit's maximum date range being three months, once this period has passed since the UA cutoff date,
 * it will no longer be able to show any historical data for UA and will automatically switch to GA4.
 * For operational reasons, we automatically make the switch a few days before the three month cutoff point.
 *
 * @since 1.107.0
 * @see UA_CUTOFF_DATE.
 */
const GA4_AUTO_SWITCH_DATE = '2023-09-25';
const MODULE_SLUG_ANALYTICS_4 = 'analytics-4';

/***/ }),

/***/ "./js/modules/analytics-4/datastore/constants.js":
/*!*******************************************************!*\
  !*** ./js/modules/analytics-4/datastore/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCOUNT_CREATE: () => (/* binding */ ACCOUNT_CREATE),
/* harmony export */   AUDIENCE_FILTER_CLAUSE_TYPE_ENUM: () => (/* binding */ AUDIENCE_FILTER_CLAUSE_TYPE_ENUM),
/* harmony export */   AUDIENCE_FILTER_SCOPE_ENUM: () => (/* binding */ AUDIENCE_FILTER_SCOPE_ENUM),
/* harmony export */   AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX: () => (/* binding */ AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX),
/* harmony export */   AUDIENCE_SEGMENTATION_SETUP_FORM: () => (/* binding */ AUDIENCE_SEGMENTATION_SETUP_FORM),
/* harmony export */   AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE: () => (/* binding */ AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE),
/* harmony export */   AUDIENCE_TYPE_SORT_ORDER: () => (/* binding */ AUDIENCE_TYPE_SORT_ORDER),
/* harmony export */   CONVERSION_REPORTING_LEAD_EVENTS: () => (/* binding */ CONVERSION_REPORTING_LEAD_EVENTS),
/* harmony export */   CUSTOM_DIMENSION_DEFINITIONS: () => (/* binding */ CUSTOM_DIMENSION_DEFINITIONS),
/* harmony export */   DATE_RANGE_OFFSET: () => (/* binding */ DATE_RANGE_OFFSET),
/* harmony export */   EDIT_SCOPE: () => (/* binding */ EDIT_SCOPE),
/* harmony export */   ENHANCED_MEASUREMENT_ENABLED: () => (/* binding */ ENHANCED_MEASUREMENT_ENABLED),
/* harmony export */   ENHANCED_MEASUREMENT_FORM: () => (/* binding */ ENHANCED_MEASUREMENT_FORM),
/* harmony export */   ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER: () => (/* binding */ ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER),
/* harmony export */   ENUM_CONVERSION_EVENTS: () => (/* binding */ ENUM_CONVERSION_EVENTS),
/* harmony export */   FORM_ACCOUNT_CREATE: () => (/* binding */ FORM_ACCOUNT_CREATE),
/* harmony export */   FORM_CUSTOM_DIMENSIONS_CREATE: () => (/* binding */ FORM_CUSTOM_DIMENSIONS_CREATE),
/* harmony export */   FORM_SETUP: () => (/* binding */ FORM_SETUP),
/* harmony export */   GTM_SCOPE: () => (/* binding */ GTM_SCOPE),
/* harmony export */   MAX_WEBDATASTREAMS_PER_BATCH: () => (/* binding */ MAX_WEBDATASTREAMS_PER_BATCH),
/* harmony export */   MODULES_ANALYTICS_4: () => (/* binding */ MODULES_ANALYTICS_4),
/* harmony export */   PROPERTY_CREATE: () => (/* binding */ PROPERTY_CREATE),
/* harmony export */   PROVISIONING_SCOPE: () => (/* binding */ PROVISIONING_SCOPE),
/* harmony export */   RESOURCE_TYPES: () => (/* binding */ RESOURCE_TYPES),
/* harmony export */   RESOURCE_TYPE_AUDIENCE: () => (/* binding */ RESOURCE_TYPE_AUDIENCE),
/* harmony export */   RESOURCE_TYPE_CUSTOM_DIMENSION: () => (/* binding */ RESOURCE_TYPE_CUSTOM_DIMENSION),
/* harmony export */   RESOURCE_TYPE_PROPERTY: () => (/* binding */ RESOURCE_TYPE_PROPERTY),
/* harmony export */   SITE_KIT_AUDIENCE_DEFINITIONS: () => (/* binding */ SITE_KIT_AUDIENCE_DEFINITIONS),
/* harmony export */   UI_ACTIVE_ROW_INDEX: () => (/* binding */ UI_ACTIVE_ROW_INDEX),
/* harmony export */   UI_ALL_TRAFFIC_LOADED: () => (/* binding */ UI_ALL_TRAFFIC_LOADED),
/* harmony export */   UI_DIMENSION_COLOR: () => (/* binding */ UI_DIMENSION_COLOR),
/* harmony export */   UI_DIMENSION_NAME: () => (/* binding */ UI_DIMENSION_NAME),
/* harmony export */   UI_DIMENSION_VALUE: () => (/* binding */ UI_DIMENSION_VALUE),
/* harmony export */   WEBDATASTREAM_CREATE: () => (/* binding */ WEBDATASTREAM_CREATE)
/* harmony export */ });
/**
 * `modules/analytics-4` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_ANALYTICS_4 = 'modules/analytics-4';

// A special Account ID value used for the "Set up a new account" option.
const ACCOUNT_CREATE = 'account_create';

// A special Property ID value used for the "Set up a new property" option.
const PROPERTY_CREATE = 'property_create';
const WEBDATASTREAM_CREATE = 'webdatastream_create';
const FORM_SETUP = 'analyticsSetup';
const MAX_WEBDATASTREAMS_PER_BATCH = 10;

// Date range offset days for Analytics 4 report requests.
const DATE_RANGE_OFFSET = 0;
const GTM_SCOPE = 'https://www.googleapis.com/auth/tagmanager.readonly';
const ENHANCED_MEASUREMENT_FORM = 'enhanced-measurement-form';
const ENHANCED_MEASUREMENT_ENABLED = 'enhanced-measurement-enabled';
const ENHANCED_MEASUREMENT_SHOULD_DISMISS_ACTIVATION_BANNER = 'enhanced-measurement-should-dismiss-activation-banner';

// Form ID for the account creation form.
const FORM_ACCOUNT_CREATE = 'analyticsAccountCreate';
const FORM_CUSTOM_DIMENSIONS_CREATE = 'analyticsCustomDimensionsCreate';

// OAuth scope required for provisioning a Google Analytics account.
const PROVISIONING_SCOPE = 'https://www.googleapis.com/auth/analytics.provision';
const EDIT_SCOPE = 'https://www.googleapis.com/auth/analytics.edit';

// Dashboard widget constants.
const UI_DIMENSION_NAME = 'dashboardAllTrafficWidgetDimensionName';
const UI_DIMENSION_COLOR = 'dashboardAllTrafficWidgetDimensionColor';
const UI_DIMENSION_VALUE = 'dashboardAllTrafficWidgetDimensionValue';
const UI_ACTIVE_ROW_INDEX = 'dashboardAllTrafficWidgetActiveRowIndex';
const UI_ALL_TRAFFIC_LOADED = 'dashboardAllTrafficWidgetLoaded';

// Note: names and descriptions are not translated as these are not surfaced in Site Kit
// and are also subject to hard limits on the length which would be unpredictable if translated.
// See https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1beta/properties.customDimensions#CustomDimension
const CUSTOM_DIMENSION_DEFINITIONS = {
  googlesitekit_post_date: {
    parameterName: 'googlesitekit_post_date',
    displayName: 'WordPress Post Date',
    description: 'Created by Site Kit: Date when a post was published',
    scope: 'EVENT'
  },
  googlesitekit_post_author: {
    parameterName: 'googlesitekit_post_author',
    displayName: 'WordPress Post Author',
    description: 'Created by Site Kit: WordPress name of the post author',
    scope: 'EVENT'
  },
  googlesitekit_post_categories: {
    parameterName: 'googlesitekit_post_categories',
    displayName: 'WordPress Post Categories',
    description: 'Created by Site Kit: Names of categories assigned to a post',
    scope: 'EVENT'
  },
  googlesitekit_post_type: {
    parameterName: 'googlesitekit_post_type',
    displayName: 'WordPress Post Type',
    description: 'Created by Site Kit: Content type of a post',
    scope: 'EVENT'
  }
};
const ENUM_CONVERSION_EVENTS = {
  ADD_TO_CART: 'add_to_cart',
  PURCHASE: 'purchase',
  SUBMIT_LEAD_FORM: 'submit_lead_form',
  GENERATE_LEAD: 'generate_lead',
  CONTACT: 'contact'
};
const CONVERSION_REPORTING_LEAD_EVENTS = [ENUM_CONVERSION_EVENTS.CONTACT, ENUM_CONVERSION_EVENTS.GENERATE_LEAD, ENUM_CONVERSION_EVENTS.SUBMIT_LEAD_FORM];

// Audience enums.
const AUDIENCE_FILTER_CLAUSE_TYPE_ENUM = {
  AUDIENCE_CLAUSE_TYPE_UNSPECIFIED: 'AUDIENCE_CLAUSE_TYPE_UNSPECIFIED',
  INCLUDE: 'INCLUDE',
  EXCLUDE: 'EXCLUDE'
};
const AUDIENCE_FILTER_SCOPE_ENUM = {
  AUDIENCE_FILTER_SCOPE_UNSPECIFIED: 'AUDIENCE_FILTER_SCOPE_UNSPECIFIED',
  AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT: 'AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT',
  AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION: 'AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION',
  AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS'
};
const SITE_KIT_AUDIENCE_DEFINITIONS = {
  'new-visitors': {
    description: 'People who visited the site for the first time',
    displayName: 'New visitors',
    membershipDurationDays: -1,
    // The longest duration, 540 days.
    filterClauses: [{
      clauseType: 'INCLUDE',
      simpleFilter: {
        scope: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS',
        filterExpression: {
          andGroup: {
            filterExpressions: [{
              orGroup: {
                filterExpressions: [{
                  dimensionOrMetricFilter: {
                    fieldName: 'newVsReturning',
                    stringFilter: {
                      matchType: 'EXACT',
                      value: 'new'
                    }
                  }
                }]
              }
            }, {
              orGroup: {
                filterExpressions: [{
                  notExpression: {
                    dimensionOrMetricFilter: {
                      fieldName: 'groupId',
                      stringFilter: {
                        matchType: 'EXACT',
                        value: 'created_by_googlesitekit:new_visitors'
                      }
                    }
                  }
                }]
              }
            }]
          }
        }
      }
    }]
  },
  'returning-visitors': {
    description: 'People who have visited your site at least once before',
    displayName: 'Returning visitors',
    membershipDurationDays: -1,
    // The longest duration, 540 days.
    filterClauses: [{
      clauseType: 'INCLUDE',
      simpleFilter: {
        scope: 'AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS',
        filterExpression: {
          andGroup: {
            filterExpressions: [{
              orGroup: {
                filterExpressions: [{
                  dimensionOrMetricFilter: {
                    fieldName: 'newVsReturning',
                    stringFilter: {
                      matchType: 'EXACT',
                      value: 'returning'
                    }
                  }
                }]
              }
            }, {
              orGroup: {
                filterExpressions: [{
                  notExpression: {
                    dimensionOrMetricFilter: {
                      fieldName: 'groupId',
                      stringFilter: {
                        matchType: 'EXACT',
                        value: 'created_by_googlesitekit:returning_visitors'
                      }
                    }
                  }
                }]
              }
            }]
          }
        }
      }
    }]
  }
};
const AUDIENCE_SEGMENTATION_SETUP_FORM = 'audiencePermissionsSetup';
const AUDIENCE_TILE_CUSTOM_DIMENSION_CREATE = 'audienceTileCustomDimensionCreate';
const AUDIENCE_TYPE_SORT_ORDER = {
  USER_AUDIENCE: 0,
  SITE_KIT_AUDIENCE: 1,
  DEFAULT_AUDIENCE: 2
};
const AUDIENCE_ITEM_NEW_BADGE_SLUG_PREFIX = 'audience-selection-panel-expirable-new-badge-';
const RESOURCE_TYPE_AUDIENCE = 'audience';
const RESOURCE_TYPE_CUSTOM_DIMENSION = 'customDimension';
const RESOURCE_TYPE_PROPERTY = 'property';
const RESOURCE_TYPES = [RESOURCE_TYPE_AUDIENCE, RESOURCE_TYPE_CUSTOM_DIMENSION, RESOURCE_TYPE_PROPERTY];

/***/ }),

/***/ "./js/modules/analytics-4/utils/account.js":
/*!*************************************************!*\
  !*** ./js/modules/analytics-4/utils/account.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAccountDefaults: () => (/* binding */ getAccountDefaults),
/* harmony export */   populateAccountID: () => (/* binding */ populateAccountID),
/* harmony export */   populateAccountSummaries: () => (/* binding */ populateAccountSummaries),
/* harmony export */   populatePropertyAndAccountIds: () => (/* binding */ populatePropertyAndAccountIds)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _countries_timezones__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./countries-timezones */ "./js/modules/analytics-4/utils/countries-timezones.js");
/**
 * Account helpers.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Gets default values for a new account.
 *
 * @since 1.98.0
 * @since 1.111.0 Added enhanced measurement enabled state to return value.
 *
 * @param {Object} args              Site information.
 * @param {string} args.siteName     Site name.
 * @param {string} args.siteURL      Site home URL.
 * @param {string} args.timezone     Site timezone.
 * @param {string} _fallbackTimezone Fallback timezone. Defaults to local timezone.
 *                                   This parameter should only be used for providing a deterministic fallback in tests.
 * @return {Object} Default property values for a new account.
 */
function getAccountDefaults({
  siteName,
  siteURL,
  timezone
}, _fallbackTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_wordpress_url__WEBPACK_IMPORTED_MODULE_3__.isURL)(siteURL), 'A valid siteURL is required.');
  const {
    hostname,
    pathname
  } = new URL(siteURL);
  return {
    accountName: siteName || hostname,
    propertyName: `${hostname}${pathname}`.replace(/\/$/, ''),
    dataStreamName: hostname,
    countryCode: _countries_timezones__WEBPACK_IMPORTED_MODULE_2__.countryCodesByTimezone[timezone] || _countries_timezones__WEBPACK_IMPORTED_MODULE_2__.countryCodesByTimezone[_fallbackTimezone],
    timezone: _countries_timezones__WEBPACK_IMPORTED_MODULE_2__.countryCodesByTimezone[timezone] ? timezone : _fallbackTimezone,
    [_js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_1__.ENHANCED_MEASUREMENT_ENABLED]: true
  };
}

/**
 * Appends an account ID to an account object.
 *
 * @since 1.138.0
 *
 * @param {Object} account Account object.
 * @return {Object} Account object with an appended ID.
 */
function populateAccountID(account) {
  const matches = account.account?.match(/accounts\/([^/]+)/);
  const _id = matches?.[1];
  return {
    ...account,
    _id
  };
}

/**
 * Appends property and account IDs to a property object.
 *
 * @since 1.138.0
 *
 * @param {Object} property Property object.
 * @return {Object} Property object with appended IDs.
 */
function populatePropertyAndAccountIds(property) {
  const propertyMatches = property.property?.match(/properties\/([^/]+)/);
  const _id = propertyMatches?.[1];
  const accountMatches = property.parent?.match(/accounts\/([^/]+)/);
  const _accountID = accountMatches?.[1];
  return {
    ...property,
    _id,
    _accountID
  };
}

/**
 * Populates a list of accountSummaries with IDs for accounts and properties.
 *
 * @since 1.147.0
 *
 * @param {Array|unknown} accountSummaries Account summaries to populate.
 * @return {Array|unknown} Populated account summaries or given value if not an array.
 */
function populateAccountSummaries(accountSummaries) {
  if (!Array.isArray(accountSummaries)) {
    return accountSummaries;
  }
  return accountSummaries.map(account => {
    return {
      ...populateAccountID(account),
      propertySummaries: (account.propertySummaries || []).map(property => populatePropertyAndAccountIds(property))
    };
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/countries-data.js":
/*!********************************************************!*\
  !*** ./js/modules/analytics-4/utils/countries-data.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   countries: () => (/* binding */ countries)
/* harmony export */ });
/* eslint-disable sitekit/acronym-case */
const countries = {
  default: {
    defaultCountryCode: 'US',
    country: [{
      countryCode: 'AF',
      displayName: 'Afghanistan',
      defaultTimeZoneId: 'Asia/Kabul',
      timeZone: [{
        timeZoneId: 'Asia/Kabul',
        displayName: '(GMT+04:30) Afghanistan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'AL',
      displayName: 'Albania',
      defaultTimeZoneId: 'Europe/Tirane',
      timeZone: [{
        timeZoneId: 'Europe/Tirane',
        displayName: '(GMT+02:00) Albania Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'DZ',
      displayName: 'Algeria',
      defaultTimeZoneId: 'Africa/Algiers',
      timeZone: [{
        timeZoneId: 'Africa/Algiers',
        displayName: '(GMT+01:00) Algeria Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'AS',
      displayName: 'American Samoa',
      defaultTimeZoneId: 'Pacific/Pago_Pago',
      timeZone: [{
        timeZoneId: 'Pacific/Pago_Pago',
        displayName: '(GMT-11:00) American Samoa Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'AD',
      displayName: 'Andorra',
      defaultTimeZoneId: 'Europe/Andorra',
      timeZone: [{
        timeZoneId: 'Europe/Andorra',
        displayName: '(GMT+02:00) Andorra Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'AQ',
      displayName: 'Antarctica',
      defaultTimeZoneId: 'Antarctica/Palmer',
      timeZone: [{
        timeZoneId: 'Antarctica/Palmer',
        displayName: '(GMT-03:00) Palmer Time'
      }, {
        timeZoneId: 'Antarctica/Rothera',
        displayName: '(GMT-03:00) Rothera Time'
      }, {
        timeZoneId: 'Antarctica/Syowa',
        displayName: '(GMT+03:00) Syowa Time'
      }, {
        timeZoneId: 'Antarctica/Mawson',
        displayName: '(GMT+05:00) Mawson Time'
      }, {
        timeZoneId: 'Antarctica/Vostok',
        displayName: '(GMT+06:00) Vostok Time'
      }, {
        timeZoneId: 'Antarctica/Davis',
        displayName: '(GMT+07:00) Davis Time'
      }, {
        timeZoneId: 'Antarctica/Casey',
        displayName: '(GMT+08:00) Casey Time'
      }, {
        timeZoneId: 'Antarctica/DumontDUrville',
        displayName: '(GMT+10:00) Dumont d\u2019Urville Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'AR',
      displayName: 'Argentina',
      defaultTimeZoneId: 'America/Buenos_Aires',
      timeZone: [{
        timeZoneId: 'America/Buenos_Aires',
        displayName: '(GMT-03:00) Buenos Aires Time'
      }, {
        timeZoneId: 'America/Cordoba',
        displayName: '(GMT-03:00) Cordoba Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'AM',
      displayName: 'Armenia',
      defaultTimeZoneId: 'Asia/Yerevan',
      timeZone: [{
        timeZoneId: 'Asia/Yerevan',
        displayName: '(GMT+04:00) Armenia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'AU',
      displayName: 'Australia',
      defaultTimeZoneId: 'Australia/Perth',
      timeZone: [{
        timeZoneId: 'Australia/Perth',
        displayName: '(GMT+08:00) Perth Time'
      }, {
        timeZoneId: 'Australia/Adelaide',
        displayName: '(GMT+09:30) Adelaide Time'
      }, {
        timeZoneId: 'Australia/Darwin',
        displayName: '(GMT+09:30) Darwin Time'
      }, {
        timeZoneId: 'Australia/Brisbane',
        displayName: '(GMT+10:00) Brisbane Time'
      }, {
        timeZoneId: 'Australia/Hobart',
        displayName: '(GMT+10:00) Hobart Time'
      }, {
        timeZoneId: 'Australia/Melbourne',
        displayName: '(GMT+10:00) Melbourne Time'
      }, {
        timeZoneId: 'Australia/Sydney',
        displayName: '(GMT+10:00) Sydney Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'AT',
      displayName: 'Austria',
      defaultTimeZoneId: 'Europe/Vienna',
      timeZone: [{
        timeZoneId: 'Europe/Vienna',
        displayName: '(GMT+02:00) Austria Time'
      }],
      tosLocale: {
        language: 'de',
        country: 'DE'
      }
    }, {
      countryCode: 'AZ',
      displayName: 'Azerbaijan',
      defaultTimeZoneId: 'Asia/Baku',
      timeZone: [{
        timeZoneId: 'Asia/Baku',
        displayName: '(GMT+04:00) Azerbaijan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'BS',
      displayName: 'Bahamas',
      defaultTimeZoneId: 'America/Nassau',
      timeZone: [{
        timeZoneId: 'America/Nassau',
        displayName: '(GMT-04:00) Bahamas Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'BD',
      displayName: 'Bangladesh',
      defaultTimeZoneId: 'Asia/Dhaka',
      timeZone: [{
        timeZoneId: 'Asia/Dhaka',
        displayName: '(GMT+06:00) Bangladesh Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'BB',
      displayName: 'Barbados',
      defaultTimeZoneId: 'America/Barbados',
      timeZone: [{
        timeZoneId: 'America/Barbados',
        displayName: '(GMT-04:00) Barbados Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'BY',
      displayName: 'Belarus',
      defaultTimeZoneId: 'Europe/Minsk',
      timeZone: [{
        timeZoneId: 'Europe/Minsk',
        displayName: '(GMT+03:00) Belarus Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'BE',
      displayName: 'Belgium',
      defaultTimeZoneId: 'Europe/Brussels',
      timeZone: [{
        timeZoneId: 'Europe/Brussels',
        displayName: '(GMT+02:00) Belgium Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'BZ',
      displayName: 'Belize',
      defaultTimeZoneId: 'America/Belize',
      timeZone: [{
        timeZoneId: 'America/Belize',
        displayName: '(GMT-06:00) Belize Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'BM',
      displayName: 'Bermuda',
      defaultTimeZoneId: 'Atlantic/Bermuda',
      timeZone: [{
        timeZoneId: 'Atlantic/Bermuda',
        displayName: '(GMT-03:00) Bermuda Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'BT',
      displayName: 'Bhutan',
      defaultTimeZoneId: 'Asia/Thimphu',
      timeZone: [{
        timeZoneId: 'Asia/Thimphu',
        displayName: '(GMT+06:00) Bhutan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'BO',
      displayName: 'Bolivia',
      defaultTimeZoneId: 'America/La_Paz',
      timeZone: [{
        timeZoneId: 'America/La_Paz',
        displayName: '(GMT-04:00) Bolivia Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'BA',
      displayName: 'Bosnia \u0026 Herzegovina',
      defaultTimeZoneId: 'Europe/Sarajevo',
      timeZone: [{
        timeZoneId: 'Europe/Sarajevo',
        displayName: '(GMT+02:00) Bosnia \u0026 Herzegovina Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'BR',
      displayName: 'Brazil',
      defaultTimeZoneId: 'America/Rio_Branco',
      timeZone: [{
        timeZoneId: 'America/Rio_Branco',
        displayName: '(GMT-05:00) Rio Branco Time'
      }, {
        timeZoneId: 'America/Boa_Vista',
        displayName: '(GMT-04:00) Boa Vista Time'
      }, {
        timeZoneId: 'America/Campo_Grande',
        displayName: '(GMT-04:00) Campo Grande Time'
      }, {
        timeZoneId: 'America/Cuiaba',
        displayName: '(GMT-04:00) Cuiaba Time'
      }, {
        timeZoneId: 'America/Manaus',
        displayName: '(GMT-04:00) Manaus Time'
      }, {
        timeZoneId: 'America/Porto_Velho',
        displayName: '(GMT-04:00) Porto Velho Time'
      }, {
        timeZoneId: 'America/Araguaina',
        displayName: '(GMT-03:00) Araguaina Time'
      }, {
        timeZoneId: 'America/Bahia',
        displayName: '(GMT-03:00) Bahia Time'
      }, {
        timeZoneId: 'America/Belem',
        displayName: '(GMT-03:00) Belem Time'
      }, {
        timeZoneId: 'America/Fortaleza',
        displayName: '(GMT-03:00) Fortaleza Time'
      }, {
        timeZoneId: 'America/Maceio',
        displayName: '(GMT-03:00) Maceio Time'
      }, {
        timeZoneId: 'America/Recife',
        displayName: '(GMT-03:00) Recife Time'
      }, {
        timeZoneId: 'America/Sao_Paulo',
        displayName: '(GMT-03:00) Sao Paulo Time'
      }, {
        timeZoneId: 'America/Noronha',
        displayName: '(GMT-02:00) Noronha Time'
      }],
      tosLocale: {
        language: 'pt',
        country: 'BR'
      }
    }, {
      countryCode: 'IO',
      displayName: 'British Indian Ocean Territory',
      defaultTimeZoneId: 'Indian/Chagos',
      timeZone: [{
        timeZoneId: 'Indian/Chagos',
        displayName: '(GMT+06:00) British Indian Ocean Territory Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'BN',
      displayName: 'Brunei',
      defaultTimeZoneId: 'Asia/Brunei',
      timeZone: [{
        timeZoneId: 'Asia/Brunei',
        displayName: '(GMT+08:00) Brunei Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'BG',
      displayName: 'Bulgaria',
      defaultTimeZoneId: 'Europe/Sofia',
      timeZone: [{
        timeZoneId: 'Europe/Sofia',
        displayName: '(GMT+03:00) Bulgaria Time'
      }],
      tosLocale: {
        language: 'bg',
        country: 'BG'
      }
    }, {
      countryCode: 'CA',
      displayName: 'Canada',
      defaultTimeZoneId: 'America/Dawson',
      timeZone: [{
        timeZoneId: 'America/Dawson',
        displayName: '(GMT-07:00) Dawson Time'
      }, {
        timeZoneId: 'America/Vancouver',
        displayName: '(GMT-07:00) Vancouver Time'
      }, {
        timeZoneId: 'America/Whitehorse',
        displayName: '(GMT-07:00) Whitehorse Time'
      }, {
        timeZoneId: 'America/Edmonton',
        displayName: '(GMT-06:00) Edmonton Time'
      }, {
        timeZoneId: 'America/Yellowknife',
        displayName: '(GMT-06:00) Yellowknife Time'
      }, {
        timeZoneId: 'America/Dawson_Creek',
        displayName: '(GMT-07:00) Dawson Creek Time'
      }, {
        timeZoneId: 'America/Winnipeg',
        displayName: '(GMT-05:00) Winnipeg Time'
      }, {
        timeZoneId: 'America/Regina',
        displayName: '(GMT-06:00) Regina Time'
      }, {
        timeZoneId: 'America/Iqaluit',
        displayName: '(GMT-04:00) Iqaluit Time'
      }, {
        timeZoneId: 'America/Toronto',
        displayName: '(GMT-04:00) Toronto Time'
      }, {
        timeZoneId: 'America/Halifax',
        displayName: '(GMT-03:00) Halifax Time'
      }, {
        timeZoneId: 'America/St_Johns',
        displayName: '(GMT-02:30) St. John\u2019s Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'CV',
      displayName: 'Cape Verde',
      defaultTimeZoneId: 'Atlantic/Cape_Verde',
      timeZone: [{
        timeZoneId: 'Atlantic/Cape_Verde',
        displayName: '(GMT-01:00) Cape Verde Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'TD',
      displayName: 'Chad',
      defaultTimeZoneId: 'Africa/Ndjamena',
      timeZone: [{
        timeZoneId: 'Africa/Ndjamena',
        displayName: '(GMT+01:00) Chad Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'CL',
      displayName: 'Chile',
      defaultTimeZoneId: 'Pacific/Easter',
      timeZone: [{
        timeZoneId: 'Pacific/Easter',
        displayName: '(GMT-06:00) Easter Time'
      }, {
        timeZoneId: 'America/Santiago',
        displayName: '(GMT-04:00) Chile Time'
      }, {
        timeZoneId: 'America/Punta_Arenas',
        displayName: '(GMT-03:00) Punta Arenas Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'CN',
      displayName: 'China',
      defaultTimeZoneId: 'Asia/Shanghai',
      timeZone: [{
        timeZoneId: 'Asia/Shanghai',
        displayName: '(GMT+08:00) China Time'
      }],
      tosLocale: {
        language: 'zh',
        country: 'CN'
      }
    }, {
      countryCode: 'CX',
      displayName: 'Christmas Island',
      defaultTimeZoneId: 'Indian/Christmas',
      timeZone: [{
        timeZoneId: 'Indian/Christmas',
        displayName: '(GMT+07:00) Christmas Island Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'CC',
      displayName: 'Cocos (Keeling) Islands',
      defaultTimeZoneId: 'Indian/Cocos',
      timeZone: [{
        timeZoneId: 'Indian/Cocos',
        displayName: '(GMT+06:30) Cocos (Keeling) Islands Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'CO',
      displayName: 'Colombia',
      defaultTimeZoneId: 'America/Bogota',
      timeZone: [{
        timeZoneId: 'America/Bogota',
        displayName: '(GMT-05:00) Colombia Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'CK',
      displayName: 'Cook Islands',
      defaultTimeZoneId: 'Pacific/Rarotonga',
      timeZone: [{
        timeZoneId: 'Pacific/Rarotonga',
        displayName: '(GMT-10:00) Cook Islands Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'CR',
      displayName: 'Costa Rica',
      defaultTimeZoneId: 'America/Costa_Rica',
      timeZone: [{
        timeZoneId: 'America/Costa_Rica',
        displayName: '(GMT-06:00) Costa Rica Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'CI',
      displayName: 'C\u00f4te d\u2019Ivoire',
      defaultTimeZoneId: 'Africa/Abidjan',
      timeZone: [{
        timeZoneId: 'Africa/Abidjan',
        displayName: '(GMT+00:00) C\u00f4te d\u2019Ivoire Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'HR',
      displayName: 'Croatia',
      defaultTimeZoneId: 'Europe/Zagreb',
      timeZone: [{
        timeZoneId: 'Europe/Zagreb',
        displayName: '(GMT+02:00) Croatia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'CU',
      displayName: 'Cuba',
      defaultTimeZoneId: 'America/Havana',
      timeZone: [{
        timeZoneId: 'America/Havana',
        displayName: '(GMT-04:00) Cuba Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'CW',
      displayName: 'Cura\u00e7ao',
      defaultTimeZoneId: 'America/Curacao',
      timeZone: [{
        timeZoneId: 'America/Curacao',
        displayName: '(GMT-04:00) Cura\u00e7ao Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'CY',
      displayName: 'Cyprus',
      defaultTimeZoneId: 'Asia/Nicosia',
      timeZone: [{
        timeZoneId: 'Asia/Nicosia',
        displayName: '(GMT+03:00) Nicosia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'CZ',
      displayName: 'Czechia',
      defaultTimeZoneId: 'Europe/Prague',
      timeZone: [{
        timeZoneId: 'Europe/Prague',
        displayName: '(GMT+02:00) Czechia Time'
      }],
      tosLocale: {
        language: 'cs',
        country: 'CZ'
      }
    }, {
      countryCode: 'DK',
      displayName: 'Denmark',
      defaultTimeZoneId: 'Europe/Copenhagen',
      timeZone: [{
        timeZoneId: 'Europe/Copenhagen',
        displayName: '(GMT+02:00) Denmark Time'
      }],
      tosLocale: {
        language: 'da',
        country: 'DK'
      }
    }, {
      countryCode: 'DO',
      displayName: 'Dominican Republic',
      defaultTimeZoneId: 'America/Santo_Domingo',
      timeZone: [{
        timeZoneId: 'America/Santo_Domingo',
        displayName: '(GMT-04:00) Dominican Republic Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'EC',
      displayName: 'Ecuador',
      defaultTimeZoneId: 'Pacific/Galapagos',
      timeZone: [{
        timeZoneId: 'Pacific/Galapagos',
        displayName: '(GMT-06:00) Galapagos Time'
      }, {
        timeZoneId: 'America/Guayaquil',
        displayName: '(GMT-05:00) Ecuador Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'EG',
      displayName: 'Egypt',
      defaultTimeZoneId: 'Africa/Cairo',
      timeZone: [{
        timeZoneId: 'Africa/Cairo',
        displayName: '(GMT+02:00) Egypt Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'SV',
      displayName: 'El Salvador',
      defaultTimeZoneId: 'America/El_Salvador',
      timeZone: [{
        timeZoneId: 'America/El_Salvador',
        displayName: '(GMT-06:00) El Salvador Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'EE',
      displayName: 'Estonia',
      defaultTimeZoneId: 'Europe/Tallinn',
      timeZone: [{
        timeZoneId: 'Europe/Tallinn',
        displayName: '(GMT+03:00) Estonia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'FK',
      displayName: 'Falkland Islands (Islas Malvinas)',
      defaultTimeZoneId: 'Atlantic/Stanley',
      timeZone: [{
        timeZoneId: 'Atlantic/Stanley',
        displayName: '(GMT-03:00) Falkland Islands (Islas Malvinas) Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'FO',
      displayName: 'Faroe Islands',
      defaultTimeZoneId: 'Atlantic/Faeroe',
      timeZone: [{
        timeZoneId: 'Atlantic/Faeroe',
        displayName: '(GMT+01:00) Faroe Islands Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'FJ',
      displayName: 'Fiji',
      defaultTimeZoneId: 'Pacific/Fiji',
      timeZone: [{
        timeZoneId: 'Pacific/Fiji',
        displayName: '(GMT+12:00) Fiji Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'FI',
      displayName: 'Finland',
      defaultTimeZoneId: 'Europe/Helsinki',
      timeZone: [{
        timeZoneId: 'Europe/Helsinki',
        displayName: '(GMT+03:00) Finland Time'
      }],
      tosLocale: {
        language: 'fi',
        country: 'FI'
      }
    }, {
      countryCode: 'FR',
      displayName: 'France',
      defaultTimeZoneId: 'Europe/Paris',
      timeZone: [{
        timeZoneId: 'Europe/Paris',
        displayName: '(GMT+02:00) France Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'GF',
      displayName: 'French Guiana',
      defaultTimeZoneId: 'America/Cayenne',
      timeZone: [{
        timeZoneId: 'America/Cayenne',
        displayName: '(GMT-03:00) French Guiana Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'PF',
      displayName: 'French Polynesia',
      defaultTimeZoneId: 'Pacific/Tahiti',
      timeZone: [{
        timeZoneId: 'Pacific/Tahiti',
        displayName: '(GMT-10:00) Tahiti Time'
      }, {
        timeZoneId: 'Pacific/Marquesas',
        displayName: '(GMT-09:30) Marquesas Time'
      }, {
        timeZoneId: 'Pacific/Gambier',
        displayName: '(GMT-09:00) Gambier Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'TF',
      displayName: 'French Southern Territories',
      defaultTimeZoneId: 'Indian/Kerguelen',
      timeZone: [{
        timeZoneId: 'Indian/Kerguelen',
        displayName: '(GMT+05:00) French Southern Territories Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'GE',
      displayName: 'Georgia',
      defaultTimeZoneId: 'Asia/Tbilisi',
      timeZone: [{
        timeZoneId: 'Asia/Tbilisi',
        displayName: '(GMT+04:00) Georgia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'DE',
      displayName: 'Germany',
      defaultTimeZoneId: 'Europe/Berlin',
      timeZone: [{
        timeZoneId: 'Europe/Berlin',
        displayName: '(GMT+02:00) Germany Time'
      }],
      tosLocale: {
        language: 'de',
        country: 'DE'
      }
    }, {
      countryCode: 'GH',
      displayName: 'Ghana',
      defaultTimeZoneId: 'Africa/Accra',
      timeZone: [{
        timeZoneId: 'Africa/Accra',
        displayName: '(GMT+00:00) Ghana Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'GI',
      displayName: 'Gibraltar',
      defaultTimeZoneId: 'Europe/Gibraltar',
      timeZone: [{
        timeZoneId: 'Europe/Gibraltar',
        displayName: '(GMT+02:00) Gibraltar Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'GR',
      displayName: 'Greece',
      defaultTimeZoneId: 'Europe/Athens',
      timeZone: [{
        timeZoneId: 'Europe/Athens',
        displayName: '(GMT+03:00) Greece Time'
      }],
      tosLocale: {
        language: 'el',
        country: 'GR'
      }
    }, {
      countryCode: 'GL',
      displayName: 'Greenland',
      defaultTimeZoneId: 'America/Thule',
      timeZone: [{
        timeZoneId: 'America/Thule',
        displayName: '(GMT-03:00) Thule Time'
      }, {
        timeZoneId: 'America/Godthab',
        displayName: '(GMT-02:00) Nuuk Time'
      }, {
        timeZoneId: 'America/Scoresbysund',
        displayName: '(GMT+00:00) Ittoqqortoormiit Time'
      }, {
        timeZoneId: 'America/Danmarkshavn',
        displayName: '(GMT+00:00) Danmarkshavn Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'GU',
      displayName: 'Guam',
      defaultTimeZoneId: 'Pacific/Guam',
      timeZone: [{
        timeZoneId: 'Pacific/Guam',
        displayName: '(GMT+10:00) Guam Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'GT',
      displayName: 'Guatemala',
      defaultTimeZoneId: 'America/Guatemala',
      timeZone: [{
        timeZoneId: 'America/Guatemala',
        displayName: '(GMT-06:00) Guatemala Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'GW',
      displayName: 'Guinea-Bissau',
      defaultTimeZoneId: 'Africa/Bissau',
      timeZone: [{
        timeZoneId: 'Africa/Bissau',
        displayName: '(GMT+00:00) Guinea-Bissau Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'GY',
      displayName: 'Guyana',
      defaultTimeZoneId: 'America/Guyana',
      timeZone: [{
        timeZoneId: 'America/Guyana',
        displayName: '(GMT-04:00) Guyana Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'HT',
      displayName: 'Haiti',
      defaultTimeZoneId: 'America/Port-au-Prince',
      timeZone: [{
        timeZoneId: 'America/Port-au-Prince',
        displayName: '(GMT-04:00) Haiti Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'HN',
      displayName: 'Honduras',
      defaultTimeZoneId: 'America/Tegucigalpa',
      timeZone: [{
        timeZoneId: 'America/Tegucigalpa',
        displayName: '(GMT-06:00) Honduras Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'HK',
      displayName: 'Hong Kong',
      defaultTimeZoneId: 'Asia/Hong_Kong',
      timeZone: [{
        timeZoneId: 'Asia/Hong_Kong',
        displayName: '(GMT+08:00) Hong Kong Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'HU',
      displayName: 'Hungary',
      defaultTimeZoneId: 'Europe/Budapest',
      timeZone: [{
        timeZoneId: 'Europe/Budapest',
        displayName: '(GMT+02:00) Hungary Time'
      }],
      tosLocale: {
        language: 'hu',
        country: 'HU'
      }
    }, {
      countryCode: 'IS',
      displayName: 'Iceland',
      defaultTimeZoneId: 'Atlantic/Reykjavik',
      timeZone: [{
        timeZoneId: 'Atlantic/Reykjavik',
        displayName: '(GMT+00:00) Iceland Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'IN',
      displayName: 'India',
      defaultTimeZoneId: 'Asia/Calcutta',
      timeZone: [{
        timeZoneId: 'Asia/Calcutta',
        displayName: '(GMT+05:30) India Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'ID',
      displayName: 'Indonesia',
      defaultTimeZoneId: 'Asia/Jakarta',
      timeZone: [{
        timeZoneId: 'Asia/Jakarta',
        displayName: '(GMT+07:00) Jakarta Time'
      }, {
        timeZoneId: 'Asia/Makassar',
        displayName: '(GMT+08:00) Makassar Time'
      }, {
        timeZoneId: 'Asia/Jayapura',
        displayName: '(GMT+09:00) Jayapura Time'
      }],
      tosLocale: {
        language: 'in',
        country: 'ID'
      }
    }, {
      countryCode: 'IR',
      displayName: 'Iran',
      defaultTimeZoneId: 'Asia/Tehran',
      timeZone: [{
        timeZoneId: 'Asia/Tehran',
        displayName: '(GMT+04:30) Iran Time'
      }]
    }, {
      countryCode: 'IQ',
      displayName: 'Iraq',
      defaultTimeZoneId: 'Asia/Baghdad',
      timeZone: [{
        timeZoneId: 'Asia/Baghdad',
        displayName: '(GMT+03:00) Iraq Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'IE',
      displayName: 'Ireland',
      defaultTimeZoneId: 'Europe/Dublin',
      timeZone: [{
        timeZoneId: 'Europe/Dublin',
        displayName: '(GMT+01:00) Ireland Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'IL',
      displayName: 'Israel',
      defaultTimeZoneId: 'Asia/Jerusalem',
      timeZone: [{
        timeZoneId: 'Asia/Jerusalem',
        displayName: '(GMT+03:00) Israel Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'IT',
      displayName: 'Italy',
      defaultTimeZoneId: 'Europe/Rome',
      timeZone: [{
        timeZoneId: 'Europe/Rome',
        displayName: '(GMT+02:00) Italy Time'
      }],
      tosLocale: {
        language: 'it',
        country: 'IT'
      }
    }, {
      countryCode: 'JM',
      displayName: 'Jamaica',
      defaultTimeZoneId: 'America/Jamaica',
      timeZone: [{
        timeZoneId: 'America/Jamaica',
        displayName: '(GMT-05:00) Jamaica Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'JP',
      displayName: 'Japan',
      defaultTimeZoneId: 'Asia/Tokyo',
      timeZone: [{
        timeZoneId: 'Asia/Tokyo',
        displayName: '(GMT+09:00) Japan Time'
      }],
      tosLocale: {
        language: 'ja',
        country: 'JP'
      }
    }, {
      countryCode: 'JO',
      displayName: 'Jordan',
      defaultTimeZoneId: 'Asia/Amman',
      timeZone: [{
        timeZoneId: 'Asia/Amman',
        displayName: '(GMT+03:00) Jordan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'KZ',
      displayName: 'Kazakhstan',
      defaultTimeZoneId: 'Asia/Aqtau',
      timeZone: [{
        timeZoneId: 'Asia/Aqtau',
        displayName: '(GMT+05:00) Aqtau Time'
      }, {
        timeZoneId: 'Asia/Aqtobe',
        displayName: '(GMT+05:00) Aqtobe Time'
      }, {
        timeZoneId: 'Asia/Almaty',
        displayName: '(GMT+06:00) Almaty Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'KE',
      displayName: 'Kenya',
      defaultTimeZoneId: 'Africa/Nairobi',
      timeZone: [{
        timeZoneId: 'Africa/Nairobi',
        displayName: '(GMT+03:00) Kenya Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'KI',
      displayName: 'Kiribati',
      defaultTimeZoneId: 'Pacific/Tarawa',
      timeZone: [{
        timeZoneId: 'Pacific/Tarawa',
        displayName: '(GMT+12:00) Tarawa Time'
      }, {
        timeZoneId: 'Pacific/Enderbury',
        displayName: '(GMT+13:00) Enderbury Time'
      }, {
        timeZoneId: 'Pacific/Kiritimati',
        displayName: '(GMT+14:00) Kiritimati Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'KG',
      displayName: 'Kyrgyzstan',
      defaultTimeZoneId: 'Asia/Bishkek',
      timeZone: [{
        timeZoneId: 'Asia/Bishkek',
        displayName: '(GMT+06:00) Kyrgyzstan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'LV',
      displayName: 'Latvia',
      defaultTimeZoneId: 'Europe/Riga',
      timeZone: [{
        timeZoneId: 'Europe/Riga',
        displayName: '(GMT+03:00) Latvia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'LB',
      displayName: 'Lebanon',
      defaultTimeZoneId: 'Asia/Beirut',
      timeZone: [{
        timeZoneId: 'Asia/Beirut',
        displayName: '(GMT+03:00) Lebanon Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'LR',
      displayName: 'Liberia',
      defaultTimeZoneId: 'Africa/Monrovia',
      timeZone: [{
        timeZoneId: 'Africa/Monrovia',
        displayName: '(GMT+00:00) Liberia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'LY',
      displayName: 'Libya',
      defaultTimeZoneId: 'Africa/Tripoli',
      timeZone: [{
        timeZoneId: 'Africa/Tripoli',
        displayName: '(GMT+02:00) Libya Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'LT',
      displayName: 'Lithuania',
      defaultTimeZoneId: 'Europe/Vilnius',
      timeZone: [{
        timeZoneId: 'Europe/Vilnius',
        displayName: '(GMT+03:00) Lithuania Time'
      }],
      tosLocale: {
        language: 'lt',
        country: 'LT'
      }
    }, {
      countryCode: 'LU',
      displayName: 'Luxembourg',
      defaultTimeZoneId: 'Europe/Luxembourg',
      timeZone: [{
        timeZoneId: 'Europe/Luxembourg',
        displayName: '(GMT+02:00) Luxembourg Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'MO',
      displayName: 'Macao',
      defaultTimeZoneId: 'Asia/Macau',
      timeZone: [{
        timeZoneId: 'Asia/Macau',
        displayName: '(GMT+08:00) Macao Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'MY',
      displayName: 'Malaysia',
      defaultTimeZoneId: 'Asia/Kuala_Lumpur',
      timeZone: [{
        timeZoneId: 'Asia/Kuala_Lumpur',
        displayName: '(GMT+08:00) Malaysia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'MV',
      displayName: 'Maldives',
      defaultTimeZoneId: 'Indian/Maldives',
      timeZone: [{
        timeZoneId: 'Indian/Maldives',
        displayName: '(GMT+05:00) Maldives Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'MT',
      displayName: 'Malta',
      defaultTimeZoneId: 'Europe/Malta',
      timeZone: [{
        timeZoneId: 'Europe/Malta',
        displayName: '(GMT+02:00) Malta Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'MH',
      displayName: 'Marshall Islands',
      defaultTimeZoneId: 'Pacific/Kwajalein',
      timeZone: [{
        timeZoneId: 'Pacific/Kwajalein',
        displayName: '(GMT+12:00) Kwajalein Time'
      }, {
        timeZoneId: 'Pacific/Majuro',
        displayName: '(GMT+12:00) Marshall Islands Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'MQ',
      displayName: 'Martinique',
      defaultTimeZoneId: 'America/Martinique',
      timeZone: [{
        timeZoneId: 'America/Martinique',
        displayName: '(GMT-04:00) Martinique Time'
      }],
      tosLocale: {
        language: 'fr',
        country: 'FR'
      }
    }, {
      countryCode: 'MU',
      displayName: 'Mauritius',
      defaultTimeZoneId: 'Indian/Mauritius',
      timeZone: [{
        timeZoneId: 'Indian/Mauritius',
        displayName: '(GMT+04:00) Mauritius Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'MX',
      displayName: 'Mexico',
      defaultTimeZoneId: 'America/Tijuana',
      timeZone: [{
        timeZoneId: 'America/Tijuana',
        displayName: '(GMT-07:00) Tijuana Time'
      }, {
        timeZoneId: 'America/Mazatlan',
        displayName: '(GMT-06:00) Mazatlan Time'
      }, {
        timeZoneId: 'America/Hermosillo',
        displayName: '(GMT-07:00) Hermosillo Time'
      }, {
        timeZoneId: 'America/Mexico_City',
        displayName: '(GMT-05:00) Mexico City Time'
      }, {
        timeZoneId: 'America/Cancun',
        displayName: '(GMT-05:00) Cancun Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'FM',
      displayName: 'Micronesia',
      defaultTimeZoneId: 'Pacific/Truk',
      timeZone: [{
        timeZoneId: 'Pacific/Truk',
        displayName: '(GMT+10:00) Chuuk Time'
      }, {
        timeZoneId: 'Pacific/Kosrae',
        displayName: '(GMT+11:00) Kosrae Time'
      }, {
        timeZoneId: 'Pacific/Ponape',
        displayName: '(GMT+11:00) Pohnpei Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'MD',
      displayName: 'Moldova',
      defaultTimeZoneId: 'Europe/Chisinau',
      timeZone: [{
        timeZoneId: 'Europe/Chisinau',
        displayName: '(GMT+03:00) Moldova Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'MC',
      displayName: 'Monaco',
      defaultTimeZoneId: 'Europe/Monaco',
      timeZone: [{
        timeZoneId: 'Europe/Monaco',
        displayName: '(GMT+02:00) Monaco Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'MN',
      displayName: 'Mongolia',
      defaultTimeZoneId: 'Asia/Hovd',
      timeZone: [{
        timeZoneId: 'Asia/Hovd',
        displayName: '(GMT+07:00) Hovd Time'
      }, {
        timeZoneId: 'Asia/Choibalsan',
        displayName: '(GMT+08:00) Choibalsan Time'
      }, {
        timeZoneId: 'Asia/Ulaanbaatar',
        displayName: '(GMT+08:00) Ulaanbaatar Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'MA',
      displayName: 'Morocco',
      defaultTimeZoneId: 'Africa/Casablanca',
      timeZone: [{
        timeZoneId: 'Africa/Casablanca',
        displayName: '(GMT+01:00) Morocco Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'MZ',
      displayName: 'Mozambique',
      defaultTimeZoneId: 'Africa/Maputo',
      timeZone: [{
        timeZoneId: 'Africa/Maputo',
        displayName: '(GMT+02:00) Mozambique Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'MM',
      displayName: 'Myanmar (Burma)',
      defaultTimeZoneId: 'Asia/Rangoon',
      timeZone: [{
        timeZoneId: 'Asia/Rangoon',
        displayName: '(GMT+06:30) Myanmar (Burma) Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'NA',
      displayName: 'Namibia',
      defaultTimeZoneId: 'Africa/Windhoek',
      timeZone: [{
        timeZoneId: 'Africa/Windhoek',
        displayName: '(GMT+02:00) Namibia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'NR',
      displayName: 'Nauru',
      defaultTimeZoneId: 'Pacific/Nauru',
      timeZone: [{
        timeZoneId: 'Pacific/Nauru',
        displayName: '(GMT+12:00) Nauru Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'NP',
      displayName: 'Nepal',
      defaultTimeZoneId: 'Asia/Katmandu',
      timeZone: [{
        timeZoneId: 'Asia/Katmandu',
        displayName: '(GMT+05:45) Nepal Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'NL',
      displayName: 'Netherlands',
      defaultTimeZoneId: 'Europe/Amsterdam',
      timeZone: [{
        timeZoneId: 'Europe/Amsterdam',
        displayName: '(GMT+02:00) Netherlands Time'
      }],
      tosLocale: {
        language: 'nl',
        country: 'NL'
      }
    }, {
      countryCode: 'NC',
      displayName: 'New Caledonia',
      defaultTimeZoneId: 'Pacific/Noumea',
      timeZone: [{
        timeZoneId: 'Pacific/Noumea',
        displayName: '(GMT+11:00) New Caledonia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'NZ',
      displayName: 'New Zealand',
      defaultTimeZoneId: 'Pacific/Auckland',
      timeZone: [{
        timeZoneId: 'Pacific/Auckland',
        displayName: '(GMT+12:00) New Zealand Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'NI',
      displayName: 'Nicaragua',
      defaultTimeZoneId: 'America/Managua',
      timeZone: [{
        timeZoneId: 'America/Managua',
        displayName: '(GMT-06:00) Nicaragua Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'NG',
      displayName: 'Nigeria',
      defaultTimeZoneId: 'Africa/Lagos',
      timeZone: [{
        timeZoneId: 'Africa/Lagos',
        displayName: '(GMT+01:00) Nigeria Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'NU',
      displayName: 'Niue',
      defaultTimeZoneId: 'Pacific/Niue',
      timeZone: [{
        timeZoneId: 'Pacific/Niue',
        displayName: '(GMT-11:00) Niue Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'NF',
      displayName: 'Norfolk Island',
      defaultTimeZoneId: 'Pacific/Norfolk',
      timeZone: [{
        timeZoneId: 'Pacific/Norfolk',
        displayName: '(GMT+11:00) Norfolk Island Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'KP',
      displayName: 'North Korea',
      defaultTimeZoneId: 'Asia/Pyongyang',
      timeZone: [{
        timeZoneId: 'Asia/Pyongyang',
        displayName: '(GMT+09:00) North Korea Time'
      }]
    }, {
      countryCode: 'MK',
      displayName: 'North Macedonia',
      defaultTimeZoneId: 'Europe/Skopje',
      timeZone: [{
        timeZoneId: 'Europe/Skopje',
        displayName: '(GMT+02:00) North Macedonia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'NO',
      displayName: 'Norway',
      defaultTimeZoneId: 'Europe/Oslo',
      timeZone: [{
        timeZoneId: 'Europe/Oslo',
        displayName: '(GMT+02:00) Norway Time'
      }],
      tosLocale: {
        language: 'no',
        country: 'NO'
      }
    }, {
      countryCode: 'PK',
      displayName: 'Pakistan',
      defaultTimeZoneId: 'Asia/Karachi',
      timeZone: [{
        timeZoneId: 'Asia/Karachi',
        displayName: '(GMT+05:00) Pakistan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'PW',
      displayName: 'Palau',
      defaultTimeZoneId: 'Pacific/Palau',
      timeZone: [{
        timeZoneId: 'Pacific/Palau',
        displayName: '(GMT+09:00) Palau Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'PS',
      displayName: 'Palestine',
      defaultTimeZoneId: 'Asia/Gaza',
      timeZone: [{
        timeZoneId: 'Asia/Gaza',
        displayName: '(GMT+03:00) Gaza Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'PA',
      displayName: 'Panama',
      defaultTimeZoneId: 'America/Panama',
      timeZone: [{
        timeZoneId: 'America/Panama',
        displayName: '(GMT-05:00) Panama Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'PG',
      displayName: 'Papua New Guinea',
      defaultTimeZoneId: 'Pacific/Port_Moresby',
      timeZone: [{
        timeZoneId: 'Pacific/Port_Moresby',
        displayName: '(GMT+10:00) Port Moresby Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'PY',
      displayName: 'Paraguay',
      defaultTimeZoneId: 'America/Asuncion',
      timeZone: [{
        timeZoneId: 'America/Asuncion',
        displayName: '(GMT-04:00) Paraguay Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'PE',
      displayName: 'Peru',
      defaultTimeZoneId: 'America/Lima',
      timeZone: [{
        timeZoneId: 'America/Lima',
        displayName: '(GMT-05:00) Peru Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'PH',
      displayName: 'Philippines',
      defaultTimeZoneId: 'Asia/Manila',
      timeZone: [{
        timeZoneId: 'Asia/Manila',
        displayName: '(GMT+08:00) Philippines Time'
      }],
      tosLocale: {
        language: 'tl',
        country: 'PH'
      }
    }, {
      countryCode: 'PN',
      displayName: 'Pitcairn Islands',
      defaultTimeZoneId: 'Pacific/Pitcairn',
      timeZone: [{
        timeZoneId: 'Pacific/Pitcairn',
        displayName: '(GMT-08:00) Pitcairn Islands Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'PL',
      displayName: 'Poland',
      defaultTimeZoneId: 'Europe/Warsaw',
      timeZone: [{
        timeZoneId: 'Europe/Warsaw',
        displayName: '(GMT+02:00) Poland Time'
      }],
      tosLocale: {
        language: 'pl',
        country: 'PL'
      }
    }, {
      countryCode: 'PT',
      displayName: 'Portugal',
      defaultTimeZoneId: 'Atlantic/Azores',
      timeZone: [{
        timeZoneId: 'Atlantic/Azores',
        displayName: '(GMT+00:00) Azores Time'
      }, {
        timeZoneId: 'Europe/Lisbon',
        displayName: '(GMT+01:00) Portugal Time'
      }],
      tosLocale: {
        language: 'pt',
        country: 'PT'
      }
    }, {
      countryCode: 'PR',
      displayName: 'Puerto Rico',
      defaultTimeZoneId: 'America/Puerto_Rico',
      timeZone: [{
        timeZoneId: 'America/Puerto_Rico',
        displayName: '(GMT-04:00) Puerto Rico Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'QA',
      displayName: 'Qatar',
      defaultTimeZoneId: 'Asia/Qatar',
      timeZone: [{
        timeZoneId: 'Asia/Qatar',
        displayName: '(GMT+03:00) Qatar Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'RE',
      displayName: 'R\u00e9union',
      defaultTimeZoneId: 'Indian/Reunion',
      timeZone: [{
        timeZoneId: 'Indian/Reunion',
        displayName: '(GMT+04:00) R\u00e9union Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'RO',
      displayName: 'Romania',
      defaultTimeZoneId: 'Europe/Bucharest',
      timeZone: [{
        timeZoneId: 'Europe/Bucharest',
        displayName: '(GMT+03:00) Romania Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'RU',
      displayName: 'Russia',
      defaultTimeZoneId: 'Europe/Kaliningrad',
      timeZone: [{
        timeZoneId: 'Europe/Kaliningrad',
        displayName: '(GMT+02:00) Kaliningrad Time'
      }, {
        timeZoneId: 'Europe/Moscow',
        displayName: '(GMT+03:00) Moscow Time'
      }, {
        timeZoneId: 'Europe/Samara',
        displayName: '(GMT+04:00) Samara Time'
      }, {
        timeZoneId: 'Asia/Yekaterinburg',
        displayName: '(GMT+05:00) Yekaterinburg Time'
      }, {
        timeZoneId: 'Asia/Omsk',
        displayName: '(GMT+06:00) Omsk Time'
      }, {
        timeZoneId: 'Asia/Krasnoyarsk',
        displayName: '(GMT+07:00) Krasnoyarsk Time'
      }, {
        timeZoneId: 'Asia/Irkutsk',
        displayName: '(GMT+08:00) Irkutsk Time'
      }, {
        timeZoneId: 'Asia/Yakutsk',
        displayName: '(GMT+09:00) Yakutsk Time'
      }, {
        timeZoneId: 'Asia/Vladivostok',
        displayName: '(GMT+10:00) Vladivostok Time'
      }, {
        timeZoneId: 'Asia/Magadan',
        displayName: '(GMT+11:00) Magadan Time'
      }, {
        timeZoneId: 'Asia/Kamchatka',
        displayName: '(GMT+12:00) Kamchatka Time'
      }],
      tosLocale: {
        language: 'ru',
        country: 'RU'
      }
    }, {
      countryCode: 'WS',
      displayName: 'Samoa',
      defaultTimeZoneId: 'Pacific/Apia',
      timeZone: [{
        timeZoneId: 'Pacific/Apia',
        displayName: '(GMT+13:00) Samoa Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'SM',
      displayName: 'San Marino',
      defaultTimeZoneId: 'Europe/San_Marino',
      timeZone: [{
        timeZoneId: 'Europe/San_Marino',
        displayName: '(GMT+02:00) San Marino Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'ST',
      displayName: 'S\u00e3o Tom\u00e9 \u0026 Pr\u00edncipe',
      defaultTimeZoneId: 'Africa/Sao_Tome',
      timeZone: [{
        timeZoneId: 'Africa/Sao_Tome',
        displayName: '(GMT+00:00) S\u00e3o Tom\u00e9 \u0026 Pr\u00edncipe Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'SA',
      displayName: 'Saudi Arabia',
      defaultTimeZoneId: 'Asia/Riyadh',
      timeZone: [{
        timeZoneId: 'Asia/Riyadh',
        displayName: '(GMT+03:00) Saudi Arabia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'RS',
      displayName: 'Serbia',
      defaultTimeZoneId: 'Europe/Belgrade',
      timeZone: [{
        timeZoneId: 'Europe/Belgrade',
        displayName: '(GMT+02:00) Serbia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'SC',
      displayName: 'Seychelles',
      defaultTimeZoneId: 'Indian/Mahe',
      timeZone: [{
        timeZoneId: 'Indian/Mahe',
        displayName: '(GMT+04:00) Seychelles Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'SG',
      displayName: 'Singapore',
      defaultTimeZoneId: 'Asia/Singapore',
      timeZone: [{
        timeZoneId: 'Asia/Singapore',
        displayName: '(GMT+08:00) Singapore Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'SK',
      displayName: 'Slovakia',
      defaultTimeZoneId: 'Europe/Bratislava',
      timeZone: [{
        timeZoneId: 'Europe/Bratislava',
        displayName: '(GMT+02:00) Slovakia Time'
      }],
      tosLocale: {
        language: 'sk',
        country: 'SK'
      }
    }, {
      countryCode: 'SI',
      displayName: 'Slovenia',
      defaultTimeZoneId: 'Europe/Ljubljana',
      timeZone: [{
        timeZoneId: 'Europe/Ljubljana',
        displayName: '(GMT+02:00) Slovenia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'SB',
      displayName: 'Solomon Islands',
      defaultTimeZoneId: 'Pacific/Guadalcanal',
      timeZone: [{
        timeZoneId: 'Pacific/Guadalcanal',
        displayName: '(GMT+11:00) Solomon Islands Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'ZA',
      displayName: 'South Africa',
      defaultTimeZoneId: 'Africa/Johannesburg',
      timeZone: [{
        timeZoneId: 'Africa/Johannesburg',
        displayName: '(GMT+02:00) South Africa Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'GS',
      displayName: 'South Georgia \u0026 South Sandwich Islands',
      defaultTimeZoneId: 'Atlantic/South_Georgia',
      timeZone: [{
        timeZoneId: 'Atlantic/South_Georgia',
        displayName: '(GMT-02:00) South Georgia \u0026 South Sandwich Islands Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'KR',
      displayName: 'South Korea',
      defaultTimeZoneId: 'Asia/Seoul',
      timeZone: [{
        timeZoneId: 'Asia/Seoul',
        displayName: '(GMT+09:00) South Korea Time'
      }],
      tosLocale: {
        language: 'ko',
        country: 'KR'
      }
    }, {
      countryCode: 'ES',
      displayName: 'Spain',
      defaultTimeZoneId: 'Atlantic/Canary',
      timeZone: [{
        timeZoneId: 'Atlantic/Canary',
        displayName: '(GMT+01:00) Canary Time'
      }, {
        timeZoneId: 'Africa/Ceuta',
        displayName: '(GMT+02:00) Ceuta Time'
      }, {
        timeZoneId: 'Europe/Madrid',
        displayName: '(GMT+02:00) Spain Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'LK',
      displayName: 'Sri Lanka',
      defaultTimeZoneId: 'Asia/Colombo',
      timeZone: [{
        timeZoneId: 'Asia/Colombo',
        displayName: '(GMT+05:30) Sri Lanka Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'PM',
      displayName: 'St. Pierre \u0026 Miquelon',
      defaultTimeZoneId: 'America/Miquelon',
      timeZone: [{
        timeZoneId: 'America/Miquelon',
        displayName: '(GMT-02:00) St. Pierre \u0026 Miquelon Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'SD',
      displayName: 'Sudan',
      defaultTimeZoneId: 'Africa/Khartoum',
      timeZone: [{
        timeZoneId: 'Africa/Khartoum',
        displayName: '(GMT+02:00) Sudan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'SR',
      displayName: 'Suriname',
      defaultTimeZoneId: 'America/Paramaribo',
      timeZone: [{
        timeZoneId: 'America/Paramaribo',
        displayName: '(GMT-03:00) Suriname Time'
      }],
      tosLocale: {
        language: 'nl',
        country: 'NL'
      }
    }, {
      countryCode: 'SJ',
      displayName: 'Svalbard \u0026 Jan Mayen',
      defaultTimeZoneId: 'Arctic/Longyearbyen',
      timeZone: [{
        timeZoneId: 'Arctic/Longyearbyen',
        displayName: '(GMT+02:00) Svalbard \u0026 Jan Mayen Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'SE',
      displayName: 'Sweden',
      defaultTimeZoneId: 'Europe/Stockholm',
      timeZone: [{
        timeZoneId: 'Europe/Stockholm',
        displayName: '(GMT+02:00) Sweden Time'
      }],
      tosLocale: {
        language: 'sv',
        country: 'SE'
      }
    }, {
      countryCode: 'CH',
      displayName: 'Switzerland',
      defaultTimeZoneId: 'Europe/Zurich',
      timeZone: [{
        timeZoneId: 'Europe/Zurich',
        displayName: '(GMT+02:00) Switzerland Time'
      }],
      tosLocale: {
        language: 'de',
        country: 'DE'
      }
    }, {
      countryCode: 'SY',
      displayName: 'Syria',
      defaultTimeZoneId: 'Asia/Damascus',
      timeZone: [{
        timeZoneId: 'Asia/Damascus',
        displayName: '(GMT+03:00) Syria Time'
      }]
    }, {
      countryCode: 'TW',
      displayName: 'Taiwan',
      defaultTimeZoneId: 'Asia/Taipei',
      timeZone: [{
        timeZoneId: 'Asia/Taipei',
        displayName: '(GMT+08:00) Taiwan Time'
      }],
      tosLocale: {
        language: 'zh',
        country: 'TW'
      }
    }, {
      countryCode: 'TJ',
      displayName: 'Tajikistan',
      defaultTimeZoneId: 'Asia/Dushanbe',
      timeZone: [{
        timeZoneId: 'Asia/Dushanbe',
        displayName: '(GMT+05:00) Tajikistan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'TH',
      displayName: 'Thailand',
      defaultTimeZoneId: 'Asia/Bangkok',
      timeZone: [{
        timeZoneId: 'Asia/Bangkok',
        displayName: '(GMT+07:00) Thailand Time'
      }],
      tosLocale: {
        language: 'th',
        country: 'TH'
      }
    }, {
      countryCode: 'TL',
      displayName: 'Timor-Leste',
      defaultTimeZoneId: 'Asia/Dili',
      timeZone: [{
        timeZoneId: 'Asia/Dili',
        displayName: '(GMT+09:00) Timor-Leste Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'TK',
      displayName: 'Tokelau',
      defaultTimeZoneId: 'Pacific/Fakaofo',
      timeZone: [{
        timeZoneId: 'Pacific/Fakaofo',
        displayName: '(GMT+13:00) Tokelau Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'TO',
      displayName: 'Tonga',
      defaultTimeZoneId: 'Pacific/Tongatapu',
      timeZone: [{
        timeZoneId: 'Pacific/Tongatapu',
        displayName: '(GMT+13:00) Tonga Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'TT',
      displayName: 'Trinidad \u0026 Tobago',
      defaultTimeZoneId: 'America/Port_of_Spain',
      timeZone: [{
        timeZoneId: 'America/Port_of_Spain',
        displayName: '(GMT-04:00) Trinidad \u0026 Tobago Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'TN',
      displayName: 'Tunisia',
      defaultTimeZoneId: 'Africa/Tunis',
      timeZone: [{
        timeZoneId: 'Africa/Tunis',
        displayName: '(GMT+01:00) Tunisia Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'TR',
      displayName: 'Turkey',
      defaultTimeZoneId: 'Europe/Istanbul',
      timeZone: [{
        timeZoneId: 'Europe/Istanbul',
        displayName: '(GMT+03:00) Turkey Time'
      }],
      tosLocale: {
        language: 'tr',
        country: 'TR'
      }
    }, {
      countryCode: 'TM',
      displayName: 'Turkmenistan',
      defaultTimeZoneId: 'Asia/Ashgabat',
      timeZone: [{
        timeZoneId: 'Asia/Ashgabat',
        displayName: '(GMT+05:00) Turkmenistan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'TC',
      displayName: 'Turks \u0026 Caicos Islands',
      defaultTimeZoneId: 'America/Grand_Turk',
      timeZone: [{
        timeZoneId: 'America/Grand_Turk',
        displayName: '(GMT-04:00) Turks \u0026 Caicos Islands Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'TV',
      displayName: 'Tuvalu',
      defaultTimeZoneId: 'Pacific/Funafuti',
      timeZone: [{
        timeZoneId: 'Pacific/Funafuti',
        displayName: '(GMT+12:00) Tuvalu Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'UM',
      displayName: 'U.S. Outlying Islands',
      defaultTimeZoneId: 'Pacific/Wake',
      timeZone: [{
        timeZoneId: 'Pacific/Wake',
        displayName: '(GMT+12:00) Wake Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'UA',
      displayName: 'Ukraine',
      defaultTimeZoneId: 'Europe/Kiev',
      timeZone: [{
        timeZoneId: 'Europe/Kiev',
        displayName: '(GMT+03:00) Ukraine Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'AE',
      displayName: 'United Arab Emirates',
      defaultTimeZoneId: 'Asia/Dubai',
      timeZone: [{
        timeZoneId: 'Asia/Dubai',
        displayName: '(GMT+04:00) United Arab Emirates Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'GB',
      displayName: 'United Kingdom',
      defaultTimeZoneId: 'Etc/GMT',
      timeZone: [{
        timeZoneId: 'Etc/GMT',
        displayName: '(GMT+00:00) GMT'
      }, {
        timeZoneId: 'Europe/London',
        displayName: '(GMT+01:00) United Kingdom Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'US',
      displayName: 'United States',
      defaultTimeZoneId: 'America/Los_Angeles',
      timeZone: [{
        timeZoneId: 'Pacific/Honolulu',
        displayName: '(GMT-10:00) Honolulu Time'
      }, {
        timeZoneId: 'America/Anchorage',
        displayName: '(GMT-08:00) Anchorage Time'
      }, {
        timeZoneId: 'America/Los_Angeles',
        displayName: '(GMT-07:00) Los Angeles Time'
      }, {
        timeZoneId: 'America/Boise',
        displayName: '(GMT-06:00) Boise Time'
      }, {
        timeZoneId: 'America/Denver',
        displayName: '(GMT-06:00) Denver Time'
      }, {
        timeZoneId: 'America/Phoenix',
        displayName: '(GMT-07:00) Phoenix Time'
      }, {
        timeZoneId: 'America/Chicago',
        displayName: '(GMT-05:00) Chicago Time'
      }, {
        timeZoneId: 'America/Detroit',
        displayName: '(GMT-04:00) Detroit Time'
      }, {
        timeZoneId: 'America/New_York',
        displayName: '(GMT-04:00) New York Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'UY',
      displayName: 'Uruguay',
      defaultTimeZoneId: 'America/Montevideo',
      timeZone: [{
        timeZoneId: 'America/Montevideo',
        displayName: '(GMT-03:00) Uruguay Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'UZ',
      displayName: 'Uzbekistan',
      defaultTimeZoneId: 'Asia/Tashkent',
      timeZone: [{
        timeZoneId: 'Asia/Tashkent',
        displayName: '(GMT+05:00) Uzbekistan Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'VU',
      displayName: 'Vanuatu',
      defaultTimeZoneId: 'Pacific/Efate',
      timeZone: [{
        timeZoneId: 'Pacific/Efate',
        displayName: '(GMT+11:00) Vanuatu Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'US'
      }
    }, {
      countryCode: 'VA',
      displayName: 'Vatican City',
      defaultTimeZoneId: 'Europe/Vatican',
      timeZone: [{
        timeZoneId: 'Europe/Vatican',
        displayName: '(GMT+02:00) Vatican City Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'VE',
      displayName: 'Venezuela',
      defaultTimeZoneId: 'America/Caracas',
      timeZone: [{
        timeZoneId: 'America/Caracas',
        displayName: '(GMT-04:00) Venezuela Time'
      }],
      tosLocale: {
        language: 'es',
        country: 'ES'
      }
    }, {
      countryCode: 'VN',
      displayName: 'Vietnam',
      defaultTimeZoneId: 'Asia/Saigon',
      timeZone: [{
        timeZoneId: 'Asia/Saigon',
        displayName: '(GMT+07:00) Vietnam Time'
      }],
      tosLocale: {
        language: 'vi',
        country: 'VN'
      }
    }, {
      countryCode: 'WF',
      displayName: 'Wallis \u0026 Futuna',
      defaultTimeZoneId: 'Pacific/Wallis',
      timeZone: [{
        timeZoneId: 'Pacific/Wallis',
        displayName: '(GMT+12:00) Wallis \u0026 Futuna Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }, {
      countryCode: 'EH',
      displayName: 'Western Sahara',
      defaultTimeZoneId: 'Africa/El_Aaiun',
      timeZone: [{
        timeZoneId: 'Africa/El_Aaiun',
        displayName: '(GMT+01:00) Western Sahara Time'
      }],
      tosLocale: {
        language: 'en',
        country: 'GB'
      }
    }]
  }
};

/***/ }),

/***/ "./js/modules/analytics-4/utils/countries-timezones.js":
/*!*************************************************************!*\
  !*** ./js/modules/analytics-4/utils/countries-timezones.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   allCountries: () => (/* binding */ allCountries),
/* harmony export */   countriesByCode: () => (/* binding */ countriesByCode),
/* harmony export */   countryCodesByTimezone: () => (/* binding */ countryCodesByTimezone),
/* harmony export */   timeZonesByCountryCode: () => (/* binding */ timeZonesByCountryCode)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _countries_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./countries-data */ "./js/modules/analytics-4/utils/countries-data.js");
/**
 * Country and Time Zone utilities.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */

const allCountries = _countries_data__WEBPACK_IMPORTED_MODULE_1__.countries.default.country;
const timeZonesByCountryCode = allCountries.reduce((map, country) => {
  map[country.countryCode] = country.timeZone;
  return map;
}, {});
const countriesByCode = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.keyBy)(allCountries, 'countryCode');
const countryCodesByTimezone = allCountries.reduce((map, country) => {
  country.timeZone.forEach(
  // eslint-disable-next-line sitekit/acronym-case
  ({
    timeZoneId
  }) => map[timeZoneId] = country.countryCode);
  return map;
}, {});

/***/ }),

/***/ "./js/modules/analytics-4/utils/extract-dashboard-data.js":
/*!****************************************************************!*\
  !*** ./js/modules/analytics-4/utils/extract-dashboard-data.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extractAnalytics4DashboardData: () => (/* binding */ extractAnalytics4DashboardData)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! classnames */ "../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/i18n */ "./js/util/i18n.js");
/* harmony import */ var _parseDimensionStringToDate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseDimensionStringToDate */ "./js/modules/analytics-4/utils/parseDimensionStringToDate.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./partition-report */ "./js/modules/analytics-4/utils/partition-report.js");
/**
 * Analytics-4 Dashboard data extraction functions.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * Reduces and processes an array of analytics-4 row data.
 *
 * @since 1.96.0
 *
 * @param {Array}  rows          An array of rows to reduce.
 * @param {number} selectedStats The currently selected stat we need to return data for.
 * @return {Array} Array of selected stats from analytics row data.
 */
function reduceAnalytics4RowsData(rows, selectedStats) {
  const dataMap = [];
  rows.forEach(row => {
    if (!row.metricValues) {
      return;
    }
    const {
      value
    } = row.metricValues[selectedStats];
    const dateString = row.dimensionValues[0].value;
    const date = (0,_parseDimensionStringToDate__WEBPACK_IMPORTED_MODULE_5__["default"])(dateString);
    dataMap.push([date, value]);
  });
  return dataMap;
}

/**
 * Extracts the data required from an analytics 'site-analytics' request.
 *
 * @since 1.96.0
 * @since 1.98.0 Added chartDataFormats parameter.
 *
 * @param {Object} report             The data returned from the Analytics API call.
 * @param {Array}  selectedStats      The currently selected stat we need to return data for.
 * @param {number} days               The number of days to extract data for. Pads empty data days.
 * @param {string} referenceDate      The reference date.
 * @param {Array}  dataLabels         The labels to be displayed.
 * @param {Array}  tooltipDataFormats The formats to be used for the tooltip data.
 * @param {Array}  chartDataFormats   The formats to be used for the chart data.
 * @return {Array} The dataMap ready for charting.
 */
function extractAnalytics4DashboardData(report, selectedStats, days, referenceDate, dataLabels = [(0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Users', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Sessions', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Engagement Rate', 'google-site-kit'), (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Session Duration', 'google-site-kit')], tooltipDataFormats = [x => parseFloat(x).toLocaleString(), x => parseFloat(x).toLocaleString(), x => (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(x / 100, {
  style: 'percent',
  signDisplay: 'never',
  maximumFractionDigits: 2
}), x => (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(x, 's')], chartDataFormats = [lodash__WEBPACK_IMPORTED_MODULE_1__.identity, lodash__WEBPACK_IMPORTED_MODULE_1__.identity, x => x * 100, lodash__WEBPACK_IMPORTED_MODULE_1__.identity]) {
  const rows = [...(report?.rows || [])]; // Copying it to escape side effects by manipulating with rows.
  const rowLength = rows.length;

  // Pad rows to 2 x number of days data points to accommodate new accounts.
  if (days * 2 > rowLength) {
    const date = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.stringToDate)(referenceDate);
    for (let i = 0; days > i; i++) {
      const month = (date.getMonth() + 1).toString();
      const day = date.getDate().toString();
      const dateString = date.getFullYear().toString() + (2 > month.length ? '0' : '') + month + (2 > day.length ? '0' : '') + day;
      if (i > rowLength) {
        const emptyDay = [{
          dimensionValues: [{
            value: dateString
          }, {
            value: 'date_range_0'
          }],
          metricValues: [{
            value: 0
          }, {
            value: 0
          }]
        }, {
          dimensionValues: [{
            value: dateString
          }, {
            value: 'date_range_1'
          }],
          metricValues: [{
            value: 0
          }, {
            value: 0
          }]
        }];
        rows.unshift(...emptyDay);
      }
      date.setDate(date.getDate() - 1);
    }
    rows.push({
      dimensionValues: [{
        value: '0'
      }, {
        value: 'date_range_0'
      }]
    }, {
      dimensionValues: [{
        value: '0'
      }, {
        value: 'date_range_1'
      }]
    });
  }
  const isSessionDuration = dataLabels[selectedStats] === (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Session Duration', 'google-site-kit');
  const dataType = isSessionDuration ? 'timeofday' : 'number';
  const dataMap = [[{
    type: 'date',
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Day', 'google-site-kit')
  }, {
    type: 'string',
    role: 'tooltip',
    p: {
      html: true
    }
  }, {
    type: dataType,
    label: dataLabels[selectedStats]
  }, {
    type: dataType,
    label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Previous period', 'google-site-kit')
  }]];
  const {
    compareRange,
    currentRange
  } = (0,_partition_report__WEBPACK_IMPORTED_MODULE_6__.partitionAnalytics4Report)(rows, {
    dateRangeLength: days
  });
  const lastMonthData = reduceAnalytics4RowsData(currentRange, selectedStats);
  const previousMonthData = reduceAnalytics4RowsData(compareRange, selectedStats);
  const locale = (0,_js_util_i18n__WEBPACK_IMPORTED_MODULE_4__.getLocale)();
  const localeDateOptions = {
    weekday: 'short',
    month: 'short',
    day: 'numeric'
  };
  lastMonthData.forEach((row, i) => {
    if (!row[0] || !row[1] || !previousMonthData[i]) {
      return;
    }
    const chartDataFormat = chartDataFormats[selectedStats];
    const currentMonthDatum = chartDataFormat(row[1]);
    const previousMonthDatum = chartDataFormat(previousMonthData[i][1]);
    const prevMonth = parseFloat(previousMonthDatum);
    const difference = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.calculateDifferenceBetweenChartValues)(currentMonthDatum, prevMonth);
    const svgArrow = (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.getChartDifferenceArrow)(difference);
    const dateRange = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: date for user stats, 2: previous date for user stats comparison */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%1$s vs %2$s', 'Date range for chart tooltip', 'google-site-kit'), row[0].toLocaleDateString(locale, localeDateOptions), previousMonthData[i][0].toLocaleDateString(locale, localeDateOptions));
    const statInfo = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: selected stat label, 2: numeric value of selected stat, 3: up or down arrow , 4: different change in percentage */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%1$s: <strong>%2$s</strong> <em>%3$s %4$s</em>', 'Stat information for chart tooltip', 'google-site-kit'), dataLabels[selectedStats], tooltipDataFormats[selectedStats](currentMonthDatum), svgArrow, (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.numFmt)(Math.abs(difference), '%'));
    dataMap.push([row[0], `<div class="${classnames__WEBPACK_IMPORTED_MODULE_0___default()('googlesitekit-visualization-tooltip', {
      'googlesitekit-visualization-tooltip--up': difference > 0,
      'googlesitekit-visualization-tooltip--down': difference < 0
    })}">
				<p>${dateRange}</p>
				<p>${statInfo}</p>
			</div>`, isSessionDuration ? (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.convertSecondsToArray)(currentMonthDatum) : currentMonthDatum, isSessionDuration ? (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.convertSecondsToArray)(previousMonthDatum) : previousMonthDatum]);
  });
  return dataMap;
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/parseDimensionStringToDate.js":
/*!********************************************************************!*\
  !*** ./js/modules/analytics-4/utils/parseDimensionStringToDate.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * `parseDimensionStringToDate` utility.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts a dimnension string date into a Date object accounting for differences in timezones.
 *
 * @since 1.10.0
 * @since 1.123.0 Migrated from analytics to analytics-4.
 * @private
 *
 * @param {string} dateString String representing the date in the format of `YYYYMMDD`.
 * @return {(Date|boolean)} Object representing the date passed, or false if parsing fails or a non-string is passed.
 */
function parseDimensionStringToDate(dateString) {
  if ('string' === typeof dateString && dateString.match(/[0-9]{8}/)) {
    const year = dateString.slice(0, 4);
    const monthIndex = Number(dateString.slice(4, 6)) - 1;
    const day = dateString.slice(6, 8);
    return new Date(year, monthIndex.toString(), day);
  }
  return false;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parseDimensionStringToDate);

/***/ }),

/***/ "./js/modules/analytics-4/utils/partition-report.js":
/*!**********************************************************!*\
  !*** ./js/modules/analytics-4/utils/partition-report.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionAnalytics4Report: () => (/* binding */ partitionAnalytics4Report)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Analytics-4 partition report utility.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.96.0
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionAnalytics4Report(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');
  function getRowsForDateRange(dateRange) {
    // Filter the report to get only rows that match the given date range.
    return report.filter(({
      dimensionValues: [, dateValue]
    }) => dateValue.value === dateRange);
  }

  // Use a negative date range length for reverse slicing.
  const reverseDateRangeLength = -1 * dateRangeLength;

  // Get the rows for the current date range and the compare date range.
  // The current range should always be sliced from the end.
  const currentRange = getRowsForDateRange('date_range_0').slice(reverseDateRangeLength);
  // The compare range continues from where the current left off (slicing towards the start),
  // and may be shorter (where older data is not available yet) which is fine.
  const compareRange = getRowsForDateRange('date_range_1').slice(reverseDateRangeLength * 2, reverseDateRangeLength);
  return {
    currentRange,
    compareRange
  };
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/report-normalization.js":
/*!**************************************************************!*\
  !*** ./js/modules/analytics-4/utils/report-normalization.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizeReportOptions: () => (/* binding */ normalizeReportOptions)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Analytics 4 report normalization utilities.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Normalizes report options.
 *
 * @since 1.94.0
 *
 * @param {Object} options Report options object.
 * @return {Object} Normalized options object.
 */
const normalizeReportOptions = memize__WEBPACK_IMPORTED_MODULE_1___default()(({
  metrics,
  dimensions,
  ...options
} = {}) => {
  return {
    metrics: normalizeMetrics(metrics),
    dimensions: normalizeDimensions(dimensions),
    ...options
  };
});
function normalizeMetrics(metrics) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.castArray)(metrics).map(metric => typeof metric === 'string' ? {
    name: metric
  } : metric).filter(metric => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(metric));
}
function normalizeDimensions(dimensions) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.castArray)(dimensions).map(dimension => typeof dimension === 'string' ? {
    name: dimension
  } : dimension).filter(dimension => (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(dimension));
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/report-validation.js":
/*!***********************************************************!*\
  !*** ./js/modules/analytics-4/utils/report-validation.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidDimensionFilters: () => (/* binding */ isValidDimensionFilters),
/* harmony export */   isValidDimensions: () => (/* binding */ isValidDimensions),
/* harmony export */   isValidMetricFilters: () => (/* binding */ isValidMetricFilters),
/* harmony export */   isValidMetrics: () => (/* binding */ isValidMetrics),
/* harmony export */   isValidOrders: () => (/* binding */ isValidOrders)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/util/report-validation */ "./js/util/report-validation.js");
/**
 * Analytics 4 reporting API validation utilities.
 *
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint complexity: [ "error", 17 ] */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Verifies that provided metrics match allowed values. Metrics can be a string,
 * an array of string, an array of objects or mix of strings and objects.
 * Objects must have a "name" property that matches the regex `/^[a-zA-Z0-9_]+$/`
 * to be valid. Objects can optionally include an "expression" property.
 *
 * When a single string is provided, it must be a metric name or a comma-separated
 * list of metric names.
 *
 * A metric name must match the regular expression `/^[a-zA-Z0-9_]+$/`.
 *
 * @since 1.94.0
 * @since 1.98.0 Added a regular expression to validate metric names, in keeping with the GA4 API.
 *
 * @param {string|string[]|Object|Object[]} metrics The metrics to check.
 * @return {boolean} TRUE if metrics are valid, otherwise FALSE.
 */
function isValidMetrics(metrics) {
  function isValidName(metricName) {
    return typeof metricName === 'string' && /^[a-zA-Z0-9_]+$/.test(metricName);
  }
  if (typeof metrics === 'string') {
    const metricNames = metrics.split(',');
    return metricNames.every(isValidName);
  }
  return (0,_js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__.isValidStringsOrObjects)(metrics, metric => {
    const validName = metric.hasOwnProperty('name') && isValidName(metric.name);

    // 'expression' is optional, so if it wasn't provided, we can
    // return early.
    if (!metric.hasOwnProperty('expression')) {
      return validName;
    }

    // 'expression', if provided, must be a string.
    const validExpression = typeof metric.expression === 'string';
    return validName && validExpression;
  }, isValidName);
}

/**
 * Verifies provided dimensions to make sure it matches allowed values. It can be a string,
 * array of strings, an object with "name" field, array of such objects or an array of strings
 * and objects.
 *
 * @since 1.94.0
 *
 * @param {string|string[]|Object|Object[]} dimensions The dimensions to check.
 * @return {boolean} TRUE if dimensions are valid, otherwise FALSE.
 */
function isValidDimensions(dimensions) {
  return (0,_js_util_report_validation__WEBPACK_IMPORTED_MODULE_1__.isValidStringsOrObjects)(dimensions, dimension => {
    return dimension.hasOwnProperty('name') && typeof dimension.name === 'string';
  });
}

/**
 * Verifies provided dimensionFilters to make sure they match allowed values found in dimensions.
 *
 * @since 1.94.0
 *
 * @param {Object} filters The dimension filters to check.
 * @return {boolean} TRUE if dimension filters are valid, otherwise FALSE.
 */
function isValidDimensionFilters(filters) {
  // Ensure every dimensionFilter key corresponds to a valid dimension.
  const validType = ['string'];
  return Object.keys(filters).every(dimension => {
    if (validType.includes(typeof filters[dimension])) {
      return true;
    }
    if (Array.isArray(filters[dimension])) {
      return filters[dimension].every(param => validType.includes(typeof param));
    }
    if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(filters[dimension])) {
      const props = Object.keys(filters[dimension]);
      if (!props.includes('filterType')) {
        return false;
      }
      if (filters[dimension].filterType !== 'emptyFilter' && !props.includes('value')) {
        return false;
      }
      return true;
    }
    return false;
  });
}

/**
 * Verifies provided metricFilters to make sure they match allowed values found in metrics and supported filters.
 *
 * @since 1.111.0
 *
 * @param {Object} filters The metric filters to check.
 * @return {boolean} TRUE if dimension filters are valid, otherwise FALSE.
 */
function isValidMetricFilters(filters) {
  const validType = ['string'];
  const allowedFilterTypes = ['numericFilter', 'betweenFilter'];
  return Object.values(filters).every(filter => {
    if (validType.includes(typeof filter)) {
      return true;
    }
    if (Array.isArray(filter)) {
      return filter.every(param => validType.includes(typeof param));
    }
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(filter)) {
      return false;
    }
    const {
      filterType,
      value,
      fromValue,
      toValue
    } = filter;

    // Validate filterType if present
    if (filterType && !allowedFilterTypes.includes(filterType)) {
      return false;
    }
    const props = Object.keys(filter);

    // Numeric Filter (default if filterType is missing)
    if (!filterType || filterType === 'numericFilter') {
      return props.includes('operation') && props.includes('value') && (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(value) || 'int64Value' in value);
    }

    // Between Filter
    if (filterType === 'betweenFilter') {
      return props.includes('fromValue') && props.includes('toValue') && [fromValue, toValue].every(val => !(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(val) || 'int64Value' in val);
    }
    return false;
  });
}

/**
 * Verifies that order definitions are valid for a report. It should be an array
 * of objects where each object has either a "metric" or a "dimension" property,
 * and an optional "desc" property. The "metric" and "dimension" properties should
 * be objects with "metricName" and "dimensionName" properties respectively.
 *
 * @since 1.95.0
 *
 * @param {Object[]} orders The order definitions to check.
 * @return {boolean} TRUE if order definitions are valid, otherwise FALSE.
 */
function isValidOrders(orders) {
  if (!Array.isArray(orders)) {
    return false;
  }
  return orders.every(order => {
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(order)) {
      return false;
    }
    if (order.hasOwnProperty('desc') && typeof order.desc !== 'boolean') {
      return false;
    }
    if (order.metric) {
      return !order.dimension && typeof order.metric?.metricName === 'string';
    }
    if (order.dimension) {
      return typeof order.dimension?.dimensionName === 'string';
    }
    return false;
  });
}

/***/ }),

/***/ "./js/modules/analytics-4/utils/validation.js":
/*!****************************************************!*\
  !*** ./js/modules/analytics-4/utils/validation.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidAccountID: () => (/* reexport safe */ _js_util__WEBPACK_IMPORTED_MODULE_3__.isValidNumericID),
/* harmony export */   isValidAccountSelection: () => (/* binding */ isValidAccountSelection),
/* harmony export */   isValidGoogleTagAccountID: () => (/* binding */ isValidGoogleTagAccountID),
/* harmony export */   isValidGoogleTagContainerID: () => (/* binding */ isValidGoogleTagContainerID),
/* harmony export */   isValidGoogleTagID: () => (/* binding */ isValidGoogleTagID),
/* harmony export */   isValidMeasurementID: () => (/* binding */ isValidMeasurementID),
/* harmony export */   isValidPropertyID: () => (/* binding */ isValidPropertyID),
/* harmony export */   isValidPropertySelection: () => (/* binding */ isValidPropertySelection),
/* harmony export */   isValidWebDataStreamID: () => (/* binding */ isValidWebDataStreamID),
/* harmony export */   isValidWebDataStreamName: () => (/* binding */ isValidWebDataStreamName),
/* harmony export */   isValidWebDataStreamSelection: () => (/* binding */ isValidWebDataStreamSelection),
/* harmony export */   validateAudience: () => (/* binding */ validateAudience),
/* harmony export */   validateReport: () => (/* binding */ validateReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/analytics-4/datastore/constants */ "./js/modules/analytics-4/datastore/constants.js");
/* harmony import */ var _js_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/js/util */ "./js/util/index.js");
/* harmony import */ var _js_util_report_validation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/js/util/report-validation */ "./js/util/report-validation.js");
/* harmony import */ var _report_normalization__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./report-normalization */ "./js/modules/analytics-4/utils/report-normalization.js");
/* harmony import */ var _report_validation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./report-validation */ "./js/modules/analytics-4/utils/report-validation.js");
/**
 * Validation utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * Internal dependencies
 */






/**
 * Checks if the given value is a valid selection for an Account.
 *
 * @since 1.119.0
 *
 * @param {?string} value Selected value.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidAccountSelection(value) {
  if (value === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.ACCOUNT_CREATE) {
    return true;
  }
  return (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.isValidNumericID)(value);
}

/**
 * Checks if the given account ID appears to be a valid Analytics account.
 *
 * @since 1.8.0
 * @since 1.121.0 Migrated from analytics to analytics-4.
 *
 * @param {(string|number)} accountID Account ID to test.
 * @return {boolean} Whether or not the given account ID is valid.
 */


/**
 * Checks whether the given property ID appears to be valid.
 *
 * @since 1.31.0
 *
 * @param {*} propertyID Property ID to check.
 * @return {boolean} Whether or not the given property ID is valid.
 */
function isValidPropertyID(propertyID) {
  return typeof propertyID === 'string' && /^\d+$/.test(propertyID);
}

/**
 * Checks if the given value is a valid selection for a Property.
 *
 * @since 1.31.0
 *
 * @param {?string} value Selected value.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidPropertySelection(value) {
  if (value === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTY_CREATE) {
    return true;
  }
  return isValidPropertyID(value);
}

/**
 * Checks whether the given web data stream ID appears to be valid.
 *
 * @since 1.33.0
 *
 * @param {*} webDataStreamID Web data stream ID to check.
 * @return {boolean} TRUE if the web data stream ID is valid, otherwise FALSE.
 */
function isValidWebDataStreamID(webDataStreamID) {
  return typeof webDataStreamID === 'string' && /^\d+$/.test(webDataStreamID);
}

/**
 * Checks whether the given web data stream is a valid selection.
 *
 * @since 1.35.0
 *
 * @param {?string} webDataStreamID Web data stream to check.
 * @return {boolean} TRUE if the web data stream selection is valid, otherwise FALSE.
 */
function isValidWebDataStreamSelection(webDataStreamID) {
  if (webDataStreamID === _js_modules_analytics_4_datastore_constants__WEBPACK_IMPORTED_MODULE_2__.WEBDATASTREAM_CREATE) {
    return true;
  }
  return isValidWebDataStreamID(webDataStreamID);
}

/**
 * Checks if the given web data stream name appears to be valid.
 *
 * @since 1.124.0
 *
 * @param {string} value Web data stream name to test.
 * @return {boolean} True if valid, otherwise false.
 */
function isValidWebDataStreamName(value) {
  return typeof value === 'string' && value.trim().length > 0;
}

/**
 * Checks whether the given measurementID appears to be valid.
 *
 * @since 1.35.0
 *
 * @param {*} measurementID Web data stream measurementID to check.
 * @return {boolean} TRUE if the measurementID is valid, otherwise FALSE.
 */
function isValidMeasurementID(measurementID) {
  return typeof measurementID === 'string' && /^G-[a-zA-Z0-9]+$/.test(measurementID);
}

/**
 * Checks whether the given googleTagId appears to be valid.
 *
 * @since 1.90.0
 *
 * @param {*} googleTagID Google Tag ID to check.
 * @return {boolean} TRUE if the googleTagID is valid, otherwise FALSE.
 */
function isValidGoogleTagID(googleTagID) {
  return typeof googleTagID === 'string' && /^(G|GT|AW)-[a-zA-Z0-9]+$/.test(googleTagID);
}

/**
 * Checks whether the given googleTagAccountID appears to be valid.
 *
 * @since 1.90.0
 *
 * @param {*} googleTagAccountID Google Tag ID to check.
 * @return {boolean} TRUE if the googleTagAccountID is valid, otherwise FALSE.
 */
function isValidGoogleTagAccountID(googleTagAccountID) {
  return (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.isValidNumericID)(googleTagAccountID);
}

/**
 * Checks whether the given googleTagContainerID appears to be valid.
 *
 * @since 1.90.0
 *
 * @param {*} googleTagContainerID Google Tag ID to check.
 * @return {boolean} TRUE if the googleTagContainerID is valid, otherwise FALSE.
 */
function isValidGoogleTagContainerID(googleTagContainerID) {
  return (0,_js_util__WEBPACK_IMPORTED_MODULE_3__.isValidNumericID)(googleTagContainerID);
}

/**
 * Checks whether a given report options object is valid.
 *
 * @since 1.130.0
 *
 * @param {Object} options The options for the report.
 */
function validateReport(options) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(options), 'options for Analytics 4 report must be an object.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_js_util_report_validation__WEBPACK_IMPORTED_MODULE_4__.isValidDateRange)(options), 'Either date range or start/end dates must be provided for Analytics 4 report.');
  const {
    metrics,
    dimensions,
    dimensionFilters,
    metricFilters,
    orderby
  } = (0,_report_normalization__WEBPACK_IMPORTED_MODULE_5__.normalizeReportOptions)(options);
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(metrics.length, 'Requests must specify at least one metric for an Analytics 4 report.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidMetrics)(metrics), 'metrics for an Analytics 4 report must be either a string, an array of strings, an object, an array of objects, or a mix of strings and objects. Objects must have a "name" property. Metric names must match the expression ^[a-zA-Z0-9_]+$.');
  if (dimensions) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidDimensions)(dimensions), 'dimensions for an Analytics 4 report must be either a string, an array of strings, an object, an array of objects, or a mix of strings and objects. Objects must have a "name" property.');
  }
  if (dimensionFilters) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidDimensionFilters)(dimensionFilters), 'dimensionFilters for an Analytics 4 report must be a map of dimension names as keys and dimension values as values.');
  }
  if (metricFilters) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidMetricFilters)(metricFilters), 'metricFilters for an Analytics 4 report must be a map of metric names as keys and filter value(s) as numeric fields, depending on the filterType.');
  }
  if (orderby) {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,_report_validation__WEBPACK_IMPORTED_MODULE_6__.isValidOrders)(orderby), 'orderby for an Analytics 4 report must be an array of OrderBy objects where each object should have either a "metric" or "dimension" property, and an optional "desc" property.');
  }
}

/**
 * Checks whether the passed audience object is valid.
 *
 * @since 1.120.0
 *
 * @param {Object} audience Audience object to check.
 */
function validateAudience(audience) {
  const audienceFields = ['displayName', 'description', 'membershipDurationDays', 'eventTrigger', 'exclusionDurationMode', 'filterClauses'];
  const audienceRequiredFields = ['displayName', 'description', 'membershipDurationDays', 'filterClauses'];
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(audience), 'Audience must be an object.');
  Object.keys(audience).forEach(key => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(audienceFields.includes(key), `Audience object must contain only valid keys. Invalid key: "${key}"`);
  });
  audienceRequiredFields.forEach(key => {
    invariant__WEBPACK_IMPORTED_MODULE_0___default()(audience[key], `Audience object must contain required keys. Missing key: "${key}"`);
  });
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isArray)(audience.filterClauses), 'filterClauses must be an array with AudienceFilterClause objects.');
}

/***/ }),

/***/ "./js/modules/search-console/constants.js":
/*!************************************************!*\
  !*** ./js/modules/search-console/constants.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MODULE_SLUG_SEARCH_CONSOLE: () => (/* binding */ MODULE_SLUG_SEARCH_CONSOLE)
/* harmony export */ });
/**
 * Search Console module constants.
 *
 * Site Kit by Google, Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULE_SLUG_SEARCH_CONSOLE = 'search-console';

/***/ }),

/***/ "./js/modules/search-console/datastore/constants.js":
/*!**********************************************************!*\
  !*** ./js/modules/search-console/datastore/constants.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATE_RANGE_OFFSET: () => (/* binding */ DATE_RANGE_OFFSET),
/* harmony export */   MODULES_SEARCH_CONSOLE: () => (/* binding */ MODULES_SEARCH_CONSOLE)
/* harmony export */ });
/**
 * `modules/search-console` data store constants.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const MODULES_SEARCH_CONSOLE = 'modules/search-console';

// Date range offset days for Search Console report requests.
const DATE_RANGE_OFFSET = 0;

/***/ }),

/***/ "./js/util/chart.js":
/*!**************************!*\
  !*** ./js/util/chart.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* binding */ calculateDifferenceBetweenChartValues),
/* harmony export */   getChartDifferenceArrow: () => (/* binding */ getChartDifferenceArrow),
/* harmony export */   isSingleSlice: () => (/* binding */ isSingleSlice)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/components/ChangeArrow */ "./js/components/ChangeArrow.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "../node_modules/react/jsx-runtime.js");
/**
 * Utility functions for charts.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Gets the up/down SVG arrow for Google Chart tooltips.
 *
 * @since 1.30.0
 *
 * @param {number}  difference            The difference which can be positive or negative.
 * @param {string}  [options]             Options to be passed to the ChangeArrow component.
 * @param {boolean} [options.invertColor] Whether we need to reverse the +/- colors of the arrow.
 * @return {string} SVG for the +/- difference.
 */

function getChartDifferenceArrow(difference, options = {}) {
  if (Number.isNaN(Number(difference))) {
    return '';
  }
  const {
    invertColor = false
  } = options;
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["default"])(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_js_components_ChangeArrow__WEBPACK_IMPORTED_MODULE_0__["default"], {
    direction: difference > 0 ? 'up' : 'down',
    invertColor: invertColor
  }));
}

/**
 * Checks if there is a single row of data or one row is contributing 100% of the total for a given dimension.
 *
 * @since 1.31.0
 *
 * @param {Array.<Object>} report An array of report data objects.
 * @return {(boolean|undefined)} Returns undefined if report is undefined, true/false for the above conditions.
 */
function isSingleSlice(report) {
  if (report === undefined) {
    return undefined;
  }
  if (report?.[0]?.data?.rows?.length === 1 || report?.[0]?.data?.rows?.[0]?.metrics?.[0]?.values?.[0] === report?.[0]?.data?.totals?.[0]?.values?.[0]) {
    return true;
  }
  return false;
}

/**
 * Calculates difference between two chart values.
 *
 * @since 1.48.0
 *
 * @param {number} currentValue  Current chart value.
 * @param {number} previousValue Previous chart value.
 * @return {number} The difference.
 */
function calculateDifferenceBetweenChartValues(currentValue, previousValue) {
  if (currentValue > 0 && previousValue > 0) {
    return currentValue / previousValue - 1;
  }
  if (currentValue > 0) {
    return 1;
  }
  if (previousValue > 0) {
    return -1;
  }
  return 0;
}

/***/ }),

/***/ "./js/util/convert-time.js":
/*!*********************************!*\
  !*** ./js/util/convert-time.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* binding */ convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* binding */ convertSecondsToArray)
/* harmony export */ });
/**
 * Time related utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Converts seconds into an array with the following values [HH, MM, SS, MS] as described below.
 * HH: hours.
 * MM: minutes.
 * SS: seconds.
 * MS: milliseconds.
 *
 * For example, passing 196.385 returns [ 0, 3, 16, 385 ].
 *
 * @since 1.27.0
 *
 * @param {number} seconds The number of seconds.
 * @return {Array} Array containing the hours, minutes, seconds and milliseconds.
 */
function convertSecondsToArray(seconds) {
  seconds = parseFloat(seconds);
  if (isNaN(seconds) || 0 === seconds) {
    return [0, 0, 0, 0];
  }
  return [Math.floor(seconds / 60 / 60), Math.floor(seconds / 60 % 60), Math.floor(seconds % 60), Math.floor(seconds * 1000) - Math.floor(seconds) * 1000];
}

/**
 * Converts Date time string into UNIX timestamp in milliseconds.
 *
 * For example, passing "2014-10-02T15:01:23Z" returns 1412262083000.
 *
 * @since 1.116.0
 *
 * @param {string} dateStringValue The date time string.
 * @return {number} UNIX timestamp in milliseconds.
 */
function convertDateStringToUNIXTimestamp(dateStringValue) {
  const unixTimestamp = dateStringValue && !Number.isInteger(dateStringValue) ?
  // Valid use of `new Date()` with an argument, because this should only
  // be passed full time strings, not `YYYY-MM-DD` style dates.
  //
  // See: https://github.com/google/site-kit-wp/pull/9459#discussion_r1790660073
  // eslint-disable-next-line sitekit/no-direct-date
  new Date(dateStringValue).getTime() : dateStringValue;
  if (isNaN(unixTimestamp) || !unixTimestamp) {
    return 0;
  }
  return unixTimestamp;
}

/***/ }),

/***/ "./js/util/create-incremental-array-by-size.js":
/*!*****************************************************!*\
  !*** ./js/util/create-incremental-array-by-size.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createIncrementalArrayBySize: () => (/* binding */ createIncrementalArrayBySize)
/* harmony export */ });
/**
 * Create Incremental Array by Size utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Creates an array of length equal to size with incremental values starting at 0.
 *
 * @since 1.28.0
 *
 * @param {number} size Array length.
 * @return {number[]} Array of incremental numbers.
 * @example createIncrementalArrayBySize(3); // [0, 1, 2]
 */
function createIncrementalArrayBySize(size) {
  return new Array(size !== null && size !== void 0 ? size : 0).fill().map((_, i) => i);
}

/***/ }),

/***/ "./js/util/dates.js":
/*!**************************!*\
  !*** ./js/util/dates.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* binding */ DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* binding */ HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* binding */ INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* binding */ INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* binding */ INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* binding */ MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* binding */ MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* binding */ WEEK_IN_SECONDS),
/* harmony export */   dateSub: () => (/* binding */ dateSub),
/* harmony export */   getAvailableDateRanges: () => (/* binding */ getAvailableDateRanges),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* binding */ getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* binding */ getDateString),
/* harmony export */   getPreviousDate: () => (/* binding */ getPreviousDate),
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidDateString: () => (/* binding */ isValidDateString),
/* harmony export */   stringToDate: () => (/* binding */ stringToDate)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */

const INVALID_DATE_INSTANCE_ERROR = 'Date param must construct to a valid date instance or be a valid date instance itself.';
const INVALID_DATE_STRING_ERROR = 'Invalid dateString parameter, it must be a string.';
const INVALID_DATE_RANGE_ERROR = 'Invalid date range, it must be a string with the format "last-x-days".';
const MINUTE_IN_SECONDS = 60;
const HOUR_IN_SECONDS = 60 * MINUTE_IN_SECONDS;
const DAY_IN_SECONDS = 24 * HOUR_IN_SECONDS;
const WEEK_IN_SECONDS = 7 * DAY_IN_SECONDS;
const MONTH_IN_SECONDS = 30 * DAY_IN_SECONDS;

/**
 * Gets the hash of available date ranges.
 *
 * @since 1.12.0
 *
 * @return {Object} The object hash where every key is a date range slug, and the value is an object with the date range slug and its translation.
 */
function getAvailableDateRanges() {
  function label(days) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: %s: number of days */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._n)('Last %s day', 'Last %s days', days, 'google-site-kit'), days);
  }
  return {
    'last-7-days': {
      slug: 'last-7-days',
      label: label(7),
      days: 7
    },
    'last-14-days': {
      slug: 'last-14-days',
      label: label(14),
      days: 14
    },
    'last-28-days': {
      slug: 'last-28-days',
      label: label(28),
      days: 28
    },
    'last-90-days': {
      slug: 'last-90-days',
      label: label(90),
      days: 90
    }
  };
}

/**
 * Gets the current dateRange day count.
 *
 * @since 1.19.0
 * @since 1.26.0 `dateRange` is now a required argument.
 *
 * @param {string} dateRange The date range slug.
 * @return {number} The number of days in the range.
 */
function getCurrentDateRangeDayCount(dateRange) {
  const daysMatch = dateRange.match(/last-(\d+)-days/);
  if (daysMatch && daysMatch[1]) {
    return parseInt(daysMatch[1], 10);
  }
  throw new Error('Unrecognized date range slug.');
}

/**
 * Asserts whether a given date string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateString Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given date string is valid.
 */
function isValidDateString(dateString = '') {
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isString)(dateString)) {
    return false;
  }
  const dateArray = dateString.split('-');
  if (dateArray.length !== 3) {
    return false;
  }

  // Valid use of `new Date()`, constructing a new date from the string.
  // eslint-disable-next-line sitekit/no-direct-date
  const date = new Date(dateString);
  return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date);
}

/**
 * Parses the given Date instance and returns a date string (YYYY-MM-DD).
 *
 * @since 1.18.0
 * @since 1.85.0 Updated the function signature to only accept a Date argument.
 *
 * @param {Date} date Date to parse into a string.
 * @return {string}                 The parsed date string (YYYY-MM-DD).
 */
function getDateString(date) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()((0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(date) && !isNaN(date), INVALID_DATE_INSTANCE_ERROR);
  const month = `${date.getMonth() + 1}`;
  const day = `${date.getDate()}`;
  const year = date.getFullYear();
  return [year, month.length < 2 ? `0${month}` : month, day.length < 2 ? `0${day}` : day].join('-');
}

/**
 * Converts a valid date string to a Date instance.
 *
 * @since 1.38.0
 *
 * @param {string} dateString The date string to parse.
 * @return {Date} Date instance.
 */
function stringToDate(dateString) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(dateString), INVALID_DATE_STRING_ERROR);

  /**
   * Split date into explicit parts rather than pass directly into date constructor
   * to avoid timezone issues caused by parsing as UTC. Ensures date is accurate for
   * the user's local time, otherwise has a chance to return a different day than was
   * passed in depending on timezone.
   */
  const [year, month, day] = dateString.split('-');
  return new Date(year, month - 1, day);
}

/**
 * Parses the given date and returns the previous date (daysBefore).
 *
 * @since 1.18.0
 *
 * @param {string} relativeDate Date string (YYYY-MM-DD) to subtract days from.
 * @param {number} daysBefore   Number of days to subtract from relativeDate.
 * @return {string}             The date string (YYYY-MM-DD) for the previous date.
 */
function getPreviousDate(relativeDate, daysBefore) {
  return getDateString(dateSub(relativeDate, daysBefore * DAY_IN_SECONDS));
}

/**
 * Asserts whether a given dateRange string is valid or invalid.
 *
 * @since 1.18.0
 *
 * @param {string} dateRange Date string to be asserted against. Defaults to an empty string.
 * @return {boolean}          True if the given dateRange string is valid.
 */
function isValidDateRange(dateRange) {
  const parts = dateRange.split('-');
  return parts.length === 3 && parts[0] === 'last' && !Number.isNaN(parts[1]) && !Number.isNaN(parseFloat(parts[1])) && parts[2] === 'days';
}

/**
 * Subtracts duration from the prodived date and returns it.
 *
 * @since 1.132.0
 *
 * @param {Date|string} relativeDate Date string (YYYY-MM-DD) or date object to subtract duration from.
 * @param {number}      duration     The duration in seconds to subtract from relativeDate.
 * @return {Date} Resulting date.
 */
function dateSub(relativeDate, duration) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(isValidDateString(relativeDate) || (0,lodash__WEBPACK_IMPORTED_MODULE_1__.isDate)(relativeDate) && !isNaN(relativeDate), INVALID_DATE_STRING_ERROR);
  const timestamp = isValidDateString(relativeDate) ? Date.parse(relativeDate) : relativeDate.getTime();

  // Valid use of `new Date()` using calculations.
  // eslint-disable-next-line sitekit/no-direct-date
  return new Date(timestamp - duration * 1000);
}

/***/ }),

/***/ "./js/util/errors.js":
/*!***************************!*\
  !*** ./js/util/errors.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_CODE_MISSING_REQUIRED_SCOPE: () => (/* binding */ ERROR_CODE_MISSING_REQUIRED_SCOPE),
/* harmony export */   ERROR_INTERNAL_SERVER_ERROR: () => (/* binding */ ERROR_INTERNAL_SERVER_ERROR),
/* harmony export */   ERROR_INVALID_JSON: () => (/* binding */ ERROR_INVALID_JSON),
/* harmony export */   ERROR_REASON_BAD_REQUEST: () => (/* binding */ ERROR_REASON_BAD_REQUEST),
/* harmony export */   ERROR_REASON_FORBIDDEN: () => (/* binding */ ERROR_REASON_FORBIDDEN),
/* harmony export */   ERROR_REASON_INSUFFICIENT_PERMISSIONS: () => (/* binding */ ERROR_REASON_INSUFFICIENT_PERMISSIONS),
/* harmony export */   getReportErrorMessage: () => (/* binding */ getReportErrorMessage),
/* harmony export */   isAuthError: () => (/* binding */ isAuthError),
/* harmony export */   isErrorRetryable: () => (/* binding */ isErrorRetryable),
/* harmony export */   isInsufficientPermissionsError: () => (/* binding */ isInsufficientPermissionsError),
/* harmony export */   isPermissionScopeError: () => (/* binding */ isPermissionScopeError),
/* harmony export */   isWPError: () => (/* binding */ isWPError)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/**
 * Error Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


// Error codes and reasons.
const ERROR_CODE_MISSING_REQUIRED_SCOPE = 'missing_required_scopes'; // When scopes are missing.
const ERROR_REASON_INSUFFICIENT_PERMISSIONS = 'insufficientPermissions';
const ERROR_REASON_FORBIDDEN = 'forbidden';
const ERROR_INTERNAL_SERVER_ERROR = 'internal_server_error';
const ERROR_INVALID_JSON = 'invalid_json';
const ERROR_REASON_BAD_REQUEST = 'bad_request';

/**
 * Checks if the provided object is an instance of WP_Error class.
 *
 * @since 1.13.0
 *
 * @param {Object} obj The object to check.
 * @return {boolean} TRUE if the object has "code", "data" and "message" properties, otherwise FALSE.
 */
function isWPError(obj) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(obj) && obj.hasOwnProperty('code') && (typeof obj.code === 'string' || typeof obj.code === 'number') && obj.hasOwnProperty('message') && typeof obj.message === 'string' && obj.hasOwnProperty('data'); // We don't check "obj.data" type because it can be anything.
}

/**
 * Checks if the given error is a permission scope error.
 *
 * @since 1.9.0
 * @private
 *
 * @param {Object} error Input to test as a possible permission scope error.
 * @return {boolean} TRUE if permission scope error, otherwise FALSE.
 */
function isPermissionScopeError(error) {
  return error?.code === ERROR_CODE_MISSING_REQUIRED_SCOPE;
}

/**
 * Checks if the given error has insufficient permissions reason.
 *
 * @since 1.16.0
 * @since 1.70.0 Add support for "forbidden" reason.
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's insufficient permissions error, otherwise FALSE.
 */
function isInsufficientPermissionsError(error) {
  return [ERROR_REASON_INSUFFICIENT_PERMISSIONS, ERROR_REASON_FORBIDDEN].includes(error?.data?.reason);
}

/**
 * Checks if the given error is an auth error.
 *
 * @since 1.78.0
 *
 * @param {Object} error The error object to check.
 * @return {boolean} TRUE if it's an auth error, otherwise FALSE.
 */
function isAuthError(error) {
  return !!error?.data?.reconnectURL;
}

/**
 * Checks if the given error can be retried.
 *
 * @since 1.86.0
 *
 * @param {Object} error          The error object to check.
 * @param {Object} [selectorData] The error's associated selector data object.
 * @return {boolean} TRUE if the error is retryable, otherwise FALSE.
 */
function isErrorRetryable(error, selectorData) {
  return !!selectorData?.storeName && !isInsufficientPermissionsError(error) && !isPermissionScopeError(error) && !isAuthError(error);
}

/**
 * Sets the error message for specific error codes.
 *
 * @since 1.92.0
 *
 * @param {Object} error The error object to check.
 * @return {Object} The updated error object.
 */
function getReportErrorMessage(error) {
  if (error?.code === ERROR_INTERNAL_SERVER_ERROR) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('There was a critical error on this website while fetching data', 'google-site-kit');
  } else if (error?.code === ERROR_INVALID_JSON) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The server provided an invalid response', 'google-site-kit');
  }
  return error?.message;
}

/***/ }),

/***/ "./js/util/i18n.js":
/*!*************************!*\
  !*** ./js/util/i18n.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDurationFormat: () => (/* binding */ createDurationFormat),
/* harmony export */   expandNumFmtOptions: () => (/* binding */ expandNumFmtOptions),
/* harmony export */   getLocale: () => (/* binding */ getLocale),
/* harmony export */   listFormat: () => (/* binding */ listFormat),
/* harmony export */   numFmt: () => (/* binding */ numFmt),
/* harmony export */   numberFormat: () => (/* binding */ numberFormat),
/* harmony export */   prepareForReadableLargeNumber: () => (/* binding */ prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* binding */ readableLargeNumber)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memize */ "../node_modules/memize/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(memize__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Internationalization Utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed.
 *
 * For example, passing 65 returns '1m 5s'.
 *
 * @since 1.0.0
 * @since 1.28.0 Refactored and renamed to improve localization.
 * @private
 *
 * @param {number}                     durationInSeconds The number of seconds.
 * @param {(Intl.NumberFormatOptions)} [options]         Optional formatting options.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationFormat(durationInSeconds, options = {}) {
  const {
    formatUnit,
    formatDecimal
  } = createDurationFormat(durationInSeconds, options);
  try {
    // Some browsers, e.g. Safari, throw a RangeError when options.style is
    // not one of decimal, percent, or currency.
    return formatUnit();
  } catch {
    // Fallback to XXh YYm ZZs using localized decimals with hardcoded units.
    return formatDecimal();
  }
}

/**
 * Converts seconds to a display ready string indicating
 * the number of hours, minutes and seconds that have elapsed
 * in ISO format - HH:mm:ss.
 *
 * If the duration is less than an hour, the HH part of the string
 * is truncated.
 * For example, passing 65 returns '01:05'.
 * Passing 5400 returns '01:30:00'.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {string} Human readable string indicating time elapsed.
 */
function durationISOFormat(durationInSeconds) {
  let {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  seconds = ('0' + seconds).slice(-2);
  minutes = ('0' + minutes).slice(-2);
  hours = ('0' + hours).slice(-2);
  return hours === '00' ? `${minutes}:${seconds}` : `${hours}:${minutes}:${seconds}`;
}

/**
 * Parses the duration in seconds into hours, minutes and seconds.
 *
 * @since 1.111.0
 * @private
 *
 * @param {number} durationInSeconds The number of seconds.
 * @return {Object} Number of hours, minutes and seconds equivalent
 * to the given duration in seconds.
 */
function parseDuration(durationInSeconds) {
  durationInSeconds = parseInt(durationInSeconds, 10);
  if (Number.isNaN(durationInSeconds)) {
    durationInSeconds = 0;
  }
  const hours = Math.floor(durationInSeconds / 60 / 60);
  const minutes = Math.floor(durationInSeconds / 60 % 60);
  const seconds = Math.floor(durationInSeconds % 60);
  return {
    hours,
    minutes,
    seconds
  };
}

/**
 * Creates duration formatting utilities.
 *
 * Not intended to be used directly.
 * Use `numFmt( number, { style: 'duration' } )` instead.
 *
 * @since 1.29.0
 * @private
 *
 * @param {number} durationInSeconds Duration to format.
 * @param {Object} [options]         Formatting options.
 * @return {Object} Formatting functions.
 */
function createDurationFormat(durationInSeconds, options = {}) {
  const {
    hours,
    minutes,
    seconds
  } = parseDuration(durationInSeconds);
  return {
    hours,
    minutes,
    seconds,
    formatUnit() {
      const {
        unitDisplay = 'short',
        ...restOptions
      } = options;
      const commonOptions = {
        unitDisplay,
        ...restOptions,
        style: 'unit'
      };
      if (durationInSeconds === 0) {
        return numberFormat(seconds, {
          ...commonOptions,
          unit: 'second'
        });
      }
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? numberFormat(seconds, {
        ...commonOptions,
        unit: 'second'
      }) : '', minutes ? numberFormat(minutes, {
        ...commonOptions,
        unit: 'minute'
      }) : '', hours ? numberFormat(hours, {
        ...commonOptions,
        unit: 'hour'
      }) : '').trim();
    },
    /**
     * Formats the duration using integers and translatable strings.
     * This is only used as a fallback when the above `formatUnit` fails.
     *
     * @since 1.29.0
     *
     * @return {string} Formatted duration.
     */
    formatDecimal() {
      const formattedSeconds = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of seconds with "s" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%ds', 'google-site-kit'), seconds);
      if (durationInSeconds === 0) {
        return formattedSeconds;
      }
      const formattedMinutes = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of minutes with "m" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dm', 'google-site-kit'), minutes);
      const formattedHours = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
      // translators: %s: number of hours with "h" as the abbreviated unit.
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%dh', 'google-site-kit'), hours);
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(/* translators: 1: formatted seconds, 2: formatted minutes, 3: formatted hours */
      (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__._x)('%3$s %2$s %1$s', 'duration of time: hh mm ss', 'google-site-kit'), seconds ? formattedSeconds : '', minutes ? formattedMinutes : '', hours ? formattedHours : '').trim();
    }
  };
}

/**
 * Prepares a number to be used in readableLargeNumber.
 *
 * @since 1.7.0
 *
 * @param {number} number The large number to prepare.
 * @return {number} The prepared number.
 */
function prepareForReadableLargeNumber(number) {
  if (1000000 <= number) {
    return Math.round(number / 100000) / 10;
  }
  if (10000 <= number) {
    return Math.round(number / 1000);
  }
  if (1000 <= number) {
    return Math.round(number / 100) / 10;
  }
  return number;
}

/**
 * Formats a large number for shortened display.
 *
 * @since 1.0.0
 *
 * @param {number} number The large number to format.
 * @return {string} The formatted number.
 */
function readableLargeNumber(number) {
  const withSingleDecimal = {
    minimumFractionDigits: 1,
    maximumFractionDigits: 1
  };

  // Numbers over 1,000,000 round normally and display a single decimal unless the decimal is 0.
  if (1000000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in millions.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sM', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }

  // Numbers between 10,000 and 1,000,000 round normally and have no decimals
  if (10000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number)));
  }

  // Numbers between 1,000 and 10,000 round normally and display a single decimal unless the decimal is 0.
  if (1000 <= number) {
    return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.sprintf)(
    // translators: %s: an abbreviated number in thousands.
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('%sK', 'google-site-kit'), numberFormat(prepareForReadableLargeNumber(number), number % 10 === 0 ? {} : withSingleDecimal));
  }
  return numberFormat(number, {
    signDisplay: 'never',
    maximumFractionDigits: 1
  });
}

/**
 * Parses formatting options and returns an object with options for selected formatting.
 *
 * @since 1.103.0
 *
 * @param {(Intl.NumberFormatOptions|string)} options Formatting options or unit shorthand. Possible shorthand values are '%', 's', or a currency code.
 * @return {Object} Formatting options.
 */
function expandNumFmtOptions(options) {
  let formatOptions = {};

  // Expand shorthand values for units.
  if ('%' === options) {
    formatOptions = {
      style: 'percent',
      maximumFractionDigits: 2
    };
  } else if ('s' === options) {
    formatOptions = {
      style: 'duration',
      unitDisplay: 'narrow'
    };
  } else if (!!options && typeof options === 'string') {
    formatOptions = {
      style: 'currency',
      currency: options
    };
  } else if ((0,lodash__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(options)) {
    formatOptions = {
      ...options
    };
  }
  return formatOptions;
}

/**
 * Formats a number with unit using the JS Internationalization Number Format API.
 *
 * In addition to the supported 'style' values of the lower-level `numberFormat` function, this function
 * supports two additional 'style' values 'metric' and 'duration' (expects a number in seconds).
 *
 * Another differentiation in behavior is that by default the function will use 'metric' formatting instead
 * of 'decimal' formatting.
 *
 * @since 1.24.0
 *
 * @param {number|string}                     number    The number to format.
 * @param {(Intl.NumberFormatOptions|string)} [options] Formatting options or unit shorthand.
 *                                                      Possible shorthand values are '%', 's',
 *                                                      or a currency code.
 * @return {string} The formatted number.
 */
function numFmt(number, options = {}) {
  // Cast parsable values to numeric types.
  number = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number) ? number : Number(number);
  if (!(0,lodash__WEBPACK_IMPORTED_MODULE_0__.isFinite)(number)) {
    // eslint-disable-next-line no-console
    console.warn('Invalid number', number, typeof number);
    number = 0;
  }
  const formatOptions = expandNumFmtOptions(options);
  const {
    style = 'metric'
  } = formatOptions; // Note: `metric` is our custom, default style.

  if ('metric' === style) {
    return readableLargeNumber(number);
  }
  if ('duration' === style) {
    return durationFormat(number, formatOptions);
  }
  if ('durationISO' === style) {
    return durationISOFormat(number);
  }
  return numberFormat(number, formatOptions);
}

// Warn once for a given message.
const warnOnce = memize__WEBPACK_IMPORTED_MODULE_1___default()(console.warn); // eslint-disable-line no-console

/**
 * Formats a number using the JS Internationalization Number Format API.
 *
 * @since 1.8.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat/NumberFormat|`options` parameter} For all available formatting options.
 *
 * @param {number}                   number           The number to format.
 * @param {Intl.NumberFormatOptions} [options]        Formatting options.
 * @param {string}                   [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @return {string} The formatted number.
 */
function numberFormat(number, options = {}) {
  const {
    locale = getLocale(),
    ...formatOptions
  } = options;
  try {
    /**
     * Per https://github.com/google/site-kit-wp/issues/3255 there have been issues with some versions of Safari
     * on some operating systems throwing issues with some parameters in the formatOptions.
     *
     * If an error is thrown, we remove some troublesome params from the formatOptions object and fallback to no formatting.
     *
     * This allows us to degrade somewhat gracefully without breaking the dashboard for users of unaffected browsers.
     */
    return new Intl.NumberFormat(locale, formatOptions).format(number);
  } catch (error) {
    warnOnce(`Site Kit numberFormat error: Intl.NumberFormat( ${JSON.stringify(locale)}, ${JSON.stringify(formatOptions)} ).format( ${typeof number} )`, error.message);
  }

  // Remove these key/values from formatOptions.
  const unstableFormatOptionValues = {
    currencyDisplay: 'narrow',
    currencySign: 'accounting',
    style: 'unit'
  };

  // Remove these keys from formatOptions irrespective of value.
  const unstableFormatOptions = ['signDisplay', 'compactDisplay'];
  const reducedFormatOptions = {};
  for (const [key, value] of Object.entries(formatOptions)) {
    if (unstableFormatOptionValues[key] && value === unstableFormatOptionValues[key]) {
      continue;
    }
    if (unstableFormatOptions.includes(key)) {
      continue;
    }
    reducedFormatOptions[key] = value;
  }
  try {
    return new Intl.NumberFormat(locale, reducedFormatOptions).format(number);
  } catch {
    return new Intl.NumberFormat(locale).format(number);
  }
}

/**
 * Flattens an array of strings into a string using the JS Internationalization List Format API.
 *
 * @since 1.23.0
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat|`options` parameter} For all available options.
 *
 * @param {Array}  list             The list to flatten.
 * @param {Object} [options]        Formatting options.
 * @param {string} [options.locale] Locale to use for formatting. Defaults to current locale used by Site Kit.
 * @param {string} [options.style]  Length of the formatted message. Defaults to long.
 * @param {string} [options.type]   Type of list. Defaults to 'conjunction' (A, B, and C).
 *                                  Also available 'disjunction' (A, B, or C)
 *                                  Also available 'unit' (5 pounds, 12 ounces)
 * @return {string} The flattened list.
 */
function listFormat(list, options = {}) {
  const {
    locale = getLocale(),
    style = 'long',
    type = 'conjunction'
  } = options;

  // Not all browsers support Intl.Listformat per
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/ListFormat/ListFormat#Browser_compatibility
  // We've seen that the built versions don't polyfill for the unsupported browsers (iOS/safari) so we provide a fallback.
  if (Intl.ListFormat) {
    const formatter = new Intl.ListFormat(locale, {
      style,
      type
    });
    return formatter.format(list);
  }

  /* translators: used between list items, there is a space after the comma. */
  const listSeparator = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)(', ', 'google-site-kit');
  return list.join(listSeparator);
}

/**
 * Gets the current locale for use with browser APIs.
 *
 * @since 1.8.0
 *
 * @param {Object} _global The global window object.
 * @return {string} Current Site Kit locale if set, otherwise the current language set by the browser.
 *                  E.g. `en-US` or `de-DE`
 */
function getLocale(_global = __webpack_require__.g) {
  const siteKitLocale = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(_global, ['_googlesitekitLegacyData', 'locale']);
  if (siteKitLocale) {
    const matches = siteKitLocale.match(/^(\w{2})?(_)?(\w{2})/);
    if (matches && matches[0]) {
      return matches[0].replace(/_/g, '-');
    }
  }
  return _global.navigator.language;
}

/***/ }),

/***/ "./js/util/index.js":
/*!**************************!*\
  !*** ./js/util/index.js ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DAY_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.DAY_IN_SECONDS),
/* harmony export */   HOUR_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.HOUR_IN_SECONDS),
/* harmony export */   INVALID_DATE_INSTANCE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_INSTANCE_ERROR),
/* harmony export */   INVALID_DATE_RANGE_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_RANGE_ERROR),
/* harmony export */   INVALID_DATE_STRING_ERROR: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.INVALID_DATE_STRING_ERROR),
/* harmony export */   MINUTE_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MINUTE_IN_SECONDS),
/* harmony export */   MONTH_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.MONTH_IN_SECONDS),
/* harmony export */   WEEK_IN_SECONDS: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.WEEK_IN_SECONDS),
/* harmony export */   calculateChange: () => (/* binding */ calculateChange),
/* harmony export */   calculateDifferenceBetweenChartValues: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.calculateDifferenceBetweenChartValues),
/* harmony export */   convertDateStringToUNIXTimestamp: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertDateStringToUNIXTimestamp),
/* harmony export */   convertSecondsToArray: () => (/* reexport safe */ _convert_time__WEBPACK_IMPORTED_MODULE_7__.convertSecondsToArray),
/* harmony export */   createDurationFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.createDurationFormat),
/* harmony export */   dateSub: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.dateSub),
/* harmony export */   decodeHTMLEntity: () => (/* binding */ decodeHTMLEntity),
/* harmony export */   expandNumFmtOptions: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.expandNumFmtOptions),
/* harmony export */   getAvailableDateRanges: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getAvailableDateRanges),
/* harmony export */   getChartDifferenceArrow: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.getChartDifferenceArrow),
/* harmony export */   getCurrentDateRangeDayCount: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getCurrentDateRangeDayCount),
/* harmony export */   getDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getDateString),
/* harmony export */   getFullURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getFullURL),
/* harmony export */   getLocale: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.getLocale),
/* harmony export */   getPreviousDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.getPreviousDate),
/* harmony export */   getStorage: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.getStorage),
/* harmony export */   getURLPath: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.getURLPath),
/* harmony export */   isHashOnly: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.isHashOnly),
/* harmony export */   isNumeric: () => (/* reexport safe */ _isnumeric__WEBPACK_IMPORTED_MODULE_12__.isNumeric),
/* harmony export */   isSingleSlice: () => (/* reexport safe */ _chart__WEBPACK_IMPORTED_MODULE_9__.isSingleSlice),
/* harmony export */   isValidDateRange: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateRange),
/* harmony export */   isValidDateString: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.isValidDateString),
/* harmony export */   isValidNumericID: () => (/* reexport safe */ _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__.isValidNumericID),
/* harmony export */   listFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.listFormat),
/* harmony export */   markdownToHTML: () => (/* reexport safe */ _markdown__WEBPACK_IMPORTED_MODULE_6__.markdownToHTML),
/* harmony export */   normalizeURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.normalizeURL),
/* harmony export */   numFmt: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numFmt),
/* harmony export */   numberFormat: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.numberFormat),
/* harmony export */   partitionReport: () => (/* reexport safe */ _partition_report__WEBPACK_IMPORTED_MODULE_14__.partitionReport),
/* harmony export */   prepareForReadableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.prepareForReadableLargeNumber),
/* harmony export */   readableLargeNumber: () => (/* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_5__.readableLargeNumber),
/* harmony export */   safelySort: () => (/* reexport safe */ _safely_sort__WEBPACK_IMPORTED_MODULE_13__.safelySort),
/* harmony export */   sanitizeHTML: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.sanitizeHTML),
/* harmony export */   shortenURL: () => (/* reexport safe */ _urls__WEBPACK_IMPORTED_MODULE_10__.shortenURL),
/* harmony export */   storageAvailable: () => (/* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_4__.storageAvailable),
/* harmony export */   stringToDate: () => (/* reexport safe */ _dates__WEBPACK_IMPORTED_MODULE_8__.stringToDate),
/* harmony export */   stringifyObject: () => (/* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_3__.stringifyObject),
/* harmony export */   trackEvent: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEvent),
/* harmony export */   trackEventOnce: () => (/* reexport safe */ _tracking__WEBPACK_IMPORTED_MODULE_1__.trackEventOnce),
/* harmony export */   untrailingslashit: () => (/* reexport safe */ _sanitize__WEBPACK_IMPORTED_MODULE_2__.untrailingslashit),
/* harmony export */   validateJSON: () => (/* binding */ validateJSON)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tracking__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tracking */ "./js/util/tracking/index.js");
/* harmony import */ var _sanitize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sanitize */ "./js/util/sanitize.js");
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./stringify */ "./js/util/stringify.js");
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./storage */ "./js/util/storage.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./i18n */ "./js/util/i18n.js");
/* harmony import */ var _markdown__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./markdown */ "./js/util/markdown.js");
/* harmony import */ var _convert_time__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./convert-time */ "./js/util/convert-time.js");
/* harmony import */ var _dates__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dates */ "./js/util/dates.js");
/* harmony import */ var _chart__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./chart */ "./js/util/chart.js");
/* harmony import */ var _urls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./urls */ "./js/util/urls.js");
/* harmony import */ var _is_valid_numeric_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./is-valid-numeric-id */ "./js/util/is-valid-numeric-id.js");
/* harmony import */ var _isnumeric__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isnumeric */ "./js/util/isnumeric.js");
/* harmony import */ var _safely_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./safely-sort */ "./js/util/safely-sort.js");
/* harmony import */ var _partition_report__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./partition-report */ "./js/util/partition-report.js");
/**
 * Utility functions.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */
















/**
 * Calculates the change between two values.
 *
 * @since 1.24.0
 *
 * @param {number} previous The previous value.
 * @param {number} current  The current value.
 * @return {(number|null)} The percent change. Null if the input or output is invalid.
 */
function calculateChange(previous, current) {
  function isZero(value) {
    return value === '0' || value === 0;
  }

  // Prevent null result when both values are legitimately zero.
  if (isZero(previous) && isZero(current)) {
    return 0;
  }

  // Prevent divide by zero errors.
  if (isZero(previous) || Number.isNaN(previous)) {
    return null;
  }

  // Avoid NaN at all costs.
  const change = (current - previous) / previous;
  if (Number.isNaN(change) || !Number.isFinite(change)) {
    return null;
  }
  return change;
}

/**
 * Verifies whether JSON is valid.
 *
 * @since 1.0.0
 *
 * @param {string} stringToValidate The string to validate.
 * @return {boolean} Indicates JSON is valid.
 */
function validateJSON(stringToValidate) {
  try {
    return JSON.parse(stringToValidate) && !!stringToValidate;
  } catch (e) {
    return false;
  }
}

/**
 * Converts HTML text into an HTML entity.
 *
 * _.unescape doesn't seem to decode some entities for admin bar titles.
 * adding combination in this helper as a workaround.
 *
 * @since 1.0.0
 *
 * @param {string} str The string to decode.
 * @return {string} Decoded HTML entity.
 */
function decodeHTMLEntity(str) {
  if (!str) {
    return '';
  }
  const decoded = str.replace(/&#(\d+);/g, (match, dec) => {
    return String.fromCharCode(dec);
  }).replace(/(\\)/g, '');
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.unescape)(decoded);
}

/***/ }),

/***/ "./js/util/initialize-google-global.js":
/*!*********************************************!*\
  !*** ./js/util/initialize-google-global.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Side Effect to initialize `google` global.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

if (!Object.prototype.hasOwnProperty.call(__webpack_require__.g, 'google')) {
  __webpack_require__.g.google = {};
}

/***/ }),

/***/ "./js/util/insufficient-permissions-error-description.js":
/*!***************************************************************!*\
  !*** ./js/util/insufficient-permissions-error-description.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getInsufficientPermissionsErrorDescription: () => (/* binding */ getInsufficientPermissionsErrorDescription)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/js/modules/analytics-4/constants */ "./js/modules/analytics-4/constants.js");
/* harmony import */ var _js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/js/modules/search-console/constants */ "./js/modules/search-console/constants.js");
/**
 * `getInsufficientPermissionsErrorDescription` function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Gets a description for an insufficient permissions error.
 *
 * @since 1.16.0
 *
 * @param {string} error              Original error message.
 * @param {Object} module             Module data.
 * @param {string} module.name        The name of the module.
 * @param {string} module.slug        The slug of the module.
 * @param {Object} module.owner       The owner of the module.
 * @param {string} module.owner.login The The login of the current owner.
 * @return {string}                   Error description.
 */
function getInsufficientPermissionsErrorDescription(error = '', module = {}) {
  const {
    slug = '',
    name = '',
    owner = {}
  } = module || {};

  // If no module data provided, it is impossible to provide a more clear message.
  if (!slug || !name) {
    return error;
  }
  let message = '';
  let userInfo = '';
  if (_js_modules_analytics_4_constants__WEBPACK_IMPORTED_MODULE_1__.MODULE_SLUG_ANALYTICS_4 === slug) {
    if (error.match(/account/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics account, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    } else if (error.match(/property/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics property, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    } else if (error.match(/view/i)) {
      message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Analytics view, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
    }
  } else if (_js_modules_search_console_constants__WEBPACK_IMPORTED_MODULE_2__.MODULE_SLUG_SEARCH_CONSOLE === slug) {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions for this Search Console property, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit');
  }
  if (!message) {
    message = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: module name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Your Google account does not have sufficient permissions to access %s data, so you won’t be able to see stats from it on the Site Kit dashboard.', 'google-site-kit'), name);
  }
  if (owner && owner.login) {
    userInfo = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.sprintf)(/* translators: %s: owner name */
    (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This service was originally connected by the administrator "%s" — you can contact them for more information.', 'google-site-kit'), owner.login);
  }
  if (!userInfo) {
    userInfo = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('This service was originally connected by an administrator — you can contact them for more information.', 'google-site-kit');
  }
  return `${message} ${userInfo}`;
}

/***/ }),

/***/ "./js/util/is-site-kit-screen.js":
/*!***************************************!*\
  !*** ./js/util/is-site-kit-screen.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isSiteKitScreen: () => (/* binding */ isSiteKitScreen)
/* harmony export */ });
/* harmony import */ var _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/googlesitekit/constants */ "./js/googlesitekit/constants.js");
/**
 * Utility function to check whether or not a view-context is a Site Kit view.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Internal dependencies
 */


/**
 * Checks whether or not the current viewContext is a Site Kit screen.
 *
 * @since 1.80.0
 *
 * @param {string} viewContext The view-context.
 * @return {boolean} TRUE if the passed view-context is a site kit view; otherwise FALSE.
 */
function isSiteKitScreen(viewContext) {
  return _js_googlesitekit_constants__WEBPACK_IMPORTED_MODULE_0__.SITE_KIT_VIEW_CONTEXTS.includes(viewContext);
}

/***/ }),

/***/ "./js/util/is-valid-numeric-id.js":
/*!****************************************!*\
  !*** ./js/util/is-valid-numeric-id.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidNumericID: () => (/* binding */ isValidNumericID)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks the given value to see if it is a positive integer.
 *
 * @since 1.11.0 Function introduced.
 * @since 1.90.0 Moved outside Tag Manager to a generic utility function.
 *
 * @param {*} input Value to check.
 * @return {boolean} Validity.
 */
function isValidNumericID(input) {
  const id = parseFloat(input) || 0;
  if (!Number.isInteger(id)) {
    return false;
  }
  return id > 0;
}

/***/ }),

/***/ "./js/util/isnumeric.js":
/*!******************************!*\
  !*** ./js/util/isnumeric.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isNumeric: () => (/* binding */ isNumeric)
/* harmony export */ });
/**
 * Utility function related to checking if a given value is numeric.
 *
 * Site Kit by Google, Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Checks if a given value is numeric.
 *
 * @since 1.80.0
 *
 * @param {*} value The value to check.
 * @return {boolean} TRUE if a value is numeric FALSE otherwise.
 */
function isNumeric(value) {
  if (typeof value === 'number') {
    return true;
  }
  const string = (value || '').toString();
  if (!string) {
    return false;
  }
  return !isNaN(string);
}

/***/ }),

/***/ "./js/util/markdown.js":
/*!*****************************!*\
  !*** ./js/util/markdown.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   markdownToHTML: () => (/* binding */ markdownToHTML)
/* harmony export */ });
/**
 * Markdown utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Replaces markdown links with its HTML equivalents.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownLinks(text) {
  return text.replace(new RegExp('\\[([^\\]]+)\\]\\((https?://[^/]+\\.\\w+/?.*?)\\)', 'gi'), '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>');
}

/**
 * Adds paragraphs to the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownParagraphs(text) {
  return `<p>${text.replace(/\n{2,}/g, '</p><p>')}</p>`;
}

/**
 * Replaces line breaks in the text.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} Text with HTML links.
 */
function markdownBreaks(text) {
  return text.replace(/\n/gi, '<br>');
}

/**
 * Converts markdown to HTML.
 *
 * @since 1.22.0
 *
 * @param {string} text Markdown text.
 * @return {string} HTML version of the markdown text.
 */
function markdownToHTML(text) {
  const rules = [markdownLinks, markdownParagraphs, markdownBreaks];
  let html = text;
  for (const rule of rules) {
    html = rule(html);
  }
  return html;
}

/***/ }),

/***/ "./js/util/partition-report.js":
/*!*************************************!*\
  !*** ./js/util/partition-report.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   partitionReport: () => (/* binding */ partitionReport)
/* harmony export */ });
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! invariant */ "../node_modules/invariant/browser.js");
/* harmony import */ var invariant__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(invariant__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Report partitioning utility.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Splits report data into segments for current and comparison ranges.
 *
 * @since 1.33.0
 * @since 1.34.0 Updated to support incomplete `report` arrays.
 *
 * @param {Array}  report               Report rows.
 * @param {Object} args                 Additional arguments.
 * @param {number} args.dateRangeLength Date range length of report segments.
 * @return {Object} Object with keys for `compareRange` and `currentRange`.
 */
function partitionReport(report, {
  dateRangeLength
}) {
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Array.isArray(report), 'report must be an array to partition.');
  invariant__WEBPACK_IMPORTED_MODULE_0___default()(Number.isInteger(dateRangeLength) && dateRangeLength > 0, 'dateRangeLength must be a positive integer.');

  // Use a negative date range length for reverse slicing.
  const _dateRangeLength = -1 * dateRangeLength;
  return {
    // The current range should always be sliced from the end.
    currentRange: report.slice(_dateRangeLength),
    // The compare range continues from where the current left off (slicing towards the start),
    // and may be shorter (where older data is not available yet) which is fine.
    compareRange: report.slice(_dateRangeLength * 2, _dateRangeLength)
  };
}

/***/ }),

/***/ "./js/util/purify.js":
/*!***************************!*\
  !*** ./js/util/purify.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   purify: () => (/* binding */ purify)
/* harmony export */ });
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! dompurify */ "../node_modules/dompurify/dist/purify.js");
/* harmony import */ var dompurify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dompurify__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

const purify = dompurify__WEBPACK_IMPORTED_MODULE_0___default()(__webpack_require__.g);

/***/ }),

/***/ "./js/util/report-validation.js":
/*!**************************************!*\
  !*** ./js/util/report-validation.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidDateRange: () => (/* binding */ isValidDateRange),
/* harmony export */   isValidOrders: () => (/* binding */ isValidOrders),
/* harmony export */   isValidStringsOrObjects: () => (/* binding */ isValidStringsOrObjects),
/* harmony export */   isValidStringularItems: () => (/* binding */ isValidStringularItems)
/* harmony export */ });
/**
 * Reporting API validation utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Validates data that can be either string or object of the certain type, or array of them.
 *
 * @since 1.13.0
 * @since 1.98.0 Added verifyStringFunction parameter.
 *
 * @param {string|string[]|Object|Object[]} data                   The data to check.
 * @param {Function}                        verifyObjectFunction   The callback to verify an object.
 * @param {Function}                        [verifyStringFunction] The callback to verify a string (optional).
 * @return {boolean} TRUE if data is valid, otherwise FALSE.
 */
function isValidStringsOrObjects(data, verifyObjectFunction, verifyStringFunction = () => true) {
  if (typeof data === 'string') {
    return verifyStringFunction(data);
  }
  if (typeof data === 'object' && verifyObjectFunction(data)) {
    return true;
  }
  if (Array.isArray(data)) {
    return data.every(item => {
      if (typeof item === 'string') {
        return verifyStringFunction(item);
      }
      if (typeof item === 'object') {
        return verifyObjectFunction(item);
      }
      return false;
    });
  }

  // Arguably this should fail/throw, because none of our allowed types were encountered.
  return false;
}

/**
 * Verifies that either date range or start and end dates are valid.
 *
 * @since 1.13.0
 *
 * @param {Object} dates           The object containing dates to check.
 * @param {string} dates.startDate The start date to check.
 * @param {string} dates.endDate   The end date to check.
 * @return {boolean} TRUE if either date range or start/end dates are valid, otherwise FALSE.
 */
function isValidDateRange({
  startDate,
  endDate
}) {
  const validStartDate = startDate && startDate.match(/^\d{4}-\d{2}-\d{2}$/);
  const validEndDate = endDate && endDate.match(/^\d{4}-\d{2}-\d{2}$/);
  return validStartDate && validEndDate;
}

/**
 * Verifies that order definitions are valid. It can be either an object or an array
 * of objects where each object has "fieldName" and valid "sortOrder" properties.
 *
 * @since 1.13.0
 *
 * @param {Object|Object[]} orders The order definitions to check.
 * @return {boolean} TRUE if order definitions are valid, otherwise FALSE.
 */
function isValidOrders(orders) {
  function isValidOrder(order) {
    const isValidFieldName = order.hasOwnProperty('fieldName') && !!order.fieldName;
    const isValidSortOrder = order.hasOwnProperty('sortOrder') && /(ASCENDING|DESCENDING)/i.test(order.sortOrder.toString());
    return isValidFieldName && isValidSortOrder;
  }
  if (Array.isArray(orders)) {
    return orders.every(item => typeof item === 'object' && isValidOrder(item));
  }
  if (typeof orders === 'object') {
    return isValidOrder(orders);
  }

  // Arguably this should fail/throw, because none of our allowed types were encountered.
  return false;
}

/**
 * Verifies that provided parameter is either a string or an array of strings.
 *
 * @since 1.15.0
 *
 * @param {(string|Array.<string>)} items Items to validate.
 * @return {boolean} TRUE if items are either a string or an array of strings, otherwise FALSE.
 */
function isValidStringularItems(items) {
  if (typeof items === 'string') {
    return true;
  }
  if (Array.isArray(items)) {
    return items.every(item => typeof item === 'string');
  }
  return false;
}

/***/ }),

/***/ "./js/util/safely-sort.js":
/*!********************************!*\
  !*** ./js/util/safely-sort.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safelySort: () => (/* binding */ safelySort)
/* harmony export */ });
/**
 * `safelySort` utility function.
 *
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Sorts an array without causing the mutation if the given parameter is an array.
 * If the parameter is not an array, it returns the parameter as is.
 *
 * @since 1.110.0
 * @since 1.128.0 Moved to the common utility directory from the key metrics directory.
 *
 * @param {Array|*} arr Param to be sorted.
 * @return {Array|*} 	Safely sorted array without mutation.
 */
function safelySort(arr) {
  return Array.isArray(arr) ? [...arr].sort() : arr;
}

/***/ }),

/***/ "./js/util/sanitize.js":
/*!*****************************!*\
  !*** ./js/util/sanitize.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sanitizeHTML: () => (/* binding */ sanitizeHTML),
/* harmony export */   untrailingslashit: () => (/* binding */ untrailingslashit)
/* harmony export */ });
/* harmony import */ var _purify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./purify */ "./js/util/purify.js");
/**
 * Internal dependencies
 */

function sanitizeHTML(unsafeHTML, domPurifyConfig = {}) {
  return {
    __html: _purify__WEBPACK_IMPORTED_MODULE_0__.purify.sanitize(unsafeHTML, domPurifyConfig)
  };
}

/**
 * Takes a string or an URL object, removes the trailing slash if any and returns it.
 *
 * @since 1.20.0
 * @private
 *
 * @param {Object|string} url A string with or without trailing slash or an URL object.
 * @return {string|undefined} The URL string after removing the trailing slash.
 */
function untrailingslashit(url) {
  const originalURL = typeof url === 'object' ? url.toString() : url;
  return originalURL?.replace?.(/\/+$/, '');
}

/***/ }),

/***/ "./js/util/storage.js":
/*!****************************!*\
  !*** ./js/util/storage.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorage: () => (/* binding */ getStorage),
/* harmony export */   storageAvailable: () => (/* binding */ storageAvailable)
/* harmony export */ });
/**
 * Storage abstraction.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Detects whether browser storage is both supported and available.
 *
 * @since 1.0.0
 *
 * @param {string} type Browser storage to test. ex localStorage or sessionStorage.
 * @return {boolean} True if the given storage is available, false otherwise.
 */
function storageAvailable(type) {
  const storage = __webpack_require__.g[type];
  if (!storage) {
    return false;
  }
  try {
    const x = '__storage_test__';
    storage.setItem(x, x);
    storage.removeItem(x);
    return true;
  } catch (e) {
    return e instanceof DOMException && (
    // everything except Firefox
    22 === e.code ||
    // Firefox
    1014 === e.code ||
    // test name field too, because code might not be present
    // everything except Firefox
    'QuotaExceededError' === e.name ||
    // Firefox
    'NS_ERROR_DOM_QUOTA_REACHED' === e.name) &&
    // acknowledge QuotaExceededError only if there's something already stored
    0 !== storage.length;
  }
}

// Custom no-op implementation of window.Storage.
class NullStorage {
  get length() {
    return 0;
  }
  key() {
    return null;
  }
  getItem() {
    return null;
  }
  setItem() {
    // Empty method body.
  }
  removeItem() {
    // Empty method body.
  }
  clear() {
    // Empty method body.
  }
}
let storageObj;

/**
 * Gets the storage object to use.
 *
 * @since 1.0.0
 *
 * @return {Storage} Either window.sessionStorage, window.localStorage', or a
 *                   no-op implementation if neither is available.
 */
function getStorage() {
  // Only run the logic to determine the storage object once.
  if (!storageObj) {
    if (storageAvailable('sessionStorage')) {
      storageObj = __webpack_require__.g.sessionStorage;
    } else if (storageAvailable('localStorage')) {
      storageObj = __webpack_require__.g.localStorage;
    } else {
      storageObj = new NullStorage();
    }
  }
  return storageObj;
}

/***/ }),

/***/ "./js/util/stringify.js":
/*!******************************!*\
  !*** ./js/util/stringify.js ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringifyObject: () => (/* binding */ stringifyObject)
/* harmony export */ });
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! md5 */ "../node_modules/md5/md5.js");
/* harmony import */ var md5__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(md5__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Stringify function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Transforms an object into a hash string.
 *
 * This function can be used to e.g. generate cache keys, based on the given
 * object. Object properties are sorted, so even if they are provided in
 * different order, the hash will match. The function furthermore supports
 * nested objects.
 *
 * @since 1.7.0
 *
 * @param {Object} obj The object to stringify.
 * @return {string} Hash for the object.
 */
function stringifyObject(obj) {
  return md5__WEBPACK_IMPORTED_MODULE_0___default()(JSON.stringify(sortObjectProperties(obj)));
}
function sortObjectProperties(obj) {
  const orderedData = {};
  Object.keys(obj).sort().forEach(key => {
    let val = obj[key];
    if (val && 'object' === typeof val && !Array.isArray(val)) {
      val = sortObjectProperties(val);
    }
    orderedData[key] = val;
  });
  return orderedData;
}

/***/ }),

/***/ "./js/util/sum-object-list-value.js":
/*!******************************************!*\
  !*** ./js/util/sum-object-list-value.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ sumObjectListValue)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Utility function sumObjectListValue.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Returns the sum of a given fieldName in a list.
 *
 * @since 1.21.0
 *
 * @param {Array}  list      Array of objects or arrays.
 * @param {string} fieldName The path name to the field to be summed.
 * @return {number} The sum of all fields in the list.
 */
function sumObjectListValue(list, fieldName) {
  return (0,lodash__WEBPACK_IMPORTED_MODULE_0__.sumBy)(list, fieldName) || 0;
}

/***/ }),

/***/ "./js/util/tracking/constants.js":
/*!***************************************!*\
  !*** ./js/util/tracking/constants.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATA_LAYER: () => (/* binding */ DATA_LAYER),
/* harmony export */   SCRIPT_IDENTIFIER: () => (/* binding */ SCRIPT_IDENTIFIER)
/* harmony export */ });
/**
 * Constants related to event tracking.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Data layer global used for internal/private Site Kit data.
 *
 * @since 1.8.0
 * @private
 */
const DATA_LAYER = '_googlesitekitDataLayer';

/**
 * The `gtag` `<script>` identifier.
 *
 * @since 1.8.0
 * @private
 */
const SCRIPT_IDENTIFIER = 'data-googlesitekit-gtag';

/***/ }),

/***/ "./js/util/tracking/createDataLayerPush.js":
/*!*************************************************!*\
  !*** ./js/util/tracking/createDataLayerPush.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createDataLayerPush)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked will initialize the dataLayer and push data onto it.
 *
 * @since 1.3.0
 *
 * @param {Object} target Object to enhance with dataLayer data.
 * @return {Function} Function that pushes data onto the dataLayer.
 */
function createDataLayerPush(target) {
  /**
   * Pushes data onto the data layer.
   *
   * Must push an instance of Arguments to the target.
   * Using an ES6 spread operator (i.e. `...args`) will cause tracking events to
   * _silently_ fail.
   *
   * @since 1.0.0
   * @see {@link https://github.com/google/site-kit-wp/issues/1181}
   */
  return function dataLayerPush() {
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] = target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER] || [];
    target[_constants__WEBPACK_IMPORTED_MODULE_0__.DATA_LAYER].push(arguments);
  };
}

/***/ }),

/***/ "./js/util/tracking/createInitializeSnippet.js":
/*!*****************************************************!*\
  !*** ./js/util/tracking/createInitializeSnippet.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createInitializeSnippet)
/* harmony export */ });
/* harmony import */ var _js_features_index__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/js/features/index */ "./js/features/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/util/tracking/constants.js");
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */




/**
 * Returns a function which, when invoked injects the gtag script if necessary.
 *
 * @since 1.44.0
 *
 * @param {Object} config          Tracking configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @return {Function} Function that injects gtag script if it isn't yet present.
 */
function createInitializeSnippet(config, dataLayerTarget) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_2__["default"])(dataLayerTarget);
  let hasInsertedTag;
  const {
    activeModules,
    referenceSiteURL,
    userIDHash,
    userRoles = [],
    isAuthenticated,
    pluginVersion
  } = config;

  /**
   * Injects the necessary script tag if not present.
   *
   * @since 1.118.0
   *
   * @return {boolean|Object} Tag src as scriptTagSrc property.
   */
  return function initializeSnippet() {
    const {
      document
    } = __webpack_require__.g;
    if (undefined === hasInsertedTag) {
      hasInsertedTag = !!document.querySelector(`script[${_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER}]`);
    }
    if (hasInsertedTag) {
      return false;
    }
    hasInsertedTag = true;

    // Sometimes the user roles returned by Site Kit/WordPress is not an
    // array, as expected, so we guard against it here.
    //
    // See: https://github.com/google/site-kit-wp/issues/8266
    const userRolesAsString = userRoles?.length ? userRoles.join(',') : '';

    // We should use the real time, and not the reference date, when
    // measuring when we initialized tracking.
    dataLayerPush('js', new Date()); // eslint-disable-line sitekit/no-direct-date
    dataLayerPush('config', config.trackingID, {
      groups: 'site_kit',
      send_page_view: config.isSiteKitScreen,
      domain: referenceSiteURL,
      plugin_version: pluginVersion || '',
      enabled_features: Array.from(_js_features_index__WEBPACK_IMPORTED_MODULE_0__.enabledFeatures).join(','),
      active_modules: activeModules.join(','),
      authenticated: isAuthenticated ? '1' : '0',
      user_properties: {
        user_roles: userRolesAsString,
        user_identifier: userIDHash
      }
    });

    // If not present, inject it and initialize dataLayer.
    const scriptTag = document.createElement('script');
    scriptTag.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.SCRIPT_IDENTIFIER, '');
    scriptTag.async = true;
    scriptTag.src = `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`;
    document.head.appendChild(scriptTag);
    return {
      scriptTagSrc: `https://www.googletagmanager.com/gtag/js?id=${config.trackingID}&l=${_constants__WEBPACK_IMPORTED_MODULE_1__.DATA_LAYER}`
    };
  };
}

/***/ }),

/***/ "./js/util/tracking/createTrackEvent.js":
/*!**********************************************!*\
  !*** ./js/util/tracking/createTrackEvent.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTrackEvent)
/* harmony export */ });
/* harmony import */ var _createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createDataLayerPush */ "./js/util/tracking/createDataLayerPush.js");
/**
 * Internal dependencies
 */


/**
 * Returns a function which, when invoked tracks a single event.
 *
 * @since 1.3.0
 *
 * @param {Object}   config            Tracking configuration.
 * @param {Object}   dataLayerTarget   Data layer parent object.
 * @param {Function} initializeSnippet Function to initialize tracking.
 * @param {Object}   _global           The global window object.
 * @return {Function} Function that tracks an event.
 */
function createTrackEvent(config, dataLayerTarget, initializeSnippet, _global) {
  const dataLayerPush = (0,_createDataLayerPush__WEBPACK_IMPORTED_MODULE_0__["default"])(dataLayerTarget);

  /**
   * Send an Analytics tracking event.
   *
   * @since 1.3.0
   *
   * @param {string} category The category of the event.
   * @param {string} action   The action name of the event.
   * @param {string} [label]  Optional. The label of the event.
   * @param {number} [value]  Optional. A non-negative integer that will appear as the event value.
   * @return {Promise} Promise that always resolves.
   */
  // eslint-disable-next-line require-await
  return async function trackEvent(category, action, label, value) {
    const {
      trackingEnabled
    } = config;
    if (!trackingEnabled) {
      // Resolve immediately if tracking is disabled.
      return null;
    }
    initializeSnippet();
    const eventData = {
      send_to: 'site_kit',
      event_category: category,
      event_label: label,
      value
    };
    return new Promise(resolve => {
      // This timeout ensures a tracking event does not block the user
      // event if it is not sent (in time).
      // If the event beacon fails, it shouldn't reject the promise since event
      // tracking should not result in user-facing errors. It will just
      // trigger a console warning.
      function failCallback() {
        _global.console.warn(`Tracking event "${action}" (category "${category}") took too long to fire.`);
        resolve();
      }
      const failTimeout = setTimeout(failCallback, 1000);
      // eslint-disable-next-line camelcase
      function event_callback() {
        clearTimeout(failTimeout);
        resolve();
      }
      dataLayerPush('event', action, {
        ...eventData,
        event_callback
      });

      // If the client-side opt-out is present, the event_callback will never be called
      // so we call it here to prevent the warning and added delay.
      if (_global._gaUserPrefs?.ioo?.()) {
        event_callback();
      }
    });
  };
}

/***/ }),

/***/ "./js/util/tracking/createTracking.js":
/*!********************************************!*\
  !*** ./js/util/tracking/createTracking.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createTracking)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "../node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createInitializeSnippet */ "./js/util/tracking/createInitializeSnippet.js");
/* harmony import */ var _createTrackEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createTrackEvent */ "./js/util/tracking/createTrackEvent.js");
/**
 * Site Kit by Google, Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


const DEFAULT_CONFIG = {
  activeModules: [],
  isAuthenticated: false,
  referenceSiteURL: '',
  trackingEnabled: false,
  trackingID: '',
  userIDHash: '',
  userRoles: []
};

/**
 * Initializes tracking.
 *
 * @since 1.3.0
 *
 * @param {Object} newConfig       New configuration.
 * @param {Object} dataLayerTarget Data layer parent object.
 * @param {Object} _global         The global window object.
 * @return {Object} Tracking config.
 */
function createTracking(newConfig, dataLayerTarget = __webpack_require__.g, _global = __webpack_require__.g) {
  const config = {
    ...DEFAULT_CONFIG,
    ...newConfig
  };
  // Remove any trailing slash from the reference URL.
  if (config.referenceSiteURL) {
    config.referenceSiteURL = config.referenceSiteURL.toString().replace(/\/+$/, '');
  }
  const initializeSnippet = (0,_createInitializeSnippet__WEBPACK_IMPORTED_MODULE_1__["default"])(config, dataLayerTarget);
  const trackEvent = (0,_createTrackEvent__WEBPACK_IMPORTED_MODULE_2__["default"])(config, dataLayerTarget, initializeSnippet, _global);
  const onceTrackedEventsMap = {};
  function trackEventOnce(...params) {
    const key = JSON.stringify(params);
    if (!onceTrackedEventsMap[key]) {
      onceTrackedEventsMap[key] = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.once)(trackEvent);
    }
    onceTrackedEventsMap[key](...params);
  }
  return {
    enableTracking: function enableTracking() {
      config.trackingEnabled = true;
    },
    disableTracking: function disableTracking() {
      config.trackingEnabled = false;
    },
    initializeSnippet,
    isTrackingEnabled: function isTrackingEnabled() {
      return !!config.trackingEnabled;
    },
    trackEvent,
    trackEventOnce
  };
}

/***/ }),

/***/ "./js/util/tracking/index.js":
/*!***********************************!*\
  !*** ./js/util/tracking/index.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTracking: () => (/* binding */ disableTracking),
/* harmony export */   enableTracking: () => (/* binding */ enableTracking),
/* harmony export */   isTrackingEnabled: () => (/* binding */ isTrackingEnabled),
/* harmony export */   toggleTracking: () => (/* binding */ toggleTracking),
/* harmony export */   trackEvent: () => (/* binding */ trackEvent),
/* harmony export */   trackEventOnce: () => (/* binding */ trackEventOnce)
/* harmony export */ });
/* harmony import */ var _createTracking__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createTracking */ "./js/util/tracking/createTracking.js");
/**
 * Event tracking utilities.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* eslint-disable sitekit/jsdoc-no-unnamed-boolean-params */

/**
 * Internal dependencies
 */

const {
  activeModules = [],
  isSiteKitScreen,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isAuthenticated,
  userRoles
} = __webpack_require__.g._googlesitekitTrackingData || {};

// Access the plugin version directly without destructuring as Webpack's DefinePlugin
// performs text replacement at build time and doesn't support destructuring patterns.
// See: https://github.com/google/site-kit-wp/issues/11802#issuecomment-3562955579
const pluginVersion = "1.168.0";
const initialConfig = {
  activeModules,
  trackingEnabled,
  trackingID,
  referenceSiteURL,
  userIDHash,
  isSiteKitScreen,
  userRoles,
  isAuthenticated,
  pluginVersion
};
const {
  enableTracking,
  disableTracking,
  isTrackingEnabled,
  initializeSnippet,
  trackEvent,
  trackEventOnce
} = (0,_createTracking__WEBPACK_IMPORTED_MODULE_0__["default"])(initialConfig);

/**
 * Changes the active state of tracking.
 *
 * @since 1.3.0
 *
 * @param {boolean} activeStatus The new state to set.
 */
function toggleTracking(activeStatus) {
  if (!!activeStatus) {
    enableTracking();
  } else {
    disableTracking();
  }
}

// Bootstrap on import if tracking is allowed.
if (isSiteKitScreen && trackingEnabled) {
  initializeSnippet();
}


/***/ }),

/***/ "./js/util/urls.js":
/*!*************************!*\
  !*** ./js/util/urls.js ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFullURL: () => (/* binding */ getFullURL),
/* harmony export */   getURLPath: () => (/* binding */ getURLPath),
/* harmony export */   isHashOnly: () => (/* binding */ isHashOnly),
/* harmony export */   normalizeURL: () => (/* binding */ normalizeURL),
/* harmony export */   shortenURL: () => (/* binding */ shortenURL)
/* harmony export */ });
/* harmony import */ var _wordpress_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/url */ "../node_modules/@wordpress/url/build-module/is-url.js");
/**
 * URL pathname getter utility function.
 *
 * Site Kit by Google, Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the path from a URL, omitting its protocol, hostname, query params, and hash.
 *
 * @since 1.24.0
 *
 * @param {string} url The URL to get the path from.
 * @return {string} The URL path.
 */
function getURLPath(url) {
  try {
    return new URL(url).pathname;
  } catch {}
  return null;
}

/**
 * Returns the absolute URL from a path including the siteURL.
 *
 * @since 1.32.0
 *
 * @param {string} siteURL The siteURL fo the WordPress install.
 * @param {string} path    The path.
 * @return {string} The URL path.
 */
function getFullURL(siteURL, path) {
  try {
    return new URL(path, siteURL).href;
  } catch {}
  return (typeof siteURL === 'string' ? siteURL : '') + (typeof path === 'string' ? path : '');
}

/**
 * Normalizes URL by removing protocol, www subdomain and trailing slash.
 *
 * @since 1.33.0
 *
 * @param {string} incomingURL The original URL.
 * @return {string} Normalized URL.
 */
function normalizeURL(incomingURL) {
  if (typeof incomingURL !== 'string') {
    return incomingURL;
  }
  return incomingURL
  // Remove protocol and optional "www." prefix from the URL.
  .replace(/^https?:\/\/(www\.)?/i, '')
  // Remove trailing slash.
  .replace(/\/$/, '');
}

/**
 * Checks if a string is not a full URL and simply a hash / anchor link.
 *
 * @since 1.49.0
 *
 * @param {string} url The URL or Hash string to test.
 * @return {boolean} Returns true if the string is only a hash and not a full URL.
 */
function isHashOnly(url) {
  return /^#\w[A-Za-z0-9-_]*$/.test(url);
}

/**
 * Shortens a URL to fit a given length.
 *
 * @since 1.49.0
 *
 * @param {string} url      The original URL to shorten.
 * @param {number} maxChars The maximum length of the URL.
 * @return {string} The shortened URL.
 */
function shortenURL(url, maxChars) {
  if (!(0,_wordpress_url__WEBPACK_IMPORTED_MODULE_0__.isURL)(url)) {
    return url;
  }
  if (url.length <= maxChars) {
    return url;
  }
  const urlObject = new URL(url);
  const shortenedURL = url.replace(urlObject.origin, '');
  if (shortenedURL.length < maxChars) {
    return shortenedURL;
  }
  const extraChars = shortenedURL.length - Math.floor(maxChars) + 1; // 1 is the length of "…".
  return '…' + shortenedURL.substr(extraChars);
}

/***/ }),

/***/ "./svg/graphics/banner-error.svg?url":
/*!*******************************************!*\
  !*** ./svg/graphics/banner-error.svg?url ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/banner-warning.svg?url":
/*!*********************************************!*\
  !*** ./svg/graphics/banner-warning.svg?url ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("data:image/svg+xml;base64,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");

/***/ }),

/***/ "./svg/graphics/cta-graph-traffic.svg":
/*!********************************************!*\
  !*** ./svg/graphics/cta-graph-traffic.svg ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path, _path2, _path3, _path4, _path5, _circle, _circle2, _circle3, _circle4, _path6, _path7, _path8, _path9, _defs;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgCtaGraphTraffic = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 116 59"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#DEDEDE",
  d: "M86.66 6.101a22.4 22.4 0 0 1 6.226-1.09l.215 7.871a14.5 14.5 0 0 0-4.046.709z"
})), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#C6C6C6",
  d: "M75.423 14.275a22.54 22.54 0 0 1 10.57-7.945l2.628 7.41a14.66 14.66 0 0 0-6.871 5.164z"
})), _path3 || (_path3 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#F1F1F1",
  d: "M75.317 40.725a22.5 22.5 0 0 1-4.226-12.872 22.64 22.64 0 0 1 3.925-13l6.47 4.426a14.7 14.7 0 0 0-2.552 8.45c.035 3.01.995 5.932 2.747 8.367z"
})), _path4 || (_path4 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#959595",
  d: "M106.601 45.702a22.4 22.4 0 0 1-16.346 4.074 22.28 22.28 0 0 1-14.517-8.485l6.217-4.827a14.48 14.48 0 0 0 9.436 5.515 14.56 14.56 0 0 0 10.625-2.648z"
})), _path5 || (_path5 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#C7C7C7",
  d: "M93.59 5c4.673 0 9.223 1.466 13.013 4.194a22.37 22.37 0 0 1 8.129 11.018 22.624 22.624 0 0 1-7.567 25.067l-4.783-6.223a14.7 14.7 0 0 0 4.919-16.293 14.54 14.54 0 0 0-5.284-7.162 14.48 14.48 0 0 0-8.458-2.726z"
})), _circle || (_circle = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 83.5,
  cy: 56.899,
  r: 1.5,
  fill: "#959595"
})), _circle2 || (_circle2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 90.5,
  cy: 56.899,
  r: 1.5,
  fill: "#C7C7C7"
})), _circle3 || (_circle3 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 97.5,
  cy: 56.899,
  r: 1.5,
  fill: "#DEDEDE"
})), _circle4 || (_circle4 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 104.5,
  cy: 56.899,
  r: 1.5,
  fill: "#F1F1F1"
})), _path6 || (_path6 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#ECE9F1",
  strokeLinecap: "round",
  strokeWidth: 0.937,
  d: "M.468 58.531h55.064"
})), _path7 || (_path7 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "#ECE9F1",
  strokeLinecap: "round",
  strokeWidth: 0.468,
  d: "M.234 44.765h55.532M.234 30.765h55.532M.234 16.766h55.532"
})), _path8 || (_path8 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "url(#cta-graph-traffic_svg__a)",
  d: "M25.531 47.668c-4.138-1.288-5.95-4.746-9.87-5.24-4.053-.51-7.2 12.53-15.661 13.777V59h56V35.07c-2.25-.486-4.367-17.89-9.25-16.601-4.882 1.288-8.475 20.892-12.365 14.578-3.89-6.313-4.716 15.91-8.854 14.622",
  opacity: 0.08
})), _path9 || (_path9 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#B8B8B8",
  d: "M2.766 1.116.883 6.3h-.77L2.281.612h.496zM4.344 6.3 2.457 1.116 2.445.612h.496L5.117 6.3zm-.098-2.106v.618H1.051v-.618zM6.555.3v6h-.727v-6zM8.5.3v6h-.727v-6zm5.73 5.023v-3.25h.727V6.3h-.691zm.137-.89.301-.008q0 .421-.09.781a1.7 1.7 0 0 1-.281.617q-.194.262-.512.41a1.85 1.85 0 0 1-.77.145q-.308 0-.566-.09a1.1 1.1 0 0 1-.437-.277 1.3 1.3 0 0 1-.285-.489 2.4 2.4 0 0 1-.098-.722V2.073h.723v2.735q0 .285.062.472.066.184.176.293.113.105.25.149.14.043.289.043.46 0 .73-.176.27-.18.387-.48.12-.306.121-.676m4.153.746q0-.155-.07-.29-.067-.136-.278-.245-.207-.114-.625-.196a5 5 0 0 1-.637-.176 2 2 0 0 1-.48-.246q-.195-.144-.301-.34a.95.95 0 0 1-.106-.457q0-.25.11-.472.112-.223.316-.395.207-.171.496-.27.29-.097.645-.097.507 0 .867.18t.55.48q.192.297.192.66h-.722a.6.6 0 0 0-.106-.34.8.8 0 0 0-.3-.277 1 1 0 0 0-.481-.11q-.3 0-.488.095a.63.63 0 0 0-.27.23.58.58 0 0 0-.043.508q.043.09.148.168.106.074.297.14t.489.133q.519.117.855.282.336.163.5.402.165.238.164.578 0 .277-.117.508a1.1 1.1 0 0 1-.332.398 1.7 1.7 0 0 1-.516.258q-.297.09-.668.09-.558 0-.945-.2a1.46 1.46 0 0 1-.586-.515q-.2-.316-.2-.668h.727q.016.297.172.473a.9.9 0 0 0 .383.246q.226.07.45.07.296 0 .495-.078a.7.7 0 0 0 .31-.215.5.5 0 0 0 .105-.312m3.425 1.199a2.1 2.1 0 0 1-.8-.149 1.8 1.8 0 0 1-.614-.425q-.254-.274-.39-.649a2.4 2.4 0 0 1-.137-.82v-.164q0-.516.152-.918.153-.405.414-.688.262-.28.594-.425t.688-.145q.453 0 .78.156.333.157.544.438.21.278.312.656.102.375.102.82v.325h-3.156V3.8h2.433v-.055q-.016-.281-.117-.547a1 1 0 0 0-.312-.437q-.216-.172-.586-.172a.98.98 0 0 0-.809.41q-.149.202-.23.496-.082.292-.082.676v.164q0 .301.081.566.087.262.247.461.163.2.394.313.235.113.531.113.384 0 .649-.156.265-.157.465-.418l.437.348q-.137.207-.348.394t-.519.305a2 2 0 0 1-.723.117m3.211-3.64V6.3h-.722V2.073h.703zm1.32-.688-.003.672a1.827 1.827 0 0 0-.352-.031q-.25 0-.441.078a.9.9 0 0 0-.325.218 1 1 0 0 0-.21.336q-.075.192-.098.422l-.203.117q0-.382.074-.718.078-.336.238-.594.16-.262.407-.406a1.14 1.14 0 0 1 .914-.094m3.13 3.129a.6.6 0 0 0-.07-.29q-.068-.136-.278-.245-.207-.114-.625-.196a5 5 0 0 1-.637-.176 2 2 0 0 1-.48-.246q-.195-.144-.301-.34a.95.95 0 0 1-.106-.457q0-.25.11-.472.112-.223.316-.395.207-.171.496-.27.29-.097.645-.097.507 0 .867.18t.55.48q.192.297.192.66h-.723a.6.6 0 0 0-.105-.34.8.8 0 0 0-.3-.277 1 1 0 0 0-.481-.11q-.3 0-.488.095a.63.63 0 0 0-.27.23.58.58 0 0 0-.043.508q.043.09.148.168.106.074.297.14t.489.133q.519.117.855.282.335.163.5.402.164.238.164.578 0 .277-.117.508a1.1 1.1 0 0 1-.332.398 1.7 1.7 0 0 1-.516.258q-.297.09-.668.09-.558 0-.945-.2a1.46 1.46 0 0 1-.586-.515q-.2-.316-.2-.668h.727q.016.297.172.473a.9.9 0 0 0 .383.246q.226.07.45.07.296 0 .495-.078a.7.7 0 0 0 .309-.215.5.5 0 0 0 .105-.312"
})), _defs || (_defs = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("defs", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("linearGradient", {
  id: "cta-graph-traffic_svg__a",
  x1: 19.094,
  x2: 19.094,
  y1: 18.399,
  y2: 66.554,
  gradientUnits: "userSpaceOnUse"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("stop", {
  stopColor: "#4F4F4F"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("stop", {
  offset: 1,
  stopColor: "#4F4F4F",
  stopOpacity: 0
})))));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgCtaGraphTraffic);

/***/ }),

/***/ "./svg/graphics/cta-most-popular-content.svg":
/*!***************************************************!*\
  !*** ./svg/graphics/cta-most-popular-content.svg ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path, _rect, _rect2, _rect3, _rect4, _path2, _rect5, _rect6, _rect7, _rect8;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgCtaMostPopularContent = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 117 70"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#C7C7C7",
  d: "m96.91 4.813 1.34-4.5h1.305L97.575 6h-.86zm-1.234-4.5 1.336 4.5L97.215 6h-.867L94.378.313zm5.527 1.46V6h-1.129V1.773zM100.004.672q0-.246.172-.406a.65.65 0 0 1 .461-.16q.285 0 .457.16a.53.53 0 0 1 .176.406q0 .247-.176.406a.64.64 0 0 1-.457.16.65.65 0 0 1-.461-.16.53.53 0 0 1-.172-.406m4.074 5.406q-.492 0-.883-.156a1.95 1.95 0 0 1-.664-.442 2 2 0 0 1-.414-.652 2.2 2.2 0 0 1-.144-.797v-.156q0-.48.136-.879.138-.399.391-.691.258-.293.625-.45.368-.16.828-.16.45 0 .797.149t.582.422q.239.272.359.656.121.378.121.844v.468h-3.359v-.75h2.254v-.086a1 1 0 0 0-.086-.418.67.67 0 0 0-.25-.296.77.77 0 0 0-.43-.11.7.7 0 0 0-.382.098.76.76 0 0 0-.262.273 1.5 1.5 0 0 0-.149.414 2.7 2.7 0 0 0-.046.516v.156q0 .255.07.469.074.215.207.371a.94.94 0 0 0 .328.242q.195.087.441.086.305 0 .567-.117a1.2 1.2 0 0 0 .457-.363l.547.593a1.7 1.7 0 0 1-.364.368 2 2 0 0 1-.546.289q-.32.11-.731.11m3.582-1.172.879-3.133h.715l-.231 1.23L108.145 6h-.598zm-.445-3.133.629 3.13.058 1.097h-.703l-1.07-4.227zm2.844 3.079.613-3.079h1.09L110.691 6h-.699zm-.707-3.079.875 3.11.121 1.117h-.602l-.879-2.992-.222-1.235zm5.261 3.059a.36.36 0 0 0-.07-.219.6.6 0 0 0-.262-.18 2.6 2.6 0 0 0-.543-.156 4 4 0 0 1-.597-.175 2 2 0 0 1-.477-.262 1.1 1.1 0 0 1-.312-.36 1 1 0 0 1-.114-.48q0-.266.114-.5.117-.234.332-.414.218-.184.531-.285.316-.106.711-.106.55 0 .945.176.399.176.609.484.216.305.215.696h-1.125a.6.6 0 0 0-.07-.293.47.47 0 0 0-.211-.207.75.75 0 0 0-.367-.078.7.7 0 0 0-.324.066.5.5 0 0 0-.211.172.41.41 0 0 0-.032.41q.044.075.137.137.094.061.242.117.153.05.375.094.457.093.817.246.359.148.57.406.211.255.211.668 0 .282-.125.516a1.24 1.24 0 0 1-.359.41 1.8 1.8 0 0 1-.563.27 2.6 2.6 0 0 1-.73.093q-.59 0-1-.21a1.6 1.6 0 0 1-.618-.536 1.25 1.25 0 0 1-.207-.672h1.067a.62.62 0 0 0 .117.371.65.65 0 0 0 .285.203q.176.063.379.063a1 1 0 0 0 .363-.059.5.5 0 0 0 .219-.164.4.4 0 0 0 .078-.242"
})), _rect || (_rect = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 13.3,
  height: 4.2,
  x: 103,
  y: 18.6,
  fill: "#C7C7C7",
  rx: 2.1
})), _rect2 || (_rect2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 9.1,
  height: 4.2,
  x: 107,
  y: 33,
  fill: "#C7C7C7",
  rx: 2.1
})), _rect3 || (_rect3 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 9.1,
  height: 4.2,
  x: 107,
  y: 47,
  fill: "#C7C7C7",
  rx: 2.1
})), _rect4 || (_rect4 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 5.6,
  height: 4.2,
  x: 110,
  y: 61,
  fill: "#C7C7C7",
  rx: 2.1
})), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#C7C7C7",
  d: "M2.848 17.981v5.72h-.723v-4.817l-1.457.531v-.652l2.066-.782zm1.351 19.125v.594H.477v-.52l1.863-2.074q.344-.382.531-.648.192-.27.266-.48a1.3 1.3 0 0 0 .078-.438q0-.281-.117-.508a.9.9 0 0 0-.336-.367 1 1 0 0 0-.54-.137q-.378 0-.632.149a.9.9 0 0 0-.375.406 1.4 1.4 0 0 0-.125.602H.367q0-.48.211-.88.211-.398.625-.632.414-.238 1.02-.238.538 0 .922.191.382.187.585.531.207.34.208.797a1.6 1.6 0 0 1-.086.508q-.083.254-.23.508-.145.254-.34.5a8 8 0 0 1-.41.484l-1.524 1.652zM1.527 48.501h.516q.378 0 .625-.125a.86.86 0 0 0 .371-.348q.125-.222.125-.5 0-.328-.11-.55a.73.73 0 0 0-.327-.336 1.2 1.2 0 0 0-.555-.114q-.304 0-.54.121a.9.9 0 0 0-.362.336 1 1 0 0 0-.13.516H.419q0-.434.219-.79.219-.354.613-.566.399-.21.922-.21.516 0 .902.183.387.18.602.54.215.354.215.886 0 .215-.102.46a1.4 1.4 0 0 1-.309.454q-.207.21-.539.348a2.2 2.2 0 0 1-.796.133h-.618zm0 .594v-.434h.618q.543 0 .898.129.355.128.559.344.207.214.289.472.086.255.086.508 0 .4-.137.707-.133.309-.38.524a1.6 1.6 0 0 1-.57.324q-.327.11-.714.11-.371 0-.7-.106a1.8 1.8 0 0 1-.574-.305 1.4 1.4 0 0 1-.39-.496 1.6 1.6 0 0 1-.14-.676h.722q0 .297.129.52a.9.9 0 0 0 .375.347q.246.122.578.122t.57-.114a.82.82 0 0 0 .371-.351q.133-.235.133-.59t-.148-.582a.87.87 0 0 0-.422-.34 1.6 1.6 0 0 0-.637-.113zm2.79 14.691v.594H.206v-.426l2.547-3.941h.59l-.633 1.14-1.684 2.633zm-.794-3.773V65.7h-.722v-5.687z"
})), _rect5 || (_rect5 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 48.3,
  height: 4.2,
  x: 9.8,
  y: 18.6,
  fill: "#C7C7C7",
  rx: 2.1
})), _rect6 || (_rect6 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 72.8,
  height: 4.2,
  x: 9.8,
  y: 33,
  fill: "#C7C7C7",
  rx: 2.1
})), _rect7 || (_rect7 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 42,
  height: 4.2,
  x: 9.8,
  y: 47,
  fill: "#C7C7C7",
  rx: 2.1
})), _rect8 || (_rect8 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("rect", {
  width: 55.3,
  height: 4.2,
  x: 9.8,
  y: 61,
  fill: "#C7C7C7",
  rx: 2.1
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgCtaMostPopularContent);

/***/ }),

/***/ "./svg/icons/arrow-inverse.svg":
/*!*************************************!*\
  !*** ./svg/icons/arrow-inverse.svg ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrowInverse = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "#FFF"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrowInverse);

/***/ }),

/***/ "./svg/icons/arrow-up.svg":
/*!********************************!*\
  !*** ./svg/icons/arrow-up.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrowUp = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 6 6"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "m0 3.01.443.387 1.755-1.534v3.344h.628V1.863L4.578 3.4l.446-.39L2.512.811z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrowUp);

/***/ }),

/***/ "./svg/icons/arrow.svg":
/*!*****************************!*\
  !*** ./svg/icons/arrow.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _g;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgArrow = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 13 13"
}, props), _g || (_g = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("g", {
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("circle", {
  cx: 6.5,
  cy: 6.5,
  r: 6.5,
  fill: "currentColor"
}), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "#FFF",
  d: "M3.461 6.96h5.15L6.36 9.21a.464.464 0 0 0 .325.79.46.46 0 0 0 .325-.135l3.037-3.038a.46.46 0 0 0 0-.65L7.015 3.135a.46.46 0 0 0-.65.65L8.61 6.039H3.461a.46.46 0 0 0-.461.46c0 .254.207.462.461.462z"
}), ".")));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgArrow);

/***/ }),

/***/ "./svg/icons/back.svg":
/*!****************************!*\
  !*** ./svg/icons/back.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgBack = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "m12 20-8-8 8-8 1.425 1.4-5.6 5.6H20v2H7.825l5.6 5.6z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgBack);

/***/ }),

/***/ "./svg/icons/check-fill.svg":
/*!**********************************!*\
  !*** ./svg/icons/check-fill.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgCheckFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  fillRule: "evenodd",
  d: "M12 1C5.925 1 1 5.925 1 12s4.925 11 11 11 11-4.925 11-11S18.075 1 12 1m4.806 8.592.592-.806-1.612-1.184-.592.806-3.89 5.296c-.166.226-.36.296-.512.296s-.346-.07-.512-.296l-1.474-2.007-.592-.806-1.612 1.184.592.806 1.474 2.007C9.191 15.6 9.971 16 10.792 16s1.6-.4 2.124-1.112z",
  clipRule: "evenodd"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgCheckFill);

/***/ }),

/***/ "./svg/icons/close.svg":
/*!*****************************!*\
  !*** ./svg/icons/close.svg ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgClose = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 14 14"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M14 1.41 12.59 0 7 5.59 1.41 0 0 1.41 5.59 7 0 12.59 1.41 14 7 8.41 12.59 14 14 12.59 8.41 7z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgClose);

/***/ }),

/***/ "./svg/icons/external.svg":
/*!********************************!*\
  !*** ./svg/icons/external.svg ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgExternal = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "M5 21a2 2 0 0 1-1.425-.575A2 2 0 0 1 3 19V5q0-.825.575-1.4Q4.175 3 5 3h7v2H5v14h14v-7h2v7q0 .825-.6 1.425Q19.825 21 19 21zm4.7-5.3-1.4-1.4L17.6 5H14V3h7v7h-2V6.4z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgExternal);

/***/ }),

/***/ "./svg/icons/info-green.svg":
/*!**********************************!*\
  !*** ./svg/icons/info-green.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgInfoGreen = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 16 16"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M7.334 11.333h1.333v-4H7.334zM8.001 6a.658.658 0 0 0 .667-.667.6.6 0 0 0-.2-.467.6.6 0 0 0-.467-.2.66.66 0 0 0-.667.667q0 .284.183.483A.7.7 0 0 0 8.001 6m0 8.666a6.6 6.6 0 0 1-2.6-.516 6.9 6.9 0 0 1-2.117-1.434A6.9 6.9 0 0 1 1.851 10.6 6.6 6.6 0 0 1 1.334 8q0-1.385.517-2.6a6.9 6.9 0 0 1 1.433-2.117q.9-.9 2.117-1.417A6.4 6.4 0 0 1 8 1.333q1.383 0 2.6.533a6.6 6.6 0 0 1 2.116 1.417q.9.9 1.417 2.117.533 1.215.533 2.6 0 1.383-.533 2.6a6.6 6.6 0 0 1-1.417 2.116 6.9 6.9 0 0 1-2.116 1.434 6.6 6.6 0 0 1-2.6.516m0-1.333q2.233 0 3.783-1.55T13.334 8t-1.55-3.784-3.783-1.55-3.784 1.55T2.667 8t1.55 3.783 3.784 1.55"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgInfoGreen);

/***/ }),

/***/ "./svg/icons/star-fill.svg":
/*!*********************************!*\
  !*** ./svg/icons/star-fill.svg ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgStarFill = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "m5.825 22 2.325-7.6L2 10h7.6L12 2l2.4 8H22l-6.15 4.4 2.325 7.6L12 17.3z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgStarFill);

/***/ }),

/***/ "./svg/icons/tick.svg":
/*!****************************!*\
  !*** ./svg/icons/tick.svg ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgTick = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 11 9"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  stroke: "currentColor",
  strokeWidth: 1.5,
  d: "M1 3.838 4.106 7 10 1"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgTick);

/***/ }),

/***/ "./svg/icons/warning-notice.svg":
/*!**************************************!*\
  !*** ./svg/icons/warning-notice.svg ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningNotice = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "none",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1m0 14a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3m-1-2h2V6h-2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningNotice);

/***/ }),

/***/ "./svg/icons/warning-v2.svg":
/*!**********************************!*\
  !*** ./svg/icons/warning-v2.svg ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarningV2 = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 22 19"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "currentColor",
  d: "M0 19h22L11 0zm12-3h-2v-2h2zm0-4h-2V8h2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarningV2);

/***/ }),

/***/ "./svg/icons/warning.svg":
/*!*******************************!*\
  !*** ./svg/icons/warning.svg ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "../node_modules/react/index.js");
var _path, _path2;
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }

const SvgWarning = props => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", _extends({
  xmlns: "http://www.w3.org/2000/svg",
  fill: "currentColor",
  "aria-labelledby": "warning-title warning-desc",
  viewBox: "0 0 24 24"
}, props), _path || (_path = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  fill: "none",
  d: "M0 0h24v24H0z"
})), _path2 || (_path2 = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", {
  d: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2m1 15h-2v-2h2zm0-4h-2V7h2z"
})));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SvgWarning);

/***/ }),

/***/ "@wordpress/i18n":
/*!*****************************************!*\
  !*** external ["googlesitekit","i18n"] ***!
  \*****************************************/
/***/ ((module) => {

"use strict";
module.exports = googlesitekit.i18n;

/***/ }),

/***/ "googlesitekit-api":
/*!****************************************!*\
  !*** external ["googlesitekit","api"] ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = googlesitekit.api;

/***/ }),

/***/ "googlesitekit-components":
/*!***********************************************!*\
  !*** external ["googlesitekit","components"] ***!
  \***********************************************/
/***/ ((module) => {

"use strict";
module.exports = googlesitekit.components;

/***/ }),

/***/ "googlesitekit-data":
/*!*****************************************!*\
  !*** external ["googlesitekit","data"] ***!
  \*****************************************/
/***/ ((module) => {

"use strict";
module.exports = googlesitekit.data;

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["googlesitekit-vendor"], () => (__webpack_exec__("./js/googlesitekit-wp-dashboard.js")));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=googlesitekit-wp-dashboard.js.map