<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource;

use Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaConversionEvent;
use Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaListConversionEventsResponse;
use Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleProtobufEmpty;
/**
 * The "conversionEvents" collection of methods.
 * Typical usage is:
 *  <code>
 *   $analyticsadminService = new Google\Service\GoogleAnalyticsAdminV1alpha(...);
 *   $conversionEvents = $analyticsadminService->properties_conversionEvents;
 *  </code>
 */
class PropertiesConversionEvents extends \Google\Site_Kit_Dependencies\Google\Service\Resource
{
    /**
     * Deprecated: Use `CreateKeyEvent` instead. Creates a conversion event with the
     * specified attributes. (conversionEvents.create)
     *
     * @param string $parent Required. The resource name of the parent property
     * where this conversion event will be created. Format: properties/123
     * @param GoogleAnalyticsAdminV1alphaConversionEvent $postBody
     * @param array $optParams Optional parameters.
     * @return GoogleAnalyticsAdminV1alphaConversionEvent
     * @throws \Google\Service\Exception
     */
    public function create($parent, \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaConversionEvent $postBody, $optParams = [])
    {
        $params = ['parent' => $parent, 'postBody' => $postBody];
        $params = \array_merge($params, $optParams);
        return $this->call('create', [$params], \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaConversionEvent::class);
    }
    /**
     * Deprecated: Use `DeleteKeyEvent` instead. Deletes a conversion event in a
     * property. (conversionEvents.delete)
     *
     * @param string $name Required. The resource name of the conversion event to
     * delete. Format: properties/{property}/conversionEvents/{conversion_event}
     * Example: "properties/123/conversionEvents/456"
     * @param array $optParams Optional parameters.
     * @return GoogleProtobufEmpty
     * @throws \Google\Service\Exception
     */
    public function delete($name, $optParams = [])
    {
        $params = ['name' => $name];
        $params = \array_merge($params, $optParams);
        return $this->call('delete', [$params], \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleProtobufEmpty::class);
    }
    /**
     * Deprecated: Use `GetKeyEvent` instead. Retrieve a single conversion event.
     * (conversionEvents.get)
     *
     * @param string $name Required. The resource name of the conversion event to
     * retrieve. Format: properties/{property}/conversionEvents/{conversion_event}
     * Example: "properties/123/conversionEvents/456"
     * @param array $optParams Optional parameters.
     * @return GoogleAnalyticsAdminV1alphaConversionEvent
     * @throws \Google\Service\Exception
     */
    public function get($name, $optParams = [])
    {
        $params = ['name' => $name];
        $params = \array_merge($params, $optParams);
        return $this->call('get', [$params], \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaConversionEvent::class);
    }
    /**
     * Deprecated: Use `ListKeyEvents` instead. Returns a list of conversion events
     * in the specified parent property. Returns an empty list if no conversion
     * events are found. (conversionEvents.listPropertiesConversionEvents)
     *
     * @param string $parent Required. The resource name of the parent property.
     * Example: 'properties/123'
     * @param array $optParams Optional parameters.
     *
     * @opt_param int pageSize The maximum number of resources to return. If
     * unspecified, at most 50 resources will be returned. The maximum value is 200;
     * (higher values will be coerced to the maximum)
     * @opt_param string pageToken A page token, received from a previous
     * `ListConversionEvents` call. Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to `ListConversionEvents` must
     * match the call that provided the page token.
     * @return GoogleAnalyticsAdminV1alphaListConversionEventsResponse
     * @throws \Google\Service\Exception
     */
    public function listPropertiesConversionEvents($parent, $optParams = [])
    {
        $params = ['parent' => $parent];
        $params = \array_merge($params, $optParams);
        return $this->call('list', [$params], \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaListConversionEventsResponse::class);
    }
    /**
     * Deprecated: Use `UpdateKeyEvent` instead. Updates a conversion event with the
     * specified attributes. (conversionEvents.patch)
     *
     * @param string $name Output only. Resource name of this conversion event.
     * Format: properties/{property}/conversionEvents/{conversion_event}
     * @param GoogleAnalyticsAdminV1alphaConversionEvent $postBody
     * @param array $optParams Optional parameters.
     *
     * @opt_param string updateMask Required. The list of fields to be updated.
     * Field names must be in snake case (e.g., "field_to_update"). Omitted fields
     * will not be updated. To replace the entire entity, use one path with the
     * string "*" to match all fields.
     * @return GoogleAnalyticsAdminV1alphaConversionEvent
     * @throws \Google\Service\Exception
     */
    public function patch($name, \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaConversionEvent $postBody, $optParams = [])
    {
        $params = ['name' => $name, 'postBody' => $postBody];
        $params = \array_merge($params, $optParams);
        return $this->call('patch', [$params], \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaConversionEvent::class);
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesConversionEvents::class, 'Google\\Site_Kit_Dependencies\\Google_Service_GoogleAnalyticsAdminV1alpha_Resource_PropertiesConversionEvents');
