<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\TagManager;

class SetupTag extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * If true, fire the main tag if and only if the setup tag fires successfully.
     * If false, fire the main tag regardless of setup tag firing status.
     *
     * @var bool
     */
    public $stopOnSetupFailure;
    /**
     * The name of the setup tag.
     *
     * @var string
     */
    public $tagName;
    /**
     * If true, fire the main tag if and only if the setup tag fires successfully.
     * If false, fire the main tag regardless of setup tag firing status.
     *
     * @param bool $stopOnSetupFailure
     */
    public function setStopOnSetupFailure($stopOnSetupFailure)
    {
        $this->stopOnSetupFailure = $stopOnSetupFailure;
    }
    /**
     * @return bool
     */
    public function getStopOnSetupFailure()
    {
        return $this->stopOnSetupFailure;
    }
    /**
     * The name of the setup tag.
     *
     * @param string $tagName
     */
    public function setTagName($tagName)
    {
        $this->tagName = $tagName;
    }
    /**
     * @return string
     */
    public function getTagName()
    {
        return $this->tagName;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\TagManager\SetupTag::class, 'Google\\Site_Kit_Dependencies\\Google_Service_TagManager_SetupTag');
