<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\Adsense;

class ListAdUnitsResponse extends \Google\Site_Kit_Dependencies\Google\Collection
{
    protected $collection_key = 'adUnits';
    protected $adUnitsType = \Google\Site_Kit_Dependencies\Google\Service\Adsense\AdUnit::class;
    protected $adUnitsDataType = 'array';
    /**
     * Continuation token used to page through ad units. To retrieve the next page
     * of the results, set the next request's "page_token" value to this.
     *
     * @var string
     */
    public $nextPageToken;
    /**
     * The ad units returned in the list response.
     *
     * @param AdUnit[] $adUnits
     */
    public function setAdUnits($adUnits)
    {
        $this->adUnits = $adUnits;
    }
    /**
     * @return AdUnit[]
     */
    public function getAdUnits()
    {
        return $this->adUnits;
    }
    /**
     * Continuation token used to page through ad units. To retrieve the next page
     * of the results, set the next request's "page_token" value to this.
     *
     * @param string $nextPageToken
     */
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    /**
     * @return string
     */
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\Adsense\ListAdUnitsResponse::class, 'Google\\Site_Kit_Dependencies\\Google_Service_Adsense_ListAdUnitsResponse');
