<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\TagManager;

class AccountAccess extends \Google\Site_Kit_Dependencies\Google\Model
{
    public const PERMISSION_accountPermissionUnspecified = 'accountPermissionUnspecified';
    public const PERMISSION_noAccess = 'noAccess';
    public const PERMISSION_user = 'user';
    public const PERMISSION_admin = 'admin';
    /**
     * Whether the user has no access, user access, or admin access to an account.
     *
     * @var string
     */
    public $permission;
    /**
     * Whether the user has no access, user access, or admin access to an account.
     *
     * Accepted values: accountPermissionUnspecified, noAccess, user, admin
     *
     * @param self::PERMISSION_* $permission
     */
    public function setPermission($permission)
    {
        $this->permission = $permission;
    }
    /**
     * @return self::PERMISSION_*
     */
    public function getPermission()
    {
        return $this->permission;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\TagManager\AccountAccess::class, 'Google\\Site_Kit_Dependencies\\Google_Service_TagManager_AccountAccess');
