/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	// The require scope
/******/ 	var __webpack_require__ = {};
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
/*!******************************************************!*\
  !*** ./js/event-providers/easy-digital-downloads.js ***!
  \******************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseCartItemHTML: () => (/* binding */ parseCartItemHTML)
/* harmony export */ });
/**
 * Site Kit by Google, Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(jQuery => {
  // eslint-disable-next-line no-undef
  if (!jQuery) {
    return;
  }
  const body = jQuery('body');
  body.on('edd_cart_item_added', (event, details) => {
    const {
      name,
      value
    } = parseCartItemHTML(details.cart_item);
    const currency = __webpack_require__.g._googlesitekit.easyDigitalDownloadsCurrency;
    __webpack_require__.g._googlesitekit?.gtagEvent?.('add_to_cart', {
      currency,
      value,
      items: [{
        item_name: name,
        price: value
      }]
    });
  });
  if (__webpack_require__.g._googlesitekit?.gtagUserData && __webpack_require__.g._googlesitekit?.edddata?.purchase?.user_data) {
    __webpack_require__.g._googlesitekit?.gtagEvent?.('purchase', {
      user_data: __webpack_require__.g._googlesitekit.edddata.purchase.user_data
    });
  }
})(__webpack_require__.g.jQuery);

/**
 * Parses the provided cart item HTML to extract product details.
 *
 * @since 1.153.0
 *
 * @param {string} cartItemHTML The HTML string for the cart item.
 * @return {Object} `title` and `value` keys.
 */
function parseCartItemHTML(cartItemHTML) {
  const parser = new DOMParser();
  const doc = parser.parseFromString(cartItemHTML, 'text/html');
  const name = doc.querySelector('.edd-cart-item-title')?.textContent.trim() || '';
  const price = doc.querySelector('.edd-cart-item-price')?.textContent.trim() || '';
  let normalizedNumericPrice = price.replace(/[^\d.,]/g, '').trim();
  const lastComma = normalizedNumericPrice.lastIndexOf(',');
  const lastDot = normalizedNumericPrice.lastIndexOf('.');
  if (lastComma > -1 && lastDot > -1) {
    // If both comma and dot are present and the last comma is after the last dot,
    // we assume the last comma is the decimal separator - and we remove dots and replace comma with dot.
    // Otherwise, we assume the last dot is the decimal separator and we remove commas.
    if (lastComma > lastDot) {
      normalizedNumericPrice = normalizedNumericPrice.replace(/\./g, '').replace(',', '.');
    } else {
      normalizedNumericPrice = normalizedNumericPrice.replace(/,/g, '');
    }
  } else if (lastComma > -1) {
    const commaDistanceFromEnd = normalizedNumericPrice.length - lastComma;
    // Assume comma is decimal separator if exactly 2 decimal digits follow.
    // Otherwise, remove comma.
    if (commaDistanceFromEnd === 3) {
      normalizedNumericPrice = normalizedNumericPrice.replace(',', '.');
    } else {
      normalizedNumericPrice = normalizedNumericPrice.replace(/,/g, '');
    }
  } else if (lastDot > -1) {
    const dotDistanceFromEnd = normalizedNumericPrice.length - lastDot;
    if (dotDistanceFromEnd !== 3) {
      normalizedNumericPrice = normalizedNumericPrice.replace(/\./g, '');
    }
  }
  const value = parseFloat(normalizedNumericPrice) || 0;
  return {
    name,
    value
  };
}
/******/ })()
;
//# sourceMappingURL=googlesitekit-events-provider-easy-digital-downloads.js.map