// -----JS CODE-----
//@input Component.Camera uiCam
//@input Asset.Material backgroundMat

var DestructionHelper = require("./Destruction Helper Module");

var helper = new DestructionHelper(script);

function createObj(parent) {
    var obj = helper.createSceneObject(parent);
    obj.layer = script.uiCam.renderLayer;
    helper.createComponent(obj, "Component.ScreenTransform");
    return obj;
}

var UIButton = requireType("./UI Button");
var VerticalLayout = requireType("./Vertical Layout");
var LayoutElement = requireType("Layout Element");

var regionObj = createObj(script.uiCam.getSceneObject());

var region = helper.createComponent(regionObj, "Component.ScreenRegionComponent");
region.region = ScreenRegionType.SafeRender;

var backgroundObj = createObj(regionObj);
backgroundObj.getComponent("Component.ScreenTransform").anchors = Rect.create(-0.8, 0.8, -0.9, 0.9)
var background = helper.createComponent(backgroundObj, "Component.Image");
background.mainMaterial = script.backgroundMat;
background.setRenderOrder(-1);
background.stretchMode = StretchMode.Stretch;

var extentsTargetObj = createObj(backgroundObj);
background.extentsTarget = extentsTargetObj.getComponent("Component.ScreenTransform");

var layoutObj = createObj(extentsTargetObj);
var layout = helper.createComponent(layoutObj, VerticalLayout);
layout.alignment = 1;

function createSpacer() {
    var obj = createObj(layoutObj);
    var element = helper.createComponent(obj, LayoutElement);
    element.requestedSized = new vec2(0, 0);
    element.minimumSize = new vec2(0, 0);
    element.maximumSize = new vec2(0, 0);
    element.growWeight = 1;
}

function createButton(text, onClick) {
    var obj = createObj(layoutObj);
    var element = helper.createComponent(obj, LayoutElement);
    //Only requested size matters since grow/shrink weights are 0
    element.requestedSize = new vec2(240, 80);
    element.growWeight = 0;
    element.shrinkWeight = 0;
    element.margins = Rect.create(0, 0, 8, 8);
    var button = helper.createComponent(obj, UIButton);
    button.changeAnimationType("Squish");
    button.changeStateValue("normal", "Color", new vec4(1, 1, 0, 1));
    button.changeStateValue("pressed", "Color", new vec4(0.5, 0.5, 0.2, 1));
    var buttonText = button.getTextComponent()
    buttonText.text = text;
    buttonText.font = null;
    buttonText.size = 40;
    buttonText.horizontalOverflow = HorizontalOverflow.Shrink;
    button.onPress.add(onClick);
    return button;
}

createSpacer();

createButton("Option One", function() {
    print("Option One clicked");
});

createButton("Option Two", function() {
    print("Option Two clicked");
});

createButton("Option Three", function() {
    print("Option Three clicked");
});

createSpacer();