/**
 * @module Lens Scripting
 * @version 5.1.0 (Internal)
 * For Snapchat Version: 13.4 (Internal)
*/
interface ComponentNameMap {
    "Animation": Animation;
    "AnimationMixer": AnimationMixer;
    "AnimationPlayer": AnimationPlayer;
    "AudioChainComponent": AudioEffectComponent;
    "AudioComponent": AudioComponent;
    "AudioEffectComponent": AudioEffectComponent;
    "AudioListenerComponent": AudioListenerComponent;
    "AudioPlayer": AudioComponent;
    "AudioTriggerComponent": AudioTriggerComponent;
    "BaseMeshVisual": BaseMeshVisual;
    "BillboardVisual": BillboardVisual;
    "BlendShapes": BlendShapes;
    "BlurNoiseEstimation": BlurNoiseEstimation;
    "Camera": Camera;
    "Canvas": Canvas;
    "ClearDepth": ClearDepth;
    "ClearScreen": ClearDepth;
    "ClientInterfaceComponent": ClientInterfaceComponent;
    "ClothVisual": ClothVisual;
    "ColliderComponent": ColliderComponent;
    "ColocatedTrackingComponent": ColocatedTrackingComponent;
    "Component.Animation": Animation;
    "Component.AnimationMixer": AnimationMixer;
    "Component.AnimationPlayer": AnimationPlayer;
    "Component.AudioChainComponent": AudioEffectComponent;
    "Component.AudioComponent": AudioComponent;
    "Component.AudioEffectComponent": AudioEffectComponent;
    "Component.AudioListenerComponent": AudioListenerComponent;
    "Component.AudioPlayer": AudioComponent;
    "Component.AudioTriggerComponent": AudioTriggerComponent;
    "Component.BaseMeshVisual": BaseMeshVisual;
    "Component.BillboardVisual": BillboardVisual;
    "Component.BlendShapes": BlendShapes;
    "Component.BlurNoiseEstimation": BlurNoiseEstimation;
    "Component.Camera": Camera;
    "Component.Canvas": Canvas;
    "Component.ClearDepth": ClearDepth;
    "Component.ClearScreen": ClearDepth;
    "Component.ClientInterfaceComponent": ClientInterfaceComponent;
    "Component.ClothVisual": ClothVisual;
    "Component.ColliderComponent": ColliderComponent;
    "Component.ColocatedTrackingComponent": ColocatedTrackingComponent;
    "Component.Data": DataComponent;
    "Component.DataComponent": DataComponent;
    "Component.DataStoreComponent": DataStoreComponent;
    "Component.DepthSetter": DepthSetter;
    "Component.DeviceLocationTrackingComponent": DeviceLocationTrackingComponent;
    "Component.DeviceTracking": DeviceTracking;
    "Component.ExternalRendererComponent": ExternalRendererComponent;
    "Component.Eye": Eye;
    "Component.EyeColorVisual": EyeColorVisual;
    "Component.FaceInsetVisual": FaceInsetVisual;
    "Component.FaceMaskVisual": FaceMaskVisual;
    "Component.FaceStretchVisual": FaceStretchVisual;
    "Component.FaceSubVisual": FaceMaskVisual;
    "Component.GaussianSplattingVisual": GaussianSplattingVisual;
    "Component.Gyroscope": Gyroscope;
    "Component.HairSimulationColliderComponent": ColliderComponent;
    "Component.HairVisual": HairVisual;
    "Component.Head": Head;
    "Component.Hints": HintsComponent;
    "Component.HintsComponent": HintsComponent;
    "Component.Image": Image;
    "Component.Inpainting": Inpainting;
    "Component.InteractionComponent": InteractionComponent;
    "Component.Label": Label;
    "Component.LightSource": LightSource;
    "Component.LiquifyVisual": LiquifyVisual;
    "Component.LocatedAtComponent": LocatedAtComponent;
    "Component.LookAtComponent": LookAtComponent;
    "Component.MLComponent": MLComponent;
    "Component.ManipulateComponent": ManipulateComponent;
    "Component.MarkerTrackingComponent": MarkerTrackingComponent;
    "Component.MaskingComponent": MaskingComponent;
    "Component.MaterialMeshVisual": MaterialMeshVisual;
    "Component.MeshVisual": RenderMeshVisual;
    "Component.ObjectTracker2D": ObjectTracking;
    "Component.ObjectTracking": ObjectTracking;
    "Component.ObjectTracking3D": ObjectTracking3D;
    "Component.ParticlesVisual": ParticlesVisual;
    "Component.PinToMeshComponent": PinToMeshComponent;
    "Component.PostEffectVisual": PostEffectVisual;
    "Component.PrefabInstantiator": PrefabInstantiator;
    "Component.RectangleSetter": RectangleSetter;
    "Component.RenderMeshVisual": RenderMeshVisual;
    "Component.Restriction": RestrictionComponent;
    "Component.RestrictionComponent": RestrictionComponent;
    "Component.RetouchVisual": RetouchVisual;
    "Component.Rotator": Rotator;
    "Component.ScreenRegionComponent": ScreenRegionComponent;
    "Component.ScreenTransform": ScreenTransform;
    "Component.Script": ScriptComponent;
    "Component.ScriptComponent": ScriptComponent;
    "Component.Skin": Skin;
    "Component.Snap3D": Snap3D;
    "Component.SplineComponent": SplineComponent;
    "Component.SpriteAligner": SpriteAligner;
    "Component.SpriteVisual": SpriteVisual;
    "Component.SpriteVisualV2": Image;
    "Component.StreamPlayerComponent": StreamPlayerComponent;
    "Component.Surface": Surface;
    "Component.Text": Text;
    "Component.Text3D": Text3D;
    "Component.TextVisual": Label;
    "Component.Touch": InteractionComponent;
    "Component.TouchComponent": InteractionComponent;
    "Component.TrackedPointComponent": TrackedPointComponent;
    "Component.VFXComponent": VFXComponent;
    "Component.VertexCache": VertexCache;
    "Component.VideoRecorderComponent": VideoRecorderComponent;
    "Component.Visual": Visual;
    "Component.WorldTracking": DeviceTracking;
    "Data": DataComponent;
    "DataComponent": DataComponent;
    "DataStoreComponent": DataStoreComponent;
    "DepthSetter": DepthSetter;
    "DeviceLocationTrackingComponent": DeviceLocationTrackingComponent;
    "DeviceTracking": DeviceTracking;
    "ExternalRendererComponent": ExternalRendererComponent;
    "Eye": Eye;
    "EyeColorVisual": EyeColorVisual;
    "FaceInsetVisual": FaceInsetVisual;
    "FaceMaskVisual": FaceMaskVisual;
    "FaceStretchVisual": FaceStretchVisual;
    "FaceSubVisual": FaceMaskVisual;
    "GaussianSplattingVisual": GaussianSplattingVisual;
    "Gyroscope": Gyroscope;
    "HairSimulationColliderComponent": ColliderComponent;
    "HairVisual": HairVisual;
    "Head": Head;
    "Hints": HintsComponent;
    "HintsComponent": HintsComponent;
    "Image": Image;
    "Inpainting": Inpainting;
    "InteractionComponent": InteractionComponent;
    "Label": Label;
    "LightSource": LightSource;
    "LiquifyVisual": LiquifyVisual;
    "LocatedAtComponent": LocatedAtComponent;
    "LookAtComponent": LookAtComponent;
    "MLComponent": MLComponent;
    "ManipulateComponent": ManipulateComponent;
    "MarkerTrackingComponent": MarkerTrackingComponent;
    "MaskingComponent": MaskingComponent;
    "MaterialMeshVisual": MaterialMeshVisual;
    "MeshVisual": RenderMeshVisual;
    "ObjectTracker2D": ObjectTracking;
    "ObjectTracking": ObjectTracking;
    "ObjectTracking3D": ObjectTracking3D;
    "ParticlesVisual": ParticlesVisual;
    "Physics.BodyComponent": BodyComponent;
    "Physics.ColliderComponent": ColliderComponent;
    "Physics.ConstraintComponent": ConstraintComponent;
    "Physics.WorldComponent": WorldComponent;
    "PinToMeshComponent": PinToMeshComponent;
    "PostEffectVisual": PostEffectVisual;
    "PrefabInstantiator": PrefabInstantiator;
    "RectangleSetter": RectangleSetter;
    "RenderMeshVisual": RenderMeshVisual;
    "Restriction": RestrictionComponent;
    "RestrictionComponent": RestrictionComponent;
    "RetouchVisual": RetouchVisual;
    "Rotator": Rotator;
    "ScreenRegionComponent": ScreenRegionComponent;
    "ScreenTransform": ScreenTransform;
    "Script": ScriptComponent;
    "ScriptComponent": ScriptComponent;
    "Skin": Skin;
    "Snap3D": Snap3D;
    "SplineComponent": SplineComponent;
    "SpriteAligner": SpriteAligner;
    "SpriteVisual": SpriteVisual;
    "SpriteVisualV2": Image;
    "StreamPlayerComponent": StreamPlayerComponent;
    "Surface": Surface;
    "Text": Text;
    "Text3D": Text3D;
    "TextVisual": Label;
    "Touch": InteractionComponent;
    "TouchComponent": InteractionComponent;
    "TrackedPointComponent": TrackedPointComponent;
    "VFXComponent": VFXComponent;
    "VertexCache": VertexCache;
    "VideoRecorderComponent": VideoRecorderComponent;
    "Visual": Visual;
    "WorldTracking": DeviceTracking;
}

interface EventNameMap {
    "BrowsLoweredEvent": BrowsLoweredEvent;
    "BrowsRaisedEvent": BrowsRaisedEvent;
    "BrowsReturnedToNormalEvent": BrowsReturnedToNormalEvent;
    "CameraBackEvent": CameraBackEvent;
    "CameraFrontEvent": CameraFrontEvent;
    "CandideUpdatedEvent": CandideUpdatedEvent;
    "ClientInterfaceActionTakenEvent": ClientInterfaceActionTakenEvent;
    "ClientInterfacePlayButtonTriggerEvent": ConnectedLensEnteredEvent;
    "ComponentDisabledEvent": ComponentDisabledEvent;
    "ComponentEnabledEvent": ComponentEnabledEvent;
    "ComponentEvent": ComponentEvent;
    "ConnectedLensEnteredEvent": ConnectedLensEnteredEvent;
    "CustomClientUIActionEvent": CustomClientUIActionEvent;
    "DelayedCallbackEvent": DelayedCallbackEvent;
    "DoubleTapEvent": DoubleTapEvent;
    "ExternalEvent": ExternalEvent;
    "FaceFoundEvent": FaceFoundEvent;
    "FaceLostEvent": FaceLostEvent;
    "FaceTrackingEvent": FaceTrackingEvent;
    "HoverEndEvent": HoverEndEvent;
    "HoverEvent": HoverEvent;
    "HoverStartEvent": HoverStartEvent;
    "KissFinishedEvent": KissFinishedEvent;
    "KissStartedEvent": KissStartedEvent;
    "LateUpdateEvent": LateUpdateEvent;
    "LongPressEndEvent": LongPressEndEvent;
    "LongPressStartEvent": LongPressStartEvent;
    "ManipulateEndEvent": ManipulateEndEvent;
    "ManipulateStartEvent": ManipulateStartEvent;
    "MouthClosedEvent": MouthClosedEvent;
    "MouthOpenedEvent": MouthOpenedEvent;
    "ObjectTrackingEndEvent": ObjectTrackingEndEvent;
    "ObjectTrackingEvent": ObjectTrackingEvent;
    "ObjectTrackingStartEvent": ObjectTrackingStartEvent;
    "OnAwakeEvent": OnAwakeEvent;
    "OnDestroyEvent": OnDestroyEvent;
    "OnDisableEvent": OnDisableEvent;
    "OnEnableEvent": OnEnableEvent;
    "OnLoopStartedEvent": OnTimeStartEvent;
    "OnPauseEvent": OnPauseEvent;
    "OnResumeEvent": OnResumeEvent;
    "OnStartEvent": OnStartEvent;
    "OnTimeStartEvent": OnTimeStartEvent;
    "PanGestureEndEvent": PanGestureEndEvent;
    "PanGestureMoveEvent": PanGestureMoveEvent;
    "PanGestureStartEvent": PanGestureStartEvent;
    "PinchGestureEndEvent": PinchGestureEndEvent;
    "PinchGestureMoveEvent": PinchGestureMoveEvent;
    "PinchGestureStartEvent": PinchGestureStartEvent;
    "SceneEvent.BrowsWereJustFrownedEvent": BrowsLoweredEvent;
    "SceneEvent.BrowsWereJustRaisedEvent": BrowsRaisedEvent;
    "SceneEvent.BrowsWereJustReturnedToNormalEvent": BrowsReturnedToNormalEvent;
    "SceneEvent.ClientInterfacePlayButtonTriggerEvent": ConnectedLensEnteredEvent;
    "SceneEvent.KissJustFinishedEvent": KissFinishedEvent;
    "SceneEvent.KissJustStartedEvent": KissStartedEvent;
    "SceneEvent.MouthWasJustClosedEvent": MouthClosedEvent;
    "SceneEvent.MouthWasJustOpenedEvent": MouthOpenedEvent;
    "SceneEvent.OnLoopStartedEvent": OnTimeStartEvent;
    "SceneEvent.SmileJustFinishedEvent": SmileFinishedEvent;
    "SceneEvent.SmileJustStartedEvent": SmileStartedEvent;
    "SceneEvent.SnappableSessionReadyEvent": SnappablesSessionReadyEvent;
    "SceneEvent.SurfaceTrackingResetEvent": SurfaceTrackingResetEvent;
    "SceneObjectEvent": SceneObjectEvent;
    "SinglePlaneTrackingUpdatedEvent": SinglePlaneTrackingUpdatedEvent;
    "SmileFinishedEvent": SmileFinishedEvent;
    "SmileStartedEvent": SmileStartedEvent;
    "SnapImageCaptureEvent": SnapImageCaptureEvent;
    "SnapRecordStartEvent": SnapRecordStartEvent;
    "SnapRecordStopEvent": SnapRecordStopEvent;
    "SnapcodeFoundEvent": SnapcodeFoundEvent;
    "SnappableSessionReadyEvent": SnappablesSessionReadyEvent;
    "SnappablesSessionInitFailedEvent": SnappablesSessionInitFailedEvent;
    "SnappablesSessionReadyEvent": SnappablesSessionReadyEvent;
    "SpatialMapLoadEvent": SpatialMapLoadEvent;
    "SpatialMapRelocalizationEvent": SpatialMapRelocalizationEvent;
    "SpatialMapSaveEvent": SpatialMapSaveEvent;
    "TapEvent": TapEvent;
    "TouchEndEvent": TouchEndEvent;
    "TouchMoveEvent": TouchMoveEvent;
    "TouchStartEvent": TouchStartEvent;
    "TriggerPrimaryEvent": TriggerPrimaryEvent;
    "TurnOffEvent": TurnOffEvent;
    "TurnOnEvent": TurnOnEvent;
    "UpdateEvent": UpdateEvent;
    "WorldTrackingMeshesAddedEvent": WorldTrackingMeshesAddedEvent;
    "WorldTrackingMeshesRemovedEvent": WorldTrackingMeshesRemovedEvent;
    "WorldTrackingMeshesUpdatedEvent": WorldTrackingMeshesUpdatedEvent;
    "WorldTrackingModeChangedEvent": WorldTrackingModeChangedEvent;
    "WorldTrackingPlanesAddedEvent": WorldTrackingPlanesAddedEvent;
    "WorldTrackingPlanesRemovedEvent": WorldTrackingPlanesRemovedEvent;
    "WorldTrackingPlanesUpdatedEvent": WorldTrackingPlanesUpdatedEvent;
    "WorldTrackingResetEvent": SurfaceTrackingResetEvent;
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/Globals-description.md Edit}
*/
/**
* Start a high resolution timer to measure real-world time elapsed. Call the function `endMeasure` with the same `name` argument to mark the end of the measurement period. Calling this function again with the same name before calling `endMeasure` will reset the start of the timer. Multiple measurements can overlap by using different timer names.


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-beginMeasure.md Edit}

* @private
*/
declare function beginMeasure(name: string): void

/**
* Returns the determinant of `arg1`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-determinantMat3.md Edit}

* @deprecated

* @private
*/
declare function determinantMat3(arg1: mat3): number

/**
* Returns the determinant of `arg1`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-determinantMat4.md Edit}

* @deprecated

* @private
*/
declare function determinantMat4(arg1: mat4): number

/**
* Stop a named timer that was previously started with `beginMeasure` and returns the duration in milliseconds.


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-endMeasure.md Edit}

* @private
*/
declare function endMeasure(name: string): number

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-endProfilingScope.md Edit}

* @private
*/
declare function endProfilingScope(scopeName: string): void

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-endProfilingSession.md Edit}

* @private
*/
declare function endProfilingSession(): void

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-eulerAngleX.md Edit}

* @deprecated

* @private
*/
declare function eulerAngleX(arg1: number): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-eulerAngleY.md Edit}

* @deprecated

* @private
*/
declare function eulerAngleY(arg1: number): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-eulerAngleYXZ.md Edit}

* @deprecated

* @private
*/
declare function eulerAngleYXZ(x: vec3): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-eulerAngleZ.md Edit}

* @deprecated

* @private
*/
declare function eulerAngleZ(arg1: number): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-extractEulerAngleXYZ.md Edit}

* @deprecated

* @private
*/
declare function extractEulerAngleXYZ(mat: mat4): vec3

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-failAsync.md Edit}
*/
declare function failAsync(error: any): void

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-fromEuler.md Edit}

* @deprecated

* @private
*/
declare function fromEuler(eulerAngles: vec3): quat

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-getAbsoluteStartTime.md Edit}

* @private
*/
declare function getAbsoluteStartTime(): number

/**
* Returns the version number of the engine running the lens.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-getCoreVersion.md Edit}

* @unreleased
*/
declare function getCoreVersion(): number

/**
* Returns the time difference in seconds between the current frame and previous frame.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-getDeltaTime.md Edit}
*/
declare function getDeltaTime(): number

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-getFileVersion.md Edit}

* @private
*/
declare function getFileVersion(): number

/**
* Get current time in Nanoseconds. Useful when optimizing a Lens to understand its performance.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-getRealTimeNanos.md Edit}
*/
declare function getRealTimeNanos(): number

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-getScenariumVersion.md Edit}

* @private
*/
declare function getScenariumVersion(): number

/**
* Returns the time in seconds since the lens was started.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-getTime.md Edit}
*/
declare function getTime(): number

/**
* Returns the inverse mat3 of `arg1`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-inverseMat3.md Edit}

* @deprecated

* @private
*/
declare function inverseMat3(arg1: mat3): mat3

/**
* Returns the inverse mat4 of `arg1`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-inverseMat4.md Edit}

* @deprecated

* @private
*/
declare function inverseMat4(arg1: mat4): mat4

/**
* Returns true if the passed in object is null or destroyed. Useful as a safe way to check if a SceneObject or Component has been destroyed.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-isNull.md Edit}
*/
declare function isNull(reference: any): boolean

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat2Add.md Edit}

* @deprecated

* @private
*/
declare function mat2Add(arg1: mat2, arg2: mat2): mat2

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat2Div.md Edit}

* @deprecated

* @private
*/
declare function mat2Div(arg1: mat2, arg2: mat2): mat2

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat2Mul.md Edit}

* @deprecated

* @private
*/
declare function mat2Mul(arg1: mat2, arg2: mat2): mat2

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat2Sub.md Edit}

* @deprecated

* @private
*/
declare function mat2Sub(arg1: mat2, arg2: mat2): mat2

/**
* Returns the result of adding `arg1` and `arg2`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat3Add.md Edit}

* @deprecated

* @private
*/
declare function mat3Add(arg1: mat3, arg2: mat3): mat3

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat3Div.md Edit}

* @deprecated

* @private
*/
declare function mat3Div(arg1: mat3, arg2: mat3): mat3

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat3Mul.md Edit}

* @deprecated

* @private
*/
declare function mat3Mul(arg1: mat3, arg2: mat3): mat3

/**
* Returns the result of subtracting `arg2` from `arg1`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat3Sub.md Edit}

* @deprecated

* @private
*/
declare function mat3Sub(arg1: mat3, arg2: mat3): mat3

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat4Add.md Edit}

* @deprecated

* @private
*/
declare function mat4Add(arg1: mat4, arg2: mat4): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat4Div.md Edit}

* @deprecated

* @private
*/
declare function mat4Div(arg1: mat4, arg2: mat4): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat4Mul.md Edit}

* @deprecated

* @private
*/
declare function mat4Mul(arg1: mat4, arg2: mat4): mat4

/**
* Returns the result of subtracting `arg2` from `arg1`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-mat4Sub.md Edit}

* @deprecated

* @private
*/
declare function mat4Sub(arg1: mat4, arg2: mat4): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-matrixCompMultMat3.md Edit}

* @deprecated

* @private
*/
declare function matrixCompMultMat3(arg1: mat3, arg2: mat3): mat3

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-matrixCompMultMat4.md Edit}

* @deprecated

* @private
*/
declare function matrixCompMultMat4(arg1: mat4, arg2: mat4): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-outerProductMat3.md Edit}

* @deprecated

* @private
*/
declare function outerProductMat3(arg1: vec3, arg2: vec3): mat3

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-outerProductMat4.md Edit}

* @deprecated

* @private
*/
declare function outerProductMat4(arg1: vec4, arg2: vec4): mat4

/**
* Prints out a message to the Logger window.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-print.md Edit}
*/
declare function print(message: any): void

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-quatFromAngleAxis.md Edit}

* @deprecated

* @private
*/
declare function quatFromAngleAxis(arg1: number, arg2: vec3): quat

/**
* Load a JavaScript module. Used for importing another JavaScript file found in the Resources panel to be used in the current script. Similar to `require` found in CommonJS specification. You can access Lens Studio specific modules (like `RemoteServiceModule`) using the `LensStudio` prefix, such as: `require("LensStudio:RemoteServiceModule)`. 

* You can use the modules name or path, meaning you can have two version of the same module in your project if needed. Both by name or by path will be relative to the script which is calling require, but by name will check the same folder as the script, then the parent folder, and so on. In addition, any require can be relative to your library folder. Take a look at the [Scripting guide](https://docs.snap.com/lens-studio/references/guides/lens-features/adding-interactivity/scripting-overview) to learn more.


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-require.md Edit}
*/
declare function require(moduleName: (ScriptAsset|string)): any

/**
* Load an asset like a `Texture`, `Material`, or `MLAsset` directly from script. 

* You can use the modules name or path. Both by name or by path will be relative to the script which is calling require, but by name will check the same folder as the script, then the parent folder, and so on. In addition, any require can be relative to your library folder. Take a look at the [Scripting guide](https://docs.snap.com/lens-studio/references/guides/lens-features/adding-interactivity/scripting-overview) to learn more.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-requireAsset.md Edit}
*/
declare function requireAsset(name: string): Asset

/**
* Load a script by name or path in order to use that type to create or get a component at runtime. 

* You can use the modules name or path. Both by name or by path will be relative to the script which is calling require, but by name will check the same folder as the script, then the parent folder, and so on. In addition, any require can be relative to your library folder. Take a look at the [Scripting guide](https://docs.snap.com/lens-studio/references/guides/lens-features/adding-interactivity/scripting-overview) to learn more.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-requireType.md Edit}
*/
declare function requireType(name: string): string

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-setDirtyRectsEnabled.md Edit}

* @snapOsOnly

* @private
*/
declare function setDirtyRectsEnabled(enabled: boolean): void

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-slerp.md Edit}

* @deprecated

* @private
*/
declare function slerp(x: quat, y: quat, t: number): quat

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-startProfilingScope.md Edit}

* @private
*/
declare function startProfilingScope(scopeName: string): void

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-startProfilingSession.md Edit}

* @private
*/
declare function startProfilingSession(): void

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-toEuler.md Edit}

* @deprecated

* @private
*/
declare function toEuler(arg1: quat): vec3

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-transposeMat3.md Edit}

* @deprecated

* @private
*/
declare function transposeMat3(arg1: mat3): mat3

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-transposeMat4.md Edit}

* @deprecated

* @private
*/
declare function transposeMat4(arg1: mat4): mat4

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/methods/Globals-yawPitchRoll.md Edit}

* @deprecated

* @private
*/
declare function yawPitchRoll(yaw: vec3): mat4

declare namespace global {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.analyticsSystem.md Edit}
    
    * @private
    */
    let analyticsSystem: AnalyticsSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.assetSystem.md Edit}
    
    * @private
    */
    let assetSystem: AssetSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.audioSystem.md Edit}
    
    * @private
    */
    let audioSystem: AudioSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.bitmojiSystem.md Edit}
    
    * @deprecated
    
    * @private
    */
    let bitmojiSystem: BitmojiSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.clientInterfaceSystem.md Edit}
    
    * @private
    */
    let clientInterfaceSystem: ClientInterfaceSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.coreVersionChecks.md Edit}
    
    * @private
    */
    let coreVersionChecks: CoreVersionChecks
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.debugRenderSystem.md Edit}
    
    * @private
    */
    let debugRenderSystem: DebugRender
    
    /**
    * Returns the global DeviceInfoSystem, which provides information about the device running the Lens.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.deviceInfoSystem.md Edit}
    */
    let deviceInfoSystem: DeviceInfoSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.drawingSystem2D.md Edit}
    
    * @private
    */
    let drawingSystem2D: DrawingSystem2D
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.experimentSystem.md Edit}
    
    * @private
    */
    let experimentSystem: ExperimentSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.freezeFrameSystem.md Edit}
    
    * @private
    */
    let freezeFrameSystem: FreezeFrameSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.friendSystem.md Edit}
    
    * @exposesUserData
    
    * @private
    */
    let friendSystem: FriendSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.glyphLoader.md Edit}
    
    * @private
    */
    let glyphLoader: GlyphLoader
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.hapticFeedbackSystem.md Edit}
    */
    let hapticFeedbackSystem: HapticFeedbackSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.landmarkersSystem.md Edit}
    
    * @private
    */
    let landmarkersSystem: LandmarkersSystem
    
    /**
    * Returns the global `GeneralDataStore` for Launch Params, which provides any special data passed in when the Lens is launched.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.launchParams.md Edit}
    */
    let launchParams: GeneralDataStore
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.lensDataSystem.md Edit}
    
    * @private
    */
    let lensDataSystem: LensDataSystem
    
    /**
    * Returns the global [LocalizationSystem](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#LocalizationSystem), which helps convert times, dates, and other units to user friendly strings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.localizationSystem.md Edit}
    */
    let localizationSystem: LocalizationSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.locationSystem.md Edit}
    
    * @private
    */
    let locationSystem: LocationSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.multiplayerSystem.md Edit}
    
    * @private
    */
    let multiplayerSystem: MultiplayerSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.objectTracker2DSystem.md Edit}
    
    * @deprecated
    
    * @private
    */
    let objectTracker2DSystem: ObjectTrackingSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.objectTrackingSystem.md Edit}
    
    * @private
    */
    let objectTrackingSystem: ObjectTrackingSystem
    
    /**
    * Returns the global [PersistentStorageSystem](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#PersistentStorageSystem), which allows data to persist between Lens sessions.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.persistentStorageSystem.md Edit}
    */
    let persistentStorageSystem: PersistentStorageSystem
    
    /**
    * A read-only property that gets the pointer to the `RenderAPIJS` object.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.renderAPI.md Edit}
    
    * @private
    */
    let renderAPI: RenderAPIJS
    
    /**
    * Returns the global [ScriptScene](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#ScriptScene) object, which offers information and controls for the current scene.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.scene.md Edit}
    */
    let scene: ScriptScene
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.sceneConfig.md Edit}
    
    * @private
    */
    let sceneConfig: SceneConfig
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.sceneIntelligenceSystem.md Edit}
    
    * @private
    */
    let sceneIntelligenceSystem: SceneIntelligenceSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.serializationSystem.md Edit}
    
    * @private
    */
    let serializationSystem: SerializationSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.shaderResourceSystem.md Edit}
    */
    let shaderResourceSystem: ShaderResourceSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.snapRecordingSystem.md Edit}
    
    * @private
    */
    let snapRecordingSystem: SnapRecordingSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.snappablesSystem.md Edit}
    
    * @private
    */
    let snappablesSystem: SnappablesSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.textInputSystem.md Edit}
    */
    let textInputSystem: TextInputSystem
    
    /**
    * Returns the global [TouchDataProvider](https://lensstudio.snapchat.com/api/lens-studio/Classes/Providers#TouchDataProvider), which controls how the Lens handles touch events.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.touchSystem.md Edit}
    */
    let touchSystem: TouchDataProvider
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.uriSystem.md Edit}
    
    * @private
    */
    let uriSystem: UriSystem
    
    /**
    * Returns the global [UserContextSystem](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#UserContextSystem), which provides information about the user such as display name, birthday, and even current weather.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.userContextSystem.md Edit}
    */
    let userContextSystem: UserContextSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.userInfoSystem.md Edit}
    
    * @private
    */
    let userInfoSystem: UserInfoSystem
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Globals/properties/Globals-global.weatherSystem.md Edit}
    
    * @private
    */
    let weatherSystem: WeatherSystem
    
}

/**
* The base class for data accessible through [DataComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#DataComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AbstractData/AbstractData-description.md Edit}

* @private
*/
interface AbstractData extends ScriptObject {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AccessLevel/AccessLevel-description.md Edit}

* @private
*/
declare enum AccessLevel {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AccessLevel/properties/AccessLevel-Undefined.md Edit}
    
    * @private
    */
    Undefined,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AccessLevel/properties/AccessLevel-User.md Edit}
    
    * @private
    */
    User,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AccessLevel/properties/AccessLevel-Friend.md Edit}
    
    * @private
    */
    Friend,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AccessLevel/properties/AccessLevel-Global.md Edit}
    
    * @private
    */
    Global
}

/**
* Interface for sending Blizzard analytics events. Accessible from [DataComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#DataComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnalyticsSystem/AnalyticsSystem-description.md Edit}

* @private
*/
interface AnalyticsSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnalyticsSystem/methods/AnalyticsSystem-getEvents.md Edit}
    
    * @private
    */
    getEvents(): object
    
    /**
    * Set an analytics event with name `name` to value `value`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnalyticsSystem/methods/AnalyticsSystem-setEventValue.md Edit}
    
    * @private
    */
    setEventValue(name: string, value: string): void
    
}

/**
* An object containing the position of an object relative to a LocationAsset. 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Anchor/Anchor-description.md Edit}
*/
interface Anchor extends ScriptObject {
    /**
    * The LocationAsset which this anchor is relative to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Anchor/properties/Anchor-location.md Edit}
    
    * @readonly
    */
    location: LocationAsset
    
    /**
    * The position of this anchor relative to the LocationAsset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Anchor/properties/Anchor-position.md Edit}
    
    * @readonly
    */
    position: vec3
    
}

/**
* Controls an animated texture resource. Can be accessed from [Texture.control](https://lensstudio.snapchat.com/api/lens-studio/Classes/Assets#texture--control) on an animated texture.
* See also: [2D Animation Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/adding-content/2d/2d-animation).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/AnimatedTextureFileProvider-description.md Edit}
*/
interface AnimatedTextureFileProvider extends TextureProvider {
    /**
    * Duplicates the AnimatedTextureFileProvider and returns the new copy. Can be used for playing the same animation at different offsets.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-clone.md Edit}
    */
    clone(): AnimatedTextureFileProvider
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-getAllAnimationGroups.md Edit}
    
    * @private
    */
    getAllAnimationGroups(): string[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-getAnimationGroupFilenames.md Edit}
    
    * @private
    */
    getAnimationGroupFilenames(groupName: string): string[]
    
    /**
    * Returns the index of the frame that is currently playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-getCurrentPlayingFrame.md Edit}
    */
    getCurrentPlayingFrame(): number
    
    /**
    * Returns how long the animation is in seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-getDuration.md Edit}
    */
    getDuration(): number
    
    /**
    * Returns the number of frames in the animation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-getFramesCount.md Edit}
    */
    getFramesCount(): number
    
    /**
    * Returns whether the animation is finished playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-isFinished.md Edit}
    */
    isFinished(): boolean
    
    /**
    * Returns whether the animation is currently paused.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-isPaused.md Edit}
    */
    isPaused(): boolean
    
    /**
    * Returns whether the animation is currently playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-isPlaying.md Edit}
    */
    isPlaying(): boolean
    
    /**
    * Pauses the animation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-pause.md Edit}
    */
    pause(): void
    
    /**
    * Pauses the animation at frame `frameIndex`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-pauseAtFrame.md Edit}
    */
    pauseAtFrame(frameIndex: number): void
    
    /**
    * Plays the animation `loops` times, starting with an offset of `offset` seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-play.md Edit}
    */
    play(loops: number, offset: number): void
    
    /**
    * Start playing the animation from frame `frameIndex`, `loops` times.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-playFromFrame.md Edit}
    */
    playFromFrame(frameIndex: number, loops: number): void
    
    /**
    * Resumes a paused animation from the frame that was last played.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-resume.md Edit}
    */
    resume(): void
    
    /**
    * Sets the callback function to be called whenever the animation stops playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-setOnFinish.md Edit}
    */
    setOnFinish(eventCallback: (animatedTexture: AnimatedTextureFileProvider) => void): void
    
    /**
    * Stops the animation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-stop.md Edit}
    */
    stop(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/methods/AnimatedTextureFileProvider-useFrameByName.md Edit}
    
    * @private
    */
    useFrameByName(name: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/properties/AnimatedTextureFileProvider-animationGroup.md Edit}
    
    * @private
    */
    animationGroup: string
    
    /**
    * Length of the animation in seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/properties/AnimatedTextureFileProvider-duration.md Edit}
    */
    duration: number
    
    /**
    * Returns whether the animation was set to automatically play and loop.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/properties/AnimatedTextureFileProvider-isAutoplay.md Edit}
    */
    isAutoplay: boolean
    
    /**
    * If enabled, the animation will alternate between normal and reverse each time it loops.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/properties/AnimatedTextureFileProvider-isPingPong.md Edit}
    */
    isPingPong: boolean
    
    /**
    * Whether the animation plays in reverse.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/properties/AnimatedTextureFileProvider-isReversed.md Edit}
    */
    isReversed: boolean
    
    /**
    * The animation track used to control the frame animation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimatedTextureFileProvider/properties/AnimatedTextureFileProvider-track.md Edit}
    
    * @deprecated
    */
    track: IntStepAnimationTrackKeyFramed
    
}

/**
* Used by [AnimationMixer](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#AnimationMixer) to animate a single object in the hierarchy.
* These are automatically added to SceneObjects when importing animated FBX files.
* See also: [Playing 3D Animation Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/adding-interactivity/additional-examples/playing-3d-animation), [AnimationMixer](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#AnimationMixer), [AnimationLayer](https://lensstudio.snapchat.com/api/lens-studio/Classes/Assets#AnimationLayer).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Animation/Animation-description.md Edit}

* @deprecated
*/
interface Animation extends Component {
    /**
    * Returns the AnimationLayer under the name `layerName`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Animation/methods/Animation-getAnimationLayerByName.md Edit}
    */
    getAnimationLayerByName(layerName: string): AnimationLayer
    
    /**
    * Removes the AnimationLayer under the name `layerName`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Animation/methods/Animation-removeAnimationLayerByName.md Edit}
    */
    removeAnimationLayerByName(layerName: string): void
    
    /**
    * Adds an AnimationLayer under the name `layerName`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Animation/methods/Animation-setAnimationLayerByName.md Edit}
    */
    setAnimationLayerByName(layerName: string, animationLayer: AnimationLayer): void
    
}

/**
* Asset that contains multiple animation layers. Animation assets themselves do not handle playing or orchestrating animations. This is left to the animation player component to handle.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/AnimationAsset-description.md Edit}
*/
interface AnimationAsset extends Asset {
    /**
    * Add the AnimationPropertyLayer that will be used as default.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/methods/AnimationAsset-addDefaultLayer.md Edit}
    
    * @private
    */
    addDefaultLayer(layerName: string): void
    
    /**
    * Adds AnimationPropertyLayer to Animation asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/methods/AnimationAsset-addLayer.md Edit}
    */
    addLayer(layerName: string, layer: AnimationPropertyLayer): void
    
    /**
    * Delete all the AnimationPropertyLayer in this AnimationAsset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/methods/AnimationAsset-clearLayers.md Edit}
    */
    clearLayers(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/methods/AnimationAsset-createEvent.md Edit}
    */
    createEvent(eventName: string, time: number): AnimationPropertyEventRegistration
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/methods/AnimationAsset-deleteEvent.md Edit}
    */
    deleteEvent(layerName: AnimationPropertyEventRegistration): void
    
    /**
    * Delete the AnimationPropertyLayer named `layerName`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/methods/AnimationAsset-deleteLayer.md Edit}
    */
    deleteLayer(layerName: string): void
    
    /**
    * Retrieves an animation associated with a particular object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/methods/AnimationAsset-getLayer.md Edit}
    */
    getLayer(layerName: string): AnimationPropertyLayer
    
    /**
    * Animation duration in seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/properties/AnimationAsset-duration.md Edit}
    
    * @readonly
    */
    duration: number
    
    /**
    * Denotes how many key frames this animation was sampled at.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/properties/AnimationAsset-fps.md Edit}
    
    * @readonly
    */
    fps: number
    
    /**
    * The AnimationPropertyLayer in this Animation Asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationAsset/properties/AnimationAsset-layers.md Edit}
    
    * @readonly
    
    * @private
    */
    layers: any
    
}

/**
* Animation Clip is what an Animation Player uses to manage playback for a specific animation. It defines that animation by referencing an Animation Asset and providing start and end points, playback speed and direction, and blending information. 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/AnimationClip-description.md Edit}
*/
interface AnimationClip extends ScriptObject {
    /**
    * Clones the existing clip with a new name.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/methods/AnimationClip-clone.md Edit}
    */
    clone(clipName: string): AnimationClip
    
    /**
    * Points to the animation asset to be played by the Animation Player.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-animation.md Edit}
    */
    animation: AnimationAsset
    
    /**
    * Returns begin time of clip.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-begin.md Edit}
    */
    begin: number
    
    /**
    * The blend mode for this particular clip.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-blendMode.md Edit}
    */
    blendMode: AnimationLayerBlendMode
    
    /**
    * Whether the animation clip is disabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-disabled.md Edit}
    */
    disabled: boolean
    
    /**
    * Returns the duration of the clip which is calculated based on the begin and end times.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-duration.md Edit}
    
    * @readonly
    */
    duration: number
    
    /**
    * Returns end time of clip.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-end.md Edit}
    */
    end: number
    
    /**
    * Name of the clip.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-name.md Edit}
    
    * @readonly
    */
    name: string
    
    /**
    * Choose whether to play animation clip once, loop the clip, or ping pong it.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-playbackMode.md Edit}
    */
    playbackMode: PlaybackMode
    
    /**
    * Scalar value to represent playback speed percentage. 1.0 is 100% playback speed.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-playbackSpeed.md Edit}
    */
    playbackSpeed: number
    
    /**
    * Specifies if the clip should be played reversed.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-reversed.md Edit}
    */
    reversed: boolean
    
    /**
    * How scale is accumulated. Usually does not need to be changed after import.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-scaleMode.md Edit}
    */
    scaleMode: AnimationLayerScaleMode
    
    /**
    * Strength of animation clip contribution. Lies between [0.0, 1.0] inclusive. For default blending a 1.0 weight indicates this clip will override all earlier clips, a less than 1.0 weight indicates it will blend onto the calculated pose using a weighted average.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/properties/AnimationClip-weight.md Edit}
    */
    weight: number
    
}
declare namespace AnimationClip {
    /**
    * Creates a clip.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/methods/AnimationClip-create.md Edit}
    */
    export function create(clipName: string): AnimationClip
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip/methods/AnimationClip-createFromAnimation.md Edit}
    */
    export function createFromAnimation(clipName: string, animation: AnimationAsset): AnimationClip
    

}

declare namespace AnimationClip {
    /**
    * Used by [AnimationMixerLayer](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#AnimationMixerLayer) for setting animation looping behavior.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip.PostInfinity/AnimationClip.PostInfinity-description.md Edit}
    
    * @deprecated
    */
    enum PostInfinity {
        /**
        * The animation will restart from the beginning each time it loops.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip.PostInfinity/properties/AnimationClip.PostInfinity-Cycle.md Edit}
        */
        Cycle,
        /**
        * The animation will switch between normal and reverse playback each time it loops.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip.PostInfinity/properties/AnimationClip.PostInfinity-Oscillate.md Edit}
        */
        Oscillate
    }

}

declare namespace AnimationClip {
    /**
    * Used by [AnimationMixerLayer](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#AnimationMixerLayer) for setting animation clip range type.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip.RangeType/AnimationClip.RangeType-description.md Edit}
    
    * @deprecated
    */
    enum RangeType {
        /**
        * Range is specified by start and end time, in seconds
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip.RangeType/properties/AnimationClip.RangeType-Time.md Edit}
        */
        Time,
        /**
        * Range is specified by start and end frame numbers
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationClip.RangeType/properties/AnimationClip.RangeType-Frames.md Edit}
        */
        Frames
    }

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/AnimationCurve-description.md Edit}
*/
interface AnimationCurve extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/methods/AnimationCurve-addKeyframe.md Edit}
    */
    addKeyframe(frame: AnimationKeyFrame): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/methods/AnimationCurve-evaluate.md Edit}
    */
    evaluate(time: number): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/methods/AnimationCurve-getKeyFrame.md Edit}
    */
    getKeyFrame(index: number): AnimationKeyFrame
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/methods/AnimationCurve-removeKeyFrame.md Edit}
    */
    removeKeyFrame(t: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/properties/AnimationCurve-keyFrameCount.md Edit}
    
    * @readonly
    */
    keyFrameCount: number
    
}
declare namespace AnimationCurve {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/methods/AnimationCurve-create.md Edit}
    */
    export function create(): AnimationCurve
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/methods/AnimationCurve-createEasingCurve.md Edit}
    */
    export function createEasingCurve(startValue: number, endValue: number, x1: number, y1: number, x2: number, y2: number): AnimationCurve
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurve/methods/AnimationCurve-createKeyFrame.md Edit}
    */
    export function createKeyFrame(): AnimationKeyFrame
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/AnimationCurveTrack-description.md Edit}
*/
interface AnimationCurveTrack extends AnimationTrack {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/methods/AnimationCurveTrack-evaluateNumber.md Edit}
    */
    evaluateNumber(time: number): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/methods/AnimationCurveTrack-evaluateRotation.md Edit}
    */
    evaluateRotation(time: number): quat
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/methods/AnimationCurveTrack-evaluateVec2.md Edit}
    */
    evaluateVec2(time: number): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/methods/AnimationCurveTrack-evaluateVec3.md Edit}
    */
    evaluateVec3(time: number): vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/methods/AnimationCurveTrack-evaluateVec4.md Edit}
    */
    evaluateVec4(time: number): vec4
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/methods/AnimationCurveTrack-getProperty.md Edit}
    */
    getProperty(key: string): AnimationCurve
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/methods/AnimationCurveTrack-getPropertyKeys.md Edit}
    */
    getPropertyKeys(): string[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationCurveTrack/methods/AnimationCurveTrack-setProperty.md Edit}
    */
    setProperty(key: string, curve: AnimationCurve): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationEventRegistration/AnimationEventRegistration-description.md Edit}

* @private
*/
interface AnimationEventRegistration extends ScriptObject {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationEventTrack/AnimationEventTrack-description.md Edit}

* @private
*/
interface AnimationEventTrack extends AnimationTrack {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationEventTrack/methods/AnimationEventTrack-addEvent.md Edit}
    
    * @private
    */
    addEvent(eventName: string, timestamp: number): AnimationEventRegistration
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationEventTrack/methods/AnimationEventTrack-removeEvent.md Edit}
    
    * @private
    */
    removeEvent(registration: AnimationEventRegistration): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationKeyFrame/AnimationKeyFrame-description.md Edit}
*/
interface AnimationKeyFrame extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationKeyFrame/properties/AnimationKeyFrame-inWeightPoint.md Edit}
    */
    inWeightPoint: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationKeyFrame/properties/AnimationKeyFrame-leftTangentType.md Edit}
    */
    leftTangentType: TangentType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationKeyFrame/properties/AnimationKeyFrame-outWeightPoint.md Edit}
    */
    outWeightPoint: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationKeyFrame/properties/AnimationKeyFrame-rightTangentType.md Edit}
    */
    rightTangentType: TangentType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationKeyFrame/properties/AnimationKeyFrame-time.md Edit}
    */
    time: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationKeyFrame/properties/AnimationKeyFrame-value.md Edit}
    */
    value: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationKeyFrame/properties/AnimationKeyFrame-weightedMode.md Edit}
    */
    weightedMode: WeightedMode
    
}

/**
* Configures an animation layer for a single [SceneObject](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#SceneObject).
* Gives access to position, rotation, scale and blend shape animation tracks.
* See also: [Playing 3D Animation Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/adding-interactivity/additional-examples/playing-3d-animation), [AnimationMixer](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#AnimationMixer), [Animation](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Animation).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/AnimationLayer-description.md Edit}

* @deprecated
*/
interface AnimationLayer extends AnimationTrack {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/methods/AnimationLayer-getAnimationEventTrack.md Edit}
    
    * @private
    */
    getAnimationEventTrack(): AnimationEventTrack
    
    /**
    * Returns a [FloatAnimationTrack](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#FloatAnimationTrack) from this AnimationLayer's blend shapes.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/methods/AnimationLayer-getBlendShapeTrack.md Edit}
    */
    getBlendShapeTrack(shapeName: string): FloatAnimationTrack
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/methods/AnimationLayer-setAnimationEventTrack.md Edit}
    
    * @private
    */
    setAnimationEventTrack(eventTrack: AnimationEventTrack): void
    
    /**
    * Sets or adds a [FloatAnimationTrack](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#FloatAnimationTrack) to this AnimationLayer's blend shapes.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/methods/AnimationLayer-setBlendShapeTrack.md Edit}
    */
    setBlendShapeTrack(shapeName: string, track: FloatAnimationTrack): void
    
    /**
    * The [Vec3AnimationTrack](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#Vec3AnimationTrack) controlling position in this AnimationLayer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/properties/AnimationLayer-position.md Edit}
    */
    position: Vec3AnimationTrack
    
    /**
    * The [QuaternionAnimationTrack](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#QuaternionAnimationTrack) controlling rotation in this AnimationLayer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/properties/AnimationLayer-rotation.md Edit}
    */
    rotation: QuaternionAnimationTrack
    
    /**
    * The [Vec3AnimationTrack](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#Vec3AnimationTrack) controlling scale in this AnimationLayer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/properties/AnimationLayer-scale.md Edit}
    */
    scale: Vec3AnimationTrack
    
    /**
    * The [IntAnimationTrack](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#IntAnimationTrack) controlling visibility in this AnimationLayer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayer/properties/AnimationLayer-visibility.md Edit}
    */
    visibility: IntAnimationTrack
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayerBlendMode/AnimationLayerBlendMode-description.md Edit}
*/
declare enum AnimationLayerBlendMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayerBlendMode/properties/AnimationLayerBlendMode-Default.md Edit}
    */
    Default,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayerBlendMode/properties/AnimationLayerBlendMode-Additive.md Edit}
    */
    Additive
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayerOnEventArgs/AnimationLayerOnEventArgs-description.md Edit}

* @private
*/
interface AnimationLayerOnEventArgs extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayerOnEventArgs/properties/AnimationLayerOnEventArgs-eventName.md Edit}
    
    * @readonly
    
    * @private
    */
    eventName: string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayerScaleMode/AnimationLayerScaleMode-description.md Edit}
*/
declare enum AnimationLayerScaleMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayerScaleMode/properties/AnimationLayerScaleMode-Multiply.md Edit}
    */
    Multiply,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationLayerScaleMode/properties/AnimationLayerScaleMode-Additive.md Edit}
    */
    Additive
}

/**
* Controls playback of animations on the attached [SceneObject](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#SceneObject) and its child objects.
* Please refer to the [Playing 3D Animation Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/adding-interactivity/additional-examples/playing-3d-animation) for setting up and playing animations.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/AnimationMixer-description.md Edit}

* @deprecated
*/
interface AnimationMixer extends Component {
    /**
    * Makes a copy of the layer `name` and stores it as `newName`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-cloneLayer.md Edit}
    */
    cloneLayer(name: string, newName: string): AnimationMixerLayer
    
    /**
    * Adds a new AnimationMixerLayer to this AnimationMixer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-createClip.md Edit}
    */
    createClip(name: string): AnimationMixerLayer
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-forceUpdate.md Edit}
    
    * @private
    */
    forceUpdate(): void
    
    /**
    * Returns a list of names of AnimationLayers in this AnimationMixer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-getAnimationLayerNames.md Edit}
    */
    getAnimationLayerNames(): string[]
    
    /**
    * Returns the AnimationMixerLayer with the name `name`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-getLayer.md Edit}
    */
    getLayer(name: string): AnimationMixerLayer
    
    /**
    * Returns the current time (in seconds) of the layer named `name`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-getLayerTime.md Edit}
    */
    getLayerTime(name: string): number
    
    /**
    * Returns a list of all AnimationMixerLayers controlled by the AnimationMixer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-getLayers.md Edit}
    */
    getLayers(): AnimationMixerLayer[]
    
    /**
    * Pauses animation layers named `name`, or all layers if `name` is empty.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-pause.md Edit}
    */
    pause(name: string): void
    
    /**
    * Rebuild the animation hierarchy by finding all [Animation](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Animation) components in the SceneObject and its children.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-resetAnimations.md Edit}
    */
    resetAnimations(): void
    
    /**
    * Resumes any paused animation layer with name `name`, or all layers if `name` is empty.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-resume.md Edit}
    */
    resume(name: string): void
    
    /**
    * Sets the weight of any layers with name `name`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-setWeight.md Edit}
    */
    setWeight(name: string, weight: number): void
    
    /**
    * Starts playing animation layers named `name`, or all layers if `name` is empty. The animation will start with an offset of `offset` seconds. The animation will play `cycles` times, or loop forever if `cycles` is -1.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-start.md Edit}
    */
    start(name: string, offset: number, cycles: number): void
    
    /**
    * Starts playing animation layers named `name`, or all layers if `name` is empty. The animation will start with an offset of `offset` seconds. The animation will play `cycles` times, or loop forever if `cycles` is -1. `eventCallback` will be called after any animation layer finishes playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-startWithCallback.md Edit}
    */
    startWithCallback(name: string, offset: number, cycles: number, eventCallback: (name: string, animationMixer: AnimationMixer) => void): void
    
    /**
    * Stops any animation layer with name `name`, or all layers if `name` is empty.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/methods/AnimationMixer-stop.md Edit}
    */
    stop(name: string): void
    
    /**
    * Whether this AnimationMixer is set to automatically play animations on start.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/properties/AnimationMixer-autoplay.md Edit}
    */
    autoplay: boolean
    
    /**
    * A multiplying value for the speed of all animations being controlled by the AnimationMixer.
    * For example, a value of 2.0 will double animation speed, while a value of 0.5 will cut the speed in half.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixer/properties/AnimationMixer-speedRatio.md Edit}
    */
    speedRatio: number
    
}

/**
* Controls animation playback for a single animation layer.
* See also: [AnimationMixer](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#AnimationMixer).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/AnimationMixerLayer-description.md Edit}

* @deprecated
*/
interface AnimationMixerLayer extends ScriptObject {
    /**
    * Returns a copy of this AnimationMixerLayer, with the name changed to `newName`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-clone.md Edit}
    */
    clone(newName: string): AnimationMixerLayer
    
    /**
    * Returns the length of the animation in seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-getDuration.md Edit}
    */
    getDuration(): number
    
    /**
    * Returns the current playback position of the animation in seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-getTime.md Edit}
    */
    getTime(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-isCycleFinished.md Edit}
    
    * @private
    */
    isCycleFinished(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-isFinished.md Edit}
    
    * @private
    */
    isFinished(): boolean
    
    /**
    * Returns whether the animation is currently playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-isPlaying.md Edit}
    */
    isPlaying(): boolean
    
    /**
    * Pauses the animation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-pause.md Edit}
    */
    pause(): void
    
    /**
    * Resumes the animation if it has been paused.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-resume.md Edit}
    */
    resume(): void
    
    /**
    * Starts playing the animation with an offset of `offsetArg` seconds.
    * The animation will play `cycles` times, or loop forever if `cycles` is -1.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-start.md Edit}
    */
    start(offset: number, cycles: number): void
    
    /**
    * Starts the animation with an offset of `offsetArg` seconds.
    * The animation will play `cycles` times, or loop forever if `cycles` is -1.
    * `eventCallback` will be called after the animation finishes.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-startWithCallback.md Edit}
    */
    startWithCallback(offset: number, cycles: number, eventCallback: (name: string, animationMixer: AnimationMixer) => void): void
    
    /**
    * Stops the animation from playing and jumps to the animation's end.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/methods/AnimationMixerLayer-stop.md Edit}
    */
    stop(): void
    
    /**
    * The name of the animation layer being used for this animation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-animationLayerName.md Edit}
    */
    animationLayerName: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-blendMode.md Edit}
    */
    blendMode: AnimationLayerBlendMode
    
    /**
    * The number of times this animation will play. If -1, the animation will loop forever.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-cycles.md Edit}
    */
    cycles: number
    
    /**
    * If true, the animation will stop having an effect.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-disabled.md Edit}
    */
    disabled: boolean
    
    /**
    * The framerate (frames per second) of the animation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-fps.md Edit}
    */
    fps: number
    
    /**
    * The starting point for this animation clip.
    * If `rangeType` is set to `Time`, this is the point to start at in seconds.
    * If `rangeType` is set to `Frames`, this is the frame number to start at.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-from.md Edit}
    */
    from: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-layer.md Edit}
    
    * @deprecated
    
    * @private
    */
    layer: string
    
    /**
    * The name of the AnimationMixerLayer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-name.md Edit}
    */
    name: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-onEvent.md Edit}
    
    * @readonly
    
    * @private
    */
    onEvent: event1<AnimationLayerOnEventArgs, void>
    
    /**
    * Defines the animation's looping behavior.
    * If set to `AnimationClip.PostInfinity.Cycle`, the animation will restart from the beginning each time it loops.
    * If set to `AnimationClip.PostInfinity.Oscillate`, the animation will switch between normal and reverse playback each time it loops.
    * This is set to `Cycle` by default.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-postInfinity.md Edit}
    */
    postInfinity: AnimationClip.PostInfinity
    
    /**
    * The range type used for defining the animation clip.
    * If set to `AnimationClip.RangeType.Time`, `to` and `from` represent times in seconds.
    * If set to `AnimationClip.RangeType.Frames`, `to` and `from` represent frame numbers.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-rangeType.md Edit}
    */
    rangeType: AnimationClip.RangeType
    
    /**
    * If true, the animation will play play in reverse.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-reversed.md Edit}
    */
    reversed: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-scaleMode.md Edit}
    */
    scaleMode: AnimationLayerScaleMode
    
    /**
    * A multiplying value for the speed of this animation.
    * For example, a value of 2.0 will double animation speed, while a value of 0.5 will cut the speed in half.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-speedRatio.md Edit}
    */
    speedRatio: number
    
    /**
    * The ending point for this animation clip.
    * If `rangeType` is set to `Time`, this is the point to end at in seconds.
    * If `rangeType` is set to `Frames`, this is the frame number to end at.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-to.md Edit}
    */
    to: number
    
    /**
    * The weight of this animation layer. Range is from [0-1], 0 being no animation strength and 1 being full animation strength.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationMixerLayer/properties/AnimationMixerLayer-weight.md Edit}
    */
    weight: number
    
}

/**
* Component that handles playing animation clips as well as binding callbacks to user defined events.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/AnimationPlayer-description.md Edit}
*/
interface AnimationPlayer extends Component {
    /**
    * Adds a clip to the player. If one exists, replace existing clip.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-addClip.md Edit}
    */
    addClip(clip: AnimationClip): void
    
    /**
    * Updates the animation player forcing sampling, resulting in the setting of transforms and firing of animation events.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-forceUpdate.md Edit}
    */
    forceUpdate(deltaTime: number): void
    
    /**
    * Get currently playing clips.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-getActiveClips.md Edit}
    */
    getActiveClips(): string[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-getAnimationClips.md Edit}
    
    * @private
    */
    getAnimationClips(): AnimationClip[]
    
    /**
    * Tries to get a clip from the player, returns null if it does not exist.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-getClip.md Edit}
    */
    getClip(name: string): AnimationClip
    
    /**
    * Returns the current time for a clip.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-getClipCurrentTime.md Edit}
    */
    getClipCurrentTime(name: string): number
    
    /**
    * Returns if a clip is enabled for playback.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-getClipEnabled.md Edit}
    */
    getClipEnabled(name: string): boolean
    
    /**
    * Returns if a clip is playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-getClipIsPlaying.md Edit}
    */
    getClipIsPlaying(name: string): boolean
    
    /**
    * Get currently inactive clips.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-getInactiveClips.md Edit}
    */
    getInactiveClips(): string[]
    
    /**
    * Pauses all clips.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-pauseAll.md Edit}
    */
    pauseAll(): void
    
    /**
    * Pause the clip with name.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-pauseClip.md Edit}
    */
    pauseClip(name: string): void
    
    /**
    * Plays all clips.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-playAll.md Edit}
    */
    playAll(): void
    
    /**
    * Plays clip with the given name and starting from the given time.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-playClipAt.md Edit}
    */
    playClipAt(name: string, time: number): void
    
    /**
    * Removes a clip from the player.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-removeClip.md Edit}
    */
    removeClip(name: string): void
    
    /**
    * Resumes all clips.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-resumeAll.md Edit}
    */
    resumeAll(): void
    
    /**
    * Resumes clip with name.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-resumeClip.md Edit}
    */
    resumeClip(name: string): void
    
    /**
    * Sets the clip to be enabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-setClipEnabled.md Edit}
    */
    setClipEnabled(name: string, enabled: boolean): void
    
    /**
    * Stops all clips and resets time to t = 0.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-stopAll.md Edit}
    */
    stopAll(): void
    
    /**
    * Stops the clip and resets time to t = 0.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/methods/AnimationPlayer-stopClip.md Edit}
    */
    stopClip(name: string): void
    
    /**
    * Specifies if clips should play on initialization.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/properties/AnimationPlayer-autoplay.md Edit}
    
    * @private
    */
    autoplay: boolean
    
    /**
    * Array of animation clips
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/properties/AnimationPlayer-clips.md Edit}
    
    * @readonly
    */
    clips: AnimationClip[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayer/properties/AnimationPlayer-onEvent.md Edit}
    
    * @readonly
    */
    onEvent: event1<AnimationPlayerOnEventArgs, void>
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayerOnEventArgs/AnimationPlayerOnEventArgs-description.md Edit}
*/
interface AnimationPlayerOnEventArgs extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPlayerOnEventArgs/properties/AnimationPlayerOnEventArgs-eventName.md Edit}
    
    * @readonly
    */
    eventName: string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyEventRegistration/AnimationPropertyEventRegistration-description.md Edit}
*/
interface AnimationPropertyEventRegistration extends ScriptObject {
}

/**
* A layer containing different properties. Examples include position, rotation, scale or any other arbitrary properties a user would like to add and sample from.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyLayer/AnimationPropertyLayer-description.md Edit}
*/
interface AnimationPropertyLayer extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyLayer/methods/AnimationPropertyLayer-getBlendShapeTrack.md Edit}
    
    * @private
    */
    getBlendShapeTrack(shapeName: string): FloatAnimationPropertyTrack
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyLayer/methods/AnimationPropertyLayer-setBlendShapeTrack.md Edit}
    
    * @private
    */
    setBlendShapeTrack(shapeName: string, track: FloatAnimationPropertyTrack): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyLayer/properties/AnimationPropertyLayer-position.md Edit}
    
    * @private
    */
    position: Vec3AnimationPropertyTrack
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyLayer/properties/AnimationPropertyLayer-rotation.md Edit}
    
    * @private
    */
    rotation: QuatAnimationPropertyTrack
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyLayer/properties/AnimationPropertyLayer-scale.md Edit}
    
    * @private
    */
    scale: Vec3AnimationPropertyTrack
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyLayer/properties/AnimationPropertyLayer-vertexCache.md Edit}
    
    * @private
    */
    vertexCache: FloatAnimationPropertyTrack
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyLayer/properties/AnimationPropertyLayer-visibility.md Edit}
    
    * @private
    */
    visibility: IntStepAnimationPropertyTrack
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationPropertyTrack/AnimationPropertyTrack-description.md Edit}

* @private
*/
interface AnimationPropertyTrack extends ScriptObject {
}

/**
* The base class for animation tracks.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnimationTrack/AnimationTrack-description.md Edit}
*/
interface AnimationTrack extends Asset {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnyData/AnyData-description.md Edit}

* @private
*/
interface AnyData {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnyData/methods/AnyData-getBool.md Edit}
    
    * @private
    */
    getBool(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnyData/methods/AnyData-getDouble.md Edit}
    
    * @private
    */
    getDouble(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnyData/methods/AnyData-getFloat.md Edit}
    
    * @private
    */
    getFloat(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnyData/methods/AnyData-getInt.md Edit}
    
    * @private
    */
    getInt(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AnyData/methods/AnyData-getString.md Edit}
    
    * @private
    */
    getString(): string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/ARDepthTextureProvider-description.md Edit}

* @private
*/
interface ARDepthTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/methods/ARDepthTextureProvider-getDepthToDisparityNumerator.md Edit}
    
    * @private
    */
    getDepthToDisparityNumerator(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/methods/ARDepthTextureProvider-getScale.md Edit}
    
    * @private
    */
    getScale(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/methods/ARDepthTextureProvider-sampleDepthAtPoint.md Edit}
    
    * @exposesUserData
    
    * @private
    */
    sampleDepthAtPoint(point: vec2): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/properties/ARDepthTextureProvider-depthProcessingOptions.md Edit}
    
    * @readonly
    
    * @private
    */
    depthProcessingOptions: DepthProcessingOptions
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/properties/ARDepthTextureProvider-dilatedDepthEnabled.md Edit}
    
    * @private
    */
    dilatedDepthEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/properties/ARDepthTextureProvider-guidedFilterEnabled.md Edit}
    
    * @private
    */
    guidedFilterEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/properties/ARDepthTextureProvider-zFar.md Edit}
    
    * @readonly
    
    * @private
    */
    zFar: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ARDepthTextureProvider/properties/ARDepthTextureProvider-zNear.md Edit}
    
    * @readonly
    
    * @private
    */
    zNear: number
    
}

/**
* Base class for all assets used in the engine.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Asset/Asset-description.md Edit}
*/
interface Asset extends SerializableWithUID {
    /**
    * The name of the Asset in Lens Studio.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Asset/properties/Asset-name.md Edit}
    */
    name: string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/AssetSystem-description.md Edit}

* @private
*/
interface AssetSystem extends IAssetSystem {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-createAsset.md Edit}
    
    * @private
    */
    createAsset(typeName: string): Asset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-createPrefabFromAsset.md Edit}
    
    * @private
    */
    createPrefabFromAsset(asset: Asset): Prefab
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-createPrefabFromSceneObject.md Edit}
    
    * @private
    */
    createPrefabFromSceneObject(sceneObject: SceneObject): Prefab
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-createProceduralTexture.md Edit}
    
    * @private
    */
    createProceduralTexture(width: number, height: number, colorSpace: Colorspace): Texture
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-downloadAsset.md Edit}
    
    * @private
    */
    downloadAsset(onDownloaded: (id: string, path: string, asset: Asset) => void, onFailed: (id: string) => void, id: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-downloadAssetFromUrl.md Edit}
    
    * @private
    */
    downloadAssetFromUrl(onDownloaded: (id: string, path: string, asset: Asset) => void, onFailed: (id: string) => void, url: string, checksum: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-downloadBitmojiGlbAsset.md Edit}
    
    * @private
    */
    downloadBitmojiGlbAsset(onDownloaded: (id: string, path: string, asset: Asset) => void, onFailed: (id: string) => void, id: string, avatarId: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-downloadDeviceDependentAsset.md Edit}
    
    * @private
    */
    downloadDeviceDependentAsset(onDownloaded: (id: string, path: string, asset: Asset) => void, onFailed: (id: string) => void, id: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-downloadFriendmojiAsset.md Edit}
    
    * @private
    */
    downloadFriendmojiAsset(onDownloaded: (id: string, path: string, asset: Asset) => void, onFailed: (id: string) => void, id: string, avatarId: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-downloadUserGeneratedAsset.md Edit}
    
    * @private
    */
    downloadUserGeneratedAsset(onDownloaded: (id: string, path: string, asset: Asset) => void, onFailed: (id: string) => void, hexEncryptionKey: string, hexEncryptionIv: string, id: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-getAsset.md Edit}
    
    * @private
    */
    getAsset(key: string): Asset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-getDefaultSystemFont.md Edit}
    
    * @private
    */
    getDefaultSystemFont(): Font
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-getSystemFont.md Edit}
    
    * @private
    */
    getSystemFont(fontName: string): Font
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-hasAsset.md Edit}
    
    * @private
    */
    hasAsset(key: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-removeAsset.md Edit}
    
    * @private
    */
    removeAsset(key: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-setAsset.md Edit}
    
    * @private
    */
    setAsset(key: string, asset: Asset): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AssetSystem/methods/AssetSystem-unpackAssetPrefab.md Edit}
    
    * @private
    */
    unpackAssetPrefab(key: string, asset: Asset): Asset
    
}

/**
* Used by [Head.setAttachmentPointType()](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Head) to specify the type of attachment used with a Head binding.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/AttachmentPointType-description.md Edit}
*/
declare enum AttachmentPointType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-CandideCenter.md Edit}
    */
    CandideCenter,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-Chin.md Edit}
    */
    Chin,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-FaceMeshCenter.md Edit}
    */
    FaceMeshCenter,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-Forehead.md Edit}
    */
    Forehead,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-HeadCenter.md Edit}
    */
    HeadCenter,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-LeftCheek.md Edit}
    */
    LeftCheek,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-LeftEyeballCenter.md Edit}
    */
    LeftEyeballCenter,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-LeftForehead.md Edit}
    */
    LeftForehead,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-MouthCenter.md Edit}
    */
    MouthCenter,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-RightCheek.md Edit}
    */
    RightCheek,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-RightEyeballCenter.md Edit}
    */
    RightEyeballCenter,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-RightForehead.md Edit}
    */
    RightForehead,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AttachmentPointType/properties/AttachmentPointType-TriangleBarycentric.md Edit}
    */
    TriangleBarycentric
}

declare namespace Audio {
    /**
    * The curve that specifies how sound fades with the distance from Audio Component to the Audio Listener.****
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.DistanceCurveType/Audio.DistanceCurveType-description.md Edit}
    */
    enum DistanceCurveType {
        /**
        * Linear Curve ~ y(x) = ax+b
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.DistanceCurveType/properties/Audio.DistanceCurveType-Linear.md Edit}
        */
        Linear,
        /**
        * Inverse Curve ~ y(x) = (a/x)+b
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.DistanceCurveType/properties/Audio.DistanceCurveType-Inverse.md Edit}
        */
        Inverse,
        /**
        * Logarithmic Curve ~ -log(x)
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.DistanceCurveType/properties/Audio.DistanceCurveType-Logarithm.md Edit}
        */
        Logarithm,
        /**
        * Inverse Logarithmic Curve ~ +log(x)
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.DistanceCurveType/properties/Audio.DistanceCurveType-InverseLogarithm.md Edit}
        */
        InverseLogarithm
    }

}

declare namespace Audio {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.PanType/Audio.PanType-description.md Edit}
    
    * @private
    */
    enum PanType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.PanType/properties/Audio.PanType-Balance.md Edit}
        
        * @private
        */
        Balance,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.PanType/properties/Audio.PanType-PowerConst.md Edit}
        
        * @private
        */
        PowerConst
    }

}

declare namespace Audio {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.PlaybackMode/Audio.PlaybackMode-description.md Edit}
    
    * @snapOsOnly
    */
    enum PlaybackMode {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.PlaybackMode/properties/Audio.PlaybackMode-LowPower.md Edit}
        */
        LowPower,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Audio.PlaybackMode/properties/Audio.PlaybackMode-LowLatency.md Edit}
        */
        LowLatency
    }

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioAnalysisEvent/AudioAnalysisEvent-description.md Edit}

* @private
*/
declare enum AudioAnalysisEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioAnalysisEvent/properties/AudioAnalysisEvent-DBLevelThresholdReached.md Edit}
    
    * @private
    */
    DBLevelThresholdReached,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioAnalysisEvent/properties/AudioAnalysisEvent-SpeechStarted.md Edit}
    
    * @private
    */
    SpeechStarted,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioAnalysisEvent/properties/AudioAnalysisEvent-KeywordDetected.md Edit}
    
    * @private
    */
    KeywordDetected
}

/**
* Used to play audio in a Lens.
* You can assign an [AudioTrackAsset](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#AudioTrackAsset) to play through script or through the AudioComponent's inspector in Lens Studio.
* See the [Playing Audio](https://lensstudio.snapchat.com/guides/audio) guide for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/AudioComponent-description.md Edit}
*/
interface AudioComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/methods/AudioComponent-channelVolume.md Edit}
    
    * @private
    */
    channelVolume(channel: number, volume: number): void
    
    /**
    * Returns whether the sound is currently paused.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/methods/AudioComponent-isPaused.md Edit}
    */
    isPaused(): boolean
    
    /**
    * Returns whether the AudioComponent is currently playing sound.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/methods/AudioComponent-isPlaying.md Edit}
    */
    isPlaying(): boolean
    
    /**
    * Pauses the sound.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/methods/AudioComponent-pause.md Edit}
    */
    pause(): boolean
    
    /**
    * Plays the current sound `loops` number of times.  If `loops` is -1, the sound will repeat forever.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/methods/AudioComponent-play.md Edit}
    */
    play(loops: number): void
    
    /**
    * Resumes a paused sound.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/methods/AudioComponent-resume.md Edit}
    */
    resume(): boolean
    
    /**
    * Sets the callback function to be called whenever this sound stops playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/methods/AudioComponent-setOnFinish.md Edit}
    */
    setOnFinish(eventCallback: (audioComponent: AudioComponent) => void): void
    
    /**
    * Stops the current sound if already playing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/methods/AudioComponent-stop.md Edit}
    */
    stop(fade: boolean): void
    
    /**
    * The audio asset currently assigned to play.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-audioTrack.md Edit}
    */
    audioTrack: AudioTrackAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-directivityEffectActive.md Edit}
    
    * @private
    */
    directivityEffectActive: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-directivityEffectShapeDecay.md Edit}
    
    * @private
    */
    directivityEffectShapeDecay: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-directivityEffectShapeFactor.md Edit}
    
    * @private
    */
    directivityEffectShapeFactor: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-distanceEffectActive.md Edit}
    
    * @private
    */
    distanceEffectActive: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-distanceEffectMaxAttenuation.md Edit}
    
    * @private
    */
    distanceEffectMaxAttenuation: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-distanceEffectMaxDistance.md Edit}
    
    * @private
    */
    distanceEffectMaxDistance: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-distanceEffectMinDistance.md Edit}
    
    * @private
    */
    distanceEffectMinDistance: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-distanceEffectType.md Edit}
    
    * @private
    */
    distanceEffectType: Audio.DistanceCurveType
    
    /**
    * The length (in seconds) of the current sound assigned to play.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-duration.md Edit}
    
    * @readonly
    */
    duration: number
    
    /**
    * Length (in seconds) of a volume fade in applied to the beginning of sound playback.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-fadeInTime.md Edit}
    */
    fadeInTime: number
    
    /**
    * Length (in seconds) of a volume fade out applied to the end of sound playback.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-fadeOutTime.md Edit}
    */
    fadeOutTime: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-mixFactor.md Edit}
    
    * @unreleased
    */
    mixFactor: number
    
    /**
    * When true, records sound directly into the snap. This mode works only when all Audio Components in the scene are using mix to snap. In this case input from microphone will be ignored.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-mixToSnap.md Edit}
    */
    mixToSnap: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-pan.md Edit}
    
    * @private
    */
    pan: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-panEffectActive.md Edit}
    
    * @private
    */
    panEffectActive: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-panEffectLevel.md Edit}
    
    * @private
    */
    panEffectLevel: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-panEffectType.md Edit}
    
    * @private
    */
    panEffectType: Audio.PanType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-playbackMode.md Edit}
    
    * @snapOsOnly
    */
    playbackMode: Audio.PlaybackMode
    
    /**
    * The current playback time in seconds
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-position.md Edit}
    */
    position: number
    
    /**
    * The volume of audio recorded to the snap, from 0 to 1.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-recordingVolume.md Edit}
    */
    recordingVolume: number
    
    /**
    * Spatial Audio settings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-spatialAudio.md Edit}
    
    * @readonly
    */
    spatialAudio: SpatialAudio
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-spatialAudioActive.md Edit}
    
    * @private
    */
    spatialAudioActive: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-streamPlayerEnabled.md Edit}
    
    * @private
    */
    streamPlayerEnabled: boolean
    
    /**
    * A volume multiplier for any sounds played by this AudioComponent.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioComponent/properties/AudioComponent-volume.md Edit}
    */
    volume: number
    
}

/**
* Configures an audio effect for [AudioEffectComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#AudioEffectComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioEffectAsset/AudioEffectAsset-description.md Edit}
*/
interface AudioEffectAsset extends Asset {
}

/**
* Used to add an audio effect to a Lens.
* When present in the scene, it will automatically apply the selected audio effect to recordings made with the Lens.
* See the [Audio Effect](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/audio/audio-effect) guide for more information.


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioEffectComponent/AudioEffectComponent-description.md Edit}
*/
interface AudioEffectComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioEffectComponent/methods/AudioEffectComponent-enablePreset.md Edit}
    
    * @deprecated
    
    * @private
    */
    enablePreset(presetName: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioEffectComponent/methods/AudioEffectComponent-getParameter.md Edit}
    
    * @private
    */
    getParameter(parameterId: string): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioEffectComponent/methods/AudioEffectComponent-setParameter.md Edit}
    
    * @private
    */
    setParameter(parameterId: string, value: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioEffectComponent/properties/AudioEffectComponent-audioEffect.md Edit}
    
    * @private
    */
    audioEffect: AudioEffectAsset
    
}

/**
* Provider for [AudioEffectAsset](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#AudioEffectAsset).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioEffectProvider/AudioEffectProvider-description.md Edit}
*/
interface AudioEffectProvider extends Provider {
}

/**
* A component that receives input from Audio Components that have Spatial Audio enabled. Calculates their positions relative to the scene object it is attached to,and properly mixes them.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioListenerComponent/AudioListenerComponent-description.md Edit}
*/
interface AudioListenerComponent extends Component {
}

/**
* Provider of the Audio Output Audio Track asset. 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioOutputProvider/AudioOutputProvider-description.md Edit}
*/
interface AudioOutputProvider extends AudioTrackProvider {
    /**
    * Enqueue audio data into an audio playback system.
    
    * `shape.x` - buffer size, must be less or equal to `audioFrame` length.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioOutputProvider/methods/AudioOutputProvider-enqueueAudioFrame.md Edit}
    */
    enqueueAudioFrame(audioFrame: Float32Array, inShape: vec3): void
    
    /**
    * Preferred size for audio output at the current frame update.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioOutputProvider/methods/AudioOutputProvider-getPreferredFrameSize.md Edit}
    */
    getPreferredFrameSize(): number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/AudioSystem-description.md Edit}

* @private
*/
interface AudioSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/methods/AudioSystem-load.md Edit}
    
    * @private
    */
    load(audioTrack: AudioTrackAsset): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/methods/AudioSystem-pause.md Edit}
    
    * @private
    */
    pause(soundId: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/methods/AudioSystem-play.md Edit}
    
    * @private
    */
    play(soundId: number, loops: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/methods/AudioSystem-resume.md Edit}
    
    * @private
    */
    resume(soundId: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/methods/AudioSystem-stop.md Edit}
    
    * @private
    */
    stop(soundId: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/methods/AudioSystem-suspend.md Edit}
    
    * @private
    */
    suspend(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/methods/AudioSystem-unload.md Edit}
    
    * @private
    */
    unload(soundId: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/methods/AudioSystem-unsuspend.md Edit}
    
    * @private
    */
    unsuspend(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/properties/AudioSystem-isHeadphones.md Edit}
    
    * @readonly
    
    * @private
    */
    isHeadphones: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioSystem/properties/AudioSystem-systemVolume.md Edit}
    
    * @private
    */
    systemVolume: number
    
}

/**
* Represents an audio file asset.
* See also: [AudioComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#AudioComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTrackAsset/AudioTrackAsset-description.md Edit}
*/
interface AudioTrackAsset extends Asset {
    /**
    * The provider for this audio track asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTrackAsset/properties/AudioTrackAsset-control.md Edit}
    */
    control: AudioTrackProvider
    
}

/**
* Base class for Audio Track providers.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTrackProvider/AudioTrackProvider-description.md Edit}
*/
interface AudioTrackProvider extends Provider {
    /**
    * The maximum frame size of the audio track asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTrackProvider/properties/AudioTrackProvider-maxFrameSize.md Edit}
    
    * @readonly
    */
    maxFrameSize: number
    
    /**
    * Sample rate (samples per second) of the audio track asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTrackProvider/properties/AudioTrackProvider-sampleRate.md Edit}
    */
    sampleRate: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTriggerComponent/AudioTriggerComponent-description.md Edit}

* @private
*/
interface AudioTriggerComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTriggerComponent/methods/AudioTriggerComponent-addEvent.md Edit}
    
    * @private
    */
    addEvent(event: AudioAnalysisEvent, value: number, callback: () => any, keyword: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTriggerComponent/methods/AudioTriggerComponent-addKeyword.md Edit}
    
    * @private
    */
    addKeyword(keyword: string, threshold: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTriggerComponent/methods/AudioTriggerComponent-clearEvents.md Edit}
    
    * @private
    */
    clearEvents(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/AudioTriggerComponent/properties/AudioTriggerComponent-modelPath.md Edit}
    
    * @private
    */
    modelPath: BinAsset
    
}

/**
* Cardinal axis enumeration.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Axis/Axis-description.md Edit}
*/
declare enum Axis {
    /**
    * The X axis.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Axis/properties/Axis-X.md Edit}
    */
    X,
    /**
    * The Y axis.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Axis/properties/Axis-Y.md Edit}
    */
    Y,
    /**
    * The Z axis.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Axis/properties/Axis-Z.md Edit}
    */
    Z
}

/**
* Settings for rendering the background on a [Text](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Text) component.
* Accessible through the [Text](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Text) component's `backgroundSettings` property.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BackgroundSettings/BackgroundSettings-description.md Edit}
*/
interface BackgroundSettings extends ScriptObject {
    /**
    * Controls how rounded the corner of the background should be.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BackgroundSettings/properties/BackgroundSettings-cornerRadius.md Edit}
    */
    cornerRadius: number
    
    /**
    * If enabled, the background will be rendered.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BackgroundSettings/properties/BackgroundSettings-enabled.md Edit}
    */
    enabled: boolean
    
    /**
    * Settings for how the inside of the background is drawn.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BackgroundSettings/properties/BackgroundSettings-fill.md Edit}
    */
    fill: TextFill
    
    /**
    * Controls how far in each direction the background should extend away from the text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BackgroundSettings/properties/BackgroundSettings-margins.md Edit}
    */
    margins: Rect
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Base64/Base64-description.md Edit}

* @private
*/
interface Base64 {
}
declare namespace Base64 {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Base64/methods/Base64-decode.md Edit}
    
    * @private
    */
    export function decode(value: string): Uint8Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Base64/methods/Base64-decodeTextureAsync.md Edit}
    
    * @private
    */
    export function decodeTextureAsync(value: string, onSuccess: (decodedTexture: Texture) => void, onFailure: () => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Base64/methods/Base64-encode.md Edit}
    
    * @private
    */
    export function encode(data: Uint8Array): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Base64/methods/Base64-encodeTextureAsync.md Edit}
    
    * @private
    */
    export function encodeTextureAsync(texture: Texture, onSuccess: (encodedTexture: string) => void, onFailure: () => void, compressionQuality: CompressionQuality, encodingType: EncodingType): void
    

}

/**
* The base class for all mesh rendering components.
* Comparable to the former class "MeshVisual", which was split into the classes:
* [BaseMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#BaseMeshVisual),
* [MaterialMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#MaterialMeshVisual),
* and [RenderMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#RenderMeshVisual).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/BaseMeshVisual-description.md Edit}
*/
interface BaseMeshVisual extends Visual {
    /**
    * Range maximum of the local-space axis-aligned bounding box (AABB) of the visual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/methods/BaseMeshVisual-localAabbMax.md Edit}
    */
    localAabbMax(): vec3
    
    /**
    * Range minimum of the local-space axis-aligned bounding box (AABB) of the visual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/methods/BaseMeshVisual-localAabbMin.md Edit}
    */
    localAabbMin(): vec3
    
    /**
    * Projects screen positions from `camera`'s view onto the mesh's UVs.
    * If the MeshVisual's material uses the same texture as the camera input, the MeshVisual will look identical to the part of the screen it covers.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/methods/BaseMeshVisual-snap.md Edit}
    */
    snap(camera: Camera): void
    
    /**
    * Range maximum of the world-space axis-aligned bounding box (AABB) of the visual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/methods/BaseMeshVisual-worldAabbMax.md Edit}
    */
    worldAabbMax(): vec3
    
    /**
    * Range minimum of the world-space axis-aligned bounding box (AABB) of the visual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/methods/BaseMeshVisual-worldAabbMin.md Edit}
    */
    worldAabbMin(): vec3
    
    /**
    * When a [ScreenTransform](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ScreenTransform) is present on this SceneObject,
    * and `extentsTarget` is a child of this SceneObject, `extentsTarget` will be repositioned to match the exact
    * area this MeshVisual is being rendered. Very useful for [Image](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Image) and [Text](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Text) components.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/properties/BaseMeshVisual-extentsTarget.md Edit}
    */
    extentsTarget: ScreenTransform
    
    /**
    * When a [ScreenTransform](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ScreenTransform) is attached to the same SceneObject, this controls how the mesh will be positioned horizontally depending on `stretchMode`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/properties/BaseMeshVisual-horizontalAlignment.md Edit}
    */
    horizontalAlignment: HorizontalAlignment
    
    /**
    * None = 0, Caster = 1, Receiver = 2
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/properties/BaseMeshVisual-meshShadowMode.md Edit}
    */
    meshShadowMode: MeshShadowMode
    
    /**
    * Affects the color of shadows being cast by this MeshVisual. The color of the cast shadow is a mix between shadowColor and the material's base texture color. The alpha value of shadowColor controls the mixing of these two colors, with 0 = shadowColor and 1 = shadowColor * textureColor.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/properties/BaseMeshVisual-shadowColor.md Edit}
    */
    shadowColor: vec4
    
    /**
    * Density of shadows cast by this MeshVisual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/properties/BaseMeshVisual-shadowDensity.md Edit}
    */
    shadowDensity: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/properties/BaseMeshVisual-ssaoMode.md Edit}
    
    * @private
    */
    ssaoMode: SSAO.MeshMode
    
    /**
    * When a [ScreenTransform](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ScreenTransform) is attached to the same SceneObject, this controls how the mesh will be stretched relative to the ScreenTransform's boundaries.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/properties/BaseMeshVisual-stretchMode.md Edit}
    */
    stretchMode: StretchMode
    
    /**
    * When a [ScreenTransform](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ScreenTransform) is attached to the same SceneObject, this controls how the mesh will be positioned vertically depending on `stretchMode`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMeshVisual/properties/BaseMeshVisual-verticalAlignment.md Edit}
    */
    verticalAlignment: VerticalAlignment
    
}

/**
* Base class for MultiplayerSession options. This class is not used directly - use ConnectedLensSessionOptions instead.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/BaseMultiplayerSessionOptions-description.md Edit}
*/
interface BaseMultiplayerSessionOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-experienceId.md Edit}
    
    * @private
    */
    experienceId: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-host.md Edit}
    
    * @private
    */
    host: string
    
    /**
    * Provides a single host for every session. Useful when an experience has a single authority. This should not be used in latency sensitive situations. The creator of the session will by default be the host. If the host leaves, thee server will determine a new host and transfer all ownership of entities owned by the original host. Use with `onHostUpdated` API to get a callback.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-hostManagementEnabled.md Edit}
    */
    hostManagementEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-isRealtime.md Edit}
    
    * @private
    */
    isRealtime: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-managedByHost.md Edit}
    
    * @deprecated
    
    * @private
    */
    managedByHost: boolean
    
    /**
    * Function to be called when a connection to the realtime backend is established. All realtime requests can be called after this callback. When you invite others to join, a new session will be created, hence you should update your session handler with the argument passed in this callback.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onConnected.md Edit}
    */
    onConnected: (session: MultiplayerSession, connectionInfo: ConnectedLensModule.ConnectionInfo) => void
    
    /**
    * Function to be called when the connection to the realtime backend is lost, either via successful disconnect or passive disconnect due to error.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onDisconnected.md Edit}
    */
    onDisconnected: (session: MultiplayerSession, disconnectInfo: string) => void
    
    /**
    * Function to be called when an error occurs in the session life cycle.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onError.md Edit}
    */
    onError: (session: MultiplayerSession, code: string, description: string) => void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onHostUpdated.md Edit}
    */
    onHostUpdated: (session: MultiplayerSession, removalInfo: ConnectedLensModule.HostUpdateInfo) => void
    
    /**
    * Function to be called when a string-based message sent by sendMessage() is received from another user via the realtime backend.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onMessageReceived.md Edit}
    */
    onMessageReceived: (session: MultiplayerSession, userId: string, message: string, senderInfo: ConnectedLensModule.UserInfo) => void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onMessageReceivedBytes.md Edit}
    
    * @private
    */
    onMessageReceivedBytes: (session: MultiplayerSession, userId: string, message: number[], senderInfo: ConnectedLensModule.UserInfo) => void
    
    /**
    * Callback function that will be executed when a realtime store is created.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onRealtimeStoreCreated.md Edit}
    */
    onRealtimeStoreCreated: (session: MultiplayerSession, store: GeneralDataStore, ownerInfo: ConnectedLensModule.UserInfo, creationInfo: ConnectedLensModule.RealtimeStoreCreationInfo) => void
    
    /**
    * Callback function that will be executed when a realtime store is deleted.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onRealtimeStoreDeleted.md Edit}
    */
    onRealtimeStoreDeleted: (session: MultiplayerSession, store: GeneralDataStore, deleteInfo: ConnectedLensModule.RealtimeStoreDeleteInfo) => void
    
    /**
    * Function to be called when a key is removed from a RealtimeStore.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onRealtimeStoreKeyRemoved.md Edit}
    */
    onRealtimeStoreKeyRemoved: (session: MultiplayerSession, removalInfo: ConnectedLensModule.RealtimeStoreKeyRemovalInfo) => void
    
    /**
    * Callback function that will be executed when ownership of a realtime store is updated.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onRealtimeStoreOwnershipUpdated.md Edit}
    */
    onRealtimeStoreOwnershipUpdated: (session: MultiplayerSession, store: GeneralDataStore, ownerInfo: ConnectedLensModule.UserInfo, ownershipUpdateInfo: ConnectedLensModule.RealtimeStoreOwnershipUpdateInfo) => void
    
    /**
    * Callback function that will be executed when a realtime store is updated.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onRealtimeStoreUpdated.md Edit}
    */
    onRealtimeStoreUpdated: (session: MultiplayerSession, store: GeneralDataStore, key: string, updateInfo: ConnectedLensModule.RealtimeStoreUpdateInfo) => void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onStartedStreamingVideo.md Edit}
    
    * @private
    */
    onStartedStreamingVideo: (session: MultiplayerSession) => void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onStoppedStreamingVideo.md Edit}
    
    * @private
    */
    onStoppedStreamingVideo: (session: MultiplayerSession) => void
    
    /**
    * Function to be called when another user joins the session. When joining a session, the current user will get a callback for each of the existing active users in the current session. This way you can build a list of existing players in game.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onUserJoinedSession.md Edit}
    */
    onUserJoinedSession: (session: MultiplayerSession, userInfo: ConnectedLensModule.UserInfo) => void
    
    /**
    * Function to be called when another user leaves the session, either deliberately or via passive disconnect due to error.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onUserLeftSession.md Edit}
    */
    onUserLeftSession: (session: MultiplayerSession, userInfo: ConnectedLensModule.UserInfo) => void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onUserStartedStreamingVideo.md Edit}
    
    * @private
    */
    onUserStartedStreamingVideo: (session: MultiplayerSession, userInfo: ConnectedLensModule.UserInfo, texture: Texture) => void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseMultiplayerSessionOptions/properties/BaseMultiplayerSessionOptions-onUserStoppedStreamingVideo.md Edit}
    
    * @private
    */
    onUserStoppedStreamingVideo: (session: MultiplayerSession, userInfo: ConnectedLensModule.UserInfo) => void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseNeuralFaceEffectTextureProvider/BaseNeuralFaceEffectTextureProvider-description.md Edit}

* @private
*/
interface BaseNeuralFaceEffectTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseNeuralFaceEffectTextureProvider/methods/BaseNeuralFaceEffectTextureProvider-setLoadingFinishedCallback.md Edit}
    
    * @private
    */
    setLoadingFinishedCallback(callback: () => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseNeuralFaceEffectTextureProvider/methods/BaseNeuralFaceEffectTextureProvider-setTexture.md Edit}
    
    * @private
    */
    setTexture(name: string, feature: Texture): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseNeuralFaceEffectTextureProvider/methods/BaseNeuralFaceEffectTextureProvider-setTypedArray.md Edit}
    
    * @private
    */
    setTypedArray(name: string, feature: Float32Array): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseNeuralFaceEffectTextureProvider/properties/BaseNeuralFaceEffectTextureProvider-asyncLoad.md Edit}
    
    * @private
    */
    asyncLoad: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseNeuralFaceEffectTextureProvider/properties/BaseNeuralFaceEffectTextureProvider-input.md Edit}
    
    * @private
    */
    input: Texture
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseNeuralFaceEffectTextureProvider/properties/BaseNeuralFaceEffectTextureProvider-model.md Edit}
    
    * @private
    */
    model: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BaseNeuralFaceEffectTextureProvider/properties/BaseNeuralFaceEffectTextureProvider-paused.md Edit}
    
    * @private
    */
    paused: boolean
    
}

/**
* Base class for Input and Output Placeholders used by MLComponent.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasePlaceholder/BasePlaceholder-description.md Edit}
*/
interface BasePlaceholder extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasePlaceholder/properties/BasePlaceholder-dataLayout.md Edit}
    
    * @private
    */
    dataLayout: MachineLearning.DataLayout
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasePlaceholder/properties/BasePlaceholder-internalDataLayout.md Edit}
    
    * @readonly
    
    * @private
    */
    internalDataLayout: MachineLearning.DataLayout
    
    /**
    * The name of the Placeholder.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasePlaceholder/properties/BasePlaceholder-name.md Edit}
    
    * @readonly
    */
    name: string
    
    /**
    * The shape of the Placeholder's data.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasePlaceholder/properties/BasePlaceholder-shape.md Edit}
    
    * @readonly
    */
    shape: vec3
    
    /**
    * Transformer object for applying transformations on the PlaceHolder's data.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasePlaceholder/properties/BasePlaceholder-transformer.md Edit}
    
    * @readonly
    */
    transformer: Transformer
    
}

/**
* Provides basic information about a transformation.
* See also: [DeviceTracking](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#DeviceTracking)

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasicTransform/BasicTransform-description.md Edit}
*/
interface BasicTransform extends ScriptObject {
    /**
    * Returns the inverted world matrix of the BasicTransform.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasicTransform/methods/BasicTransform-getInvertedMatrix.md Edit}
    */
    getInvertedMatrix(): mat4
    
    /**
    * Returns the world matrix of the BasicTransform.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasicTransform/methods/BasicTransform-getMatrix.md Edit}
    */
    getMatrix(): mat4
    
    /**
    * Returns the world position of the BasicTransform.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasicTransform/methods/BasicTransform-getPosition.md Edit}
    */
    getPosition(): vec3
    
    /**
    * Returns the world rotation of the BasicTransform.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasicTransform/methods/BasicTransform-getRotation.md Edit}
    */
    getRotation(): quat
    
    /**
    * Returns the world scale of the BasicTransform.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BasicTransform/methods/BasicTransform-getScale.md Edit}
    */
    getScale(): vec3
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BillboardVisual/BillboardVisual-description.md Edit}

* @deprecated

* @private
*/
interface BillboardVisual extends MaterialMeshVisual {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BillboardVisual/properties/BillboardVisual-fillMode.md Edit}
    
    * @private
    */
    fillMode: TextureStretchMode
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BillboardVisual/properties/BillboardVisual-flipX.md Edit}
    
    * @private
    */
    flipX: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BillboardVisual/properties/BillboardVisual-flipY.md Edit}
    
    * @private
    */
    flipY: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BillboardVisual/properties/BillboardVisual-pivot.md Edit}
    
    * @private
    */
    pivot: vec2
    
}

/**
* File based asset.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BinAsset/BinAsset-description.md Edit}
*/
interface BinAsset extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BinAsset/methods/BinAsset-readText.md Edit}
    
    * @private
    */
    readText(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BinAsset/properties/BinAsset-control.md Edit}
    
    * @private
    */
    control: BinFileProvider
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BinFileProvider/BinFileProvider-description.md Edit}

* @unreleased
*/
interface BinFileProvider extends Provider {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmapGlyph/BitmapGlyph-description.md Edit}

* @private
*/
interface BitmapGlyph extends Glyph {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmapGlyph/methods/BitmapGlyph-createTexture.md Edit}
    
    * @private
    */
    createTexture(): Texture
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji2DOptions/Bitmoji2DOptions-description.md Edit}
*/
interface Bitmoji2DOptions extends ScriptObject {
    /**
    * The pose id for the 2D Bitmoji.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji2DOptions/properties/Bitmoji2DOptions-poseId.md Edit}
    */
    poseId: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji2DOptions/properties/Bitmoji2DOptions-user.md Edit}
    */
    user: SnapchatUser
    
}
declare namespace Bitmoji2DOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji2DOptions/methods/Bitmoji2DOptions-create.md Edit}
    */
    export function create(): Bitmoji2DOptions
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji2DResource/Bitmoji2DResource-description.md Edit}
*/
interface Bitmoji2DResource extends DynamicResource {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji3DOptions/Bitmoji3DOptions-description.md Edit}
*/
interface Bitmoji3DOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji3DOptions/properties/Bitmoji3DOptions-parameters.md Edit}
    
    * @private
    */
    parameters: object
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji3DOptions/properties/Bitmoji3DOptions-user.md Edit}
    */
    user: SnapchatUser
    
}
declare namespace Bitmoji3DOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji3DOptions/methods/Bitmoji3DOptions-create.md Edit}
    */
    export function create(): Bitmoji3DOptions
    

}

/**
* Provides information about the current user's 3D Bitmoji avatar to be downloaded via the RemoteMediaModule.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji3DResource/Bitmoji3DResource-description.md Edit}
*/
interface Bitmoji3DResource extends DynamicResource {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji3DResource/properties/Bitmoji3DResource-assetId.md Edit}
    
    * @readonly
    
    * @private
    */
    assetId: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Bitmoji3DResource/properties/Bitmoji3DResource-parameters.md Edit}
    
    * @readonly
    
    * @private
    */
    parameters: object
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiAliasIds/BitmojiAliasIds-description.md Edit}

* @private
*/
interface BitmojiAliasIds {
}
declare namespace BitmojiAliasIds {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiAliasIds/properties/BitmojiAliasIds-CurrentUserAvatarId.md Edit}
    
    * @deprecated
    
    * @private
    */
    let CurrentUserAvatarId: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiAliasIds/properties/BitmojiAliasIds-DefaultFriendAvatarId.md Edit}
    
    * @deprecated
    
    * @private
    */
    let DefaultFriendAvatarId: number
    

}

/**
* Provides access to getting information about the current user's Bitmoji.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiModule/BitmojiModule-description.md Edit}
*/
interface BitmojiModule extends Asset {
    /**
    * Retrieve a handle representing the Bitmoji model for the given user. This can be passed to `RemoteMediaModule` for download.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiModule/methods/BitmojiModule-createBitmoji3DResourceForUser.md Edit}
    
    * @private
    */
    createBitmoji3DResourceForUser(user: SnapchatUser): Bitmoji3DResource
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiModule/methods/BitmojiModule-createBitmoji3DResourceForUserWithParams.md Edit}
    
    * @private
    */
    createBitmoji3DResourceForUserWithParams(user: SnapchatUser, params: object): Bitmoji3DResource
    
    /**
    * Returns a `DynamicResource` via the provided `callback`, which can be resolved into a texture using `RemoteMediaModule`. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiModule/methods/BitmojiModule-requestBitmoji2DResource.md Edit}
    */
    requestBitmoji2DResource(options: Bitmoji2DOptions, callback: (resource: Bitmoji2DResource) => void): void
    
    /**
    * Request the current user's 3D Bitmoji avatar.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiModule/methods/BitmojiModule-requestBitmoji3DResource.md Edit}
    */
    requestBitmoji3DResource(callback: (resource: Bitmoji3DResource) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiModule/methods/BitmojiModule-requestBitmoji3DResourceWithOptions.md Edit}
    */
    requestBitmoji3DResourceWithOptions(options: Bitmoji3DOptions, callback: (resource: Bitmoji3DResource) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiModule/methods/BitmojiModule-requestBitmoji3DResourceWithParams.md Edit}
    
    * @private
    */
    requestBitmoji3DResourceWithParams(params: object, callback: (resource: Bitmoji3DResource) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiModule/properties/BitmojiModule-fallbackAvatarId.md Edit}
    
    * @private
    */
    fallbackAvatarId: string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiStickerType/BitmojiStickerType-description.md Edit}

* @private
*/
declare enum BitmojiStickerType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiStickerType/properties/BitmojiStickerType-Bitmoji.md Edit}
    
    * @private
    */
    Bitmoji,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiStickerType/properties/BitmojiStickerType-FriendMoji.md Edit}
    
    * @private
    */
    FriendMoji
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiSystem/BitmojiSystem-description.md Edit}

* @deprecated

* @private
*/
interface BitmojiSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiSystem/methods/BitmojiSystem-getSelfieId.md Edit}
    
    * @deprecated
    
    * @private
    */
    getSelfieId(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiSystem/methods/BitmojiSystem-initialize.md Edit}
    
    * @deprecated
    
    * @private
    */
    initialize(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiSystem/methods/BitmojiSystem-isBitmojiAvailable.md Edit}
    
    * @deprecated
    
    * @private
    */
    isBitmojiAvailable(bitmojiAliasId: number): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiSystem/methods/BitmojiSystem-loadBitmoji.md Edit}
    
    * @deprecated
    
    * @private
    */
    loadBitmoji(bitmojiId: string, bitmojiAliasId: number, callback: (texture: Texture) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiSystem/methods/BitmojiSystem-loadBitmojiSelfieForUser.md Edit}
    
    * @deprecated
    
    * @private
    */
    loadBitmojiSelfieForUser(user: SnapchatUser, onLoaded: (texture: Texture) => void, onFailure: (error: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiSystem/methods/BitmojiSystem-loadFriendmoji.md Edit}
    
    * @deprecated
    
    * @private
    */
    loadFriendmoji(bitmojiId: string, friendAliasId: number, callback: (texture: Texture) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiSystem/properties/BitmojiSystem-redirectToBitmojiApp.md Edit}
    
    * @deprecated
    
    * @private
    */
    redirectToBitmojiApp: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiTextureProvider/BitmojiTextureProvider-description.md Edit}

* @private
*/
interface BitmojiTextureProvider extends TextureProvider {
    /**
    * Configures which user object is associated with the Bitmoji resource.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiTextureProvider/methods/BitmojiTextureProvider-setUser.md Edit}
    
    * @private
    */
    setUser(user: SnapchatUser): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiTextureProvider/properties/BitmojiTextureProvider-defaultTexture.md Edit}
    
    * @private
    */
    defaultTexture: Texture
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiTextureProvider/properties/BitmojiTextureProvider-friendAliasId.md Edit}
    
    * @private
    */
    friendAliasId: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiTextureProvider/properties/BitmojiTextureProvider-stickerId.md Edit}
    
    * @private
    */
    stickerId: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiTextureProvider/properties/BitmojiTextureProvider-stickerType.md Edit}
    
    * @private
    */
    stickerType: BitmojiStickerType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BitmojiTextureProvider/properties/BitmojiTextureProvider-userAliasId.md Edit}
    
    * @private
    */
    userAliasId: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/BlendFactor-description.md Edit}

* @private
*/
declare enum BlendFactor {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-Zero.md Edit}
    
    * @private
    */
    Zero,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-One.md Edit}
    
    * @private
    */
    One,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-SourceColor.md Edit}
    
    * @private
    */
    SourceColor,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-OneMinusSourceColor.md Edit}
    
    * @private
    */
    OneMinusSourceColor,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-DestinationColor.md Edit}
    
    * @private
    */
    DestinationColor,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-OneMinusDestinationColor.md Edit}
    
    * @private
    */
    OneMinusDestinationColor,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-SourceAlpha.md Edit}
    
    * @private
    */
    SourceAlpha,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-OneMinusSourceAlpha.md Edit}
    
    * @private
    */
    OneMinusSourceAlpha,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-DestinationAlpha.md Edit}
    
    * @private
    */
    DestinationAlpha,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-OneMinusDestinationAlpha.md Edit}
    
    * @private
    */
    OneMinusDestinationAlpha,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-ConstantColor.md Edit}
    
    * @private
    */
    ConstantColor,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-OneMinusConstantColor.md Edit}
    
    * @private
    */
    OneMinusConstantColor,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-ConstantAlpha.md Edit}
    
    * @private
    */
    ConstantAlpha,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-OneMinusConstantAlpha.md Edit}
    
    * @private
    */
    OneMinusConstantAlpha,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendFactor/properties/BlendFactor-SourceAlphaSaturated.md Edit}
    
    * @private
    */
    SourceAlphaSaturated
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/BlendMode-description.md Edit}
*/
declare enum BlendMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Normal.md Edit}
    */
    Normal,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-MultiplyLegacy.md Edit}
    
    * @deprecated
    */
    MultiplyLegacy,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-AddLegacy.md Edit}
    
    * @deprecated
    */
    AddLegacy,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Screen.md Edit}
    */
    Screen,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-PremultipliedAlpha.md Edit}
    */
    PremultipliedAlpha,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-AlphaToCoverage.md Edit}
    */
    AlphaToCoverage,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Disabled.md Edit}
    */
    Disabled,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Add.md Edit}
    */
    Add,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-AlphaTest.md Edit}
    */
    AlphaTest,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-ColoredGlass.md Edit}
    */
    ColoredGlass,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Multiply.md Edit}
    */
    Multiply,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Min.md Edit}
    */
    Min,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Max.md Edit}
    */
    Max,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Software.md Edit}
    */
    Software,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-PremultipliedAlphaHardware.md Edit}
    */
    PremultipliedAlphaHardware,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-Hardware.md Edit}
    */
    Hardware,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendMode/properties/BlendMode-PremultipliedAlphaAuto.md Edit}
    */
    PremultipliedAlphaAuto
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendOperation/BlendOperation-description.md Edit}

* @private
*/
declare enum BlendOperation {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendOperation/properties/BlendOperation-Add.md Edit}
    
    * @private
    */
    Add,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendOperation/properties/BlendOperation-Subtract.md Edit}
    
    * @private
    */
    Subtract,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendOperation/properties/BlendOperation-ReverseSubtract.md Edit}
    
    * @private
    */
    ReverseSubtract,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendOperation/properties/BlendOperation-Min.md Edit}
    
    * @private
    */
    Min,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendOperation/properties/BlendOperation-Max.md Edit}
    
    * @private
    */
    Max
}

/**
* Controls blend shapes connected to imported animation content.

* Note: this class has been deprecated. Please use the blend shapes functions in [RenderMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#RenderMeshVisual).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendShapes/BlendShapes-description.md Edit}

* @deprecated
*/
interface BlendShapes extends Component {
    /**
    * Removes all blend shapes from the BlendShapesVisual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendShapes/methods/BlendShapes-clearBlendShapes.md Edit}
    */
    clearBlendShapes(): void
    
    /**
    * Returns the weight of blend shape `name`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendShapes/methods/BlendShapes-getBlendShape.md Edit}
    */
    getBlendShape(name: string): number
    
    /**
    * Returns whether this BlendShapesVisual has a blend shape named `name`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendShapes/methods/BlendShapes-hasBlendShape.md Edit}
    */
    hasBlendShape(name: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendShapes/methods/BlendShapes-isNormalBlended.md Edit}
    
    * @private
    */
    isNormalBlended(): boolean
    
    /**
    * Sets the weight of blend shape `name`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendShapes/methods/BlendShapes-setBlendShape.md Edit}
    */
    setBlendShape(name: string, weight: number): void
    
    /**
    * Clears the blendshape with the matching name from the BlendShapes component.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendShapes/methods/BlendShapes-unsetBlendShape.md Edit}
    */
    unsetBlendShape(name: string): void
    
    /**
    * If enabled, normal directions are also blended by blend shapes.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendShapes/properties/BlendShapes-blendNormals.md Edit}
    */
    blendNormals: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/BlendState-description.md Edit}

* @private
*/
interface BlendState extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-getAlphaOperation.md Edit}
    
    * @private
    */
    getAlphaOperation(colorAttachmentIndex: number): BlendOperation
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-getDestinationAlphaFactor.md Edit}
    
    * @private
    */
    getDestinationAlphaFactor(colorAttachmentIndex: number): BlendFactor
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-getDestinationRgbFactor.md Edit}
    
    * @private
    */
    getDestinationRgbFactor(colorAttachmentIndex: number): BlendFactor
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-getEnabled.md Edit}
    
    * @private
    */
    getEnabled(colorAttachmentIndex: number): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-getRgbOperation.md Edit}
    
    * @private
    */
    getRgbOperation(colorAttachmentIndex: number): BlendOperation
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-getSourceAlphaFactor.md Edit}
    
    * @private
    */
    getSourceAlphaFactor(colorAttachmentIndex: number): BlendFactor
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-getSourceRgbFactor.md Edit}
    
    * @private
    */
    getSourceRgbFactor(colorAttachmentIndex: number): BlendFactor
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-setAlphaOperation.md Edit}
    
    * @private
    */
    setAlphaOperation(colorAttachmentIndex: number, value: BlendOperation): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-setDestinationAlphaFactor.md Edit}
    
    * @private
    */
    setDestinationAlphaFactor(colorAttachmentIndex: number, value: BlendFactor): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-setDestinationRgbFactor.md Edit}
    
    * @private
    */
    setDestinationRgbFactor(colorAttachmentIndex: number, value: BlendFactor): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-setEnabled.md Edit}
    
    * @private
    */
    setEnabled(colorAttachmentIndex: number, value: boolean): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-setRgbOperation.md Edit}
    
    * @private
    */
    setRgbOperation(colorAttachmentIndex: number, value: BlendOperation): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-setSourceAlphaFactor.md Edit}
    
    * @private
    */
    setSourceAlphaFactor(colorAttachmentIndex: number, value: BlendFactor): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/methods/BlendState-setSourceRgbFactor.md Edit}
    
    * @private
    */
    setSourceRgbFactor(colorAttachmentIndex: number, value: BlendFactor): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-alphaOperation.md Edit}
    
    * @private
    */
    alphaOperation: BlendOperation
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-alphaToCoverageEnabled.md Edit}
    
    * @private
    */
    alphaToCoverageEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-blendMode.md Edit}
    
    * @private
    */
    blendMode: BlendMode
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-colorAttachmentCount.md Edit}
    
    * @readonly
    
    * @private
    */
    colorAttachmentCount: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-constantColor.md Edit}
    
    * @private
    */
    constantColor: vec4
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-destinationAlphaFactor.md Edit}
    
    * @private
    */
    destinationAlphaFactor: BlendFactor
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-destinationRgbFactor.md Edit}
    
    * @private
    */
    destinationRgbFactor: BlendFactor
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-enabled.md Edit}
    
    * @private
    */
    enabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-indexedBlendingEnabled.md Edit}
    
    * @private
    */
    indexedBlendingEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-indexedBlendingSupported.md Edit}
    
    * @readonly
    
    * @private
    */
    indexedBlendingSupported: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-rgbOperation.md Edit}
    
    * @private
    */
    rgbOperation: BlendOperation
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-sourceAlphaFactor.md Edit}
    
    * @private
    */
    sourceAlphaFactor: BlendFactor
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlendState/properties/BlendState-sourceRgbFactor.md Edit}
    
    * @private
    */
    sourceRgbFactor: BlendFactor
    
}

/**
* Used to analyze the camera input and apply similar image artifacts to your AR objects in order to allow it to blend and match the real world better.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BlurNoiseEstimation/BlurNoiseEstimation-description.md Edit}
*/
interface BlurNoiseEstimation extends Component {
}

/**
* Derived from ColliderComponent, attaching this to a SceneObject turns it into a dynamic rigid-body that is automatically moved by the physics simulation in response to gravity, collisions, and other forces.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/BodyComponent-description.md Edit}
*/
interface BodyComponent extends ColliderComponent {
    /**
    * Apply linear force at the object's center-of-mass.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/methods/BodyComponent-addForce.md Edit}
    */
    addForce(force: vec3, mode: Physics.ForceMode): void
    
    /**
    * Apply force at a point offset from the object's origin, effectively generating torque.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/methods/BodyComponent-addForceAt.md Edit}
    */
    addForceAt(force: vec3, offset: vec3, mode: Physics.ForceMode): void
    
    /**
    * Add a point constraint between this body and the given collider, at the given position. `target` is optional. If null, it is statically constrained to the world.   This is a convenience function that creates a child SceneObject with a ConstraintComponent, and sets its type, target, and constraint parameters. To fully remove the constraint, its SceneObject must be removed - not the component. Call `removeConstraint()` to do this.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/methods/BodyComponent-addPointConstraint.md Edit}
    */
    addPointConstraint(target: ColliderComponent, position: vec3): ConstraintComponent
    
    /**
    * Relative to local rotation, apply linear force at the object's center-of-mass.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/methods/BodyComponent-addRelativeForce.md Edit}
    */
    addRelativeForce(force: vec3, mode: Physics.ForceMode): void
    
    /**
    * Relative to local rotation, apply force at a point offset from the object's origin, effectively generating torque.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/methods/BodyComponent-addRelativeForceAt.md Edit}
    */
    addRelativeForceAt(force: vec3, position: vec3, mode: Physics.ForceMode): void
    
    /**
    * Relative to local rotation, apply torque (angular force).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/methods/BodyComponent-addRelativeTorque.md Edit}
    */
    addRelativeTorque(torque: vec3, mode: Physics.ForceMode): void
    
    /**
    * Apply torque (angular force).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/methods/BodyComponent-addTorque.md Edit}
    */
    addTorque(torque: vec3, mode: Physics.ForceMode): void
    
    /**
    * Removes a constraint that was added with one of the `add*Constraint()` functions.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/methods/BodyComponent-removeConstraint.md Edit}
    */
    removeConstraint(constraint: ConstraintComponent): void
    
    /**
    * Damping applied to angular velocity, in the range 0.0 (no damping) to 1.0 (maximum damping).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/properties/BodyComponent-angularDamping.md Edit}
    */
    angularDamping: number
    
    /**
    * Damping applied to linear velocity, in the range 0.0 (no damping) to 1.0 (maximum damping). This produces an effect similar to drag in that it causes the object to slow down over time. It is not however physically accurate, and it doesn't take into account surface area or mass.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/properties/BodyComponent-damping.md Edit}
    */
    damping: number
    
    /**
    * Density (kg/L) of the object, used to derive mass from volume. If modified, mass changes according to shape and scale.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/properties/BodyComponent-density.md Edit}
    */
    density: number
    
    /**
    * If enabled, the body is dynamically simulated, such that it responds to forces and collisions. Otherwise, it acts as a static collider, functionally equivalent to Physics.ColliderComponent.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/properties/BodyComponent-dynamic.md Edit}
    */
    dynamic: boolean
    
    /**
    * Mass (kg) of the object. If modified from this field, mass is constant irrespective of shape and scale.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyComponent/properties/BodyComponent-mass.md Edit}
    */
    mass: number
    
}

/**
* Provides depth values of the tracked body encoded as D24_UNORM_S8_UINT in screen resolution. Depth is normalized between 0-1, and the stencil component is ignored. The values may be remapped from normalized units (0 to 1) to negative centimeters from the camera (-near in cm to -far in cm) using the `Depth Map` mode of the `Texture 2D Sample` node in Material Editor.


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyDepthTextureProvider/BodyDepthTextureProvider-description.md Edit}
*/
interface BodyDepthTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyDepthTextureProvider/properties/BodyDepthTextureProvider-annotatorOptionsAsset.md Edit}
    
    * @private
    */
    annotatorOptionsAsset: BinAsset
    
    /**
    * The index of the body to track. The first body detected is `0`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyDepthTextureProvider/properties/BodyDepthTextureProvider-bodyIndex.md Edit}
    */
    bodyIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyDepthTextureProvider/properties/BodyDepthTextureProvider-bodyModel.md Edit}
    
    * @private
    */
    bodyModel: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyDepthTextureProvider/properties/BodyDepthTextureProvider-depthNormalsUVModel.md Edit}
    
    * @private
    */
    depthNormalsUVModel: BinAsset
    
    /**
    * A background depth (where confidence < `minimumConfidence`) is represented by 1.0 (zFar). A value from 0.0 to 1.0 (default value 0.5). 
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyDepthTextureProvider/properties/BodyDepthTextureProvider-minimumConfidence.md Edit}
    */
    minimumConfidence: number
    
    /**
    * Far plane value in cm, Read only, always outputs 1000.0.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyDepthTextureProvider/properties/BodyDepthTextureProvider-zFar.md Edit}
    
    * @readonly
    */
    zFar: number
    
    /**
    * Near plane value in cm, Read only, always outputs 1.0.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyDepthTextureProvider/properties/BodyDepthTextureProvider-zNear.md Edit}
    
    * @readonly
    */
    zNear: number
    
}

/**
* Provides surface normal values of the tracked body encoded as RGBA (x, y, z, confidence) in `R8G8B8A8_UNORM` format in screen resolution. The XYZ values may need to be remapped from [0 -> 1] to [-1 -> 1] using the "Normal Map" mode of the `Texture 2D Sample` node in Material Editor.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyNormalsTextureProvider/BodyNormalsTextureProvider-description.md Edit}
*/
interface BodyNormalsTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyNormalsTextureProvider/properties/BodyNormalsTextureProvider-annotatorOptionsAsset.md Edit}
    
    * @private
    */
    annotatorOptionsAsset: BinAsset
    
    /**
    * The index of the body to track. The first body detected is `0`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyNormalsTextureProvider/properties/BodyNormalsTextureProvider-bodyIndex.md Edit}
    */
    bodyIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyNormalsTextureProvider/properties/BodyNormalsTextureProvider-bodyModel.md Edit}
    
    * @private
    */
    bodyModel: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyNormalsTextureProvider/properties/BodyNormalsTextureProvider-depthNormalsUVModel.md Edit}
    
    * @private
    */
    depthNormalsUVModel: BinAsset
    
}

/**
* Provider for full Body Mesh render object.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/BodyRenderObjectProvider-description.md Edit}
*/
interface BodyRenderObjectProvider extends RenderObjectProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/methods/BodyRenderObjectProvider-getAnnotationBytes.md Edit}
    
    * @private
    */
    getAnnotationBytes(): Uint8Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/methods/BodyRenderObjectProvider-getAnnotationDescriptorBytes.md Edit}
    
    * @private
    */
    getAnnotationDescriptorBytes(): Uint8Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/methods/BodyRenderObjectProvider-getBlendShapeWeights.md Edit}
    
    * @deprecated
    
    * @private
    */
    getBlendShapeWeights(): Float32Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-annotatorOptionsAsset.md Edit}
    
    * @private
    */
    annotatorOptionsAsset: BinAsset
    
    /**
    * Enable main Body Mesh geometry.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-bodyGeometryEnabled.md Edit}
    */
    bodyGeometryEnabled: boolean
    
    /**
    * Index of body in scene to track.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-bodyIndex.md Edit}
    */
    bodyIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-bodyModel.md Edit}
    
    * @private
    */
    bodyModel: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-handModel.md Edit}
    
    * @private
    */
    handModel: BinAsset
    
    /**
    * Enable head mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-headGeometryEnabled.md Edit}
    */
    headGeometryEnabled: boolean
    
    /**
    * Enable left hand mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-leftHandGeometryEnabled.md Edit}
    */
    leftHandGeometryEnabled: boolean
    
    /**
    * Enable right hand mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-rightHandGeometryEnabled.md Edit}
    */
    rightHandGeometryEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyRenderObjectProvider/properties/BodyRenderObjectProvider-useAccurateDepth.md Edit}
    
    * @private
    */
    useAccurateDepth: boolean
    
}

/**
* Asset used to configure Body Tracking for the [ObjectTracking3D](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ObjectTracking3D) component.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/BodyTrackingAsset-description.md Edit}
*/
interface BodyTrackingAsset extends Object3DAsset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-annotatorOptionsAsset.md Edit}
    
    * @private
    */
    annotatorOptionsAsset: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-bodyModel.md Edit}
    
    * @private
    */
    bodyModel: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-handModel.md Edit}
    
    * @private
    */
    handModel: BinAsset
    
    /**
    * When true, hand tracking will be enabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-handTrackingEnabled.md Edit}
    */
    handTrackingEnabled: boolean
    
}
declare namespace BodyTrackingAsset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/methods/BodyTrackingAsset-create.md Edit}
    
    * @deprecated
    
    * @private
    */
    export function create(options: BodyTrackingAssetOptions): BodyTrackingAsset
    
    /**
    * Key for Head attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-Head.md Edit}
    */
    let Head: string
    
    /**
    * Key for Hips attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-Hips.md Edit}
    */
    let Hips: string
    
    /**
    * Key for Left Arm attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftArm.md Edit}
    */
    let LeftArm: string
    
    /**
    * Key for Left Foot attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftFoot.md Edit}
    */
    let LeftFoot: string
    
    /**
    * Key for Left Forearm attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftForeArm.md Edit}
    */
    let LeftForeArm: string
    
    /**
    * Key for Left Hand attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHand.md Edit}
    */
    let LeftHand: string
    
    /**
    * Key for Left Hand Index 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandIndex1.md Edit}
    */
    let LeftHandIndex1: string
    
    /**
    * Key for Left Hand Index 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandIndex2.md Edit}
    */
    let LeftHandIndex2: string
    
    /**
    * Key for Left Hand Index 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandIndex3.md Edit}
    */
    let LeftHandIndex3: string
    
    /**
    * Key for Left Hand Middle 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandMiddle1.md Edit}
    */
    let LeftHandMiddle1: string
    
    /**
    * Key for Left Hand Middle 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandMiddle2.md Edit}
    */
    let LeftHandMiddle2: string
    
    /**
    * Key for Left Hand Middle 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandMiddle3.md Edit}
    */
    let LeftHandMiddle3: string
    
    /**
    * Key for Left Hand Pinky 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandPinky1.md Edit}
    */
    let LeftHandPinky1: string
    
    /**
    * Key for Left Hand Pinky 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandPinky2.md Edit}
    */
    let LeftHandPinky2: string
    
    /**
    * Key for Left Hand Pinky 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandPinky3.md Edit}
    */
    let LeftHandPinky3: string
    
    /**
    * Key for Left Hand Ring 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandRing1.md Edit}
    */
    let LeftHandRing1: string
    
    /**
    * Key for Left Hand Ring 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandRing2.md Edit}
    */
    let LeftHandRing2: string
    
    /**
    * Key for Left Hand Ring 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandRing3.md Edit}
    */
    let LeftHandRing3: string
    
    /**
    * Key for Left Hand Thumb 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandThumb1.md Edit}
    */
    let LeftHandThumb1: string
    
    /**
    * Key for Left Hand Thumb 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandThumb2.md Edit}
    */
    let LeftHandThumb2: string
    
    /**
    * Key for Left Hand Thumb 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftHandThumb3.md Edit}
    */
    let LeftHandThumb3: string
    
    /**
    * Key for Left Leg attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftLeg.md Edit}
    */
    let LeftLeg: string
    
    /**
    * Key for Left Shoulder attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftShoulder.md Edit}
    */
    let LeftShoulder: string
    
    /**
    * Key for Left Toe Base attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftToeBase.md Edit}
    */
    let LeftToeBase: string
    
    /**
    * Key for Upper Left Leg attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-LeftUpLeg.md Edit}
    */
    let LeftUpLeg: string
    
    /**
    * Key for Neck attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-Neck.md Edit}
    */
    let Neck: string
    
    /**
    * Key for Right Arm attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightArm.md Edit}
    */
    let RightArm: string
    
    /**
    * Key for Right Foot attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightFoot.md Edit}
    */
    let RightFoot: string
    
    /**
    * Key for Right Forearm attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightForeArm.md Edit}
    */
    let RightForeArm: string
    
    /**
    * Key for Right Hand attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHand.md Edit}
    */
    let RightHand: string
    
    /**
    * Key for Right Hand Index 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandIndex1.md Edit}
    */
    let RightHandIndex1: string
    
    /**
    * Key for Right Hand Index 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandIndex2.md Edit}
    */
    let RightHandIndex2: string
    
    /**
    * Key for Right Hand Index 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandIndex3.md Edit}
    */
    let RightHandIndex3: string
    
    /**
    * Key for Right Hand Middle 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandMiddle1.md Edit}
    */
    let RightHandMiddle1: string
    
    /**
    * Key for Right Hand Middle 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandMiddle2.md Edit}
    */
    let RightHandMiddle2: string
    
    /**
    * Key for Right Hand Middle 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandMiddle3.md Edit}
    */
    let RightHandMiddle3: string
    
    /**
    * Key for Right Hand Pinky 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandPinky1.md Edit}
    */
    let RightHandPinky1: string
    
    /**
    * Key for Right Hand Pinky 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandPinky2.md Edit}
    */
    let RightHandPinky2: string
    
    /**
    * Key for Right Hand Pinky 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandPinky3.md Edit}
    */
    let RightHandPinky3: string
    
    /**
    * Key for Right Hand Ring 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandRing1.md Edit}
    */
    let RightHandRing1: string
    
    /**
    * Key for Right Hand Ring 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandRing2.md Edit}
    */
    let RightHandRing2: string
    
    /**
    * Key for Right Hand Ring 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandRing3.md Edit}
    */
    let RightHandRing3: string
    
    /**
    * Key for Right Hand Thumb 1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandThumb1.md Edit}
    */
    let RightHandThumb1: string
    
    /**
    * Key for Right Hand Thumb 2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandThumb2.md Edit}
    */
    let RightHandThumb2: string
    
    /**
    * Key for Right Hand Thumb 3 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightHandThumb3.md Edit}
    */
    let RightHandThumb3: string
    
    /**
    * Key for Right Leg attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightLeg.md Edit}
    */
    let RightLeg: string
    
    /**
    * Key for Right Shoulder attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightShoulder.md Edit}
    */
    let RightShoulder: string
    
    /**
    * Key for Right Toe Base attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightToeBase.md Edit}
    */
    let RightToeBase: string
    
    /**
    * Key for Upper Right Leg attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-RightUpLeg.md Edit}
    */
    let RightUpLeg: string
    
    /**
    * Key for Spine attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-Spine.md Edit}
    */
    let Spine: string
    
    /**
    * Key for Spine1 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-Spine1.md Edit}
    */
    let Spine1: string
    
    /**
    * Key for Spine2 attachment point.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAsset/properties/BodyTrackingAsset-Spine2.md Edit}
    */
    let Spine2: string
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAssetOptions/BodyTrackingAssetOptions-description.md Edit}

* @private
*/
interface BodyTrackingAssetOptions extends ScriptObject {
}
declare namespace BodyTrackingAssetOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BodyTrackingAssetOptions/methods/BodyTrackingAssetOptions-create.md Edit}
    
    * @deprecated
    
    * @private
    */
    export function create(): BodyTrackingAssetOptions
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/BoundedVideoTextureProvider-description.md Edit}

* @private
*/
interface BoundedVideoTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/methods/BoundedVideoTextureProvider-loop.md Edit}
    
    * @private
    */
    loop(value: boolean): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/methods/BoundedVideoTextureProvider-pause.md Edit}
    
    * @private
    */
    pause(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/methods/BoundedVideoTextureProvider-play.md Edit}
    
    * @private
    */
    play(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/methods/BoundedVideoTextureProvider-seekSeconds.md Edit}
    
    * @private
    */
    seekSeconds(value: number): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/methods/BoundedVideoTextureProvider-setOnPlaybackReady.md Edit}
    
    * @private
    */
    setOnPlaybackReady(value: () => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/methods/BoundedVideoTextureProvider-setOnTextureUpdated.md Edit}
    
    * @private
    */
    setOnTextureUpdated(value: () => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/methods/BoundedVideoTextureProvider-stop.md Edit}
    
    * @private
    */
    stop(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-currentTimeSec.md Edit}
    
    * @readonly
    
    * @private
    */
    currentTimeSec: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-durationSec.md Edit}
    
    * @readonly
    
    * @private
    */
    durationSec: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-isLooped.md Edit}
    
    * @readonly
    
    * @private
    */
    isLooped: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-isPlaybackReady.md Edit}
    
    * @readonly
    
    * @private
    */
    isPlaybackReady: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-isPlaying.md Edit}
    
    * @readonly
    
    * @private
    */
    isPlaying: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-isValid.md Edit}
    
    * @readonly
    
    * @private
    */
    isValid: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-lastTextureTimeSec.md Edit}
    
    * @readonly
    
    * @private
    */
    lastTextureTimeSec: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-playbackRelEnd.md Edit}
    
    * @private
    */
    playbackRelEnd: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-playbackRelStart.md Edit}
    
    * @private
    */
    playbackRelStart: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundedVideoTextureProvider/properties/BoundedVideoTextureProvider-volume.md Edit}
    
    * @private
    */
    volume: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundingBox/BoundingBox-description.md Edit}

* @private
*/
declare class BoundingBox {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundingBox/methods/BoundingBox-BoundingBox.md Edit}
    
    * @private
    */
    constructor(arg1: number, arg2: number, arg3: number, arg4: number)
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundingBox/methods/BoundingBox-getSize.md Edit}
    
    * @private
    */
    getSize(): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundingBox/properties/BoundingBox-xMax.md Edit}
    
    * @private
    */
    xMax: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundingBox/properties/BoundingBox-xMin.md Edit}
    
    * @private
    */
    xMin: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundingBox/properties/BoundingBox-yMax.md Edit}
    
    * @private
    */
    yMax: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoundingBox/properties/BoundingBox-yMin.md Edit}
    
    * @private
    */
    yMin: number
    
}

/**
* A box collision shape.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoxShape/BoxShape-description.md Edit}
*/
interface BoxShape extends Shape {
    /**
    * The size of the box on each local axis.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BoxShape/properties/BoxShape-size.md Edit}
    */
    size: vec3
    
}

/**
* Triggered when eyebrows are lowered on the tracked face.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BrowsLoweredEvent/BrowsLoweredEvent-description.md Edit}
*/
interface BrowsLoweredEvent extends FaceTrackingEvent {
}

/**
* Triggered when eyebrows are raised on the tracked face.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BrowsRaisedEvent/BrowsRaisedEvent-description.md Edit}
*/
interface BrowsRaisedEvent extends FaceTrackingEvent {
}

/**
* Triggered when eyebrows are returned to normal on the tracked face.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/BrowsReturnedToNormalEvent/BrowsReturnedToNormalEvent-description.md Edit}
*/
interface BrowsReturnedToNormalEvent extends FaceTrackingEvent {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameoAsset/CameoAsset-description.md Edit}
*/
interface CameoAsset extends BinAsset {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameosPerformanceMode/CameosPerformanceMode-description.md Edit}

* @private
*/
declare enum CameosPerformanceMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameosPerformanceMode/properties/CameosPerformanceMode-None.md Edit}
    
    * @private
    */
    None,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameosPerformanceMode/properties/CameosPerformanceMode-Low.md Edit}
    
    * @private
    */
    Low,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameosPerformanceMode/properties/CameosPerformanceMode-High.md Edit}
    
    * @private
    */
    High
}

/**
* Renders the scene to a Render Target texture.
* A Camera will only render a SceneObject if the SceneObject's render layer is enabled on the Camera.
* For more information, see the [Camera and Layers](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/scene-set-up/camera) guide.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/Camera-description.md Edit}
*/
interface Camera extends Component {
    /**
    * Adds layer `id` to the list of layers the Camera will render.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-addRenderLayer.md Edit}
    
    * @deprecated
    */
    addRenderLayer(id: number): void
    
    /**
    * Returns whether rendering layer `id` is enabled for the Camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-checkRenderLayer.md Edit}
    
    * @deprecated
    */
    checkRenderLayer(id: number): boolean
    
    /**
    * Returns a list of 32 numbers, one for every render layer. Values will either be 0 or 1, 0 meaning the Camera won't render the layer and 1 meaning it will.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-getAllRenderLayers.md Edit}
    
    * @deprecated
    */
    getAllRenderLayers(): number[]
    
    /**
    * For orthographic cameras, returns the camera size as (width, height).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-getOrthographicSize.md Edit}
    */
    getOrthographicSize(): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-getViewProjectionMatrix.md Edit}
    
    * @private
    */
    getViewProjectionMatrix(): mat4
    
    /**
    * Returns true if a sphere with the specified world space center position and radius is visible within the camera frustum, false otherwise.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-isSphereVisible.md Edit}
    */
    isSphereVisible(center: vec3, radius: number): boolean
    
    /**
    * Converts a world space position to a raw screen space position.
    * The screen space position will be returned as a `vec3` with `x`,`y` representing normalized screen space,
    * and `z` representing a raw depth value not directly convertible to world units.
    * This returned value will mostly be useful for passing into `unproject()`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-project.md Edit}
    */
    project(worldSpacePoint: vec3): vec3
    
    /**
    * Removes layer `id` from the list of layers the Camera will render.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-removeRenderLayer.md Edit}
    
    * @deprecated
    */
    removeRenderLayer(id: number): void
    
    /**
    * Converts a screen space position to a world space position, given an absolute depth.
    * The screen space position should be provided as a `vec2` in the range ([0-1], [0-1]),
    * (0,0) being the top-left of the screen and (1,1) being the bottom-right.
    * The returned world space position will be the point `absoluteDepth` units away from the Camera's
    * `near` plane at the point specified in screen space.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-screenSpaceToWorldSpace.md Edit}
    */
    screenSpaceToWorldSpace(normalizedScreenSpacePoint: vec2, absoluteDepth: number): vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-trackingCameraScreenSpaceToWorldSpace.md Edit}
    
    * @private
    */
    trackingCameraScreenSpaceToWorldSpace(normalizedScreenSpacePoint: vec2, absoluteDepth: number): vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-trackingCameraSpaceToWorldSpace.md Edit}
    
    * @private
    */
    trackingCameraSpaceToWorldSpace(trackingCameraPoint: vec3): vec3
    
    /**
    * Converts a raw screen space position to a world space position.
    * `clipSpacePoint` should be a `vec3` returned from a previous `project()` call, since the
    * `z` value represents a raw depth value not directly convertible to world units.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-unproject.md Edit}
    */
    unproject(clipSpacePoint: vec3): vec3
    
    /**
    * Converts the world space position `worldSpacePoint` to a screen space position.
    * Screen positions are represented in the range ([0-1], [0-1]), (0,0) being the top-left of the screen and (1,1) being the bottom-right.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-worldSpaceToScreenSpace.md Edit}
    */
    worldSpaceToScreenSpace(worldSpacePoint: vec3): vec2
    
    /**
    * The aspect ratio of the camera (width/height).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-aspect.md Edit}
    */
    aspect: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-cameraMaskChannel.md Edit}
    
    * @private
    */
    cameraMaskChannel: Camera.CameraMaskChannel
    
    /**
    * When `enableClearColor` is true and `inputTexture` is null, this color is used to clear this Camera's `renderTarget` before drawing to it.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-clearColor.md Edit}
    */
    clearColor: vec4
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-clearColorOption.md Edit}
    
    * @deprecated
    
    * @private
    */
    clearColorOption: ClearColorOption
    
    /**
    * Returns an array of Color Render Targets. The first color render target is always available.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-colorRenderTargets.md Edit}
    */
    colorRenderTargets: Camera.ColorRenderTarget[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-debugRender.md Edit}
    
    * @readonly
    
    * @private
    */
    debugRender: DebugRender
    
    /**
    * Determines the way depth is handled on this Camera. Changing this can help sort objects at different distance ranges.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-depthBufferMode.md Edit}
    */
    depthBufferMode: Camera.DepthBufferMode
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-depthClearOption.md Edit}
    
    * @deprecated
    
    * @private
    */
    depthClearOption: DepthClearOption
    
    /**
    * Descriptor of depth/stencil textures and clear options.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-depthStencilRenderTarget.md Edit}
    */
    depthStencilRenderTarget: Camera.DepthStencilRenderTarget
    
    /**
    * Controls which Camera settings will be overridden by physical device properties.
    * For example, this can be used to override the `fov` property to match the device camera's actual field of view.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-devicePropertyUsage.md Edit}
    */
    devicePropertyUsage: Camera.DeviceProperty
    
    /**
    * If enabled, this Camera will clear the color on its `renderTarget` before drawing to it.
    * `inputTexture` will be used to clear it unless it is null, in which case `clearColor` is used instead.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-enableClearColor.md Edit}
    */
    enableClearColor: boolean
    
    /**
    * If enabled, this Camera will clear the depth buffer on its `renderTarget` before drawing to it.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-enableClearDepth.md Edit}
    */
    enableClearDepth: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-extents.md Edit}
    
    * @private
    */
    extents: Rect
    
    /**
    * The distance of the far clipping plane.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-far.md Edit}
    */
    far: number
    
    /**
    * The Camera's field of view in radians.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-fov.md Edit}
    */
    fov: number
    
    /**
    * When `enableClearColor` is true, this texture is used to clear this Camera's `renderTarget` before drawing.
    * If this texture is null, `clearColor` will be used instead.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-inputTexture.md Edit}
    */
    inputTexture: Texture
    
    /**
    * If true, the camera FOV will be overridden to match the device's physical camera FOV.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-isPhysical.md Edit}
    
    * @deprecated
    */
    isPhysical: boolean
    
    /**
    * A texture controlling which parts of the output texture the camera will draw to.
    * The "red" value of each pixel determines how strongly the camera will draw to that part of the image.
    * For example, a completely black section will cause the camera to not draw there at all. A completely
    * white (or red) section will cause the camera to draw normally. Colors in between, like gray, will be semitransparent.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-maskTexture.md Edit}
    */
    maskTexture: Texture
    
    /**
    * The distance of the near clipping plane.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-near.md Edit}
    */
    near: number
    
    /**
    * Toggles ray tracing for the camera. When true, ray tracing is enabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-rayTracing.md Edit}
    */
    rayTracing: boolean
    
    /**
    * Controls the set of layers this Camera will render.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-renderLayer.md Edit}
    */
    renderLayer: LayerSet
    
    /**
    * The sorting order the Camera renders in. Every frame, Cameras render in ascending order determined by their `renderOrder` properties.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-renderOrder.md Edit}
    */
    renderOrder: number
    
    /**
    * The RenderTarget this Camera will draw to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-renderTarget.md Edit}
    */
    renderTarget: Texture
    
    /**
    * Sets which face of the cubemap this camera will render to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-renderTargetCubemapFace.md Edit}
    */
    renderTargetCubemapFace: Camera.CubemapFace
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-renderTargetMipmapLevel.md Edit}
    
    * @private
    */
    renderTargetMipmapLevel: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-renderTargetSlice.md Edit}
    
    * @private
    */
    renderTargetSlice: number
    
    /**
    * The orthographic size of the camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-size.md Edit}
    */
    size: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-ssao.md Edit}
    
    * @private
    */
    ssao: SSAO.Settings
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-stencilClearOption.md Edit}
    
    * @deprecated
    
    * @private
    */
    stencilClearOption: StencilClearOption
    
    /**
    * Returns a number of hardware supported render targets. The max number is 4. If the device doesnt support Multiple Render Targets this property equals 1.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-supportedColorRenderTargetCount.md Edit}
    
    * @deprecated
    
    * @readonly
    */
    supportedColorRenderTargetCount: number
    
    /**
    * Controls which type of rendering the camera uses.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/properties/Camera-type.md Edit}
    */
    type: Camera.Type
    
}
declare namespace Camera {
    /**
    * Creates and returns a new Color Render Target.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-createColorRenderTarget.md Edit}
    */
    export function createColorRenderTarget(): Camera.ColorRenderTarget
    
    /**
    * Create a depth/stencil render target descriptor for the camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-createDepthStencilRenderTarget.md Edit}
    */
    export function createDepthStencilRenderTarget(): Camera.DepthStencilRenderTarget
    
    /**
    * Return true if the device supports stencil operations and render to depth texture.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-depthStencilRenderTargetSupported.md Edit}
    */
    export function depthStencilRenderTargetSupported(): boolean
    
    /**
    * Returns the number of possible render target bindings to the camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera/methods/Camera-getSupportedColorRenderTargetCount.md Edit}
    */
    export function getSupportedColorRenderTargetCount(): number
    

}

declare namespace Camera {
    /**
    * The base class from which ColorRenderTarget and DepthStencilRenderTarget are derived from
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.BaseRenderTarget/Camera.BaseRenderTarget-description.md Edit}
    */
    interface BaseRenderTarget extends ScriptObject {
        /**
        * Color texture used in clear color operation in "CustomTexture" mode.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.BaseRenderTarget/properties/Camera.BaseRenderTarget-inputTexture.md Edit}
        */
        inputTexture: Texture
        
        /**
        * Texture used like a color mask for target texture.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.BaseRenderTarget/properties/Camera.BaseRenderTarget-maskTexture.md Edit}
        */
        maskTexture: Texture
        
        /**
        * Render target texture. Camera will render scene color values to this texture.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.BaseRenderTarget/properties/Camera.BaseRenderTarget-targetTexture.md Edit}
        */
        targetTexture: Texture
        
    }

}

declare namespace Camera {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CameraMaskChannel/Camera.CameraMaskChannel-description.md Edit}
    
    * @private
    */
    enum CameraMaskChannel {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CameraMaskChannel/properties/Camera.CameraMaskChannel-UseR.md Edit}
        
        * @private
        */
        UseR,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CameraMaskChannel/properties/Camera.CameraMaskChannel-UseRGBA.md Edit}
        
        * @private
        */
        UseRGBA,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CameraMaskChannel/properties/Camera.CameraMaskChannel-UseA.md Edit}
        
        * @private
        */
        UseA
    }

}

declare namespace Camera {
    /**
    * Color based RenderTarget.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.ColorRenderTarget/Camera.ColorRenderTarget-description.md Edit}
    */
    interface ColorRenderTarget extends Camera.BaseRenderTarget {
        /**
        * Sets the clear color of the camera when its `clearColorOption` is set to `ClearColorOption.CustomColor`
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.ColorRenderTarget/properties/Camera.ColorRenderTarget-clearColor.md Edit}
        */
        clearColor: vec4
        
        /**
        * Sets how the RenderTarget's color will be cleared before rendering during each frame.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.ColorRenderTarget/properties/Camera.ColorRenderTarget-clearColorOption.md Edit}
        */
        clearColorOption: ClearColorOption
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.ColorRenderTarget/properties/Camera.ColorRenderTarget-maskChannel.md Edit}
        
        * @private
        */
        maskChannel: Camera.CameraMaskChannel
        
    }

}

declare namespace Camera {
    /**
    * Different faces of the cubemap that a camera can render into.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/Camera.CubemapFace-description.md Edit}
    */
    enum CubemapFace {
        /**
        * The positive X cubemap face.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-PositiveX.md Edit}
        */
        PositiveX,
        /**
        * The negative X cubemap face.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-NegativeX.md Edit}
        */
        NegativeX,
        /**
        * The positive Y cubemap face.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-PositiveY.md Edit}
        */
        PositiveY,
        /**
        * The negative Y cubemap face.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-NegativeY.md Edit}
        */
        NegativeY,
        /**
        * The positive Z cubemap face.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-PositiveZ.md Edit}
        */
        PositiveZ,
        /**
        * The negative Z cubemap face.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-NegativeZ.md Edit}
        */
        NegativeZ,
        /**
        * The left cubemap face, same as NegativeX.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-Left.md Edit}
        */
        Left,
        /**
        * The right cubemap face, same as PositiveX.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-Right.md Edit}
        */
        Right,
        /**
        * The top cubemap face, same as PositiveY.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-Top.md Edit}
        */
        Top,
        /**
        * The bottom cubemap face, same as NegativeY.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-Bottom.md Edit}
        */
        Bottom,
        /**
        * The front cubemap face, same as PositiveZ.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-Front.md Edit}
        */
        Front,
        /**
        * The back cubemap face, same as NegativeZ.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.CubemapFace/properties/Camera.CubemapFace-Back.md Edit}
        */
        Back
    }

}

declare namespace Camera {
    /**
    * Used in [Camera's](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Camera) `depthBufferMode` property.
    * Each mode is suited for handling objects at a certain distance range.
    * For more information on depth modes, see the [Camera and Layers](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/scene-set-up/camera) guide.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthBufferMode/Camera.DepthBufferMode-description.md Edit}
    */
    enum DepthBufferMode {
        /**
        * Gives higher depth precision on nearby objects, so is better suited for scenes near to the camera.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthBufferMode/properties/Camera.DepthBufferMode-Regular.md Edit}
        */
        Regular,
        /**
        * Gives higher depth precision on far away objects, so is better suited for scenes far away from the camera.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthBufferMode/properties/Camera.DepthBufferMode-Logarithmic.md Edit}
        */
        Logarithmic
    }

}

declare namespace Camera {
    /**
    * This class inherits from the BaseRenderTarget class. BaseRenderTarget class is not available for creation and is used like the base class for DepthStencilRenderTarget class to provide access to targetTexture, inputTexture and maskTexture properties.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthStencilRenderTarget/Camera.DepthStencilRenderTarget-description.md Edit}
    */
    interface DepthStencilRenderTarget extends Camera.BaseRenderTarget {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthStencilRenderTarget/properties/Camera.DepthStencilRenderTarget-clearDepth.md Edit}
        
        * @deprecated
        
        * @private
        */
        clearDepth: number
        
        /**
        * Float value in range [0.0..1.0] used in depth buffer clear operation in "CustomValue" mode. The initial value is 1.0.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthStencilRenderTarget/properties/Camera.DepthStencilRenderTarget-clearDepthValue.md Edit}
        */
        clearDepthValue: number
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthStencilRenderTarget/properties/Camera.DepthStencilRenderTarget-clearStencil.md Edit}
        
        * @deprecated
        
        * @private
        */
        clearStencil: number
        
        /**
        * Unsigned int value in range [0..0xFF] used in stencil buffer clear operation in "CustomValue" mode. The initial value is 0.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthStencilRenderTarget/properties/Camera.DepthStencilRenderTarget-clearStencilValue.md Edit}
        */
        clearStencilValue: number
        
        /**
        * The same as "depthClearOption" property of DepthStencilRenderTargetProvider. But if Camera's depth clear option property is set to "CustomValue" or "CustomTexture" then this has priority over depth/stencil provider settings.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthStencilRenderTarget/properties/Camera.DepthStencilRenderTarget-depthClearOption.md Edit}
        */
        depthClearOption: DepthClearOption
        
        /**
        * The same as "stencilClearOption" property of DepthStencilRenderTargetProvider. But if Camera's stencil clear option property is set to "CustomValue" or "CustomTexture" then this has priority over depth/stencil provider settings.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DepthStencilRenderTarget/properties/Camera.DepthStencilRenderTarget-stencilClearOption.md Edit}
        */
        stencilClearOption: StencilClearOption
        
    }

}

declare namespace Camera {
    /**
    * Used in [Camera's](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Camera) `devicePropertyUsage` property.
    * Specifies which camera properties should be overridden by device properties.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DeviceProperty/Camera.DeviceProperty-description.md Edit}
    */
    enum DeviceProperty {
        /**
        * No Camera properties are overridden with device properties.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DeviceProperty/properties/Camera.DeviceProperty-None.md Edit}
        */
        None,
        /**
        * Overrides the Camera's `aspect` property to use the device's aspect ratio instead.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DeviceProperty/properties/Camera.DeviceProperty-Aspect.md Edit}
        */
        Aspect,
        /**
        * Overrides the Camera's `fov` property to use the device's field of view instead.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DeviceProperty/properties/Camera.DeviceProperty-Fov.md Edit}
        */
        Fov,
        /**
        * Overrides both `aspect` and `fov` with the device's properties.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.DeviceProperty/properties/Camera.DeviceProperty-All.md Edit}
        */
        All
    }

}

declare namespace Camera {
    /**
    * Returned from [Camera's](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Camera) `type` property.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.Type/Camera.Type-description.md Edit}
    */
    enum Type {
        /**
        * Simulates how perspective and depth perception work in the real world. Useful for rendering objects in 3D space.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.Type/properties/Camera.Type-Perspective.md Edit}
        */
        Perspective,
        /**
        * Does not simulate perspective distortion. Useful for 2D effects like Images and Text.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Camera.Type/properties/Camera.Type-Orthographic.md Edit}
        */
        Orthographic
    }

}

/**
* Triggered when the device's back facing camera becomes active.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraBackEvent/CameraBackEvent-description.md Edit}
*/
interface CameraBackEvent extends SceneEvent {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraFrame/CameraFrame-description.md Edit}

* @experimental

* @exposesUserData

* @snapOsOnly
*/
interface CameraFrame extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraFrame/properties/CameraFrame-timestampMillis.md Edit}
    
    * @readonly
    */
    timestampMillis: number
    
}

/**
* Triggered when the device's front facing camera becomes active.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraFrontEvent/CameraFrontEvent-description.md Edit}
*/
interface CameraFrontEvent extends SceneEvent {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule/CameraModule-description.md Edit}

* @experimental

* @exposesUserData

* @snapOsOnly
*/
interface CameraModule extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule/methods/CameraModule-requestCamera.md Edit}
    */
    requestCamera(request: CameraModule.CameraRequest): Texture
    
}
declare namespace CameraModule {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule/methods/CameraModule-createCameraRequest.md Edit}
    
    * @experimental
    
    * @exposesUserData
    
    * @snapOsOnly
    */
    export function createCameraRequest(): CameraModule.CameraRequest
    

}

declare namespace CameraModule {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule.CameraId/CameraModule.CameraId-description.md Edit}
    
    * @experimental
    
    * @exposesUserData
    
    * @snapOsOnly
    */
    enum CameraId {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule.CameraId/properties/CameraModule.CameraId-Default_Color.md Edit}
        */
        Default_Color,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule.CameraId/properties/CameraModule.CameraId-Left_Color.md Edit}
        */
        Left_Color,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule.CameraId/properties/CameraModule.CameraId-Right_Color.md Edit}
        */
        Right_Color
    }

}

declare namespace CameraModule {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule.CameraRequest/CameraModule.CameraRequest-description.md Edit}
    
    * @experimental
    
    * @exposesUserData
    
    * @snapOsOnly
    */
    interface CameraRequest extends ScriptObject {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule.CameraRequest/properties/CameraModule.CameraRequest-cameraId.md Edit}
        */
        cameraId: CameraModule.CameraId
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraModule.CameraRequest/properties/CameraModule.CameraRequest-imageSmallerDimension.md Edit}
        */
        imageSmallerDimension?: number
        
    }

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraRawModule/CameraRawModule-description.md Edit}

* @private
*/
interface CameraRawModule extends Asset {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraTextureProvider/CameraTextureProvider-description.md Edit}
*/
interface CameraTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraTextureProvider/properties/CameraTextureProvider-onNewFrame.md Edit}
    
    * @readonly
    
    * @experimental
    
    * @exposesUserData
    
    * @snapOsOnly
    */
    onNewFrame: event1<CameraFrame, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CameraTextureProvider/properties/CameraTextureProvider-timestampSeconds.md Edit}
    
    * @readonly
    
    * @private
    */
    timestampSeconds: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CandideUpdatedEvent/CandideUpdatedEvent-description.md Edit}

* @unreleased
*/
interface CandideUpdatedEvent extends FaceTrackingEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CandideUpdatedEvent/properties/CandideUpdatedEvent-points2d.md Edit}
    
    * @unreleased
    
    * @readonly
    */
    points2d: vec2[]
    
}

/**
* A 2D canvas anchored in 3D space that acts as the root of the ScreenTransform hierarchy. ScreenTransform SceneObjects can be placed on the Canvas, and the Canvas can be sized and placed anywhere in 3D space. It is like a painter’s canvas for ScreenTransforms.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas/Canvas-description.md Edit}
*/
interface Canvas extends Component {
    /**
    * Get size of rectangle as (width, height)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas/methods/Canvas-getSize.md Edit}
    */
    getSize(): vec2
    
    /**
    * Set size of rectangle as (width, height)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas/methods/Canvas-setSize.md Edit}
    */
    setSize(value: vec2): void
    
    /**
    * The point about which the Canvas Rectangle will rotate. Defined as fractional coordinates of the Canvas's dimensions. e.g. (1 , 1) brings the pivot to the top right corner of the canvas. Or (0.5, 0) moves the pivot to the right by half the canvas width.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas/properties/Canvas-pivot.md Edit}
    */
    pivot: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas/properties/Canvas-sortingType.md Edit}
    */
    sortingType: Canvas.SortingType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas/properties/Canvas-unitType.md Edit}
    */
    unitType: Canvas.UnitType
    
    /**
    * World Space Rectangle that defines the Canvas as offsets in world units from the SceneObject's position
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas/properties/Canvas-worldSpaceRect.md Edit}
    */
    worldSpaceRect: Rect
    
}

declare namespace Canvas {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas.SortingType/Canvas.SortingType-description.md Edit}
    */
    enum SortingType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas.SortingType/properties/Canvas.SortingType-Hierarchy.md Edit}
        */
        Hierarchy,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas.SortingType/properties/Canvas.SortingType-Depth.md Edit}
        */
        Depth
    }

}

declare namespace Canvas {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas.UnitType/Canvas.UnitType-description.md Edit}
    */
    enum UnitType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas.UnitType/properties/Canvas.UnitType-World.md Edit}
        */
        World,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas.UnitType/properties/Canvas.UnitType-Pixels.md Edit}
        */
        Pixels,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Canvas.UnitType/properties/Canvas.UnitType-Points.md Edit}
        */
        Points
    }

}

/**
* Changes the capitalization of the text component. Useful when using dynamic texts.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CapitilizationOverride/CapitilizationOverride-description.md Edit}
*/
declare enum CapitilizationOverride {
    /**
    * Display the capitalization of the displayed text as provided.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CapitilizationOverride/properties/CapitilizationOverride-None.md Edit}
    */
    None,
    /**
    * Sets the capitalization of the displayed text to lowercase.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CapitilizationOverride/properties/CapitilizationOverride-AllLower.md Edit}
    */
    AllLower,
    /**
    * Sets the capitalization of the displayed text to uppercase.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CapitilizationOverride/properties/CapitilizationOverride-AllUpper.md Edit}
    */
    AllUpper
}

/**
* A capsule collision shape. Also known as a capped cylinder.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CapsuleShape/CapsuleShape-description.md Edit}
*/
interface CapsuleShape extends Shape {
    /**
    * Lengthwise local axis along which the capsule is oriented.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CapsuleShape/properties/CapsuleShape-axis.md Edit}
    */
    axis: Axis
    
    /**
    * Length of the capsule along its local axis. This is the distance between the two end-cap centers.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CapsuleShape/properties/CapsuleShape-length.md Edit}
    */
    length: number
    
    /**
    * Radius of the capsule cylinder, and its end-cap spheres.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CapsuleShape/properties/CapsuleShape-radius.md Edit}
    */
    radius: number
    
}

/**
* Settings for how color will be cleared before rendering.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearColorOption/ClearColorOption-description.md Edit}
*/
declare enum ClearColorOption {
    /**
    * The frame will not be cleared before being rendered to (draws over the previous frame).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearColorOption/properties/ClearColorOption-None.md Edit}
    */
    None,
    /**
    * Use the Device Texture for the color color
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearColorOption/properties/ClearColorOption-Background.md Edit}
    */
    Background,
    /**
    * The frame will be cleared with a color before being rendered to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearColorOption/properties/ClearColorOption-CustomColor.md Edit}
    */
    CustomColor,
    /**
    * The frame will be cleared with a texture before being rendered to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearColorOption/properties/ClearColorOption-CustomTexture.md Edit}
    */
    CustomTexture
}

/**
* Clears depth in the drawing order.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearScreen/ClearScreen-description.md Edit}
*/
interface ClearDepth extends Visual {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearScreen/properties/ClearScreen-clearColor.md Edit}
    
    * @private
    */
    clearColor: vec4
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearScreen/properties/ClearScreen-clearDepth.md Edit}
    
    * @private
    */
    clearDepth: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearScreen/properties/ClearScreen-clearStencil.md Edit}
    
    * @private
    */
    clearStencil: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearScreen/properties/ClearScreen-colorMask.md Edit}
    
    * @private
    */
    colorMask: vec4b
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearScreen/properties/ClearScreen-depthMask.md Edit}
    
    * @private
    */
    depthMask: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClearScreen/properties/ClearScreen-stencilMask.md Edit}
    
    * @private
    */
    stencilMask: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceAction/ClientInterfaceAction-description.md Edit}

* @private
*/
declare enum ClientInterfaceAction {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceAction/properties/ClientInterfaceAction-EnableHighlight.md Edit}
    
    * @private
    */
    EnableHighlight,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceAction/properties/ClientInterfaceAction-DisableHighlight.md Edit}
    
    * @private
    */
    DisableHighlight,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceAction/properties/ClientInterfaceAction-Trigger.md Edit}
    
    * @private
    */
    Trigger,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceAction/properties/ClientInterfaceAction-Hide.md Edit}
    
    * @private
    */
    Hide,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceAction/properties/ClientInterfaceAction-Show.md Edit}
    
    * @private
    */
    Show
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceActionTakenEvent/ClientInterfaceActionTakenEvent-description.md Edit}

* @private
*/
interface ClientInterfaceActionTakenEvent extends SceneEvent {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceComponent/ClientInterfaceComponent-description.md Edit}

* @private
*/
interface ClientInterfaceComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceComponent/methods/ClientInterfaceComponent-hideClientInterface.md Edit}
    
    * @private
    */
    hideClientInterface(interfaceType: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceComponent/methods/ClientInterfaceComponent-isClientInterfaceActive.md Edit}
    
    * @private
    */
    isClientInterfaceActive(interfaceType: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceComponent/methods/ClientInterfaceComponent-performAction.md Edit}
    
    * @private
    */
    performAction(interfaceControl: string, action: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceComponent/methods/ClientInterfaceComponent-showClientInterface.md Edit}
    
    * @private
    */
    showClientInterface(interfaceControl: string, headerId: string, descriptionId: string): boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/ClientInterfaceElement-description.md Edit}

* @private
*/
declare enum ClientInterfaceElement {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-ToggleCameraButton.md Edit}
    
    * @private
    */
    ToggleCameraButton,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-ImagePicker.md Edit}
    
    * @private
    */
    ImagePicker,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-Modal.md Edit}
    
    * @private
    */
    Modal,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-Hint.md Edit}
    
    * @private
    */
    Hint,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-LinkBitmojiCallToAction.md Edit}
    
    * @private
    */
    LinkBitmojiCallToAction,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-SnapButton.md Edit}
    
    * @private
    */
    SnapButton,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-PlayButton.md Edit}
    
    * @private
    */
    PlayButton,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-All.md Edit}
    
    * @private
    */
    All,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-ExitFullScreenButton.md Edit}
    
    * @private
    */
    ExitFullScreenButton,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceElement/properties/ClientInterfaceElement-LensAttachmentButton.md Edit}
    
    * @private
    */
    LensAttachmentButton
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/ClientInterfaceSystem-description.md Edit}

* @private
*/
interface ClientInterfaceSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-enableExternalImageApi.md Edit}
    
    * @deprecated
    
    * @private
    */
    enableExternalImageApi(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-getSystemInterfaceElementSize.md Edit}
    
    * @private
    */
    getSystemInterfaceElementSize(interfaceElement: SystemInterfaceElement): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-hideInterfaceElement.md Edit}
    
    * @private
    */
    hideInterfaceElement(interfaceElement: DeviceUIElement): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-isInterfaceControlVisible.md Edit}
    
    * @deprecated
    
    * @private
    */
    isInterfaceControlVisible(interfaceControl: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-isInterfaceElementVisible.md Edit}
    
    * @private
    */
    isInterfaceElementVisible(interfaceElement: DeviceUIElement): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-perform.md Edit}
    
    * @private
    */
    perform(interfaceElement: DeviceUIElement, action: DeviceUIAction): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-performAction.md Edit}
    
    * @deprecated
    
    * @private
    */
    performAction(interfaceControl: string, action: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-saveTextureToGallery.md Edit}
    
    * @private
    */
    saveTextureToGallery(texture: Texture, galleryType: GalleryType, onSuccess: (response: string) => void, onFailure: (error: number, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-setMessageRecipients.md Edit}
    
    * @private
    */
    setMessageRecipients(users: SnapchatUser[], onSuccess: (response: string) => void, onFailure: (error: number, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-setScreenDimmingEnabled.md Edit}
    
    * @private
    */
    setScreenDimmingEnabled(enabled: boolean): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClientInterfaceSystem/methods/ClientInterfaceSystem-showInterfaceElementWithText.md Edit}
    
    * @private
    */
    showInterfaceElementWithText(interfaceElement: DeviceUIElement, headerId: string, descriptionId: string): boolean
    
}

/**
* Handles the mesh data of cloth and prepares it for cloth simulation. Also controls all the parameters of the cloth simulator and colliders.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/ClothVisual-description.md Edit}
*/
interface ClothVisual extends MaterialMeshVisual {
    /**
    * Adds a collider to the list of colliders.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-addCollider.md Edit}
    */
    addCollider(colliderComponent: ColliderComponent): void
    
    /**
    * Clears the colliders list.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-clearColliders.md Edit}
    */
    clearColliders(): void
    
    /**
    * Returns all available vertex colors on cloth mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-getAllColors.md Edit}
    */
    getAllColors(): vec4[]
    
    /**
    * Returns the vertex color by vertex index.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-getPointColorByIndex.md Edit}
    */
    getPointColorByIndex(index: number): vec4
    
    /**
    * Returns all the indices of vertices that are labeled by this color.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-getPointIndicesByColor.md Edit}
    */
    getPointIndicesByColor(color: vec4, colorMask: vec4b): number[]
    
    /**
    * Returns all the indices on the cloth mesh that are matching the color mask. Match means that the color has value on the channels which in colorMask is true.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-getPointIndicesByMask.md Edit}
    */
    getPointIndicesByMask(colorMask: vec4b): number[]
    
    /**
    * Gets binding SceneObject of the vertex.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-getVertexBinding.md Edit}
    */
    getVertexBinding(index: number): SceneObject
    
    /**
    * Gets simulation settings of the vertex.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-getVertexSettings.md Edit}
    */
    getVertexSettings(index: number): VertexSimulationSettings
    
    /**
    * Returns true if the Cloth Simulation feature is supported by the current device.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-isHardwareSupported.md Edit}
    */
    isHardwareSupported(): boolean
    
    /**
    * Returns true if the Cloth Simulation and resources are initialized. Always return false if device is not supported.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-isInitialized.md Edit}
    */
    isInitialized(): boolean
    
    /**
    * Removes collider by its index and returns the removed collider.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-removeColliderByIndex.md Edit}
    */
    removeColliderByIndex(index: number): ColliderComponent
    
    /**
    * Resets the cloth simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-resetSimulation.md Edit}
    */
    resetSimulation(): void
    
    /**
    * Sets the binding SceneObject for the vertex.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-setVertexBinding.md Edit}
    */
    setVertexBinding(index: number, bindingObj: SceneObject): void
    
    /**
    * Sets simulation settings of the vertex.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-setVertexSettings.md Edit}
    */
    setVertexSettings(index: number, vertexSettings: VertexSimulationSettings): void
    
    /**
    * Select bend mode to use (Isometric bending/Linear bending).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-bendMode.md Edit}
    */
    bendMode: ClothVisual.BendMode
    
    /**
    * BendStiffness value.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-bendStiffness.md Edit}
    */
    bendStiffness: number
    
    /**
    * BendStiffness value weight on all the VertexSettings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-bendStiffnessVertexWeight.md Edit}
    */
    bendStiffnessVertexWeight: number
    
    /**
    * List of colliders assigned.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-colliders.md Edit}
    */
    colliders: ColliderComponent[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-debugModeEnabled.md Edit}
    
    * @private
    */
    debugModeEnabled: boolean
    
    /**
    * The influence of the external body mesh acting on the cloth visual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-externalBodyMeshWeight.md Edit}
    */
    externalBodyMeshWeight: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-frameRate.md Edit}
    
    * @private
    */
    frameRate: number
    
    /**
    * Friction value.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-friction.md Edit}
    */
    friction: number
    
    /**
    * Friction value weight on all the VertexSettings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-frictionVertexWeight.md Edit}
    */
    frictionVertexWeight: number
    
    /**
    * Gravity force vector.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-gravity.md Edit}
    */
    gravity: vec3
    
    /**
    * Number of simulation iterations to perform per each step. Higher number contributes to higher quality, but can be difficult for device performance.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-iterationsPerStep.md Edit}
    */
    iterationsPerStep: number
    
    /**
    * Mass value.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-mass.md Edit}
    */
    mass: number
    
    /**
    * Mass value weight on all the VertexSettings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-massVertexWeight.md Edit}
    */
    massVertexWeight: number
    
    /**
    * Control for the acceleration on motion of vertices in cloth simulation, by default set to 2000.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-maxAcceleration.md Edit}
    */
    maxAcceleration: number
    
    /**
    * Whether to merge close vertices (Lens Studio might split vertices when loading FBX mesh). Changing this resets the simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-mergeCloseVerticesEnabled.md Edit}
    */
    mergeCloseVerticesEnabled: boolean
    
    /**
    * Threshold of close vertices. Changing this value resets the simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-mergeCloseVerticesThreshold.md Edit}
    */
    mergeCloseVerticesThreshold: number
    
    /**
    * Attached mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-mesh.md Edit}
    */
    mesh: RenderMesh
    
    /**
    * Function called when the ClothVisual is initialized.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-onInitialized.md Edit}
    */
    onInitialized: (clothVisual: ClothVisual) => void
    
    /**
    * Indicates whether we will enable collision repulsion with collider models.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-repulsionEnabled.md Edit}
    */
    repulsionEnabled: boolean
    
    /**
    * Collision friction to dampen relative motion.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-repulsionFriction.md Edit}
    */
    repulsionFriction: number
    
    /**
    * Indicates the offset we set when the cloth mesh is too close to the colliders.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-repulsionOffset.md Edit}
    */
    repulsionOffset: number
    
    /**
    * Indicates the stiffness of repulsion when collision.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-repulsionStiffness.md Edit}
    */
    repulsionStiffness: number
    
    /**
    * Returns the modified simulated mesh which can be used in another [RenderMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#RenderMeshVisual) if the same simulated mesh is needed. Useful when creating effects that might require the same mesh to be rendered twice, such as with a mirror effect. Prevents the need to run a simulation twice. 
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-simulatedMesh.md Edit}
    
    * @readonly
    */
    simulatedMesh: RenderMesh
    
    /**
    * StretchStiffness Value.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-stretchStiffness.md Edit}
    */
    stretchStiffness: number
    
    /**
    * StretchStiffness Value weight on all the VertexSettings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-stretchStiffnessVertexWeight.md Edit}
    */
    stretchStiffnessVertexWeight: number
    
    /**
    * Whether to update normals for the cloth mesh each frame in order to get reflection update.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/properties/ClothVisual-updateNormalsEnabled.md Edit}
    */
    updateNormalsEnabled: boolean
    
}
declare namespace ClothVisual {
    /**
    * Creates a new instance of vertex simulation settings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual/methods/ClothVisual-createVertexSettings.md Edit}
    */
    export function createVertexSettings(): VertexSimulationSettings
    

}

declare namespace ClothVisual {
    /**
    * Cloth bend mode to use for cloth simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual.BendMode/ClothVisual.BendMode-description.md Edit}
    */
    enum BendMode {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual.BendMode/properties/ClothVisual.BendMode-Isometric.md Edit}
        */
        Isometric,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ClothVisual.BendMode/properties/ClothVisual.BendMode-Linear.md Edit}
        */
        Linear
    }

}

/**
* Options associated with the listValues method call.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageListOptions/CloudStorageListOptions-description.md Edit}
*/
interface CloudStorageListOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageListOptions/properties/CloudStorageListOptions-collection.md Edit}
    
    * @private
    */
    collection: string
    
    /**
    * The position in the resulting list. Each time a list is requested, 10 entities are returned. If no cursor is provided, first 10 entities will be returned.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageListOptions/properties/CloudStorageListOptions-cursor.md Edit}
    */
    cursor: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageListOptions/properties/CloudStorageListOptions-limit.md Edit}
    
    * @private
    */
    limit: number
    
    /**
    * The scope of the listValues request. Required
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageListOptions/properties/CloudStorageListOptions-scope.md Edit}
    */
    scope: StorageScope
    
}
declare namespace CloudStorageListOptions {
    /**
    * Creates the listValues options object for Cloud Storage
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageListOptions/methods/CloudStorageListOptions-create.md Edit}
    */
    export function create(): CloudStorageListOptions
    

}

/**
* Provides access to Cloud Storage.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageModule/CloudStorageModule-description.md Edit}
*/
interface CloudStorageModule extends Asset {
    /**
    * Get the Cloud Store. Future calls to this method will return the same cloud store, even if the options change.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageModule/methods/CloudStorageModule-getCloudStore.md Edit}
    */
    getCloudStore(options: CloudStorageOptions, onCloudStoreReady: (store: CloudStore) => void, onError: (code: string, description: string) => void): void
    
}

/**
* Used to configure `Cloud Storage Module` with various options. Note: if `session` scoped storage is required, this option must be provided.


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageOptions/CloudStorageOptions-description.md Edit}
*/
interface CloudStorageOptions extends ScriptObject {
    /**
    * If session scoped storage is required, set this property with the session object from [Connected Lenses Module](https://lensstudio.snapchat.com/api/classes/ConnectedLensModule).
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageOptions/properties/CloudStorageOptions-session.md Edit}
    */
    session: MultiplayerSession
    
}
declare namespace CloudStorageOptions {
    /**
    * Create options for use with Cloud Storage.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageOptions/methods/CloudStorageOptions-create.md Edit}
    */
    export function create(): CloudStorageOptions
    

}

/**
* Options associated with the getValue/deleteValue methods for Cloud Storage.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageReadOptions/CloudStorageReadOptions-description.md Edit}
*/
interface CloudStorageReadOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageReadOptions/properties/CloudStorageReadOptions-collection.md Edit}
    
    * @private
    */
    collection: string
    
    /**
    * The scope of the request.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageReadOptions/properties/CloudStorageReadOptions-scope.md Edit}
    */
    scope: StorageScope
    
}
declare namespace CloudStorageReadOptions {
    /**
    * Options associated with the getValue/deleteValue methods for Cloud Storage.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageReadOptions/methods/CloudStorageReadOptions-create.md Edit}
    */
    export function create(): CloudStorageReadOptions
    

}

/**
* Options associated with the setValue method for Cloud Storage.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageWriteOptions/CloudStorageWriteOptions-description.md Edit}
*/
interface CloudStorageWriteOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageWriteOptions/properties/CloudStorageWriteOptions-collection.md Edit}
    
    * @private
    */
    collection: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageWriteOptions/properties/CloudStorageWriteOptions-dataPolicy.md Edit}
    
    * @private
    */
    dataPolicy: string
    
    /**
    * The scope of the write option.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageWriteOptions/properties/CloudStorageWriteOptions-scope.md Edit}
    */
    scope: StorageScope
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageWriteOptions/properties/CloudStorageWriteOptions-writePermissions.md Edit}
    
    * @private
    */
    writePermissions: WritePermissions
    
}
declare namespace CloudStorageWriteOptions {
    /**
    * Creates the setValue options object for Cloud Storage.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStorageWriteOptions/methods/CloudStorageWriteOptions-create.md Edit}
    */
    export function create(): CloudStorageWriteOptions
    

}

/**
* An instance of Cloud Storage that can store data in a multiplayer experience.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/CloudStore-description.md Edit}
*/
interface CloudStore extends ScriptObject {
    /**
    * Deletes a value from the persistence backend. Note that the scope must match that which was used when the value was originally saved.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-deleteValue.md Edit}
    */
    deleteValue(key: string, readOptions: CloudStorageReadOptions, onDeleted: () => void, onError: (code: string, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-deleteValueInternal.md Edit}
    
    * @private
    */
    deleteValueInternal(key: string, readOptions: CloudStorageReadOptions, onDeleted: () => void, onError: (code: string, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-getPersistedAsset.md Edit}
    
    * @private
    */
    getPersistedAsset(key: string, readOptions: CloudStorageReadOptions, onRetrieved: (collection: string, key: string, asset: Asset) => void, onError: (code: string, description: string) => void): void
    
    /**
    * Gets a value from the persistence backend. Note that scope must match that which was used when the value was originally saved.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-getValue.md Edit}
    */
    getValue(key: string, readOptions: CloudStorageReadOptions, onRetrieved: (key: string, value: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string)) => void, onError: (code: string, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-getValueInternal.md Edit}
    
    * @private
    */
    getValueInternal(key: string, readOptions: CloudStorageReadOptions, onRetrieved: (collection: string, key: string, value: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string)) => void, onError: (code: string, description: string) => void): void
    
    /**
    * Lists values from the persistence backend. Note that the scope must match that which was used when the values were originally saved.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-listValues.md Edit}
    */
    listValues(listOptions: CloudStorageListOptions, onRetrieved: (values: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string)[][], cursor: string) => void, onError: (code: string, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-listValuesInternal.md Edit}
    
    * @private
    */
    listValuesInternal(listOptions: CloudStorageListOptions, onRetrieved: (collection: string, values: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string)[][], cursor: string) => void, onError: (code: string, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-setPersistedAsset.md Edit}
    
    * @private
    */
    setPersistedAsset(key: string, writeOptions: CloudStorageWriteOptions, asset: Asset, onSaved: () => void, onError: (code: string, description: string) => void): void
    
    /**
    * Sets a value in the persistence backend.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-setValue.md Edit}
    */
    setValue(key: string, value: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string), writeOptions: CloudStorageWriteOptions, onSaved: () => void, onError: (code: string, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CloudStore/methods/CloudStore-setValueInternal.md Edit}
    
    * @private
    */
    setValueInternal(key: string, value: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string), writeOptions: CloudStorageWriteOptions, onSaved: () => void, onError: (code: string, description: string) => void): void
    
}

/**
* Collider used by the [Hair Visual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#HairVisual) for its simulation.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/ColliderComponent-description.md Edit}
*/
interface ColliderComponent extends Component {
    /**
    * Clears all velocities and forces on a collider.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/methods/ColliderComponent-clearMotion.md Edit}
    */
    clearMotion(): void
    
    /**
    * Angular velocity, expressed as an axis of rotation scaled by angular speed (radians/s).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-angularVelocity.md Edit}
    */
    angularVelocity: vec3
    
    /**
    * Expects a LevelsetColliderAsset. Contains distance field data which describes a collider's shape. A selection of default Levelset assets can be found in Resource->Add->Hairstyle Colliders
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-asset.md Edit}
    
    * @deprecated
    */
    asset: LevelsetColliderAsset
    
    /**
    * Toggle collider wire rendering for visualizing collider geometry shape and where it is placed.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-debugDrawEnabled.md Edit}
    */
    debugDrawEnabled: boolean
    
    /**
    * Collision filter to use for this collider.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-filter.md Edit}
    */
    filter: Filter
    
    /**
    * If enabled, the collider shape extends to fit the visual mesh, if any. Only applicable for Box and Sphere shapes.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-fitVisual.md Edit}
    */
    fitVisual: boolean
    
    /**
    * Nested collider/body components may be merged into compound shapes. By default, this occurs only for dynamic bodies and not for static colliders. If `forceCompound` is set, this occurs for static colliders as well.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-forceCompound.md Edit}
    */
    forceCompound: boolean
    
    /**
    * If enabled, the collider doesn't interact with the world but may still be detected with ray casts and intersection events.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-intangible.md Edit}
    */
    intangible: boolean
    
    /**
    * The matter used by the collider to define its physical substance, such as friction and bounciness.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-matter.md Edit}
    */
    matter: Matter
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-offset.md Edit}
    
    * @deprecated
    
    * @private
    */
    offset: vec3
    
    /**
    * Signals when objects initially collide.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-onCollisionEnter.md Edit}
    
    * @readonly
    */
    onCollisionEnter: event1<CollisionEnterEventArgs, void>
    
    /**
    * Signals when objects stop colliding.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-onCollisionExit.md Edit}
    
    * @readonly
    */
    onCollisionExit: event1<CollisionExitEventArgs, void>
    
    /**
    * Signals every frame while objects continue to collide.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-onCollisionStay.md Edit}
    
    * @readonly
    */
    onCollisionStay: event1<CollisionStayEventArgs, void>
    
    /**
    * Signals when colliders first overlap.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-onOverlapEnter.md Edit}
    
    * @readonly
    */
    onOverlapEnter: event1<OverlapEnterEventArgs, void>
    
    /**
    * Signals when colliders stop overlapping.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-onOverlapExit.md Edit}
    
    * @readonly
    */
    onOverlapExit: event1<OverlapExitEventArgs, void>
    
    /**
    * Signals every frame while colliders continue to overlap.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-onOverlapStay.md Edit}
    
    * @readonly
    */
    onOverlapStay: event1<OverlapStayEventArgs, void>
    
    /**
    * Collision filter used for overlap events.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-overlapFilter.md Edit}
    */
    overlapFilter: Filter
    
    /**
    * Smoothing spring factor, for rotation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-rotateSmoothFactor.md Edit}
    */
    rotateSmoothFactor: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-scale.md Edit}
    
    * @deprecated
    
    * @private
    */
    scale: vec3
    
    /**
    * The Shape object used for collision.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-shape.md Edit}
    */
    shape: Shape
    
    /**
    * Smooth transform changes using a dampened spring. Useful to reduce motion noise. This only applies to the simulation and changes from outside the simulation. The scene object's transform is not affected. It has no effect for dynamic bodies. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-smooth.md Edit}
    */
    smooth: boolean
    
    /**
    * Smoothing spring factor, for translation. This controls the restitution strength of the spring, so low values are smoother but lag more.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-translateSmoothFactor.md Edit}
    */
    translateSmoothFactor: number
    
    /**
    * Linear velocity (cm/s).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-velocity.md Edit}
    */
    velocity: vec3
    
    /**
    * The WorldSettingsAsset used by the collider to define the physics simulation settings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColliderComponent/properties/ColliderComponent-worldSettings.md Edit}
    */
    worldSettings: Physics.WorldSettingsAsset
    
}

/**
* A state generated for ColliderComponent collision events.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Collision/Collision-description.md Edit}
*/
interface Collision extends ScriptObject {
    /**
    * Primitive shapes that physics objects interact with, such as spheres, boxes, and meshes, or compound shapes formed from multiple shapes. Used with Physics, Hair Simulation and Cloth Simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Collision/properties/Collision-collider.md Edit}
    
    * @readonly
    */
    collider: ColliderComponent
    
    /**
    * The number of contact points in the collision.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Collision/properties/Collision-contactCount.md Edit}
    
    * @readonly
    */
    contactCount: number
    
    /**
    * Array of contacts in the collision.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Collision/properties/Collision-contacts.md Edit}
    
    * @readonly
    */
    contacts: Contact[]
    
    /**
    * ID of the collision, unique for this collider.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Collision/properties/Collision-id.md Edit}
    
    * @readonly
    */
    id: number
    
}

/**
* Args used for [ColliderComponent.onCollisionEnter](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ColliderComponent), which is triggered when a collision begins.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CollisionEnterEventArgs/CollisionEnterEventArgs-description.md Edit}
*/
interface CollisionEnterEventArgs extends ScriptObject {
    /**
    * Structure containing information about the current collision.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CollisionEnterEventArgs/properties/CollisionEnterEventArgs-collision.md Edit}
    
    * @readonly
    */
    collision: Collision
    
}

/**
* Args used for [ColliderComponent.onCollisionExit](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ColliderComponent), which is triggered when a collision ends.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CollisionExitEventArgs/CollisionExitEventArgs-description.md Edit}
*/
interface CollisionExitEventArgs extends ScriptObject {
    /**
    * Structure containing information about the current collision.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CollisionExitEventArgs/properties/CollisionExitEventArgs-collision.md Edit}
    
    * @readonly
    */
    collision: Collision
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CollisionMesh/CollisionMesh-description.md Edit}
*/
interface CollisionMesh extends Asset {
}

/**
* Args used for [ColliderComponent.onCollisionStay](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ColliderComponent), which is triggered every frame while a collision continues.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CollisionStayEventArgs/CollisionStayEventArgs-description.md Edit}
*/
interface CollisionStayEventArgs extends ScriptObject {
    /**
    * Structure containing information about the current collision.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CollisionStayEventArgs/properties/CollisionStayEventArgs-collision.md Edit}
    
    * @readonly
    */
    collision: Collision
    
}

/**
* Not usable from JS. Accessed via the Colocated Landmarks 2D Mesh resource. Contains the 2D keypoints when creating a Colocated map. Expanded by the material provided with template.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedLandmarks2DRenderObjectProvider/ColocatedLandmarks2DRenderObjectProvider-description.md Edit}
*/
interface ColocatedLandmarks2DRenderObjectProvider extends ColocatedLandmarksRenderObjectProviderBase {
}

/**
* Not usable from JS. Accessed via the Colocated Landmarks 3D Mesh resource. Contains the 3D landmarks when creating a Colocated map. Expanded by the material provided with template.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedLandmarks3DRenderObjectProvider/ColocatedLandmarks3DRenderObjectProvider-description.md Edit}
*/
interface ColocatedLandmarks3DRenderObjectProvider extends ColocatedLandmarksRenderObjectProviderBase {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedLandmarksRenderObjectProviderBase/ColocatedLandmarksRenderObjectProviderBase-description.md Edit}
*/
interface ColocatedLandmarksRenderObjectProviderBase extends RenderObjectProvider {
}

/**
* Creates Colocated Connected Lenses experiences by enabling the creation and tracking of a shared space which can be used to place several users in the same coordinate frame. This shared space will be made available and can be tracked by any friend you invite to join your session via Snapcode. Users are expected to be located in the same room when using the colocated feature. This component needs to be attached to the camera. 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/ColocatedTrackingComponent-description.md Edit}
*/
interface ColocatedTrackingComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/methods/ColocatedTrackingComponent-cancelBuilding.md Edit}
    
    * @private
    */
    cancelBuilding(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/methods/ColocatedTrackingComponent-finishBuilding.md Edit}
    
    * @private
    */
    finishBuilding(): void
    
    /**
    * Joins an existing session, retrieving the shared space that the colocated session initiator just created. Throws an exception if a join or build operation is in progress or if a shared space is already present.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/methods/ColocatedTrackingComponent-join.md Edit}
    */
    join(session: MultiplayerSession): void
    
    /**
    * Starts the shared space building process locally in the session initiator's device.
    
    * If a session is provided, the shared space is placed into the session after building has completed, which is required for Colocated experiences running on mobile devices. When running the experience in Lens Studio Preview or solo mode the session is not required.
    
    * Throws an exception if a join or build operation is in progress or if a map is already present.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/methods/ColocatedTrackingComponent-startBuilding.md Edit}
    */
    startBuilding(session: MultiplayerSession): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-buildingConfiguration.md Edit}
    
    * @private
    */
    buildingConfiguration: ColocatedTrackingComponent.BuildingConfiguration
    
    /**
    * Provides the shared space building progress expressed in values 0-1. These values can be used to populate a progress bar. Once this value has reached 1, the colocated tracking component attempts to share the space which the user created.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-buildingProgress.md Edit}
    
    * @readonly
    */
    buildingProgress: number
    
    /**
    * Indicates whether a shared space can be built on this device. Colocated Tracking is available on devices with ARKit/ARCore in the rear camera. This flag should be checked before attempting to build or join a session. If it is false, you should inform users: "Sorry, your device does not support shared AR experiences."
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-canBuild.md Edit}
    
    * @readonly
    */
    canBuild: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-canFinishBuilding.md Edit}
    
    * @readonly
    
    * @private
    */
    canFinishBuilding: boolean
    
    /**
    * Indicates whether a shared space is present and ready to be tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-canTrack.md Edit}
    
    * @readonly
    */
    canTrack: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-capacityUsed.md Edit}
    
    * @readonly
    
    * @private
    */
    capacityUsed: number
    
    /**
    * Indicates whether a shared space building operation is in progress. Once the flag is false, the shared space still needs to be shared. Use `onTrackingAvailable` to determine when your space has been shared.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-isBuilding.md Edit}
    
    * @readonly
    */
    isBuilding: boolean
    
    /**
    * Indicates whether a session joining operation is in progress.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-isJoining.md Edit}
    
    * @readonly
    */
    isJoining: boolean
    
    /**
    * Indicates whether a shared space is actively being tracked. This value will be true while tracking is active, either with or without the shared space in view. This property matches the equivalent one in `MarkerTrackingComponent`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-isTracking.md Edit}
    
    * @readonly
    */
    isTracking: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-maximumSize.md Edit}
    
    * @private
    */
    maximumSize: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-minimumSize.md Edit}
    
    * @private
    */
    minimumSize: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-model.md Edit}
    
    * @private
    */
    model: LocalizationModel
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-onBuildCancelled.md Edit}
    
    * @readonly
    
    * @private
    */
    onBuildCancelled: event0<void>
    
    /**
    * Event fired when the building operation fails (for example, sharing your space failed). Once `onTrackingAvailable` event is triggered, this event will not be triggered anymore. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-onBuildFailed.md Edit}
    
    * @readonly
    */
    onBuildFailed: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-onBuildFinished.md Edit}
    
    * @readonly
    
    * @private
    */
    onBuildFinished: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-onCanFinishBuilding.md Edit}
    
    * @readonly
    
    * @private
    */
    onCanFinishBuilding: event0<void>
    
    /**
    * Event fired when a shared space starts being actively tracked. This property is an analogue of the `onMarkerFound` property in `MarkerTrackingComponent`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-onFound.md Edit}
    
    * @readonly
    */
    onFound: event0<void>
    
    /**
    * Event fired when a join operation completes but no shared space was found in the session.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-onJoinFailed.md Edit}
    
    * @readonly
    */
    onJoinFailed: event0<void>
    
    /**
    * Event fired when a shared space stops being actively tracked. This property is an analogue of the `onMarkerLost` property in `MarkerTrackingComponent`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-onLost.md Edit}
    
    * @readonly
    */
    onLost: event0<void>
    
    /**
    * Event fired when a shared space has been shared or received and the device can attempt to start tracking.  If this event is not being triggered for a long period, the process will time out and `onBuildFailed` event will be triggered.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-onTrackingAvailable.md Edit}
    
    * @readonly
    */
    onTrackingAvailable: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent/properties/ColocatedTrackingComponent-quality.md Edit}
    
    * @readonly
    
    * @private
    */
    quality: number
    
}

declare namespace ColocatedTrackingComponent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent.BuildingConfiguration/ColocatedTrackingComponent.BuildingConfiguration-description.md Edit}
    
    * @private
    */
    enum BuildingConfiguration {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent.BuildingConfiguration/properties/ColocatedTrackingComponent.BuildingConfiguration-Colocated.md Edit}
        
        * @private
        */
        Colocated,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ColocatedTrackingComponent.BuildingConfiguration/properties/ColocatedTrackingComponent.BuildingConfiguration-CustomLandmarker.md Edit}
        
        * @private
        */
        CustomLandmarker
    }

}

/**
* Data type used for color values.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/Colorspace-description.md Edit}
*/
declare enum Colorspace {
    /**
    * Color data has one value: Red
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-R.md Edit}
    */
    R,
    /**
    * Color data has 2 values: Red, Green
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-RG.md Edit}
    */
    RG,
    /**
    * Color data has 4 values: Red, Green, Blue, Alpha
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-RGBA.md Edit}
    */
    RGBA,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-RedFloat.md Edit}
    */
    RedFloat,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-RGFloat.md Edit}
    */
    RGFloat,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-RGBAFloat.md Edit}
    
    * @unreleased
    */
    RGBAFloat,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-RGBAFloat16.md Edit}
    
    * @unreleased
    */
    RGBAFloat16,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-RGFloat16.md Edit}
    
    * @unreleased
    */
    RGFloat16,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Colorspace/properties/Colorspace-Red.md Edit}
    
    * @deprecated
    */
    Red
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompassAccuracy/CompassAccuracy-description.md Edit}

* @private
*/
declare enum CompassAccuracy {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompassAccuracy/properties/CompassAccuracy-NoContact.md Edit}
    
    * @private
    */
    NoContact,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompassAccuracy/properties/CompassAccuracy-High.md Edit}
    
    * @private
    */
    High,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompassAccuracy/properties/CompassAccuracy-Medium.md Edit}
    
    * @private
    */
    Medium,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompassAccuracy/properties/CompassAccuracy-Low.md Edit}
    
    * @private
    */
    Low,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompassAccuracy/properties/CompassAccuracy-Unreliable.md Edit}
    
    * @private
    */
    Unreliable
}

/**
* The base class for all components.  Components are attached to [SceneObjects](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#SceneObject).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Component/Component-description.md Edit}
*/
interface Component extends SerializableWithUID {
    /**
    * Destroys the component.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Component/methods/Component-destroy.md Edit}
    */
    destroy(): void
    
    /**
    * Returns the SceneObject the component is attached to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Component/methods/Component-getSceneObject.md Edit}
    */
    getSceneObject(): SceneObject
    
    /**
    * Returns the Transform this component is attached to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Component/methods/Component-getTransform.md Edit}
    */
    getTransform(): Transform
    
    /**
    * If disabled, the Component will stop enacting its behavior.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Component/properties/Component-enabled.md Edit}
    */
    enabled: boolean
    
    /**
    * The name of the Component.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Component/properties/Component-name.md Edit}
    
    * @private
    */
    name: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Component/properties/Component-sceneObject.md Edit}
    
    * @readonly
    */
    sceneObject: SceneObject
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Component/properties/Component-updatePriority.md Edit}
    
    * @private
    */
    updatePriority: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ComponentDisabledEvent/ComponentDisabledEvent-description.md Edit}

* @private
*/
interface ComponentDisabledEvent extends ComponentEvent {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ComponentEnabledEvent/ComponentEnabledEvent-description.md Edit}

* @private
*/
interface ComponentEnabledEvent extends ComponentEvent {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ComponentEvent/ComponentEvent-description.md Edit}

* @private
*/
interface ComponentEvent extends SceneEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ComponentEvent/methods/ComponentEvent-getDeltaTime.md Edit}
    
    * @private
    */
    getDeltaTime(): number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompressionQuality/CompressionQuality-description.md Edit}

* @private
*/
declare enum CompressionQuality {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompressionQuality/properties/CompressionQuality-MaximumCompression.md Edit}
    
    * @private
    */
    MaximumCompression,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompressionQuality/properties/CompressionQuality-LowQuality.md Edit}
    
    * @private
    */
    LowQuality,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompressionQuality/properties/CompressionQuality-IntermediateQuality.md Edit}
    
    * @private
    */
    IntermediateQuality,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompressionQuality/properties/CompressionQuality-HighQuality.md Edit}
    
    * @private
    */
    HighQuality,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CompressionQuality/properties/CompressionQuality-MaximumQuality.md Edit}
    
    * @private
    */
    MaximumQuality
}

/**
* A cone collision shape.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConeShape/ConeShape-description.md Edit}
*/
interface ConeShape extends Shape {
    /**
    * Lengthwise local axis along which the cone is oriented.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConeShape/properties/ConeShape-axis.md Edit}
    */
    axis: Axis
    
    /**
    * The length of the cone.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConeShape/properties/ConeShape-length.md Edit}
    */
    length: number
    
    /**
    * The radius of the cone.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConeShape/properties/ConeShape-radius.md Edit}
    */
    radius: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConfigurationReader/ConfigurationReader-description.md Edit}

* @private
*/
interface ConfigurationReader {
}
declare namespace ConfigurationReader {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConfigurationReader/methods/ConfigurationReader-getBooleanAsync.md Edit}
    
    * @private
    */
    export function getBooleanAsync(key: string, defaultValue: boolean, onConfigurationReadOrTimeout: (Arg: boolean) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConfigurationReader/methods/ConfigurationReader-getByteArrayAsync.md Edit}
    
    * @private
    */
    export function getByteArrayAsync(key: string, defaultValue: number[], onConfigurationReadOrTimeout: (Arg: number[]) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConfigurationReader/methods/ConfigurationReader-getFloatAsync.md Edit}
    
    * @private
    */
    export function getFloatAsync(key: string, defaultValue: number, onConfigurationReadOrTimeout: (Arg: number) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConfigurationReader/methods/ConfigurationReader-getIntAsync.md Edit}
    
    * @private
    */
    export function getIntAsync(key: string, defaultValue: number, onConfigurationReadOrTimeout: (Arg: number) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConfigurationReader/methods/ConfigurationReader-getLongAsync.md Edit}
    
    * @private
    */
    export function getLongAsync(key: string, defaultValue: number, onConfigurationReadOrTimeout: (Arg: number) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConfigurationReader/methods/ConfigurationReader-getStringAsync.md Edit}
    
    * @private
    */
    export function getStringAsync(key: string, defaultValue: string, onConfigurationReadOrTimeout: (Arg: string) => void): void
    

}

/**
* Event fired when the "Launch connected lens" button was pressed. Wait for this event to be triggered before creating a session, as having this event gaurantees the user has accepted the necessary disclosures to use a connected lens experience.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensEnteredEvent/ConnectedLensEnteredEvent-description.md Edit}
*/
interface ConnectedLensEnteredEvent extends SceneEvent {
}

/**
* Connected Lenses Module allows use of networked Lens communication capabilities (real-time communication, co-located session creation and joining, and shared persistent storage). It's recommended to only use one ConnectedLensModule per Lens.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule/ConnectedLensModule-description.md Edit}
*/
interface ConnectedLensModule extends Asset {
    /**
    * Create session with the provided options. Will also check if there is a session that can be created from a session sharetype received from other users.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule/methods/ConnectedLensModule-createSession.md Edit}
    */
    createSession(sessionOptions: ConnectedLensSessionOptions): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule/methods/ConnectedLensModule-recordScore.md Edit}
    
    * @private
    */
    recordScore(score: number): void
    
    /**
    * Share the session with other users, specified by the SessionShareType. Note that if shared via Invitation, a new session will be created. Expect a new onConnected callback with the new session being passed in.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule/methods/ConnectedLensModule-shareSession.md Edit}
    */
    shareSession(sessionShareType: ConnectedLensModule.SessionShareType, onSessionShared: (session: MultiplayerSession, snapcode: Texture) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule/methods/ConnectedLensModule-showLeaderboard.md Edit}
    
    * @private
    */
    showLeaderboard(): void
    
}

declare namespace ConnectedLensModule {
    /**
    * Information that is bootstrapped to the user who just connected to the session.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.ConnectionInfo/ConnectedLensModule.ConnectionInfo-description.md Edit}
    */
    interface ConnectionInfo extends ScriptObject {
        /**
        * Get the information about all the other users connected to the same session. 
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.ConnectionInfo/properties/ConnectedLensModule.ConnectionInfo-externalUsersInfo.md Edit}
        
        * @readonly
        */
        externalUsersInfo: ConnectedLensModule.UserInfo[]
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.ConnectionInfo/properties/ConnectedLensModule.ConnectionInfo-hostUserInfo.md Edit}
        
        * @readonly
        */
        hostUserInfo: ConnectedLensModule.UserInfo
        
        /**
        * Get the information about the local user.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.ConnectionInfo/properties/ConnectedLensModule.ConnectionInfo-localUserInfo.md Edit}
        
        * @readonly
        */
        localUserInfo: ConnectedLensModule.UserInfo
        
        /**
        * Get all the Realtime Stores that are being used in the session.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.ConnectionInfo/properties/ConnectedLensModule.ConnectionInfo-realtimeStores.md Edit}
        
        * @readonly
        */
        realtimeStores: GeneralDataStore[]
        
        /**
        * Provides creation info about every existing RealtimeStore.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.ConnectionInfo/properties/ConnectedLensModule.ConnectionInfo-realtimeStoresCreationInfos.md Edit}
        
        * @readonly
        */
        realtimeStoresCreationInfos: ConnectedLensModule.RealtimeStoreCreationInfo[]
        
    }

}

declare namespace ConnectedLensModule {
    /**
    * Information about the host update.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.HostUpdateInfo/ConnectedLensModule.HostUpdateInfo-description.md Edit}
    */
    interface HostUpdateInfo extends ScriptObject {
        /**
        * Provides the server timestamp (in milliseconds) of when the host was updated.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.HostUpdateInfo/properties/ConnectedLensModule.HostUpdateInfo-sentServerTimeMilliseconds.md Edit}
        
        * @readonly
        */
        sentServerTimeMilliseconds: number
        
        /**
        * Information about the new host user. 
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.HostUpdateInfo/properties/ConnectedLensModule.HostUpdateInfo-userInfo.md Edit}
        
        * @readonly
        */
        userInfo: ConnectedLensModule.UserInfo
        
    }

}

declare namespace ConnectedLensModule {
    /**
    * Provides extra context about a RealtimeStore's creation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreCreationInfo/ConnectedLensModule.RealtimeStoreCreationInfo-description.md Edit}
    */
    interface RealtimeStoreCreationInfo extends ScriptObject {
        /**
        * If true, ownership of the store can be claimed even if the store is already owned.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreCreationInfo/properties/ConnectedLensModule.RealtimeStoreCreationInfo-allowOwnershipTakeOver.md Edit}
        
        * @readonly
        */
        allowOwnershipTakeOver: boolean
        
        /**
        * Provides the server timestamp (in milliseconds) of the last time the store was updated.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreCreationInfo/properties/ConnectedLensModule.RealtimeStoreCreationInfo-lastUpdatedServerTimestamp.md Edit}
        
        * @readonly
        */
        lastUpdatedServerTimestamp: number
        
        /**
        * Provides the UserInfo of the current owner of the RealtimeStore. If the store is unowned, a UserInfo object with null fields will be returned.
        
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreCreationInfo/properties/ConnectedLensModule.RealtimeStoreCreationInfo-ownerInfo.md Edit}
        
        * @readonly
        */
        ownerInfo: ConnectedLensModule.UserInfo
        
        /**
        * The persistence setting that the store was created with.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreCreationInfo/properties/ConnectedLensModule.RealtimeStoreCreationInfo-persistence.md Edit}
        
        * @readonly
        */
        persistence: RealtimeStoreCreateOptions.Persistence
        
        /**
        * Provides the server timestamp (in milliseconds) of when the store was created.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreCreationInfo/properties/ConnectedLensModule.RealtimeStoreCreationInfo-sentServerTimeMilliseconds.md Edit}
        
        * @readonly
        */
        sentServerTimeMilliseconds: number
        
        /**
        * A string that can be used to identify the RealtimeStore.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreCreationInfo/properties/ConnectedLensModule.RealtimeStoreCreationInfo-storeId.md Edit}
        
        * @readonly
        */
        storeId: string
        
    }

}

declare namespace ConnectedLensModule {
    /**
    * Gives information about the Realtime Store delete operation. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreDeleteInfo/ConnectedLensModule.RealtimeStoreDeleteInfo-description.md Edit}
    */
    interface RealtimeStoreDeleteInfo extends ScriptObject {
        /**
        * Get the information of the user who deleted the Store.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreDeleteInfo/properties/ConnectedLensModule.RealtimeStoreDeleteInfo-deleterInfo.md Edit}
        
        * @readonly
        */
        deleterInfo: ConnectedLensModule.UserInfo
        
        /**
        * Provides the server timestamp (in milliseconds) of when the store was deleted.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreDeleteInfo/properties/ConnectedLensModule.RealtimeStoreDeleteInfo-sentServerTimeMilliseconds.md Edit}
        
        * @readonly
        */
        sentServerTimeMilliseconds: number
        
    }

}

declare namespace ConnectedLensModule {
    /**
    * Provides information about a key being removed from a RealtimeStore.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreKeyRemovalInfo/ConnectedLensModule.RealtimeStoreKeyRemovalInfo-description.md Edit}
    */
    interface RealtimeStoreKeyRemovalInfo extends ScriptObject {
        /**
        * Key of the property that was removed.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreKeyRemovalInfo/properties/ConnectedLensModule.RealtimeStoreKeyRemovalInfo-key.md Edit}
        
        * @readonly
        */
        key: string
        
        /**
        * User that removed the key.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreKeyRemovalInfo/properties/ConnectedLensModule.RealtimeStoreKeyRemovalInfo-removerInfo.md Edit}
        
        * @readonly
        */
        removerInfo: ConnectedLensModule.UserInfo
        
        /**
        * Provides the server timestamp (in milliseconds) of when the key was removed.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreKeyRemovalInfo/properties/ConnectedLensModule.RealtimeStoreKeyRemovalInfo-sentServerTimeMilliseconds.md Edit}
        
        * @readonly
        */
        sentServerTimeMilliseconds: number
        
        /**
        * The RealtimeStore that the key was removed from.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreKeyRemovalInfo/properties/ConnectedLensModule.RealtimeStoreKeyRemovalInfo-store.md Edit}
        
        * @readonly
        */
        store: GeneralDataStore
        
    }

}

declare namespace ConnectedLensModule {
    /**
    * Provides information about a RealtimeStore's ownership being updated.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreOwnershipUpdateInfo/ConnectedLensModule.RealtimeStoreOwnershipUpdateInfo-description.md Edit}
    */
    interface RealtimeStoreOwnershipUpdateInfo extends ScriptObject {
        /**
        * Provides the server timestamp (in milliseconds) of when the store ownership was updated.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreOwnershipUpdateInfo/properties/ConnectedLensModule.RealtimeStoreOwnershipUpdateInfo-sentServerTimeMilliseconds.md Edit}
        
        * @readonly
        */
        sentServerTimeMilliseconds: number
        
    }

}

declare namespace ConnectedLensModule {
    /**
    * Gives information about the Realtime Store update operation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreUpdateInfo/ConnectedLensModule.RealtimeStoreUpdateInfo-description.md Edit}
    */
    interface RealtimeStoreUpdateInfo extends ScriptObject {
        /**
        * Provides the server timestamp (in milliseconds) of when the store was updated.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreUpdateInfo/properties/ConnectedLensModule.RealtimeStoreUpdateInfo-sentServerTimeMilliseconds.md Edit}
        
        * @readonly
        */
        sentServerTimeMilliseconds: number
        
        /**
        * Get the information of the user who updated the store.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.RealtimeStoreUpdateInfo/properties/ConnectedLensModule.RealtimeStoreUpdateInfo-updaterInfo.md Edit}
        
        * @readonly
        */
        updaterInfo: ConnectedLensModule.UserInfo
        
    }

}

declare namespace ConnectedLensModule {
    /**
    * Used by ConnectedLensesModule to specify the session share type.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.SessionShareType/ConnectedLensModule.SessionShareType-description.md Edit}
    */
    enum SessionShareType {
        /**
        * Share a session by inviting your friends, launching the "send to" screen.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.SessionShareType/properties/ConnectedLensModule.SessionShareType-Invitation.md Edit}
        */
        Invitation,
        /**
        * Share session via Snapcode that your friends can scan.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.SessionShareType/properties/ConnectedLensModule.SessionShareType-Snapcode.md Edit}
        */
        Snapcode
    }

}

declare namespace ConnectedLensModule {
    /**
    * Provides information about a user in a Connected Lens session.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.UserInfo/ConnectedLensModule.UserInfo-description.md Edit}
    */
    interface UserInfo extends ScriptObject {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.UserInfo/properties/ConnectedLensModule.UserInfo-bitmojiAvatarId.md Edit}
        
        * @readonly
        
        * @private
        */
        bitmojiAvatarId: string
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.UserInfo/properties/ConnectedLensModule.UserInfo-connectionId.md Edit}
        
        * @readonly
        */
        connectionId: string
        
        /**
        * The current display name of the user.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.UserInfo/properties/ConnectedLensModule.UserInfo-displayName.md Edit}
        
        * @readonly
        */
        displayName: string
        
        /**
        * Provides the server timestamp (in milliseconds) that the user joined the session.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.UserInfo/properties/ConnectedLensModule.UserInfo-joinServerTimeMilliseconds.md Edit}
        
        * @readonly
        */
        joinServerTimeMilliseconds: number
        
        /**
        * A unique identifier for each participant of connected lens experience. It is unique per lens for each user.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensModule.UserInfo/properties/ConnectedLensModule.UserInfo-userId.md Edit}
        
        * @readonly
        */
        userId: string
        
    }

}

/**
* Settings for configuring a Connected Lens session.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/ConnectedLensSessionOptions-description.md Edit}
*/
interface ConnectedLensSessionOptions extends DirectMultiplayerSessionOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/properties/ConnectedLensSessionOptions-appInstanceId.md Edit}
    
    * @private
    */
    appInstanceId: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/properties/ConnectedLensSessionOptions-leaderboardId.md Edit}
    
    * @private
    */
    leaderboardId: string
    
    /**
    * Defines maximum number of receipients that a user of connected lens can select while sharing a connected lens session via Invitation flow.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/properties/ConnectedLensSessionOptions-maxNumberOfInvitations.md Edit}
    */
    maxNumberOfInvitations: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/properties/ConnectedLensSessionOptions-maxNumberOfPlayers.md Edit}
    
    * @deprecated
    
    * @private
    */
    maxNumberOfPlayers: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/properties/ConnectedLensSessionOptions-onLeaderboardDismissed.md Edit}
    
    * @private
    */
    onLeaderboardDismissed: () => void
    
    /**
    * Function called when the session is created. The session creation type in this callback can be used to tell if the session is being created from scratch, or is being received from another user.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/properties/ConnectedLensSessionOptions-onSessionCreated.md Edit}
    */
    onSessionCreated: (session: MultiplayerSession, sessionCreationType: ConnectedLensSessionOptions.SessionCreationType) => void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/properties/ConnectedLensSessionOptions-sessionId.md Edit}
    
    * @private
    */
    sessionId: string
    
}
declare namespace ConnectedLensSessionOptions {
    /**
    * Create a new ConnectedLensesOptions object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions/methods/ConnectedLensSessionOptions-create.md Edit}
    */
    export function create(): ConnectedLensSessionOptions
    

}

declare namespace ConnectedLensSessionOptions {
    /**
    * Type of the created Connected Lens session.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions.SessionCreationType/ConnectedLensSessionOptions.SessionCreationType-description.md Edit}
    */
    enum SessionCreationType {
        /**
        * New Session was created.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions.SessionCreationType/properties/ConnectedLensSessionOptions.SessionCreationType-New.md Edit}
        */
        New,
        /**
        * Session was joined via invite.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions.SessionCreationType/properties/ConnectedLensSessionOptions.SessionCreationType-MultiplayerReceiver.md Edit}
        */
        MultiplayerReceiver,
        /**
        * A Connected Lens session with only the current user.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConnectedLensSessionOptions.SessionCreationType/properties/ConnectedLensSessionOptions.SessionCreationType-NewSoloMode.md Edit}
        */
        NewSoloMode
    }

}

/**
* Constraints body motion in configurable ways, for simulating physical objects such as joints and hinges.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Constraint/Constraint-description.md Edit}
*/
interface Constraint extends ScriptObject {
    /**
    * The type of constraint that is applied.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Constraint/properties/Constraint-constraintType.md Edit}
    
    * @readonly
    */
    constraintType: Physics.ConstraintType
    
}

/**
* Used to apply a constraint to an object.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConstraintComponent/ConstraintComponent-description.md Edit}
*/
interface ConstraintComponent extends Component {
    /**
    * The target is attached to the constraint by a fixed local-space matrix, calculated from the difference between the target's and the constraint's world-space transforms. This local-space matrix is generated on-load, or whenever the target is changed. Call this function to explicitly recalculate it for the current world-space transforms.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConstraintComponent/methods/ConstraintComponent-reanchorTarget.md Edit}
    */
    reanchorTarget(): void
    
    /**
    * Dictates constraint type and settings. Note, when setting this field it creates a copy of the constraint, rather than referencing it. So if you intend to modify the constraint after assigning it, you must do so on the component's constraint field, rather than the source constraint object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConstraintComponent/properties/ConstraintComponent-constraint.md Edit}
    */
    constraint: Constraint
    
    /**
    * Show the constraint with debug-draw.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConstraintComponent/properties/ConstraintComponent-debugDrawEnabled.md Edit}
    */
    debugDrawEnabled: boolean
    
    /**
    * Reference to connected target collider. If null, constraint target is attached to a fixed world transform.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ConstraintComponent/properties/ConstraintComponent-target.md Edit}
    */
    target: ColliderComponent
    
}

/**
* Contact point between two colliding objects.  See also: [ColliderComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ColliderComponent), [CollisionEnterEventArgs](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#CollisionEnterEventArgs), [CollisionExitEventArgs](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#CollisionExitEventArgs), [CollisionStayEventArgs](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#CollisionStayEventArgs).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Contact/Contact-description.md Edit}
*/
interface Contact extends ScriptObject {
    /**
    * Distance along the normal between the hit collider and this collider.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Contact/properties/Contact-distance.md Edit}
    
    * @readonly
    */
    distance: number
    
    /**
    * Impulse (kg*cm/s) applied along the normal in response to the collision.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Contact/properties/Contact-impulse.md Edit}
    
    * @readonly
    */
    impulse: number
    
    /**
    * Normal on the hit collider.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Contact/properties/Contact-normal.md Edit}
    
    * @readonly
    */
    normal: vec3
    
    /**
    * Position on the hit collider.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Contact/properties/Contact-position.md Edit}
    
    * @readonly
    */
    position: vec3
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreMLModule/CoreMLModule-description.md Edit}

* @private
*/
interface CoreMLModule extends Asset {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreVersionChecks/CoreVersionChecks-description.md Edit}

* @private
*/
interface CoreVersionChecks extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreVersionChecks/methods/CoreVersionChecks-forceFixedDateFormatting.md Edit}
    
    * @private
    */
    forceFixedDateFormatting(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreVersionChecks/methods/CoreVersionChecks-forceFixedMeshSnapInternalTransformBehavior.md Edit}
    
    * @private
    */
    forceFixedMeshSnapInternalTransformBehavior(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreVersionChecks/methods/CoreVersionChecks-forceFixedPinToMeshInternalTransformBehavior.md Edit}
    
    * @private
    */
    forceFixedPinToMeshInternalTransformBehavior(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreVersionChecks/methods/CoreVersionChecks-forceImmediateScriptCallbackExecution.md Edit}
    
    * @private
    */
    forceImmediateScriptCallbackExecution(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreVersionChecks/methods/CoreVersionChecks-forceLightEstimationForDynamicEnvMapFaceMode.md Edit}
    
    * @private
    */
    forceLightEstimationForDynamicEnvMapFaceMode(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreVersionChecks/methods/CoreVersionChecks-forceMLAssetAsyncLoad.md Edit}
    
    * @private
    */
    forceMLAssetAsyncLoad(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CoreVersionChecks/methods/CoreVersionChecks-forceWorldSpaceRectForText.md Edit}
    
    * @private
    */
    forceWorldSpaceRectForText(): void
    
}

/**
* Base class for Texture Providers that crop an input texture.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CropTextureProvider/CropTextureProvider-description.md Edit}
*/
interface CropTextureProvider extends TextureProvider {
    /**
    * Input texture to crop.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CropTextureProvider/properties/CropTextureProvider-inputTexture.md Edit}
    */
    inputTexture: Texture
    
}

/**
* Used with [Pass's](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#Pass) `cullMode` property.
* Determines which faces of a surface are culled (not rendered).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CullMode/CullMode-description.md Edit}
*/
declare enum CullMode {
    /**
    * Front facing surfaces are not rendered.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CullMode/properties/CullMode-Front.md Edit}
    */
    Front,
    /**
    * Back facing surfaces are not rendered.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CullMode/properties/CullMode-Back.md Edit}
    */
    Back,
    /**
    * Neither front facing nor back facing surfaces are rendered.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CullMode/properties/CullMode-FrontAndBack.md Edit}
    */
    FrontAndBack
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomClientUIActionEvent/CustomClientUIActionEvent-description.md Edit}

* @private
*/
interface CustomClientUIActionEvent extends SceneEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomClientUIActionEvent/properties/CustomClientUIActionEvent-uiAction.md Edit}
    
    * @readonly
    
    * @private
    */
    uiAction: DeviceUIAction
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomClientUIActionEvent/properties/CustomClientUIActionEvent-uiElement.md Edit}
    
    * @readonly
    
    * @private
    */
    uiElement: DeviceUIElement
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers/CustomLandmarkers-description.md Edit}

* @private
*/
interface CustomLandmarkers {
}
declare namespace CustomLandmarkers {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers/methods/CustomLandmarkers-createCustomLocationBuilder.md Edit}
    
    * @private
    */
    export function createCustomLocationBuilder(): CustomLandmarkers.CustomLocationBuilder
    

}

declare namespace CustomLandmarkers {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/CustomLandmarkers.CustomLocationBuilder-description.md Edit}
    
    * @private
    */
    interface CustomLocationBuilder extends ScriptObject {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/methods/CustomLandmarkers.CustomLocationBuilder-postProcess.md Edit}
        
        * @private
        */
        postProcess(onSuccess: () => void): void
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/methods/CustomLandmarkers.CustomLocationBuilder-publish.md Edit}
        
        * @private
        */
        publish(publishedCallback: (locationAsset: LocationAsset) => void, publishFailedCallback: (error: string) => void): void
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/methods/CustomLandmarkers.CustomLocationBuilder-publishPublicly.md Edit}
        
        * @private
        */
        publishPublicly(publishedCallback: (locationAsset: LocationAsset) => void, publishFailedCallback: (error: string) => void): void
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/properties/CustomLandmarkers.CustomLocationBuilder-appId.md Edit}
        
        * @private
        */
        appId?: string
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/properties/CustomLandmarkers.CustomLocationBuilder-localizationModel.md Edit}
        
        * @private
        */
        localizationModel: LocalizationModel
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/properties/CustomLandmarkers.CustomLocationBuilder-locationId.md Edit}
        
        * @private
        */
        locationId?: string
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/properties/CustomLandmarkers.CustomLocationBuilder-mapSource.md Edit}
        
        * @private
        */
        mapSource: ColocatedTrackingComponent
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/properties/CustomLandmarkers.CustomLocationBuilder-mesh.md Edit}
        
        * @private
        */
        mesh: RenderMesh
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/properties/CustomLandmarkers.CustomLocationBuilder-meshSource.md Edit}
        
        * @private
        */
        meshSource: WorldRenderObjectProvider
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/properties/CustomLandmarkers.CustomLocationBuilder-name.md Edit}
        
        * @private
        */
        name: string
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder/properties/CustomLandmarkers.CustomLocationBuilder-readPermission.md Edit}
        
        * @private
        */
        readPermission: CustomLandmarkers.CustomLocationBuilder.Permission
        
    }

}

declare namespace CustomLandmarkers {
    namespace CustomLocationBuilder {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder.Permission/CustomLandmarkers.CustomLocationBuilder.Permission-description.md Edit}
        
        * @private
        */
        enum Permission {
            /**
            * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder.Permission/properties/CustomLandmarkers.CustomLocationBuilder.Permission-Public.md Edit}
            
            * @private
            */
            Public,
            /**
            * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CustomLandmarkers.CustomLocationBuilder.Permission/properties/CustomLandmarkers.CustomLocationBuilder.Permission-Private.md Edit}
            
            * @private
            */
            Private
        }
    
    }

}

/**
* A cylinder collision shape.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CylinderShape/CylinderShape-description.md Edit}
*/
interface CylinderShape extends Shape {
    /**
    * Lengthwise local axis along which the cylinder is oriented.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CylinderShape/properties/CylinderShape-axis.md Edit}
    */
    axis: Axis
    
    /**
    * The length of the cylinder.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CylinderShape/properties/CylinderShape-length.md Edit}
    */
    length: number
    
    /**
    * The radius of the cylinder.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/CylinderShape/properties/CylinderShape-radius.md Edit}
    */
    radius: number
    
}

/**
* Provides access to external data. Do not add multiple data components to the same scene, since they will interfere with each other. Instead, always have a single data component.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataComponent/DataComponent-description.md Edit}

* @deprecated

* @private
*/
interface DataComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataComponent/methods/DataComponent-activateProvider.md Edit}
    
    * @private
    */
    activateProvider(type: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataComponent/methods/DataComponent-activateProviderWithCallback.md Edit}
    
    * @private
    */
    activateProviderWithCallback(type: string, callback: (data: AbstractData) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataComponent/methods/DataComponent-deactivateProvider.md Edit}
    
    * @private
    */
    deactivateProvider(type: string): void
    
    /**
    * Allows you to access the data provider for the specified input. Possible inputs are:
    
    * Input | Return Type
    * --- | ---
    * "UserData"     | [`GeneralDataStore`](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#GeneralDataStore)
    * "Location" | `Location`
    * "Bitmoji3D" | `Bitmoji3D`
    * "SceneRecognition" | `SceneRecognition`
    * "Segmentation" | `SegmentationSystem`
    * "DeviceMotion" | `DeviceMotion`
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataComponent/methods/DataComponent-getData.md Edit}
    
    * @private
    */
    getData(type: string): AbstractData
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreComponent/DataStoreComponent-description.md Edit}

* @private
*/
interface DataStoreComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreComponent/properties/DataStoreComponent-store.md Edit}
    
    * @private
    */
    store: GeneralDataStore
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreWithScene/DataStoreWithScene-description.md Edit}

* @private
*/
interface DataStoreWithScene extends GeneralDataStore {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreWithScene/methods/DataStoreWithScene-getAsset.md Edit}
    
    * @private
    */
    getAsset(name: string, successCallback: (asset: Asset) => void, failureCallback: (error: number, description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreWithScene/methods/DataStoreWithScene-hasAsset.md Edit}
    
    * @private
    */
    hasAsset(name: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreWithScene/methods/DataStoreWithScene-removeAsset.md Edit}
    
    * @private
    */
    removeAsset(name: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreWithScene/methods/DataStoreWithScene-saveAsset.md Edit}
    
    * @private
    */
    saveAsset(asset: Asset, name: string): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreWrapper/DataStoreWrapper-description.md Edit}

* @private
*/
interface DataStoreWrapper extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DataStoreWrapper/properties/DataStoreWrapper-store.md Edit}
    
    * @private
    */
    store: GeneralDataStore
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/DateTime-description.md Edit}

* @deprecated

* @private
*/
declare class DateTime {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/methods/DateTime-DateTime.md Edit}
    
    * @deprecated
    
    * @private
    */
    constructor()
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/properties/DateTime-day.md Edit}
    
    * @deprecated
    
    * @private
    */
    day: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/properties/DateTime-hour.md Edit}
    
    * @deprecated
    
    * @private
    */
    hour: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/properties/DateTime-millisecond.md Edit}
    
    * @deprecated
    
    * @private
    */
    millisecond: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/properties/DateTime-minute.md Edit}
    
    * @deprecated
    
    * @private
    */
    minute: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/properties/DateTime-month.md Edit}
    
    * @deprecated
    
    * @private
    */
    month: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/properties/DateTime-second.md Edit}
    
    * @deprecated
    
    * @private
    */
    second: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DateTime/properties/DateTime-year.md Edit}
    
    * @deprecated
    
    * @private
    */
    year: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/DebugRender-description.md Edit}

* @private
*/
interface DebugRender extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-clear.md Edit}
    
    * @private
    */
    clear(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-drawBox.md Edit}
    
    * @private
    */
    drawBox(position: vec3, width: number, height: number, depth: number, color: vec4): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-drawBrokenLine.md Edit}
    
    * @private
    */
    drawBrokenLine(points: vec3[], color: vec4): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-drawCircle.md Edit}
    
    * @private
    */
    drawCircle(position: vec3, radius: number, color: vec4): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-drawLine.md Edit}
    
    * @private
    */
    drawLine(posA: vec3, posB: vec3, color: vec4): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-drawSolidBox.md Edit}
    
    * @private
    */
    drawSolidBox(position: vec3, width: number, height: number, depth: number, color: vec4): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-drawSolidSphere.md Edit}
    
    * @private
    */
    drawSolidSphere(position: vec3, radius: number, color: vec4): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-drawSolidTriangle.md Edit}
    
    * @private
    */
    drawSolidTriangle(vertex1: vec3, vertex2: vec3, vertex3: vec3, color: vec4): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-drawSphere.md Edit}
    
    * @private
    */
    drawSphere(position: vec3, radius: number, color: vec4): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-reserveVertices.md Edit}
    
    * @deprecated
    
    * @private
    */
    reserveVertices(vertexCount: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/methods/DebugRender-reserveVerticesForTopology.md Edit}
    
    * @private
    */
    reserveVerticesForTopology(vertexCount: number, topology: MeshTopology): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/properties/DebugRender-depthTest.md Edit}
    
    * @private
    */
    depthTest: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/properties/DebugRender-depthWrite.md Edit}
    
    * @private
    */
    depthWrite: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/properties/DebugRender-isAutoClear.md Edit}
    
    * @private
    */
    isAutoClear: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DebugRender/properties/DebugRender-isBlendModeNormalAvailable.md Edit}
    
    * @private
    */
    isBlendModeNormalAvailable: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeformingCollisionMesh/DeformingCollisionMesh-description.md Edit}
*/
interface DeformingCollisionMesh extends CollisionMesh {
}

/**
* Creates a buffer for the audio data.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Delay/Delay-description.md Edit}
*/
interface Delay extends ScriptObject {
    /**
    * Process current frame data passed in `inTensor` of shape `inShape`, writes the result (delayed frame) to the `outTensor` and returns the shape of `outTensor`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Delay/methods/Delay-process.md Edit}
    */
    process(inTensor: Float32Array, inShape: vec3, outTensor: Float32Array): vec3
    
    /**
    * Maximum amount of features (channels).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Delay/properties/Delay-maxTensorSize.md Edit}
    
    * @readonly
    */
    maxTensorSize: number
    
}

/**
* Builder class for the Delay.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayBuilder/DelayBuilder-description.md Edit}
*/
interface DelayBuilder extends ScriptObject {
    /**
    * Creates new Delay object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayBuilder/methods/DelayBuilder-build.md Edit}
    */
    build(): Delay
    
    /**
    * Set the delay of the Delay object in samples. Delay is equal to `sampleRate * delayInSeconds`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayBuilder/methods/DelayBuilder-setDelay.md Edit}
    */
    setDelay(delay: number): DelayBuilder
    
    /**
    * Specify number of channels. Currently, only mono is supported, so should be set to `1`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayBuilder/methods/DelayBuilder-setNumFeatures.md Edit}
    */
    setNumFeatures(numFeatures: number): DelayBuilder
    
}

/**
* An event that gets triggered after a delay.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayedCallbackEvent/DelayedCallbackEvent-description.md Edit}
*/
interface DelayedCallbackEvent extends SceneEvent {
    /**
    * Cancel the callback in progress.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayedCallbackEvent/methods/DelayedCallbackEvent-cancel.md Edit}
    */
    cancel(): void
    
    /**
    * Returns the total delay time in seconds set on the event.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayedCallbackEvent/methods/DelayedCallbackEvent-getDelayTime.md Edit}
    */
    getDelayTime(): number
    
    /**
    * Returns the current time in seconds left in the event's delay.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayedCallbackEvent/methods/DelayedCallbackEvent-getTimeLeft.md Edit}
    */
    getTimeLeft(): number
    
    /**
    * Calling this will cause the event to trigger in `time` seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DelayedCallbackEvent/methods/DelayedCallbackEvent-reset.md Edit}
    */
    reset(time: number): void
    
}

/**
* Local estimate of the derivative of the input data along the selected axis. Outputs the derivative of the input features along the window.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Delta/Delta-description.md Edit}
*/
interface Delta extends ScriptObject {
    /**
    * Process `inTensor` with shape `inShape` and writes the result to the `outTensor` and returns the shape of `outTensor`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Delta/methods/Delta-process.md Edit}
    */
    process(inTensor: Float32Array, inShape: vec3, outTensor: Float32Array): vec3
    
    /**
    * Maximum amount of features (channels).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Delta/properties/Delta-maxTensorSize.md Edit}
    
    * @readonly
    */
    maxTensorSize: number
    
}

/**
* Builder class for Delta.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeltaBuilder/DeltaBuilder-description.md Edit}
*/
interface DeltaBuilder extends ScriptObject {
    /**
    * Create a new Delta object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeltaBuilder/methods/DeltaBuilder-build.md Edit}
    */
    build(): Delta
    
    /**
    * Specify number of channels. Currently, only mono is supported, so should be set to `1`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeltaBuilder/methods/DeltaBuilder-setNumFeatures.md Edit}
    */
    setNumFeatures(numFeatures: number): DeltaBuilder
    
    /**
    * Set the size of the window.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeltaBuilder/methods/DeltaBuilder-setWindowSize.md Edit}
    */
    setWindowSize(winSize: number): DeltaBuilder
    
}

/**
* Settings for the depth clear option modes on a DepthStencilRenderTargetProvider.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthClearOption/DepthClearOption-description.md Edit}
*/
declare enum DepthClearOption {
    /**
    * Do not clear the depth buffer, just keep values. Equal to disabled clear depth checkbox in Camera in previous Studio version.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthClearOption/properties/DepthClearOption-None.md Edit}
    */
    None,
    /**
    * Clear depth buffer by specific value. Equal to enabled clear depth checkbox in Camera in previous Studio version.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthClearOption/properties/DepthClearOption-CustomValue.md Edit}
    */
    CustomValue,
    /**
    * Clear depth buffer by values from depth part of input texture. Will use custom value in case of unavailable input texture.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthClearOption/properties/DepthClearOption-CustomTexture.md Edit}
    */
    CustomTexture
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthExtractionModel/DepthExtractionModel-description.md Edit}

* @private
*/
interface DepthExtractionModel extends BinAsset {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/DepthMeshBuilder-description.md Edit}

* @private
*/
declare class DepthMeshBuilder {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/methods/DepthMeshBuilder-DepthMeshBuilder.md Edit}
    
    * @private
    */
    constructor()
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/methods/DepthMeshBuilder-build.md Edit}
    
    * @private
    */
    build(depthmap: Texture, minDepth: number, maxDepth: number, normalizedFocalLength: vec2): RenderMesh
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/properties/DepthMeshBuilder-bilinearInterpolation.md Edit}
    
    * @private
    */
    bilinearInterpolation: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/properties/DepthMeshBuilder-cutThreshold.md Edit}
    
    * @private
    */
    cutThreshold: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/properties/DepthMeshBuilder-downsampleFactor.md Edit}
    
    * @private
    */
    downsampleFactor: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/properties/DepthMeshBuilder-meshType.md Edit}
    
    * @private
    */
    meshType: DepthMeshBuilder.MeshType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/properties/DepthMeshBuilder-roamErrorThreshold.md Edit}
    
    * @private
    */
    roamErrorThreshold: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder/properties/DepthMeshBuilder-roamSubdivisionMaxDepth.md Edit}
    
    * @private
    */
    roamSubdivisionMaxDepth: number
    
}

declare namespace DepthMeshBuilder {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder.MeshType/DepthMeshBuilder.MeshType-description.md Edit}
    
    * @private
    */
    enum MeshType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder.MeshType/properties/DepthMeshBuilder.MeshType-Grid.md Edit}
        
        * @private
        */
        Grid,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthMeshBuilder.MeshType/properties/DepthMeshBuilder.MeshType-Roam.md Edit}
        
        * @private
        */
        Roam
    }

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions/DepthProcessingOptions-description.md Edit}

* @private
*/
interface DepthProcessingOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions/properties/DepthProcessingOptions-alignFrontFacingDepthToImage.md Edit}
    
    * @private
    */
    alignFrontFacingDepthToImage: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions/properties/DepthProcessingOptions-cropDepthToImage.md Edit}
    
    * @private
    */
    cropDepthToImage: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions/properties/DepthProcessingOptions-depthModelAsset.md Edit}
    
    * @private
    */
    depthModelAsset: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions/properties/DepthProcessingOptions-enableModelBasedTracking.md Edit}
    
    * @private
    */
    enableModelBasedTracking: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions/properties/DepthProcessingOptions-guidedFilterEnabled.md Edit}
    
    * @private
    */
    guidedFilterEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions/properties/DepthProcessingOptions-holeFillingStrategy.md Edit}
    
    * @private
    */
    holeFillingStrategy: DepthProcessingOptions.HoleFillingStrategy
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions/properties/DepthProcessingOptions-holeReplacementValue.md Edit}
    
    * @private
    */
    holeReplacementValue: number
    
}

declare namespace DepthProcessingOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions.HoleFillingStrategy/DepthProcessingOptions.HoleFillingStrategy-description.md Edit}
    
    * @private
    */
    enum HoleFillingStrategy {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions.HoleFillingStrategy/properties/DepthProcessingOptions.HoleFillingStrategy-None.md Edit}
        
        * @private
        */
        None,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions.HoleFillingStrategy/properties/DepthProcessingOptions.HoleFillingStrategy-MinimumInWindow.md Edit}
        
        * @private
        */
        MinimumInWindow,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthProcessingOptions.HoleFillingStrategy/properties/DepthProcessingOptions.HoleFillingStrategy-FixedValue.md Edit}
        
        * @private
        */
        FixedValue
    }

}

/**
* Writes video feed depth information to the depth buffer, which automatically sets up depth occlusion for 3D visuals.
* Only works in some cases, such as in Lenses for Spectacles 3.
* See the [Lenses for Spectacles guide](https://lensstudio.snapchat.com/lens-studio/references/guides/distributing/spectacles/spectacles-3/lenses-for-spectacles-3) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthSetter/DepthSetter-description.md Edit}
*/
interface DepthSetter extends PostEffectVisual {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthSetter/properties/DepthSetter-guidedFilterEnabled.md Edit}
    
    * @private
    */
    guidedFilterEnabled: boolean
    
}

/**
* Access to a Depth Stencil Render Target that can output depth and stencil values from a Camera in Depth24/Stencil8 format.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/DepthStencilRenderTargetProvider-description.md Edit}
*/
interface DepthStencilRenderTargetProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-clearDepth.md Edit}
    
    * @deprecated
    
    * @private
    */
    clearDepth: number
    
    /**
    * Float value in range [0.0..1.0] used in depth buffer clear operation in "CustomValue" mode. The initial value is 1.0.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-clearDepthValue.md Edit}
    */
    clearDepthValue: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-clearStencil.md Edit}
    
    * @deprecated
    
    * @private
    */
    clearStencil: number
    
    /**
    * Unsigned int value in range [0..0xFF] used in stencil buffer clear operation in "CustomValue" mode. The initial value is 0.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-clearStencilValue.md Edit}
    */
    clearStencilValue: number
    
    /**
    * Depth buffer clear option.  "None" - depth buffer clear operation will be skipped.  "CustomValue" - depth buffer will be cleared by "clearDepthValue" property value. "CustomTexture" - depth buffer will be cleared by texture from "inputTexture" property, if "inputTexture" is null then depth clear option will fallback to "CustomValue" mode.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-depthClearOption.md Edit}
    */
    depthClearOption: DepthClearOption
    
    /**
    * Texture with Depth24_Stencil8 format. Depth24 part used in depth clear operation in "CustomTexture" mode.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-inputTexture.md Edit}
    */
    inputTexture: Texture
    
    /**
    * Texture with Depth24_Stencil8 format. Stencil8 part used in stencil clear operation in "CustomTexture" mode.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-maskTexture.md Edit}
    */
    maskTexture: Texture
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-mipmapsEnabled.md Edit}
    
    * @private
    */
    mipmapsEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-outputResolution.md Edit}
    
    * @private
    */
    outputResolution: DepthStencilRenderTargetProvider.OutputResolution
    
    /**
    * Custom render target resolution, this property will use if the "outputResolution" property is a "Custom".
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-resolution.md Edit}
    */
    resolution: vec2
    
    /**
    * Stencil buffer clear option.  "None" - stencil buffer clear operation will be skipped.  "CustomValue" - stencil buffer will be cleared by "clearStencilValue" property value. "CustomTexture" - stencil buffer will be cleared by texture from "maskTexture" property, if "maskTexture" is null then the stencil clear option will fallback to "CustomValue" mode.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/properties/DepthStencilRenderTargetProvider-stencilClearOption.md Edit}
    */
    stencilClearOption: StencilClearOption
    
}
declare namespace DepthStencilRenderTargetProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/methods/DepthStencilRenderTargetProvider-inputAndMaskSupported.md Edit}
    
    * @deprecated
    
    * @private
    */
    export function inputAndMaskSupported(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider/methods/DepthStencilRenderTargetProvider-stencilBufferSupported.md Edit}
    
    * @deprecated
    
    * @private
    */
    export function stencilBufferSupported(): boolean
    

}

declare namespace DepthStencilRenderTargetProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider.OutputResolution/DepthStencilRenderTargetProvider.OutputResolution-description.md Edit}
    
    * @private
    */
    enum OutputResolution {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider.OutputResolution/properties/DepthStencilRenderTargetProvider.OutputResolution-Custom.md Edit}
        
        * @private
        */
        Custom,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthStencilRenderTargetProvider.OutputResolution/properties/DepthStencilRenderTargetProvider.OutputResolution-Camera.md Edit}
        
        * @private
        */
        Camera
    }

}

/**
* Provides depth information of the video feed that the Lens is being applied to when available, such as in Lenses for Spectacles 3.
* Can be accessed from `mainPass.baseTex.control` of a Spectacles Depth material.

* See the [Lenses for Spectacles guide](https://lensstudio.snapchat.com/lens-studio/references/guides/distributing/spectacles/spectacles-2021/lenses-for-spectacles) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthTextureProvider/DepthTextureProvider-description.md Edit}
*/
interface DepthTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthTextureProvider/methods/DepthTextureProvider-getDepthToDisparityNumerator.md Edit}
    
    * @private
    */
    getDepthToDisparityNumerator(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthTextureProvider/methods/DepthTextureProvider-getScale.md Edit}
    
    * @private
    */
    getScale(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthTextureProvider/methods/DepthTextureProvider-sampleDepthAtPoint.md Edit}
    
    * @exposesUserData
    */
    sampleDepthAtPoint(point: vec2): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthTextureProvider/properties/DepthTextureProvider-depthProcessingOptions.md Edit}
    
    * @readonly
    
    * @private
    */
    depthProcessingOptions: DepthProcessingOptions
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DepthTextureProvider/properties/DepthTextureProvider-dilatedDepthEnabled.md Edit}
    
    * @private
    */
    dilatedDepthEnabled: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/DetectedHandObject-description.md Edit}

* @private
*/
interface DetectedHandObject extends DetectedObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/methods/DetectedHandObject-getHandSize.md Edit}
    
    * @private
    */
    getHandSize(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/methods/DetectedHandObject-getNormDirection.md Edit}
    
    * @private
    */
    getNormDirection(): vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/methods/DetectedHandObject-getPalmDirection.md Edit}
    
    * @private
    */
    getPalmDirection(): vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/methods/DetectedHandObject-getPalmPoint.md Edit}
    
    * @private
    */
    getPalmPoint(): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/methods/DetectedHandObject-getWristPoint.md Edit}
    
    * @private
    */
    getWristPoint(): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/methods/DetectedHandObject-isClosed.md Edit}
    
    * @private
    */
    isClosed(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/methods/DetectedHandObject-isOpened.md Edit}
    
    * @private
    */
    isOpened(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedHandObject/methods/DetectedHandObject-isPointing.md Edit}
    
    * @private
    */
    isPointing(): boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedObject/DetectedObject-description.md Edit}

* @private
*/
interface DetectedObject extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedObject/methods/DetectedObject-getCenter.md Edit}
    
    * @private
    */
    getCenter(): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedObject/methods/DetectedObject-getId.md Edit}
    
    * @private
    */
    getId(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedObject/methods/DetectedObject-getLabel.md Edit}
    
    * @private
    */
    getLabel(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DetectedObject/methods/DetectedObject-getSize.md Edit}
    
    * @private
    */
    getSize(): vec2
    
}

/**
* Provides information about the device's camera.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/DeviceCamera-description.md Edit}
*/
interface DeviceCamera extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/methods/DeviceCamera-project.md Edit}
    */
    project(pointInDeviceReferenceNode: vec3): vec2
    
    /**
    * Unprojects the normalized screen space point `normalizedScreenSpacePoint` based on some distance `absoluteDepth`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/methods/DeviceCamera-unproject.md Edit}
    */
    unproject(normalizedScreenSpacePoint: vec2, absoluteDepth: number): vec3
    
    /**
    * Provides the focal length of the device's camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/properties/DeviceCamera-focalLength.md Edit}
    
    * @readonly
    */
    focalLength: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/properties/DeviceCamera-fov.md Edit}
    
    * @readonly
    
    * @private
    */
    fov: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/properties/DeviceCamera-isFrontCamera.md Edit}
    
    * @readonly
    
    * @private
    */
    isFrontCamera: boolean
    
    /**
    * Provides the transform of the camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/properties/DeviceCamera-pose.md Edit}
    
    * @readonly
    */
    pose: mat4
    
    /**
    * Provides the principal point, or center of image, of the device's camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/properties/DeviceCamera-principalPoint.md Edit}
    
    * @readonly
    */
    principalPoint: vec2
    
    /**
    * Provides the resolution of the image returned by the device's camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceCamera/properties/DeviceCamera-resolution.md Edit}
    
    * @readonly
    */
    resolution: vec2
    
}

/**
* Provides information about the device running the Lens. Accessible through `global.deviceInfoSystem`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/DeviceInfoSystem-description.md Edit}
*/
interface DeviceInfoSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getDeviceClass.md Edit}
    
    * @private
    */
    getDeviceClass(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getDeviceModel.md Edit}
    
    * @private
    */
    getDeviceModel(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getDeviceMotionSensorPresence.md Edit}
    
    * @private
    */
    getDeviceMotionSensorPresence(): number
    
    /**
    * Returns the operating system type of the device.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getOS.md Edit}
    
    * @exposesUserData
    */
    getOS(): OS
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getOsVersion.md Edit}
    
    * @deprecated
    
    * @private
    */
    getOsVersion(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getSnapOSVersion.md Edit}
    
    * @private
    */
    getSnapOSVersion(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getTargetOS.md Edit}
    
    * @deprecated
    
    * @private
    */
    getTargetOS(): string
    
    /**
    * Provides the tracking camera's [DeviceCamera](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#DeviceCamera).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getTrackingCamera.md Edit}
    */
    getTrackingCamera(): DeviceCamera
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-getTrackingCameraForId.md Edit}
    
    * @experimental
    
    * @snapOsOnly
    */
    getTrackingCameraForId(cameraId: CameraModule.CameraId): DeviceCamera
    
    /**
    * Returns whether the current Lens is running in a desktop computer.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-isDesktop.md Edit}
    */
    isDesktop(): boolean
    
    /**
    * Returns whether the current Lens is running in Lens Studio.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-isEditor.md Edit}
    */
    isEditor(): boolean
    
    /**
    * Returns whether the current Lens is running in a mobile device.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-isMobile.md Edit}
    */
    isMobile(): boolean
    
    /**
    * Returns whether the current Lens is running in a Spectacles device.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-isSpectacles.md Edit}
    */
    isSpectacles(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/methods/DeviceInfoSystem-supportsNativeTracking.md Edit}
    
    * @deprecated
    
    * @private
    */
    supportsNativeTracking(): boolean
    
    /**
    * Returns the PerformanceIndexes object, which provides performance information about the device.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/properties/DeviceInfoSystem-performanceIndexes.md Edit}
    
    * @unreleased
    
    * @readonly
    */
    performanceIndexes: PerformanceIndexes
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceInfoSystem/properties/DeviceInfoSystem-screenScale.md Edit}
    
    * @readonly
    */
    screenScale: number
    
}

/**
* Used to track a landmarker in the camera. Moves the SceneObject's transform to match the detected landmarker scene.
* See the [Landmarker guide](https://lensstudio.snapchat.com/templates/landmarker) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/DeviceLocationTrackingComponent-description.md Edit}
*/
interface DeviceLocationTrackingComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/methods/DeviceLocationTrackingComponent-isMarkerTracking.md Edit}
    
    * @private
    */
    isMarkerTracking(): boolean
    
    /**
    * Returns whether the location landmarker is currently being tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/methods/DeviceLocationTrackingComponent-isTracking.md Edit}
    */
    isTracking(): boolean
    
    /**
    * Returns the distance, in meters, to the location. If the distance is unavailable, -1 is returned.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/properties/DeviceLocationTrackingComponent-distanceToLocation.md Edit}
    
    * @readonly
    */
    distanceToLocation: number
    
    /**
    * The location that the tracker is tracking. Useful for dynamically controlling the target location being tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/properties/DeviceLocationTrackingComponent-location.md Edit}
    */
    location: LocationAsset
    
    /**
    * Returns the user's current LocationProximityStatus. Useful for telling if a user is close enough to the location to track it.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/properties/DeviceLocationTrackingComponent-locationProximityStatus.md Edit}
    
    * @readonly
    */
    locationProximityStatus: LocationProximityStatus
    
    /**
    * A function that gets called when location data fails to download.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/properties/DeviceLocationTrackingComponent-onLocationDataDownloadFailed.md Edit}
    */
    onLocationDataDownloadFailed: () => void
    
    /**
    * A function that gets called when location data is downloaded.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/properties/DeviceLocationTrackingComponent-onLocationDataDownloaded.md Edit}
    */
    onLocationDataDownloaded: () => void
    
    /**
    * A function that gets called when location is found.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/properties/DeviceLocationTrackingComponent-onLocationFound.md Edit}
    */
    onLocationFound: () => void
    
    /**
    * A function that gets called when location is lost. Note this will also happen when the user flips the camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceLocationTrackingComponent/properties/DeviceLocationTrackingComponent-onLocationLost.md Edit}
    */
    onLocationLost: () => void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceMotion/DeviceMotion-description.md Edit}

* @private
*/
interface DeviceMotion extends AbstractData {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceMotion/methods/DeviceMotion-getAcceleration.md Edit}
    
    * @private
    */
    getAcceleration(): vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceMotion/methods/DeviceMotion-getRotationMatrix.md Edit}
    
    * @private
    */
    getRotationMatrix(): mat3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceMotion/methods/DeviceMotion-isDeviceMotionAvailable.md Edit}
    
    * @private
    */
    isDeviceMotionAvailable(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceMotion/properties/DeviceMotion-compassAligned.md Edit}
    
    * @private
    */
    compassAligned: boolean
    
}

/**
* Moves or rotates the SceneObject to match device orientation.

* If using "Surface" tracking mode, adding this to a SceneObject enables surface tracking for the scene, and moves the
* object to a position and rotation that matches the physical camera's pose in the world. Surface tracking can also be enhanced
* with native AR by enabling the "Use Native AR" option in the Inspector panel, or through script by setting the
* component's [`surfaceOptions.enhanceWithNativeAR`](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#SurfaceOptions) property.

* If using "Rotation" tracking mode, adding this to a SceneObject will apply the device's real world rotation to the object.

* If using "World" tracking mode, adding this to a SceneObject enables native AR tracking for the scene, and moves the
* object to a position and rotation that matches the physical camera's pose in the world.

* See the [Tracking Modes](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/world/tracking-modes) guide for more information.

**Note:** This component was named "WorldTracking" in previous versions of Lens Studio.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/DeviceTracking-description.md Edit}
*/
interface DeviceTracking extends Component {
    /**
    * Calculates a histogram of world mesh surfaces within a sphere at the given world position and radius. Only available when world mesh tracking is supported and enabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-calculateWorldMeshHistogram.md Edit}
    */
    calculateWorldMeshHistogram(center: vec3, radius: number): TrackedMeshHistogramResult
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-createTrackedPoint.md Edit}
    
    * @private
    */
    createTrackedPoint(sceneObject: SceneObject, worldPos: vec3, plane: TrackedPlane): TrackedPointComponent
    
    /**
    * Creates a TrackedPoint at world position `worldPos` and world rotation `worldRot`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-createTrackedWorldPoint.md Edit}
    */
    createTrackedWorldPoint(worldPos: vec3, worldRot: quat): TrackedPoint
    
    /**
    * Returns the actual DeviceTrackingMode being used. This may be different from the requested DeviceTrackingMode.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-getActualDeviceTrackingMode.md Edit}
    */
    getActualDeviceTrackingMode(): DeviceTrackingMode
    
    /**
    * Returns an array of BasicTransform objects describing each point that the camera travels through.
    * Each item in the array matches the camera's basic transform in the corresponding frame of the video feed that the Lens is applied to.
    * Only available in some cases, such as in Lenses for Spectacles 3. When not available, it will return an empty array.
    * See the [Lenses for Spectacles guide](https://lensstudio.snapchat.com/lens-studio/references/guides/distributing/spectacles/spectacles-2021/lenses-for-spectacles) for more information.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-getDevicePath.md Edit}
    */
    getDevicePath(): BasicTransform[]
    
    /**
    * Returns the current frame index of the video feed that the Lens is being applied to.
    * This can be used as an index to access the current BasicTransform in `getDevicePath()`.
    * Only available in some cases, such as in Lenses for Spectacles 3. When not available, it will return -1.
    * See the [Lenses for Spectacles guide](https://lensstudio.snapchat.com/lens-studio/references/guides/distributing/spectacles/spectacles-2021/lenses-for-spectacles) for more information.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-getDevicePathIndex.md Edit}
    */
    getDevicePathIndex(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-getNativeARTrackingState.md Edit}
    
    * @private
    */
    getNativeARTrackingState(): NativeARTrackingState
    
    /**
    * Returns the 3D point cloud representing important features visible by the camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-getPointCloud.md Edit}
    
    * @exposesUserData
    */
    getPointCloud(): PointCloud
    
    /**
    * Returns the DeviceTrackingMode currently requested to be used.
    * This may be different from the actual DeviceTrackingMode being used.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-getRequestedDeviceTrackingMode.md Edit}
    */
    getRequestedDeviceTrackingMode(): DeviceTrackingMode
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-getSurfaceTrackingPoint.md Edit}
    
    * @private
    */
    getSurfaceTrackingPoint(): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-getTransformSequence.md Edit}
    
    * @deprecated
    
    * @private
    */
    getTransformSequence(): Transform[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-hitTest.md Edit}
    
    * @unreleased
    */
    hitTest(screenPos: vec2): TrackedPlaneHitTestResult[]
    
    /**
    * Returns an array of TrackedMeshHitTestResult that intersect with a ray cast from screen position screenPos. Only available when world mesh tracking is supported and enabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-hitTestWorldMesh.md Edit}
    */
    hitTestWorldMesh(screenPos: vec2): TrackedMeshHitTestResult[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-hitTestWorldMeshRough.md Edit}
    
    * @private
    */
    hitTestWorldMeshRough(screenPos: vec2): TrackedMeshHitTestResult[]
    
    /**
    * Returns whether the DeviceTrackingMode is supported.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-isDeviceTrackingModeSupported.md Edit}
    */
    isDeviceTrackingModeSupported(mode: DeviceTrackingMode): boolean
    
    /**
    * Returns an array of TrackedMeshHitTestResult that intersect with a ray cast from the world position `from` and continuing through the world position `to`. Only available when world mesh tracking is supported and enabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-raycastWorldMesh.md Edit}
    */
    raycastWorldMesh(from: vec3, to: vec3): TrackedMeshHitTestResult[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-raycastWorldMeshRough.md Edit}
    
    * @private
    */
    raycastWorldMeshRough(from: vec3, to: vec3): TrackedMeshHitTestResult[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-registerSceneObjectOfInterest.md Edit}
    
    * @deprecated
    
    * @private
    */
    registerSceneObjectOfInterest(obj: SceneObject): void
    
    /**
    * Requests that a DeviceTrackingMode be used. This requested change may not happen immediately.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-requestDeviceTrackingMode.md Edit}
    */
    requestDeviceTrackingMode(val: DeviceTrackingMode): void
    
    /**
    * Resets the World Tracking origin to the point on the surface plane aligned with the screen position `position`.
    * Screen positions are represented in the range ([0-1], [0-1]), (0,0) being the top-left of the screen and (1,1) being the bottom-right.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-resetTracking.md Edit}
    */
    resetTracking(position: vec2): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-setOnGyroscopeInitialized.md Edit}
    
    * @private
    */
    setOnGyroscopeInitialized(eventCallback: () => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-setTrackerMode.md Edit}
    
    * @deprecated
    
    * @private
    */
    setTrackerMode(type: TrackerMode): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-setTrackerType.md Edit}
    
    * @deprecated
    
    * @private
    */
    setTrackerType(type: TrackerMode): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-setWallModeEnabled.md Edit}
    
    * @deprecated
    
    * @private
    */
    setWallModeEnabled(enable: boolean): void
    
    /**
    * Offsets the default position of the World Tracking surface origin by `offset`.
    * Avoid using a `y` value of zero in `offset`, because it may cause problems with tracking.
    * If used outside of `Initialized` or `TurnOnEvent`, you will need to call `resetTracking()` to apply the offset.
    * Note: calling `resetTracking()` will overwrite the `x` and `z` components of the offset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-setWorldOriginOffset.md Edit}
    */
    setWorldOriginOffset(offset: vec3): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/methods/DeviceTracking-unregisterSceneObjectOfInterest.md Edit}
    
    * @deprecated
    
    * @private
    */
    unregisterSceneObjectOfInterest(obj: SceneObject): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/properties/DeviceTracking-drawDebug.md Edit}
    
    * @private
    */
    drawDebug: boolean
    
    /**
    * Used to access rotation tracking settings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/properties/DeviceTracking-rotationOptions.md Edit}
    */
    rotationOptions: RotationOptions
    
    /**
    * Used to access surface tracking settings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/properties/DeviceTracking-surfaceOptions.md Edit}
    */
    surfaceOptions: SurfaceOptions
    
    /**
    * Helps to improve surface tracking accuracy while the target `SceneObject` is being moved.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/properties/DeviceTracking-surfaceTrackingTarget.md Edit}
    */
    surfaceTrackingTarget: SceneObject
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/properties/DeviceTracking-trackedMeshes.md Edit}
    
    * @readonly
    
    * @private
    */
    trackedMeshes: TrackedMesh[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/properties/DeviceTracking-trackedPlanes.md Edit}
    
    * @readonly
    
    * @private
    */
    trackedPlanes: TrackedPlane[]
    
    /**
    * Returns the WorldOptions object of this component, which can be used to control World Tracking settings.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/properties/DeviceTracking-worldOptions.md Edit}
    */
    worldOptions: WorldOptions
    
    /**
    * Returns the World Tracking Capabilities of the current device.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTracking/properties/DeviceTracking-worldTrackingCapabilities.md Edit}
    
    * @readonly
    */
    worldTrackingCapabilities: WorldTrackingCapabilities
    
}

/**
* Tracking modes used by the [DeviceTracking](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#DeviceTracking) component to specify what type of tracking to use.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTrackingMode/DeviceTrackingMode-description.md Edit}
*/
declare enum DeviceTrackingMode {
    /**
    * Use gyroscope tracking (rotation only)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTrackingMode/properties/DeviceTrackingMode-Rotation.md Edit}
    */
    Rotation,
    /**
    * Use surface tracking (position and rotation)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTrackingMode/properties/DeviceTrackingMode-Surface.md Edit}
    */
    Surface,
    /**
    * Use native tracking (position and rotation)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTrackingMode/properties/DeviceTrackingMode-World.md Edit}
    */
    World
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceTrackingModule/DeviceTrackingModule-description.md Edit}
*/
interface DeviceTrackingModule extends Asset {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIAction/DeviceUIAction-description.md Edit}

* @private
*/
declare enum DeviceUIAction {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIAction/properties/DeviceUIAction-Tap.md Edit}
    
    * @private
    */
    Tap,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIAction/properties/DeviceUIAction-LongTapStart.md Edit}
    
    * @private
    */
    LongTapStart,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIAction/properties/DeviceUIAction-LongTapRelease.md Edit}
    
    * @private
    */
    LongTapRelease,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIAction/properties/DeviceUIAction-Unknown.md Edit}
    
    * @private
    */
    Unknown
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIElement/DeviceUIElement-description.md Edit}

* @private
*/
declare enum DeviceUIElement {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIElement/properties/DeviceUIElement-SnapButton.md Edit}
    
    * @private
    */
    SnapButton,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIElement/properties/DeviceUIElement-LensAttachmentButton.md Edit}
    
    * @private
    */
    LensAttachmentButton,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DeviceUIElement/properties/DeviceUIElement-Unknown.md Edit}
    
    * @private
    */
    Unknown
}

declare namespace Dialog {
    /**
    * Provides answer information in response to `DialogModule.askQuestions()`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Dialog.Answer/Dialog.Answer-description.md Edit}
    */
    interface Answer extends ScriptObject {
        /**
        * The answer to the question.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Dialog.Answer/properties/Dialog.Answer-answer.md Edit}
        
        * @readonly
        */
        answer: string
        
        /**
        * The index of the question this is answering in the questions array.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Dialog.Answer/properties/Dialog.Answer-questionId.md Edit}
        
        * @readonly
        */
        questionId: number
        
        /**
        * Status of the question response.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Dialog.Answer/properties/Dialog.Answer-status.md Edit}
        
        * @readonly
        */
        status: number
        
    }

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DialogModule/DialogModule-description.md Edit}
*/
interface DialogModule extends Asset {
    /**
    * Sends a request to ask questions using the DialogModule. `context` is the text the model will use as context for answering the question. `questions` is a list of questions to ask. When answers are ready, `onQuestionsAnswerComplete` will be called with a list of `Dialog.Answer` objects corresponding to the questions in the `questions` list. `onQuestionsAnswerError` will be called if any error occurs.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DialogModule/methods/DialogModule-askQuestions.md Edit}
    */
    askQuestions(context: string, questions: string[], onQuestionsAnswerComplete: (answers: Dialog.Answer[]) => void, onQuestionsAnswerError: (error: number, description: string) => void): void
    
}

/**
* An Audio Component effect that simulates sound attenuation based on the orientation of the transform relative to the [AudioListenerComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#AudioListenerComponent). 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DirectivityEffect/DirectivityEffect-description.md Edit}
*/
interface DirectivityEffect extends ScriptObject {
    /**
    * Whether the audio directivity effect is applied or not.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DirectivityEffect/properties/DirectivityEffect-enabled.md Edit}
    */
    enabled: boolean
    
    /**
    * The width of main lobe.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DirectivityEffect/properties/DirectivityEffect-shapeDecay.md Edit}
    */
    shapeDecay: number
    
    /**
    * A ratio that specifies the shape of pattern directivity from omnidirectional(0) to cardioid (1.0).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DirectivityEffect/properties/DirectivityEffect-shapeFactor.md Edit}
    */
    shapeFactor: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DirectMultiplayerSessionOptions/DirectMultiplayerSessionOptions-description.md Edit}
*/
interface DirectMultiplayerSessionOptions extends BaseMultiplayerSessionOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DirectMultiplayerSessionOptions/properties/DirectMultiplayerSessionOptions-appInstanceId.md Edit}
    
    * @private
    */
    appInstanceId: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DirectMultiplayerSessionOptions/properties/DirectMultiplayerSessionOptions-sessionId.md Edit}
    
    * @private
    */
    sessionId: string
    
}
declare namespace DirectMultiplayerSessionOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DirectMultiplayerSessionOptions/methods/DirectMultiplayerSessionOptions-create.md Edit}
    
    * @private
    */
    export function create(): DirectMultiplayerSessionOptions
    

}

/**
* An audio effect that simulates sound attenuation based on the distance between the Audio and the [AudioListenerComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#AudioListenerComponent). 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DistanceEffect/DistanceEffect-description.md Edit}
*/
interface DistanceEffect extends ScriptObject {
    /**
    * If enabled, the distance effect will be applied.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DistanceEffect/properties/DistanceEffect-enabled.md Edit}
    */
    enabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DistanceEffect/properties/DistanceEffect-maxAttenuation.md Edit}
    
    * @private
    */
    maxAttenuation: number
    
    /**
    * If the distance is higher than this value, the sound cannot be heard at all.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DistanceEffect/properties/DistanceEffect-maxDistance.md Edit}
    */
    maxDistance: number
    
    /**
    * If the distance is less than this value, the distance effect is not applied at all. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DistanceEffect/properties/DistanceEffect-minDistance.md Edit}
    */
    minDistance: number
    
    /**
    * Curve type that describes how volume attenuates with distance.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DistanceEffect/properties/DistanceEffect-type.md Edit}
    */
    type: Audio.DistanceCurveType
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DomainInfo/DomainInfo-description.md Edit}

* @unreleased
*/
interface DomainInfo {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DomainInfo/properties/DomainInfo-assetType.md Edit}
    
    * @readonly
    */
    assetType: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DomainInfo/properties/DomainInfo-description.md Edit}
    
    * @readonly
    */
    description: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DomainInfo/properties/DomainInfo-name.md Edit}
    
    * @readonly
    */
    name: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DomainInfo/properties/DomainInfo-states.md Edit}
    
    * @readonly
    */
    states: StateInfo[]
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DopplerEffect/DopplerEffect-description.md Edit}

* @private
*/
interface DopplerEffect extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DopplerEffect/properties/DopplerEffect-enabled.md Edit}
    
    * @private
    */
    enabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DopplerEffect/properties/DopplerEffect-velocityFactor.md Edit}
    
    * @private
    */
    velocityFactor: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DoubleTapEvent/DoubleTapEvent-description.md Edit}

* @unreleased
*/
interface DoubleTapEvent extends SceneObjectEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DoubleTapEvent/methods/DoubleTapEvent-getTapPosition.md Edit}
    */
    getTapPosition(): vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DoubleTapEventArgs/DoubleTapEventArgs-description.md Edit}

* @unreleased
*/
interface DoubleTapEventArgs extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DoubleTapEventArgs/properties/DoubleTapEventArgs-position.md Edit}
    
    * @readonly
    */
    position: vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/DrawingSystem2D-description.md Edit}

* @private
*/
interface DrawingSystem2D extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-drawingHistoryUpdated.md Edit}
    
    * @private
    */
    drawingHistoryUpdated(canDrawOnOverlay: boolean, strokeCount: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-setColorCallback.md Edit}
    
    * @private
    */
    setColorCallback(callback: (color: vec4) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-setDeserializeCallback.md Edit}
    
    * @private
    */
    setDeserializeCallback(callback: (data: string) => number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-setDrawOverlayCallback.md Edit}
    
    * @private
    */
    setDrawOverlayCallback(callback: (enabled: boolean) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-setSelectBrushCallback.md Edit}
    
    * @private
    */
    setSelectBrushCallback(callback: (prefab: Prefab, id: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-setSerializeCallback.md Edit}
    
    * @private
    */
    setSerializeCallback(callback: () => any): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-setUndoCallback.md Edit}
    
    * @private
    */
    setUndoCallback(callback: () => number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-setUnicodeSymbolCallback.md Edit}
    
    * @private
    */
    setUnicodeSymbolCallback(callback: (symbol: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DrawingSystem2D/methods/DrawingSystem2D-setWidthCallback.md Edit}
    
    * @private
    */
    setWidthCallback(callback: (width: number) => void): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DriftCorrectionType/DriftCorrectionType-description.md Edit}

* @experimental

* @wearableOnly

* @private
*/
declare enum DriftCorrectionType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DriftCorrectionType/properties/DriftCorrectionType-SystemDefault.md Edit}
    
    * @private
    */
    SystemDefault,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DriftCorrectionType/properties/DriftCorrectionType-Disabled.md Edit}
    
    * @private
    */
    Disabled,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DriftCorrectionType/properties/DriftCorrectionType-Enabled.md Edit}
    
    * @private
    */
    Enabled
}

/**
* Used in [Text's](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Text) `dropShadowSettings` property.
* Configures how dropshadow will appear on a Text component.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DropshadowSettings/DropshadowSettings-description.md Edit}
*/
interface DropshadowSettings extends ScriptObject {
    /**
    * Whether dropshadow is enabled on the Text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DropshadowSettings/properties/DropshadowSettings-enabled.md Edit}
    */
    enabled: boolean
    
    /**
    * Settings for how the inside of the dropshadow is drawn.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DropshadowSettings/properties/DropshadowSettings-fill.md Edit}
    */
    fill: TextFill
    
    /**
    * An (x, y) offset controlling where the dropshadow is drawn relative to the Text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DropshadowSettings/properties/DropshadowSettings-offset.md Edit}
    */
    offset: vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DynamicEnvLight/DynamicEnvLight-description.md Edit}

* @private
*/
interface DynamicEnvLight extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DynamicEnvLight/properties/DynamicEnvLight-color.md Edit}
    
    * @private
    */
    color: vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DynamicEnvLight/properties/DynamicEnvLight-direction.md Edit}
    
    * @private
    */
    direction: vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DynamicEnvLight/properties/DynamicEnvLight-intensity.md Edit}
    
    * @private
    */
    intensity: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DynamicMeshRenderObjectProvider/DynamicMeshRenderObjectProvider-description.md Edit}
*/
interface DynamicMeshRenderObjectProvider extends ProceduralMeshRenderObjectProvider {
}

/**
* A resource that is resolved at runtime.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DynamicResource/DynamicResource-description.md Edit}
*/
interface DynamicResource extends ScriptObject {
}
declare namespace DynamicResource {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DynamicResource/methods/DynamicResource-createEncryptedResourceWithUrl.md Edit}
    */
    export function createEncryptedResourceWithUrl(url: string, keyBytes: Uint8Array): DynamicResource
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/DynamicResource/methods/DynamicResource-createWithResourceId.md Edit}
    
    * @private
    */
    export function createWithResourceId(resourceId: string): DynamicResource
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EmojiTextureProvider/EmojiTextureProvider-description.md Edit}

* @private
*/
interface EmojiTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EmojiTextureProvider/methods/EmojiTextureProvider-setUnicodeSymbol.md Edit}
    
    * @private
    */
    setUnicodeSymbol(uniSymbol: string): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EncodingType/EncodingType-description.md Edit}

* @private
*/
declare enum EncodingType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EncodingType/properties/EncodingType-Png.md Edit}
    
    * @private
    */
    Png,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EncodingType/properties/EncodingType-Jpg.md Edit}
    
    * @private
    */
    Jpg
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EnvironmentMapTextureProvider/EnvironmentMapTextureProvider-description.md Edit}

* @private
*/
interface EnvironmentMapTextureProvider extends TextureProvider {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EventPropertyTrack/EventPropertyTrack-description.md Edit}

* @private
*/
interface EventPropertyTrack extends AnimationPropertyTrack {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EventPropertyTrack/methods/EventPropertyTrack-addEvent.md Edit}
    
    * @private
    */
    addEvent(eventName: string, timestamp: number): AnimationPropertyEventRegistration
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EventPropertyTrack/methods/EventPropertyTrack-removeEvent.md Edit}
    
    * @private
    */
    removeEvent(registration: AnimationPropertyEventRegistration): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EventRegistration/EventRegistration-description.md Edit}
*/
interface EventRegistration extends ScriptObject {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExperimentalClass/ExperimentalClass-description.md Edit}
*/
declare class ExperimentalClass {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExperimentalClass/methods/ExperimentalClass-ExperimentalClass.md Edit}
    */
    constructor(id: number)
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExperimentalClass/methods/ExperimentalClass-getId.md Edit}
    
    * @experimental
    */
    getId(): number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExperimentSystem/ExperimentSystem-description.md Edit}

* @private
*/
interface ExperimentSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExperimentSystem/methods/ExperimentSystem-getExperimentParameter.md Edit}
    
    * @private
    */
    getExperimentParameter(experimentName: string, parameterName: string): string
    
}

/**
* Expression names used with `FaceRenderObjectProvider.getExpressionWeightByName()`
* and returned by `FaceRenderObjectProvider.getExpressionNames()`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/Expressions-description.md Edit}
*/
interface Expressions {
}
declare namespace Expressions {
    /**
    * Left eyebrow downward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-BrowsDownLeft.md Edit}
    */
    let BrowsDownLeft: string
    
    /**
    * Right eyebrow downward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-BrowsDownRight.md Edit}
    */
    let BrowsDownRight: string
    
    /**
    * Between eyebrows upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-BrowsUpCenter.md Edit}
    */
    let BrowsUpCenter: string
    
    /**
    * Left eyebrow upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-BrowsUpLeft.md Edit}
    */
    let BrowsUpLeft: string
    
    /**
    * Right eyebrow upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-BrowsUpRight.md Edit}
    */
    let BrowsUpRight: string
    
    /**
    * Left cheek and below left eye upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-CheekSquintLeft.md Edit}
    */
    let CheekSquintLeft: string
    
    /**
    * Right cheek and below right eye upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-CheekSquintRight.md Edit}
    */
    let CheekSquintRight: string
    
    /**
    * Left eyelids closing
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeBlinkLeft.md Edit}
    */
    let EyeBlinkLeft: string
    
    /**
    * Right eyelids closing
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeBlinkRight.md Edit}
    */
    let EyeBlinkRight: string
    
    /**
    * Left eyelids downward look
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeDownLeft.md Edit}
    */
    let EyeDownLeft: string
    
    /**
    * Right eyelids downward look
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeDownRight.md Edit}
    */
    let EyeDownRight: string
    
    /**
    * Left eyelids looking towards center
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeInLeft.md Edit}
    */
    let EyeInLeft: string
    
    /**
    * Right eyelids looking towards center
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeInRight.md Edit}
    */
    let EyeInRight: string
    
    /**
    * Left eyelids opening
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeOpenLeft.md Edit}
    */
    let EyeOpenLeft: string
    
    /**
    * Right eyelids opening
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeOpenRight.md Edit}
    */
    let EyeOpenRight: string
    
    /**
    * Left eyelids looking away from center
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeOutLeft.md Edit}
    */
    let EyeOutLeft: string
    
    /**
    * Right eyelids looking away from center
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeOutRight.md Edit}
    */
    let EyeOutRight: string
    
    /**
    * Left eye squinting
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeSquintLeft.md Edit}
    */
    let EyeSquintLeft: string
    
    /**
    * Right eye squinting
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeSquintRight.md Edit}
    */
    let EyeSquintRight: string
    
    /**
    * Left eyelids upward look
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeUpLeft.md Edit}
    */
    let EyeUpLeft: string
    
    /**
    * Right eyelids upward look
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-EyeUpRight.md Edit}
    */
    let EyeUpRight: string
    
    /**
    * Jaw forward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-JawForward.md Edit}
    */
    let JawForward: string
    
    /**
    * Jaw leftward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-JawLeft.md Edit}
    */
    let JawLeft: string
    
    /**
    * Jaw opening
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-JawOpen.md Edit}
    */
    let JawOpen: string
    
    /**
    * Jaw rightward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-JawRight.md Edit}
    */
    let JawRight: string
    
    /**
    * Lips forming open circular shape together
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-LipsFunnel.md Edit}
    */
    let LipsFunnel: string
    
    /**
    * Lips compressing together while closed
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-LipsPucker.md Edit}
    */
    let LipsPucker: string
    
    /**
    * Lower lip moving towards and behind upper lip
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-LowerLipClose.md Edit}
    */
    let LowerLipClose: string
    
    /**
    * Left lower lip downward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-LowerLipDownLeft.md Edit}
    */
    let LowerLipDownLeft: string
    
    /**
    * Right lower lip downward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-LowerLipDownRight.md Edit}
    */
    let LowerLipDownRight: string
    
    /**
    * Lower lip upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-LowerLipRaise.md Edit}
    */
    let LowerLipRaise: string
    
    /**
    * Lips moving together
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthClose.md Edit}
    */
    let MouthClose: string
    
    /**
    * Left mouth corner back and leftward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthDimpleLeft.md Edit}
    */
    let MouthDimpleLeft: string
    
    /**
    * Right mouth corner back and rightward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthDimpleRight.md Edit}
    */
    let MouthDimpleRight: string
    
    /**
    * Left mouth corner downward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthFrownLeft.md Edit}
    */
    let MouthFrownLeft: string
    
    /**
    * Right mouth corner downward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthFrownRight.md Edit}
    */
    let MouthFrownRight: string
    
    /**
    * Both lips leftward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthLeft.md Edit}
    */
    let MouthLeft: string
    
    /**
    * Both lips rightward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthRight.md Edit}
    */
    let MouthRight: string
    
    /**
    * Left mouth corner upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthSmileLeft.md Edit}
    */
    let MouthSmileLeft: string
    
    /**
    * Right mouth corner upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthSmileRight.md Edit}
    */
    let MouthSmileRight: string
    
    /**
    * Left side of mouth leftward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthStretchLeft.md Edit}
    */
    let MouthStretchLeft: string
    
    /**
    * Right side of mouth rightward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthStretchRight.md Edit}
    */
    let MouthStretchRight: string
    
    /**
    * Left side of mouth upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthUpLeft.md Edit}
    */
    let MouthUpLeft: string
    
    /**
    * Right side of mouth upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-MouthUpRight.md Edit}
    */
    let MouthUpRight: string
    
    /**
    * Both cheeks puffing outward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-Puff.md Edit}
    */
    let Puff: string
    
    /**
    * Left nostril raising
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-SneerLeft.md Edit}
    */
    let SneerLeft: string
    
    /**
    * Right nostril raising
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-SneerRight.md Edit}
    */
    let SneerRight: string
    
    /**
    * Upper lip moving towards and behind lower lip
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-UpperLipClose.md Edit}
    */
    let UpperLipClose: string
    
    /**
    * Upper lip upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-UpperLipRaise.md Edit}
    */
    let UpperLipRaise: string
    
    /**
    * Left upper lip upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-UpperLipUpLeft.md Edit}
    */
    let UpperLipUpLeft: string
    
    /**
    * Right upper lip upward movement
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Expressions/properties/Expressions-UpperLipUpRight.md Edit}
    */
    let UpperLipUpRight: string
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtendedTrackingMode/ExtendedTrackingMode-description.md Edit}

* @private
*/
declare enum ExtendedTrackingMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtendedTrackingMode/properties/ExtendedTrackingMode-None.md Edit}
    
    * @private
    */
    None,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtendedTrackingMode/properties/ExtendedTrackingMode-Gyro.md Edit}
    
    * @private
    */
    Gyro,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtendedTrackingMode/properties/ExtendedTrackingMode-SLAM.md Edit}
    
    * @private
    */
    SLAM
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExternalEvent/ExternalEvent-description.md Edit}

* @private
*/
interface ExternalEvent extends SceneEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExternalEvent/methods/ExternalEvent-getData.md Edit}
    
    * @private
    */
    getData(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExternalEvent/methods/ExternalEvent-getType.md Edit}
    
    * @private
    */
    getType(): string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExternalRendererComponent/ExternalRendererComponent-description.md Edit}
*/
interface ExternalRendererComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExternalRendererComponent/methods/ExternalRendererComponent-getEventHook.md Edit}
    */
    getEventHook(eventHookName: string): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExternalRendererComponent/properties/ExternalRendererComponent-rendererConfig.md Edit}
    */
    rendererConfig: string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExternalStreamTextureProvider/ExternalStreamTextureProvider-description.md Edit}

* @private
*/
interface ExternalStreamTextureProvider extends TextureProvider {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/ExtrudedMeshBuilder-description.md Edit}

* @private
*/
interface ExtrudedMeshBuilder extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/methods/ExtrudedMeshBuilder-buildMesh.md Edit}
    
    * @private
    */
    buildMesh(): RenderMesh
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/methods/ExtrudedMeshBuilder-toString.md Edit}
    
    * @private
    */
    toString(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-backFaceTextureOffset.md Edit}
    
    * @private
    */
    backFaceTextureOffset: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-curveSegmentPrecision.md Edit}
    
    * @private
    */
    curveSegmentPrecision: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-extrudeDepth.md Edit}
    
    * @private
    */
    extrudeDepth: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-faceTextureSize.md Edit}
    
    * @private
    */
    faceTextureSize: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-flipBackFaceTextureHorizontally.md Edit}
    
    * @private
    */
    flipBackFaceTextureHorizontally: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-flipBackFaceTextureVertically.md Edit}
    
    * @private
    */
    flipBackFaceTextureVertically: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-flipFrontFaceTextureHorizontally.md Edit}
    
    * @private
    */
    flipFrontFaceTextureHorizontally: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-flipFrontFaceTextureVertically.md Edit}
    
    * @private
    */
    flipFrontFaceTextureVertically: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-frontFaceTextureOffset.md Edit}
    
    * @private
    */
    frontFaceTextureOffset: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-holeMode.md Edit}
    
    * @private
    */
    holeMode: HoleMode
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-innerRepeats.md Edit}
    
    * @private
    */
    innerRepeats: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-innerSideTextureOffset.md Edit}
    
    * @private
    */
    innerSideTextureOffset: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-meshSerializationEnabled.md Edit}
    
    * @private
    */
    meshSerializationEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-outerRepeats.md Edit}
    
    * @private
    */
    outerRepeats: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-outerSideTextureOffset.md Edit}
    
    * @private
    */
    outerSideTextureOffset: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-sideTextureMode.md Edit}
    
    * @private
    */
    sideTextureMode: SideTextureMode
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-textureStartAngle.md Edit}
    
    * @private
    */
    textureStartAngle: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-tileInnerTexture.md Edit}
    
    * @private
    */
    tileInnerTexture: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ExtrudedMeshBuilder/properties/ExtrudedMeshBuilder-tileOuterTexture.md Edit}
    
    * @private
    */
    tileOuterTexture: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Eye/Eye-description.md Edit}

* @deprecated

* @private
*/
interface Eye extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Eye/properties/Eye-eyeIndex.md Edit}
    
    * @private
    */
    eyeIndex: EyeIndex
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Eye/properties/Eye-faceIndex.md Edit}
    
    * @private
    */
    faceIndex: number
    
}

/**
* Applies an eye color effect to a face.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeColorVisual/EyeColorVisual-description.md Edit}
*/
interface EyeColorVisual extends MaterialMeshVisual {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeColorVisual/properties/EyeColorVisual-eyeToRender.md Edit}
    
    * @unreleased
    */
    eyeToRender: EyeToRender
    
    /**
    * The index of the face this EyeColorVisual is attached to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeColorVisual/properties/EyeColorVisual-faceIndex.md Edit}
    */
    faceIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeColorVisual/properties/EyeColorVisual-rotationEnabled.md Edit}
    
    * @unreleased
    */
    rotationEnabled: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeIndex/EyeIndex-description.md Edit}

* @private
*/
declare enum EyeIndex {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeIndex/properties/EyeIndex-Left.md Edit}
    
    * @private
    */
    Left,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeIndex/properties/EyeIndex-Right.md Edit}
    
    * @private
    */
    Right
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeToRender/EyeToRender-description.md Edit}

* @unreleased
*/
declare enum EyeToRender {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeToRender/properties/EyeToRender-Left.md Edit}
    
    * @unreleased
    */
    Left,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeToRender/properties/EyeToRender-Right.md Edit}
    
    * @unreleased
    */
    Right,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/EyeToRender/properties/EyeToRender-Both.md Edit}
    
    * @unreleased
    */
    Both
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCount/FaceCount-description.md Edit}

* @private
*/
interface FaceCount {
}
declare namespace FaceCount {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCount/properties/FaceCount-Unlimited.md Edit}
    
    * @private
    */
    let Unlimited: number
    

}

/**
* Texture Provider giving a cropped region of the input texture, calculated based on face position.
* Can be accessed using `Texture.control` on a FaceCropTexture asset.
* For more information, see the [Crop Textures](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/machine-learning/ml-component/crop-textures#crop-textures) guide.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/FaceCropTextureProvider-description.md Edit}
*/
interface FaceCropTextureProvider extends CropTextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/methods/FaceCropTextureProvider-getCroppedLandmarks.md Edit}
    
    * @private
    */
    getCroppedLandmarks(): Float32Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-alignmentType.md Edit}
    
    * @private
    */
    alignmentType: MachineLearning.AlignmentType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-downMargin.md Edit}
    
    * @private
    */
    downMargin: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-eyeIndex.md Edit}
    
    * @private
    */
    eyeIndex: number
    
    /**
    * Ratio of the mouth position on the cropped texture. Value ranges from 0 to 1, with 0 having no effect and 1 centering the image on the mouth.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-faceCenterMouthWeight.md Edit}
    */
    faceCenterMouthWeight: number
    
    /**
    * Index of the face being tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-faceIndex.md Edit}
    */
    faceIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-horizontalMargin.md Edit}
    
    * @private
    */
    horizontalMargin: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-restrictCrop.md Edit}
    
    * @private
    */
    restrictCrop: number
    
    /**
    * Scaling of the cropped texture.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-textureScale.md Edit}
    */
    textureScale: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceCropTextureProvider/properties/FaceCropTextureProvider-upMargin.md Edit}
    
    * @private
    */
    upMargin: number
    
}

/**
* Triggered when a new face is detected and starts being tracked.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceFoundEvent/FaceFoundEvent-description.md Edit}
*/
interface FaceFoundEvent extends FaceTrackingEvent {
}

/**
* Controls the face image picker texture resource.
* Can be accessed through [Texture.control](https://lensstudio.snapchat.com/api/lens-studio/Classes/Assets#texture--control) on a Face Image Picker texture.
* For more information, see the [Face Image Picker Texture guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/face/face-effects/face-image-picker-texture).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceImagePickerTextureProvider/FaceImagePickerTextureProvider-description.md Edit}
*/
interface FaceImagePickerTextureProvider extends ImagePickerTextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceImagePickerTextureProvider/methods/FaceImagePickerTextureProvider-getFaceRect.md Edit}
    
    * @deprecated
    
    * @private
    */
    getFaceRect(): vec4
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceImagePickerTextureProvider/methods/FaceImagePickerTextureProvider-requestFaceMesh.md Edit}
    
    * @private
    */
    requestFaceMesh(callback: () => void): void
    
    /**
    * If enabled, the selected image will be cropped to only show the face region.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceImagePickerTextureProvider/properties/FaceImagePickerTextureProvider-cropToFace.md Edit}
    */
    cropToFace: boolean
    
    /**
    * The FaceTextureProvider used to provide the face texture.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceImagePickerTextureProvider/properties/FaceImagePickerTextureProvider-faceControl.md Edit}
    */
    faceControl: FaceTextureProvider
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceImagePickerTextureProvider/properties/FaceImagePickerTextureProvider-useFace.md Edit}
    
    * @deprecated
    
    * @private
    */
    useFace: boolean
    
}

/**
* Used with [FaceInsetVisual.faceRegion](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#FaceInsetVisual) for setting the face region to draw.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetRegion/FaceInsetRegion-description.md Edit}
*/
declare enum FaceInsetRegion {
    /**
    * Targets the entire face
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetRegion/properties/FaceInsetRegion-Face.md Edit}
    */
    Face,
    /**
    * Targets the left eye
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetRegion/properties/FaceInsetRegion-LeftEye.md Edit}
    */
    LeftEye,
    /**
    * Targets the mouth
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetRegion/properties/FaceInsetRegion-Mouth.md Edit}
    */
    Mouth,
    /**
    * Targets the nose
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetRegion/properties/FaceInsetRegion-Nose.md Edit}
    */
    Nose,
    /**
    * Targets the right eye
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetRegion/properties/FaceInsetRegion-RightEye.md Edit}
    */
    RightEye
}

/**
* Draws a section of a tracked face.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/FaceInsetVisual-description.md Edit}
*/
interface FaceInsetVisual extends MaterialMeshVisual {
    /**
    * Returns the face region that the inset is applied to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/methods/FaceInsetVisual-getFaceRegion.md Edit}
    
    * @deprecated
    
    * @private
    */
    getFaceRegion(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/methods/FaceInsetVisual-setBarycentricCoordinates.md Edit}
    
    * @private
    */
    setBarycentricCoordinates(coordsJS: any[]): void
    
    /**
    * Applies the inset effect on `region`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/methods/FaceInsetVisual-setFaceRegion.md Edit}
    
    * @deprecated
    
    * @private
    */
    setFaceRegion(value: string): void
    
    /**
    * The index of the face this FaceInsetVisual uses.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-faceIndex.md Edit}
    */
    faceIndex: number
    
    /**
    * The region of the face this FaceInsetVisual draws.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-faceRegion.md Edit}
    */
    faceRegion: FaceInsetRegion
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-faceRegionIndices.md Edit}
    
    * @private
    */
    faceRegionIndices: number[]
    
    /**
    * Flips the drawn face region horizontally if enabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-flipX.md Edit}
    */
    flipX: boolean
    
    /**
    * Flips the drawn face region vertically if enabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-flipY.md Edit}
    */
    flipY: boolean
    
    /**
    * The amount of alpha fading applied from the border of the face inset inward.
    * This value must be in the range 0-1.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-innerBorderRadius.md Edit}
    */
    innerBorderRadius: number
    
    /**
    * The amount of alpha fading applied from the border of the face inset outward.
    * This value must be in the range 0-1.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-outerBorderRadius.md Edit}
    */
    outerBorderRadius: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-pivot.md Edit}
    
    * @private
    */
    pivot: vec2
    
    /**
    * The x and y scaling used to draw the face region.
    * Think of scaling as meaning how many times the face region could fit into the drawing area.
    * Higher values will zoom away from the face region, and lower values will zoom into it.
    * The normal, unzoomed scaling value is (1,1).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-sourceScale.md Edit}
    */
    sourceScale: vec2
    
    /**
    * Determines the quality of the face inset's borders.
    * A higher value means better looking borders but lower performance.
    * This value must be greater than 10 and less than 100.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceInsetVisual/properties/FaceInsetVisual-subdivisionsCount.md Edit}
    */
    subdivisionsCount: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FacelessTextureProvider/FacelessTextureProvider-description.md Edit}

* @private
*/
interface FacelessTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FacelessTextureProvider/properties/FacelessTextureProvider-inputTexture.md Edit}
    
    * @private
    */
    inputTexture: Texture
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FacelessTextureProvider/properties/FacelessTextureProvider-leftLarge.md Edit}
    
    * @readonly
    
    * @private
    */
    leftLarge: SkinSample
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FacelessTextureProvider/properties/FacelessTextureProvider-leftMedium.md Edit}
    
    * @readonly
    
    * @private
    */
    leftMedium: SkinSample
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FacelessTextureProvider/properties/FacelessTextureProvider-leftSmall.md Edit}
    
    * @readonly
    
    * @private
    */
    leftSmall: SkinSample
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FacelessTextureProvider/properties/FacelessTextureProvider-rightLarge.md Edit}
    
    * @readonly
    
    * @private
    */
    rightLarge: SkinSample
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FacelessTextureProvider/properties/FacelessTextureProvider-rightMedium.md Edit}
    
    * @readonly
    
    * @private
    */
    rightMedium: SkinSample
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FacelessTextureProvider/properties/FacelessTextureProvider-rightSmall.md Edit}
    
    * @readonly
    
    * @private
    */
    rightSmall: SkinSample
    
}

/**
* Triggered when a face can no longer be tracked.  For example, if a face gets blocked from the camera's view, or gets too far away.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceLostEvent/FaceLostEvent-description.md Edit}
*/
interface FaceLostEvent extends FaceTrackingEvent {
}

/**
* Applies a face mask effect. See the [Face Mask Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/face/face-effects/face-mask) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/FaceMaskVisual-description.md Edit}
*/
interface FaceMaskVisual extends MaterialMeshVisual {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-activeTriangleIndices.md Edit}
    
    * @unreleased
    */
    activeTriangleIndices: number[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-customMaskOnMouthClosed.md Edit}
    */
    customMaskOnMouthClosed: Texture
    
    /**
    * The index of the face this effect is attached to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-faceIndex.md Edit}
    */
    faceIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-hidesMaskOnMouthClosed.md Edit}
    */
    hidesMaskOnMouthClosed: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-maskCoords.md Edit}
    
    * @unreleased
    */
    maskCoords: number[]
    
    /**
    * If "Use Orig. Face" is enabled for this FaceMaskVisual in the Inspector panel, this property
    * specifies the face index to use for drawing the mask.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-originalFaceIndex.md Edit}
    */
    originalFaceIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-swapsMaskOnMouthClosed.md Edit}
    */
    swapsMaskOnMouthClosed: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-teethAlpha.md Edit}
    */
    teethAlpha: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-textureCoords.md Edit}
    
    * @unreleased
    */
    textureCoords: number[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-useOriginalTexCoords.md Edit}
    */
    useOriginalTexCoords: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMaskVisual/properties/FaceMaskVisual-useTextureFacePosition.md Edit}
    
    * @private
    */
    useTextureFacePosition: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMeshSource/FaceMeshSource-description.md Edit}

* @private
*/
declare enum FaceMeshSource {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMeshSource/properties/FaceMeshSource-FaceMorph.md Edit}
    
    * @private
    */
    FaceMorph,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceMeshSource/properties/FaceMeshSource-ARKit.md Edit}
    
    * @private
    */
    ARKit
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceNeutralityDataSender/FaceNeutralityDataSender-description.md Edit}

* @private
*/
interface FaceNeutralityDataSender extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceNeutralityDataSender/methods/FaceNeutralityDataSender-logMessage.md Edit}
    
    * @private
    */
    logMessage(message: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceNeutralityDataSender/methods/FaceNeutralityDataSender-sendImage.md Edit}
    
    * @private
    */
    sendImage(texture: Texture, shape: vec2): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceNeutralityDataSender/methods/FaceNeutralityDataSender-sendLandmarks.md Edit}
    
    * @private
    */
    sendLandmarks(landmarks: Float32Array): void
    
}
declare namespace FaceNeutralityDataSender {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceNeutralityDataSender/methods/FaceNeutralityDataSender-create.md Edit}
    
    * @private
    */
    export function create(): FaceNeutralityDataSender
    

}

/**
* Mesh provider for a Face Mesh. Accessible through the `control` property on a Face Mesh `RenderMesh`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/FaceRenderObjectProvider-description.md Edit}
*/
interface FaceRenderObjectProvider extends RenderObjectProvider {
    /**
    * Returns a list of all expression names being tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/methods/FaceRenderObjectProvider-getExpressionNames.md Edit}
    */
    getExpressionNames(): string[]
    
    /**
    * Returns the weight of the expression with the passed in name. See [Expressions](https://lensstudio.snapchat.com/api/lens-studio/Classes/OtherClasses#Expressions) for valid expression names.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/methods/FaceRenderObjectProvider-getExpressionWeightByName.md Edit}
    */
    getExpressionWeightByName(expressionName: string): number
    
    /**
    * Returns a Float32Array of all expression weights being tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/methods/FaceRenderObjectProvider-getExpressionWeights.md Edit}
    */
    getExpressionWeights(): Float32Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/methods/FaceRenderObjectProvider-getFaceFittingWeights.md Edit}
    
    * @private
    */
    getFaceFittingWeights(): Float32Array
    
    /**
    * When true, ears will be included in the Face Mesh geometry.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-earGeometryEnabled.md Edit}
    */
    earGeometryEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-externalFaceTexture.md Edit}
    
    * @private
    */
    externalFaceTexture: Texture
    
    /**
    * When true, a small area in the corners of the eyes will be included in the Face Mesh geometry.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-eyeCornerGeometryEnabled.md Edit}
    */
    eyeCornerGeometryEnabled: boolean
    
    /**
    * When true, eyes will be included in the Face Mesh geometry.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-eyeGeometryEnabled.md Edit}
    */
    eyeGeometryEnabled: boolean
    
    /**
    * When true, the general face (not including eyes and mouth) will be included in the Face Mesh geometry.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-faceGeometryEnabled.md Edit}
    */
    faceGeometryEnabled: boolean
    
    /**
    * Index of the face this FaceRenderObjectProvider mirrors.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-faceIndex.md Edit}
    */
    faceIndex: number
    
    /**
    * When true, the mouth will be included in the Face Mesh geometry.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-mouthGeometryEnabled.md Edit}
    */
    mouthGeometryEnabled: boolean
    
    /**
    * When true, the skull will be included in the Face Mesh geometry.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-skullGeometryEnabled.md Edit}
    */
    skullGeometryEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceRenderObjectProvider/properties/FaceRenderObjectProvider-trackingScopeAsset.md Edit}
    
    * @private
    */
    trackingScopeAsset: TrackingScopeAsset
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceSegmentationPostprocessor/FaceSegmentationPostprocessor-description.md Edit}

* @private
*/
interface FaceSegmentationPostprocessor extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceSegmentationPostprocessor/methods/FaceSegmentationPostprocessor-addEyes.md Edit}
    
    * @private
    */
    addEyes(eyelids: Texture, pupil: Texture, iris: Texture, eye: Texture, shape: vec2): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceSegmentationPostprocessor/methods/FaceSegmentationPostprocessor-debug.md Edit}
    
    * @private
    */
    debug(out: Uint8Array): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceSegmentationPostprocessor/methods/FaceSegmentationPostprocessor-processEye.md Edit}
    
    * @private
    */
    processEye(eyelid: Float32Array, pupil: Float32Array, iris: Float32Array, eye: Float32Array, shape: vec2, flipX: boolean): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceSegmentationPostprocessor/methods/FaceSegmentationPostprocessor-processFace.md Edit}
    
    * @private
    */
    processFace(landmarks: vec2[], face: Float32Array, hair: Float32Array, neck: Float32Array, body: Float32Array, accessories: Float32Array, background: Float32Array, imageTexture: Texture, provider: CropTextureProvider, imageShape: vec2, maskShape: vec2, maxSideLengthBodyMatting: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceSegmentationPostprocessor/methods/FaceSegmentationPostprocessor-sendTarget.md Edit}
    
    * @private
    */
    sendTarget(maxSideLengthHeadExtraction: number, maxSideLengthMattingHead: number): void
    
}
declare namespace FaceSegmentationPostprocessor {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceSegmentationPostprocessor/methods/FaceSegmentationPostprocessor-create.md Edit}
    
    * @private
    */
    export function create(): FaceSegmentationPostprocessor
    

}

/**
* Applies a face stretch effect.
* Face stretch features can be added to a FaceStretchVisual through the Inspector panel in Lens Studio.
* See the [Face Stretch Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/face/face-effects/face-stretch) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/FaceStretchVisual-description.md Edit}
*/
interface FaceStretchVisual extends BaseMeshVisual {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/methods/FaceStretchVisual-addFeature.md Edit}
    
    * @unreleased
    */
    addFeature(name: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/methods/FaceStretchVisual-clearFeatures.md Edit}
    
    * @unreleased
    */
    clearFeatures(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/methods/FaceStretchVisual-getFeatureNames.md Edit}
    
    * @unreleased
    */
    getFeatureNames(): string[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/methods/FaceStretchVisual-getFeaturePoints.md Edit}
    
    * @unreleased
    */
    getFeaturePoints(name: string): StretchPoint[]
    
    /**
    * Returns the weight of the face stretch feature named `feature`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/methods/FaceStretchVisual-getFeatureWeight.md Edit}
    */
    getFeatureWeight(feature: string): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/methods/FaceStretchVisual-removeFeature.md Edit}
    
    * @unreleased
    */
    removeFeature(name: string): void
    
    /**
    * Sets the weight of the face stretch feature named `feature` to `intensity`.
    * The intensity must be greater than -0.5 and less than 2.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/methods/FaceStretchVisual-setFeatureWeight.md Edit}
    */
    setFeatureWeight(feature: string, intensity: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/methods/FaceStretchVisual-updateFeaturePoints.md Edit}
    
    * @unreleased
    */
    updateFeaturePoints(name: string, points: StretchPoint[]): void
    
    /**
    * The index of the face the stretch will be applied to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceStretchVisual/properties/FaceStretchVisual-faceIndex.md Edit}
    */
    faceIndex: number
    
}

/**
* TextureProvider for face textures.
* See the [Face Texture Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/face/face-effects/face-texture) for more information.
* Can be accessed using [Texture.control](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Texture#control-textureprovider) on a face texture asset.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTextureProvider/FaceTextureProvider-description.md Edit}
*/
interface FaceTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTextureProvider/properties/FaceTextureProvider-adjustOffset.md Edit}
    
    * @private
    */
    adjustOffset: OffsetAdjustType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTextureProvider/properties/FaceTextureProvider-adjustOffsetMax.md Edit}
    
    * @private
    */
    adjustOffsetMax: vec2
    
    /**
    * Index of the face to track.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTextureProvider/properties/FaceTextureProvider-faceIndex.md Edit}
    */
    faceIndex: number
    
    /**
    * The source texture being drawn.
    * This is useful for controlling which effects are visible on the face texture, based on which camera output texture is being used.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTextureProvider/properties/FaceTextureProvider-inputTexture.md Edit}
    */
    inputTexture: Texture
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTextureProvider/properties/FaceTextureProvider-offset.md Edit}
    
    * @private
    */
    offset: vec2
    
    /**
    * The x and y scale used to draw the face within the texture region.
    * A lower scale will be more zoomed in on the face, and a higher scale will be more zoomed out.
    * The default scale is (1, 1).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTextureProvider/properties/FaceTextureProvider-scale.md Edit}
    */
    scale: vec2
    
}

/**
* This is the base class for all face tracking events. This event won't actually get triggered itself, so use one of the child classes instead.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTrackingEvent/FaceTrackingEvent-description.md Edit}
*/
interface FaceTrackingEvent extends SceneEvent {
    /**
    * The index of the face this event is tracking. Change this value to control which face the event tracks.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTrackingEvent/properties/FaceTrackingEvent-faceIndex.md Edit}
    */
    faceIndex: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTrackingMode/FaceTrackingMode-description.md Edit}

* @private
*/
declare enum FaceTrackingMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTrackingMode/properties/FaceTrackingMode-Fast.md Edit}
    
    * @private
    */
    Fast,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTrackingMode/properties/FaceTrackingMode-Precise.md Edit}
    
    * @private
    */
    Precise
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FaceTrackingModule/FaceTrackingModule-description.md Edit}

* @unreleased
*/
interface FaceTrackingModule extends Asset {
}

/**
* Provider for file based Audio Tracks.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileAudioTrackProvider/FileAudioTrackProvider-description.md Edit}
*/
interface FileAudioTrackProvider extends AudioTrackProvider {
    /**
    * Writes readSize samples into the passed in audioBuffer Float32Array.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileAudioTrackProvider/methods/FileAudioTrackProvider-getAudioBuffer.md Edit}
    */
    getAudioBuffer(audioBuffer: Float32Array, readSize: number): vec3
    
    /**
    * Writes current audio frame to the passed in `Float32Array` and returns the frame shape.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileAudioTrackProvider/methods/FileAudioTrackProvider-getAudioFrame.md Edit}
    */
    getAudioFrame(audioFrame: Float32Array): vec3
    
    /**
    * The duration of the AudioTrackAsset in seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileAudioTrackProvider/properties/FileAudioTrackProvider-duration.md Edit}
    
    * @readonly
    */
    duration: number
    
    /**
    * Loop count, if `-1` is provided, the audio track will loop forever.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileAudioTrackProvider/properties/FileAudioTrackProvider-loops.md Edit}
    */
    loops: number
    
    /**
    * The current position of the AudioTrackAsset in seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileAudioTrackProvider/properties/FileAudioTrackProvider-position.md Edit}
    */
    position: number
    
}

/**
* Provides an image marker based on an imported image file.
* For more information, see the [Marker Tracking](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/world/marker-tracking) guide.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileBasedMarkerProvider/FileBasedMarkerProvider-description.md Edit}
*/
interface FileBasedMarkerProvider extends NaturalFeatureMarkerProvider {
}

/**
* A file track provider of the Licensed Sounds from Asset LIbrary.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileLicensedSoundProvider/FileLicensedSoundProvider-description.md Edit}
*/
interface FileLicensedSoundProvider extends AudioTrackProvider {
    /**
    * Writes readSize samples into the passed in audioBuffer Float32Array.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileLicensedSoundProvider/methods/FileLicensedSoundProvider-getAudioBuffer.md Edit}
    */
    getAudioBuffer(audioBuffer: Float32Array, readSize: number): vec3
    
    /**
    * Writes current audio frame to the passed in Float32Array and returns the frame shape.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileLicensedSoundProvider/methods/FileLicensedSoundProvider-getAudioFrame.md Edit}
    */
    getAudioFrame(audioFrame: Float32Array): vec3
    
    /**
    * The duration of the AudioTrackAsset in seconds.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileLicensedSoundProvider/properties/FileLicensedSoundProvider-duration.md Edit}
    
    * @readonly
    */
    duration: number
    
    /**
    * Loop count, if -1 is provided, the audio track will loop forever.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileLicensedSoundProvider/properties/FileLicensedSoundProvider-loops.md Edit}
    */
    loops: number
    
}

/**
* A [TextureProvider](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#TextureProvider) for textures originating from files.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FileTextureProvider/FileTextureProvider-description.md Edit}
*/
interface FileTextureProvider extends TextureProvider {
}

/**
* Intersection filter settings. Unifies settings for world probes and collider overlap tests.   See also: [ColliderComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ColliderComponent), [Physics](https://lensstudio.snapchat.com/api/lens-studio/Classes/OtherClasses#Physics).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Filter/Filter-description.md Edit}
*/
interface Filter extends ScriptObject {
    /**
    * Include dynamic objects in intersection tests.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Filter/properties/Filter-includeDynamic.md Edit}
    */
    includeDynamic: boolean
    
    /**
    * Include intangible objects in intersection tests.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Filter/properties/Filter-includeIntangible.md Edit}
    */
    includeIntangible: boolean
    
    /**
    * Include static objects in intersection tests.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Filter/properties/Filter-includeStatic.md Edit}
    */
    includeStatic: boolean
    
    /**
    * If non-empty, only perform collision with these colliders. In other words: the set of colliders to include when performing collision tests, excluding all others.  If empty, this setting is disabled (effectively including all colliders, minus skipColliders).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Filter/properties/Filter-onlyColliders.md Edit}
    */
    onlyColliders: ColliderComponent[]
    
    /**
    * If non-empty, only perform collision with colliders in these layers. In other words: the set of layers to include when performing collision tests, excluding all others.  If empty, this setting is disabled (effectively including all layers, minus skipLayers).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Filter/properties/Filter-onlyLayers.md Edit}
    */
    onlyLayers: LayerSet
    
    /**
    * Skip collision with these colliders. In other words: the set of colliders to exclude when performing collision tests. This takes precedence over onlyColliders, so a collider that is in both is skipped.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Filter/properties/Filter-skipColliders.md Edit}
    */
    skipColliders: ColliderComponent[]
    
    /**
    * Skip collision with colliders in these layers. In other words: the set of layers to exclude when performing collision tests. This takes precedence over onlyLayers, so a layer that is in both is skipped.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Filter/properties/Filter-skipLayers.md Edit}
    */
    skipLayers: LayerSet
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FilteringMode/FilteringMode-description.md Edit}
*/
declare enum FilteringMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FilteringMode/properties/FilteringMode-Nearest.md Edit}
    */
    Nearest,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FilteringMode/properties/FilteringMode-Bilinear.md Edit}
    */
    Bilinear,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FilteringMode/properties/FilteringMode-Trilinear.md Edit}
    */
    Trilinear
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FixedCollisionMesh/FixedCollisionMesh-description.md Edit}
*/
interface FixedCollisionMesh extends CollisionMesh {
}

/**
* Fully constrain rotation and translation.  See also: [ConstraintComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ConstraintComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FixedConstraint/FixedConstraint-description.md Edit}
*/
interface FixedConstraint extends Constraint {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatAnimationPropertyTrack/FloatAnimationPropertyTrack-description.md Edit}

* @private
*/
interface FloatAnimationPropertyTrack extends AnimationPropertyTrack {
}

/**
* The base class for animation tracks using float values.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatAnimationTrack/FloatAnimationTrack-description.md Edit}

* @deprecated
*/
interface FloatAnimationTrack extends AnimationTrack {
}

/**
* Represents an animation track using float value keyframes.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatAnimationTrackKeyFramed/FloatAnimationTrackKeyFramed-description.md Edit}

* @deprecated
*/
interface FloatAnimationTrackKeyFramed extends FloatAnimationTrack {
    /**
    * Adds a key with value `value` at time `time`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatAnimationTrackKeyFramed/methods/FloatAnimationTrackKeyFramed-addKey.md Edit}
    */
    addKey(time: number, value: number): void
    
    /**
    * Removes all keys.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatAnimationTrackKeyFramed/methods/FloatAnimationTrackKeyFramed-removeAllKeys.md Edit}
    */
    removeAllKeys(): void
    
    /**
    * Removes key at index `index`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatAnimationTrackKeyFramed/methods/FloatAnimationTrackKeyFramed-removeKeyAt.md Edit}
    */
    removeKeyAt(index: number): void
    
}

/**
* Represents an animation track using vec3 value keyframes for a bezier curve.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatBezierAnimationTrackKeyFramed/FloatBezierAnimationTrackKeyFramed-description.md Edit}

* @deprecated
*/
interface FloatBezierAnimationTrackKeyFramed extends FloatAnimationTrack {
    /**
    * Adds a key with value `value` at time `time`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatBezierAnimationTrackKeyFramed/methods/FloatBezierAnimationTrackKeyFramed-addKey.md Edit}
    */
    addKey(time: number, value: vec3): void
    
    /**
    * Removes all keys.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatBezierAnimationTrackKeyFramed/methods/FloatBezierAnimationTrackKeyFramed-removeAllKeys.md Edit}
    */
    removeAllKeys(): void
    
    /**
    * Removes key at index `index`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FloatBezierAnimationTrackKeyFramed/methods/FloatBezierAnimationTrackKeyFramed-removeKeyAt.md Edit}
    */
    removeKeyAt(index: number): void
    
}

/**
* Arguments used with the `InteractionComponent.onFocusEnd` event.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FocusEndEventArgs/FocusEndEventArgs-description.md Edit}
*/
interface FocusEndEventArgs extends ScriptObject {
}

/**
* Arguments used with the `InteractionComponent.onFocusStart` event.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FocusStartEventArgs/FocusStartEventArgs-description.md Edit}
*/
interface FocusStartEventArgs extends ScriptObject {
}

/**
* A font asset used for rendering text.
* Used by [Text](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Text).
* For more information, see the [Text guide](https://lensstudio.snapchat.com/lens-studio/references/guides/adding-content/text/2d-text).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/Font-description.md Edit}
*/
interface Font extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getAscender.md Edit}
    
    * @private
    */
    getAscender(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getBoundingBox.md Edit}
    
    * @private
    */
    getBoundingBox(): BoundingBox
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getDefaultLineSpace.md Edit}
    
    * @private
    */
    getDefaultLineSpace(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getDescender.md Edit}
    
    * @private
    */
    getDescender(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getFamilyName.md Edit}
    
    * @private
    */
    getFamilyName(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getGlyphsForText.md Edit}
    
    * @private
    */
    getGlyphsForText(text: string): OutlineGlyph[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getKerningValue.md Edit}
    
    * @private
    */
    getKerningValue(leftGlyph: Glyph, rightGlyph: Glyph): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getPostscriptName.md Edit}
    
    * @private
    */
    getPostscriptName(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getStyleName.md Edit}
    
    * @private
    */
    getStyleName(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getUnderlinePosition.md Edit}
    
    * @private
    */
    getUnderlinePosition(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getUnderlineThickness.md Edit}
    
    * @private
    */
    getUnderlineThickness(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Font/methods/Font-getUnitsPerEm.md Edit}
    
    * @private
    */
    getUnitsPerEm(): number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FreezeFrameSystem/FreezeFrameSystem-description.md Edit}

* @private
*/
interface FreezeFrameSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FreezeFrameSystem/methods/FreezeFrameSystem-registerTurnOffCallback.md Edit}
    
    * @private
    */
    registerTurnOffCallback(callback: () => void): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Friend/Friend-description.md Edit}

* @private
*/
interface Friend extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Friend/methods/Friend-getAliasId.md Edit}
    
    * @private
    */
    getAliasId(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Friend/methods/Friend-getBitmojiSelfieId.md Edit}
    
    * @private
    */
    getBitmojiSelfieId(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Friend/methods/Friend-getDisplayname.md Edit}
    
    * @private
    */
    getDisplayname(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Friend/methods/Friend-getUserId.md Edit}
    
    * @private
    */
    getUserId(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Friend/methods/Friend-getUsername.md Edit}
    
    * @private
    */
    getUsername(): string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FriendSystem/FriendSystem-description.md Edit}

* @exposesUserData

* @private
*/
interface FriendSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FriendSystem/methods/FriendSystem-getAllFriendsInChat.md Edit}
    
    * @private
    */
    getAllFriendsInChat(): Friend[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FriendSystem/methods/FriendSystem-getChatFriendByIndex.md Edit}
    
    * @private
    */
    getChatFriendByIndex(index: number): Friend
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FriendSystem/methods/FriendSystem-getChatFriendByUserId.md Edit}
    
    * @private
    */
    getChatFriendByUserId(userId: string): Friend
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FriendSystem/methods/FriendSystem-getChatFriendByUsername.md Edit}
    
    * @deprecated
    
    * @private
    */
    getChatFriendByUsername(username: string): Friend
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FriendSystem/methods/FriendSystem-getNumFriendsInChat.md Edit}
    
    * @private
    */
    getNumFriendsInChat(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FriendSystem/methods/FriendSystem-initialize.md Edit}
    
    * @private
    */
    initialize(): void
    
}

/**
* Mode for setting frustum culling on Pass

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FrustumCullMode/FrustumCullMode-description.md Edit}
*/
declare enum FrustumCullMode {
    /**
    * Based on shader property, frustum culling will either be disabled or test with render object's aabb
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FrustumCullMode/properties/FrustumCullMode-Auto.md Edit}
    */
    Auto,
    /**
    * Enable frustum culling and extend render object's aabb to (1 + value)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FrustumCullMode/properties/FrustumCullMode-Extend.md Edit}
    */
    Extend,
    /**
    * Users define the specific AABB which is used for culling test. Assumes frustumCullMin and frustumCullMax are calculated in local space of the object. frustumCullMin is the bottom-left-back and frustumCullMax is the top-right-front of the user defined AABB.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/FrustumCullMode/properties/FrustumCullMode-UserDefinedAABB.md Edit}
    */
    UserDefinedAABB
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GalleryType/GalleryType-description.md Edit}

* @private
*/
declare enum GalleryType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GalleryType/properties/GalleryType-UserPreference.md Edit}
    
    * @private
    */
    UserPreference
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingAsset/GaussianSplattingAsset-description.md Edit}
*/
interface GaussianSplattingAsset extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingAsset/methods/GaussianSplattingAsset-getNumberOfFrames.md Edit}
    */
    getNumberOfFrames(): number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingVisual/GaussianSplattingVisual-description.md Edit}
*/
interface GaussianSplattingVisual extends MaterialMeshVisual {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingVisual/properties/GaussianSplattingVisual-activeFrame.md Edit}
    */
    activeFrame: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingVisual/properties/GaussianSplattingVisual-asset.md Edit}
    */
    asset: GaussianSplattingAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingVisual/properties/GaussianSplattingVisual-disableFrustumCulling.md Edit}
    
    * @private
    */
    disableFrustumCulling: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingVisual/properties/GaussianSplattingVisual-disablePrediction.md Edit}
    
    * @private
    */
    disablePrediction: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingVisual/properties/GaussianSplattingVisual-lastSortDuration.md Edit}
    
    * @readonly
    
    * @private
    */
    lastSortDuration: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GaussianSplattingVisual/properties/GaussianSplattingVisual-syncSorting.md Edit}
    
    * @private
    */
    syncSorting: boolean
    
}

/**
* Class for storing and retrieving data based on keys.
* Used by [PersistentStorageSystem](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#PersistentStorageSystem).
* For more information, see the [Persistent Storage guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/adding-interactivity/persistent-storage).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/GeneralDataStore-description.md Edit}
*/
interface GeneralDataStore extends ScriptObject {
    /**
    * Clears all data stored in the General Data Store.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-clear.md Edit}
    */
    clear(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-get.md Edit}
    
    * @deprecated
    
    * @private
    */
    get(key: string): string
    
    /**
    * Returns an array with all the keys in the store.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getAllKeys.md Edit}
    */
    getAllKeys(): string[]
    
    /**
    * Returns a boolean value stored under the given key, or false if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getBool.md Edit}
    */
    getBool(key: string): boolean
    
    /**
    * Returns a boolean array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getBoolArray.md Edit}
    */
    getBoolArray(key: string): boolean[]
    
    /**
    * Returns a double precision floating point number stored under the given key, or 0 if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getDouble.md Edit}
    */
    getDouble(key: string): number
    
    /**
    * Returns a floating point value stored under the given key, or 0 if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getFloat.md Edit}
    */
    getFloat(key: string): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getFloat32Array.md Edit}
    */
    getFloat32Array(key: string): Float32Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getFloat64Array.md Edit}
    */
    getFloat64Array(key: string): any
    
    /**
    * Returns a floating point array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getFloatArray.md Edit}
    */
    getFloatArray(key: string): number[]
    
    /**
    * Returns an integer number stored under the given key, or 0 if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getInt.md Edit}
    */
    getInt(key: string): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getInt16Array.md Edit}
    */
    getInt16Array(key: string): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getInt32Array.md Edit}
    */
    getInt32Array(key: string): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getInt8Array.md Edit}
    */
    getInt8Array(key: string): any
    
    /**
    * Returns an integer array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getIntArray.md Edit}
    */
    getIntArray(key: string): number[]
    
    /**
    * Returns a mat2 value stored under the given key, or a default mat2 if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getMat2.md Edit}
    */
    getMat2(key: string): mat2
    
    /**
    * Returns a mat2 array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getMat2Array.md Edit}
    */
    getMat2Array(key: string): mat2[]
    
    /**
    * Stores a mat3 value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getMat3.md Edit}
    */
    getMat3(key: string): mat3
    
    /**
    * Returns a mat3 array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getMat3Array.md Edit}
    */
    getMat3Array(key: string): mat3[]
    
    /**
    * Returns a mat4 value stored under the given key, or a default mat4 if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getMat4.md Edit}
    */
    getMat4(key: string): mat4
    
    /**
    * Returns a mat4 array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getMat4Array.md Edit}
    */
    getMat4Array(key: string): mat4[]
    
    /**
    * Returns the maximum total size allowed, in bytes, of all data stored in this General Data Store.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getMaxSizeInBytes.md Edit}
    */
    getMaxSizeInBytes(): number
    
    /**
    * Returns a quat value stored under the given key, or a default quat if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getQuat.md Edit}
    */
    getQuat(key: string): quat
    
    /**
    * Returns a quat array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getQuatArray.md Edit}
    */
    getQuatArray(key: string): quat[]
    
    /**
    * If `onStoreFull` has been set, this method returns the current total size, in bytes, of all data stored in this General Data Store. Otherwise, `0` is returned.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getSizeInBytes.md Edit}
    */
    getSizeInBytes(): number
    
    /**
    * Returns a string value stored under the given key, or empty string if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getString.md Edit}
    */
    getString(key: string): string
    
    /**
    * Returns a string array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getStringArray.md Edit}
    */
    getStringArray(key: string): string[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getUint16Array.md Edit}
    */
    getUint16Array(key: string): Uint16Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getUint32Array.md Edit}
    */
    getUint32Array(key: string): Uint32Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getUint8Array.md Edit}
    */
    getUint8Array(key: string): Uint8Array
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getValueCount.md Edit}
    
    * @private
    */
    getValueCount(): number
    
    /**
    * Returns a vec2 value stored under the given key, or a default vec2 if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getVec2.md Edit}
    */
    getVec2(key: string): vec2
    
    /**
    * Returns a vec2 array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getVec2Array.md Edit}
    */
    getVec2Array(key: string): vec2[]
    
    /**
    * Returns a vec3 value stored under the given key, or a default vec3 if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getVec3.md Edit}
    */
    getVec3(key: string): vec3
    
    /**
    * Returns a vec3 array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getVec3Array.md Edit}
    */
    getVec3Array(key: string): vec3[]
    
    /**
    * Returns a vec4 value stored under the given key, or a default vec4 if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getVec4.md Edit}
    */
    getVec4(key: string): vec4
    
    /**
    * Returns a vec4 array being stored under the given key, or an empty array if none exists.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-getVec4Array.md Edit}
    */
    getVec4Array(key: string): vec4[]
    
    /**
    * Returns true if a value is being stored under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-has.md Edit}
    */
    has(key: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-hasValueForKey.md Edit}
    
    * @deprecated
    
    * @private
    */
    hasValueForKey(key: string): boolean
    
    /**
    * Stores a boolean value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putBool.md Edit}
    */
    putBool(key: string, value: boolean): void
    
    /**
    * Stores a boolean array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putBoolArray.md Edit}
    */
    putBoolArray(key: string, value: boolean[]): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putBoolWithTimeToLive.md Edit}
    
    * @deprecated
    
    * @private
    */
    putBoolWithTimeToLive(key: string, value: boolean, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putBoolWithTimeToLiveDays.md Edit}
    
    * @deprecated
    
    * @private
    */
    putBoolWithTimeToLiveDays(key: string, value: boolean, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putBoolWithTimeToLiveHours.md Edit}
    
    * @deprecated
    
    * @private
    */
    putBoolWithTimeToLiveHours(key: string, value: boolean, ttl: number): void
    
    /**
    * Stores a double precision floating point number under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putDouble.md Edit}
    */
    putDouble(key: string, value: number): void
    
    /**
    * Stores a floating point value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putFloat.md Edit}
    */
    putFloat(key: string, value: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putFloat32Array.md Edit}
    */
    putFloat32Array(key: string, value: Float32Array): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putFloat64Array.md Edit}
    */
    putFloat64Array(key: string, value: any): void
    
    /**
    * Stores a floating point array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putFloatArray.md Edit}
    */
    putFloatArray(key: string, value: number[]): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putFloatWithTimeToLive.md Edit}
    
    * @deprecated
    
    * @private
    */
    putFloatWithTimeToLive(key: string, value: number, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putFloatWithTimeToLiveDays.md Edit}
    
    * @deprecated
    
    * @private
    */
    putFloatWithTimeToLiveDays(key: string, value: number, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putFloatWithTimeToLiveHours.md Edit}
    
    * @deprecated
    
    * @private
    */
    putFloatWithTimeToLiveHours(key: string, value: number, ttl: number): void
    
    /**
    * Stores an integer number value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putInt.md Edit}
    */
    putInt(key: string, value: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putInt16Array.md Edit}
    */
    putInt16Array(key: string, value: any): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putInt32Array.md Edit}
    */
    putInt32Array(key: string, value: any): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putInt8Array.md Edit}
    */
    putInt8Array(key: string, value: any): void
    
    /**
    * Stores an integer array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putIntArray.md Edit}
    */
    putIntArray(key: string, value: number[]): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putIntWithTimeToLive.md Edit}
    
    * @deprecated
    
    * @private
    */
    putIntWithTimeToLive(key: string, value: number, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putIntWithTimeToLiveDays.md Edit}
    
    * @deprecated
    
    * @private
    */
    putIntWithTimeToLiveDays(key: string, value: number, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putIntWithTimeToLiveHours.md Edit}
    
    * @deprecated
    
    * @private
    */
    putIntWithTimeToLiveHours(key: string, value: number, ttl: number): void
    
    /**
    * Stores a mat2 value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putMat2.md Edit}
    */
    putMat2(key: string, value: mat2): void
    
    /**
    * Stores a mat2 array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putMat2Array.md Edit}
    */
    putMat2Array(key: string, value: mat2[]): void
    
    /**
    * Stores a mat3 value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putMat3.md Edit}
    */
    putMat3(key: string, value: mat3): void
    
    /**
    * Stores a mat3 array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putMat3Array.md Edit}
    */
    putMat3Array(key: string, value: mat3[]): void
    
    /**
    * Stores a mat4 value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putMat4.md Edit}
    */
    putMat4(key: string, value: mat4): void
    
    /**
    * Stores a mat4 array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putMat4Array.md Edit}
    */
    putMat4Array(key: string, value: mat4[]): void
    
    /**
    * Stores a quat value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putQuat.md Edit}
    */
    putQuat(key: string, value: quat): void
    
    /**
    * Stores a quat array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putQuatArray.md Edit}
    */
    putQuatArray(key: string, value: quat[]): void
    
    /**
    * Stores a string value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putString.md Edit}
    */
    putString(key: string, value: string): void
    
    /**
    * Stores a string array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putStringArray.md Edit}
    */
    putStringArray(key: string, value: string[]): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putStringWithTimeToLive.md Edit}
    
    * @deprecated
    
    * @private
    */
    putStringWithTimeToLive(key: string, value: string, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putStringWithTimeToLiveDays.md Edit}
    
    * @deprecated
    
    * @private
    */
    putStringWithTimeToLiveDays(key: string, value: string, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putStringWithTimeToLiveHours.md Edit}
    
    * @deprecated
    
    * @private
    */
    putStringWithTimeToLiveHours(key: string, value: string, ttl: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putUint16Array.md Edit}
    */
    putUint16Array(key: string, value: Uint16Array): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putUint32Array.md Edit}
    */
    putUint32Array(key: string, value: Uint32Array): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putUint8Array.md Edit}
    */
    putUint8Array(key: string, value: Uint8Array): void
    
    /**
    * Stores a vec2 value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putVec2.md Edit}
    */
    putVec2(key: string, value: vec2): void
    
    /**
    * Stores a vec2 array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putVec2Array.md Edit}
    */
    putVec2Array(key: string, value: vec2[]): void
    
    /**
    * Stores a vec3 value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putVec3.md Edit}
    */
    putVec3(key: string, value: vec3): void
    
    /**
    * Stores a vec3 array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putVec3Array.md Edit}
    */
    putVec3Array(key: string, value: vec3[]): void
    
    /**
    * Stores a vec4 value under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putVec4.md Edit}
    */
    putVec4(key: string, value: vec4): void
    
    /**
    * Stores a vec4 array under the given key.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-putVec4Array.md Edit}
    */
    putVec4Array(key: string, value: vec4[]): void
    
    /**
    * Removes the value being stored under the given key. If no value exists under the key, nothing will happen.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-remove.md Edit}
    */
    remove(key: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-removeBool.md Edit}
    
    * @deprecated
    
    * @private
    */
    removeBool(key: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-removeFloat.md Edit}
    
    * @deprecated
    
    * @private
    */
    removeFloat(key: string): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-removeInt.md Edit}
    
    * @deprecated
    
    * @private
    */
    removeInt(key: string): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-removeString.md Edit}
    
    * @deprecated
    
    * @private
    */
    removeString(key: string): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-size.md Edit}
    
    * @deprecated
    
    * @private
    */
    size(): number
    
    /**
    * Callback function that gets called when the allowed storage limit has been passed.
    * The store won't be saved if it is full, so if this is called make sure to remove data until back under the limit.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/properties/GeneralDataStore-onStoreFull.md Edit}
    */
    onStoreFull: () => void
    
}
declare namespace GeneralDataStore {
    /**
    * Creates a General Data Store.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeneralDataStore/methods/GeneralDataStore-create.md Edit}
    */
    export function create(): GeneralDataStore
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoData/GeoData-description.md Edit}

* @private
*/
interface GeoData extends AbstractData {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoData/methods/GeoData-getTaxonomyJson.md Edit}
    
    * @private
    */
    getTaxonomyJson(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoData/methods/GeoData-getTemperatureCelsius.md Edit}
    
    * @private
    */
    getTemperatureCelsius(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoData/methods/GeoData-getTemperatureFahrenheit.md Edit}
    
    * @private
    */
    getTemperatureFahrenheit(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoData/methods/GeoData-getWeatherCondition.md Edit}
    
    * @private
    */
    getWeatherCondition(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoData/methods/GeoData-isTaxonomyAvailable.md Edit}
    
    * @private
    */
    isTaxonomyAvailable(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoData/methods/GeoData-isWeatherAvailable.md Edit}
    
    * @private
    */
    isWeatherAvailable(): boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/GeoEntity-description.md Edit}

* @private
*/
interface GeoEntity extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/methods/GeoEntity-getAsset.md Edit}
    
    * @private
    */
    getAsset(assetKey: number): Promise<Asset>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/methods/GeoEntity-hasAsset.md Edit}
    
    * @private
    */
    hasAsset(assetKey: number): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/methods/GeoEntity-removeAsset.md Edit}
    
    * @private
    */
    removeAsset(assetKey: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/methods/GeoEntity-setAsset.md Edit}
    
    * @private
    */
    setAsset(assetKey: number, asset: Asset): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/properties/GeoEntity-createdAt.md Edit}
    
    * @readonly
    
    * @private
    */
    createdAt?: Date
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/properties/GeoEntity-displayName.md Edit}
    
    * @private
    */
    displayName: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/properties/GeoEntity-key.md Edit}
    
    * @private
    */
    key: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/properties/GeoEntity-metadata.md Edit}
    
    * @private
    */
    metadata: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/properties/GeoEntity-objectType.md Edit}
    
    * @private
    */
    objectType: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/properties/GeoEntity-position.md Edit}
    
    * @private
    */
    position: GeoPosition
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/properties/GeoEntity-readPermission.md Edit}
    
    * @private
    */
    readPermission: AccessLevel
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/properties/GeoEntity-writePermission.md Edit}
    
    * @private
    */
    writePermission: AccessLevel
    
}
declare namespace GeoEntity {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoEntity/methods/GeoEntity-create.md Edit}
    
    * @private
    */
    export function create(): GeoEntity
    

}

/**
* Namespace for location functionality.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoLocation/GeoLocation-description.md Edit}
*/
interface GeoLocation {
}
declare namespace GeoLocation {
    /**
    * Creates a new `LocationService`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoLocation/methods/GeoLocation-createLocationService.md Edit}
    */
    export function createLocationService(): LocationService
    
    /**
    * Calculates heading based on north aligned device orientation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoLocation/methods/GeoLocation-getNorthAlignedHeading.md Edit}
    */
    export function getNorthAlignedHeading(northAlignedOrientation: quat): number
    

}

/**
* Enumeration of supported GPS location accuracy.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoLocationAccuracy/GeoLocationAccuracy-description.md Edit}
*/
declare enum GeoLocationAccuracy {
    /**
    * Used for guiding the user. Generally accurate up to 5 meters.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoLocationAccuracy/properties/GeoLocationAccuracy-Navigation.md Edit}
    */
    Navigation,
    /**
    * Best possible accuracy without navigation requirement. Generally accurate up to 5 meters.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoLocationAccuracy/properties/GeoLocationAccuracy-High.md Edit}
    */
    High,
    /**
    * Generally accurate up to 10 meters. Power efficient option.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoLocationAccuracy/properties/GeoLocationAccuracy-Medium.md Edit}
    */
    Medium,
    /**
    * Generally accurate up to 100 meters. The most power efficient option.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoLocationAccuracy/properties/GeoLocationAccuracy-Low.md Edit}
    */
    Low
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeometryType/GeometryType-description.md Edit}

* @private
*/
declare enum GeometryType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeometryType/properties/GeometryType-Point.md Edit}
    
    * @private
    */
    Point,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeometryType/properties/GeometryType-MultiPoint.md Edit}
    
    * @private
    */
    MultiPoint,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeometryType/properties/GeometryType-Line.md Edit}
    
    * @private
    */
    Line,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeometryType/properties/GeometryType-MultiLine.md Edit}
    
    * @private
    */
    MultiLine,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeometryType/properties/GeometryType-Polygon.md Edit}
    
    * @private
    */
    Polygon,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeometryType/properties/GeometryType-MultiPolygon.md Edit}
    
    * @private
    */
    MultiPolygon
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoObject/GeoObject-description.md Edit}

* @private
*/
interface GeoObject extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoObject/properties/GeoObject-geometry.md Edit}
    
    * @readonly
    
    * @private
    */
    geometry: (vec2[][][]|vec2[]|vec2[][]|vec2)
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoObject/properties/GeoObject-geometryType.md Edit}
    
    * @readonly
    
    * @private
    */
    geometryType: GeometryType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoObject/properties/GeoObject-id.md Edit}
    
    * @readonly
    
    * @private
    */
    id: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoObject/properties/GeoObject-properties.md Edit}
    
    * @readonly
    
    * @private
    */
    properties: object
    
}

/**
* The location of the device.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoPosition/GeoPosition-description.md Edit}
*/
interface GeoPosition extends ScriptObject {
    /**
    * Represents the direction towards which the device is facing. This value, specified in degrees, indicates how far off from heading true north the device is. 0 degrees represents true north, and the direction is determined clockwise.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoPosition/properties/GeoPosition-heading.md Edit}
    
    * @readonly
    */
    heading: number
    
    /**
    * The accuracy of the latitude and longitude properties, expressed in meters.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoPosition/properties/GeoPosition-horizontalAccuracy.md Edit}
    */
    horizontalAccuracy: number
    
    /**
    * Indicates whether the device is able to provide heading information.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoPosition/properties/GeoPosition-isHeadingAvailable.md Edit}
    
    * @readonly
    */
    isHeadingAvailable: boolean
    
    /**
    * The position's latitude in decimal degrees.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoPosition/properties/GeoPosition-latitude.md Edit}
    */
    latitude: number
    
    /**
    * The position's longitude in decimal degrees.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoPosition/properties/GeoPosition-longitude.md Edit}
    */
    longitude: number
    
    /**
    * The accuracy of the altitude property, expressed in meters.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoPosition/properties/GeoPosition-verticalAccuracy.md Edit}
    */
    verticalAccuracy: number
    
}
declare namespace GeoPosition {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoPosition/methods/GeoPosition-create.md Edit}
    */
    export function create(): GeoPosition
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoStorageModule/GeoStorageModule-description.md Edit}

* @private
*/
interface GeoStorageModule extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoStorageModule/methods/GeoStorageModule-create.md Edit}
    
    * @private
    */
    create(): GeoStore
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoStorageModule/properties/GeoStorageModule-appId.md Edit}
    
    * @private
    */
    appId: string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoStore/GeoStore-description.md Edit}

* @private
*/
interface GeoStore extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoStore/methods/GeoStore-query.md Edit}
    
    * @private
    */
    query(queryOptions: QueryGeoStorageOptions, onRetrieved: (entities: GeoEntity[]) => void, onError: (description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoStore/methods/GeoStore-read.md Edit}
    
    * @private
    */
    read(key: string, onRetrieved: (entity: GeoEntity) => void, onError: (description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoStore/methods/GeoStore-remove.md Edit}
    
    * @private
    */
    remove(key: string, onRemoved: () => void, onError: (description: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GeoStore/methods/GeoStore-write.md Edit}
    
    * @private
    */
    write(entity: GeoEntity, onSaved: () => void, onError: (description: string) => void): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/GestureModule-description.md Edit}

* @wearableOnly
*/
interface GestureModule extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPalmPressedEvent.md Edit}
    
    * @private
    */
    getPalmPressedEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPalmReleasedEvent.md Edit}
    
    * @private
    */
    getPalmReleasedEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPalmTapDownEvent.md Edit}
    */
    getPalmTapDownEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPalmTapUpEvent.md Edit}
    */
    getPalmTapUpEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchDetectabilityEvent.md Edit}
    
    * @private
    */
    getPinchDetectabilityEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchDownEvent.md Edit}
    */
    getPinchDownEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchHoldEvent.md Edit}
    
    * @private
    */
    getPinchHoldEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchProximityByFingerEvent.md Edit}
    
    * @private
    */
    getPinchProximityByFingerEvent(handType: GestureModule.HandType, fingerType: GestureModule.FingerType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchReleasedEvent.md Edit}
    
    * @private
    */
    getPinchReleasedEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchStrengthEvent.md Edit}
    */
    getPinchStrengthEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchTouchedEvent.md Edit}
    
    * @private
    */
    getPinchTouchedEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchUpEvent.md Edit}
    */
    getPinchUpEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getPinchVisibilityEvent.md Edit}
    
    * @private
    */
    getPinchVisibilityEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getQuickPinchByFingerEvent.md Edit}
    
    * @private
    */
    getQuickPinchByFingerEvent(handType: GestureModule.HandType, fingerType: GestureModule.FingerType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getQuickPinchEvent.md Edit}
    
    * @private
    */
    getQuickPinchEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getTargetingDataEvent.md Edit}
    */
    getTargetingDataEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/methods/GestureModule-getTargetingRayEvent.md Edit}
    
    * @private
    */
    getTargetingRayEvent(handType: GestureModule.HandType): any
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/properties/GestureModule-pinchModel.md Edit}
    
    * @private
    */
    pinchModel: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule/properties/GestureModule-targetingModel.md Edit}
    
    * @private
    */
    targetingModel: BinAsset
    
}

declare namespace GestureModule {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.FingerType/GestureModule.FingerType-description.md Edit}
    
    * @wearableOnly
    
    * @private
    */
    enum FingerType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.FingerType/properties/GestureModule.FingerType-Thumb.md Edit}
        
        * @private
        */
        Thumb,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.FingerType/properties/GestureModule.FingerType-Index.md Edit}
        
        * @private
        */
        Index,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.FingerType/properties/GestureModule.FingerType-Middle.md Edit}
        
        * @private
        */
        Middle,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.FingerType/properties/GestureModule.FingerType-Ring.md Edit}
        
        * @private
        */
        Ring,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.FingerType/properties/GestureModule.FingerType-Pinky.md Edit}
        
        * @private
        */
        Pinky
    }

}

declare namespace GestureModule {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.HandType/GestureModule.HandType-description.md Edit}
    
    * @wearableOnly
    */
    enum HandType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.HandType/properties/GestureModule.HandType-Left.md Edit}
        */
        Left,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GestureModule.HandType/properties/GestureModule.HandType-Right.md Edit}
        */
        Right
    }

}

/**
* Represents a GLTF 3D Model.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GltfAsset/GltfAsset-description.md Edit}
*/
interface GltfAsset extends Asset {
    /**
    * Try instantiating an object from the GLTF asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GltfAsset/methods/GltfAsset-tryInstantiate.md Edit}
    */
    tryInstantiate(parent: SceneObject, material: Material): SceneObject
    
    /**
    * Try instantiating an object from the GLTF asset with supplied GltfSetting
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GltfAsset/methods/GltfAsset-tryInstantiateWithSetting.md Edit}
    */
    tryInstantiateWithSetting(parent: SceneObject, material: Material, gltfSettings: GltfSettings): SceneObject
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GltfAsset/properties/GltfAsset-extras.md Edit}
    
    * @readonly
    */
    extras: string
    
}

/**
* Settings for importing a glTF Asset.
* Use this with [GltfAsset](https://lensstudio.snapchat.com/api/classes/GltfAsset) component's `tryInstantiateWithSetting` method.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GltfSettings/GltfSettings-description.md Edit}
*/
interface GltfSettings extends ScriptObject {
    /**
    * Units for all linear distances in glTF are meters and in LensStudio are centimeters, enable this option if you want to automatically scale from meters into centimeters when importing the glTF file.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GltfSettings/properties/GltfSettings-convertMetersToCentimeters.md Edit}
    */
    convertMetersToCentimeters: boolean
    
    /**
    * Whether the GLB Loader should optimize geometry. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GltfSettings/properties/GltfSettings-optimizeGeometry.md Edit}
    */
    optimizeGeometry: boolean
    
}
declare namespace GltfSettings {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GltfSettings/methods/GltfSettings-create.md Edit}
    */
    export function create(): GltfSettings
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Glyph/Glyph-description.md Edit}

* @private
*/
interface Glyph extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Glyph/methods/Glyph-getAdvanceX.md Edit}
    
    * @private
    */
    getAdvanceX(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Glyph/methods/Glyph-getAdvanceY.md Edit}
    
    * @private
    */
    getAdvanceY(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Glyph/methods/Glyph-getBoundingBox.md Edit}
    
    * @private
    */
    getBoundingBox(): BoundingBox
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Glyph/methods/Glyph-getCharacters.md Edit}
    
    * @private
    */
    getCharacters(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Glyph/methods/Glyph-getFont.md Edit}
    
    * @private
    */
    getFont(): Font
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Glyph/methods/Glyph-getIndex.md Edit}
    
    * @private
    */
    getIndex(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Glyph/methods/Glyph-getMeshBuilder.md Edit}
    
    * @private
    */
    getMeshBuilder(): ExtrudedMeshBuilder
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphLoader/GlyphLoader-description.md Edit}

* @private
*/
interface GlyphLoader extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphLoader/methods/GlyphLoader-getGlyphsAndPositions.md Edit}
    
    * @private
    */
    getGlyphsAndPositions(text: string, preferredFonts: Font[]): GlyphsAndPositions
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphMeshBuilder/GlyphMeshBuilder-description.md Edit}

* @private
*/
interface GlyphMeshBuilder extends ExtrudedMeshBuilder {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphMeshBuilder/properties/GlyphMeshBuilder-boundingBox.md Edit}
    
    * @private
    */
    boundingBox: BoundingBox
    
}
declare namespace GlyphMeshBuilder {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphMeshBuilder/methods/GlyphMeshBuilder-createMeshBuilder.md Edit}
    
    * @private
    */
    export function createMeshBuilder(glyph: OutlineGlyph): GlyphMeshBuilder
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineEdge/GlyphOutlineEdge-description.md Edit}

* @private
*/
interface GlyphOutlineEdge {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineEdge/methods/GlyphOutlineEdge-getFirstNormalIndex.md Edit}
    
    * @private
    */
    getFirstNormalIndex(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineEdge/methods/GlyphOutlineEdge-getFirstVertex.md Edit}
    
    * @private
    */
    getFirstVertex(): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineEdge/methods/GlyphOutlineEdge-getFirstVertexU.md Edit}
    
    * @private
    */
    getFirstVertexU(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineEdge/methods/GlyphOutlineEdge-getSecondNormalIndex.md Edit}
    
    * @private
    */
    getSecondNormalIndex(): number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineShape/GlyphOutlineShape-description.md Edit}

* @private
*/
interface GlyphOutlineShape {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineShape/methods/GlyphOutlineShape-getEdges.md Edit}
    
    * @private
    */
    getEdges(): GlyphOutlineEdge[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineShape/methods/GlyphOutlineShape-getLength.md Edit}
    
    * @private
    */
    getLength(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineShape/methods/GlyphOutlineShape-getNormals.md Edit}
    
    * @private
    */
    getNormals(): vec2[]
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineShapes/GlyphOutlineShapes-description.md Edit}

* @private
*/
interface GlyphOutlineShapes {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineShapes/methods/GlyphOutlineShapes-getBoundary.md Edit}
    
    * @private
    */
    getBoundary(): GlyphOutlineShape
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphOutlineShapes/methods/GlyphOutlineShapes-getHoles.md Edit}
    
    * @private
    */
    getHoles(): GlyphOutlineShape[]
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphPosition/GlyphPosition-description.md Edit}

* @private
*/
interface GlyphPosition {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphPosition/methods/GlyphPosition-getAdvance.md Edit}
    
    * @private
    */
    getAdvance(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphPosition/methods/GlyphPosition-getOffset.md Edit}
    
    * @private
    */
    getOffset(): vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphsAndPositions/GlyphsAndPositions-description.md Edit}

* @private
*/
interface GlyphsAndPositions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphsAndPositions/methods/GlyphsAndPositions-getCaretSubpositions.md Edit}
    
    * @private
    */
    getCaretSubpositions(): number[][]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphsAndPositions/methods/GlyphsAndPositions-getGlyphs.md Edit}
    
    * @private
    */
    getGlyphs(): Glyph[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphsAndPositions/methods/GlyphsAndPositions-getPositions.md Edit}
    
    * @private
    */
    getPositions(): GlyphPosition[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GlyphsAndPositions/methods/GlyphsAndPositions-getStringIndices.md Edit}
    
    * @private
    */
    getStringIndices(): number[]
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GraphicsApi/GraphicsApi-description.md Edit}

* @private
*/
declare enum GraphicsApi {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GraphicsApi/properties/GraphicsApi-OpenGL.md Edit}
    
    * @private
    */
    OpenGL,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GraphicsApi/properties/GraphicsApi-Metal.md Edit}
    
    * @private
    */
    Metal,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GraphicsApi/properties/GraphicsApi-SnapGraphicsOpenGL.md Edit}
    
    * @private
    */
    SnapGraphicsOpenGL,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GraphicsApi/properties/GraphicsApi-SnapGraphicsMetal.md Edit}
    
    * @private
    */
    SnapGraphicsMetal
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GridMeshBuilder/GridMeshBuilder-description.md Edit}

* @private
*/
declare class GridMeshBuilder {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GridMeshBuilder/methods/GridMeshBuilder-GridMeshBuilder.md Edit}
    
    * @private
    */
    constructor()
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/GridMeshBuilder/methods/GridMeshBuilder-build.md Edit}
    
    * @private
    */
    build(width: number, height: number): RenderMesh
    
}

/**
* This class has been **Deprecated**. Please instead use the [DeviceTracking](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#DeviceTracking) component with Tracking Mode set to Rotation.
* See the [Tracking Modes](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/world/tracking-modes) guide for more information.

* Applies the device's gyroscope rotation to the SceneObject it is attached to.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Gyroscope/Gyroscope-description.md Edit}

* @deprecated
*/
interface Gyroscope extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Gyroscope/methods/Gyroscope-setOnGyroscopeInitialized.md Edit}
    
    * @private
    */
    setOnGyroscopeInitialized(eventCallback: () => void): void
    
    /**
    * If enabled, the Gyroscope's rotation will be inverted when the front facing camera is active.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Gyroscope/properties/Gyroscope-invertOnFrontCamera.md Edit}
    */
    invertOnFrontCamera: boolean
    
    /**
    * If enabled, the Gyroscope's rotation will be inverted.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Gyroscope/properties/Gyroscope-invertRotation.md Edit}
    */
    invertRotation: boolean
    
}

/**
* Hair asset converted from an FBX containing splines to be used with [Hair Visual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#HairVisual).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairDataAsset/HairDataAsset-description.md Edit}
*/
interface HairDataAsset extends Asset {
}

/**
* Component that renders hair simulation.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/HairVisual-description.md Edit}
*/
interface HairVisual extends BaseMeshVisual {
    /**
    * Adds a collider to the simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-addCollider.md Edit}
    */
    addCollider(colliderComponent: ColliderComponent): void
    
    /**
    * Removes all hair colliders from the hair simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-clearColliders.md Edit}
    */
    clearColliders(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-getCollider.md Edit}
    
    * @private
    */
    getCollider(index: number): ColliderComponent
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-getColliderCount.md Edit}
    
    * @private
    */
    getColliderCount(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-isFallbackInitialized.md Edit}
    
    * @deprecated
    
    * @private
    */
    isFallbackInitialized(): boolean
    
    /**
    * Returns `true` if hair simulation is supported by the device.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-isHardwareSupported.md Edit}
    */
    isHardwareSupported(): boolean
    
    /**
    * Returns `true` if the hair resources are initialized.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-isInitialized.md Edit}
    */
    isInitialized(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-rebuildFallbackResources.md Edit}
    
    * @deprecated
    
    * @private
    */
    rebuildFallbackResources(): void
    
    /**
    * Removes a collider from the simulation by index and returns it.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-removeColliderByIndex.md Edit}
    */
    removeColliderByIndex(index: number): ColliderComponent
    
    /**
    * Resets the simulation. May be called if the object with the hair simulation is toggled between enabled and disabled.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/methods/HairVisual-resetSimulation.md Edit}
    */
    resetSimulation(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-bendStiff.md Edit}
    
    * @deprecated
    
    * @private
    */
    bendStiff: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-bendStiffness.md Edit}
    
    * @private
    */
    bendStiffness: number
    
    /**
    * Density of each clump, higher number would result in "messier" looking hair.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-clumpDensity.md Edit}
    */
    clumpDensity: number
    
    /**
    * Offset amount of hair roots.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-clumpRadius.md Edit}
    */
    clumpRadius: number
    
    /**
    * Offset amount of hair tips.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-clumpTipScale.md Edit}
    */
    clumpTipScale: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-collapseStiff.md Edit}
    
    * @deprecated
    
    * @private
    */
    collapseStiff: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-collapseStiffness.md Edit}
    
    * @private
    */
    collapseStiffness: number
    
    /**
    * List of all colliders assigned to the hair simulation of the current hair visual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-colliders.md Edit}
    */
    colliders: ColliderComponent[]
    
    /**
    * Determines if collision is enabled for hair.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-collisionEnabled.md Edit}
    */
    collisionEnabled: boolean
    
    /**
    * Determines amount of friction for collision between hair strands.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-collisionFriction.md Edit}
    */
    collisionFriction: number
    
    /**
    * Determines how much position offset collision will cause.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-collisionOffset.md Edit}
    */
    collisionOffset: number
    
    /**
    * Determines how stiff the collision is.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-collisionStiffness.md Edit}
    */
    collisionStiffness: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-controlVertexCount.md Edit}
    
    * @deprecated
    
    * @private
    */
    controlVertexCount: number
    
    /**
    * Higher value of damp will cause hair to have less free movement.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-damp.md Edit}
    */
    damp: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-debugModeEnabled.md Edit}
    
    * @private
    */
    debugModeEnabled: boolean
    
    /**
    * Amount of density created to thicken hair.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-density.md Edit}
    */
    density: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-drawFbxGuides.md Edit}
    
    * @private
    */
    drawFbxGuides: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-drawFbxStrands.md Edit}
    
    * @deprecated
    
    * @private
    */
    drawFbxStrands: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-drawSimulatedGuides.md Edit}
    
    * @private
    */
    drawSimulatedGuides: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-drawSimulatedStrands.md Edit}
    
    * @deprecated
    
    * @private
    */
    drawSimulatedStrands: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-fallbackHairMaterial.md Edit}
    
    * @deprecated
    */
    fallbackHairMaterial: Material
    
    /**
    * This enables fallback mode which turns off physics simulations; it is recommended to enable fallback mode on lower-end devices. It will be enabled automatically if device doesn't support hair simulation feature.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-fallbackModeEnabled.md Edit}
    */
    fallbackModeEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-frameRate.md Edit}
    
    * @private
    */
    frameRate: number
    
    /**
    * Amount of friction for hair strands.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-friction.md Edit}
    */
    friction: number
    
    /**
    * Gravity force that gets added for hair's physics simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-gravity.md Edit}
    */
    gravity: vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-hairData.md Edit}
    
    * @private
    */
    hairData: HairDataAsset
    
    /**
    * Material used by this simulation to render hair.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-hairMaterial.md Edit}
    */
    hairMaterial: Material
    
    /**
    * Determines the amount of vertices on each strand. `0` means using original number of the strands. `1` is the smallest resolution for hair. Keep in mind when you change this property, the hair geometry will be regenerated.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-hairResolution.md Edit}
    */
    hairResolution: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-hairstyleGuides.md Edit}
    
    * @deprecated
    
    * @private
    */
    hairstyleGuides: SceneObject
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-hairstyleVersion.md Edit}
    
    * @readonly
    
    * @private
    */
    hairstyleVersion: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-headRepulsionEnable.md Edit}
    
    * @deprecated
    
    * @private
    */
    headRepulsionEnable: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-headRepulsionFriction.md Edit}
    
    * @deprecated
    
    * @private
    */
    headRepulsionFriction: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-headRepulsionOffset.md Edit}
    
    * @deprecated
    
    * @private
    */
    headRepulsionOffset: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-headRepulsionStiff.md Edit}
    
    * @deprecated
    
    * @private
    */
    headRepulsionStiff: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-isDebugMode.md Edit}
    
    * @deprecated
    
    * @private
    */
    isDebugMode: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-isFallbackMode.md Edit}
    
    * @deprecated
    
    * @private
    */
    isFallbackMode: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-multiStrandInterpolationCosThreshold.md Edit}
    
    * @deprecated
    
    * @private
    */
    multiStrandInterpolationCosThreshold: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-multiStrandInterpolationInstanceCount.md Edit}
    
    * @deprecated
    
    * @private
    */
    multiStrandInterpolationInstanceCount: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-multiStrandInterpolationLengthThreshold.md Edit}
    
    * @deprecated
    
    * @private
    */
    multiStrandInterpolationLengthThreshold: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-multiStrandInterpolationNoise.md Edit}
    
    * @deprecated
    
    * @private
    */
    multiStrandInterpolationNoise: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-multiStrandInterpolationRadius.md Edit}
    
    * @deprecated
    
    * @private
    */
    multiStrandInterpolationRadius: number
    
    /**
    * Offset of hair density.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-noise.md Edit}
    */
    noise: number
    
    /**
    * This function gets called when the hair visual is initialized in the Lens.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-onInitialized.md Edit}
    */
    onInitialized: (hairVisual: HairVisual) => void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-preserveStiff.md Edit}
    
    * @deprecated
    
    * @private
    */
    preserveStiff: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-primaryHairMaterial.md Edit}
    
    * @deprecated
    */
    primaryHairMaterial: Material
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-rebuildStrandPointCount.md Edit}
    
    * @deprecated
    
    * @private
    */
    rebuildStrandPointCount: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-relativeStrandScaleEnabled.md Edit}
    
    * @deprecated
    
    * @private
    */
    relativeStrandScaleEnabled: boolean
    
    /**
    * If enabled, hair strands will collide with themselves.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-selfCollisionEnabled.md Edit}
    */
    selfCollisionEnabled: boolean
    
    /**
    * Friction of collisions between hair strands.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-selfCollisionFriction.md Edit}
    */
    selfCollisionFriction: number
    
    /**
    * Radius limit of collisions between hair strands.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-selfCollisionRadius.md Edit}
    */
    selfCollisionRadius: number
    
    /**
    * Determines how stiff collision between hair strands are.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-selfCollisionStiffness.md Edit}
    */
    selfCollisionStiffness: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-singleStrandInterpolationInstanceCount.md Edit}
    
    * @deprecated
    
    * @private
    */
    singleStrandInterpolationInstanceCount: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-singleStrandInterpolationRadius.md Edit}
    
    * @deprecated
    
    * @private
    */
    singleStrandInterpolationRadius: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-steppedCutEnabled.md Edit}
    
    * @private
    */
    steppedCutEnabled: boolean
    
    /**
    * Higher value of stiffness will make hair move less.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-stiffness.md Edit}
    */
    stiffness: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandBunchAberration.md Edit}
    
    * @deprecated
    
    * @private
    */
    strandBunchAberration: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandCollisionEnable.md Edit}
    
    * @deprecated
    
    * @private
    */
    strandCollisionEnable: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandCollisionRadius.md Edit}
    
    * @deprecated
    
    * @private
    */
    strandCollisionRadius: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandCollisionStiff.md Edit}
    
    * @deprecated
    
    * @private
    */
    strandCollisionStiff: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandCut.md Edit}
    
    * @private
    */
    strandCut: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandNeighborCosThreshold.md Edit}
    
    * @private
    */
    strandNeighborCosThreshold: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandNeighborLengthThreshold.md Edit}
    
    * @private
    */
    strandNeighborLengthThreshold: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandNeighborRadius.md Edit}
    
    * @private
    */
    strandNeighborRadius: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandNeighbourSearchType.md Edit}
    
    * @deprecated
    
    * @private
    */
    strandNeighbourSearchType: StrandNeighbourSearchType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandScale.md Edit}
    
    * @deprecated
    
    * @private
    */
    strandScale: number
    
    /**
    * The taper size of each hair towards the tip.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandTaper.md Edit}
    */
    strandTaper: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandTipClamp.md Edit}
    
    * @deprecated
    
    * @private
    */
    strandTipClamp: number
    
    /**
    * The Width of each hair strand.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandWidth.md Edit}
    */
    strandWidth: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-strandsSceneObject.md Edit}
    
    * @deprecated
    
    * @private
    */
    strandsSceneObject: SceneObject
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-stretchLimitEnable.md Edit}
    
    * @deprecated
    
    * @private
    */
    stretchLimitEnable: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-stretchLimitEnabled.md Edit}
    
    * @private
    */
    stretchLimitEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-stretchStiff.md Edit}
    
    * @deprecated
    
    * @private
    */
    stretchStiff: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-stretchStiffness.md Edit}
    
    * @private
    */
    stretchStiffness: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-timeSubs.md Edit}
    
    * @deprecated
    
    * @private
    */
    timeSubs: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-twistStiff.md Edit}
    
    * @deprecated
    
    * @private
    */
    twistStiff: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-twistStiffness.md Edit}
    
    * @private
    */
    twistStiffness: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-windEnable.md Edit}
    
    * @deprecated
    
    * @private
    */
    windEnable: boolean
    
    /**
    * If checked will add wind force to hair simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-windEnabled.md Edit}
    */
    windEnabled: boolean
    
    /**
    * Amount of wind force added to hair simulation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HairVisual/properties/HairVisual-windForce.md Edit}
    */
    windForce: vec3
    
}

/**
* Provides additional data for the tracked hand. You can figure out whether the tracked hand is the left hand by accessing the *isLeft* property [true/false], as well as the probability of this data through the  *isLeftProbability*  property [0-1].


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandSpecificData/HandSpecificData-description.md Edit}
*/
interface HandSpecificData extends ObjectSpecificData {
}

/**
*     

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAsset/HandTracking3DAsset-description.md Edit}
*/
interface HandTracking3DAsset extends Object3DAsset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAsset/properties/HandTracking3DAsset-annotatorOptionsAsset.md Edit}
    
    * @private
    */
    annotatorOptionsAsset: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAsset/properties/HandTracking3DAsset-handDetectorModel.md Edit}
    
    * @private
    */
    handDetectorModel: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAsset/properties/HandTracking3DAsset-handModel.md Edit}
    
    * @private
    */
    handModel: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAsset/properties/HandTracking3DAsset-objectTrackingAsset.md Edit}
    
    * @private
    */
    objectTrackingAsset: ObjectTrackingAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAsset/properties/HandTracking3DAsset-options.md Edit}
    
    * @readonly
    
    * @private
    */
    options: HandTracking3DAssetOptions
    
}
declare namespace HandTracking3DAsset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAsset/methods/HandTracking3DAsset-create.md Edit}
    
    * @private
    */
    export function create(options: HandTracking3DAssetOptions): HandTracking3DAsset
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAssetOptions/HandTracking3DAssetOptions-description.md Edit}

* @private
*/
interface HandTracking3DAssetOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAssetOptions/properties/HandTracking3DAssetOptions-handType.md Edit}
    
    * @private
    */
    handType: HandTracking3DAssetOptions.HandType
    
}
declare namespace HandTracking3DAssetOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAssetOptions/methods/HandTracking3DAssetOptions-create.md Edit}
    
    * @private
    */
    export function create(): HandTracking3DAssetOptions
    

}

declare namespace HandTracking3DAssetOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAssetOptions.HandType/HandTracking3DAssetOptions.HandType-description.md Edit}
    
    * @private
    */
    enum HandType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAssetOptions.HandType/properties/HandTracking3DAssetOptions.HandType-Left.md Edit}
        
        * @private
        */
        Left,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HandTracking3DAssetOptions.HandType/properties/HandTracking3DAssetOptions.HandType-Right.md Edit}
        
        * @private
        */
        Right
    }

}

/**
* Triggers haptic feedback on the device. (iOS Devices only)


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HapticFeedbackSystem/HapticFeedbackSystem-description.md Edit}
*/
interface HapticFeedbackSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HapticFeedbackSystem/methods/HapticFeedbackSystem-hapticFeedback.md Edit}
    */
    hapticFeedback(type: HapticFeedbackType): void
    
}

/**
* The method in which haptic feedback is provided. Use with the `HapticFeedbackSystem`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HapticFeedbackType/HapticFeedbackType-description.md Edit}
*/
declare enum HapticFeedbackType {
    /**
    * Taptic engine based haptic feedback. Available only on some devices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HapticFeedbackType/properties/HapticFeedbackType-TapticEngine.md Edit}
    */
    TapticEngine,
    /**
    * Vibration based haptic feedback.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HapticFeedbackType/properties/HapticFeedbackType-Vibration.md Edit}
    */
    Vibration
}

/**
* Binds the SceneObject to a tracked face.
* See the [Head Attached 3D Objects Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/face/face-effects/head-attached-3d-objects) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/Head-description.md Edit}
*/
interface Head extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getBarycentricPos.md Edit}
    
    * @private
    */
    getBarycentricPos(indexWeight: vec2[]): vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getBarycentricPos2d.md Edit}
    
    * @private
    */
    getBarycentricPos2d(indexWeight: vec2[]): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getExpressionWeight.md Edit}
    
    * @private
    */
    getExpressionWeight(expressionIndex: number): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getExpressionWeightByName.md Edit}
    
    * @private
    */
    getExpressionWeightByName(expressionName: string): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getFaceMeshSource.md Edit}
    
    * @private
    */
    getFaceMeshSource(): FaceMeshSource
    
    /**
    * Returns the total number of faces currently being tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getFacesCount.md Edit}
    */
    getFacesCount(): number
    
    /**
    * Returns the screen position of the face landmark at the passed in index.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getLandmark.md Edit}
    */
    getLandmark(index: number): vec2
    
    /**
    * Returns the number of face landmarks being tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getLandmarkCount.md Edit}
    */
    getLandmarkCount(): number
    
    /**
    * Returns a list of screen positions of all tracked landmarks.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getLandmarks.md Edit}
    */
    getLandmarks(): vec2[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getPosition.md Edit}
    
    * @private
    */
    getPosition(index: number): vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getPosition2d.md Edit}
    
    * @private
    */
    getPosition2d(index: number): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getRotation.md Edit}
    
    * @private
    */
    getRotation(): quat
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-getSize.md Edit}
    
    * @private
    */
    getSize(): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-hasExpressionWithName.md Edit}
    
    * @private
    */
    hasExpressionWithName(expressionName: string): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-setAttachedBarycentricVertexIndexes.md Edit}
    
    * @private
    */
    setAttachedBarycentricVertexIndexes(index0: number, index1: number, index2: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-setAttachedBarycentricVertexWeights.md Edit}
    
    * @private
    */
    setAttachedBarycentricVertexWeights(weight0: number, weight1: number, weight2: number): void
    
    /**
    * Changes the attachment point type used to anchor this object to a face.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-setAttachmentPointType.md Edit}
    */
    setAttachmentPointType(attachmentPointType: AttachmentPointType): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-setNeedsExpressionWeights.md Edit}
    
    * @private
    */
    setNeedsExpressionWeights(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-setNeedsPreciseExpressionWeights.md Edit}
    
    * @private
    */
    setNeedsPreciseExpressionWeights(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/methods/Head-supportsAccurateDepth.md Edit}
    
    * @unreleased
    */
    supportsAccurateDepth(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/properties/Head-accurateDepth.md Edit}
    
    * @unreleased
    */
    accurateDepth: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/properties/Head-enableDebugRendering.md Edit}
    
    * @private
    */
    enableDebugRendering: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/properties/Head-enhanceWithNativeAR.md Edit}
    
    * @private
    */
    enhanceWithNativeAR: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/properties/Head-externalFaceTexture.md Edit}
    
    * @private
    */
    externalFaceTexture: Texture
    
    /**
    * The index of the face this head is attached to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/properties/Head-faceIndex.md Edit}
    */
    faceIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/properties/Head-minFaceScale.md Edit}
    
    * @private
    */
    minFaceScale: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Head/properties/Head-trackingScopeAsset.md Edit}
    
    * @private
    */
    trackingScopeAsset: TrackingScopeAsset
    
}

/**
* Constraints translation and a single axis of rotation.  See also: [ConstraintComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ConstraintComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HingeConstraint/HingeConstraint-description.md Edit}
*/
interface HingeConstraint extends Constraint {
}

/**
* Used to show and hide hints to the user.
* For more information and useful helper scripts, see the [Scripting Hints Guide](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/adding-interactivity/additional-examples/scripting-hints).

* <table cellspacing=0 cellpadding=0><thead><tr><th>Hint ID</th><th>Hint Message</th></tr></thead><tbody><tr><td>&#8220;lens_hint_blow_a_kiss&#8221;</td><td>&#8220;Blow A Kiss&#8221;</td></tr><tr><td>&#8220;lens_hint_come_closer&#8221;</td><td>&#8220;Come Closer&#8221;</td></tr><tr><td>&#8220;lens_hint_do_not_smile&#8221;</td><td>&#8220;Do Not Smile&#8221;</td></tr><tr><td>&#8220;lens_hint_do_not_try_with_a_friend&#8221;</td><td>&#8220;Do Not Try With A Friend&#8221;</td></tr><tr><td>&#8220;lens_hint_find_face&#8221;</td><td>&#8220;Find Face&#8221;</td></tr><tr><td>&#8220;lens_hint_keep_raising_your_eyebrows&#8221;</td><td>&#8220;Keep Raising Your Eyebrows&#8221;</td></tr><tr><td>&#8220;lens_hint_kiss&#8221;</td><td>&#8220;Kiss&#8221;</td></tr><tr><td>&#8220;lens_hint_kiss_again&#8221;</td><td>&#8220;Kiss Again&#8221;</td></tr><tr><td>&#8220;lens_hint_look_around&#8221;</td><td>&#8220;Look Around&#8221;</td></tr><tr><td>&#8220;lens_hint_look_down&#8221;</td><td>&#8220;Look Down&#8221;</td></tr><tr><td>&#8220;lens_hint_look_left&#8221;</td><td>&#8220;Look Left&#8221;</td></tr><tr><td>&#8220;lens_hint_look_right&#8221;</td><td>&#8220;Look Right&#8221;</td></tr><tr><td>&#8220;lens_hint_look_up&#8221;</td><td>&#8220;Look Up&#8221;</td></tr><tr><td>&#8220;lens_hint_make_some_noise&#8221;</td><td>&#8220;Make Some Noise!&#8221;</td></tr><tr><td>&#8220;lens_hint_nod_your_head&#8221;</td><td>&#8220;Nod Your Head&#8221;</td></tr><tr><td>&#8220;lens_hint_now_kiss&#8221;</td><td>&#8220;Now Kiss&#8221;</td></tr><tr><td>&#8220;lens_hint_now_open_your_mouth&#8221;</td><td>&#8220;Now Open Your Mouth&#8221;</td></tr><tr><td>&#8220;lens_hint_now_raise_your_eyebrows&#8221;</td><td>&#8220;Now Raise Your Eyebrows&#8221;</td></tr><tr><td>&#8220;lens_hint_now_smile&#8221;</td><td>&#8220;Now Smile&#8221;</td></tr><tr><td>&#8220;lens_hint_open_your_mouth&#8221;</td><td>&#8220;Open Your Mouth&#8221;</td></tr><tr><td>&#8220;lens_hint_open_your_mouth_again&#8221;</td><td>&#8220;Open Your Mouth Again&#8221;</td></tr><tr><td>&#8220;lens_hint_raise_eyebrows_or_open_mouth&#8221;</td><td>&#8220;Raise Your Eyebrows / Or / Open Your Mouth&#8221;</td></tr><tr><td>&#8220;lens_hint_raise_your_eyebrows&#8221;</td><td>&#8220;Raise Your Eyebrows&#8221;</td></tr><tr><td>&#8220;lens_hint_raise_your_eyebrows_again&#8221;</td><td>&#8220;Raise Your Eyebrows Again&#8221;</td></tr><tr><td>&#8220;lens_hint_smile&#8221;</td><td>&#8220;Smile&#8221;</td></tr><tr><td>&#8220;lens_hint_smile_again&#8221;</td><td>&#8220;Smile Again&#8221;</td></tr><tr><td>&#8220;lens_hint_swap_camera&#8221;</td><td>&#8220;Swap Camera&#8221;</td></tr><tr><td>&#8220;lens_hint_tap&#8221;</td><td>&#8220;Tap!&#8221;</td></tr><tr><td>&#8220;lens_hint_tap_a_surface&#8221;</td><td>&#8220;Tap A Surface&#8221;</td></tr><tr><td>&#8220;lens_hint_tap_ground&#8221;</td><td>&#8220;Tap The Ground&#8221;</td></tr><tr><td>&#8220;lens_hint_tap_ground_to_place&#8221;</td><td>&#8220;Tap Ground To Place&#8221;</td></tr><tr><td>&#8220;lens_hint_tap_surface_to_place&#8221;</td><td>&#8220;Tap Surface To Place&#8221;</td></tr><tr><td>&#8220;lens_hint_try_friend&#8221;</td><td>&#8220;Try It With A Friend&#8221;</td></tr><tr><td>&#8220;lens_hint_try_rear_camera&#8221;</td><td>&#8220;Try It With Your Rear Camera&#8221;</td></tr><tr><td>&#8220;lens_hint_turn_around&#8221;</td><td>&#8220;Turn Around&#8221;</td></tr><tr><td>&#8220;lens_hint_walk_through_the_door&#8221;</td><td>&#8220;Walk Through The Door&#8221;</td></tr></tbody></table>

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HintsComponent/HintsComponent-description.md Edit}
*/
interface HintsComponent extends Component {
    /**
    * Hides the hint with id `hintID`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HintsComponent/methods/HintsComponent-hideHint.md Edit}
    */
    hideHint(hintID: string): boolean
    
    /**
    * Shows the hint with id `hintID` for a duration of `duration` seconds. Use a duration of -1 to keep the hint onscreen forever.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HintsComponent/methods/HintsComponent-showHint.md Edit}
    */
    showHint(hintID: string, duration: number): boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/HistogramData-description.md Edit}

* @private
*/
interface HistogramData extends AbstractData {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/methods/HistogramData-getCdfArray.md Edit}
    
    * @private
    */
    getCdfArray(): number[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/methods/HistogramData-getCdfArraySize.md Edit}
    
    * @private
    */
    getCdfArraySize(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/methods/HistogramData-getHistogramArray.md Edit}
    
    * @private
    */
    getHistogramArray(): number[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/methods/HistogramData-getHistogramArraySize.md Edit}
    
    * @private
    */
    getHistogramArraySize(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/methods/HistogramData-nthPercintile.md Edit}
    
    * @private
    */
    nthPercintile(percentage: number): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/properties/HistogramData-average.md Edit}
    
    * @private
    */
    average: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/properties/HistogramData-brightness.md Edit}
    
    * @private
    */
    brightness: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/properties/HistogramData-cdfMin.md Edit}
    
    * @private
    */
    cdfMin: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HistogramData/properties/HistogramData-rootMeanSquare.md Edit}
    
    * @private
    */
    rootMeanSquare: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HitTestSession/HitTestSession-description.md Edit}

* @wearableOnly
*/
interface HitTestSession extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HitTestSession/methods/HitTestSession-hitTest.md Edit}
    */
    hitTest(rayStart: vec3, rayEnd: vec3, hitCallback: (hit: WorldQueryHitTestResult) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HitTestSession/methods/HitTestSession-reset.md Edit}
    */
    reset(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HitTestSession/methods/HitTestSession-start.md Edit}
    */
    start(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HitTestSession/methods/HitTestSession-stop.md Edit}
    */
    stop(): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HitTestSessionOptions/HitTestSessionOptions-description.md Edit}

* @wearableOnly
*/
interface HitTestSessionOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HitTestSessionOptions/properties/HitTestSessionOptions-filter.md Edit}
    */
    filter: boolean
    
}
declare namespace HitTestSessionOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HitTestSessionOptions/methods/HitTestSessionOptions-create.md Edit}
    
    * @wearableOnly
    */
    export function create(): HitTestSessionOptions
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoleMode/HoleMode-description.md Edit}

* @private
*/
declare enum HoleMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoleMode/properties/HoleMode-Full.md Edit}
    
    * @private
    */
    Full,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoleMode/properties/HoleMode-HolesOnly.md Edit}
    
    * @private
    */
    HolesOnly,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoleMode/properties/HoleMode-NoHoles.md Edit}
    
    * @private
    */
    NoHoles
}

/**
* Used by the `horizontalAlignment` property in [MeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#MeshVisual).
* When a [ScreenTransform](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ScreenTransform) is attached to the same SceneObject, this determines how the mesh will be positioned horizontally.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalAlignment/HorizontalAlignment-description.md Edit}
*/
declare enum HorizontalAlignment {
    /**
    * The mesh will be aligned to the left side.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalAlignment/properties/HorizontalAlignment-Left.md Edit}
    */
    Left,
    /**
    * The mesh will be centered.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalAlignment/properties/HorizontalAlignment-Center.md Edit}
    */
    Center,
    /**
    * The mesh will be aligned to the right side.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalAlignment/properties/HorizontalAlignment-Right.md Edit}
    */
    Right
}

/**
* Options for wrapping text horizontally.
* Used by [Text component's](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Text) `horizontalOverflow` property.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalOverflow/HorizontalOverflow-description.md Edit}
*/
declare enum HorizontalOverflow {
    /**
    * Text will continue drawing past horizontal boundaries.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalOverflow/properties/HorizontalOverflow-Overflow.md Edit}
    */
    Overflow,
    /**
    * Text is clipped to the width of horizontal boundaries.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalOverflow/properties/HorizontalOverflow-Truncate.md Edit}
    */
    Truncate,
    /**
    * Text wraps when reaching horizontal boundaries and continues on the next line.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalOverflow/properties/HorizontalOverflow-Wrap.md Edit}
    */
    Wrap,
    /**
    * Text will shrink to fit within the horizontal boundaries.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HorizontalOverflow/properties/HorizontalOverflow-Shrink.md Edit}
    */
    Shrink
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverEndEvent/HoverEndEvent-description.md Edit}

* @private
*/
interface HoverEndEvent extends SceneObjectEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverEndEvent/methods/HoverEndEvent-getHoverPosition.md Edit}
    
    * @unreleased
    
    * @private
    */
    getHoverPosition(): vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverEndEventArgs/HoverEndEventArgs-description.md Edit}

* @private
*/
interface HoverEndEventArgs extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverEndEventArgs/properties/HoverEndEventArgs-position.md Edit}
    
    * @readonly
    
    * @private
    */
    position: vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverEvent/HoverEvent-description.md Edit}
*/
interface HoverEvent extends SceneObjectEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverEvent/methods/HoverEvent-getHoverPosition.md Edit}
    */
    getHoverPosition(): vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverEventArgs/HoverEventArgs-description.md Edit}

* @private
*/
interface HoverEventArgs extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverEventArgs/properties/HoverEventArgs-position.md Edit}
    
    * @readonly
    
    * @private
    */
    position: vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverStartEvent/HoverStartEvent-description.md Edit}

* @private
*/
interface HoverStartEvent extends SceneObjectEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverStartEvent/methods/HoverStartEvent-getHoverPosition.md Edit}
    
    * @unreleased
    
    * @private
    */
    getHoverPosition(): vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverStartEventArgs/HoverStartEventArgs-description.md Edit}

* @private
*/
interface HoverStartEventArgs extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HoverStartEventArgs/properties/HoverStartEventArgs-position.md Edit}
    
    * @readonly
    
    * @private
    */
    position: vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HRTFMode/HRTFMode-description.md Edit}

* @private
*/
declare enum HRTFMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HRTFMode/properties/HRTFMode-Regular.md Edit}
    
    * @private
    */
    Regular,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/HRTFMode/properties/HRTFMode-DeviceCalibrated.md Edit}
    
    * @private
    */
    DeviceCalibrated
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IAssetSystem/IAssetSystem-description.md Edit}

* @private
*/
interface IAssetSystem extends ScriptObject {
}

/**
* The base class for parameter objects passed into event callbacks.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IEventParameters/IEventParameters-description.md Edit}
*/
interface IEventParameters extends ScriptObject {
}

/**
* A 2D visual used for drawing texture assets.
* Commonly used with [ScreenTransform](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ScreenTransform) for drawing images on the screen.

* See the [Image guide](https://lensstudio.snapchat.com/lens-studio/references/guides/adding-content/2d/image) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Image/Image-description.md Edit}
*/
interface Image extends MaterialMeshVisual {
    /**
    * If enabled, the drawn image will be flipped horizontally.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Image/properties/Image-flipX.md Edit}
    */
    flipX: boolean
    
    /**
    * If enabled, the drawn image will be flipped vertically.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Image/properties/Image-flipY.md Edit}
    */
    flipY: boolean
    
    /**
    * The location of the Image's pivot point relative to its boundaries.
    * Where (-1, -1) is the bottom left corner, (0, 0) is the center, and (1, 1) is the top right corner of the Image.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Image/properties/Image-pivot.md Edit}
    */
    pivot: vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Image/properties/Image-size.md Edit}
    
    * @private
    */
    size: vec2
    
}

/**
* Controls an image picker texture and UI.
* Can be accessed through [Texture.control](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Texture#control-textureprovider) on an Image Picker texture.
* For more information, see the [Image Picker Texture](https://lensstudio.snapchat.com/lens-studio/references/guides/adding-content/2d/media-picker-texture) guide.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImagePickerTextureProvider/ImagePickerTextureProvider-description.md Edit}
*/
interface ImagePickerTextureProvider extends MediaPickerTextureProvider {
    /**
    * Hides the image picker UI.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImagePickerTextureProvider/methods/ImagePickerTextureProvider-hideImagePicker.md Edit}
    */
    hideImagePicker(): void
    
    /**
    * Binds a callback function for when the user selects or changes an image from the picker.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImagePickerTextureProvider/methods/ImagePickerTextureProvider-setImageChangedCallback.md Edit}
    */
    setImageChangedCallback(callback: () => void): void
    
    /**
    * Shows the image picker UI.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImagePickerTextureProvider/methods/ImagePickerTextureProvider-showImagePicker.md Edit}
    */
    showImagePicker(): void
    
    /**
    * If enabled, the image picker UI will be shown automatically when the Lens starts.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImagePickerTextureProvider/properties/ImagePickerTextureProvider-autoShowImagePicker.md Edit}
    */
    autoShowImagePicker: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadCompressionMethod/ImageUploadCompressionMethod-description.md Edit}

* @private
*/
declare enum ImageUploadCompressionMethod {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadCompressionMethod/properties/ImageUploadCompressionMethod-PNG.md Edit}
    
    * @private
    */
    PNG,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadCompressionMethod/properties/ImageUploadCompressionMethod-JPG.md Edit}
    
    * @private
    */
    JPG,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadCompressionMethod/properties/ImageUploadCompressionMethod-WEBP.md Edit}
    
    * @private
    */
    WEBP
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadOptions/ImageUploadOptions-description.md Edit}

* @private
*/
interface ImageUploadOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadOptions/properties/ImageUploadOptions-compressionMethod.md Edit}
    
    * @private
    */
    compressionMethod: ImageUploadCompressionMethod
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadOptions/properties/ImageUploadOptions-compressionQuality.md Edit}
    
    * @private
    */
    compressionQuality: CompressionQuality
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadOptions/properties/ImageUploadOptions-includeAlpha.md Edit}
    
    * @private
    */
    includeAlpha: boolean
    
}
declare namespace ImageUploadOptions {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ImageUploadOptions/methods/ImageUploadOptions-create.md Edit}
    
    * @private
    */
    export function create(): ImageUploadOptions
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Inpainting/Inpainting-description.md Edit}

* @private
*/
interface Inpainting extends PostEffectVisual {
}

/**
* Builds InputPlaceHolders for MLComponent.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputBuilder/InputBuilder-description.md Edit}
*/
interface InputBuilder extends ScriptObject {
    /**
    * Builds and returns a new InputPlaceholder.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputBuilder/methods/InputBuilder-build.md Edit}
    */
    build(): InputPlaceholder
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputBuilder/methods/InputBuilder-setAllowImageTracker.md Edit}
    
    * @unreleased
    
    * @private
    */
    setAllowImageTracker(value: boolean): InputBuilder
    
    /**
    * Sets the input texture of the InputPlaceholder to be built.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputBuilder/methods/InputBuilder-setInputTexture.md Edit}
    */
    setInputTexture(texture: Texture): InputBuilder
    
    /**
    * Sets the name of the InputPlaceholder to be built.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputBuilder/methods/InputBuilder-setName.md Edit}
    */
    setName(name: string): InputBuilder
    
    /**
    * Sets sampler for input placeholder builder.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputBuilder/methods/InputBuilder-setSampler.md Edit}
    */
    setSampler(sampler: Sampler): InputBuilder
    
    /**
    * Sets the shape of the InputPlaceholder to be built.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputBuilder/methods/InputBuilder-setShape.md Edit}
    */
    setShape(shape: vec3): InputBuilder
    
    /**
    * Sets the Transformer of the InputPlaceholder to be built.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputBuilder/methods/InputBuilder-setTransformer.md Edit}
    */
    setTransformer(transformer: Transformer): InputBuilder
    
}

/**
* Controls input data for a neural network used by an MLComponent.
* For more information, see the [MLComponent Scripting](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/machine-learning/ml-component/scripting-ml-component) guide.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputPlaceholder/InputPlaceholder-description.md Edit}
*/
interface InputPlaceholder extends BasePlaceholder {
    /**
    * Data used as input.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputPlaceholder/properties/InputPlaceholder-data.md Edit}
    
    * @readonly
    */
    data: Float32Array
    
    /**
    * Texture used as input.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InputPlaceholder/properties/InputPlaceholder-texture.md Edit}
    */
    texture: Texture
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntAnimationPropertyTrack/IntAnimationPropertyTrack-description.md Edit}

* @private
*/
interface IntAnimationPropertyTrack extends AnimationPropertyTrack {
}

/**
* The base class for animation tracks using integer values.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntAnimationTrack/IntAnimationTrack-description.md Edit}

* @deprecated
*/
interface IntAnimationTrack extends AnimationTrack {
}

/**
* Allows the `MeshVisual` provided to this component to handle touches on the screen (blocking Snapchat from receiving the touches), and optionally let certain touch types to pass through (let Snapchat handle the touch).

* Possible `TouchType` values:

* "TouchTypeNone"
* "TouchTypeTouch"
* "TouchTypeTap"
* "TouchTypeDoubleTap"
* "TouchTypeScale"
* "TouchTypePan"
* "TouchTypeSwipe"

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/InteractionComponent-description.md Edit}
*/
interface InteractionComponent extends Component {
    /**
    * Adds a MeshVisual as a target for interaction detection.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/methods/InteractionComponent-addMeshVisual.md Edit}
    */
    addMeshVisual(meshVisual: BaseMeshVisual): void
    
    /**
    * Adds a touch type that this component will ignore.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/methods/InteractionComponent-addTouchBlockingException.md Edit}
    */
    addTouchBlockingException(exception: string): void
    
    /**
    * Returns the minimum bounding box size used for detecting touches. Value range is from [0-1], relative to screen width.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/methods/InteractionComponent-getMinimumTouchSize.md Edit}
    */
    getMinimumTouchSize(): number
    
    /**
    * Removes a MeshVisual as a target for interaction detection.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/methods/InteractionComponent-removeMeshVisual.md Edit}
    */
    removeMeshVisual(meshVisual: BaseMeshVisual): void
    
    /**
    * Sets the camera that will be used for interaction detection.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/methods/InteractionComponent-setCamera.md Edit}
    */
    setCamera(camera: Camera): void
    
    /**
    * Sets the minimum bounding box size used for detecting touches. Value range is from [0-1], relative to screen width.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/methods/InteractionComponent-setMinimumTouchSize.md Edit}
    */
    setMinimumTouchSize(value: number): void
    
    /**
    * When enabled, interaction events will be invoked only on the"closest" object, where order is defined by distance from camera and camera render order.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-isFilteredByDepth.md Edit}
    */
    isFilteredByDepth: boolean
    
    /**
    * Returns whether the user is currently gazing at the object on wearable devices, and when the user is touching on mobile devices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-isFocused.md Edit}
    
    * @readonly
    */
    isFocused: boolean
    
    /**
    * Returns whether the user is currently selecting and gazing at an object on wearable devices, or touching it on mobile devices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-isSelected.md Edit}
    
    * @readonly
    */
    isSelected: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onDoubleTap.md Edit}
    
    * @unreleased
    
    * @readonly
    */
    onDoubleTap: event1<DoubleTapEventArgs, void>
    
    /**
    * On mobile devices, this is triggered when the user releases their touch. On wearable devices, this is triggered when the user looks away from the current object. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onFocusEnd.md Edit}
    
    * @readonly
    */
    onFocusEnd: event1<FocusEndEventArgs, void>
    
    /**
    * On mobile devices, this is triggered when the user starts touching. On wearable devices, this is triggered when the user gazes on the current object. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onFocusStart.md Edit}
    
    * @readonly
    */
    onFocusStart: event1<FocusStartEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onHover.md Edit}
    
    * @readonly
    
    * @private
    */
    onHover: event1<HoverEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onHoverEnd.md Edit}
    
    * @readonly
    
    * @private
    */
    onHoverEnd: event1<HoverEndEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onHoverStart.md Edit}
    
    * @readonly
    
    * @private
    */
    onHoverStart: event1<HoverStartEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onLongPressEnd.md Edit}
    
    * @readonly
    
    * @private
    */
    onLongPressEnd: event1<LongPressEndEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onLongPressStart.md Edit}
    
    * @readonly
    
    * @private
    */
    onLongPressStart: event1<LongPressStartEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onPanEnd.md Edit}
    
    * @readonly
    
    * @private
    */
    onPanEnd: event1<PanEndEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onPanMove.md Edit}
    
    * @readonly
    
    * @private
    */
    onPanMove: event1<PanMoveEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onPanStart.md Edit}
    
    * @readonly
    
    * @private
    */
    onPanStart: event1<PanStartEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onPinchEnd.md Edit}
    
    * @readonly
    
    * @private
    */
    onPinchEnd: event1<PinchEndEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onPinchMove.md Edit}
    
    * @readonly
    
    * @private
    */
    onPinchMove: event1<PinchMoveEventArgs, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onPinchStart.md Edit}
    
    * @readonly
    
    * @private
    */
    onPinchStart: event1<PinchStartEventArgs, void>
    
    /**
    * On mobile devices, this is triggered when the user releases their touch. On wearable devices, this is triggered when the user stops touching the current object. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onSelectEnd.md Edit}
    
    * @readonly
    */
    onSelectEnd: event1<SelectEndEventArgs, void>
    
    /**
    * On mobile devices, this is triggered when the user starts touching the current object. On wearable devices, this is triggered when the user touches the touchpad while focusing on an object. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onSelectStart.md Edit}
    
    * @readonly
    */
    onSelectStart: event1<SelectStartEventArgs, void>
    
    /**
    * Triggered when the user taps on the screen.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onTap.md Edit}
    
    * @readonly
    */
    onTap: event1<TapEventArgs, void>
    
    /**
    * Triggered when a touch event ends.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onTouchEnd.md Edit}
    
    * @readonly
    */
    onTouchEnd: event1<TouchEndEventArgs, void>
    
    /**
    * Triggered when a touch position on the screen is moved.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onTouchMove.md Edit}
    
    * @readonly
    */
    onTouchMove: event1<TouchMoveEventArgs, void>
    
    /**
    * Triggered when a touch event starts--either on the screen or on a touchpad. On wearables with touchpad, the coordinate returned are based on the touchpad and not the screen.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onTouchStart.md Edit}
    
    * @readonly
    */
    onTouchStart: event1<TouchStartEventArgs, void>
    
    /**
    * Gets called when the user triggers the primary input on their device. For example touch on touch screens.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InteractionComponent/properties/InteractionComponent-onTriggerPrimary.md Edit}
    
    * @readonly
    */
    onTriggerPrimary: event1<TriggerPrimaryEventArgs, void>
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InternalMeshBuilderConfig/InternalMeshBuilderConfig-description.md Edit}

* @private
*/
interface InternalMeshBuilderConfig extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InternalMeshBuilderConfig/properties/InternalMeshBuilderConfig-colorEnabled.md Edit}
    
    * @private
    */
    colorEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InternalMeshBuilderConfig/properties/InternalMeshBuilderConfig-emptySpaceUpdatesEnabled.md Edit}
    
    * @private
    */
    emptySpaceUpdatesEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InternalMeshBuilderConfig/properties/InternalMeshBuilderConfig-maxDepth.md Edit}
    
    * @private
    */
    maxDepth: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InternalMeshBuilderConfig/properties/InternalMeshBuilderConfig-minDepth.md Edit}
    
    * @private
    */
    minDepth: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InternalMeshBuilderConfig/properties/InternalMeshBuilderConfig-minDepthConfidence.md Edit}
    
    * @private
    */
    minDepthConfidence: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InternalMeshBuilderConfig/properties/InternalMeshBuilderConfig-voxelSize.md Edit}
    
    * @private
    */
    voxelSize: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/InternetModule/InternetModule-description.md Edit}

* @private
*/
interface InternetModule extends Asset {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepAnimationPropertyTrack/IntStepAnimationPropertyTrack-description.md Edit}

* @private
*/
interface IntStepAnimationPropertyTrack extends AnimationPropertyTrack {
}

/**
* Represents an animation track using stepped integer value keyframes.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepAnimationTrackKeyFramed/IntStepAnimationTrackKeyFramed-description.md Edit}

* @deprecated
*/
interface IntStepAnimationTrackKeyFramed extends IntAnimationTrack {
    /**
    * Adds a key with value `value` at time `time`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepAnimationTrackKeyFramed/methods/IntStepAnimationTrackKeyFramed-addKey.md Edit}
    */
    addKey(time: number, value: number): void
    
    /**
    * Removes all keys.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepAnimationTrackKeyFramed/methods/IntStepAnimationTrackKeyFramed-removeAllKeys.md Edit}
    */
    removeAllKeys(): void
    
    /**
    * Removes key at index `index`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepAnimationTrackKeyFramed/methods/IntStepAnimationTrackKeyFramed-removeKeyAt.md Edit}
    */
    removeKeyAt(index: number): void
    
}

/**
* Represents an animation track using stepped integer value keyframes.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepNoLerpAnimationTrackKeyFramed/IntStepNoLerpAnimationTrackKeyFramed-description.md Edit}

* @deprecated
*/
interface IntStepNoLerpAnimationTrackKeyFramed extends IntAnimationTrack {
    /**
    * Adds a key with value `value` at time `time`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepNoLerpAnimationTrackKeyFramed/methods/IntStepNoLerpAnimationTrackKeyFramed-addKey.md Edit}
    */
    addKey(time: number, value: number): void
    
    /**
    * Removes all keys.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepNoLerpAnimationTrackKeyFramed/methods/IntStepNoLerpAnimationTrackKeyFramed-removeAllKeys.md Edit}
    */
    removeAllKeys(): void
    
    /**
    * Removes key at index `index`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/IntStepNoLerpAnimationTrackKeyFramed/methods/IntStepNoLerpAnimationTrackKeyFramed-removeKeyAt.md Edit}
    */
    removeKeyAt(index: number): void
    
}

/**
* Triggered when the tracked face ends a kiss.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/KissFinishedEvent/KissFinishedEvent-description.md Edit}
*/
interface KissFinishedEvent extends FaceTrackingEvent {
}

/**
* Triggered when the tracked face starts a kiss.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/KissStartedEvent/KissStartedEvent-description.md Edit}
*/
interface KissStartedEvent extends FaceTrackingEvent {
}

/**
* Displays text in the scene.
* This is now deprecated in favor of [Text](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Text).
* See the [Text guide](https://lensstudio.snapchat.com/lens-studio/references/guides/adding-content/text/2d-text) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/Label-description.md Edit}

* @deprecated
*/
interface Label extends SpriteVisual {
    /**
    * Returns the potential width and height of the Label if it were to display the input text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/methods/Label-measureText.md Edit}
    */
    measureText(text: string): vec2
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/methods/Label-setTextInfo.md Edit}
    
    * @deprecated
    
    * @private
    */
    setTextInfo(text: string, font: string, size: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-dropshadowColor.md Edit}
    
    * @deprecated
    
    * @private
    */
    dropshadowColor: vec2
    
    /**
    * The horizontal and vertical offset used for dropshadow.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-dropshadowOffset.md Edit}
    
    * @deprecated
    
    * @private
    */
    dropshadowOffset: vec2
    
    /**
    * The font used to display text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-fontAsset.md Edit}
    */
    fontAsset: Font
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-fontName.md Edit}
    
    * @deprecated
    
    * @private
    */
    fontName: string
    
    /**
    * The color used for the outline effect.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-outlineColor.md Edit}
    */
    outlineColor: vec4
    
    /**
    * The strength of the outline effect.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-outlineSize.md Edit}
    */
    outlineSize: number
    
    /**
    * The color used for dropshadow.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-shadowColor.md Edit}
    */
    shadowColor: vec4
    
    /**
    * The horizontal and vertical offset used for dropshadow.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-shadowOffset.md Edit}
    */
    shadowOffset: vec2
    
    /**
    * The font size being used.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-size.md Edit}
    */
    size: number
    
    /**
    * The text displayed by the Label.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-text.md Edit}
    */
    text: string
    
    /**
    * The color used for drawing text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-textColor.md Edit}
    */
    textColor: vec4
    
    /**
    * If enabled, adds a dropshadow to the text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-useDropshadow.md Edit}
    */
    useDropshadow: boolean
    
    /**
    * If enabled, adds an outline around the text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Label/properties/Label-useOutline.md Edit}
    */
    useOutline: boolean
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LandmarkersSystem/LandmarkersSystem-description.md Edit}

* @private
*/
interface LandmarkersSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LandmarkersSystem/methods/LandmarkersSystem-downloadLocalizationModel.md Edit}
    
    * @private
    */
    downloadLocalizationModel(location: LocationAsset, successCallback: (localizationModel: LocalizationModel) => void, failureCallback: (error: string) => void): void
    
}

/**
* This event is triggered at the end of every frame, after normal [UpdateEvents](https://lensstudio.snapchat.com/api/lens-studio/Classes/Events#UpdateEvent) trigger
* but before rendering occurs.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LateUpdateEvent/LateUpdateEvent-description.md Edit}
*/
interface LateUpdateEvent extends SceneEvent {
    /**
    * Returns the time elapsed (in seconds) between the current frame and previous frame.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LateUpdateEvent/methods/LateUpdateEvent-getDeltaTime.md Edit}
    */
    getDeltaTime(): number
    
}

/**
* Used to describe a set of layers that an object belongs to or interacts with.

* See [SceneObject's](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#SceneObject) `layer` property, [Camera's](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#Camera) `renderLayer` property, and [LightSource's](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#LightSource) `renderLayer` property.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/LayerSet-description.md Edit}
*/
interface LayerSet {
    /**
    * Returns true if all layers in the `other` LayerSet are also present in this one.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/methods/LayerSet-contains.md Edit}
    */
    contains(other: LayerSet): boolean
    
    /**
    * Returns a new LayerSet that contains layers present in this LayerSet but not present in `other`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/methods/LayerSet-except.md Edit}
    */
    except(other: LayerSet): LayerSet
    
    /**
    * Returns a new LayerSet that only contains layers present in both this LayerSet and `other`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/methods/LayerSet-intersect.md Edit}
    */
    intersect(other: LayerSet): LayerSet
    
    /**
    * Returns true if this LayerSet contains no layers.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/methods/LayerSet-isEmpty.md Edit}
    */
    isEmpty(): boolean
    
    /**
    * Returns a string representation of this LayerSet.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/methods/LayerSet-toString.md Edit}
    */
    toString(): string
    
    /**
    * Returns a new LayerSet combining this LayerSet and `other`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/methods/LayerSet-union.md Edit}
    */
    union(other: LayerSet): LayerSet
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/properties/LayerSet-numbers.md Edit}
    */
    numbers: number[]
    
}
declare namespace LayerSet {
    /**
    * Returns a new LayerSet based on the passed in number.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/methods/LayerSet-fromNumber.md Edit}
    */
    export function fromNumber(layerId: number): LayerSet
    
    /**
    * Creates a new LayerSet that is guaranteed to be empty and not intersect existing layers. This bypasses the normal 32 layer limit in Studio, allowing for around 65,000 unique layers.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LayerSet/methods/LayerSet-makeUnique.md Edit}
    */
    export function makeUnique(): LayerSet
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard/Leaderboard-description.md Edit}
*/
interface Leaderboard extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard/methods/Leaderboard-getLeaderboardInfo.md Edit}
    */
    getLeaderboardInfo(options: Leaderboard.RetrievalOptions, successCallback: (othersInfo: Leaderboard.UserRecord[], currentUserInfo?: Leaderboard.UserRecord) => void, failureCallback: (status: number) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard/methods/Leaderboard-submitScore.md Edit}
    */
    submitScore(score: number, successCallback: (currentUserInfo: Leaderboard.UserRecord) => void, failureCallback: (status: number) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard/properties/Leaderboard-leaderboardId.md Edit}
    
    * @readonly
    
    * @private
    */
    leaderboardId: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard/properties/Leaderboard-name.md Edit}
    
    * @readonly
    */
    name: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard/properties/Leaderboard-orderingType.md Edit}
    
    * @readonly
    */
    orderingType: Leaderboard.OrderingType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard/properties/Leaderboard-ttlSeconds.md Edit}
    
    * @readonly
    */
    ttlSeconds: number
    
}

declare namespace Leaderboard {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.CreateOptions/Leaderboard.CreateOptions-description.md Edit}
    */
    interface CreateOptions extends ScriptObject {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.CreateOptions/properties/Leaderboard.CreateOptions-name.md Edit}
        */
        name: string
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.CreateOptions/properties/Leaderboard.CreateOptions-orderingType.md Edit}
        */
        orderingType: Leaderboard.OrderingType
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.CreateOptions/properties/Leaderboard.CreateOptions-ttlSeconds.md Edit}
        */
        ttlSeconds: number
        
    }

}
declare namespace Leaderboard {
    namespace CreateOptions {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.CreateOptions/methods/Leaderboard.CreateOptions-create.md Edit}
        */
        export function create(): Leaderboard.CreateOptions
        
    
    }

}

declare namespace Leaderboard {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.OrderingType/Leaderboard.OrderingType-description.md Edit}
    */
    enum OrderingType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.OrderingType/properties/Leaderboard.OrderingType-Descending.md Edit}
        */
        Descending,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.OrderingType/properties/Leaderboard.OrderingType-Ascending.md Edit}
        */
        Ascending
    }

}

declare namespace Leaderboard {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.RetrievalOptions/Leaderboard.RetrievalOptions-description.md Edit}
    */
    interface RetrievalOptions extends ScriptObject {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.RetrievalOptions/properties/Leaderboard.RetrievalOptions-usersLimit.md Edit}
        */
        usersLimit: number
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.RetrievalOptions/properties/Leaderboard.RetrievalOptions-usersType.md Edit}
        */
        usersType: Leaderboard.UsersType
        
    }

}
declare namespace Leaderboard {
    namespace RetrievalOptions {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.RetrievalOptions/methods/Leaderboard.RetrievalOptions-create.md Edit}
        */
        export function create(): Leaderboard.RetrievalOptions
        
    
    }

}

declare namespace Leaderboard {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.UserRecord/Leaderboard.UserRecord-description.md Edit}
    */
    interface UserRecord extends ScriptObject {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.UserRecord/properties/Leaderboard.UserRecord-globalExactRank.md Edit}
        
        * @readonly
        */
        globalExactRank?: number
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.UserRecord/properties/Leaderboard.UserRecord-globalRankPercentile.md Edit}
        
        * @readonly
        */
        globalRankPercentile: number
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.UserRecord/properties/Leaderboard.UserRecord-score.md Edit}
        
        * @readonly
        */
        score: number
        
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.UserRecord/properties/Leaderboard.UserRecord-snapchatUser.md Edit}
        
        * @readonly
        */
        snapchatUser: SnapchatUser
        
    }

}

declare namespace Leaderboard {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.UsersType/Leaderboard.UsersType-description.md Edit}
    */
    enum UsersType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.UsersType/properties/Leaderboard.UsersType-Friends.md Edit}
        */
        Friends,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Leaderboard.UsersType/properties/Leaderboard.UsersType-Global.md Edit}
        */
        Global
    }

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LeaderboardModule/LeaderboardModule-description.md Edit}
*/
interface LeaderboardModule extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LeaderboardModule/methods/LeaderboardModule-getLeaderboard.md Edit}
    
    * @exposesUserData
    */
    getLeaderboard(options: Leaderboard.CreateOptions, successCallback: (leaderboard: Leaderboard) => void, failureCallback: (message: string) => void): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LegacyFaceMeshProvider/LegacyFaceMeshProvider-description.md Edit}

* @deprecated

* @private
*/
interface LegacyFaceMeshProvider extends RenderObjectProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LegacyFaceMeshProvider/properties/LegacyFaceMeshProvider-externalMesh.md Edit}
    
    * @private
    */
    externalMesh: RenderMesh
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LegacyFaceMeshProvider/properties/LegacyFaceMeshProvider-faceIndex.md Edit}
    
    * @private
    */
    faceIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LegacyFaceMeshProvider/properties/LegacyFaceMeshProvider-vertexMatchingMode.md Edit}
    
    * @private
    */
    vertexMatchingMode: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LegacyFaceMeshProvider/properties/LegacyFaceMeshProvider-vertexMatchingRadius.md Edit}
    
    * @private
    */
    vertexMatchingRadius: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataKey/LensDataKey-description.md Edit}

* @private
*/
interface LensDataKey {
}
declare namespace LensDataKey {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataKey/properties/LensDataKey-SnapReceivedWithLens.md Edit}
    
    * @private
    */
    let SnapReceivedWithLens: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataKey/properties/LensDataKey-SnapSavedWithLens.md Edit}
    
    * @private
    */
    let SnapSavedWithLens: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataKey/properties/LensDataKey-SnapSendWithLens.md Edit}
    
    * @private
    */
    let SnapSendWithLens: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataKey/properties/LensDataKey-StoryPostWithLens.md Edit}
    
    * @private
    */
    let StoryPostWithLens: string
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataSystem/LensDataSystem-description.md Edit}

* @private
*/
interface LensDataSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataSystem/methods/LensDataSystem-getLensData.md Edit}
    
    * @private
    */
    getLensData(key: string): AnyData
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataSystem/methods/LensDataSystem-isLensDataReady.md Edit}
    
    * @private
    */
    isLensDataReady(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensDataSystem/methods/LensDataSystem-requestLensData.md Edit}
    
    * @private
    */
    requestLensData(callback: () => void): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/LensEntryPoint-description.md Edit}

* @private
*/
declare enum LensEntryPoint {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-LiveCamera.md Edit}
    
    * @private
    */
    LiveCamera,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-StoryReply.md Edit}
    
    * @private
    */
    StoryReply,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-ChatReply.md Edit}
    
    * @private
    */
    ChatReply,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-Restart.md Edit}
    
    * @private
    */
    Restart,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-PreviewCancel.md Edit}
    
    * @private
    */
    PreviewCancel,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-Map.md Edit}
    
    * @private
    */
    Map,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-BitmojiStickers.md Edit}
    
    * @private
    */
    BitmojiStickers,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-PostCapturePreview.md Edit}
    
    * @private
    */
    PostCapturePreview,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LensEntryPoint/properties/LensEntryPoint-PostCaptureTranscoding.md Edit}
    
    * @private
    */
    PostCaptureTranscoding
}

/**
* Collider asset generated from a mesh to be used with the [Hair Visual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#HairVisual) as part of the hair simulation.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LevelsetColliderAsset/LevelsetColliderAsset-description.md Edit}
*/
interface LevelsetColliderAsset extends BinAsset {
}

/**
* A levelset collision shape. A levelset is an asset that is generated to approximate a mesh.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LevelsetShape/LevelsetShape-description.md Edit}
*/
interface LevelsetShape extends Shape {
    /**
    * Reference to the levelset asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LevelsetShape/properties/LevelsetShape-asset.md Edit}
    */
    asset: LevelsetColliderAsset
    
}

/**
* Acts as a source of light in the scene.
* See the [Light and Shadows](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/graphics/light-and-shadow) guide for more information about lighting.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/LightSource-description.md Edit}
*/
interface LightSource extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/methods/LightSource-addRenderLayer.md Edit}
    
    * @deprecated
    
    * @private
    */
    addRenderLayer(id: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/methods/LightSource-checkRenderLayer.md Edit}
    
    * @deprecated
    
    * @private
    */
    checkRenderLayer(id: number): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/methods/LightSource-getAllRenderLayers.md Edit}
    
    * @deprecated
    
    * @private
    */
    getAllRenderLayers(): number[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/methods/LightSource-removeRenderLayer.md Edit}
    
    * @deprecated
    
    * @private
    */
    removeRenderLayer(id: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/methods/LightSource-resetDynamicEnvMap.md Edit}
    
    * @private
    */
    resetDynamicEnvMap(): void
    
    /**
    * If enabled, the LightSource will be automatically positioned based on its orientation relative to any shadow casting meshes in the scene.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-autoLightSourcePosition.md Edit}
    */
    autoLightSourcePosition: boolean
    
    /**
    * If enabled, `shadowFrustumSize` will be automatically updated based on its orientation relative to any shadow casting meshes in the scene.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-autoShadowFrustumSize.md Edit}
    */
    autoShadowFrustumSize: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-autoShadowFrustumSizeExtend.md Edit}
    
    * @private
    */
    autoShadowFrustumSizeExtend: number
    
    /**
    * If enabled, the LightSource will be able to cast shadows.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-castsShadows.md Edit}
    */
    castsShadows: boolean
    
    /**
    * The color of the light.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-color.md Edit}
    */
    color: vec3
    
    /**
    * A color image applied to an imaginary skybox the light source will use for color information.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-diffuseEnvTexture.md Edit}
    
    * @deprecated
    
    * @private
    */
    diffuseEnvTexture: Texture
    
    /**
    * A color image applied to an imaginary skybox the LightSource will use for color information.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-diffuseEnvmapTexture.md Edit}
    */
    diffuseEnvmapTexture: Texture
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-dynamicEnvLight.md Edit}
    
    * @private
    */
    dynamicEnvLight: DynamicEnvLight
    
    /**
    * A value used to increase the intensity of light information derived from the `diffuseEnvmapTexture` exponentially.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-envmapExposure.md Edit}
    */
    envmapExposure: number
    
    /**
    * Controls the amount of rotation applied to the `diffuseEnvmapTexture`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-envmapRotation.md Edit}
    */
    envmapRotation: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-estimationIntensity.md Edit}
    
    * @private
    */
    estimationIntensity: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-estimationModel.md Edit}
    
    * @private
    */
    estimationModel: BinAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-falloffEndDistance.md Edit}
    
    * @private
    */
    falloffEndDistance: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-gaussianBlurKernelSize.md Edit}
    
    * @deprecated
    
    * @private
    */
    gaussianBlurKernelSize: number
    
    /**
    * Controls the strength of blurring done to shadows cast by this LightSource.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-gaussianBlurSigma.md Edit}
    
    * @deprecated
    */
    gaussianBlurSigma: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-gaussianBlurStep.md Edit}
    
    * @deprecated
    
    * @private
    */
    gaussianBlurStep: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-innerConeAngleDegrees.md Edit}
    
    * @private
    */
    innerConeAngleDegrees: number
    
    /**
    * The strength of the light on a scale of 0.0  1.0.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-intensity.md Edit}
    */
    intensity: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-lightEstimationCustomModel.md Edit}
    
    * @private
    */
    lightEstimationCustomModel: Asset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-lightEstimationIntensity.md Edit}
    
    * @private
    */
    lightEstimationIntensity: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-lightEstimationSharpness.md Edit}
    
    * @private
    */
    lightEstimationSharpness: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-outerConeAngleDegrees.md Edit}
    
    * @private
    */
    outerConeAngleDegrees: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-rangeEnabled.md Edit}
    
    * @private
    */
    rangeEnabled: boolean
    
    /**
    * The set of layers this LightSource will affect.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-renderLayer.md Edit}
    */
    renderLayer: LayerSet
    
    /**
    * Controls the blurring size used when casting shadows from this LightSource.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-shadowBlurRadius.md Edit}
    */
    shadowBlurRadius: number
    
    /**
    * Controls the color used when casting shadows from this LightSource.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-shadowColor.md Edit}
    */
    shadowColor: vec4
    
    /**
    * The lightness and darkness value of the shadow cast by objects from this light source.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-shadowDensity.md Edit}
    */
    shadowDensity: number
    
    /**
    * The maximum distance at which shadows will be calculated for this LightSource.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-shadowFrustumFarClipPlane.md Edit}
    */
    shadowFrustumFarClipPlane: number
    
    /**
    * The minimum distance at which shadows will be calculated for this LightSource.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-shadowFrustumNearClipPlane.md Edit}
    */
    shadowFrustumNearClipPlane: number
    
    /**
    * The simulated distance of the light source from objects to calculate the softness of the shadow.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-shadowFrustumSize.md Edit}
    */
    shadowFrustumSize: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-shadowTextureSize.md Edit}
    
    * @private
    */
    shadowTextureSize: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-specularEnvTexture.md Edit}
    
    * @deprecated
    
    * @private
    */
    specularEnvTexture: Texture
    
    /**
    * A color image applied to an imaginary skybox the light source will use for specular and reflection information.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-specularEnvmapTexture.md Edit}
    */
    specularEnvmapTexture: Texture
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-useDynamicEnvmap.md Edit}
    
    * @private
    */
    useDynamicEnvmap: boolean
    
    /**
    * Enable if you would like the LightSource to use information from the `diffuseEnvmapTexture` for light color information.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-useEnvmap.md Edit}
    */
    useEnvmap: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LightSource/properties/LightSource-useEstimation.md Edit}
    
    * @private
    */
    useEstimation: boolean
    
}

/**
* Applies a liquify effect to anything rendered behind it.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiquifyVisual/LiquifyVisual-description.md Edit}
*/
interface LiquifyVisual extends BaseMeshVisual {
    /**
    * How strong the liquify effect is.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiquifyVisual/properties/LiquifyVisual-intensity.md Edit}
    */
    intensity: number
    
    /**
    * The radius of the liquify effect circle.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiquifyVisual/properties/LiquifyVisual-radius.md Edit}
    */
    radius: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiveVideoStreamTextureProvider/LiveVideoStreamTextureProvider-description.md Edit}

* @private
*/
interface LiveVideoStreamTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiveVideoStreamTextureProvider/methods/LiveVideoStreamTextureProvider-pause.md Edit}
    
    * @private
    */
    pause(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiveVideoStreamTextureProvider/methods/LiveVideoStreamTextureProvider-play.md Edit}
    
    * @private
    */
    play(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiveVideoStreamTextureProvider/properties/LiveVideoStreamTextureProvider-liveStreamUrl.md Edit}
    
    * @private
    */
    liveStreamUrl: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiveVideoStreamTextureProvider/properties/LiveVideoStreamTextureProvider-onStreamResolutionChanged.md Edit}
    
    * @readonly
    
    * @private
    */
    onStreamResolutionChanged: event2<number, number, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LiveVideoStreamTextureProvider/properties/LiveVideoStreamTextureProvider-volume.md Edit}
    
    * @private
    */
    volume: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LoadStatus/LoadStatus-description.md Edit}
*/
declare enum LoadStatus {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LoadStatus/properties/LoadStatus-Idle.md Edit}
    */
    Idle,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LoadStatus/properties/LoadStatus-Loading.md Edit}
    */
    Loading,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LoadStatus/properties/LoadStatus-Loaded.md Edit}
    */
    Loaded
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationModel/LocalizationModel-description.md Edit}

* @private
*/
interface LocalizationModel extends Asset {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationModel/properties/LocalizationModel-landmarkPositions.md Edit}
    
    * @readonly
    
    * @private
    */
    landmarkPositions: vec3[]
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationModel/properties/LocalizationModel-poses.md Edit}
    
    * @readonly
    
    * @private
    */
    poses: BasicTransform[]
    
}

/**
* Asset used with the Localizations system to support custom localization strings.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationsAsset/LocalizationsAsset-description.md Edit}
*/
interface LocalizationsAsset extends Asset {
}

/**
* Helps convert data types to localized string representations. Accessible through `global.localizationSystem`.

* Note that formatted or localized strings may appear differently to users depending on their region.
* The example results given here are representative of a user in the United States, but may appear differently for users in other regions.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/LocalizationSystem-description.md Edit}
*/
interface LocalizationSystem extends ScriptObject {
    /**
    * Returns a localized string for the date and time of the passed in `Date` object.
    
    * Example: "Jan 1, 2019 at 12:34 AM"
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getDateAndTimeFormatted.md Edit}
    */
    getDateAndTimeFormatted(date: Date): string
    
    /**
    * Returns a localized string for the date of the passed in `Date` object.
    
    * Example: "Jan 1, 2019"
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getDateFormatted.md Edit}
    */
    getDateFormatted(date: Date): string
    
    /**
    * Returns a short, localized string for the date of the passed in `Date` object.
    
    * Example: "1/1/19"
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getDateShortFormatted.md Edit}
    */
    getDateShortFormatted(date: Date): string
    
    /**
    * Returns a localized string for the day of the week of the passed in `Date` object.
    
    * Example: "Tuesday"
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getDayOfWeek.md Edit}
    */
    getDayOfWeek(date: Date): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedDate.md Edit}
    
    * @deprecated
    
    * @private
    */
    getFormattedDate(date: Date): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedDateAndTime.md Edit}
    
    * @deprecated
    
    * @private
    */
    getFormattedDateAndTime(date: Date): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedDateShort.md Edit}
    
    * @deprecated
    
    * @private
    */
    getFormattedDateShort(date: Date): string
    
    /**
    * Returns a localized, formatted string representation of the distance in meters passed in.
    
    * Example: "39.4 in" (from 1 passed in)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedDistanceFromMeters.md Edit}
    */
    getFormattedDistanceFromMeters(meters: number): string
    
    /**
    * Returns a localized, formatted string representation of the number passed in.
    
    * Example: "1,234" (from 1234 passed in)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedNumber.md Edit}
    */
    getFormattedNumber(number: number): string
    
    /**
    * Returns a localized, formatted string representing the number of seconds passed in.
    
    * Example: "2:06" (from 126 passed in)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedSeconds.md Edit}
    */
    getFormattedSeconds(seconds: number): string
    
    /**
    * Returns a localized, formatted string representation of the celsius temperature passed in.
    
    * Example: "32F" (from 0 passed in)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedTemperatureFromCelsius.md Edit}
    */
    getFormattedTemperatureFromCelsius(temperature: number): string
    
    /**
    * Returns a localized, formatted string representation of the fahrenheit temperature passed in.
    
    * Example: "32F" (from 32 passed in)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedTemperatureFromFahrenheit.md Edit}
    */
    getFormattedTemperatureFromFahrenheit(temperature: number): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getFormattedTime.md Edit}
    
    * @deprecated
    
    * @private
    */
    getFormattedTime(date: Date): string
    
    /**
    * Returns the language code of the language being used on the device.
    
    * Example: "en" (for English)
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getLanguage.md Edit}
    
    * @exposesUserData
    */
    getLanguage(): string
    
    /**
    * Returns a localized string for the month of the passed in `Date` object.
    
    * Example: "January"
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getMonth.md Edit}
    */
    getMonth(date: Date): string
    
    /**
    * Returns a localized string for the time of the passed in `Date` object.
    
    * Example: "12:34 AM"
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-getTimeFormatted.md Edit}
    */
    getTimeFormatted(date: Date): string
    
    /**
    * The method takes a [localization key](https://lensstudio.snapchat.com/lens-studio/references/guides/adding-content/text/localization) and returns the localized string according to device language. Useful for localizing strings before formatting them and assigning them to Text.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/methods/LocalizationSystem-localize.md Edit}
    
    * @exposesUserData
    */
    localize(key: string): string
    
    /**
    * Use this property to set the language. Intended for debugging.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocalizationSystem/properties/LocalizationSystem-language.md Edit}
    
    * @exposesUserData
    */
    language: string
    
}

/**
* A component which modifies the [Transform](https://lensstudio.snapchat.com/api/classes/Transform) of the object it is on to a position in the real world, based on a `LocationAsset` and a `position`.


* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/LocatedAtComponent-description.md Edit}
*/
interface LocatedAtComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-alignment.md Edit}
    
    * @private
    */
    alignment: LocatedAtComponent.Alignment
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-distanceToLocation.md Edit}
    
    * @readonly
    */
    distanceToLocation: number
    
    /**
    * The LocationAsset which contains the position this object should be anchored to.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-location.md Edit}
    */
    location: LocationAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-onCanTrack.md Edit}
    
    * @readonly
    */
    onCanTrack: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-onCannotTrack.md Edit}
    
    * @readonly
    */
    onCannotTrack: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-onError.md Edit}
    
    * @readonly
    */
    onError: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-onFound.md Edit}
    
    * @readonly
    */
    onFound: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-onLost.md Edit}
    
    * @readonly
    */
    onLost: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-onReady.md Edit}
    
    * @readonly
    */
    onReady: event0<void>
    
    /**
    * The geo anchored position within a LocationAsset that this object should be anchored to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-position.md Edit}
    */
    position: vec3
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/properties/LocatedAtComponent-proximityStatus.md Edit}
    
    * @readonly
    */
    proximityStatus: LocationProximityStatus
    
}
declare namespace LocatedAtComponent {
    /**
    * Creates an option object for the `LocatedAtComponent`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/methods/LocatedAtComponent-createMappingOptions.md Edit}
    */
    export function createMappingOptions(): MappingOptions
    
    /**
    * Creates a mapping session.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent/methods/LocatedAtComponent-createMappingSession.md Edit}
    */
    export function createMappingSession(options: MappingOptions): MappingSession
    

}

declare namespace LocatedAtComponent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent.Alignment/LocatedAtComponent.Alignment-description.md Edit}
    
    * @private
    */
    enum Alignment {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent.Alignment/properties/LocatedAtComponent.Alignment-Auto.md Edit}
        
        * @private
        */
        Auto,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent.Alignment/properties/LocatedAtComponent.Alignment-EllipsoidSeaLevel.md Edit}
        
        * @private
        */
        EllipsoidSeaLevel,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent.Alignment/properties/LocatedAtComponent.Alignment-Terrain.md Edit}
        
        * @private
        */
        Terrain,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocatedAtComponent.Alignment/properties/LocatedAtComponent.Alignment-RoofTop.md Edit}
        
        * @private
        */
        RoofTop
    }

}

/**
* Allows you to access a user's location information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/Location-description.md Edit}

* @private
*/
interface Location extends AbstractData {
    /**
    * Returns the user's altitude in meters.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getAltitude.md Edit}
    
    * @private
    */
    getAltitude(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getCourse.md Edit}
    
    * @private
    */
    getCourse(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getDistanceFrom.md Edit}
    
    * @private
    */
    getDistanceFrom(latitude: number, longitude: number): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getHeading.md Edit}
    
    * @private
    */
    getHeading(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getHeadingAccuracy.md Edit}
    
    * @private
    */
    getHeadingAccuracy(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getHorizontalAccuracy.md Edit}
    
    * @private
    */
    getHorizontalAccuracy(): number
    
    /**
    * Returns the user's latitude.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getLatitude.md Edit}
    
    * @private
    */
    getLatitude(): number
    
    /**
    * Returns the local time in the user's location in ISO format.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getLocalTimeISOFormat.md Edit}
    
    * @private
    */
    getLocalTimeISOFormat(): string
    
    /**
    * Returns the user's longitude.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getLongitude.md Edit}
    
    * @private
    */
    getLongitude(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getProvider.md Edit}
    
    * @private
    */
    getProvider(): string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getRotationFrom.md Edit}
    
    * @private
    */
    getRotationFrom(latitude: number, longitude: number): number
    
    /**
    * Returns the speed at which the user is moving in meters per second.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getSpeed.md Edit}
    
    * @private
    */
    getSpeed(): number
    
    /**
    * Returns the temperature in the user's location in degrees Celsius.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getTemperatureCelsius.md Edit}
    
    * @deprecated
    
    * @private
    */
    getTemperatureCelsius(): number
    
    /**
    * Returns the temperature in the user's location in degrees Fahrenheit.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getTemperatureFahrenheit.md Edit}
    
    * @deprecated
    
    * @private
    */
    getTemperatureFahrenheit(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getTimestamp.md Edit}
    
    * @private
    */
    getTimestamp(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getVerticalAccuracy.md Edit}
    
    * @private
    */
    getVerticalAccuracy(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-getWeatherCondition.md Edit}
    
    * @deprecated
    
    * @private
    */
    getWeatherCondition(): string
    
    /**
    * Returns whether or not the user's compass is currently available.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-isCompassAvailable.md Edit}
    
    * @private
    */
    isCompassAvailable(): boolean
    
    /**
    * Returns whether or not the user's location is currently available.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-isLocationAvailable.md Edit}
    
    * @private
    */
    isLocationAvailable(): boolean
    
    /**
    * Returns whether or not the weather in the user's location is available.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-isWeatherAvailable.md Edit}
    
    * @deprecated
    
    * @private
    */
    isWeatherAvailable(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-setDesiredAccuracy.md Edit}
    
    * @private
    */
    setDesiredAccuracy(accuracy: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-setDistanceFilterMeters.md Edit}
    
    * @private
    */
    setDistanceFilterMeters(filter: number): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Location/methods/Location-setLocationUpdateIntervalMillis.md Edit}
    
    * @private
    */
    setLocationUpdateIntervalMillis(millis: number): void
    
}

/**
* Provides a frame of reference in which to localize objects to the real world. Use with [LocatedAtComponent](https://lensstudio.snapchat.com/api/classes/LocatedAtComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/LocationAsset-description.md Edit}
*/
interface LocationAsset extends Asset {
    /**
    * Returns the `LocationAsset` Tile that is  specified by the containing tile and the specified `xOffset`, `yOffset` and `zoomOffset`. When zooming in, index offset is relative to the center. When zooming out or not zooming, index offset is relative to the containing tile.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/methods/LocationAsset-adjacentTile.md Edit}
    */
    adjacentTile(xOffset: number, yOffset: number, zoomOffset: number): LocationAsset
    
    /**
    * Gets the Proxy LocationID if the LocationAsset is a proxyLocation; returns null otherwise. This is useful in instances where a callback may return a mix of different location assets, and the creator of the proxy asset has specific handling in mind for particular proxy locations.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/methods/LocationAsset-getProxyId.md Edit}
    */
    getProxyId(): string | undefined
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/properties/LocationAsset-locationId.md Edit}
    
    * @private
    */
    locationId: string
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/properties/LocationAsset-locationType.md Edit}
    
    * @private
    */
    locationType: LocationType
    
}
declare namespace LocationAsset {
    /**
    * Gets the origin position of the `LocationAsset`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/methods/LocationAsset-getAROrigin.md Edit}
    */
    export function getAROrigin(): LocationAsset
    
    /**
    * Get an [Anchor](https://lensstudio.snapchat.com/api/classes/anchor) based on the given GPS coordinate.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/methods/LocationAsset-getGeoAnchoredPosition.md Edit}
    */
    export function getGeoAnchoredPosition(longitude: number, latitude: number): Anchor
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/methods/LocationAsset-getLensWorld.md Edit}
    
    * @private
    */
    export function getLensWorld(): LocationAsset
    
    /**
    * Gets nearby LocationAsset tiles, where each argument represents the x,y,z position relative to the current LocationAsset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/methods/LocationAsset-getNearby.md Edit}
    */
    export function getNearby(xOffset: number, yOffset: number, zoomOffset: number): LocationAsset
    
    /**
    * Get a Proxy LocationAsset with the proxyId embedded in the locationId. proxyId must not be null, must start with an alpha char, and consist only of alphanumerics or ".".
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationAsset/methods/LocationAsset-getProxy.md Edit}
    */
    export function getProxy(proxyId: string): LocationAsset
    

}

/**
* Provides access to location cloud storage depending upon the LocationCloudStorageOptions.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageModule/LocationCloudStorageModule-description.md Edit}
*/
interface LocationCloudStorageModule extends Asset {
    /**
    * Request discovery of LocationCloudStores based on the user location.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageModule/methods/LocationCloudStorageModule-getNearbyLocationStores.md Edit}
    */
    getNearbyLocationStores(options: LocationCloudStorageOptions): void
    
    /**
    * Retrieves the specified `LocationAsset`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageModule/methods/LocationCloudStorageModule-retrieveLocation.md Edit}
    */
    retrieveLocation(persistedLocationId: string, onRetrievedLocation: (location: LocationAsset) => void, onError: (error: string) => void): void
    
    /**
    * Stores the specified `LocationAsset`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageModule/methods/LocationCloudStorageModule-storeLocation.md Edit}
    */
    storeLocation(location: LocationAsset, onStoredLocation: (persistedLocationId: string) => void, onError: (error: string) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageModule/properties/LocationCloudStorageModule-session.md Edit}
    
    * @private
    */
    session: MultiplayerSession
    
}

/**
* Used to configure LocationCloudStorage module with various options. 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageOptions/LocationCloudStorageOptions-description.md Edit}
*/
interface LocationCloudStorageOptions extends ScriptObject {
    /**
    * Tag to represent a collection of objects/entities
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageOptions/properties/LocationCloudStorageOptions-collection.md Edit}
    */
    collection: string
    
    /**
    * Provides a frame of reference in which to localize objects to the real world. Could be any location type.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageOptions/properties/LocationCloudStorageOptions-location.md Edit}
    */
    location: LocationAsset
    
    /**
    * Event raised on discovery of nearby cloud stores.
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageOptions/properties/LocationCloudStorageOptions-onDiscoveredNearby.md Edit}
    
    * @readonly
    */
    onDiscoveredNearby: event2<LocationAsset, LocationCloudStore, void>
    
    /**
    * Error event raised when failing to instantiate a location cloud store associated with that location asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageOptions/properties/LocationCloudStorageOptions-onError.md Edit}
    
    * @readonly
    */
    onError: event3<LocationAsset, string, string, void>
    
}
declare namespace LocationCloudStorageOptions {
    /**
    * Create options to provide to LocationCloudStorageModule  
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStorageOptions/methods/LocationCloudStorageOptions-create.md Edit}
    */
    export function create(): LocationCloudStorageOptions
    

}

/**
* Instance of location cloud store which has a similar interface as cloud store.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStore/LocationCloudStore-description.md Edit}
*/
interface LocationCloudStore extends ScriptObject {
    /**
    * Deletes a value on the location cloud store. Note: when updating a value, the scope and collection must match that of the original value.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStore/methods/LocationCloudStore-deleteValue.md Edit}
    */
    deleteValue(key: string, readOptions: CloudStorageReadOptions, onDeleted: () => void, onError: (code: string, description: string) => void): void
    
    /**
    * Gets a value on the location cloud store. Note: when updating a value, the scope and collection must match that of the original value.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStore/methods/LocationCloudStore-getValue.md Edit}
    */
    getValue(key: string, readOptions: CloudStorageReadOptions, onRetrieved: (key: string, value: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string), collection: string) => void, onError: (code: string, description: string) => void): void
    
    /**
    * List values on the location cloud store. Note: when updating a value, the scope and collection must match that of the original value.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStore/methods/LocationCloudStore-listValues.md Edit}
    */
    listValues(listOptions: CloudStorageListOptions, onRetrieved: (values: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string)[][], cursor: string, collection: string) => void, onError: (code: string, description: string) => void): void
    
    /**
    * Create/update a value on the location cloud store. Note: when updating a value, the scope and collection must match that of the original value.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationCloudStore/methods/LocationCloudStore-setValue.md Edit}
    */
    setValue(key: string, value: (mat4|mat3|mat2|vec4|vec2|vec3|boolean|quat|number|string), writeOptions: CloudStorageWriteOptions, onSaved: () => void, onError: (code: string, description: string) => void): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationLandmarksRenderObjectProvider/LocationLandmarksRenderObjectProvider-description.md Edit}

* @private
*/
interface LocationLandmarksRenderObjectProvider extends RenderObjectProvider {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationMarkerProvider/LocationMarkerProvider-description.md Edit}

* @unreleased
*/
interface LocationMarkerProvider extends NaturalFeatureMarkerProvider {
}

/**
* Used by [DeviceLocationTrackingComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#DeviceLocationTrackingComponent) to indicate the user's distance from the landmarker location.
* See the [Landmarker guide](https://lensstudio.snapchat.com/templates/landmarker) for more information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationProximityStatus/LocationProximityStatus-description.md Edit}
*/
declare enum LocationProximityStatus {
    /**
    * User's distance cannot be determined or has not been determined yet.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationProximityStatus/properties/LocationProximityStatus-Unknown.md Edit}
    */
    Unknown,
    /**
    * User is close enough to the landmarker location to begin tracking.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationProximityStatus/properties/LocationProximityStatus-WithinRange.md Edit}
    */
    WithinRange,
    /**
    * User is too far away from the landmarker location to track it.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationProximityStatus/properties/LocationProximityStatus-OutOfRange.md Edit}
    */
    OutOfRange
}

/**
* Provides access to a location's Mesh--such as when working with City Scale AR. Usually used in conjunction with `LocationTextureProvider`.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationRenderObjectProvider/LocationRenderObjectProvider-description.md Edit}
*/
interface LocationRenderObjectProvider extends RenderObjectProvider {
    /**
    * The Render Object's `LocationAsset` nearby tile.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationRenderObjectProvider/properties/LocationRenderObjectProvider-location.md Edit}
    */
    location: LocationAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationRenderObjectProvider/properties/LocationRenderObjectProvider-onLocationDataDownloadFailed.md Edit}
    
    * @readonly
    */
    onLocationDataDownloadFailed: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationRenderObjectProvider/properties/LocationRenderObjectProvider-onLocationDataDownloaded.md Edit}
    
    * @readonly
    */
    onLocationDataDownloaded: event0<void>
    
}
declare namespace LocationRenderObjectProvider {
    /**
    * Creates the location mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationRenderObjectProvider/methods/LocationRenderObjectProvider-create.md Edit}
    */
    export function create(): RenderMesh
    

}

/**
* The LocationService allows the user to provide their location to lens applications if they so desire. For privacy reasons, the user is asked for permission to report location information.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationService/LocationService-description.md Edit}
*/
interface LocationService extends ScriptObject {
    /**
    * Retrieves the device's current location.
    * `onSuccess`: a callback function that takes a GeoPosition object as its sole input parameter.
    * `onError`: a callback function that takes a string error message as its sole input parameter.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationService/methods/LocationService-getCurrentPosition.md Edit}
    
    * @exposesUserData
    */
    getCurrentPosition(onSucess: (geoPosition: GeoPosition) => void, onError: (error: string) => void): void
    
    /**
    * The accuracy of the provided position.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationService/properties/LocationService-accuracy.md Edit}
    */
    accuracy: GeoLocationAccuracy
    
    /**
    * Event to notify when north aligned orientation data is available to use.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationService/properties/LocationService-onNorthAlignedOrientationUpdate.md Edit}
    
    * @readonly
    */
    onNorthAlignedOrientationUpdate: event1<quat, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationService/properties/LocationService-timestampSeconds.md Edit}
    
    * @readonly
    
    * @private
    */
    timestampSeconds: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationService/properties/LocationService-updateIntervalMillis.md Edit}
    
    * @private
    */
    updateIntervalMillis: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationSystem/LocationSystem-description.md Edit}

* @private
*/
interface LocationSystem extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationSystem/methods/LocationSystem-requestLocationOfUser.md Edit}
    
    * @private
    */
    requestLocationOfUser(user: SnapchatUser, successCallback: (location: UserLocationInfo) => void, failureCallback: (error: string) => void): void
    
}

/**
* Provides access to a location's texture--such as when working with City Scale AR.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationTextureProvider/LocationTextureProvider-description.md Edit}
*/
interface LocationTextureProvider extends TextureProvider {
    /**
    * The location texture's `LocationAsset` nearby tile.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationTextureProvider/properties/LocationTextureProvider-location.md Edit}
    */
    location: LocationAsset
    
}
declare namespace LocationTextureProvider {
    /**
    * Create location texture.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationTextureProvider/methods/LocationTextureProvider-create.md Edit}
    */
    export function create(): Texture
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/LocationType-description.md Edit}

* @private
*/
declare enum LocationType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/properties/LocationType-Snap.md Edit}
    
    * @private
    */
    Snap,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/properties/LocationType-Custom.md Edit}
    
    * @private
    */
    Custom,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/properties/LocationType-World.md Edit}
    
    * @private
    */
    World,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/properties/LocationType-Tile.md Edit}
    
    * @private
    */
    Tile,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/properties/LocationType-RelativeTile.md Edit}
    
    * @private
    */
    RelativeTile,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/properties/LocationType-Proxy.md Edit}
    
    * @private
    */
    Proxy,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/properties/LocationType-NativeAR.md Edit}
    
    * @private
    */
    NativeAR,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LocationType/properties/LocationType-LensWorld.md Edit}
    
    * @private
    */
    LensWorld
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LongPressEndEvent/LongPressEndEvent-description.md Edit}

* @private
*/
interface LongPressEndEvent extends SceneObjectEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LongPressEndEvent/methods/LongPressEndEvent-getLongPressPosition.md Edit}
    
    * @private
    */
    getLongPressPosition(): vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LongPressEndEventArgs/LongPressEndEventArgs-description.md Edit}

* @private
*/
interface LongPressEndEventArgs extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LongPressEndEventArgs/properties/LongPressEndEventArgs-position.md Edit}
    
    * @readonly
    
    * @private
    */
    position: vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LongPressStartEvent/LongPressStartEvent-description.md Edit}

* @private
*/
interface LongPressStartEvent extends SceneObjectEvent {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LongPressStartEvent/methods/LongPressStartEvent-getLongPressPosition.md Edit}
    
    * @private
    */
    getLongPressPosition(): vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LongPressStartEventArgs/LongPressStartEventArgs-description.md Edit}

* @private
*/
interface LongPressStartEventArgs extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LongPressStartEventArgs/properties/LongPressStartEventArgs-position.md Edit}
    
    * @readonly
    
    * @private
    */
    position: vec2
    
}

/**
* Every frame, LookAtComponent rotates its SceneObject to face towards a target SceneObject.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent/LookAtComponent-description.md Edit}
*/
interface LookAtComponent extends Component {
    /**
    * The "aim" and "up" vectors used when determining rotation.
    * LookAtComponent will try to point the `Aim` axis of the SceneObject towards the target,
    * while keeping the `Up` axis of the SceneObject pointing towards `worldUpVector`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent/properties/LookAtComponent-aimVectors.md Edit}
    */
    aimVectors: LookAtComponent.AimVectors
    
    /**
    * Controls the method of rotation being used.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent/properties/LookAtComponent-lookAtMode.md Edit}
    */
    lookAtMode: LookAtComponent.LookAtMode
    
    /**
    * Adds an additional rotation offset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent/properties/LookAtComponent-offsetRotation.md Edit}
    */
    offsetRotation: quat
    
    /**
    * The SceneObject this LookAtComponent targets.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent/properties/LookAtComponent-target.md Edit}
    */
    target: SceneObject
    
    /**
    * The vector to be considered the "up" vector when determining rotation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent/properties/LookAtComponent-worldUpVector.md Edit}
    */
    worldUpVector: LookAtComponent.WorldUpVector
    
}

declare namespace LookAtComponent {
    /**
    * The "aim" and "up" vectors used with [LookAtComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#LookAtComponent) when determining rotation.
    * LookAtComponent will try to point the `Aim` axis of the SceneObject towards the target,
    * while keeping the `Up` axis of the SceneObject pointing towards `worldUpVector`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/LookAtComponent.AimVectors-description.md Edit}
    */
    enum AimVectors {
        /**
        * X Aim, Y Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-XAimYUp.md Edit}
        */
        XAimYUp,
        /**
        * X Aim, Z Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-XAimZUp.md Edit}
        */
        XAimZUp,
        /**
        * Y Aim, X Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-YAimXUp.md Edit}
        */
        YAimXUp,
        /**
        * Y Aim, Z Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-YAimZUp.md Edit}
        */
        YAimZUp,
        /**
        * Z Aim, X Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-ZAimXUp.md Edit}
        */
        ZAimXUp,
        /**
        * Z Aim, Y Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-ZAimYUp.md Edit}
        */
        ZAimYUp,
        /**
        * X Aim, -Y Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-XAimNegativeYUp.md Edit}
        */
        XAimNegativeYUp,
        /**
        * X Aim, -Z Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-XAimNegativeZUp.md Edit}
        */
        XAimNegativeZUp,
        /**
        * Y Aim, -X Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-YAimNegativeXUp.md Edit}
        */
        YAimNegativeXUp,
        /**
        * Y Aim, -Z Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-YAimNegativeZUp.md Edit}
        */
        YAimNegativeZUp,
        /**
        * Z Aim, -X Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-ZAimNegativeXUp.md Edit}
        */
        ZAimNegativeXUp,
        /**
        * Z Aim, -Y Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-ZAimNegativeYUp.md Edit}
        */
        ZAimNegativeYUp,
        /**
        * -X Aim, Y Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeXAimYUp.md Edit}
        */
        NegativeXAimYUp,
        /**
        * -X Aim, Z Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeXAimZUp.md Edit}
        */
        NegativeXAimZUp,
        /**
        * -Y Aim, X Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeYAimXUp.md Edit}
        */
        NegativeYAimXUp,
        /**
        * -Y Aim, Z Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeYAimZUp.md Edit}
        */
        NegativeYAimZUp,
        /**
        * -Z Aim, X Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeZAimXUp.md Edit}
        */
        NegativeZAimXUp,
        /**
        * -Z Aim, Y Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeZAimYUp.md Edit}
        */
        NegativeZAimYUp,
        /**
        * -X Aim, -Y Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeXAimNegativeYUp.md Edit}
        */
        NegativeXAimNegativeYUp,
        /**
        * -X Aim, -Z Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeXAimNegativeZUp.md Edit}
        */
        NegativeXAimNegativeZUp,
        /**
        * -Y Aim, -X Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeYAimNegativeXUp.md Edit}
        */
        NegativeYAimNegativeXUp,
        /**
        * -Y Aim, -Z Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeYAimNegativeZUp.md Edit}
        */
        NegativeYAimNegativeZUp,
        /**
        * -Z Aim, -X Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeZAimNegativeXUp.md Edit}
        */
        NegativeZAimNegativeXUp,
        /**
        * -Z Aim, -Y Up
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.AimVectors/properties/LookAtComponent.AimVectors-NegativeZAimNegativeYUp.md Edit}
        */
        NegativeZAimNegativeYUp
    }

}

declare namespace LookAtComponent {
    /**
    * Modes used in `LookAtComponent.lookAtMode` to determine the rotation method being used.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.LookAtMode/LookAtComponent.LookAtMode-description.md Edit}
    */
    enum LookAtMode {
        /**
        * Rotation is based on the target object's position
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.LookAtMode/properties/LookAtComponent.LookAtMode-LookAtPoint.md Edit}
        */
        LookAtPoint,
        /**
        * Rotation is based on the target object's rotation
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.LookAtMode/properties/LookAtComponent.LookAtMode-LookAtDirection.md Edit}
        */
        LookAtDirection
    }

}

declare namespace LookAtComponent {
    /**
    * Used with [LookAtComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#LookAtComponent) to set the "up" vector when determining rotation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/LookAtComponent.WorldUpVector-description.md Edit}
    */
    enum WorldUpVector {
        /**
        * Scene's X vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-SceneX.md Edit}
        */
        SceneX,
        /**
        * Scene's Y vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-SceneY.md Edit}
        */
        SceneY,
        /**
        * Scene's Y vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-SceneUp.md Edit}
        */
        SceneUp,
        /**
        * Scene's Z vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-SceneZ.md Edit}
        */
        SceneZ,
        /**
        * Target object's X vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-TargetX.md Edit}
        */
        TargetX,
        /**
        * Target object's Y vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-TargetY.md Edit}
        */
        TargetY,
        /**
        * Target object's Z vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-TargetZ.md Edit}
        */
        TargetZ,
        /**
        * Current object's X vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-ObjectX.md Edit}
        */
        ObjectX,
        /**
        * Current object's Y vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-ObjectY.md Edit}
        */
        ObjectY,
        /**
        * Current object's Z vector
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/LookAtComponent.WorldUpVector/properties/LookAtComponent.WorldUpVector-ObjectZ.md Edit}
        */
        ObjectZ
    }

}

/**
* Namespace for Machine Learning related classes and methods.
* For more information, see the [Machine Learning Overview](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/machine-learning/ml-overview).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/MachineLearning-description.md Edit}
*/
interface MachineLearning {
}
declare namespace MachineLearning {
    /**
    * Creates a new DelayBuilder object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createDelayBuilder.md Edit}
    */
    export function createDelayBuilder(): DelayBuilder
    
    /**
    * Creates a new DeltaBuilder object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createDeltaBuilder.md Edit}
    */
    export function createDeltaBuilder(): DeltaBuilder
    
    /**
    * Creates a new InputBuilder object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createInputBuilder.md Edit}
    */
    export function createInputBuilder(): InputBuilder
    
    /**
    * Creates a new MFCCBuilder object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createMFCCBuilder.md Edit}
    */
    export function createMFCCBuilder(): MFCCBuilder
    
    /**
    * Creates a new MelSpectrogramBuilder object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createMelSpectrogramBuilder.md Edit}
    */
    export function createMelSpectrogramBuilder(): MelSpectrogramBuilder
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createNoiseReductionBuilder.md Edit}
    */
    export function createNoiseReductionBuilder(): NoiseReductionBuilder
    
    /**
    * Creates a new OutputBuilder object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createOutputBuilder.md Edit}
    */
    export function createOutputBuilder(): OutputBuilder
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createPitchShifterBuilder.md Edit}
    */
    export function createPitchShifterBuilder(): PitchShifterBuilder
    
    /**
    * Creates SamplerBuilder.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createSamplerBuilder.md Edit}
    */
    export function createSamplerBuilder(): SamplerBuilder
    
    /**
    * Creates a new SpectrogramBuilder object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createSpectrogramBuilder.md Edit}
    */
    export function createSpectrogramBuilder(): SpectrogramBuilder
    
    /**
    * Creates a new TransformerBuilder object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning/methods/MachineLearning-createTransformerBuilder.md Edit}
    */
    export function createTransformerBuilder(): TransformerBuilder
    

}

declare namespace MachineLearning {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/MachineLearning.AlignmentType-description.md Edit}
    
    * @private
    */
    enum AlignmentType {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-CelebAHQ.md Edit}
        
        * @private
        */
        CelebAHQ,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-RotationSquare.md Edit}
        
        * @private
        */
        RotationSquare,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-RotationRect.md Edit}
        
        * @private
        */
        RotationRect,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-FaceSegmentation.md Edit}
        
        * @private
        */
        FaceSegmentation,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-EyeSegmentation.md Edit}
        
        * @private
        */
        EyeSegmentation,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-NeutralityClassifier.md Edit}
        
        * @private
        */
        NeutralityClassifier,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-NeutralityGenerator.md Edit}
        
        * @private
        */
        NeutralityGenerator,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-FaceMeshBased.md Edit}
        
        * @private
        */
        FaceMeshBased,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.AlignmentType/properties/MachineLearning.AlignmentType-FaceSwap.md Edit}
        
        * @private
        */
        FaceSwap
    }

}

declare namespace MachineLearning {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.DataLayout/MachineLearning.DataLayout-description.md Edit}
    
    * @private
    */
    enum DataLayout {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.DataLayout/properties/MachineLearning.DataLayout-NCHW.md Edit}
        
        * @private
        */
        NCHW,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.DataLayout/properties/MachineLearning.DataLayout-NHWC.md Edit}
        
        * @private
        */
        NHWC
    }

}

declare namespace MachineLearning {
    /**
    * Timing options for when MLComponent should start or stop running. Used with `MLComponent.runScheduled()`.
    * For more information, see the [MLComponent Scripting](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/machine-learning/ml-component/scripting-ml-component) guide.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.FrameTiming/MachineLearning.FrameTiming-description.md Edit}
    */
    enum FrameTiming {
        /**
        * Only valid as an end timing. There is no exact time specified when MLComponent should finish its run.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.FrameTiming/properties/MachineLearning.FrameTiming-None.md Edit}
        */
        None,
        /**
        * Run during MLComponent update, before script update.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.FrameTiming/properties/MachineLearning.FrameTiming-Update.md Edit}
        */
        Update,
        /**
        * Run in MLComponent LateUpdate, after all scripts update, but before they get LateUpdate.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.FrameTiming/properties/MachineLearning.FrameTiming-LateUpdate.md Edit}
        */
        LateUpdate,
        /**
        * Run at a specific point during frame rendering.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.FrameTiming/properties/MachineLearning.FrameTiming-OnRender.md Edit}
        */
        OnRender
    }

}

declare namespace MachineLearning {
    /**
    * Inference modes used by `MLComponent.inferenceMode`. Each mode describes how the neural network will be run.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.InferenceMode/MachineLearning.InferenceMode-description.md Edit}
    */
    enum InferenceMode {
        /**
        * MLComponent will run the neural network on CPU. Available on all devices.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.InferenceMode/properties/MachineLearning.InferenceMode-CPU.md Edit}
        */
        CPU,
        /**
        * MLComponent will attempt to run the neural network on GPU. If the device doesn't support it, CPU mode will be used instead.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.InferenceMode/properties/MachineLearning.InferenceMode-GPU.md Edit}
        */
        GPU,
        /**
        * MLComponent will attempt to use a dedicated hardware accelerator to run the neural network. If the device doesn't support it, GPU mode will be used instead.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.InferenceMode/properties/MachineLearning.InferenceMode-Accelerator.md Edit}
        */
        Accelerator,
        /**
        * MLComponent will automatically decide how to run the neural network based on what is supported. It will start with Accelerator, then fall back to GPU, then CPU.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.InferenceMode/properties/MachineLearning.InferenceMode-Auto.md Edit}
        */
        Auto,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.InferenceMode/properties/MachineLearning.InferenceMode-NativeCPU.md Edit}
        */
        NativeCPU,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.InferenceMode/properties/MachineLearning.InferenceMode-Libdnn.md Edit}
        */
        Libdnn,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.InferenceMode/properties/MachineLearning.InferenceMode-DSP.md Edit}
        */
        DSP
    }

}

declare namespace MachineLearning {
    /**
    * Describes the current state of the MLComponent model.
    * For more information, see the [MLComponent Scripting](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/machine-learning/ml-component/scripting-ml-component) guide.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.ModelState/MachineLearning.ModelState-description.md Edit}
    */
    enum ModelState {
        /**
        * Model is running
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.ModelState/properties/MachineLearning.ModelState-Running.md Edit}
        */
        Running,
        /**
        * Model is loading
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.ModelState/properties/MachineLearning.ModelState-Loading.md Edit}
        */
        Loading,
        /**
        * Model is built and ready to run
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.ModelState/properties/MachineLearning.ModelState-Idle.md Edit}
        */
        Idle,
        /**
        * Model is not ready to run
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.ModelState/properties/MachineLearning.ModelState-NotReady.md Edit}
        */
        NotReady
    }

}

declare namespace MachineLearning {
    /**
    * Types of output used by OutputPlaceholder.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.OutputMode/MachineLearning.OutputMode-description.md Edit}
    */
    enum OutputMode {
        /**
        * The output will be in the form of a Texture.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.OutputMode/properties/MachineLearning.OutputMode-Texture.md Edit}
        */
        Texture,
        /**
        * The output will be in the form of a Float32Array.
        
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MachineLearning.OutputMode/properties/MachineLearning.OutputMode-Data.md Edit}
        */
        Data
    }

}

/**
* Handles input information from user touch input via the [TouchComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#TouchComponent) to control Scale, Rotation, and Translation of objects.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/ManipulateComponent-description.md Edit}
*/
interface ManipulateComponent extends Component {
    /**
    * Repositions the object to be within the bounds of `minDistance`, `maxDistance`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/methods/ManipulateComponent-clampWorldPosition.md Edit}
    */
    clampWorldPosition(): void
    
    /**
    * Enables or disables the specified ManipulateType for this ManipulateComponent.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/methods/ManipulateComponent-enableManipulateType.md Edit}
    */
    enableManipulateType(type: ManipulateType, enable: boolean): void
    
    /**
    * Checks for an intersection point between the manipulation plane and a line extending
    * from the camera through the specified screen space point. The screen point is passed in as (x, y) with both values
    * ranging from ([0-1], [0-1]), (0,0) being left-top and (1,1) being right-bottom. The result is returned as a
    * [ManipulateFrameIntersectResult](https://lensstudio.snapchat.com/api/lens-studio/Classes/OtherClasses#ManipulateFrameIntersectResult) object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/methods/ManipulateComponent-intersectManipulateFrame.md Edit}
    */
    intersectManipulateFrame(screenSpacePoint: vec2): ManipulateFrameIntersectResult
    
    /**
    * Returns whether the specified ManipulateType is enabled for this ManipulateComponent.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/methods/ManipulateComponent-isManipulateTypeEnabled.md Edit}
    */
    isManipulateTypeEnabled(type: ManipulateType): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/methods/ManipulateComponent-setCamera.md Edit}
    
    * @deprecated
    
    * @private
    */
    setCamera(camera: Camera): void
    
    /**
    * Changes swivel behavior based on the object's height relative to the camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-isContextualSwivel.md Edit}
    */
    isContextualSwivel: boolean
    
    /**
    * Returns whether the object that the Manipulate Component is on is currently being manipulated
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-isManipulating.md Edit}
    
    * @readonly
    */
    isManipulating: boolean
    
    /**
    * The maximum distance the object can travel from the user.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-maxDistance.md Edit}
    */
    maxDistance: number
    
    /**
    * The maximum height of the object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-maxHeight.md Edit}
    */
    maxHeight: number
    
    /**
    * The maximum size the object can scale to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-maxScale.md Edit}
    */
    maxScale: number
    
    /**
    * The minimum distance the object can be from the user.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-minDistance.md Edit}
    */
    minDistance: number
    
    /**
    * The minimum height of the object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-minHeight.md Edit}
    */
    minHeight: number
    
    /**
    * The minimum size the object can shrink to.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-minScale.md Edit}
    */
    minScale: number
    
    /**
    * Event fired when manipulation ends.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-onManipulateEnd.md Edit}
    
    * @readonly
    */
    onManipulateEnd: event1<ManipulateEndEventArgs, void>
    
    /**
    * Event fired when manipulation starts.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-onManipulateStart.md Edit}
    
    * @readonly
    */
    onManipulateStart: event1<ManipulateStartEventArgs, void>
    
    /**
    * Multiplier for swivel rotation speed.
    * For example, a value of 0.5 will cut rotation speed in half,
    * and a value of 2.0 will double rotation speed.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateComponent/properties/ManipulateComponent-rotationScale.md Edit}
    */
    rotationScale: number
    
}

/**
* This event is triggered when manipulation on the object ends.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateEndEvent/ManipulateEndEvent-description.md Edit}
*/
interface ManipulateEndEvent extends SceneObjectEvent {
    /**
    * Sets the type of manipulation this event reacts to. Possible values are: "scale", "swivel", "translatesurface", "translatesphericalwithdepthadjust".
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateEndEvent/methods/ManipulateEndEvent-setManipulateType.md Edit}
    
    * @private
    */
    setManipulateType(manipulateType: string): void
    
}

/**
* Arguments used with the `ManipulateComponent.onManipulateEnd` event.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateEndEventArgs/ManipulateEndEventArgs-description.md Edit}
*/
interface ManipulateEndEventArgs extends ScriptObject {
}

/**
* Result object returned from [ManipulateComponent.intersectManipulateFrame()](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ManipulateComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateFrameIntersectResult/ManipulateFrameIntersectResult-description.md Edit}
*/
interface ManipulateFrameIntersectResult {
    /**
    * If there was a valid intersection, returns the intersection point in world space.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateFrameIntersectResult/methods/ManipulateFrameIntersectResult-getIntersectionPoint.md Edit}
    */
    getIntersectionPoint(): vec3
    
    /**
    * Returns whether there was a valid intersection.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateFrameIntersectResult/methods/ManipulateFrameIntersectResult-isValid.md Edit}
    */
    isValid(): boolean
    
}

/**
* This event is triggered when manipulation on the object begins.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateStartEvent/ManipulateStartEvent-description.md Edit}
*/
interface ManipulateStartEvent extends SceneObjectEvent {
    /**
    * Sets the type of manipulation this event reacts to. Possible values are: "scale", "swivel", "translatesurface", "translatesphericalwithdepthadjust".
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateStartEvent/methods/ManipulateStartEvent-setManipulateType.md Edit}
    
    * @private
    */
    setManipulateType(value: string): void
    
}

/**
* Arguments used with the `ManipulateComponent.onManipulateStart` event.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateStartEventArgs/ManipulateStartEventArgs-description.md Edit}
*/
interface ManipulateStartEventArgs extends ScriptObject {
}

/**
* Enum values specifying each type of manipulation. See [ManipulateComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#ManipulateComponent).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateType/ManipulateType-description.md Edit}
*/
declare enum ManipulateType {
    /**
    * The object can be scaled by pinching with two fingers.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateType/properties/ManipulateType-Scale.md Edit}
    */
    Scale,
    /**
    * The object can be rotated by swiveling with two fingers.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateType/properties/ManipulateType-Swivel.md Edit}
    */
    Swivel,
    /**
    * The object can be moved by touching and dragging.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateType/properties/ManipulateType-Drag.md Edit}
    */
    Drag,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateType/properties/ManipulateType-DragVertical.md Edit}
    */
    DragVertical,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/ManipulateType/properties/ManipulateType-Pan.md Edit}
    */
    Pan
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandler/MapHandler-description.md Edit}

* @private
*/
interface MapHandler extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandler/methods/MapHandler-getGeoObjectCount.md Edit}
    
    * @private
    */
    getGeoObjectCount(request: MapHandlerRequest, onSuccess: (geoObjectCount: number) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandler/methods/MapHandler-getLayer.md Edit}
    
    * @private
    */
    getLayer(request: MapHandlerRequest, onSuccess: (layerData: GeoObject[]) => void): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandler/properties/MapHandler-onError.md Edit}
    
    * @readonly
    
    * @private
    */
    onError: event0<void>
    
}
declare namespace MapHandler {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandler/methods/MapHandler-create.md Edit}
    
    * @private
    */
    export function create(): MapHandler
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandler/methods/MapHandler-createRequest.md Edit}
    
    * @private
    */
    export function createRequest(): MapHandlerRequest
    

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandlerRequest/MapHandlerRequest-description.md Edit}

* @private
*/
interface MapHandlerRequest extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandlerRequest/properties/MapHandlerRequest-latitude.md Edit}
    
    * @private
    */
    latitude: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandlerRequest/properties/MapHandlerRequest-layerType.md Edit}
    
    * @private
    */
    layerType: MapLayerType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandlerRequest/properties/MapHandlerRequest-limit.md Edit}
    
    * @private
    */
    limit: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandlerRequest/properties/MapHandlerRequest-longitude.md Edit}
    
    * @private
    */
    longitude: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandlerRequest/properties/MapHandlerRequest-radius.md Edit}
    
    * @private
    */
    radius: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapHandlerRequest/properties/MapHandlerRequest-start.md Edit}
    
    * @private
    */
    start: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/MapLayerType-description.md Edit}

* @private
*/
declare enum MapLayerType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Unsupported.md Edit}
    
    * @private
    */
    Unsupported,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Boundaries.md Edit}
    
    * @private
    */
    Boundaries,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Buildings.md Edit}
    
    * @private
    */
    Buildings,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Earth.md Edit}
    
    * @private
    */
    Earth,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Landuse.md Edit}
    
    * @private
    */
    Landuse,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Places.md Edit}
    
    * @private
    */
    Places,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-PointsOfInterest.md Edit}
    
    * @private
    */
    PointsOfInterest,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Roads.md Edit}
    
    * @private
    */
    Roads,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Transit.md Edit}
    
    * @private
    */
    Transit,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapLayerType/properties/MapLayerType-Water.md Edit}
    
    * @private
    */
    Water
}

/**
* Module for providing Map utils. 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapModule/MapModule-description.md Edit}
*/
interface MapModule extends Asset {
    /**
    * Creates a new texture which holds a `MapTextureProvider`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapModule/methods/MapModule-createMapTextureProvider.md Edit}
    */
    createMapTextureProvider(): Texture
    
    /**
    * Returns the position of the marker (relative to the associated map tile) based on the specified `longitude`, `latitude` and `location`. The top left corner of the provided `location` has a value of `[0,0]` and the right down corner has a value of `[1.1]`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapModule/methods/MapModule-longLatToImageRatio.md Edit}
    */
    longLatToImageRatio(longitude: number, latitude: number, location: LocationAsset): vec2
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingOptions/MappingOptions-description.md Edit}
*/
interface MappingOptions extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingOptions/properties/MappingOptions-location.md Edit}
    */
    location: LocationAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingOptions/properties/MappingOptions-locationCloudStorageModule.md Edit}
    */
    locationCloudStorageModule: LocationCloudStorageModule
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingOptions/properties/MappingOptions-policy.md Edit}
    */
    policy: string
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/MappingSession-description.md Edit}
*/
interface MappingSession extends ScriptObject {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/methods/MappingSession-cancel.md Edit}
    */
    cancel(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/methods/MappingSession-checkpoint.md Edit}
    */
    checkpoint(): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-canCheckpoint.md Edit}
    
    * @readonly
    */
    canCheckpoint: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-capacityUsed.md Edit}
    
    * @readonly
    */
    capacityUsed: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-handheldMaximumSize.md Edit}
    */
    handheldMaximumSize: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-handheldMinimumSize.md Edit}
    */
    handheldMinimumSize: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-onCapacityUsedAtLimit.md Edit}
    
    * @readonly
    
    * @private
    */
    onCapacityUsedAtLimit: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-onMapped.md Edit}
    
    * @readonly
    */
    onMapped: event1<LocationAsset, void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-onQualityAcceptable.md Edit}
    
    * @readonly
    
    * @private
    */
    onQualityAcceptable: event0<void>
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-quality.md Edit}
    
    * @readonly
    */
    quality: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-throttling.md Edit}
    */
    throttling: MappingSession.MappingThrottling
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-wearableAcceptableRawCapacity.md Edit}
    
    * @private
    */
    wearableAcceptableRawCapacity: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-wearableAllowEarlyCheckpoint.md Edit}
    
    * @private
    */
    wearableAllowEarlyCheckpoint: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-wearableMaximumSize.md Edit}
    */
    wearableMaximumSize: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession/properties/MappingSession-wearableMinimumSize.md Edit}
    */
    wearableMinimumSize: number
    
}

declare namespace MappingSession {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession.MappingThrottling/MappingSession.MappingThrottling-description.md Edit}
    */
    enum MappingThrottling {
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession.MappingThrottling/properties/MappingSession.MappingThrottling-Auto.md Edit}
        */
        Auto,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession.MappingThrottling/properties/MappingSession.MappingThrottling-Foreground.md Edit}
        */
        Foreground,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession.MappingThrottling/properties/MappingSession.MappingThrottling-Background.md Edit}
        */
        Background,
        /**
        * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MappingSession.MappingThrottling/properties/MappingSession.MappingThrottling-Off.md Edit}
        */
        Off
    }

}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapTextureProvider/MapTextureProvider-description.md Edit}
*/
interface MapTextureProvider extends TextureProvider {
    /**
    * The location asset associated with the `MapTextureProvider`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapTextureProvider/properties/MapTextureProvider-location.md Edit}
    */
    location: LocationAsset
    
    /**
    * A function that gets called when location data fails to download.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapTextureProvider/properties/MapTextureProvider-onFailed.md Edit}
    
    * @readonly
    */
    onFailed: event0<void>
    
    /**
    * A function that gets called when location data is downloaded.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MapTextureProvider/properties/MapTextureProvider-onReady.md Edit}
    
    * @readonly
    */
    onReady: event0<void>
    
}

/**
* Defines a marker to use for Marker Tracking with [MarkerTrackingComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#MarkerTrackingComponent).
* For more information, see the [Marker Tracking](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/world/marker-tracking) guide.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerAsset/MarkerAsset-description.md Edit}
*/
interface MarkerAsset extends Asset {
    /**
    * Returns the aspect ratio (width / height) of the texture used by the marker asset.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerAsset/methods/MarkerAsset-getAspectRatio.md Edit}
    */
    getAspectRatio(): number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerAsset/methods/MarkerAsset-setExtendedTrackingFilterWeights.md Edit}
    
    * @private
    */
    setExtendedTrackingFilterWeights(measurementWeights: number[], recursiveWeights: number[]): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerAsset/methods/MarkerAsset-setTrackingDebugConfig.md Edit}
    
    * @private
    */
    setTrackingDebugConfig(json: string): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerAsset/properties/MarkerAsset-allowExtendedTracking.md Edit}
    
    * @deprecated
    
    * @private
    */
    allowExtendedTracking: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerAsset/properties/MarkerAsset-extendedTrackingMode.md Edit}
    
    * @private
    */
    extendedTrackingMode: ExtendedTrackingMode
    
    /**
    * The height of the marker asset in real-life centimeters. Used to provide accurate transformation.
    * A [MarkerTrackingComponent](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#MarkerTrackingComponent) using this MarkerAsset will be scaled so that
    * one unit in the SceneObject's local space is equal to one centimeter in real life.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerAsset/properties/MarkerAsset-height.md Edit}
    */
    height: number
    
}

/**
* Base class for marker providers.
* For more information, see the [Marker Tracking](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/world/marker-tracking) guide.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerProvider/MarkerProvider-description.md Edit}
*/
interface MarkerProvider extends Provider {
}

/**
* Used to track images in the camera. Moves the containing object's transform to match the detected image.
* For more information, see the [Marker Tracking](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/tracking/world/marker-tracking) guide.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerTrackingComponent/MarkerTrackingComponent-description.md Edit}
*/
interface MarkerTrackingComponent extends Component {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerTrackingComponent/methods/MarkerTrackingComponent-isMarkerTracking.md Edit}
    
    * @private
    */
    isMarkerTracking(): boolean
    
    /**
    * Returns whether the marker image is currently being tracked in camera.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerTrackingComponent/methods/MarkerTrackingComponent-isTracking.md Edit}
    */
    isTracking(): boolean
    
    /**
    * If true, child objects of this Component's [SceneObject](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#SceneObject) will be disabled when the marker image is not being tracked.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerTrackingComponent/properties/MarkerTrackingComponent-autoEnableWhenTracking.md Edit}
    */
    autoEnableWhenTracking: boolean
    
    /**
    * The marker asset describing the tracking target.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerTrackingComponent/properties/MarkerTrackingComponent-marker.md Edit}
    */
    marker: MarkerAsset
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerTrackingComponent/properties/MarkerTrackingComponent-markerIndex.md Edit}
    
    * @private
    */
    markerIndex: number
    
    /**
    * A function that gets called when marker tracking begins.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerTrackingComponent/properties/MarkerTrackingComponent-onMarkerFound.md Edit}
    */
    onMarkerFound: () => void
    
    /**
    * A function that gets called when marker tracking is lost.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MarkerTrackingComponent/properties/MarkerTrackingComponent-onMarkerLost.md Edit}
    */
    onMarkerLost: () => void
    
}

/**
* Clips visuals and Interaction Component events within a tree hierarchy. Any Visual or Interaction Components will be clipped user defined 2D bounds. These 2D bounds are defined by a Screen Transform. Useful for clipping some screen transforms--for example a scroll view. 

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaskingComponent/MaskingComponent-description.md Edit}
*/
interface MaskingComponent extends BaseMeshVisual {
    /**
    * The radius of the mask's corner.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaskingComponent/properties/MaskingComponent-cornerRadius.md Edit}
    */
    cornerRadius: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaskTextureProvider/MaskTextureProvider-description.md Edit}

* @private
*/
interface MaskTextureProvider extends TextureProvider {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaskTextureProvider/methods/MaskTextureProvider-setKey.md Edit}
    
    * @private
    */
    setKey(name: string): void
    
}

/**
* A 2x2 matrix.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/mat2-description.md Edit}
*/
declare class mat2 {
    /**
    * Creates a new mat2, defaulting to identity values.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-mat2.md Edit}
    */
    constructor()
    
    /**
    * Returns the result of adding the two matrices together.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-add.md Edit}
    */
    add(mat: mat2): mat2
    
    /**
    * Returns the determinant of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-determinant.md Edit}
    */
    determinant(): number
    
    /**
    * Returns the result of dividing the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-div.md Edit}
    */
    div(mat: mat2): mat2
    
    /**
    * Returns whether the two matrices are equal.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-equal.md Edit}
    */
    equal(mat: mat2): boolean
    
    /**
    * Returns the inverse of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-inverse.md Edit}
    */
    inverse(): mat2
    
    /**
    * Returns the result of multiplying the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-mult.md Edit}
    */
    mult(mat: mat2): mat2
    
    /**
    * Returns the result of scalar multiplying the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-multiplyScalar.md Edit}
    */
    multiplyScalar(scalar: number): mat2
    
    /**
    * Returns the result of subtracting the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-sub.md Edit}
    */
    sub(mat: mat2): mat2
    
    /**
    * Returns a string representation of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-toString.md Edit}
    */
    toString(): string
    
    /**
    * Returns the transpose of this matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-transpose.md Edit}
    */
    transpose(): mat2
    
    /**
    * The first column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/properties/mat2-column0.md Edit}
    */
    column0: vec2
    
    /**
    * The second column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/properties/mat2-column1.md Edit}
    */
    column1: vec2
    
    /**
    * Returns a string representation of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/properties/mat2-description.md Edit}
    */
    description: string
    
}
declare namespace mat2 {
    /**
    * Returns the identity matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-identity.md Edit}
    */
    export function identity(): mat2
    
    /**
    * Returns a matrix with all zero values.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat2/methods/mat2-zero.md Edit}
    */
    export function zero(): mat2
    

}

/**
* A 3x3 matrix.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/mat3-description.md Edit}
*/
declare class mat3 {
    /**
    * Creates a new mat3, defaulting to identity values.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-mat3.md Edit}
    */
    constructor()
    
    /**
    * Returns the result of adding the two matrices together.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-add.md Edit}
    */
    add(mat: mat3): mat3
    
    /**
    * Returns the determinant of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-determinant.md Edit}
    */
    determinant(): number
    
    /**
    * Returns the result of dividing the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-div.md Edit}
    */
    div(mat: mat3): mat3
    
    /**
    * Returns whether the two matrices are equal.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-equal.md Edit}
    */
    equal(mat: mat3): boolean
    
    /**
    * Returns the inverse of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-inverse.md Edit}
    */
    inverse(): mat3
    
    /**
    * Returns the result of multiplying the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-mult.md Edit}
    */
    mult(mat: mat3): mat3
    
    /**
    * Returns the result of scalar multiplying the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-multiplyScalar.md Edit}
    */
    multiplyScalar(scalar: number): mat3
    
    /**
    * Returns the result of subtracting the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-sub.md Edit}
    */
    sub(mat: mat3): mat3
    
    /**
    * Returns a string representation of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-toString.md Edit}
    */
    toString(): string
    
    /**
    * Returns the transpose of this matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-transpose.md Edit}
    */
    transpose(): mat3
    
    /**
    * The first column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/properties/mat3-column0.md Edit}
    */
    column0: vec3
    
    /**
    * The second column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/properties/mat3-column1.md Edit}
    */
    column1: vec3
    
    /**
    * The third column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/properties/mat3-column2.md Edit}
    */
    column2: vec3
    
    /**
    * Returns a string representation of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/properties/mat3-description.md Edit}
    */
    description: string
    
}
declare namespace mat3 {
    /**
    * Returns the identity matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-identity.md Edit}
    */
    export function identity(): mat3
    
    /**
    * Returns a matrix representing the specified rotation.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-makeFromRotation.md Edit}
    */
    export function makeFromRotation(arg1: quat): mat3
    
    /**
    * Returns a matrix with all zero values.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat3/methods/mat3-zero.md Edit}
    */
    export function zero(): mat3
    

}

/**
* A 4x4 matrix.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/mat4-description.md Edit}
*/
declare class mat4 {
    /**
    * Creates a new mat4, defaulting to identity values.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-mat4.md Edit}
    */
    constructor()
    
    /**
    * Returns the result of adding the two matrices together.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-add.md Edit}
    */
    add(mat: mat4): mat4
    
    /**
    * Returns the determinant of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-determinant.md Edit}
    */
    determinant(): number
    
    /**
    * Returns the result of dividing the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-div.md Edit}
    */
    div(mat: mat4): mat4
    
    /**
    * Returns whether the two matrices are equal.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-equal.md Edit}
    */
    equal(mat: mat4): boolean
    
    /**
    * Returns an euler angle representation of this matrix's rotation, in radians.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-extractEulerAngles.md Edit}
    */
    extractEulerAngles(): vec3
    
    /**
    * Returns an euler angle representation of this matrix's rotation, in radians.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-extractEulerXYZ.md Edit}
    
    * @deprecated
    */
    extractEulerXYZ(): vec3
    
    /**
    * Returns the inverse of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-inverse.md Edit}
    */
    inverse(): mat4
    
    /**
    * Returns the result of multiplying the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-mult.md Edit}
    */
    mult(mat: mat4): mat4
    
    /**
    * Returns the direction vector multiplied by this matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-multiplyDirection.md Edit}
    */
    multiplyDirection(direction: vec3): vec3
    
    /**
    * Returns the point `point` multiplied by this matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-multiplyPoint.md Edit}
    */
    multiplyPoint(point: vec3): vec3
    
    /**
    * Returns the result of scalar multiplying the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-multiplyScalar.md Edit}
    */
    multiplyScalar(scalar: number): mat4
    
    /**
    * Returns the vector multiplied by this matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-multiplyVector.md Edit}
    */
    multiplyVector(vector: vec4): vec4
    
    /**
    * Returns the result of subtracting the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-sub.md Edit}
    */
    sub(mat: mat4): mat4
    
    /**
    * Returns a string representation of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-toString.md Edit}
    */
    toString(): string
    
    /**
    * Returns the transpose of this matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-transpose.md Edit}
    */
    transpose(): mat4
    
    /**
    * The first column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/properties/mat4-column0.md Edit}
    */
    column0: vec4
    
    /**
    * The second column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/properties/mat4-column1.md Edit}
    */
    column1: vec4
    
    /**
    * The third column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/properties/mat4-column2.md Edit}
    */
    column2: vec4
    
    /**
    * The fourth column of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/properties/mat4-column3.md Edit}
    */
    column3: vec4
    
    /**
    * Returns a string representation of the matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/properties/mat4-description.md Edit}
    */
    description: string
    
}
declare namespace mat4 {
    /**
    * Returns the two matrices multiplied component-wise.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-compMult.md Edit}
    */
    export function compMult(arg1: mat4, arg2: mat4): mat4
    
    /**
    * Returns a new matrix with translation `translation`, rotation `rotation`, and scale `scale`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-compose.md Edit}
    */
    export function compose(translation: vec3, rotation: quat, scale: vec3): mat4
    
    /**
    * Returns a new matrix with the specified euler angles (in radians).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromEulerAngles.md Edit}
    */
    export function fromEulerAngles(euler: vec3): mat4
    
    /**
    * Returns a new matrix with euler angles `euler` (in radians).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromEulerAnglesYXZ.md Edit}
    
    * @deprecated
    */
    export function fromEulerAnglesYXZ(euler: vec3): mat4
    
    /**
    * Returns a new matrix with x euler angle `xAngle` (in radians).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromEulerX.md Edit}
    */
    export function fromEulerX(xAngle: number): mat4
    
    /**
    * Returns a new matrix with y euler angle `yAngle` (in radians).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromEulerY.md Edit}
    */
    export function fromEulerY(yAngle: number): mat4
    
    /**
    * Returns a new matrix with z euler angle `zAngle` (in radians).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromEulerZ.md Edit}
    */
    export function fromEulerZ(zAngle: number): mat4
    
    /**
    * Returns a new matrix with rotation `rotation`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromRotation.md Edit}
    */
    export function fromRotation(rotation: quat): mat4
    
    /**
    * Returns a new matrix with scale `scale`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromScale.md Edit}
    */
    export function fromScale(scale: vec3): mat4
    
    /**
    * Returns a new matrix with the translation `translation`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromTranslation.md Edit}
    */
    export function fromTranslation(translation: vec3): mat4
    
    /**
    * Returns a new matrix with the yaw, pitch, and roll radians found in `yawPitchRoll`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-fromYawPitchRoll.md Edit}
    
    * @deprecated
    */
    export function fromYawPitchRoll(yawPitchRoll: vec3): mat4
    
    /**
    * Returns the identity matrix.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-identity.md Edit}
    */
    export function identity(): mat4
    
    /**
    * Returns a new matrix generated using the provided arguments.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-lookAt.md Edit}
    */
    export function lookAt(eye: vec3, center: vec3, up: vec3): mat4
    
    /**
    * Returns a new matrix using the provided vectors.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-makeBasis.md Edit}
    */
    export function makeBasis(x: vec3, y: vec3, z: vec3): mat4
    
    /**
    * Returns a new matrix generated using the provided arguments.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-orthographic.md Edit}
    */
    export function orthographic(left: number, right: number, bottom: number, top: number, zNear: number, zFar: number): mat4
    
    /**
    * Returns the outer product of the two matrices.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-outerProduct.md Edit}
    */
    export function outerProduct(arg1: vec4, arg2: vec4): mat4
    
    /**
    * Returns a new matrix generated using the provided arguments.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-perspective.md Edit}
    */
    export function perspective(fovY: number, aspect: number, zNear: number, zFar: number): mat4
    
    /**
    * Returns a matrix with all zero values.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/mat4/methods/mat4-zero.md Edit}
    */
    export function zero(): mat4
    

}

/**
* An asset that describes how visual objects should appear.
* Each Material is a collection of [Passes](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#Pass) which define the actual rendering passes.
* Materials are used by [MeshVisuals](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#MeshVisual) for drawing meshes in the scene.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Material/Material-description.md Edit}
*/
interface Material extends Asset {
    /**
    * Returns a copy of the Material.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Material/methods/Material-clone.md Edit}
    */
    clone(): Material
    
    /**
    * Returns the [Pass](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#Pass) of the Material at index `index`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Material/methods/Material-getPass.md Edit}
    */
    getPass(index: number): Pass
    
    /**
    * Returns the number of [Passes](https://lensstudio.snapchat.com/api/lens-studio/Classes/ScriptObjects#Pass) for the Material.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Material/methods/Material-getPassCount.md Edit}
    */
    getPassCount(): number
    
    /**
    * The first Pass of the Material.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Material/properties/Material-mainPass.md Edit}
    */
    mainPass: Pass
    
}

/**
* Base class for all MeshVisual components using [Materials](https://lensstudio.snapchat.com/api/lens-studio/Classes/Assets#Material) to render.
* Comparable to the former class "MeshVisual", which was split into the classes:
* [BaseMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#BaseMeshVisual),
* [MaterialMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Assets#MaterialMeshVisual),
* and [RenderMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#RenderMeshVisual).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaterialMeshVisual/MaterialMeshVisual-description.md Edit}
*/
interface MaterialMeshVisual extends BaseMeshVisual {
    /**
    * Adds a Material to use for rendering.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaterialMeshVisual/methods/MaterialMeshVisual-addMaterial.md Edit}
    */
    addMaterial(material: Material): void
    
    /**
    * Clears all Materials.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaterialMeshVisual/methods/MaterialMeshVisual-clearMaterials.md Edit}
    */
    clearMaterials(): void
    
    /**
    * Returns the Material at index `index`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaterialMeshVisual/methods/MaterialMeshVisual-getMaterial.md Edit}
    */
    getMaterial(index: number): Material
    
    /**
    * Returns the number of Materials used for rendering.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaterialMeshVisual/methods/MaterialMeshVisual-getMaterialsCount.md Edit}
    */
    getMaterialsCount(): number
    
    /**
    * Returns the first Material.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaterialMeshVisual/properties/MaterialMeshVisual-mainMaterial.md Edit}
    */
    mainMaterial: Material
    
    /**
    * Returns the `mainPass` of the `mainMaterial`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaterialMeshVisual/properties/MaterialMeshVisual-mainPass.md Edit}
    */
    mainPass: Pass
    
    /**
    * Get the array of materials used by the MaterialMeshVisual.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MaterialMeshVisual/properties/MaterialMeshVisual-materials.md Edit}
    */
    materials: Material[]
    
}

/**
* Provides useful math utility functions.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MathUtils/MathUtils-description.md Edit}
*/
interface MathUtils {
}
declare namespace MathUtils {
    /**
    * Clamp floating-point value `v` in the range `[lo, hi]` (inclusive).
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MathUtils/methods/MathUtils-clamp.md Edit}
    */
    export function clamp(v: number, lo: number, hi: number): number
    
    /**
    * Linearly interpolate from floating-point `a` to `b`, based on fraction `t` (where t=0.0 returns a, and t=1.0 returns b). This is equivalent to the vec2 and vec3 lerp() functions, but operates on scalar floating-point values.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MathUtils/methods/MathUtils-lerp.md Edit}
    */
    export function lerp(a: number, b: number, time: number): number
    
    /**
    * Generate a random floating-point value in the range `[lo, hi)`. Note, the range is inclusive at the lower end, and exclusive at the upper.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MathUtils/methods/MathUtils-randomRange.md Edit}
    */
    export function randomRange(lo: number, hi: number): number
    
    /**
    * Map floating-point `v` from range [inMin, inMax] to [outMin, outMax].
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MathUtils/methods/MathUtils-remap.md Edit}
    */
    export function remap(v: number, inMin: number, inMax: number, outMin: number, outMax: number): number
    
    /**
    * Constant mapping degrees to radians. This equals pi/180.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MathUtils/properties/MathUtils-DegToRad.md Edit}
    */
    let DegToRad: number
    
    /**
    * Constant mapping radians to degrees. This equals 180/pi.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MathUtils/properties/MathUtils-RadToDeg.md Edit}
    */
    let RadToDeg: number
    

}

/**
* Settings for the physical substance, such as friction and bounciness, of a collider. If unset, uses the default matter from the world settings.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Matter/Matter-description.md Edit}
*/
interface Matter extends Asset {
    /**
    * Bounciness, or restitution, for dynamic bodies. This is the proportion of energy preserved after a collision, in the range 0 to 1. 
    * This defaults to 0.0. Dynamic bounciness should usually be less than 1.0, to prevent energy from accumulating excessively (there is a certain amount of energy gained due to collision response). 
    * The effective bounciness for a collision is the product of both colliding objects. So if your bounciness setting appears to have no effect, it probably means the object it's colliding with has 0 bounciness.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Matter/properties/Matter-dynamicBounciness.md Edit}
    */
    dynamicBounciness: number
    
    /**
    * Coefficient of friction. 
    * The effective friction between two objects is the product of both objects' friction. So for example, the default between two objects is 0.5*0.5=0.25. 
    * Typical ranges are between 0 and 1, but larger values (up to 10) are allowed. This may be used to increase the effective friction when colliding against another object with low friction. 
    * This is a very simplified approximation of realistic friction, since it does not correctly take into account the combined surface characteristics of both objects. It also doesn't distinguish between static and dynamic friction.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Matter/properties/Matter-friction.md Edit}
    */
    friction: number
    
    /**
    * Friction applied to rolling objects. This isn't physically realistic, but helps prevent objects from rolling indefinitely.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Matter/properties/Matter-rollingFriction.md Edit}
    */
    rollingFriction: number
    
    /**
    * Friction applied to spinning objects. This isn't physically realistic, but helps prevent objects from spinning indefinitely.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Matter/properties/Matter-spinningFriction.md Edit}
    */
    spinningFriction: number
    
    /**
    * Bounciness (AKA restitution), for static colliders. This is the proportion of energy preserved after a collision, in the range 0 to 1. 
    * This defaults to 1.0. Typically we use high bounciness for static colliders because they are unaffected by collision, and thus maximally preserve energy. 
    * The effective bounciness for a collision is the product of both colliding objects. So if your bounciness setting appears to have no effect, it probably means the object it's colliding with has 0 bounciness.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/Matter/properties/Matter-staticBounciness.md Edit}
    */
    staticBounciness: number
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaContentType/MediaContentType-description.md Edit}

* @private
*/
declare enum MediaContentType {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaContentType/properties/MediaContentType-None.md Edit}
    
    * @private
    */
    None,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaContentType/properties/MediaContentType-Image.md Edit}
    
    * @private
    */
    Image,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaContentType/properties/MediaContentType-Video.md Edit}
    
    * @private
    */
    Video
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerMode/MediaPickerMode-description.md Edit}

* @private
*/
declare enum MediaPickerMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerMode/properties/MediaPickerMode-PickImage.md Edit}
    
    * @private
    */
    PickImage,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerMode/properties/MediaPickerMode-PickFaceImage.md Edit}
    
    * @private
    */
    PickFaceImage,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerMode/properties/MediaPickerMode-PickVideo.md Edit}
    
    * @private
    */
    PickVideo,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerMode/properties/MediaPickerMode-PickMultipleFacesImage.md Edit}
    
    * @private
    */
    PickMultipleFacesImage
}

/**
* Base class for Texture Providers based on selectable media.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/MediaPickerTextureProvider-description.md Edit}
*/
interface MediaPickerTextureProvider extends TextureProvider {
    /**
    * Requests SDK to hide media picking UI.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/methods/MediaPickerTextureProvider-hideMediaPicker.md Edit}
    */
    hideMediaPicker(): void
    
    /**
    * Requests face mesh and sets a callback to fire when it's ready.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/methods/MediaPickerTextureProvider-setFaceMeshReadyCallback.md Edit}
    */
    setFaceMeshReadyCallback(callback: () => void): void
    
    /**
    * Sets a callback to fire when a file is picked through media picking UI.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/methods/MediaPickerTextureProvider-setFilePickedCallback.md Edit}
    */
    setFilePickedCallback(callback: () => void): void
    
    /**
    * Requests SDK to show media picking UI.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/methods/MediaPickerTextureProvider-showMediaPicker.md Edit}
    */
    showMediaPicker(): void
    
    /**
    * If set to true, MediaPickerTextureProvider will request media picker UI automatically during loading.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-autoShowMediaPicker.md Edit}
    */
    autoShowMediaPicker: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-contentType.md Edit}
    
    * @readonly
    
    * @private
    */
    contentType: MediaContentType
    
    /**
    * If set to true, MediaPickerTextureProvider will provide a proper texture transform for image with face(s), that will "zoom" UVs to the first found face on the image.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-cropFace.md Edit}
    */
    cropFace: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-faceCount.md Edit}
    
    * @readonly
    
    * @private
    */
    faceCount: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-faceFound.md Edit}
    
    * @readonly
    
    * @private
    */
    faceFound: boolean
    
    /**
    * Returns underlying TextureProvider for the last selected media file. If the last media file was not image with at least one face, null is returned.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-faceImageControl.md Edit}
    */
    faceImageControl: FaceTextureProvider
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-faceIndex.md Edit}
    
    * @private
    */
    faceIndex: number
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-faceRect.md Edit}
    
    * @deprecated
    
    * @readonly
    */
    faceRect: vec4
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-faceTextureControl.md Edit}
    
    * @private
    */
    faceTextureControl: FaceTextureProvider
    
    /**
    * Returns underlying TextureProvider for the last selected media file. If the last media file was not image, null is returned.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-imageControl.md Edit}
    
    * @readonly
    */
    imageControl: TextureProvider
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-imageTextureControl.md Edit}
    
    * @readonly
    
    * @private
    */
    imageTextureControl: TextureProvider
    
    /**
    * Returns true if an image is selected, or a video file has been loaded and is ready for decoding, false otherwise.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-isContentReady.md Edit}
    
    * @readonly
    */
    isContentReady: boolean
    
    /**
    * MediaPickerTextureProvider will allow users to select only images with detected faces through media picker UI. See also "cropFace" option.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-isFaceImagePickingEnabled.md Edit}
    */
    isFaceImagePickingEnabled: boolean
    
    /**
    * MediaPickerTextureProvider will allow users to select all images files through media picker UI.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-isImagePickingEnabled.md Edit}
    */
    isImagePickingEnabled: boolean
    
    /**
    * MediaPickerTextureProvider will allow users to select video files through media picker UI.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-isVideoPickingEnabled.md Edit}
    */
    isVideoPickingEnabled: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-multipleFaces.md Edit}
    
    * @private
    */
    multipleFaces: boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-pickerMode.md Edit}
    
    * @private
    */
    pickerMode: MediaPickerMode
    
    /**
    * Returns underlying VideoTextureProvider for the last selected media file. If the last media file was not video, null is returned. 
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-videoControl.md Edit}
    
    * @readonly
    */
    videoControl: VideoTextureProvider
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MediaPickerTextureProvider/properties/MediaPickerTextureProvider-videoTextureControl.md Edit}
    
    * @readonly
    
    * @private
    */
    videoTextureControl: TextureProvider
    
}

/**
* Computes a mel scale spectrogram - a spectrogram where the frequencies are converted to the mel scale.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogram/MelSpectrogram-description.md Edit}
*/
interface MelSpectrogram extends ScriptObject {
    /**
    * Process in tensor with shape, write result to the outTensor and return the shape of outTensor.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogram/methods/MelSpectrogram-process.md Edit}
    */
    process(inTensor: Float32Array, inShape: vec3, outTensor: Float32Array): vec3
    
}

/**
* A builder class for MelSpectrogram.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/MelSpectrogramBuilder-description.md Edit}
*/
interface MelSpectrogramBuilder extends ScriptObject {
    /**
    * Create new MelSpectrogram object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/methods/MelSpectrogramBuilder-build.md Edit}
    */
    build(): MelSpectrogram
    
    /**
    * Set length of the fft window.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/methods/MelSpectrogramBuilder-setFFTSize.md Edit}
    */
    setFFTSize(fftSize: number): MelSpectrogramBuilder
    
    /**
    * Length of the window, which is the length of frameSize and then padded with zeros to match fftSize.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/methods/MelSpectrogramBuilder-setFrameSize.md Edit}
    */
    setFrameSize(frameSize: number): MelSpectrogramBuilder
    
    /**
    * Set number of samples between successive fft segments.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/methods/MelSpectrogramBuilder-setHopSize.md Edit}
    */
    setHopSize(hopSize: number): MelSpectrogramBuilder
    
    /**
    * Set max frequency.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/methods/MelSpectrogramBuilder-setMaxFreq.md Edit}
    */
    setMaxFreq(maxFreq: number): MelSpectrogramBuilder
    
    /**
    * Set min frequency.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/methods/MelSpectrogramBuilder-setMinFreq.md Edit}
    */
    setMinFreq(minFreq: number): MelSpectrogramBuilder
    
    /**
    * Set number of mel bins.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/methods/MelSpectrogramBuilder-setNumMel.md Edit}
    */
    setNumMel(numMel: number): MelSpectrogramBuilder
    
    /**
    * Set number of samples per second.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MelSpectrogramBuilder/methods/MelSpectrogramBuilder-setSampleRate.md Edit}
    */
    setSampleRate(sampleRate: number): MelSpectrogramBuilder
    
}

/**
* A class for generating meshes at runtime.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/MeshBuilder-description.md Edit}
*/
declare class MeshBuilder {
    /**
    * Creates a new MeshBuilder with the specified vertex layout.
    
    * Layout is given as a list of "attribute" objects with the following properties:
    
    * __name__ - Attribute name
    * __components__ - Size of the attribute (how many float values it uses)
    * __normalized__ (optional) - Optional property declaring that the attribute should be normalized
    
    * ```js
    * var builder = new MeshBuilder([
    *     // vertex position (x,y,z)
    *     { name: "position", components: 3 },
    *     // normal vector (x,y,z)
    *     { name: "normal", components: 3, normalized: true },
    *     // texture UV (u,v)
    *     { name: "texture0", components: 2 },
    * ]);
    * ```
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-MeshBuilder.md Edit}
    */
    constructor(layout: any[])
    
    /**
    * Appends indices to the index list.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-appendIndices.md Edit}
    */
    appendIndices(indices: number[]): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-appendIndicesFromTypedArray.md Edit}
    
    * @private
    */
    appendIndicesFromTypedArray(indices: Uint16Array, usedSize: number): void
    
    /**
    * Takes a list of list of vertex values according to the layout.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-appendVertices.md Edit}
    */
    appendVertices(verts: number[][]): void
    
    /**
    * Similar to `appendVertices`, but takes all values in one large array.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-appendVerticesInterleaved.md Edit}
    */
    appendVerticesInterleaved(verts: number[]): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-appendVerticesInterleavedFromTypedArray.md Edit}
    
    * @private
    */
    appendVerticesInterleavedFromTypedArray(verts: Float32Array, usedSize: number): void
    
    /**
    * Removes all indices starting at index `from` and ending before index `to`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-eraseIndices.md Edit}
    */
    eraseIndices(from: number, to: number): void
    
    /**
    * Removes all vertex data starting at vertex index `from` and ending before vertex index `to`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-eraseVertices.md Edit}
    */
    eraseVertices(from: number, to: number): void
    
    /**
    * Returns the number of indices in the index list.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-getIndicesCount.md Edit}
    */
    getIndicesCount(): number
    
    /**
    * Returns a RenderMesh asset that can be applied to a MeshVisual's `mesh` property. This asset stays linked to the MeshBuilder that provided it, so making changes to the mesh data and calling `updateMesh()` will update the RenderMesh as well.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-getMesh.md Edit}
    */
    getMesh(): RenderMesh
    
    /**
    * Returns the number of vertices in the vertex list.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-getVerticesCount.md Edit}
    */
    getVerticesCount(): number
    
    /**
    * Checks whether the current data entered will create a valid mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-isValid.md Edit}
    */
    isValid(): boolean
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-setParameters.md Edit}
    
    * @private
    */
    setParameters(params: any): void
    
    /**
    * Sets data for a single vertex at vertex index `index`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-setVertexInterleaved.md Edit}
    */
    setVertexInterleaved(index: number, verts: number[]): void
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-toString.md Edit}
    
    * @private
    */
    toString(): string
    
    /**
    * Rebuilds the MeshAsset controlled by this MeshBuilder using the current mesh data.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/methods/MeshBuilder-updateMesh.md Edit}
    */
    updateMesh(): void
    
    /**
    * The index data type used by this MeshBuilder. `MeshIndexType.UInt16` is the value normally used for this.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/properties/MeshBuilder-indexType.md Edit}
    */
    indexType: MeshIndexType
    
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/properties/MeshBuilder-meshSerializationEnabled.md Edit}
    
    * @private
    */
    meshSerializationEnabled: boolean
    
    /**
    * The topology type used for the mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshBuilder/properties/MeshBuilder-topology.md Edit}
    */
    topology: MeshTopology
    
}

/**
* Formats of mesh classification used by WorldRenderObjectProvider.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshClassificationFormat/MeshClassificationFormat-description.md Edit}
*/
declare enum MeshClassificationFormat {
    /**
    * Do not bake classifications to mesh
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshClassificationFormat/properties/MeshClassificationFormat-None.md Edit}
    */
    None,
    /**
    * Classifications are baked per vertex - vertices with multiple classes will use the value from the last face
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshClassificationFormat/properties/MeshClassificationFormat-PerVertexFast.md Edit}
    */
    PerVertexFast
}

/**
* Possible index data types used by [MeshBuilder](https://lensstudio.snapchat.com/api/lens-studio/Classes/OtherClasses#MeshBuilder). `MeshIndexType.UInt16` is the value normally used.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshIndexType/MeshIndexType-description.md Edit}
*/
declare enum MeshIndexType {
    /**
    * No index data type
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshIndexType/properties/MeshIndexType-None.md Edit}
    */
    None,
    /**
    * Unsigned integer, this is the value normally used
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshIndexType/properties/MeshIndexType-UInt16.md Edit}
    */
    UInt16
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshRenderObjectProvider/MeshRenderObjectProvider-description.md Edit}
*/
interface MeshRenderObjectProvider extends RenderObjectProvider {
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshShadowMode/MeshShadowMode-description.md Edit}
*/
declare enum MeshShadowMode {
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshShadowMode/properties/MeshShadowMode-None.md Edit}
    */
    None,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshShadowMode/properties/MeshShadowMode-Caster.md Edit}
    */
    Caster,
    /**
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshShadowMode/properties/MeshShadowMode-Receiver.md Edit}
    */
    Receiver
}

/**
* Allows meshes to be used as collision shapes, for ColliderComponent and BodyComponent.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshShape/MeshShape-description.md Edit}
*/
interface MeshShape extends Shape {
    /**
    * Bake mesh as a convex hull, generated from mesh colliders. This allows for irregular shapes to be used as dynamic bodies.
    
    **Limitations:**
    
    * They are non-deforming. A hull may be generated from a deforming render mesh, but it will not deform with it. Because of this, intrinsically deforming mesh types will not work as convex hulls. For instance world and face meshes. In these cases the convex hull will exist, but be empty and wont simulate.
    
    * It produces an approximation of the source mesh, reducing triangle count and eliminating concave areas.
    * Concave shapes may be composed of convex hulls in the scene graph. Splitting a concave mesh into convex hulls is known as "convex decomposition". It is an expensive process not supported by Studio, but there are many standalone tools available for this purpose (including plugins for 3D modeling apps). The resulting split mesh can be imported into Studio as a prefab.
    
    * Original triangle data is lost, so it is not available to script in ray casts.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshShape/properties/MeshShape-convex.md Edit}
    */
    convex: boolean
    
    /**
    * Sets geometry from a render mesh. The render mesh is automatically converted to a collision mesh.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshShape/properties/MeshShape-mesh.md Edit}
    */
    mesh: RenderMesh
    
    /**
    * Specifies skinning component used to animate skinned meshes.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshShape/properties/MeshShape-skin.md Edit}
    */
    skin: Skin
    
}

/**
* Mesh topology types used by [MeshBuilder](https://lensstudio.snapchat.com/api/lens-studio/Classes/OtherClasses#MeshBuilder).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshTopology/MeshTopology-description.md Edit}
*/
declare enum MeshTopology {
    /**
    * Draws unconnected line segments. Each group of two vertices specifies a new line segment.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshTopology/properties/MeshTopology-Lines.md Edit}
    */
    Lines,
    /**
    * Draws connected line segments. Starting with the second vertex, a line is drawn between each vertex and the preceding one.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshTopology/properties/MeshTopology-LineStrip.md Edit}
    */
    LineStrip,
    /**
    * Draws individual points. Each vertex specifies a new point to draw.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshTopology/properties/MeshTopology-Points.md Edit}
    */
    Points,
    /**
    * Draws unconnected triangles. Each group of three vertices specifies a new triangle.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshTopology/properties/MeshTopology-Triangles.md Edit}
    */
    Triangles,
    /**
    * Draws connected triangles sharing one central vertex. The first vertex is the shared one, or "hub" vertex. Starting with the third vertex, each vertex forms a triangle connecting with the previous vertex and hub vertex.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshTopology/properties/MeshTopology-TriangleFan.md Edit}
    */
    TriangleFan,
    /**
    * Draws connected triangles in a strip. After the first two vertices, each vertex defines the third point on a new triangle extending from the previous one.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshTopology/properties/MeshTopology-TriangleStrip.md Edit}
    */
    TriangleStrip
}

/**
* This class has been DEPRECATED starting in Lens Studio 2.3.
* The `Component.MeshVisual` typename is now an alias for [BaseMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#BaseMeshVisual).
* When upgrading a project to Lens Studio 2.3 or higher, any instances of the MeshVisual component will be upgraded to [RenderMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#RenderMeshVisual).

* This class was split into the following three classes, to better distinguish the behaviors of child classes.

* [BaseMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#BaseMeshVisual): Base class for all visual classes using meshes to render

* [MaterialMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Assets#MaterialMeshVisual): Child class of BaseMeshVisual, gives access to the [Materials](https://lensstudio.snapchat.com/api/lens-studio/Classes/Assets#Material) used to render

* [RenderMeshVisual](https://lensstudio.snapchat.com/api/lens-studio/Classes/Components#RenderMeshVisual): Child class of MaterialMeshVisual, gives access to the [RenderMesh](https://lensstudio.snapchat.com/api/lens-studio/Classes/Assets#RenderMesh) used to render

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MeshVisual/MeshVisual-description.md Edit}
*/
interface MeshVisual extends Component {
}

/**
* Mel-frequency cepstral coefficients.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCC/MFCC-description.md Edit}
*/
interface MFCC extends ScriptObject {
    /**
    * Process in tensor with `shape`, write result to the `outTensor`, and returns the shape of `outTensor`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCC/methods/MFCC-process.md Edit}
    */
    process(inTensor: Float32Array, inShape: vec3, outTensor: Float32Array): vec3
    
    /**
    * Max tensor size.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCC/properties/MFCC-maxTensorSize.md Edit}
    
    * @readonly
    */
    maxTensorSize: number
    
}

/**
* Builder class for the MFCC (Mel Frequency Cepstral Co-efficients).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/MFCCBuilder-description.md Edit}
*/
interface MFCCBuilder extends ScriptObject {
    /**
    * Create a new MFCC object.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-build.md Edit}
    */
    build(): MFCC
    
    /**
    * Sets the length of the FFT window.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setFFTSize.md Edit}
    */
    setFFTSize(fftSize: number): MFCCBuilder
    
    /**
    * Length of the window, the window will be the length of frameSize and then padded with zeros to mach FFTSize.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setFrameSize.md Edit}
    */
    setFrameSize(frameSize: number): MFCCBuilder
    
    /**
    * Sets the number of samples between successive FFT segments.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setHopSize.md Edit}
    */
    setHopSize(hopSize: number): MFCCBuilder
    
    /**
    * If lifter > 0, apply liftering to the MFCCs.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setLifter.md Edit}
    */
    setLifter(lifter: number): MFCCBuilder
    
    /**
    * Sets the max frequency.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setMaxFreq.md Edit}
    */
    setMaxFreq(maxFreq: number): MFCCBuilder
    
    /**
    * Sets the min frequency.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setMinFreq.md Edit}
    */
    setMinFreq(minFreq: number): MFCCBuilder
    
    /**
    * Sets the number of MFCCs to return.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setNumMFCC.md Edit}
    */
    setNumMFCC(numMFCC: number): MFCCBuilder
    
    /**
    * Sets number of mel bins.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setNumMel.md Edit}
    */
    setNumMel(numMel: number): MFCCBuilder
    
    /**
    * Sets the number of samples per second.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MFCCBuilder/methods/MFCCBuilder-setSampleRate.md Edit}
    */
    setSampleRate(sampleRate: number): MFCCBuilder
    
}

/**
* The Audio Track Provider of the audio from microphone.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MicrophoneAudioProvider/MicrophoneAudioProvider-description.md Edit}
*/
interface MicrophoneAudioProvider extends AudioTrackProvider {
    /**
    * Writes current frame audio data to the passed in `Float32Array` and returns its shape. The length of the array can't be more than `maxFrameSize`.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MicrophoneAudioProvider/methods/MicrophoneAudioProvider-getAudioFrame.md Edit}
    
    * @exposesUserData
    */
    getAudioFrame(audioFrame: Float32Array): vec3
    
    /**
    * Start processing audio from microphone. Useful to avoid redundant processing.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MicrophoneAudioProvider/methods/MicrophoneAudioProvider-start.md Edit}
    */
    start(): void
    
    /**
    * Stop processing audio from microphone.
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MicrophoneAudioProvider/methods/MicrophoneAudioProvider-stop.md Edit}
    */
    stop(): void
    
}

/**
* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MicrophoneRawModule/MicrophoneRawModule-description.md Edit}

* @private
*/
interface MicrophoneRawModule extends Asset {
}

/**
* Binary ML model supplied by the user.

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MLAsset/MLAsset-description.md Edit}
*/
interface MLAsset extends BinAsset {
    /**
    * Returns model metadata as JSON object. 
    
    
    * {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/main/api_generation/./api_scenarium/input/api_text_descriptions/MLAsset/methods/MLAsset-getMetadata.md Edit}
    */
    getMetadata(): object
    
}

/**
* Transforms inputs (Textures or Float32Array) into outputs (Textures or Float32Array) using a neural network.
* The neural network is represented by an MLAsset, which is set as the `model` property.
* For more information, see the [MLComponent Overview](https://lensstudio.snapchat.com/lens-studio/references/guides/lens-features/machine-learning/ml-component/ml-component-overview).

* {@link https://github.sc-corp.net/Snapchat/studio3d-documentation/edit/ma