//@input Component.RenderMeshVisual renderMeshVisual
/** @type {RenderMeshVisual} */
var renderMeshVisual = script.renderMeshVisual;

//@input Physics.ColliderComponent collider
/** @type {ColliderComponent} */
var collider = script.collider;

//@input Component.Text text
/** @type {Text} */
var text = script.text;

//@input Asset.Material horizontalPlaneMat
/** @type {Material} */
var horizontalPlaneMat = script.horizontalPlaneMat;

//@input Asset.Material verticalPlaneMat
/** @type {Material} */
var verticalPlaneMat = script.verticalPlaneMat;

var trackedPlane;

/**
 * @param {TrackedPlane}
 */
function init(myTrackedPlane){

    trackedPlane = myTrackedPlane;
    collider.debugDrawEnabled = false; // debug

    switch(trackedPlane.orientation) {
        case TrackedPlaneOrientation.Horizontal: 
            text.text = ("Horizontal");
            renderMeshVisual.mainMaterial = horizontalPlaneMat;
            break;
        case TrackedPlaneOrientation.Vertical: 
            text.text = ("Vertical");
            renderMeshVisual.mainMaterial = verticalPlaneMat;
            break;
        default:
            text.text =("Undefined");
    } 
}

/**
 * 
 * @returns {TrackedPlane}
 */
function getTrackedPlane() {
    return trackedPlane;
}

/**
 * @typedef PlaneObj
 * @property {()=>Transform} getTransform
 * @property {()=>TrackedPlane} getTrackedPlane
 * @property {(myTrackedPlane:TrackedPlane)=>void} init
 */

script.getTrackedPlane = getTrackedPlane;
script.init = init;