/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.ParameterMode;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class QueryParameterHelper
implements Serializable {
    private static final long serialVersionUID = -283738274937293739L;
    private final ParameterMode mode;
    private final ImmutableMap<String, QueryParameterValue> namedParameters;
    private final ImmutableList<QueryParameterValue> positionalParameters;

    public QueryParameterHelper(ParameterMode mode, ImmutableMap<String, QueryParameterValue> named, ImmutableList<QueryParameterValue> positional) {
        this.mode = mode;
        this.namedParameters = named;
        this.positionalParameters = positional;
    }

    static QueryParameterHelper none() {
        return new QueryParameterHelper(ParameterMode.NONE, ImmutableMap.of(), ImmutableList.of());
    }

    static QueryParameterHelper named(Map<String, QueryParameterValue> namedParameters) {
        Preconditions.checkNotNull(namedParameters, "Input named parameters map cannot be null for named mode");
        return new QueryParameterHelper(ParameterMode.NAMED, ImmutableMap.copyOf(namedParameters), ImmutableList.of());
    }

    static QueryParameterHelper positional(List<QueryParameterValue> positionalParameters) {
        Preconditions.checkNotNull(positionalParameters, "Input positional parameters list cannot be null for positional mode");
        return new QueryParameterHelper(ParameterMode.POSITIONAL, ImmutableMap.of(), ImmutableList.copyOf(positionalParameters));
    }

    public ParameterMode getMode() {
        return this.mode;
    }

    public Optional<ImmutableMap<String, QueryParameterValue>> getNamedParameters() {
        return this.mode == ParameterMode.NAMED ? Optional.of(this.namedParameters) : Optional.empty();
    }

    public Optional<ImmutableList<QueryParameterValue>> getPositionalParameters() {
        return this.mode == ParameterMode.POSITIONAL ? Optional.of(this.positionalParameters) : Optional.empty();
    }

    public boolean isEmpty() {
        return this.mode == ParameterMode.NONE;
    }

    public QueryJobConfiguration.Builder configureBuilder(QueryJobConfiguration.Builder builder) {
        Preconditions.checkNotNull(builder, "QueryJobConfiguration.Builder cannot be null");
        this.namedParameters.forEach((paramName, paramValue) -> builder.addNamedParameter((String)paramName, (QueryParameterValue)paramValue));
        this.positionalParameters.forEach(paramValue -> builder.addPositionalParameter((QueryParameterValue)paramValue));
        return builder;
    }
}

