/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.ObsoleteApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.AutoValue_TimedAttemptSettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.util.TimeConversionUtils;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.AutoValue;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.bp.Duration;

@AutoValue
public abstract class TimedAttemptSettings {
    public abstract RetrySettings getGlobalSettings();

    @ObsoleteApi(value="Use getRetryDelayDuration() instead")
    public final Duration getRetryDelay() {
        return TimeConversionUtils.toThreetenDuration(this.getRetryDelayDuration());
    }

    public abstract java.time.Duration getRetryDelayDuration();

    @ObsoleteApi(value="Use getRpcTimeoutDuration() instead")
    public final Duration getRpcTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getRpcTimeoutDuration());
    }

    public abstract java.time.Duration getRpcTimeoutDuration();

    @ObsoleteApi(value="Use getRandomizedRetryDelayDuration() instead")
    public final Duration getRandomizedRetryDelay() {
        return TimeConversionUtils.toThreetenDuration(this.getRandomizedRetryDelayDuration());
    }

    public abstract java.time.Duration getRandomizedRetryDelayDuration();

    public abstract int getAttemptCount();

    public abstract int getOverallAttemptCount();

    public abstract long getFirstAttemptStartTimeNanos();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_TimedAttemptSettings.Builder().setOverallAttemptCount(0);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setGlobalSettings(RetrySettings var1);

        @ObsoleteApi(value="Use setRetryDelayDuration(java.time.Duration) instead")
        public final Builder setRetryDelay(Duration value) {
            return this.setRetryDelayDuration(TimeConversionUtils.toJavaTimeDuration(value));
        }

        public abstract Builder setRetryDelayDuration(java.time.Duration var1);

        @ObsoleteApi(value="Use setRpcTimeoutDuration(java.time.Duration) instead")
        public final Builder setRpcTimeout(Duration value) {
            return this.setRpcTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(value));
        }

        public abstract Builder setRpcTimeoutDuration(java.time.Duration var1);

        @ObsoleteApi(value="Use setRandomizedRetryDelayDuration(java.time.Duration) instead")
        public final Builder setRandomizedRetryDelay(Duration value) {
            return this.setRandomizedRetryDelayDuration(TimeConversionUtils.toJavaTimeDuration(value));
        }

        public abstract Builder setRandomizedRetryDelayDuration(java.time.Duration var1);

        public abstract Builder setAttemptCount(int var1);

        public abstract Builder setOverallAttemptCount(int var1);

        public abstract Builder setFirstAttemptStartTimeNanos(long var1);

        public abstract TimedAttemptSettings build();
    }
}

