/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.DecompressReadRowsResponse;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ReadRowsResponseInputStreamEnumeration
implements Enumeration<InputStream> {
    private final Iterator<ReadRowsResponse> responses;
    private ReadRowsResponse currentResponse;
    private final BigQueryStorageReadRowsTracer tracer;
    private final ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec;

    public ReadRowsResponseInputStreamEnumeration(Iterator<ReadRowsResponse> responses, BigQueryStorageReadRowsTracer tracer, ReadSession.TableReadOptions.ResponseCompressionCodec compressionCodec) {
        this.responses = responses;
        this.tracer = tracer;
        this.responseCompressionCodec = compressionCodec;
        this.loadNextResponse();
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentResponse != null;
    }

    @Override
    public InputStream nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more responses");
        }
        ReadRowsResponse ret = this.currentResponse;
        this.loadNextResponse();
        try {
            return DecompressReadRowsResponse.decompressArrowRecordBatch(ret, this.responseCompressionCodec);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read rows", e);
        }
    }

    void loadNextResponse() {
        this.tracer.readRowsResponseRequested();
        this.currentResponse = this.responses.hasNext() ? this.responses.next() : null;
        this.tracer.readRowsResponseObtained(this.currentResponse == null ? 0L : (long)this.currentResponse.getArrowRecordBatch().getSerializedRecordBatch().size());
    }
}

