/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Preconditions;
import java.io.IOException;

public final class BasicAuthentication
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final String username;
    private final String password;

    public BasicAuthentication(String username, String password) {
        this.username = Preconditions.checkNotNull(username);
        this.password = Preconditions.checkNotNull(password);
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(this);
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        request.getHeaders().setBasicAuthentication(this.username, this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

