/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.spark.bigquery.v2.Spark31BigQueryDataWriterFactory;
import com.google.cloud.spark.bigquery.v2.Spark31BigQueryWriterCommitMessage;
import com.google.cloud.spark.bigquery.write.context.DataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.WriterCommitMessageContext;
import java.util.stream.Stream;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;

public class BigQueryBatchWrite
implements BatchWrite {
    private DataSourceWriterContext ctx;

    public BigQueryBatchWrite(DataSourceWriterContext ctx) {
        this.ctx = ctx;
    }

    public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
        return new Spark31BigQueryDataWriterFactory(this.ctx.createWriterContextFactory());
    }

    public void onDataWriterCommit(WriterCommitMessage message) {
        this.ctx.onDataWriterCommit(this.toWriterCommitMessageContext(message));
    }

    public void commit(WriterCommitMessage[] messages) {
        this.ctx.commit(this.toWriterCommitMessageContextArray(messages));
    }

    public void abort(WriterCommitMessage[] messages) {
        this.ctx.abort(this.toWriterCommitMessageContextArray(messages));
    }

    private WriterCommitMessageContext toWriterCommitMessageContext(WriterCommitMessage message) {
        return ((Spark31BigQueryWriterCommitMessage)message).getContext();
    }

    private WriterCommitMessageContext[] toWriterCommitMessageContextArray(WriterCommitMessage[] messages) {
        return (WriterCommitMessageContext[])Stream.of(messages).map(this::toWriterCommitMessageContext).toArray(WriterCommitMessageContext[]::new);
    }
}

