/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.memoized.processor;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.service.AutoService;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.memoized.Memoized"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
public final class MemoizedValidator
extends AbstractProcessor {
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        TypeElement memoized = this.processingEnv.getElementUtils().getTypeElement("com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.memoized.Memoized");
        for (ExecutableElement method : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(memoized))) {
            if (MemoizedValidator.isAutoValue(method.getEnclosingElement())) continue;
            messager.printMessage(Diagnostic.Kind.ERROR, "@Memoized methods must be declared only in @AutoValue classes", method, MemoizedValidator.getAnnotationMirror(method, "com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.memoized.Memoized").get());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private static boolean isAutoValue(Element element) {
        return element.getAnnotationMirrors().stream().map(annotation -> MoreTypes.asTypeElement(annotation.getAnnotationType())).anyMatch(type -> type.getQualifiedName().contentEquals("com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.AutoValue"));
    }

    static Optional<AnnotationMirror> getAnnotationMirror(Element element, String annotationName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationElement = MoreTypes.asTypeElement(annotationMirror.getAnnotationType());
            if (!annotationElement.getQualifiedName().contentEquals(annotationName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }
}

