/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.grpc.util;

import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.errorprone.annotations.InlineMe;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ExperimentalApi;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.util.CertificateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public final class AdvancedTlsX509KeyManager
extends X509ExtendedKeyManager {
    private static final Logger log = Logger.getLogger(AdvancedTlsX509KeyManager.class.getName());
    private static final int MINIMUM_REFRESH_PERIOD_IN_MINUTES = 1;
    private volatile KeyInfo keyInfo;

    @Override
    public PrivateKey getPrivateKey(String alias) {
        if (alias.equals("default")) {
            return this.keyInfo.key;
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (alias.equals("default")) {
            return Arrays.copyOf(this.keyInfo.certs, this.keyInfo.certs.length);
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return new String[]{"default"};
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return "default";
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return "default";
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return new String[]{"default"};
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return "default";
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return "default";
    }

    @Deprecated
    @InlineMe(replacement="this.updateIdentityCredentials(certs, key)")
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8024")
    public void updateIdentityCredentials(PrivateKey key, X509Certificate[] certs) {
        this.updateIdentityCredentials(certs, key);
    }

    public void updateIdentityCredentials(X509Certificate[] certs, PrivateKey key) {
        this.keyInfo = new KeyInfo(Preconditions.checkNotNull(certs, "certs"), Preconditions.checkNotNull(key, "key"));
    }

    public Closeable updateIdentityCredentials(File certFile, File keyFile, long period, TimeUnit unit, ScheduledExecutorService executor) throws IOException, GeneralSecurityException {
        UpdateResult newResult = this.readAndUpdate(certFile, keyFile, 0L, 0L);
        if (!newResult.success) {
            throw new GeneralSecurityException("Files were unmodified before their initial update. Probably a bug.");
        }
        if (Preconditions.checkNotNull(unit, "unit").toMinutes(period) < 1L) {
            log.log(Level.FINE, "Provided refresh period of {0} {1} is too small. Default value of {2} minute(s) will be used.", new Object[]{period, unit.name(), 1});
            period = 1L;
            unit = TimeUnit.MINUTES;
        }
        ScheduledFuture<?> future = Preconditions.checkNotNull(executor, "executor").scheduleWithFixedDelay(new LoadFilePathExecution(certFile, keyFile), period, period, unit);
        return () -> future.cancel(false);
    }

    public void updateIdentityCredentials(File certFile, File keyFile) throws IOException, GeneralSecurityException {
        UpdateResult newResult = this.readAndUpdate(certFile, keyFile, 0L, 0L);
        if (!newResult.success) {
            throw new GeneralSecurityException("Files were unmodified before their initial update. Probably a bug.");
        }
    }

    @Deprecated
    @InlineMe(replacement="this.updateIdentityCredentials(certFile, keyFile)")
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8024")
    public void updateIdentityCredentialsFromFile(File keyFile, File certFile) throws IOException, GeneralSecurityException {
        this.updateIdentityCredentials(certFile, keyFile);
    }

    @Deprecated
    @InlineMe(replacement="this.updateIdentityCredentials(certFile, keyFile, period, unit, executor)")
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/8024")
    public Closeable updateIdentityCredentialsFromFile(File keyFile, File certFile, long period, TimeUnit unit, ScheduledExecutorService executor) throws IOException, GeneralSecurityException {
        return this.updateIdentityCredentials(certFile, keyFile, period, unit, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult readAndUpdate(File certFile, File keyFile, long oldKeyTime, long oldCertTime) throws IOException, GeneralSecurityException {
        long newKeyTime = Preconditions.checkNotNull(keyFile, "keyFile").lastModified();
        long newCertTime = Preconditions.checkNotNull(certFile, "certFile").lastModified();
        if (newKeyTime != oldKeyTime && newCertTime != oldCertTime) {
            try (FileInputStream keyInputStream = new FileInputStream(keyFile);){
                UpdateResult updateResult;
                PrivateKey key = CertificateUtils.getPrivateKey(keyInputStream);
                FileInputStream certInputStream = new FileInputStream(certFile);
                try {
                    X509Certificate[] certs = CertificateUtils.getX509Certificates(certInputStream);
                    this.updateIdentityCredentials(certs, key);
                    updateResult = new UpdateResult(true, newKeyTime, newCertTime);
                }
                catch (Throwable throwable) {
                    certInputStream.close();
                    throw throwable;
                }
                certInputStream.close();
                return updateResult;
            }
        }
        return new UpdateResult(false, oldKeyTime, oldCertTime);
    }

    public static interface Closeable
    extends java.io.Closeable {
        @Override
        public void close();
    }

    private static class UpdateResult {
        boolean success;
        long certTime;
        long keyTime;

        public UpdateResult(boolean success, long certTime, long keyTime) {
            this.success = success;
            this.certTime = certTime;
            this.keyTime = keyTime;
        }
    }

    private class LoadFilePathExecution
    implements Runnable {
        File keyFile;
        File certFile;
        long currentCertTime;
        long currentKeyTime;

        public LoadFilePathExecution(File certFile, File keyFile) {
            this.certFile = certFile;
            this.keyFile = keyFile;
            this.currentCertTime = 0L;
            this.currentKeyTime = 0L;
        }

        @Override
        public void run() {
            try {
                UpdateResult newResult = AdvancedTlsX509KeyManager.this.readAndUpdate(this.certFile, this.keyFile, this.currentKeyTime, this.currentCertTime);
                if (newResult.success) {
                    this.currentCertTime = newResult.certTime;
                    this.currentKeyTime = newResult.keyTime;
                }
            }
            catch (IOException | GeneralSecurityException e) {
                log.log(Level.SEVERE, String.format("Failed refreshing certificate and private key chain from files. Using previous ones (certFile lastModified = %s, keyFile lastModified = %s)", this.certFile.lastModified(), this.keyFile.lastModified()), e);
            }
        }
    }

    private static class KeyInfo {
        final X509Certificate[] certs;
        final PrivateKey key;

        public KeyInfo(X509Certificate[] certs, PrivateKey key) {
            this.certs = certs;
            this.key = key;
        }
    }
}

