/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo;

import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.annotation.JsonSubTypes;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.flatbuffers.FlatBufferBuilder;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Field;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Struct_;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.BufferAllocator;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.FieldVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.DateUnit;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.FloatingPointPrecision;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.IntervalUnit;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.TimeUnit;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.UnionMode;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.FieldType;
import java.util.Arrays;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Null.class, name="null"), @JsonSubTypes.Type(value=Struct.class, name="struct"), @JsonSubTypes.Type(value=List.class, name="list"), @JsonSubTypes.Type(value=LargeList.class, name="largelist"), @JsonSubTypes.Type(value=FixedSizeList.class, name="fixedsizelist"), @JsonSubTypes.Type(value=Union.class, name="union"), @JsonSubTypes.Type(value=Map.class, name="map"), @JsonSubTypes.Type(value=Int.class, name="int"), @JsonSubTypes.Type(value=FloatingPoint.class, name="floatingpoint"), @JsonSubTypes.Type(value=Utf8.class, name="utf8"), @JsonSubTypes.Type(value=Utf8View.class, name="utf8view"), @JsonSubTypes.Type(value=LargeUtf8.class, name="largeutf8"), @JsonSubTypes.Type(value=Binary.class, name="binary"), @JsonSubTypes.Type(value=BinaryView.class, name="binaryview"), @JsonSubTypes.Type(value=LargeBinary.class, name="largebinary"), @JsonSubTypes.Type(value=FixedSizeBinary.class, name="fixedsizebinary"), @JsonSubTypes.Type(value=Bool.class, name="bool"), @JsonSubTypes.Type(value=Decimal.class, name="decimal"), @JsonSubTypes.Type(value=Date.class, name="date"), @JsonSubTypes.Type(value=Time.class, name="time"), @JsonSubTypes.Type(value=Timestamp.class, name="timestamp"), @JsonSubTypes.Type(value=Interval.class, name="interval"), @JsonSubTypes.Type(value=Duration.class, name="duration"), @JsonSubTypes.Type(value=ListView.class, name="listview")})
public abstract class ArrowType {
    private static final int defaultDecimalBitWidth = 128;

    @JsonIgnore
    public abstract ArrowTypeID getTypeID();

    @JsonIgnore
    public abstract boolean isComplex();

    public abstract int getType(FlatBufferBuilder var1);

    public abstract <T> T accept(ArrowTypeVisitor<T> var1);

    public static ArrowType getTypeForField(Field field) {
        switch (field.typeType()) {
            case 1: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Null nullType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Null)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Null());
                return new Null();
            }
            case 13: {
                Struct_ struct_Type = (Struct_)field.type(new Struct_());
                return new Struct();
            }
            case 12: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.List listType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.List)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.List());
                return new List();
            }
            case 21: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeList largelistType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeList)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeList());
                return new LargeList();
            }
            case 16: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeList fixedsizelistType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeList)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeList());
                int listSize = fixedsizelistType.listSize();
                return new FixedSizeList(listSize);
            }
            case 14: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Union unionType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Union)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Union());
                short mode = unionType.mode();
                int[] typeIds = new int[unionType.typeIdsLength()];
                for (int i = 0; i < typeIds.length; ++i) {
                    typeIds[i] = unionType.typeIds(i);
                }
                return new Union(UnionMode.fromFlatbufID(mode), typeIds);
            }
            case 17: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Map mapType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Map)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Map());
                boolean keysSorted = mapType.keysSorted();
                return new Map(keysSorted);
            }
            case 2: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int intType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int());
                int bitWidth = intType.bitWidth();
                boolean isSigned = intType.isSigned();
                return new Int(bitWidth, isSigned);
            }
            case 3: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FloatingPoint floatingpointType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FloatingPoint)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FloatingPoint());
                short precision = floatingpointType.precision();
                return new FloatingPoint(FloatingPointPrecision.fromFlatbufID(precision));
            }
            case 5: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8 utf8Type = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8());
                return new Utf8();
            }
            case 24: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8View utf8viewType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8View)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8View());
                return new Utf8View();
            }
            case 20: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeUtf8 largeutf8Type = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeUtf8)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeUtf8());
                return new LargeUtf8();
            }
            case 4: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Binary binaryType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Binary)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Binary());
                return new Binary();
            }
            case 23: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.BinaryView binaryviewType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.BinaryView)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.BinaryView());
                return new BinaryView();
            }
            case 19: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeBinary largebinaryType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeBinary)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeBinary());
                return new LargeBinary();
            }
            case 15: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeBinary fixedsizebinaryType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeBinary)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeBinary());
                int byteWidth = fixedsizebinaryType.byteWidth();
                return new FixedSizeBinary(byteWidth);
            }
            case 6: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Bool boolType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Bool)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Bool());
                return new Bool();
            }
            case 7: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Decimal decimalType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Decimal)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Decimal());
                int precision = decimalType.precision();
                int scale = decimalType.scale();
                int bitWidth = decimalType.bitWidth();
                if (bitWidth != 128 && bitWidth != 256) {
                    throw new IllegalArgumentException("Library only supports 128-bit and 256-bit decimal values");
                }
                return new Decimal(precision, scale, bitWidth);
            }
            case 8: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Date dateType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Date)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Date());
                short unit = dateType.unit();
                return new Date(DateUnit.fromFlatbufID(unit));
            }
            case 9: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Time timeType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Time)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Time());
                short unit = timeType.unit();
                int bitWidth = timeType.bitWidth();
                return new Time(TimeUnit.fromFlatbufID(unit), bitWidth);
            }
            case 10: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Timestamp timestampType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Timestamp)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Timestamp());
                short unit = timestampType.unit();
                String timezone = timestampType.timezone();
                return new Timestamp(TimeUnit.fromFlatbufID(unit), timezone);
            }
            case 11: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Interval intervalType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Interval)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Interval());
                short unit = intervalType.unit();
                return new Interval(IntervalUnit.fromFlatbufID(unit));
            }
            case 18: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Duration durationType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Duration)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Duration());
                short unit = durationType.unit();
                return new Duration(TimeUnit.fromFlatbufID(unit));
            }
            case 25: {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.ListView listviewType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.ListView)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.ListView());
                return new ListView();
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + field.typeType());
    }

    public static Int getInt(Field field) {
        com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int intType = (com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int)field.type(new com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int());
        return new Int(intType.bitWidth(), intType.isSigned());
    }

    public static class Null
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Null;
        public static final Null INSTANCE = new Null();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Null.startNull(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Null.endNull(builder);
        }

        public String toString() {
            return "Null";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof Null;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Struct
    extends ComplexType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Struct;
        public static final Struct INSTANCE = new Struct();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            Struct_.startStruct_(builder);
            return Struct_.endStruct_(builder);
        }

        public String toString() {
            return "Struct";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof Struct;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class List
    extends ComplexType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.List;
        public static final List INSTANCE = new List();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.List.startList(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.List.endList(builder);
        }

        public String toString() {
            return "List";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof List;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class LargeList
    extends ComplexType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.LargeList;
        public static final LargeList INSTANCE = new LargeList();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeList.startLargeList(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeList.endLargeList(builder);
        }

        public String toString() {
            return "LargeList";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof LargeList;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class FixedSizeList
    extends ComplexType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.FixedSizeList;
        int listSize;

        @JsonCreator
        public FixedSizeList(@JsonProperty(value="listSize") int listSize) {
            this.listSize = listSize;
        }

        public int getListSize() {
            return this.listSize;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeList.startFixedSizeList(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeList.addListSize(builder, this.listSize);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeList.endFixedSizeList(builder);
        }

        public String toString() {
            return "FixedSizeList(" + this.listSize + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.listSize});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FixedSizeList)) {
                return false;
            }
            FixedSizeList that = (FixedSizeList)obj;
            return Objects.deepEquals(this.listSize, that.listSize);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Union
    extends ComplexType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Union;
        UnionMode mode;
        int[] typeIds;

        @JsonCreator
        public Union(@JsonProperty(value="mode") UnionMode mode, @JsonProperty(value="typeIds") int[] typeIds) {
            this.mode = mode;
            this.typeIds = typeIds;
        }

        public UnionMode getMode() {
            return this.mode;
        }

        public int[] getTypeIds() {
            return this.typeIds;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            int typeIds = this.typeIds == null ? -1 : com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Union.createTypeIdsVector(builder, this.typeIds);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Union.startUnion(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Union.addMode(builder, this.mode.getFlatbufID());
            if (this.typeIds != null) {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Union.addTypeIds(builder, typeIds);
            }
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Union.endUnion(builder);
        }

        public String toString() {
            return "Union(" + (Object)((Object)this.mode) + ", " + Arrays.toString(this.typeIds) + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.mode, this.typeIds});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Union)) {
                return false;
            }
            Union that = (Union)obj;
            return Objects.deepEquals((Object)this.mode, (Object)that.mode) && Objects.deepEquals(this.typeIds, that.typeIds);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Map
    extends ComplexType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Map;
        boolean keysSorted;

        @JsonCreator
        public Map(@JsonProperty(value="keysSorted") boolean keysSorted) {
            this.keysSorted = keysSorted;
        }

        public boolean getKeysSorted() {
            return this.keysSorted;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Map.startMap(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Map.addKeysSorted(builder, this.keysSorted);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Map.endMap(builder);
        }

        public String toString() {
            return "Map(" + this.keysSorted + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.keysSorted});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map)) {
                return false;
            }
            Map that = (Map)obj;
            return Objects.deepEquals(this.keysSorted, that.keysSorted);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Int
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Int;
        int bitWidth;
        boolean isSigned;

        @JsonCreator
        public Int(@JsonProperty(value="bitWidth") int bitWidth, @JsonProperty(value="isSigned") boolean isSigned) {
            this.bitWidth = bitWidth;
            this.isSigned = isSigned;
        }

        public int getBitWidth() {
            return this.bitWidth;
        }

        public boolean getIsSigned() {
            return this.isSigned;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int.startInt(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int.addBitWidth(builder, this.bitWidth);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int.addIsSigned(builder, this.isSigned);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Int.endInt(builder);
        }

        public String toString() {
            return "Int(" + this.bitWidth + ", " + this.isSigned + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.bitWidth, this.isSigned});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Int)) {
                return false;
            }
            Int that = (Int)obj;
            return Objects.deepEquals(this.bitWidth, that.bitWidth) && Objects.deepEquals(this.isSigned, that.isSigned);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class FloatingPoint
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.FloatingPoint;
        FloatingPointPrecision precision;

        @JsonCreator
        public FloatingPoint(@JsonProperty(value="precision") FloatingPointPrecision precision) {
            this.precision = precision;
        }

        public FloatingPointPrecision getPrecision() {
            return this.precision;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FloatingPoint.startFloatingPoint(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FloatingPoint.addPrecision(builder, this.precision.getFlatbufID());
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FloatingPoint.endFloatingPoint(builder);
        }

        public String toString() {
            return "FloatingPoint(" + (Object)((Object)this.precision) + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.precision});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FloatingPoint)) {
                return false;
            }
            FloatingPoint that = (FloatingPoint)obj;
            return Objects.deepEquals((Object)this.precision, (Object)that.precision);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Utf8
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Utf8;
        public static final Utf8 INSTANCE = new Utf8();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8.startUtf8(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8.endUtf8(builder);
        }

        public String toString() {
            return "Utf8";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof Utf8;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Utf8View
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Utf8View;
        public static final Utf8View INSTANCE = new Utf8View();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8View.startUtf8View(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Utf8View.endUtf8View(builder);
        }

        public String toString() {
            return "Utf8View";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof Utf8View;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class LargeUtf8
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.LargeUtf8;
        public static final LargeUtf8 INSTANCE = new LargeUtf8();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeUtf8.startLargeUtf8(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeUtf8.endLargeUtf8(builder);
        }

        public String toString() {
            return "LargeUtf8";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof LargeUtf8;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Binary
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Binary;
        public static final Binary INSTANCE = new Binary();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Binary.startBinary(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Binary.endBinary(builder);
        }

        public String toString() {
            return "Binary";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof Binary;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class BinaryView
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.BinaryView;
        public static final BinaryView INSTANCE = new BinaryView();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.BinaryView.startBinaryView(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.BinaryView.endBinaryView(builder);
        }

        public String toString() {
            return "BinaryView";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof BinaryView;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class LargeBinary
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.LargeBinary;
        public static final LargeBinary INSTANCE = new LargeBinary();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeBinary.startLargeBinary(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.LargeBinary.endLargeBinary(builder);
        }

        public String toString() {
            return "LargeBinary";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof LargeBinary;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class FixedSizeBinary
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.FixedSizeBinary;
        int byteWidth;

        @JsonCreator
        public FixedSizeBinary(@JsonProperty(value="byteWidth") int byteWidth) {
            this.byteWidth = byteWidth;
        }

        public int getByteWidth() {
            return this.byteWidth;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeBinary.startFixedSizeBinary(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeBinary.addByteWidth(builder, this.byteWidth);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.FixedSizeBinary.endFixedSizeBinary(builder);
        }

        public String toString() {
            return "FixedSizeBinary(" + this.byteWidth + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.byteWidth});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FixedSizeBinary)) {
                return false;
            }
            FixedSizeBinary that = (FixedSizeBinary)obj;
            return Objects.deepEquals(this.byteWidth, that.byteWidth);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Bool
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Bool;
        public static final Bool INSTANCE = new Bool();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Bool.startBool(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Bool.endBool(builder);
        }

        public String toString() {
            return "Bool";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof Bool;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Decimal
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Decimal;
        int precision;
        int scale;
        int bitWidth;

        @JsonCreator
        public static Decimal createDecimal(@JsonProperty(value="precision") int precision, @JsonProperty(value="scale") int scale, @JsonProperty(value="bitWidth") Integer bitWidth) {
            return new Decimal(precision, scale, bitWidth == null ? 128 : bitWidth);
        }

        @Deprecated
        public Decimal(int precision, int scale) {
            this(precision, scale, 128);
        }

        public Decimal(@JsonProperty(value="precision") int precision, @JsonProperty(value="scale") int scale, @JsonProperty(value="bitWidth") int bitWidth) {
            this.precision = precision;
            this.scale = scale;
            this.bitWidth = bitWidth;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        public int getBitWidth() {
            return this.bitWidth;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Decimal.startDecimal(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Decimal.addPrecision(builder, this.precision);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Decimal.addScale(builder, this.scale);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Decimal.addBitWidth(builder, this.bitWidth);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Decimal.endDecimal(builder);
        }

        public String toString() {
            return "Decimal(" + this.precision + ", " + this.scale + ", " + this.bitWidth + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.precision, this.scale, this.bitWidth});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Decimal)) {
                return false;
            }
            Decimal that = (Decimal)obj;
            return Objects.deepEquals(this.precision, that.precision) && Objects.deepEquals(this.scale, that.scale) && Objects.deepEquals(this.bitWidth, that.bitWidth);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Date
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Date;
        DateUnit unit;

        @JsonCreator
        public Date(@JsonProperty(value="unit") DateUnit unit) {
            this.unit = unit;
        }

        public DateUnit getUnit() {
            return this.unit;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Date.startDate(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Date.addUnit(builder, this.unit.getFlatbufID());
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Date.endDate(builder);
        }

        public String toString() {
            return "Date(" + (Object)((Object)this.unit) + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.unit});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Date)) {
                return false;
            }
            Date that = (Date)obj;
            return Objects.deepEquals((Object)this.unit, (Object)that.unit);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Time
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Time;
        TimeUnit unit;
        int bitWidth;

        @JsonCreator
        public Time(@JsonProperty(value="unit") TimeUnit unit, @JsonProperty(value="bitWidth") int bitWidth) {
            this.unit = unit;
            this.bitWidth = bitWidth;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public int getBitWidth() {
            return this.bitWidth;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Time.startTime(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Time.addUnit(builder, this.unit.getFlatbufID());
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Time.addBitWidth(builder, this.bitWidth);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Time.endTime(builder);
        }

        public String toString() {
            return "Time(" + (Object)((Object)this.unit) + ", " + this.bitWidth + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.unit, this.bitWidth});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Time)) {
                return false;
            }
            Time that = (Time)obj;
            return Objects.deepEquals((Object)this.unit, (Object)that.unit) && Objects.deepEquals(this.bitWidth, that.bitWidth);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Timestamp
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Timestamp;
        TimeUnit unit;
        String timezone;

        @JsonCreator
        public Timestamp(@JsonProperty(value="unit") TimeUnit unit, @JsonProperty(value="timezone") String timezone) {
            this.unit = unit;
            this.timezone = timezone;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public String getTimezone() {
            return this.timezone;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            int timezone = this.timezone == null ? -1 : builder.createString(this.timezone);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Timestamp.startTimestamp(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Timestamp.addUnit(builder, this.unit.getFlatbufID());
            if (this.timezone != null) {
                com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Timestamp.addTimezone(builder, timezone);
            }
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Timestamp.endTimestamp(builder);
        }

        public String toString() {
            return "Timestamp(" + (Object)((Object)this.unit) + ", " + this.timezone + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.unit, this.timezone});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Timestamp)) {
                return false;
            }
            Timestamp that = (Timestamp)obj;
            return Objects.deepEquals((Object)this.unit, (Object)that.unit) && Objects.deepEquals(this.timezone, that.timezone);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Interval
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Interval;
        IntervalUnit unit;

        @JsonCreator
        public Interval(@JsonProperty(value="unit") IntervalUnit unit) {
            this.unit = unit;
        }

        public IntervalUnit getUnit() {
            return this.unit;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Interval.startInterval(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Interval.addUnit(builder, this.unit.getFlatbufID());
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Interval.endInterval(builder);
        }

        public String toString() {
            return "Interval(" + (Object)((Object)this.unit) + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.unit});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Interval)) {
                return false;
            }
            Interval that = (Interval)obj;
            return Objects.deepEquals((Object)this.unit, (Object)that.unit);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Duration
    extends PrimitiveType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.Duration;
        TimeUnit unit;

        @JsonCreator
        public Duration(@JsonProperty(value="unit") TimeUnit unit) {
            this.unit = unit;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Duration.startDuration(builder);
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Duration.addUnit(builder, this.unit.getFlatbufID());
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.Duration.endDuration(builder);
        }

        public String toString() {
            return "Duration(" + (Object)((Object)this.unit) + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.unit});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Duration)) {
                return false;
            }
            Duration that = (Duration)obj;
            return Objects.deepEquals((Object)this.unit, (Object)that.unit);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class ListView
    extends ComplexType {
        public static final ArrowTypeID TYPE_TYPE = ArrowTypeID.ListView;
        public static final ListView INSTANCE = new ListView();

        @Override
        public ArrowTypeID getTypeID() {
            return TYPE_TYPE;
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.ListView.startListView(builder);
            return com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.flatbuf.ListView.endListView(builder);
        }

        public String toString() {
            return "ListView";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[0]);
        }

        public boolean equals(Object obj) {
            return obj instanceof ListView;
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static abstract class ExtensionType
    extends ComplexType {
        public static final String EXTENSION_METADATA_KEY_NAME = "ARROW:extension:name";
        public static final String EXTENSION_METADATA_KEY_METADATA = "ARROW:extension:metadata";

        public abstract ArrowType storageType();

        public abstract String extensionName();

        public abstract boolean extensionEquals(ExtensionType var1);

        public abstract String serialize();

        public abstract ArrowType deserialize(ArrowType var1, String var2);

        public abstract FieldVector getNewVector(String var1, FieldType var2, BufferAllocator var3);

        @Override
        public ArrowTypeID getTypeID() {
            return this.storageType().getTypeID();
        }

        @Override
        public int getType(FlatBufferBuilder builder) {
            return this.storageType().getType(builder);
        }

        public String toString() {
            return "ExtensionType(" + this.extensionName() + ", " + this.storageType().toString() + ")";
        }

        public int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.storageType(), this.extensionName()});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExtensionType)) {
                return false;
            }
            return this.extensionEquals((ExtensionType)obj);
        }

        @Override
        public <T> T accept(ArrowTypeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static abstract class PrimitiveTypeVisitor<T>
    implements ArrowTypeVisitor<T> {
        public T visit(ComplexType type) {
            throw new UnsupportedOperationException("Unexpected Complex type: " + type);
        }

        @Override
        public final T visit(Struct type) {
            return this.visit((ComplexType)type);
        }

        @Override
        public final T visit(List type) {
            return this.visit((ComplexType)type);
        }

        @Override
        public final T visit(LargeList type) {
            return this.visit((ComplexType)type);
        }

        @Override
        public final T visit(FixedSizeList type) {
            return this.visit((ComplexType)type);
        }

        @Override
        public final T visit(Union type) {
            return this.visit((ComplexType)type);
        }

        @Override
        public final T visit(Map type) {
            return this.visit((ComplexType)type);
        }

        @Override
        public final T visit(ListView type) {
            return this.visit((ComplexType)type);
        }
    }

    public static abstract class ComplexTypeVisitor<T>
    implements ArrowTypeVisitor<T> {
        public T visit(PrimitiveType type) {
            throw new UnsupportedOperationException("Unexpected Primitive type: " + type);
        }

        @Override
        public final T visit(Null type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Int type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(FloatingPoint type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Utf8 type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Utf8View type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(LargeUtf8 type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Binary type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(BinaryView type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(LargeBinary type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(FixedSizeBinary type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Bool type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Decimal type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Date type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Time type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Timestamp type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Interval type) {
            return this.visit((PrimitiveType)type);
        }

        @Override
        public final T visit(Duration type) {
            return this.visit((PrimitiveType)type);
        }
    }

    public static interface ArrowTypeVisitor<T> {
        public T visit(Null var1);

        public T visit(Struct var1);

        public T visit(List var1);

        public T visit(LargeList var1);

        public T visit(FixedSizeList var1);

        public T visit(Union var1);

        public T visit(Map var1);

        public T visit(Int var1);

        public T visit(FloatingPoint var1);

        public T visit(Utf8 var1);

        public T visit(Utf8View var1);

        public T visit(LargeUtf8 var1);

        public T visit(Binary var1);

        public T visit(BinaryView var1);

        public T visit(LargeBinary var1);

        public T visit(FixedSizeBinary var1);

        public T visit(Bool var1);

        public T visit(Decimal var1);

        public T visit(Date var1);

        public T visit(Time var1);

        public T visit(Timestamp var1);

        public T visit(Interval var1);

        public T visit(Duration var1);

        public T visit(ListView var1);

        default public T visit(ExtensionType type) {
            return type.storageType().accept(this);
        }
    }

    public static enum ArrowTypeID {
        Null(1),
        Struct(13),
        List(12),
        LargeList(21),
        FixedSizeList(16),
        Union(14),
        Map(17),
        Int(2),
        FloatingPoint(3),
        Utf8(5),
        Utf8View(24),
        LargeUtf8(20),
        Binary(4),
        BinaryView(23),
        LargeBinary(19),
        FixedSizeBinary(15),
        Bool(6),
        Decimal(7),
        Date(8),
        Time(9),
        Timestamp(10),
        Interval(11),
        Duration(18),
        ListView(25),
        NONE(0);

        private final byte flatbufType;

        public byte getFlatbufID() {
            return this.flatbufType;
        }

        private ArrowTypeID(byte flatbufType) {
            this.flatbufType = flatbufType;
        }
    }

    public static abstract class ComplexType
    extends ArrowType {
        private ComplexType() {
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    public static abstract class PrimitiveType
    extends ArrowType {
        private PrimitiveType() {
        }

        @Override
        public boolean isComplex() {
            return false;
        }
    }
}

