/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.spark.bigquery.SupportsQueryPushdown;
import com.google.cloud.spark.bigquery.direct.BigQueryRDDFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.v2.BigQueryInputPartition;
import com.google.cloud.spark.bigquery.v2.BigQueryPartitionReaderFactory;
import com.google.cloud.spark.bigquery.v2.Spark3Statistics;
import com.google.cloud.spark.bigquery.v2.context.BigQueryDataSourceReaderContext;
import com.google.cloud.spark.bigquery.v2.context.InputPartitionContext;
import java.util.Objects;
import java.util.Optional;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spark31BigQueryScanBuilder
implements Batch,
Scan,
ScanBuilder,
SupportsPushDownFilters,
SupportsPushDownRequiredColumns,
SupportsReportStatistics,
SupportsQueryPushdown {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BigQueryDataSourceReaderContext ctx;
    protected InputPartition[] partitions;

    public Spark31BigQueryScanBuilder(BigQueryDataSourceReaderContext ctx) {
        this.ctx = ctx;
    }

    public TableId getTableId() {
        return this.ctx.getTableId();
    }

    public Scan build() {
        this.ctx.build();
        return this;
    }

    public Filter[] pushFilters(Filter[] filters) {
        this.ctx.pushFilters(filters);
        return filters;
    }

    public Filter[] pushedFilters() {
        return this.ctx.getAllFilters();
    }

    public void pruneColumns(StructType requiredSchema) {
        this.ctx.pruneColumns(requiredSchema);
    }

    public StructType readSchema() {
        return this.ctx.readSchema();
    }

    public String description() {
        return String.format("Reading table [%s], filters [%s], Read session Id : %s ", this.ctx.getFullTableName(), this.getPushdownFilters().orElse(""), this.ctx.getReadSessionId());
    }

    public Batch toBatch() {
        return this;
    }

    public Statistics estimateStatistics() {
        return new Spark3Statistics(this.ctx.estimateStatistics());
    }

    @Override
    public BigQueryRDDFactory getBigQueryRDDFactory() {
        return this.ctx.getBigQueryRddFactory();
    }

    @Override
    public Optional<String> getPushdownFilters() {
        return this.ctx.getCombinedFilter();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spark31BigQueryScanBuilder that = (Spark31BigQueryScanBuilder)o;
        return this.getTableId().equals(that.getTableId()) && this.readSchema().equals((Object)that.readSchema()) && this.getPushdownFilters().equals(that.getPushdownFilters());
    }

    public int hashCode() {
        return Objects.hash(this.getTableId(), this.readSchema(), this.getPushdownFilters());
    }

    public InputPartition[] planInputPartitions() {
        if (this.partitions != null) {
            return this.partitions;
        }
        this.partitions = this.ctx.enableBatchRead() ? (InputPartition[])this.ctx.planBatchInputPartitionContexts().map(inputPartitionContext -> new BigQueryInputPartition((InputPartitionContext)inputPartitionContext)).toArray(InputPartition[]::new) : (InputPartition[])this.ctx.planInputPartitionContexts().map(inputPartitionContext -> new BigQueryInputPartition((InputPartitionContext)inputPartitionContext)).toArray(InputPartition[]::new);
        return this.partitions;
    }

    public PartitionReaderFactory createReaderFactory() {
        return new BigQueryPartitionReaderFactory();
    }
}

