/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonClientInterceptor;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonHeaderInterceptor;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonInterceptorProvider;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonLoggingInterceptor;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.ManagedHttpJsonChannel;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson.ManagedHttpJsonInterceptorChannel;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.Credentials;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@InternalExtensionOnly
public final class InstantiatingHttpJsonChannelProvider
implements TransportChannelProvider {
    private final Executor executor;
    private final HeaderProvider headerProvider;
    private final HttpJsonInterceptorProvider interceptorProvider;
    private final String endpoint;
    private final HttpTransport httpTransport;
    private final MtlsProvider mtlsProvider;

    private InstantiatingHttpJsonChannelProvider(Executor executor, HeaderProvider headerProvider, HttpJsonInterceptorProvider interceptorProvider, String endpoint, HttpTransport httpTransport, MtlsProvider mtlsProvider) {
        this.executor = executor;
        this.headerProvider = headerProvider;
        this.interceptorProvider = interceptorProvider;
        this.endpoint = endpoint;
        this.httpTransport = httpTransport;
        this.mtlsProvider = mtlsProvider;
    }

    @Override
    @Deprecated
    public boolean needsExecutor() {
        return this.executor == null;
    }

    @Override
    @Deprecated
    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.withExecutor((Executor)executor);
    }

    @Override
    public TransportChannelProvider withExecutor(Executor executor) {
        return this.toBuilder().setExecutor(executor).build();
    }

    @Override
    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    @Override
    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider(FixedHeaderProvider.create(headers)).build();
    }

    @Override
    public boolean needsEndpoint() {
        return this.endpoint == null;
    }

    @Override
    public TransportChannelProvider withEndpoint(String endpoint) {
        return this.toBuilder().setEndpoint(endpoint).build();
    }

    @Override
    @Deprecated
    public boolean acceptsPoolSize() {
        return false;
    }

    @Override
    @Deprecated
    public TransportChannelProvider withPoolSize(int size) {
        throw new UnsupportedOperationException("InstantiatingHttpJsonChannelProvider doesn't allow pool size customization");
    }

    @Override
    public String getTransportName() {
        return HttpJsonTransportChannel.getHttpJsonTransportName();
    }

    @Override
    public HttpJsonTransportChannel getTransportChannel() throws IOException {
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        try {
            return this.createChannel();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean needsCredentials() {
        return false;
    }

    @Override
    public TransportChannelProvider withCredentials(Credentials credentials) {
        throw new UnsupportedOperationException("InstantiatingHttpJsonChannelProvider doesn't need credentials");
    }

    HttpTransport createHttpTransport() throws IOException, GeneralSecurityException {
        KeyStore mtlsKeyStore;
        if (this.mtlsProvider.useMtlsClientCertificate() && (mtlsKeyStore = this.mtlsProvider.getKeyStore()) != null) {
            return new NetHttpTransport.Builder().trustCertificates(null, mtlsKeyStore, "").build();
        }
        return null;
    }

    private HttpJsonTransportChannel createChannel() throws IOException, GeneralSecurityException {
        HttpTransport httpTransportToUse = this.httpTransport;
        if (httpTransportToUse == null) {
            httpTransportToUse = this.createHttpTransport();
        }
        ManagedHttpJsonChannel channel = ManagedHttpJsonChannel.newBuilder().setEndpoint(this.endpoint).setExecutor(this.executor).setHttpTransport(httpTransportToUse).build();
        HttpJsonHeaderInterceptor headerInterceptor = new HttpJsonHeaderInterceptor(this.headerProvider.getHeaders());
        channel = new ManagedHttpJsonInterceptorChannel(channel, new HttpJsonLoggingInterceptor());
        channel = new ManagedHttpJsonInterceptorChannel(channel, headerInterceptor);
        if (this.interceptorProvider != null && this.interceptorProvider.getInterceptors() != null) {
            for (HttpJsonClientInterceptor interceptor : this.interceptorProvider.getInterceptors()) {
                channel = new ManagedHttpJsonInterceptorChannel(channel, interceptor);
            }
        }
        return HttpJsonTransportChannel.newBuilder().setManagedChannel(channel).build();
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Executor executor;
        private HeaderProvider headerProvider;
        private HttpJsonInterceptorProvider interceptorProvider;
        private String endpoint;
        private HttpTransport httpTransport;
        private MtlsProvider mtlsProvider = new MtlsProvider();

        private Builder() {
        }

        private Builder(InstantiatingHttpJsonChannelProvider provider) {
            this.executor = provider.executor;
            this.headerProvider = provider.headerProvider;
            this.endpoint = provider.endpoint;
            this.httpTransport = provider.httpTransport;
            this.mtlsProvider = provider.mtlsProvider;
            this.interceptorProvider = provider.interceptorProvider;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Deprecated
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            return this.setExecutor(executorProvider.getExecutor());
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setInterceptorProvider(HttpJsonInterceptorProvider interceptorProvider) {
            this.interceptorProvider = interceptorProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        @VisibleForTesting
        Builder setMtlsProvider(MtlsProvider mtlsProvider) {
            this.mtlsProvider = mtlsProvider;
            return this;
        }

        public InstantiatingHttpJsonChannelProvider build() {
            return new InstantiatingHttpJsonChannelProvider(this.executor, this.headerProvider, this.interceptorProvider, this.endpoint, this.httpTransport, this.mtlsProvider);
        }
    }
}

