/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.ParameterMode;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class QueryParameterHelper
implements Serializable {
    private static final long serialVersionUID = -283738274937293739L;
    private final ParameterMode mode;
    private final Map<String, QueryParameterValue> namedParameters;
    private final List<QueryParameterValue> positionalParameters;

    public QueryParameterHelper(ParameterMode mode, Map<String, QueryParameterValue> named, List<QueryParameterValue> positional) {
        this.mode = mode;
        this.namedParameters = Collections.unmodifiableMap(new HashMap<String, QueryParameterValue>(named));
        this.positionalParameters = Collections.unmodifiableList(new ArrayList<QueryParameterValue>(positional));
    }

    static QueryParameterHelper none() {
        return new QueryParameterHelper(ParameterMode.NONE, Collections.emptyMap(), Collections.emptyList());
    }

    static QueryParameterHelper named(Map<String, QueryParameterValue> namedParameters) {
        Preconditions.checkNotNull(namedParameters, "Input named parameters map cannot be null for named mode");
        return new QueryParameterHelper(ParameterMode.NAMED, namedParameters, Collections.emptyList());
    }

    static QueryParameterHelper positional(List<QueryParameterValue> positionalParameters) {
        Preconditions.checkNotNull(positionalParameters, "Input positional parameters list cannot be null for positional mode");
        return new QueryParameterHelper(ParameterMode.POSITIONAL, Collections.emptyMap(), positionalParameters);
    }

    public ParameterMode getMode() {
        return this.mode;
    }

    public Optional<Map<String, QueryParameterValue>> getNamedParameters() {
        return this.mode == ParameterMode.NAMED ? Optional.of(this.namedParameters) : Optional.empty();
    }

    public Optional<List<QueryParameterValue>> getPositionalParameters() {
        return this.mode == ParameterMode.POSITIONAL ? Optional.of(this.positionalParameters) : Optional.empty();
    }

    public boolean isEmpty() {
        return this.mode == ParameterMode.NONE;
    }

    public QueryJobConfiguration.Builder configureBuilder(QueryJobConfiguration.Builder builder) {
        Preconditions.checkNotNull(builder, "QueryJobConfiguration.Builder cannot be null");
        this.namedParameters.forEach((paramName, paramValue) -> builder.addNamedParameter((String)paramName, (QueryParameterValue)paramValue));
        this.positionalParameters.forEach(paramValue -> builder.addPositionalParameter((QueryParameterValue)paramValue));
        return builder;
    }
}

