/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableCollection;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.Maps;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.AutoValueExtension;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.AnnotatedTypeMirror;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.AutoValueProcessor;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.AutoValueishProcessor;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.ClassNames;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.TypeSimplifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class ExtensionContext
implements AutoValueExtension.Context {
    private final AutoValueProcessor autoValueProcessor;
    private final ProcessingEnvironment processingEnvironment;
    private final TypeElement autoValueClass;
    private final ImmutableMap<String, ExecutableElement> properties;
    private final ImmutableMap<String, AnnotatedTypeMirror> propertyTypes;
    private final ImmutableSet<ExecutableElement> abstractMethods;
    private final ImmutableSet<ExecutableElement> builderAbstractMethods;
    private Optional<AutoValueExtension.BuilderContext> builderContext = Optional.empty();

    ExtensionContext(AutoValueProcessor autoValueProcessor, ProcessingEnvironment processingEnvironment, TypeElement autoValueClass, ImmutableMap<String, ExecutableElement> properties, ImmutableMap<ExecutableElement, AnnotatedTypeMirror> propertyMethodsAndTypes, ImmutableSet<ExecutableElement> abstractMethods, ImmutableSet<ExecutableElement> builderAbstractMethods) {
        this.autoValueProcessor = autoValueProcessor;
        this.processingEnvironment = processingEnvironment;
        this.autoValueClass = autoValueClass;
        this.properties = properties;
        this.propertyTypes = ImmutableMap.copyOf(Maps.transformValues(properties, propertyMethodsAndTypes::get));
        this.abstractMethods = abstractMethods;
        this.builderAbstractMethods = builderAbstractMethods;
    }

    void setBuilderContext(AutoValueExtension.BuilderContext builderContext) {
        this.builderContext = Optional.of(builderContext);
    }

    @Override
    public ProcessingEnvironment processingEnvironment() {
        return this.processingEnvironment;
    }

    @Override
    public String packageName() {
        return TypeSimplifier.packageNameOf(this.autoValueClass);
    }

    @Override
    public TypeElement autoValueClass() {
        return this.autoValueClass;
    }

    @Override
    public String finalAutoValueClassName() {
        return AutoValueProcessor.generatedSubclassName(this.autoValueClass, 0);
    }

    @Override
    public Map<String, ExecutableElement> properties() {
        return this.properties;
    }

    @Override
    public Map<String, TypeMirror> propertyTypes() {
        return Maps.transformValues(this.propertyTypes, AnnotatedTypeMirror::getType);
    }

    @Override
    public Set<ExecutableElement> abstractMethods() {
        return this.abstractMethods;
    }

    @Override
    public Set<ExecutableElement> builderAbstractMethods() {
        return this.builderAbstractMethods;
    }

    @Override
    public List<AnnotationMirror> classAnnotationsToCopy(TypeElement classToCopyFrom) {
        if (!AutoValueishProcessor.hasAnnotationMirror(classToCopyFrom, "com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.AutoValue.CopyAnnotations")) {
            return ImmutableList.of();
        }
        ImmutableCollection excludedAnnotations = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(AutoValueishProcessor.getExcludedAnnotationClassNames(classToCopyFrom))).addAll(AutoValueishProcessor.getAnnotationsMarkedWithInherited(classToCopyFrom))).add(ClassNames.KOTLIN_METADATA_NAME)).build();
        return this.autoValueProcessor.annotationsToCopy(this.autoValueClass, classToCopyFrom, (Set<String>)((Object)excludedAnnotations));
    }

    @Override
    public List<AnnotationMirror> methodAnnotationsToCopy(ExecutableElement method) {
        return this.autoValueProcessor.propertyMethodAnnotations(this.autoValueClass, method);
    }

    @Override
    public Optional<AutoValueExtension.BuilderContext> builder() {
        return this.builderContext;
    }
}

