/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.commons.io.function;

import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.io.IOExceptionList;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.io.IOIndexedException;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.io.function.IOStreams;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.io.function.Uncheck;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

@FunctionalInterface
public interface IOConsumer<T> {
    public static final IOConsumer<?> NOOP_IO_CONSUMER = t2 -> {};

    public static <T> void forAll(IOConsumer<T> action, Iterable<T> iterable) throws IOExceptionList {
        IOStreams.forAll(IOStreams.of(iterable), action);
    }

    public static <T> void forAll(IOConsumer<T> action, Stream<T> stream) throws IOExceptionList {
        IOStreams.forAll(stream, action, IOIndexedException::new);
    }

    @SafeVarargs
    public static <T> void forAll(IOConsumer<T> action, T ... array) throws IOExceptionList {
        IOStreams.forAll(IOStreams.of(array), action);
    }

    public static <T> void forEach(Iterable<T> iterable, IOConsumer<T> action) throws IOException {
        IOStreams.forEach(IOStreams.of(iterable), action);
    }

    public static <T> void forEach(Stream<T> stream, IOConsumer<T> action) throws IOException {
        IOStreams.forEach(stream, action);
    }

    public static <T> void forEach(T[] array, IOConsumer<T> action) throws IOException {
        IOStreams.forEach(IOStreams.of(array), action);
    }

    public static <T> IOConsumer<T> noop() {
        return NOOP_IO_CONSUMER;
    }

    public void accept(T var1) throws IOException;

    default public IOConsumer<T> andThen(IOConsumer<? super T> after) {
        Objects.requireNonNull(after, "after");
        return t2 -> {
            this.accept(t2);
            after.accept(t2);
        };
    }

    default public Consumer<T> asConsumer() {
        return t2 -> Uncheck.accept(this, t2);
    }
}

