/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.threeten.extra;

import com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.Temporals;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Hours
implements TemporalAmount,
Comparable<Hours>,
Serializable {
    public static final Hours ZERO = new Hours(0);
    private static final long serialVersionUID = -8494096666041369608L;
    private static final int HOURS_PER_DAY = 24;
    private static final Pattern PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)D)?(?:T(?:([-+]?[0-9]+)H)?)?", 2);
    private final int hours;

    public static Hours of(int hours) {
        if (hours == 0) {
            return ZERO;
        }
        return new Hours(hours);
    }

    public static Hours from(TemporalAmount amount) {
        if (amount instanceof Hours) {
            return (Hours)amount;
        }
        Objects.requireNonNull(amount, "amount");
        int hours = 0;
        for (TemporalUnit unit : amount.getUnits()) {
            long value = amount.get(unit);
            if (value == 0L) continue;
            long[] converted = Temporals.convertAmount(value, unit, ChronoUnit.HOURS);
            if (converted[1] != 0L) {
                throw new DateTimeException("Amount could not be converted to a whole number of hours: " + value + " " + unit);
            }
            hours = Math.addExact(hours, Math.toIntExact(converted[0]));
        }
        return Hours.of(hours);
    }

    @FromString
    public static Hours parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches()) {
            int negate = "-".equals(matcher.group(1)) ? -1 : 1;
            String daysStr = matcher.group(2);
            String hoursStr = matcher.group(3);
            if (daysStr != null || hoursStr != null) {
                int hours = 0;
                if (hoursStr != null) {
                    try {
                        hours = Integer.parseInt(hoursStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new DateTimeParseException("Text cannot be parsed to Hours, non-numeric hours", text, 0, ex);
                    }
                }
                if (daysStr != null) {
                    try {
                        int daysAsHours = Math.multiplyExact(Integer.parseInt(daysStr), 24);
                        hours = Math.addExact(hours, daysAsHours);
                    }
                    catch (NumberFormatException ex) {
                        throw new DateTimeParseException("Text cannot be parsed to Hours, non-numeric days", text, 0, ex);
                    }
                }
                return Hours.of(Math.multiplyExact(hours, negate));
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to Hours", text, 0);
    }

    public static Hours between(Temporal startInclusive, Temporal endExclusive) {
        return Hours.of(Math.toIntExact(ChronoUnit.HOURS.between(startInclusive, endExclusive)));
    }

    private Hours(int hours) {
        this.hours = hours;
    }

    private Object readResolve() {
        return Hours.of(this.hours);
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.HOURS) {
            return this.hours;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.singletonList(ChronoUnit.HOURS);
    }

    public int getAmount() {
        return this.hours;
    }

    public Hours plus(TemporalAmount amountToAdd) {
        return this.plus(Hours.from(amountToAdd).getAmount());
    }

    public Hours plus(int hours) {
        if (hours == 0) {
            return this;
        }
        return Hours.of(Math.addExact(this.hours, hours));
    }

    public Hours minus(TemporalAmount amountToAdd) {
        return this.minus(Hours.from(amountToAdd).getAmount());
    }

    public Hours minus(int hours) {
        if (hours == 0) {
            return this;
        }
        return Hours.of(Math.subtractExact(this.hours, hours));
    }

    public Hours multipliedBy(int scalar) {
        if (scalar == 1) {
            return this;
        }
        return Hours.of(Math.multiplyExact(this.hours, scalar));
    }

    public Hours dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Hours.of(this.hours / divisor);
    }

    public Hours negated() {
        return this.multipliedBy(-1);
    }

    public Hours abs() {
        return this.hours < 0 ? this.negated() : this;
    }

    @Deprecated
    public Duration toPeriod() {
        return Duration.ofHours(this.hours);
    }

    public Duration toDuration() {
        return Duration.ofHours(this.hours);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.hours != 0) {
            temporal = temporal.plus(this.hours, ChronoUnit.HOURS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.hours != 0) {
            temporal = temporal.minus(this.hours, ChronoUnit.HOURS);
        }
        return temporal;
    }

    @Override
    public int compareTo(Hours otherAmount) {
        int thisValue = this.hours;
        int otherValue = otherAmount.hours;
        return Integer.compare(thisValue, otherValue);
    }

    public boolean equals(Object otherAmount) {
        if (this == otherAmount) {
            return true;
        }
        if (otherAmount instanceof Hours) {
            Hours other = (Hours)otherAmount;
            return this.hours == other.hours;
        }
        return false;
    }

    public int hashCode() {
        return this.hours;
    }

    @ToString
    public String toString() {
        return "PT" + this.hours + "H";
    }
}

