/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateDataCleaner
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IntermediateDataCleaner.class);
    private final Path path;
    private final Configuration conf;

    public IntermediateDataCleaner(Path path, Configuration conf) {
        this.path = path;
        this.conf = conf;
    }

    @Override
    public void run() {
        this.deletePath();
    }

    public void deletePath() {
        try {
            FileSystem fs;
            logger.info("Deleting path " + this.path + " if it exists");
            Configuration cleanConf = new Configuration(this.conf);
            String scheme = this.path.toUri().getScheme();
            if (scheme != null) {
                cleanConf.set("fs." + scheme + ".impl.disable.cache", "true");
            }
            if (this.pathExists(fs = FileSystem.get((URI)this.path.toUri(), (Configuration)cleanConf), this.path)) {
                fs.delete(this.path, true);
            }
            logger.info("Path " + this.path + " no longer exists)");
        }
        catch (Exception e) {
            logger.error("Failed to delete path " + this.path, (Throwable)e);
        }
    }

    public void deleteEpochPath(long epochId) {
        Path epochPath = new Path(this.path + "/" + epochId);
        try {
            logger.info("Deleting epoch path " + epochPath + " if it exists");
            FileSystem fs = epochPath.getFileSystem(this.conf);
            if (this.pathExists(fs, epochPath)) {
                fs.delete(epochPath, true);
            }
            logger.info("Path " + epochPath + " no longer exists)");
        }
        catch (Exception e) {
            logger.error("Failed to delete path " + epochPath, (Throwable)e);
        }
    }

    private boolean pathExists(FileSystem fs, Path path) {
        try {
            return fs.exists(path);
        }
        catch (Exception e) {
            return false;
        }
    }
}

