/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.opencensus.metrics;

import com.google.cloud.spark.bigquery.repackaged.io.opencensus.common.ToLongFunction;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.internal.Utils;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.metrics.LabelKey;
import com.google.cloud.spark.bigquery.repackaged.io.opencensus.metrics.LabelValue;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class DerivedLongCumulative {
    public abstract <T> void createTimeSeries(List<LabelValue> var1, T var2, ToLongFunction<T> var3);

    public abstract void removeTimeSeries(List<LabelValue> var1);

    public abstract void clear();

    static DerivedLongCumulative newNoopDerivedLongCumulative(String name, String description, String unit, List<LabelKey> labelKeys) {
        return NoopDerivedLongCumulative.create(name, description, unit, labelKeys);
    }

    private static final class NoopDerivedLongCumulative
    extends DerivedLongCumulative {
        private final int labelKeysSize;

        static NoopDerivedLongCumulative create(String name, String description, String unit, List<LabelKey> labelKeys) {
            return new NoopDerivedLongCumulative(name, description, unit, labelKeys);
        }

        NoopDerivedLongCumulative(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(description, "description");
            Utils.checkNotNull(unit, "unit");
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            this.labelKeysSize = labelKeys.size();
        }

        @Override
        public <T> void createTimeSeries(List<LabelValue> labelValues, T obj, ToLongFunction<T> function) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            Utils.checkNotNull(function, "function");
        }

        @Override
        public void removeTimeSeries(List<LabelValue> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void clear() {
        }
    }
}

