/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.http.protocol;

import com.google.cloud.spark.bigquery.repackaged.org.apache.http.HttpException;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.HttpRequest;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.HttpRequestInterceptor;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.annotation.Contract;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.annotation.ThreadingBehavior;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.protocol.HttpContext;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

