/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.datatype.jsr310;

import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.core.io.NumberInput;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.function.BiFunction;

public final class DecimalUtils {
    private DecimalUtils() {
    }

    public static String toDecimal(long seconds, int nanoseconds) {
        StringBuilder sb = new StringBuilder(20).append(seconds).append('.');
        if ((long)nanoseconds == 0L) {
            if (seconds == 0L) {
                return "0.0";
            }
            sb.append("000000000");
        } else {
            StringBuilder nanoSB = new StringBuilder(9);
            nanoSB.append(nanoseconds);
            int nanosLen = nanoSB.length();
            for (int prepZeroes = 9 - nanosLen; prepZeroes > 0; --prepZeroes) {
                sb.append('0');
            }
            sb.append((CharSequence)nanoSB);
        }
        return sb.toString();
    }

    public static BigDecimal toBigDecimal(long seconds, int nanoseconds) {
        if ((long)nanoseconds == 0L) {
            if (seconds == 0L) {
                return BigDecimal.ZERO.setScale(1);
            }
            return BigDecimal.valueOf(seconds).setScale(9);
        }
        return NumberInput.parseBigDecimal(DecimalUtils.toDecimal(seconds, nanoseconds), false);
    }

    @Deprecated
    public static <T> T extractSecondsAndNanos(BigDecimal seconds, BiFunction<Long, Integer, T> convert) {
        return DecimalUtils.extractSecondsAndNanos(seconds, convert, true);
    }

    public static <T> T extractSecondsAndNanos(BigDecimal seconds, BiFunction<Long, Integer, T> convert, boolean negativeAdjustment) {
        long secondsOnly;
        int nanosOnly;
        BigDecimal nanoseconds = seconds.scaleByPowerOfTen(9);
        if (nanoseconds.precision() - nanoseconds.scale() <= 0) {
            nanosOnly = 0;
            secondsOnly = 0;
        } else if (seconds.scale() < -63) {
            nanosOnly = 0;
            secondsOnly = 0;
        } else {
            secondsOnly = seconds.longValue();
            nanosOnly = nanoseconds.subtract(BigDecimal.valueOf(secondsOnly).scaleByPowerOfTen(9)).intValue();
            if (secondsOnly < 0L && secondsOnly > Instant.MIN.getEpochSecond() && negativeAdjustment) {
                nanosOnly = Math.abs(nanosOnly);
            }
        }
        return convert.apply(secondsOnly, nanosOnly);
    }
}

