/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.AbstractApiFuture;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.ApiFuture;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.BetaApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc.ChannelPool;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.grpc.GrpcDirectCallable;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.CallOptions;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Channel;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ClientCall;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ClientInterceptor;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ClientInterceptors;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Deadline;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Metadata;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.MethodDescriptor;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Status;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.stub.MetadataUtils;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class GrpcClientCalls {
    private static final Logger LOGGER = Logger.getLogger(GrpcDirectCallable.class.getName());

    private GrpcClientCalls() {
    }

    public static <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> descriptor, ApiCallContext context) {
        if (!(context instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + context.getClass().getName());
        }
        GrpcCallContext grpcContext = (GrpcCallContext)context;
        Preconditions.checkNotNull(grpcContext.getChannel());
        CallOptions callOptions = grpcContext.getCallOptions();
        Preconditions.checkNotNull(callOptions);
        if (grpcContext.getTimeoutDuration() != null) {
            Deadline newDeadline = Deadline.after(grpcContext.getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
            Deadline oldDeadline = callOptions.getDeadline();
            if (oldDeadline == null || newDeadline.isBefore(oldDeadline)) {
                callOptions = callOptions.withDeadline(newDeadline);
            }
        }
        Channel channel = grpcContext.getChannel();
        if (grpcContext.getChannelAffinity() != null && channel instanceof ChannelPool) {
            channel = ((ChannelPool)channel).getChannel(grpcContext.getChannelAffinity());
        }
        if (!grpcContext.getExtraHeaders().isEmpty()) {
            ClientInterceptor interceptor = MetadataUtils.newAttachHeadersInterceptor(grpcContext.getMetadata());
            channel = ClientInterceptors.intercept(channel, interceptor);
        }
        grpcContext.validateUniverseDomain();
        try (ApiTracer.Scope ignored = grpcContext.getTracer().inScope();){
            ClientCall<RequestT, ResponseT> clientCall = channel.newCall(descriptor, callOptions);
            return clientCall;
        }
    }

    @BetaApi
    static <RequestT, ResponseT> ApiFuture<ResponseT> eagerFutureUnaryCall(ClientCall<RequestT, ResponseT> clientCall, RequestT request) {
        GrpcFuture future = new GrpcFuture(clientCall);
        clientCall.start(new EagerFutureListener(future), new Metadata());
        try {
            clientCall.sendMessage(request);
            clientCall.halfClose();
            clientCall.request(2);
        }
        catch (Throwable sendError) {
            try {
                clientCall.cancel(null, sendError);
            }
            catch (Throwable cancelError) {
                LOGGER.log(Level.SEVERE, "Error encountered while closing it", sendError);
            }
            throw sendError;
        }
        return future;
    }

    private static class GrpcFuture<T>
    extends AbstractApiFuture<T> {
        private final ClientCall<?, T> call;

        private GrpcFuture(ClientCall<?, T> call) {
            this.call = call;
        }

        @Override
        protected void interruptTask() {
            this.call.cancel("GrpcFuture was cancelled", null);
        }

        @Override
        public boolean set(T value) {
            return super.set(value);
        }

        @Override
        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }

    private static class EagerFutureListener<T>
    extends ClientCall.Listener<T> {
        private final GrpcFuture<T> future;

        private EagerFutureListener(GrpcFuture<T> future) {
            this.future = future;
        }

        @Override
        public void onMessage(T message) {
            if (!this.future.set(message)) {
                throw Status.INTERNAL.withDescription("More than one value received for unary call").asRuntimeException();
            }
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            if (!this.future.isDone()) {
                this.future.setException(Status.INTERNAL.withDescription("No value received for unary call").asException(trailers));
            }
            if (!status.isOk()) {
                LOGGER.log(Level.WARNING, "Received error for unary call after receiving a successful response");
            }
        }
    }
}

