/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.impl;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.service.AutoService;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.squareup.javapoet.CodeBlock;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.Serializer;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.SerializerExtension;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.SerializerFactory;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@AutoService(value={SerializerExtension.class})
public final class OptionalSerializerExtension
implements SerializerExtension {
    @Override
    public Optional<Serializer> getSerializer(TypeMirror typeMirror, SerializerFactory factory, ProcessingEnvironment processingEnv) {
        if (!OptionalSerializerExtension.isOptional(typeMirror)) {
            return Optional.empty();
        }
        TypeMirror containedType = OptionalSerializerExtension.getContainedType(typeMirror);
        Serializer containedTypeSerializer = factory.getSerializer(containedType);
        return Optional.of(new OptionalSerializer(containedTypeSerializer));
    }

    private static boolean isOptional(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        return MoreTypes.asTypeElement(type).getQualifiedName().contentEquals("java.util.Optional");
    }

    private static TypeMirror getContainedType(TypeMirror type) {
        return MoreTypes.asDeclared(type).getTypeArguments().get(0);
    }

    private static class OptionalSerializer
    implements Serializer {
        private final Serializer containedTypeSerializer;

        OptionalSerializer(Serializer containedTypeSerializer) {
            this.containedTypeSerializer = containedTypeSerializer;
        }

        @Override
        public TypeMirror proxyFieldType() {
            return this.containedTypeSerializer.proxyFieldType();
        }

        @Override
        public CodeBlock toProxy(CodeBlock expression) {
            return CodeBlock.of("$L.isPresent() ? $L : null", expression, this.containedTypeSerializer.toProxy(CodeBlock.of("$L.get()", expression)));
        }

        @Override
        public CodeBlock fromProxy(CodeBlock expression) {
            return CodeBlock.of("$T.ofNullable($L == null ? null : $L)", Optional.class, expression, this.containedTypeSerializer.fromProxy(expression));
        }
    }
}

