/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.compression;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.ArrowBuf;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.BufferAllocator;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compression.AbstractCompressionCodec;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compression.CompressionUtil;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.compress.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Lz4CompressionCodec
extends AbstractCompressionCodec {
    @Override
    protected ArrowBuf doCompress(BufferAllocator allocator, ArrowBuf uncompressedBuffer) {
        Preconditions.checkArgument(uncompressedBuffer.writerIndex() <= Integer.MAX_VALUE, "The uncompressed buffer size exceeds the integer limit %s.", Integer.MAX_VALUE);
        byte[] inBytes = new byte[(int)uncompressedBuffer.writerIndex()];
        uncompressedBuffer.getBytes(0L, inBytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ByteArrayInputStream in = new ByteArrayInputStream(inBytes);
             FramedLZ4CompressorOutputStream out = new FramedLZ4CompressorOutputStream(baos);){
            IOUtils.copy(in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] outBytes = baos.toByteArray();
        ArrowBuf compressedBuffer = allocator.buffer(8L + (long)outBytes.length);
        compressedBuffer.setBytes(8L, outBytes);
        compressedBuffer.writerIndex(8L + (long)outBytes.length);
        return compressedBuffer;
    }

    @Override
    protected ArrowBuf doDecompress(BufferAllocator allocator, ArrowBuf compressedBuffer) {
        Preconditions.checkArgument(compressedBuffer.writerIndex() <= Integer.MAX_VALUE, "The compressed buffer size exceeds the integer limit %s", Integer.MAX_VALUE);
        long decompressedLength = this.readUncompressedLength(compressedBuffer);
        byte[] inBytes = new byte[(int)(compressedBuffer.writerIndex() - 8L)];
        compressedBuffer.getBytes(8L, inBytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)decompressedLength);
        try (FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream(new ByteArrayInputStream(inBytes));){
            IOUtils.copy(in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] outBytes = out.toByteArray();
        ArrowBuf decompressedBuffer = allocator.buffer(outBytes.length);
        decompressedBuffer.setBytes(0L, outBytes);
        decompressedBuffer.writerIndex(decompressedLength);
        return decompressedBuffer;
    }

    @Override
    public CompressionUtil.CodecType getCodecType() {
        return CompressionUtil.CodecType.LZ4_FRAME;
    }
}

