/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.compression;

import com.github.luben.zstd.Zstd;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.ArrowBuf;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.BufferAllocator;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compression.AbstractCompressionCodec;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compression.CompressionUtil;

public class ZstdCompressionCodec
extends AbstractCompressionCodec {
    private int compressionLevel;
    private static final int DEFAULT_COMPRESSION_LEVEL = 3;

    public ZstdCompressionCodec() {
        this.compressionLevel = 3;
    }

    public ZstdCompressionCodec(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    protected ArrowBuf doCompress(BufferAllocator allocator, ArrowBuf uncompressedBuffer) {
        long maxSize = Zstd.compressBound((long)uncompressedBuffer.writerIndex());
        long dstSize = 8L + maxSize;
        ArrowBuf compressedBuffer = allocator.buffer(dstSize);
        long bytesWritten = Zstd.compressUnsafe((long)(compressedBuffer.memoryAddress() + 8L), (long)dstSize, (long)uncompressedBuffer.memoryAddress(), (long)uncompressedBuffer.writerIndex(), (int)this.compressionLevel);
        if (Zstd.isError((long)bytesWritten)) {
            compressedBuffer.close();
            throw new RuntimeException("Error compressing: " + Zstd.getErrorName((long)bytesWritten));
        }
        compressedBuffer.writerIndex(8L + bytesWritten);
        return compressedBuffer;
    }

    @Override
    protected ArrowBuf doDecompress(BufferAllocator allocator, ArrowBuf compressedBuffer) {
        long decompressedLength = this.readUncompressedLength(compressedBuffer);
        ArrowBuf uncompressedBuffer = allocator.buffer(decompressedLength);
        long decompressedSize = Zstd.decompressUnsafe((long)uncompressedBuffer.memoryAddress(), (long)decompressedLength, (long)(compressedBuffer.memoryAddress() + 8L), (long)(compressedBuffer.writerIndex() - 8L));
        if (Zstd.isError((long)decompressedSize)) {
            uncompressedBuffer.close();
            throw new RuntimeException("Error decompressing: " + Zstd.getErrorName((long)decompressedLength));
        }
        if (decompressedLength != decompressedSize) {
            uncompressedBuffer.close();
            throw new RuntimeException("Expected != actual decompressed length: " + decompressedLength + " != " + decompressedSize);
        }
        uncompressedBuffer.writerIndex(decompressedLength);
        return uncompressedBuffer;
    }

    @Override
    public CompressionUtil.CodecType getCodecType() {
        return CompressionUtil.CodecType.ZSTD;
    }
}

