/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.ApiFunction;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.http.HttpTransportFactory;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.HttpConnectProxiedSocketAddress;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ProxiedSocketAddress;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.ProxyDetector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.HttpHost;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.auth.AuthScope;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.auth.UsernamePasswordCredentials;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.impl.client.BasicCredentialsProvider;
import com.google.cloud.spark.bigquery.repackaged.org.apache.http.impl.client.HttpClientBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Optional;

public class BigQueryProxyTransporterBuilder {
    public static ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> createGrpcChannelConfigurator(Optional<URI> proxyAddress, final Optional<String> proxyUsername, final Optional<String> proxyPassword) {
        if (!proxyAddress.isPresent()) {
            return null;
        }
        BigQueryProxyTransporterBuilder.checkProxyParamsValidity(proxyUsername, proxyPassword);
        URI proxyUri = proxyAddress.get();
        String httpProxyHost = proxyUri.getHost();
        int httpProxyPort = proxyUri.getPort();
        final InetSocketAddress proxySocketAddress = new InetSocketAddress(httpProxyHost, httpProxyPort);
        return new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            @Override
            public ManagedChannelBuilder apply(ManagedChannelBuilder input) {
                return input.proxyDetector(new ProxyDetector(){

                    @Override
                    public ProxiedSocketAddress proxyFor(SocketAddress targetServerAddress) {
                        HttpConnectProxiedSocketAddress.Builder proxySocketBuilder = HttpConnectProxiedSocketAddress.newBuilder().setTargetAddress((InetSocketAddress)targetServerAddress).setProxyAddress(proxySocketAddress);
                        if (proxyUsername.isPresent() && proxyPassword.isPresent()) {
                            proxySocketBuilder.setUsername((String)proxyUsername.get());
                            proxySocketBuilder.setPassword((String)proxyPassword.get());
                        }
                        return proxySocketBuilder.build();
                    }
                });
            }
        };
    }

    public static HttpTransportFactory createHttpTransportFactory(Optional<URI> proxyAddress, Optional<String> proxyUsername, Optional<String> proxyPassword) {
        if (!proxyAddress.isPresent()) {
            return null;
        }
        BigQueryProxyTransporterBuilder.checkProxyParamsValidity(proxyUsername, proxyPassword);
        URI proxyUri = proxyAddress.get();
        String httpProxyHost = proxyUri.getHost();
        int httpProxyPort = proxyUri.getPort();
        HttpHost proxyHost = new HttpHost(httpProxyHost, httpProxyPort);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setProxy(proxyHost);
        if (proxyUsername.isPresent() && proxyPassword.isPresent()) {
            UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxyUsername.get(), proxyPassword.get());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), proxyCredentials);
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        return new BigQueryHttpTransportFactory(httpClientBuilder);
    }

    public static void checkProxyParamsValidity(Optional<String> proxyUsername, Optional<String> proxyPassword) throws IllegalArgumentException {
        if (proxyUsername.isPresent() != proxyPassword.isPresent()) {
            throw new IllegalArgumentException("Both proxyUsername and proxyPassword should be defined or not defined together");
        }
    }

    public static class BigQueryHttpTransportFactory
    implements HttpTransportFactory {
        private HttpClientBuilder httpClientBuilder;

        public BigQueryHttpTransportFactory() {
        }

        public BigQueryHttpTransportFactory(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
        }

        @Override
        public HttpTransport create() {
            return new ApacheHttpTransport(this.httpClientBuilder.build());
        }
    }
}

