/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import java.io.Serializable;
import java.time.Duration;

final class DurationTimer
implements Serializable {
    private static final long serialVersionUID = 3952075543181450716L;
    private long start = Long.MIN_VALUE;
    private long accumulatedNanos = 0L;
    private long samples = 0L;

    DurationTimer() {
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public void finish() {
        long now = System.nanoTime();
        if (this.start != Long.MIN_VALUE) {
            this.accumulatedNanos += now - this.start;
            ++this.samples;
        }
        this.start = now;
    }

    public Duration getAccumulatedTime() {
        return Duration.ofNanos(this.accumulatedNanos);
    }

    public long getSamples() {
        return this.samples;
    }
}

