/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableInfo;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;

public class BigQueryRelation
extends BaseRelation {
    private final SparkBigQueryConfig options;
    private final TableInfo table;
    private final SQLContext sqlContext;
    private final TableId tableId;
    private final String tableName;

    public BigQueryRelation(SparkBigQueryConfig options, TableInfo table, SQLContext sqlContext) {
        this.options = options;
        this.table = table;
        this.sqlContext = sqlContext;
        this.tableId = table.getTableId();
        this.tableName = BigQueryUtil.friendlyTableName(this.tableId);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        SchemaConverters sc = SchemaConverters.from(SchemaConvertersConfiguration.from(this.options));
        return this.options.getSchema().orElse(sc.toSpark(sc.getSchemaWithPseudoColumns(this.table)));
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected String getTableNameForLogging() {
        return this.options.getQuery().map(query -> this.tableName + " created from \"" + BigQueryUtil.prepareQueryForLog(query, 50) + "\"").orElse(BigQueryUtil.friendlyTableName(this.options.getTableId()));
    }
}

