/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.metrics;

import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkBigQueryConnectorMetricsUtils {
    private static final Logger logger = LoggerFactory.getLogger(SparkBigQueryConnectorMetricsUtils.class);

    public static void postInputFormatEvent(SparkContext sparkContext) {
        try {
            Class<?> eventClass = Class.forName("com.google.cloud.spark.events.InputFormatEvent");
            sparkContext.listenerBus().post((SparkListenerEvent)eventClass.getConstructor(String.class, Long.TYPE).newInstance("bigquery", -1L));
        }
        catch (ReflectiveOperationException ignored) {
            logger.debug("spark.events.InputFormatEvent library not in class path");
        }
    }

    public static void postConnectorVersion(SparkContext sparkContext, String connectorVersion) {
        try {
            Class<?> eventBuilderClass = Class.forName("com.google.cloud.spark.events.BigQueryConnectorVersionEvent$BigQueryConnectorVersionEventBuilder");
            Method buildMethod = eventBuilderClass.getDeclaredMethod("build", new Class[0]);
            sparkContext.listenerBus().post((SparkListenerEvent)buildMethod.invoke(eventBuilderClass.getDeclaredConstructor(String.class).newInstance(connectorVersion), new Object[0]));
        }
        catch (ReflectiveOperationException ignored) {
            logger.debug("spark.events.BigQueryConnectorVersionEvent library not in class path");
        }
    }

    public static void postWriteSessionMetrics(long timestamp, SparkBigQueryConfig.WriteMethod writeMethod, long bytesWritten, Optional<SparkBigQueryConfig.IntermediateFormat> intermediateDataFormat, SparkContext sparkContext) {
        try {
            String name;
            Method nameMethod;
            Class<?> eventBuilderClass = Class.forName("com.google.cloud.spark.events.SparkBigQueryConnectorWriteEvent$SparkBigQueryConnectorWriteEventBuilder");
            Object builderInstance = eventBuilderClass.getDeclaredConstructor(Long.TYPE).newInstance(timestamp);
            eventBuilderClass.getMethod("setBytesWritten", Long.TYPE).invoke(builderInstance, bytesWritten);
            if (intermediateDataFormat.isPresent()) {
                Class<?> dataFormatEnum = Class.forName("com.google.cloud.spark.events.DataFormat");
                ?[] dataFormatEnumConstants = dataFormatEnum.getEnumConstants();
                Object generatedDataFormatEnumValue = dataFormatEnumConstants[0];
                for (Object constant : dataFormatEnumConstants) {
                    nameMethod = constant.getClass().getMethod("name", new Class[0]);
                    name = (String)nameMethod.invoke(constant, new Object[0]);
                    if (!name.equalsIgnoreCase(intermediateDataFormat.get().getDataSource())) continue;
                    generatedDataFormatEnumValue = constant;
                    break;
                }
                eventBuilderClass.getMethod("setIntermediateDataFormat", dataFormatEnum).invoke(builderInstance, generatedDataFormatEnumValue);
            }
            Class<?> dataWriteMethodEnum = Class.forName("com.google.cloud.spark.events.DataWriteMethod");
            ?[] dataWriteMethodConstants = dataWriteMethodEnum.getEnumConstants();
            Object generatedDataWriteMethodEnumValue = dataWriteMethodConstants[0];
            for (Object constant : dataWriteMethodConstants) {
                nameMethod = constant.getClass().getMethod("name", new Class[0]);
                name = (String)nameMethod.invoke(constant, new Object[0]);
                if (!name.equalsIgnoreCase(writeMethod.toString())) continue;
                generatedDataWriteMethodEnumValue = constant;
                break;
            }
            eventBuilderClass.getMethod("setWriteMethod", dataWriteMethodEnum).invoke(builderInstance, generatedDataWriteMethodEnumValue);
            Method buildMethod = eventBuilderClass.getDeclaredMethod("build", new Class[0]);
            sparkContext.listenerBus().post((SparkListenerEvent)buildMethod.invoke(builderInstance, new Object[0]));
        }
        catch (ReflectiveOperationException ex) {
            logger.debug("spark.events.SparkBigQueryConnectorWriteEvent library not in class path");
        }
    }

    public static String getAccumulatorNameForMetric(String metricName, String sessionName) {
        return String.format("%s-%s", sessionName, metricName);
    }
}

