/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.netty.channel.kqueue;

import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.Channel;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.ChannelMetadata;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.ChannelOutboundBuffer;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.kqueue.AbstractKQueueChannel;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.kqueue.BsdSocket;
import java.io.IOException;

abstract class AbstractKQueueDatagramChannel
extends AbstractKQueueChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);

    AbstractKQueueDatagramChannel(Channel parent, BsdSocket fd, boolean active) {
        super(parent, fd, active);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected abstract boolean doWriteMessage(Object var1) throws Exception;

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        int maxMessagesPerWrite = this.maxMessagesPerWrite();
        while (maxMessagesPerWrite > 0 && (msg = in.current()) != null) {
            try {
                boolean done = false;
                for (int i = this.config().getWriteSpinCount(); i > 0; --i) {
                    if (!this.doWriteMessage(msg)) continue;
                    done = true;
                    break;
                }
                if (!done) break;
                in.remove();
                --maxMessagesPerWrite;
            }
            catch (IOException e) {
                --maxMessagesPerWrite;
                in.remove(e);
            }
        }
        this.writeFilter(!in.isEmpty());
    }
}

