/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.lifecycle.plan;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.OpenLineage;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.OpenLineageClientUtils;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.DatasetIdentifier;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.core.type.TypeReference;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.InputDatasetWithDelegate;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.InputDatasetWithFacets;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.InputDatasetWithIdentifier;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.InputLineageNode;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.LineageRelation;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.LineageRelationProvider;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.OutputDatasetWithDelegate;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.OutputDatasetWithFacets;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.OutputDatasetWithIdentifier;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.extension.v1.OutputLineageNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public final class SparkOpenLineageExtensionVisitor {
    private static final ObjectMapper mapper = OpenLineageClientUtils.newObjectMapper();
    private final OpenLineage openLineage = new OpenLineage(Versions.OPEN_LINEAGE_PRODUCER_URI);

    public boolean isDefinedAt(Object lineageNode) {
        return lineageNode instanceof LineageRelationProvider || lineageNode instanceof LineageRelation || lineageNode instanceof InputLineageNode || lineageNode instanceof OutputLineageNode;
    }

    public Map<String, Object> apply(Object lineageNode, String sparkListenerEventName, Object sqlContext, Object parameters) {
        if (lineageNode instanceof LineageRelationProvider) {
            LineageRelationProvider provider = (LineageRelationProvider)lineageNode;
            DatasetIdentifier datasetIdentifier = provider.getLineageDatasetIdentifier(sparkListenerEventName, this.openLineage, sqlContext, parameters);
            return mapper.convertValue((Object)datasetIdentifier, new TypeReference<Map<String, Object>>(){});
        }
        return Collections.emptyMap();
    }

    public Map<String, Object> apply(Object lineageNode, String sparkListenerEventName) {
        if (lineageNode instanceof LineageRelation) {
            LineageRelation lineageRelation = (LineageRelation)lineageNode;
            DatasetIdentifier datasetIdentifier = lineageRelation.getLineageDatasetIdentifier(sparkListenerEventName, this.openLineage);
            return mapper.convertValue((Object)datasetIdentifier, new TypeReference<Map<String, Object>>(){});
        }
        if (lineageNode instanceof InputLineageNode) {
            InputLineageNode inputLineageNode = (InputLineageNode)lineageNode;
            return this.handleInputLineageNode(sparkListenerEventName, inputLineageNode);
        }
        if (lineageNode instanceof OutputLineageNode) {
            OutputLineageNode outputLineageNode = (OutputLineageNode)lineageNode;
            return this.handleOutputLineageNode(sparkListenerEventName, outputLineageNode);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> handleInputLineageNode(String sparkListenerEventName, InputLineageNode inputLineageNode) {
        List<InputDatasetWithFacets> inputs = inputLineageNode.getInputs(sparkListenerEventName, this.openLineage);
        List inputDatasets = inputs.stream().filter(d -> d instanceof InputDatasetWithIdentifier).map(d -> (InputDatasetWithIdentifier)d).map(d -> this.openLineage.newInputDatasetBuilder().namespace(d.getDatasetIdentifier().getNamespace()).name(d.getDatasetIdentifier().getName()).facets(d.getDatasetFacetsBuilder().build()).inputFacets(d.getInputFacetsBuilder().build()).build()).collect(Collectors.toList());
        List<Object> delegateNodes = inputs.stream().filter(d -> d instanceof InputDatasetWithDelegate).map(d -> (InputDatasetWithDelegate)d).map(InputDatasetWithDelegate::getNode).collect(Collectors.toList());
        List<Map<String, Object>> serializedDatasets = mapper.convertValue(inputDatasets, new TypeReference<List<Map<String, Object>>>(){});
        return SparkOpenLineageExtensionVisitor.buildMapWithDatasetsAndDelegates(serializedDatasets, delegateNodes);
    }

    private Map<String, Object> handleOutputLineageNode(String sparkListenerEventName, OutputLineageNode outputLineageNode) {
        List<OutputDatasetWithFacets> outputs = outputLineageNode.getOutputs(sparkListenerEventName, this.openLineage);
        List outputDatasets = outputs.stream().filter(d -> d instanceof OutputDatasetWithIdentifier).map(d -> (OutputDatasetWithIdentifier)d).map(d -> this.openLineage.newOutputDatasetBuilder().namespace(d.getDatasetIdentifier().getNamespace()).name(d.getDatasetIdentifier().getName()).facets(d.getDatasetFacetsBuilder().build()).outputFacets(d.getOutputFacetsBuilder().build()).build()).collect(Collectors.toList());
        List<Object> delegateNodes = outputs.stream().filter(d -> d instanceof OutputDatasetWithDelegate).map(d -> (OutputDatasetWithDelegate)d).map(OutputDatasetWithDelegate::getNode).collect(Collectors.toList());
        List<Map<String, Object>> serializedDatasets = mapper.convertValue(outputDatasets, new TypeReference<List<Map<String, Object>>>(){});
        return SparkOpenLineageExtensionVisitor.buildMapWithDatasetsAndDelegates(serializedDatasets, delegateNodes);
    }

    private static Map<String, Object> buildMapWithDatasetsAndDelegates(List<Map<String, Object>> serializedDatasets, List<Object> delegateNodes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasets", serializedDatasets);
        map.put("delegateNodes", delegateNodes);
        return map;
    }

    private static class Versions {
        public static final URI OPEN_LINEAGE_PRODUCER_URI = Versions.getProducerUri();

        private Versions() {
        }

        private static URI getProducerUri() {
            return URI.create(String.format("https://github.com/OpenLineage/OpenLineage/tree/%s/integration/spark-extension-interfaces", Versions.getVersion()));
        }

        public static String getVersion() {
            try {
                Properties properties = new Properties();
                InputStream is = Versions.class.getResourceAsStream("version.properties");
                properties.load(is);
                return properties.getProperty("version");
            }
            catch (IOException exception) {
                return "main";
            }
        }
    }
}

