/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.compression;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.compression.Lz4CompressionCodec;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.compression.ZstdCompressionCodec;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compression.CompressionCodec;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compression.CompressionUtil;

public class CommonsCompressionFactory
implements CompressionCodec.Factory {
    public static final CommonsCompressionFactory INSTANCE = new CommonsCompressionFactory();

    @Override
    public CompressionCodec createCodec(CompressionUtil.CodecType codecType) {
        switch (codecType) {
            case LZ4_FRAME: {
                return new Lz4CompressionCodec();
            }
            case ZSTD: {
                return new ZstdCompressionCodec();
            }
        }
        throw new IllegalArgumentException("Compression type not supported: " + (Object)((Object)codecType));
    }

    @Override
    public CompressionCodec createCodec(CompressionUtil.CodecType codecType, int compressionLevel) {
        switch (codecType) {
            case LZ4_FRAME: {
                return new Lz4CompressionCodec();
            }
            case ZSTD: {
                return new ZstdCompressionCodec(compressionLevel);
            }
        }
        throw new IllegalArgumentException("Compression type not supported: " + (Object)((Object)codecType));
    }
}

