/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.chrono;

import com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.chrono.AbstractNileChronology;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.chrono.CopticDate;
import com.google.cloud.spark.bigquery.repackaged.org.threeten.extra.chrono.CopticEra;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CopticChronology
extends AbstractNileChronology
implements Serializable {
    public static final CopticChronology INSTANCE = new CopticChronology();
    private static final long serialVersionUID = 7291205177830286973L;

    @Deprecated
    public CopticChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Coptic";
    }

    @Override
    public String getCalendarType() {
        return "coptic";
    }

    @Override
    public CopticDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public CopticDate date(int prolepticYear, int month, int dayOfMonth) {
        return CopticDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public CopticDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public CopticDate dateYearDay(int prolepticYear, int dayOfYear) {
        return CopticDate.ofYearDay(prolepticYear, dayOfYear);
    }

    @Override
    public CopticDate dateEpochDay(long epochDay) {
        return CopticDate.ofEpochDay(epochDay);
    }

    @Override
    public CopticDate dateNow() {
        return CopticDate.now();
    }

    @Override
    public CopticDate dateNow(ZoneId zone) {
        return CopticDate.now(zone);
    }

    @Override
    public CopticDate dateNow(Clock clock) {
        return CopticDate.now(clock);
    }

    @Override
    public CopticDate date(TemporalAccessor temporal) {
        return CopticDate.from(temporal);
    }

    public ChronoLocalDateTime<CopticDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<CopticDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<CopticDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof CopticEra)) {
            throw new ClassCastException("Era must be CopticEra");
        }
        return era == CopticEra.AM ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public CopticEra eraOf(int eraValue) {
        return CopticEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(CopticEra.values());
    }

    @Override
    public CopticDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (CopticDate)super.resolveDate(fieldValues, resolverStyle);
    }
}

