/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Objects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface BigQueryConfig {
    public Optional<String> getAccessTokenProviderFQCN();

    public Optional<String> getAccessTokenProviderConfig();

    public Optional<String> getCredentialsKey();

    public Optional<String> getCredentialsFile();

    public Optional<String> getAccessToken();

    public String getLoggedInUserName();

    public Set<String> getLoggedInUserGroups();

    public Optional<Map<String, String>> getImpersonationServiceAccountsForUsers();

    public Optional<Map<String, String>> getImpersonationServiceAccountsForGroups();

    public Optional<String> getImpersonationServiceAccount();

    public String getParentProjectId();

    public boolean useParentProjectForMetadataOperations();

    public boolean isViewsEnabled();

    public Optional<String> getMaterializationProject();

    public Optional<String> getMaterializationDataset();

    public int getBigQueryClientConnectTimeout();

    public int getBigQueryClientReadTimeout();

    public RetrySettings getBigQueryClientRetrySettings();

    public BigQueryProxyConfig getBigQueryProxyConfig();

    public Optional<String> getBigQueryStorageGrpcEndpoint();

    public Optional<String> getBigQueryHttpEndpoint();

    public int getCacheExpirationTimeInMinutes();

    public ImmutableMap<String, String> getBigQueryJobLabels();

    public Optional<Long> getCreateReadSessionTimeoutInSeconds();

    public int getChannelPoolSize();

    public Optional<Integer> getFlowControlWindowBytes();

    public QueryJobConfiguration.Priority getQueryJobPriority();

    public long getBigQueryJobTimeoutInMinutes();

    default public int getClientCreationHashCode() {
        return Objects.hashCode(this.getAccessTokenProviderFQCN(), this.getAccessTokenProviderConfig(), this.getCredentialsKey(), this.getAccessToken(), this.getCredentialsFile(), this.getBigQueryHttpEndpoint(), this.getFlowControlWindowBytes(), this.getBigQueryStorageGrpcEndpoint(), this.getCreateReadSessionTimeoutInSeconds(), this.getBigQueryProxyConfig(), this.getParentProjectId(), this.useParentProjectForMetadataOperations());
    }

    default public boolean areClientCreationConfigsEqual(BigQueryConfig b) {
        if (this == b) {
            return true;
        }
        return Objects.equal(this.getAccessTokenProviderFQCN(), b.getAccessTokenProviderFQCN()) && Objects.equal(this.getAccessTokenProviderConfig(), b.getAccessTokenProviderConfig()) && Objects.equal(this.getCredentialsKey(), b.getCredentialsKey()) && Objects.equal(this.getAccessToken(), b.getAccessToken()) && Objects.equal(this.getCredentialsFile(), b.getCredentialsFile()) && Objects.equal(this.getBigQueryHttpEndpoint(), b.getBigQueryHttpEndpoint()) && Objects.equal(this.getFlowControlWindowBytes(), b.getFlowControlWindowBytes()) && Objects.equal(this.getBigQueryStorageGrpcEndpoint(), b.getBigQueryStorageGrpcEndpoint()) && Objects.equal(this.getCreateReadSessionTimeoutInSeconds(), b.getCreateReadSessionTimeoutInSeconds()) && Objects.equal(this.getBigQueryProxyConfig(), b.getBigQueryProxyConfig()) && Objects.equal(this.getParentProjectId(), b.getParentProjectId()) && Objects.equal(this.useParentProjectForMetadataOperations(), b.useParentProjectForMetadataOperations());
    }
}

