/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.UserAgentProvider;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.spark.bigquery.repackaged.com.google.gson.JsonObject;
import java.util.Optional;
import org.apache.spark.package$;
import scala.util.Properties;

public class SparkBigQueryConnectorUserAgentProvider
implements UserAgentProvider {
    @VisibleForTesting
    static String GCP_REGION_PART = SparkBigQueryConnectorUserAgentProvider.getGcpRegion().map(region -> " region/" + region).orElse("");
    @VisibleForTesting
    static String DATAPROC_IMAGE_PART = Optional.ofNullable(System.getenv("DATAPROC_IMAGE_VERSION")).map(image -> " dataproc-image/" + image).orElse("");
    private static String SPARK_VERSION = package$.MODULE$.SPARK_VERSION();
    private static String JAVA_VERSION = System.getProperty("java.runtime.version");
    private static String SCALA_VERSION = Properties.versionNumberString();
    static final String USER_AGENT = String.format("spark/%s java/%s scala/%s%s%s", SPARK_VERSION, JAVA_VERSION, SCALA_VERSION, GCP_REGION_PART, DATAPROC_IMAGE_PART);
    private String dataSourceVersion;
    private Optional<String> gpn;

    public SparkBigQueryConnectorUserAgentProvider(String dataSourceVersion, Optional<String> gpn) {
        this.dataSourceVersion = dataSourceVersion;
        this.gpn = gpn;
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    static Optional<String> getGcpRegion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getUserAgent() {
        StringBuilder userAgentBuilder = new StringBuilder();
        userAgentBuilder.append("spark-bigquery-connector/").append(SparkBigQueryUtil.CONNECTOR_VERSION);
        this.gpn.ifPresent(s2 -> userAgentBuilder.append(" (GPN:").append((String)s2).append(") "));
        userAgentBuilder.append(USER_AGENT).append(" datasource/").append(this.dataSourceVersion);
        return userAgentBuilder.toString();
    }

    @Override
    public String getConnectorInfo() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("connectorVersion", SparkBigQueryUtil.CONNECTOR_VERSION);
        jsonObject.addProperty("datasource", this.dataSourceVersion);
        jsonObject.addProperty("dataprocImage", DATAPROC_IMAGE_PART);
        jsonObject.addProperty("gcpRegion", GCP_REGION_PART);
        jsonObject.addProperty("sparkVersion", SPARK_VERSION);
        jsonObject.addProperty("javaVersion", JAVA_VERSION);
        jsonObject.addProperty("scalaVersion", SCALA_VERSION);
        this.gpn.ifPresent(s2 -> jsonObject.addProperty("GPN", (String)s2));
        return jsonObject.toString();
    }
}

